// Generated by gmmproc 2.68.0 -- DO NOT MODIFY!


#include <glibmm.h>

#include <pangomm/glyphstring.h>
#include <pangomm/private/glyphstring_p.h>


/*
 * Copyright 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/utility.h>
#include <pango/pangocairo.h>

namespace Pango
{

GlyphString::GlyphString(const Glib::ustring& text, const Analysis& analysis)
:
  gobject_(pango_glyph_string_new())
{
  pango_shape(text.c_str(), text.bytes(), analysis.gobj(), gobj());
}

GlyphString::GlyphString(const Glib::ustring& item_text, const Glib::ustring& paragraph_text,
  const Analysis& analysis, ShapeFlags flags)
:
  gobject_(pango_glyph_string_new())
{
  pango_shape_with_flags(item_text.c_str(), item_text.bytes(), paragraph_text.c_str(),
   paragraph_text.bytes(), analysis.gobj(), gobj(), static_cast<PangoShapeFlags>(flags));
}

Rectangle GlyphString::get_ink_extents(const Glib::RefPtr<const Font>& font) const
{
  Rectangle ink_rect;
  pango_glyph_string_extents(const_cast<PangoGlyphString*>(gobj()), const_cast<PangoFont*>(font->gobj()), ink_rect.gobj(), 0);
  return ink_rect;
}

Rectangle GlyphString::get_ink_extents(int start, int end, const Glib::RefPtr<const Font>& font) const
{
  Rectangle ink_rect;
  pango_glyph_string_extents_range(const_cast<PangoGlyphString*>(gobj()), start, end, const_cast<PangoFont*>(font->gobj()), ink_rect.gobj(), 0);
  return ink_rect;
}

Rectangle GlyphString::get_logical_extents(const Glib::RefPtr<const Font>& font) const
{
  Rectangle logical_rect;
  pango_glyph_string_extents(const_cast<PangoGlyphString*>(gobj()), const_cast<PangoFont*>(font->gobj()), 0, logical_rect.gobj());
  return logical_rect;
}

Rectangle GlyphString::get_logical_extents(int start, int end, const Glib::RefPtr<const Font>& font) const
{
  Rectangle logical_rect;
  pango_glyph_string_extents_range(const_cast<PangoGlyphString*>(gobj()), start, end, const_cast<PangoFont*>(font->gobj()), 0, logical_rect.gobj());
  return logical_rect;
}

std::vector<int> GlyphString::get_logical_widths(const Glib::ustring& text, int embedding_level) const
{
  int* logical_widths = g_new(int, text.length());
  pango_glyph_string_get_logical_widths(const_cast<PangoGlyphString*>(gobj()), text.c_str(), text.bytes(), embedding_level, logical_widths);
  return Glib::ArrayHandler<int>::array_to_vector(logical_widths, text.length(), Glib::OWNERSHIP_SHALLOW);
}

int GlyphString::index_to_x(const Glib::ustring& text, const Analysis& analysis, int index, bool trailing) const
{
  int x_pos;
  pango_glyph_string_index_to_x(const_cast<PangoGlyphString*>(gobj()), const_cast<gchar*>(text.c_str()), text.bytes(), const_cast<PangoAnalysis*>(analysis.gobj()), index, static_cast<int>(trailing), &x_pos);
  return x_pos;
}

void GlyphString::x_to_index(const Glib::ustring& text, const Analysis& analysis, int x_pos, int& index, bool& trailing) const
{
  gboolean trailing_temp = FALSE;
  pango_glyph_string_x_to_index(const_cast<PangoGlyphString*>(gobj()), const_cast<char*>(text.c_str()), text.bytes(), const_cast<PangoAnalysis*>(analysis.gobj()), x_pos, &index, &trailing_temp);
  trailing = trailing_temp;
}

std::vector<GlyphInfo> GlyphString::get_glyphs() const
{
  return Glib::ArrayHandler<GlyphInfo>::array_to_vector(reinterpret_cast<GlyphInfo*>(gobj()->glyphs), gobj()->num_glyphs, Glib::OWNERSHIP_NONE);
}

} //namespace Pango

namespace
{
} // anonymous namespace


namespace Glib
{

Pango::GlyphString wrap(PangoGlyphString* object, bool take_copy)
{
  return Pango::GlyphString(object, take_copy);
}

} // namespace Glib


namespace Pango
{


// static
GType GlyphString::get_type()
{
  return pango_glyph_string_get_type();
}

GlyphString::GlyphString()
:
  gobject_ (pango_glyph_string_new())
{}

GlyphString::GlyphString(const GlyphString& other)
:
  gobject_ ((other.gobject_) ? pango_glyph_string_copy(other.gobject_) : nullptr)
{}

GlyphString::GlyphString(GlyphString&& other) noexcept
:
  gobject_(other.gobject_)
{
  other.gobject_ = nullptr;
}

GlyphString& GlyphString::operator=(GlyphString&& other) noexcept
{
  GlyphString temp (std::move(other));
  swap(temp);
  return *this;
}

GlyphString::GlyphString(PangoGlyphString* gobject, bool make_a_copy)
:
  // For BoxedType wrappers, make_a_copy is true by default.  The static
  // BoxedType wrappers must always take a copy, thus make_a_copy = true
  // ensures identical behaviour if the default argument is used.
  gobject_ ((make_a_copy && gobject) ? pango_glyph_string_copy(gobject) : gobject)
{}

GlyphString& GlyphString::operator=(const GlyphString& other)
{
  GlyphString temp (other);
  swap(temp);
  return *this;
}

GlyphString::~GlyphString() noexcept
{
  if(gobject_)
    pango_glyph_string_free(gobject_);
}

void GlyphString::swap(GlyphString& other) noexcept
{
  std::swap(gobject_, other.gobject_);
}

PangoGlyphString* GlyphString::gobj_copy() const
{
  return pango_glyph_string_copy(gobject_);
}


void GlyphString::set_size(int new_len)
{
  pango_glyph_string_set_size(gobj(), new_len);
}

void GlyphString::get_extents(const Glib::RefPtr<const Font>& font, Rectangle& ink_rect, Rectangle& logical_rect) const
{
  pango_glyph_string_extents(const_cast<PangoGlyphString*>(gobj()), const_cast<PangoFont*>(Glib::unwrap<Font>(font)), (ink_rect).gobj(), (logical_rect).gobj());
}

void GlyphString::get_extents(int start, int end, const Glib::RefPtr<const Font>& font, Rectangle& ink_rect, Rectangle& logical_rect) const
{
  pango_glyph_string_extents_range(const_cast<PangoGlyphString*>(gobj()), start, end, const_cast<PangoFont*>(Glib::unwrap<Font>(font)), (ink_rect).gobj(), (logical_rect).gobj());
}

int GlyphString::get_width() const
{
  return pango_glyph_string_get_width(const_cast<PangoGlyphString*>(gobj()));
}


} // namespace Pango


