/* valainitializerlist.c generated by valac, the Vala compiler
 * generated from valainitializerlist.vala, do not modify */

/* valainitializerlist.vala
 *
 * Copyright (C) 2006-2011  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include "vala.h"
#include <valagee.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))

struct _ValaInitializerListPrivate {
	ValaList* initializers;
};

static gint ValaInitializerList_private_offset;
static gpointer vala_initializer_list_parent_class = NULL;

static void vala_initializer_list_real_accept_children (ValaCodeNode* base,
                                                 ValaCodeVisitor* visitor);
static void vala_initializer_list_real_accept (ValaCodeNode* base,
                                        ValaCodeVisitor* visitor);
static gboolean vala_initializer_list_real_is_constant (ValaExpression* base);
static gboolean vala_initializer_list_real_is_pure (ValaExpression* base);
static gboolean vala_initializer_list_real_is_accessible (ValaExpression* base,
                                                   ValaSymbol* sym);
static gchar* vala_initializer_list_real_to_string (ValaCodeNode* base);
static void vala_initializer_list_real_replace_expression (ValaCodeNode* base,
                                                    ValaExpression* old_node,
                                                    ValaExpression* new_node);
static gboolean vala_initializer_list_real_check (ValaCodeNode* base,
                                           ValaCodeContext* context);
static void vala_initializer_list_real_emit (ValaCodeNode* base,
                                      ValaCodeGenerator* codegen);
static void vala_initializer_list_real_get_used_variables (ValaCodeNode* base,
                                                    ValaCollection* collection);
static void vala_initializer_list_finalize (ValaCodeNode * obj);
static GType vala_initializer_list_get_type_once (void);

static inline gpointer
vala_initializer_list_get_instance_private (ValaInitializerList* self)
{
	return G_STRUCT_MEMBER_P (self, ValaInitializerList_private_offset);
}

/**
 * Appends the specified expression to this initializer
 *
 * @param expr an expression
 */
void
vala_initializer_list_append (ValaInitializerList* self,
                              ValaExpression* expr)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (expr != NULL);
	_tmp0_ = self->priv->initializers;
	vala_collection_add ((ValaCollection*) _tmp0_, expr);
	vala_code_node_set_parent_node ((ValaCodeNode*) expr, (ValaCodeNode*) self);
}

/**
 * Returns the initalizer expression list
 *
 * @return expression list
 */
ValaList*
vala_initializer_list_get_initializers (ValaInitializerList* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->initializers;
	result = _tmp0_;
	return result;
}

gint
vala_initializer_list_get_size (ValaInitializerList* self)
{
	gint result;
	ValaList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->initializers;
	_tmp1_ = vala_collection_get_size ((ValaCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

/**
 * Creates a new initializer
 *
 * @param source_reference reference to source code
 * @return                 newly created initializer list
 */
ValaInitializerList*
vala_initializer_list_construct (GType object_type,
                                 ValaSourceReference* source_reference)
{
	ValaInitializerList* self = NULL;
	g_return_val_if_fail (source_reference != NULL, NULL);
	self = (ValaInitializerList*) vala_expression_construct (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaInitializerList*
vala_initializer_list_new (ValaSourceReference* source_reference)
{
	return vala_initializer_list_construct (VALA_TYPE_INITIALIZER_LIST, source_reference);
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static void
vala_initializer_list_real_accept_children (ValaCodeNode* base,
                                            ValaCodeVisitor* visitor)
{
	ValaInitializerList * self;
	self = (ValaInitializerList*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _expr_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _expr_index = 0;
		_tmp0_ = self->priv->initializers;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_expr_list = _tmp1_;
		_tmp2_ = _expr_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_expr_size = _tmp4_;
		_expr_index = -1;
		while (TRUE) {
			ValaExpression* expr = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaExpression* _tmp7_;
			_expr_index = _expr_index + 1;
			if (!(_expr_index < _expr_size)) {
				break;
			}
			_tmp5_ = _expr_list;
			_tmp6_ = vala_list_get (_tmp5_, _expr_index);
			expr = (ValaExpression*) _tmp6_;
			_tmp7_ = expr;
			vala_code_node_accept ((ValaCodeNode*) _tmp7_, visitor);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
}

static void
vala_initializer_list_real_accept (ValaCodeNode* base,
                                   ValaCodeVisitor* visitor)
{
	ValaInitializerList * self;
	self = (ValaInitializerList*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_initializer_list (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static gboolean
vala_initializer_list_real_is_constant (ValaExpression* base)
{
	ValaInitializerList * self;
	gboolean result = FALSE;
	self = (ValaInitializerList*) base;
	{
		ValaList* _initializer_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _initializer_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _initializer_index = 0;
		_tmp0_ = self->priv->initializers;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_initializer_list = _tmp1_;
		_tmp2_ = _initializer_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_initializer_size = _tmp4_;
		_initializer_index = -1;
		while (TRUE) {
			ValaExpression* initializer = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaExpression* _tmp7_;
			_initializer_index = _initializer_index + 1;
			if (!(_initializer_index < _initializer_size)) {
				break;
			}
			_tmp5_ = _initializer_list;
			_tmp6_ = vala_list_get (_tmp5_, _initializer_index);
			initializer = (ValaExpression*) _tmp6_;
			_tmp7_ = initializer;
			if (!vala_expression_is_constant (_tmp7_)) {
				result = FALSE;
				_vala_code_node_unref0 (initializer);
				_vala_iterable_unref0 (_initializer_list);
				return result;
			}
			_vala_code_node_unref0 (initializer);
		}
		_vala_iterable_unref0 (_initializer_list);
	}
	result = TRUE;
	return result;
}

static gboolean
vala_initializer_list_real_is_pure (ValaExpression* base)
{
	ValaInitializerList * self;
	gboolean result = FALSE;
	self = (ValaInitializerList*) base;
	{
		ValaList* _initializer_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _initializer_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _initializer_index = 0;
		_tmp0_ = self->priv->initializers;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_initializer_list = _tmp1_;
		_tmp2_ = _initializer_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_initializer_size = _tmp4_;
		_initializer_index = -1;
		while (TRUE) {
			ValaExpression* initializer = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaExpression* _tmp7_;
			_initializer_index = _initializer_index + 1;
			if (!(_initializer_index < _initializer_size)) {
				break;
			}
			_tmp5_ = _initializer_list;
			_tmp6_ = vala_list_get (_tmp5_, _initializer_index);
			initializer = (ValaExpression*) _tmp6_;
			_tmp7_ = initializer;
			if (!vala_expression_is_pure (_tmp7_)) {
				result = FALSE;
				_vala_code_node_unref0 (initializer);
				_vala_iterable_unref0 (_initializer_list);
				return result;
			}
			_vala_code_node_unref0 (initializer);
		}
		_vala_iterable_unref0 (_initializer_list);
	}
	result = TRUE;
	return result;
}

static gboolean
vala_initializer_list_real_is_accessible (ValaExpression* base,
                                          ValaSymbol* sym)
{
	ValaInitializerList * self;
	gboolean result = FALSE;
	self = (ValaInitializerList*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	{
		ValaList* _initializer_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _initializer_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _initializer_index = 0;
		_tmp0_ = self->priv->initializers;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_initializer_list = _tmp1_;
		_tmp2_ = _initializer_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_initializer_size = _tmp4_;
		_initializer_index = -1;
		while (TRUE) {
			ValaExpression* initializer = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaExpression* _tmp7_;
			_initializer_index = _initializer_index + 1;
			if (!(_initializer_index < _initializer_size)) {
				break;
			}
			_tmp5_ = _initializer_list;
			_tmp6_ = vala_list_get (_tmp5_, _initializer_index);
			initializer = (ValaExpression*) _tmp6_;
			_tmp7_ = initializer;
			if (!vala_expression_is_accessible (_tmp7_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (initializer);
				_vala_iterable_unref0 (_initializer_list);
				return result;
			}
			_vala_code_node_unref0 (initializer);
		}
		_vala_iterable_unref0 (_initializer_list);
	}
	result = TRUE;
	return result;
}

static gchar*
vala_initializer_list_real_to_string (ValaCodeNode* base)
{
	ValaInitializerList * self;
	GString* builder = NULL;
	GString* _tmp0_;
	gboolean first = FALSE;
	GString* _tmp16_;
	GString* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* result = NULL;
	self = (ValaInitializerList*) base;
	_tmp0_ = g_string_new ("{");
	builder = _tmp0_;
	first = TRUE;
	{
		ValaList* _initializer_list = NULL;
		ValaList* _tmp1_;
		ValaList* _tmp2_;
		gint _initializer_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _initializer_index = 0;
		_tmp1_ = self->priv->initializers;
		_tmp2_ = _vala_iterable_ref0 (_tmp1_);
		_initializer_list = _tmp2_;
		_tmp3_ = _initializer_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_initializer_size = _tmp5_;
		_initializer_index = -1;
		while (TRUE) {
			ValaExpression* initializer = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			_initializer_index = _initializer_index + 1;
			if (!(_initializer_index < _initializer_size)) {
				break;
			}
			_tmp6_ = _initializer_list;
			_tmp7_ = vala_list_get (_tmp6_, _initializer_index);
			initializer = (ValaExpression*) _tmp7_;
			if (first) {
				GString* _tmp8_;
				ValaExpression* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				_tmp8_ = builder;
				_tmp9_ = initializer;
				_tmp10_ = vala_code_node_to_string ((ValaCodeNode*) _tmp9_);
				_tmp11_ = _tmp10_;
				g_string_append (_tmp8_, _tmp11_);
				_g_free0 (_tmp11_);
				first = FALSE;
			} else {
				GString* _tmp12_;
				ValaExpression* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				_tmp12_ = builder;
				_tmp13_ = initializer;
				_tmp14_ = vala_code_node_to_string ((ValaCodeNode*) _tmp13_);
				_tmp15_ = _tmp14_;
				g_string_append_printf (_tmp12_, ", %s", _tmp15_);
				_g_free0 (_tmp15_);
			}
			_vala_code_node_unref0 (initializer);
		}
		_vala_iterable_unref0 (_initializer_list);
	}
	_tmp16_ = builder;
	g_string_append_c (_tmp16_, '}');
	_tmp17_ = builder;
	_tmp18_ = _tmp17_->str;
	_tmp19_ = g_strdup (_tmp18_);
	result = _tmp19_;
	_g_string_free0 (builder);
	return result;
}

static void
vala_initializer_list_real_replace_expression (ValaCodeNode* base,
                                               ValaExpression* old_node,
                                               ValaExpression* new_node)
{
	ValaInitializerList * self;
	self = (ValaInitializerList*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaExpression* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->initializers;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->initializers;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaExpression*) _tmp6_;
				_tmp8_ = _tmp7_ == old_node;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->initializers;
					vala_list_set (_tmp9_, i, new_node);
					vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
				}
			}
		}
	}
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gboolean
vala_initializer_list_real_check (ValaCodeNode* base,
                                  ValaCodeContext* context)
{
	ValaInitializerList * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	gboolean _tmp223_;
	gboolean _tmp224_;
	gboolean _tmp270_;
	gboolean _tmp271_;
	ValaDataType* _tmp278_;
	ValaDataType* _tmp279_;
	gboolean _tmp282_;
	gboolean _tmp283_;
	gboolean result = FALSE;
	self = (ValaInitializerList*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_expression_get_target_type ((ValaExpression*) self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == NULL) {
		ValaSourceReference* _tmp6_;
		ValaSourceReference* _tmp7_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp6_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp7_ = _tmp6_;
		vala_report_error (_tmp7_, "initializer list used for unknown type");
		result = FALSE;
		return result;
	} else {
		ValaDataType* _tmp8_;
		ValaDataType* _tmp9_;
		gboolean _tmp10_;
		gboolean _tmp11_;
		_tmp8_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_code_node_get_error ((ValaCodeNode*) _tmp9_);
		_tmp11_ = _tmp10_;
		if (_tmp11_) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			return result;
		} else {
			ValaDataType* _tmp12_;
			ValaDataType* _tmp13_;
			_tmp12_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp13_ = _tmp12_;
			if (VALA_IS_ARRAY_TYPE (_tmp13_)) {
				ValaArrayType* array_type = NULL;
				ValaDataType* _tmp14_;
				ValaDataType* _tmp15_;
				gboolean requires_constants_only = FALSE;
				ValaCodeNode* node = NULL;
				ValaCodeNode* _tmp16_;
				ValaCodeNode* _tmp17_;
				gboolean _tmp23_ = FALSE;
				gboolean _tmp24_ = FALSE;
				ValaCodeNode* _tmp25_;
				ValaCodeNode* _tmp26_;
				ValaDataType* inner_target_type = NULL;
				ValaArrayType* _tmp66_;
				gint _tmp67_;
				gint _tmp68_;
				_tmp14_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp15_ = _tmp14_;
				array_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, VALA_TYPE_ARRAY_TYPE, ValaArrayType);
				requires_constants_only = FALSE;
				_tmp16_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp17_ = _tmp16_;
				node = _tmp17_;
				while (TRUE) {
					ValaCodeNode* _tmp18_;
					ValaCodeNode* _tmp19_;
					ValaCodeNode* _tmp20_;
					ValaCodeNode* _tmp21_;
					ValaCodeNode* _tmp22_;
					_tmp18_ = node;
					if (!(_tmp18_ != NULL)) {
						break;
					}
					_tmp19_ = node;
					if (VALA_IS_CONSTANT (_tmp19_)) {
						requires_constants_only = TRUE;
						break;
					}
					_tmp20_ = node;
					_tmp21_ = vala_code_node_get_parent_node (_tmp20_);
					_tmp22_ = _tmp21_;
					node = _tmp22_;
				}
				_tmp25_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp26_ = _tmp25_;
				if (!VALA_IS_ARRAY_CREATION_EXPRESSION (_tmp26_)) {
					_tmp24_ = !requires_constants_only;
				} else {
					_tmp24_ = FALSE;
				}
				if (_tmp24_) {
					gboolean _tmp27_ = FALSE;
					ValaCodeNode* _tmp28_;
					ValaCodeNode* _tmp29_;
					_tmp28_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp29_ = _tmp28_;
					if (!VALA_IS_INITIALIZER_LIST (_tmp29_)) {
						_tmp27_ = TRUE;
					} else {
						ValaCodeNode* _tmp30_;
						ValaCodeNode* _tmp31_;
						ValaDataType* _tmp32_;
						ValaDataType* _tmp33_;
						ValaTypeSymbol* _tmp34_;
						ValaTypeSymbol* _tmp35_;
						_tmp30_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp31_ = _tmp30_;
						_tmp32_ = vala_expression_get_target_type ((ValaExpression*) G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, VALA_TYPE_INITIALIZER_LIST, ValaInitializerList));
						_tmp33_ = _tmp32_;
						_tmp34_ = vala_data_type_get_type_symbol (_tmp33_);
						_tmp35_ = _tmp34_;
						_tmp27_ = VALA_IS_STRUCT (_tmp35_);
					}
					_tmp23_ = _tmp27_;
				} else {
					_tmp23_ = FALSE;
				}
				if (_tmp23_) {
					ValaCodeNode* old_parent_node = NULL;
					ValaCodeNode* _tmp36_;
					ValaCodeNode* _tmp37_;
					ValaCodeNode* _tmp38_;
					ValaArrayCreationExpression* array_creation = NULL;
					ValaArrayType* _tmp39_;
					ValaDataType* _tmp40_;
					ValaDataType* _tmp41_;
					ValaDataType* _tmp42_;
					ValaDataType* _tmp43_;
					ValaArrayType* _tmp44_;
					gint _tmp45_;
					gint _tmp46_;
					ValaSourceReference* _tmp47_;
					ValaSourceReference* _tmp48_;
					ValaArrayCreationExpression* _tmp49_;
					ValaArrayCreationExpression* _tmp50_;
					ValaArrayCreationExpression* _tmp51_;
					ValaArrayType* _tmp52_;
					ValaDataType* _tmp53_;
					ValaDataType* _tmp54_;
					ValaDataType* _tmp55_;
					ValaDataType* _tmp56_;
					ValaArrayCreationExpression* _tmp57_;
					ValaDataType* _tmp58_;
					ValaDataType* _tmp59_;
					ValaArrayCreationExpression* _tmp60_;
					ValaDataType* _tmp61_;
					ValaDataType* _tmp62_;
					ValaCodeNode* _tmp63_;
					ValaArrayCreationExpression* _tmp64_;
					ValaArrayCreationExpression* _tmp65_;
					_tmp36_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp37_ = _tmp36_;
					_tmp38_ = _vala_code_node_ref0 (_tmp37_);
					old_parent_node = _tmp38_;
					_tmp39_ = array_type;
					_tmp40_ = vala_array_type_get_element_type (_tmp39_);
					_tmp41_ = _tmp40_;
					_tmp42_ = vala_data_type_copy (_tmp41_);
					_tmp43_ = _tmp42_;
					_tmp44_ = array_type;
					_tmp45_ = vala_array_type_get_rank (_tmp44_);
					_tmp46_ = _tmp45_;
					_tmp47_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp48_ = _tmp47_;
					_tmp49_ = vala_array_creation_expression_new (_tmp43_, _tmp46_, self, _tmp48_);
					_tmp50_ = _tmp49_;
					_vala_code_node_unref0 (_tmp43_);
					array_creation = _tmp50_;
					_tmp51_ = array_creation;
					_tmp52_ = array_type;
					_tmp53_ = vala_array_type_get_length_type (_tmp52_);
					_tmp54_ = _tmp53_;
					_tmp55_ = vala_data_type_copy (_tmp54_);
					_tmp56_ = _tmp55_;
					vala_array_creation_expression_set_length_type (_tmp51_, _tmp56_);
					_vala_code_node_unref0 (_tmp56_);
					_tmp57_ = array_creation;
					_tmp58_ = vala_expression_get_target_type ((ValaExpression*) self);
					_tmp59_ = _tmp58_;
					vala_expression_set_target_type ((ValaExpression*) _tmp57_, _tmp59_);
					_tmp60_ = array_creation;
					_tmp61_ = vala_expression_get_formal_target_type ((ValaExpression*) self);
					_tmp62_ = _tmp61_;
					vala_expression_set_formal_target_type ((ValaExpression*) _tmp60_, _tmp62_);
					_tmp63_ = old_parent_node;
					_tmp64_ = array_creation;
					vala_code_node_replace_expression (_tmp63_, (ValaExpression*) self, (ValaExpression*) _tmp64_);
					vala_code_node_set_checked ((ValaCodeNode*) self, FALSE);
					_tmp65_ = array_creation;
					result = vala_code_node_check ((ValaCodeNode*) _tmp65_, context);
					_vala_code_node_unref0 (array_creation);
					_vala_code_node_unref0 (old_parent_node);
					return result;
				}
				_tmp66_ = array_type;
				_tmp67_ = vala_array_type_get_rank (_tmp66_);
				_tmp68_ = _tmp67_;
				if (_tmp68_ > 1) {
					ValaArrayType* inner_array_type = NULL;
					ValaArrayType* _tmp69_;
					ValaDataType* _tmp70_;
					ValaArrayType* _tmp71_;
					gint _tmp72_;
					gint _tmp73_;
					ValaArrayType* _tmp74_;
					ValaDataType* _tmp75_;
					_tmp69_ = array_type;
					_tmp70_ = vala_data_type_copy ((ValaDataType*) _tmp69_);
					inner_array_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp70_, VALA_TYPE_ARRAY_TYPE, ValaArrayType);
					_tmp71_ = inner_array_type;
					_tmp72_ = vala_array_type_get_rank (_tmp71_);
					_tmp73_ = _tmp72_;
					vala_array_type_set_rank (_tmp71_, _tmp73_ - 1);
					_tmp74_ = inner_array_type;
					_tmp75_ = _vala_code_node_ref0 ((ValaDataType*) _tmp74_);
					_vala_code_node_unref0 (inner_target_type);
					inner_target_type = _tmp75_;
					_vala_code_node_unref0 (inner_array_type);
				} else {
					ValaArrayType* _tmp76_;
					ValaDataType* _tmp77_;
					ValaDataType* _tmp78_;
					ValaDataType* _tmp79_;
					_tmp76_ = array_type;
					_tmp77_ = vala_array_type_get_element_type (_tmp76_);
					_tmp78_ = _tmp77_;
					_tmp79_ = vala_data_type_copy (_tmp78_);
					_vala_code_node_unref0 (inner_target_type);
					inner_target_type = _tmp79_;
				}
				{
					ValaList* _e_list = NULL;
					ValaList* _tmp80_;
					ValaList* _tmp81_;
					gint _e_size = 0;
					ValaList* _tmp82_;
					gint _tmp83_;
					gint _tmp84_;
					gint _e_index = 0;
					_tmp80_ = vala_initializer_list_get_initializers (self);
					_tmp81_ = _vala_iterable_ref0 (_tmp80_);
					_e_list = _tmp81_;
					_tmp82_ = _e_list;
					_tmp83_ = vala_collection_get_size ((ValaCollection*) _tmp82_);
					_tmp84_ = _tmp83_;
					_e_size = _tmp84_;
					_e_index = -1;
					while (TRUE) {
						ValaExpression* e = NULL;
						ValaList* _tmp85_;
						gpointer _tmp86_;
						ValaExpression* _tmp87_;
						ValaDataType* _tmp88_;
						_e_index = _e_index + 1;
						if (!(_e_index < _e_size)) {
							break;
						}
						_tmp85_ = _e_list;
						_tmp86_ = vala_list_get (_tmp85_, _e_index);
						e = (ValaExpression*) _tmp86_;
						_tmp87_ = e;
						_tmp88_ = inner_target_type;
						vala_expression_set_target_type (_tmp87_, _tmp88_);
						_vala_code_node_unref0 (e);
					}
					_vala_iterable_unref0 (_e_list);
				}
				_vala_code_node_unref0 (inner_target_type);
			} else {
				ValaDataType* _tmp89_;
				ValaDataType* _tmp90_;
				ValaTypeSymbol* _tmp91_;
				ValaTypeSymbol* _tmp92_;
				_tmp89_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp90_ = _tmp89_;
				_tmp91_ = vala_data_type_get_type_symbol (_tmp90_);
				_tmp92_ = _tmp91_;
				if (VALA_IS_STRUCT (_tmp92_)) {
					ValaStruct* st = NULL;
					ValaDataType* _tmp93_;
					ValaDataType* _tmp94_;
					ValaTypeSymbol* _tmp95_;
					ValaTypeSymbol* _tmp96_;
					gboolean _tmp103_ = FALSE;
					ValaCodeNode* _tmp104_;
					ValaCodeNode* _tmp105_;
					gboolean in_array_creation_initializer = FALSE;
					ValaObjectCreationExpression* struct_creation = NULL;
					ValaIterator* field_it = NULL;
					ValaStruct* _tmp154_;
					ValaList* _tmp155_;
					ValaIterator* _tmp156_;
					_tmp93_ = vala_expression_get_target_type ((ValaExpression*) self);
					_tmp94_ = _tmp93_;
					_tmp95_ = vala_data_type_get_type_symbol (_tmp94_);
					_tmp96_ = _tmp95_;
					st = G_TYPE_CHECK_INSTANCE_CAST (_tmp96_, VALA_TYPE_STRUCT, ValaStruct);
					while (TRUE) {
						ValaStruct* _tmp97_;
						ValaStruct* _tmp98_;
						ValaStruct* _tmp99_;
						ValaStruct* _tmp100_;
						ValaStruct* _tmp101_;
						ValaStruct* _tmp102_;
						_tmp97_ = st;
						_tmp98_ = vala_struct_get_base_struct (_tmp97_);
						_tmp99_ = _tmp98_;
						if (!(_tmp99_ != NULL)) {
							break;
						}
						_tmp100_ = st;
						_tmp101_ = vala_struct_get_base_struct (_tmp100_);
						_tmp102_ = _tmp101_;
						st = _tmp102_;
					}
					_tmp104_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp105_ = _tmp104_;
					if (VALA_IS_INITIALIZER_LIST (_tmp105_)) {
						ValaCodeNode* _tmp106_;
						ValaCodeNode* _tmp107_;
						ValaCodeNode* _tmp108_;
						ValaCodeNode* _tmp109_;
						_tmp106_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp107_ = _tmp106_;
						_tmp108_ = vala_code_node_get_parent_node (_tmp107_);
						_tmp109_ = _tmp108_;
						_tmp103_ = VALA_IS_ARRAY_CREATION_EXPRESSION (_tmp109_);
					} else {
						_tmp103_ = FALSE;
					}
					in_array_creation_initializer = _tmp103_;
					struct_creation = NULL;
					if (in_array_creation_initializer) {
						ValaSymbol* sym = NULL;
						ValaStruct* _tmp110_;
						ValaMemberAccess* ma = NULL;
						ValaSymbol* _tmp111_;
						const gchar* _tmp112_;
						const gchar* _tmp113_;
						ValaSourceReference* _tmp114_;
						ValaSourceReference* _tmp115_;
						ValaMemberAccess* _tmp116_;
						ValaMemberAccess* _tmp117_;
						ValaMemberAccess* _tmp118_;
						ValaSymbol* _tmp119_;
						ValaMemberAccess* inner = NULL;
						ValaMemberAccess* _tmp120_;
						ValaMemberAccess* _tmp121_;
						ValaMemberAccess* _tmp144_;
						ValaSourceReference* _tmp145_;
						ValaSourceReference* _tmp146_;
						ValaObjectCreationExpression* _tmp147_;
						ValaObjectCreationExpression* _tmp148_;
						ValaDataType* _tmp149_;
						ValaDataType* _tmp150_;
						ValaDataType* _tmp151_;
						ValaDataType* _tmp152_;
						ValaObjectCreationExpression* _tmp153_;
						_tmp110_ = st;
						sym = (ValaSymbol*) _tmp110_;
						_tmp111_ = sym;
						_tmp112_ = vala_symbol_get_name (_tmp111_);
						_tmp113_ = _tmp112_;
						_tmp114_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp115_ = _tmp114_;
						_tmp116_ = vala_member_access_new_simple (_tmp113_, _tmp115_);
						ma = _tmp116_;
						_tmp117_ = ma;
						vala_member_access_set_creation_member (_tmp117_, TRUE);
						_tmp118_ = ma;
						_tmp119_ = sym;
						vala_expression_set_symbol_reference ((ValaExpression*) _tmp118_, _tmp119_);
						_tmp120_ = ma;
						_tmp121_ = _vala_code_node_ref0 (_tmp120_);
						inner = _tmp121_;
						while (TRUE) {
							gboolean _tmp122_ = FALSE;
							ValaSymbol* _tmp123_;
							ValaSymbol* _tmp124_;
							ValaSymbol* _tmp125_;
							ValaSymbol* _tmp131_;
							ValaSymbol* _tmp132_;
							ValaSymbol* _tmp133_;
							ValaMemberAccess* ma_inner = NULL;
							ValaSymbol* _tmp134_;
							const gchar* _tmp135_;
							const gchar* _tmp136_;
							ValaSourceReference* _tmp137_;
							ValaSourceReference* _tmp138_;
							ValaMemberAccess* _tmp139_;
							ValaMemberAccess* _tmp140_;
							ValaMemberAccess* _tmp141_;
							ValaMemberAccess* _tmp142_;
							ValaMemberAccess* _tmp143_;
							_tmp123_ = sym;
							_tmp124_ = vala_symbol_get_parent_symbol (_tmp123_);
							_tmp125_ = _tmp124_;
							if (_tmp125_ != NULL) {
								ValaSymbol* _tmp126_;
								ValaSymbol* _tmp127_;
								ValaSymbol* _tmp128_;
								ValaNamespace* _tmp129_;
								ValaNamespace* _tmp130_;
								_tmp126_ = sym;
								_tmp127_ = vala_symbol_get_parent_symbol (_tmp126_);
								_tmp128_ = _tmp127_;
								_tmp129_ = vala_code_context_get_root (context);
								_tmp130_ = _tmp129_;
								_tmp122_ = _tmp128_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp130_, VALA_TYPE_SYMBOL, ValaSymbol);
							} else {
								_tmp122_ = FALSE;
							}
							if (!_tmp122_) {
								break;
							}
							_tmp131_ = sym;
							_tmp132_ = vala_symbol_get_parent_symbol (_tmp131_);
							_tmp133_ = _tmp132_;
							sym = _tmp133_;
							_tmp134_ = sym;
							_tmp135_ = vala_symbol_get_name (_tmp134_);
							_tmp136_ = _tmp135_;
							_tmp137_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp138_ = _tmp137_;
							_tmp139_ = vala_member_access_new_simple (_tmp136_, _tmp138_);
							ma_inner = _tmp139_;
							_tmp140_ = inner;
							_tmp141_ = ma_inner;
							vala_member_access_set_inner (_tmp140_, (ValaExpression*) _tmp141_);
							_tmp142_ = ma_inner;
							_tmp143_ = _vala_code_node_ref0 (_tmp142_);
							_vala_code_node_unref0 (inner);
							inner = _tmp143_;
							_vala_code_node_unref0 (ma_inner);
						}
						_tmp144_ = ma;
						_tmp145_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp146_ = _tmp145_;
						_tmp147_ = vala_object_creation_expression_new (_tmp144_, _tmp146_);
						_vala_code_node_unref0 (struct_creation);
						struct_creation = _tmp147_;
						_tmp148_ = struct_creation;
						_tmp149_ = vala_expression_get_target_type ((ValaExpression*) self);
						_tmp150_ = _tmp149_;
						_tmp151_ = vala_data_type_copy (_tmp150_);
						_tmp152_ = _tmp151_;
						vala_expression_set_target_type ((ValaExpression*) _tmp148_, _tmp152_);
						_vala_code_node_unref0 (_tmp152_);
						_tmp153_ = struct_creation;
						vala_object_creation_expression_set_struct_creation (_tmp153_, TRUE);
						_vala_code_node_unref0 (inner);
						_vala_code_node_unref0 (ma);
					}
					_tmp154_ = st;
					_tmp155_ = vala_struct_get_fields (_tmp154_);
					_tmp156_ = vala_iterable_iterator ((ValaIterable*) _tmp155_);
					field_it = _tmp156_;
					{
						ValaList* _e_list = NULL;
						ValaList* _tmp157_;
						ValaList* _tmp158_;
						gint _e_size = 0;
						ValaList* _tmp159_;
						gint _tmp160_;
						gint _tmp161_;
						gint _e_index = 0;
						_tmp157_ = vala_initializer_list_get_initializers (self);
						_tmp158_ = _vala_iterable_ref0 (_tmp157_);
						_e_list = _tmp158_;
						_tmp159_ = _e_list;
						_tmp160_ = vala_collection_get_size ((ValaCollection*) _tmp159_);
						_tmp161_ = _tmp160_;
						_e_size = _tmp161_;
						_e_index = -1;
						while (TRUE) {
							ValaExpression* e = NULL;
							ValaList* _tmp162_;
							gpointer _tmp163_;
							ValaField* field = NULL;
							_e_index = _e_index + 1;
							if (!(_e_index < _e_size)) {
								break;
							}
							_tmp162_ = _e_list;
							_tmp163_ = vala_list_get (_tmp162_, _e_index);
							e = (ValaExpression*) _tmp163_;
							field = NULL;
							while (TRUE) {
								ValaField* _tmp164_;
								ValaIterator* _tmp165_;
								ValaIterator* _tmp175_;
								gpointer _tmp176_;
								ValaField* _tmp177_;
								ValaMemberBinding _tmp178_;
								ValaMemberBinding _tmp179_;
								_tmp164_ = field;
								if (!(_tmp164_ == NULL)) {
									break;
								}
								_tmp165_ = field_it;
								if (!vala_iterator_next (_tmp165_)) {
									ValaExpression* _tmp166_;
									ValaSourceReference* _tmp167_;
									ValaSourceReference* _tmp168_;
									ValaDataType* _tmp169_;
									ValaDataType* _tmp170_;
									gchar* _tmp171_;
									gchar* _tmp172_;
									gchar* _tmp173_;
									gchar* _tmp174_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp166_ = e;
									_tmp167_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp166_);
									_tmp168_ = _tmp167_;
									_tmp169_ = vala_expression_get_target_type ((ValaExpression*) self);
									_tmp170_ = _tmp169_;
									_tmp171_ = vala_code_node_to_string ((ValaCodeNode*) _tmp170_);
									_tmp172_ = _tmp171_;
									_tmp173_ = g_strdup_printf ("too many expressions in initializer list for `%s'", _tmp172_);
									_tmp174_ = _tmp173_;
									vala_report_error (_tmp168_, _tmp174_);
									_g_free0 (_tmp174_);
									_g_free0 (_tmp172_);
									result = FALSE;
									_vala_code_node_unref0 (field);
									_vala_code_node_unref0 (e);
									_vala_iterable_unref0 (_e_list);
									_vala_iterator_unref0 (field_it);
									_vala_code_node_unref0 (struct_creation);
									return result;
								}
								_tmp175_ = field_it;
								_tmp176_ = vala_iterator_get (_tmp175_);
								_vala_code_node_unref0 (field);
								field = (ValaField*) _tmp176_;
								_tmp177_ = field;
								_tmp178_ = vala_field_get_binding (_tmp177_);
								_tmp179_ = _tmp178_;
								if (_tmp179_ != VALA_MEMBER_BINDING_INSTANCE) {
									_vala_code_node_unref0 (field);
									field = NULL;
								}
							}
							if (in_array_creation_initializer) {
								ValaMemberInitializer* member_init = NULL;
								ValaField* _tmp180_;
								const gchar* _tmp181_;
								const gchar* _tmp182_;
								ValaExpression* _tmp183_;
								ValaExpression* _tmp184_;
								ValaSourceReference* _tmp185_;
								ValaSourceReference* _tmp186_;
								ValaMemberInitializer* _tmp187_;
								ValaObjectCreationExpression* _tmp188_;
								ValaMemberInitializer* _tmp189_;
								_tmp180_ = field;
								_tmp181_ = vala_symbol_get_name ((ValaSymbol*) _tmp180_);
								_tmp182_ = _tmp181_;
								_tmp183_ = e;
								_tmp184_ = e;
								_tmp185_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp184_);
								_tmp186_ = _tmp185_;
								_tmp187_ = vala_member_initializer_new (_tmp182_, _tmp183_, _tmp186_);
								member_init = _tmp187_;
								_tmp188_ = struct_creation;
								_tmp189_ = member_init;
								vala_object_creation_expression_add_member_initializer (_tmp188_, _tmp189_);
								_vala_code_node_unref0 (member_init);
							} else {
								ValaExpression* _tmp190_;
								ValaField* _tmp191_;
								ValaDataType* _tmp192_;
								ValaDataType* _tmp193_;
								ValaDataType* _tmp194_;
								ValaDataType* _tmp195_;
								ValaDataType* _tmp196_;
								ValaDataType* _tmp197_;
								gboolean _tmp198_;
								gboolean _tmp199_;
								_tmp190_ = e;
								_tmp191_ = field;
								_tmp192_ = vala_variable_get_variable_type ((ValaVariable*) _tmp191_);
								_tmp193_ = _tmp192_;
								_tmp194_ = vala_data_type_copy (_tmp193_);
								_tmp195_ = _tmp194_;
								vala_expression_set_target_type (_tmp190_, _tmp195_);
								_vala_code_node_unref0 (_tmp195_);
								_tmp196_ = vala_expression_get_target_type ((ValaExpression*) self);
								_tmp197_ = _tmp196_;
								_tmp198_ = vala_data_type_get_value_owned (_tmp197_);
								_tmp199_ = _tmp198_;
								if (!_tmp199_) {
									ValaExpression* _tmp200_;
									ValaDataType* _tmp201_;
									ValaDataType* _tmp202_;
									_tmp200_ = e;
									_tmp201_ = vala_expression_get_target_type (_tmp200_);
									_tmp202_ = _tmp201_;
									vala_data_type_set_value_owned (_tmp202_, FALSE);
								}
							}
							_vala_code_node_unref0 (field);
							_vala_code_node_unref0 (e);
						}
						_vala_iterable_unref0 (_e_list);
					}
					if (in_array_creation_initializer) {
						ValaCodeNode* _tmp203_;
						ValaCodeNode* _tmp204_;
						ValaObjectCreationExpression* _tmp205_;
						ValaObjectCreationExpression* _tmp206_;
						_tmp203_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp204_ = _tmp203_;
						_tmp205_ = struct_creation;
						vala_code_node_replace_expression (_tmp204_, (ValaExpression*) self, (ValaExpression*) _tmp205_);
						vala_code_node_set_checked ((ValaCodeNode*) self, FALSE);
						_tmp206_ = struct_creation;
						result = vala_code_node_check ((ValaCodeNode*) _tmp206_, context);
						_vala_iterator_unref0 (field_it);
						_vala_code_node_unref0 (struct_creation);
						return result;
					}
					_vala_iterator_unref0 (field_it);
					_vala_code_node_unref0 (struct_creation);
				} else {
					ValaSourceReference* _tmp207_;
					ValaSourceReference* _tmp208_;
					ValaDataType* _tmp209_;
					ValaDataType* _tmp210_;
					gchar* _tmp211_;
					gchar* _tmp212_;
					gchar* _tmp213_;
					gchar* _tmp214_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp207_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp208_ = _tmp207_;
					_tmp209_ = vala_expression_get_target_type ((ValaExpression*) self);
					_tmp210_ = _tmp209_;
					_tmp211_ = vala_code_node_to_string ((ValaCodeNode*) _tmp210_);
					_tmp212_ = _tmp211_;
					_tmp213_ = g_strdup_printf ("initializer list used for `%s', which is neither array nor struct", _tmp212_);
					_tmp214_ = _tmp213_;
					vala_report_error (_tmp208_, _tmp214_);
					_g_free0 (_tmp214_);
					_g_free0 (_tmp212_);
					result = FALSE;
					return result;
				}
			}
		}
	}
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp215_;
		ValaList* _tmp216_;
		gint _expr_size = 0;
		ValaList* _tmp217_;
		gint _tmp218_;
		gint _tmp219_;
		gint _expr_index = 0;
		_tmp215_ = self->priv->initializers;
		_tmp216_ = _vala_iterable_ref0 (_tmp215_);
		_expr_list = _tmp216_;
		_tmp217_ = _expr_list;
		_tmp218_ = vala_collection_get_size ((ValaCollection*) _tmp217_);
		_tmp219_ = _tmp218_;
		_expr_size = _tmp219_;
		_expr_index = -1;
		while (TRUE) {
			ValaExpression* expr = NULL;
			ValaList* _tmp220_;
			gpointer _tmp221_;
			ValaExpression* _tmp222_;
			_expr_index = _expr_index + 1;
			if (!(_expr_index < _expr_size)) {
				break;
			}
			_tmp220_ = _expr_list;
			_tmp221_ = vala_list_get (_tmp220_, _expr_index);
			expr = (ValaExpression*) _tmp221_;
			_tmp222_ = expr;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp222_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
	_tmp223_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp224_ = _tmp223_;
	if (_tmp224_) {
		result = FALSE;
		return result;
	}
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp225_;
		ValaList* _tmp226_;
		gint _e_size = 0;
		ValaList* _tmp227_;
		gint _tmp228_;
		gint _tmp229_;
		gint _e_index = 0;
		_tmp225_ = vala_initializer_list_get_initializers (self);
		_tmp226_ = _vala_iterable_ref0 (_tmp225_);
		_e_list = _tmp226_;
		_tmp227_ = _e_list;
		_tmp228_ = vala_collection_get_size ((ValaCollection*) _tmp227_);
		_tmp229_ = _tmp228_;
		_e_size = _tmp229_;
		_e_index = -1;
		while (TRUE) {
			ValaExpression* e = NULL;
			ValaList* _tmp230_;
			gpointer _tmp231_;
			ValaExpression* _tmp232_;
			ValaDataType* _tmp233_;
			ValaDataType* _tmp234_;
			ValaUnaryExpression* unary = NULL;
			ValaExpression* _tmp238_;
			gboolean _tmp239_ = FALSE;
			ValaUnaryExpression* _tmp240_;
			_e_index = _e_index + 1;
			if (!(_e_index < _e_size)) {
				break;
			}
			_tmp230_ = _e_list;
			_tmp231_ = vala_list_get (_tmp230_, _e_index);
			e = (ValaExpression*) _tmp231_;
			_tmp232_ = e;
			_tmp233_ = vala_expression_get_value_type (_tmp232_);
			_tmp234_ = _tmp233_;
			if (_tmp234_ == NULL) {
				ValaExpression* _tmp235_;
				ValaSourceReference* _tmp236_;
				ValaSourceReference* _tmp237_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp235_ = e;
				_tmp236_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp235_);
				_tmp237_ = _tmp236_;
				vala_report_error (_tmp237_, "expression type not allowed as initializer");
				_vala_code_node_unref0 (e);
				continue;
			}
			_tmp238_ = e;
			unary = VALA_IS_UNARY_EXPRESSION (_tmp238_) ? ((ValaUnaryExpression*) _tmp238_) : NULL;
			_tmp240_ = unary;
			if (_tmp240_ != NULL) {
				gboolean _tmp241_ = FALSE;
				ValaUnaryExpression* _tmp242_;
				ValaUnaryOperator _tmp243_;
				ValaUnaryOperator _tmp244_;
				_tmp242_ = unary;
				_tmp243_ = vala_unary_expression_get_operator (_tmp242_);
				_tmp244_ = _tmp243_;
				if (_tmp244_ == VALA_UNARY_OPERATOR_REF) {
					_tmp241_ = TRUE;
				} else {
					ValaUnaryExpression* _tmp245_;
					ValaUnaryOperator _tmp246_;
					ValaUnaryOperator _tmp247_;
					_tmp245_ = unary;
					_tmp246_ = vala_unary_expression_get_operator (_tmp245_);
					_tmp247_ = _tmp246_;
					_tmp241_ = _tmp247_ == VALA_UNARY_OPERATOR_OUT;
				}
				_tmp239_ = _tmp241_;
			} else {
				_tmp239_ = FALSE;
			}
			if (_tmp239_) {
			} else {
				ValaExpression* _tmp248_;
				ValaDataType* _tmp249_;
				ValaDataType* _tmp250_;
				ValaExpression* _tmp251_;
				ValaDataType* _tmp252_;
				ValaDataType* _tmp253_;
				_tmp248_ = e;
				_tmp249_ = vala_expression_get_value_type (_tmp248_);
				_tmp250_ = _tmp249_;
				_tmp251_ = e;
				_tmp252_ = vala_expression_get_target_type (_tmp251_);
				_tmp253_ = _tmp252_;
				if (!vala_data_type_compatible (_tmp250_, _tmp253_)) {
					ValaExpression* _tmp254_;
					ValaExpression* _tmp255_;
					ValaSourceReference* _tmp256_;
					ValaSourceReference* _tmp257_;
					ValaExpression* _tmp258_;
					ValaDataType* _tmp259_;
					ValaDataType* _tmp260_;
					gchar* _tmp261_;
					gchar* _tmp262_;
					ValaExpression* _tmp263_;
					ValaDataType* _tmp264_;
					ValaDataType* _tmp265_;
					gchar* _tmp266_;
					gchar* _tmp267_;
					gchar* _tmp268_;
					gchar* _tmp269_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp254_ = e;
					vala_code_node_set_error ((ValaCodeNode*) _tmp254_, TRUE);
					_tmp255_ = e;
					_tmp256_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp255_);
					_tmp257_ = _tmp256_;
					_tmp258_ = e;
					_tmp259_ = vala_expression_get_target_type (_tmp258_);
					_tmp260_ = _tmp259_;
					_tmp261_ = vala_code_node_to_string ((ValaCodeNode*) _tmp260_);
					_tmp262_ = _tmp261_;
					_tmp263_ = e;
					_tmp264_ = vala_expression_get_value_type (_tmp263_);
					_tmp265_ = _tmp264_;
					_tmp266_ = vala_code_node_to_string ((ValaCodeNode*) _tmp265_);
					_tmp267_ = _tmp266_;
					_tmp268_ = g_strdup_printf ("Expected initializer of type `%s' but got `%s'", _tmp262_, _tmp267_);
					_tmp269_ = _tmp268_;
					vala_report_error (_tmp257_, _tmp269_);
					_g_free0 (_tmp269_);
					_g_free0 (_tmp267_);
					_g_free0 (_tmp262_);
				}
			}
			_vala_code_node_unref0 (e);
		}
		_vala_iterable_unref0 (_e_list);
	}
	_tmp270_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp271_ = _tmp270_;
	if (!_tmp271_) {
		ValaDataType* _tmp272_;
		ValaDataType* _tmp273_;
		ValaDataType* _tmp274_;
		ValaDataType* _tmp275_;
		ValaDataType* _tmp276_;
		ValaDataType* _tmp277_;
		_tmp272_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp273_ = _tmp272_;
		_tmp274_ = vala_data_type_copy (_tmp273_);
		_tmp275_ = _tmp274_;
		vala_expression_set_value_type ((ValaExpression*) self, _tmp275_);
		_vala_code_node_unref0 (_tmp275_);
		_tmp276_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp277_ = _tmp276_;
		vala_data_type_set_nullable (_tmp277_, FALSE);
	}
	_tmp278_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp279_ = _tmp278_;
	if (_tmp279_ != NULL) {
		ValaDataType* _tmp280_;
		ValaDataType* _tmp281_;
		_tmp280_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp281_ = _tmp280_;
		vala_code_node_check ((ValaCodeNode*) _tmp281_, context);
	}
	_tmp282_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp283_ = _tmp282_;
	result = !_tmp283_;
	return result;
}

static void
vala_initializer_list_real_emit (ValaCodeNode* base,
                                 ValaCodeGenerator* codegen)
{
	ValaInitializerList * self;
	self = (ValaInitializerList*) base;
	g_return_if_fail (codegen != NULL);
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _expr_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _expr_index = 0;
		_tmp0_ = self->priv->initializers;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_expr_list = _tmp1_;
		_tmp2_ = _expr_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_expr_size = _tmp4_;
		_expr_index = -1;
		while (TRUE) {
			ValaExpression* expr = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaExpression* _tmp7_;
			_expr_index = _expr_index + 1;
			if (!(_expr_index < _expr_size)) {
				break;
			}
			_tmp5_ = _expr_list;
			_tmp6_ = vala_list_get (_tmp5_, _expr_index);
			expr = (ValaExpression*) _tmp6_;
			_tmp7_ = expr;
			vala_code_node_emit ((ValaCodeNode*) _tmp7_, codegen);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
	vala_code_visitor_visit_initializer_list ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_initializer_list_real_get_used_variables (ValaCodeNode* base,
                                               ValaCollection* collection)
{
	ValaInitializerList * self;
	self = (ValaInitializerList*) base;
	g_return_if_fail (collection != NULL);
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _expr_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _expr_index = 0;
		_tmp0_ = self->priv->initializers;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_expr_list = _tmp1_;
		_tmp2_ = _expr_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_expr_size = _tmp4_;
		_expr_index = -1;
		while (TRUE) {
			ValaExpression* expr = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaExpression* _tmp7_;
			_expr_index = _expr_index + 1;
			if (!(_expr_index < _expr_size)) {
				break;
			}
			_tmp5_ = _expr_list;
			_tmp6_ = vala_list_get (_tmp5_, _expr_index);
			expr = (ValaExpression*) _tmp6_;
			_tmp7_ = expr;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp7_, collection);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
}

static void
vala_initializer_list_class_init (ValaInitializerListClass * klass,
                                  gpointer klass_data)
{
	vala_initializer_list_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_initializer_list_finalize;
	g_type_class_adjust_private_offset (klass, &ValaInitializerList_private_offset);
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_initializer_list_real_accept_children;
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_initializer_list_real_accept;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_initializer_list_real_is_constant;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_initializer_list_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_initializer_list_real_is_accessible;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_initializer_list_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_initializer_list_real_replace_expression;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_initializer_list_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_initializer_list_real_emit;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_initializer_list_real_get_used_variables;
}

static void
vala_initializer_list_instance_init (ValaInitializerList * self,
                                     gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_initializer_list_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->initializers = (ValaList*) _tmp1_;
}

static void
vala_initializer_list_finalize (ValaCodeNode * obj)
{
	ValaInitializerList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_INITIALIZER_LIST, ValaInitializerList);
	_vala_iterable_unref0 (self->priv->initializers);
	VALA_CODE_NODE_CLASS (vala_initializer_list_parent_class)->finalize (obj);
}

/**
 * Represents an array or struct initializer list in the source code.
 */
static GType
vala_initializer_list_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaInitializerListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_initializer_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaInitializerList), 0, (GInstanceInitFunc) vala_initializer_list_instance_init, NULL };
	GType vala_initializer_list_type_id;
	vala_initializer_list_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaInitializerList", &g_define_type_info, 0);
	ValaInitializerList_private_offset = g_type_add_instance_private (vala_initializer_list_type_id, sizeof (ValaInitializerListPrivate));
	return vala_initializer_list_type_id;
}

GType
vala_initializer_list_get_type (void)
{
	static volatile gsize vala_initializer_list_type_id__volatile = 0;
	if (g_once_init_enter (&vala_initializer_list_type_id__volatile)) {
		GType vala_initializer_list_type_id;
		vala_initializer_list_type_id = vala_initializer_list_get_type_once ();
		g_once_init_leave (&vala_initializer_list_type_id__volatile, vala_initializer_list_type_id);
	}
	return vala_initializer_list_type_id__volatile;
}

