/* valacreationmethod.c generated by valac, the Vala compiler
 * generated from valacreationmethod.vala, do not modify */

/* valacreationmethod.vala
 *
 * Copyright (C) 2007-2010  Jürg Billeter
 * Copyright (C) 2007-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))

struct _ValaCreationMethodPrivate {
	gchar* _class_name;
	gboolean _chain_up;
};

static gint ValaCreationMethod_private_offset;
static gpointer vala_creation_method_parent_class = NULL;

static void vala_creation_method_real_accept (ValaCodeNode* base,
                                       ValaCodeVisitor* visitor);
static void vala_creation_method_real_accept_children (ValaCodeNode* base,
                                                ValaCodeVisitor* visitor);
static gboolean vala_creation_method_real_check (ValaCodeNode* base,
                                          ValaCodeContext* context);
static void vala_creation_method_finalize (ValaCodeNode * obj);
static GType vala_creation_method_get_type_once (void);

static inline gpointer
vala_creation_method_get_instance_private (ValaCreationMethod* self)
{
	return G_STRUCT_MEMBER_P (self, ValaCreationMethod_private_offset);
}

const gchar*
vala_creation_method_get_class_name (ValaCreationMethod* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_class_name;
	result = _tmp0_;
	return result;
}

void
vala_creation_method_set_class_name (ValaCreationMethod* self,
                                     const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_class_name);
	self->priv->_class_name = _tmp0_;
}

gboolean
vala_creation_method_get_chain_up (ValaCreationMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_chain_up;
	return result;
}

void
vala_creation_method_set_chain_up (ValaCreationMethod* self,
                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_chain_up = value;
}

/**
 * Creates a new method.
 *
 * @param name             method name
 * @param source_reference reference to source code
 * @return                 newly created method
 */
ValaCreationMethod*
vala_creation_method_construct (GType object_type,
                                const gchar* class_name,
                                const gchar* name,
                                ValaSourceReference* source_reference,
                                ValaComment* comment)
{
	ValaCreationMethod* self = NULL;
	ValaVoidType* _tmp0_;
	ValaVoidType* _tmp1_;
	_tmp0_ = vala_void_type_new (NULL);
	_tmp1_ = _tmp0_;
	self = (ValaCreationMethod*) vala_method_construct (object_type, name, (ValaDataType*) _tmp1_, source_reference, comment);
	_vala_code_node_unref0 (_tmp1_);
	vala_creation_method_set_class_name (self, class_name);
	return self;
}

ValaCreationMethod*
vala_creation_method_new (const gchar* class_name,
                          const gchar* name,
                          ValaSourceReference* source_reference,
                          ValaComment* comment)
{
	return vala_creation_method_construct (VALA_TYPE_CREATION_METHOD, class_name, name, source_reference, comment);
}

static void
vala_creation_method_real_accept (ValaCodeNode* base,
                                  ValaCodeVisitor* visitor)
{
	ValaCreationMethod * self;
	self = (ValaCreationMethod*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_creation_method (visitor, self);
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static void
vala_creation_method_real_accept_children (ValaCodeNode* base,
                                           ValaCodeVisitor* visitor)
{
	ValaCreationMethod * self;
	ValaList* _tmp8_;
	ValaBlock* _tmp33_;
	ValaBlock* _tmp34_;
	self = (ValaCreationMethod*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _param_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _param_index = 0;
		_tmp0_ = vala_callable_get_parameters ((ValaCallable*) self);
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_param_list = _tmp1_;
		_tmp2_ = _param_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_param_size = _tmp4_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaParameter* _tmp7_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp5_ = _param_list;
			_tmp6_ = vala_list_get (_tmp5_, _param_index);
			param = (ValaParameter*) _tmp6_;
			_tmp7_ = param;
			vala_code_node_accept ((ValaCodeNode*) _tmp7_, visitor);
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp8_ = ((ValaMethod*) self)->error_types;
	if (_tmp8_ != NULL) {
		{
			ValaList* _error_type_list = NULL;
			ValaList* _tmp9_;
			ValaList* _tmp10_;
			gint _error_type_size = 0;
			ValaList* _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			gint _error_type_index = 0;
			_tmp9_ = ((ValaMethod*) self)->error_types;
			_tmp10_ = _vala_iterable_ref0 (_tmp9_);
			_error_type_list = _tmp10_;
			_tmp11_ = _error_type_list;
			_tmp12_ = vala_collection_get_size ((ValaCollection*) _tmp11_);
			_tmp13_ = _tmp12_;
			_error_type_size = _tmp13_;
			_error_type_index = -1;
			while (TRUE) {
				ValaDataType* error_type = NULL;
				ValaList* _tmp14_;
				gpointer _tmp15_;
				ValaDataType* _tmp16_;
				_error_type_index = _error_type_index + 1;
				if (!(_error_type_index < _error_type_size)) {
					break;
				}
				_tmp14_ = _error_type_list;
				_tmp15_ = vala_list_get (_tmp14_, _error_type_index);
				error_type = (ValaDataType*) _tmp15_;
				_tmp16_ = error_type;
				vala_code_node_accept ((ValaCodeNode*) _tmp16_, visitor);
				_vala_code_node_unref0 (error_type);
			}
			_vala_iterable_unref0 (_error_type_list);
		}
	}
	{
		ValaList* _precondition_list = NULL;
		ValaList* _tmp17_;
		ValaList* _tmp18_;
		gint _precondition_size = 0;
		ValaList* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		gint _precondition_index = 0;
		_tmp17_ = vala_method_get_preconditions ((ValaMethod*) self);
		_tmp18_ = _vala_iterable_ref0 (_tmp17_);
		_precondition_list = _tmp18_;
		_tmp19_ = _precondition_list;
		_tmp20_ = vala_collection_get_size ((ValaCollection*) _tmp19_);
		_tmp21_ = _tmp20_;
		_precondition_size = _tmp21_;
		_precondition_index = -1;
		while (TRUE) {
			ValaExpression* precondition = NULL;
			ValaList* _tmp22_;
			gpointer _tmp23_;
			ValaExpression* _tmp24_;
			_precondition_index = _precondition_index + 1;
			if (!(_precondition_index < _precondition_size)) {
				break;
			}
			_tmp22_ = _precondition_list;
			_tmp23_ = vala_list_get (_tmp22_, _precondition_index);
			precondition = (ValaExpression*) _tmp23_;
			_tmp24_ = precondition;
			vala_code_node_accept ((ValaCodeNode*) _tmp24_, visitor);
			_vala_code_node_unref0 (precondition);
		}
		_vala_iterable_unref0 (_precondition_list);
	}
	{
		ValaList* _postcondition_list = NULL;
		ValaList* _tmp25_;
		ValaList* _tmp26_;
		gint _postcondition_size = 0;
		ValaList* _tmp27_;
		gint _tmp28_;
		gint _tmp29_;
		gint _postcondition_index = 0;
		_tmp25_ = vala_method_get_postconditions ((ValaMethod*) self);
		_tmp26_ = _vala_iterable_ref0 (_tmp25_);
		_postcondition_list = _tmp26_;
		_tmp27_ = _postcondition_list;
		_tmp28_ = vala_collection_get_size ((ValaCollection*) _tmp27_);
		_tmp29_ = _tmp28_;
		_postcondition_size = _tmp29_;
		_postcondition_index = -1;
		while (TRUE) {
			ValaExpression* postcondition = NULL;
			ValaList* _tmp30_;
			gpointer _tmp31_;
			ValaExpression* _tmp32_;
			_postcondition_index = _postcondition_index + 1;
			if (!(_postcondition_index < _postcondition_size)) {
				break;
			}
			_tmp30_ = _postcondition_list;
			_tmp31_ = vala_list_get (_tmp30_, _postcondition_index);
			postcondition = (ValaExpression*) _tmp31_;
			_tmp32_ = postcondition;
			vala_code_node_accept ((ValaCodeNode*) _tmp32_, visitor);
			_vala_code_node_unref0 (postcondition);
		}
		_vala_iterable_unref0 (_postcondition_list);
	}
	_tmp33_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp34_ = _tmp33_;
	if (_tmp34_ != NULL) {
		ValaBlock* _tmp35_;
		ValaBlock* _tmp36_;
		_tmp35_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp36_ = _tmp35_;
		vala_code_node_accept ((ValaCodeNode*) _tmp36_, visitor);
	}
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gboolean
vala_creation_method_real_check (ValaCodeNode* base,
                                 ValaCodeContext* context)
{
	ValaCreationMethod * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	ValaParameter* _tmp22_;
	ValaParameter* _tmp23_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp26_;
	ValaSemanticAnalyzer* _tmp27_;
	ValaSourceFile* _tmp28_;
	ValaSourceFile* _tmp29_;
	ValaSourceFile* _tmp30_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp31_;
	ValaSemanticAnalyzer* _tmp32_;
	ValaSymbol* _tmp33_;
	ValaSymbol* _tmp34_;
	ValaSymbol* _tmp35_;
	ValaSourceReference* _tmp36_;
	ValaSourceReference* _tmp37_;
	ValaSemanticAnalyzer* _tmp44_;
	ValaSemanticAnalyzer* _tmp45_;
	gint i = 0;
	ValaList* _tmp65_;
	ValaBlock* _tmp102_;
	ValaBlock* _tmp103_;
	ValaSemanticAnalyzer* _tmp227_;
	ValaSemanticAnalyzer* _tmp228_;
	ValaSourceFile* _tmp229_;
	ValaSemanticAnalyzer* _tmp230_;
	ValaSemanticAnalyzer* _tmp231_;
	ValaSymbol* _tmp232_;
	gboolean _tmp233_ = FALSE;
	gboolean _tmp234_ = FALSE;
	gboolean _tmp235_;
	gboolean _tmp236_;
	gboolean _tmp247_ = FALSE;
	ValaBlock* _tmp248_;
	ValaBlock* _tmp249_;
	gboolean _tmp288_;
	gboolean _tmp289_;
	gboolean result = FALSE;
	self = (ValaCreationMethod*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp5_ = self->priv->_class_name;
	if (_tmp5_ != NULL) {
		const gchar* _tmp6_;
		ValaSymbol* _tmp7_;
		ValaSymbol* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		_tmp6_ = self->priv->_class_name;
		_tmp7_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_symbol_get_name (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp4_ = g_strcmp0 (_tmp6_, _tmp10_) != 0;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaSourceReference* _tmp11_;
		ValaSourceReference* _tmp12_;
		ValaSemanticAnalyzer* _tmp13_;
		ValaSemanticAnalyzer* _tmp14_;
		ValaSymbol* _tmp15_;
		ValaSymbol* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		const gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		_tmp11_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_code_context_get_analyzer (context);
		_tmp14_ = _tmp13_;
		_tmp15_ = vala_semantic_analyzer_get_current_symbol (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_symbol_get_full_name (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = self->priv->_class_name;
		_tmp20_ = g_strdup_printf ("missing return type in method `%s.%s´", _tmp18_, _tmp19_);
		_tmp21_ = _tmp20_;
		vala_report_error (_tmp12_, _tmp21_);
		_g_free0 (_tmp21_);
		_g_free0 (_tmp18_);
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp22_ = vala_method_get_this_parameter ((ValaMethod*) self);
	_tmp23_ = _tmp22_;
	if (_tmp23_ != NULL) {
		ValaParameter* _tmp24_;
		ValaParameter* _tmp25_;
		_tmp24_ = vala_method_get_this_parameter ((ValaMethod*) self);
		_tmp25_ = _tmp24_;
		vala_code_node_check ((ValaCodeNode*) _tmp25_, context);
	}
	_tmp26_ = vala_code_context_get_analyzer (context);
	_tmp27_ = _tmp26_;
	_tmp28_ = vala_semantic_analyzer_get_current_source_file (_tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = _vala_source_file_ref0 (_tmp29_);
	old_source_file = _tmp30_;
	_tmp31_ = vala_code_context_get_analyzer (context);
	_tmp32_ = _tmp31_;
	_tmp33_ = vala_semantic_analyzer_get_current_symbol (_tmp32_);
	_tmp34_ = _tmp33_;
	_tmp35_ = _vala_code_node_ref0 (_tmp34_);
	old_symbol = _tmp35_;
	_tmp36_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp37_ = _tmp36_;
	if (_tmp37_ != NULL) {
		ValaSemanticAnalyzer* _tmp38_;
		ValaSemanticAnalyzer* _tmp39_;
		ValaSourceReference* _tmp40_;
		ValaSourceReference* _tmp41_;
		ValaSourceFile* _tmp42_;
		ValaSourceFile* _tmp43_;
		_tmp38_ = vala_code_context_get_analyzer (context);
		_tmp39_ = _tmp38_;
		_tmp40_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_source_reference_get_file (_tmp41_);
		_tmp43_ = _tmp42_;
		vala_semantic_analyzer_set_current_source_file (_tmp39_, _tmp43_);
	}
	_tmp44_ = vala_code_context_get_analyzer (context);
	_tmp45_ = _tmp44_;
	vala_semantic_analyzer_set_current_symbol (_tmp45_, (ValaSymbol*) self);
	i = 0;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp46_;
		ValaList* _tmp47_;
		gint _param_size = 0;
		ValaList* _tmp48_;
		gint _tmp49_;
		gint _tmp50_;
		gint _param_index = 0;
		_tmp46_ = vala_callable_get_parameters ((ValaCallable*) self);
		_tmp47_ = _vala_iterable_ref0 (_tmp46_);
		_param_list = _tmp47_;
		_tmp48_ = _param_list;
		_tmp49_ = vala_collection_get_size ((ValaCollection*) _tmp48_);
		_tmp50_ = _tmp49_;
		_param_size = _tmp50_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp51_;
			gpointer _tmp52_;
			ValaParameter* _tmp53_;
			gboolean _tmp54_ = FALSE;
			gboolean _tmp55_ = FALSE;
			gint _tmp64_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp51_ = _param_list;
			_tmp52_ = vala_list_get (_tmp51_, _param_index);
			param = (ValaParameter*) _tmp52_;
			_tmp53_ = param;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp53_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			if (i == 0) {
				ValaParameter* _tmp56_;
				gboolean _tmp57_;
				gboolean _tmp58_;
				_tmp56_ = param;
				_tmp57_ = vala_parameter_get_ellipsis (_tmp56_);
				_tmp58_ = _tmp57_;
				_tmp55_ = _tmp58_;
			} else {
				_tmp55_ = FALSE;
			}
			if (_tmp55_) {
				ValaBlock* _tmp59_;
				ValaBlock* _tmp60_;
				_tmp59_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp60_ = _tmp59_;
				_tmp54_ = _tmp60_ != NULL;
			} else {
				_tmp54_ = FALSE;
			}
			if (_tmp54_) {
				ValaParameter* _tmp61_;
				ValaSourceReference* _tmp62_;
				ValaSourceReference* _tmp63_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp61_ = param;
				_tmp62_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp61_);
				_tmp63_ = _tmp62_;
				vala_report_error (_tmp63_, "Named parameter required before `...'");
			}
			_tmp64_ = i;
			i = _tmp64_ + 1;
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp65_ = ((ValaMethod*) self)->error_types;
	if (_tmp65_ != NULL) {
		{
			ValaList* _error_type_list = NULL;
			ValaList* _tmp66_;
			ValaList* _tmp67_;
			gint _error_type_size = 0;
			ValaList* _tmp68_;
			gint _tmp69_;
			gint _tmp70_;
			gint _error_type_index = 0;
			_tmp66_ = ((ValaMethod*) self)->error_types;
			_tmp67_ = _vala_iterable_ref0 (_tmp66_);
			_error_type_list = _tmp67_;
			_tmp68_ = _error_type_list;
			_tmp69_ = vala_collection_get_size ((ValaCollection*) _tmp68_);
			_tmp70_ = _tmp69_;
			_error_type_size = _tmp70_;
			_error_type_index = -1;
			while (TRUE) {
				ValaDataType* error_type = NULL;
				ValaList* _tmp71_;
				gpointer _tmp72_;
				ValaDataType* _tmp73_;
				ValaSemanticAnalyzer* _tmp74_;
				ValaSemanticAnalyzer* _tmp75_;
				ValaDataType* _tmp76_;
				_error_type_index = _error_type_index + 1;
				if (!(_error_type_index < _error_type_size)) {
					break;
				}
				_tmp71_ = _error_type_list;
				_tmp72_ = vala_list_get (_tmp71_, _error_type_index);
				error_type = (ValaDataType*) _tmp72_;
				_tmp73_ = error_type;
				vala_code_node_check ((ValaCodeNode*) _tmp73_, context);
				_tmp74_ = vala_code_context_get_analyzer (context);
				_tmp75_ = _tmp74_;
				_tmp76_ = error_type;
				if (!vala_semantic_analyzer_is_type_accessible (_tmp75_, (ValaSymbol*) self, _tmp76_)) {
					ValaSourceReference* _tmp77_;
					ValaSourceReference* _tmp78_;
					ValaDataType* _tmp79_;
					gchar* _tmp80_;
					gchar* _tmp81_;
					gchar* _tmp82_;
					gchar* _tmp83_;
					gchar* _tmp84_;
					gchar* _tmp85_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp77_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp78_ = _tmp77_;
					_tmp79_ = error_type;
					_tmp80_ = vala_code_node_to_string ((ValaCodeNode*) _tmp79_);
					_tmp81_ = _tmp80_;
					_tmp82_ = vala_symbol_get_full_name ((ValaSymbol*) self);
					_tmp83_ = _tmp82_;
					_tmp84_ = g_strdup_printf ("error type `%s' is less accessible than creation method `%s'", _tmp81_, _tmp83_);
					_tmp85_ = _tmp84_;
					vala_report_error (_tmp78_, _tmp85_);
					_g_free0 (_tmp85_);
					_g_free0 (_tmp83_);
					_g_free0 (_tmp81_);
					result = FALSE;
					_vala_code_node_unref0 (error_type);
					_vala_iterable_unref0 (_error_type_list);
					_vala_code_node_unref0 (old_symbol);
					_vala_source_file_unref0 (old_source_file);
					return result;
				}
				_vala_code_node_unref0 (error_type);
			}
			_vala_iterable_unref0 (_error_type_list);
		}
	}
	{
		ValaList* _precondition_list = NULL;
		ValaList* _tmp86_;
		ValaList* _tmp87_;
		gint _precondition_size = 0;
		ValaList* _tmp88_;
		gint _tmp89_;
		gint _tmp90_;
		gint _precondition_index = 0;
		_tmp86_ = vala_method_get_preconditions ((ValaMethod*) self);
		_tmp87_ = _vala_iterable_ref0 (_tmp86_);
		_precondition_list = _tmp87_;
		_tmp88_ = _precondition_list;
		_tmp89_ = vala_collection_get_size ((ValaCollection*) _tmp88_);
		_tmp90_ = _tmp89_;
		_precondition_size = _tmp90_;
		_precondition_index = -1;
		while (TRUE) {
			ValaExpression* precondition = NULL;
			ValaList* _tmp91_;
			gpointer _tmp92_;
			ValaExpression* _tmp93_;
			_precondition_index = _precondition_index + 1;
			if (!(_precondition_index < _precondition_size)) {
				break;
			}
			_tmp91_ = _precondition_list;
			_tmp92_ = vala_list_get (_tmp91_, _precondition_index);
			precondition = (ValaExpression*) _tmp92_;
			_tmp93_ = precondition;
			vala_code_node_check ((ValaCodeNode*) _tmp93_, context);
			_vala_code_node_unref0 (precondition);
		}
		_vala_iterable_unref0 (_precondition_list);
	}
	{
		ValaList* _postcondition_list = NULL;
		ValaList* _tmp94_;
		ValaList* _tmp95_;
		gint _postcondition_size = 0;
		ValaList* _tmp96_;
		gint _tmp97_;
		gint _tmp98_;
		gint _postcondition_index = 0;
		_tmp94_ = vala_method_get_postconditions ((ValaMethod*) self);
		_tmp95_ = _vala_iterable_ref0 (_tmp94_);
		_postcondition_list = _tmp95_;
		_tmp96_ = _postcondition_list;
		_tmp97_ = vala_collection_get_size ((ValaCollection*) _tmp96_);
		_tmp98_ = _tmp97_;
		_postcondition_size = _tmp98_;
		_postcondition_index = -1;
		while (TRUE) {
			ValaExpression* postcondition = NULL;
			ValaList* _tmp99_;
			gpointer _tmp100_;
			ValaExpression* _tmp101_;
			_postcondition_index = _postcondition_index + 1;
			if (!(_postcondition_index < _postcondition_size)) {
				break;
			}
			_tmp99_ = _postcondition_list;
			_tmp100_ = vala_list_get (_tmp99_, _postcondition_index);
			postcondition = (ValaExpression*) _tmp100_;
			_tmp101_ = postcondition;
			vala_code_node_check ((ValaCodeNode*) _tmp101_, context);
			_vala_code_node_unref0 (postcondition);
		}
		_vala_iterable_unref0 (_postcondition_list);
	}
	_tmp102_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp103_ = _tmp102_;
	if (_tmp103_ != NULL) {
		ValaBlock* _tmp104_;
		ValaBlock* _tmp105_;
		ValaClass* cl = NULL;
		ValaSymbol* _tmp106_;
		ValaSymbol* _tmp107_;
		gboolean _tmp108_ = FALSE;
		gboolean _tmp109_ = FALSE;
		gboolean _tmp110_;
		_tmp104_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp105_ = _tmp104_;
		vala_code_node_check ((ValaCodeNode*) _tmp105_, context);
		_tmp106_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp107_ = _tmp106_;
		cl = VALA_IS_CLASS (_tmp107_) ? ((ValaClass*) _tmp107_) : NULL;
		_tmp110_ = self->priv->_chain_up;
		if (!_tmp110_) {
			ValaClass* _tmp111_;
			_tmp111_ = cl;
			_tmp109_ = _tmp111_ != NULL;
		} else {
			_tmp109_ = FALSE;
		}
		if (_tmp109_) {
			ValaClass* _tmp112_;
			ValaClass* _tmp113_;
			ValaClass* _tmp114_;
			_tmp112_ = cl;
			_tmp113_ = vala_class_get_base_class (_tmp112_);
			_tmp114_ = _tmp113_;
			_tmp108_ = _tmp114_ != NULL;
		} else {
			_tmp108_ = FALSE;
		}
		if (_tmp108_) {
			gboolean _tmp115_ = FALSE;
			gboolean _tmp116_ = FALSE;
			ValaProfile _tmp117_;
			ValaProfile _tmp118_;
			_tmp117_ = vala_code_context_get_profile (context);
			_tmp118_ = _tmp117_;
			if (_tmp118_ == VALA_PROFILE_GOBJECT) {
				ValaClass* _tmp119_;
				ValaClass* _tmp120_;
				ValaClass* _tmp121_;
				ValaCreationMethod* _tmp122_;
				ValaCreationMethod* _tmp123_;
				_tmp119_ = cl;
				_tmp120_ = vala_class_get_base_class (_tmp119_);
				_tmp121_ = _tmp120_;
				_tmp122_ = vala_class_get_default_construction_method (_tmp121_);
				_tmp123_ = _tmp122_;
				_tmp116_ = _tmp123_ != NULL;
			} else {
				_tmp116_ = FALSE;
			}
			if (_tmp116_) {
				ValaClass* _tmp124_;
				ValaClass* _tmp125_;
				ValaClass* _tmp126_;
				ValaCreationMethod* _tmp127_;
				ValaCreationMethod* _tmp128_;
				gboolean _tmp129_;
				gboolean _tmp130_;
				_tmp124_ = cl;
				_tmp125_ = vala_class_get_base_class (_tmp124_);
				_tmp126_ = _tmp125_;
				_tmp127_ = vala_class_get_default_construction_method (_tmp126_);
				_tmp128_ = _tmp127_;
				_tmp129_ = vala_method_get_has_construct_function ((ValaMethod*) _tmp128_);
				_tmp130_ = _tmp129_;
				_tmp115_ = !_tmp130_;
			} else {
				_tmp115_ = FALSE;
			}
			if (_tmp115_) {
				ValaBlock* old_insert_block = NULL;
				ValaSemanticAnalyzer* _tmp131_;
				ValaSemanticAnalyzer* _tmp132_;
				ValaBlock* _tmp133_;
				ValaBlock* _tmp134_;
				ValaSemanticAnalyzer* _tmp135_;
				ValaSemanticAnalyzer* _tmp136_;
				ValaBlock* _tmp137_;
				ValaBlock* _tmp138_;
				ValaSemanticAnalyzer* _tmp139_;
				ValaSemanticAnalyzer* _tmp140_;
				ValaBlock* _tmp141_;
				ValaBlock* _tmp142_;
				ValaBlock* _tmp143_;
				ValaExpressionStatement* stmt = NULL;
				ValaSourceReference* _tmp144_;
				ValaSourceReference* _tmp145_;
				ValaMemberAccess* _tmp146_;
				ValaMemberAccess* _tmp147_;
				ValaSourceReference* _tmp148_;
				ValaSourceReference* _tmp149_;
				ValaMemberAccess* _tmp150_;
				ValaMemberAccess* _tmp151_;
				ValaSourceReference* _tmp152_;
				ValaSourceReference* _tmp153_;
				ValaMethodCall* _tmp154_;
				ValaMethodCall* _tmp155_;
				ValaSourceReference* _tmp156_;
				ValaSourceReference* _tmp157_;
				ValaExpressionStatement* _tmp158_;
				ValaExpressionStatement* _tmp159_;
				ValaBlock* _tmp160_;
				ValaBlock* _tmp161_;
				ValaExpressionStatement* _tmp162_;
				ValaExpressionStatement* _tmp163_;
				ValaSemanticAnalyzer* _tmp164_;
				ValaSemanticAnalyzer* _tmp165_;
				ValaSemanticAnalyzer* _tmp166_;
				ValaSemanticAnalyzer* _tmp167_;
				ValaBlock* _tmp168_;
				ValaBlock* _tmp169_;
				_tmp131_ = vala_code_context_get_analyzer (context);
				_tmp132_ = _tmp131_;
				_tmp133_ = _tmp132_->insert_block;
				_tmp134_ = _vala_code_node_ref0 (_tmp133_);
				old_insert_block = _tmp134_;
				_tmp135_ = vala_code_context_get_analyzer (context);
				_tmp136_ = _tmp135_;
				_tmp137_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp138_ = _tmp137_;
				vala_semantic_analyzer_set_current_symbol (_tmp136_, (ValaSymbol*) _tmp138_);
				_tmp139_ = vala_code_context_get_analyzer (context);
				_tmp140_ = _tmp139_;
				_tmp141_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp142_ = _tmp141_;
				_tmp143_ = _vala_code_node_ref0 (_tmp142_);
				_vala_code_node_unref0 (_tmp140_->insert_block);
				_tmp140_->insert_block = _tmp143_;
				_tmp144_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp145_ = _tmp144_;
				_tmp146_ = vala_member_access_new_simple ("GLib", _tmp145_);
				_tmp147_ = _tmp146_;
				_tmp148_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp149_ = _tmp148_;
				_tmp150_ = vala_member_access_new ((ValaExpression*) _tmp147_, "Object", _tmp149_);
				_tmp151_ = _tmp150_;
				_tmp152_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp153_ = _tmp152_;
				_tmp154_ = vala_method_call_new ((ValaExpression*) _tmp151_, _tmp153_);
				_tmp155_ = _tmp154_;
				_tmp156_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp157_ = _tmp156_;
				_tmp158_ = vala_expression_statement_new ((ValaExpression*) _tmp155_, _tmp157_);
				_tmp159_ = _tmp158_;
				_vala_code_node_unref0 (_tmp155_);
				_vala_code_node_unref0 (_tmp151_);
				_vala_code_node_unref0 (_tmp147_);
				stmt = _tmp159_;
				_tmp160_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp161_ = _tmp160_;
				_tmp162_ = stmt;
				vala_block_insert_statement (_tmp161_, 0, (ValaStatement*) _tmp162_);
				_tmp163_ = stmt;
				vala_code_node_check ((ValaCodeNode*) _tmp163_, context);
				_tmp164_ = vala_code_context_get_analyzer (context);
				_tmp165_ = _tmp164_;
				vala_semantic_analyzer_set_current_symbol (_tmp165_, (ValaSymbol*) self);
				_tmp166_ = vala_code_context_get_analyzer (context);
				_tmp167_ = _tmp166_;
				_tmp168_ = old_insert_block;
				_tmp169_ = _vala_code_node_ref0 (_tmp168_);
				_vala_code_node_unref0 (_tmp167_->insert_block);
				_tmp167_->insert_block = _tmp169_;
				_vala_code_node_unref0 (stmt);
				_vala_code_node_unref0 (old_insert_block);
			} else {
				gboolean _tmp170_ = FALSE;
				ValaClass* _tmp171_;
				ValaClass* _tmp172_;
				ValaClass* _tmp173_;
				ValaCreationMethod* _tmp174_;
				ValaCreationMethod* _tmp175_;
				_tmp171_ = cl;
				_tmp172_ = vala_class_get_base_class (_tmp171_);
				_tmp173_ = _tmp172_;
				_tmp174_ = vala_class_get_default_construction_method (_tmp173_);
				_tmp175_ = _tmp174_;
				if (_tmp175_ == NULL) {
					_tmp170_ = TRUE;
				} else {
					ValaClass* _tmp176_;
					ValaClass* _tmp177_;
					ValaClass* _tmp178_;
					ValaCreationMethod* _tmp179_;
					ValaCreationMethod* _tmp180_;
					ValaSymbolAccessibility _tmp181_;
					ValaSymbolAccessibility _tmp182_;
					_tmp176_ = cl;
					_tmp177_ = vala_class_get_base_class (_tmp176_);
					_tmp178_ = _tmp177_;
					_tmp179_ = vala_class_get_default_construction_method (_tmp178_);
					_tmp180_ = _tmp179_;
					_tmp181_ = vala_symbol_get_access ((ValaSymbol*) _tmp180_);
					_tmp182_ = _tmp181_;
					_tmp170_ = _tmp182_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
				}
				if (_tmp170_) {
					ValaSourceReference* _tmp183_;
					ValaSourceReference* _tmp184_;
					_tmp183_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp184_ = _tmp183_;
					vala_report_error (_tmp184_, "unable to chain up to private base constructor");
				} else {
					ValaClass* _tmp185_;
					ValaClass* _tmp186_;
					ValaClass* _tmp187_;
					ValaCreationMethod* _tmp188_;
					ValaCreationMethod* _tmp189_;
					_tmp185_ = cl;
					_tmp186_ = vala_class_get_base_class (_tmp185_);
					_tmp187_ = _tmp186_;
					_tmp188_ = vala_class_get_default_construction_method (_tmp187_);
					_tmp189_ = _tmp188_;
					if (vala_method_get_required_arguments ((ValaMethod*) _tmp189_) > 0) {
						ValaSourceReference* _tmp190_;
						ValaSourceReference* _tmp191_;
						_tmp190_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp191_ = _tmp190_;
						vala_report_error (_tmp191_, "unable to chain up to base constructor requiring arguments");
					} else {
						ValaBlock* old_insert_block = NULL;
						ValaSemanticAnalyzer* _tmp192_;
						ValaSemanticAnalyzer* _tmp193_;
						ValaBlock* _tmp194_;
						ValaBlock* _tmp195_;
						ValaSemanticAnalyzer* _tmp196_;
						ValaSemanticAnalyzer* _tmp197_;
						ValaBlock* _tmp198_;
						ValaBlock* _tmp199_;
						ValaSemanticAnalyzer* _tmp200_;
						ValaSemanticAnalyzer* _tmp201_;
						ValaBlock* _tmp202_;
						ValaBlock* _tmp203_;
						ValaBlock* _tmp204_;
						ValaExpressionStatement* stmt = NULL;
						ValaSourceReference* _tmp205_;
						ValaSourceReference* _tmp206_;
						ValaBaseAccess* _tmp207_;
						ValaBaseAccess* _tmp208_;
						ValaSourceReference* _tmp209_;
						ValaSourceReference* _tmp210_;
						ValaMethodCall* _tmp211_;
						ValaMethodCall* _tmp212_;
						ValaSourceReference* _tmp213_;
						ValaSourceReference* _tmp214_;
						ValaExpressionStatement* _tmp215_;
						ValaExpressionStatement* _tmp216_;
						ValaBlock* _tmp217_;
						ValaBlock* _tmp218_;
						ValaExpressionStatement* _tmp219_;
						ValaExpressionStatement* _tmp220_;
						ValaSemanticAnalyzer* _tmp221_;
						ValaSemanticAnalyzer* _tmp222_;
						ValaSemanticAnalyzer* _tmp223_;
						ValaSemanticAnalyzer* _tmp224_;
						ValaBlock* _tmp225_;
						ValaBlock* _tmp226_;
						_tmp192_ = vala_code_context_get_analyzer (context);
						_tmp193_ = _tmp192_;
						_tmp194_ = _tmp193_->insert_block;
						_tmp195_ = _vala_code_node_ref0 (_tmp194_);
						old_insert_block = _tmp195_;
						_tmp196_ = vala_code_context_get_analyzer (context);
						_tmp197_ = _tmp196_;
						_tmp198_ = vala_subroutine_get_body ((ValaSubroutine*) self);
						_tmp199_ = _tmp198_;
						vala_semantic_analyzer_set_current_symbol (_tmp197_, (ValaSymbol*) _tmp199_);
						_tmp200_ = vala_code_context_get_analyzer (context);
						_tmp201_ = _tmp200_;
						_tmp202_ = vala_subroutine_get_body ((ValaSubroutine*) self);
						_tmp203_ = _tmp202_;
						_tmp204_ = _vala_code_node_ref0 (_tmp203_);
						_vala_code_node_unref0 (_tmp201_->insert_block);
						_tmp201_->insert_block = _tmp204_;
						_tmp205_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp206_ = _tmp205_;
						_tmp207_ = vala_base_access_new (_tmp206_);
						_tmp208_ = _tmp207_;
						_tmp209_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp210_ = _tmp209_;
						_tmp211_ = vala_method_call_new ((ValaExpression*) _tmp208_, _tmp210_);
						_tmp212_ = _tmp211_;
						_tmp213_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp214_ = _tmp213_;
						_tmp215_ = vala_expression_statement_new ((ValaExpression*) _tmp212_, _tmp214_);
						_tmp216_ = _tmp215_;
						_vala_code_node_unref0 (_tmp212_);
						_vala_code_node_unref0 (_tmp208_);
						stmt = _tmp216_;
						_tmp217_ = vala_subroutine_get_body ((ValaSubroutine*) self);
						_tmp218_ = _tmp217_;
						_tmp219_ = stmt;
						vala_block_insert_statement (_tmp218_, 0, (ValaStatement*) _tmp219_);
						_tmp220_ = stmt;
						vala_code_node_check ((ValaCodeNode*) _tmp220_, context);
						_tmp221_ = vala_code_context_get_analyzer (context);
						_tmp222_ = _tmp221_;
						vala_semantic_analyzer_set_current_symbol (_tmp222_, (ValaSymbol*) self);
						_tmp223_ = vala_code_context_get_analyzer (context);
						_tmp224_ = _tmp223_;
						_tmp225_ = old_insert_block;
						_tmp226_ = _vala_code_node_ref0 (_tmp225_);
						_vala_code_node_unref0 (_tmp224_->insert_block);
						_tmp224_->insert_block = _tmp226_;
						_vala_code_node_unref0 (stmt);
						_vala_code_node_unref0 (old_insert_block);
					}
				}
			}
		}
	}
	_tmp227_ = vala_code_context_get_analyzer (context);
	_tmp228_ = _tmp227_;
	_tmp229_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp228_, _tmp229_);
	_tmp230_ = vala_code_context_get_analyzer (context);
	_tmp231_ = _tmp230_;
	_tmp232_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp231_, _tmp232_);
	_tmp235_ = vala_method_get_is_abstract ((ValaMethod*) self);
	_tmp236_ = _tmp235_;
	if (_tmp236_) {
		_tmp234_ = TRUE;
	} else {
		gboolean _tmp237_;
		gboolean _tmp238_;
		_tmp237_ = vala_method_get_is_virtual ((ValaMethod*) self);
		_tmp238_ = _tmp237_;
		_tmp234_ = _tmp238_;
	}
	if (_tmp234_) {
		_tmp233_ = TRUE;
	} else {
		gboolean _tmp239_;
		gboolean _tmp240_;
		_tmp239_ = vala_method_get_overrides ((ValaMethod*) self);
		_tmp240_ = _tmp239_;
		_tmp233_ = _tmp240_;
	}
	if (_tmp233_) {
		ValaSourceReference* _tmp241_;
		ValaSourceReference* _tmp242_;
		gchar* _tmp243_;
		gchar* _tmp244_;
		gchar* _tmp245_;
		gchar* _tmp246_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp241_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp242_ = _tmp241_;
		_tmp243_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp244_ = _tmp243_;
		_tmp245_ = g_strdup_printf ("The creation method `%s' cannot be marked as override, virtual, or abs" \
"tract", _tmp244_);
		_tmp246_ = _tmp245_;
		vala_report_error (_tmp242_, _tmp246_);
		_g_free0 (_tmp246_);
		_g_free0 (_tmp244_);
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp248_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp249_ = _tmp248_;
	if (_tmp249_ != NULL) {
		ValaBlock* _tmp250_;
		ValaBlock* _tmp251_;
		gboolean _tmp252_;
		gboolean _tmp253_;
		_tmp250_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp251_ = _tmp250_;
		_tmp252_ = vala_code_node_get_error ((ValaCodeNode*) _tmp251_);
		_tmp253_ = _tmp252_;
		_tmp247_ = !_tmp253_;
	} else {
		_tmp247_ = FALSE;
	}
	if (_tmp247_) {
		ValaArrayList* body_errors = NULL;
		GEqualFunc _tmp254_;
		ValaArrayList* _tmp255_;
		ValaBlock* _tmp256_;
		ValaBlock* _tmp257_;
		ValaArrayList* _tmp258_;
		_tmp254_ = g_direct_equal;
		_tmp255_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp254_);
		body_errors = _tmp255_;
		_tmp256_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp257_ = _tmp256_;
		_tmp258_ = body_errors;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp257_, (ValaCollection*) _tmp258_, NULL);
		{
			ValaArrayList* _body_error_type_list = NULL;
			ValaArrayList* _tmp259_;
			ValaArrayList* _tmp260_;
			gint _body_error_type_size = 0;
			ValaArrayList* _tmp261_;
			gint _tmp262_;
			gint _tmp263_;
			gint _body_error_type_index = 0;
			_tmp259_ = body_errors;
			_tmp260_ = _vala_iterable_ref0 (_tmp259_);
			_body_error_type_list = _tmp260_;
			_tmp261_ = _body_error_type_list;
			_tmp262_ = vala_collection_get_size ((ValaCollection*) _tmp261_);
			_tmp263_ = _tmp262_;
			_body_error_type_size = _tmp263_;
			_body_error_type_index = -1;
			while (TRUE) {
				ValaDataType* body_error_type = NULL;
				ValaArrayList* _tmp264_;
				gpointer _tmp265_;
				gboolean can_propagate_error = FALSE;
				ValaList* _tmp266_;
				gboolean _tmp276_ = FALSE;
				_body_error_type_index = _body_error_type_index + 1;
				if (!(_body_error_type_index < _body_error_type_size)) {
					break;
				}
				_tmp264_ = _body_error_type_list;
				_tmp265_ = vala_list_get ((ValaList*) _tmp264_, _body_error_type_index);
				body_error_type = (ValaDataType*) _tmp265_;
				can_propagate_error = FALSE;
				_tmp266_ = ((ValaMethod*) self)->error_types;
				if (_tmp266_ != NULL) {
					{
						ValaList* _method_error_type_list = NULL;
						ValaList* _tmp267_;
						ValaList* _tmp268_;
						gint _method_error_type_size = 0;
						ValaList* _tmp269_;
						gint _tmp270_;
						gint _tmp271_;
						gint _method_error_type_index = 0;
						_tmp267_ = ((ValaMethod*) self)->error_types;
						_tmp268_ = _vala_iterable_ref0 (_tmp267_);
						_method_error_type_list = _tmp268_;
						_tmp269_ = _method_error_type_list;
						_tmp270_ = vala_collection_get_size ((ValaCollection*) _tmp269_);
						_tmp271_ = _tmp270_;
						_method_error_type_size = _tmp271_;
						_method_error_type_index = -1;
						while (TRUE) {
							ValaDataType* method_error_type = NULL;
							ValaList* _tmp272_;
							gpointer _tmp273_;
							ValaDataType* _tmp274_;
							ValaDataType* _tmp275_;
							_method_error_type_index = _method_error_type_index + 1;
							if (!(_method_error_type_index < _method_error_type_size)) {
								break;
							}
							_tmp272_ = _method_error_type_list;
							_tmp273_ = vala_list_get (_tmp272_, _method_error_type_index);
							method_error_type = (ValaDataType*) _tmp273_;
							_tmp274_ = body_error_type;
							_tmp275_ = method_error_type;
							if (vala_data_type_compatible (_tmp274_, _tmp275_)) {
								can_propagate_error = TRUE;
							}
							_vala_code_node_unref0 (method_error_type);
						}
						_vala_iterable_unref0 (_method_error_type_list);
					}
				}
				if (!can_propagate_error) {
					ValaDataType* _tmp277_;
					gboolean _tmp278_;
					gboolean _tmp279_;
					_tmp277_ = body_error_type;
					_tmp278_ = vala_error_type_get_dynamic_error (G_TYPE_CHECK_INSTANCE_CAST (_tmp277_, VALA_TYPE_ERROR_TYPE, ValaErrorType));
					_tmp279_ = _tmp278_;
					_tmp276_ = !_tmp279_;
				} else {
					_tmp276_ = FALSE;
				}
				if (_tmp276_) {
					ValaDataType* _tmp280_;
					ValaSourceReference* _tmp281_;
					ValaSourceReference* _tmp282_;
					ValaDataType* _tmp283_;
					gchar* _tmp284_;
					gchar* _tmp285_;
					gchar* _tmp286_;
					gchar* _tmp287_;
					_tmp280_ = body_error_type;
					_tmp281_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp280_);
					_tmp282_ = _tmp281_;
					_tmp283_ = body_error_type;
					_tmp284_ = vala_code_node_to_string ((ValaCodeNode*) _tmp283_);
					_tmp285_ = _tmp284_;
					_tmp286_ = g_strdup_printf ("unhandled error `%s'", _tmp285_);
					_tmp287_ = _tmp286_;
					vala_report_warning (_tmp282_, _tmp287_);
					_g_free0 (_tmp287_);
					_g_free0 (_tmp285_);
				}
				_vala_code_node_unref0 (body_error_type);
			}
			_vala_iterable_unref0 (_body_error_type_list);
		}
		_vala_iterable_unref0 (body_errors);
	}
	_tmp288_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp289_ = _tmp288_;
	result = !_tmp289_;
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}

static void
vala_creation_method_class_init (ValaCreationMethodClass * klass,
                                 gpointer klass_data)
{
	vala_creation_method_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_creation_method_finalize;
	g_type_class_adjust_private_offset (klass, &ValaCreationMethod_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_creation_method_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_creation_method_real_accept_children;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_creation_method_real_check;
}

static void
vala_creation_method_instance_init (ValaCreationMethod * self,
                                    gpointer klass)
{
	self->priv = vala_creation_method_get_instance_private (self);
}

static void
vala_creation_method_finalize (ValaCodeNode * obj)
{
	ValaCreationMethod * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CREATION_METHOD, ValaCreationMethod);
	_g_free0 (self->priv->_class_name);
	VALA_CODE_NODE_CLASS (vala_creation_method_parent_class)->finalize (obj);
}

/**
 * Represents a type creation method.
 */
static GType
vala_creation_method_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaCreationMethodClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_creation_method_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCreationMethod), 0, (GInstanceInitFunc) vala_creation_method_instance_init, NULL };
	GType vala_creation_method_type_id;
	vala_creation_method_type_id = g_type_register_static (VALA_TYPE_METHOD, "ValaCreationMethod", &g_define_type_info, 0);
	ValaCreationMethod_private_offset = g_type_add_instance_private (vala_creation_method_type_id, sizeof (ValaCreationMethodPrivate));
	return vala_creation_method_type_id;
}

GType
vala_creation_method_get_type (void)
{
	static volatile gsize vala_creation_method_type_id__volatile = 0;
	if (g_once_init_enter (&vala_creation_method_type_id__volatile)) {
		GType vala_creation_method_type_id;
		vala_creation_method_type_id = vala_creation_method_get_type_once ();
		g_once_init_leave (&vala_creation_method_type_id__volatile, vala_creation_method_type_id);
	}
	return vala_creation_method_type_id__volatile;
}

