/* valasignal.c generated by valac, the Vala compiler
 * generated from valasignal.vala, do not modify */

/* valasignal.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaSignalPrivate {
	gboolean _is_virtual;
	ValaList* parameters;
	ValaMethod* _default_handler;
	ValaMethod* _emitter;
	ValaDataType* _return_type;
	ValaBlock* _body;
};

static gint ValaSignal_private_offset;
static gpointer vala_signal_parent_class = NULL;
static ValaCallableIface * vala_signal_vala_callable_parent_iface = NULL;

static void vala_signal_set_default_handler (ValaSignal* self,
                                      ValaMethod* value);
static void vala_signal_set_emitter (ValaSignal* self,
                              ValaMethod* value);
static void vala_signal_real_add_parameter (ValaCallable* base,
                                     ValaParameter* param);
static ValaList* vala_signal_real_get_parameters (ValaCallable* base);
static void vala_signal_real_accept (ValaCodeNode* base,
                              ValaCodeVisitor* visitor);
static void vala_signal_real_accept_children (ValaCodeNode* base,
                                       ValaCodeVisitor* visitor);
static void vala_signal_real_replace_type (ValaCodeNode* base,
                                    ValaDataType* old_type,
                                    ValaDataType* new_type);
static gboolean vala_signal_real_check (ValaCodeNode* base,
                                 ValaCodeContext* context);
static void vala_signal_finalize (ValaCodeNode * obj);
static GType vala_signal_get_type_once (void);

static inline gpointer
vala_signal_get_instance_private (ValaSignal* self)
{
	return G_STRUCT_MEMBER_P (self, ValaSignal_private_offset);
}

static ValaDataType*
vala_signal_real_get_return_type (ValaCallable* base)
{
	ValaDataType* result;
	ValaSignal* self;
	ValaDataType* _tmp0_;
	self = (ValaSignal*) base;
	_tmp0_ = self->priv->_return_type;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static void
vala_signal_real_set_return_type (ValaCallable* base,
                                  ValaDataType* value)
{
	ValaSignal* self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaSignal*) base;
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_return_type);
	self->priv->_return_type = _tmp0_;
	_tmp1_ = self->priv->_return_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

ValaBlock*
vala_signal_get_body (ValaSignal* self)
{
	ValaBlock* result;
	ValaBlock* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_body;
	result = _tmp0_;
	return result;
}

void
vala_signal_set_body (ValaSignal* self,
                      ValaBlock* value)
{
	ValaBlock* _tmp0_;
	ValaBlock* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_body);
	self->priv->_body = _tmp0_;
	_tmp1_ = self->priv->_body;
	if (_tmp1_ != NULL) {
		ValaBlock* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_body;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

gboolean
vala_signal_get_is_virtual (ValaSignal* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_virtual;
	return result;
}

void
vala_signal_set_is_virtual (ValaSignal* self,
                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_virtual = value;
}

ValaMethod*
vala_signal_get_default_handler (ValaSignal* self)
{
	ValaMethod* result;
	ValaMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_default_handler;
	result = _tmp0_;
	return result;
}

static void
vala_signal_set_default_handler (ValaSignal* self,
                                 ValaMethod* value)
{
	ValaMethod* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_default_handler);
	self->priv->_default_handler = _tmp0_;
}

ValaMethod*
vala_signal_get_emitter (ValaSignal* self)
{
	ValaMethod* result;
	ValaMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_emitter;
	result = _tmp0_;
	return result;
}

static void
vala_signal_set_emitter (ValaSignal* self,
                         ValaMethod* value)
{
	ValaMethod* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_emitter);
	self->priv->_emitter = _tmp0_;
}

/**
 * Creates a new signal.
 *
 * @param name              signal name
 * @param return_type       signal return type
 * @param source_reference  reference to source code
 * @return                  newly created signal
 */
ValaSignal*
vala_signal_construct (GType object_type,
                       const gchar* name,
                       ValaDataType* return_type,
                       ValaSourceReference* source_reference,
                       ValaComment* comment)
{
	ValaSignal* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (return_type != NULL, NULL);
	self = (ValaSignal*) vala_symbol_construct (object_type, name, source_reference, comment);
	vala_callable_set_return_type ((ValaCallable*) self, return_type);
	return self;
}

ValaSignal*
vala_signal_new (const gchar* name,
                 ValaDataType* return_type,
                 ValaSourceReference* source_reference,
                 ValaComment* comment)
{
	return vala_signal_construct (VALA_TYPE_SIGNAL, name, return_type, source_reference, comment);
}

/**
 * Appends parameter to signal handler.
 *
 * @param param a formal parameter
 */
static void
vala_signal_real_add_parameter (ValaCallable* base,
                                ValaParameter* param)
{
	ValaSignal * self;
	ValaList* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	self = (ValaSignal*) base;
	g_return_if_fail (param != NULL);
	_tmp0_ = self->priv->parameters;
	vala_collection_add ((ValaCollection*) _tmp0_, param);
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) param);
	_tmp4_ = _tmp3_;
	vala_scope_add (_tmp2_, _tmp4_, (ValaSymbol*) param);
}

static ValaList*
vala_signal_real_get_parameters (ValaCallable* base)
{
	ValaSignal * self;
	ValaList* _tmp0_;
	ValaList* result = NULL;
	self = (ValaSignal*) base;
	_tmp0_ = self->priv->parameters;
	result = _tmp0_;
	return result;
}

/**
 * Returns generated delegate to be used for signal handlers.
 *
 * @return delegate
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

ValaDelegate*
vala_signal_get_delegate (ValaSignal* self,
                          ValaDataType* sender_type,
                          ValaCodeNode* node_reference)
{
	ValaDataType* actual_return_type = NULL;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDelegate* generated_delegate = NULL;
	ValaDataType* _tmp3_;
	ValaDelegate* _tmp4_;
	ValaDelegate* _tmp5_;
	ValaDelegate* _tmp6_;
	ValaScope* _tmp7_;
	ValaScope* _tmp8_;
	ValaDataType* sender_param_type = NULL;
	ValaDataType* _tmp9_;
	ValaDataType* _tmp10_;
	ValaDataType* _tmp11_;
	ValaDelegate* _tmp12_;
	ValaDataType* _tmp13_;
	gboolean is_generic = FALSE;
	ValaScope* _tmp76_;
	ValaScope* _tmp77_;
	ValaDelegate* _tmp78_;
	ValaDelegate* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sender_type != NULL, NULL);
	g_return_val_if_fail (node_reference != NULL, NULL);
	_tmp0_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_data_type_get_actual_type (_tmp1_, sender_type, NULL, node_reference);
	actual_return_type = _tmp2_;
	_tmp3_ = actual_return_type;
	_tmp4_ = vala_delegate_new (NULL, _tmp3_, NULL, NULL);
	generated_delegate = _tmp4_;
	_tmp5_ = generated_delegate;
	vala_symbol_set_access ((ValaSymbol*) _tmp5_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp6_ = generated_delegate;
	_tmp7_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp8_ = _tmp7_;
	vala_symbol_set_owner ((ValaSymbol*) _tmp6_, _tmp8_);
	_tmp9_ = vala_data_type_copy (sender_type);
	sender_param_type = _tmp9_;
	_tmp10_ = sender_param_type;
	vala_data_type_set_value_owned (_tmp10_, FALSE);
	_tmp11_ = sender_param_type;
	vala_data_type_set_nullable (_tmp11_, FALSE);
	_tmp12_ = generated_delegate;
	_tmp13_ = sender_param_type;
	vala_delegate_set_sender_type (_tmp12_, _tmp13_);
	is_generic = FALSE;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp14_;
		ValaList* _tmp15_;
		gint _param_size = 0;
		ValaList* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		gint _param_index = 0;
		_tmp14_ = self->priv->parameters;
		_tmp15_ = _vala_iterable_ref0 (_tmp14_);
		_param_list = _tmp15_;
		_tmp16_ = _param_list;
		_tmp17_ = vala_collection_get_size ((ValaCollection*) _tmp16_);
		_tmp18_ = _tmp17_;
		_param_size = _tmp18_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp19_;
			gpointer _tmp20_;
			ValaParameter* actual_param = NULL;
			ValaParameter* _tmp21_;
			ValaParameter* _tmp22_;
			ValaParameter* _tmp23_;
			ValaParameter* _tmp24_;
			ValaDataType* _tmp25_;
			ValaDataType* _tmp26_;
			ValaDataType* _tmp27_;
			ValaDataType* _tmp28_;
			ValaDelegate* _tmp29_;
			ValaParameter* _tmp30_;
			ValaParameter* _tmp31_;
			ValaDataType* _tmp32_;
			ValaDataType* _tmp33_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp19_ = _param_list;
			_tmp20_ = vala_list_get (_tmp19_, _param_index);
			param = (ValaParameter*) _tmp20_;
			_tmp21_ = param;
			_tmp22_ = vala_parameter_copy (_tmp21_);
			actual_param = _tmp22_;
			_tmp23_ = actual_param;
			_tmp24_ = actual_param;
			_tmp25_ = vala_variable_get_variable_type ((ValaVariable*) _tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = vala_data_type_get_actual_type (_tmp26_, sender_type, NULL, node_reference);
			_tmp28_ = _tmp27_;
			vala_variable_set_variable_type ((ValaVariable*) _tmp23_, _tmp28_);
			_vala_code_node_unref0 (_tmp28_);
			_tmp29_ = generated_delegate;
			_tmp30_ = actual_param;
			vala_callable_add_parameter ((ValaCallable*) _tmp29_, _tmp30_);
			_tmp31_ = actual_param;
			_tmp32_ = vala_variable_get_variable_type ((ValaVariable*) _tmp31_);
			_tmp33_ = _tmp32_;
			if (VALA_IS_GENERIC_TYPE (_tmp33_)) {
				is_generic = TRUE;
			}
			_vala_code_node_unref0 (actual_param);
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	if (is_generic) {
		ValaObjectTypeSymbol* cl = NULL;
		ValaSymbol* _tmp34_;
		ValaSymbol* _tmp35_;
		_tmp34_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp35_ = _tmp34_;
		cl = G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol);
		{
			ValaList* _type_param_list = NULL;
			ValaObjectTypeSymbol* _tmp36_;
			ValaList* _tmp37_;
			ValaList* _tmp38_;
			gint _type_param_size = 0;
			ValaList* _tmp39_;
			gint _tmp40_;
			gint _tmp41_;
			gint _type_param_index = 0;
			_tmp36_ = cl;
			_tmp37_ = vala_object_type_symbol_get_type_parameters (_tmp36_);
			_tmp38_ = _vala_iterable_ref0 (_tmp37_);
			_type_param_list = _tmp38_;
			_tmp39_ = _type_param_list;
			_tmp40_ = vala_collection_get_size ((ValaCollection*) _tmp39_);
			_tmp41_ = _tmp40_;
			_type_param_size = _tmp41_;
			_type_param_index = -1;
			while (TRUE) {
				ValaTypeParameter* type_param = NULL;
				ValaList* _tmp42_;
				gpointer _tmp43_;
				ValaDelegate* _tmp44_;
				ValaTypeParameter* _tmp45_;
				const gchar* _tmp46_;
				const gchar* _tmp47_;
				ValaTypeParameter* _tmp48_;
				ValaSourceReference* _tmp49_;
				ValaSourceReference* _tmp50_;
				ValaTypeParameter* _tmp51_;
				ValaTypeParameter* _tmp52_;
				_type_param_index = _type_param_index + 1;
				if (!(_type_param_index < _type_param_size)) {
					break;
				}
				_tmp42_ = _type_param_list;
				_tmp43_ = vala_list_get (_tmp42_, _type_param_index);
				type_param = (ValaTypeParameter*) _tmp43_;
				_tmp44_ = generated_delegate;
				_tmp45_ = type_param;
				_tmp46_ = vala_symbol_get_name ((ValaSymbol*) _tmp45_);
				_tmp47_ = _tmp46_;
				_tmp48_ = type_param;
				_tmp49_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp48_);
				_tmp50_ = _tmp49_;
				_tmp51_ = vala_typeparameter_new (_tmp47_, _tmp50_);
				_tmp52_ = _tmp51_;
				vala_delegate_add_type_parameter (_tmp44_, _tmp52_);
				_vala_code_node_unref0 (_tmp52_);
				_vala_code_node_unref0 (type_param);
			}
			_vala_iterable_unref0 (_type_param_list);
		}
		{
			ValaList* _param_list = NULL;
			ValaDelegate* _tmp53_;
			ValaList* _tmp54_;
			ValaList* _tmp55_;
			gint _param_size = 0;
			ValaList* _tmp56_;
			gint _tmp57_;
			gint _tmp58_;
			gint _param_index = 0;
			_tmp53_ = generated_delegate;
			_tmp54_ = vala_callable_get_parameters ((ValaCallable*) _tmp53_);
			_tmp55_ = _vala_iterable_ref0 (_tmp54_);
			_param_list = _tmp55_;
			_tmp56_ = _param_list;
			_tmp57_ = vala_collection_get_size ((ValaCollection*) _tmp56_);
			_tmp58_ = _tmp57_;
			_param_size = _tmp58_;
			_param_index = -1;
			while (TRUE) {
				ValaParameter* param = NULL;
				ValaList* _tmp59_;
				gpointer _tmp60_;
				ValaGenericType* generic_type = NULL;
				ValaParameter* _tmp61_;
				ValaDataType* _tmp62_;
				ValaDataType* _tmp63_;
				ValaGenericType* _tmp64_;
				_param_index = _param_index + 1;
				if (!(_param_index < _param_size)) {
					break;
				}
				_tmp59_ = _param_list;
				_tmp60_ = vala_list_get (_tmp59_, _param_index);
				param = (ValaParameter*) _tmp60_;
				_tmp61_ = param;
				_tmp62_ = vala_variable_get_variable_type ((ValaVariable*) _tmp61_);
				_tmp63_ = _tmp62_;
				generic_type = VALA_IS_GENERIC_TYPE (_tmp63_) ? ((ValaGenericType*) _tmp63_) : NULL;
				_tmp64_ = generic_type;
				if (_tmp64_ != NULL) {
					ValaGenericType* _tmp65_;
					ValaDelegate* _tmp66_;
					ValaList* _tmp67_;
					ValaDelegate* _tmp68_;
					ValaGenericType* _tmp69_;
					ValaTypeParameter* _tmp70_;
					ValaTypeParameter* _tmp71_;
					const gchar* _tmp72_;
					const gchar* _tmp73_;
					gpointer _tmp74_;
					ValaTypeParameter* _tmp75_;
					_tmp65_ = generic_type;
					_tmp66_ = generated_delegate;
					_tmp67_ = vala_delegate_get_type_parameters (_tmp66_);
					_tmp68_ = generated_delegate;
					_tmp69_ = generic_type;
					_tmp70_ = vala_generic_type_get_type_parameter (_tmp69_);
					_tmp71_ = _tmp70_;
					_tmp72_ = vala_symbol_get_name ((ValaSymbol*) _tmp71_);
					_tmp73_ = _tmp72_;
					_tmp74_ = vala_list_get (_tmp67_, vala_typesymbol_get_type_parameter_index ((ValaTypeSymbol*) _tmp68_, _tmp73_));
					_tmp75_ = (ValaTypeParameter*) _tmp74_;
					vala_generic_type_set_type_parameter (_tmp65_, _tmp75_);
					_vala_code_node_unref0 (_tmp75_);
				}
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
	}
	_tmp76_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp77_ = _tmp76_;
	_tmp78_ = generated_delegate;
	vala_scope_add (_tmp77_, NULL, (ValaSymbol*) _tmp78_);
	result = generated_delegate;
	_vala_code_node_unref0 (sender_param_type);
	_vala_code_node_unref0 (actual_return_type);
	return result;
}

static void
vala_signal_real_accept (ValaCodeNode* base,
                         ValaCodeVisitor* visitor)
{
	ValaSignal * self;
	self = (ValaSignal*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_signal (visitor, self);
}

static void
vala_signal_real_accept_children (ValaCodeNode* base,
                                  ValaCodeVisitor* visitor)
{
	ValaSignal * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	gboolean _tmp10_ = FALSE;
	ValaMethod* _tmp11_;
	ValaMethod* _tmp18_;
	self = (ValaSignal*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp2_;
		ValaList* _tmp3_;
		gint _param_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _param_index = 0;
		_tmp2_ = self->priv->parameters;
		_tmp3_ = _vala_iterable_ref0 (_tmp2_);
		_param_list = _tmp3_;
		_tmp4_ = _param_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_param_size = _tmp6_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaParameter* _tmp9_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp7_ = _param_list;
			_tmp8_ = vala_list_get (_tmp7_, _param_index);
			param = (ValaParameter*) _tmp8_;
			_tmp9_ = param;
			vala_code_node_accept ((ValaCodeNode*) _tmp9_, visitor);
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp11_ = self->priv->_default_handler;
	if (_tmp11_ == NULL) {
		ValaBlock* _tmp12_;
		ValaBlock* _tmp13_;
		_tmp12_ = vala_signal_get_body (self);
		_tmp13_ = _tmp12_;
		_tmp10_ = _tmp13_ != NULL;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		ValaBlock* _tmp14_;
		ValaBlock* _tmp15_;
		_tmp14_ = vala_signal_get_body (self);
		_tmp15_ = _tmp14_;
		vala_code_node_accept ((ValaCodeNode*) _tmp15_, visitor);
	} else {
		ValaMethod* _tmp16_;
		_tmp16_ = self->priv->_default_handler;
		if (_tmp16_ != NULL) {
			ValaMethod* _tmp17_;
			_tmp17_ = self->priv->_default_handler;
			vala_code_node_accept ((ValaCodeNode*) _tmp17_, visitor);
		}
	}
	_tmp18_ = self->priv->_emitter;
	if (_tmp18_ != NULL) {
		ValaMethod* _tmp19_;
		_tmp19_ = self->priv->_emitter;
		vala_code_node_accept ((ValaCodeNode*) _tmp19_, visitor);
	}
}

static void
vala_signal_real_replace_type (ValaCodeNode* base,
                               ValaDataType* old_type,
                               ValaDataType* new_type)
{
	ValaSignal * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaSignal*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_callable_set_return_type ((ValaCallable*) self, new_type);
	}
}

static gboolean
vala_signal_real_check (ValaCodeNode* base,
                        ValaCodeContext* context)
{
	ValaSignal * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaClass* parent_cl = NULL;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	gboolean _tmp6_ = FALSE;
	ValaClass* _tmp7_;
	ValaClass* _tmp13_;
	ValaDataType* _tmp34_;
	ValaDataType* _tmp35_;
	ValaDataType* _tmp36_;
	ValaDataType* _tmp37_;
	ValaTypeSymbol* _tmp38_;
	ValaTypeSymbol* _tmp39_;
	ValaSemanticAnalyzer* _tmp40_;
	ValaSemanticAnalyzer* _tmp41_;
	ValaDataType* _tmp42_;
	ValaTypeSymbol* _tmp43_;
	ValaTypeSymbol* _tmp44_;
	gboolean _tmp69_ = FALSE;
	gboolean _tmp70_;
	gboolean _tmp75_;
	ValaAttribute* _tmp115_;
	gboolean _tmp183_ = FALSE;
	gboolean _tmp184_ = FALSE;
	gboolean _tmp185_;
	gboolean _tmp186_;
	gboolean _tmp201_;
	gboolean _tmp202_;
	gboolean result = FALSE;
	self = (ValaSignal*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp5_ = _tmp4_;
	parent_cl = VALA_IS_CLASS (_tmp5_) ? ((ValaClass*) _tmp5_) : NULL;
	_tmp7_ = parent_cl;
	if (_tmp7_ != NULL) {
		ValaClass* _tmp8_;
		gboolean _tmp9_;
		gboolean _tmp10_;
		_tmp8_ = parent_cl;
		_tmp9_ = vala_class_get_is_compact (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp6_ = _tmp10_;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		ValaSourceReference* _tmp11_;
		ValaSourceReference* _tmp12_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp11_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp12_ = _tmp11_;
		vala_report_error (_tmp12_, "Signals are not supported in compact classes");
		result = FALSE;
		return result;
	}
	_tmp13_ = parent_cl;
	if (_tmp13_ != NULL) {
		{
			ValaList* _base_type_list = NULL;
			ValaClass* _tmp14_;
			ValaList* _tmp15_;
			ValaList* _tmp16_;
			gint _base_type_size = 0;
			ValaList* _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			gint _base_type_index = 0;
			_tmp14_ = parent_cl;
			_tmp15_ = vala_class_get_base_types (_tmp14_);
			_tmp16_ = _vala_iterable_ref0 (_tmp15_);
			_base_type_list = _tmp16_;
			_tmp17_ = _base_type_list;
			_tmp18_ = vala_collection_get_size ((ValaCollection*) _tmp17_);
			_tmp19_ = _tmp18_;
			_base_type_size = _tmp19_;
			_base_type_index = -1;
			while (TRUE) {
				ValaDataType* base_type = NULL;
				ValaList* _tmp20_;
				gpointer _tmp21_;
				ValaDataType* _tmp22_;
				ValaTypeSymbol* _tmp23_;
				ValaTypeSymbol* _tmp24_;
				const gchar* _tmp25_;
				const gchar* _tmp26_;
				ValaSymbol* _tmp27_;
				ValaSymbol* _tmp28_;
				gboolean _tmp29_;
				_base_type_index = _base_type_index + 1;
				if (!(_base_type_index < _base_type_size)) {
					break;
				}
				_tmp20_ = _base_type_list;
				_tmp21_ = vala_list_get (_tmp20_, _base_type_index);
				base_type = (ValaDataType*) _tmp21_;
				_tmp22_ = base_type;
				_tmp23_ = vala_data_type_get_type_symbol (_tmp22_);
				_tmp24_ = _tmp23_;
				_tmp25_ = vala_symbol_get_name ((ValaSymbol*) self);
				_tmp26_ = _tmp25_;
				_tmp27_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) _tmp24_, _tmp26_);
				_tmp28_ = _tmp27_;
				_tmp29_ = VALA_IS_SIGNAL (_tmp28_);
				_vala_code_node_unref0 (_tmp28_);
				if (_tmp29_) {
					ValaSourceReference* _tmp30_;
					ValaSourceReference* _tmp31_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp30_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp31_ = _tmp30_;
					vala_report_error (_tmp31_, "Signals with the same name as a signal in a base type are not supporte" \
"d");
					result = FALSE;
					_vala_code_node_unref0 (base_type);
					_vala_iterable_unref0 (_base_type_list);
					return result;
				}
				_vala_code_node_unref0 (base_type);
			}
			_vala_iterable_unref0 (_base_type_list);
		}
	}
	if (VALA_IS_DYNAMIC_SIGNAL (self)) {
		gboolean _tmp32_;
		gboolean _tmp33_;
		_tmp32_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp33_ = _tmp32_;
		result = !_tmp33_;
		return result;
	}
	_tmp34_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp35_ = _tmp34_;
	vala_code_node_check ((ValaCodeNode*) _tmp35_, context);
	_tmp36_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp37_ = _tmp36_;
	_tmp38_ = vala_data_type_get_type_symbol (_tmp37_);
	_tmp39_ = _tmp38_;
	_tmp40_ = vala_code_context_get_analyzer (context);
	_tmp41_ = _tmp40_;
	_tmp42_ = _tmp41_->va_list_type;
	_tmp43_ = vala_data_type_get_type_symbol (_tmp42_);
	_tmp44_ = _tmp43_;
	if (_tmp39_ == _tmp44_) {
		ValaSourceReference* _tmp45_;
		ValaSourceReference* _tmp46_;
		ValaDataType* _tmp47_;
		ValaDataType* _tmp48_;
		ValaTypeSymbol* _tmp49_;
		ValaTypeSymbol* _tmp50_;
		gchar* _tmp51_;
		gchar* _tmp52_;
		gchar* _tmp53_;
		gchar* _tmp54_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp45_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp46_ = _tmp45_;
		_tmp47_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp48_ = _tmp47_;
		_tmp49_ = vala_data_type_get_type_symbol (_tmp48_);
		_tmp50_ = _tmp49_;
		_tmp51_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp50_);
		_tmp52_ = _tmp51_;
		_tmp53_ = g_strdup_printf ("`%s' not supported as return type", _tmp52_);
		_tmp54_ = _tmp53_;
		vala_report_error (_tmp46_, _tmp54_);
		_g_free0 (_tmp54_);
		_g_free0 (_tmp52_);
		result = FALSE;
		return result;
	}
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp55_;
		ValaList* _tmp56_;
		gint _param_size = 0;
		ValaList* _tmp57_;
		gint _tmp58_;
		gint _tmp59_;
		gint _param_index = 0;
		_tmp55_ = self->priv->parameters;
		_tmp56_ = _vala_iterable_ref0 (_tmp55_);
		_param_list = _tmp56_;
		_tmp57_ = _param_list;
		_tmp58_ = vala_collection_get_size ((ValaCollection*) _tmp57_);
		_tmp59_ = _tmp58_;
		_param_size = _tmp59_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp60_;
			gpointer _tmp61_;
			ValaParameter* _tmp62_;
			gboolean _tmp63_;
			gboolean _tmp64_;
			ValaParameter* _tmp68_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp60_ = _param_list;
			_tmp61_ = vala_list_get (_tmp60_, _param_index);
			param = (ValaParameter*) _tmp61_;
			_tmp62_ = param;
			_tmp63_ = vala_parameter_get_ellipsis (_tmp62_);
			_tmp64_ = _tmp63_;
			if (_tmp64_) {
				ValaParameter* _tmp65_;
				ValaSourceReference* _tmp66_;
				ValaSourceReference* _tmp67_;
				_tmp65_ = param;
				_tmp66_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp65_);
				_tmp67_ = _tmp66_;
				vala_report_error (_tmp67_, "Signals with variable argument lists are not supported");
				result = FALSE;
				_vala_code_node_unref0 (param);
				_vala_iterable_unref0 (_param_list);
				return result;
			}
			_tmp68_ = param;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp68_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp70_ = self->priv->_is_virtual;
	if (!_tmp70_) {
		ValaBlock* _tmp71_;
		ValaBlock* _tmp72_;
		_tmp71_ = vala_signal_get_body (self);
		_tmp72_ = _tmp71_;
		_tmp69_ = _tmp72_ != NULL;
	} else {
		_tmp69_ = FALSE;
	}
	if (_tmp69_) {
		ValaSourceReference* _tmp73_;
		ValaSourceReference* _tmp74_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp73_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp74_ = _tmp73_;
		vala_report_error (_tmp74_, "Only virtual signals can have a default signal handler body");
	}
	_tmp75_ = self->priv->_is_virtual;
	if (_tmp75_) {
		const gchar* _tmp76_;
		const gchar* _tmp77_;
		ValaDataType* _tmp78_;
		ValaDataType* _tmp79_;
		ValaSourceReference* _tmp80_;
		ValaSourceReference* _tmp81_;
		ValaMethod* _tmp82_;
		ValaMethod* _tmp83_;
		ValaMethod* _tmp84_;
		ValaScope* _tmp85_;
		ValaScope* _tmp86_;
		ValaMethod* _tmp87_;
		ValaSymbolAccessibility _tmp88_;
		ValaSymbolAccessibility _tmp89_;
		ValaMethod* _tmp90_;
		gboolean _tmp91_;
		gboolean _tmp92_;
		ValaMethod* _tmp93_;
		gboolean _tmp94_;
		gboolean _tmp95_;
		ValaMethod* _tmp96_;
		ValaMethod* _tmp97_;
		ValaMethod* _tmp98_;
		ValaBlock* _tmp99_;
		ValaBlock* _tmp100_;
		ValaObjectTypeSymbol* cl = NULL;
		ValaSymbol* _tmp110_;
		ValaSymbol* _tmp111_;
		ValaObjectTypeSymbol* _tmp112_;
		ValaMethod* _tmp113_;
		ValaMethod* _tmp114_;
		_tmp76_ = vala_symbol_get_name ((ValaSymbol*) self);
		_tmp77_ = _tmp76_;
		_tmp78_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp79_ = _tmp78_;
		_tmp80_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp81_ = _tmp80_;
		_tmp82_ = vala_method_new (_tmp77_, _tmp79_, _tmp81_, NULL);
		_tmp83_ = _tmp82_;
		vala_signal_set_default_handler (self, _tmp83_);
		_vala_code_node_unref0 (_tmp83_);
		_tmp84_ = self->priv->_default_handler;
		_tmp85_ = vala_symbol_get_owner ((ValaSymbol*) self);
		_tmp86_ = _tmp85_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp84_, _tmp86_);
		_tmp87_ = self->priv->_default_handler;
		_tmp88_ = vala_symbol_get_access ((ValaSymbol*) self);
		_tmp89_ = _tmp88_;
		vala_symbol_set_access ((ValaSymbol*) _tmp87_, _tmp89_);
		_tmp90_ = self->priv->_default_handler;
		_tmp91_ = vala_symbol_get_external ((ValaSymbol*) self);
		_tmp92_ = _tmp91_;
		vala_symbol_set_external ((ValaSymbol*) _tmp90_, _tmp92_);
		_tmp93_ = self->priv->_default_handler;
		_tmp94_ = vala_symbol_get_hides ((ValaSymbol*) self);
		_tmp95_ = _tmp94_;
		vala_symbol_set_hides ((ValaSymbol*) _tmp93_, _tmp95_);
		_tmp96_ = self->priv->_default_handler;
		vala_method_set_is_virtual (_tmp96_, TRUE);
		_tmp97_ = self->priv->_default_handler;
		vala_method_set_signal_reference (_tmp97_, self);
		_tmp98_ = self->priv->_default_handler;
		_tmp99_ = vala_signal_get_body (self);
		_tmp100_ = _tmp99_;
		vala_subroutine_set_body ((ValaSubroutine*) _tmp98_, _tmp100_);
		{
			ValaList* _param_list = NULL;
			ValaList* _tmp101_;
			ValaList* _tmp102_;
			gint _param_size = 0;
			ValaList* _tmp103_;
			gint _tmp104_;
			gint _tmp105_;
			gint _param_index = 0;
			_tmp101_ = self->priv->parameters;
			_tmp102_ = _vala_iterable_ref0 (_tmp101_);
			_param_list = _tmp102_;
			_tmp103_ = _param_list;
			_tmp104_ = vala_collection_get_size ((ValaCollection*) _tmp103_);
			_tmp105_ = _tmp104_;
			_param_size = _tmp105_;
			_param_index = -1;
			while (TRUE) {
				ValaParameter* param = NULL;
				ValaList* _tmp106_;
				gpointer _tmp107_;
				ValaMethod* _tmp108_;
				ValaParameter* _tmp109_;
				_param_index = _param_index + 1;
				if (!(_param_index < _param_size)) {
					break;
				}
				_tmp106_ = _param_list;
				_tmp107_ = vala_list_get (_tmp106_, _param_index);
				param = (ValaParameter*) _tmp107_;
				_tmp108_ = self->priv->_default_handler;
				_tmp109_ = param;
				vala_callable_add_parameter ((ValaCallable*) _tmp108_, _tmp109_);
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		_tmp110_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp111_ = _tmp110_;
		cl = VALA_IS_OBJECT_TYPE_SYMBOL (_tmp111_) ? ((ValaObjectTypeSymbol*) _tmp111_) : NULL;
		_tmp112_ = cl;
		_tmp113_ = self->priv->_default_handler;
		vala_object_type_symbol_add_hidden_method (_tmp112_, _tmp113_);
		_tmp114_ = self->priv->_default_handler;
		vala_code_node_check ((ValaCodeNode*) _tmp114_, context);
	}
	_tmp115_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "HasEmitter");
	if (_tmp115_ != NULL) {
		const gchar* _tmp116_;
		const gchar* _tmp117_;
		ValaDataType* _tmp118_;
		ValaDataType* _tmp119_;
		ValaSourceReference* _tmp120_;
		ValaSourceReference* _tmp121_;
		ValaMethod* _tmp122_;
		ValaMethod* _tmp123_;
		ValaMethod* _tmp124_;
		ValaScope* _tmp125_;
		ValaScope* _tmp126_;
		ValaMethod* _tmp127_;
		ValaSymbolAccessibility _tmp128_;
		ValaSymbolAccessibility _tmp129_;
		ValaBlock* body = NULL;
		ValaSourceReference* _tmp130_;
		ValaSourceReference* _tmp131_;
		ValaBlock* _tmp132_;
		ValaMethodCall* call = NULL;
		const gchar* _tmp133_;
		const gchar* _tmp134_;
		ValaSourceReference* _tmp135_;
		ValaSourceReference* _tmp136_;
		ValaMemberAccess* _tmp137_;
		ValaMemberAccess* _tmp138_;
		ValaSourceReference* _tmp139_;
		ValaSourceReference* _tmp140_;
		ValaMethodCall* _tmp141_;
		ValaMethodCall* _tmp142_;
		ValaDataType* _tmp160_;
		ValaDataType* _tmp161_;
		ValaMethod* _tmp174_;
		ValaBlock* _tmp175_;
		ValaObjectTypeSymbol* cl = NULL;
		ValaSymbol* _tmp176_;
		ValaSymbol* _tmp177_;
		ValaObjectTypeSymbol* _tmp178_;
		ValaMethod* _tmp179_;
		gboolean _tmp180_;
		gboolean _tmp181_;
		_tmp116_ = vala_symbol_get_name ((ValaSymbol*) self);
		_tmp117_ = _tmp116_;
		_tmp118_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp119_ = _tmp118_;
		_tmp120_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp121_ = _tmp120_;
		_tmp122_ = vala_method_new (_tmp117_, _tmp119_, _tmp121_, NULL);
		_tmp123_ = _tmp122_;
		vala_signal_set_emitter (self, _tmp123_);
		_vala_code_node_unref0 (_tmp123_);
		_tmp124_ = self->priv->_emitter;
		_tmp125_ = vala_symbol_get_owner ((ValaSymbol*) self);
		_tmp126_ = _tmp125_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp124_, _tmp126_);
		_tmp127_ = self->priv->_emitter;
		_tmp128_ = vala_symbol_get_access ((ValaSymbol*) self);
		_tmp129_ = _tmp128_;
		vala_symbol_set_access ((ValaSymbol*) _tmp127_, _tmp129_);
		_tmp130_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp131_ = _tmp130_;
		_tmp132_ = vala_block_new (_tmp131_);
		body = _tmp132_;
		_tmp133_ = vala_symbol_get_name ((ValaSymbol*) self);
		_tmp134_ = _tmp133_;
		_tmp135_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp136_ = _tmp135_;
		_tmp137_ = vala_member_access_new_simple (_tmp134_, _tmp136_);
		_tmp138_ = _tmp137_;
		_tmp139_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp140_ = _tmp139_;
		_tmp141_ = vala_method_call_new ((ValaExpression*) _tmp138_, _tmp140_);
		_tmp142_ = _tmp141_;
		_vala_code_node_unref0 (_tmp138_);
		call = _tmp142_;
		{
			ValaList* _param_list = NULL;
			ValaList* _tmp143_;
			ValaList* _tmp144_;
			gint _param_size = 0;
			ValaList* _tmp145_;
			gint _tmp146_;
			gint _tmp147_;
			gint _param_index = 0;
			_tmp143_ = self->priv->parameters;
			_tmp144_ = _vala_iterable_ref0 (_tmp143_);
			_param_list = _tmp144_;
			_tmp145_ = _param_list;
			_tmp146_ = vala_collection_get_size ((ValaCollection*) _tmp145_);
			_tmp147_ = _tmp146_;
			_param_size = _tmp147_;
			_param_index = -1;
			while (TRUE) {
				ValaParameter* param = NULL;
				ValaList* _tmp148_;
				gpointer _tmp149_;
				ValaMethod* _tmp150_;
				ValaParameter* _tmp151_;
				ValaMethodCall* _tmp152_;
				ValaParameter* _tmp153_;
				const gchar* _tmp154_;
				const gchar* _tmp155_;
				ValaSourceReference* _tmp156_;
				ValaSourceReference* _tmp157_;
				ValaMemberAccess* _tmp158_;
				ValaMemberAccess* _tmp159_;
				_param_index = _param_index + 1;
				if (!(_param_index < _param_size)) {
					break;
				}
				_tmp148_ = _param_list;
				_tmp149_ = vala_list_get (_tmp148_, _param_index);
				param = (ValaParameter*) _tmp149_;
				_tmp150_ = self->priv->_emitter;
				_tmp151_ = param;
				vala_callable_add_parameter ((ValaCallable*) _tmp150_, _tmp151_);
				_tmp152_ = call;
				_tmp153_ = param;
				_tmp154_ = vala_symbol_get_name ((ValaSymbol*) _tmp153_);
				_tmp155_ = _tmp154_;
				_tmp156_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp157_ = _tmp156_;
				_tmp158_ = vala_member_access_new_simple (_tmp155_, _tmp157_);
				_tmp159_ = _tmp158_;
				vala_method_call_add_argument (_tmp152_, (ValaExpression*) _tmp159_);
				_vala_code_node_unref0 (_tmp159_);
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		_tmp160_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp161_ = _tmp160_;
		if (VALA_IS_VOID_TYPE (_tmp161_)) {
			ValaBlock* _tmp162_;
			ValaMethodCall* _tmp163_;
			ValaSourceReference* _tmp164_;
			ValaSourceReference* _tmp165_;
			ValaExpressionStatement* _tmp166_;
			ValaExpressionStatement* _tmp167_;
			_tmp162_ = body;
			_tmp163_ = call;
			_tmp164_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp165_ = _tmp164_;
			_tmp166_ = vala_expression_statement_new ((ValaExpression*) _tmp163_, _tmp165_);
			_tmp167_ = _tmp166_;
			vala_block_add_statement (_tmp162_, (ValaStatement*) _tmp167_);
			_vala_code_node_unref0 (_tmp167_);
		} else {
			ValaBlock* _tmp168_;
			ValaMethodCall* _tmp169_;
			ValaSourceReference* _tmp170_;
			ValaSourceReference* _tmp171_;
			ValaReturnStatement* _tmp172_;
			ValaReturnStatement* _tmp173_;
			_tmp168_ = body;
			_tmp169_ = call;
			_tmp170_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp171_ = _tmp170_;
			_tmp172_ = vala_return_statement_new ((ValaExpression*) _tmp169_, _tmp171_);
			_tmp173_ = _tmp172_;
			vala_block_add_statement (_tmp168_, (ValaStatement*) _tmp173_);
			_vala_code_node_unref0 (_tmp173_);
		}
		_tmp174_ = self->priv->_emitter;
		_tmp175_ = body;
		vala_subroutine_set_body ((ValaSubroutine*) _tmp174_, _tmp175_);
		_tmp176_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp177_ = _tmp176_;
		cl = VALA_IS_OBJECT_TYPE_SYMBOL (_tmp177_) ? ((ValaObjectTypeSymbol*) _tmp177_) : NULL;
		_tmp178_ = cl;
		_tmp179_ = self->priv->_emitter;
		vala_object_type_symbol_add_hidden_method (_tmp178_, _tmp179_);
		_tmp180_ = vala_symbol_get_external_package ((ValaSymbol*) self);
		_tmp181_ = _tmp180_;
		if (!_tmp181_) {
			ValaMethod* _tmp182_;
			_tmp182_ = self->priv->_emitter;
			vala_code_node_check ((ValaCodeNode*) _tmp182_, context);
		}
		_vala_code_node_unref0 (call);
		_vala_code_node_unref0 (body);
	}
	_tmp185_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp186_ = _tmp185_;
	if (!_tmp186_) {
		gboolean _tmp187_;
		gboolean _tmp188_;
		_tmp187_ = vala_symbol_get_hides ((ValaSymbol*) self);
		_tmp188_ = _tmp187_;
		_tmp184_ = !_tmp188_;
	} else {
		_tmp184_ = FALSE;
	}
	if (_tmp184_) {
		ValaSymbol* _tmp189_;
		ValaSymbol* _tmp190_;
		_tmp189_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp190_ = _tmp189_;
		_tmp183_ = _tmp190_ != NULL;
		_vala_code_node_unref0 (_tmp190_);
	} else {
		_tmp183_ = FALSE;
	}
	if (_tmp183_) {
		ValaSourceReference* _tmp191_;
		ValaSourceReference* _tmp192_;
		gchar* _tmp193_;
		gchar* _tmp194_;
		ValaSymbol* _tmp195_;
		ValaSymbol* _tmp196_;
		gchar* _tmp197_;
		gchar* _tmp198_;
		gchar* _tmp199_;
		gchar* _tmp200_;
		_tmp191_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp192_ = _tmp191_;
		_tmp193_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp194_ = _tmp193_;
		_tmp195_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp196_ = _tmp195_;
		_tmp197_ = vala_symbol_get_full_name (_tmp196_);
		_tmp198_ = _tmp197_;
		_tmp199_ = g_strdup_printf ("%s hides inherited signal `%s'. Use the `new' keyword if hiding was in" \
"tentional", _tmp194_, _tmp198_);
		_tmp200_ = _tmp199_;
		vala_report_warning (_tmp192_, _tmp200_);
		_g_free0 (_tmp200_);
		_g_free0 (_tmp198_);
		_vala_code_node_unref0 (_tmp196_);
		_g_free0 (_tmp194_);
	}
	_tmp201_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp202_ = _tmp201_;
	result = !_tmp202_;
	return result;
}

static void
vala_signal_class_init (ValaSignalClass * klass,
                        gpointer klass_data)
{
	vala_signal_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_signal_finalize;
	g_type_class_adjust_private_offset (klass, &ValaSignal_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_signal_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_signal_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_signal_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_signal_real_check;
}

static void
vala_signal_vala_callable_interface_init (ValaCallableIface * iface,
                                          gpointer iface_data)
{
	vala_signal_vala_callable_parent_iface = g_type_interface_peek_parent (iface);
	iface->add_parameter = (void (*) (ValaCallable*, ValaParameter*)) vala_signal_real_add_parameter;
	iface->get_parameters = (ValaList* (*) (ValaCallable*)) vala_signal_real_get_parameters;
	iface->get_return_type = vala_signal_real_get_return_type;
	iface->set_return_type = vala_signal_real_set_return_type;
}

static void
vala_signal_instance_init (ValaSignal * self,
                           gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_signal_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->parameters = (ValaList*) _tmp1_;
}

static void
vala_signal_finalize (ValaCodeNode * obj)
{
	ValaSignal * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_SIGNAL, ValaSignal);
	_vala_iterable_unref0 (self->priv->parameters);
	_vala_code_node_unref0 (self->priv->_default_handler);
	_vala_code_node_unref0 (self->priv->_emitter);
	_vala_code_node_unref0 (self->priv->_return_type);
	_vala_code_node_unref0 (self->priv->_body);
	VALA_CODE_NODE_CLASS (vala_signal_parent_class)->finalize (obj);
}

/**
 * Represents an object signal. Signals enable objects to provide notifications.
 */
static GType
vala_signal_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaSignalClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_signal_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaSignal), 0, (GInstanceInitFunc) vala_signal_instance_init, NULL };
	static const GInterfaceInfo vala_callable_info = { (GInterfaceInitFunc) vala_signal_vala_callable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType vala_signal_type_id;
	vala_signal_type_id = g_type_register_static (VALA_TYPE_SYMBOL, "ValaSignal", &g_define_type_info, 0);
	g_type_add_interface_static (vala_signal_type_id, VALA_TYPE_CALLABLE, &vala_callable_info);
	ValaSignal_private_offset = g_type_add_instance_private (vala_signal_type_id, sizeof (ValaSignalPrivate));
	return vala_signal_type_id;
}

GType
vala_signal_get_type (void)
{
	static volatile gsize vala_signal_type_id__volatile = 0;
	if (g_once_init_enter (&vala_signal_type_id__volatile)) {
		GType vala_signal_type_id;
		vala_signal_type_id = vala_signal_get_type_once ();
		g_once_init_leave (&vala_signal_type_id__volatile, vala_signal_type_id);
	}
	return vala_signal_type_id__volatile;
}

