/* valascanner.c generated by valac, the Vala compiler
 * generated from valascanner.vala, do not modify */

/* valascanner.vala
 *
 * Copyright (C) 2008-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Jukka-Pekka Iivonen <jp0409@jippii.fi>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>


#define VALA_TYPE_SCANNER (vala_scanner_get_type ())
#define VALA_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SCANNER, ValaScanner))
#define VALA_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SCANNER, ValaScannerClass))
#define VALA_IS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SCANNER))
#define VALA_IS_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SCANNER))
#define VALA_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SCANNER, ValaScannerClass))

typedef struct _ValaScanner ValaScanner;
typedef struct _ValaScannerClass ValaScannerClass;
typedef struct _ValaScannerPrivate ValaScannerPrivate;

#define VALA_TYPE_SOURCE_FILE (vala_source_file_get_type ())
#define VALA_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFile))
#define VALA_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))
#define VALA_IS_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_FILE))
#define VALA_IS_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_FILE))
#define VALA_SOURCE_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))

typedef struct _ValaSourceFile ValaSourceFile;
typedef struct _ValaSourceFileClass ValaSourceFileClass;

#define VALA_TYPE_TOKEN_TYPE (vala_token_type_get_type ())

#define VALA_TYPE_COMMENT (vala_comment_get_type ())
#define VALA_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_COMMENT, ValaComment))
#define VALA_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_COMMENT, ValaCommentClass))
#define VALA_IS_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_COMMENT))
#define VALA_IS_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_COMMENT))
#define VALA_COMMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_COMMENT, ValaCommentClass))

typedef struct _ValaComment ValaComment;
typedef struct _ValaCommentClass ValaCommentClass;

#define VALA_SCANNER_TYPE_CONDITIONAL (vala_scanner_conditional_get_type ())
typedef struct _ValaScannerConditional ValaScannerConditional;

#define VALA_SCANNER_TYPE_STATE (vala_scanner_state_get_type ())
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_comment_unref0(var) ((var == NULL) ? NULL : (var = (vala_comment_unref (var), NULL)))

#define VALA_TYPE_SOURCE_LOCATION (vala_source_location_get_type ())
typedef struct _ValaSourceLocation ValaSourceLocation;

#define VALA_TYPE_SOURCE_REFERENCE (vala_source_reference_get_type ())
#define VALA_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReference))
#define VALA_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))
#define VALA_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))

typedef struct _ValaSourceReference ValaSourceReference;
typedef struct _ValaSourceReferenceClass ValaSourceReferenceClass;
#define _vala_source_reference_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_reference_unref (var), NULL)))

#define VALA_TYPE_CODE_CONTEXT (vala_code_context_get_type ())
#define VALA_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContext))
#define VALA_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))
#define VALA_IS_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_CONTEXT))
#define VALA_IS_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_CONTEXT))
#define VALA_CODE_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))

typedef struct _ValaCodeContext ValaCodeContext;
typedef struct _ValaCodeContextClass ValaCodeContextClass;

#define VALA_TYPE_PROFILE (vala_profile_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ValaParamSpecScanner ValaParamSpecScanner;

struct _ValaScanner {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaScannerPrivate * priv;
};

struct _ValaScannerClass {
	GTypeClass parent_class;
	void (*finalize) (ValaScanner *self);
};

typedef enum  {
	VALA_TOKEN_TYPE_NONE,
	VALA_TOKEN_TYPE_ABSTRACT,
	VALA_TOKEN_TYPE_AS,
	VALA_TOKEN_TYPE_ASSIGN,
	VALA_TOKEN_TYPE_ASSIGN_ADD,
	VALA_TOKEN_TYPE_ASSIGN_BITWISE_AND,
	VALA_TOKEN_TYPE_ASSIGN_BITWISE_OR,
	VALA_TOKEN_TYPE_ASSIGN_BITWISE_XOR,
	VALA_TOKEN_TYPE_ASSIGN_DIV,
	VALA_TOKEN_TYPE_ASSIGN_MUL,
	VALA_TOKEN_TYPE_ASSIGN_PERCENT,
	VALA_TOKEN_TYPE_ASSIGN_SHIFT_LEFT,
	VALA_TOKEN_TYPE_ASSIGN_SUB,
	VALA_TOKEN_TYPE_ASYNC,
	VALA_TOKEN_TYPE_BASE,
	VALA_TOKEN_TYPE_BITWISE_AND,
	VALA_TOKEN_TYPE_BITWISE_OR,
	VALA_TOKEN_TYPE_BREAK,
	VALA_TOKEN_TYPE_CARRET,
	VALA_TOKEN_TYPE_CASE,
	VALA_TOKEN_TYPE_CATCH,
	VALA_TOKEN_TYPE_CHARACTER_LITERAL,
	VALA_TOKEN_TYPE_CLASS,
	VALA_TOKEN_TYPE_CLOSE_BRACE,
	VALA_TOKEN_TYPE_CLOSE_BRACKET,
	VALA_TOKEN_TYPE_CLOSE_PARENS,
	VALA_TOKEN_TYPE_CLOSE_REGEX_LITERAL,
	VALA_TOKEN_TYPE_CLOSE_TEMPLATE,
	VALA_TOKEN_TYPE_COLON,
	VALA_TOKEN_TYPE_COMMA,
	VALA_TOKEN_TYPE_CONST,
	VALA_TOKEN_TYPE_CONSTRUCT,
	VALA_TOKEN_TYPE_CONTINUE,
	VALA_TOKEN_TYPE_DEFAULT,
	VALA_TOKEN_TYPE_DELEGATE,
	VALA_TOKEN_TYPE_DELETE,
	VALA_TOKEN_TYPE_DIV,
	VALA_TOKEN_TYPE_DO,
	VALA_TOKEN_TYPE_DOUBLE_COLON,
	VALA_TOKEN_TYPE_DOT,
	VALA_TOKEN_TYPE_DYNAMIC,
	VALA_TOKEN_TYPE_ELLIPSIS,
	VALA_TOKEN_TYPE_ELSE,
	VALA_TOKEN_TYPE_ENUM,
	VALA_TOKEN_TYPE_ENSURES,
	VALA_TOKEN_TYPE_ERRORDOMAIN,
	VALA_TOKEN_TYPE_EOF,
	VALA_TOKEN_TYPE_EXTERN,
	VALA_TOKEN_TYPE_FALSE,
	VALA_TOKEN_TYPE_FINALLY,
	VALA_TOKEN_TYPE_FOR,
	VALA_TOKEN_TYPE_FOREACH,
	VALA_TOKEN_TYPE_GET,
	VALA_TOKEN_TYPE_HASH,
	VALA_TOKEN_TYPE_IDENTIFIER,
	VALA_TOKEN_TYPE_IF,
	VALA_TOKEN_TYPE_IN,
	VALA_TOKEN_TYPE_INLINE,
	VALA_TOKEN_TYPE_INTEGER_LITERAL,
	VALA_TOKEN_TYPE_INTERFACE,
	VALA_TOKEN_TYPE_INTERNAL,
	VALA_TOKEN_TYPE_INTERR,
	VALA_TOKEN_TYPE_IS,
	VALA_TOKEN_TYPE_LAMBDA,
	VALA_TOKEN_TYPE_LOCK,
	VALA_TOKEN_TYPE_MINUS,
	VALA_TOKEN_TYPE_NAMESPACE,
	VALA_TOKEN_TYPE_NEW,
	VALA_TOKEN_TYPE_NULL,
	VALA_TOKEN_TYPE_OUT,
	VALA_TOKEN_TYPE_OP_AND,
	VALA_TOKEN_TYPE_OP_COALESCING,
	VALA_TOKEN_TYPE_OP_DEC,
	VALA_TOKEN_TYPE_OP_EQ,
	VALA_TOKEN_TYPE_OP_GE,
	VALA_TOKEN_TYPE_OP_GT,
	VALA_TOKEN_TYPE_OP_INC,
	VALA_TOKEN_TYPE_OP_LE,
	VALA_TOKEN_TYPE_OP_LT,
	VALA_TOKEN_TYPE_OP_NE,
	VALA_TOKEN_TYPE_OP_NEG,
	VALA_TOKEN_TYPE_OP_OR,
	VALA_TOKEN_TYPE_OP_PTR,
	VALA_TOKEN_TYPE_OP_SHIFT_LEFT,
	VALA_TOKEN_TYPE_OPEN_BRACE,
	VALA_TOKEN_TYPE_OPEN_BRACKET,
	VALA_TOKEN_TYPE_OPEN_PARENS,
	VALA_TOKEN_TYPE_OPEN_REGEX_LITERAL,
	VALA_TOKEN_TYPE_OPEN_TEMPLATE,
	VALA_TOKEN_TYPE_OVERRIDE,
	VALA_TOKEN_TYPE_OWNED,
	VALA_TOKEN_TYPE_PARAMS,
	VALA_TOKEN_TYPE_PERCENT,
	VALA_TOKEN_TYPE_PLUS,
	VALA_TOKEN_TYPE_PRIVATE,
	VALA_TOKEN_TYPE_PROTECTED,
	VALA_TOKEN_TYPE_PUBLIC,
	VALA_TOKEN_TYPE_REAL_LITERAL,
	VALA_TOKEN_TYPE_REF,
	VALA_TOKEN_TYPE_REGEX_LITERAL,
	VALA_TOKEN_TYPE_REQUIRES,
	VALA_TOKEN_TYPE_RETURN,
	VALA_TOKEN_TYPE_SEALED,
	VALA_TOKEN_TYPE_SEMICOLON,
	VALA_TOKEN_TYPE_SET,
	VALA_TOKEN_TYPE_SIGNAL,
	VALA_TOKEN_TYPE_SIZEOF,
	VALA_TOKEN_TYPE_STAR,
	VALA_TOKEN_TYPE_STATIC,
	VALA_TOKEN_TYPE_STRING_LITERAL,
	VALA_TOKEN_TYPE_STRUCT,
	VALA_TOKEN_TYPE_SWITCH,
	VALA_TOKEN_TYPE_TEMPLATE_STRING_LITERAL,
	VALA_TOKEN_TYPE_THIS,
	VALA_TOKEN_TYPE_THROW,
	VALA_TOKEN_TYPE_THROWS,
	VALA_TOKEN_TYPE_TILDE,
	VALA_TOKEN_TYPE_TRUE,
	VALA_TOKEN_TYPE_TRY,
	VALA_TOKEN_TYPE_TYPEOF,
	VALA_TOKEN_TYPE_UNOWNED,
	VALA_TOKEN_TYPE_USING,
	VALA_TOKEN_TYPE_VAR,
	VALA_TOKEN_TYPE_VERBATIM_STRING_LITERAL,
	VALA_TOKEN_TYPE_VIRTUAL,
	VALA_TOKEN_TYPE_VOID,
	VALA_TOKEN_TYPE_VOLATILE,
	VALA_TOKEN_TYPE_WEAK,
	VALA_TOKEN_TYPE_WHILE,
	VALA_TOKEN_TYPE_YIELD
} ValaTokenType;

struct _ValaScannerConditional {
	gboolean matched;
	gboolean else_found;
	gboolean skip_section;
};

typedef enum  {
	VALA_SCANNER_STATE_PARENS,
	VALA_SCANNER_STATE_BRACE,
	VALA_SCANNER_STATE_BRACKET,
	VALA_SCANNER_STATE_TEMPLATE,
	VALA_SCANNER_STATE_TEMPLATE_PART,
	VALA_SCANNER_STATE_REGEX_LITERAL
} ValaScannerState;

struct _ValaScannerPrivate {
	ValaSourceFile* _source_file;
	ValaTokenType previous;
	gchar* current;
	gchar* end;
	gint line;
	gint column;
	ValaComment* _comment;
	ValaScannerConditional* conditional_stack;
	gint conditional_stack_length1;
	gint _conditional_stack_size_;
	ValaScannerState* state_stack;
	gint state_stack_length1;
	gint _state_stack_size_;
};

struct _ValaSourceLocation {
	gchar* pos;
	gint line;
	gint column;
};

typedef enum  {
	VALA_PROFILE_POSIX,
	VALA_PROFILE_GOBJECT,
	VALA_PROFILE_DOVA
} ValaProfile;

struct _ValaParamSpecScanner {
	GParamSpec parent_instance;
};


static gpointer vala_scanner_parent_class = NULL;

gpointer vala_scanner_ref (gpointer instance);
void vala_scanner_unref (gpointer instance);
GParamSpec* vala_param_spec_scanner (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_scanner (GValue* value, gpointer v_object);
void vala_value_take_scanner (GValue* value, gpointer v_object);
gpointer vala_value_get_scanner (const GValue* value);
GType vala_scanner_get_type (void) G_GNUC_CONST;
gpointer vala_source_file_ref (gpointer instance);
void vala_source_file_unref (gpointer instance);
GParamSpec* vala_param_spec_source_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_file (GValue* value, gpointer v_object);
void vala_value_take_source_file (GValue* value, gpointer v_object);
gpointer vala_value_get_source_file (const GValue* value);
GType vala_source_file_get_type (void) G_GNUC_CONST;
GType vala_token_type_get_type (void) G_GNUC_CONST;
gpointer vala_comment_ref (gpointer instance);
void vala_comment_unref (gpointer instance);
GParamSpec* vala_param_spec_comment (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_comment (GValue* value, gpointer v_object);
void vala_value_take_comment (GValue* value, gpointer v_object);
gpointer vala_value_get_comment (const GValue* value);
GType vala_comment_get_type (void) G_GNUC_CONST;
static GType vala_scanner_conditional_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static ValaScannerConditional* vala_scanner_conditional_dup (const ValaScannerConditional* self);
static void vala_scanner_conditional_free (ValaScannerConditional* self);
static GType vala_scanner_state_get_type (void) G_GNUC_UNUSED;
#define VALA_SCANNER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_SCANNER, ValaScannerPrivate))
enum  {
	VALA_SCANNER_DUMMY_PROPERTY
};
ValaScanner* vala_scanner_new (ValaSourceFile* source_file);
ValaScanner* vala_scanner_construct (GType object_type, ValaSourceFile* source_file);
static void vala_scanner_set_source_file (ValaScanner* self, ValaSourceFile* value);
gchar* vala_source_file_get_mapped_contents (ValaSourceFile* self);
gsize vala_source_file_get_mapped_length (ValaSourceFile* self);
GType vala_source_location_get_type (void) G_GNUC_CONST;
ValaSourceLocation* vala_source_location_dup (const ValaSourceLocation* self);
void vala_source_location_free (ValaSourceLocation* self);
void vala_scanner_seek (ValaScanner* self, ValaSourceLocation* location);
static gboolean vala_scanner_in_template (ValaScanner* self);
static gboolean vala_scanner_in_template_part (ValaScanner* self);
static gboolean vala_scanner_in_regex_literal (ValaScanner* self);
static gboolean vala_scanner_is_ident_char (ValaScanner* self, gchar c);
gpointer vala_source_reference_ref (gpointer instance);
void vala_source_reference_unref (gpointer instance);
GParamSpec* vala_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_reference (GValue* value, gpointer v_object);
void vala_value_take_source_reference (GValue* value, gpointer v_object);
gpointer vala_value_get_source_reference (const GValue* value);
GType vala_source_reference_get_type (void) G_GNUC_CONST;
static ValaSourceReference* vala_scanner_get_source_reference (ValaScanner* self, gint offset, gint length);
ValaSourceFile* vala_scanner_get_source_file (ValaScanner* self);
void vala_source_location_init (ValaSourceLocation *self, gchar* _pos, gint _line, gint _column);
ValaSourceReference* vala_source_reference_new (ValaSourceFile* _file, ValaSourceLocation* begin, ValaSourceLocation* end);
ValaSourceReference* vala_source_reference_construct (GType object_type, ValaSourceFile* _file, ValaSourceLocation* begin, ValaSourceLocation* end);
ValaTokenType vala_scanner_read_regex_token (ValaScanner* self, ValaSourceLocation* token_begin, ValaSourceLocation* token_end);
void vala_report_error (ValaSourceReference* source, const gchar* message);
ValaTokenType vala_scanner_read_token (ValaScanner* self, ValaSourceLocation* token_begin, ValaSourceLocation* token_end);
ValaTokenType vala_scanner_get_identifier_or_keyword (gchar* begin, gint len);
static gboolean vala_scanner_matches (gchar* begin, const gchar* keyword);
static ValaTokenType vala_scanner_read_number (ValaScanner* self);
ValaTokenType vala_scanner_read_template_token (ValaScanner* self, ValaSourceLocation* token_begin, ValaSourceLocation* token_end);
static void _vala_array_add13 (ValaScannerState** array, int* length, int* size, ValaScannerState value);
static void _vala_array_add14 (ValaScannerState** array, int* length, int* size, ValaScannerState value);
static void _vala_array_add15 (ValaScannerState** array, int* length, int* size, ValaScannerState value);
static void _vala_array_add16 (ValaScannerState** array, int* length, int* size, ValaScannerState value);
static void vala_scanner_space (ValaScanner* self);
gpointer vala_code_context_ref (gpointer instance);
void vala_code_context_unref (gpointer instance);
GParamSpec* vala_param_spec_code_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_context (GValue* value, gpointer v_object);
void vala_value_take_code_context (GValue* value, gpointer v_object);
gpointer vala_value_get_code_context (const GValue* value);
GType vala_code_context_get_type (void) G_GNUC_CONST;
ValaCodeContext* vala_source_file_get_context (ValaSourceFile* self);
GType vala_profile_get_type (void) G_GNUC_CONST;
ValaProfile vala_code_context_get_profile (ValaCodeContext* self);
static void _vala_array_add17 (ValaScannerState** array, int* length, int* size, ValaScannerState value);
static void _vala_array_add18 (ValaScannerState** array, int* length, int* size, ValaScannerState value);
static void _vala_array_add19 (ValaScannerState** array, int* length, int* size, ValaScannerState value);
static void _vala_array_add20 (ValaScannerState** array, int* length, int* size, ValaScannerState value);
static void _vala_array_add21 (ValaScannerState** array, int* length, int* size, ValaScannerState value);
static void _vala_array_add22 (ValaScannerState** array, int* length, int* size, ValaScannerState value);
static gboolean vala_scanner_pp_whitespace (ValaScanner* self);
static void vala_scanner_pp_directive (ValaScanner* self);
static void vala_scanner_parse_pp_if (ValaScanner* self);
static void vala_scanner_parse_pp_elif (ValaScanner* self);
static void vala_scanner_parse_pp_else (ValaScanner* self);
static void vala_scanner_parse_pp_endif (ValaScanner* self);
static void vala_scanner_pp_eol (ValaScanner* self);
static gboolean vala_scanner_parse_pp_expression (ValaScanner* self);
static void _vala_array_add23 (ValaScannerConditional** array, int* length, int* size, const ValaScannerConditional* value);
static gboolean vala_scanner_parse_pp_symbol (ValaScanner* self);
gboolean vala_code_context_is_defined (ValaCodeContext* self, const gchar* define);
static gboolean vala_scanner_parse_pp_primary_expression (ValaScanner* self);
static gboolean vala_scanner_parse_pp_unary_expression (ValaScanner* self);
static gboolean vala_scanner_parse_pp_equality_expression (ValaScanner* self);
static gboolean vala_scanner_parse_pp_and_expression (ValaScanner* self);
static gboolean vala_scanner_parse_pp_or_expression (ValaScanner* self);
static gboolean vala_scanner_whitespace (ValaScanner* self);
static gboolean vala_scanner_comment (ValaScanner* self, gboolean file_comment);
static void vala_scanner_push_comment (ValaScanner* self, const gchar* comment_item, ValaSourceReference* source_reference, gboolean file_comment);
void vala_scanner_parse_file_comments (ValaScanner* self);
void vala_source_file_add_comment (ValaSourceFile* self, ValaComment* comment);
ValaComment* vala_comment_new (const gchar* comment, ValaSourceReference* _source_reference);
ValaComment* vala_comment_construct (GType object_type, const gchar* comment, ValaSourceReference* _source_reference);
ValaComment* vala_scanner_pop_comment (ValaScanner* self);
static void vala_scanner_finalize (ValaScanner* obj);


static GType vala_scanner_state_get_type (void) {
	static volatile gsize vala_scanner_state_type_id__volatile = 0;
	if (g_once_init_enter (&vala_scanner_state_type_id__volatile)) {
		static const GEnumValue values[] = {{VALA_SCANNER_STATE_PARENS, "VALA_SCANNER_STATE_PARENS", "parens"}, {VALA_SCANNER_STATE_BRACE, "VALA_SCANNER_STATE_BRACE", "brace"}, {VALA_SCANNER_STATE_BRACKET, "VALA_SCANNER_STATE_BRACKET", "bracket"}, {VALA_SCANNER_STATE_TEMPLATE, "VALA_SCANNER_STATE_TEMPLATE", "template"}, {VALA_SCANNER_STATE_TEMPLATE_PART, "VALA_SCANNER_STATE_TEMPLATE_PART", "template-part"}, {VALA_SCANNER_STATE_REGEX_LITERAL, "VALA_SCANNER_STATE_REGEX_LITERAL", "regex-literal"}, {0, NULL, NULL}};
		GType vala_scanner_state_type_id;
		vala_scanner_state_type_id = g_enum_register_static ("ValaScannerState", values);
		g_once_init_leave (&vala_scanner_state_type_id__volatile, vala_scanner_state_type_id);
	}
	return vala_scanner_state_type_id__volatile;
}


ValaScanner* vala_scanner_construct (GType object_type, ValaSourceFile* source_file) {
	ValaScanner* self = NULL;
	ValaSourceFile* _tmp0_;
	ValaSourceFile* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* begin;
	ValaSourceFile* _tmp3_;
	gsize _tmp4_ = 0UL;
	g_return_val_if_fail (source_file != NULL, NULL);
	self = (ValaScanner*) g_type_create_instance (object_type);
	_tmp0_ = source_file;
	vala_scanner_set_source_file (self, _tmp0_);
	_tmp1_ = source_file;
	_tmp2_ = vala_source_file_get_mapped_contents (_tmp1_);
	begin = _tmp2_;
	_tmp3_ = source_file;
	_tmp4_ = vala_source_file_get_mapped_length (_tmp3_);
	self->priv->end = begin + _tmp4_;
	self->priv->current = begin;
	self->priv->line = 1;
	self->priv->column = 1;
	return self;
}


ValaScanner* vala_scanner_new (ValaSourceFile* source_file) {
	return vala_scanner_construct (VALA_TYPE_SCANNER, source_file);
}


void vala_scanner_seek (ValaScanner* self, ValaSourceLocation* location) {
	ValaSourceLocation _tmp0_;
	gchar* _tmp1_;
	ValaSourceLocation _tmp2_;
	gint _tmp3_;
	ValaSourceLocation _tmp4_;
	gint _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (location != NULL);
	_tmp0_ = *location;
	_tmp1_ = _tmp0_.pos;
	self->priv->current = _tmp1_;
	_tmp2_ = *location;
	_tmp3_ = _tmp2_.line;
	self->priv->line = _tmp3_;
	_tmp4_ = *location;
	_tmp5_ = _tmp4_.column;
	self->priv->column = _tmp5_;
	self->priv->conditional_stack = (g_free (self->priv->conditional_stack), NULL);
	self->priv->conditional_stack = NULL;
	self->priv->conditional_stack_length1 = 0;
	self->priv->_conditional_stack_size_ = self->priv->conditional_stack_length1;
	self->priv->state_stack = (g_free (self->priv->state_stack), NULL);
	self->priv->state_stack = NULL;
	self->priv->state_stack_length1 = 0;
	self->priv->_state_stack_size_ = self->priv->state_stack_length1;
}


static gboolean vala_scanner_in_template (ValaScanner* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaScannerState* _tmp1_;
	gint _tmp1__length1;
	gboolean _tmp5_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->state_stack;
	_tmp1__length1 = self->priv->state_stack_length1;
	if (_tmp1__length1 > 0) {
		ValaScannerState* _tmp2_;
		gint _tmp2__length1;
		ValaScannerState* _tmp3_;
		gint _tmp3__length1;
		ValaScannerState _tmp4_;
		_tmp2_ = self->priv->state_stack;
		_tmp2__length1 = self->priv->state_stack_length1;
		_tmp3_ = self->priv->state_stack;
		_tmp3__length1 = self->priv->state_stack_length1;
		_tmp4_ = _tmp2_[_tmp3__length1 - 1];
		_tmp0_ = _tmp4_ == VALA_SCANNER_STATE_TEMPLATE;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp5_ = _tmp0_;
	result = _tmp5_;
	return result;
}


static gboolean vala_scanner_in_template_part (ValaScanner* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaScannerState* _tmp1_;
	gint _tmp1__length1;
	gboolean _tmp5_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->state_stack;
	_tmp1__length1 = self->priv->state_stack_length1;
	if (_tmp1__length1 > 0) {
		ValaScannerState* _tmp2_;
		gint _tmp2__length1;
		ValaScannerState* _tmp3_;
		gint _tmp3__length1;
		ValaScannerState _tmp4_;
		_tmp2_ = self->priv->state_stack;
		_tmp2__length1 = self->priv->state_stack_length1;
		_tmp3_ = self->priv->state_stack;
		_tmp3__length1 = self->priv->state_stack_length1;
		_tmp4_ = _tmp2_[_tmp3__length1 - 1];
		_tmp0_ = _tmp4_ == VALA_SCANNER_STATE_TEMPLATE_PART;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp5_ = _tmp0_;
	result = _tmp5_;
	return result;
}


static gboolean vala_scanner_in_regex_literal (ValaScanner* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaScannerState* _tmp1_;
	gint _tmp1__length1;
	gboolean _tmp5_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->state_stack;
	_tmp1__length1 = self->priv->state_stack_length1;
	if (_tmp1__length1 > 0) {
		ValaScannerState* _tmp2_;
		gint _tmp2__length1;
		ValaScannerState* _tmp3_;
		gint _tmp3__length1;
		ValaScannerState _tmp4_;
		_tmp2_ = self->priv->state_stack;
		_tmp2__length1 = self->priv->state_stack_length1;
		_tmp3_ = self->priv->state_stack;
		_tmp3__length1 = self->priv->state_stack_length1;
		_tmp4_ = _tmp2_[_tmp3__length1 - 1];
		_tmp0_ = _tmp4_ == VALA_SCANNER_STATE_REGEX_LITERAL;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp5_ = _tmp0_;
	result = _tmp5_;
	return result;
}


static gboolean vala_scanner_is_ident_char (ValaScanner* self, gchar c) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gchar _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = c;
	_tmp2_ = g_ascii_isalnum (_tmp1_);
	if (_tmp2_) {
		_tmp0_ = TRUE;
	} else {
		gchar _tmp3_;
		_tmp3_ = c;
		_tmp0_ = _tmp3_ == '_';
	}
	_tmp4_ = _tmp0_;
	result = _tmp4_;
	return result;
}


static ValaSourceReference* vala_scanner_get_source_reference (ValaScanner* self, gint offset, gint length) {
	ValaSourceReference* result = NULL;
	ValaSourceFile* _tmp0_;
	gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	ValaSourceLocation _tmp5_ = {0};
	gchar* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	ValaSourceLocation _tmp12_ = {0};
	ValaSourceReference* _tmp13_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_source_file;
	_tmp1_ = self->priv->current;
	_tmp2_ = self->priv->line;
	_tmp3_ = self->priv->column;
	_tmp4_ = offset;
	vala_source_location_init (&_tmp5_, _tmp1_, _tmp2_, _tmp3_ + _tmp4_);
	_tmp6_ = self->priv->current;
	_tmp7_ = length;
	_tmp8_ = self->priv->line;
	_tmp9_ = self->priv->column;
	_tmp10_ = offset;
	_tmp11_ = length;
	vala_source_location_init (&_tmp12_, _tmp6_ + _tmp7_, _tmp8_, (_tmp9_ + _tmp10_) + _tmp11_);
	_tmp13_ = vala_source_reference_new (_tmp0_, &_tmp5_, &_tmp12_);
	result = _tmp13_;
	return result;
}


ValaTokenType vala_scanner_read_regex_token (ValaScanner* self, ValaSourceLocation* token_begin, ValaSourceLocation* token_end) {
	ValaSourceLocation _vala_token_begin = {0};
	ValaSourceLocation _vala_token_end = {0};
	ValaTokenType result = 0;
	ValaTokenType type = 0;
	gchar* _tmp0_;
	gchar* begin;
	gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint token_length_in_chars;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gint _tmp102_;
	gchar* _tmp108_;
	gint _tmp109_;
	gint _tmp110_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->current;
	begin = _tmp0_;
	_tmp1_ = begin;
	_tmp2_ = self->priv->line;
	_tmp3_ = self->priv->column;
	vala_source_location_init (&_vala_token_begin, _tmp1_, _tmp2_, _tmp3_);
	token_length_in_chars = -1;
	_tmp4_ = self->priv->current;
	_tmp5_ = self->priv->end;
	if (_tmp4_ >= _tmp5_) {
		type = VALA_TOKEN_TYPE_EOF;
	} else {
		gchar* _tmp6_;
		gchar _tmp7_;
		_tmp6_ = self->priv->current;
		_tmp7_ = _tmp6_[0];
		switch (_tmp7_) {
			case '/':
			{
				gchar* _tmp8_;
				gint _tmp9_;
				gboolean fl_i;
				gboolean fl_s;
				gboolean fl_m;
				gboolean fl_x;
				type = VALA_TOKEN_TYPE_CLOSE_REGEX_LITERAL;
				_tmp8_ = self->priv->current;
				self->priv->current = _tmp8_ + 1;
				_tmp9_ = self->priv->state_stack_length1;
				self->priv->state_stack_length1 = _tmp9_ - 1;
				fl_i = FALSE;
				fl_s = FALSE;
				fl_m = FALSE;
				fl_x = FALSE;
				while (TRUE) {
					gboolean _tmp10_ = FALSE;
					gboolean _tmp11_ = FALSE;
					gboolean _tmp12_ = FALSE;
					gchar* _tmp13_;
					gchar _tmp14_;
					gboolean _tmp17_;
					gboolean _tmp20_;
					gboolean _tmp23_;
					gchar* _tmp24_;
					gchar _tmp25_;
					gchar* _tmp42_;
					gint _tmp43_;
					_tmp13_ = self->priv->current;
					_tmp14_ = _tmp13_[0];
					if (_tmp14_ == 'i') {
						_tmp12_ = TRUE;
					} else {
						gchar* _tmp15_;
						gchar _tmp16_;
						_tmp15_ = self->priv->current;
						_tmp16_ = _tmp15_[0];
						_tmp12_ = _tmp16_ == 's';
					}
					_tmp17_ = _tmp12_;
					if (_tmp17_) {
						_tmp11_ = TRUE;
					} else {
						gchar* _tmp18_;
						gchar _tmp19_;
						_tmp18_ = self->priv->current;
						_tmp19_ = _tmp18_[0];
						_tmp11_ = _tmp19_ == 'm';
					}
					_tmp20_ = _tmp11_;
					if (_tmp20_) {
						_tmp10_ = TRUE;
					} else {
						gchar* _tmp21_;
						gchar _tmp22_;
						_tmp21_ = self->priv->current;
						_tmp22_ = _tmp21_[0];
						_tmp10_ = _tmp22_ == 'x';
					}
					_tmp23_ = _tmp10_;
					if (!_tmp23_) {
						break;
					}
					_tmp24_ = self->priv->current;
					_tmp25_ = _tmp24_[0];
					switch (_tmp25_) {
						case 'i':
						{
							gboolean _tmp26_;
							_tmp26_ = fl_i;
							if (_tmp26_) {
								gint _tmp27_;
								ValaSourceReference* _tmp28_ = NULL;
								ValaSourceReference* _tmp29_;
								_tmp27_ = token_length_in_chars;
								_tmp28_ = vala_scanner_get_source_reference (self, _tmp27_, 0);
								_tmp29_ = _tmp28_;
								vala_report_error (_tmp29_, "modifier 'i' used more than once");
								_vala_source_reference_unref0 (_tmp29_);
							}
							fl_i = TRUE;
							break;
						}
						case 's':
						{
							gboolean _tmp30_;
							_tmp30_ = fl_s;
							if (_tmp30_) {
								gint _tmp31_;
								ValaSourceReference* _tmp32_ = NULL;
								ValaSourceReference* _tmp33_;
								_tmp31_ = token_length_in_chars;
								_tmp32_ = vala_scanner_get_source_reference (self, _tmp31_, 0);
								_tmp33_ = _tmp32_;
								vala_report_error (_tmp33_, "modifier 's' used more than once");
								_vala_source_reference_unref0 (_tmp33_);
							}
							fl_s = TRUE;
							break;
						}
						case 'm':
						{
							gboolean _tmp34_;
							_tmp34_ = fl_m;
							if (_tmp34_) {
								gint _tmp35_;
								ValaSourceReference* _tmp36_ = NULL;
								ValaSourceReference* _tmp37_;
								_tmp35_ = token_length_in_chars;
								_tmp36_ = vala_scanner_get_source_reference (self, _tmp35_, 0);
								_tmp37_ = _tmp36_;
								vala_report_error (_tmp37_, "modifier 'm' used more than once");
								_vala_source_reference_unref0 (_tmp37_);
							}
							fl_m = TRUE;
							break;
						}
						case 'x':
						{
							gboolean _tmp38_;
							_tmp38_ = fl_x;
							if (_tmp38_) {
								gint _tmp39_;
								ValaSourceReference* _tmp40_ = NULL;
								ValaSourceReference* _tmp41_;
								_tmp39_ = token_length_in_chars;
								_tmp40_ = vala_scanner_get_source_reference (self, _tmp39_, 0);
								_tmp41_ = _tmp40_;
								vala_report_error (_tmp41_, "modifier 'x' used more than once");
								_vala_source_reference_unref0 (_tmp41_);
							}
							fl_x = TRUE;
							break;
						}
						default:
						break;
					}
					_tmp42_ = self->priv->current;
					self->priv->current = _tmp42_ + 1;
					_tmp43_ = token_length_in_chars;
					token_length_in_chars = _tmp43_ + 1;
				}
				break;
			}
			default:
			{
				gboolean _tmp89_ = FALSE;
				gchar* _tmp90_;
				gchar* _tmp91_;
				gboolean _tmp94_;
				type = VALA_TOKEN_TYPE_REGEX_LITERAL;
				token_length_in_chars = 0;
				while (TRUE) {
					gboolean _tmp44_ = FALSE;
					gchar* _tmp45_;
					gchar* _tmp46_;
					gboolean _tmp49_;
					gchar* _tmp50_;
					gchar _tmp51_;
					_tmp45_ = self->priv->current;
					_tmp46_ = self->priv->end;
					if (_tmp45_ < _tmp46_) {
						gchar* _tmp47_;
						gchar _tmp48_;
						_tmp47_ = self->priv->current;
						_tmp48_ = _tmp47_[0];
						_tmp44_ = _tmp48_ != '/';
					} else {
						_tmp44_ = FALSE;
					}
					_tmp49_ = _tmp44_;
					if (!_tmp49_) {
						break;
					}
					_tmp50_ = self->priv->current;
					_tmp51_ = _tmp50_[0];
					if (_tmp51_ == '\\') {
						gchar* _tmp52_;
						gint _tmp53_;
						gchar* _tmp54_;
						gchar* _tmp55_;
						gchar* _tmp56_;
						gchar _tmp57_;
						_tmp52_ = self->priv->current;
						self->priv->current = _tmp52_ + 1;
						_tmp53_ = token_length_in_chars;
						token_length_in_chars = _tmp53_ + 1;
						_tmp54_ = self->priv->current;
						_tmp55_ = self->priv->end;
						if (_tmp54_ >= _tmp55_) {
							break;
						}
						_tmp56_ = self->priv->current;
						_tmp57_ = _tmp56_[0];
						switch (_tmp57_) {
							case '\'':
							case '"':
							case '\\':
							case '/':
							case '^':
							case '$':
							case '.':
							case '[':
							case ']':
							case '{':
							case '}':
							case '(':
							case ')':
							case '?':
							case '*':
							case '+':
							case '-':
							case '#':
							case '&':
							case '~':
							case ':':
							case ';':
							case '<':
							case '>':
							case '|':
							case '%':
							case '=':
							case '@':
							case '0':
							case 'b':
							case 'B':
							case 'f':
							case 'n':
							case 'r':
							case 't':
							case 'a':
							case 'A':
							case 'p':
							case 'P':
							case 'e':
							case 'd':
							case 'D':
							case 's':
							case 'S':
							case 'w':
							case 'W':
							case 'G':
							case 'z':
							case 'Z':
							{
								gchar* _tmp58_;
								gint _tmp59_;
								_tmp58_ = self->priv->current;
								self->priv->current = _tmp58_ + 1;
								_tmp59_ = token_length_in_chars;
								token_length_in_chars = _tmp59_ + 1;
								break;
							}
							case 'x':
							{
								gchar* _tmp60_;
								gint _tmp61_;
								_tmp60_ = self->priv->current;
								self->priv->current = _tmp60_ + 1;
								_tmp61_ = token_length_in_chars;
								token_length_in_chars = _tmp61_ + 1;
								while (TRUE) {
									gboolean _tmp62_ = FALSE;
									gchar* _tmp63_;
									gchar* _tmp64_;
									gboolean _tmp68_;
									gchar* _tmp69_;
									gint _tmp70_;
									_tmp63_ = self->priv->current;
									_tmp64_ = self->priv->end;
									if (_tmp63_ < _tmp64_) {
										gchar* _tmp65_;
										gchar _tmp66_;
										gboolean _tmp67_ = FALSE;
										_tmp65_ = self->priv->current;
										_tmp66_ = _tmp65_[0];
										_tmp67_ = g_ascii_isxdigit (_tmp66_);
										_tmp62_ = _tmp67_;
									} else {
										_tmp62_ = FALSE;
									}
									_tmp68_ = _tmp62_;
									if (!_tmp68_) {
										break;
									}
									_tmp69_ = self->priv->current;
									self->priv->current = _tmp69_ + 1;
									_tmp70_ = token_length_in_chars;
									token_length_in_chars = _tmp70_ + 1;
								}
								break;
							}
							default:
							{
								gint _tmp71_;
								ValaSourceReference* _tmp72_ = NULL;
								ValaSourceReference* _tmp73_;
								_tmp71_ = token_length_in_chars;
								_tmp72_ = vala_scanner_get_source_reference (self, _tmp71_, 0);
								_tmp73_ = _tmp72_;
								vala_report_error (_tmp73_, "invalid escape sequence");
								_vala_source_reference_unref0 (_tmp73_);
								break;
							}
						}
					} else {
						gchar* _tmp74_;
						gchar _tmp75_;
						_tmp74_ = self->priv->current;
						_tmp75_ = _tmp74_[0];
						if (_tmp75_ == '\n') {
							break;
						} else {
							gchar* _tmp76_;
							gchar* _tmp77_;
							gchar* _tmp78_;
							gunichar _tmp79_ = 0U;
							gunichar u;
							gunichar _tmp80_;
							_tmp76_ = self->priv->current;
							_tmp77_ = self->priv->end;
							_tmp78_ = self->priv->current;
							_tmp79_ = g_utf8_get_char_validated ((const gchar*) _tmp76_, (gssize) ((glong) (_tmp77_ - _tmp78_)));
							u = _tmp79_;
							_tmp80_ = u;
							if (_tmp80_ != ((gunichar) (-1))) {
								gchar* _tmp81_;
								gunichar _tmp82_;
								gint _tmp83_ = 0;
								gint _tmp84_;
								_tmp81_ = self->priv->current;
								_tmp82_ = u;
								_tmp83_ = g_unichar_to_utf8 (_tmp82_, NULL);
								self->priv->current = _tmp81_ + _tmp83_;
								_tmp84_ = token_length_in_chars;
								token_length_in_chars = _tmp84_ + 1;
							} else {
								gchar* _tmp85_;
								gint _tmp86_;
								ValaSourceReference* _tmp87_ = NULL;
								ValaSourceReference* _tmp88_;
								_tmp85_ = self->priv->current;
								self->priv->current = _tmp85_ + 1;
								_tmp86_ = token_length_in_chars;
								_tmp87_ = vala_scanner_get_source_reference (self, _tmp86_, 0);
								_tmp88_ = _tmp87_;
								vala_report_error (_tmp88_, "invalid UTF-8 character");
								_vala_source_reference_unref0 (_tmp88_);
							}
						}
					}
				}
				_tmp90_ = self->priv->current;
				_tmp91_ = self->priv->end;
				if (_tmp90_ >= _tmp91_) {
					_tmp89_ = TRUE;
				} else {
					gchar* _tmp92_;
					gchar _tmp93_;
					_tmp92_ = self->priv->current;
					_tmp93_ = _tmp92_[0];
					_tmp89_ = _tmp93_ == '\n';
				}
				_tmp94_ = _tmp89_;
				if (_tmp94_) {
					gint _tmp95_;
					ValaSourceReference* _tmp96_ = NULL;
					ValaSourceReference* _tmp97_;
					gint _tmp98_;
					ValaSourceLocation _tmp99_ = {0};
					ValaSourceLocation _tmp100_ = {0};
					ValaTokenType _tmp101_ = 0;
					_tmp95_ = token_length_in_chars;
					_tmp96_ = vala_scanner_get_source_reference (self, _tmp95_, 0);
					_tmp97_ = _tmp96_;
					vala_report_error (_tmp97_, "syntax error, expected \"");
					_vala_source_reference_unref0 (_tmp97_);
					_tmp98_ = self->priv->state_stack_length1;
					self->priv->state_stack_length1 = _tmp98_ - 1;
					_tmp101_ = vala_scanner_read_token (self, &_tmp99_, &_tmp100_);
					_vala_token_begin = _tmp99_;
					_vala_token_end = _tmp100_;
					result = _tmp101_;
					if (token_begin) {
						*token_begin = _vala_token_begin;
					}
					if (token_end) {
						*token_end = _vala_token_end;
					}
					return result;
				}
				break;
			}
		}
	}
	_tmp102_ = token_length_in_chars;
	if (_tmp102_ < 0) {
		gint _tmp103_;
		gchar* _tmp104_;
		gchar* _tmp105_;
		_tmp103_ = self->priv->column;
		_tmp104_ = self->priv->current;
		_tmp105_ = begin;
		self->priv->column = _tmp103_ + ((gint) (_tmp104_ - _tmp105_));
	} else {
		gint _tmp106_;
		gint _tmp107_;
		_tmp106_ = self->priv->column;
		_tmp107_ = token_length_in_chars;
		self->priv->column = _tmp106_ + _tmp107_;
	}
	_tmp108_ = self->priv->current;
	_tmp109_ = self->priv->line;
	_tmp110_ = self->priv->column;
	vala_source_location_init (&_vala_token_end, _tmp108_, _tmp109_, _tmp110_ - 1);
	result = type;
	if (token_begin) {
		*token_begin = _vala_token_begin;
	}
	if (token_end) {
		*token_end = _vala_token_end;
	}
	return result;
}


ValaTokenType vala_scanner_get_identifier_or_keyword (gchar* begin, gint len) {
	ValaTokenType result = 0;
	gint _tmp0_;
	_tmp0_ = len;
	switch (_tmp0_) {
		case 2:
		{
			gchar* _tmp1_;
			gchar _tmp2_;
			_tmp1_ = begin;
			_tmp2_ = _tmp1_[0];
			switch (_tmp2_) {
				case 'a':
				{
					gchar* _tmp3_;
					gboolean _tmp4_ = FALSE;
					_tmp3_ = begin;
					_tmp4_ = vala_scanner_matches (_tmp3_, "as");
					if (_tmp4_) {
						result = VALA_TOKEN_TYPE_AS;
						return result;
					}
					break;
				}
				case 'd':
				{
					gchar* _tmp5_;
					gboolean _tmp6_ = FALSE;
					_tmp5_ = begin;
					_tmp6_ = vala_scanner_matches (_tmp5_, "do");
					if (_tmp6_) {
						result = VALA_TOKEN_TYPE_DO;
						return result;
					}
					break;
				}
				case 'i':
				{
					gchar* _tmp7_;
					gchar _tmp8_;
					_tmp7_ = begin;
					_tmp8_ = _tmp7_[1];
					switch (_tmp8_) {
						case 'f':
						{
							result = VALA_TOKEN_TYPE_IF;
							return result;
						}
						case 'n':
						{
							result = VALA_TOKEN_TYPE_IN;
							return result;
						}
						case 's':
						{
							result = VALA_TOKEN_TYPE_IS;
							return result;
						}
						default:
						break;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 3:
		{
			gchar* _tmp9_;
			gchar _tmp10_;
			_tmp9_ = begin;
			_tmp10_ = _tmp9_[0];
			switch (_tmp10_) {
				case 'f':
				{
					gchar* _tmp11_;
					gboolean _tmp12_ = FALSE;
					_tmp11_ = begin;
					_tmp12_ = vala_scanner_matches (_tmp11_, "for");
					if (_tmp12_) {
						result = VALA_TOKEN_TYPE_FOR;
						return result;
					}
					break;
				}
				case 'g':
				{
					gchar* _tmp13_;
					gboolean _tmp14_ = FALSE;
					_tmp13_ = begin;
					_tmp14_ = vala_scanner_matches (_tmp13_, "get");
					if (_tmp14_) {
						result = VALA_TOKEN_TYPE_GET;
						return result;
					}
					break;
				}
				case 'n':
				{
					gchar* _tmp15_;
					gboolean _tmp16_ = FALSE;
					_tmp15_ = begin;
					_tmp16_ = vala_scanner_matches (_tmp15_, "new");
					if (_tmp16_) {
						result = VALA_TOKEN_TYPE_NEW;
						return result;
					}
					break;
				}
				case 'o':
				{
					gchar* _tmp17_;
					gboolean _tmp18_ = FALSE;
					_tmp17_ = begin;
					_tmp18_ = vala_scanner_matches (_tmp17_, "out");
					if (_tmp18_) {
						result = VALA_TOKEN_TYPE_OUT;
						return result;
					}
					break;
				}
				case 'r':
				{
					gchar* _tmp19_;
					gboolean _tmp20_ = FALSE;
					_tmp19_ = begin;
					_tmp20_ = vala_scanner_matches (_tmp19_, "ref");
					if (_tmp20_) {
						result = VALA_TOKEN_TYPE_REF;
						return result;
					}
					break;
				}
				case 's':
				{
					gchar* _tmp21_;
					gboolean _tmp22_ = FALSE;
					_tmp21_ = begin;
					_tmp22_ = vala_scanner_matches (_tmp21_, "set");
					if (_tmp22_) {
						result = VALA_TOKEN_TYPE_SET;
						return result;
					}
					break;
				}
				case 't':
				{
					gchar* _tmp23_;
					gboolean _tmp24_ = FALSE;
					_tmp23_ = begin;
					_tmp24_ = vala_scanner_matches (_tmp23_, "try");
					if (_tmp24_) {
						result = VALA_TOKEN_TYPE_TRY;
						return result;
					}
					break;
				}
				case 'v':
				{
					gchar* _tmp25_;
					gboolean _tmp26_ = FALSE;
					_tmp25_ = begin;
					_tmp26_ = vala_scanner_matches (_tmp25_, "var");
					if (_tmp26_) {
						result = VALA_TOKEN_TYPE_VAR;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 4:
		{
			gchar* _tmp27_;
			gchar _tmp28_;
			_tmp27_ = begin;
			_tmp28_ = _tmp27_[0];
			switch (_tmp28_) {
				case 'b':
				{
					gchar* _tmp29_;
					gboolean _tmp30_ = FALSE;
					_tmp29_ = begin;
					_tmp30_ = vala_scanner_matches (_tmp29_, "base");
					if (_tmp30_) {
						result = VALA_TOKEN_TYPE_BASE;
						return result;
					}
					break;
				}
				case 'c':
				{
					gchar* _tmp31_;
					gboolean _tmp32_ = FALSE;
					_tmp31_ = begin;
					_tmp32_ = vala_scanner_matches (_tmp31_, "case");
					if (_tmp32_) {
						result = VALA_TOKEN_TYPE_CASE;
						return result;
					}
					break;
				}
				case 'e':
				{
					gchar* _tmp33_;
					gchar _tmp34_;
					_tmp33_ = begin;
					_tmp34_ = _tmp33_[1];
					switch (_tmp34_) {
						case 'l':
						{
							gchar* _tmp35_;
							gboolean _tmp36_ = FALSE;
							_tmp35_ = begin;
							_tmp36_ = vala_scanner_matches (_tmp35_, "else");
							if (_tmp36_) {
								result = VALA_TOKEN_TYPE_ELSE;
								return result;
							}
							break;
						}
						case 'n':
						{
							gchar* _tmp37_;
							gboolean _tmp38_ = FALSE;
							_tmp37_ = begin;
							_tmp38_ = vala_scanner_matches (_tmp37_, "enum");
							if (_tmp38_) {
								result = VALA_TOKEN_TYPE_ENUM;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'l':
				{
					gchar* _tmp39_;
					gboolean _tmp40_ = FALSE;
					_tmp39_ = begin;
					_tmp40_ = vala_scanner_matches (_tmp39_, "lock");
					if (_tmp40_) {
						result = VALA_TOKEN_TYPE_LOCK;
						return result;
					}
					break;
				}
				case 'n':
				{
					gchar* _tmp41_;
					gboolean _tmp42_ = FALSE;
					_tmp41_ = begin;
					_tmp42_ = vala_scanner_matches (_tmp41_, "null");
					if (_tmp42_) {
						result = VALA_TOKEN_TYPE_NULL;
						return result;
					}
					break;
				}
				case 't':
				{
					gchar* _tmp43_;
					gchar _tmp44_;
					_tmp43_ = begin;
					_tmp44_ = _tmp43_[1];
					switch (_tmp44_) {
						case 'h':
						{
							gchar* _tmp45_;
							gboolean _tmp46_ = FALSE;
							_tmp45_ = begin;
							_tmp46_ = vala_scanner_matches (_tmp45_, "this");
							if (_tmp46_) {
								result = VALA_TOKEN_TYPE_THIS;
								return result;
							}
							break;
						}
						case 'r':
						{
							gchar* _tmp47_;
							gboolean _tmp48_ = FALSE;
							_tmp47_ = begin;
							_tmp48_ = vala_scanner_matches (_tmp47_, "true");
							if (_tmp48_) {
								result = VALA_TOKEN_TYPE_TRUE;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'v':
				{
					gchar* _tmp49_;
					gboolean _tmp50_ = FALSE;
					_tmp49_ = begin;
					_tmp50_ = vala_scanner_matches (_tmp49_, "void");
					if (_tmp50_) {
						result = VALA_TOKEN_TYPE_VOID;
						return result;
					}
					break;
				}
				case 'w':
				{
					gchar* _tmp51_;
					gboolean _tmp52_ = FALSE;
					_tmp51_ = begin;
					_tmp52_ = vala_scanner_matches (_tmp51_, "weak");
					if (_tmp52_) {
						result = VALA_TOKEN_TYPE_WEAK;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 5:
		{
			gchar* _tmp53_;
			gchar _tmp54_;
			_tmp53_ = begin;
			_tmp54_ = _tmp53_[0];
			switch (_tmp54_) {
				case 'a':
				{
					gchar* _tmp55_;
					gboolean _tmp56_ = FALSE;
					_tmp55_ = begin;
					_tmp56_ = vala_scanner_matches (_tmp55_, "async");
					if (_tmp56_) {
						result = VALA_TOKEN_TYPE_ASYNC;
						return result;
					}
					break;
				}
				case 'b':
				{
					gchar* _tmp57_;
					gboolean _tmp58_ = FALSE;
					_tmp57_ = begin;
					_tmp58_ = vala_scanner_matches (_tmp57_, "break");
					if (_tmp58_) {
						result = VALA_TOKEN_TYPE_BREAK;
						return result;
					}
					break;
				}
				case 'c':
				{
					gchar* _tmp59_;
					gchar _tmp60_;
					_tmp59_ = begin;
					_tmp60_ = _tmp59_[1];
					switch (_tmp60_) {
						case 'a':
						{
							gchar* _tmp61_;
							gboolean _tmp62_ = FALSE;
							_tmp61_ = begin;
							_tmp62_ = vala_scanner_matches (_tmp61_, "catch");
							if (_tmp62_) {
								result = VALA_TOKEN_TYPE_CATCH;
								return result;
							}
							break;
						}
						case 'l':
						{
							gchar* _tmp63_;
							gboolean _tmp64_ = FALSE;
							_tmp63_ = begin;
							_tmp64_ = vala_scanner_matches (_tmp63_, "class");
							if (_tmp64_) {
								result = VALA_TOKEN_TYPE_CLASS;
								return result;
							}
							break;
						}
						case 'o':
						{
							gchar* _tmp65_;
							gboolean _tmp66_ = FALSE;
							_tmp65_ = begin;
							_tmp66_ = vala_scanner_matches (_tmp65_, "const");
							if (_tmp66_) {
								result = VALA_TOKEN_TYPE_CONST;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'f':
				{
					gchar* _tmp67_;
					gboolean _tmp68_ = FALSE;
					_tmp67_ = begin;
					_tmp68_ = vala_scanner_matches (_tmp67_, "false");
					if (_tmp68_) {
						result = VALA_TOKEN_TYPE_FALSE;
						return result;
					}
					break;
				}
				case 'o':
				{
					gchar* _tmp69_;
					gboolean _tmp70_ = FALSE;
					_tmp69_ = begin;
					_tmp70_ = vala_scanner_matches (_tmp69_, "owned");
					if (_tmp70_) {
						result = VALA_TOKEN_TYPE_OWNED;
						return result;
					}
					break;
				}
				case 't':
				{
					gchar* _tmp71_;
					gboolean _tmp72_ = FALSE;
					_tmp71_ = begin;
					_tmp72_ = vala_scanner_matches (_tmp71_, "throw");
					if (_tmp72_) {
						result = VALA_TOKEN_TYPE_THROW;
						return result;
					}
					break;
				}
				case 'u':
				{
					gchar* _tmp73_;
					gboolean _tmp74_ = FALSE;
					_tmp73_ = begin;
					_tmp74_ = vala_scanner_matches (_tmp73_, "using");
					if (_tmp74_) {
						result = VALA_TOKEN_TYPE_USING;
						return result;
					}
					break;
				}
				case 'w':
				{
					gchar* _tmp75_;
					gboolean _tmp76_ = FALSE;
					_tmp75_ = begin;
					_tmp76_ = vala_scanner_matches (_tmp75_, "while");
					if (_tmp76_) {
						result = VALA_TOKEN_TYPE_WHILE;
						return result;
					}
					break;
				}
				case 'y':
				{
					gchar* _tmp77_;
					gboolean _tmp78_ = FALSE;
					_tmp77_ = begin;
					_tmp78_ = vala_scanner_matches (_tmp77_, "yield");
					if (_tmp78_) {
						result = VALA_TOKEN_TYPE_YIELD;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 6:
		{
			gchar* _tmp79_;
			gchar _tmp80_;
			_tmp79_ = begin;
			_tmp80_ = _tmp79_[0];
			switch (_tmp80_) {
				case 'd':
				{
					gchar* _tmp81_;
					gboolean _tmp82_ = FALSE;
					_tmp81_ = begin;
					_tmp82_ = vala_scanner_matches (_tmp81_, "delete");
					if (_tmp82_) {
						result = VALA_TOKEN_TYPE_DELETE;
						return result;
					}
					break;
				}
				case 'e':
				{
					gchar* _tmp83_;
					gboolean _tmp84_ = FALSE;
					_tmp83_ = begin;
					_tmp84_ = vala_scanner_matches (_tmp83_, "extern");
					if (_tmp84_) {
						result = VALA_TOKEN_TYPE_EXTERN;
						return result;
					}
					break;
				}
				case 'i':
				{
					gchar* _tmp85_;
					gboolean _tmp86_ = FALSE;
					_tmp85_ = begin;
					_tmp86_ = vala_scanner_matches (_tmp85_, "inline");
					if (_tmp86_) {
						result = VALA_TOKEN_TYPE_INLINE;
						return result;
					}
					break;
				}
				case 'p':
				{
					gchar* _tmp87_;
					gchar _tmp88_;
					_tmp87_ = begin;
					_tmp88_ = _tmp87_[1];
					switch (_tmp88_) {
						case 'a':
						{
							gchar* _tmp89_;
							gboolean _tmp90_ = FALSE;
							_tmp89_ = begin;
							_tmp90_ = vala_scanner_matches (_tmp89_, "params");
							if (_tmp90_) {
								result = VALA_TOKEN_TYPE_PARAMS;
								return result;
							}
							break;
						}
						case 'u':
						{
							gchar* _tmp91_;
							gboolean _tmp92_ = FALSE;
							_tmp91_ = begin;
							_tmp92_ = vala_scanner_matches (_tmp91_, "public");
							if (_tmp92_) {
								result = VALA_TOKEN_TYPE_PUBLIC;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'r':
				{
					gchar* _tmp93_;
					gboolean _tmp94_ = FALSE;
					_tmp93_ = begin;
					_tmp94_ = vala_scanner_matches (_tmp93_, "return");
					if (_tmp94_) {
						result = VALA_TOKEN_TYPE_RETURN;
						return result;
					}
					break;
				}
				case 's':
				{
					gchar* _tmp95_;
					gchar _tmp96_;
					_tmp95_ = begin;
					_tmp96_ = _tmp95_[1];
					switch (_tmp96_) {
						case 'e':
						{
							gchar* _tmp97_;
							gboolean _tmp98_ = FALSE;
							_tmp97_ = begin;
							_tmp98_ = vala_scanner_matches (_tmp97_, "sealed");
							if (_tmp98_) {
								result = VALA_TOKEN_TYPE_SEALED;
								return result;
							}
							break;
						}
						case 'i':
						{
							gchar* _tmp99_;
							gchar _tmp100_;
							_tmp99_ = begin;
							_tmp100_ = _tmp99_[2];
							switch (_tmp100_) {
								case 'g':
								{
									gchar* _tmp101_;
									gboolean _tmp102_ = FALSE;
									_tmp101_ = begin;
									_tmp102_ = vala_scanner_matches (_tmp101_, "signal");
									if (_tmp102_) {
										result = VALA_TOKEN_TYPE_SIGNAL;
										return result;
									}
									break;
								}
								case 'z':
								{
									gchar* _tmp103_;
									gboolean _tmp104_ = FALSE;
									_tmp103_ = begin;
									_tmp104_ = vala_scanner_matches (_tmp103_, "sizeof");
									if (_tmp104_) {
										result = VALA_TOKEN_TYPE_SIZEOF;
										return result;
									}
									break;
								}
								default:
								break;
							}
							break;
						}
						case 't':
						{
							gchar* _tmp105_;
							gchar _tmp106_;
							_tmp105_ = begin;
							_tmp106_ = _tmp105_[2];
							switch (_tmp106_) {
								case 'a':
								{
									gchar* _tmp107_;
									gboolean _tmp108_ = FALSE;
									_tmp107_ = begin;
									_tmp108_ = vala_scanner_matches (_tmp107_, "static");
									if (_tmp108_) {
										result = VALA_TOKEN_TYPE_STATIC;
										return result;
									}
									break;
								}
								case 'r':
								{
									gchar* _tmp109_;
									gboolean _tmp110_ = FALSE;
									_tmp109_ = begin;
									_tmp110_ = vala_scanner_matches (_tmp109_, "struct");
									if (_tmp110_) {
										result = VALA_TOKEN_TYPE_STRUCT;
										return result;
									}
									break;
								}
								default:
								break;
							}
							break;
						}
						case 'w':
						{
							gchar* _tmp111_;
							gboolean _tmp112_ = FALSE;
							_tmp111_ = begin;
							_tmp112_ = vala_scanner_matches (_tmp111_, "switch");
							if (_tmp112_) {
								result = VALA_TOKEN_TYPE_SWITCH;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 't':
				{
					gchar* _tmp113_;
					gchar _tmp114_;
					_tmp113_ = begin;
					_tmp114_ = _tmp113_[1];
					switch (_tmp114_) {
						case 'h':
						{
							gchar* _tmp115_;
							gboolean _tmp116_ = FALSE;
							_tmp115_ = begin;
							_tmp116_ = vala_scanner_matches (_tmp115_, "throws");
							if (_tmp116_) {
								result = VALA_TOKEN_TYPE_THROWS;
								return result;
							}
							break;
						}
						case 'y':
						{
							gchar* _tmp117_;
							gboolean _tmp118_ = FALSE;
							_tmp117_ = begin;
							_tmp118_ = vala_scanner_matches (_tmp117_, "typeof");
							if (_tmp118_) {
								result = VALA_TOKEN_TYPE_TYPEOF;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 7:
		{
			gchar* _tmp119_;
			gchar _tmp120_;
			_tmp119_ = begin;
			_tmp120_ = _tmp119_[0];
			switch (_tmp120_) {
				case 'd':
				{
					gchar* _tmp121_;
					gchar _tmp122_;
					_tmp121_ = begin;
					_tmp122_ = _tmp121_[1];
					switch (_tmp122_) {
						case 'e':
						{
							gchar* _tmp123_;
							gboolean _tmp124_ = FALSE;
							_tmp123_ = begin;
							_tmp124_ = vala_scanner_matches (_tmp123_, "default");
							if (_tmp124_) {
								result = VALA_TOKEN_TYPE_DEFAULT;
								return result;
							}
							break;
						}
						case 'y':
						{
							gchar* _tmp125_;
							gboolean _tmp126_ = FALSE;
							_tmp125_ = begin;
							_tmp126_ = vala_scanner_matches (_tmp125_, "dynamic");
							if (_tmp126_) {
								result = VALA_TOKEN_TYPE_DYNAMIC;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'e':
				{
					gchar* _tmp127_;
					gboolean _tmp128_ = FALSE;
					_tmp127_ = begin;
					_tmp128_ = vala_scanner_matches (_tmp127_, "ensures");
					if (_tmp128_) {
						result = VALA_TOKEN_TYPE_ENSURES;
						return result;
					}
					break;
				}
				case 'f':
				{
					gchar* _tmp129_;
					gchar _tmp130_;
					_tmp129_ = begin;
					_tmp130_ = _tmp129_[1];
					switch (_tmp130_) {
						case 'i':
						{
							gchar* _tmp131_;
							gboolean _tmp132_ = FALSE;
							_tmp131_ = begin;
							_tmp132_ = vala_scanner_matches (_tmp131_, "finally");
							if (_tmp132_) {
								result = VALA_TOKEN_TYPE_FINALLY;
								return result;
							}
							break;
						}
						case 'o':
						{
							gchar* _tmp133_;
							gboolean _tmp134_ = FALSE;
							_tmp133_ = begin;
							_tmp134_ = vala_scanner_matches (_tmp133_, "foreach");
							if (_tmp134_) {
								result = VALA_TOKEN_TYPE_FOREACH;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'p':
				{
					gchar* _tmp135_;
					gboolean _tmp136_ = FALSE;
					_tmp135_ = begin;
					_tmp136_ = vala_scanner_matches (_tmp135_, "private");
					if (_tmp136_) {
						result = VALA_TOKEN_TYPE_PRIVATE;
						return result;
					}
					break;
				}
				case 'u':
				{
					gchar* _tmp137_;
					gboolean _tmp138_ = FALSE;
					_tmp137_ = begin;
					_tmp138_ = vala_scanner_matches (_tmp137_, "unowned");
					if (_tmp138_) {
						result = VALA_TOKEN_TYPE_UNOWNED;
						return result;
					}
					break;
				}
				case 'v':
				{
					gchar* _tmp139_;
					gboolean _tmp140_ = FALSE;
					_tmp139_ = begin;
					_tmp140_ = vala_scanner_matches (_tmp139_, "virtual");
					if (_tmp140_) {
						result = VALA_TOKEN_TYPE_VIRTUAL;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 8:
		{
			gchar* _tmp141_;
			gchar _tmp142_;
			_tmp141_ = begin;
			_tmp142_ = _tmp141_[0];
			switch (_tmp142_) {
				case 'a':
				{
					gchar* _tmp143_;
					gboolean _tmp144_ = FALSE;
					_tmp143_ = begin;
					_tmp144_ = vala_scanner_matches (_tmp143_, "abstract");
					if (_tmp144_) {
						result = VALA_TOKEN_TYPE_ABSTRACT;
						return result;
					}
					break;
				}
				case 'c':
				{
					gchar* _tmp145_;
					gboolean _tmp146_ = FALSE;
					_tmp145_ = begin;
					_tmp146_ = vala_scanner_matches (_tmp145_, "continue");
					if (_tmp146_) {
						result = VALA_TOKEN_TYPE_CONTINUE;
						return result;
					}
					break;
				}
				case 'd':
				{
					gchar* _tmp147_;
					gboolean _tmp148_ = FALSE;
					_tmp147_ = begin;
					_tmp148_ = vala_scanner_matches (_tmp147_, "delegate");
					if (_tmp148_) {
						result = VALA_TOKEN_TYPE_DELEGATE;
						return result;
					}
					break;
				}
				case 'i':
				{
					gchar* _tmp149_;
					gboolean _tmp150_ = FALSE;
					_tmp149_ = begin;
					_tmp150_ = vala_scanner_matches (_tmp149_, "internal");
					if (_tmp150_) {
						result = VALA_TOKEN_TYPE_INTERNAL;
						return result;
					}
					break;
				}
				case 'o':
				{
					gchar* _tmp151_;
					gboolean _tmp152_ = FALSE;
					_tmp151_ = begin;
					_tmp152_ = vala_scanner_matches (_tmp151_, "override");
					if (_tmp152_) {
						result = VALA_TOKEN_TYPE_OVERRIDE;
						return result;
					}
					break;
				}
				case 'r':
				{
					gchar* _tmp153_;
					gboolean _tmp154_ = FALSE;
					_tmp153_ = begin;
					_tmp154_ = vala_scanner_matches (_tmp153_, "requires");
					if (_tmp154_) {
						result = VALA_TOKEN_TYPE_REQUIRES;
						return result;
					}
					break;
				}
				case 'v':
				{
					gchar* _tmp155_;
					gboolean _tmp156_ = FALSE;
					_tmp155_ = begin;
					_tmp156_ = vala_scanner_matches (_tmp155_, "volatile");
					if (_tmp156_) {
						result = VALA_TOKEN_TYPE_VOLATILE;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 9:
		{
			gchar* _tmp157_;
			gchar _tmp158_;
			_tmp157_ = begin;
			_tmp158_ = _tmp157_[0];
			switch (_tmp158_) {
				case 'c':
				{
					gchar* _tmp159_;
					gboolean _tmp160_ = FALSE;
					_tmp159_ = begin;
					_tmp160_ = vala_scanner_matches (_tmp159_, "construct");
					if (_tmp160_) {
						result = VALA_TOKEN_TYPE_CONSTRUCT;
						return result;
					}
					break;
				}
				case 'i':
				{
					gchar* _tmp161_;
					gboolean _tmp162_ = FALSE;
					_tmp161_ = begin;
					_tmp162_ = vala_scanner_matches (_tmp161_, "interface");
					if (_tmp162_) {
						result = VALA_TOKEN_TYPE_INTERFACE;
						return result;
					}
					break;
				}
				case 'n':
				{
					gchar* _tmp163_;
					gboolean _tmp164_ = FALSE;
					_tmp163_ = begin;
					_tmp164_ = vala_scanner_matches (_tmp163_, "namespace");
					if (_tmp164_) {
						result = VALA_TOKEN_TYPE_NAMESPACE;
						return result;
					}
					break;
				}
				case 'p':
				{
					gchar* _tmp165_;
					gboolean _tmp166_ = FALSE;
					_tmp165_ = begin;
					_tmp166_ = vala_scanner_matches (_tmp165_, "protected");
					if (_tmp166_) {
						result = VALA_TOKEN_TYPE_PROTECTED;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 11:
		{
			gchar* _tmp167_;
			gboolean _tmp168_ = FALSE;
			_tmp167_ = begin;
			_tmp168_ = vala_scanner_matches (_tmp167_, "errordomain");
			if (_tmp168_) {
				result = VALA_TOKEN_TYPE_ERRORDOMAIN;
				return result;
			}
			break;
		}
		default:
		break;
	}
	result = VALA_TOKEN_TYPE_IDENTIFIER;
	return result;
}


static ValaTokenType vala_scanner_read_number (ValaScanner* self) {
	ValaTokenType result = 0;
	ValaTokenType type;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp7_;
	gboolean _tmp10_;
	gboolean _tmp14_;
	gboolean _tmp32_ = FALSE;
	gboolean _tmp33_ = FALSE;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gboolean _tmp38_;
	gboolean _tmp42_;
	gboolean _tmp52_ = FALSE;
	gchar* _tmp53_;
	gchar* _tmp54_;
	gboolean _tmp58_;
	gchar* _tmp79_;
	gchar* _tmp80_;
	g_return_val_if_fail (self != NULL, 0);
	type = VALA_TOKEN_TYPE_INTEGER_LITERAL;
	_tmp3_ = self->priv->current;
	_tmp4_ = self->priv->end;
	if (_tmp3_ < (_tmp4_ - 2)) {
		gchar* _tmp5_;
		gchar _tmp6_;
		_tmp5_ = self->priv->current;
		_tmp6_ = _tmp5_[0];
		_tmp2_ = _tmp6_ == '0';
	} else {
		_tmp2_ = FALSE;
	}
	_tmp7_ = _tmp2_;
	if (_tmp7_) {
		gchar* _tmp8_;
		gchar _tmp9_;
		_tmp8_ = self->priv->current;
		_tmp9_ = _tmp8_[1];
		_tmp1_ = _tmp9_ == 'x';
	} else {
		_tmp1_ = FALSE;
	}
	_tmp10_ = _tmp1_;
	if (_tmp10_) {
		gchar* _tmp11_;
		gchar _tmp12_;
		gboolean _tmp13_ = FALSE;
		_tmp11_ = self->priv->current;
		_tmp12_ = _tmp11_[2];
		_tmp13_ = g_ascii_isxdigit (_tmp12_);
		_tmp0_ = _tmp13_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp14_ = _tmp0_;
	if (_tmp14_) {
		gchar* _tmp15_;
		_tmp15_ = self->priv->current;
		self->priv->current = _tmp15_ + 2;
		while (TRUE) {
			gboolean _tmp16_ = FALSE;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gboolean _tmp22_;
			gchar* _tmp23_;
			_tmp17_ = self->priv->current;
			_tmp18_ = self->priv->end;
			if (_tmp17_ < _tmp18_) {
				gchar* _tmp19_;
				gchar _tmp20_;
				gboolean _tmp21_ = FALSE;
				_tmp19_ = self->priv->current;
				_tmp20_ = _tmp19_[0];
				_tmp21_ = g_ascii_isxdigit (_tmp20_);
				_tmp16_ = _tmp21_;
			} else {
				_tmp16_ = FALSE;
			}
			_tmp22_ = _tmp16_;
			if (!_tmp22_) {
				break;
			}
			_tmp23_ = self->priv->current;
			self->priv->current = _tmp23_ + 1;
		}
	} else {
		while (TRUE) {
			gboolean _tmp24_ = FALSE;
			gchar* _tmp25_;
			gchar* _tmp26_;
			gboolean _tmp30_;
			gchar* _tmp31_;
			_tmp25_ = self->priv->current;
			_tmp26_ = self->priv->end;
			if (_tmp25_ < _tmp26_) {
				gchar* _tmp27_;
				gchar _tmp28_;
				gboolean _tmp29_ = FALSE;
				_tmp27_ = self->priv->current;
				_tmp28_ = _tmp27_[0];
				_tmp29_ = g_ascii_isdigit (_tmp28_);
				_tmp24_ = _tmp29_;
			} else {
				_tmp24_ = FALSE;
			}
			_tmp30_ = _tmp24_;
			if (!_tmp30_) {
				break;
			}
			_tmp31_ = self->priv->current;
			self->priv->current = _tmp31_ + 1;
		}
	}
	_tmp34_ = self->priv->current;
	_tmp35_ = self->priv->end;
	if (_tmp34_ < (_tmp35_ - 1)) {
		gchar* _tmp36_;
		gchar _tmp37_;
		_tmp36_ = self->priv->current;
		_tmp37_ = _tmp36_[0];
		_tmp33_ = _tmp37_ == '.';
	} else {
		_tmp33_ = FALSE;
	}
	_tmp38_ = _tmp33_;
	if (_tmp38_) {
		gchar* _tmp39_;
		gchar _tmp40_;
		gboolean _tmp41_ = FALSE;
		_tmp39_ = self->priv->current;
		_tmp40_ = _tmp39_[1];
		_tmp41_ = g_ascii_isdigit (_tmp40_);
		_tmp32_ = _tmp41_;
	} else {
		_tmp32_ = FALSE;
	}
	_tmp42_ = _tmp32_;
	if (_tmp42_) {
		gchar* _tmp43_;
		type = VALA_TOKEN_TYPE_REAL_LITERAL;
		_tmp43_ = self->priv->current;
		self->priv->current = _tmp43_ + 1;
		while (TRUE) {
			gboolean _tmp44_ = FALSE;
			gchar* _tmp45_;
			gchar* _tmp46_;
			gboolean _tmp50_;
			gchar* _tmp51_;
			_tmp45_ = self->priv->current;
			_tmp46_ = self->priv->end;
			if (_tmp45_ < _tmp46_) {
				gchar* _tmp47_;
				gchar _tmp48_;
				gboolean _tmp49_ = FALSE;
				_tmp47_ = self->priv->current;
				_tmp48_ = _tmp47_[0];
				_tmp49_ = g_ascii_isdigit (_tmp48_);
				_tmp44_ = _tmp49_;
			} else {
				_tmp44_ = FALSE;
			}
			_tmp50_ = _tmp44_;
			if (!_tmp50_) {
				break;
			}
			_tmp51_ = self->priv->current;
			self->priv->current = _tmp51_ + 1;
		}
	}
	_tmp53_ = self->priv->current;
	_tmp54_ = self->priv->end;
	if (_tmp53_ < _tmp54_) {
		gchar* _tmp55_;
		gchar _tmp56_;
		gchar _tmp57_ = '\0';
		_tmp55_ = self->priv->current;
		_tmp56_ = _tmp55_[0];
		_tmp57_ = g_ascii_tolower (_tmp56_);
		_tmp52_ = _tmp57_ == 'e';
	} else {
		_tmp52_ = FALSE;
	}
	_tmp58_ = _tmp52_;
	if (_tmp58_) {
		gchar* _tmp59_;
		gboolean _tmp60_ = FALSE;
		gchar* _tmp61_;
		gchar* _tmp62_;
		gboolean _tmp69_;
		type = VALA_TOKEN_TYPE_REAL_LITERAL;
		_tmp59_ = self->priv->current;
		self->priv->current = _tmp59_ + 1;
		_tmp61_ = self->priv->current;
		_tmp62_ = self->priv->end;
		if (_tmp61_ < _tmp62_) {
			gboolean _tmp63_ = FALSE;
			gchar* _tmp64_;
			gchar _tmp65_;
			gboolean _tmp68_;
			_tmp64_ = self->priv->current;
			_tmp65_ = _tmp64_[0];
			if (_tmp65_ == '+') {
				_tmp63_ = TRUE;
			} else {
				gchar* _tmp66_;
				gchar _tmp67_;
				_tmp66_ = self->priv->current;
				_tmp67_ = _tmp66_[0];
				_tmp63_ = _tmp67_ == '-';
			}
			_tmp68_ = _tmp63_;
			_tmp60_ = _tmp68_;
		} else {
			_tmp60_ = FALSE;
		}
		_tmp69_ = _tmp60_;
		if (_tmp69_) {
			gchar* _tmp70_;
			_tmp70_ = self->priv->current;
			self->priv->current = _tmp70_ + 1;
		}
		while (TRUE) {
			gboolean _tmp71_ = FALSE;
			gchar* _tmp72_;
			gchar* _tmp73_;
			gboolean _tmp77_;
			gchar* _tmp78_;
			_tmp72_ = self->priv->current;
			_tmp73_ = self->priv->end;
			if (_tmp72_ < _tmp73_) {
				gchar* _tmp74_;
				gchar _tmp75_;
				gboolean _tmp76_ = FALSE;
				_tmp74_ = self->priv->current;
				_tmp75_ = _tmp74_[0];
				_tmp76_ = g_ascii_isdigit (_tmp75_);
				_tmp71_ = _tmp76_;
			} else {
				_tmp71_ = FALSE;
			}
			_tmp77_ = _tmp71_;
			if (!_tmp77_) {
				break;
			}
			_tmp78_ = self->priv->current;
			self->priv->current = _tmp78_ + 1;
		}
	}
	_tmp79_ = self->priv->current;
	_tmp80_ = self->priv->end;
	if (_tmp79_ < _tmp80_) {
		ValaTokenType _tmp81_;
		gboolean real_literal;
		gchar* _tmp82_;
		gchar _tmp83_;
		gboolean _tmp113_ = FALSE;
		gboolean _tmp114_;
		gboolean _tmp118_;
		_tmp81_ = type;
		real_literal = _tmp81_ == VALA_TOKEN_TYPE_REAL_LITERAL;
		_tmp82_ = self->priv->current;
		_tmp83_ = _tmp82_[0];
		switch (_tmp83_) {
			case 'l':
			case 'L':
			{
				ValaTokenType _tmp84_;
				_tmp84_ = type;
				if (_tmp84_ == VALA_TOKEN_TYPE_INTEGER_LITERAL) {
					gchar* _tmp85_;
					gboolean _tmp86_ = FALSE;
					gchar* _tmp87_;
					gchar* _tmp88_;
					gboolean _tmp92_;
					_tmp85_ = self->priv->current;
					self->priv->current = _tmp85_ + 1;
					_tmp87_ = self->priv->current;
					_tmp88_ = self->priv->end;
					if (_tmp87_ < _tmp88_) {
						gchar* _tmp89_;
						gchar _tmp90_;
						gchar _tmp91_ = '\0';
						_tmp89_ = self->priv->current;
						_tmp90_ = _tmp89_[0];
						_tmp91_ = g_ascii_tolower (_tmp90_);
						_tmp86_ = _tmp91_ == 'l';
					} else {
						_tmp86_ = FALSE;
					}
					_tmp92_ = _tmp86_;
					if (_tmp92_) {
						gchar* _tmp93_;
						_tmp93_ = self->priv->current;
						self->priv->current = _tmp93_ + 1;
					}
				}
				break;
			}
			case 'u':
			case 'U':
			{
				ValaTokenType _tmp94_;
				_tmp94_ = type;
				if (_tmp94_ == VALA_TOKEN_TYPE_INTEGER_LITERAL) {
					gchar* _tmp95_;
					gboolean _tmp96_ = FALSE;
					gchar* _tmp97_;
					gchar* _tmp98_;
					gboolean _tmp102_;
					_tmp95_ = self->priv->current;
					self->priv->current = _tmp95_ + 1;
					_tmp97_ = self->priv->current;
					_tmp98_ = self->priv->end;
					if (_tmp97_ < _tmp98_) {
						gchar* _tmp99_;
						gchar _tmp100_;
						gchar _tmp101_ = '\0';
						_tmp99_ = self->priv->current;
						_tmp100_ = _tmp99_[0];
						_tmp101_ = g_ascii_tolower (_tmp100_);
						_tmp96_ = _tmp101_ == 'l';
					} else {
						_tmp96_ = FALSE;
					}
					_tmp102_ = _tmp96_;
					if (_tmp102_) {
						gchar* _tmp103_;
						gboolean _tmp104_ = FALSE;
						gchar* _tmp105_;
						gchar* _tmp106_;
						gboolean _tmp110_;
						_tmp103_ = self->priv->current;
						self->priv->current = _tmp103_ + 1;
						_tmp105_ = self->priv->current;
						_tmp106_ = self->priv->end;
						if (_tmp105_ < _tmp106_) {
							gchar* _tmp107_;
							gchar _tmp108_;
							gchar _tmp109_ = '\0';
							_tmp107_ = self->priv->current;
							_tmp108_ = _tmp107_[0];
							_tmp109_ = g_ascii_tolower (_tmp108_);
							_tmp104_ = _tmp109_ == 'l';
						} else {
							_tmp104_ = FALSE;
						}
						_tmp110_ = _tmp104_;
						if (_tmp110_) {
							gchar* _tmp111_;
							_tmp111_ = self->priv->current;
							self->priv->current = _tmp111_ + 1;
						}
					}
				}
				break;
			}
			case 'f':
			case 'F':
			case 'd':
			case 'D':
			{
				gchar* _tmp112_;
				type = VALA_TOKEN_TYPE_REAL_LITERAL;
				_tmp112_ = self->priv->current;
				self->priv->current = _tmp112_ + 1;
				break;
			}
			default:
			break;
		}
		_tmp114_ = real_literal;
		if (!_tmp114_) {
			gchar* _tmp115_;
			gchar _tmp116_;
			gboolean _tmp117_ = FALSE;
			_tmp115_ = self->priv->current;
			_tmp116_ = _tmp115_[0];
			_tmp117_ = vala_scanner_is_ident_char (self, _tmp116_);
			_tmp113_ = _tmp117_;
		} else {
			_tmp113_ = FALSE;
		}
		_tmp118_ = _tmp113_;
		if (_tmp118_) {
			while (TRUE) {
				gboolean _tmp119_ = FALSE;
				gchar* _tmp120_;
				gchar* _tmp121_;
				gboolean _tmp125_;
				gchar* _tmp126_;
				_tmp120_ = self->priv->current;
				_tmp121_ = self->priv->end;
				if (_tmp120_ < _tmp121_) {
					gchar* _tmp122_;
					gchar _tmp123_;
					gboolean _tmp124_ = FALSE;
					_tmp122_ = self->priv->current;
					_tmp123_ = _tmp122_[0];
					_tmp124_ = vala_scanner_is_ident_char (self, _tmp123_);
					_tmp119_ = _tmp124_;
				} else {
					_tmp119_ = FALSE;
				}
				_tmp125_ = _tmp119_;
				if (!_tmp125_) {
					break;
				}
				_tmp126_ = self->priv->current;
				self->priv->current = _tmp126_ + 1;
			}
			type = VALA_TOKEN_TYPE_IDENTIFIER;
		}
	}
	result = type;
	return result;
}


static void _vala_array_add13 (ValaScannerState** array, int* length, int* size, ValaScannerState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add14 (ValaScannerState** array, int* length, int* size, ValaScannerState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add15 (ValaScannerState** array, int* length, int* size, ValaScannerState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add16 (ValaScannerState** array, int* length, int* size, ValaScannerState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


ValaTokenType vala_scanner_read_template_token (ValaScanner* self, ValaSourceLocation* token_begin, ValaSourceLocation* token_end) {
	ValaSourceLocation _vala_token_begin = {0};
	ValaSourceLocation _vala_token_end = {0};
	ValaTokenType result = 0;
	ValaTokenType type = 0;
	gchar* _tmp0_;
	gchar* begin;
	gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint token_length_in_chars;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gint _tmp107_;
	gchar* _tmp113_;
	gint _tmp114_;
	gint _tmp115_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->current;
	begin = _tmp0_;
	_tmp1_ = begin;
	_tmp2_ = self->priv->line;
	_tmp3_ = self->priv->column;
	vala_source_location_init (&_vala_token_begin, _tmp1_, _tmp2_, _tmp3_);
	token_length_in_chars = -1;
	_tmp4_ = self->priv->current;
	_tmp5_ = self->priv->end;
	if (_tmp4_ >= _tmp5_) {
		type = VALA_TOKEN_TYPE_EOF;
	} else {
		gchar* _tmp6_;
		gchar _tmp7_;
		_tmp6_ = self->priv->current;
		_tmp7_ = _tmp6_[0];
		switch (_tmp7_) {
			case '"':
			{
				gchar* _tmp8_;
				gint _tmp9_;
				type = VALA_TOKEN_TYPE_CLOSE_TEMPLATE;
				_tmp8_ = self->priv->current;
				self->priv->current = _tmp8_ + 1;
				_tmp9_ = self->priv->state_stack_length1;
				self->priv->state_stack_length1 = _tmp9_ - 1;
				break;
			}
			case '$':
			{
				gchar* _tmp10_;
				gchar* _tmp11_;
				gboolean _tmp12_ = FALSE;
				gchar* _tmp13_;
				gchar _tmp14_;
				gboolean _tmp15_ = FALSE;
				gboolean _tmp18_;
				_tmp10_ = _vala_token_begin.pos;
				_vala_token_begin.pos = _tmp10_ + 1;
				_tmp11_ = self->priv->current;
				self->priv->current = _tmp11_ + 1;
				_tmp13_ = self->priv->current;
				_tmp14_ = _tmp13_[0];
				_tmp15_ = g_ascii_isalpha (_tmp14_);
				if (_tmp15_) {
					_tmp12_ = TRUE;
				} else {
					gchar* _tmp16_;
					gchar _tmp17_;
					_tmp16_ = self->priv->current;
					_tmp17_ = _tmp16_[0];
					_tmp12_ = _tmp17_ == '_';
				}
				_tmp18_ = _tmp12_;
				if (_tmp18_) {
					gint len;
					ValaScannerState* _tmp28_;
					gint _tmp28__length1;
					len = 0;
					while (TRUE) {
						gboolean _tmp19_ = FALSE;
						gchar* _tmp20_;
						gchar* _tmp21_;
						gboolean _tmp25_;
						gchar* _tmp26_;
						gint _tmp27_;
						_tmp20_ = self->priv->current;
						_tmp21_ = self->priv->end;
						if (_tmp20_ < _tmp21_) {
							gchar* _tmp22_;
							gchar _tmp23_;
							gboolean _tmp24_ = FALSE;
							_tmp22_ = self->priv->current;
							_tmp23_ = _tmp22_[0];
							_tmp24_ = vala_scanner_is_ident_char (self, _tmp23_);
							_tmp19_ = _tmp24_;
						} else {
							_tmp19_ = FALSE;
						}
						_tmp25_ = _tmp19_;
						if (!_tmp25_) {
							break;
						}
						_tmp26_ = self->priv->current;
						self->priv->current = _tmp26_ + 1;
						_tmp27_ = len;
						len = _tmp27_ + 1;
					}
					type = VALA_TOKEN_TYPE_IDENTIFIER;
					_tmp28_ = self->priv->state_stack;
					_tmp28__length1 = self->priv->state_stack_length1;
					_vala_array_add13 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_SCANNER_STATE_TEMPLATE_PART);
				} else {
					gchar* _tmp29_;
					gchar _tmp30_;
					_tmp29_ = self->priv->current;
					_tmp30_ = _tmp29_[0];
					if (_tmp30_ == '(') {
						gchar* _tmp31_;
						gint _tmp32_;
						ValaScannerState* _tmp33_;
						gint _tmp33__length1;
						ValaSourceLocation _tmp34_ = {0};
						ValaSourceLocation _tmp35_ = {0};
						ValaTokenType _tmp36_ = 0;
						_tmp31_ = self->priv->current;
						self->priv->current = _tmp31_ + 1;
						_tmp32_ = self->priv->column;
						self->priv->column = _tmp32_ + 2;
						_tmp33_ = self->priv->state_stack;
						_tmp33__length1 = self->priv->state_stack_length1;
						_vala_array_add14 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_SCANNER_STATE_PARENS);
						_tmp36_ = vala_scanner_read_token (self, &_tmp34_, &_tmp35_);
						_vala_token_begin = _tmp34_;
						_vala_token_end = _tmp35_;
						result = _tmp36_;
						if (token_begin) {
							*token_begin = _vala_token_begin;
						}
						if (token_end) {
							*token_end = _vala_token_end;
						}
						return result;
					} else {
						gchar* _tmp37_;
						gchar _tmp38_;
						_tmp37_ = self->priv->current;
						_tmp38_ = _tmp37_[0];
						if (_tmp38_ == '$') {
							gchar* _tmp39_;
							ValaScannerState* _tmp40_;
							gint _tmp40__length1;
							type = VALA_TOKEN_TYPE_TEMPLATE_STRING_LITERAL;
							_tmp39_ = self->priv->current;
							self->priv->current = _tmp39_ + 1;
							_tmp40_ = self->priv->state_stack;
							_tmp40__length1 = self->priv->state_stack_length1;
							_vala_array_add15 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_SCANNER_STATE_TEMPLATE_PART);
						} else {
							ValaSourceReference* _tmp41_ = NULL;
							ValaSourceReference* _tmp42_;
							ValaSourceLocation _tmp43_ = {0};
							ValaSourceLocation _tmp44_ = {0};
							ValaTokenType _tmp45_ = 0;
							_tmp41_ = vala_scanner_get_source_reference (self, 1, 0);
							_tmp42_ = _tmp41_;
							vala_report_error (_tmp42_, "unexpected character");
							_vala_source_reference_unref0 (_tmp42_);
							_tmp45_ = vala_scanner_read_template_token (self, &_tmp43_, &_tmp44_);
							_vala_token_begin = _tmp43_;
							_vala_token_end = _tmp44_;
							result = _tmp45_;
							if (token_begin) {
								*token_begin = _vala_token_begin;
							}
							if (token_end) {
								*token_end = _vala_token_end;
							}
							return result;
						}
					}
				}
				break;
			}
			default:
			{
				gchar* _tmp97_;
				gchar* _tmp98_;
				ValaScannerState* _tmp106_;
				gint _tmp106__length1;
				type = VALA_TOKEN_TYPE_TEMPLATE_STRING_LITERAL;
				token_length_in_chars = 0;
				while (TRUE) {
					gboolean _tmp46_ = FALSE;
					gboolean _tmp47_ = FALSE;
					gchar* _tmp48_;
					gchar* _tmp49_;
					gboolean _tmp52_;
					gboolean _tmp55_;
					gchar* _tmp56_;
					gchar _tmp57_;
					_tmp48_ = self->priv->current;
					_tmp49_ = self->priv->end;
					if (_tmp48_ < _tmp49_) {
						gchar* _tmp50_;
						gchar _tmp51_;
						_tmp50_ = self->priv->current;
						_tmp51_ = _tmp50_[0];
						_tmp47_ = _tmp51_ != '"';
					} else {
						_tmp47_ = FALSE;
					}
					_tmp52_ = _tmp47_;
					if (_tmp52_) {
						gchar* _tmp53_;
						gchar _tmp54_;
						_tmp53_ = self->priv->current;
						_tmp54_ = _tmp53_[0];
						_tmp46_ = _tmp54_ != '$';
					} else {
						_tmp46_ = FALSE;
					}
					_tmp55_ = _tmp46_;
					if (!_tmp55_) {
						break;
					}
					_tmp56_ = self->priv->current;
					_tmp57_ = _tmp56_[0];
					if (_tmp57_ == '\\') {
						gchar* _tmp58_;
						gint _tmp59_;
						gchar* _tmp60_;
						gchar* _tmp61_;
						gchar* _tmp62_;
						gchar _tmp63_;
						_tmp58_ = self->priv->current;
						self->priv->current = _tmp58_ + 1;
						_tmp59_ = token_length_in_chars;
						token_length_in_chars = _tmp59_ + 1;
						_tmp60_ = self->priv->current;
						_tmp61_ = self->priv->end;
						if (_tmp60_ >= _tmp61_) {
							break;
						}
						_tmp62_ = self->priv->current;
						_tmp63_ = _tmp62_[0];
						switch (_tmp63_) {
							case '\'':
							case '"':
							case '\\':
							case '0':
							case 'b':
							case 'f':
							case 'n':
							case 'r':
							case 't':
							{
								gchar* _tmp64_;
								gint _tmp65_;
								_tmp64_ = self->priv->current;
								self->priv->current = _tmp64_ + 1;
								_tmp65_ = token_length_in_chars;
								token_length_in_chars = _tmp65_ + 1;
								break;
							}
							case 'x':
							{
								gchar* _tmp66_;
								gint _tmp67_;
								_tmp66_ = self->priv->current;
								self->priv->current = _tmp66_ + 1;
								_tmp67_ = token_length_in_chars;
								token_length_in_chars = _tmp67_ + 1;
								while (TRUE) {
									gboolean _tmp68_ = FALSE;
									gchar* _tmp69_;
									gchar* _tmp70_;
									gboolean _tmp74_;
									gchar* _tmp75_;
									gint _tmp76_;
									_tmp69_ = self->priv->current;
									_tmp70_ = self->priv->end;
									if (_tmp69_ < _tmp70_) {
										gchar* _tmp71_;
										gchar _tmp72_;
										gboolean _tmp73_ = FALSE;
										_tmp71_ = self->priv->current;
										_tmp72_ = _tmp71_[0];
										_tmp73_ = g_ascii_isxdigit (_tmp72_);
										_tmp68_ = _tmp73_;
									} else {
										_tmp68_ = FALSE;
									}
									_tmp74_ = _tmp68_;
									if (!_tmp74_) {
										break;
									}
									_tmp75_ = self->priv->current;
									self->priv->current = _tmp75_ + 1;
									_tmp76_ = token_length_in_chars;
									token_length_in_chars = _tmp76_ + 1;
								}
								break;
							}
							default:
							{
								gint _tmp77_;
								ValaSourceReference* _tmp78_ = NULL;
								ValaSourceReference* _tmp79_;
								_tmp77_ = token_length_in_chars;
								_tmp78_ = vala_scanner_get_source_reference (self, _tmp77_, 0);
								_tmp79_ = _tmp78_;
								vala_report_error (_tmp79_, "invalid escape sequence");
								_vala_source_reference_unref0 (_tmp79_);
								break;
							}
						}
					} else {
						gchar* _tmp80_;
						gchar _tmp81_;
						_tmp80_ = self->priv->current;
						_tmp81_ = _tmp80_[0];
						if (_tmp81_ == '\n') {
							gchar* _tmp82_;
							gint _tmp83_;
							_tmp82_ = self->priv->current;
							self->priv->current = _tmp82_ + 1;
							_tmp83_ = self->priv->line;
							self->priv->line = _tmp83_ + 1;
							self->priv->column = 1;
							token_length_in_chars = 1;
						} else {
							gchar* _tmp84_;
							gchar* _tmp85_;
							gchar* _tmp86_;
							gunichar _tmp87_ = 0U;
							gunichar u;
							gunichar _tmp88_;
							_tmp84_ = self->priv->current;
							_tmp85_ = self->priv->end;
							_tmp86_ = self->priv->current;
							_tmp87_ = g_utf8_get_char_validated ((const gchar*) _tmp84_, (gssize) ((glong) (_tmp85_ - _tmp86_)));
							u = _tmp87_;
							_tmp88_ = u;
							if (_tmp88_ != ((gunichar) (-1))) {
								gchar* _tmp89_;
								gunichar _tmp90_;
								gint _tmp91_ = 0;
								gint _tmp92_;
								_tmp89_ = self->priv->current;
								_tmp90_ = u;
								_tmp91_ = g_unichar_to_utf8 (_tmp90_, NULL);
								self->priv->current = _tmp89_ + _tmp91_;
								_tmp92_ = token_length_in_chars;
								token_length_in_chars = _tmp92_ + 1;
							} else {
								gchar* _tmp93_;
								gint _tmp94_;
								ValaSourceReference* _tmp95_ = NULL;
								ValaSourceReference* _tmp96_;
								_tmp93_ = self->priv->current;
								self->priv->current = _tmp93_ + 1;
								_tmp94_ = token_length_in_chars;
								_tmp95_ = vala_scanner_get_source_reference (self, _tmp94_, 0);
								_tmp96_ = _tmp95_;
								vala_report_error (_tmp96_, "invalid UTF-8 character");
								_vala_source_reference_unref0 (_tmp96_);
							}
						}
					}
				}
				_tmp97_ = self->priv->current;
				_tmp98_ = self->priv->end;
				if (_tmp97_ >= _tmp98_) {
					gint _tmp99_;
					ValaSourceReference* _tmp100_ = NULL;
					ValaSourceReference* _tmp101_;
					gint _tmp102_;
					ValaSourceLocation _tmp103_ = {0};
					ValaSourceLocation _tmp104_ = {0};
					ValaTokenType _tmp105_ = 0;
					_tmp99_ = token_length_in_chars;
					_tmp100_ = vala_scanner_get_source_reference (self, _tmp99_, 0);
					_tmp101_ = _tmp100_;
					vala_report_error (_tmp101_, "syntax error, expected \"");
					_vala_source_reference_unref0 (_tmp101_);
					_tmp102_ = self->priv->state_stack_length1;
					self->priv->state_stack_length1 = _tmp102_ - 1;
					_tmp105_ = vala_scanner_read_token (self, &_tmp103_, &_tmp104_);
					_vala_token_begin = _tmp103_;
					_vala_token_end = _tmp104_;
					result = _tmp105_;
					if (token_begin) {
						*token_begin = _vala_token_begin;
					}
					if (token_end) {
						*token_end = _vala_token_end;
					}
					return result;
				}
				_tmp106_ = self->priv->state_stack;
				_tmp106__length1 = self->priv->state_stack_length1;
				_vala_array_add16 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_SCANNER_STATE_TEMPLATE_PART);
				break;
			}
		}
	}
	_tmp107_ = token_length_in_chars;
	if (_tmp107_ < 0) {
		gint _tmp108_;
		gchar* _tmp109_;
		gchar* _tmp110_;
		_tmp108_ = self->priv->column;
		_tmp109_ = self->priv->current;
		_tmp110_ = begin;
		self->priv->column = _tmp108_ + ((gint) (_tmp109_ - _tmp110_));
	} else {
		gint _tmp111_;
		gint _tmp112_;
		_tmp111_ = self->priv->column;
		_tmp112_ = token_length_in_chars;
		self->priv->column = _tmp111_ + _tmp112_;
	}
	_tmp113_ = self->priv->current;
	_tmp114_ = self->priv->line;
	_tmp115_ = self->priv->column;
	vala_source_location_init (&_vala_token_end, _tmp113_, _tmp114_, _tmp115_ - 1);
	result = type;
	if (token_begin) {
		*token_begin = _vala_token_begin;
	}
	if (token_end) {
		*token_end = _vala_token_end;
	}
	return result;
}


static void _vala_array_add17 (ValaScannerState** array, int* length, int* size, ValaScannerState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add18 (ValaScannerState** array, int* length, int* size, ValaScannerState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add19 (ValaScannerState** array, int* length, int* size, ValaScannerState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add20 (ValaScannerState** array, int* length, int* size, ValaScannerState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add21 (ValaScannerState** array, int* length, int* size, ValaScannerState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add22 (ValaScannerState** array, int* length, int* size, ValaScannerState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


ValaTokenType vala_scanner_read_token (ValaScanner* self, ValaSourceLocation* token_begin, ValaSourceLocation* token_end) {
	ValaSourceLocation _vala_token_begin = {0};
	ValaSourceLocation _vala_token_end = {0};
	ValaTokenType result = 0;
	gboolean _tmp0_ = FALSE;
	ValaTokenType type = 0;
	gchar* _tmp16_;
	gchar* begin;
	gchar* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	gint token_length_in_chars;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gint _tmp385_;
	gchar* _tmp391_;
	gint _tmp392_;
	gint _tmp393_;
	ValaTokenType _tmp394_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = vala_scanner_in_template (self);
	if (_tmp0_) {
		ValaSourceLocation _tmp1_ = {0};
		ValaSourceLocation _tmp2_ = {0};
		ValaTokenType _tmp3_ = 0;
		_tmp3_ = vala_scanner_read_template_token (self, &_tmp1_, &_tmp2_);
		_vala_token_begin = _tmp1_;
		_vala_token_end = _tmp2_;
		result = _tmp3_;
		if (token_begin) {
			*token_begin = _vala_token_begin;
		}
		if (token_end) {
			*token_end = _vala_token_end;
		}
		return result;
	} else {
		gboolean _tmp4_ = FALSE;
		_tmp4_ = vala_scanner_in_template_part (self);
		if (_tmp4_) {
			gint _tmp5_;
			gchar* _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			gchar* _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			_tmp5_ = self->priv->state_stack_length1;
			self->priv->state_stack_length1 = _tmp5_ - 1;
			_tmp6_ = self->priv->current;
			_tmp7_ = self->priv->line;
			_tmp8_ = self->priv->column;
			vala_source_location_init (&_vala_token_begin, _tmp6_, _tmp7_, _tmp8_);
			_tmp9_ = self->priv->current;
			_tmp10_ = self->priv->line;
			_tmp11_ = self->priv->column;
			vala_source_location_init (&_vala_token_end, _tmp9_, _tmp10_, _tmp11_ - 1);
			result = VALA_TOKEN_TYPE_COMMA;
			if (token_begin) {
				*token_begin = _vala_token_begin;
			}
			if (token_end) {
				*token_end = _vala_token_end;
			}
			return result;
		} else {
			gboolean _tmp12_ = FALSE;
			_tmp12_ = vala_scanner_in_regex_literal (self);
			if (_tmp12_) {
				ValaSourceLocation _tmp13_ = {0};
				ValaSourceLocation _tmp14_ = {0};
				ValaTokenType _tmp15_ = 0;
				_tmp15_ = vala_scanner_read_regex_token (self, &_tmp13_, &_tmp14_);
				_vala_token_begin = _tmp13_;
				_vala_token_end = _tmp14_;
				result = _tmp15_;
				if (token_begin) {
					*token_begin = _vala_token_begin;
				}
				if (token_end) {
					*token_end = _vala_token_end;
				}
				return result;
			}
		}
	}
	vala_scanner_space (self);
	_tmp16_ = self->priv->current;
	begin = _tmp16_;
	_tmp17_ = begin;
	_tmp18_ = self->priv->line;
	_tmp19_ = self->priv->column;
	vala_source_location_init (&_vala_token_begin, _tmp17_, _tmp18_, _tmp19_);
	token_length_in_chars = -1;
	_tmp20_ = self->priv->current;
	_tmp21_ = self->priv->end;
	if (_tmp20_ >= _tmp21_) {
		type = VALA_TOKEN_TYPE_EOF;
	} else {
		gboolean _tmp22_ = FALSE;
		gchar* _tmp23_;
		gchar _tmp24_;
		gboolean _tmp25_ = FALSE;
		gboolean _tmp28_;
		_tmp23_ = self->priv->current;
		_tmp24_ = _tmp23_[0];
		_tmp25_ = g_ascii_isalpha (_tmp24_);
		if (_tmp25_) {
			_tmp22_ = TRUE;
		} else {
			gchar* _tmp26_;
			gchar _tmp27_;
			_tmp26_ = self->priv->current;
			_tmp27_ = _tmp26_[0];
			_tmp22_ = _tmp27_ == '_';
		}
		_tmp28_ = _tmp22_;
		if (_tmp28_) {
			gint len;
			gchar* _tmp38_;
			gint _tmp39_;
			ValaTokenType _tmp40_ = 0;
			len = 0;
			while (TRUE) {
				gboolean _tmp29_ = FALSE;
				gchar* _tmp30_;
				gchar* _tmp31_;
				gboolean _tmp35_;
				gchar* _tmp36_;
				gint _tmp37_;
				_tmp30_ = self->priv->current;
				_tmp31_ = self->priv->end;
				if (_tmp30_ < _tmp31_) {
					gchar* _tmp32_;
					gchar _tmp33_;
					gboolean _tmp34_ = FALSE;
					_tmp32_ = self->priv->current;
					_tmp33_ = _tmp32_[0];
					_tmp34_ = vala_scanner_is_ident_char (self, _tmp33_);
					_tmp29_ = _tmp34_;
				} else {
					_tmp29_ = FALSE;
				}
				_tmp35_ = _tmp29_;
				if (!_tmp35_) {
					break;
				}
				_tmp36_ = self->priv->current;
				self->priv->current = _tmp36_ + 1;
				_tmp37_ = len;
				len = _tmp37_ + 1;
			}
			_tmp38_ = begin;
			_tmp39_ = len;
			_tmp40_ = vala_scanner_get_identifier_or_keyword (_tmp38_, _tmp39_);
			type = _tmp40_;
		} else {
			gboolean _tmp41_ = FALSE;
			gchar* _tmp42_;
			gchar _tmp43_;
			gboolean _tmp49_;
			_tmp42_ = self->priv->current;
			_tmp43_ = _tmp42_[0];
			if (_tmp43_ == '@') {
				ValaSourceFile* _tmp44_;
				ValaCodeContext* _tmp45_;
				ValaCodeContext* _tmp46_;
				ValaProfile _tmp47_;
				ValaProfile _tmp48_;
				_tmp44_ = self->priv->_source_file;
				_tmp45_ = vala_source_file_get_context (_tmp44_);
				_tmp46_ = _tmp45_;
				_tmp47_ = vala_code_context_get_profile (_tmp46_);
				_tmp48_ = _tmp47_;
				_tmp41_ = _tmp48_ != VALA_PROFILE_DOVA;
			} else {
				_tmp41_ = FALSE;
			}
			_tmp49_ = _tmp41_;
			if (_tmp49_) {
				gboolean _tmp50_ = FALSE;
				gchar* _tmp51_;
				gchar* _tmp52_;
				gboolean _tmp55_;
				_tmp51_ = self->priv->current;
				_tmp52_ = self->priv->end;
				if (_tmp51_ < (_tmp52_ - 1)) {
					gchar* _tmp53_;
					gchar _tmp54_;
					_tmp53_ = self->priv->current;
					_tmp54_ = _tmp53_[1];
					_tmp50_ = _tmp54_ == '"';
				} else {
					_tmp50_ = FALSE;
				}
				_tmp55_ = _tmp50_;
				if (_tmp55_) {
					gchar* _tmp56_;
					ValaScannerState* _tmp57_;
					gint _tmp57__length1;
					type = VALA_TOKEN_TYPE_OPEN_TEMPLATE;
					_tmp56_ = self->priv->current;
					self->priv->current = _tmp56_ + 2;
					_tmp57_ = self->priv->state_stack;
					_tmp57__length1 = self->priv->state_stack_length1;
					_vala_array_add17 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_SCANNER_STATE_TEMPLATE);
				} else {
					gchar* _tmp58_;
					gchar* _tmp59_;
					gint len;
					_tmp58_ = _vala_token_begin.pos;
					_vala_token_begin.pos = _tmp58_ + 1;
					_tmp59_ = self->priv->current;
					self->priv->current = _tmp59_ + 1;
					len = 0;
					while (TRUE) {
						gboolean _tmp60_ = FALSE;
						gchar* _tmp61_;
						gchar* _tmp62_;
						gboolean _tmp66_;
						gchar* _tmp67_;
						gint _tmp68_;
						_tmp61_ = self->priv->current;
						_tmp62_ = self->priv->end;
						if (_tmp61_ < _tmp62_) {
							gchar* _tmp63_;
							gchar _tmp64_;
							gboolean _tmp65_ = FALSE;
							_tmp63_ = self->priv->current;
							_tmp64_ = _tmp63_[0];
							_tmp65_ = vala_scanner_is_ident_char (self, _tmp64_);
							_tmp60_ = _tmp65_;
						} else {
							_tmp60_ = FALSE;
						}
						_tmp66_ = _tmp60_;
						if (!_tmp66_) {
							break;
						}
						_tmp67_ = self->priv->current;
						self->priv->current = _tmp67_ + 1;
						_tmp68_ = len;
						len = _tmp68_ + 1;
					}
					type = VALA_TOKEN_TYPE_IDENTIFIER;
				}
			} else {
				gchar* _tmp69_;
				gchar _tmp70_;
				gboolean _tmp71_ = FALSE;
				_tmp69_ = self->priv->current;
				_tmp70_ = _tmp69_[0];
				_tmp71_ = g_ascii_isdigit (_tmp70_);
				if (_tmp71_) {
					ValaTokenType _tmp72_ = 0;
					_tmp72_ = vala_scanner_read_number (self);
					type = _tmp72_;
				} else {
					gchar* _tmp73_;
					gchar _tmp74_;
					_tmp73_ = self->priv->current;
					_tmp74_ = _tmp73_[0];
					switch (_tmp74_) {
						case '{':
						{
							gchar* _tmp75_;
							ValaScannerState* _tmp76_;
							gint _tmp76__length1;
							type = VALA_TOKEN_TYPE_OPEN_BRACE;
							_tmp75_ = self->priv->current;
							self->priv->current = _tmp75_ + 1;
							_tmp76_ = self->priv->state_stack;
							_tmp76__length1 = self->priv->state_stack_length1;
							_vala_array_add18 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_SCANNER_STATE_BRACE);
							break;
						}
						case '}':
						{
							gchar* _tmp77_;
							ValaScannerState* _tmp78_;
							gint _tmp78__length1;
							type = VALA_TOKEN_TYPE_CLOSE_BRACE;
							_tmp77_ = self->priv->current;
							self->priv->current = _tmp77_ + 1;
							_tmp78_ = self->priv->state_stack;
							_tmp78__length1 = self->priv->state_stack_length1;
							if (_tmp78__length1 > 0) {
								gint _tmp79_;
								_tmp79_ = self->priv->state_stack_length1;
								self->priv->state_stack_length1 = _tmp79_ - 1;
							}
							break;
						}
						case '(':
						{
							gchar* _tmp80_;
							ValaScannerState* _tmp81_;
							gint _tmp81__length1;
							type = VALA_TOKEN_TYPE_OPEN_PARENS;
							_tmp80_ = self->priv->current;
							self->priv->current = _tmp80_ + 1;
							_tmp81_ = self->priv->state_stack;
							_tmp81__length1 = self->priv->state_stack_length1;
							_vala_array_add19 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_SCANNER_STATE_PARENS);
							break;
						}
						case ')':
						{
							gchar* _tmp82_;
							ValaScannerState* _tmp83_;
							gint _tmp83__length1;
							gboolean _tmp85_ = FALSE;
							type = VALA_TOKEN_TYPE_CLOSE_PARENS;
							_tmp82_ = self->priv->current;
							self->priv->current = _tmp82_ + 1;
							_tmp83_ = self->priv->state_stack;
							_tmp83__length1 = self->priv->state_stack_length1;
							if (_tmp83__length1 > 0) {
								gint _tmp84_;
								_tmp84_ = self->priv->state_stack_length1;
								self->priv->state_stack_length1 = _tmp84_ - 1;
							}
							_tmp85_ = vala_scanner_in_template (self);
							if (_tmp85_) {
								type = VALA_TOKEN_TYPE_COMMA;
							}
							break;
						}
						case '[':
						{
							gchar* _tmp86_;
							ValaScannerState* _tmp87_;
							gint _tmp87__length1;
							type = VALA_TOKEN_TYPE_OPEN_BRACKET;
							_tmp86_ = self->priv->current;
							self->priv->current = _tmp86_ + 1;
							_tmp87_ = self->priv->state_stack;
							_tmp87__length1 = self->priv->state_stack_length1;
							_vala_array_add20 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_SCANNER_STATE_BRACKET);
							break;
						}
						case ']':
						{
							gchar* _tmp88_;
							ValaScannerState* _tmp89_;
							gint _tmp89__length1;
							type = VALA_TOKEN_TYPE_CLOSE_BRACKET;
							_tmp88_ = self->priv->current;
							self->priv->current = _tmp88_ + 1;
							_tmp89_ = self->priv->state_stack;
							_tmp89__length1 = self->priv->state_stack_length1;
							if (_tmp89__length1 > 0) {
								gint _tmp90_;
								_tmp90_ = self->priv->state_stack_length1;
								self->priv->state_stack_length1 = _tmp90_ - 1;
							}
							break;
						}
						case '.':
						{
							gchar* _tmp91_;
							gchar* _tmp92_;
							gchar* _tmp93_;
							type = VALA_TOKEN_TYPE_DOT;
							_tmp91_ = self->priv->current;
							self->priv->current = _tmp91_ + 1;
							_tmp92_ = self->priv->current;
							_tmp93_ = self->priv->end;
							if (_tmp92_ < (_tmp93_ - 1)) {
								gboolean _tmp94_ = FALSE;
								gchar* _tmp95_;
								gchar _tmp96_;
								gboolean _tmp99_;
								_tmp95_ = self->priv->current;
								_tmp96_ = _tmp95_[0];
								if (_tmp96_ == '.') {
									gchar* _tmp97_;
									gchar _tmp98_;
									_tmp97_ = self->priv->current;
									_tmp98_ = _tmp97_[1];
									_tmp94_ = _tmp98_ == '.';
								} else {
									_tmp94_ = FALSE;
								}
								_tmp99_ = _tmp94_;
								if (_tmp99_) {
									gchar* _tmp100_;
									type = VALA_TOKEN_TYPE_ELLIPSIS;
									_tmp100_ = self->priv->current;
									self->priv->current = _tmp100_ + 2;
								}
							}
							break;
						}
						case ':':
						{
							gchar* _tmp101_;
							gboolean _tmp102_ = FALSE;
							gchar* _tmp103_;
							gchar* _tmp104_;
							gboolean _tmp107_;
							type = VALA_TOKEN_TYPE_COLON;
							_tmp101_ = self->priv->current;
							self->priv->current = _tmp101_ + 1;
							_tmp103_ = self->priv->current;
							_tmp104_ = self->priv->end;
							if (_tmp103_ < _tmp104_) {
								gchar* _tmp105_;
								gchar _tmp106_;
								_tmp105_ = self->priv->current;
								_tmp106_ = _tmp105_[0];
								_tmp102_ = _tmp106_ == ':';
							} else {
								_tmp102_ = FALSE;
							}
							_tmp107_ = _tmp102_;
							if (_tmp107_) {
								gchar* _tmp108_;
								type = VALA_TOKEN_TYPE_DOUBLE_COLON;
								_tmp108_ = self->priv->current;
								self->priv->current = _tmp108_ + 1;
							}
							break;
						}
						case ',':
						{
							gchar* _tmp109_;
							type = VALA_TOKEN_TYPE_COMMA;
							_tmp109_ = self->priv->current;
							self->priv->current = _tmp109_ + 1;
							break;
						}
						case ';':
						{
							gchar* _tmp110_;
							type = VALA_TOKEN_TYPE_SEMICOLON;
							_tmp110_ = self->priv->current;
							self->priv->current = _tmp110_ + 1;
							break;
						}
						case '#':
						{
							gchar* _tmp111_;
							type = VALA_TOKEN_TYPE_HASH;
							_tmp111_ = self->priv->current;
							self->priv->current = _tmp111_ + 1;
							break;
						}
						case '?':
						{
							gchar* _tmp112_;
							gboolean _tmp113_ = FALSE;
							gchar* _tmp114_;
							gchar* _tmp115_;
							gboolean _tmp118_;
							type = VALA_TOKEN_TYPE_INTERR;
							_tmp112_ = self->priv->current;
							self->priv->current = _tmp112_ + 1;
							_tmp114_ = self->priv->current;
							_tmp115_ = self->priv->end;
							if (_tmp114_ < _tmp115_) {
								gchar* _tmp116_;
								gchar _tmp117_;
								_tmp116_ = self->priv->current;
								_tmp117_ = _tmp116_[0];
								_tmp113_ = _tmp117_ == '?';
							} else {
								_tmp113_ = FALSE;
							}
							_tmp118_ = _tmp113_;
							if (_tmp118_) {
								gchar* _tmp119_;
								type = VALA_TOKEN_TYPE_OP_COALESCING;
								_tmp119_ = self->priv->current;
								self->priv->current = _tmp119_ + 1;
							}
							break;
						}
						case '|':
						{
							gchar* _tmp120_;
							gchar* _tmp121_;
							gchar* _tmp122_;
							type = VALA_TOKEN_TYPE_BITWISE_OR;
							_tmp120_ = self->priv->current;
							self->priv->current = _tmp120_ + 1;
							_tmp121_ = self->priv->current;
							_tmp122_ = self->priv->end;
							if (_tmp121_ < _tmp122_) {
								gchar* _tmp123_;
								gchar _tmp124_;
								_tmp123_ = self->priv->current;
								_tmp124_ = _tmp123_[0];
								switch (_tmp124_) {
									case '=':
									{
										gchar* _tmp125_;
										type = VALA_TOKEN_TYPE_ASSIGN_BITWISE_OR;
										_tmp125_ = self->priv->current;
										self->priv->current = _tmp125_ + 1;
										break;
									}
									case '|':
									{
										gchar* _tmp126_;
										type = VALA_TOKEN_TYPE_OP_OR;
										_tmp126_ = self->priv->current;
										self->priv->current = _tmp126_ + 1;
										break;
									}
									default:
									break;
								}
							}
							break;
						}
						case '&':
						{
							gchar* _tmp127_;
							gchar* _tmp128_;
							gchar* _tmp129_;
							type = VALA_TOKEN_TYPE_BITWISE_AND;
							_tmp127_ = self->priv->current;
							self->priv->current = _tmp127_ + 1;
							_tmp128_ = self->priv->current;
							_tmp129_ = self->priv->end;
							if (_tmp128_ < _tmp129_) {
								gchar* _tmp130_;
								gchar _tmp131_;
								_tmp130_ = self->priv->current;
								_tmp131_ = _tmp130_[0];
								switch (_tmp131_) {
									case '=':
									{
										gchar* _tmp132_;
										type = VALA_TOKEN_TYPE_ASSIGN_BITWISE_AND;
										_tmp132_ = self->priv->current;
										self->priv->current = _tmp132_ + 1;
										break;
									}
									case '&':
									{
										gchar* _tmp133_;
										type = VALA_TOKEN_TYPE_OP_AND;
										_tmp133_ = self->priv->current;
										self->priv->current = _tmp133_ + 1;
										break;
									}
									default:
									break;
								}
							}
							break;
						}
						case '^':
						{
							gchar* _tmp134_;
							gboolean _tmp135_ = FALSE;
							gchar* _tmp136_;
							gchar* _tmp137_;
							gboolean _tmp140_;
							type = VALA_TOKEN_TYPE_CARRET;
							_tmp134_ = self->priv->current;
							self->priv->current = _tmp134_ + 1;
							_tmp136_ = self->priv->current;
							_tmp137_ = self->priv->end;
							if (_tmp136_ < _tmp137_) {
								gchar* _tmp138_;
								gchar _tmp139_;
								_tmp138_ = self->priv->current;
								_tmp139_ = _tmp138_[0];
								_tmp135_ = _tmp139_ == '=';
							} else {
								_tmp135_ = FALSE;
							}
							_tmp140_ = _tmp135_;
							if (_tmp140_) {
								gchar* _tmp141_;
								type = VALA_TOKEN_TYPE_ASSIGN_BITWISE_XOR;
								_tmp141_ = self->priv->current;
								self->priv->current = _tmp141_ + 1;
							}
							break;
						}
						case '~':
						{
							gchar* _tmp142_;
							type = VALA_TOKEN_TYPE_TILDE;
							_tmp142_ = self->priv->current;
							self->priv->current = _tmp142_ + 1;
							break;
						}
						case '=':
						{
							gchar* _tmp143_;
							gchar* _tmp144_;
							gchar* _tmp145_;
							type = VALA_TOKEN_TYPE_ASSIGN;
							_tmp143_ = self->priv->current;
							self->priv->current = _tmp143_ + 1;
							_tmp144_ = self->priv->current;
							_tmp145_ = self->priv->end;
							if (_tmp144_ < _tmp145_) {
								gchar* _tmp146_;
								gchar _tmp147_;
								_tmp146_ = self->priv->current;
								_tmp147_ = _tmp146_[0];
								switch (_tmp147_) {
									case '=':
									{
										gchar* _tmp148_;
										type = VALA_TOKEN_TYPE_OP_EQ;
										_tmp148_ = self->priv->current;
										self->priv->current = _tmp148_ + 1;
										break;
									}
									case '>':
									{
										gchar* _tmp149_;
										type = VALA_TOKEN_TYPE_LAMBDA;
										_tmp149_ = self->priv->current;
										self->priv->current = _tmp149_ + 1;
										break;
									}
									default:
									break;
								}
							}
							break;
						}
						case '<':
						{
							gchar* _tmp150_;
							gchar* _tmp151_;
							gchar* _tmp152_;
							type = VALA_TOKEN_TYPE_OP_LT;
							_tmp150_ = self->priv->current;
							self->priv->current = _tmp150_ + 1;
							_tmp151_ = self->priv->current;
							_tmp152_ = self->priv->end;
							if (_tmp151_ < _tmp152_) {
								gchar* _tmp153_;
								gchar _tmp154_;
								_tmp153_ = self->priv->current;
								_tmp154_ = _tmp153_[0];
								switch (_tmp154_) {
									case '=':
									{
										gchar* _tmp155_;
										type = VALA_TOKEN_TYPE_OP_LE;
										_tmp155_ = self->priv->current;
										self->priv->current = _tmp155_ + 1;
										break;
									}
									case '<':
									{
										gchar* _tmp156_;
										gboolean _tmp157_ = FALSE;
										gchar* _tmp158_;
										gchar* _tmp159_;
										gboolean _tmp162_;
										type = VALA_TOKEN_TYPE_OP_SHIFT_LEFT;
										_tmp156_ = self->priv->current;
										self->priv->current = _tmp156_ + 1;
										_tmp158_ = self->priv->current;
										_tmp159_ = self->priv->end;
										if (_tmp158_ < _tmp159_) {
											gchar* _tmp160_;
											gchar _tmp161_;
											_tmp160_ = self->priv->current;
											_tmp161_ = _tmp160_[0];
											_tmp157_ = _tmp161_ == '=';
										} else {
											_tmp157_ = FALSE;
										}
										_tmp162_ = _tmp157_;
										if (_tmp162_) {
											gchar* _tmp163_;
											type = VALA_TOKEN_TYPE_ASSIGN_SHIFT_LEFT;
											_tmp163_ = self->priv->current;
											self->priv->current = _tmp163_ + 1;
										}
										break;
									}
									default:
									break;
								}
							}
							break;
						}
						case '>':
						{
							gchar* _tmp164_;
							gboolean _tmp165_ = FALSE;
							gchar* _tmp166_;
							gchar* _tmp167_;
							gboolean _tmp170_;
							type = VALA_TOKEN_TYPE_OP_GT;
							_tmp164_ = self->priv->current;
							self->priv->current = _tmp164_ + 1;
							_tmp166_ = self->priv->current;
							_tmp167_ = self->priv->end;
							if (_tmp166_ < _tmp167_) {
								gchar* _tmp168_;
								gchar _tmp169_;
								_tmp168_ = self->priv->current;
								_tmp169_ = _tmp168_[0];
								_tmp165_ = _tmp169_ == '=';
							} else {
								_tmp165_ = FALSE;
							}
							_tmp170_ = _tmp165_;
							if (_tmp170_) {
								gchar* _tmp171_;
								type = VALA_TOKEN_TYPE_OP_GE;
								_tmp171_ = self->priv->current;
								self->priv->current = _tmp171_ + 1;
							}
							break;
						}
						case '!':
						{
							gchar* _tmp172_;
							gboolean _tmp173_ = FALSE;
							gchar* _tmp174_;
							gchar* _tmp175_;
							gboolean _tmp178_;
							type = VALA_TOKEN_TYPE_OP_NEG;
							_tmp172_ = self->priv->current;
							self->priv->current = _tmp172_ + 1;
							_tmp174_ = self->priv->current;
							_tmp175_ = self->priv->end;
							if (_tmp174_ < _tmp175_) {
								gchar* _tmp176_;
								gchar _tmp177_;
								_tmp176_ = self->priv->current;
								_tmp177_ = _tmp176_[0];
								_tmp173_ = _tmp177_ == '=';
							} else {
								_tmp173_ = FALSE;
							}
							_tmp178_ = _tmp173_;
							if (_tmp178_) {
								gchar* _tmp179_;
								type = VALA_TOKEN_TYPE_OP_NE;
								_tmp179_ = self->priv->current;
								self->priv->current = _tmp179_ + 1;
							}
							break;
						}
						case '+':
						{
							gchar* _tmp180_;
							gchar* _tmp181_;
							gchar* _tmp182_;
							type = VALA_TOKEN_TYPE_PLUS;
							_tmp180_ = self->priv->current;
							self->priv->current = _tmp180_ + 1;
							_tmp181_ = self->priv->current;
							_tmp182_ = self->priv->end;
							if (_tmp181_ < _tmp182_) {
								gchar* _tmp183_;
								gchar _tmp184_;
								_tmp183_ = self->priv->current;
								_tmp184_ = _tmp183_[0];
								switch (_tmp184_) {
									case '=':
									{
										gchar* _tmp185_;
										type = VALA_TOKEN_TYPE_ASSIGN_ADD;
										_tmp185_ = self->priv->current;
										self->priv->current = _tmp185_ + 1;
										break;
									}
									case '+':
									{
										gchar* _tmp186_;
										type = VALA_TOKEN_TYPE_OP_INC;
										_tmp186_ = self->priv->current;
										self->priv->current = _tmp186_ + 1;
										break;
									}
									default:
									break;
								}
							}
							break;
						}
						case '-':
						{
							gchar* _tmp187_;
							gchar* _tmp188_;
							gchar* _tmp189_;
							type = VALA_TOKEN_TYPE_MINUS;
							_tmp187_ = self->priv->current;
							self->priv->current = _tmp187_ + 1;
							_tmp188_ = self->priv->current;
							_tmp189_ = self->priv->end;
							if (_tmp188_ < _tmp189_) {
								gchar* _tmp190_;
								gchar _tmp191_;
								_tmp190_ = self->priv->current;
								_tmp191_ = _tmp190_[0];
								switch (_tmp191_) {
									case '=':
									{
										gchar* _tmp192_;
										type = VALA_TOKEN_TYPE_ASSIGN_SUB;
										_tmp192_ = self->priv->current;
										self->priv->current = _tmp192_ + 1;
										break;
									}
									case '-':
									{
										gchar* _tmp193_;
										type = VALA_TOKEN_TYPE_OP_DEC;
										_tmp193_ = self->priv->current;
										self->priv->current = _tmp193_ + 1;
										break;
									}
									case '>':
									{
										gchar* _tmp194_;
										type = VALA_TOKEN_TYPE_OP_PTR;
										_tmp194_ = self->priv->current;
										self->priv->current = _tmp194_ + 1;
										break;
									}
									default:
									break;
								}
							}
							break;
						}
						case '*':
						{
							gchar* _tmp195_;
							gboolean _tmp196_ = FALSE;
							gchar* _tmp197_;
							gchar* _tmp198_;
							gboolean _tmp201_;
							type = VALA_TOKEN_TYPE_STAR;
							_tmp195_ = self->priv->current;
							self->priv->current = _tmp195_ + 1;
							_tmp197_ = self->priv->current;
							_tmp198_ = self->priv->end;
							if (_tmp197_ < _tmp198_) {
								gchar* _tmp199_;
								gchar _tmp200_;
								_tmp199_ = self->priv->current;
								_tmp200_ = _tmp199_[0];
								_tmp196_ = _tmp200_ == '=';
							} else {
								_tmp196_ = FALSE;
							}
							_tmp201_ = _tmp196_;
							if (_tmp201_) {
								gchar* _tmp202_;
								type = VALA_TOKEN_TYPE_ASSIGN_MUL;
								_tmp202_ = self->priv->current;
								self->priv->current = _tmp202_ + 1;
							}
							break;
						}
						case '/':
						{
							ValaTokenType _tmp203_;
							_tmp203_ = self->priv->previous;
							switch (_tmp203_) {
								case VALA_TOKEN_TYPE_ASSIGN:
								case VALA_TOKEN_TYPE_COMMA:
								case VALA_TOKEN_TYPE_MINUS:
								case VALA_TOKEN_TYPE_OP_AND:
								case VALA_TOKEN_TYPE_OP_COALESCING:
								case VALA_TOKEN_TYPE_OP_EQ:
								case VALA_TOKEN_TYPE_OP_GE:
								case VALA_TOKEN_TYPE_OP_GT:
								case VALA_TOKEN_TYPE_OP_LE:
								case VALA_TOKEN_TYPE_OP_LT:
								case VALA_TOKEN_TYPE_OP_NE:
								case VALA_TOKEN_TYPE_OP_NEG:
								case VALA_TOKEN_TYPE_OP_OR:
								case VALA_TOKEN_TYPE_OPEN_BRACE:
								case VALA_TOKEN_TYPE_OPEN_PARENS:
								case VALA_TOKEN_TYPE_PLUS:
								case VALA_TOKEN_TYPE_RETURN:
								{
									ValaScannerState* _tmp204_;
									gint _tmp204__length1;
									gchar* _tmp205_;
									type = VALA_TOKEN_TYPE_OPEN_REGEX_LITERAL;
									_tmp204_ = self->priv->state_stack;
									_tmp204__length1 = self->priv->state_stack_length1;
									_vala_array_add21 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_SCANNER_STATE_REGEX_LITERAL);
									_tmp205_ = self->priv->current;
									self->priv->current = _tmp205_ + 1;
									break;
								}
								default:
								{
									gchar* _tmp206_;
									gboolean _tmp207_ = FALSE;
									gchar* _tmp208_;
									gchar* _tmp209_;
									gboolean _tmp212_;
									type = VALA_TOKEN_TYPE_DIV;
									_tmp206_ = self->priv->current;
									self->priv->current = _tmp206_ + 1;
									_tmp208_ = self->priv->current;
									_tmp209_ = self->priv->end;
									if (_tmp208_ < _tmp209_) {
										gchar* _tmp210_;
										gchar _tmp211_;
										_tmp210_ = self->priv->current;
										_tmp211_ = _tmp210_[0];
										_tmp207_ = _tmp211_ == '=';
									} else {
										_tmp207_ = FALSE;
									}
									_tmp212_ = _tmp207_;
									if (_tmp212_) {
										gchar* _tmp213_;
										type = VALA_TOKEN_TYPE_ASSIGN_DIV;
										_tmp213_ = self->priv->current;
										self->priv->current = _tmp213_ + 1;
									}
									break;
								}
							}
							break;
						}
						case '%':
						{
							gchar* _tmp214_;
							gboolean _tmp215_ = FALSE;
							gchar* _tmp216_;
							gchar* _tmp217_;
							gboolean _tmp220_;
							type = VALA_TOKEN_TYPE_PERCENT;
							_tmp214_ = self->priv->current;
							self->priv->current = _tmp214_ + 1;
							_tmp216_ = self->priv->current;
							_tmp217_ = self->priv->end;
							if (_tmp216_ < _tmp217_) {
								gchar* _tmp218_;
								gchar _tmp219_;
								_tmp218_ = self->priv->current;
								_tmp219_ = _tmp218_[0];
								_tmp215_ = _tmp219_ == '=';
							} else {
								_tmp215_ = FALSE;
							}
							_tmp220_ = _tmp215_;
							if (_tmp220_) {
								gchar* _tmp221_;
								type = VALA_TOKEN_TYPE_ASSIGN_PERCENT;
								_tmp221_ = self->priv->current;
								self->priv->current = _tmp221_ + 1;
							}
							break;
						}
						case '\'':
						case '"':
						{
							gchar* _tmp222_;
							gchar _tmp223_;
							gchar* _tmp281_;
							gchar* _tmp358_;
							gchar* _tmp359_;
							_tmp222_ = begin;
							_tmp223_ = _tmp222_[0];
							if (_tmp223_ == '\'') {
								type = VALA_TOKEN_TYPE_CHARACTER_LITERAL;
							} else {
								gboolean _tmp224_ = FALSE;
								gboolean _tmp225_ = FALSE;
								gchar* _tmp226_;
								gchar* _tmp227_;
								gboolean _tmp230_;
								gboolean _tmp233_;
								_tmp226_ = self->priv->current;
								_tmp227_ = self->priv->end;
								if (_tmp226_ < (_tmp227_ - 6)) {
									gchar* _tmp228_;
									gchar _tmp229_;
									_tmp228_ = begin;
									_tmp229_ = _tmp228_[1];
									_tmp225_ = _tmp229_ == '"';
								} else {
									_tmp225_ = FALSE;
								}
								_tmp230_ = _tmp225_;
								if (_tmp230_) {
									gchar* _tmp231_;
									gchar _tmp232_;
									_tmp231_ = begin;
									_tmp232_ = _tmp231_[2];
									_tmp224_ = _tmp232_ == '"';
								} else {
									_tmp224_ = FALSE;
								}
								_tmp233_ = _tmp224_;
								if (_tmp233_) {
									gchar* _tmp234_;
									gboolean _tmp267_ = FALSE;
									gboolean _tmp268_ = FALSE;
									gchar* _tmp269_;
									gchar _tmp270_;
									gboolean _tmp273_;
									gboolean _tmp276_;
									type = VALA_TOKEN_TYPE_VERBATIM_STRING_LITERAL;
									token_length_in_chars = 6;
									_tmp234_ = self->priv->current;
									self->priv->current = _tmp234_ + 3;
									while (TRUE) {
										gchar* _tmp235_;
										gchar* _tmp236_;
										gboolean _tmp237_ = FALSE;
										gboolean _tmp238_ = FALSE;
										gboolean _tmp239_ = FALSE;
										gchar* _tmp240_;
										gchar _tmp241_;
										gboolean _tmp244_;
										gboolean _tmp247_;
										gboolean _tmp250_;
										_tmp235_ = self->priv->current;
										_tmp236_ = self->priv->end;
										if (!(_tmp235_ < (_tmp236_ - 4))) {
											break;
										}
										_tmp240_ = self->priv->current;
										_tmp241_ = _tmp240_[0];
										if (_tmp241_ == '"') {
											gchar* _tmp242_;
											gchar _tmp243_;
											_tmp242_ = self->priv->current;
											_tmp243_ = _tmp242_[1];
											_tmp239_ = _tmp243_ == '"';
										} else {
											_tmp239_ = FALSE;
										}
										_tmp244_ = _tmp239_;
										if (_tmp244_) {
											gchar* _tmp245_;
											gchar _tmp246_;
											_tmp245_ = self->priv->current;
											_tmp246_ = _tmp245_[2];
											_tmp238_ = _tmp246_ == '"';
										} else {
											_tmp238_ = FALSE;
										}
										_tmp247_ = _tmp238_;
										if (_tmp247_) {
											gchar* _tmp248_;
											gchar _tmp249_;
											_tmp248_ = self->priv->current;
											_tmp249_ = _tmp248_[3];
											_tmp237_ = _tmp249_ != '"';
										} else {
											_tmp237_ = FALSE;
										}
										_tmp250_ = _tmp237_;
										if (_tmp250_) {
											break;
										} else {
											gchar* _tmp251_;
											gchar _tmp252_;
											_tmp251_ = self->priv->current;
											_tmp252_ = _tmp251_[0];
											if (_tmp252_ == '\n') {
												gchar* _tmp253_;
												gint _tmp254_;
												_tmp253_ = self->priv->current;
												self->priv->current = _tmp253_ + 1;
												_tmp254_ = self->priv->line;
												self->priv->line = _tmp254_ + 1;
												self->priv->column = 1;
												token_length_in_chars = 3;
											} else {
												gchar* _tmp255_;
												gchar* _tmp256_;
												gchar* _tmp257_;
												gunichar _tmp258_ = 0U;
												gunichar u;
												gunichar _tmp259_;
												_tmp255_ = self->priv->current;
												_tmp256_ = self->priv->end;
												_tmp257_ = self->priv->current;
												_tmp258_ = g_utf8_get_char_validated ((const gchar*) _tmp255_, (gssize) ((glong) (_tmp256_ - _tmp257_)));
												u = _tmp258_;
												_tmp259_ = u;
												if (_tmp259_ != ((gunichar) (-1))) {
													gchar* _tmp260_;
													gunichar _tmp261_;
													gint _tmp262_ = 0;
													gint _tmp263_;
													_tmp260_ = self->priv->current;
													_tmp261_ = u;
													_tmp262_ = g_unichar_to_utf8 (_tmp261_, NULL);
													self->priv->current = _tmp260_ + _tmp262_;
													_tmp263_ = token_length_in_chars;
													token_length_in_chars = _tmp263_ + 1;
												} else {
													gint _tmp264_;
													ValaSourceReference* _tmp265_ = NULL;
													ValaSourceReference* _tmp266_;
													_tmp264_ = token_length_in_chars;
													_tmp265_ = vala_scanner_get_source_reference (self, _tmp264_, 0);
													_tmp266_ = _tmp265_;
													vala_report_error (_tmp266_, "invalid UTF-8 character");
													_vala_source_reference_unref0 (_tmp266_);
												}
											}
										}
									}
									_tmp269_ = self->priv->current;
									_tmp270_ = _tmp269_[0];
									if (_tmp270_ == '"') {
										gchar* _tmp271_;
										gchar _tmp272_;
										_tmp271_ = self->priv->current;
										_tmp272_ = _tmp271_[1];
										_tmp268_ = _tmp272_ == '"';
									} else {
										_tmp268_ = FALSE;
									}
									_tmp273_ = _tmp268_;
									if (_tmp273_) {
										gchar* _tmp274_;
										gchar _tmp275_;
										_tmp274_ = self->priv->current;
										_tmp275_ = _tmp274_[2];
										_tmp267_ = _tmp275_ == '"';
									} else {
										_tmp267_ = FALSE;
									}
									_tmp276_ = _tmp267_;
									if (_tmp276_) {
										gchar* _tmp277_;
										_tmp277_ = self->priv->current;
										self->priv->current = _tmp277_ + 3;
									} else {
										gint _tmp278_;
										ValaSourceReference* _tmp279_ = NULL;
										ValaSourceReference* _tmp280_;
										_tmp278_ = token_length_in_chars;
										_tmp279_ = vala_scanner_get_source_reference (self, _tmp278_, 0);
										_tmp280_ = _tmp279_;
										vala_report_error (_tmp280_, "syntax error, expected \"\"\"");
										_vala_source_reference_unref0 (_tmp280_);
									}
									break;
								} else {
									type = VALA_TOKEN_TYPE_STRING_LITERAL;
								}
							}
							token_length_in_chars = 2;
							_tmp281_ = self->priv->current;
							self->priv->current = _tmp281_ + 1;
							while (TRUE) {
								gboolean _tmp282_ = FALSE;
								gchar* _tmp283_;
								gchar* _tmp284_;
								gboolean _tmp289_;
								gchar* _tmp290_;
								gchar _tmp291_;
								gboolean _tmp345_ = FALSE;
								gboolean _tmp346_ = FALSE;
								gchar* _tmp347_;
								gchar* _tmp348_;
								gboolean _tmp351_;
								gboolean _tmp354_;
								_tmp283_ = self->priv->current;
								_tmp284_ = self->priv->end;
								if (_tmp283_ < _tmp284_) {
									gchar* _tmp285_;
									gchar _tmp286_;
									gchar* _tmp287_;
									gchar _tmp288_;
									_tmp285_ = self->priv->current;
									_tmp286_ = _tmp285_[0];
									_tmp287_ = begin;
									_tmp288_ = _tmp287_[0];
									_tmp282_ = _tmp286_ != _tmp288_;
								} else {
									_tmp282_ = FALSE;
								}
								_tmp289_ = _tmp282_;
								if (!_tmp289_) {
									break;
								}
								_tmp290_ = self->priv->current;
								_tmp291_ = _tmp290_[0];
								if (_tmp291_ == '\\') {
									gchar* _tmp292_;
									gint _tmp293_;
									gchar* _tmp294_;
									gchar* _tmp295_;
									gchar* _tmp296_;
									gchar _tmp297_;
									_tmp292_ = self->priv->current;
									self->priv->current = _tmp292_ + 1;
									_tmp293_ = token_length_in_chars;
									token_length_in_chars = _tmp293_ + 1;
									_tmp294_ = self->priv->current;
									_tmp295_ = self->priv->end;
									if (_tmp294_ >= _tmp295_) {
										break;
									}
									_tmp296_ = self->priv->current;
									_tmp297_ = _tmp296_[0];
									switch (_tmp297_) {
										case '\'':
										case '"':
										case '\\':
										case '0':
										case 'b':
										case 'f':
										case 'n':
										case 'r':
										case 't':
										case '$':
										{
											gchar* _tmp298_;
											gint _tmp299_;
											_tmp298_ = self->priv->current;
											self->priv->current = _tmp298_ + 1;
											_tmp299_ = token_length_in_chars;
											token_length_in_chars = _tmp299_ + 1;
											break;
										}
										case 'x':
										{
											gchar* _tmp300_;
											gint _tmp301_;
											_tmp300_ = self->priv->current;
											self->priv->current = _tmp300_ + 1;
											_tmp301_ = token_length_in_chars;
											token_length_in_chars = _tmp301_ + 1;
											while (TRUE) {
												gboolean _tmp302_ = FALSE;
												gchar* _tmp303_;
												gchar* _tmp304_;
												gboolean _tmp308_;
												gchar* _tmp309_;
												gint _tmp310_;
												_tmp303_ = self->priv->current;
												_tmp304_ = self->priv->end;
												if (_tmp303_ < _tmp304_) {
													gchar* _tmp305_;
													gchar _tmp306_;
													gboolean _tmp307_ = FALSE;
													_tmp305_ = self->priv->current;
													_tmp306_ = _tmp305_[0];
													_tmp307_ = g_ascii_isxdigit (_tmp306_);
													_tmp302_ = _tmp307_;
												} else {
													_tmp302_ = FALSE;
												}
												_tmp308_ = _tmp302_;
												if (!_tmp308_) {
													break;
												}
												_tmp309_ = self->priv->current;
												self->priv->current = _tmp309_ + 1;
												_tmp310_ = token_length_in_chars;
												token_length_in_chars = _tmp310_ + 1;
											}
											break;
										}
										default:
										{
											gint _tmp311_;
											ValaSourceReference* _tmp312_ = NULL;
											ValaSourceReference* _tmp313_;
											_tmp311_ = token_length_in_chars;
											_tmp312_ = vala_scanner_get_source_reference (self, _tmp311_, 0);
											_tmp313_ = _tmp312_;
											vala_report_error (_tmp313_, "invalid escape sequence");
											_vala_source_reference_unref0 (_tmp313_);
											break;
										}
									}
								} else {
									gchar* _tmp314_;
									gchar _tmp315_;
									_tmp314_ = self->priv->current;
									_tmp315_ = _tmp314_[0];
									if (_tmp315_ == '\n') {
										gchar* _tmp316_;
										gint _tmp317_;
										_tmp316_ = self->priv->current;
										self->priv->current = _tmp316_ + 1;
										_tmp317_ = self->priv->line;
										self->priv->line = _tmp317_ + 1;
										self->priv->column = 1;
										token_length_in_chars = 1;
									} else {
										gboolean _tmp318_ = FALSE;
										gboolean _tmp319_ = FALSE;
										ValaTokenType _tmp320_;
										gboolean _tmp326_;
										gboolean _tmp329_;
										gchar* _tmp332_;
										gchar* _tmp333_;
										gchar* _tmp334_;
										gunichar _tmp335_ = 0U;
										gunichar u;
										gunichar _tmp336_;
										_tmp320_ = type;
										if (_tmp320_ == VALA_TOKEN_TYPE_STRING_LITERAL) {
											ValaSourceFile* _tmp321_;
											ValaCodeContext* _tmp322_;
											ValaCodeContext* _tmp323_;
											ValaProfile _tmp324_;
											ValaProfile _tmp325_;
											_tmp321_ = self->priv->_source_file;
											_tmp322_ = vala_source_file_get_context (_tmp321_);
											_tmp323_ = _tmp322_;
											_tmp324_ = vala_code_context_get_profile (_tmp323_);
											_tmp325_ = _tmp324_;
											_tmp319_ = _tmp325_ == VALA_PROFILE_DOVA;
										} else {
											_tmp319_ = FALSE;
										}
										_tmp326_ = _tmp319_;
										if (_tmp326_) {
											gchar* _tmp327_;
											gchar _tmp328_;
											_tmp327_ = self->priv->current;
											_tmp328_ = _tmp327_[0];
											_tmp318_ = _tmp328_ == '$';
										} else {
											_tmp318_ = FALSE;
										}
										_tmp329_ = _tmp318_;
										if (_tmp329_) {
											gchar* _tmp330_;
											ValaScannerState* _tmp331_;
											gint _tmp331__length1;
											type = VALA_TOKEN_TYPE_OPEN_TEMPLATE;
											_tmp330_ = begin;
											self->priv->current = _tmp330_;
											_tmp331_ = self->priv->state_stack;
											_tmp331__length1 = self->priv->state_stack_length1;
											_vala_array_add22 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_SCANNER_STATE_TEMPLATE);
											break;
										}
										_tmp332_ = self->priv->current;
										_tmp333_ = self->priv->end;
										_tmp334_ = self->priv->current;
										_tmp335_ = g_utf8_get_char_validated ((const gchar*) _tmp332_, (gssize) ((glong) (_tmp333_ - _tmp334_)));
										u = _tmp335_;
										_tmp336_ = u;
										if (_tmp336_ != ((gunichar) (-1))) {
											gchar* _tmp337_;
											gunichar _tmp338_;
											gint _tmp339_ = 0;
											gint _tmp340_;
											_tmp337_ = self->priv->current;
											_tmp338_ = u;
											_tmp339_ = g_unichar_to_utf8 (_tmp338_, NULL);
											self->priv->current = _tmp337_ + _tmp339_;
											_tmp340_ = token_length_in_chars;
											token_length_in_chars = _tmp340_ + 1;
										} else {
											gchar* _tmp341_;
											gint _tmp342_;
											ValaSourceReference* _tmp343_ = NULL;
											ValaSourceReference* _tmp344_;
											_tmp341_ = self->priv->current;
											self->priv->current = _tmp341_ + 1;
											_tmp342_ = token_length_in_chars;
											_tmp343_ = vala_scanner_get_source_reference (self, _tmp342_, 0);
											_tmp344_ = _tmp343_;
											vala_report_error (_tmp344_, "invalid UTF-8 character");
											_vala_source_reference_unref0 (_tmp344_);
										}
									}
								}
								_tmp347_ = self->priv->current;
								_tmp348_ = self->priv->end;
								if (_tmp347_ < _tmp348_) {
									gchar* _tmp349_;
									gchar _tmp350_;
									_tmp349_ = begin;
									_tmp350_ = _tmp349_[0];
									_tmp346_ = _tmp350_ == '\'';
								} else {
									_tmp346_ = FALSE;
								}
								_tmp351_ = _tmp346_;
								if (_tmp351_) {
									gchar* _tmp352_;
									gchar _tmp353_;
									_tmp352_ = self->priv->current;
									_tmp353_ = _tmp352_[0];
									_tmp345_ = _tmp353_ != '\'';
								} else {
									_tmp345_ = FALSE;
								}
								_tmp354_ = _tmp345_;
								if (_tmp354_) {
									gint _tmp355_;
									ValaSourceReference* _tmp356_ = NULL;
									ValaSourceReference* _tmp357_;
									_tmp355_ = token_length_in_chars;
									_tmp356_ = vala_scanner_get_source_reference (self, _tmp355_, 0);
									_tmp357_ = _tmp356_;
									vala_report_error (_tmp357_, "invalid character literal");
									_vala_source_reference_unref0 (_tmp357_);
								}
							}
							_tmp358_ = self->priv->current;
							_tmp359_ = self->priv->end;
							if (_tmp358_ < _tmp359_) {
								gchar* _tmp360_;
								_tmp360_ = self->priv->current;
								self->priv->current = _tmp360_ + 1;
							} else {
								gint _tmp361_;
								ValaSourceReference* _tmp362_ = NULL;
								ValaSourceReference* _tmp363_;
								gchar* _tmp364_;
								gchar _tmp365_;
								gchar* _tmp366_ = NULL;
								gchar* _tmp367_;
								_tmp361_ = token_length_in_chars;
								_tmp362_ = vala_scanner_get_source_reference (self, _tmp361_, 0);
								_tmp363_ = _tmp362_;
								_tmp364_ = begin;
								_tmp365_ = _tmp364_[0];
								_tmp366_ = g_strdup_printf ("syntax error, expected %c", (gint) _tmp365_);
								_tmp367_ = _tmp366_;
								vala_report_error (_tmp363_, _tmp367_);
								_g_free0 (_tmp367_);
								_vala_source_reference_unref0 (_tmp363_);
							}
							break;
						}
						default:
						{
							gchar* _tmp368_;
							gchar* _tmp369_;
							gchar* _tmp370_;
							gunichar _tmp371_ = 0U;
							gunichar u;
							gunichar _tmp372_;
							gint _tmp381_;
							ValaSourceLocation _tmp382_ = {0};
							ValaSourceLocation _tmp383_ = {0};
							ValaTokenType _tmp384_ = 0;
							_tmp368_ = self->priv->current;
							_tmp369_ = self->priv->end;
							_tmp370_ = self->priv->current;
							_tmp371_ = g_utf8_get_char_validated ((const gchar*) _tmp368_, (gssize) ((glong) (_tmp369_ - _tmp370_)));
							u = _tmp371_;
							_tmp372_ = u;
							if (_tmp372_ != ((gunichar) (-1))) {
								gchar* _tmp373_;
								gunichar _tmp374_;
								gint _tmp375_ = 0;
								ValaSourceReference* _tmp376_ = NULL;
								ValaSourceReference* _tmp377_;
								_tmp373_ = self->priv->current;
								_tmp374_ = u;
								_tmp375_ = g_unichar_to_utf8 (_tmp374_, NULL);
								self->priv->current = _tmp373_ + _tmp375_;
								_tmp376_ = vala_scanner_get_source_reference (self, 0, 0);
								_tmp377_ = _tmp376_;
								vala_report_error (_tmp377_, "syntax error, unexpected character");
								_vala_source_reference_unref0 (_tmp377_);
							} else {
								gchar* _tmp378_;
								ValaSourceReference* _tmp379_ = NULL;
								ValaSourceReference* _tmp380_;
								_tmp378_ = self->priv->current;
								self->priv->current = _tmp378_ + 1;
								_tmp379_ = vala_scanner_get_source_reference (self, 0, 0);
								_tmp380_ = _tmp379_;
								vala_report_error (_tmp380_, "invalid UTF-8 character");
								_vala_source_reference_unref0 (_tmp380_);
							}
							_tmp381_ = self->priv->column;
							self->priv->column = _tmp381_ + 1;
							_tmp384_ = vala_scanner_read_token (self, &_tmp382_, &_tmp383_);
							_vala_token_begin = _tmp382_;
							_vala_token_end = _tmp383_;
							result = _tmp384_;
							if (token_begin) {
								*token_begin = _vala_token_begin;
							}
							if (token_end) {
								*token_end = _vala_token_end;
							}
							return result;
						}
					}
				}
			}
		}
	}
	_tmp385_ = token_length_in_chars;
	if (_tmp385_ < 0) {
		gint _tmp386_;
		gchar* _tmp387_;
		gchar* _tmp388_;
		_tmp386_ = self->priv->column;
		_tmp387_ = self->priv->current;
		_tmp388_ = begin;
		self->priv->column = _tmp386_ + ((gint) (_tmp387_ - _tmp388_));
	} else {
		gint _tmp389_;
		gint _tmp390_;
		_tmp389_ = self->priv->column;
		_tmp390_ = token_length_in_chars;
		self->priv->column = _tmp389_ + _tmp390_;
	}
	_tmp391_ = self->priv->current;
	_tmp392_ = self->priv->line;
	_tmp393_ = self->priv->column;
	vala_source_location_init (&_vala_token_end, _tmp391_, _tmp392_, _tmp393_ - 1);
	_tmp394_ = type;
	self->priv->previous = _tmp394_;
	result = type;
	if (token_begin) {
		*token_begin = _vala_token_begin;
	}
	if (token_end) {
		*token_end = _vala_token_end;
	}
	return result;
}


static gboolean vala_scanner_matches (gchar* begin, const gchar* keyword) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* keyword_array;
	const gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	glong len;
	g_return_val_if_fail (keyword != NULL, FALSE);
	_tmp0_ = keyword;
	keyword_array = (gchar*) _tmp0_;
	_tmp1_ = keyword;
	_tmp2_ = strlen (_tmp1_);
	_tmp3_ = _tmp2_;
	len = (glong) _tmp3_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp5_;
				gint _tmp7_;
				glong _tmp8_;
				gchar* _tmp9_;
				gint _tmp10_;
				gchar _tmp11_;
				gchar* _tmp12_;
				gint _tmp13_;
				gchar _tmp14_;
				_tmp5_ = _tmp4_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp7_ = i;
				_tmp8_ = len;
				if (!(((glong) _tmp7_) < _tmp8_)) {
					break;
				}
				_tmp9_ = begin;
				_tmp10_ = i;
				_tmp11_ = _tmp9_[_tmp10_];
				_tmp12_ = keyword_array;
				_tmp13_ = i;
				_tmp14_ = _tmp12_[_tmp13_];
				if (_tmp11_ != _tmp14_) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}


static gboolean vala_scanner_pp_whitespace (ValaScanner* self) {
	gboolean result = FALSE;
	gboolean found;
	g_return_val_if_fail (self != NULL, FALSE);
	found = FALSE;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gboolean _tmp7_;
		gboolean _tmp10_;
		gchar* _tmp11_;
		gint _tmp12_;
		_tmp2_ = self->priv->current;
		_tmp3_ = self->priv->end;
		if (_tmp2_ < _tmp3_) {
			gchar* _tmp4_;
			gchar _tmp5_;
			gboolean _tmp6_ = FALSE;
			_tmp4_ = self->priv->current;
			_tmp5_ = _tmp4_[0];
			_tmp6_ = g_ascii_isspace (_tmp5_);
			_tmp1_ = _tmp6_;
		} else {
			_tmp1_ = FALSE;
		}
		_tmp7_ = _tmp1_;
		if (_tmp7_) {
			gchar* _tmp8_;
			gchar _tmp9_;
			_tmp8_ = self->priv->current;
			_tmp9_ = _tmp8_[0];
			_tmp0_ = _tmp9_ != '\n';
		} else {
			_tmp0_ = FALSE;
		}
		_tmp10_ = _tmp0_;
		if (!_tmp10_) {
			break;
		}
		found = TRUE;
		_tmp11_ = self->priv->current;
		self->priv->current = _tmp11_ + 1;
		_tmp12_ = self->priv->column;
		self->priv->column = _tmp12_ + 1;
	}
	result = found;
	return result;
}


static void vala_scanner_pp_directive (ValaScanner* self) {
	gchar* _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gint _tmp5_;
	gboolean _tmp7_;
	gboolean _tmp10_;
	gboolean _tmp13_;
	gchar* _tmp21_;
	gchar* begin;
	gint len;
	gboolean _tmp32_ = FALSE;
	gint _tmp33_;
	gboolean _tmp36_;
	gboolean _tmp56_ = FALSE;
	ValaScannerConditional* _tmp57_;
	gint _tmp57__length1;
	gboolean _tmp62_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current;
	self->priv->current = _tmp0_ + 1;
	_tmp1_ = self->priv->column;
	self->priv->column = _tmp1_ + 1;
	_tmp5_ = self->priv->line;
	if (_tmp5_ == 1) {
		gint _tmp6_;
		_tmp6_ = self->priv->column;
		_tmp4_ = _tmp6_ == 2;
	} else {
		_tmp4_ = FALSE;
	}
	_tmp7_ = _tmp4_;
	if (_tmp7_) {
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp8_ = self->priv->current;
		_tmp9_ = self->priv->end;
		_tmp3_ = _tmp8_ < _tmp9_;
	} else {
		_tmp3_ = FALSE;
	}
	_tmp10_ = _tmp3_;
	if (_tmp10_) {
		gchar* _tmp11_;
		gchar _tmp12_;
		_tmp11_ = self->priv->current;
		_tmp12_ = _tmp11_[0];
		_tmp2_ = _tmp12_ == '!';
	} else {
		_tmp2_ = FALSE;
	}
	_tmp13_ = _tmp2_;
	if (_tmp13_) {
		while (TRUE) {
			gboolean _tmp14_ = FALSE;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gboolean _tmp19_;
			gchar* _tmp20_;
			_tmp15_ = self->priv->current;
			_tmp16_ = self->priv->end;
			if (_tmp15_ < _tmp16_) {
				gchar* _tmp17_;
				gchar _tmp18_;
				_tmp17_ = self->priv->current;
				_tmp18_ = _tmp17_[0];
				_tmp14_ = _tmp18_ != '\n';
			} else {
				_tmp14_ = FALSE;
			}
			_tmp19_ = _tmp14_;
			if (!_tmp19_) {
				break;
			}
			_tmp20_ = self->priv->current;
			self->priv->current = _tmp20_ + 1;
		}
		return;
	}
	vala_scanner_pp_whitespace (self);
	_tmp21_ = self->priv->current;
	begin = _tmp21_;
	len = 0;
	while (TRUE) {
		gboolean _tmp22_ = FALSE;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gboolean _tmp28_;
		gchar* _tmp29_;
		gint _tmp30_;
		gint _tmp31_;
		_tmp23_ = self->priv->current;
		_tmp24_ = self->priv->end;
		if (_tmp23_ < _tmp24_) {
			gchar* _tmp25_;
			gchar _tmp26_;
			gboolean _tmp27_ = FALSE;
			_tmp25_ = self->priv->current;
			_tmp26_ = _tmp25_[0];
			_tmp27_ = g_ascii_isalnum (_tmp26_);
			_tmp22_ = _tmp27_;
		} else {
			_tmp22_ = FALSE;
		}
		_tmp28_ = _tmp22_;
		if (!_tmp28_) {
			break;
		}
		_tmp29_ = self->priv->current;
		self->priv->current = _tmp29_ + 1;
		_tmp30_ = self->priv->column;
		self->priv->column = _tmp30_ + 1;
		_tmp31_ = len;
		len = _tmp31_ + 1;
	}
	_tmp33_ = len;
	if (_tmp33_ == 2) {
		gchar* _tmp34_;
		gboolean _tmp35_ = FALSE;
		_tmp34_ = begin;
		_tmp35_ = vala_scanner_matches (_tmp34_, "if");
		_tmp32_ = _tmp35_;
	} else {
		_tmp32_ = FALSE;
	}
	_tmp36_ = _tmp32_;
	if (_tmp36_) {
		vala_scanner_parse_pp_if (self);
	} else {
		gboolean _tmp37_ = FALSE;
		gint _tmp38_;
		gboolean _tmp41_;
		_tmp38_ = len;
		if (_tmp38_ == 4) {
			gchar* _tmp39_;
			gboolean _tmp40_ = FALSE;
			_tmp39_ = begin;
			_tmp40_ = vala_scanner_matches (_tmp39_, "elif");
			_tmp37_ = _tmp40_;
		} else {
			_tmp37_ = FALSE;
		}
		_tmp41_ = _tmp37_;
		if (_tmp41_) {
			vala_scanner_parse_pp_elif (self);
		} else {
			gboolean _tmp42_ = FALSE;
			gint _tmp43_;
			gboolean _tmp46_;
			_tmp43_ = len;
			if (_tmp43_ == 4) {
				gchar* _tmp44_;
				gboolean _tmp45_ = FALSE;
				_tmp44_ = begin;
				_tmp45_ = vala_scanner_matches (_tmp44_, "else");
				_tmp42_ = _tmp45_;
			} else {
				_tmp42_ = FALSE;
			}
			_tmp46_ = _tmp42_;
			if (_tmp46_) {
				vala_scanner_parse_pp_else (self);
			} else {
				gboolean _tmp47_ = FALSE;
				gint _tmp48_;
				gboolean _tmp51_;
				_tmp48_ = len;
				if (_tmp48_ == 5) {
					gchar* _tmp49_;
					gboolean _tmp50_ = FALSE;
					_tmp49_ = begin;
					_tmp50_ = vala_scanner_matches (_tmp49_, "endif");
					_tmp47_ = _tmp50_;
				} else {
					_tmp47_ = FALSE;
				}
				_tmp51_ = _tmp47_;
				if (_tmp51_) {
					vala_scanner_parse_pp_endif (self);
				} else {
					gint _tmp52_;
					gint _tmp53_;
					ValaSourceReference* _tmp54_ = NULL;
					ValaSourceReference* _tmp55_;
					_tmp52_ = len;
					_tmp53_ = len;
					_tmp54_ = vala_scanner_get_source_reference (self, -_tmp52_, _tmp53_);
					_tmp55_ = _tmp54_;
					vala_report_error (_tmp55_, "syntax error, invalid preprocessing directive");
					_vala_source_reference_unref0 (_tmp55_);
				}
			}
		}
	}
	_tmp57_ = self->priv->conditional_stack;
	_tmp57__length1 = self->priv->conditional_stack_length1;
	if (_tmp57__length1 > 0) {
		ValaScannerConditional* _tmp58_;
		gint _tmp58__length1;
		ValaScannerConditional* _tmp59_;
		gint _tmp59__length1;
		ValaScannerConditional _tmp60_;
		gboolean _tmp61_;
		_tmp58_ = self->priv->conditional_stack;
		_tmp58__length1 = self->priv->conditional_stack_length1;
		_tmp59_ = self->priv->conditional_stack;
		_tmp59__length1 = self->priv->conditional_stack_length1;
		_tmp60_ = _tmp58_[_tmp59__length1 - 1];
		_tmp61_ = _tmp60_.skip_section;
		_tmp56_ = _tmp61_;
	} else {
		_tmp56_ = FALSE;
	}
	_tmp62_ = _tmp56_;
	if (_tmp62_) {
		gboolean bol;
		bol = FALSE;
		while (TRUE) {
			gchar* _tmp63_;
			gchar* _tmp64_;
			gboolean _tmp65_ = FALSE;
			gboolean _tmp66_;
			gboolean _tmp69_;
			gchar* _tmp72_;
			gchar _tmp73_;
			gchar* _tmp78_;
			gint _tmp79_;
			_tmp63_ = self->priv->current;
			_tmp64_ = self->priv->end;
			if (!(_tmp63_ < _tmp64_)) {
				break;
			}
			_tmp66_ = bol;
			if (_tmp66_) {
				gchar* _tmp67_;
				gchar _tmp68_;
				_tmp67_ = self->priv->current;
				_tmp68_ = _tmp67_[0];
				_tmp65_ = _tmp68_ == '#';
			} else {
				_tmp65_ = FALSE;
			}
			_tmp69_ = _tmp65_;
			if (_tmp69_) {
				gchar* _tmp70_;
				gint _tmp71_;
				_tmp70_ = self->priv->current;
				_tmp71_ = self->priv->column;
				self->priv->current = _tmp70_ - (_tmp71_ - 1);
				self->priv->column = 1;
				return;
			}
			_tmp72_ = self->priv->current;
			_tmp73_ = _tmp72_[0];
			if (_tmp73_ == '\n') {
				gint _tmp74_;
				_tmp74_ = self->priv->line;
				self->priv->line = _tmp74_ + 1;
				self->priv->column = 0;
				bol = TRUE;
			} else {
				gchar* _tmp75_;
				gchar _tmp76_;
				gboolean _tmp77_ = FALSE;
				_tmp75_ = self->priv->current;
				_tmp76_ = _tmp75_[0];
				_tmp77_ = g_ascii_isspace (_tmp76_);
				if (!_tmp77_) {
					bol = FALSE;
				}
			}
			_tmp78_ = self->priv->current;
			self->priv->current = _tmp78_ + 1;
			_tmp79_ = self->priv->column;
			self->priv->column = _tmp79_ + 1;
		}
	}
}


static void vala_scanner_pp_eol (ValaScanner* self) {
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	vala_scanner_pp_whitespace (self);
	_tmp1_ = self->priv->current;
	_tmp2_ = self->priv->end;
	if (_tmp1_ >= _tmp2_) {
		_tmp0_ = TRUE;
	} else {
		gchar* _tmp3_;
		gchar _tmp4_;
		_tmp3_ = self->priv->current;
		_tmp4_ = _tmp3_[0];
		_tmp0_ = _tmp4_ != '\n';
	}
	_tmp5_ = _tmp0_;
	if (_tmp5_) {
		ValaSourceReference* _tmp6_ = NULL;
		ValaSourceReference* _tmp7_;
		_tmp6_ = vala_scanner_get_source_reference (self, 0, 0);
		_tmp7_ = _tmp6_;
		vala_report_error (_tmp7_, "syntax error, expected newline");
		_vala_source_reference_unref0 (_tmp7_);
	}
}


static void _vala_array_add23 (ValaScannerConditional** array, int* length, int* size, const ValaScannerConditional* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerConditional, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static void vala_scanner_parse_pp_if (ValaScanner* self) {
	gboolean _tmp0_ = FALSE;
	gboolean condition;
	ValaScannerConditional* _tmp1_;
	gint _tmp1__length1;
	ValaScannerConditional _tmp2_ = {0};
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_;
	gboolean _tmp12_;
	g_return_if_fail (self != NULL);
	vala_scanner_pp_whitespace (self);
	_tmp0_ = vala_scanner_parse_pp_expression (self);
	condition = _tmp0_;
	vala_scanner_pp_eol (self);
	_tmp1_ = self->priv->conditional_stack;
	_tmp1__length1 = self->priv->conditional_stack_length1;
	memset (&_tmp2_, 0, sizeof (ValaScannerConditional));
	_vala_array_add23 (&self->priv->conditional_stack, &self->priv->conditional_stack_length1, &self->priv->_conditional_stack_size_, &_tmp2_);
	_tmp4_ = condition;
	if (_tmp4_) {
		gboolean _tmp5_ = FALSE;
		ValaScannerConditional* _tmp6_;
		gint _tmp6__length1;
		gboolean _tmp11_;
		_tmp6_ = self->priv->conditional_stack;
		_tmp6__length1 = self->priv->conditional_stack_length1;
		if (_tmp6__length1 == 1) {
			_tmp5_ = TRUE;
		} else {
			ValaScannerConditional* _tmp7_;
			gint _tmp7__length1;
			ValaScannerConditional* _tmp8_;
			gint _tmp8__length1;
			ValaScannerConditional _tmp9_;
			gboolean _tmp10_;
			_tmp7_ = self->priv->conditional_stack;
			_tmp7__length1 = self->priv->conditional_stack_length1;
			_tmp8_ = self->priv->conditional_stack;
			_tmp8__length1 = self->priv->conditional_stack_length1;
			_tmp9_ = _tmp7_[_tmp8__length1 - 2];
			_tmp10_ = _tmp9_.skip_section;
			_tmp5_ = !_tmp10_;
		}
		_tmp11_ = _tmp5_;
		_tmp3_ = _tmp11_;
	} else {
		_tmp3_ = FALSE;
	}
	_tmp12_ = _tmp3_;
	if (_tmp12_) {
		ValaScannerConditional* _tmp13_;
		gint _tmp13__length1;
		ValaScannerConditional* _tmp14_;
		gint _tmp14__length1;
		_tmp13_ = self->priv->conditional_stack;
		_tmp13__length1 = self->priv->conditional_stack_length1;
		_tmp14_ = self->priv->conditional_stack;
		_tmp14__length1 = self->priv->conditional_stack_length1;
		_tmp13_[_tmp14__length1 - 1].matched = TRUE;
	} else {
		ValaScannerConditional* _tmp15_;
		gint _tmp15__length1;
		ValaScannerConditional* _tmp16_;
		gint _tmp16__length1;
		_tmp15_ = self->priv->conditional_stack;
		_tmp15__length1 = self->priv->conditional_stack_length1;
		_tmp16_ = self->priv->conditional_stack;
		_tmp16__length1 = self->priv->conditional_stack_length1;
		_tmp15_[_tmp16__length1 - 1].skip_section = TRUE;
	}
}


static void vala_scanner_parse_pp_elif (ValaScanner* self) {
	gboolean _tmp0_ = FALSE;
	gboolean condition;
	gboolean _tmp1_ = FALSE;
	ValaScannerConditional* _tmp2_;
	gint _tmp2__length1;
	gboolean _tmp7_;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_;
	gboolean _tmp17_;
	gboolean _tmp25_;
	g_return_if_fail (self != NULL);
	vala_scanner_pp_whitespace (self);
	_tmp0_ = vala_scanner_parse_pp_expression (self);
	condition = _tmp0_;
	vala_scanner_pp_eol (self);
	_tmp2_ = self->priv->conditional_stack;
	_tmp2__length1 = self->priv->conditional_stack_length1;
	if (_tmp2__length1 == 0) {
		_tmp1_ = TRUE;
	} else {
		ValaScannerConditional* _tmp3_;
		gint _tmp3__length1;
		ValaScannerConditional* _tmp4_;
		gint _tmp4__length1;
		ValaScannerConditional _tmp5_;
		gboolean _tmp6_;
		_tmp3_ = self->priv->conditional_stack;
		_tmp3__length1 = self->priv->conditional_stack_length1;
		_tmp4_ = self->priv->conditional_stack;
		_tmp4__length1 = self->priv->conditional_stack_length1;
		_tmp5_ = _tmp3_[_tmp4__length1 - 1];
		_tmp6_ = _tmp5_.else_found;
		_tmp1_ = _tmp6_;
	}
	_tmp7_ = _tmp1_;
	if (_tmp7_) {
		ValaSourceReference* _tmp8_ = NULL;
		ValaSourceReference* _tmp9_;
		_tmp8_ = vala_scanner_get_source_reference (self, 0, 0);
		_tmp9_ = _tmp8_;
		vala_report_error (_tmp9_, "syntax error, unexpected #elif");
		_vala_source_reference_unref0 (_tmp9_);
		return;
	}
	_tmp12_ = condition;
	if (_tmp12_) {
		ValaScannerConditional* _tmp13_;
		gint _tmp13__length1;
		ValaScannerConditional* _tmp14_;
		gint _tmp14__length1;
		ValaScannerConditional _tmp15_;
		gboolean _tmp16_;
		_tmp13_ = self->priv->conditional_stack;
		_tmp13__length1 = self->priv->conditional_stack_length1;
		_tmp14_ = self->priv->conditional_stack;
		_tmp14__length1 = self->priv->conditional_stack_length1;
		_tmp15_ = _tmp13_[_tmp14__length1 - 1];
		_tmp16_ = _tmp15_.matched;
		_tmp11_ = !_tmp16_;
	} else {
		_tmp11_ = FALSE;
	}
	_tmp17_ = _tmp11_;
	if (_tmp17_) {
		gboolean _tmp18_ = FALSE;
		ValaScannerConditional* _tmp19_;
		gint _tmp19__length1;
		gboolean _tmp24_;
		_tmp19_ = self->priv->conditional_stack;
		_tmp19__length1 = self->priv->conditional_stack_length1;
		if (_tmp19__length1 == 1) {
			_tmp18_ = TRUE;
		} else {
			ValaScannerConditional* _tmp20_;
			gint _tmp20__length1;
			ValaScannerConditional* _tmp21_;
			gint _tmp21__length1;
			ValaScannerConditional _tmp22_;
			gboolean _tmp23_;
			_tmp20_ = self->priv->conditional_stack;
			_tmp20__length1 = self->priv->conditional_stack_length1;
			_tmp21_ = self->priv->conditional_stack;
			_tmp21__length1 = self->priv->conditional_stack_length1;
			_tmp22_ = _tmp20_[_tmp21__length1 - 2];
			_tmp23_ = _tmp22_.skip_section;
			_tmp18_ = !_tmp23_;
		}
		_tmp24_ = _tmp18_;
		_tmp10_ = _tmp24_;
	} else {
		_tmp10_ = FALSE;
	}
	_tmp25_ = _tmp10_;
	if (_tmp25_) {
		ValaScannerConditional* _tmp26_;
		gint _tmp26__length1;
		ValaScannerConditional* _tmp27_;
		gint _tmp27__length1;
		ValaScannerConditional* _tmp28_;
		gint _tmp28__length1;
		ValaScannerConditional* _tmp29_;
		gint _tmp29__length1;
		_tmp26_ = self->priv->conditional_stack;
		_tmp26__length1 = self->priv->conditional_stack_length1;
		_tmp27_ = self->priv->conditional_stack;
		_tmp27__length1 = self->priv->conditional_stack_length1;
		_tmp26_[_tmp27__length1 - 1].matched = TRUE;
		_tmp28_ = self->priv->conditional_stack;
		_tmp28__length1 = self->priv->conditional_stack_length1;
		_tmp29_ = self->priv->conditional_stack;
		_tmp29__length1 = self->priv->conditional_stack_length1;
		_tmp28_[_tmp29__length1 - 1].skip_section = FALSE;
	} else {
		ValaScannerConditional* _tmp30_;
		gint _tmp30__length1;
		ValaScannerConditional* _tmp31_;
		gint _tmp31__length1;
		_tmp30_ = self->priv->conditional_stack;
		_tmp30__length1 = self->priv->conditional_stack_length1;
		_tmp31_ = self->priv->conditional_stack;
		_tmp31__length1 = self->priv->conditional_stack_length1;
		_tmp30_[_tmp31__length1 - 1].skip_section = TRUE;
	}
}


static void vala_scanner_parse_pp_else (ValaScanner* self) {
	gboolean _tmp0_ = FALSE;
	ValaScannerConditional* _tmp1_;
	gint _tmp1__length1;
	gboolean _tmp6_;
	gboolean _tmp9_ = FALSE;
	ValaScannerConditional* _tmp10_;
	gint _tmp10__length1;
	ValaScannerConditional* _tmp11_;
	gint _tmp11__length1;
	ValaScannerConditional _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp21_;
	g_return_if_fail (self != NULL);
	vala_scanner_pp_eol (self);
	_tmp1_ = self->priv->conditional_stack;
	_tmp1__length1 = self->priv->conditional_stack_length1;
	if (_tmp1__length1 == 0) {
		_tmp0_ = TRUE;
	} else {
		ValaScannerConditional* _tmp2_;
		gint _tmp2__length1;
		ValaScannerConditional* _tmp3_;
		gint _tmp3__length1;
		ValaScannerConditional _tmp4_;
		gboolean _tmp5_;
		_tmp2_ = self->priv->conditional_stack;
		_tmp2__length1 = self->priv->conditional_stack_length1;
		_tmp3_ = self->priv->conditional_stack;
		_tmp3__length1 = self->priv->conditional_stack_length1;
		_tmp4_ = _tmp2_[_tmp3__length1 - 1];
		_tmp5_ = _tmp4_.else_found;
		_tmp0_ = _tmp5_;
	}
	_tmp6_ = _tmp0_;
	if (_tmp6_) {
		ValaSourceReference* _tmp7_ = NULL;
		ValaSourceReference* _tmp8_;
		_tmp7_ = vala_scanner_get_source_reference (self, 0, 0);
		_tmp8_ = _tmp7_;
		vala_report_error (_tmp8_, "syntax error, unexpected #else");
		_vala_source_reference_unref0 (_tmp8_);
		return;
	}
	_tmp10_ = self->priv->conditional_stack;
	_tmp10__length1 = self->priv->conditional_stack_length1;
	_tmp11_ = self->priv->conditional_stack;
	_tmp11__length1 = self->priv->conditional_stack_length1;
	_tmp12_ = _tmp10_[_tmp11__length1 - 1];
	_tmp13_ = _tmp12_.matched;
	if (!_tmp13_) {
		gboolean _tmp14_ = FALSE;
		ValaScannerConditional* _tmp15_;
		gint _tmp15__length1;
		gboolean _tmp20_;
		_tmp15_ = self->priv->conditional_stack;
		_tmp15__length1 = self->priv->conditional_stack_length1;
		if (_tmp15__length1 == 1) {
			_tmp14_ = TRUE;
		} else {
			ValaScannerConditional* _tmp16_;
			gint _tmp16__length1;
			ValaScannerConditional* _tmp17_;
			gint _tmp17__length1;
			ValaScannerConditional _tmp18_;
			gboolean _tmp19_;
			_tmp16_ = self->priv->conditional_stack;
			_tmp16__length1 = self->priv->conditional_stack_length1;
			_tmp17_ = self->priv->conditional_stack;
			_tmp17__length1 = self->priv->conditional_stack_length1;
			_tmp18_ = _tmp16_[_tmp17__length1 - 2];
			_tmp19_ = _tmp18_.skip_section;
			_tmp14_ = !_tmp19_;
		}
		_tmp20_ = _tmp14_;
		_tmp9_ = _tmp20_;
	} else {
		_tmp9_ = FALSE;
	}
	_tmp21_ = _tmp9_;
	if (_tmp21_) {
		ValaScannerConditional* _tmp22_;
		gint _tmp22__length1;
		ValaScannerConditional* _tmp23_;
		gint _tmp23__length1;
		ValaScannerConditional* _tmp24_;
		gint _tmp24__length1;
		ValaScannerConditional* _tmp25_;
		gint _tmp25__length1;
		_tmp22_ = self->priv->conditional_stack;
		_tmp22__length1 = self->priv->conditional_stack_length1;
		_tmp23_ = self->priv->conditional_stack;
		_tmp23__length1 = self->priv->conditional_stack_length1;
		_tmp22_[_tmp23__length1 - 1].matched = TRUE;
		_tmp24_ = self->priv->conditional_stack;
		_tmp24__length1 = self->priv->conditional_stack_length1;
		_tmp25_ = self->priv->conditional_stack;
		_tmp25__length1 = self->priv->conditional_stack_length1;
		_tmp24_[_tmp25__length1 - 1].skip_section = FALSE;
	} else {
		ValaScannerConditional* _tmp26_;
		gint _tmp26__length1;
		ValaScannerConditional* _tmp27_;
		gint _tmp27__length1;
		_tmp26_ = self->priv->conditional_stack;
		_tmp26__length1 = self->priv->conditional_stack_length1;
		_tmp27_ = self->priv->conditional_stack;
		_tmp27__length1 = self->priv->conditional_stack_length1;
		_tmp26_[_tmp27__length1 - 1].skip_section = TRUE;
	}
}


static void vala_scanner_parse_pp_endif (ValaScanner* self) {
	ValaScannerConditional* _tmp0_;
	gint _tmp0__length1;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	vala_scanner_pp_eol (self);
	_tmp0_ = self->priv->conditional_stack;
	_tmp0__length1 = self->priv->conditional_stack_length1;
	if (_tmp0__length1 == 0) {
		ValaSourceReference* _tmp1_ = NULL;
		ValaSourceReference* _tmp2_;
		_tmp1_ = vala_scanner_get_source_reference (self, 0, 0);
		_tmp2_ = _tmp1_;
		vala_report_error (_tmp2_, "syntax error, unexpected #endif");
		_vala_source_reference_unref0 (_tmp2_);
		return;
	}
	_tmp3_ = self->priv->conditional_stack_length1;
	self->priv->conditional_stack_length1 = _tmp3_ - 1;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_;
		gint _tmp8_;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_;
		glong _tmp14_;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_;
		glong _tmp17_;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


static gboolean vala_scanner_parse_pp_symbol (ValaScanner* self) {
	gboolean result = FALSE;
	gint len;
	gint _tmp10_;
	gchar* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	gchar* _tmp16_ = NULL;
	gchar* identifier;
	gboolean defined = FALSE;
	const gchar* _tmp17_;
	g_return_val_if_fail (self != NULL, FALSE);
	len = 0;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gboolean _tmp6_;
		gchar* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		_tmp1_ = self->priv->current;
		_tmp2_ = self->priv->end;
		if (_tmp1_ < _tmp2_) {
			gchar* _tmp3_;
			gchar _tmp4_;
			gboolean _tmp5_ = FALSE;
			_tmp3_ = self->priv->current;
			_tmp4_ = _tmp3_[0];
			_tmp5_ = vala_scanner_is_ident_char (self, _tmp4_);
			_tmp0_ = _tmp5_;
		} else {
			_tmp0_ = FALSE;
		}
		_tmp6_ = _tmp0_;
		if (!_tmp6_) {
			break;
		}
		_tmp7_ = self->priv->current;
		self->priv->current = _tmp7_ + 1;
		_tmp8_ = self->priv->column;
		self->priv->column = _tmp8_ + 1;
		_tmp9_ = len;
		len = _tmp9_ + 1;
	}
	_tmp10_ = len;
	if (_tmp10_ == 0) {
		ValaSourceReference* _tmp11_ = NULL;
		ValaSourceReference* _tmp12_;
		_tmp11_ = vala_scanner_get_source_reference (self, 0, 0);
		_tmp12_ = _tmp11_;
		vala_report_error (_tmp12_, "syntax error, expected identifier");
		_vala_source_reference_unref0 (_tmp12_);
		result = FALSE;
		return result;
	}
	_tmp13_ = self->priv->current;
	_tmp14_ = len;
	_tmp15_ = len;
	_tmp16_ = string_substring ((const gchar*) (_tmp13_ - _tmp14_), (glong) 0, (glong) _tmp15_);
	identifier = _tmp16_;
	_tmp17_ = identifier;
	if (g_strcmp0 (_tmp17_, "true") == 0) {
		defined = TRUE;
	} else {
		const gchar* _tmp18_;
		_tmp18_ = identifier;
		if (g_strcmp0 (_tmp18_, "false") == 0) {
			defined = FALSE;
		} else {
			ValaSourceFile* _tmp19_;
			ValaCodeContext* _tmp20_;
			ValaCodeContext* _tmp21_;
			const gchar* _tmp22_;
			gboolean _tmp23_ = FALSE;
			_tmp19_ = self->priv->_source_file;
			_tmp20_ = vala_source_file_get_context (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = identifier;
			_tmp23_ = vala_code_context_is_defined (_tmp21_, _tmp22_);
			defined = _tmp23_;
		}
	}
	result = defined;
	_g_free0 (identifier);
	return result;
}


static gboolean vala_scanner_parse_pp_primary_expression (ValaScanner* self) {
	gboolean result = FALSE;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->current;
	_tmp1_ = self->priv->end;
	if (_tmp0_ >= _tmp1_) {
		ValaSourceReference* _tmp2_ = NULL;
		ValaSourceReference* _tmp3_;
		_tmp2_ = vala_scanner_get_source_reference (self, 0, 0);
		_tmp3_ = _tmp2_;
		vala_report_error (_tmp3_, "syntax error, expected identifier");
		_vala_source_reference_unref0 (_tmp3_);
	} else {
		gchar* _tmp4_;
		gchar _tmp5_;
		gboolean _tmp6_ = FALSE;
		_tmp4_ = self->priv->current;
		_tmp5_ = _tmp4_[0];
		_tmp6_ = vala_scanner_is_ident_char (self, _tmp5_);
		if (_tmp6_) {
			gboolean _tmp7_ = FALSE;
			_tmp7_ = vala_scanner_parse_pp_symbol (self);
			result = _tmp7_;
			return result;
		} else {
			gchar* _tmp8_;
			gchar _tmp9_;
			_tmp8_ = self->priv->current;
			_tmp9_ = _tmp8_[0];
			if (_tmp9_ == '(') {
				gchar* _tmp10_;
				gint _tmp11_;
				gboolean _tmp12_ = FALSE;
				gboolean _result_;
				gboolean _tmp13_ = FALSE;
				gchar* _tmp14_;
				gchar* _tmp15_;
				gboolean _tmp18_;
				_tmp10_ = self->priv->current;
				self->priv->current = _tmp10_ + 1;
				_tmp11_ = self->priv->column;
				self->priv->column = _tmp11_ + 1;
				vala_scanner_pp_whitespace (self);
				_tmp12_ = vala_scanner_parse_pp_expression (self);
				_result_ = _tmp12_;
				vala_scanner_pp_whitespace (self);
				_tmp14_ = self->priv->current;
				_tmp15_ = self->priv->end;
				if (_tmp14_ < _tmp15_) {
					gchar* _tmp16_;
					gchar _tmp17_;
					_tmp16_ = self->priv->current;
					_tmp17_ = _tmp16_[0];
					_tmp13_ = _tmp17_ == ')';
				} else {
					_tmp13_ = FALSE;
				}
				_tmp18_ = _tmp13_;
				if (_tmp18_) {
					gchar* _tmp19_;
					gint _tmp20_;
					_tmp19_ = self->priv->current;
					self->priv->current = _tmp19_ + 1;
					_tmp20_ = self->priv->column;
					self->priv->column = _tmp20_ + 1;
				} else {
					ValaSourceReference* _tmp21_ = NULL;
					ValaSourceReference* _tmp22_;
					_tmp21_ = vala_scanner_get_source_reference (self, 0, 0);
					_tmp22_ = _tmp21_;
					vala_report_error (_tmp22_, "syntax error, expected `)'");
					_vala_source_reference_unref0 (_tmp22_);
				}
				result = _result_;
				return result;
			} else {
				ValaSourceReference* _tmp23_ = NULL;
				ValaSourceReference* _tmp24_;
				_tmp23_ = vala_scanner_get_source_reference (self, 0, 0);
				_tmp24_ = _tmp23_;
				vala_report_error (_tmp24_, "syntax error, expected identifier");
				_vala_source_reference_unref0 (_tmp24_);
			}
		}
	}
	result = FALSE;
	return result;
}


static gboolean vala_scanner_parse_pp_unary_expression (ValaScanner* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp5_;
	gboolean _tmp9_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->current;
	_tmp2_ = self->priv->end;
	if (_tmp1_ < _tmp2_) {
		gchar* _tmp3_;
		gchar _tmp4_;
		_tmp3_ = self->priv->current;
		_tmp4_ = _tmp3_[0];
		_tmp0_ = _tmp4_ == '!';
	} else {
		_tmp0_ = FALSE;
	}
	_tmp5_ = _tmp0_;
	if (_tmp5_) {
		gchar* _tmp6_;
		gint _tmp7_;
		gboolean _tmp8_ = FALSE;
		_tmp6_ = self->priv->current;
		self->priv->current = _tmp6_ + 1;
		_tmp7_ = self->priv->column;
		self->priv->column = _tmp7_ + 1;
		vala_scanner_pp_whitespace (self);
		_tmp8_ = vala_scanner_parse_pp_unary_expression (self);
		result = !_tmp8_;
		return result;
	}
	_tmp9_ = vala_scanner_parse_pp_primary_expression (self);
	result = _tmp9_;
	return result;
}


static gboolean vala_scanner_parse_pp_equality_expression (ValaScanner* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean left;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_scanner_parse_pp_unary_expression (self);
	left = _tmp0_;
	vala_scanner_pp_whitespace (self);
	while (TRUE) {
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gboolean _tmp7_;
		gboolean _tmp10_;
		_tmp3_ = self->priv->current;
		_tmp4_ = self->priv->end;
		if (_tmp3_ < (_tmp4_ - 1)) {
			gchar* _tmp5_;
			gchar _tmp6_;
			_tmp5_ = self->priv->current;
			_tmp6_ = _tmp5_[0];
			_tmp2_ = _tmp6_ == '=';
		} else {
			_tmp2_ = FALSE;
		}
		_tmp7_ = _tmp2_;
		if (_tmp7_) {
			gchar* _tmp8_;
			gchar _tmp9_;
			_tmp8_ = self->priv->current;
			_tmp9_ = _tmp8_[1];
			_tmp1_ = _tmp9_ == '=';
		} else {
			_tmp1_ = FALSE;
		}
		_tmp10_ = _tmp1_;
		if (_tmp10_) {
			gchar* _tmp11_;
			gint _tmp12_;
			gboolean _tmp13_ = FALSE;
			gboolean right;
			gboolean _tmp14_;
			gboolean _tmp15_;
			_tmp11_ = self->priv->current;
			self->priv->current = _tmp11_ + 2;
			_tmp12_ = self->priv->column;
			self->priv->column = _tmp12_ + 2;
			vala_scanner_pp_whitespace (self);
			_tmp13_ = vala_scanner_parse_pp_unary_expression (self);
			right = _tmp13_;
			_tmp14_ = left;
			_tmp15_ = right;
			left = _tmp14_ == _tmp15_;
		} else {
			gboolean _tmp16_ = FALSE;
			gboolean _tmp17_ = FALSE;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gboolean _tmp22_;
			gboolean _tmp25_;
			_tmp18_ = self->priv->current;
			_tmp19_ = self->priv->end;
			if (_tmp18_ < (_tmp19_ - 1)) {
				gchar* _tmp20_;
				gchar _tmp21_;
				_tmp20_ = self->priv->current;
				_tmp21_ = _tmp20_[0];
				_tmp17_ = _tmp21_ == '!';
			} else {
				_tmp17_ = FALSE;
			}
			_tmp22_ = _tmp17_;
			if (_tmp22_) {
				gchar* _tmp23_;
				gchar _tmp24_;
				_tmp23_ = self->priv->current;
				_tmp24_ = _tmp23_[1];
				_tmp16_ = _tmp24_ == '=';
			} else {
				_tmp16_ = FALSE;
			}
			_tmp25_ = _tmp16_;
			if (_tmp25_) {
				gchar* _tmp26_;
				gint _tmp27_;
				gboolean _tmp28_ = FALSE;
				gboolean right;
				gboolean _tmp29_;
				gboolean _tmp30_;
				_tmp26_ = self->priv->current;
				self->priv->current = _tmp26_ + 2;
				_tmp27_ = self->priv->column;
				self->priv->column = _tmp27_ + 2;
				vala_scanner_pp_whitespace (self);
				_tmp28_ = vala_scanner_parse_pp_unary_expression (self);
				right = _tmp28_;
				_tmp29_ = left;
				_tmp30_ = right;
				left = _tmp29_ != _tmp30_;
			} else {
				break;
			}
		}
	}
	result = left;
	return result;
}


static gboolean vala_scanner_parse_pp_and_expression (ValaScanner* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean left;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_scanner_parse_pp_equality_expression (self);
	left = _tmp0_;
	vala_scanner_pp_whitespace (self);
	while (TRUE) {
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gboolean _tmp7_;
		gboolean _tmp10_;
		gchar* _tmp11_;
		gint _tmp12_;
		gboolean _tmp13_ = FALSE;
		gboolean right;
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_;
		gboolean _tmp17_;
		_tmp3_ = self->priv->current;
		_tmp4_ = self->priv->end;
		if (_tmp3_ < (_tmp4_ - 1)) {
			gchar* _tmp5_;
			gchar _tmp6_;
			_tmp5_ = self->priv->current;
			_tmp6_ = _tmp5_[0];
			_tmp2_ = _tmp6_ == '&';
		} else {
			_tmp2_ = FALSE;
		}
		_tmp7_ = _tmp2_;
		if (_tmp7_) {
			gchar* _tmp8_;
			gchar _tmp9_;
			_tmp8_ = self->priv->current;
			_tmp9_ = _tmp8_[1];
			_tmp1_ = _tmp9_ == '&';
		} else {
			_tmp1_ = FALSE;
		}
		_tmp10_ = _tmp1_;
		if (!_tmp10_) {
			break;
		}
		_tmp11_ = self->priv->current;
		self->priv->current = _tmp11_ + 2;
		_tmp12_ = self->priv->column;
		self->priv->column = _tmp12_ + 2;
		vala_scanner_pp_whitespace (self);
		_tmp13_ = vala_scanner_parse_pp_equality_expression (self);
		right = _tmp13_;
		_tmp15_ = left;
		if (_tmp15_) {
			gboolean _tmp16_;
			_tmp16_ = right;
			_tmp14_ = _tmp16_;
		} else {
			_tmp14_ = FALSE;
		}
		_tmp17_ = _tmp14_;
		left = _tmp17_;
	}
	result = left;
	return result;
}


static gboolean vala_scanner_parse_pp_or_expression (ValaScanner* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean left;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_scanner_parse_pp_and_expression (self);
	left = _tmp0_;
	vala_scanner_pp_whitespace (self);
	while (TRUE) {
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gboolean _tmp7_;
		gboolean _tmp10_;
		gchar* _tmp11_;
		gint _tmp12_;
		gboolean _tmp13_ = FALSE;
		gboolean right;
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_;
		gboolean _tmp17_;
		_tmp3_ = self->priv->current;
		_tmp4_ = self->priv->end;
		if (_tmp3_ < (_tmp4_ - 1)) {
			gchar* _tmp5_;
			gchar _tmp6_;
			_tmp5_ = self->priv->current;
			_tmp6_ = _tmp5_[0];
			_tmp2_ = _tmp6_ == '|';
		} else {
			_tmp2_ = FALSE;
		}
		_tmp7_ = _tmp2_;
		if (_tmp7_) {
			gchar* _tmp8_;
			gchar _tmp9_;
			_tmp8_ = self->priv->current;
			_tmp9_ = _tmp8_[1];
			_tmp1_ = _tmp9_ == '|';
		} else {
			_tmp1_ = FALSE;
		}
		_tmp10_ = _tmp1_;
		if (!_tmp10_) {
			break;
		}
		_tmp11_ = self->priv->current;
		self->priv->current = _tmp11_ + 2;
		_tmp12_ = self->priv->column;
		self->priv->column = _tmp12_ + 2;
		vala_scanner_pp_whitespace (self);
		_tmp13_ = vala_scanner_parse_pp_and_expression (self);
		right = _tmp13_;
		_tmp15_ = left;
		if (_tmp15_) {
			_tmp14_ = TRUE;
		} else {
			gboolean _tmp16_;
			_tmp16_ = right;
			_tmp14_ = _tmp16_;
		}
		_tmp17_ = _tmp14_;
		left = _tmp17_;
	}
	result = left;
	return result;
}


static gboolean vala_scanner_parse_pp_expression (ValaScanner* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_scanner_parse_pp_or_expression (self);
	result = _tmp0_;
	return result;
}


static gboolean vala_scanner_whitespace (ValaScanner* self) {
	gboolean result = FALSE;
	gboolean found;
	gint _tmp0_;
	gboolean bol;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_;
	gboolean _tmp18_;
	gboolean _tmp21_;
	g_return_val_if_fail (self != NULL, FALSE);
	found = FALSE;
	_tmp0_ = self->priv->column;
	bol = _tmp0_ == 1;
	while (TRUE) {
		gboolean _tmp1_ = FALSE;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gboolean _tmp7_;
		gchar* _tmp8_;
		gchar _tmp9_;
		gchar* _tmp11_;
		gint _tmp12_;
		_tmp2_ = self->priv->current;
		_tmp3_ = self->priv->end;
		if (_tmp2_ < _tmp3_) {
			gchar* _tmp4_;
			gchar _tmp5_;
			gboolean _tmp6_ = FALSE;
			_tmp4_ = self->priv->current;
			_tmp5_ = _tmp4_[0];
			_tmp6_ = g_ascii_isspace (_tmp5_);
			_tmp1_ = _tmp6_;
		} else {
			_tmp1_ = FALSE;
		}
		_tmp7_ = _tmp1_;
		if (!_tmp7_) {
			break;
		}
		_tmp8_ = self->priv->current;
		_tmp9_ = _tmp8_[0];
		if (_tmp9_ == '\n') {
			gint _tmp10_;
			_tmp10_ = self->priv->line;
			self->priv->line = _tmp10_ + 1;
			self->priv->column = 0;
			bol = TRUE;
		}
		found = TRUE;
		_tmp11_ = self->priv->current;
		self->priv->current = _tmp11_ + 1;
		_tmp12_ = self->priv->column;
		self->priv->column = _tmp12_ + 1;
	}
	_tmp15_ = bol;
	if (_tmp15_) {
		gchar* _tmp16_;
		gchar* _tmp17_;
		_tmp16_ = self->priv->current;
		_tmp17_ = self->priv->end;
		_tmp14_ = _tmp16_ < _tmp17_;
	} else {
		_tmp14_ = FALSE;
	}
	_tmp18_ = _tmp14_;
	if (_tmp18_) {
		gchar* _tmp19_;
		gchar _tmp20_;
		_tmp19_ = self->priv->current;
		_tmp20_ = _tmp19_[0];
		_tmp13_ = _tmp20_ == '#';
	} else {
		_tmp13_ = FALSE;
	}
	_tmp21_ = _tmp13_;
	if (_tmp21_) {
		vala_scanner_pp_directive (self);
		result = TRUE;
		return result;
	}
	result = found;
	return result;
}


static gboolean vala_scanner_comment (ValaScanner* self, gboolean file_comment) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar* _tmp3_;
	gboolean _tmp6_;
	gboolean _tmp9_;
	gboolean _tmp16_;
	gchar* _tmp17_;
	gchar _tmp18_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp3_ = self->priv->current;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = self->priv->current;
		_tmp5_ = self->priv->end;
		_tmp2_ = _tmp4_ > (_tmp5_ - 2);
	}
	_tmp6_ = _tmp2_;
	if (_tmp6_) {
		_tmp1_ = TRUE;
	} else {
		gchar* _tmp7_;
		gchar _tmp8_;
		_tmp7_ = self->priv->current;
		_tmp8_ = _tmp7_[0];
		_tmp1_ = _tmp8_ != '/';
	}
	_tmp9_ = _tmp1_;
	if (_tmp9_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp10_ = FALSE;
		gchar* _tmp11_;
		gchar _tmp12_;
		gboolean _tmp15_;
		_tmp11_ = self->priv->current;
		_tmp12_ = _tmp11_[1];
		if (_tmp12_ != '/') {
			gchar* _tmp13_;
			gchar _tmp14_;
			_tmp13_ = self->priv->current;
			_tmp14_ = _tmp13_[1];
			_tmp10_ = _tmp14_ != '*';
		} else {
			_tmp10_ = FALSE;
		}
		_tmp15_ = _tmp10_;
		_tmp0_ = _tmp15_;
	}
	_tmp16_ = _tmp0_;
	if (_tmp16_) {
		result = FALSE;
		return result;
	}
	_tmp17_ = self->priv->current;
	_tmp18_ = _tmp17_[1];
	if (_tmp18_ == '/') {
		ValaSourceReference* source_reference;
		gboolean _tmp19_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* begin;
		ValaSourceReference* _tmp30_;
		source_reference = NULL;
		_tmp19_ = file_comment;
		if (_tmp19_) {
			ValaSourceReference* _tmp20_ = NULL;
			_tmp20_ = vala_scanner_get_source_reference (self, 0, 0);
			_vala_source_reference_unref0 (source_reference);
			source_reference = _tmp20_;
		}
		_tmp21_ = self->priv->current;
		self->priv->current = _tmp21_ + 2;
		_tmp22_ = self->priv->current;
		begin = _tmp22_;
		while (TRUE) {
			gboolean _tmp23_ = FALSE;
			gchar* _tmp24_;
			gchar* _tmp25_;
			gboolean _tmp28_;
			gchar* _tmp29_;
			_tmp24_ = self->priv->current;
			_tmp25_ = self->priv->end;
			if (_tmp24_ < _tmp25_) {
				gchar* _tmp26_;
				gchar _tmp27_;
				_tmp26_ = self->priv->current;
				_tmp27_ = _tmp26_[0];
				_tmp23_ = _tmp27_ != '\n';
			} else {
				_tmp23_ = FALSE;
			}
			_tmp28_ = _tmp23_;
			if (!_tmp28_) {
				break;
			}
			_tmp29_ = self->priv->current;
			self->priv->current = _tmp29_ + 1;
		}
		_tmp30_ = source_reference;
		if (_tmp30_ != NULL) {
			gchar* _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_ = NULL;
			gchar* _tmp35_;
			ValaSourceReference* _tmp36_;
			gboolean _tmp37_;
			_tmp31_ = begin;
			_tmp32_ = self->priv->current;
			_tmp33_ = begin;
			_tmp34_ = string_substring ((const gchar*) _tmp31_, (glong) 0, (glong) (_tmp32_ - _tmp33_));
			_tmp35_ = _tmp34_;
			_tmp36_ = source_reference;
			_tmp37_ = file_comment;
			vala_scanner_push_comment (self, _tmp35_, _tmp36_, _tmp37_);
			_g_free0 (_tmp35_);
		}
		_vala_source_reference_unref0 (source_reference);
	} else {
		ValaSourceReference* source_reference;
		gboolean _tmp38_ = FALSE;
		gboolean _tmp39_;
		gboolean _tmp42_;
		gboolean _tmp43_ = FALSE;
		gchar* _tmp44_;
		gchar _tmp45_;
		gboolean _tmp47_;
		gchar* _tmp49_;
		gchar* _tmp50_;
		gchar* begin;
		gchar* _tmp66_;
		gchar* _tmp67_;
		ValaSourceReference* _tmp70_;
		gchar* _tmp78_;
		gint _tmp79_;
		source_reference = NULL;
		_tmp39_ = file_comment;
		if (_tmp39_) {
			gchar* _tmp40_;
			gchar _tmp41_;
			_tmp40_ = self->priv->current;
			_tmp41_ = _tmp40_[2];
			_tmp38_ = _tmp41_ == '*';
		} else {
			_tmp38_ = FALSE;
		}
		_tmp42_ = _tmp38_;
		if (_tmp42_) {
			result = FALSE;
			_vala_source_reference_unref0 (source_reference);
			return result;
		}
		_tmp44_ = self->priv->current;
		_tmp45_ = _tmp44_[2];
		if (_tmp45_ == '*') {
			_tmp43_ = TRUE;
		} else {
			gboolean _tmp46_;
			_tmp46_ = file_comment;
			_tmp43_ = _tmp46_;
		}
		_tmp47_ = _tmp43_;
		if (_tmp47_) {
			ValaSourceReference* _tmp48_ = NULL;
			_tmp48_ = vala_scanner_get_source_reference (self, 0, 0);
			_vala_source_reference_unref0 (source_reference);
			source_reference = _tmp48_;
		}
		_tmp49_ = self->priv->current;
		self->priv->current = _tmp49_ + 2;
		_tmp50_ = self->priv->current;
		begin = _tmp50_;
		while (TRUE) {
			gboolean _tmp51_ = FALSE;
			gchar* _tmp52_;
			gchar* _tmp53_;
			gboolean _tmp60_;
			gchar* _tmp61_;
			gchar _tmp62_;
			gchar* _tmp64_;
			gint _tmp65_;
			_tmp52_ = self->priv->current;
			_tmp53_ = self->priv->end;
			if (_tmp52_ < (_tmp53_ - 1)) {
				gboolean _tmp54_ = FALSE;
				gchar* _tmp55_;
				gchar _tmp56_;
				gboolean _tmp59_;
				_tmp55_ = self->priv->current;
				_tmp56_ = _tmp55_[0];
				if (_tmp56_ != '*') {
					_tmp54_ = TRUE;
				} else {
					gchar* _tmp57_;
					gchar _tmp58_;
					_tmp57_ = self->priv->current;
					_tmp58_ = _tmp57_[1];
					_tmp54_ = _tmp58_ != '/';
				}
				_tmp59_ = _tmp54_;
				_tmp51_ = _tmp59_;
			} else {
				_tmp51_ = FALSE;
			}
			_tmp60_ = _tmp51_;
			if (!_tmp60_) {
				break;
			}
			_tmp61_ = self->priv->current;
			_tmp62_ = _tmp61_[0];
			if (_tmp62_ == '\n') {
				gint _tmp63_;
				_tmp63_ = self->priv->line;
				self->priv->line = _tmp63_ + 1;
				self->priv->column = 0;
			}
			_tmp64_ = self->priv->current;
			self->priv->current = _tmp64_ + 1;
			_tmp65_ = self->priv->column;
			self->priv->column = _tmp65_ + 1;
		}
		_tmp66_ = self->priv->current;
		_tmp67_ = self->priv->end;
		if (_tmp66_ == (_tmp67_ - 1)) {
			ValaSourceReference* _tmp68_ = NULL;
			ValaSourceReference* _tmp69_;
			_tmp68_ = vala_scanner_get_source_reference (self, 0, 0);
			_tmp69_ = _tmp68_;
			vala_report_error (_tmp69_, "syntax error, expected */");
			_vala_source_reference_unref0 (_tmp69_);
			result = TRUE;
			_vala_source_reference_unref0 (source_reference);
			return result;
		}
		_tmp70_ = source_reference;
		if (_tmp70_ != NULL) {
			gchar* _tmp71_;
			gchar* _tmp72_;
			gchar* _tmp73_;
			gchar* _tmp74_ = NULL;
			gchar* _tmp75_;
			ValaSourceReference* _tmp76_;
			gboolean _tmp77_;
			_tmp71_ = begin;
			_tmp72_ = self->priv->current;
			_tmp73_ = begin;
			_tmp74_ = string_substring ((const gchar*) _tmp71_, (glong) 0, (glong) (_tmp72_ - _tmp73_));
			_tmp75_ = _tmp74_;
			_tmp76_ = source_reference;
			_tmp77_ = file_comment;
			vala_scanner_push_comment (self, _tmp75_, _tmp76_, _tmp77_);
			_g_free0 (_tmp75_);
		}
		_tmp78_ = self->priv->current;
		self->priv->current = _tmp78_ + 2;
		_tmp79_ = self->priv->column;
		self->priv->column = _tmp79_ + 2;
		_vala_source_reference_unref0 (source_reference);
	}
	result = TRUE;
	return result;
}


static void vala_scanner_space (ValaScanner* self) {
	g_return_if_fail (self != NULL);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gboolean _tmp3_;
		_tmp1_ = vala_scanner_whitespace (self);
		if (_tmp1_) {
			_tmp0_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			_tmp2_ = vala_scanner_comment (self, FALSE);
			_tmp0_ = _tmp2_;
		}
		_tmp3_ = _tmp0_;
		if (!_tmp3_) {
			break;
		}
	}
}


void vala_scanner_parse_file_comments (ValaScanner* self) {
	g_return_if_fail (self != NULL);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gboolean _tmp3_;
		_tmp1_ = vala_scanner_whitespace (self);
		if (_tmp1_) {
			_tmp0_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			_tmp2_ = vala_scanner_comment (self, TRUE);
			_tmp0_ = _tmp2_;
		}
		_tmp3_ = _tmp0_;
		if (!_tmp3_) {
			break;
		}
	}
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static void vala_scanner_push_comment (ValaScanner* self, const gchar* comment_item, ValaSourceReference* source_reference, gboolean file_comment) {
	const gchar* _tmp0_;
	gchar _tmp1_ = '\0';
	gboolean _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (comment_item != NULL);
	g_return_if_fail (source_reference != NULL);
	_tmp0_ = comment_item;
	_tmp1_ = string_get (_tmp0_, (glong) 0);
	if (_tmp1_ == '*') {
		ValaComment* _tmp2_;
		const gchar* _tmp5_;
		ValaSourceReference* _tmp6_;
		ValaComment* _tmp7_;
		_tmp2_ = self->priv->_comment;
		if (_tmp2_ != NULL) {
			ValaSourceFile* _tmp3_;
			ValaComment* _tmp4_;
			_tmp3_ = self->priv->_source_file;
			_tmp4_ = self->priv->_comment;
			vala_source_file_add_comment (_tmp3_, _tmp4_);
		}
		_tmp5_ = comment_item;
		_tmp6_ = source_reference;
		_tmp7_ = vala_comment_new (_tmp5_, _tmp6_);
		_vala_comment_unref0 (self->priv->_comment);
		self->priv->_comment = _tmp7_;
	}
	_tmp8_ = file_comment;
	if (_tmp8_) {
		ValaSourceFile* _tmp9_;
		const gchar* _tmp10_;
		ValaSourceReference* _tmp11_;
		ValaComment* _tmp12_;
		ValaComment* _tmp13_;
		_tmp9_ = self->priv->_source_file;
		_tmp10_ = comment_item;
		_tmp11_ = source_reference;
		_tmp12_ = vala_comment_new (_tmp10_, _tmp11_);
		_tmp13_ = _tmp12_;
		vala_source_file_add_comment (_tmp9_, _tmp13_);
		_vala_comment_unref0 (_tmp13_);
		_vala_comment_unref0 (self->priv->_comment);
		self->priv->_comment = NULL;
	}
}


/**
 * Clears and returns the content of the comment stack.
 *
 * @return saved comment
 */
static gpointer _vala_comment_ref0 (gpointer self) {
	return self ? vala_comment_ref (self) : NULL;
}


ValaComment* vala_scanner_pop_comment (ValaScanner* self) {
	ValaComment* result = NULL;
	ValaComment* _tmp0_;
	ValaComment* _tmp1_;
	ValaComment* _tmp2_;
	ValaComment* comment;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_comment;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->_comment;
	_tmp2_ = _vala_comment_ref0 (_tmp1_);
	comment = _tmp2_;
	_vala_comment_unref0 (self->priv->_comment);
	self->priv->_comment = NULL;
	result = comment;
	return result;
}


ValaSourceFile* vala_scanner_get_source_file (ValaScanner* self) {
	ValaSourceFile* result;
	ValaSourceFile* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_source_file;
	result = _tmp0_;
	return result;
}


static gpointer _vala_source_file_ref0 (gpointer self) {
	return self ? vala_source_file_ref (self) : NULL;
}


static void vala_scanner_set_source_file (ValaScanner* self, ValaSourceFile* value) {
	ValaSourceFile* _tmp0_;
	ValaSourceFile* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_source_file_ref0 (_tmp0_);
	_vala_source_file_unref0 (self->priv->_source_file);
	self->priv->_source_file = _tmp1_;
}


static ValaScannerConditional* vala_scanner_conditional_dup (const ValaScannerConditional* self) {
	ValaScannerConditional* dup;
	dup = g_new0 (ValaScannerConditional, 1);
	memcpy (dup, self, sizeof (ValaScannerConditional));
	return dup;
}


static void vala_scanner_conditional_free (ValaScannerConditional* self) {
	g_free (self);
}


static GType vala_scanner_conditional_get_type (void) {
	static volatile gsize vala_scanner_conditional_type_id__volatile = 0;
	if (g_once_init_enter (&vala_scanner_conditional_type_id__volatile)) {
		GType vala_scanner_conditional_type_id;
		vala_scanner_conditional_type_id = g_boxed_type_register_static ("ValaScannerConditional", (GBoxedCopyFunc) vala_scanner_conditional_dup, (GBoxedFreeFunc) vala_scanner_conditional_free);
		g_once_init_leave (&vala_scanner_conditional_type_id__volatile, vala_scanner_conditional_type_id);
	}
	return vala_scanner_conditional_type_id__volatile;
}


static void vala_value_scanner_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void vala_value_scanner_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		vala_scanner_unref (value->data[0].v_pointer);
	}
}


static void vala_value_scanner_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_scanner_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer vala_value_scanner_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* vala_value_scanner_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ValaScanner* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_scanner_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* vala_value_scanner_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ValaScanner** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_scanner_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* vala_param_spec_scanner (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ValaParamSpecScanner* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_SCANNER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer vala_value_get_scanner (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_SCANNER), NULL);
	return value->data[0].v_pointer;
}


void vala_value_set_scanner (GValue* value, gpointer v_object) {
	ValaScanner* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_SCANNER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_SCANNER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_scanner_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_scanner_unref (old);
	}
}


void vala_value_take_scanner (GValue* value, gpointer v_object) {
	ValaScanner* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_SCANNER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_SCANNER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_scanner_unref (old);
	}
}


static void vala_scanner_class_init (ValaScannerClass * klass) {
	vala_scanner_parent_class = g_type_class_peek_parent (klass);
	VALA_SCANNER_CLASS (klass)->finalize = vala_scanner_finalize;
	g_type_class_add_private (klass, sizeof (ValaScannerPrivate));
}


static void vala_scanner_instance_init (ValaScanner * self) {
	self->priv = VALA_SCANNER_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void vala_scanner_finalize (ValaScanner* obj) {
	ValaScanner * self;
	self = VALA_SCANNER (obj);
	_vala_source_file_unref0 (self->priv->_source_file);
	_vala_comment_unref0 (self->priv->_comment);
	self->priv->conditional_stack = (g_free (self->priv->conditional_stack), NULL);
	self->priv->state_stack = (g_free (self->priv->state_stack), NULL);
}


/**
 * Lexical scanner for Vala source files.
 */
GType vala_scanner_get_type (void) {
	static volatile gsize vala_scanner_type_id__volatile = 0;
	if (g_once_init_enter (&vala_scanner_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_scanner_init, vala_value_scanner_free_value, vala_value_scanner_copy_value, vala_value_scanner_peek_pointer, "p", vala_value_scanner_collect_value, "p", vala_value_scanner_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaScannerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_scanner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaScanner), 0, (GInstanceInitFunc) vala_scanner_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_scanner_type_id;
		vala_scanner_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaScanner", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_scanner_type_id__volatile, vala_scanner_type_id);
	}
	return vala_scanner_type_id__volatile;
}


gpointer vala_scanner_ref (gpointer instance) {
	ValaScanner* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void vala_scanner_unref (gpointer instance) {
	ValaScanner* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_SCANNER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



