/* valacompiler.c generated by valac, the Vala compiler
 * generated from valacompiler.vala, do not modify */

/* valacompiler.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 1996-2002, 2004, 2005, 2006 Free Software Foundation, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <valacodegen.h>
#include <glib/gstdio.h>
#include <unistd.h>
#include <locale.h>
#include <config.h>
#include <version.h>
#include <gobject/gvaluecollector.h>


#define VALA_TYPE_COMPILER (vala_compiler_get_type ())
#define VALA_COMPILER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_COMPILER, ValaCompiler))
#define VALA_COMPILER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_COMPILER, ValaCompilerClass))
#define VALA_IS_COMPILER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_COMPILER))
#define VALA_IS_COMPILER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_COMPILER))
#define VALA_COMPILER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_COMPILER, ValaCompilerClass))

typedef struct _ValaCompiler ValaCompiler;
typedef struct _ValaCompilerClass ValaCompilerClass;
typedef struct _ValaCompilerPrivate ValaCompilerPrivate;
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))
#define _vala_ccode_compiler_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_compiler_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_compiler_unref0(var) ((var == NULL) ? NULL : (var = (vala_compiler_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
typedef struct _ValaParamSpecCompiler ValaParamSpecCompiler;

struct _ValaCompiler {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCompilerPrivate * priv;
};

struct _ValaCompilerClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCompiler *self);
};

struct _ValaCompilerPrivate {
	ValaCodeContext* context;
};

struct _Block1Data {
	int _ref_count_;
	GMainLoop* loop;
	gint child_status;
};

struct _ValaParamSpecCompiler {
	GParamSpec parent_instance;
};


static gpointer vala_compiler_parent_class = NULL;
static gchar* vala_compiler_basedir;
static gchar* vala_compiler_basedir = NULL;
static gchar* vala_compiler_directory;
static gchar* vala_compiler_directory = NULL;
static gboolean vala_compiler_version;
static gboolean vala_compiler_version = FALSE;
static gchar** vala_compiler_sources;
static gchar** vala_compiler_sources = NULL;
static gchar** vala_compiler_vapi_directories;
static gchar** vala_compiler_vapi_directories = NULL;
static gchar** vala_compiler_gir_directories;
static gchar** vala_compiler_gir_directories = NULL;
static gchar** vala_compiler_metadata_directories;
static gchar** vala_compiler_metadata_directories = NULL;
static gchar* vala_compiler_vapi_filename;
static gchar* vala_compiler_vapi_filename = NULL;
static gchar* vala_compiler_library;
static gchar* vala_compiler_library = NULL;
static gchar* vala_compiler_gir;
static gchar* vala_compiler_gir = NULL;
static gchar** vala_compiler_packages;
static gchar** vala_compiler_packages = NULL;
static gchar** vala_compiler_fast_vapis;
static gchar** vala_compiler_fast_vapis = NULL;
static gchar* vala_compiler_target_glib;
static gchar* vala_compiler_target_glib = NULL;
static gboolean vala_compiler_ccode_only;
static gboolean vala_compiler_ccode_only = FALSE;
static gchar* vala_compiler_header_filename;
static gchar* vala_compiler_header_filename = NULL;
static gboolean vala_compiler_use_header;
static gboolean vala_compiler_use_header = FALSE;
static gchar* vala_compiler_internal_header_filename;
static gchar* vala_compiler_internal_header_filename = NULL;
static gchar* vala_compiler_internal_vapi_filename;
static gchar* vala_compiler_internal_vapi_filename = NULL;
static gchar* vala_compiler_fast_vapi_filename;
static gchar* vala_compiler_fast_vapi_filename = NULL;
static gchar* vala_compiler_symbols_filename;
static gchar* vala_compiler_symbols_filename = NULL;
static gchar* vala_compiler_includedir;
static gchar* vala_compiler_includedir = NULL;
static gboolean vala_compiler_compile_only;
static gboolean vala_compiler_compile_only = FALSE;
static gchar* vala_compiler_output;
static gchar* vala_compiler_output = NULL;
static gboolean vala_compiler_debug;
static gboolean vala_compiler_debug = FALSE;
static gboolean vala_compiler_thread;
static gboolean vala_compiler_thread = FALSE;
static gboolean vala_compiler_mem_profiler;
static gboolean vala_compiler_mem_profiler = FALSE;
static gboolean vala_compiler_disable_assert;
static gboolean vala_compiler_disable_assert = FALSE;
static gboolean vala_compiler_enable_checking;
static gboolean vala_compiler_enable_checking = FALSE;
static gboolean vala_compiler_deprecated;
static gboolean vala_compiler_deprecated = FALSE;
static gboolean vala_compiler_experimental;
static gboolean vala_compiler_experimental = FALSE;
static gboolean vala_compiler_experimental_non_null;
static gboolean vala_compiler_experimental_non_null = FALSE;
static gboolean vala_compiler_gobject_tracing;
static gboolean vala_compiler_gobject_tracing = FALSE;
static gboolean vala_compiler_disable_warnings;
static gboolean vala_compiler_disable_warnings = FALSE;
static gchar* vala_compiler_cc_command;
static gchar* vala_compiler_cc_command = NULL;
static gchar** vala_compiler_cc_options;
static gchar** vala_compiler_cc_options = NULL;
static gchar* vala_compiler_dump_tree;
static gchar* vala_compiler_dump_tree = NULL;
static gboolean vala_compiler_save_temps;
static gboolean vala_compiler_save_temps = FALSE;
static gchar** vala_compiler_defines;
static gchar** vala_compiler_defines = NULL;
static gboolean vala_compiler_quiet_mode;
static gboolean vala_compiler_quiet_mode = FALSE;
static gboolean vala_compiler_verbose_mode;
static gboolean vala_compiler_verbose_mode = FALSE;
static gchar* vala_compiler_profile;
static gchar* vala_compiler_profile = NULL;
static gboolean vala_compiler_nostdpkg;
static gboolean vala_compiler_nostdpkg = FALSE;
static gboolean vala_compiler_enable_version_header;
static gboolean vala_compiler_enable_version_header = FALSE;
static gboolean vala_compiler_disable_version_header;
static gboolean vala_compiler_disable_version_header = FALSE;
static gboolean vala_compiler_fatal_warnings;
static gboolean vala_compiler_fatal_warnings = FALSE;
static gchar* vala_compiler_dependencies;
static gchar* vala_compiler_dependencies = NULL;
static gchar* vala_compiler_entry_point;
static gchar* vala_compiler_entry_point = NULL;
static gboolean vala_compiler_run_output;
static gboolean vala_compiler_run_output = FALSE;

gpointer vala_compiler_ref (gpointer instance);
void vala_compiler_unref (gpointer instance);
GParamSpec* vala_param_spec_compiler (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_compiler (GValue* value, gpointer v_object);
void vala_value_take_compiler (GValue* value, gpointer v_object);
gpointer vala_value_get_compiler (const GValue* value);
GType vala_compiler_get_type (void) G_GNUC_CONST;
#define VALA_COMPILER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_COMPILER, ValaCompilerPrivate))
enum  {
	VALA_COMPILER_DUMMY_PROPERTY
};
static gint vala_compiler_quit (ValaCompiler* self);
static gint vala_compiler_run (ValaCompiler* self);
static gchar** _vala_array_dup1 (gchar** self, int length);
static gchar** _vala_array_dup2 (gchar** self, int length);
static gchar** _vala_array_dup3 (gchar** self, int length);
static gint vala_compiler_run_source (gchar** args, int args_length1);
ValaCompiler* vala_compiler_new (void);
ValaCompiler* vala_compiler_construct (GType object_type);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void ___lambda2_ (Block1Data* _data1_, GPid pid, gint status);
static void ____lambda2__gchild_watch_func (GPid pid, gint status, gpointer self);
static gint vala_compiler_main (gchar** args, int args_length1);
static void vala_compiler_finalize (ValaCompiler* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GOptionEntry VALA_COMPILER_options[48] = {{"vapidir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_vapi_directories, "Look for package bindings in DIRECTORY", "DIRECTORY..."}, {"girdir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_gir_directories, "Look for .gir files in DIRECTORY", "DIRECTORY..."}, {"metadatadir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_metadata_directories, "Look for GIR .metadata files in DIRECTORY", "DIRECTORY..."}, {"pkg", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_packages, "Include binding for PACKAGE", "PACKAGE..."}, {"vapi", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_vapi_filename, "Output VAPI file name", "FILE"}, {"library", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_library, "Library name", "NAME"}, {"gir", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_gir, "GObject-Introspection repository file name", "NAME-VERSION.gir"}, {"basedir", 'b', 0, G_OPTION_ARG_FILENAME, &vala_compiler_basedir, "Base source directory", "DIRECTORY"}, {"directory", 'd', 0, G_OPTION_ARG_FILENAME, &vala_compiler_directory, "Output directory", "DIRECTORY"}, {"version", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_version, "Display version number", NULL}, {"ccode", 'C', 0, G_OPTION_ARG_NONE, &vala_compiler_ccode_only, "Output C code", NULL}, {"header", 'H', 0, G_OPTION_ARG_FILENAME, &vala_compiler_header_filename, "Output C header file", "FILE"}, {"use-header", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_use_header, "Use C header file", NULL}, {"includedir", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_includedir, "Directory used to include the C header file", "DIRECTORY"}, {"internal-header", 'h', 0, G_OPTION_ARG_FILENAME, &vala_compiler_internal_header_filename, "Output internal C header file", "FILE"}, {"internal-vapi", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_internal_vapi_filename, "Output vapi with internal api", "FILE"}, {"fast-vapi", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_fast_vapi_filename, "Output vapi without performing symbol resolution", NULL}, {"use-fast-vapi", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_fast_vapis, "Use --fast-vapi output during this compile", NULL}, {"deps", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_dependencies, "Write make-style dependency information to this file", NULL}, {"symbols", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_symbols_filename, "Output symbols file", "FILE"}, {"compile", 'c', 0, G_OPTION_ARG_NONE, &vala_compiler_compile_only, "Compile but do not link", NULL}, {"output", 'o', 0, G_OPTION_ARG_FILENAME, &vala_compiler_output, "Place output in file FILE", "FILE"}, {"debug", 'g', 0, G_OPTION_ARG_NONE, &vala_compiler_debug, "Produce debug information", NULL}, {"thread", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_thread, "Enable multithreading support", NULL}, {"enable-mem-profiler", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_mem_profiler, "Enable GLib memory profiler", NULL}, {"define", 'D', 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_defines, "Define SYMBOL", "SYMBOL..."}, {"main", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_entry_point, "Use SYMBOL as entry point", "SYMBOL..."}, {"nostdpkg", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_nostdpkg, "Do not include standard packages", NULL}, {"disable-assert", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_assert, "Disable assertions", NULL}, {"enable-checking", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_enable_checking, "Enable additional run-time checks", NULL}, {"enable-deprecated", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_deprecated, "Enable deprecated features", NULL}, {"enable-experimental", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_experimental, "Enable experimental features", NULL}, {"disable-warnings", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_warnings, "Disable warnings", NULL}, {"fatal-warnings", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_fatal_warnings, "Treat warnings as fatal", NULL}, {"enable-experimental-non-null", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_experimental_non_null, "Enable experimental enhancements for non-null types", NULL}, {"enable-gobject-tracing", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_gobject_tracing, "Enable GObject creation tracing", NULL}, {"cc", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_cc_command, "Use COMMAND as C compiler command", "COMMAND"}, {"Xcc", 'X', 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_cc_options, "Pass OPTION to the C compiler", "OPTION..."}, {"dump-tree", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_dump_tree, "Write code tree to FILE", "FILE"}, {"save-temps", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_save_temps, "Keep temporary files", NULL}, {"profile", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_profile, "Use the given profile instead of the default", "PROFILE"}, {"quiet", 'q', 0, G_OPTION_ARG_NONE, &vala_compiler_quiet_mode, "Do not print messages to the console", NULL}, {"verbose", 'v', 0, G_OPTION_ARG_NONE, &vala_compiler_verbose_mode, "Print additional messages to the console", NULL}, {"target-glib", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_target_glib, "Target version of glib for code generation", "MAJOR.MINOR"}, {"enable-version-header", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_enable_version_header, "Write vala build version in generated files", NULL}, {"disable-version-header", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_version_header, "Do not write vala build version in generated files", NULL}, {"", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_sources, NULL, "FILE..."}, {NULL}};

static gint vala_compiler_quit (ValaCompiler* self) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	ValaCodeContext* _tmp1_;
	ValaReport* _tmp2_;
	ValaReport* _tmp3_;
	gint _tmp4_ = 0;
	gboolean _tmp9_;
	gboolean _tmp10_ = FALSE;
	ValaCodeContext* _tmp11_;
	ValaReport* _tmp12_;
	ValaReport* _tmp13_;
	gint _tmp14_ = 0;
	gboolean _tmp22_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp1_ = self->priv->context;
	_tmp2_ = vala_code_context_get_report (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_report_get_errors (_tmp3_);
	if (_tmp4_ == 0) {
		ValaCodeContext* _tmp5_;
		ValaReport* _tmp6_;
		ValaReport* _tmp7_;
		gint _tmp8_ = 0;
		_tmp5_ = self->priv->context;
		_tmp6_ = vala_code_context_get_report (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_report_get_warnings (_tmp7_);
		_tmp0_ = _tmp8_ == 0;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp9_ = _tmp0_;
	if (_tmp9_) {
		result = 0;
		return result;
	}
	_tmp11_ = self->priv->context;
	_tmp12_ = vala_code_context_get_report (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_report_get_errors (_tmp13_);
	if (_tmp14_ == 0) {
		gboolean _tmp15_ = FALSE;
		gboolean _tmp16_;
		gboolean _tmp21_;
		_tmp16_ = vala_compiler_fatal_warnings;
		if (!_tmp16_) {
			_tmp15_ = TRUE;
		} else {
			ValaCodeContext* _tmp17_;
			ValaReport* _tmp18_;
			ValaReport* _tmp19_;
			gint _tmp20_ = 0;
			_tmp17_ = self->priv->context;
			_tmp18_ = vala_code_context_get_report (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = vala_report_get_warnings (_tmp19_);
			_tmp15_ = _tmp20_ == 0;
		}
		_tmp21_ = _tmp15_;
		_tmp10_ = _tmp21_;
	} else {
		_tmp10_ = FALSE;
	}
	_tmp22_ = _tmp10_;
	if (_tmp22_) {
		gboolean _tmp23_;
		_tmp23_ = vala_compiler_quiet_mode;
		if (!_tmp23_) {
			FILE* _tmp24_;
			ValaCodeContext* _tmp25_;
			ValaReport* _tmp26_;
			ValaReport* _tmp27_;
			gint _tmp28_ = 0;
			_tmp24_ = stdout;
			_tmp25_ = self->priv->context;
			_tmp26_ = vala_code_context_get_report (_tmp25_);
			_tmp27_ = _tmp26_;
			_tmp28_ = vala_report_get_warnings (_tmp27_);
			fprintf (_tmp24_, "Compilation succeeded - %d warning(s)\n", _tmp28_);
		}
		result = 0;
		return result;
	} else {
		gboolean _tmp29_;
		_tmp29_ = vala_compiler_quiet_mode;
		if (!_tmp29_) {
			FILE* _tmp30_;
			ValaCodeContext* _tmp31_;
			ValaReport* _tmp32_;
			ValaReport* _tmp33_;
			gint _tmp34_ = 0;
			ValaCodeContext* _tmp35_;
			ValaReport* _tmp36_;
			ValaReport* _tmp37_;
			gint _tmp38_ = 0;
			_tmp30_ = stdout;
			_tmp31_ = self->priv->context;
			_tmp32_ = vala_code_context_get_report (_tmp31_);
			_tmp33_ = _tmp32_;
			_tmp34_ = vala_report_get_errors (_tmp33_);
			_tmp35_ = self->priv->context;
			_tmp36_ = vala_code_context_get_report (_tmp35_);
			_tmp37_ = _tmp36_;
			_tmp38_ = vala_report_get_warnings (_tmp37_);
			fprintf (_tmp30_, "Compilation failed: %d error(s), %d warning(s)\n", _tmp34_, _tmp38_);
		}
		result = 1;
		return result;
	}
}


static gint string_last_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gint _tmp0_;
	gunichar _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _result_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = c;
	_tmp2_ = g_utf8_strrchr (((gchar*) self) + _tmp0_, (gssize) (-1), _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_;
		gint _tmp8_;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_;
		glong _tmp14_;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_;
		glong _tmp17_;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup3 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static gint vala_compiler_run (ValaCompiler* self) {
	gint result = 0;
	ValaCodeContext* _tmp0_;
	ValaCodeContext* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_;
	gboolean _tmp6_;
	gboolean _tmp8_;
	ValaCodeContext* _tmp21_;
	gboolean _tmp22_;
	ValaCodeContext* _tmp23_;
	gboolean _tmp24_;
	ValaCodeContext* _tmp25_;
	gboolean _tmp26_;
	ValaCodeContext* _tmp27_;
	gboolean _tmp28_;
	ValaCodeContext* _tmp29_;
	gboolean _tmp30_;
	ValaCodeContext* _tmp31_;
	gboolean _tmp32_;
	ValaCodeContext* _tmp33_;
	ValaReport* _tmp34_;
	ValaReport* _tmp35_;
	gboolean _tmp36_;
	ValaCodeContext* _tmp37_;
	ValaReport* _tmp38_;
	ValaReport* _tmp39_;
	gboolean _tmp40_;
	ValaCodeContext* _tmp41_;
	gboolean _tmp42_;
	ValaCodeContext* _tmp43_;
	gboolean _tmp44_;
	ValaCodeContext* _tmp45_;
	gboolean _tmp46_;
	ValaCodeContext* _tmp47_;
	gboolean _tmp48_;
	ValaCodeContext* _tmp49_;
	const gchar* _tmp50_;
	gboolean _tmp51_ = FALSE;
	const gchar* _tmp52_;
	gboolean _tmp54_;
	ValaCodeContext* _tmp55_;
	gboolean _tmp56_;
	ValaCodeContext* _tmp57_;
	const gchar* _tmp58_;
	ValaCodeContext* _tmp59_;
	const gchar* _tmp60_;
	ValaCodeContext* _tmp61_;
	const gchar* _tmp62_;
	ValaCodeContext* _tmp63_;
	const gchar* _tmp64_;
	const gchar* _tmp65_;
	const gchar* _tmp73_;
	ValaCodeContext* _tmp82_;
	gchar** _tmp83_;
	gint _tmp83__length1;
	gchar** _tmp84_;
	gint _tmp84__length1;
	ValaCodeContext* _tmp85_;
	gchar** _tmp86_;
	gint _tmp86__length1;
	gchar** _tmp87_;
	gint _tmp87__length1;
	ValaCodeContext* _tmp88_;
	gchar** _tmp89_;
	gint _tmp89__length1;
	gchar** _tmp90_;
	gint _tmp90__length1;
	ValaCodeContext* _tmp91_;
	gboolean _tmp92_;
	ValaCodeContext* _tmp93_;
	gboolean _tmp94_;
	ValaCodeContext* _tmp95_;
	gboolean _tmp96_;
	ValaCodeContext* _tmp97_;
	gboolean _tmp98_;
	const gchar* _tmp99_;
	gboolean _tmp117_;
	const gchar* _tmp118_;
	ValaCodeContext* _tmp119_;
	gboolean _tmp120_;
	ValaCodeContext* _tmp121_;
	const gchar* _tmp122_;
	ValaCodeContext* _tmp123_;
	gboolean _tmp124_;
	gchar** _tmp125_;
	gint _tmp125__length1;
	ValaCodeContext* _tmp138_;
	ValaProfile _tmp139_;
	ValaProfile _tmp140_;
	gchar** _tmp175_;
	gint _tmp175__length1;
	gchar** _tmp180_;
	gint _tmp180__length1;
	gboolean _tmp190_ = FALSE;
	ValaCodeContext* _tmp191_;
	ValaReport* _tmp192_;
	ValaReport* _tmp193_;
	gint _tmp194_ = 0;
	gboolean _tmp202_;
	ValaCodeContext* _tmp204_;
	ValaProfile _tmp205_;
	ValaProfile _tmp206_;
	gboolean has_c_files;
	gchar** _tmp219_;
	gint _tmp219__length1;
	gboolean _tmp227_ = FALSE;
	ValaCodeContext* _tmp228_;
	ValaReport* _tmp229_;
	ValaReport* _tmp230_;
	gint _tmp231_ = 0;
	gboolean _tmp239_;
	ValaParser* _tmp241_;
	ValaParser* parser;
	ValaParser* _tmp242_;
	ValaCodeContext* _tmp243_;
	ValaGenieParser* _tmp244_;
	ValaGenieParser* genie_parser;
	ValaGenieParser* _tmp245_;
	ValaCodeContext* _tmp246_;
	ValaGirParser* _tmp247_;
	ValaGirParser* gir_parser;
	ValaGirParser* _tmp248_;
	ValaCodeContext* _tmp249_;
	gboolean _tmp250_ = FALSE;
	ValaCodeContext* _tmp251_;
	ValaReport* _tmp252_;
	ValaReport* _tmp253_;
	gint _tmp254_ = 0;
	gboolean _tmp262_;
	const gchar* _tmp264_;
	ValaCodeContext* _tmp270_;
	gboolean _tmp271_ = FALSE;
	ValaCodeContext* _tmp272_;
	ValaReport* _tmp273_;
	ValaReport* _tmp274_;
	gint _tmp275_ = 0;
	gboolean _tmp283_;
	gboolean _tmp285_ = FALSE;
	gboolean _tmp286_ = FALSE;
	gboolean _tmp287_;
	gboolean _tmp289_;
	gboolean _tmp291_;
	const gchar* _tmp298_;
	gboolean _tmp303_ = FALSE;
	ValaCodeContext* _tmp304_;
	ValaReport* _tmp305_;
	ValaReport* _tmp306_;
	gint _tmp307_ = 0;
	gboolean _tmp315_;
	ValaCodeContext* _tmp317_;
	ValaCodeGenerator* _tmp318_;
	ValaCodeGenerator* _tmp319_;
	ValaCodeContext* _tmp320_;
	gboolean _tmp321_ = FALSE;
	ValaCodeContext* _tmp322_;
	ValaReport* _tmp323_;
	ValaReport* _tmp324_;
	gint _tmp325_ = 0;
	gboolean _tmp333_;
	gboolean _tmp335_ = FALSE;
	const gchar* _tmp336_;
	gboolean _tmp338_;
	const gchar* _tmp341_;
	const gchar* _tmp397_;
	const gchar* _tmp412_;
	const gchar* _tmp437_;
	gboolean _tmp440_;
	gint _tmp458_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = vala_code_context_new ();
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = _tmp0_;
	_tmp1_ = self->priv->context;
	vala_code_context_push (_tmp1_);
	_tmp4_ = vala_compiler_ccode_only;
	if (!_tmp4_) {
		gboolean _tmp5_;
		_tmp5_ = vala_compiler_compile_only;
		_tmp3_ = !_tmp5_;
	} else {
		_tmp3_ = FALSE;
	}
	_tmp6_ = _tmp3_;
	if (_tmp6_) {
		const gchar* _tmp7_;
		_tmp7_ = vala_compiler_output;
		_tmp2_ = _tmp7_ == NULL;
	} else {
		_tmp2_ = FALSE;
	}
	_tmp8_ = _tmp2_;
	if (_tmp8_) {
		gchar** _tmp9_;
		gint _tmp9__length1;
		const gchar* _tmp10_;
		gint _tmp11_ = 0;
		_tmp9_ = vala_compiler_sources;
		_tmp9__length1 = _vala_array_length (vala_compiler_sources);
		_tmp10_ = _tmp9_[0];
		_tmp11_ = string_last_index_of_char (_tmp10_, (gunichar) '.', 0);
		if (_tmp11_ != (-1)) {
			gchar** _tmp12_;
			gint _tmp12__length1;
			const gchar* _tmp13_;
			gint _tmp14_ = 0;
			gint dot;
			gchar** _tmp15_;
			gint _tmp15__length1;
			const gchar* _tmp16_;
			gint _tmp17_;
			gchar* _tmp18_ = NULL;
			gchar* _tmp19_;
			gchar* _tmp20_ = NULL;
			_tmp12_ = vala_compiler_sources;
			_tmp12__length1 = _vala_array_length (vala_compiler_sources);
			_tmp13_ = _tmp12_[0];
			_tmp14_ = string_last_index_of_char (_tmp13_, (gunichar) '.', 0);
			dot = _tmp14_;
			_tmp15_ = vala_compiler_sources;
			_tmp15__length1 = _vala_array_length (vala_compiler_sources);
			_tmp16_ = _tmp15_[0];
			_tmp17_ = dot;
			_tmp18_ = string_substring (_tmp16_, (glong) 0, (glong) _tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = g_path_get_basename (_tmp19_);
			_g_free0 (vala_compiler_output);
			vala_compiler_output = _tmp20_;
			_g_free0 (_tmp19_);
		}
	}
	_tmp21_ = self->priv->context;
	_tmp22_ = vala_compiler_disable_assert;
	vala_code_context_set_assert (_tmp21_, !_tmp22_);
	_tmp23_ = self->priv->context;
	_tmp24_ = vala_compiler_enable_checking;
	vala_code_context_set_checking (_tmp23_, _tmp24_);
	_tmp25_ = self->priv->context;
	_tmp26_ = vala_compiler_deprecated;
	vala_code_context_set_deprecated (_tmp25_, _tmp26_);
	_tmp27_ = self->priv->context;
	_tmp28_ = vala_compiler_experimental;
	vala_code_context_set_experimental (_tmp27_, _tmp28_);
	_tmp29_ = self->priv->context;
	_tmp30_ = vala_compiler_experimental_non_null;
	vala_code_context_set_experimental_non_null (_tmp29_, _tmp30_);
	_tmp31_ = self->priv->context;
	_tmp32_ = vala_compiler_gobject_tracing;
	vala_code_context_set_gobject_tracing (_tmp31_, _tmp32_);
	_tmp33_ = self->priv->context;
	_tmp34_ = vala_code_context_get_report (_tmp33_);
	_tmp35_ = _tmp34_;
	_tmp36_ = vala_compiler_disable_warnings;
	vala_report_set_enable_warnings (_tmp35_, !_tmp36_);
	_tmp37_ = self->priv->context;
	_tmp38_ = vala_code_context_get_report (_tmp37_);
	_tmp39_ = _tmp38_;
	_tmp40_ = vala_compiler_quiet_mode;
	vala_report_set_verbose_errors (_tmp39_, !_tmp40_);
	_tmp41_ = self->priv->context;
	_tmp42_ = vala_compiler_verbose_mode;
	vala_code_context_set_verbose_mode (_tmp41_, _tmp42_);
	_tmp43_ = self->priv->context;
	_tmp44_ = vala_compiler_disable_version_header;
	vala_code_context_set_version_header (_tmp43_, !_tmp44_);
	_tmp45_ = self->priv->context;
	_tmp46_ = vala_compiler_ccode_only;
	vala_code_context_set_ccode_only (_tmp45_, _tmp46_);
	_tmp47_ = self->priv->context;
	_tmp48_ = vala_compiler_compile_only;
	vala_code_context_set_compile_only (_tmp47_, _tmp48_);
	_tmp49_ = self->priv->context;
	_tmp50_ = vala_compiler_header_filename;
	vala_code_context_set_header_filename (_tmp49_, _tmp50_);
	_tmp52_ = vala_compiler_header_filename;
	if (_tmp52_ == NULL) {
		gboolean _tmp53_;
		_tmp53_ = vala_compiler_use_header;
		_tmp51_ = _tmp53_;
	} else {
		_tmp51_ = FALSE;
	}
	_tmp54_ = _tmp51_;
	if (_tmp54_) {
		vala_report_error (NULL, "--use-header may only be used in combination with --header");
	}
	_tmp55_ = self->priv->context;
	_tmp56_ = vala_compiler_use_header;
	vala_code_context_set_use_header (_tmp55_, _tmp56_);
	_tmp57_ = self->priv->context;
	_tmp58_ = vala_compiler_internal_header_filename;
	vala_code_context_set_internal_header_filename (_tmp57_, _tmp58_);
	_tmp59_ = self->priv->context;
	_tmp60_ = vala_compiler_symbols_filename;
	vala_code_context_set_symbols_filename (_tmp59_, _tmp60_);
	_tmp61_ = self->priv->context;
	_tmp62_ = vala_compiler_includedir;
	vala_code_context_set_includedir (_tmp61_, _tmp62_);
	_tmp63_ = self->priv->context;
	_tmp64_ = vala_compiler_output;
	vala_code_context_set_output (_tmp63_, _tmp64_);
	_tmp65_ = vala_compiler_basedir;
	if (_tmp65_ == NULL) {
		ValaCodeContext* _tmp66_;
		gchar* _tmp67_ = NULL;
		gchar* _tmp68_;
		_tmp66_ = self->priv->context;
		_tmp67_ = vala_code_context_realpath (".");
		_tmp68_ = _tmp67_;
		vala_code_context_set_basedir (_tmp66_, _tmp68_);
		_g_free0 (_tmp68_);
	} else {
		ValaCodeContext* _tmp69_;
		const gchar* _tmp70_;
		gchar* _tmp71_ = NULL;
		gchar* _tmp72_;
		_tmp69_ = self->priv->context;
		_tmp70_ = vala_compiler_basedir;
		_tmp71_ = vala_code_context_realpath (_tmp70_);
		_tmp72_ = _tmp71_;
		vala_code_context_set_basedir (_tmp69_, _tmp72_);
		_g_free0 (_tmp72_);
	}
	_tmp73_ = vala_compiler_directory;
	if (_tmp73_ != NULL) {
		ValaCodeContext* _tmp74_;
		const gchar* _tmp75_;
		gchar* _tmp76_ = NULL;
		gchar* _tmp77_;
		_tmp74_ = self->priv->context;
		_tmp75_ = vala_compiler_directory;
		_tmp76_ = vala_code_context_realpath (_tmp75_);
		_tmp77_ = _tmp76_;
		vala_code_context_set_directory (_tmp74_, _tmp77_);
		_g_free0 (_tmp77_);
	} else {
		ValaCodeContext* _tmp78_;
		ValaCodeContext* _tmp79_;
		const gchar* _tmp80_;
		const gchar* _tmp81_;
		_tmp78_ = self->priv->context;
		_tmp79_ = self->priv->context;
		_tmp80_ = vala_code_context_get_basedir (_tmp79_);
		_tmp81_ = _tmp80_;
		vala_code_context_set_directory (_tmp78_, _tmp81_);
	}
	_tmp82_ = self->priv->context;
	_tmp83_ = vala_compiler_vapi_directories;
	_tmp83__length1 = _vala_array_length (vala_compiler_vapi_directories);
	_tmp84_ = (_tmp83_ != NULL) ? _vala_array_dup1 (_tmp83_, _tmp83__length1) : ((gpointer) _tmp83_);
	_tmp84__length1 = _tmp83__length1;
	_tmp82_->vapi_directories = (_vala_array_free (_tmp82_->vapi_directories, _tmp82_->vapi_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp82_->vapi_directories = _tmp84_;
	_tmp82_->vapi_directories_length1 = _tmp84__length1;
	_tmp85_ = self->priv->context;
	_tmp86_ = vala_compiler_gir_directories;
	_tmp86__length1 = _vala_array_length (vala_compiler_gir_directories);
	_tmp87_ = (_tmp86_ != NULL) ? _vala_array_dup2 (_tmp86_, _tmp86__length1) : ((gpointer) _tmp86_);
	_tmp87__length1 = _tmp86__length1;
	_tmp85_->gir_directories = (_vala_array_free (_tmp85_->gir_directories, _tmp85_->gir_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp85_->gir_directories = _tmp87_;
	_tmp85_->gir_directories_length1 = _tmp87__length1;
	_tmp88_ = self->priv->context;
	_tmp89_ = vala_compiler_metadata_directories;
	_tmp89__length1 = _vala_array_length (vala_compiler_metadata_directories);
	_tmp90_ = (_tmp89_ != NULL) ? _vala_array_dup3 (_tmp89_, _tmp89__length1) : ((gpointer) _tmp89_);
	_tmp90__length1 = _tmp89__length1;
	_tmp88_->metadata_directories = (_vala_array_free (_tmp88_->metadata_directories, _tmp88_->metadata_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp88_->metadata_directories = _tmp90_;
	_tmp88_->metadata_directories_length1 = _tmp90__length1;
	_tmp91_ = self->priv->context;
	_tmp92_ = vala_compiler_debug;
	vala_code_context_set_debug (_tmp91_, _tmp92_);
	_tmp93_ = self->priv->context;
	_tmp94_ = vala_compiler_thread;
	vala_code_context_set_thread (_tmp93_, _tmp94_);
	_tmp95_ = self->priv->context;
	_tmp96_ = vala_compiler_mem_profiler;
	vala_code_context_set_mem_profiler (_tmp95_, _tmp96_);
	_tmp97_ = self->priv->context;
	_tmp98_ = vala_compiler_save_temps;
	vala_code_context_set_save_temps (_tmp97_, _tmp98_);
	_tmp99_ = vala_compiler_profile;
	if (g_strcmp0 (_tmp99_, "posix") == 0) {
		ValaCodeContext* _tmp100_;
		ValaCodeContext* _tmp101_;
		_tmp100_ = self->priv->context;
		vala_code_context_set_profile (_tmp100_, VALA_PROFILE_POSIX);
		_tmp101_ = self->priv->context;
		vala_code_context_add_define (_tmp101_, "POSIX");
	} else {
		gboolean _tmp102_ = FALSE;
		gboolean _tmp103_ = FALSE;
		const gchar* _tmp104_;
		gboolean _tmp106_;
		gboolean _tmp108_;
		_tmp104_ = vala_compiler_profile;
		if (g_strcmp0 (_tmp104_, "gobject-2.0") == 0) {
			_tmp103_ = TRUE;
		} else {
			const gchar* _tmp105_;
			_tmp105_ = vala_compiler_profile;
			_tmp103_ = g_strcmp0 (_tmp105_, "gobject") == 0;
		}
		_tmp106_ = _tmp103_;
		if (_tmp106_) {
			_tmp102_ = TRUE;
		} else {
			const gchar* _tmp107_;
			_tmp107_ = vala_compiler_profile;
			_tmp102_ = _tmp107_ == NULL;
		}
		_tmp108_ = _tmp102_;
		if (_tmp108_) {
			ValaCodeContext* _tmp109_;
			ValaCodeContext* _tmp110_;
			_tmp109_ = self->priv->context;
			vala_code_context_set_profile (_tmp109_, VALA_PROFILE_GOBJECT);
			_tmp110_ = self->priv->context;
			vala_code_context_add_define (_tmp110_, "GOBJECT");
		} else {
			const gchar* _tmp111_;
			_tmp111_ = vala_compiler_profile;
			if (g_strcmp0 (_tmp111_, "dova") == 0) {
				ValaCodeContext* _tmp112_;
				ValaCodeContext* _tmp113_;
				_tmp112_ = self->priv->context;
				vala_code_context_set_profile (_tmp112_, VALA_PROFILE_DOVA);
				_tmp113_ = self->priv->context;
				vala_code_context_add_define (_tmp113_, "DOVA");
			} else {
				const gchar* _tmp114_;
				gchar* _tmp115_ = NULL;
				gchar* _tmp116_;
				_tmp114_ = vala_compiler_profile;
				_tmp115_ = g_strdup_printf ("Unknown profile %s", _tmp114_);
				_tmp116_ = _tmp115_;
				vala_report_error (NULL, _tmp116_);
				_g_free0 (_tmp116_);
			}
		}
	}
	_tmp117_ = vala_compiler_nostdpkg;
	_tmp118_ = vala_compiler_fast_vapi_filename;
	vala_compiler_nostdpkg = _tmp117_ | (_tmp118_ != NULL);
	_tmp119_ = self->priv->context;
	_tmp120_ = vala_compiler_nostdpkg;
	vala_code_context_set_nostdpkg (_tmp119_, _tmp120_);
	_tmp121_ = self->priv->context;
	_tmp122_ = vala_compiler_entry_point;
	vala_code_context_set_entry_point_name (_tmp121_, _tmp122_);
	_tmp123_ = self->priv->context;
	_tmp124_ = vala_compiler_run_output;
	vala_code_context_set_run_output (_tmp123_, _tmp124_);
	_tmp125_ = vala_compiler_defines;
	_tmp125__length1 = _vala_array_length (vala_compiler_defines);
	if (_tmp125_ != NULL) {
		gchar** _tmp126_;
		gint _tmp126__length1;
		_tmp126_ = vala_compiler_defines;
		_tmp126__length1 = _vala_array_length (vala_compiler_defines);
		{
			gchar** define_collection = NULL;
			gint define_collection_length1 = 0;
			gint _define_collection_size_ = 0;
			gint define_it = 0;
			define_collection = _tmp126_;
			define_collection_length1 = _tmp126__length1;
			for (define_it = 0; define_it < _tmp126__length1; define_it = define_it + 1) {
				gchar* _tmp127_;
				gchar* define = NULL;
				_tmp127_ = g_strdup (define_collection[define_it]);
				define = _tmp127_;
				{
					ValaCodeContext* _tmp128_;
					const gchar* _tmp129_;
					_tmp128_ = self->priv->context;
					_tmp129_ = define;
					vala_code_context_add_define (_tmp128_, _tmp129_);
					_g_free0 (define);
				}
			}
		}
	}
	{
		gint i;
		i = 2;
		{
			gboolean _tmp130_;
			_tmp130_ = TRUE;
			while (TRUE) {
				gboolean _tmp131_;
				gint _tmp133_;
				ValaCodeContext* _tmp134_;
				gint _tmp135_;
				gchar* _tmp136_ = NULL;
				gchar* _tmp137_;
				_tmp131_ = _tmp130_;
				if (!_tmp131_) {
					gint _tmp132_;
					_tmp132_ = i;
					i = _tmp132_ + 2;
				}
				_tmp130_ = FALSE;
				_tmp133_ = i;
				if (!(_tmp133_ <= 18)) {
					break;
				}
				_tmp134_ = self->priv->context;
				_tmp135_ = i;
				_tmp136_ = g_strdup_printf ("VALA_0_%d", _tmp135_);
				_tmp137_ = _tmp136_;
				vala_code_context_add_define (_tmp134_, _tmp137_);
				_g_free0 (_tmp137_);
			}
		}
	}
	_tmp138_ = self->priv->context;
	_tmp139_ = vala_code_context_get_profile (_tmp138_);
	_tmp140_ = _tmp139_;
	if (_tmp140_ == VALA_PROFILE_POSIX) {
		gboolean _tmp141_;
		_tmp141_ = vala_compiler_nostdpkg;
		if (!_tmp141_) {
			ValaCodeContext* _tmp142_;
			_tmp142_ = self->priv->context;
			vala_code_context_add_external_package (_tmp142_, "posix");
		}
	} else {
		ValaCodeContext* _tmp143_;
		ValaProfile _tmp144_;
		ValaProfile _tmp145_;
		_tmp143_ = self->priv->context;
		_tmp144_ = vala_code_context_get_profile (_tmp143_);
		_tmp145_ = _tmp144_;
		if (_tmp145_ == VALA_PROFILE_GOBJECT) {
			gint glib_major;
			gint glib_minor;
			gboolean _tmp146_ = FALSE;
			const gchar* _tmp147_;
			gboolean _tmp150_;
			ValaCodeContext* _tmp151_;
			gint _tmp152_;
			ValaCodeContext* _tmp153_;
			gint _tmp154_;
			ValaCodeContext* _tmp155_;
			gint _tmp156_;
			gint _tmp157_;
			gboolean _tmp167_;
			glib_major = 2;
			glib_minor = 16;
			_tmp147_ = vala_compiler_target_glib;
			if (_tmp147_ != NULL) {
				const gchar* _tmp148_;
				gint _tmp149_ = 0;
				_tmp148_ = vala_compiler_target_glib;
				_tmp149_ = sscanf (_tmp148_, "%d.%d", &glib_major, &glib_minor);
				_tmp146_ = _tmp149_ != 2;
			} else {
				_tmp146_ = FALSE;
			}
			_tmp150_ = _tmp146_;
			if (_tmp150_) {
				vala_report_error (NULL, "Invalid format for --target-glib");
			}
			_tmp151_ = self->priv->context;
			_tmp152_ = glib_major;
			vala_code_context_set_target_glib_major (_tmp151_, _tmp152_);
			_tmp153_ = self->priv->context;
			_tmp154_ = glib_minor;
			vala_code_context_set_target_glib_minor (_tmp153_, _tmp154_);
			_tmp155_ = self->priv->context;
			_tmp156_ = vala_code_context_get_target_glib_major (_tmp155_);
			_tmp157_ = _tmp156_;
			if (_tmp157_ != 2) {
				vala_report_error (NULL, "This version of valac only supports GLib 2");
			}
			{
				gint i;
				i = 16;
				{
					gboolean _tmp158_;
					_tmp158_ = TRUE;
					while (TRUE) {
						gboolean _tmp159_;
						gint _tmp161_;
						gint _tmp162_;
						ValaCodeContext* _tmp163_;
						gint _tmp164_;
						gchar* _tmp165_ = NULL;
						gchar* _tmp166_;
						_tmp159_ = _tmp158_;
						if (!_tmp159_) {
							gint _tmp160_;
							_tmp160_ = i;
							i = _tmp160_ + 2;
						}
						_tmp158_ = FALSE;
						_tmp161_ = i;
						_tmp162_ = glib_minor;
						if (!(_tmp161_ <= _tmp162_)) {
							break;
						}
						_tmp163_ = self->priv->context;
						_tmp164_ = i;
						_tmp165_ = g_strdup_printf ("GLIB_2_%d", _tmp164_);
						_tmp166_ = _tmp165_;
						vala_code_context_add_define (_tmp163_, _tmp166_);
						_g_free0 (_tmp166_);
					}
				}
			}
			_tmp167_ = vala_compiler_nostdpkg;
			if (!_tmp167_) {
				ValaCodeContext* _tmp168_;
				ValaCodeContext* _tmp169_;
				_tmp168_ = self->priv->context;
				vala_code_context_add_external_package (_tmp168_, "glib-2.0");
				_tmp169_ = self->priv->context;
				vala_code_context_add_external_package (_tmp169_, "gobject-2.0");
			}
		} else {
			ValaCodeContext* _tmp170_;
			ValaProfile _tmp171_;
			ValaProfile _tmp172_;
			_tmp170_ = self->priv->context;
			_tmp171_ = vala_code_context_get_profile (_tmp170_);
			_tmp172_ = _tmp171_;
			if (_tmp172_ == VALA_PROFILE_DOVA) {
				gboolean _tmp173_;
				_tmp173_ = vala_compiler_nostdpkg;
				if (!_tmp173_) {
					ValaCodeContext* _tmp174_;
					_tmp174_ = self->priv->context;
					vala_code_context_add_external_package (_tmp174_, "dova-core-0.1");
				}
			}
		}
	}
	_tmp175_ = vala_compiler_packages;
	_tmp175__length1 = _vala_array_length (vala_compiler_packages);
	if (_tmp175_ != NULL) {
		gchar** _tmp176_;
		gint _tmp176__length1;
		_tmp176_ = vala_compiler_packages;
		_tmp176__length1 = _vala_array_length (vala_compiler_packages);
		{
			gchar** package_collection = NULL;
			gint package_collection_length1 = 0;
			gint _package_collection_size_ = 0;
			gint package_it = 0;
			package_collection = _tmp176_;
			package_collection_length1 = _tmp176__length1;
			for (package_it = 0; package_it < _tmp176__length1; package_it = package_it + 1) {
				gchar* _tmp177_;
				gchar* package = NULL;
				_tmp177_ = g_strdup (package_collection[package_it]);
				package = _tmp177_;
				{
					ValaCodeContext* _tmp178_;
					const gchar* _tmp179_;
					_tmp178_ = self->priv->context;
					_tmp179_ = package;
					vala_code_context_add_external_package (_tmp178_, _tmp179_);
					_g_free0 (package);
				}
			}
		}
		vala_compiler_packages = (_vala_array_free (vala_compiler_packages, _vala_array_length (vala_compiler_packages), (GDestroyNotify) g_free), NULL);
		vala_compiler_packages = NULL;
	}
	_tmp180_ = vala_compiler_fast_vapis;
	_tmp180__length1 = _vala_array_length (vala_compiler_fast_vapis);
	if (_tmp180_ != NULL) {
		gchar** _tmp181_;
		gint _tmp181__length1;
		_tmp181_ = vala_compiler_fast_vapis;
		_tmp181__length1 = _vala_array_length (vala_compiler_fast_vapis);
		{
			gchar** vapi_collection = NULL;
			gint vapi_collection_length1 = 0;
			gint _vapi_collection_size_ = 0;
			gint vapi_it = 0;
			vapi_collection = _tmp181_;
			vapi_collection_length1 = _tmp181__length1;
			for (vapi_it = 0; vapi_it < _tmp181__length1; vapi_it = vapi_it + 1) {
				gchar* _tmp182_;
				gchar* vapi = NULL;
				_tmp182_ = g_strdup (vapi_collection[vapi_it]);
				vapi = _tmp182_;
				{
					const gchar* _tmp183_;
					gchar* _tmp184_ = NULL;
					gchar* rpath;
					ValaCodeContext* _tmp185_;
					const gchar* _tmp186_;
					ValaSourceFile* _tmp187_;
					ValaSourceFile* source_file;
					ValaCodeContext* _tmp188_;
					ValaSourceFile* _tmp189_;
					_tmp183_ = vapi;
					_tmp184_ = vala_code_context_realpath (_tmp183_);
					rpath = _tmp184_;
					_tmp185_ = self->priv->context;
					_tmp186_ = rpath;
					_tmp187_ = vala_source_file_new (_tmp185_, VALA_SOURCE_FILE_TYPE_FAST, _tmp186_, NULL, FALSE);
					source_file = _tmp187_;
					_tmp188_ = self->priv->context;
					_tmp189_ = source_file;
					vala_code_context_add_source_file (_tmp188_, _tmp189_);
					_vala_source_file_unref0 (source_file);
					_g_free0 (rpath);
					_g_free0 (vapi);
				}
			}
		}
	}
	_tmp191_ = self->priv->context;
	_tmp192_ = vala_code_context_get_report (_tmp191_);
	_tmp193_ = _tmp192_;
	_tmp194_ = vala_report_get_errors (_tmp193_);
	if (_tmp194_ > 0) {
		_tmp190_ = TRUE;
	} else {
		gboolean _tmp195_ = FALSE;
		gboolean _tmp196_;
		gboolean _tmp201_;
		_tmp196_ = vala_compiler_fatal_warnings;
		if (_tmp196_) {
			ValaCodeContext* _tmp197_;
			ValaReport* _tmp198_;
			ValaReport* _tmp199_;
			gint _tmp200_ = 0;
			_tmp197_ = self->priv->context;
			_tmp198_ = vala_code_context_get_report (_tmp197_);
			_tmp199_ = _tmp198_;
			_tmp200_ = vala_report_get_warnings (_tmp199_);
			_tmp195_ = _tmp200_ > 0;
		} else {
			_tmp195_ = FALSE;
		}
		_tmp201_ = _tmp195_;
		_tmp190_ = _tmp201_;
	}
	_tmp202_ = _tmp190_;
	if (_tmp202_) {
		gint _tmp203_ = 0;
		_tmp203_ = vala_compiler_quit (self);
		result = _tmp203_;
		return result;
	}
	_tmp204_ = self->priv->context;
	_tmp205_ = vala_code_context_get_profile (_tmp204_);
	_tmp206_ = _tmp205_;
	if (_tmp206_ == VALA_PROFILE_GOBJECT) {
		ValaCodeContext* _tmp207_;
		ValaGDBusServerModule* _tmp208_;
		ValaGDBusServerModule* _tmp209_;
		_tmp207_ = self->priv->context;
		_tmp208_ = vala_gd_bus_server_module_new ();
		_tmp209_ = _tmp208_;
		vala_code_context_set_codegen (_tmp207_, (ValaCodeGenerator*) _tmp209_);
		_vala_code_visitor_unref0 (_tmp209_);
	} else {
		ValaCodeContext* _tmp210_;
		ValaProfile _tmp211_;
		ValaProfile _tmp212_;
		_tmp210_ = self->priv->context;
		_tmp211_ = vala_code_context_get_profile (_tmp210_);
		_tmp212_ = _tmp211_;
		if (_tmp212_ == VALA_PROFILE_DOVA) {
			ValaCodeContext* _tmp213_;
			ValaDovaErrorModule* _tmp214_;
			ValaDovaErrorModule* _tmp215_;
			_tmp213_ = self->priv->context;
			_tmp214_ = vala_dova_error_module_new ();
			_tmp215_ = _tmp214_;
			vala_code_context_set_codegen (_tmp213_, (ValaCodeGenerator*) _tmp215_);
			_vala_code_visitor_unref0 (_tmp215_);
		} else {
			ValaCodeContext* _tmp216_;
			ValaCCodeDelegateModule* _tmp217_;
			ValaCCodeDelegateModule* _tmp218_;
			_tmp216_ = self->priv->context;
			_tmp217_ = vala_ccode_delegate_module_new ();
			_tmp218_ = _tmp217_;
			vala_code_context_set_codegen (_tmp216_, (ValaCodeGenerator*) _tmp218_);
			_vala_code_visitor_unref0 (_tmp218_);
		}
	}
	has_c_files = FALSE;
	_tmp219_ = vala_compiler_sources;
	_tmp219__length1 = _vala_array_length (vala_compiler_sources);
	{
		gchar** source_collection = NULL;
		gint source_collection_length1 = 0;
		gint _source_collection_size_ = 0;
		gint source_it = 0;
		source_collection = _tmp219_;
		source_collection_length1 = _tmp219__length1;
		for (source_it = 0; source_it < _tmp219__length1; source_it = source_it + 1) {
			gchar* _tmp220_;
			gchar* source = NULL;
			_tmp220_ = g_strdup (source_collection[source_it]);
			source = _tmp220_;
			{
				ValaCodeContext* _tmp221_;
				const gchar* _tmp222_;
				gboolean _tmp223_;
				gboolean _tmp224_ = FALSE;
				_tmp221_ = self->priv->context;
				_tmp222_ = source;
				_tmp223_ = vala_compiler_run_output;
				_tmp224_ = vala_code_context_add_source_filename (_tmp221_, _tmp222_, _tmp223_, TRUE);
				if (_tmp224_) {
					const gchar* _tmp225_;
					gboolean _tmp226_ = FALSE;
					_tmp225_ = source;
					_tmp226_ = g_str_has_suffix (_tmp225_, ".c");
					if (_tmp226_) {
						has_c_files = TRUE;
					}
				}
				_g_free0 (source);
			}
		}
	}
	vala_compiler_sources = (_vala_array_free (vala_compiler_sources, _vala_array_length (vala_compiler_sources), (GDestroyNotify) g_free), NULL);
	vala_compiler_sources = NULL;
	_tmp228_ = self->priv->context;
	_tmp229_ = vala_code_context_get_report (_tmp228_);
	_tmp230_ = _tmp229_;
	_tmp231_ = vala_report_get_errors (_tmp230_);
	if (_tmp231_ > 0) {
		_tmp227_ = TRUE;
	} else {
		gboolean _tmp232_ = FALSE;
		gboolean _tmp233_;
		gboolean _tmp238_;
		_tmp233_ = vala_compiler_fatal_warnings;
		if (_tmp233_) {
			ValaCodeContext* _tmp234_;
			ValaReport* _tmp235_;
			ValaReport* _tmp236_;
			gint _tmp237_ = 0;
			_tmp234_ = self->priv->context;
			_tmp235_ = vala_code_context_get_report (_tmp234_);
			_tmp236_ = _tmp235_;
			_tmp237_ = vala_report_get_warnings (_tmp236_);
			_tmp232_ = _tmp237_ > 0;
		} else {
			_tmp232_ = FALSE;
		}
		_tmp238_ = _tmp232_;
		_tmp227_ = _tmp238_;
	}
	_tmp239_ = _tmp227_;
	if (_tmp239_) {
		gint _tmp240_ = 0;
		_tmp240_ = vala_compiler_quit (self);
		result = _tmp240_;
		return result;
	}
	_tmp241_ = vala_parser_new ();
	parser = _tmp241_;
	_tmp242_ = parser;
	_tmp243_ = self->priv->context;
	vala_parser_parse (_tmp242_, _tmp243_);
	_tmp244_ = vala_genie_parser_new ();
	genie_parser = _tmp244_;
	_tmp245_ = genie_parser;
	_tmp246_ = self->priv->context;
	vala_genie_parser_parse (_tmp245_, _tmp246_);
	_tmp247_ = vala_gir_parser_new ();
	gir_parser = _tmp247_;
	_tmp248_ = gir_parser;
	_tmp249_ = self->priv->context;
	vala_gir_parser_parse (_tmp248_, _tmp249_);
	_tmp251_ = self->priv->context;
	_tmp252_ = vala_code_context_get_report (_tmp251_);
	_tmp253_ = _tmp252_;
	_tmp254_ = vala_report_get_errors (_tmp253_);
	if (_tmp254_ > 0) {
		_tmp250_ = TRUE;
	} else {
		gboolean _tmp255_ = FALSE;
		gboolean _tmp256_;
		gboolean _tmp261_;
		_tmp256_ = vala_compiler_fatal_warnings;
		if (_tmp256_) {
			ValaCodeContext* _tmp257_;
			ValaReport* _tmp258_;
			ValaReport* _tmp259_;
			gint _tmp260_ = 0;
			_tmp257_ = self->priv->context;
			_tmp258_ = vala_code_context_get_report (_tmp257_);
			_tmp259_ = _tmp258_;
			_tmp260_ = vala_report_get_warnings (_tmp259_);
			_tmp255_ = _tmp260_ > 0;
		} else {
			_tmp255_ = FALSE;
		}
		_tmp261_ = _tmp255_;
		_tmp250_ = _tmp261_;
	}
	_tmp262_ = _tmp250_;
	if (_tmp262_) {
		gint _tmp263_ = 0;
		_tmp263_ = vala_compiler_quit (self);
		result = _tmp263_;
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp264_ = vala_compiler_fast_vapi_filename;
	if (_tmp264_ != NULL) {
		ValaCodeWriter* _tmp265_;
		ValaCodeWriter* interface_writer;
		ValaCodeWriter* _tmp266_;
		ValaCodeContext* _tmp267_;
		const gchar* _tmp268_;
		gint _tmp269_ = 0;
		_tmp265_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_FAST);
		interface_writer = _tmp265_;
		_tmp266_ = interface_writer;
		_tmp267_ = self->priv->context;
		_tmp268_ = vala_compiler_fast_vapi_filename;
		vala_code_writer_write_file (_tmp266_, _tmp267_, _tmp268_);
		_tmp269_ = vala_compiler_quit (self);
		result = _tmp269_;
		_vala_code_visitor_unref0 (interface_writer);
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp270_ = self->priv->context;
	vala_code_context_check (_tmp270_);
	_tmp272_ = self->priv->context;
	_tmp273_ = vala_code_context_get_report (_tmp272_);
	_tmp274_ = _tmp273_;
	_tmp275_ = vala_report_get_errors (_tmp274_);
	if (_tmp275_ > 0) {
		_tmp271_ = TRUE;
	} else {
		gboolean _tmp276_ = FALSE;
		gboolean _tmp277_;
		gboolean _tmp282_;
		_tmp277_ = vala_compiler_fatal_warnings;
		if (_tmp277_) {
			ValaCodeContext* _tmp278_;
			ValaReport* _tmp279_;
			ValaReport* _tmp280_;
			gint _tmp281_ = 0;
			_tmp278_ = self->priv->context;
			_tmp279_ = vala_code_context_get_report (_tmp278_);
			_tmp280_ = _tmp279_;
			_tmp281_ = vala_report_get_warnings (_tmp280_);
			_tmp276_ = _tmp281_ > 0;
		} else {
			_tmp276_ = FALSE;
		}
		_tmp282_ = _tmp276_;
		_tmp271_ = _tmp282_;
	}
	_tmp283_ = _tmp271_;
	if (_tmp283_) {
		gint _tmp284_ = 0;
		_tmp284_ = vala_compiler_quit (self);
		result = _tmp284_;
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp287_ = vala_compiler_ccode_only;
	if (!_tmp287_) {
		gboolean _tmp288_;
		_tmp288_ = vala_compiler_compile_only;
		_tmp286_ = !_tmp288_;
	} else {
		_tmp286_ = FALSE;
	}
	_tmp289_ = _tmp286_;
	if (_tmp289_) {
		const gchar* _tmp290_;
		_tmp290_ = vala_compiler_library;
		_tmp285_ = _tmp290_ == NULL;
	} else {
		_tmp285_ = FALSE;
	}
	_tmp291_ = _tmp285_;
	if (_tmp291_) {
		gboolean _tmp292_ = FALSE;
		gboolean _tmp293_;
		gboolean _tmp297_;
		_tmp293_ = has_c_files;
		if (!_tmp293_) {
			ValaCodeContext* _tmp294_;
			ValaMethod* _tmp295_;
			ValaMethod* _tmp296_;
			_tmp294_ = self->priv->context;
			_tmp295_ = vala_code_context_get_entry_point (_tmp294_);
			_tmp296_ = _tmp295_;
			_tmp292_ = _tmp296_ == NULL;
		} else {
			_tmp292_ = FALSE;
		}
		_tmp297_ = _tmp292_;
		if (_tmp297_) {
			vala_report_error (NULL, "program does not contain a static `main' method");
		}
	}
	_tmp298_ = vala_compiler_dump_tree;
	if (_tmp298_ != NULL) {
		ValaCodeWriter* _tmp299_;
		ValaCodeWriter* code_writer;
		ValaCodeWriter* _tmp300_;
		ValaCodeContext* _tmp301_;
		const gchar* _tmp302_;
		_tmp299_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_DUMP);
		code_writer = _tmp299_;
		_tmp300_ = code_writer;
		_tmp301_ = self->priv->context;
		_tmp302_ = vala_compiler_dump_tree;
		vala_code_writer_write_file (_tmp300_, _tmp301_, _tmp302_);
		_vala_code_visitor_unref0 (code_writer);
	}
	_tmp304_ = self->priv->context;
	_tmp305_ = vala_code_context_get_report (_tmp304_);
	_tmp306_ = _tmp305_;
	_tmp307_ = vala_report_get_errors (_tmp306_);
	if (_tmp307_ > 0) {
		_tmp303_ = TRUE;
	} else {
		gboolean _tmp308_ = FALSE;
		gboolean _tmp309_;
		gboolean _tmp314_;
		_tmp309_ = vala_compiler_fatal_warnings;
		if (_tmp309_) {
			ValaCodeContext* _tmp310_;
			ValaReport* _tmp311_;
			ValaReport* _tmp312_;
			gint _tmp313_ = 0;
			_tmp310_ = self->priv->context;
			_tmp311_ = vala_code_context_get_report (_tmp310_);
			_tmp312_ = _tmp311_;
			_tmp313_ = vala_report_get_warnings (_tmp312_);
			_tmp308_ = _tmp313_ > 0;
		} else {
			_tmp308_ = FALSE;
		}
		_tmp314_ = _tmp308_;
		_tmp303_ = _tmp314_;
	}
	_tmp315_ = _tmp303_;
	if (_tmp315_) {
		gint _tmp316_ = 0;
		_tmp316_ = vala_compiler_quit (self);
		result = _tmp316_;
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp317_ = self->priv->context;
	_tmp318_ = vala_code_context_get_codegen (_tmp317_);
	_tmp319_ = _tmp318_;
	_tmp320_ = self->priv->context;
	vala_code_generator_emit (_tmp319_, _tmp320_);
	_tmp322_ = self->priv->context;
	_tmp323_ = vala_code_context_get_report (_tmp322_);
	_tmp324_ = _tmp323_;
	_tmp325_ = vala_report_get_errors (_tmp324_);
	if (_tmp325_ > 0) {
		_tmp321_ = TRUE;
	} else {
		gboolean _tmp326_ = FALSE;
		gboolean _tmp327_;
		gboolean _tmp332_;
		_tmp327_ = vala_compiler_fatal_warnings;
		if (_tmp327_) {
			ValaCodeContext* _tmp328_;
			ValaReport* _tmp329_;
			ValaReport* _tmp330_;
			gint _tmp331_ = 0;
			_tmp328_ = self->priv->context;
			_tmp329_ = vala_code_context_get_report (_tmp328_);
			_tmp330_ = _tmp329_;
			_tmp331_ = vala_report_get_warnings (_tmp330_);
			_tmp326_ = _tmp331_ > 0;
		} else {
			_tmp326_ = FALSE;
		}
		_tmp332_ = _tmp326_;
		_tmp321_ = _tmp332_;
	}
	_tmp333_ = _tmp321_;
	if (_tmp333_) {
		gint _tmp334_ = 0;
		_tmp334_ = vala_compiler_quit (self);
		result = _tmp334_;
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp336_ = vala_compiler_vapi_filename;
	if (_tmp336_ == NULL) {
		const gchar* _tmp337_;
		_tmp337_ = vala_compiler_library;
		_tmp335_ = _tmp337_ != NULL;
	} else {
		_tmp335_ = FALSE;
	}
	_tmp338_ = _tmp335_;
	if (_tmp338_) {
		const gchar* _tmp339_;
		gchar* _tmp340_ = NULL;
		_tmp339_ = vala_compiler_library;
		_tmp340_ = g_strdup_printf ("%s.vapi", _tmp339_);
		_g_free0 (vala_compiler_vapi_filename);
		vala_compiler_vapi_filename = _tmp340_;
	}
	_tmp341_ = vala_compiler_library;
	if (_tmp341_ != NULL) {
		const gchar* _tmp342_;
		_tmp342_ = vala_compiler_gir;
		if (_tmp342_ != NULL) {
			ValaCodeContext* _tmp343_;
			ValaProfile _tmp344_;
			ValaProfile _tmp345_;
			_tmp343_ = self->priv->context;
			_tmp344_ = vala_code_context_get_profile (_tmp343_);
			_tmp345_ = _tmp344_;
			if (_tmp345_ == VALA_PROFILE_GOBJECT) {
				const gchar* _tmp346_;
				gint _tmp347_;
				gint _tmp348_;
				glong gir_len;
				const gchar* _tmp349_;
				gint _tmp350_ = 0;
				gint last_hyphen;
				gboolean _tmp351_ = FALSE;
				gint _tmp352_;
				gboolean _tmp355_;
				_tmp346_ = vala_compiler_gir;
				_tmp347_ = strlen (_tmp346_);
				_tmp348_ = _tmp347_;
				gir_len = (glong) _tmp348_;
				_tmp349_ = vala_compiler_gir;
				_tmp350_ = string_last_index_of_char (_tmp349_, (gunichar) '-', 0);
				last_hyphen = _tmp350_;
				_tmp352_ = last_hyphen;
				if (_tmp352_ == (-1)) {
					_tmp351_ = TRUE;
				} else {
					const gchar* _tmp353_;
					gboolean _tmp354_ = FALSE;
					_tmp353_ = vala_compiler_gir;
					_tmp354_ = g_str_has_suffix (_tmp353_, ".gir");
					_tmp351_ = !_tmp354_;
				}
				_tmp355_ = _tmp351_;
				if (_tmp355_) {
					const gchar* _tmp356_;
					gchar* _tmp357_ = NULL;
					gchar* _tmp358_;
					_tmp356_ = vala_compiler_gir;
					_tmp357_ = g_strdup_printf ("GIR file name `%s' is not well-formed, expected NAME-VERSION.gir", _tmp356_);
					_tmp358_ = _tmp357_;
					vala_report_error (NULL, _tmp358_);
					_g_free0 (_tmp358_);
				} else {
					const gchar* _tmp359_;
					gint _tmp360_;
					gchar* _tmp361_ = NULL;
					gchar* gir_namespace;
					const gchar* _tmp362_;
					gint _tmp363_;
					glong _tmp364_;
					gint _tmp365_;
					gchar* _tmp366_ = NULL;
					gchar* gir_version;
					const gchar* _tmp367_;
					gboolean _tmp368_ = FALSE;
					gboolean _tmp369_ = FALSE;
					gboolean _tmp370_ = FALSE;
					const gchar* _tmp371_;
					gboolean _tmp373_;
					gboolean _tmp377_;
					gboolean _tmp380_;
					_tmp359_ = vala_compiler_gir;
					_tmp360_ = last_hyphen;
					_tmp361_ = string_substring (_tmp359_, (glong) 0, (glong) _tmp360_);
					gir_namespace = _tmp361_;
					_tmp362_ = vala_compiler_gir;
					_tmp363_ = last_hyphen;
					_tmp364_ = gir_len;
					_tmp365_ = last_hyphen;
					_tmp366_ = string_substring (_tmp362_, (glong) (_tmp363_ + 1), (_tmp364_ - _tmp365_) - 5);
					gir_version = _tmp366_;
					_tmp367_ = gir_version;
					g_strcanon (_tmp367_, "0123456789.", '?');
					_tmp371_ = gir_namespace;
					if (g_strcmp0 (_tmp371_, "") == 0) {
						_tmp370_ = TRUE;
					} else {
						const gchar* _tmp372_;
						_tmp372_ = gir_version;
						_tmp370_ = g_strcmp0 (_tmp372_, "") == 0;
					}
					_tmp373_ = _tmp370_;
					if (_tmp373_) {
						_tmp369_ = TRUE;
					} else {
						const gchar* _tmp374_;
						gchar _tmp375_ = '\0';
						gboolean _tmp376_ = FALSE;
						_tmp374_ = gir_version;
						_tmp375_ = string_get (_tmp374_, (glong) 0);
						_tmp376_ = g_ascii_isdigit (_tmp375_);
						_tmp369_ = !_tmp376_;
					}
					_tmp377_ = _tmp369_;
					if (_tmp377_) {
						_tmp368_ = TRUE;
					} else {
						const gchar* _tmp378_;
						gboolean _tmp379_ = FALSE;
						_tmp378_ = gir_version;
						_tmp379_ = string_contains (_tmp378_, "?");
						_tmp368_ = _tmp379_;
					}
					_tmp380_ = _tmp368_;
					if (_tmp380_) {
						const gchar* _tmp381_;
						gchar* _tmp382_ = NULL;
						gchar* _tmp383_;
						_tmp381_ = vala_compiler_gir;
						_tmp382_ = g_strdup_printf ("GIR file name `%s' is not well-formed, expected NAME-VERSION.gir", _tmp381_);
						_tmp383_ = _tmp382_;
						vala_report_error (NULL, _tmp383_);
						_g_free0 (_tmp383_);
					} else {
						ValaGIRWriter* _tmp384_;
						ValaGIRWriter* gir_writer;
						gchar* _tmp385_;
						gchar* gir_directory;
						const gchar* _tmp386_;
						ValaGIRWriter* _tmp391_;
						ValaCodeContext* _tmp392_;
						const gchar* _tmp393_;
						const gchar* _tmp394_;
						const gchar* _tmp395_;
						const gchar* _tmp396_;
						_tmp384_ = vala_gir_writer_new ();
						gir_writer = _tmp384_;
						_tmp385_ = g_strdup (".");
						gir_directory = _tmp385_;
						_tmp386_ = vala_compiler_directory;
						if (_tmp386_ != NULL) {
							ValaCodeContext* _tmp387_;
							const gchar* _tmp388_;
							const gchar* _tmp389_;
							gchar* _tmp390_;
							_tmp387_ = self->priv->context;
							_tmp388_ = vala_code_context_get_directory (_tmp387_);
							_tmp389_ = _tmp388_;
							_tmp390_ = g_strdup (_tmp389_);
							_g_free0 (gir_directory);
							gir_directory = _tmp390_;
						}
						_tmp391_ = gir_writer;
						_tmp392_ = self->priv->context;
						_tmp393_ = gir_directory;
						_tmp394_ = gir_namespace;
						_tmp395_ = gir_version;
						_tmp396_ = vala_compiler_library;
						vala_gir_writer_write_file (_tmp391_, _tmp392_, _tmp393_, _tmp394_, _tmp395_, _tmp396_);
						_g_free0 (gir_directory);
						_vala_code_visitor_unref0 (gir_writer);
					}
					_g_free0 (gir_version);
					_g_free0 (gir_namespace);
				}
			}
			_g_free0 (vala_compiler_gir);
			vala_compiler_gir = NULL;
		}
		_g_free0 (vala_compiler_library);
		vala_compiler_library = NULL;
	}
	_tmp397_ = vala_compiler_vapi_filename;
	if (_tmp397_ != NULL) {
		ValaCodeWriter* _tmp398_;
		ValaCodeWriter* interface_writer;
		gboolean _tmp399_ = FALSE;
		const gchar* _tmp400_;
		gboolean _tmp403_;
		ValaCodeWriter* _tmp409_;
		ValaCodeContext* _tmp410_;
		const gchar* _tmp411_;
		_tmp398_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_EXTERNAL);
		interface_writer = _tmp398_;
		_tmp400_ = vala_compiler_directory;
		if (_tmp400_ != NULL) {
			const gchar* _tmp401_;
			gboolean _tmp402_ = FALSE;
			_tmp401_ = vala_compiler_vapi_filename;
			_tmp402_ = g_path_is_absolute (_tmp401_);
			_tmp399_ = !_tmp402_;
		} else {
			_tmp399_ = FALSE;
		}
		_tmp403_ = _tmp399_;
		if (_tmp403_) {
			ValaCodeContext* _tmp404_;
			const gchar* _tmp405_;
			const gchar* _tmp406_;
			const gchar* _tmp407_;
			gchar* _tmp408_ = NULL;
			_tmp404_ = self->priv->context;
			_tmp405_ = vala_code_context_get_directory (_tmp404_);
			_tmp406_ = _tmp405_;
			_tmp407_ = vala_compiler_vapi_filename;
			_tmp408_ = g_strdup_printf ("%s%c%s", _tmp406_, (gint) G_DIR_SEPARATOR, _tmp407_);
			_g_free0 (vala_compiler_vapi_filename);
			vala_compiler_vapi_filename = _tmp408_;
		}
		_tmp409_ = interface_writer;
		_tmp410_ = self->priv->context;
		_tmp411_ = vala_compiler_vapi_filename;
		vala_code_writer_write_file (_tmp409_, _tmp410_, _tmp411_);
		_vala_code_visitor_unref0 (interface_writer);
	}
	_tmp412_ = vala_compiler_internal_vapi_filename;
	if (_tmp412_ != NULL) {
		gboolean _tmp413_ = FALSE;
		const gchar* _tmp414_;
		gboolean _tmp416_;
		ValaCodeWriter* _tmp418_;
		ValaCodeWriter* interface_writer;
		ValaCodeWriter* _tmp419_;
		const gchar* _tmp420_;
		const gchar* _tmp421_;
		const gchar* _tmp422_;
		gchar* _tmp423_;
		gchar* vapi_filename;
		gboolean _tmp424_ = FALSE;
		const gchar* _tmp425_;
		gboolean _tmp428_;
		ValaCodeWriter* _tmp434_;
		ValaCodeContext* _tmp435_;
		const gchar* _tmp436_;
		_tmp414_ = vala_compiler_internal_header_filename;
		if (_tmp414_ == NULL) {
			_tmp413_ = TRUE;
		} else {
			const gchar* _tmp415_;
			_tmp415_ = vala_compiler_header_filename;
			_tmp413_ = _tmp415_ == NULL;
		}
		_tmp416_ = _tmp413_;
		if (_tmp416_) {
			gint _tmp417_ = 0;
			vala_report_error (NULL, "--internal-vapi may only be used in combination with --header and --in" \
"ternal-header");
			_tmp417_ = vala_compiler_quit (self);
			result = _tmp417_;
			_vala_code_visitor_unref0 (gir_parser);
			_vala_code_visitor_unref0 (genie_parser);
			_vala_code_visitor_unref0 (parser);
			return result;
		}
		_tmp418_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_INTERNAL);
		interface_writer = _tmp418_;
		_tmp419_ = interface_writer;
		_tmp420_ = vala_compiler_header_filename;
		_tmp421_ = vala_compiler_internal_header_filename;
		vala_code_writer_set_cheader_override (_tmp419_, _tmp420_, _tmp421_);
		_tmp422_ = vala_compiler_internal_vapi_filename;
		_tmp423_ = g_strdup (_tmp422_);
		vapi_filename = _tmp423_;
		_tmp425_ = vala_compiler_directory;
		if (_tmp425_ != NULL) {
			const gchar* _tmp426_;
			gboolean _tmp427_ = FALSE;
			_tmp426_ = vapi_filename;
			_tmp427_ = g_path_is_absolute (_tmp426_);
			_tmp424_ = !_tmp427_;
		} else {
			_tmp424_ = FALSE;
		}
		_tmp428_ = _tmp424_;
		if (_tmp428_) {
			ValaCodeContext* _tmp429_;
			const gchar* _tmp430_;
			const gchar* _tmp431_;
			const gchar* _tmp432_;
			gchar* _tmp433_ = NULL;
			_tmp429_ = self->priv->context;
			_tmp430_ = vala_code_context_get_directory (_tmp429_);
			_tmp431_ = _tmp430_;
			_tmp432_ = vapi_filename;
			_tmp433_ = g_strdup_printf ("%s%c%s", _tmp431_, (gint) G_DIR_SEPARATOR, _tmp432_);
			_g_free0 (vapi_filename);
			vapi_filename = _tmp433_;
		}
		_tmp434_ = interface_writer;
		_tmp435_ = self->priv->context;
		_tmp436_ = vapi_filename;
		vala_code_writer_write_file (_tmp434_, _tmp435_, _tmp436_);
		_g_free0 (vala_compiler_internal_vapi_filename);
		vala_compiler_internal_vapi_filename = NULL;
		_g_free0 (vapi_filename);
		_vala_code_visitor_unref0 (interface_writer);
	}
	_tmp437_ = vala_compiler_dependencies;
	if (_tmp437_ != NULL) {
		ValaCodeContext* _tmp438_;
		const gchar* _tmp439_;
		_tmp438_ = self->priv->context;
		_tmp439_ = vala_compiler_dependencies;
		vala_code_context_write_dependencies (_tmp438_, _tmp439_);
	}
	_tmp440_ = vala_compiler_ccode_only;
	if (!_tmp440_) {
		ValaCCodeCompiler* _tmp441_;
		ValaCCodeCompiler* ccompiler;
		gboolean _tmp442_ = FALSE;
		const gchar* _tmp443_;
		gboolean _tmp445_;
		gchar** _tmp448_;
		gint _tmp448__length1;
		_tmp441_ = vala_ccode_compiler_new ();
		ccompiler = _tmp441_;
		_tmp443_ = vala_compiler_cc_command;
		if (_tmp443_ == NULL) {
			const gchar* _tmp444_ = NULL;
			_tmp444_ = g_getenv ("CC");
			_tmp442_ = _tmp444_ != NULL;
		} else {
			_tmp442_ = FALSE;
		}
		_tmp445_ = _tmp442_;
		if (_tmp445_) {
			const gchar* _tmp446_ = NULL;
			gchar* _tmp447_;
			_tmp446_ = g_getenv ("CC");
			_tmp447_ = g_strdup (_tmp446_);
			_g_free0 (vala_compiler_cc_command);
			vala_compiler_cc_command = _tmp447_;
		}
		_tmp448_ = vala_compiler_cc_options;
		_tmp448__length1 = _vala_array_length (vala_compiler_cc_options);
		if (_tmp448_ == NULL) {
			ValaCCodeCompiler* _tmp449_;
			ValaCodeContext* _tmp450_;
			const gchar* _tmp451_;
			gchar** _tmp452_ = NULL;
			gchar** _tmp453_;
			gint _tmp453__length1;
			_tmp449_ = ccompiler;
			_tmp450_ = self->priv->context;
			_tmp451_ = vala_compiler_cc_command;
			_tmp452_ = g_new0 (gchar*, 0 + 1);
			_tmp453_ = _tmp452_;
			_tmp453__length1 = 0;
			vala_ccode_compiler_compile (_tmp449_, _tmp450_, _tmp451_, _tmp453_, 0);
			_tmp453_ = (_vala_array_free (_tmp453_, _tmp453__length1, (GDestroyNotify) g_free), NULL);
		} else {
			ValaCCodeCompiler* _tmp454_;
			ValaCodeContext* _tmp455_;
			const gchar* _tmp456_;
			gchar** _tmp457_;
			gint _tmp457__length1;
			_tmp454_ = ccompiler;
			_tmp455_ = self->priv->context;
			_tmp456_ = vala_compiler_cc_command;
			_tmp457_ = vala_compiler_cc_options;
			_tmp457__length1 = _vala_array_length (vala_compiler_cc_options);
			vala_ccode_compiler_compile (_tmp454_, _tmp455_, _tmp456_, _tmp457_, _tmp457__length1);
		}
		_vala_ccode_compiler_unref0 (ccompiler);
	}
	_tmp458_ = vala_compiler_quit (self);
	result = _tmp458_;
	_vala_code_visitor_unref0 (gir_parser);
	_vala_code_visitor_unref0 (genie_parser);
	_vala_code_visitor_unref0 (parser);
	return result;
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_main_loop_unref0 (_data1_->loop);
		g_slice_free (Block1Data, _data1_);
	}
}


static void ___lambda2_ (Block1Data* _data1_, GPid pid, gint status) {
	gint _tmp0_;
	GMainLoop* _tmp1_;
	_tmp0_ = status;
	_data1_->child_status = (_tmp0_ & 0xff00) >> 8;
	_tmp1_ = _data1_->loop;
	g_main_loop_quit (_tmp1_);
}


static void ____lambda2__gchild_watch_func (GPid pid, gint status, gpointer self) {
	___lambda2_ (self, pid, status);
}


static gint vala_compiler_run_source (gchar** args, int args_length1) {
	gint result = 0;
	gint i;
	gboolean _tmp0_ = FALSE;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp8_;
	gchar** _tmp30_;
	gint _tmp30__length1;
	gint _tmp31_;
	const gchar* _tmp32_;
	gchar** _tmp34_;
	gint _tmp34__length1;
	gint _tmp35_;
	const gchar* _tmp36_;
	gchar* _tmp37_;
	gchar** _tmp38_ = NULL;
	const gchar* _tmp39_ = NULL;
	gchar** _tmp40_;
	gint _tmp40__length1;
	gint _tmp41_;
	const gchar* _tmp42_;
	gchar* _tmp43_ = NULL;
	gchar* _tmp44_;
	gchar* _tmp45_ = NULL;
	const gchar* _tmp46_;
	gint _tmp47_ = 0;
	gint outputfd;
	gint _tmp48_;
	ValaCompiler* _tmp49_;
	ValaCompiler* compiler;
	ValaCompiler* _tmp50_;
	gint _tmp51_ = 0;
	gint ret;
	gint _tmp52_;
	gint _tmp53_;
	const gchar* _tmp54_;
	gint _tmp55_ = 0;
	const gchar* _tmp57_;
	gchar* _tmp58_;
	gchar** _tmp59_ = NULL;
	gchar** target_args;
	gint target_args_length1;
	gint _target_args_size_;
	GError * _inner_error_ = NULL;
	i = 1;
	_tmp1_ = args;
	_tmp1__length1 = args_length1;
	_tmp2_ = i;
	_tmp3_ = _tmp1_[_tmp2_];
	if (_tmp3_ != NULL) {
		gchar** _tmp4_;
		gint _tmp4__length1;
		gint _tmp5_;
		const gchar* _tmp6_;
		gboolean _tmp7_ = FALSE;
		_tmp4_ = args;
		_tmp4__length1 = args_length1;
		_tmp5_ = i;
		_tmp6_ = _tmp4_[_tmp5_];
		_tmp7_ = g_str_has_prefix (_tmp6_, "-");
		_tmp0_ = _tmp7_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp8_ = _tmp0_;
	if (_tmp8_) {
		gint _tmp29_;
		{
			gchar** compile_args = NULL;
			gint compile_args_length1 = 0;
			gint _compile_args_size_ = 0;
			gchar** _tmp9_;
			gint _tmp9__length1;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gchar** _tmp13_ = NULL;
			gint _tmp14_ = 0;
			GOptionContext* _tmp15_;
			GOptionContext* opt_context;
			GOptionContext* _tmp16_;
			GOptionContext* _tmp17_;
			gchar** _tmp18_;
			gint _tmp18__length1;
			gchar** temp_args;
			gint temp_args_length1;
			gint _temp_args_size_;
			GOptionContext* _tmp19_;
			_tmp9_ = args;
			_tmp9__length1 = args_length1;
			_tmp10_ = _tmp9_[1];
			_tmp11_ = g_strconcat ("valac ", _tmp10_, NULL);
			_tmp12_ = _tmp11_;
			g_shell_parse_argv (_tmp12_, &_tmp14_, &_tmp13_, &_inner_error_);
			compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
			compile_args = _tmp13_;
			compile_args_length1 = _tmp14_;
			_compile_args_size_ = compile_args_length1;
			_g_free0 (_tmp12_);
			if (_inner_error_ != NULL) {
				compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
				if (_inner_error_->domain == G_SHELL_ERROR) {
					goto __catch0_g_shell_error;
				}
				if (_inner_error_->domain == G_OPTION_ERROR) {
					goto __catch0_g_option_error;
				}
				compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
			_tmp15_ = g_option_context_new ("- Vala");
			opt_context = _tmp15_;
			_tmp16_ = opt_context;
			g_option_context_set_help_enabled (_tmp16_, TRUE);
			_tmp17_ = opt_context;
			g_option_context_add_main_entries (_tmp17_, VALA_COMPILER_options, NULL);
			_tmp18_ = compile_args;
			_tmp18__length1 = compile_args_length1;
			temp_args = _tmp18_;
			temp_args_length1 = _tmp18__length1;
			_temp_args_size_ = temp_args_length1;
			_tmp19_ = opt_context;
			g_option_context_parse (_tmp19_, &temp_args_length1, &temp_args, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_option_context_free0 (opt_context);
				compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
				if (_inner_error_->domain == G_SHELL_ERROR) {
					goto __catch0_g_shell_error;
				}
				if (_inner_error_->domain == G_OPTION_ERROR) {
					goto __catch0_g_option_error;
				}
				_g_option_context_free0 (opt_context);
				compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
			_g_option_context_free0 (opt_context);
			compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
		}
		goto __finally0;
		__catch0_g_shell_error:
		{
			GError* e = NULL;
			FILE* _tmp20_;
			GError* _tmp21_;
			const gchar* _tmp22_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp20_ = stdout;
			_tmp21_ = e;
			_tmp22_ = _tmp21_->message;
			fprintf (_tmp20_, "%s\n", _tmp22_);
			result = 1;
			_g_error_free0 (e);
			return result;
		}
		goto __finally0;
		__catch0_g_option_error:
		{
			GError* e = NULL;
			FILE* _tmp23_;
			GError* _tmp24_;
			const gchar* _tmp25_;
			FILE* _tmp26_;
			gchar** _tmp27_;
			gint _tmp27__length1;
			const gchar* _tmp28_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp23_ = stdout;
			_tmp24_ = e;
			_tmp25_ = _tmp24_->message;
			fprintf (_tmp23_, "%s\n", _tmp25_);
			_tmp26_ = stdout;
			_tmp27_ = args;
			_tmp27__length1 = args_length1;
			_tmp28_ = _tmp27_[0];
			fprintf (_tmp26_, "Run '%s --help' to see a full list of available command line options.\n", _tmp28_);
			result = 1;
			_g_error_free0 (e);
			return result;
		}
		__finally0:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		_tmp29_ = i;
		i = _tmp29_ + 1;
	}
	_tmp30_ = args;
	_tmp30__length1 = args_length1;
	_tmp31_ = i;
	_tmp32_ = _tmp30_[_tmp31_];
	if (_tmp32_ == NULL) {
		FILE* _tmp33_;
		_tmp33_ = stderr;
		fprintf (_tmp33_, "No source file specified.\n");
		result = 1;
		return result;
	}
	_tmp34_ = args;
	_tmp34__length1 = args_length1;
	_tmp35_ = i;
	_tmp36_ = _tmp34_[_tmp35_];
	_tmp37_ = g_strdup (_tmp36_);
	_tmp38_ = g_new0 (gchar*, 1 + 1);
	_tmp38_[0] = _tmp37_;
	vala_compiler_sources = (_vala_array_free (vala_compiler_sources, _vala_array_length (vala_compiler_sources), (GDestroyNotify) g_free), NULL);
	vala_compiler_sources = _tmp38_;
	_tmp39_ = g_get_tmp_dir ();
	_tmp40_ = args;
	_tmp40__length1 = args_length1;
	_tmp41_ = i;
	_tmp42_ = _tmp40_[_tmp41_];
	_tmp43_ = g_path_get_basename (_tmp42_);
	_tmp44_ = _tmp43_;
	_tmp45_ = g_strdup_printf ("%s/%s.XXXXXX", _tmp39_, _tmp44_);
	_g_free0 (vala_compiler_output);
	vala_compiler_output = _tmp45_;
	_g_free0 (_tmp44_);
	_tmp46_ = vala_compiler_output;
	_tmp47_ = g_mkstemp (_tmp46_);
	outputfd = _tmp47_;
	_tmp48_ = outputfd;
	if (_tmp48_ < 0) {
		result = 1;
		return result;
	}
	vala_compiler_run_output = TRUE;
	vala_compiler_disable_warnings = TRUE;
	vala_compiler_quiet_mode = TRUE;
	_tmp49_ = vala_compiler_new ();
	compiler = _tmp49_;
	_tmp50_ = compiler;
	_tmp51_ = vala_compiler_run (_tmp50_);
	ret = _tmp51_;
	_tmp52_ = ret;
	if (_tmp52_ != 0) {
		result = ret;
		_vala_compiler_unref0 (compiler);
		return result;
	}
	_tmp53_ = outputfd;
	close (_tmp53_);
	_tmp54_ = vala_compiler_output;
	_tmp55_ = g_chmod (_tmp54_, 0700);
	if (_tmp55_ != 0) {
		const gchar* _tmp56_;
		_tmp56_ = vala_compiler_output;
		g_unlink (_tmp56_);
		result = 1;
		_vala_compiler_unref0 (compiler);
		return result;
	}
	_tmp57_ = vala_compiler_output;
	_tmp58_ = g_strdup (_tmp57_);
	_tmp59_ = g_new0 (gchar*, 1 + 1);
	_tmp59_[0] = _tmp58_;
	target_args = _tmp59_;
	target_args_length1 = 1;
	_target_args_size_ = target_args_length1;
	while (TRUE) {
		gint _tmp60_;
		gchar** _tmp61_;
		gint _tmp61__length1;
		gchar** _tmp62_;
		gint _tmp62__length1;
		gchar** _tmp63_;
		gint _tmp63__length1;
		gint _tmp64_;
		const gchar* _tmp65_;
		gchar* _tmp66_;
		gint _tmp67_;
		_tmp60_ = i;
		_tmp61_ = args;
		_tmp61__length1 = args_length1;
		if (!(_tmp60_ < _tmp61__length1)) {
			break;
		}
		_tmp62_ = target_args;
		_tmp62__length1 = target_args_length1;
		_tmp63_ = args;
		_tmp63__length1 = args_length1;
		_tmp64_ = i;
		_tmp65_ = _tmp63_[_tmp64_];
		_tmp66_ = g_strdup (_tmp65_);
		_vala_array_add1 (&target_args, &target_args_length1, &_target_args_size_, _tmp66_);
		_tmp67_ = i;
		i = _tmp67_ + 1;
	}
	{
		Block1Data* _data1_;
		GPid pid = 0;
		GMainLoop* _tmp68_;
		gchar** _tmp69_;
		gint _tmp69__length1;
		GPid _tmp70_ = 0;
		const gchar* _tmp71_;
		GPid _tmp72_;
		GMainLoop* _tmp73_;
		gint _tmp74_;
		_data1_ = g_slice_new0 (Block1Data);
		_data1_->_ref_count_ = 1;
		_tmp68_ = g_main_loop_new (NULL, FALSE);
		_data1_->loop = _tmp68_;
		_data1_->child_status = 0;
		_tmp69_ = target_args;
		_tmp69__length1 = target_args_length1;
		g_spawn_async (NULL, _tmp69_, NULL, (G_SPAWN_CHILD_INHERITS_STDIN | G_SPAWN_DO_NOT_REAP_CHILD) | G_SPAWN_FILE_AND_ARGV_ZERO, NULL, NULL, &_tmp70_, &_inner_error_);
		pid = _tmp70_;
		if (_inner_error_ != NULL) {
			block1_data_unref (_data1_);
			_data1_ = NULL;
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch1_g_spawn_error;
			}
			block1_data_unref (_data1_);
			_data1_ = NULL;
			target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
			_vala_compiler_unref0 (compiler);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		_tmp71_ = vala_compiler_output;
		g_unlink (_tmp71_);
		_tmp72_ = pid;
		g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, _tmp72_, ____lambda2__gchild_watch_func, block1_data_ref (_data1_), block1_data_unref);
		_tmp73_ = _data1_->loop;
		g_main_loop_run (_tmp73_);
		_tmp74_ = _data1_->child_status;
		result = _tmp74_;
		block1_data_unref (_data1_);
		_data1_ = NULL;
		target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
		_vala_compiler_unref0 (compiler);
		return result;
	}
	goto __finally1;
	__catch1_g_spawn_error:
	{
		GError* e = NULL;
		FILE* _tmp75_;
		GError* _tmp76_;
		const gchar* _tmp77_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp75_ = stdout;
		_tmp76_ = e;
		_tmp77_ = _tmp76_->message;
		fprintf (_tmp75_, "%s\n", _tmp77_);
		result = 1;
		_g_error_free0 (e);
		target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
		_vala_compiler_unref0 (compiler);
		return result;
	}
	__finally1:
	target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
	_vala_compiler_unref0 (compiler);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return 0;
}


static gint vala_compiler_main (gchar** args, int args_length1) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	gchar** _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp10_;
	gboolean _tmp23_;
	gboolean _tmp25_ = FALSE;
	gchar** _tmp26_;
	gint _tmp26__length1;
	gboolean _tmp28_;
	ValaCompiler* _tmp30_;
	ValaCompiler* compiler;
	ValaCompiler* _tmp31_;
	gint _tmp32_ = 0;
	GError * _inner_error_ = NULL;
	setlocale (LC_ALL, "");
	_tmp1_ = args;
	_tmp1__length1 = args_length1;
	_tmp2_ = _tmp1_[0];
	_tmp3_ = g_path_get_basename (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strcmp0 (_tmp4_, "vala") == 0;
	_g_free0 (_tmp4_);
	if (_tmp5_) {
		_tmp0_ = TRUE;
	} else {
		gchar** _tmp6_;
		gint _tmp6__length1;
		const gchar* _tmp7_;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		_tmp6_ = args;
		_tmp6__length1 = args_length1;
		_tmp7_ = _tmp6_[0];
		_tmp8_ = g_path_get_basename (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp0_ = g_strcmp0 (_tmp9_, "vala" PACKAGE_SUFFIX) == 0;
		_g_free0 (_tmp9_);
	}
	_tmp10_ = _tmp0_;
	if (_tmp10_) {
		gchar** _tmp11_;
		gint _tmp11__length1;
		gint _tmp12_ = 0;
		_tmp11_ = args;
		_tmp11__length1 = args_length1;
		_tmp12_ = vala_compiler_run_source (_tmp11_, _tmp11__length1);
		result = _tmp12_;
		return result;
	}
	{
		GOptionContext* _tmp13_;
		GOptionContext* opt_context;
		GOptionContext* _tmp14_;
		GOptionContext* _tmp15_;
		GOptionContext* _tmp16_;
		_tmp13_ = g_option_context_new ("- Vala Compiler");
		opt_context = _tmp13_;
		_tmp14_ = opt_context;
		g_option_context_set_help_enabled (_tmp14_, TRUE);
		_tmp15_ = opt_context;
		g_option_context_add_main_entries (_tmp15_, VALA_COMPILER_options, NULL);
		_tmp16_ = opt_context;
		g_option_context_parse (_tmp16_, &args_length1, &args, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_option_context_free0 (opt_context);
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch2_g_option_error;
			}
			_g_option_context_free0 (opt_context);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		_g_option_context_free0 (opt_context);
	}
	goto __finally2;
	__catch2_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp17_;
		GError* _tmp18_;
		const gchar* _tmp19_;
		FILE* _tmp20_;
		gchar** _tmp21_;
		gint _tmp21__length1;
		const gchar* _tmp22_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp17_ = stdout;
		_tmp18_ = e;
		_tmp19_ = _tmp18_->message;
		fprintf (_tmp17_, "%s\n", _tmp19_);
		_tmp20_ = stdout;
		_tmp21_ = args;
		_tmp21__length1 = args_length1;
		_tmp22_ = _tmp21_[0];
		fprintf (_tmp20_, "Run '%s --help' to see a full list of available command line options.\n", _tmp22_);
		result = 1;
		_g_error_free0 (e);
		return result;
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp23_ = vala_compiler_version;
	if (_tmp23_) {
		FILE* _tmp24_;
		_tmp24_ = stdout;
		fprintf (_tmp24_, "Vala %s\n", BUILD_VERSION);
		result = 0;
		return result;
	}
	_tmp26_ = vala_compiler_sources;
	_tmp26__length1 = _vala_array_length (vala_compiler_sources);
	if (_tmp26_ == NULL) {
		gchar** _tmp27_;
		gint _tmp27__length1;
		_tmp27_ = vala_compiler_fast_vapis;
		_tmp27__length1 = _vala_array_length (vala_compiler_fast_vapis);
		_tmp25_ = _tmp27_ == NULL;
	} else {
		_tmp25_ = FALSE;
	}
	_tmp28_ = _tmp25_;
	if (_tmp28_) {
		FILE* _tmp29_;
		_tmp29_ = stderr;
		fprintf (_tmp29_, "No source file specified.\n");
		result = 1;
		return result;
	}
	_tmp30_ = vala_compiler_new ();
	compiler = _tmp30_;
	_tmp31_ = compiler;
	_tmp32_ = vala_compiler_run (_tmp31_);
	result = _tmp32_;
	_vala_compiler_unref0 (compiler);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return vala_compiler_main (argv, argc);
}


ValaCompiler* vala_compiler_construct (GType object_type) {
	ValaCompiler* self = NULL;
	self = (ValaCompiler*) g_type_create_instance (object_type);
	return self;
}


ValaCompiler* vala_compiler_new (void) {
	return vala_compiler_construct (VALA_TYPE_COMPILER);
}


static void vala_value_compiler_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void vala_value_compiler_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		vala_compiler_unref (value->data[0].v_pointer);
	}
}


static void vala_value_compiler_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_compiler_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer vala_value_compiler_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* vala_value_compiler_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ValaCompiler* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_compiler_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* vala_value_compiler_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ValaCompiler** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_compiler_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* vala_param_spec_compiler (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ValaParamSpecCompiler* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_COMPILER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer vala_value_get_compiler (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_COMPILER), NULL);
	return value->data[0].v_pointer;
}


void vala_value_set_compiler (GValue* value, gpointer v_object) {
	ValaCompiler* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_COMPILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_COMPILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_compiler_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_compiler_unref (old);
	}
}


void vala_value_take_compiler (GValue* value, gpointer v_object) {
	ValaCompiler* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_COMPILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_COMPILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_compiler_unref (old);
	}
}


static void vala_compiler_class_init (ValaCompilerClass * klass) {
	vala_compiler_parent_class = g_type_class_peek_parent (klass);
	VALA_COMPILER_CLASS (klass)->finalize = vala_compiler_finalize;
	g_type_class_add_private (klass, sizeof (ValaCompilerPrivate));
}


static void vala_compiler_instance_init (ValaCompiler * self) {
	self->priv = VALA_COMPILER_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void vala_compiler_finalize (ValaCompiler* obj) {
	ValaCompiler * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_COMPILER, ValaCompiler);
	_vala_code_context_unref0 (self->priv->context);
}


GType vala_compiler_get_type (void) {
	static volatile gsize vala_compiler_type_id__volatile = 0;
	if (g_once_init_enter (&vala_compiler_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_compiler_init, vala_value_compiler_free_value, vala_value_compiler_copy_value, vala_value_compiler_peek_pointer, "p", vala_value_compiler_collect_value, "p", vala_value_compiler_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaCompilerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_compiler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCompiler), 0, (GInstanceInitFunc) vala_compiler_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_compiler_type_id;
		vala_compiler_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaCompiler", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_compiler_type_id__volatile, vala_compiler_type_id);
	}
	return vala_compiler_type_id__volatile;
}


gpointer vala_compiler_ref (gpointer instance) {
	ValaCompiler* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void vala_compiler_unref (gpointer instance) {
	ValaCompiler* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_COMPILER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



