/*
 * Generated by gdbus-codegen 2.33.3. DO NOT EDIT.
 *
 * The license of this code is the same as for the source it was derived from.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "bluetooth-client-glue.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  gboolean use_gvariant;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

/* ------------------------------------------------------------------------
 * Code for interface org.bluez.Manager
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:Manager
 * @title: Manager
 * @short_description: Generated C code for the org.bluez.Manager D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-bluez-Manager.top_of_page">org.bluez.Manager</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.bluez.Manager ---- */

static const _ExtendedGDBusArgInfo _manager_method_info_default_adapter_OUT_ARG_unnamed_arg0 =
{
  {
    -1,
    (gchar *) "unnamed_arg0",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo * const _manager_method_info_default_adapter_OUT_ARG_pointers[] =
{
  &_manager_method_info_default_adapter_OUT_ARG_unnamed_arg0,
  NULL
};

static const _ExtendedGDBusMethodInfo _manager_method_info_default_adapter =
{
  {
    -1,
    (gchar *) "DefaultAdapter",
    NULL,
    (GDBusArgInfo **) &_manager_method_info_default_adapter_OUT_ARG_pointers,
    NULL
  },
  "handle-default-adapter",
  FALSE
};

static const _ExtendedGDBusArgInfo _manager_method_info_get_properties_OUT_ARG_unnamed_arg0 =
{
  {
    -1,
    (gchar *) "unnamed_arg0",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo * const _manager_method_info_get_properties_OUT_ARG_pointers[] =
{
  &_manager_method_info_get_properties_OUT_ARG_unnamed_arg0,
  NULL
};

static const _ExtendedGDBusMethodInfo _manager_method_info_get_properties =
{
  {
    -1,
    (gchar *) "GetProperties",
    NULL,
    (GDBusArgInfo **) &_manager_method_info_get_properties_OUT_ARG_pointers,
    NULL
  },
  "handle-get-properties",
  FALSE
};

static const _ExtendedGDBusMethodInfo * const _manager_method_info_pointers[] =
{
  &_manager_method_info_default_adapter,
  &_manager_method_info_get_properties,
  NULL
};

static const _ExtendedGDBusArgInfo _manager_signal_info_adapter_added_ARG_unnamed_arg0 =
{
  {
    -1,
    (gchar *) "unnamed_arg0",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo * const _manager_signal_info_adapter_added_ARG_pointers[] =
{
  &_manager_signal_info_adapter_added_ARG_unnamed_arg0,
  NULL
};

static const _ExtendedGDBusSignalInfo _manager_signal_info_adapter_added =
{
  {
    -1,
    (gchar *) "AdapterAdded",
    (GDBusArgInfo **) &_manager_signal_info_adapter_added_ARG_pointers,
    NULL
  },
  "adapter-added"
};

static const _ExtendedGDBusArgInfo _manager_signal_info_adapter_removed_ARG_unnamed_arg0 =
{
  {
    -1,
    (gchar *) "unnamed_arg0",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo * const _manager_signal_info_adapter_removed_ARG_pointers[] =
{
  &_manager_signal_info_adapter_removed_ARG_unnamed_arg0,
  NULL
};

static const _ExtendedGDBusSignalInfo _manager_signal_info_adapter_removed =
{
  {
    -1,
    (gchar *) "AdapterRemoved",
    (GDBusArgInfo **) &_manager_signal_info_adapter_removed_ARG_pointers,
    NULL
  },
  "adapter-removed"
};

static const _ExtendedGDBusArgInfo _manager_signal_info_default_adapter_changed_ARG_unnamed_arg0 =
{
  {
    -1,
    (gchar *) "unnamed_arg0",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo * const _manager_signal_info_default_adapter_changed_ARG_pointers[] =
{
  &_manager_signal_info_default_adapter_changed_ARG_unnamed_arg0,
  NULL
};

static const _ExtendedGDBusSignalInfo _manager_signal_info_default_adapter_changed =
{
  {
    -1,
    (gchar *) "DefaultAdapterChanged",
    (GDBusArgInfo **) &_manager_signal_info_default_adapter_changed_ARG_pointers,
    NULL
  },
  "default-adapter-changed"
};

static const _ExtendedGDBusSignalInfo * const _manager_signal_info_pointers[] =
{
  &_manager_signal_info_adapter_added,
  &_manager_signal_info_adapter_removed,
  &_manager_signal_info_default_adapter_changed,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _manager_interface_info =
{
  {
    -1,
    (gchar *) "org.bluez.Manager",
    (GDBusMethodInfo **) &_manager_method_info_pointers,
    (GDBusSignalInfo **) &_manager_signal_info_pointers,
    NULL,
    NULL
  },
  "manager",
};


/**
 * manager_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-bluez-Manager.top_of_page">org.bluez.Manager</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
manager_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_manager_interface_info;
}

/**
 * manager_override_properties:
 * @klass: The class structure for a #GObject<!-- -->-derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #Manager interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
manager_override_properties (GObjectClass *klass, guint property_id_begin)
{
  return property_id_begin - 1;
}



/**
 * Manager:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-bluez-Manager.top_of_page">org.bluez.Manager</link>.
 */

/**
 * ManagerIface:
 * @parent_iface: The parent interface.
 * @handle_default_adapter: Handler for the #Manager::handle-default-adapter signal.
 * @handle_get_properties: Handler for the #Manager::handle-get-properties signal.
 * @adapter_added: Handler for the #Manager::adapter-added signal.
 * @adapter_removed: Handler for the #Manager::adapter-removed signal.
 * @default_adapter_changed: Handler for the #Manager::default-adapter-changed signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-bluez-Manager.top_of_page">org.bluez.Manager</link>.
 */

static void
manager_default_init (ManagerIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * Manager::handle-default-adapter:
   * @object: A #Manager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-bluez-Manager.DefaultAdapter">DefaultAdapter()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call manager_complete_default_adapter() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-default-adapter",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ManagerIface, handle_default_adapter),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * Manager::handle-get-properties:
   * @object: A #Manager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-bluez-Manager.GetProperties">GetProperties()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call manager_complete_get_properties() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-properties",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ManagerIface, handle_get_properties),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject signals for received D-Bus signals: */
  /**
   * Manager::adapter-added:
   * @object: A #Manager.
   * @arg_unnamed_arg0: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-bluez-Manager.AdapterAdded">"AdapterAdded"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("adapter-added",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ManagerIface, adapter_added),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    1, G_TYPE_STRING);

  /**
   * Manager::adapter-removed:
   * @object: A #Manager.
   * @arg_unnamed_arg0: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-bluez-Manager.AdapterRemoved">"AdapterRemoved"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("adapter-removed",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ManagerIface, adapter_removed),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    1, G_TYPE_STRING);

  /**
   * Manager::default-adapter-changed:
   * @object: A #Manager.
   * @arg_unnamed_arg0: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-bluez-Manager.DefaultAdapterChanged">"DefaultAdapterChanged"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("default-adapter-changed",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ManagerIface, default_adapter_changed),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    1, G_TYPE_STRING);

}

typedef ManagerIface ManagerInterface;
G_DEFINE_INTERFACE (Manager, manager, G_TYPE_OBJECT);

/**
 * manager_emit_adapter_added:
 * @object: A #Manager.
 * @arg_unnamed_arg0: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-bluez-Manager.AdapterAdded">"AdapterAdded"</link> D-Bus signal.
 */
void
manager_emit_adapter_added (
    Manager *object,
    const gchar *arg_unnamed_arg0)
{
  g_signal_emit_by_name (object, "adapter-added", arg_unnamed_arg0);
}

/**
 * manager_emit_adapter_removed:
 * @object: A #Manager.
 * @arg_unnamed_arg0: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-bluez-Manager.AdapterRemoved">"AdapterRemoved"</link> D-Bus signal.
 */
void
manager_emit_adapter_removed (
    Manager *object,
    const gchar *arg_unnamed_arg0)
{
  g_signal_emit_by_name (object, "adapter-removed", arg_unnamed_arg0);
}

/**
 * manager_emit_default_adapter_changed:
 * @object: A #Manager.
 * @arg_unnamed_arg0: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-bluez-Manager.DefaultAdapterChanged">"DefaultAdapterChanged"</link> D-Bus signal.
 */
void
manager_emit_default_adapter_changed (
    Manager *object,
    const gchar *arg_unnamed_arg0)
{
  g_signal_emit_by_name (object, "default-adapter-changed", arg_unnamed_arg0);
}

/**
 * manager_call_default_adapter:
 * @proxy: A #ManagerProxy.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-bluez-Manager.DefaultAdapter">DefaultAdapter()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call manager_call_default_adapter_finish() to get the result of the operation.
 *
 * See manager_call_default_adapter_sync() for the synchronous, blocking version of this method.
 */
void
manager_call_default_adapter (
    Manager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "DefaultAdapter",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * manager_call_default_adapter_finish:
 * @proxy: A #ManagerProxy.
 * @out_unnamed_arg0: (out): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to manager_call_default_adapter().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with manager_call_default_adapter().
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
manager_call_default_adapter_finish (
    Manager *proxy,
    gchar **out_unnamed_arg0,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_unnamed_arg0);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * manager_call_default_adapter_sync:
 * @proxy: A #ManagerProxy.
 * @out_unnamed_arg0: (out): Return location for return parameter or %NULL to ignore.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-bluez-Manager.DefaultAdapter">DefaultAdapter()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See manager_call_default_adapter() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
manager_call_default_adapter_sync (
    Manager *proxy,
    gchar **out_unnamed_arg0,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "DefaultAdapter",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_unnamed_arg0);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * manager_call_get_properties:
 * @proxy: A #ManagerProxy.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-bluez-Manager.GetProperties">GetProperties()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call manager_call_get_properties_finish() to get the result of the operation.
 *
 * See manager_call_get_properties_sync() for the synchronous, blocking version of this method.
 */
void
manager_call_get_properties (
    Manager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetProperties",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * manager_call_get_properties_finish:
 * @proxy: A #ManagerProxy.
 * @out_unnamed_arg0: (out): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to manager_call_get_properties().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with manager_call_get_properties().
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
manager_call_get_properties_finish (
    Manager *proxy,
    GVariant **out_unnamed_arg0,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sv})",
                 out_unnamed_arg0);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * manager_call_get_properties_sync:
 * @proxy: A #ManagerProxy.
 * @out_unnamed_arg0: (out): Return location for return parameter or %NULL to ignore.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-bluez-Manager.GetProperties">GetProperties()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See manager_call_get_properties() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
manager_call_get_properties_sync (
    Manager *proxy,
    GVariant **out_unnamed_arg0,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetProperties",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sv})",
                 out_unnamed_arg0);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * manager_complete_default_adapter:
 * @object: A #Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @unnamed_arg0: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-bluez-Manager.DefaultAdapter">DefaultAdapter()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
manager_complete_default_adapter (
    Manager *object,
    GDBusMethodInvocation *invocation,
    const gchar *unnamed_arg0)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   unnamed_arg0));
}

/**
 * manager_complete_get_properties:
 * @object: A #Manager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @unnamed_arg0: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-bluez-Manager.GetProperties">GetProperties()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
manager_complete_get_properties (
    Manager *object,
    GDBusMethodInvocation *invocation,
    GVariant *unnamed_arg0)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a{sv})",
                   unnamed_arg0));
}

/* ------------------------------------------------------------------------ */

/**
 * ManagerProxy:
 *
 * The #ManagerProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * ManagerProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #ManagerProxy.
 */

struct _ManagerProxyPrivate
{
  GData *qdata;
};

static void manager_proxy_iface_init (ManagerIface *iface);

G_DEFINE_TYPE_WITH_CODE (ManagerProxy, manager_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (TYPE_MANAGER, manager_proxy_iface_init));

static void
manager_proxy_finalize (GObject *object)
{
  ManagerProxy *proxy = MANAGER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (manager_proxy_parent_class)->finalize (object);
}

static void
manager_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec)
{
}

static void
manager_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
}

static void
manager_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  guint num_params;
  guint n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_manager_interface_info, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], TYPE_MANAGER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TYPE_MANAGER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
manager_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  ManagerProxy *proxy = MANAGER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_manager_interface_info, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_manager_interface_info, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
manager_proxy_init (ManagerProxy *proxy)
{
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, TYPE_MANAGER_PROXY, ManagerProxyPrivate);
  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), manager_interface_info ());
}

static void
manager_proxy_class_init (ManagerProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  g_type_class_add_private (klass, sizeof (ManagerProxyPrivate));

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = manager_proxy_finalize;
  gobject_class->get_property = manager_proxy_get_property;
  gobject_class->set_property = manager_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = manager_proxy_g_signal;
  proxy_class->g_properties_changed = manager_proxy_g_properties_changed;

}

static void
manager_proxy_iface_init (ManagerIface *iface)
{
}

/**
 * manager_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (allow-none): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-bluez-Manager.top_of_page">org.bluez.Manager</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call manager_proxy_new_finish() to get the result of the operation.
 *
 * See manager_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
manager_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TYPE_MANAGER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.bluez.Manager", NULL);
}

/**
 * manager_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to manager_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with manager_proxy_new().
 *
 * Returns: (transfer full) (type ManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
Manager *
manager_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return MANAGER (ret);
  else
    return NULL;
}

/**
 * manager_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (allow-none): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-bluez-Manager.top_of_page">org.bluez.Manager</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See manager_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type ManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
Manager *
manager_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TYPE_MANAGER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.bluez.Manager", NULL);
  if (ret != NULL)
    return MANAGER (ret);
  else
    return NULL;
}


/**
 * manager_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like manager_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call manager_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See manager_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
manager_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TYPE_MANAGER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.bluez.Manager", NULL);
}

/**
 * manager_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to manager_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with manager_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type ManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
Manager *
manager_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return MANAGER (ret);
  else
    return NULL;
}

/**
 * manager_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like manager_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See manager_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type ManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
Manager *
manager_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TYPE_MANAGER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.bluez.Manager", NULL);
  if (ret != NULL)
    return MANAGER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * ManagerSkeleton:
 *
 * The #ManagerSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * ManagerSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #ManagerSkeleton.
 */

struct _ManagerSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_manager_skeleton_handle_method_call (
  GDBusConnection *connection,
  const gchar *sender,
  const gchar *object_path,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  ManagerSkeleton *skeleton = MANAGER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  guint num_params;
  guint num_extra;
  guint n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], TYPE_MANAGER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TYPE_MANAGER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_manager_skeleton_handle_get_property (
  GDBusConnection *connection,
  const gchar *sender,
  const gchar *object_path,
  const gchar *interface_name,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  ManagerSkeleton *skeleton = MANAGER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_manager_interface_info, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_manager_skeleton_handle_set_property (
  GDBusConnection *connection,
  const gchar *sender,
  const gchar *object_path,
  const gchar *interface_name,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  ManagerSkeleton *skeleton = MANAGER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_manager_interface_info, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _manager_skeleton_vtable =
{
  _manager_skeleton_handle_method_call,
  _manager_skeleton_handle_get_property,
  _manager_skeleton_handle_set_property
};

static GDBusInterfaceInfo *
manager_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton)
{
  return manager_interface_info ();
}

static GDBusInterfaceVTable *
manager_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton)
{
  return (GDBusInterfaceVTable *) &_manager_skeleton_vtable;
}

static GVariant *
manager_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  ManagerSkeleton *skeleton = MANAGER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_manager_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _manager_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _manager_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _manager_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.bluez.Manager", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
manager_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
}

static void
_manager_on_signal_adapter_added (
    Manager *object,
    const gchar *arg_unnamed_arg0)
{
  ManagerSkeleton *skeleton = MANAGER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(o)",
                   arg_unnamed_arg0));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.bluez.Manager", "AdapterAdded",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_manager_on_signal_adapter_removed (
    Manager *object,
    const gchar *arg_unnamed_arg0)
{
  ManagerSkeleton *skeleton = MANAGER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(o)",
                   arg_unnamed_arg0));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.bluez.Manager", "AdapterRemoved",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_manager_on_signal_default_adapter_changed (
    Manager *object,
    const gchar *arg_unnamed_arg0)
{
  ManagerSkeleton *skeleton = MANAGER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(o)",
                   arg_unnamed_arg0));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.bluez.Manager", "DefaultAdapterChanged",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void manager_skeleton_iface_init (ManagerIface *iface);
G_DEFINE_TYPE_WITH_CODE (ManagerSkeleton, manager_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (TYPE_MANAGER, manager_skeleton_iface_init));

static void
manager_skeleton_finalize (GObject *object)
{
  ManagerSkeleton *skeleton = MANAGER_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (manager_skeleton_parent_class)->finalize (object);
}

static void
manager_skeleton_init (ManagerSkeleton *skeleton)
{
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, TYPE_MANAGER_SKELETON, ManagerSkeletonPrivate);
  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
manager_skeleton_class_init (ManagerSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  g_type_class_add_private (klass, sizeof (ManagerSkeletonPrivate));

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = manager_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = manager_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = manager_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = manager_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = manager_skeleton_dbus_interface_get_vtable;
}

static void
manager_skeleton_iface_init (ManagerIface *iface)
{
  iface->adapter_added = _manager_on_signal_adapter_added;
  iface->adapter_removed = _manager_on_signal_adapter_removed;
  iface->default_adapter_changed = _manager_on_signal_default_adapter_changed;
}

/**
 * manager_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-bluez-Manager.top_of_page">org.bluez.Manager</link>.
 *
 * Returns: (transfer full) (type ManagerSkeleton): The skeleton object.
 */
Manager *
manager_skeleton_new (void)
{
  return MANAGER (g_object_new (TYPE_MANAGER_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.bluez.Adapter
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:Adapter
 * @title: Adapter
 * @short_description: Generated C code for the org.bluez.Adapter D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-bluez-Adapter.top_of_page">org.bluez.Adapter</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.bluez.Adapter ---- */

static const _ExtendedGDBusArgInfo _adapter_method_info_get_properties_OUT_ARG_unnamed_arg0 =
{
  {
    -1,
    (gchar *) "unnamed_arg0",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo * const _adapter_method_info_get_properties_OUT_ARG_pointers[] =
{
  &_adapter_method_info_get_properties_OUT_ARG_unnamed_arg0,
  NULL
};

static const _ExtendedGDBusMethodInfo _adapter_method_info_get_properties =
{
  {
    -1,
    (gchar *) "GetProperties",
    NULL,
    (GDBusArgInfo **) &_adapter_method_info_get_properties_OUT_ARG_pointers,
    NULL
  },
  "handle-get-properties",
  FALSE
};

static const _ExtendedGDBusArgInfo _adapter_method_info_set_property_IN_ARG_unnamed_arg0 =
{
  {
    -1,
    (gchar *) "unnamed_arg0",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _adapter_method_info_set_property_IN_ARG_unnamed_arg1 =
{
  {
    -1,
    (gchar *) "unnamed_arg1",
    (gchar *) "v",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo * const _adapter_method_info_set_property_IN_ARG_pointers[] =
{
  &_adapter_method_info_set_property_IN_ARG_unnamed_arg0,
  &_adapter_method_info_set_property_IN_ARG_unnamed_arg1,
  NULL
};

static const _ExtendedGDBusMethodInfo _adapter_method_info_set_property =
{
  {
    -1,
    (gchar *) "SetProperty",
    (GDBusArgInfo **) &_adapter_method_info_set_property_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-property",
  FALSE
};

static const _ExtendedGDBusMethodInfo _adapter_method_info_start_discovery =
{
  {
    -1,
    (gchar *) "StartDiscovery",
    NULL,
    NULL,
    NULL
  },
  "handle-start-discovery",
  FALSE
};

static const _ExtendedGDBusMethodInfo _adapter_method_info_stop_discovery =
{
  {
    -1,
    (gchar *) "StopDiscovery",
    NULL,
    NULL,
    NULL
  },
  "handle-stop-discovery",
  FALSE
};

static const _ExtendedGDBusArgInfo _adapter_method_info_remove_device_IN_ARG_device =
{
  {
    -1,
    (gchar *) "device",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo * const _adapter_method_info_remove_device_IN_ARG_pointers[] =
{
  &_adapter_method_info_remove_device_IN_ARG_device,
  NULL
};

static const _ExtendedGDBusMethodInfo _adapter_method_info_remove_device =
{
  {
    -1,
    (gchar *) "RemoveDevice",
    (GDBusArgInfo **) &_adapter_method_info_remove_device_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-remove-device",
  FALSE
};

static const _ExtendedGDBusMethodInfo * const _adapter_method_info_pointers[] =
{
  &_adapter_method_info_get_properties,
  &_adapter_method_info_set_property,
  &_adapter_method_info_start_discovery,
  &_adapter_method_info_stop_discovery,
  &_adapter_method_info_remove_device,
  NULL
};

static const _ExtendedGDBusArgInfo _adapter_signal_info_property_changed_ARG_unnamed_arg0 =
{
  {
    -1,
    (gchar *) "unnamed_arg0",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _adapter_signal_info_property_changed_ARG_unnamed_arg1 =
{
  {
    -1,
    (gchar *) "unnamed_arg1",
    (gchar *) "v",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo * const _adapter_signal_info_property_changed_ARG_pointers[] =
{
  &_adapter_signal_info_property_changed_ARG_unnamed_arg0,
  &_adapter_signal_info_property_changed_ARG_unnamed_arg1,
  NULL
};

static const _ExtendedGDBusSignalInfo _adapter_signal_info_property_changed =
{
  {
    -1,
    (gchar *) "PropertyChanged",
    (GDBusArgInfo **) &_adapter_signal_info_property_changed_ARG_pointers,
    NULL
  },
  "property-changed"
};

static const _ExtendedGDBusArgInfo _adapter_signal_info_device_created_ARG_unnamed_arg0 =
{
  {
    -1,
    (gchar *) "unnamed_arg0",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo * const _adapter_signal_info_device_created_ARG_pointers[] =
{
  &_adapter_signal_info_device_created_ARG_unnamed_arg0,
  NULL
};

static const _ExtendedGDBusSignalInfo _adapter_signal_info_device_created =
{
  {
    -1,
    (gchar *) "DeviceCreated",
    (GDBusArgInfo **) &_adapter_signal_info_device_created_ARG_pointers,
    NULL
  },
  "device-created"
};

static const _ExtendedGDBusArgInfo _adapter_signal_info_device_removed_ARG_unnamed_arg0 =
{
  {
    -1,
    (gchar *) "unnamed_arg0",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo * const _adapter_signal_info_device_removed_ARG_pointers[] =
{
  &_adapter_signal_info_device_removed_ARG_unnamed_arg0,
  NULL
};

static const _ExtendedGDBusSignalInfo _adapter_signal_info_device_removed =
{
  {
    -1,
    (gchar *) "DeviceRemoved",
    (GDBusArgInfo **) &_adapter_signal_info_device_removed_ARG_pointers,
    NULL
  },
  "device-removed"
};

static const _ExtendedGDBusArgInfo _adapter_signal_info_device_found_ARG_unnamed_arg0 =
{
  {
    -1,
    (gchar *) "unnamed_arg0",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _adapter_signal_info_device_found_ARG_unnamed_arg1 =
{
  {
    -1,
    (gchar *) "unnamed_arg1",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo * const _adapter_signal_info_device_found_ARG_pointers[] =
{
  &_adapter_signal_info_device_found_ARG_unnamed_arg0,
  &_adapter_signal_info_device_found_ARG_unnamed_arg1,
  NULL
};

static const _ExtendedGDBusSignalInfo _adapter_signal_info_device_found =
{
  {
    -1,
    (gchar *) "DeviceFound",
    (GDBusArgInfo **) &_adapter_signal_info_device_found_ARG_pointers,
    NULL
  },
  "device-found"
};

static const _ExtendedGDBusSignalInfo * const _adapter_signal_info_pointers[] =
{
  &_adapter_signal_info_property_changed,
  &_adapter_signal_info_device_created,
  &_adapter_signal_info_device_removed,
  &_adapter_signal_info_device_found,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _adapter_interface_info =
{
  {
    -1,
    (gchar *) "org.bluez.Adapter",
    (GDBusMethodInfo **) &_adapter_method_info_pointers,
    (GDBusSignalInfo **) &_adapter_signal_info_pointers,
    NULL,
    NULL
  },
  "adapter",
};


/**
 * adapter_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-bluez-Adapter.top_of_page">org.bluez.Adapter</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
adapter_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_adapter_interface_info;
}

/**
 * adapter_override_properties:
 * @klass: The class structure for a #GObject<!-- -->-derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #Adapter interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
adapter_override_properties (GObjectClass *klass, guint property_id_begin)
{
  return property_id_begin - 1;
}



/**
 * Adapter:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-bluez-Adapter.top_of_page">org.bluez.Adapter</link>.
 */

/**
 * AdapterIface:
 * @parent_iface: The parent interface.
 * @handle_get_properties: Handler for the #Adapter::handle-get-properties signal.
 * @handle_remove_device: Handler for the #Adapter::handle-remove-device signal.
 * @handle_set_property: Handler for the #Adapter::handle-set-property signal.
 * @handle_start_discovery: Handler for the #Adapter::handle-start-discovery signal.
 * @handle_stop_discovery: Handler for the #Adapter::handle-stop-discovery signal.
 * @device_created: Handler for the #Adapter::device-created signal.
 * @device_found: Handler for the #Adapter::device-found signal.
 * @device_removed: Handler for the #Adapter::device-removed signal.
 * @property_changed: Handler for the #Adapter::property-changed signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-bluez-Adapter.top_of_page">org.bluez.Adapter</link>.
 */

static void
adapter_default_init (AdapterIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * Adapter::handle-get-properties:
   * @object: A #Adapter.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-bluez-Adapter.GetProperties">GetProperties()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call adapter_complete_get_properties() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-properties",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (AdapterIface, handle_get_properties),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * Adapter::handle-set-property:
   * @object: A #Adapter.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_unnamed_arg0: Argument passed by remote caller.
   * @arg_unnamed_arg1: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-bluez-Adapter.SetProperty">SetProperty()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call adapter_complete_set_property() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-property",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (AdapterIface, handle_set_property),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * Adapter::handle-start-discovery:
   * @object: A #Adapter.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-bluez-Adapter.StartDiscovery">StartDiscovery()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call adapter_complete_start_discovery() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-start-discovery",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (AdapterIface, handle_start_discovery),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * Adapter::handle-stop-discovery:
   * @object: A #Adapter.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-bluez-Adapter.StopDiscovery">StopDiscovery()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call adapter_complete_stop_discovery() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-stop-discovery",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (AdapterIface, handle_stop_discovery),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * Adapter::handle-remove-device:
   * @object: A #Adapter.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_device: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-bluez-Adapter.RemoveDevice">RemoveDevice()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call adapter_complete_remove_device() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-remove-device",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (AdapterIface, handle_remove_device),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /* GObject signals for received D-Bus signals: */
  /**
   * Adapter::property-changed:
   * @object: A #Adapter.
   * @arg_unnamed_arg0: Argument.
   * @arg_unnamed_arg1: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-bluez-Adapter.PropertyChanged">"PropertyChanged"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("property-changed",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (AdapterIface, property_changed),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    2, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * Adapter::device-created:
   * @object: A #Adapter.
   * @arg_unnamed_arg0: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-bluez-Adapter.DeviceCreated">"DeviceCreated"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("device-created",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (AdapterIface, device_created),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    1, G_TYPE_STRING);

  /**
   * Adapter::device-removed:
   * @object: A #Adapter.
   * @arg_unnamed_arg0: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-bluez-Adapter.DeviceRemoved">"DeviceRemoved"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("device-removed",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (AdapterIface, device_removed),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    1, G_TYPE_STRING);

  /**
   * Adapter::device-found:
   * @object: A #Adapter.
   * @arg_unnamed_arg0: Argument.
   * @arg_unnamed_arg1: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-bluez-Adapter.DeviceFound">"DeviceFound"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("device-found",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (AdapterIface, device_found),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    2, G_TYPE_STRING, G_TYPE_VARIANT);

}

typedef AdapterIface AdapterInterface;
G_DEFINE_INTERFACE (Adapter, adapter, G_TYPE_OBJECT);

/**
 * adapter_emit_property_changed:
 * @object: A #Adapter.
 * @arg_unnamed_arg0: Argument to pass with the signal.
 * @arg_unnamed_arg1: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-bluez-Adapter.PropertyChanged">"PropertyChanged"</link> D-Bus signal.
 */
void
adapter_emit_property_changed (
    Adapter *object,
    const gchar *arg_unnamed_arg0,
    GVariant *arg_unnamed_arg1)
{
  g_signal_emit_by_name (object, "property-changed", arg_unnamed_arg0, arg_unnamed_arg1);
}

/**
 * adapter_emit_device_created:
 * @object: A #Adapter.
 * @arg_unnamed_arg0: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-bluez-Adapter.DeviceCreated">"DeviceCreated"</link> D-Bus signal.
 */
void
adapter_emit_device_created (
    Adapter *object,
    const gchar *arg_unnamed_arg0)
{
  g_signal_emit_by_name (object, "device-created", arg_unnamed_arg0);
}

/**
 * adapter_emit_device_removed:
 * @object: A #Adapter.
 * @arg_unnamed_arg0: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-bluez-Adapter.DeviceRemoved">"DeviceRemoved"</link> D-Bus signal.
 */
void
adapter_emit_device_removed (
    Adapter *object,
    const gchar *arg_unnamed_arg0)
{
  g_signal_emit_by_name (object, "device-removed", arg_unnamed_arg0);
}

/**
 * adapter_emit_device_found:
 * @object: A #Adapter.
 * @arg_unnamed_arg0: Argument to pass with the signal.
 * @arg_unnamed_arg1: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-bluez-Adapter.DeviceFound">"DeviceFound"</link> D-Bus signal.
 */
void
adapter_emit_device_found (
    Adapter *object,
    const gchar *arg_unnamed_arg0,
    GVariant *arg_unnamed_arg1)
{
  g_signal_emit_by_name (object, "device-found", arg_unnamed_arg0, arg_unnamed_arg1);
}

/**
 * adapter_call_get_properties:
 * @proxy: A #AdapterProxy.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-bluez-Adapter.GetProperties">GetProperties()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call adapter_call_get_properties_finish() to get the result of the operation.
 *
 * See adapter_call_get_properties_sync() for the synchronous, blocking version of this method.
 */
void
adapter_call_get_properties (
    Adapter *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetProperties",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * adapter_call_get_properties_finish:
 * @proxy: A #AdapterProxy.
 * @out_unnamed_arg0: (out): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to adapter_call_get_properties().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with adapter_call_get_properties().
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
adapter_call_get_properties_finish (
    Adapter *proxy,
    GVariant **out_unnamed_arg0,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sv})",
                 out_unnamed_arg0);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * adapter_call_get_properties_sync:
 * @proxy: A #AdapterProxy.
 * @out_unnamed_arg0: (out): Return location for return parameter or %NULL to ignore.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-bluez-Adapter.GetProperties">GetProperties()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See adapter_call_get_properties() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
adapter_call_get_properties_sync (
    Adapter *proxy,
    GVariant **out_unnamed_arg0,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetProperties",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sv})",
                 out_unnamed_arg0);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * adapter_call_set_property:
 * @proxy: A #AdapterProxy.
 * @arg_unnamed_arg0: Argument to pass with the method invocation.
 * @arg_unnamed_arg1: Argument to pass with the method invocation.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-bluez-Adapter.SetProperty">SetProperty()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call adapter_call_set_property_finish() to get the result of the operation.
 *
 * See adapter_call_set_property_sync() for the synchronous, blocking version of this method.
 */
void
adapter_call_set_property (
    Adapter *proxy,
    const gchar *arg_unnamed_arg0,
    GVariant *arg_unnamed_arg1,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetProperty",
    g_variant_new ("(s@v)",
                   arg_unnamed_arg0,
                   arg_unnamed_arg1),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * adapter_call_set_property_finish:
 * @proxy: A #AdapterProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to adapter_call_set_property().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with adapter_call_set_property().
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
adapter_call_set_property_finish (
    Adapter *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * adapter_call_set_property_sync:
 * @proxy: A #AdapterProxy.
 * @arg_unnamed_arg0: Argument to pass with the method invocation.
 * @arg_unnamed_arg1: Argument to pass with the method invocation.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-bluez-Adapter.SetProperty">SetProperty()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See adapter_call_set_property() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
adapter_call_set_property_sync (
    Adapter *proxy,
    const gchar *arg_unnamed_arg0,
    GVariant *arg_unnamed_arg1,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetProperty",
    g_variant_new ("(s@v)",
                   arg_unnamed_arg0,
                   arg_unnamed_arg1),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * adapter_call_start_discovery:
 * @proxy: A #AdapterProxy.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-bluez-Adapter.StartDiscovery">StartDiscovery()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call adapter_call_start_discovery_finish() to get the result of the operation.
 *
 * See adapter_call_start_discovery_sync() for the synchronous, blocking version of this method.
 */
void
adapter_call_start_discovery (
    Adapter *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "StartDiscovery",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * adapter_call_start_discovery_finish:
 * @proxy: A #AdapterProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to adapter_call_start_discovery().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with adapter_call_start_discovery().
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
adapter_call_start_discovery_finish (
    Adapter *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * adapter_call_start_discovery_sync:
 * @proxy: A #AdapterProxy.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-bluez-Adapter.StartDiscovery">StartDiscovery()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See adapter_call_start_discovery() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
adapter_call_start_discovery_sync (
    Adapter *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "StartDiscovery",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * adapter_call_stop_discovery:
 * @proxy: A #AdapterProxy.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-bluez-Adapter.StopDiscovery">StopDiscovery()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call adapter_call_stop_discovery_finish() to get the result of the operation.
 *
 * See adapter_call_stop_discovery_sync() for the synchronous, blocking version of this method.
 */
void
adapter_call_stop_discovery (
    Adapter *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "StopDiscovery",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * adapter_call_stop_discovery_finish:
 * @proxy: A #AdapterProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to adapter_call_stop_discovery().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with adapter_call_stop_discovery().
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
adapter_call_stop_discovery_finish (
    Adapter *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * adapter_call_stop_discovery_sync:
 * @proxy: A #AdapterProxy.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-bluez-Adapter.StopDiscovery">StopDiscovery()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See adapter_call_stop_discovery() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
adapter_call_stop_discovery_sync (
    Adapter *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "StopDiscovery",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * adapter_call_remove_device:
 * @proxy: A #AdapterProxy.
 * @arg_device: Argument to pass with the method invocation.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-bluez-Adapter.RemoveDevice">RemoveDevice()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call adapter_call_remove_device_finish() to get the result of the operation.
 *
 * See adapter_call_remove_device_sync() for the synchronous, blocking version of this method.
 */
void
adapter_call_remove_device (
    Adapter *proxy,
    const gchar *arg_device,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "RemoveDevice",
    g_variant_new ("(o)",
                   arg_device),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * adapter_call_remove_device_finish:
 * @proxy: A #AdapterProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to adapter_call_remove_device().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with adapter_call_remove_device().
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
adapter_call_remove_device_finish (
    Adapter *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * adapter_call_remove_device_sync:
 * @proxy: A #AdapterProxy.
 * @arg_device: Argument to pass with the method invocation.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-bluez-Adapter.RemoveDevice">RemoveDevice()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See adapter_call_remove_device() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
adapter_call_remove_device_sync (
    Adapter *proxy,
    const gchar *arg_device,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "RemoveDevice",
    g_variant_new ("(o)",
                   arg_device),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * adapter_complete_get_properties:
 * @object: A #Adapter.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @unnamed_arg0: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-bluez-Adapter.GetProperties">GetProperties()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
adapter_complete_get_properties (
    Adapter *object,
    GDBusMethodInvocation *invocation,
    GVariant *unnamed_arg0)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a{sv})",
                   unnamed_arg0));
}

/**
 * adapter_complete_set_property:
 * @object: A #Adapter.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-bluez-Adapter.SetProperty">SetProperty()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
adapter_complete_set_property (
    Adapter *object,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * adapter_complete_start_discovery:
 * @object: A #Adapter.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-bluez-Adapter.StartDiscovery">StartDiscovery()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
adapter_complete_start_discovery (
    Adapter *object,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * adapter_complete_stop_discovery:
 * @object: A #Adapter.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-bluez-Adapter.StopDiscovery">StopDiscovery()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
adapter_complete_stop_discovery (
    Adapter *object,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * adapter_complete_remove_device:
 * @object: A #Adapter.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-bluez-Adapter.RemoveDevice">RemoveDevice()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
adapter_complete_remove_device (
    Adapter *object,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * AdapterProxy:
 *
 * The #AdapterProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * AdapterProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #AdapterProxy.
 */

struct _AdapterProxyPrivate
{
  GData *qdata;
};

static void adapter_proxy_iface_init (AdapterIface *iface);

G_DEFINE_TYPE_WITH_CODE (AdapterProxy, adapter_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (TYPE_ADAPTER, adapter_proxy_iface_init));

static void
adapter_proxy_finalize (GObject *object)
{
  AdapterProxy *proxy = ADAPTER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (adapter_proxy_parent_class)->finalize (object);
}

static void
adapter_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec)
{
}

static void
adapter_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
}

static void
adapter_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  guint num_params;
  guint n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_adapter_interface_info, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], TYPE_ADAPTER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TYPE_ADAPTER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
adapter_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  AdapterProxy *proxy = ADAPTER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_adapter_interface_info, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_adapter_interface_info, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
adapter_proxy_init (AdapterProxy *proxy)
{
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, TYPE_ADAPTER_PROXY, AdapterProxyPrivate);
  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), adapter_interface_info ());
}

static void
adapter_proxy_class_init (AdapterProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  g_type_class_add_private (klass, sizeof (AdapterProxyPrivate));

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = adapter_proxy_finalize;
  gobject_class->get_property = adapter_proxy_get_property;
  gobject_class->set_property = adapter_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = adapter_proxy_g_signal;
  proxy_class->g_properties_changed = adapter_proxy_g_properties_changed;

}

static void
adapter_proxy_iface_init (AdapterIface *iface)
{
}

/**
 * adapter_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (allow-none): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-bluez-Adapter.top_of_page">org.bluez.Adapter</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call adapter_proxy_new_finish() to get the result of the operation.
 *
 * See adapter_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
adapter_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TYPE_ADAPTER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.bluez.Adapter", NULL);
}

/**
 * adapter_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to adapter_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with adapter_proxy_new().
 *
 * Returns: (transfer full) (type AdapterProxy): The constructed proxy object or %NULL if @error is set.
 */
Adapter *
adapter_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return ADAPTER (ret);
  else
    return NULL;
}

/**
 * adapter_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (allow-none): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-bluez-Adapter.top_of_page">org.bluez.Adapter</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See adapter_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type AdapterProxy): The constructed proxy object or %NULL if @error is set.
 */
Adapter *
adapter_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TYPE_ADAPTER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.bluez.Adapter", NULL);
  if (ret != NULL)
    return ADAPTER (ret);
  else
    return NULL;
}


/**
 * adapter_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like adapter_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call adapter_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See adapter_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
adapter_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TYPE_ADAPTER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.bluez.Adapter", NULL);
}

/**
 * adapter_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to adapter_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with adapter_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type AdapterProxy): The constructed proxy object or %NULL if @error is set.
 */
Adapter *
adapter_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return ADAPTER (ret);
  else
    return NULL;
}

/**
 * adapter_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like adapter_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See adapter_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type AdapterProxy): The constructed proxy object or %NULL if @error is set.
 */
Adapter *
adapter_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TYPE_ADAPTER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.bluez.Adapter", NULL);
  if (ret != NULL)
    return ADAPTER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * AdapterSkeleton:
 *
 * The #AdapterSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * AdapterSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #AdapterSkeleton.
 */

struct _AdapterSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_adapter_skeleton_handle_method_call (
  GDBusConnection *connection,
  const gchar *sender,
  const gchar *object_path,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  AdapterSkeleton *skeleton = ADAPTER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  guint num_params;
  guint num_extra;
  guint n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], TYPE_ADAPTER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TYPE_ADAPTER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_adapter_skeleton_handle_get_property (
  GDBusConnection *connection,
  const gchar *sender,
  const gchar *object_path,
  const gchar *interface_name,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  AdapterSkeleton *skeleton = ADAPTER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_adapter_interface_info, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_adapter_skeleton_handle_set_property (
  GDBusConnection *connection,
  const gchar *sender,
  const gchar *object_path,
  const gchar *interface_name,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  AdapterSkeleton *skeleton = ADAPTER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_adapter_interface_info, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _adapter_skeleton_vtable =
{
  _adapter_skeleton_handle_method_call,
  _adapter_skeleton_handle_get_property,
  _adapter_skeleton_handle_set_property
};

static GDBusInterfaceInfo *
adapter_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton)
{
  return adapter_interface_info ();
}

static GDBusInterfaceVTable *
adapter_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton)
{
  return (GDBusInterfaceVTable *) &_adapter_skeleton_vtable;
}

static GVariant *
adapter_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  AdapterSkeleton *skeleton = ADAPTER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_adapter_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _adapter_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _adapter_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _adapter_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.bluez.Adapter", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
adapter_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
}

static void
_adapter_on_signal_property_changed (
    Adapter *object,
    const gchar *arg_unnamed_arg0,
    GVariant *arg_unnamed_arg1)
{
  AdapterSkeleton *skeleton = ADAPTER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(s@v)",
                   arg_unnamed_arg0,
                   arg_unnamed_arg1));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.bluez.Adapter", "PropertyChanged",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_adapter_on_signal_device_created (
    Adapter *object,
    const gchar *arg_unnamed_arg0)
{
  AdapterSkeleton *skeleton = ADAPTER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(o)",
                   arg_unnamed_arg0));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.bluez.Adapter", "DeviceCreated",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_adapter_on_signal_device_removed (
    Adapter *object,
    const gchar *arg_unnamed_arg0)
{
  AdapterSkeleton *skeleton = ADAPTER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(o)",
                   arg_unnamed_arg0));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.bluez.Adapter", "DeviceRemoved",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_adapter_on_signal_device_found (
    Adapter *object,
    const gchar *arg_unnamed_arg0,
    GVariant *arg_unnamed_arg1)
{
  AdapterSkeleton *skeleton = ADAPTER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(s@a{sv})",
                   arg_unnamed_arg0,
                   arg_unnamed_arg1));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.bluez.Adapter", "DeviceFound",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void adapter_skeleton_iface_init (AdapterIface *iface);
G_DEFINE_TYPE_WITH_CODE (AdapterSkeleton, adapter_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (TYPE_ADAPTER, adapter_skeleton_iface_init));

static void
adapter_skeleton_finalize (GObject *object)
{
  AdapterSkeleton *skeleton = ADAPTER_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (adapter_skeleton_parent_class)->finalize (object);
}

static void
adapter_skeleton_init (AdapterSkeleton *skeleton)
{
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, TYPE_ADAPTER_SKELETON, AdapterSkeletonPrivate);
  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
adapter_skeleton_class_init (AdapterSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  g_type_class_add_private (klass, sizeof (AdapterSkeletonPrivate));

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = adapter_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = adapter_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = adapter_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = adapter_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = adapter_skeleton_dbus_interface_get_vtable;
}

static void
adapter_skeleton_iface_init (AdapterIface *iface)
{
  iface->property_changed = _adapter_on_signal_property_changed;
  iface->device_created = _adapter_on_signal_device_created;
  iface->device_removed = _adapter_on_signal_device_removed;
  iface->device_found = _adapter_on_signal_device_found;
}

/**
 * adapter_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-bluez-Adapter.top_of_page">org.bluez.Adapter</link>.
 *
 * Returns: (transfer full) (type AdapterSkeleton): The skeleton object.
 */
Adapter *
adapter_skeleton_new (void)
{
  return ADAPTER (g_object_new (TYPE_ADAPTER_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.bluez.Device
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:Device
 * @title: Device
 * @short_description: Generated C code for the org.bluez.Device D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-bluez-Device.top_of_page">org.bluez.Device</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.bluez.Device ---- */

static const _ExtendedGDBusArgInfo _device_method_info_get_properties_OUT_ARG_unnamed_arg0 =
{
  {
    -1,
    (gchar *) "unnamed_arg0",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo * const _device_method_info_get_properties_OUT_ARG_pointers[] =
{
  &_device_method_info_get_properties_OUT_ARG_unnamed_arg0,
  NULL
};

static const _ExtendedGDBusMethodInfo _device_method_info_get_properties =
{
  {
    -1,
    (gchar *) "GetProperties",
    NULL,
    (GDBusArgInfo **) &_device_method_info_get_properties_OUT_ARG_pointers,
    NULL
  },
  "handle-get-properties",
  FALSE
};

static const _ExtendedGDBusArgInfo _device_method_info_set_property_IN_ARG_unnamed_arg0 =
{
  {
    -1,
    (gchar *) "unnamed_arg0",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _device_method_info_set_property_IN_ARG_unnamed_arg1 =
{
  {
    -1,
    (gchar *) "unnamed_arg1",
    (gchar *) "v",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo * const _device_method_info_set_property_IN_ARG_pointers[] =
{
  &_device_method_info_set_property_IN_ARG_unnamed_arg0,
  &_device_method_info_set_property_IN_ARG_unnamed_arg1,
  NULL
};

static const _ExtendedGDBusMethodInfo _device_method_info_set_property =
{
  {
    -1,
    (gchar *) "SetProperty",
    (GDBusArgInfo **) &_device_method_info_set_property_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-property",
  FALSE
};

static const _ExtendedGDBusMethodInfo _device_method_info_disconnect =
{
  {
    -1,
    (gchar *) "Disconnect",
    NULL,
    NULL,
    NULL
  },
  "handle-disconnect",
  FALSE
};

static const _ExtendedGDBusMethodInfo * const _device_method_info_pointers[] =
{
  &_device_method_info_get_properties,
  &_device_method_info_set_property,
  &_device_method_info_disconnect,
  NULL
};

static const _ExtendedGDBusArgInfo _device_signal_info_property_changed_ARG_unnamed_arg0 =
{
  {
    -1,
    (gchar *) "unnamed_arg0",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _device_signal_info_property_changed_ARG_unnamed_arg1 =
{
  {
    -1,
    (gchar *) "unnamed_arg1",
    (gchar *) "v",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo * const _device_signal_info_property_changed_ARG_pointers[] =
{
  &_device_signal_info_property_changed_ARG_unnamed_arg0,
  &_device_signal_info_property_changed_ARG_unnamed_arg1,
  NULL
};

static const _ExtendedGDBusSignalInfo _device_signal_info_property_changed =
{
  {
    -1,
    (gchar *) "PropertyChanged",
    (GDBusArgInfo **) &_device_signal_info_property_changed_ARG_pointers,
    NULL
  },
  "property-changed"
};

static const _ExtendedGDBusSignalInfo * const _device_signal_info_pointers[] =
{
  &_device_signal_info_property_changed,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _device_interface_info =
{
  {
    -1,
    (gchar *) "org.bluez.Device",
    (GDBusMethodInfo **) &_device_method_info_pointers,
    (GDBusSignalInfo **) &_device_signal_info_pointers,
    NULL,
    NULL
  },
  "device",
};


/**
 * device_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-bluez-Device.top_of_page">org.bluez.Device</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
device_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_device_interface_info;
}

/**
 * device_override_properties:
 * @klass: The class structure for a #GObject<!-- -->-derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #Device interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
device_override_properties (GObjectClass *klass, guint property_id_begin)
{
  return property_id_begin - 1;
}



/**
 * Device:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-bluez-Device.top_of_page">org.bluez.Device</link>.
 */

/**
 * DeviceIface:
 * @parent_iface: The parent interface.
 * @handle_disconnect: Handler for the #Device::handle-disconnect signal.
 * @handle_get_properties: Handler for the #Device::handle-get-properties signal.
 * @handle_set_property: Handler for the #Device::handle-set-property signal.
 * @property_changed: Handler for the #Device::property-changed signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-bluez-Device.top_of_page">org.bluez.Device</link>.
 */

static void
device_default_init (DeviceIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * Device::handle-get-properties:
   * @object: A #Device.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-bluez-Device.GetProperties">GetProperties()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call device_complete_get_properties() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-properties",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (DeviceIface, handle_get_properties),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * Device::handle-set-property:
   * @object: A #Device.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_unnamed_arg0: Argument passed by remote caller.
   * @arg_unnamed_arg1: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-bluez-Device.SetProperty">SetProperty()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call device_complete_set_property() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-property",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (DeviceIface, handle_set_property),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * Device::handle-disconnect:
   * @object: A #Device.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-bluez-Device.Disconnect">Disconnect()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call device_complete_disconnect() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-disconnect",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (DeviceIface, handle_disconnect),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject signals for received D-Bus signals: */
  /**
   * Device::property-changed:
   * @object: A #Device.
   * @arg_unnamed_arg0: Argument.
   * @arg_unnamed_arg1: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-bluez-Device.PropertyChanged">"PropertyChanged"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("property-changed",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (DeviceIface, property_changed),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    2, G_TYPE_STRING, G_TYPE_VARIANT);

}

typedef DeviceIface DeviceInterface;
G_DEFINE_INTERFACE (Device, device, G_TYPE_OBJECT);

/**
 * device_emit_property_changed:
 * @object: A #Device.
 * @arg_unnamed_arg0: Argument to pass with the signal.
 * @arg_unnamed_arg1: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-bluez-Device.PropertyChanged">"PropertyChanged"</link> D-Bus signal.
 */
void
device_emit_property_changed (
    Device *object,
    const gchar *arg_unnamed_arg0,
    GVariant *arg_unnamed_arg1)
{
  g_signal_emit_by_name (object, "property-changed", arg_unnamed_arg0, arg_unnamed_arg1);
}

/**
 * device_call_get_properties:
 * @proxy: A #DeviceProxy.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-bluez-Device.GetProperties">GetProperties()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call device_call_get_properties_finish() to get the result of the operation.
 *
 * See device_call_get_properties_sync() for the synchronous, blocking version of this method.
 */
void
device_call_get_properties (
    Device *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetProperties",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * device_call_get_properties_finish:
 * @proxy: A #DeviceProxy.
 * @out_unnamed_arg0: (out): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to device_call_get_properties().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with device_call_get_properties().
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
device_call_get_properties_finish (
    Device *proxy,
    GVariant **out_unnamed_arg0,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sv})",
                 out_unnamed_arg0);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * device_call_get_properties_sync:
 * @proxy: A #DeviceProxy.
 * @out_unnamed_arg0: (out): Return location for return parameter or %NULL to ignore.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-bluez-Device.GetProperties">GetProperties()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See device_call_get_properties() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
device_call_get_properties_sync (
    Device *proxy,
    GVariant **out_unnamed_arg0,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetProperties",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sv})",
                 out_unnamed_arg0);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * device_call_set_property:
 * @proxy: A #DeviceProxy.
 * @arg_unnamed_arg0: Argument to pass with the method invocation.
 * @arg_unnamed_arg1: Argument to pass with the method invocation.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-bluez-Device.SetProperty">SetProperty()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call device_call_set_property_finish() to get the result of the operation.
 *
 * See device_call_set_property_sync() for the synchronous, blocking version of this method.
 */
void
device_call_set_property (
    Device *proxy,
    const gchar *arg_unnamed_arg0,
    GVariant *arg_unnamed_arg1,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetProperty",
    g_variant_new ("(s@v)",
                   arg_unnamed_arg0,
                   arg_unnamed_arg1),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * device_call_set_property_finish:
 * @proxy: A #DeviceProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to device_call_set_property().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with device_call_set_property().
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
device_call_set_property_finish (
    Device *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * device_call_set_property_sync:
 * @proxy: A #DeviceProxy.
 * @arg_unnamed_arg0: Argument to pass with the method invocation.
 * @arg_unnamed_arg1: Argument to pass with the method invocation.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-bluez-Device.SetProperty">SetProperty()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See device_call_set_property() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
device_call_set_property_sync (
    Device *proxy,
    const gchar *arg_unnamed_arg0,
    GVariant *arg_unnamed_arg1,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetProperty",
    g_variant_new ("(s@v)",
                   arg_unnamed_arg0,
                   arg_unnamed_arg1),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * device_call_disconnect:
 * @proxy: A #DeviceProxy.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-bluez-Device.Disconnect">Disconnect()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call device_call_disconnect_finish() to get the result of the operation.
 *
 * See device_call_disconnect_sync() for the synchronous, blocking version of this method.
 */
void
device_call_disconnect (
    Device *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Disconnect",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * device_call_disconnect_finish:
 * @proxy: A #DeviceProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to device_call_disconnect().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with device_call_disconnect().
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
device_call_disconnect_finish (
    Device *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * device_call_disconnect_sync:
 * @proxy: A #DeviceProxy.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-bluez-Device.Disconnect">Disconnect()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See device_call_disconnect() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
device_call_disconnect_sync (
    Device *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Disconnect",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * device_complete_get_properties:
 * @object: A #Device.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @unnamed_arg0: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-bluez-Device.GetProperties">GetProperties()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
device_complete_get_properties (
    Device *object,
    GDBusMethodInvocation *invocation,
    GVariant *unnamed_arg0)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a{sv})",
                   unnamed_arg0));
}

/**
 * device_complete_set_property:
 * @object: A #Device.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-bluez-Device.SetProperty">SetProperty()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
device_complete_set_property (
    Device *object,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * device_complete_disconnect:
 * @object: A #Device.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-bluez-Device.Disconnect">Disconnect()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
device_complete_disconnect (
    Device *object,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * DeviceProxy:
 *
 * The #DeviceProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * DeviceProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #DeviceProxy.
 */

struct _DeviceProxyPrivate
{
  GData *qdata;
};

static void device_proxy_iface_init (DeviceIface *iface);

G_DEFINE_TYPE_WITH_CODE (DeviceProxy, device_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (TYPE_DEVICE, device_proxy_iface_init));

static void
device_proxy_finalize (GObject *object)
{
  DeviceProxy *proxy = DEVICE_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (device_proxy_parent_class)->finalize (object);
}

static void
device_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec)
{
}

static void
device_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
}

static void
device_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  guint num_params;
  guint n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_device_interface_info, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], TYPE_DEVICE);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TYPE_DEVICE);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
device_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  DeviceProxy *proxy = DEVICE_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_device_interface_info, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_device_interface_info, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
device_proxy_init (DeviceProxy *proxy)
{
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, TYPE_DEVICE_PROXY, DeviceProxyPrivate);
  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), device_interface_info ());
}

static void
device_proxy_class_init (DeviceProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  g_type_class_add_private (klass, sizeof (DeviceProxyPrivate));

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = device_proxy_finalize;
  gobject_class->get_property = device_proxy_get_property;
  gobject_class->set_property = device_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = device_proxy_g_signal;
  proxy_class->g_properties_changed = device_proxy_g_properties_changed;

}

static void
device_proxy_iface_init (DeviceIface *iface)
{
}

/**
 * device_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (allow-none): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-bluez-Device.top_of_page">org.bluez.Device</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call device_proxy_new_finish() to get the result of the operation.
 *
 * See device_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
device_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TYPE_DEVICE_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.bluez.Device", NULL);
}

/**
 * device_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to device_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with device_proxy_new().
 *
 * Returns: (transfer full) (type DeviceProxy): The constructed proxy object or %NULL if @error is set.
 */
Device *
device_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return DEVICE (ret);
  else
    return NULL;
}

/**
 * device_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (allow-none): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-bluez-Device.top_of_page">org.bluez.Device</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See device_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type DeviceProxy): The constructed proxy object or %NULL if @error is set.
 */
Device *
device_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TYPE_DEVICE_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.bluez.Device", NULL);
  if (ret != NULL)
    return DEVICE (ret);
  else
    return NULL;
}


/**
 * device_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like device_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call device_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See device_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
device_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TYPE_DEVICE_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.bluez.Device", NULL);
}

/**
 * device_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to device_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with device_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type DeviceProxy): The constructed proxy object or %NULL if @error is set.
 */
Device *
device_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return DEVICE (ret);
  else
    return NULL;
}

/**
 * device_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like device_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See device_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type DeviceProxy): The constructed proxy object or %NULL if @error is set.
 */
Device *
device_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TYPE_DEVICE_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.bluez.Device", NULL);
  if (ret != NULL)
    return DEVICE (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * DeviceSkeleton:
 *
 * The #DeviceSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * DeviceSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #DeviceSkeleton.
 */

struct _DeviceSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_device_skeleton_handle_method_call (
  GDBusConnection *connection,
  const gchar *sender,
  const gchar *object_path,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  DeviceSkeleton *skeleton = DEVICE_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  guint num_params;
  guint num_extra;
  guint n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], TYPE_DEVICE);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TYPE_DEVICE);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_device_skeleton_handle_get_property (
  GDBusConnection *connection,
  const gchar *sender,
  const gchar *object_path,
  const gchar *interface_name,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  DeviceSkeleton *skeleton = DEVICE_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_device_interface_info, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_device_skeleton_handle_set_property (
  GDBusConnection *connection,
  const gchar *sender,
  const gchar *object_path,
  const gchar *interface_name,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  DeviceSkeleton *skeleton = DEVICE_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_device_interface_info, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _device_skeleton_vtable =
{
  _device_skeleton_handle_method_call,
  _device_skeleton_handle_get_property,
  _device_skeleton_handle_set_property
};

static GDBusInterfaceInfo *
device_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton)
{
  return device_interface_info ();
}

static GDBusInterfaceVTable *
device_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton)
{
  return (GDBusInterfaceVTable *) &_device_skeleton_vtable;
}

static GVariant *
device_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  DeviceSkeleton *skeleton = DEVICE_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_device_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _device_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _device_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _device_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.bluez.Device", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
device_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
}

static void
_device_on_signal_property_changed (
    Device *object,
    const gchar *arg_unnamed_arg0,
    GVariant *arg_unnamed_arg1)
{
  DeviceSkeleton *skeleton = DEVICE_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(s@v)",
                   arg_unnamed_arg0,
                   arg_unnamed_arg1));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.bluez.Device", "PropertyChanged",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void device_skeleton_iface_init (DeviceIface *iface);
G_DEFINE_TYPE_WITH_CODE (DeviceSkeleton, device_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (TYPE_DEVICE, device_skeleton_iface_init));

static void
device_skeleton_finalize (GObject *object)
{
  DeviceSkeleton *skeleton = DEVICE_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (device_skeleton_parent_class)->finalize (object);
}

static void
device_skeleton_init (DeviceSkeleton *skeleton)
{
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, TYPE_DEVICE_SKELETON, DeviceSkeletonPrivate);
  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
device_skeleton_class_init (DeviceSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  g_type_class_add_private (klass, sizeof (DeviceSkeletonPrivate));

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = device_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = device_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = device_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = device_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = device_skeleton_dbus_interface_get_vtable;
}

static void
device_skeleton_iface_init (DeviceIface *iface)
{
  iface->property_changed = _device_on_signal_property_changed;
}

/**
 * device_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-bluez-Device.top_of_page">org.bluez.Device</link>.
 *
 * Returns: (transfer full) (type DeviceSkeleton): The skeleton object.
 */
Device *
device_skeleton_new (void)
{
  return DEVICE (g_object_new (TYPE_DEVICE_SKELETON, NULL));
}

