/* ofono-persona.c generated by valac 0.18.0.110-5650, the Vala compiler
 * generated from ofono-persona.vala, do not modify */

/*
 * Copyright (C) 2012 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *          Jeremy Whiting <jeremy.whiting@collabora.co.uk>
 *
 * Based on kf-persona.vala by:
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <folks/folks.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <libebook-contacts/libebook-contacts.h>


#define FOLKS_BACKENDS_OFONO_TYPE_PERSONA (folks_backends_ofono_persona_get_type ())
#define FOLKS_BACKENDS_OFONO_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_BACKENDS_OFONO_TYPE_PERSONA, FolksBackendsOfonoPersona))
#define FOLKS_BACKENDS_OFONO_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_BACKENDS_OFONO_TYPE_PERSONA, FolksBackendsOfonoPersonaClass))
#define FOLKS_BACKENDS_OFONO_IS_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_BACKENDS_OFONO_TYPE_PERSONA))
#define FOLKS_BACKENDS_OFONO_IS_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_BACKENDS_OFONO_TYPE_PERSONA))
#define FOLKS_BACKENDS_OFONO_PERSONA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_BACKENDS_OFONO_TYPE_PERSONA, FolksBackendsOfonoPersonaClass))

typedef struct _FolksBackendsOfonoPersona FolksBackendsOfonoPersona;
typedef struct _FolksBackendsOfonoPersonaClass FolksBackendsOfonoPersonaClass;
typedef struct _FolksBackendsOfonoPersonaPrivate FolksBackendsOfonoPersonaPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define __vala_EVCardAttribute_free0(var) ((var == NULL) ? NULL : (var = (_vala_EVCardAttribute_free (var), NULL)))

struct _FolksBackendsOfonoPersona {
	FolksPersona parent_instance;
	FolksBackendsOfonoPersonaPrivate * priv;
};

struct _FolksBackendsOfonoPersonaClass {
	FolksPersonaClass parent_class;
};

struct _FolksBackendsOfonoPersonaPrivate {
	FolksStructuredName* _structured_name;
	gchar* _full_name;
	gchar* _nickname;
	GeeHashSet* _phone_numbers;
	GeeSet* _phone_numbers_ro;
	GeeHashSet* _email_addresses;
	GeeSet* _email_addresses_ro;
};


static gpointer folks_backends_ofono_persona_parent_class = NULL;
static gchar** folks_backends_ofono_persona__writeable_properties;
static gint folks_backends_ofono_persona__writeable_properties_length1;
static gchar** folks_backends_ofono_persona__writeable_properties = NULL;
static gint folks_backends_ofono_persona__writeable_properties_length1 = 0;
static gint _folks_backends_ofono_persona__writeable_properties_size_ = 0;
static FolksEmailDetailsIface* folks_backends_ofono_persona_folks_email_details_parent_iface = NULL;
static FolksNameDetailsIface* folks_backends_ofono_persona_folks_name_details_parent_iface = NULL;
static FolksPhoneDetailsIface* folks_backends_ofono_persona_folks_phone_details_parent_iface = NULL;

GType folks_backends_ofono_persona_get_type (void) G_GNUC_CONST;
#define FOLKS_BACKENDS_OFONO_PERSONA_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_BACKENDS_OFONO_TYPE_PERSONA, FolksBackendsOfonoPersonaPrivate))
enum  {
	FOLKS_BACKENDS_OFONO_PERSONA_DUMMY_PROPERTY,
	FOLKS_BACKENDS_OFONO_PERSONA_LINKABLE_PROPERTIES,
	FOLKS_BACKENDS_OFONO_PERSONA_WRITEABLE_PROPERTIES,
	FOLKS_BACKENDS_OFONO_PERSONA_PHONE_NUMBERS,
	FOLKS_BACKENDS_OFONO_PERSONA_STRUCTURED_NAME,
	FOLKS_BACKENDS_OFONO_PERSONA_FULL_NAME,
	FOLKS_BACKENDS_OFONO_PERSONA_NICKNAME,
	FOLKS_BACKENDS_OFONO_PERSONA_EMAIL_ADDRESSES
};
FolksBackendsOfonoPersona* folks_backends_ofono_persona_new (const gchar* vcard, FolksPersonaStore* store);
FolksBackendsOfonoPersona* folks_backends_ofono_persona_construct (GType object_type, const gchar* vcard, FolksPersonaStore* store);
static void _folks_backends_ofono_persona_set_vcard (FolksBackendsOfonoPersona* self, const gchar* vcard);
static EVCardAttribute* _vala_EVCardAttribute_copy (EVCardAttribute* self);
static void _vala_EVCardAttribute_free (EVCardAttribute* self);
static void folks_backends_ofono_persona_real_linkable_property_to_links (FolksPersona* base, const gchar* prop_name, FolksPersonaLinkablePropertyCallback callback, void* callback_target);
static GObject * folks_backends_ofono_persona_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void folks_backends_ofono_persona_finalize (GObject* obj);
static void _vala_folks_backends_ofono_persona_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_folks_backends_ofono_persona_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);

static const gchar* FOLKS_BACKENDS_OFONO_PERSONA__linkable_properties[2] = {"phone-numbers", "email-addresses"};

/**
   * Create a new persona.
   *
   * Create a new persona for the given vCard contents.
   *
   * @param vcard the vCard data to use for this {@link Persona}.
   * @param store the {@link PersonaStore} this {@link Persona} belongs to.
   *
   * @since 0.9.0
   */
FolksBackendsOfonoPersona* folks_backends_ofono_persona_construct (GType object_type, const gchar* vcard, FolksPersonaStore* store) {
	FolksBackendsOfonoPersona * self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* iid;
	FolksPersonaStore* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* uid;
	FolksPersonaStore* _tmp6_;
	const gchar* _tmp7_;
	g_return_val_if_fail (vcard != NULL, NULL);
	g_return_val_if_fail (store != NULL, NULL);
	_tmp0_ = vcard;
	_tmp1_ = g_compute_checksum_for_string (G_CHECKSUM_SHA1, _tmp0_, (gsize) (-1));
	iid = _tmp1_;
	_tmp2_ = store;
	_tmp3_ = folks_persona_store_get_id (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = folks_persona_build_uid ("ofono", _tmp4_, iid);
	uid = _tmp5_;
	_tmp6_ = store;
	self = (FolksBackendsOfonoPersona*) g_object_new (object_type, "display-id", uid, "iid", iid, "uid", uid, "store", _tmp6_, "is-user", FALSE, NULL);
	_tmp7_ = vcard;
	_folks_backends_ofono_persona_set_vcard (self, _tmp7_);
	_g_free0 (uid);
	_g_free0 (iid);
	return self;
}


FolksBackendsOfonoPersona* folks_backends_ofono_persona_new (const gchar* vcard, FolksPersonaStore* store) {
	return folks_backends_ofono_persona_construct (FOLKS_BACKENDS_OFONO_TYPE_PERSONA, vcard, store);
}


static EVCardAttribute* _vala_EVCardAttribute_copy (EVCardAttribute* self) {
	return g_boxed_copy (e_vcard_attribute_get_type (), self);
}


static gpointer __vala_EVCardAttribute_copy0 (gpointer self) {
	return self ? _vala_EVCardAttribute_copy (self) : NULL;
}


static void _vala_EVCardAttribute_free (EVCardAttribute* self) {
	g_boxed_free (e_vcard_attribute_get_type (), self);
}


static void _folks_backends_ofono_persona_set_vcard (FolksBackendsOfonoPersona* self, const gchar* vcard) {
	const gchar* _tmp0_;
	EVCard* _tmp1_;
	EVCard* card;
	EVCard* _tmp2_;
	EVCardAttribute* _tmp3_ = NULL;
	EVCardAttribute* _tmp4_;
	EVCardAttribute* attribute;
	EVCardAttribute* _tmp5_;
	EVCard* _tmp13_;
	EVCardAttribute* _tmp14_ = NULL;
	EVCardAttribute* _tmp15_;
	EVCardAttribute* _tmp16_;
	EVCard* _tmp22_;
	EVCardAttribute* _tmp23_ = NULL;
	EVCardAttribute* _tmp24_;
	EVCardAttribute* _tmp25_;
	EVCard* _tmp31_;
	EVCardAttribute* _tmp32_ = NULL;
	EVCardAttribute* _tmp33_;
	EVCardAttribute* _tmp34_;
	EVCard* _tmp57_;
	EVCardAttribute* _tmp58_ = NULL;
	EVCardAttribute* _tmp59_;
	EVCardAttribute* _tmp60_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (vcard != NULL);
	_tmp0_ = vcard;
	_tmp1_ = e_vcard_new_from_string (_tmp0_);
	card = _tmp1_;
	_tmp2_ = card;
	_tmp3_ = e_vcard_get_attribute (_tmp2_, "TEL");
	_tmp4_ = __vala_EVCardAttribute_copy0 (_tmp3_);
	attribute = _tmp4_;
	_tmp5_ = attribute;
	if (_tmp5_ != NULL) {
		GeeHashSet* _tmp6_;
		EVCardAttribute* _tmp7_;
		GString* _tmp8_ = NULL;
		GString* _tmp9_;
		const gchar* _tmp10_;
		FolksPhoneFieldDetails* _tmp11_;
		FolksPhoneFieldDetails* _tmp12_;
		_tmp6_ = self->priv->_phone_numbers;
		_tmp7_ = attribute;
		_tmp8_ = e_vcard_attribute_get_value_decoded (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = _tmp9_->str;
		_tmp11_ = folks_phone_field_details_new (_tmp10_, NULL);
		_tmp12_ = _tmp11_;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp6_, _tmp12_);
		_g_object_unref0 (_tmp12_);
		_g_string_free0 (_tmp9_);
	}
	_tmp13_ = card;
	_tmp14_ = e_vcard_get_attribute (_tmp13_, "FN");
	_tmp15_ = __vala_EVCardAttribute_copy0 (_tmp14_);
	__vala_EVCardAttribute_free0 (attribute);
	attribute = _tmp15_;
	_tmp16_ = attribute;
	if (_tmp16_ != NULL) {
		EVCardAttribute* _tmp17_;
		GString* _tmp18_ = NULL;
		GString* _tmp19_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		_tmp17_ = attribute;
		_tmp18_ = e_vcard_attribute_get_value_decoded (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = _tmp19_->str;
		_tmp21_ = g_strdup (_tmp20_);
		_g_free0 (self->priv->_full_name);
		self->priv->_full_name = _tmp21_;
		_g_string_free0 (_tmp19_);
	}
	_tmp22_ = card;
	_tmp23_ = e_vcard_get_attribute (_tmp22_, "NICKNAME");
	_tmp24_ = __vala_EVCardAttribute_copy0 (_tmp23_);
	__vala_EVCardAttribute_free0 (attribute);
	attribute = _tmp24_;
	_tmp25_ = attribute;
	if (_tmp25_ != NULL) {
		EVCardAttribute* _tmp26_;
		GString* _tmp27_ = NULL;
		GString* _tmp28_;
		const gchar* _tmp29_;
		gchar* _tmp30_;
		_tmp26_ = attribute;
		_tmp27_ = e_vcard_attribute_get_value_decoded (_tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = _tmp28_->str;
		_tmp30_ = g_strdup (_tmp29_);
		_g_free0 (self->priv->_nickname);
		self->priv->_nickname = _tmp30_;
		_g_string_free0 (_tmp28_);
	}
	_tmp31_ = card;
	_tmp32_ = e_vcard_get_attribute (_tmp31_, "N");
	_tmp33_ = __vala_EVCardAttribute_copy0 (_tmp32_);
	__vala_EVCardAttribute_free0 (attribute);
	attribute = _tmp33_;
	_tmp34_ = attribute;
	if (_tmp34_ != NULL) {
		EVCardAttribute* _tmp35_;
		GList* _tmp36_ = NULL;
		GList* values;
		GList* _tmp37_;
		guint _tmp38_ = 0U;
		_tmp35_ = attribute;
		_tmp36_ = e_vcard_attribute_get_values_decoded (_tmp35_);
		values = _tmp36_;
		_tmp37_ = values;
		_tmp38_ = g_list_length (_tmp37_);
		if (_tmp38_ >= ((guint) 5)) {
			GList* _tmp39_;
			gconstpointer _tmp40_ = NULL;
			const gchar* _tmp41_;
			GList* _tmp42_;
			gconstpointer _tmp43_ = NULL;
			const gchar* _tmp44_;
			GList* _tmp45_;
			gconstpointer _tmp46_ = NULL;
			const gchar* _tmp47_;
			GList* _tmp48_;
			gconstpointer _tmp49_ = NULL;
			const gchar* _tmp50_;
			GList* _tmp51_;
			gconstpointer _tmp52_ = NULL;
			const gchar* _tmp53_;
			FolksStructuredName* _tmp54_;
			_tmp39_ = values;
			_tmp40_ = g_list_nth_data (_tmp39_, (guint) 0);
			_tmp41_ = ((GString*) _tmp40_)->str;
			_tmp42_ = values;
			_tmp43_ = g_list_nth_data (_tmp42_, (guint) 1);
			_tmp44_ = ((GString*) _tmp43_)->str;
			_tmp45_ = values;
			_tmp46_ = g_list_nth_data (_tmp45_, (guint) 2);
			_tmp47_ = ((GString*) _tmp46_)->str;
			_tmp48_ = values;
			_tmp49_ = g_list_nth_data (_tmp48_, (guint) 3);
			_tmp50_ = ((GString*) _tmp49_)->str;
			_tmp51_ = values;
			_tmp52_ = g_list_nth_data (_tmp51_, (guint) 4);
			_tmp53_ = ((GString*) _tmp52_)->str;
			_tmp54_ = folks_structured_name_new (_tmp41_, _tmp44_, _tmp47_, _tmp50_, _tmp53_);
			_g_object_unref0 (self->priv->_structured_name);
			self->priv->_structured_name = _tmp54_;
		} else {
			GList* _tmp55_;
			guint _tmp56_ = 0U;
			_tmp55_ = values;
			_tmp56_ = g_list_length (_tmp55_);
			g_warning ("ofono-persona.vala:191: Expected 5 components to N value of vcard, got" \
" %u", _tmp56_);
		}
	}
	_tmp57_ = card;
	_tmp58_ = e_vcard_get_attribute (_tmp57_, "EMAIL");
	_tmp59_ = __vala_EVCardAttribute_copy0 (_tmp58_);
	__vala_EVCardAttribute_free0 (attribute);
	attribute = _tmp59_;
	_tmp60_ = attribute;
	if (_tmp60_ != NULL) {
		GeeHashSet* _tmp61_;
		EVCardAttribute* _tmp62_;
		GString* _tmp63_ = NULL;
		GString* _tmp64_;
		const gchar* _tmp65_;
		FolksEmailFieldDetails* _tmp66_;
		FolksEmailFieldDetails* _tmp67_;
		_tmp61_ = self->priv->_email_addresses;
		_tmp62_ = attribute;
		_tmp63_ = e_vcard_attribute_get_value_decoded (_tmp62_);
		_tmp64_ = _tmp63_;
		_tmp65_ = _tmp64_->str;
		_tmp66_ = folks_email_field_details_new (_tmp65_, NULL);
		_tmp67_ = _tmp66_;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp61_, _tmp67_);
		_g_object_unref0 (_tmp67_);
		_g_string_free0 (_tmp64_);
	}
	__vala_EVCardAttribute_free0 (attribute);
	_g_object_unref0 (card);
}


/**
   * {@inheritDoc}
   */
static void folks_backends_ofono_persona_real_linkable_property_to_links (FolksPersona* base, const gchar* prop_name, FolksPersonaLinkablePropertyCallback callback, void* callback_target) {
	FolksBackendsOfonoPersona * self;
	const gchar* _tmp0_;
	self = (FolksBackendsOfonoPersona*) base;
	g_return_if_fail (prop_name != NULL);
	_tmp0_ = prop_name;
	if (g_strcmp0 (_tmp0_, "phone-numbers") == 0) {
		{
			GeeHashSet* _tmp1_;
			GeeIterator* _tmp2_ = NULL;
			GeeIterator* _phone_number_it;
			_tmp1_ = self->priv->_phone_numbers;
			_tmp2_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp1_);
			_phone_number_it = _tmp2_;
			while (TRUE) {
				GeeIterator* _tmp3_;
				gboolean _tmp4_ = FALSE;
				GeeIterator* _tmp5_;
				gpointer _tmp6_ = NULL;
				FolksPhoneFieldDetails* phone_number;
				FolksPhoneFieldDetails* _tmp7_;
				gconstpointer _tmp8_;
				const gchar* _tmp9_;
				_tmp3_ = _phone_number_it;
				_tmp4_ = gee_iterator_next (_tmp3_);
				if (!_tmp4_) {
					break;
				}
				_tmp5_ = _phone_number_it;
				_tmp6_ = gee_iterator_get (_tmp5_);
				phone_number = (FolksPhoneFieldDetails*) _tmp6_;
				_tmp7_ = phone_number;
				_tmp8_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp7_);
				_tmp9_ = _tmp8_;
				if (((const gchar*) _tmp9_) != NULL) {
					FolksPersonaLinkablePropertyCallback _tmp10_;
					void* _tmp10__target;
					FolksPhoneFieldDetails* _tmp11_;
					gconstpointer _tmp12_;
					const gchar* _tmp13_;
					_tmp10_ = callback;
					_tmp10__target = callback_target;
					_tmp11_ = phone_number;
					_tmp12_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp11_);
					_tmp13_ = _tmp12_;
					_tmp10_ ((const gchar*) _tmp13_, _tmp10__target);
				}
				_g_object_unref0 (phone_number);
			}
			_g_object_unref0 (_phone_number_it);
		}
	} else {
		const gchar* _tmp14_;
		_tmp14_ = prop_name;
		if (g_strcmp0 (_tmp14_, "email-addresses") == 0) {
			{
				GeeHashSet* _tmp15_;
				GeeIterator* _tmp16_ = NULL;
				GeeIterator* _email_address_it;
				_tmp15_ = self->priv->_email_addresses;
				_tmp16_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp15_);
				_email_address_it = _tmp16_;
				while (TRUE) {
					GeeIterator* _tmp17_;
					gboolean _tmp18_ = FALSE;
					GeeIterator* _tmp19_;
					gpointer _tmp20_ = NULL;
					FolksEmailFieldDetails* email_address;
					FolksEmailFieldDetails* _tmp21_;
					gconstpointer _tmp22_;
					const gchar* _tmp23_;
					_tmp17_ = _email_address_it;
					_tmp18_ = gee_iterator_next (_tmp17_);
					if (!_tmp18_) {
						break;
					}
					_tmp19_ = _email_address_it;
					_tmp20_ = gee_iterator_get (_tmp19_);
					email_address = (FolksEmailFieldDetails*) _tmp20_;
					_tmp21_ = email_address;
					_tmp22_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp21_);
					_tmp23_ = _tmp22_;
					if (((const gchar*) _tmp23_) != NULL) {
						FolksPersonaLinkablePropertyCallback _tmp24_;
						void* _tmp24__target;
						FolksEmailFieldDetails* _tmp25_;
						gconstpointer _tmp26_;
						const gchar* _tmp27_;
						_tmp24_ = callback;
						_tmp24__target = callback_target;
						_tmp25_ = email_address;
						_tmp26_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp25_);
						_tmp27_ = _tmp26_;
						_tmp24_ ((const gchar*) _tmp27_, _tmp24__target);
					}
					_g_object_unref0 (email_address);
				}
				_g_object_unref0 (_email_address_it);
			}
		} else {
			const gchar* _tmp28_;
			FolksPersonaLinkablePropertyCallback _tmp29_;
			void* _tmp29__target;
			_tmp28_ = prop_name;
			_tmp29_ = callback;
			_tmp29__target = callback_target;
			FOLKS_PERSONA_CLASS (folks_backends_ofono_persona_parent_class)->linkable_property_to_links (G_TYPE_CHECK_INSTANCE_CAST (self, FOLKS_TYPE_PERSONA, FolksPersona), _tmp28_, _tmp29_, _tmp29__target);
		}
	}
}


static gchar** folks_backends_ofono_persona_real_get_linkable_properties (FolksPersona* base, int* result_length1) {
	gchar** result;
	FolksBackendsOfonoPersona* self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	self = (FolksBackendsOfonoPersona*) base;
	_tmp0_ = FOLKS_BACKENDS_OFONO_PERSONA__linkable_properties;
	_tmp0__length1 = G_N_ELEMENTS (FOLKS_BACKENDS_OFONO_PERSONA__linkable_properties);
	if (result_length1) {
		*result_length1 = _tmp0__length1;
	}
	result = _tmp0_;
	return result;
}


static gchar** folks_backends_ofono_persona_real_get_writeable_properties (FolksPersona* base, int* result_length1) {
	gchar** result;
	FolksBackendsOfonoPersona* self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	self = (FolksBackendsOfonoPersona*) base;
	_tmp0_ = folks_backends_ofono_persona__writeable_properties;
	_tmp0__length1 = folks_backends_ofono_persona__writeable_properties_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}


static GeeSet* folks_backends_ofono_persona_real_get_phone_numbers (FolksPhoneDetails* base) {
	GeeSet* result;
	FolksBackendsOfonoPersona* self;
	GeeSet* _tmp0_;
	self = (FolksBackendsOfonoPersona*) base;
	_tmp0_ = self->priv->_phone_numbers_ro;
	result = _tmp0_;
	return result;
}


static void folks_backends_ofono_persona_real_set_phone_numbers (FolksPhoneDetails* base, GeeSet* value) {
	FolksBackendsOfonoPersona* self;
	GeeSet* _tmp0_;
	self = (FolksBackendsOfonoPersona*) base;
	_tmp0_ = value;
	folks_phone_details_change_phone_numbers ((FolksPhoneDetails*) self, _tmp0_, NULL, NULL);
}


static FolksStructuredName* folks_backends_ofono_persona_real_get_structured_name (FolksNameDetails* base) {
	FolksStructuredName* result;
	FolksBackendsOfonoPersona* self;
	FolksStructuredName* _tmp0_;
	self = (FolksBackendsOfonoPersona*) base;
	_tmp0_ = self->priv->_structured_name;
	result = _tmp0_;
	return result;
}


static void folks_backends_ofono_persona_real_set_structured_name (FolksNameDetails* base, FolksStructuredName* value) {
	FolksBackendsOfonoPersona* self;
	FolksStructuredName* _tmp0_;
	self = (FolksBackendsOfonoPersona*) base;
	_tmp0_ = value;
	folks_name_details_change_structured_name ((FolksNameDetails*) self, _tmp0_, NULL, NULL);
}


static const gchar* folks_backends_ofono_persona_real_get_full_name (FolksNameDetails* base) {
	const gchar* result;
	FolksBackendsOfonoPersona* self;
	const gchar* _tmp0_;
	self = (FolksBackendsOfonoPersona*) base;
	_tmp0_ = self->priv->_full_name;
	result = _tmp0_;
	return result;
}


static void folks_backends_ofono_persona_real_set_full_name (FolksNameDetails* base, const gchar* value) {
	FolksBackendsOfonoPersona* self;
	const gchar* _tmp0_;
	self = (FolksBackendsOfonoPersona*) base;
	_tmp0_ = value;
	folks_name_details_change_full_name ((FolksNameDetails*) self, _tmp0_, NULL, NULL);
}


static const gchar* folks_backends_ofono_persona_real_get_nickname (FolksNameDetails* base) {
	const gchar* result;
	FolksBackendsOfonoPersona* self;
	const gchar* _tmp0_;
	self = (FolksBackendsOfonoPersona*) base;
	_tmp0_ = self->priv->_nickname;
	result = _tmp0_;
	return result;
}


static void folks_backends_ofono_persona_real_set_nickname (FolksNameDetails* base, const gchar* value) {
	FolksBackendsOfonoPersona* self;
	const gchar* _tmp0_;
	self = (FolksBackendsOfonoPersona*) base;
	_tmp0_ = value;
	folks_name_details_change_nickname ((FolksNameDetails*) self, _tmp0_, NULL, NULL);
}


static GeeSet* folks_backends_ofono_persona_real_get_email_addresses (FolksEmailDetails* base) {
	GeeSet* result;
	FolksBackendsOfonoPersona* self;
	GeeSet* _tmp0_;
	self = (FolksBackendsOfonoPersona*) base;
	_tmp0_ = self->priv->_email_addresses_ro;
	result = _tmp0_;
	return result;
}


static void folks_backends_ofono_persona_real_set_email_addresses (FolksEmailDetails* base, GeeSet* value) {
	FolksBackendsOfonoPersona* self;
	GeeSet* _tmp0_;
	self = (FolksBackendsOfonoPersona*) base;
	_tmp0_ = value;
	folks_email_details_change_email_addresses ((FolksEmailDetails*) self, _tmp0_, NULL, NULL);
}


static GObject * folks_backends_ofono_persona_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	FolksBackendsOfonoPersona * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GeeHashSet* _tmp6_;
	GeeHashSet* _tmp7_;
	GeeSet* _tmp8_;
	GeeSet* _tmp9_;
	GeeHashSet* _tmp10_;
	GeeHashSet* _tmp11_;
	GeeSet* _tmp12_;
	GeeSet* _tmp13_;
	parent_class = G_OBJECT_CLASS (folks_backends_ofono_persona_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_BACKENDS_OFONO_TYPE_PERSONA, FolksBackendsOfonoPersona);
	_tmp0_ = folks_persona_get_uid ((FolksPersona*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = folks_persona_get_iid ((FolksPersona*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = folks_persona_get_display_id ((FolksPersona*) self);
	_tmp5_ = _tmp4_;
	g_debug ("ofono-persona.vala:145: Adding Ofono Persona '%s' (IID '%s', group '%s" \
"')", _tmp1_, _tmp3_, _tmp5_);
	_tmp6_ = gee_hash_set_new (FOLKS_TYPE_PHONE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_phone_numbers);
	self->priv->_phone_numbers = _tmp6_;
	_tmp7_ = self->priv->_phone_numbers;
	_tmp8_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp7_);
	_tmp9_ = _tmp8_;
	_g_object_unref0 (self->priv->_phone_numbers_ro);
	self->priv->_phone_numbers_ro = _tmp9_;
	_tmp10_ = gee_hash_set_new (FOLKS_TYPE_EMAIL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_email_addresses);
	self->priv->_email_addresses = _tmp10_;
	_tmp11_ = self->priv->_email_addresses;
	_tmp12_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp11_);
	_tmp13_ = _tmp12_;
	_g_object_unref0 (self->priv->_email_addresses_ro);
	self->priv->_email_addresses_ro = _tmp13_;
	return obj;
}


static void folks_backends_ofono_persona_class_init (FolksBackendsOfonoPersonaClass * klass) {
	gchar** _tmp0_ = NULL;
	folks_backends_ofono_persona_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksBackendsOfonoPersonaPrivate));
	FOLKS_PERSONA_CLASS (klass)->linkable_property_to_links = folks_backends_ofono_persona_real_linkable_property_to_links;
	FOLKS_PERSONA_CLASS (klass)->get_linkable_properties = folks_backends_ofono_persona_real_get_linkable_properties;
	FOLKS_PERSONA_CLASS (klass)->get_writeable_properties = folks_backends_ofono_persona_real_get_writeable_properties;
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_backends_ofono_persona_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_folks_backends_ofono_persona_set_property;
	G_OBJECT_CLASS (klass)->constructor = folks_backends_ofono_persona_constructor;
	G_OBJECT_CLASS (klass)->finalize = folks_backends_ofono_persona_finalize;
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_OFONO_PERSONA_LINKABLE_PROPERTIES, g_param_spec_boxed ("linkable-properties", "linkable-properties", "linkable-properties", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_OFONO_PERSONA_WRITEABLE_PROPERTIES, g_param_spec_boxed ("writeable-properties", "writeable-properties", "writeable-properties", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_OFONO_PERSONA_PHONE_NUMBERS, g_param_spec_object ("phone-numbers", "phone-numbers", "phone-numbers", GEE_TYPE_SET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_OFONO_PERSONA_STRUCTURED_NAME, g_param_spec_object ("structured-name", "structured-name", "structured-name", FOLKS_TYPE_STRUCTURED_NAME, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_OFONO_PERSONA_FULL_NAME, g_param_spec_string ("full-name", "full-name", "full-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_OFONO_PERSONA_NICKNAME, g_param_spec_string ("nickname", "nickname", "nickname", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_OFONO_PERSONA_EMAIL_ADDRESSES, g_param_spec_object ("email-addresses", "email-addresses", "email-addresses", GEE_TYPE_SET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	folks_backends_ofono_persona__writeable_properties = _tmp0_;
	folks_backends_ofono_persona__writeable_properties_length1 = 0;
}


static void folks_backends_ofono_persona_folks_email_details_interface_init (FolksEmailDetailsIface * iface) {
	folks_backends_ofono_persona_folks_email_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_email_addresses = folks_backends_ofono_persona_real_get_email_addresses;
	iface->set_email_addresses = folks_backends_ofono_persona_real_set_email_addresses;
}


static void folks_backends_ofono_persona_folks_name_details_interface_init (FolksNameDetailsIface * iface) {
	folks_backends_ofono_persona_folks_name_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_structured_name = folks_backends_ofono_persona_real_get_structured_name;
	iface->set_structured_name = folks_backends_ofono_persona_real_set_structured_name;
	iface->get_full_name = folks_backends_ofono_persona_real_get_full_name;
	iface->set_full_name = folks_backends_ofono_persona_real_set_full_name;
	iface->get_nickname = folks_backends_ofono_persona_real_get_nickname;
	iface->set_nickname = folks_backends_ofono_persona_real_set_nickname;
}


static void folks_backends_ofono_persona_folks_phone_details_interface_init (FolksPhoneDetailsIface * iface) {
	folks_backends_ofono_persona_folks_phone_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_phone_numbers = folks_backends_ofono_persona_real_get_phone_numbers;
	iface->set_phone_numbers = folks_backends_ofono_persona_real_set_phone_numbers;
}


static void folks_backends_ofono_persona_instance_init (FolksBackendsOfonoPersona * self) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	self->priv = FOLKS_BACKENDS_OFONO_PERSONA_GET_PRIVATE (self);
	self->priv->_structured_name = NULL;
	_tmp0_ = g_strdup ("");
	self->priv->_full_name = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->priv->_nickname = _tmp1_;
}


static void folks_backends_ofono_persona_finalize (GObject* obj) {
	FolksBackendsOfonoPersona * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_BACKENDS_OFONO_TYPE_PERSONA, FolksBackendsOfonoPersona);
	_g_object_unref0 (self->priv->_structured_name);
	_g_free0 (self->priv->_full_name);
	_g_free0 (self->priv->_nickname);
	_g_object_unref0 (self->priv->_phone_numbers);
	_g_object_unref0 (self->priv->_phone_numbers_ro);
	_g_object_unref0 (self->priv->_email_addresses);
	_g_object_unref0 (self->priv->_email_addresses_ro);
	G_OBJECT_CLASS (folks_backends_ofono_persona_parent_class)->finalize (obj);
}


/**
 * A persona subclass which represents a single persona from a simple key file.
 *
 * @since 0.9.0
 */
GType folks_backends_ofono_persona_get_type (void) {
	static volatile gsize folks_backends_ofono_persona_type_id__volatile = 0;
	if (g_once_init_enter (&folks_backends_ofono_persona_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksBackendsOfonoPersonaClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_backends_ofono_persona_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksBackendsOfonoPersona), 0, (GInstanceInitFunc) folks_backends_ofono_persona_instance_init, NULL };
		static const GInterfaceInfo folks_email_details_info = { (GInterfaceInitFunc) folks_backends_ofono_persona_folks_email_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_name_details_info = { (GInterfaceInitFunc) folks_backends_ofono_persona_folks_name_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_phone_details_info = { (GInterfaceInitFunc) folks_backends_ofono_persona_folks_phone_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType folks_backends_ofono_persona_type_id;
		folks_backends_ofono_persona_type_id = g_type_register_static (FOLKS_TYPE_PERSONA, "FolksBackendsOfonoPersona", &g_define_type_info, 0);
		g_type_add_interface_static (folks_backends_ofono_persona_type_id, FOLKS_TYPE_EMAIL_DETAILS, &folks_email_details_info);
		g_type_add_interface_static (folks_backends_ofono_persona_type_id, FOLKS_TYPE_NAME_DETAILS, &folks_name_details_info);
		g_type_add_interface_static (folks_backends_ofono_persona_type_id, FOLKS_TYPE_PHONE_DETAILS, &folks_phone_details_info);
		g_once_init_leave (&folks_backends_ofono_persona_type_id__volatile, folks_backends_ofono_persona_type_id);
	}
	return folks_backends_ofono_persona_type_id__volatile;
}


static void _vala_folks_backends_ofono_persona_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FolksBackendsOfonoPersona * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_BACKENDS_OFONO_TYPE_PERSONA, FolksBackendsOfonoPersona);
	switch (property_id) {
		case FOLKS_BACKENDS_OFONO_PERSONA_LINKABLE_PROPERTIES:
		{
			int length;
			g_value_set_boxed (value, folks_persona_get_linkable_properties ((FolksPersona*) self, &length));
		}
		break;
		case FOLKS_BACKENDS_OFONO_PERSONA_WRITEABLE_PROPERTIES:
		{
			int length;
			g_value_set_boxed (value, folks_persona_get_writeable_properties ((FolksPersona*) self, &length));
		}
		break;
		case FOLKS_BACKENDS_OFONO_PERSONA_PHONE_NUMBERS:
		g_value_set_object (value, folks_phone_details_get_phone_numbers ((FolksPhoneDetails*) self));
		break;
		case FOLKS_BACKENDS_OFONO_PERSONA_STRUCTURED_NAME:
		g_value_set_object (value, folks_name_details_get_structured_name ((FolksNameDetails*) self));
		break;
		case FOLKS_BACKENDS_OFONO_PERSONA_FULL_NAME:
		g_value_set_string (value, folks_name_details_get_full_name ((FolksNameDetails*) self));
		break;
		case FOLKS_BACKENDS_OFONO_PERSONA_NICKNAME:
		g_value_set_string (value, folks_name_details_get_nickname ((FolksNameDetails*) self));
		break;
		case FOLKS_BACKENDS_OFONO_PERSONA_EMAIL_ADDRESSES:
		g_value_set_object (value, folks_email_details_get_email_addresses ((FolksEmailDetails*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_folks_backends_ofono_persona_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	FolksBackendsOfonoPersona * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_BACKENDS_OFONO_TYPE_PERSONA, FolksBackendsOfonoPersona);
	switch (property_id) {
		case FOLKS_BACKENDS_OFONO_PERSONA_PHONE_NUMBERS:
		folks_phone_details_set_phone_numbers ((FolksPhoneDetails*) self, g_value_get_object (value));
		break;
		case FOLKS_BACKENDS_OFONO_PERSONA_STRUCTURED_NAME:
		folks_name_details_set_structured_name ((FolksNameDetails*) self, g_value_get_object (value));
		break;
		case FOLKS_BACKENDS_OFONO_PERSONA_FULL_NAME:
		folks_name_details_set_full_name ((FolksNameDetails*) self, g_value_get_string (value));
		break;
		case FOLKS_BACKENDS_OFONO_PERSONA_NICKNAME:
		folks_name_details_set_nickname ((FolksNameDetails*) self, g_value_get_string (value));
		break;
		case FOLKS_BACKENDS_OFONO_PERSONA_EMAIL_ADDRESSES:
		folks_email_details_set_email_addresses ((FolksEmailDetails*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



