/* traversable.c generated by valac 0.20.1.66-2886, the Vala compiler
 * generated from traversable.vala, do not modify */

/* traversable.vala
 *
 * Copyright (C) 2011-2012  Maciej Piechotka
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Maciej Piechotka <uzytkownik2@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>


#define GEE_TYPE_LAZY (gee_lazy_get_type ())
#define GEE_LAZY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_LAZY, GeeLazy))
#define GEE_LAZY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_LAZY, GeeLazyClass))
#define GEE_IS_LAZY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_LAZY))
#define GEE_IS_LAZY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_LAZY))
#define GEE_LAZY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_LAZY, GeeLazyClass))

typedef struct _GeeLazy GeeLazy;
typedef struct _GeeLazyClass GeeLazyClass;

#define GEE_TRAVERSABLE_TYPE_STREAM (gee_traversable_stream_get_type ())

#define GEE_TYPE_TRAVERSABLE (gee_traversable_get_type ())
#define GEE_TRAVERSABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_TRAVERSABLE, GeeTraversable))
#define GEE_IS_TRAVERSABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_TRAVERSABLE))
#define GEE_TRAVERSABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_TRAVERSABLE, GeeTraversableIface))

typedef struct _GeeTraversable GeeTraversable;
typedef struct _GeeTraversableIface GeeTraversableIface;

#define GEE_TYPE_ITERATOR (gee_iterator_get_type ())
#define GEE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERATOR, GeeIterator))
#define GEE_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERATOR))
#define GEE_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERATOR, GeeIteratorIface))

typedef struct _GeeIterator GeeIterator;
typedef struct _GeeIteratorIface GeeIteratorIface;

#define GEE_TYPE_ITERABLE (gee_iterable_get_type ())
#define GEE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERABLE, GeeIterable))
#define GEE_IS_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERABLE))
#define GEE_ITERABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERABLE, GeeIterableIface))

typedef struct _GeeIterable GeeIterable;
typedef struct _GeeIterableIface GeeIterableIface;

#define GEE_TYPE_STREAM_ITERATOR (gee_stream_iterator_get_type ())
#define GEE_STREAM_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_STREAM_ITERATOR, GeeStreamIterator))
#define GEE_STREAM_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_STREAM_ITERATOR, GeeStreamIteratorClass))
#define GEE_IS_STREAM_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_STREAM_ITERATOR))
#define GEE_IS_STREAM_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_STREAM_ITERATOR))
#define GEE_STREAM_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_STREAM_ITERATOR, GeeStreamIteratorClass))

typedef struct _GeeStreamIterator GeeStreamIterator;
typedef struct _GeeStreamIteratorClass GeeStreamIteratorClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _a_destroy_func0(var) (((var == NULL) || (a_destroy_func == NULL)) ? NULL : (var = (a_destroy_func (var), NULL)))
typedef struct _Block13Data Block13Data;
typedef struct _Block14Data Block14Data;
#define _gee_lazy_unref0(var) ((var == NULL) ? NULL : (var = (gee_lazy_unref (var), NULL)))
typedef struct _Block15Data Block15Data;
typedef struct _Block16Data Block16Data;
typedef struct _Block17Data Block17Data;
typedef struct _Block18Data Block18Data;
typedef struct _Block19Data Block19Data;
typedef struct _Block20Data Block20Data;
typedef struct _Block21Data Block21Data;
typedef struct _Block22Data Block22Data;

#define GEE_TEE_ITERATOR_TYPE_NODE (gee_tee_iterator_node_get_type ())
#define GEE_TEE_ITERATOR_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TEE_ITERATOR_TYPE_NODE, GeeTeeIteratorNode))
#define GEE_TEE_ITERATOR_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TEE_ITERATOR_TYPE_NODE, GeeTeeIteratorNodeClass))
#define GEE_TEE_ITERATOR_IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TEE_ITERATOR_TYPE_NODE))
#define GEE_TEE_ITERATOR_IS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TEE_ITERATOR_TYPE_NODE))
#define GEE_TEE_ITERATOR_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TEE_ITERATOR_TYPE_NODE, GeeTeeIteratorNodeClass))

typedef struct _GeeTeeIteratorNode GeeTeeIteratorNode;
typedef struct _GeeTeeIteratorNodeClass GeeTeeIteratorNodeClass;

#define GEE_TYPE_TEE_ITERATOR (gee_tee_iterator_get_type ())
#define GEE_TEE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_TEE_ITERATOR, GeeTeeIterator))
#define GEE_TEE_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_TEE_ITERATOR, GeeTeeIteratorClass))
#define GEE_IS_TEE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_TEE_ITERATOR))
#define GEE_IS_TEE_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_TEE_ITERATOR))
#define GEE_TEE_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_TEE_ITERATOR, GeeTeeIteratorClass))

typedef struct _GeeTeeIterator GeeTeeIterator;
typedef struct _GeeTeeIteratorClass GeeTeeIteratorClass;
#define _gee_tee_iterator_node_unref0(var) ((var == NULL) ? NULL : (var = (gee_tee_iterator_node_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef gpointer (*GeeFoldFunc) (gpointer g, gpointer a, void* user_data);
typedef gboolean (*GeeForallFunc) (gpointer g, void* user_data);
typedef GeeLazy* (*GeeUnfoldFunc) (void* user_data);
typedef enum  {
	GEE_TRAVERSABLE_STREAM_YIELD,
	GEE_TRAVERSABLE_STREAM_CONTINUE,
	GEE_TRAVERSABLE_STREAM_END,
	GEE_TRAVERSABLE_STREAM_WAIT
} GeeTraversableStream;

typedef GeeTraversableStream (*GeeStreamFunc) (GeeTraversableStream state, GeeLazy* g, GeeLazy** lazy, void* user_data);
typedef gpointer (*GeeMapFunc) (gpointer g, void* user_data);
typedef gboolean (*GeePredicate) (gconstpointer g, void* user_data);
struct _GeeIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (GeeIterator* self);
	gboolean (*has_next) (GeeIterator* self);
	gpointer (*get) (GeeIterator* self);
	void (*remove) (GeeIterator* self);
	gboolean (*get_valid) (GeeIterator* self);
	gboolean (*get_read_only) (GeeIterator* self);
};

typedef GeeIterator* (*GeeFlatMapFunc) (gpointer g, void* user_data);
struct _GeeTraversableIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeTraversable* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeTraversable* self);
	GDestroyNotify (*get_g_destroy_func) (GeeTraversable* self);
	gboolean (*foreach) (GeeTraversable* self, GeeForallFunc f, void* f_target);
	GeeIterator* (*stream) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeStreamFunc f, void* f_target, GDestroyNotify f_target_destroy_notify);
	gpointer (*fold) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed);
	GeeIterator* (*map) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeMapFunc f, void* f_target);
	GeeIterator* (*scan) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed);
	GeeIterator* (*filter) (GeeTraversable* self, GeePredicate pred, void* pred_target, GDestroyNotify pred_target_destroy_notify);
	GeeIterator* (*chop) (GeeTraversable* self, gint offset, gint length);
	GType (*get_element_type) (GeeTraversable* self);
	GeeIterator* (*flat_map) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFlatMapFunc f, void* f_target, GDestroyNotify f_target_destroy_notify);
	GeeIterator** (*tee) (GeeTraversable* self, guint forks, int* result_length1);
};

struct _GeeIterableIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeIterable* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeIterable* self);
	GDestroyNotify (*get_g_destroy_func) (GeeIterable* self);
	GeeIterator* (*iterator) (GeeIterable* self);
};

struct _Block13Data {
	int _ref_count_;
	GeeTraversable * self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	GeeFoldFunc f;
	gpointer f_target;
	gpointer seed;
};

struct _Block14Data {
	int _ref_count_;
	GeeTraversable * self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	GeeMapFunc f;
	gpointer f_target;
};

struct _Block15Data {
	int _ref_count_;
	Block14Data * _data14_;
	GeeLazy* item;
};

typedef gpointer (*GeeLazyFunc) (void* user_data);
struct _Block16Data {
	int _ref_count_;
	GeeTraversable * self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	gboolean seed_emitted;
	GeeFoldFunc f;
	gpointer f_target;
	gpointer seed;
};

struct _Block17Data {
	int _ref_count_;
	Block16Data * _data16_;
	GeeLazy* item;
};

struct _Block18Data {
	int _ref_count_;
	GeeTraversable * self;
	GeePredicate pred;
	gpointer pred_target;
	GDestroyNotify pred_target_destroy_notify;
};

struct _Block19Data {
	int _ref_count_;
	GeeTraversable * self;
	gint offset;
	gint length;
};

struct _Block20Data {
	int _ref_count_;
	GeeTraversable * self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	GeeIterator* current;
	GeeFlatMapFunc f;
	gpointer f_target;
	GDestroyNotify f_target_destroy_notify;
};

struct _Block21Data {
	int _ref_count_;
	Block20Data * _data20_;
};

struct _Block22Data {
	int _ref_count_;
	GeeTraversable * self;
	GeeIterator* _self_;
};



gpointer gee_lazy_ref (gpointer instance);
void gee_lazy_unref (gpointer instance);
GParamSpec* gee_param_spec_lazy (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gee_value_set_lazy (GValue* value, gpointer v_object);
void gee_value_take_lazy (GValue* value, gpointer v_object);
gpointer gee_value_get_lazy (const GValue* value);
GType gee_lazy_get_type (void) G_GNUC_CONST;
GType gee_traversable_stream_get_type (void) G_GNUC_CONST;
GType gee_iterator_get_type (void) G_GNUC_CONST;
GType gee_traversable_get_type (void) G_GNUC_CONST;
gboolean gee_traversable_foreach (GeeTraversable* self, GeeForallFunc f, void* f_target);
GeeIterator* gee_traversable_stream (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeStreamFunc f, void* f_target, GDestroyNotify f_target_destroy_notify);
static GeeIterator* gee_traversable_real_stream (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeStreamFunc f, void* f_target, GDestroyNotify f_target_destroy_notify);
GType gee_iterable_get_type (void) G_GNUC_CONST;
GeeStreamIterator* gee_stream_iterator_new (GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeIterator* outer, GeeStreamFunc func, void* func_target, GDestroyNotify func_target_destroy_notify);
GeeStreamIterator* gee_stream_iterator_construct (GType object_type, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeIterator* outer, GeeStreamFunc func, void* func_target, GDestroyNotify func_target_destroy_notify);
GType gee_stream_iterator_get_type (void) G_GNUC_CONST;
GeeIterator* gee_iterable_iterator (GeeIterable* self);
gpointer gee_traversable_fold (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed);
static gpointer gee_traversable_real_fold (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed);
static Block13Data* block13_data_ref (Block13Data* _data13_);
static void block13_data_unref (void * _userdata_);
static gboolean __lambda9_ (Block13Data* _data13_, gpointer item);
static gboolean ___lambda9__gee_forall_func (gpointer g, gpointer self);
GeeIterator* gee_traversable_map (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeMapFunc f, void* f_target);
static GeeIterator* gee_traversable_real_map (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeMapFunc f, void* f_target);
static Block14Data* block14_data_ref (Block14Data* _data14_);
static void block14_data_unref (void * _userdata_);
static GeeTraversableStream __lambda10_ (Block14Data* _data14_, GeeTraversableStream state, GeeLazy* item, GeeLazy** val);
static Block15Data* block15_data_ref (Block15Data* _data15_);
static void block15_data_unref (void * _userdata_);
static gpointer ___lambda11_ (Block15Data* _data15_);
gpointer gee_lazy_get (GeeLazy* self);
static gpointer ____lambda11__gee_lazy_func (gpointer self);
GeeLazy* gee_lazy_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeLazyFunc func, void* func_target, GDestroyNotify func_target_destroy_notify);
GeeLazy* gee_lazy_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeLazyFunc func, void* func_target, GDestroyNotify func_target_destroy_notify);
static GeeTraversableStream ___lambda10__gee_stream_func (GeeTraversableStream state, GeeLazy* g, GeeLazy** lazy, gpointer self);
GeeIterator* gee_traversable_scan (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed);
static GeeIterator* gee_traversable_real_scan (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed);
static Block16Data* block16_data_ref (Block16Data* _data16_);
static void block16_data_unref (void * _userdata_);
static GeeTraversableStream __lambda12_ (Block16Data* _data16_, GeeTraversableStream state, GeeLazy* item, GeeLazy** val);
static Block17Data* block17_data_ref (Block17Data* _data17_);
static void block17_data_unref (void * _userdata_);
GeeLazy* gee_lazy_new_from_value (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer item);
GeeLazy* gee_lazy_construct_from_value (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer item);
static gpointer ___lambda13_ (Block17Data* _data17_);
static gpointer ____lambda13__gee_lazy_func (gpointer self);
static GeeTraversableStream ___lambda12__gee_stream_func (GeeTraversableStream state, GeeLazy* g, GeeLazy** lazy, gpointer self);
GeeIterator* gee_traversable_filter (GeeTraversable* self, GeePredicate pred, void* pred_target, GDestroyNotify pred_target_destroy_notify);
static GeeIterator* gee_traversable_real_filter (GeeTraversable* self, GeePredicate pred, void* pred_target, GDestroyNotify pred_target_destroy_notify);
static Block18Data* block18_data_ref (Block18Data* _data18_);
static void block18_data_unref (void * _userdata_);
static GeeTraversableStream __lambda14_ (Block18Data* _data18_, GeeTraversableStream state, GeeLazy* item, GeeLazy** val);
static GeeTraversableStream ___lambda14__gee_stream_func (GeeTraversableStream state, GeeLazy* g, GeeLazy** lazy, gpointer self);
GeeIterator* gee_traversable_chop (GeeTraversable* self, gint offset, gint length);
static GeeIterator* gee_traversable_real_chop (GeeTraversable* self, gint offset, gint length);
static Block19Data* block19_data_ref (Block19Data* _data19_);
static void block19_data_unref (void * _userdata_);
static GeeTraversableStream __lambda15_ (Block19Data* _data19_, GeeTraversableStream state, GeeLazy* item, GeeLazy** val);
static GeeTraversableStream ___lambda15__gee_stream_func (GeeTraversableStream state, GeeLazy* g, GeeLazy** lazy, gpointer self);
GeeIterator* gee_traversable_flat_map (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFlatMapFunc f, void* f_target, GDestroyNotify f_target_destroy_notify);
static GeeIterator* gee_traversable_real_flat_map (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFlatMapFunc f, void* f_target, GDestroyNotify f_target_destroy_notify);
static Block20Data* block20_data_ref (Block20Data* _data20_);
static void block20_data_unref (void * _userdata_);
static GeeTraversableStream __lambda16_ (Block20Data* _data20_, GeeTraversableStream state, GeeLazy* item, GeeLazy** val);
static Block21Data* block21_data_ref (Block21Data* _data21_);
static void block21_data_unref (void * _userdata_);
gboolean gee_iterator_next (GeeIterator* self);
static gpointer ____lambda17_ (Block21Data* _data21_);
gpointer gee_iterator_get (GeeIterator* self);
static gpointer _____lambda17__gee_lazy_func (gpointer self);
gboolean gee_iterator_get_valid (GeeIterator* self);
static gpointer ____lambda18_ (Block21Data* _data21_);
static gpointer _____lambda18__gee_lazy_func (gpointer self);
static gpointer ____lambda19_ (Block21Data* _data21_);
static gpointer _____lambda19__gee_lazy_func (gpointer self);
static GeeTraversableStream ___lambda16__gee_stream_func (GeeTraversableStream state, GeeLazy* g, GeeLazy** lazy, gpointer self);
GeeIterator** gee_traversable_tee (GeeTraversable* self, guint forks, int* result_length1);
static GeeIterator** gee_traversable_real_tee (GeeTraversable* self, guint forks, int* result_length1);
static Block22Data* block22_data_ref (Block22Data* _data22_);
static void block22_data_unref (void * _userdata_);
static gpointer ______lambda20_ (Block22Data* _data22_);
static gpointer _______lambda20__gee_lazy_func (gpointer self);
gpointer gee_tee_iterator_node_ref (gpointer instance);
void gee_tee_iterator_node_unref (gpointer instance);
GParamSpec* gee_tee_iterator_param_spec_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gee_tee_iterator_value_set_node (GValue* value, gpointer v_object);
void gee_tee_iterator_value_take_node (GValue* value, gpointer v_object);
gpointer gee_tee_iterator_value_get_node (const GValue* value);
GType gee_tee_iterator_node_get_type (void) G_GNUC_CONST;
GeeLazy* gee_tee_iterator_create_nodes (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeIterator* iterator, GeeLazy* dependent);
GeeTeeIteratorNode* gee_tee_iterator_node_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeLazy* data, GeeLazy* next);
GeeTeeIteratorNode* gee_tee_iterator_node_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeLazy* data, GeeLazy* next);
GeeTeeIterator* gee_tee_iterator_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTeeIteratorNode* head, gboolean valid);
GeeTeeIterator* gee_tee_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTeeIteratorNode* head, gboolean valid);
GType gee_tee_iterator_get_type (void) G_GNUC_CONST;
GType gee_traversable_get_element_type (GeeTraversable* self);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GType gee_traversable_stream_get_type (void) {
	static volatile gsize gee_traversable_stream_type_id__volatile = 0;
	if (g_once_init_enter (&gee_traversable_stream_type_id__volatile)) {
		static const GEnumValue values[] = {{GEE_TRAVERSABLE_STREAM_YIELD, "GEE_TRAVERSABLE_STREAM_YIELD", "yield"}, {GEE_TRAVERSABLE_STREAM_CONTINUE, "GEE_TRAVERSABLE_STREAM_CONTINUE", "continue"}, {GEE_TRAVERSABLE_STREAM_END, "GEE_TRAVERSABLE_STREAM_END", "end"}, {GEE_TRAVERSABLE_STREAM_WAIT, "GEE_TRAVERSABLE_STREAM_WAIT", "wait"}, {0, NULL, NULL}};
		GType gee_traversable_stream_type_id;
		gee_traversable_stream_type_id = g_enum_register_static ("GeeTraversableStream", values);
		g_once_init_leave (&gee_traversable_stream_type_id__volatile, gee_traversable_stream_type_id);
	}
	return gee_traversable_stream_type_id__volatile;
}


/**
 * Apply function to each element returned by iterator untill last element
 * or function return ''false''.
 *
 * ''{@link Iterator} implementation:'' Operation moves the iterator
 * to last element in iteration or the first element that returned ''false''.
 * If iterator points at some element it will be included in iteration.
 *
 * @param f function applied to every element of the collection
 *
 * @return ''false'' if the argument returned ''false'' at last invocation and
 *         ''true'' otherwise.
 */
gboolean gee_traversable_foreach (GeeTraversable* self, GeeForallFunc f, void* f_target) {
#line 68 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 68 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return GEE_TRAVERSABLE_GET_INTERFACE (self)->foreach (self, f, f_target);
#line 379 "traversable.c"
}


/**
 * Stream function is an abstract function allowing writing many
 * operations.
 *
 * The stream function accepts three parameter:
 *
 *   1. state. It is usually the last returned value from function but
 *      it may be {@link Stream.END} when {@link Stream.CONTINUE} was
 *      returned and there was no more elements.
 *   1. input. It is valid only if first argument is
 *      {@link Stream.CONTINUE}
 *   1. output. It is valid only if result is Stream.YIELD
 *
 * It may return one of 3 results:
 *
 *   1. {@link Stream.YIELD}. It means that value was yielded and can
 *      be passed to outgoing iterator.
 *   1. {@link Stream.CONTINUE}. It means that the function needs to be
 *      called with next element or with {@link Stream.END} if it is
 *      end of stream). If the state element was Stream.END during the
 *      current iteration function ''must not'' return {@link Stream.CONTINUE}.
 *   1. {@link Stream.WAIT}. Simply denotes that iterator should skip an element.
 *      Usually the function is called once again with {@link Stream.WAIT} as
 *      state however it do affect the initial validity of iterator.
 *   1. {@link Stream.END}. It means that the last argument was yielded.
 *
 * If the function yields the value immediately then the returning iterator
 * is {@link Iterator.valid} and points to this value as well as in case when the
 * parent iterator is {@link Iterator.valid} and function yields
 * after consuming 1 input. In other case returned iterator is invalid including
 * when the first value returned is {@link Stream.WAIT}.
 *
 * Note: In {@link Iterator} implementation: if iterator is
 *    {@link Iterator.valid} the current value should be fed
 *    immediately to function if during initial call function returns
 *    {@link Stream.CONTINUE}. The parent iterator cannot be used before
 *    the functions return {@link Stream.END} afterwards it points on the
 *    last element consumed.
 *
 * @param f function generating stream
 * @return iterator containing values yielded by stream
 */
static GeeIterator* gee_traversable_real_stream (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeStreamFunc f, void* f_target, GDestroyNotify f_target_destroy_notify) {
	GeeIterator* result = NULL;
	GeeIterator* _self_ = NULL;
	GeeIterable* iself = NULL;
	GeeIterator* _tmp0_ = NULL;
#line 117 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_self_ = G_TYPE_CHECK_INSTANCE_TYPE (self, GEE_TYPE_ITERATOR) ? ((GeeIterator*) self) : NULL;
#line 117 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp0_ = _self_;
#line 117 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	if (_tmp0_ != NULL) {
#line 436 "traversable.c"
		GeeIterator* _tmp1_ = NULL;
		GeeStreamFunc _tmp2_ = NULL;
		void* _tmp2__target = NULL;
		GDestroyNotify _tmp2__target_destroy_notify = NULL;
		GeeStreamIterator* _tmp3_ = NULL;
#line 118 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_tmp1_ = _self_;
#line 118 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_tmp2_ = f;
#line 118 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_tmp2__target = f_target;
#line 118 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_tmp2__target_destroy_notify = f_target_destroy_notify;
#line 118 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		f_target_destroy_notify = NULL;
#line 118 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_tmp3_ = gee_stream_iterator_new (a_type, (GBoxedCopyFunc) a_dup_func, a_destroy_func, GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_type (self), (GBoxedCopyFunc) GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_dup_func (self), GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self), _tmp1_, _tmp2_, _tmp2__target, _tmp2__target_destroy_notify);
#line 118 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		result = (GeeIterator*) _tmp3_;
#line 118 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		(f_target_destroy_notify == NULL) ? NULL : (f_target_destroy_notify (f_target), NULL);
#line 118 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		f = NULL;
#line 118 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		f_target = NULL;
#line 118 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		f_target_destroy_notify = NULL;
#line 118 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		return result;
#line 466 "traversable.c"
	} else {
		GeeIterable* _tmp4_ = NULL;
#line 119 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		iself = G_TYPE_CHECK_INSTANCE_TYPE (self, GEE_TYPE_ITERABLE) ? ((GeeIterable*) self) : NULL;
#line 119 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_tmp4_ = iself;
#line 119 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		if (_tmp4_ != NULL) {
#line 475 "traversable.c"
			GeeIterable* _tmp5_ = NULL;
			GeeIterator* _tmp6_ = NULL;
			GeeIterator* _tmp7_ = NULL;
			GeeStreamFunc _tmp8_ = NULL;
			void* _tmp8__target = NULL;
			GDestroyNotify _tmp8__target_destroy_notify = NULL;
			GeeIterator* _tmp9_ = NULL;
			GeeIterator* _tmp10_ = NULL;
#line 120 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_tmp5_ = iself;
#line 120 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_tmp6_ = gee_iterable_iterator (_tmp5_);
#line 120 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_tmp7_ = _tmp6_;
#line 120 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_tmp8_ = f;
#line 120 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_tmp8__target = f_target;
#line 120 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_tmp8__target_destroy_notify = f_target_destroy_notify;
#line 120 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			f_target_destroy_notify = NULL;
#line 120 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_tmp9_ = gee_traversable_stream ((GeeTraversable*) _tmp7_, a_type, (GBoxedCopyFunc) a_dup_func, a_destroy_func, _tmp8_, _tmp8__target, _tmp8__target_destroy_notify);
#line 120 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_tmp10_ = _tmp9_;
#line 120 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_g_object_unref0 (_tmp7_);
#line 120 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			result = _tmp10_;
#line 120 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			(f_target_destroy_notify == NULL) ? NULL : (f_target_destroy_notify (f_target), NULL);
#line 120 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			f = NULL;
#line 120 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			f_target = NULL;
#line 120 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			f_target_destroy_notify = NULL;
#line 120 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			return result;
#line 516 "traversable.c"
		} else {
#line 122 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			g_assert_not_reached ();
#line 520 "traversable.c"
		}
	}
#line 113 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	(f_target_destroy_notify == NULL) ? NULL : (f_target_destroy_notify (f_target), NULL);
#line 113 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	f = NULL;
#line 113 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	f_target = NULL;
#line 113 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	f_target_destroy_notify = NULL;
#line 531 "traversable.c"
}


GeeIterator* gee_traversable_stream (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeStreamFunc f, void* f_target, GDestroyNotify f_target_destroy_notify) {
#line 113 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 113 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return GEE_TRAVERSABLE_GET_INTERFACE (self)->stream (self, a_type, a_dup_func, a_destroy_func, f, f_target, f_target_destroy_notify);
#line 540 "traversable.c"
}


/**
 * Standard aggregation function.
 *
 * It takes a function, seed and first element, returns the new seed and
 * progress to next element when the operation repeats.
 *
 * Note: Default implementation uses {@link foreach}.
 *
 * Note: In {@link Iterator} implementation operation moves the
 *    iterator to last element in iteration. If iterator is
 *    {@link Iterator.valid} the current element will be considered
 *    as well.
 *
 */
static Block13Data* block13_data_ref (Block13Data* _data13_) {
#line 141 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	g_atomic_int_inc (&_data13_->_ref_count_);
#line 141 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return _data13_;
#line 563 "traversable.c"
}


static void block13_data_unref (void * _userdata_) {
	Block13Data* _data13_;
	_data13_ = (Block13Data*) _userdata_;
#line 141 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	if (g_atomic_int_dec_and_test (&_data13_->_ref_count_)) {
#line 572 "traversable.c"
		GeeTraversable * self;
		GType a_type;
		GBoxedCopyFunc a_dup_func;
		GDestroyNotify a_destroy_func;
#line 141 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		self = _data13_->self;
#line 141 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		a_type = _data13_->a_type;
#line 141 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		a_dup_func = _data13_->a_dup_func;
#line 141 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		a_destroy_func = _data13_->a_destroy_func;
#line 141 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_a_destroy_func0 (_data13_->seed);
#line 141 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_g_object_unref0 (self);
#line 141 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		g_slice_free (Block13Data, _data13_);
#line 591 "traversable.c"
	}
}


static gboolean __lambda9_ (Block13Data* _data13_, gpointer item) {
	GeeTraversable * self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	gboolean result = FALSE;
	GeeFoldFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	gpointer _tmp1_ = NULL;
	gpointer _tmp2_ = NULL;
	gpointer _tmp3_ = NULL;
#line 143 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	self = _data13_->self;
#line 143 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	a_type = _data13_->a_type;
#line 143 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	a_dup_func = _data13_->a_dup_func;
#line 143 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	a_destroy_func = _data13_->a_destroy_func;
#line 143 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp0_ = _data13_->f;
#line 143 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp0__target = _data13_->f_target;
#line 143 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp1_ = item;
#line 143 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	item = NULL;
#line 143 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp2_ = _data13_->seed;
#line 143 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data13_->seed = NULL;
#line 143 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp3_ = _tmp0_ (_tmp1_, _tmp2_, _tmp0__target);
#line 143 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_a_destroy_func0 (_data13_->seed);
#line 143 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data13_->seed = _tmp3_;
#line 143 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	result = TRUE;
#line 143 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	((item == NULL) || (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self) == NULL)) ? NULL : (item = (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self) (item), NULL));
#line 143 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return result;
#line 639 "traversable.c"
}


static gboolean ___lambda9__gee_forall_func (gpointer g, gpointer self) {
	gboolean result;
	result = __lambda9_ (self, g);
#line 143 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return result;
#line 648 "traversable.c"
}


static gpointer gee_traversable_real_fold (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed) {
	gpointer result = NULL;
	Block13Data* _data13_;
	GeeFoldFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	gconstpointer _tmp1_ = NULL;
	gpointer _tmp2_ = NULL;
#line 141 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data13_ = g_slice_new0 (Block13Data);
#line 141 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data13_->_ref_count_ = 1;
#line 141 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data13_->self = g_object_ref (self);
#line 141 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data13_->a_type = a_type;
#line 141 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data13_->a_dup_func = a_dup_func;
#line 141 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data13_->a_destroy_func = a_destroy_func;
#line 141 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp0_ = f;
#line 141 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp0__target = f_target;
#line 141 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data13_->f = _tmp0_;
#line 141 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data13_->f_target = _tmp0__target;
#line 141 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp1_ = seed;
#line 141 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_a_destroy_func0 (_data13_->seed);
#line 141 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data13_->seed = _tmp1_;
#line 143 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	gee_traversable_foreach (self, ___lambda9__gee_forall_func, _data13_);
#line 144 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp2_ = _data13_->seed;
#line 144 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data13_->seed = NULL;
#line 144 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	result = _tmp2_;
#line 144 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	block13_data_unref (_data13_);
#line 144 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data13_ = NULL;
#line 144 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return result;
#line 699 "traversable.c"
}


gpointer gee_traversable_fold (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed) {
#line 141 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 141 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return GEE_TRAVERSABLE_GET_INTERFACE (self)->fold (self, a_type, a_dup_func, a_destroy_func, f, f_target, seed);
#line 708 "traversable.c"
}


/**
 * Produces an iterator pointing at elements generated by function passed.
 *
 * Iterator is lazy evaluated but value is force-evaluated when
 * iterator moves to next element. ({@link Iterator.next})
 *
 * Note: Default implementation uses {@link stream}.
 *
 * Note: In {@link Iterator} implementation if the parent iterator is
 *    {@link Iterator.valid} so is the returned one. Using the parent
 *    iterator is not allowed before the inner iterator {@link Iterator.next}
 *    return false and then it points on its last element.
 *    The resulting iterator is {@link Iterator.valid} if the parent
 *    iterator is.
 *
 * @param f Mapping function
 * @return Iterator listing mapped value
 */
static Block14Data* block14_data_ref (Block14Data* _data14_) {
#line 166 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	g_atomic_int_inc (&_data14_->_ref_count_);
#line 166 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return _data14_;
#line 735 "traversable.c"
}


static void block14_data_unref (void * _userdata_) {
	Block14Data* _data14_;
	_data14_ = (Block14Data*) _userdata_;
#line 166 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	if (g_atomic_int_dec_and_test (&_data14_->_ref_count_)) {
#line 744 "traversable.c"
		GeeTraversable * self;
		GType a_type;
		GBoxedCopyFunc a_dup_func;
		GDestroyNotify a_destroy_func;
#line 166 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		self = _data14_->self;
#line 166 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		a_type = _data14_->a_type;
#line 166 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		a_dup_func = _data14_->a_dup_func;
#line 166 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		a_destroy_func = _data14_->a_destroy_func;
#line 166 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_g_object_unref0 (self);
#line 166 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		g_slice_free (Block14Data, _data14_);
#line 761 "traversable.c"
	}
}


static Block15Data* block15_data_ref (Block15Data* _data15_) {
#line 167 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	g_atomic_int_inc (&_data15_->_ref_count_);
#line 167 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return _data15_;
#line 771 "traversable.c"
}


static void block15_data_unref (void * _userdata_) {
	Block15Data* _data15_;
	_data15_ = (Block15Data*) _userdata_;
#line 167 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	if (g_atomic_int_dec_and_test (&_data15_->_ref_count_)) {
#line 780 "traversable.c"
		GeeTraversable * self;
		GType a_type;
		GBoxedCopyFunc a_dup_func;
		GDestroyNotify a_destroy_func;
#line 167 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		self = _data15_->_data14_->self;
#line 167 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		a_type = _data15_->_data14_->a_type;
#line 167 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		a_dup_func = _data15_->_data14_->a_dup_func;
#line 167 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		a_destroy_func = _data15_->_data14_->a_destroy_func;
#line 167 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_gee_lazy_unref0 (_data15_->item);
#line 167 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		block14_data_unref (_data15_->_data14_);
#line 167 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_data15_->_data14_ = NULL;
#line 167 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		g_slice_free (Block15Data, _data15_);
#line 801 "traversable.c"
	}
}


static gpointer ___lambda11_ (Block15Data* _data15_) {
	Block14Data* _data14_;
	GeeTraversable * self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	gpointer result = NULL;
	gpointer tmp = NULL;
	GeeLazy* _tmp0_ = NULL;
	gpointer _tmp1_ = NULL;
	GeeMapFunc _tmp2_ = NULL;
	void* _tmp2__target = NULL;
	gpointer _tmp3_ = NULL;
	gpointer _tmp4_ = NULL;
#line 173 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data14_ = _data15_->_data14_;
#line 173 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	self = _data14_->self;
#line 173 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	a_type = _data14_->a_type;
#line 173 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	a_dup_func = _data14_->a_dup_func;
#line 173 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	a_destroy_func = _data14_->a_destroy_func;
#line 174 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp0_ = _data15_->item;
#line 174 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp1_ = gee_lazy_get (_tmp0_);
#line 174 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	tmp = _tmp1_;
#line 175 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_gee_lazy_unref0 (_data15_->item);
#line 175 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data15_->item = NULL;
#line 176 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp2_ = _data14_->f;
#line 176 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp2__target = _data14_->f_target;
#line 176 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp3_ = tmp;
#line 176 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	tmp = NULL;
#line 176 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp4_ = _tmp2_ (_tmp3_, _tmp2__target);
#line 176 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	result = _tmp4_;
#line 176 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_a_destroy_func0 (tmp);
#line 176 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return result;
#line 856 "traversable.c"
}


static gpointer ____lambda11__gee_lazy_func (gpointer self) {
	gpointer result;
	result = ___lambda11_ (self);
#line 173 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return result;
#line 865 "traversable.c"
}


static GeeTraversableStream __lambda10_ (Block14Data* _data14_, GeeTraversableStream state, GeeLazy* item, GeeLazy** val) {
	GeeTraversable * self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	GeeLazy* _vala_val = NULL;
	GeeTraversableStream result = 0;
	Block15Data* _data15_;
	GeeLazy* _tmp0_ = NULL;
	GeeTraversableStream _tmp1_ = 0;
#line 167 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	self = _data14_->self;
#line 167 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	a_type = _data14_->a_type;
#line 167 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	a_dup_func = _data14_->a_dup_func;
#line 167 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	a_destroy_func = _data14_->a_destroy_func;
#line 167 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data15_ = g_slice_new0 (Block15Data);
#line 167 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data15_->_ref_count_ = 1;
#line 167 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data15_->_data14_ = block14_data_ref (_data14_);
#line 167 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp0_ = item;
#line 167 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_gee_lazy_unref0 (_data15_->item);
#line 167 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data15_->item = _tmp0_;
#line 168 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp1_ = state;
#line 168 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	switch (_tmp1_) {
#line 168 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		case GEE_TRAVERSABLE_STREAM_YIELD:
#line 905 "traversable.c"
		{
#line 170 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_gee_lazy_unref0 (_vala_val);
#line 170 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_vala_val = NULL;
#line 171 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			result = GEE_TRAVERSABLE_STREAM_CONTINUE;
#line 171 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			block15_data_unref (_data15_);
#line 171 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_data15_ = NULL;
#line 171 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			if (val) {
#line 171 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				*val = _vala_val;
#line 921 "traversable.c"
			} else {
#line 171 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_gee_lazy_unref0 (_vala_val);
#line 925 "traversable.c"
			}
#line 171 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			return result;
#line 929 "traversable.c"
		}
#line 168 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		case GEE_TRAVERSABLE_STREAM_CONTINUE:
#line 933 "traversable.c"
		{
			GeeLazy* _tmp2_ = NULL;
#line 173 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_tmp2_ = gee_lazy_new (a_type, (GBoxedCopyFunc) a_dup_func, a_destroy_func, ____lambda11__gee_lazy_func, block15_data_ref (_data15_), block15_data_unref);
#line 173 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_gee_lazy_unref0 (_vala_val);
#line 173 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_vala_val = _tmp2_;
#line 178 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			result = GEE_TRAVERSABLE_STREAM_YIELD;
#line 178 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			block15_data_unref (_data15_);
#line 178 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_data15_ = NULL;
#line 178 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			if (val) {
#line 178 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				*val = _vala_val;
#line 952 "traversable.c"
			} else {
#line 178 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_gee_lazy_unref0 (_vala_val);
#line 956 "traversable.c"
			}
#line 178 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			return result;
#line 960 "traversable.c"
		}
#line 168 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		case GEE_TRAVERSABLE_STREAM_END:
#line 964 "traversable.c"
		{
#line 180 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_gee_lazy_unref0 (_vala_val);
#line 180 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_vala_val = NULL;
#line 181 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			result = GEE_TRAVERSABLE_STREAM_END;
#line 181 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			block15_data_unref (_data15_);
#line 181 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_data15_ = NULL;
#line 181 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			if (val) {
#line 181 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				*val = _vala_val;
#line 980 "traversable.c"
			} else {
#line 181 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_gee_lazy_unref0 (_vala_val);
#line 984 "traversable.c"
			}
#line 181 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			return result;
#line 988 "traversable.c"
		}
		default:
		{
#line 183 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			g_assert_not_reached ();
#line 994 "traversable.c"
		}
	}
#line 167 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	if (val) {
#line 167 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		*val = _vala_val;
#line 1001 "traversable.c"
	} else {
#line 167 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_gee_lazy_unref0 (_vala_val);
#line 1005 "traversable.c"
	}
#line 167 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	block15_data_unref (_data15_);
#line 167 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data15_ = NULL;
#line 1011 "traversable.c"
}


static GeeTraversableStream ___lambda10__gee_stream_func (GeeTraversableStream state, GeeLazy* g, GeeLazy** lazy, gpointer self) {
	GeeTraversableStream result;
	result = __lambda10_ (self, state, g, lazy);
#line 167 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return result;
#line 1020 "traversable.c"
}


static GeeIterator* gee_traversable_real_map (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeMapFunc f, void* f_target) {
	GeeIterator* result = NULL;
	Block14Data* _data14_;
	GeeMapFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	GeeIterator* _tmp1_ = NULL;
#line 166 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data14_ = g_slice_new0 (Block14Data);
#line 166 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data14_->_ref_count_ = 1;
#line 166 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data14_->self = g_object_ref (self);
#line 166 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data14_->a_type = a_type;
#line 166 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data14_->a_dup_func = a_dup_func;
#line 166 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data14_->a_destroy_func = a_destroy_func;
#line 166 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp0_ = f;
#line 166 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp0__target = f_target;
#line 166 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data14_->f = _tmp0_;
#line 166 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data14_->f_target = _tmp0__target;
#line 167 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp1_ = gee_traversable_stream (self, a_type, (GBoxedCopyFunc) a_dup_func, a_destroy_func, ___lambda10__gee_stream_func, block14_data_ref (_data14_), block14_data_unref);
#line 167 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	result = _tmp1_;
#line 167 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	block14_data_unref (_data14_);
#line 167 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data14_ = NULL;
#line 167 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return result;
#line 1060 "traversable.c"
}


GeeIterator* gee_traversable_map (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeMapFunc f, void* f_target) {
#line 166 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 166 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return GEE_TRAVERSABLE_GET_INTERFACE (self)->map (self, a_type, a_dup_func, a_destroy_func, f, f_target);
#line 1069 "traversable.c"
}


/**
 * Creates a new iterator that is initially pointing to seed. Then
 * subsequent values are obtained after applying the function to previous
 * value and the subsequent items.
 *
 * The resulting iterator is always valid and it contains the seed value.
 *
 * Note: Default implementation uses {@link stream}.
 *
 * Note: When the method is called on {@link Iterator} using the parent
 *    iterator is not allowed befor the inner iterator
 *    {@link Iterator.next} return false and then it points on its last
 *    element. The resulting iterator is {@link Iterator.valid}.
 *
 * @param f Folding function
 * @param seed original seed value
 * @return Iterator containing values of subsequent values of seed
 */
static Block16Data* block16_data_ref (Block16Data* _data16_) {
#line 207 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	g_atomic_int_inc (&_data16_->_ref_count_);
#line 207 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return _data16_;
#line 1096 "traversable.c"
}


static void block16_data_unref (void * _userdata_) {
	Block16Data* _data16_;
	_data16_ = (Block16Data*) _userdata_;
#line 207 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	if (g_atomic_int_dec_and_test (&_data16_->_ref_count_)) {
#line 1105 "traversable.c"
		GeeTraversable * self;
		GType a_type;
		GBoxedCopyFunc a_dup_func;
		GDestroyNotify a_destroy_func;
#line 207 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		self = _data16_->self;
#line 207 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		a_type = _data16_->a_type;
#line 207 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		a_dup_func = _data16_->a_dup_func;
#line 207 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		a_destroy_func = _data16_->a_destroy_func;
#line 207 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_a_destroy_func0 (_data16_->seed);
#line 207 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_g_object_unref0 (self);
#line 207 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		g_slice_free (Block16Data, _data16_);
#line 1124 "traversable.c"
	}
}


static Block17Data* block17_data_ref (Block17Data* _data17_) {
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	g_atomic_int_inc (&_data17_->_ref_count_);
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return _data17_;
#line 1134 "traversable.c"
}


static void block17_data_unref (void * _userdata_) {
	Block17Data* _data17_;
	_data17_ = (Block17Data*) _userdata_;
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	if (g_atomic_int_dec_and_test (&_data17_->_ref_count_)) {
#line 1143 "traversable.c"
		GeeTraversable * self;
		GType a_type;
		GBoxedCopyFunc a_dup_func;
		GDestroyNotify a_destroy_func;
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		self = _data17_->_data16_->self;
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		a_type = _data17_->_data16_->a_type;
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		a_dup_func = _data17_->_data16_->a_dup_func;
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		a_destroy_func = _data17_->_data16_->a_destroy_func;
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_gee_lazy_unref0 (_data17_->item);
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		block16_data_unref (_data17_->_data16_);
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_data17_->_data16_ = NULL;
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		g_slice_free (Block17Data, _data17_);
#line 1164 "traversable.c"
	}
}


static gpointer ___lambda13_ (Block17Data* _data17_) {
	Block16Data* _data16_;
	GeeTraversable * self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	gpointer result = NULL;
	gpointer tmp = NULL;
	GeeLazy* _tmp0_ = NULL;
	gpointer _tmp1_ = NULL;
	GeeFoldFunc _tmp2_ = NULL;
	void* _tmp2__target = NULL;
	gpointer _tmp3_ = NULL;
	gpointer _tmp4_ = NULL;
	gpointer _tmp5_ = NULL;
	gconstpointer _tmp6_ = NULL;
	gpointer _tmp7_ = NULL;
#line 221 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data16_ = _data17_->_data16_;
#line 221 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	self = _data16_->self;
#line 221 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	a_type = _data16_->a_type;
#line 221 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	a_dup_func = _data16_->a_dup_func;
#line 221 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	a_destroy_func = _data16_->a_destroy_func;
#line 222 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp0_ = _data17_->item;
#line 222 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp1_ = gee_lazy_get (_tmp0_);
#line 222 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	tmp = _tmp1_;
#line 223 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_gee_lazy_unref0 (_data17_->item);
#line 223 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data17_->item = NULL;
#line 224 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp2_ = _data16_->f;
#line 224 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp2__target = _data16_->f_target;
#line 224 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp3_ = tmp;
#line 224 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	tmp = NULL;
#line 224 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp4_ = _data16_->seed;
#line 224 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data16_->seed = NULL;
#line 224 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp5_ = _tmp2_ (_tmp3_, _tmp4_, _tmp2__target);
#line 224 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_a_destroy_func0 (_data16_->seed);
#line 224 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data16_->seed = _tmp5_;
#line 225 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp6_ = _data16_->seed;
#line 225 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp7_ = ((_tmp6_ != NULL) && (a_dup_func != NULL)) ? a_dup_func ((gpointer) _tmp6_) : ((gpointer) _tmp6_);
#line 225 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	result = _tmp7_;
#line 225 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_a_destroy_func0 (tmp);
#line 225 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return result;
#line 1234 "traversable.c"
}


static gpointer ____lambda13__gee_lazy_func (gpointer self) {
	gpointer result;
	result = ___lambda13_ (self);
#line 221 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return result;
#line 1243 "traversable.c"
}


static GeeTraversableStream __lambda12_ (Block16Data* _data16_, GeeTraversableStream state, GeeLazy* item, GeeLazy** val) {
	GeeTraversable * self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	GeeLazy* _vala_val = NULL;
	GeeTraversableStream result = 0;
	Block17Data* _data17_;
	GeeLazy* _tmp0_ = NULL;
	GeeTraversableStream _tmp1_ = 0;
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	self = _data16_->self;
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	a_type = _data16_->a_type;
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	a_dup_func = _data16_->a_dup_func;
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	a_destroy_func = _data16_->a_destroy_func;
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data17_ = g_slice_new0 (Block17Data);
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data17_->_ref_count_ = 1;
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data17_->_data16_ = block16_data_ref (_data16_);
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp0_ = item;
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_gee_lazy_unref0 (_data17_->item);
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data17_->item = _tmp0_;
#line 210 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp1_ = state;
#line 210 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	switch (_tmp1_) {
#line 210 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		case GEE_TRAVERSABLE_STREAM_YIELD:
#line 1283 "traversable.c"
		{
#line 212 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			if (_data16_->seed_emitted) {
#line 213 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_gee_lazy_unref0 (_vala_val);
#line 213 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_vala_val = NULL;
#line 214 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				result = GEE_TRAVERSABLE_STREAM_CONTINUE;
#line 214 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				block17_data_unref (_data17_);
#line 214 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_data17_ = NULL;
#line 214 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				if (val) {
#line 214 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					*val = _vala_val;
#line 1301 "traversable.c"
				} else {
#line 214 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					_gee_lazy_unref0 (_vala_val);
#line 1305 "traversable.c"
				}
#line 214 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				return result;
#line 1309 "traversable.c"
			} else {
				gconstpointer _tmp2_ = NULL;
				GeeLazy* _tmp3_ = NULL;
#line 216 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_tmp2_ = _data16_->seed;
#line 216 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_tmp3_ = gee_lazy_new_from_value (a_type, (GBoxedCopyFunc) a_dup_func, a_destroy_func, _tmp2_);
#line 216 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_gee_lazy_unref0 (_vala_val);
#line 216 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_vala_val = _tmp3_;
#line 217 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_data16_->seed_emitted = TRUE;
#line 218 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				result = GEE_TRAVERSABLE_STREAM_YIELD;
#line 218 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				block17_data_unref (_data17_);
#line 218 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_data17_ = NULL;
#line 218 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				if (val) {
#line 218 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					*val = _vala_val;
#line 1333 "traversable.c"
				} else {
#line 218 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					_gee_lazy_unref0 (_vala_val);
#line 1337 "traversable.c"
				}
#line 218 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				return result;
#line 1341 "traversable.c"
			}
		}
#line 210 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		case GEE_TRAVERSABLE_STREAM_CONTINUE:
#line 1346 "traversable.c"
		{
			GeeLazy* _tmp4_ = NULL;
#line 221 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_tmp4_ = gee_lazy_new (a_type, (GBoxedCopyFunc) a_dup_func, a_destroy_func, ____lambda13__gee_lazy_func, block17_data_ref (_data17_), block17_data_unref);
#line 221 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_gee_lazy_unref0 (_vala_val);
#line 221 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_vala_val = _tmp4_;
#line 227 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			result = GEE_TRAVERSABLE_STREAM_YIELD;
#line 227 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			block17_data_unref (_data17_);
#line 227 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_data17_ = NULL;
#line 227 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			if (val) {
#line 227 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				*val = _vala_val;
#line 1365 "traversable.c"
			} else {
#line 227 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_gee_lazy_unref0 (_vala_val);
#line 1369 "traversable.c"
			}
#line 227 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			return result;
#line 1373 "traversable.c"
		}
#line 210 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		case GEE_TRAVERSABLE_STREAM_END:
#line 1377 "traversable.c"
		{
#line 229 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_gee_lazy_unref0 (_vala_val);
#line 229 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_vala_val = NULL;
#line 230 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			result = GEE_TRAVERSABLE_STREAM_END;
#line 230 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			block17_data_unref (_data17_);
#line 230 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_data17_ = NULL;
#line 230 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			if (val) {
#line 230 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				*val = _vala_val;
#line 1393 "traversable.c"
			} else {
#line 230 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_gee_lazy_unref0 (_vala_val);
#line 1397 "traversable.c"
			}
#line 230 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			return result;
#line 1401 "traversable.c"
		}
		default:
		{
#line 232 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			g_assert_not_reached ();
#line 1407 "traversable.c"
		}
	}
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	if (val) {
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		*val = _vala_val;
#line 1414 "traversable.c"
	} else {
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_gee_lazy_unref0 (_vala_val);
#line 1418 "traversable.c"
	}
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	block17_data_unref (_data17_);
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data17_ = NULL;
#line 1424 "traversable.c"
}


static GeeTraversableStream ___lambda12__gee_stream_func (GeeTraversableStream state, GeeLazy* g, GeeLazy** lazy, gpointer self) {
	GeeTraversableStream result;
	result = __lambda12_ (self, state, g, lazy);
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return result;
#line 1433 "traversable.c"
}


static GeeIterator* gee_traversable_real_scan (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed) {
	GeeIterator* result = NULL;
	Block16Data* _data16_;
	GeeFoldFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	gconstpointer _tmp1_ = NULL;
	GeeIterator* _tmp2_ = NULL;
#line 207 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data16_ = g_slice_new0 (Block16Data);
#line 207 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data16_->_ref_count_ = 1;
#line 207 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data16_->self = g_object_ref (self);
#line 207 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data16_->a_type = a_type;
#line 207 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data16_->a_dup_func = a_dup_func;
#line 207 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data16_->a_destroy_func = a_destroy_func;
#line 207 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp0_ = f;
#line 207 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp0__target = f_target;
#line 207 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data16_->f = _tmp0_;
#line 207 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data16_->f_target = _tmp0__target;
#line 207 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp1_ = seed;
#line 207 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_a_destroy_func0 (_data16_->seed);
#line 207 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data16_->seed = _tmp1_;
#line 208 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data16_->seed_emitted = FALSE;
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp2_ = gee_traversable_stream (self, a_type, (GBoxedCopyFunc) a_dup_func, a_destroy_func, ___lambda12__gee_stream_func, block16_data_ref (_data16_), block16_data_unref);
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	result = _tmp2_;
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	block16_data_unref (_data16_);
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data16_ = NULL;
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return result;
#line 1482 "traversable.c"
}


GeeIterator* gee_traversable_scan (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed) {
#line 207 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 207 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return GEE_TRAVERSABLE_GET_INTERFACE (self)->scan (self, a_type, a_dup_func, a_destroy_func, f, f_target, seed);
#line 1491 "traversable.c"
}


/**
 * Creates a new iterator that contains only values that fullfills the
 * predicate.
 *
 * Note: When the method is called on {@link Iterator} using the parent
 *    iterator is not allowed befor the inner iterator
 *    {@link Iterator.next} return false and then it points on its last
 *    element. The resulting iterator is {@link Iterator.valid} if parent
 *    iterator is {@link Iterator.valid} and value it is pointing on
 *    fullfills the predicate.
 *
 * @param pred predicate to check should the value be retained
 * @return Iterator containing values of subsequent values of seed
 */
static Block18Data* block18_data_ref (Block18Data* _data18_) {
#line 252 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	g_atomic_int_inc (&_data18_->_ref_count_);
#line 252 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return _data18_;
#line 1514 "traversable.c"
}


static void block18_data_unref (void * _userdata_) {
	Block18Data* _data18_;
	_data18_ = (Block18Data*) _userdata_;
#line 252 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	if (g_atomic_int_dec_and_test (&_data18_->_ref_count_)) {
#line 1523 "traversable.c"
		GeeTraversable * self;
#line 252 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		self = _data18_->self;
#line 252 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		(_data18_->pred_target_destroy_notify == NULL) ? NULL : (_data18_->pred_target_destroy_notify (_data18_->pred_target), NULL);
#line 252 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_data18_->pred = NULL;
#line 252 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_data18_->pred_target = NULL;
#line 252 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_data18_->pred_target_destroy_notify = NULL;
#line 252 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_g_object_unref0 (self);
#line 252 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		g_slice_free (Block18Data, _data18_);
#line 1539 "traversable.c"
	}
}


static gpointer _gee_lazy_ref0 (gpointer self) {
#line 261 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return self ? gee_lazy_ref (self) : NULL;
#line 1547 "traversable.c"
}


static GeeTraversableStream __lambda14_ (Block18Data* _data18_, GeeTraversableStream state, GeeLazy* item, GeeLazy** val) {
	GeeTraversable * self;
	GeeLazy* _vala_val = NULL;
	GeeTraversableStream result = 0;
	GeeTraversableStream _tmp0_ = 0;
#line 253 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	self = _data18_->self;
#line 254 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp0_ = state;
#line 254 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	switch (_tmp0_) {
#line 254 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		case GEE_TRAVERSABLE_STREAM_YIELD:
#line 1564 "traversable.c"
		{
#line 256 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_gee_lazy_unref0 (_vala_val);
#line 256 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_vala_val = NULL;
#line 257 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			result = GEE_TRAVERSABLE_STREAM_CONTINUE;
#line 257 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_gee_lazy_unref0 (item);
#line 257 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			if (val) {
#line 257 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				*val = _vala_val;
#line 1578 "traversable.c"
			} else {
#line 257 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_gee_lazy_unref0 (_vala_val);
#line 1582 "traversable.c"
			}
#line 257 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			return result;
#line 1586 "traversable.c"
		}
#line 254 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		case GEE_TRAVERSABLE_STREAM_CONTINUE:
#line 1590 "traversable.c"
		{
			gpointer g = NULL;
			GeeLazy* _tmp1_ = NULL;
			gpointer _tmp2_ = NULL;
			GeePredicate _tmp3_ = NULL;
			void* _tmp3__target = NULL;
			gconstpointer _tmp4_ = NULL;
			gboolean _tmp5_ = FALSE;
#line 259 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_tmp1_ = item;
#line 259 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_tmp2_ = gee_lazy_get (_tmp1_);
#line 259 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			g = _tmp2_;
#line 260 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_tmp3_ = _data18_->pred;
#line 260 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_tmp3__target = _data18_->pred_target;
#line 260 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_tmp4_ = g;
#line 260 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_tmp5_ = _tmp3_ (_tmp4_, _tmp3__target);
#line 260 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			if (_tmp5_) {
#line 1615 "traversable.c"
				GeeLazy* _tmp6_ = NULL;
				GeeLazy* _tmp7_ = NULL;
#line 261 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_tmp6_ = item;
#line 261 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_tmp7_ = _gee_lazy_ref0 (_tmp6_);
#line 261 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_gee_lazy_unref0 (_vala_val);
#line 261 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_vala_val = _tmp7_;
#line 262 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				result = GEE_TRAVERSABLE_STREAM_YIELD;
#line 262 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				((g == NULL) || (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self) == NULL)) ? NULL : (g = (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self) (g), NULL));
#line 262 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_gee_lazy_unref0 (item);
#line 262 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				if (val) {
#line 262 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					*val = _vala_val;
#line 1636 "traversable.c"
				} else {
#line 262 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					_gee_lazy_unref0 (_vala_val);
#line 1640 "traversable.c"
				}
#line 262 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				return result;
#line 1644 "traversable.c"
			} else {
#line 264 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_gee_lazy_unref0 (_vala_val);
#line 264 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_vala_val = NULL;
#line 265 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				result = GEE_TRAVERSABLE_STREAM_CONTINUE;
#line 265 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				((g == NULL) || (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self) == NULL)) ? NULL : (g = (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self) (g), NULL));
#line 265 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_gee_lazy_unref0 (item);
#line 265 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				if (val) {
#line 265 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					*val = _vala_val;
#line 1660 "traversable.c"
				} else {
#line 265 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					_gee_lazy_unref0 (_vala_val);
#line 1664 "traversable.c"
				}
#line 265 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				return result;
#line 1668 "traversable.c"
			}
#line 254 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			((g == NULL) || (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self) == NULL)) ? NULL : (g = (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self) (g), NULL));
#line 1672 "traversable.c"
		}
#line 254 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		case GEE_TRAVERSABLE_STREAM_END:
#line 1676 "traversable.c"
		{
#line 268 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_gee_lazy_unref0 (_vala_val);
#line 268 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_vala_val = NULL;
#line 269 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			result = GEE_TRAVERSABLE_STREAM_END;
#line 269 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_gee_lazy_unref0 (item);
#line 269 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			if (val) {
#line 269 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				*val = _vala_val;
#line 1690 "traversable.c"
			} else {
#line 269 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_gee_lazy_unref0 (_vala_val);
#line 1694 "traversable.c"
			}
#line 269 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			return result;
#line 1698 "traversable.c"
		}
		default:
		{
#line 271 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			g_assert_not_reached ();
#line 1704 "traversable.c"
		}
	}
#line 253 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_gee_lazy_unref0 (item);
#line 253 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	if (val) {
#line 253 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		*val = _vala_val;
#line 1713 "traversable.c"
	} else {
#line 253 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_gee_lazy_unref0 (_vala_val);
#line 1717 "traversable.c"
	}
}


static GeeTraversableStream ___lambda14__gee_stream_func (GeeTraversableStream state, GeeLazy* g, GeeLazy** lazy, gpointer self) {
	GeeTraversableStream result;
	result = __lambda14_ (self, state, g, lazy);
#line 253 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return result;
#line 1727 "traversable.c"
}


static GeeIterator* gee_traversable_real_filter (GeeTraversable* self, GeePredicate pred, void* pred_target, GDestroyNotify pred_target_destroy_notify) {
	GeeIterator* result = NULL;
	Block18Data* _data18_;
	GeePredicate _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	GeeIterator* _tmp1_ = NULL;
#line 252 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data18_ = g_slice_new0 (Block18Data);
#line 252 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data18_->_ref_count_ = 1;
#line 252 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data18_->self = g_object_ref (self);
#line 252 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp0_ = pred;
#line 252 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp0__target = pred_target;
#line 252 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	(_data18_->pred_target_destroy_notify == NULL) ? NULL : (_data18_->pred_target_destroy_notify (_data18_->pred_target), NULL);
#line 252 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data18_->pred = NULL;
#line 252 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data18_->pred_target = NULL;
#line 252 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data18_->pred_target_destroy_notify = NULL;
#line 252 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data18_->pred = _tmp0_;
#line 252 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data18_->pred_target = _tmp0__target;
#line 252 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data18_->pred_target_destroy_notify = pred_target_destroy_notify;
#line 253 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp1_ = gee_traversable_stream (self, GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_type (self), (GBoxedCopyFunc) GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_dup_func (self), GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self), ___lambda14__gee_stream_func, block18_data_ref (_data18_), block18_data_unref);
#line 253 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	result = _tmp1_;
#line 253 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	block18_data_unref (_data18_);
#line 253 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data18_ = NULL;
#line 253 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return result;
#line 1771 "traversable.c"
}


GeeIterator* gee_traversable_filter (GeeTraversable* self, GeePredicate pred, void* pred_target, GDestroyNotify pred_target_destroy_notify) {
#line 252 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 252 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return GEE_TRAVERSABLE_GET_INTERFACE (self)->filter (self, pred, pred_target, pred_target_destroy_notify);
#line 1780 "traversable.c"
}


/**
 * Creates a new iterator which contains elements from iterable. The
 * first argument states the offset i.e. number of elements the iterator
 * skips by default.
 *
 * Note: In {@link Iterator} implementation resulting iterator is
 *    {@link Iterator.valid} when parent iterator is
 *    {@link Iterator.valid} and the offset is 0. Using the parent
 *    iterator is not allowed before the inner iterator
 *    {@link Iterator.next} return false and then it points on its last
 *    element.
 *
 * @param offset the offset to first element the iterator is pointing to
 * @param length maximum number of elements iterator may return. Negative
 *        value means that the number is unbounded
 */
static Block19Data* block19_data_ref (Block19Data* _data19_) {
#line 293 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	g_atomic_int_inc (&_data19_->_ref_count_);
#line 293 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return _data19_;
#line 1805 "traversable.c"
}


static void block19_data_unref (void * _userdata_) {
	Block19Data* _data19_;
	_data19_ = (Block19Data*) _userdata_;
#line 293 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	if (g_atomic_int_dec_and_test (&_data19_->_ref_count_)) {
#line 1814 "traversable.c"
		GeeTraversable * self;
#line 293 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		self = _data19_->self;
#line 293 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_g_object_unref0 (self);
#line 293 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		g_slice_free (Block19Data, _data19_);
#line 1822 "traversable.c"
	}
}


static GeeTraversableStream __lambda15_ (Block19Data* _data19_, GeeTraversableStream state, GeeLazy* item, GeeLazy** val) {
	GeeTraversable * self;
	GeeLazy* _vala_val = NULL;
	GeeTraversableStream result = 0;
	GeeTraversableStream _tmp0_ = 0;
#line 295 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	self = _data19_->self;
#line 296 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp0_ = state;
#line 296 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	switch (_tmp0_) {
#line 296 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		case GEE_TRAVERSABLE_STREAM_YIELD:
#line 1840 "traversable.c"
		{
			gint _tmp1_ = 0;
#line 298 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_gee_lazy_unref0 (_vala_val);
#line 298 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_vala_val = NULL;
#line 299 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_tmp1_ = _data19_->offset;
#line 299 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			if (_tmp1_ > 0) {
#line 300 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				result = GEE_TRAVERSABLE_STREAM_CONTINUE;
#line 300 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_gee_lazy_unref0 (item);
#line 300 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				if (val) {
#line 300 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					*val = _vala_val;
#line 1859 "traversable.c"
				} else {
#line 300 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					_gee_lazy_unref0 (_vala_val);
#line 1863 "traversable.c"
				}
#line 300 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				return result;
#line 1867 "traversable.c"
			} else {
				gint _tmp2_ = 0;
#line 301 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_tmp2_ = _data19_->length;
#line 301 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				if (_tmp2_ > 0) {
#line 1874 "traversable.c"
					GeeTraversableStream _tmp3_ = 0;
					gint _tmp4_ = 0;
					GeeTraversableStream _tmp5_ = 0;
#line 302 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					_tmp4_ = _data19_->length;
#line 302 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					if (_tmp4_ != 0) {
#line 302 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
						_tmp3_ = GEE_TRAVERSABLE_STREAM_CONTINUE;
#line 1884 "traversable.c"
					} else {
#line 302 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
						_tmp3_ = GEE_TRAVERSABLE_STREAM_END;
#line 1888 "traversable.c"
					}
#line 302 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					_tmp5_ = _tmp3_;
#line 302 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					result = _tmp5_;
#line 302 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					_gee_lazy_unref0 (item);
#line 302 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					if (val) {
#line 302 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
						*val = _vala_val;
#line 1900 "traversable.c"
					} else {
#line 302 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
						_gee_lazy_unref0 (_vala_val);
#line 1904 "traversable.c"
					}
#line 302 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					return result;
#line 1908 "traversable.c"
				} else {
					gint _tmp6_ = 0;
#line 303 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					_tmp6_ = _data19_->length;
#line 303 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					if (_tmp6_ == 0) {
#line 304 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
						result = GEE_TRAVERSABLE_STREAM_END;
#line 304 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
						_gee_lazy_unref0 (item);
#line 304 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
						if (val) {
#line 304 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
							*val = _vala_val;
#line 1923 "traversable.c"
						} else {
#line 304 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
							_gee_lazy_unref0 (_vala_val);
#line 1927 "traversable.c"
						}
#line 304 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
						return result;
#line 1931 "traversable.c"
					} else {
#line 306 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
						result = GEE_TRAVERSABLE_STREAM_CONTINUE;
#line 306 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
						_gee_lazy_unref0 (item);
#line 306 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
						if (val) {
#line 306 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
							*val = _vala_val;
#line 1941 "traversable.c"
						} else {
#line 306 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
							_gee_lazy_unref0 (_vala_val);
#line 1945 "traversable.c"
						}
#line 306 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
						return result;
#line 1949 "traversable.c"
					}
				}
			}
		}
#line 296 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		case GEE_TRAVERSABLE_STREAM_CONTINUE:
#line 1956 "traversable.c"
		{
			gint _tmp7_ = 0;
#line 309 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_tmp7_ = _data19_->offset;
#line 309 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			if (_tmp7_ == 0) {
#line 1963 "traversable.c"
				GeeLazy* _tmp8_ = NULL;
				GeeLazy* _tmp9_ = NULL;
				gint _tmp10_ = 0;
#line 310 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_tmp8_ = item;
#line 310 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_tmp9_ = _gee_lazy_ref0 (_tmp8_);
#line 310 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_gee_lazy_unref0 (_vala_val);
#line 310 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_vala_val = _tmp9_;
#line 311 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_tmp10_ = _data19_->length;
#line 311 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_data19_->length = _tmp10_ - 1;
#line 312 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				result = GEE_TRAVERSABLE_STREAM_YIELD;
#line 312 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_gee_lazy_unref0 (item);
#line 312 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				if (val) {
#line 312 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					*val = _vala_val;
#line 1987 "traversable.c"
				} else {
#line 312 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					_gee_lazy_unref0 (_vala_val);
#line 1991 "traversable.c"
				}
#line 312 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				return result;
#line 1995 "traversable.c"
			} else {
				gint _tmp11_ = 0;
#line 314 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_gee_lazy_unref0 (_vala_val);
#line 314 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_vala_val = NULL;
#line 315 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_tmp11_ = _data19_->offset;
#line 315 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_data19_->offset = _tmp11_ - 1;
#line 316 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				result = GEE_TRAVERSABLE_STREAM_CONTINUE;
#line 316 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_gee_lazy_unref0 (item);
#line 316 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				if (val) {
#line 316 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					*val = _vala_val;
#line 2014 "traversable.c"
				} else {
#line 316 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					_gee_lazy_unref0 (_vala_val);
#line 2018 "traversable.c"
				}
#line 316 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				return result;
#line 2022 "traversable.c"
			}
		}
#line 296 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		case GEE_TRAVERSABLE_STREAM_END:
#line 2027 "traversable.c"
		{
#line 319 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_gee_lazy_unref0 (_vala_val);
#line 319 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_vala_val = NULL;
#line 320 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			result = GEE_TRAVERSABLE_STREAM_END;
#line 320 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_gee_lazy_unref0 (item);
#line 320 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			if (val) {
#line 320 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				*val = _vala_val;
#line 2041 "traversable.c"
			} else {
#line 320 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_gee_lazy_unref0 (_vala_val);
#line 2045 "traversable.c"
			}
#line 320 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			return result;
#line 2049 "traversable.c"
		}
		default:
		{
#line 322 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			g_assert_not_reached ();
#line 2055 "traversable.c"
		}
	}
#line 295 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_gee_lazy_unref0 (item);
#line 295 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	if (val) {
#line 295 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		*val = _vala_val;
#line 2064 "traversable.c"
	} else {
#line 295 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_gee_lazy_unref0 (_vala_val);
#line 2068 "traversable.c"
	}
}


static GeeTraversableStream ___lambda15__gee_stream_func (GeeTraversableStream state, GeeLazy* g, GeeLazy** lazy, gpointer self) {
	GeeTraversableStream result;
	result = __lambda15_ (self, state, g, lazy);
#line 295 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return result;
#line 2078 "traversable.c"
}


static GeeIterator* gee_traversable_real_chop (GeeTraversable* self, gint offset, gint length) {
	GeeIterator* result = NULL;
	Block19Data* _data19_;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GeeIterator* _tmp3_ = NULL;
#line 293 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data19_ = g_slice_new0 (Block19Data);
#line 293 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data19_->_ref_count_ = 1;
#line 293 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data19_->self = g_object_ref (self);
#line 293 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp0_ = offset;
#line 293 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data19_->offset = _tmp0_;
#line 293 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp1_ = length;
#line 293 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data19_->length = _tmp1_;
#line 294 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp2_ = _data19_->offset;
#line 294 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_vala_assert (_tmp2_ >= 0, "offset >= 0");
#line 295 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp3_ = gee_traversable_stream (self, GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_type (self), (GBoxedCopyFunc) GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_dup_func (self), GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self), ___lambda15__gee_stream_func, block19_data_ref (_data19_), block19_data_unref);
#line 295 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	result = _tmp3_;
#line 295 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	block19_data_unref (_data19_);
#line 295 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data19_ = NULL;
#line 295 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return result;
#line 2117 "traversable.c"
}


GeeIterator* gee_traversable_chop (GeeTraversable* self, gint offset, gint length) {
#line 293 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 293 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return GEE_TRAVERSABLE_GET_INTERFACE (self)->chop (self, offset, length);
#line 2126 "traversable.c"
}


/**
 * A fused concatinate and map. The function is applied to each element
 * of iteration and the resulting values are concatinated.
 *
 * The iterator is lazy evaluated but value is force-evaluated when
 * iterator is moved to next value.
 *
 * Note: Default implementation uses {@link stream}.
 *
 * Note: In {@link Iterator} implementation if the parent iterator is
 *    {@link Iterator.valid} and function returns a valid iterator the
 *    resulting iterator is also valid. Using the parent iterator is not
 *    allowed before the inner iterator {@link Iterator.next}
 *    return false and then it points on its last element.
 *
 * @since 0.11.1
 * @param f mapping function
 * @return Iterator over returned values
 */
static Block20Data* block20_data_ref (Block20Data* _data20_) {
#line 353 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	g_atomic_int_inc (&_data20_->_ref_count_);
#line 353 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return _data20_;
#line 2154 "traversable.c"
}


static void block20_data_unref (void * _userdata_) {
	Block20Data* _data20_;
	_data20_ = (Block20Data*) _userdata_;
#line 353 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	if (g_atomic_int_dec_and_test (&_data20_->_ref_count_)) {
#line 2163 "traversable.c"
		GeeTraversable * self;
		GType a_type;
		GBoxedCopyFunc a_dup_func;
		GDestroyNotify a_destroy_func;
#line 353 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		self = _data20_->self;
#line 353 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		a_type = _data20_->a_type;
#line 353 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		a_dup_func = _data20_->a_dup_func;
#line 353 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		a_destroy_func = _data20_->a_destroy_func;
#line 353 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_g_object_unref0 (_data20_->current);
#line 353 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		(_data20_->f_target_destroy_notify == NULL) ? NULL : (_data20_->f_target_destroy_notify (_data20_->f_target), NULL);
#line 353 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_data20_->f = NULL;
#line 353 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_data20_->f_target = NULL;
#line 353 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_data20_->f_target_destroy_notify = NULL;
#line 353 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_g_object_unref0 (self);
#line 353 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		g_slice_free (Block20Data, _data20_);
#line 2190 "traversable.c"
	}
}


static Block21Data* block21_data_ref (Block21Data* _data21_) {
#line 355 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	g_atomic_int_inc (&_data21_->_ref_count_);
#line 355 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return _data21_;
#line 2200 "traversable.c"
}


static void block21_data_unref (void * _userdata_) {
	Block21Data* _data21_;
	_data21_ = (Block21Data*) _userdata_;
#line 355 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	if (g_atomic_int_dec_and_test (&_data21_->_ref_count_)) {
#line 2209 "traversable.c"
		GeeTraversable * self;
		GType a_type;
		GBoxedCopyFunc a_dup_func;
		GDestroyNotify a_destroy_func;
#line 355 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		self = _data21_->_data20_->self;
#line 355 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		a_type = _data21_->_data20_->a_type;
#line 355 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		a_dup_func = _data21_->_data20_->a_dup_func;
#line 355 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		a_destroy_func = _data21_->_data20_->a_destroy_func;
#line 355 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		block20_data_unref (_data21_->_data20_);
#line 355 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_data21_->_data20_ = NULL;
#line 355 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		g_slice_free (Block21Data, _data21_);
#line 2228 "traversable.c"
	}
}


static gpointer ____lambda17_ (Block21Data* _data21_) {
	Block20Data* _data20_;
	GeeTraversable * self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	gpointer result = NULL;
	gpointer _tmp0_ = NULL;
#line 361 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data20_ = _data21_->_data20_;
#line 361 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	self = _data20_->self;
#line 361 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	a_type = _data20_->a_type;
#line 361 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	a_dup_func = _data20_->a_dup_func;
#line 361 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	a_destroy_func = _data20_->a_destroy_func;
#line 361 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp0_ = gee_iterator_get (_data20_->current);
#line 361 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	result = _tmp0_;
#line 361 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return result;
#line 2257 "traversable.c"
}


static gpointer _____lambda17__gee_lazy_func (gpointer self) {
	gpointer result;
	result = ____lambda17_ (self);
#line 361 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return result;
#line 2266 "traversable.c"
}


static gpointer ____lambda18_ (Block21Data* _data21_) {
	Block20Data* _data20_;
	GeeTraversable * self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	gpointer result = NULL;
	gpointer _tmp0_ = NULL;
#line 367 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data20_ = _data21_->_data20_;
#line 367 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	self = _data20_->self;
#line 367 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	a_type = _data20_->a_type;
#line 367 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	a_dup_func = _data20_->a_dup_func;
#line 367 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	a_destroy_func = _data20_->a_destroy_func;
#line 367 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp0_ = gee_iterator_get (_data20_->current);
#line 367 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	result = _tmp0_;
#line 367 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return result;
#line 2294 "traversable.c"
}


static gpointer _____lambda18__gee_lazy_func (gpointer self) {
	gpointer result;
	result = ____lambda18_ (self);
#line 367 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return result;
#line 2303 "traversable.c"
}


static gpointer ____lambda19_ (Block21Data* _data21_) {
	Block20Data* _data20_;
	GeeTraversable * self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	gpointer result = NULL;
	gpointer _tmp0_ = NULL;
#line 374 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data20_ = _data21_->_data20_;
#line 374 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	self = _data20_->self;
#line 374 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	a_type = _data20_->a_type;
#line 374 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	a_dup_func = _data20_->a_dup_func;
#line 374 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	a_destroy_func = _data20_->a_destroy_func;
#line 374 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp0_ = gee_iterator_get (_data20_->current);
#line 374 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	result = _tmp0_;
#line 374 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return result;
#line 2331 "traversable.c"
}


static gpointer _____lambda19__gee_lazy_func (gpointer self) {
	gpointer result;
	result = ____lambda19_ (self);
#line 374 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return result;
#line 2340 "traversable.c"
}


static GeeTraversableStream __lambda16_ (Block20Data* _data20_, GeeTraversableStream state, GeeLazy* item, GeeLazy** val) {
	GeeTraversable * self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	GeeLazy* _vala_val = NULL;
	GeeTraversableStream result = 0;
	Block21Data* _data21_;
	GeeTraversableStream _tmp0_ = 0;
#line 355 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	self = _data20_->self;
#line 355 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	a_type = _data20_->a_type;
#line 355 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	a_dup_func = _data20_->a_dup_func;
#line 355 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	a_destroy_func = _data20_->a_destroy_func;
#line 355 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data21_ = g_slice_new0 (Block21Data);
#line 355 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data21_->_ref_count_ = 1;
#line 355 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data21_->_data20_ = block20_data_ref (_data20_);
#line 356 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp0_ = state;
#line 356 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	switch (_tmp0_) {
#line 356 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		case GEE_TRAVERSABLE_STREAM_YIELD:
#line 2373 "traversable.c"
		{
			gboolean _tmp1_ = FALSE;
			gboolean _tmp3_ = FALSE;
#line 358 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			if (_data20_->current == NULL) {
#line 358 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_tmp1_ = TRUE;
#line 2381 "traversable.c"
			} else {
				gboolean _tmp2_ = FALSE;
#line 358 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_tmp2_ = gee_iterator_next (_data20_->current);
#line 358 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_tmp1_ = !_tmp2_;
#line 2388 "traversable.c"
			}
#line 358 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_tmp3_ = _tmp1_;
#line 358 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			if (_tmp3_) {
#line 359 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				result = GEE_TRAVERSABLE_STREAM_CONTINUE;
#line 359 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				block21_data_unref (_data21_);
#line 359 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_data21_ = NULL;
#line 359 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_gee_lazy_unref0 (item);
#line 359 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				if (val) {
#line 359 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					*val = _vala_val;
#line 2406 "traversable.c"
				} else {
#line 359 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					_gee_lazy_unref0 (_vala_val);
#line 2410 "traversable.c"
				}
#line 359 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				return result;
#line 2414 "traversable.c"
			} else {
				GeeLazy* _tmp4_ = NULL;
#line 361 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_tmp4_ = gee_lazy_new (a_type, (GBoxedCopyFunc) a_dup_func, a_destroy_func, _____lambda17__gee_lazy_func, block21_data_ref (_data21_), block21_data_unref);
#line 361 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_gee_lazy_unref0 (_vala_val);
#line 361 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_vala_val = _tmp4_;
#line 362 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				result = GEE_TRAVERSABLE_STREAM_YIELD;
#line 362 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				block21_data_unref (_data21_);
#line 362 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_data21_ = NULL;
#line 362 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_gee_lazy_unref0 (item);
#line 362 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				if (val) {
#line 362 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					*val = _vala_val;
#line 2435 "traversable.c"
				} else {
#line 362 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					_gee_lazy_unref0 (_vala_val);
#line 2439 "traversable.c"
				}
#line 362 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				return result;
#line 2443 "traversable.c"
			}
		}
#line 356 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		case GEE_TRAVERSABLE_STREAM_CONTINUE:
#line 2448 "traversable.c"
		{
			GeeFlatMapFunc _tmp5_ = NULL;
			void* _tmp5__target = NULL;
			GeeLazy* _tmp6_ = NULL;
			gpointer _tmp7_ = NULL;
			GeeIterator* _tmp8_ = NULL;
			gboolean _tmp9_ = FALSE;
			gboolean _tmp10_ = FALSE;
#line 365 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_tmp5_ = _data20_->f;
#line 365 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_tmp5__target = _data20_->f_target;
#line 365 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_tmp6_ = item;
#line 365 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_tmp7_ = gee_lazy_get (_tmp6_);
#line 365 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_tmp8_ = _tmp5_ (_tmp7_, _tmp5__target);
#line 365 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_g_object_unref0 (_data20_->current);
#line 365 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_data20_->current = _tmp8_;
#line 366 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_tmp9_ = gee_iterator_get_valid (_data20_->current);
#line 366 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_tmp10_ = _tmp9_;
#line 366 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			if (_tmp10_) {
#line 2477 "traversable.c"
				GeeLazy* _tmp11_ = NULL;
#line 367 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_tmp11_ = gee_lazy_new (a_type, (GBoxedCopyFunc) a_dup_func, a_destroy_func, _____lambda18__gee_lazy_func, block21_data_ref (_data21_), block21_data_unref);
#line 367 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_gee_lazy_unref0 (_vala_val);
#line 367 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_vala_val = _tmp11_;
#line 368 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				result = GEE_TRAVERSABLE_STREAM_YIELD;
#line 368 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				block21_data_unref (_data21_);
#line 368 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_data21_ = NULL;
#line 368 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_gee_lazy_unref0 (item);
#line 368 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				if (val) {
#line 368 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					*val = _vala_val;
#line 2497 "traversable.c"
				} else {
#line 368 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					_gee_lazy_unref0 (_vala_val);
#line 2501 "traversable.c"
				}
#line 368 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				return result;
#line 2505 "traversable.c"
			} else {
#line 370 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				result = GEE_TRAVERSABLE_STREAM_WAIT;
#line 370 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				block21_data_unref (_data21_);
#line 370 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_data21_ = NULL;
#line 370 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_gee_lazy_unref0 (item);
#line 370 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				if (val) {
#line 370 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					*val = _vala_val;
#line 2519 "traversable.c"
				} else {
#line 370 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					_gee_lazy_unref0 (_vala_val);
#line 2523 "traversable.c"
				}
#line 370 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				return result;
#line 2527 "traversable.c"
			}
		}
#line 356 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		case GEE_TRAVERSABLE_STREAM_WAIT:
#line 2532 "traversable.c"
		{
			gboolean _tmp12_ = FALSE;
#line 373 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_tmp12_ = gee_iterator_next (_data20_->current);
#line 373 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			if (_tmp12_) {
#line 2539 "traversable.c"
				GeeLazy* _tmp13_ = NULL;
#line 374 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_tmp13_ = gee_lazy_new (a_type, (GBoxedCopyFunc) a_dup_func, a_destroy_func, _____lambda19__gee_lazy_func, block21_data_ref (_data21_), block21_data_unref);
#line 374 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_gee_lazy_unref0 (_vala_val);
#line 374 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_vala_val = _tmp13_;
#line 375 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				result = GEE_TRAVERSABLE_STREAM_YIELD;
#line 375 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				block21_data_unref (_data21_);
#line 375 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_data21_ = NULL;
#line 375 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_gee_lazy_unref0 (item);
#line 375 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				if (val) {
#line 375 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					*val = _vala_val;
#line 2559 "traversable.c"
				} else {
#line 375 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					_gee_lazy_unref0 (_vala_val);
#line 2563 "traversable.c"
				}
#line 375 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				return result;
#line 2567 "traversable.c"
			} else {
#line 377 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				result = GEE_TRAVERSABLE_STREAM_CONTINUE;
#line 377 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				block21_data_unref (_data21_);
#line 377 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_data21_ = NULL;
#line 377 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_gee_lazy_unref0 (item);
#line 377 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				if (val) {
#line 377 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					*val = _vala_val;
#line 2581 "traversable.c"
				} else {
#line 377 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					_gee_lazy_unref0 (_vala_val);
#line 2585 "traversable.c"
				}
#line 377 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				return result;
#line 2589 "traversable.c"
			}
		}
#line 356 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		case GEE_TRAVERSABLE_STREAM_END:
#line 2594 "traversable.c"
		{
#line 380 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			result = GEE_TRAVERSABLE_STREAM_END;
#line 380 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			block21_data_unref (_data21_);
#line 380 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_data21_ = NULL;
#line 380 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_gee_lazy_unref0 (item);
#line 380 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			if (val) {
#line 380 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				*val = _vala_val;
#line 2608 "traversable.c"
			} else {
#line 380 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_gee_lazy_unref0 (_vala_val);
#line 2612 "traversable.c"
			}
#line 380 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			return result;
#line 2616 "traversable.c"
		}
		default:
		{
#line 382 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			g_assert_not_reached ();
#line 2622 "traversable.c"
		}
	}
#line 355 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_gee_lazy_unref0 (item);
#line 355 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	if (val) {
#line 355 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		*val = _vala_val;
#line 2631 "traversable.c"
	} else {
#line 355 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_gee_lazy_unref0 (_vala_val);
#line 2635 "traversable.c"
	}
#line 355 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	block21_data_unref (_data21_);
#line 355 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data21_ = NULL;
#line 2641 "traversable.c"
}


static GeeTraversableStream ___lambda16__gee_stream_func (GeeTraversableStream state, GeeLazy* g, GeeLazy** lazy, gpointer self) {
	GeeTraversableStream result;
	result = __lambda16_ (self, state, g, lazy);
#line 355 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return result;
#line 2650 "traversable.c"
}


static GeeIterator* gee_traversable_real_flat_map (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFlatMapFunc f, void* f_target, GDestroyNotify f_target_destroy_notify) {
	GeeIterator* result = NULL;
	Block20Data* _data20_;
	GeeFlatMapFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	GeeIterator* _tmp1_ = NULL;
#line 353 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data20_ = g_slice_new0 (Block20Data);
#line 353 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data20_->_ref_count_ = 1;
#line 353 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data20_->self = g_object_ref (self);
#line 353 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data20_->a_type = a_type;
#line 353 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data20_->a_dup_func = a_dup_func;
#line 353 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data20_->a_destroy_func = a_destroy_func;
#line 353 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp0_ = f;
#line 353 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp0__target = f_target;
#line 353 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	(_data20_->f_target_destroy_notify == NULL) ? NULL : (_data20_->f_target_destroy_notify (_data20_->f_target), NULL);
#line 353 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data20_->f = NULL;
#line 353 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data20_->f_target = NULL;
#line 353 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data20_->f_target_destroy_notify = NULL;
#line 353 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data20_->f = _tmp0_;
#line 353 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data20_->f_target = _tmp0__target;
#line 353 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data20_->f_target_destroy_notify = f_target_destroy_notify;
#line 354 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data20_->current = NULL;
#line 355 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp1_ = gee_traversable_stream (self, a_type, (GBoxedCopyFunc) a_dup_func, a_destroy_func, ___lambda16__gee_stream_func, block20_data_ref (_data20_), block20_data_unref);
#line 355 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	result = _tmp1_;
#line 355 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	block20_data_unref (_data20_);
#line 355 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data20_ = NULL;
#line 355 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return result;
#line 2702 "traversable.c"
}


GeeIterator* gee_traversable_flat_map (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFlatMapFunc f, void* f_target, GDestroyNotify f_target_destroy_notify) {
#line 353 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 353 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return GEE_TRAVERSABLE_GET_INTERFACE (self)->flat_map (self, a_type, a_dup_func, a_destroy_func, f, f_target, f_target_destroy_notify);
#line 2711 "traversable.c"
}


/**
 * Splits the traversable into multiple ones, caching the result if needed.
 *
 * Note: In {@link Iterator} implementation using the parent iterator is
 *   not allowed. However if any of the forked iterators {@link next}
 *   return false then it is treated as if the parent iterator
 *   {@link next} returned false.
 *
 * Note: The returned arrey might contain parent iterator if it is allowed
 *   by implementation. For example the iteration over collection does
 *   not need to generate and cache the results.
 *
 * Note: the resulting iterators does not need to be thread safe.
 *
 * @param forks Number of iterators in array
 * @returns An array with created iterators
 * @since 0.11.5
 */
static Block22Data* block22_data_ref (Block22Data* _data22_) {
#line 406 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	g_atomic_int_inc (&_data22_->_ref_count_);
#line 406 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return _data22_;
#line 2738 "traversable.c"
}


static void block22_data_unref (void * _userdata_) {
	Block22Data* _data22_;
	_data22_ = (Block22Data*) _userdata_;
#line 406 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	if (g_atomic_int_dec_and_test (&_data22_->_ref_count_)) {
#line 2747 "traversable.c"
		GeeTraversable * self;
#line 406 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		self = _data22_->self;
#line 406 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_g_object_unref0 (self);
#line 406 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		g_slice_free (Block22Data, _data22_);
#line 2755 "traversable.c"
	}
}


static gpointer _g_object_ref0 (gpointer self) {
#line 414 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return self ? g_object_ref (self) : NULL;
#line 2763 "traversable.c"
}


static gpointer ______lambda20_ (Block22Data* _data22_) {
	GeeTraversable * self;
	gpointer result = NULL;
	GeeIterator* _tmp0_ = NULL;
	gpointer _tmp1_ = NULL;
#line 420 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	self = _data22_->self;
#line 420 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp0_ = _data22_->_self_;
#line 420 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp1_ = gee_iterator_get (_tmp0_);
#line 420 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	result = _tmp1_;
#line 420 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return result;
#line 2782 "traversable.c"
}


static gpointer _______lambda20__gee_lazy_func (gpointer self) {
	gpointer result;
	result = ______lambda20_ (self);
#line 420 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return result;
#line 2791 "traversable.c"
}


static GeeIterator** gee_traversable_real_tee (GeeTraversable* self, guint forks, int* result_length1) {
	GeeIterator** result = NULL;
	Block22Data* _data22_;
	GeeIterable* iself = NULL;
	GeeIterator* _tmp0_ = NULL;
#line 406 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data22_ = g_slice_new0 (Block22Data);
#line 406 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data22_->_ref_count_ = 1;
#line 406 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data22_->self = g_object_ref (self);
#line 410 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data22_->_self_ = G_TYPE_CHECK_INSTANCE_TYPE (self, GEE_TYPE_ITERATOR) ? ((GeeIterator*) self) : NULL;
#line 410 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp0_ = _data22_->_self_;
#line 410 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	if (_tmp0_ != NULL) {
#line 2812 "traversable.c"
		guint _tmp1_ = 0U;
#line 411 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_tmp1_ = forks;
#line 411 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		if (_tmp1_ == ((guint) 0)) {
#line 2818 "traversable.c"
			GeeIterator** _tmp2_ = NULL;
			GeeIterator** _tmp3_ = NULL;
			gint _tmp3__length1 = 0;
#line 412 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_tmp2_ = g_new0 (GeeIterator*, 0 + 1);
#line 412 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_tmp3_ = _tmp2_;
#line 412 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_tmp3__length1 = 0;
#line 412 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			if (result_length1) {
#line 412 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				*result_length1 = _tmp3__length1;
#line 2832 "traversable.c"
			}
#line 412 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			result = _tmp3_;
#line 412 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			block22_data_unref (_data22_);
#line 412 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_data22_ = NULL;
#line 412 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			return result;
#line 2842 "traversable.c"
		} else {
			guint _tmp4_ = 0U;
#line 413 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_tmp4_ = forks;
#line 413 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			if (_tmp4_ == ((guint) 1)) {
#line 2849 "traversable.c"
				GeeIterator* _tmp5_ = NULL;
				GeeIterator* _tmp6_ = NULL;
				GeeIterator** _tmp7_ = NULL;
				GeeIterator** _tmp8_ = NULL;
				gint _tmp8__length1 = 0;
#line 414 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_tmp5_ = _data22_->_self_;
#line 414 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_tmp6_ = _g_object_ref0 (_tmp5_);
#line 414 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_tmp7_ = g_new0 (GeeIterator*, 1 + 1);
#line 414 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_tmp7_[0] = _tmp6_;
#line 414 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_tmp8_ = _tmp7_;
#line 414 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_tmp8__length1 = 1;
#line 414 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				if (result_length1) {
#line 414 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					*result_length1 = _tmp8__length1;
#line 2871 "traversable.c"
				}
#line 414 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				result = _tmp8_;
#line 414 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				block22_data_unref (_data22_);
#line 414 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_data22_ = NULL;
#line 414 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				return result;
#line 2881 "traversable.c"
			} else {
				GeeIterator** _result_ = NULL;
				guint _tmp9_ = 0U;
				GeeIterator** _tmp10_ = NULL;
				gint _result__length1 = 0;
				gint __result__size_ = 0;
				GeeLazy* data = NULL;
				gboolean is_valid = FALSE;
				GeeIterator* _tmp11_ = NULL;
				gboolean _tmp12_ = FALSE;
				gboolean _tmp13_ = FALSE;
				gboolean _tmp14_ = FALSE;
				GeeTeeIteratorNode* head = NULL;
				GeeLazy* _tmp17_ = NULL;
				GeeLazy* _tmp18_ = NULL;
				GeeIterator* _tmp19_ = NULL;
				GeeLazy* _tmp20_ = NULL;
				GeeLazy* _tmp21_ = NULL;
				GeeTeeIteratorNode* _tmp22_ = NULL;
				GeeIterator** _tmp34_ = NULL;
				gint _tmp34__length1 = 0;
#line 416 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_tmp9_ = forks;
#line 416 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_tmp10_ = g_new0 (GeeIterator*, _tmp9_ + 1);
#line 416 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_result_ = _tmp10_;
#line 416 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_result__length1 = _tmp9_;
#line 416 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				__result__size_ = _result__length1;
#line 418 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_tmp11_ = _data22_->_self_;
#line 418 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_tmp12_ = gee_iterator_get_valid (_tmp11_);
#line 418 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_tmp13_ = _tmp12_;
#line 418 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				is_valid = _tmp13_;
#line 419 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_tmp14_ = is_valid;
#line 419 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				if (_tmp14_) {
#line 2925 "traversable.c"
					GeeLazy* _tmp15_ = NULL;
#line 420 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					_tmp15_ = gee_lazy_new (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_type (self), (GBoxedCopyFunc) GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_dup_func (self), GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self), _______lambda20__gee_lazy_func, block22_data_ref (_data22_), block22_data_unref);
#line 420 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					_gee_lazy_unref0 (data);
#line 420 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					data = _tmp15_;
#line 2933 "traversable.c"
				} else {
					GeeLazy* _tmp16_ = NULL;
#line 422 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					_tmp16_ = gee_lazy_new_from_value (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_type (self), (GBoxedCopyFunc) GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_dup_func (self), GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self), NULL);
#line 422 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					_gee_lazy_unref0 (data);
#line 422 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					data = _tmp16_;
#line 2942 "traversable.c"
				}
#line 424 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_tmp17_ = data;
#line 424 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_tmp18_ = _gee_lazy_ref0 (_tmp17_);
#line 424 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_tmp19_ = _data22_->_self_;
#line 424 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_tmp20_ = data;
#line 424 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_tmp21_ = gee_tee_iterator_create_nodes (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_type (self), (GBoxedCopyFunc) GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_dup_func (self), GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self), _tmp19_, _tmp20_);
#line 424 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_tmp22_ = gee_tee_iterator_node_new (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_type (self), (GBoxedCopyFunc) GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_dup_func (self), GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self), _tmp18_, _tmp21_);
#line 424 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				head = _tmp22_;
#line 2958 "traversable.c"
				{
					guint i = 0U;
#line 425 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					i = (guint) 0;
#line 2963 "traversable.c"
					{
						gboolean _tmp23_ = FALSE;
#line 425 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
						_tmp23_ = TRUE;
#line 425 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
						while (TRUE) {
#line 2970 "traversable.c"
							gboolean _tmp24_ = FALSE;
							guint _tmp26_ = 0U;
							guint _tmp27_ = 0U;
							GeeIterator** _tmp28_ = NULL;
							gint _tmp28__length1 = 0;
							guint _tmp29_ = 0U;
							GeeTeeIteratorNode* _tmp30_ = NULL;
							gboolean _tmp31_ = FALSE;
							GeeTeeIterator* _tmp32_ = NULL;
							GeeIterator* _tmp33_ = NULL;
#line 425 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
							_tmp24_ = _tmp23_;
#line 425 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
							if (!_tmp24_) {
#line 2985 "traversable.c"
								guint _tmp25_ = 0U;
#line 425 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
								_tmp25_ = i;
#line 425 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
								i = _tmp25_ + 1;
#line 2991 "traversable.c"
							}
#line 425 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
							_tmp23_ = FALSE;
#line 425 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
							_tmp26_ = i;
#line 425 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
							_tmp27_ = forks;
#line 425 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
							if (!(_tmp26_ < _tmp27_)) {
#line 425 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
								break;
#line 3003 "traversable.c"
							}
#line 426 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
							_tmp28_ = _result_;
#line 426 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
							_tmp28__length1 = _result__length1;
#line 426 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
							_tmp29_ = i;
#line 426 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
							_tmp30_ = head;
#line 426 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
							_tmp31_ = is_valid;
#line 426 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
							_tmp32_ = gee_tee_iterator_new (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_type (self), (GBoxedCopyFunc) GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_dup_func (self), GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self), _tmp30_, _tmp31_);
#line 426 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
							_g_object_unref0 (_tmp28_[_tmp29_]);
#line 426 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
							_tmp28_[_tmp29_] = (GeeIterator*) _tmp32_;
#line 426 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
							_tmp33_ = _tmp28_[_tmp29_];
#line 3023 "traversable.c"
						}
					}
				}
#line 428 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_tmp34_ = _result_;
#line 428 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_tmp34__length1 = _result__length1;
#line 428 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				if (result_length1) {
#line 428 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					*result_length1 = _tmp34__length1;
#line 3035 "traversable.c"
				}
#line 428 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				result = _tmp34_;
#line 428 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_gee_tee_iterator_node_unref0 (head);
#line 428 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_gee_lazy_unref0 (data);
#line 428 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				block22_data_unref (_data22_);
#line 428 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_data22_ = NULL;
#line 428 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				return result;
#line 3049 "traversable.c"
			}
		}
	} else {
		GeeIterable* _tmp35_ = NULL;
#line 430 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		iself = G_TYPE_CHECK_INSTANCE_TYPE (self, GEE_TYPE_ITERABLE) ? ((GeeIterable*) self) : NULL;
#line 430 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_tmp35_ = iself;
#line 430 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		if (_tmp35_ != NULL) {
#line 3060 "traversable.c"
			GeeIterator** _result_ = NULL;
			guint _tmp36_ = 0U;
			GeeIterator** _tmp37_ = NULL;
			gint _result__length1 = 0;
			gint __result__size_ = 0;
			GeeIterator** _tmp48_ = NULL;
			gint _tmp48__length1 = 0;
#line 431 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_tmp36_ = forks;
#line 431 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_tmp37_ = g_new0 (GeeIterator*, _tmp36_ + 1);
#line 431 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_result_ = _tmp37_;
#line 431 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_result__length1 = _tmp36_;
#line 431 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			__result__size_ = _result__length1;
#line 3078 "traversable.c"
			{
				guint i = 0U;
#line 432 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				i = (guint) 0;
#line 3083 "traversable.c"
				{
					gboolean _tmp38_ = FALSE;
#line 432 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					_tmp38_ = TRUE;
#line 432 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					while (TRUE) {
#line 3090 "traversable.c"
						gboolean _tmp39_ = FALSE;
						guint _tmp41_ = 0U;
						guint _tmp42_ = 0U;
						GeeIterator** _tmp43_ = NULL;
						gint _tmp43__length1 = 0;
						guint _tmp44_ = 0U;
						GeeIterable* _tmp45_ = NULL;
						GeeIterator* _tmp46_ = NULL;
						GeeIterator* _tmp47_ = NULL;
#line 432 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
						_tmp39_ = _tmp38_;
#line 432 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
						if (!_tmp39_) {
#line 3104 "traversable.c"
							guint _tmp40_ = 0U;
#line 432 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
							_tmp40_ = i;
#line 432 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
							i = _tmp40_ + 1;
#line 3110 "traversable.c"
						}
#line 432 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
						_tmp38_ = FALSE;
#line 432 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
						_tmp41_ = i;
#line 432 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
						_tmp42_ = forks;
#line 432 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
						if (!(_tmp41_ < _tmp42_)) {
#line 432 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
							break;
#line 3122 "traversable.c"
						}
#line 433 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
						_tmp43_ = _result_;
#line 433 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
						_tmp43__length1 = _result__length1;
#line 433 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
						_tmp44_ = i;
#line 433 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
						_tmp45_ = iself;
#line 433 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
						_tmp46_ = gee_iterable_iterator (_tmp45_);
#line 433 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
						_g_object_unref0 (_tmp43_[_tmp44_]);
#line 433 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
						_tmp43_[_tmp44_] = _tmp46_;
#line 433 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
						_tmp47_ = _tmp43_[_tmp44_];
#line 3140 "traversable.c"
					}
				}
			}
#line 435 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_tmp48_ = _result_;
#line 435 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_tmp48__length1 = _result__length1;
#line 435 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			if (result_length1) {
#line 435 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				*result_length1 = _tmp48__length1;
#line 3152 "traversable.c"
			}
#line 435 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			result = _tmp48_;
#line 435 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			block22_data_unref (_data22_);
#line 435 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_data22_ = NULL;
#line 435 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			return result;
#line 3162 "traversable.c"
		} else {
#line 437 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			g_assert_not_reached ();
#line 3166 "traversable.c"
		}
	}
#line 406 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	block22_data_unref (_data22_);
#line 406 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data22_ = NULL;
#line 3173 "traversable.c"
}


GeeIterator** gee_traversable_tee (GeeTraversable* self, guint forks, int* result_length1) {
#line 406 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 406 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return GEE_TRAVERSABLE_GET_INTERFACE (self)->tee (self, forks, result_length1);
#line 3182 "traversable.c"
}


GType gee_traversable_get_element_type (GeeTraversable* self) {
#line 331 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	g_return_val_if_fail (self != NULL, 0UL);
#line 331 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return GEE_TRAVERSABLE_GET_INTERFACE (self)->get_element_type (self);
#line 3191 "traversable.c"
}


static GType gee_traversable_real_get_element_type (GeeTraversable* base) {
	GType result;
	GeeTraversable* self;
#line 331 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	self = base;
#line 331 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	result = GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_type (self);
#line 331 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return result;
#line 3204 "traversable.c"
}


static void gee_traversable_base_init (GeeTraversableIface * iface) {
#line 53 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	static gboolean initialized = FALSE;
#line 53 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	if (!initialized) {
#line 53 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		initialized = TRUE;
#line 53 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		iface->stream = gee_traversable_real_stream;
#line 53 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		iface->fold = gee_traversable_real_fold;
#line 53 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		iface->map = gee_traversable_real_map;
#line 53 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		iface->scan = gee_traversable_real_scan;
#line 53 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		iface->filter = gee_traversable_real_filter;
#line 53 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		iface->chop = gee_traversable_real_chop;
#line 53 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		iface->flat_map = gee_traversable_real_flat_map;
#line 53 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		iface->tee = gee_traversable_real_tee;
#line 53 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		iface->get_element_type = gee_traversable_real_get_element_type;
#line 3233 "traversable.c"
	}
}


/**
 * It's a common interface for {@link Iterator} and {@link Iterable}. It
 * provides a fast, high level functions.
 *
 * ''{@link Iterator} implementation:'' Please note that most of the functions
 * affect the state of the iterator by moving it forward.
 * Even if the iterator is {@link BidirIterator} it ''must not''
 * rewind the state.
 *
 * ''{@link Iterable} implementation:'' validy ({@link Iterator.valid})
 * of returned iterator is the same as for invalid
 * iterator. In other words the following code is semantically equivalent:
 *
 * {{{
 *     var x = iterable.function (args);
 *     var x = iterable.iterator ().function(args);
 * }}}
 *
 * @since 0.7.0
 */
GType gee_traversable_get_type (void) {
	static volatile gsize gee_traversable_type_id__volatile = 0;
	if (g_once_init_enter (&gee_traversable_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeTraversableIface), (GBaseInitFunc) gee_traversable_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType gee_traversable_type_id;
		gee_traversable_type_id = g_type_register_static (G_TYPE_INTERFACE, "GeeTraversable", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (gee_traversable_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&gee_traversable_type_id__volatile, gee_traversable_type_id);
	}
	return gee_traversable_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



