/* baobab-chart.c generated by valac 0.21.1.1-0d6f3, the Vala compiler
 * generated from baobab-chart.vala, do not modify */

/* -*- tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* Baobab - disk usage analyzer
 *
 * Copyright (C) 2006, 2007, 2008  Igalia
 * Copyright (C) 2013  Stefano Facchini <stefano.facchini@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301  USA
 *
 * Authors of the original code:
 *   Felipe Erias <femorandeira@igalia.com>
 *   Pablo Santamaria <psantamaria@igalia.com>
 *   Jacobo Aragunde <jaragunde@igalia.com>
 *   Eduardo Lima <elima@igalia.com>
 *   Mario Sanchez <msanchez@igalia.com>
 *   Miguel Gomez <magomez@igalia.com>
 *   Henrique Ferreiro <hferreiro@igalia.com>
 *   Alejandro Pinheiro <apinheiro@igalia.com>
 *   Carlos Sanmartin <csanmartin@igalia.com>
 *   Alejandro Garcia <alex@igalia.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <cairo.h>
#include <gio/gio.h>
#include <gobject/gvaluecollector.h>


#define BAOBAB_TYPE_CHART_ITEM (baobab_chart_item_get_type ())
#define BAOBAB_CHART_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BAOBAB_TYPE_CHART_ITEM, BaobabChartItem))
#define BAOBAB_CHART_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BAOBAB_TYPE_CHART_ITEM, BaobabChartItemClass))
#define BAOBAB_IS_CHART_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAOBAB_TYPE_CHART_ITEM))
#define BAOBAB_IS_CHART_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BAOBAB_TYPE_CHART_ITEM))
#define BAOBAB_CHART_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BAOBAB_TYPE_CHART_ITEM, BaobabChartItemClass))

typedef struct _BaobabChartItem BaobabChartItem;
typedef struct _BaobabChartItemClass BaobabChartItemClass;
typedef struct _BaobabChartItemPrivate BaobabChartItemPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _BaobabParamSpecChartItem BaobabParamSpecChartItem;

#define BAOBAB_TYPE_CHART (baobab_chart_get_type ())
#define BAOBAB_CHART(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BAOBAB_TYPE_CHART, BaobabChart))
#define BAOBAB_CHART_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BAOBAB_TYPE_CHART, BaobabChartClass))
#define BAOBAB_IS_CHART(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAOBAB_TYPE_CHART))
#define BAOBAB_IS_CHART_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BAOBAB_TYPE_CHART))
#define BAOBAB_CHART_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BAOBAB_TYPE_CHART, BaobabChartClass))

typedef struct _BaobabChart BaobabChart;
typedef struct _BaobabChartClass BaobabChartClass;
typedef struct _BaobabChartPrivate BaobabChartPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__baobab_chart_item_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__baobab_chart_item_unref0_ (var), NULL)))
#define _gtk_tree_row_reference_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_row_reference_free (var), NULL)))
#define _baobab_chart_item_unref0(var) ((var == NULL) ? NULL : (var = (baobab_chart_item_unref (var), NULL)))
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))

#define BAOBAB_TYPE_WINDOW (baobab_window_get_type ())
#define BAOBAB_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BAOBAB_TYPE_WINDOW, BaobabWindow))
#define BAOBAB_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BAOBAB_TYPE_WINDOW, BaobabWindowClass))
#define BAOBAB_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAOBAB_TYPE_WINDOW))
#define BAOBAB_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BAOBAB_TYPE_WINDOW))
#define BAOBAB_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BAOBAB_TYPE_WINDOW, BaobabWindowClass))

typedef struct _BaobabWindow BaobabWindow;
typedef struct _BaobabWindowClass BaobabWindowClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _BaobabChartItem {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BaobabChartItemPrivate * priv;
	gchar* name;
	gchar* size;
	guint depth;
	gdouble rel_start;
	gdouble rel_size;
	GtkTreeIter iter;
	gboolean visible;
	gboolean has_any_child;
	gboolean has_visible_children;
	GdkRectangle rect;
	GList* parent;
};

struct _BaobabChartItemClass {
	GTypeClass parent_class;
	void (*finalize) (BaobabChartItem *self);
};

struct _BaobabParamSpecChartItem {
	GParamSpec parent_instance;
};

struct _BaobabChart {
	GtkWidget parent_instance;
	BaobabChartPrivate * priv;
};

struct _BaobabChartClass {
	GtkWidgetClass parent_class;
	void (*post_draw) (BaobabChart* self, cairo_t* cr);
	void (*draw_item) (BaobabChart* self, cairo_t* cr, BaobabChartItem* item, gboolean highlighted);
	void (*calculate_item_geometry) (BaobabChart* self, BaobabChartItem* item);
	gboolean (*is_point_over_item) (BaobabChart* self, BaobabChartItem* item, gdouble x, gdouble y);
	void (*get_item_rectangle) (BaobabChart* self, BaobabChartItem* item);
	gboolean (*can_zoom_in) (BaobabChart* self);
	gboolean (*can_zoom_out) (BaobabChart* self);
	BaobabChartItem* (*create_new_chartitem) (BaobabChart* self);
	void (*item_activated) (BaobabChart* self, GtkTreeIter* iter);
};

struct _BaobabChartPrivate {
	guint name_column;
	guint size_column;
	guint info_column;
	guint percentage_column;
	guint valid_column;
	gboolean model_changed;
	GtkMenu* context_menu;
	GList* items;
	guint max_depth_;
	GtkTreeModel* model_;
	GtkTreeRowReference* root_;
	BaobabChartItem* highlighted_item_;
	GSimpleActionGroup* action_group;
};


static gpointer baobab_chart_item_parent_class = NULL;
static gpointer baobab_chart_parent_class = NULL;

gpointer baobab_chart_item_ref (gpointer instance);
void baobab_chart_item_unref (gpointer instance);
GParamSpec* baobab_param_spec_chart_item (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void baobab_value_set_chart_item (GValue* value, gpointer v_object);
void baobab_value_take_chart_item (GValue* value, gpointer v_object);
gpointer baobab_value_get_chart_item (const GValue* value);
GType baobab_chart_item_get_type (void) G_GNUC_CONST;
enum  {
	BAOBAB_CHART_ITEM_DUMMY_PROPERTY
};
BaobabChartItem* baobab_chart_item_construct (GType object_type);
static void baobab_chart_item_finalize (BaobabChartItem* obj);
GType baobab_chart_get_type (void) G_GNUC_CONST;
#define BAOBAB_CHART_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BAOBAB_TYPE_CHART, BaobabChartPrivate))
enum  {
	BAOBAB_CHART_DUMMY_PROPERTY,
	BAOBAB_CHART_MAX_DEPTH,
	BAOBAB_CHART_MODEL,
	BAOBAB_CHART_ROOT,
	BAOBAB_CHART_HIGHLIGHTED_ITEM
};
static void _baobab_chart_item_unref0_ (gpointer var);
static void _g_list_free__baobab_chart_item_unref0_ (GList* self);
#define BAOBAB_CHART_MAX_DEPTH ((guint) 5)
#define BAOBAB_CHART_MIN_DEPTH ((guint) 1)
void baobab_chart_open_file (BaobabChart* self);
static void _baobab_chart_open_file_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void baobab_chart_copy_path (BaobabChart* self);
static void _baobab_chart_copy_path_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void baobab_chart_trash_file (BaobabChart* self);
static void _baobab_chart_trash_file_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void baobab_chart_move_up_root (BaobabChart* self);
static void _baobab_chart_move_up_root_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void baobab_chart_zoom_in (BaobabChart* self);
static void _baobab_chart_zoom_in_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void baobab_chart_zoom_out (BaobabChart* self);
static void _baobab_chart_zoom_out_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void baobab_chart_set_model_with_columns (BaobabChart* self, GtkTreeModel* m, guint name_column_, guint size_column_, guint info_column_, guint percentage_column_, guint valid_column_, GtkTreePath* r);
void baobab_chart_set_model (BaobabChart* self, GtkTreeModel* value);
void baobab_chart_set_root (BaobabChart* self, GtkTreePath* value);
void baobab_chart_post_draw (BaobabChart* self, cairo_t* cr);
static void baobab_chart_real_post_draw (BaobabChart* self, cairo_t* cr);
void baobab_chart_draw_item (BaobabChart* self, cairo_t* cr, BaobabChartItem* item, gboolean highlighted);
static void baobab_chart_real_draw_item (BaobabChart* self, cairo_t* cr, BaobabChartItem* item, gboolean highlighted);
void baobab_chart_calculate_item_geometry (BaobabChart* self, BaobabChartItem* item);
static void baobab_chart_real_calculate_item_geometry (BaobabChart* self, BaobabChartItem* item);
gboolean baobab_chart_is_point_over_item (BaobabChart* self, BaobabChartItem* item, gdouble x, gdouble y);
static gboolean baobab_chart_real_is_point_over_item (BaobabChart* self, BaobabChartItem* item, gdouble x, gdouble y);
void baobab_chart_get_item_rectangle (BaobabChart* self, BaobabChartItem* item);
static void baobab_chart_real_get_item_rectangle (BaobabChart* self, BaobabChartItem* item);
gboolean baobab_chart_can_zoom_in (BaobabChart* self);
static gboolean baobab_chart_real_can_zoom_in (BaobabChart* self);
gboolean baobab_chart_can_zoom_out (BaobabChart* self);
static gboolean baobab_chart_real_can_zoom_out (BaobabChart* self);
BaobabChartItem* baobab_chart_create_new_chartitem (BaobabChart* self);
static BaobabChartItem* baobab_chart_real_create_new_chartitem (BaobabChart* self);
static void baobab_chart_real_realize (GtkWidget* base);
static void baobab_chart_real_size_allocate (GtkWidget* base, GtkAllocation* allocation);
static gboolean baobab_chart_highlight_item_at_point (BaobabChart* self, gdouble x, gdouble y);
void baobab_chart_set_highlighted_item (BaobabChart* self, BaobabChartItem* value);
static gboolean baobab_chart_real_motion_notify_event (GtkWidget* base, GdkEventMotion* event);
static gboolean baobab_chart_real_leave_notify_event (GtkWidget* base, GdkEventCrossing* event);
static GList* baobab_chart_add_item (BaobabChart* self, guint depth, gdouble rel_start, gdouble rel_size, GtkTreeIter* iter);
GtkTreeModel* baobab_chart_get_model (BaobabChart* self);
static void baobab_chart_get_items (BaobabChart* self, GtkTreePath* root_path);
guint baobab_chart_get_max_depth (BaobabChart* self);
static void baobab_chart_draw_chart (BaobabChart* self, cairo_t* cr);
BaobabChartItem* baobab_chart_get_highlighted_item (BaobabChart* self);
static void baobab_chart_update_draw (BaobabChart* self, GtkTreePath* path);
GtkTreePath* baobab_chart_get_root (BaobabChart* self);
static void baobab_chart_row_changed (BaobabChart* self, GtkTreeModel* model, GtkTreePath* path, GtkTreeIter* iter);
static void baobab_chart_row_inserted (BaobabChart* self, GtkTreeModel* model, GtkTreePath* path, GtkTreeIter* iter);
static void baobab_chart_row_deleted (BaobabChart* self, GtkTreeModel* model, GtkTreePath* path);
static void baobab_chart_row_has_child_toggled (BaobabChart* self, GtkTreeModel* model, GtkTreePath* path, GtkTreeIter* iter);
static void baobab_chart_rows_reordered (BaobabChart* self, GtkTreeModel* model, GtkTreePath* path, GtkTreeIter* iter, void* new_order);
static gboolean baobab_chart_real_draw (GtkWidget* base, cairo_t* cr);
static void baobab_chart_interpolate_colors (BaobabChart* self, GdkRGBA* colora, GdkRGBA* colorb, gdouble percentage, GdkRGBA* result);
void baobab_chart_get_item_color (BaobabChart* self, gdouble rel_position, guint depth, gboolean highlighted, GdkRGBA* result);
static gboolean baobab_chart_real_button_press_event (GtkWidget* base, GdkEventButton* event);
static void baobab_chart_show_popup_menu (BaobabChart* self, GdkEventButton* event);
static gboolean baobab_chart_real_scroll_event (GtkWidget* base, GdkEventScroll* event);
GType baobab_window_get_type (void) G_GNUC_CONST;
void baobab_window_open_item (BaobabWindow* self, GtkTreeIter* iter);
void baobab_window_copy_path (BaobabWindow* self, GtkTreeIter* iter);
void baobab_window_trash_file (BaobabWindow* self, GtkTreeIter* iter);
void baobab_chart_set_max_depth (BaobabChart* self, guint value);
static void baobab_chart_build_context_menu (BaobabChart* self);
static void baobab_chart_connect_model_signals (BaobabChart* self, GtkTreeModel* m);
static void _baobab_chart_row_changed_gtk_tree_model_row_changed (GtkTreeModel* _sender, GtkTreePath* path, GtkTreeIter* iter, gpointer self);
static void _baobab_chart_row_inserted_gtk_tree_model_row_inserted (GtkTreeModel* _sender, GtkTreePath* path, GtkTreeIter* iter, gpointer self);
static void _baobab_chart_row_has_child_toggled_gtk_tree_model_row_has_child_toggled (GtkTreeModel* _sender, GtkTreePath* path, GtkTreeIter* iter, gpointer self);
static void _baobab_chart_row_deleted_gtk_tree_model_row_deleted (GtkTreeModel* _sender, GtkTreePath* path, gpointer self);
static void _baobab_chart_rows_reordered_gtk_tree_model_rows_reordered (GtkTreeModel* _sender, GtkTreePath* path, GtkTreeIter* iter, void* new_order, gpointer self);
static void baobab_chart_disconnect_model_signals (BaobabChart* self, GtkTreeModel* m);
static gboolean baobab_chart_real_query_tooltip (GtkWidget* base, gint x, gint y, gboolean keyboard_tooltip, GtkTooltip* tooltip);
BaobabChart* baobab_chart_construct (GType object_type);
static void baobab_chart_real_item_activated (BaobabChart* self, GtkTreeIter* iter);
static void g_cclosure_user_marshal_VOID__BOXED (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static GObject * baobab_chart_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void baobab_chart_finalize (GObject* obj);
static void _vala_baobab_chart_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_baobab_chart_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);

static const GdkRGBA BAOBAB_CHART_TANGO_COLORS[6] = {{0.94, 0.16, 0.16, 1.0}, {0.68, 0.49, 0.66, 1.0}, {0.45, 0.62, 0.82, 1.0}, {0.54, 0.89, 0.20, 1.0}, {0.91, 0.73, 0.43, 1.0}, {0.99, 0.68, 0.25, 1.0}};
static const GActionEntry BAOBAB_CHART_action_entries[6] = {{"open-file", _baobab_chart_open_file_gsimple_action_activate_callback}, {"copy-path", _baobab_chart_copy_path_gsimple_action_activate_callback}, {"trash-file", _baobab_chart_trash_file_gsimple_action_activate_callback}, {"move-up", _baobab_chart_move_up_root_gsimple_action_activate_callback}, {"zoom-in", _baobab_chart_zoom_in_gsimple_action_activate_callback}, {"zoom-out", _baobab_chart_zoom_out_gsimple_action_activate_callback}};

BaobabChartItem* baobab_chart_item_construct (GType object_type) {
	BaobabChartItem* self = NULL;
	self = (BaobabChartItem*) g_type_create_instance (object_type);
	return self;
}


static void baobab_value_chart_item_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void baobab_value_chart_item_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		baobab_chart_item_unref (value->data[0].v_pointer);
	}
}


static void baobab_value_chart_item_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = baobab_chart_item_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer baobab_value_chart_item_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* baobab_value_chart_item_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		BaobabChartItem* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = baobab_chart_item_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* baobab_value_chart_item_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	BaobabChartItem** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = baobab_chart_item_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* baobab_param_spec_chart_item (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	BaobabParamSpecChartItem* spec;
	g_return_val_if_fail (g_type_is_a (object_type, BAOBAB_TYPE_CHART_ITEM), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer baobab_value_get_chart_item (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BAOBAB_TYPE_CHART_ITEM), NULL);
	return value->data[0].v_pointer;
}


void baobab_value_set_chart_item (GValue* value, gpointer v_object) {
	BaobabChartItem* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BAOBAB_TYPE_CHART_ITEM));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BAOBAB_TYPE_CHART_ITEM));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		baobab_chart_item_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		baobab_chart_item_unref (old);
	}
}


void baobab_value_take_chart_item (GValue* value, gpointer v_object) {
	BaobabChartItem* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BAOBAB_TYPE_CHART_ITEM));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BAOBAB_TYPE_CHART_ITEM));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		baobab_chart_item_unref (old);
	}
}


static void baobab_chart_item_class_init (BaobabChartItemClass * klass) {
	baobab_chart_item_parent_class = g_type_class_peek_parent (klass);
	BAOBAB_CHART_ITEM_CLASS (klass)->finalize = baobab_chart_item_finalize;
}


static void baobab_chart_item_instance_init (BaobabChartItem * self) {
	self->ref_count = 1;
}


static void baobab_chart_item_finalize (BaobabChartItem* obj) {
	BaobabChartItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BAOBAB_TYPE_CHART_ITEM, BaobabChartItem);
	_g_free0 (self->name);
	_g_free0 (self->size);
}


GType baobab_chart_item_get_type (void) {
	static volatile gsize baobab_chart_item_type_id__volatile = 0;
	if (g_once_init_enter (&baobab_chart_item_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { baobab_value_chart_item_init, baobab_value_chart_item_free_value, baobab_value_chart_item_copy_value, baobab_value_chart_item_peek_pointer, "p", baobab_value_chart_item_collect_value, "p", baobab_value_chart_item_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (BaobabChartItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) baobab_chart_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BaobabChartItem), 0, (GInstanceInitFunc) baobab_chart_item_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType baobab_chart_item_type_id;
		baobab_chart_item_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BaobabChartItem", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&baobab_chart_item_type_id__volatile, baobab_chart_item_type_id);
	}
	return baobab_chart_item_type_id__volatile;
}


gpointer baobab_chart_item_ref (gpointer instance) {
	BaobabChartItem* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void baobab_chart_item_unref (gpointer instance) {
	BaobabChartItem* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BAOBAB_CHART_ITEM_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _baobab_chart_item_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (baobab_chart_item_unref (var), NULL));
}


static void _g_list_free__baobab_chart_item_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _baobab_chart_item_unref0_, NULL);
	g_list_free (self);
}


static void _baobab_chart_open_file_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	baobab_chart_open_file (self);
}


static void _baobab_chart_copy_path_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	baobab_chart_copy_path (self);
}


static void _baobab_chart_trash_file_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	baobab_chart_trash_file (self);
}


static void _baobab_chart_move_up_root_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	baobab_chart_move_up_root (self);
}


static void _baobab_chart_zoom_in_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	baobab_chart_zoom_in (self);
}


static void _baobab_chart_zoom_out_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	baobab_chart_zoom_out (self);
}


void baobab_chart_set_model_with_columns (BaobabChart* self, GtkTreeModel* m, guint name_column_, guint size_column_, guint info_column_, guint percentage_column_, guint valid_column_, GtkTreePath* r) {
	GtkTreeModel* _tmp0_ = NULL;
	GtkTreePath* _tmp1_ = NULL;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	guint _tmp5_ = 0U;
	guint _tmp6_ = 0U;
	guint _tmp7_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (m != NULL);
	_tmp0_ = m;
	baobab_chart_set_model (self, _tmp0_);
	_tmp1_ = r;
	if (_tmp1_ != NULL) {
		GtkTreePath* _tmp2_ = NULL;
		_tmp2_ = r;
		baobab_chart_set_root (self, _tmp2_);
	}
	_tmp3_ = name_column_;
	self->priv->name_column = _tmp3_;
	_tmp4_ = size_column_;
	self->priv->size_column = _tmp4_;
	_tmp5_ = info_column_;
	self->priv->info_column = _tmp5_;
	_tmp6_ = percentage_column_;
	self->priv->percentage_column = _tmp6_;
	_tmp7_ = valid_column_;
	self->priv->valid_column = _tmp7_;
}


static void baobab_chart_real_post_draw (BaobabChart* self, cairo_t* cr) {
	g_return_if_fail (cr != NULL);
}


void baobab_chart_post_draw (BaobabChart* self, cairo_t* cr) {
	g_return_if_fail (self != NULL);
	BAOBAB_CHART_GET_CLASS (self)->post_draw (self, cr);
}


static void baobab_chart_real_draw_item (BaobabChart* self, cairo_t* cr, BaobabChartItem* item, gboolean highlighted) {
	g_critical ("Type `%s' does not implement abstract method `baobab_chart_draw_item'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void baobab_chart_draw_item (BaobabChart* self, cairo_t* cr, BaobabChartItem* item, gboolean highlighted) {
	g_return_if_fail (self != NULL);
	BAOBAB_CHART_GET_CLASS (self)->draw_item (self, cr, item, highlighted);
}


static void baobab_chart_real_calculate_item_geometry (BaobabChart* self, BaobabChartItem* item) {
	g_critical ("Type `%s' does not implement abstract method `baobab_chart_calculate_item_geometry'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void baobab_chart_calculate_item_geometry (BaobabChart* self, BaobabChartItem* item) {
	g_return_if_fail (self != NULL);
	BAOBAB_CHART_GET_CLASS (self)->calculate_item_geometry (self, item);
}


static gboolean baobab_chart_real_is_point_over_item (BaobabChart* self, BaobabChartItem* item, gdouble x, gdouble y) {
	g_critical ("Type `%s' does not implement abstract method `baobab_chart_is_point_over_item'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return FALSE;
}


gboolean baobab_chart_is_point_over_item (BaobabChart* self, BaobabChartItem* item, gdouble x, gdouble y) {
	g_return_val_if_fail (self != NULL, FALSE);
	return BAOBAB_CHART_GET_CLASS (self)->is_point_over_item (self, item, x, y);
}


static void baobab_chart_real_get_item_rectangle (BaobabChart* self, BaobabChartItem* item) {
	g_critical ("Type `%s' does not implement abstract method `baobab_chart_get_item_rectangle'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void baobab_chart_get_item_rectangle (BaobabChart* self, BaobabChartItem* item) {
	g_return_if_fail (self != NULL);
	BAOBAB_CHART_GET_CLASS (self)->get_item_rectangle (self, item);
}


static gboolean baobab_chart_real_can_zoom_in (BaobabChart* self) {
	g_critical ("Type `%s' does not implement abstract method `baobab_chart_can_zoom_in'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return FALSE;
}


gboolean baobab_chart_can_zoom_in (BaobabChart* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return BAOBAB_CHART_GET_CLASS (self)->can_zoom_in (self);
}


static gboolean baobab_chart_real_can_zoom_out (BaobabChart* self) {
	g_critical ("Type `%s' does not implement abstract method `baobab_chart_can_zoom_out'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return FALSE;
}


gboolean baobab_chart_can_zoom_out (BaobabChart* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return BAOBAB_CHART_GET_CLASS (self)->can_zoom_out (self);
}


static BaobabChartItem* baobab_chart_real_create_new_chartitem (BaobabChart* self) {
	g_critical ("Type `%s' does not implement abstract method `baobab_chart_create_new_chartitem'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


BaobabChartItem* baobab_chart_create_new_chartitem (BaobabChart* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return BAOBAB_CHART_GET_CLASS (self)->create_new_chartitem (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void baobab_chart_real_realize (GtkWidget* base) {
	BaobabChart * self;
	GtkAllocation allocation = {0};
	GtkAllocation _tmp0_ = {0};
	GdkWindowAttr attributes = {0};
	GdkWindowAttr _tmp1_ = {0};
	GtkAllocation _tmp2_ = {0};
	gint _tmp3_ = 0;
	GtkAllocation _tmp4_ = {0};
	gint _tmp5_ = 0;
	GtkAllocation _tmp6_ = {0};
	gint _tmp7_ = 0;
	GtkAllocation _tmp8_ = {0};
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	GdkWindow* window = NULL;
	GdkWindow* _tmp11_ = NULL;
	GdkWindowAttr _tmp12_ = {0};
	GdkWindow* _tmp13_ = NULL;
	GdkWindow* _tmp14_ = NULL;
	GtkStyleContext* _tmp15_ = NULL;
	self = (BaobabChart*) base;
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp0_);
	allocation = _tmp0_;
	gtk_widget_set_realized ((GtkWidget*) self, TRUE);
	attributes = _tmp1_;
	attributes.window_type = GDK_WINDOW_CHILD;
	_tmp2_ = allocation;
	_tmp3_ = _tmp2_.x;
	attributes.x = _tmp3_;
	_tmp4_ = allocation;
	_tmp5_ = _tmp4_.y;
	attributes.y = _tmp5_;
	_tmp6_ = allocation;
	_tmp7_ = _tmp6_.width;
	attributes.width = _tmp7_;
	_tmp8_ = allocation;
	_tmp9_ = _tmp8_.height;
	attributes.height = _tmp9_;
	attributes.wclass = GDK_INPUT_OUTPUT;
	_tmp10_ = gtk_widget_get_events ((GtkWidget*) self);
	attributes.event_mask = ((((((_tmp10_ | GDK_EXPOSURE_MASK) | GDK_ENTER_NOTIFY_MASK) | GDK_LEAVE_NOTIFY_MASK) | GDK_BUTTON_PRESS_MASK) | GDK_POINTER_MOTION_MASK) | GDK_POINTER_MOTION_HINT_MASK) | GDK_SCROLL_MASK;
	_tmp11_ = gtk_widget_get_parent_window ((GtkWidget*) self);
	_tmp12_ = attributes;
	_tmp13_ = gdk_window_new (_tmp11_, &_tmp12_, GDK_WA_X | GDK_WA_Y);
	window = _tmp13_;
	_tmp14_ = _g_object_ref0 (window);
	gtk_widget_set_window ((GtkWidget*) self, _tmp14_);
	gdk_window_set_user_data (window, (GObject*) self);
	_tmp15_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_set_background (_tmp15_, window);
	_g_object_unref0 (window);
}


static gpointer _baobab_chart_item_ref0 (gpointer self) {
	return self ? baobab_chart_item_ref (self) : NULL;
}


static void baobab_chart_real_size_allocate (GtkWidget* base, GtkAllocation* allocation) {
	BaobabChart * self;
	GtkAllocation _tmp0_ = {0};
	gboolean _tmp1_ = FALSE;
	self = (BaobabChart*) base;
	g_return_if_fail (allocation != NULL);
	_tmp0_ = *allocation;
	gtk_widget_set_allocation ((GtkWidget*) self, &_tmp0_);
	_tmp1_ = gtk_widget_get_realized ((GtkWidget*) self);
	if (_tmp1_) {
		GdkWindow* _tmp2_ = NULL;
		GtkAllocation _tmp3_ = {0};
		gint _tmp4_ = 0;
		GtkAllocation _tmp5_ = {0};
		gint _tmp6_ = 0;
		GtkAllocation _tmp7_ = {0};
		gint _tmp8_ = 0;
		GtkAllocation _tmp9_ = {0};
		gint _tmp10_ = 0;
		GList* _tmp11_ = NULL;
		_tmp2_ = gtk_widget_get_window ((GtkWidget*) self);
		_tmp3_ = *allocation;
		_tmp4_ = _tmp3_.x;
		_tmp5_ = *allocation;
		_tmp6_ = _tmp5_.y;
		_tmp7_ = *allocation;
		_tmp8_ = _tmp7_.width;
		_tmp9_ = *allocation;
		_tmp10_ = _tmp9_.height;
		gdk_window_move_resize (_tmp2_, _tmp4_, _tmp6_, _tmp8_, _tmp10_);
		_tmp11_ = self->priv->items;
		{
			GList* item_collection = NULL;
			GList* item_it = NULL;
			item_collection = _tmp11_;
			for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
				BaobabChartItem* _tmp12_ = NULL;
				BaobabChartItem* item = NULL;
				_tmp12_ = _baobab_chart_item_ref0 ((BaobabChartItem*) item_it->data);
				item = _tmp12_;
				{
					BaobabChartItem* _tmp13_ = NULL;
					BaobabChartItem* _tmp14_ = NULL;
					BaobabChartItem* _tmp15_ = NULL;
					_tmp13_ = item;
					_tmp13_->has_visible_children = FALSE;
					_tmp14_ = item;
					_tmp14_->visible = FALSE;
					_tmp15_ = item;
					baobab_chart_calculate_item_geometry (self, _tmp15_);
					_baobab_chart_item_unref0 (item);
				}
			}
		}
	}
}


static gboolean baobab_chart_highlight_item_at_point (BaobabChart* self, gdouble x, gdouble y) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		GList* node = NULL;
		GList* _tmp0_ = NULL;
		GList* _tmp1_ = NULL;
		_tmp0_ = self->priv->items;
		_tmp1_ = g_list_last (_tmp0_);
		node = _tmp1_;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_ = FALSE;
				GList* _tmp6_ = NULL;
				BaobabChartItem* item = NULL;
				GList* _tmp7_ = NULL;
				gconstpointer _tmp8_ = NULL;
				BaobabChartItem* _tmp9_ = NULL;
				gboolean _tmp10_ = FALSE;
				BaobabChartItem* _tmp11_ = NULL;
				gboolean _tmp12_ = FALSE;
				gboolean _tmp17_ = FALSE;
				_tmp3_ = _tmp2_;
				if (!_tmp3_) {
					GList* _tmp4_ = NULL;
					GList* _tmp5_ = NULL;
					_tmp4_ = node;
					_tmp5_ = _tmp4_->prev;
					node = _tmp5_;
				}
				_tmp2_ = FALSE;
				_tmp6_ = node;
				if (!(_tmp6_ != NULL)) {
					break;
				}
				_tmp7_ = node;
				_tmp8_ = _tmp7_->data;
				_tmp9_ = _baobab_chart_item_ref0 ((BaobabChartItem*) _tmp8_);
				item = _tmp9_;
				_tmp11_ = item;
				_tmp12_ = _tmp11_->visible;
				if (_tmp12_) {
					BaobabChartItem* _tmp13_ = NULL;
					gdouble _tmp14_ = 0.0;
					gdouble _tmp15_ = 0.0;
					gboolean _tmp16_ = FALSE;
					_tmp13_ = item;
					_tmp14_ = x;
					_tmp15_ = y;
					_tmp16_ = baobab_chart_is_point_over_item (self, _tmp13_, _tmp14_, _tmp15_);
					_tmp10_ = _tmp16_;
				} else {
					_tmp10_ = FALSE;
				}
				_tmp17_ = _tmp10_;
				if (_tmp17_) {
					BaobabChartItem* _tmp18_ = NULL;
					_tmp18_ = item;
					baobab_chart_set_highlighted_item (self, _tmp18_);
					result = TRUE;
					_baobab_chart_item_unref0 (item);
					return result;
				}
				_baobab_chart_item_unref0 (item);
			}
		}
	}
	baobab_chart_set_highlighted_item (self, NULL);
	result = FALSE;
	return result;
}


static gboolean baobab_chart_real_motion_notify_event (GtkWidget* base, GdkEventMotion* event) {
	BaobabChart * self;
	gboolean result = FALSE;
	GdkEventMotion _tmp0_ = {0};
	gdouble _tmp1_ = 0.0;
	GdkEventMotion _tmp2_ = {0};
	gdouble _tmp3_ = 0.0;
	gboolean _tmp4_ = FALSE;
	GdkEventMotion _tmp5_ = {0};
	self = (BaobabChart*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = *event;
	_tmp1_ = _tmp0_.x;
	_tmp2_ = *event;
	_tmp3_ = _tmp2_.y;
	_tmp4_ = baobab_chart_highlight_item_at_point (self, _tmp1_, _tmp3_);
	gtk_widget_set_has_tooltip ((GtkWidget*) self, _tmp4_);
	_tmp5_ = *event;
	gdk_event_request_motions (&_tmp5_);
	result = FALSE;
	return result;
}


static gboolean baobab_chart_real_leave_notify_event (GtkWidget* base, GdkEventCrossing* event) {
	BaobabChart * self;
	gboolean result = FALSE;
	GtkMenu* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	self = (BaobabChart*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->context_menu;
	_tmp1_ = gtk_widget_get_visible ((GtkWidget*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		baobab_chart_set_highlighted_item (self, NULL);
	}
	result = FALSE;
	return result;
}


static GList* baobab_chart_add_item (BaobabChart* self, guint depth, gdouble rel_start, gdouble rel_size, GtkTreeIter* iter) {
	GList* result = NULL;
	gchar* name = NULL;
	guint64 size = 0ULL;
	GtkTreeModel* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeIter _tmp2_ = {0};
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	BaobabChartItem* item = NULL;
	BaobabChartItem* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	guint _tmp8_ = 0U;
	gdouble _tmp9_ = 0.0;
	gdouble _tmp10_ = 0.0;
	GtkTreeIter _tmp11_ = {0};
	BaobabChartItem* _tmp12_ = NULL;
	GList* ret = NULL;
	GList* _tmp13_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (iter != NULL, NULL);
	_tmp0_ = baobab_chart_get_model (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = *iter;
	_tmp3_ = self->priv->name_column;
	_tmp4_ = self->priv->size_column;
	gtk_tree_model_get (_tmp1_, &_tmp2_, _tmp3_, &name, _tmp4_, &size, -1, -1);
	_tmp5_ = baobab_chart_create_new_chartitem (self);
	item = _tmp5_;
	_tmp6_ = g_strdup (name);
	_g_free0 (item->name);
	item->name = _tmp6_;
	_tmp7_ = g_format_size_full (size, G_FORMAT_SIZE_DEFAULT);
	_g_free0 (item->size);
	item->size = _tmp7_;
	_tmp8_ = depth;
	item->depth = _tmp8_;
	_tmp9_ = rel_start;
	item->rel_start = _tmp9_;
	_tmp10_ = rel_size;
	item->rel_size = _tmp10_;
	item->has_any_child = FALSE;
	item->visible = FALSE;
	item->has_visible_children = FALSE;
	_tmp11_ = *iter;
	item->iter = _tmp11_;
	item->parent = NULL;
	_tmp12_ = _baobab_chart_item_ref0 (item);
	self->priv->items = g_list_prepend (self->priv->items, _tmp12_);
	_tmp13_ = self->priv->items;
	ret = _tmp13_;
	result = ret;
	_baobab_chart_item_unref0 (item);
	_g_free0 (name);
	return result;
}


static void baobab_chart_get_items (BaobabChart* self, GtkTreePath* root_path) {
	GList* node = NULL;
	GtkTreeIter initial_iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gdouble size = 0.0;
	GtkTreePath* model_root_path = NULL;
	GtkTreeIter model_root_iter = {0};
	GtkTreeIter child_iter = {0};
	GtkTreeIter _tmp1_ = {0};
	GList* child_node = NULL;
	gdouble rel_start = 0.0;
	GtkTreeModel* _tmp2_ = NULL;
	GtkTreeModel* _tmp3_ = NULL;
	GtkTreePath* _tmp4_ = NULL;
	GtkTreeIter _tmp5_ = {0};
	gboolean _tmp6_ = FALSE;
	GtkTreePath* _tmp7_ = NULL;
	GtkTreeModel* _tmp8_ = NULL;
	GtkTreeModel* _tmp9_ = NULL;
	GtkTreePath* _tmp10_ = NULL;
	GtkTreeIter _tmp11_ = {0};
	GtkTreeModel* _tmp12_ = NULL;
	GtkTreeModel* _tmp13_ = NULL;
	GtkTreeIter _tmp14_ = {0};
	guint _tmp15_ = 0U;
	GtkTreeIter _tmp16_ = {0};
	GList* _tmp17_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (root_path != NULL);
	node = NULL;
	_tmp0_.stamp = 0;
	initial_iter = _tmp0_;
	_tmp1_.stamp = 0;
	child_iter = _tmp1_;
	__g_list_free__baobab_chart_item_unref0_0 (self->priv->items);
	self->priv->items = NULL;
	_tmp2_ = baobab_chart_get_model (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = root_path;
	_tmp6_ = gtk_tree_model_get_iter (_tmp3_, &_tmp5_, _tmp4_);
	initial_iter = _tmp5_;
	if (!_tmp6_) {
		self->priv->model_changed = FALSE;
		_gtk_tree_path_free0 (model_root_path);
		return;
	}
	_tmp7_ = gtk_tree_path_new_first ();
	_gtk_tree_path_free0 (model_root_path);
	model_root_path = _tmp7_;
	_tmp8_ = baobab_chart_get_model (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = model_root_path;
	gtk_tree_model_get_iter (_tmp9_, &_tmp11_, _tmp10_);
	model_root_iter = _tmp11_;
	_tmp12_ = baobab_chart_get_model (self);
	_tmp13_ = _tmp12_;
	_tmp14_ = model_root_iter;
	_tmp15_ = self->priv->percentage_column;
	gtk_tree_model_get (_tmp13_, &_tmp14_, _tmp15_, &size, -1, -1);
	_tmp16_ = initial_iter;
	_tmp17_ = baobab_chart_add_item (self, (guint) 0, (gdouble) 0, (gdouble) 100, &_tmp16_);
	node = _tmp17_;
	{
		gboolean _tmp18_ = FALSE;
		_tmp18_ = TRUE;
		while (TRUE) {
			gboolean _tmp19_ = FALSE;
			BaobabChartItem* item = NULL;
			GList* _tmp21_ = NULL;
			gconstpointer _tmp22_ = NULL;
			BaobabChartItem* _tmp23_ = NULL;
			BaobabChartItem* _tmp24_ = NULL;
			GtkTreeModel* _tmp25_ = NULL;
			GtkTreeModel* _tmp26_ = NULL;
			BaobabChartItem* _tmp27_ = NULL;
			GtkTreeIter _tmp28_ = {0};
			GtkTreeIter _tmp29_ = {0};
			gboolean _tmp30_ = FALSE;
			BaobabChartItem* _tmp31_ = NULL;
			BaobabChartItem* _tmp32_ = NULL;
			gboolean _tmp33_ = FALSE;
			gboolean _tmp36_ = FALSE;
			BaobabChartItem* _tmp37_ = NULL;
			gboolean _tmp38_ = FALSE;
			gboolean _tmp43_ = FALSE;
			GList* _tmp66_ = NULL;
			GList* _tmp67_ = NULL;
			_tmp19_ = _tmp18_;
			if (!_tmp19_) {
				GList* _tmp20_ = NULL;
				_tmp20_ = node;
				if (!(_tmp20_ != NULL)) {
					break;
				}
			}
			_tmp18_ = FALSE;
			_tmp21_ = node;
			_tmp22_ = _tmp21_->data;
			_tmp23_ = _baobab_chart_item_ref0 ((BaobabChartItem*) _tmp22_);
			item = _tmp23_;
			_tmp24_ = item;
			_tmp25_ = baobab_chart_get_model (self);
			_tmp26_ = _tmp25_;
			_tmp27_ = item;
			_tmp28_ = _tmp27_->iter;
			_tmp30_ = gtk_tree_model_iter_children (_tmp26_, &_tmp29_, &_tmp28_);
			child_iter = _tmp29_;
			_tmp24_->has_any_child = _tmp30_;
			_tmp31_ = item;
			baobab_chart_calculate_item_geometry (self, _tmp31_);
			_tmp32_ = item;
			_tmp33_ = _tmp32_->visible;
			if (!_tmp33_) {
				GList* _tmp34_ = NULL;
				GList* _tmp35_ = NULL;
				_tmp34_ = node;
				_tmp35_ = _tmp34_->prev;
				node = _tmp35_;
				_baobab_chart_item_unref0 (item);
				continue;
			}
			_tmp37_ = item;
			_tmp38_ = _tmp37_->has_any_child;
			if (_tmp38_) {
				BaobabChartItem* _tmp39_ = NULL;
				guint _tmp40_ = 0U;
				guint _tmp41_ = 0U;
				guint _tmp42_ = 0U;
				_tmp39_ = item;
				_tmp40_ = _tmp39_->depth;
				_tmp41_ = baobab_chart_get_max_depth (self);
				_tmp42_ = _tmp41_;
				_tmp36_ = _tmp40_ < (_tmp42_ + 1);
			} else {
				_tmp36_ = FALSE;
			}
			_tmp43_ = _tmp36_;
			if (_tmp43_) {
				rel_start = (gdouble) 0;
				{
					gboolean _tmp44_ = FALSE;
					_tmp44_ = TRUE;
					while (TRUE) {
						gboolean _tmp45_ = FALSE;
						GtkTreeModel* _tmp49_ = NULL;
						GtkTreeModel* _tmp50_ = NULL;
						GtkTreeIter _tmp51_ = {0};
						guint _tmp52_ = 0U;
						BaobabChartItem* _tmp53_ = NULL;
						guint _tmp54_ = 0U;
						gdouble _tmp55_ = 0.0;
						gdouble _tmp56_ = 0.0;
						GtkTreeIter _tmp57_ = {0};
						GList* _tmp58_ = NULL;
						BaobabChartItem* child = NULL;
						GList* _tmp59_ = NULL;
						gconstpointer _tmp60_ = NULL;
						BaobabChartItem* _tmp61_ = NULL;
						BaobabChartItem* _tmp62_ = NULL;
						GList* _tmp63_ = NULL;
						gdouble _tmp64_ = 0.0;
						gdouble _tmp65_ = 0.0;
						_tmp45_ = _tmp44_;
						if (!_tmp45_) {
							GtkTreeModel* _tmp46_ = NULL;
							GtkTreeModel* _tmp47_ = NULL;
							gboolean _tmp48_ = FALSE;
							_tmp46_ = baobab_chart_get_model (self);
							_tmp47_ = _tmp46_;
							_tmp48_ = gtk_tree_model_iter_next (_tmp47_, &child_iter);
							if (!_tmp48_) {
								break;
							}
						}
						_tmp44_ = FALSE;
						_tmp49_ = baobab_chart_get_model (self);
						_tmp50_ = _tmp49_;
						_tmp51_ = child_iter;
						_tmp52_ = self->priv->percentage_column;
						gtk_tree_model_get (_tmp50_, &_tmp51_, _tmp52_, &size, -1, -1);
						_tmp53_ = item;
						_tmp54_ = _tmp53_->depth;
						_tmp55_ = rel_start;
						_tmp56_ = size;
						_tmp57_ = child_iter;
						_tmp58_ = baobab_chart_add_item (self, _tmp54_ + 1, _tmp55_, _tmp56_, &_tmp57_);
						child_node = _tmp58_;
						_tmp59_ = child_node;
						_tmp60_ = _tmp59_->data;
						_tmp61_ = _baobab_chart_item_ref0 ((BaobabChartItem*) _tmp60_);
						child = _tmp61_;
						_tmp62_ = child;
						_tmp63_ = node;
						_tmp62_->parent = _tmp63_;
						_tmp64_ = rel_start;
						_tmp65_ = size;
						rel_start = _tmp64_ + _tmp65_;
						_baobab_chart_item_unref0 (child);
					}
				}
			}
			_tmp66_ = node;
			_tmp67_ = _tmp66_->prev;
			node = _tmp67_;
			_baobab_chart_item_unref0 (item);
		}
	}
	self->priv->items = g_list_reverse (self->priv->items);
	self->priv->model_changed = FALSE;
	_gtk_tree_path_free0 (model_root_path);
}


static void baobab_chart_draw_chart (BaobabChart* self, cairo_t* cr) {
	cairo_t* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	cairo_t* _tmp27_ = NULL;
	cairo_t* _tmp28_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = cr;
	cairo_save (_tmp0_);
	_tmp1_ = self->priv->items;
	{
		GList* item_collection = NULL;
		GList* item_it = NULL;
		item_collection = _tmp1_;
		for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
			BaobabChartItem* _tmp2_ = NULL;
			BaobabChartItem* item = NULL;
			_tmp2_ = _baobab_chart_item_ref0 ((BaobabChartItem*) item_it->data);
			item = _tmp2_;
			{
				GdkRectangle clip = {0};
				gboolean _tmp3_ = FALSE;
				gboolean _tmp4_ = FALSE;
				gboolean _tmp5_ = FALSE;
				cairo_t* _tmp6_ = NULL;
				GdkRectangle _tmp7_ = {0};
				gboolean _tmp8_ = FALSE;
				gboolean _tmp11_ = FALSE;
				gboolean _tmp15_ = FALSE;
				gboolean _tmp20_ = FALSE;
				_tmp6_ = cr;
				_tmp8_ = gdk_cairo_get_clip_rectangle (_tmp6_, &_tmp7_);
				clip = _tmp7_;
				if (_tmp8_) {
					BaobabChartItem* _tmp9_ = NULL;
					gboolean _tmp10_ = FALSE;
					_tmp9_ = item;
					_tmp10_ = _tmp9_->visible;
					_tmp5_ = _tmp10_;
				} else {
					_tmp5_ = FALSE;
				}
				_tmp11_ = _tmp5_;
				if (_tmp11_) {
					BaobabChartItem* _tmp12_ = NULL;
					GdkRectangle _tmp13_ = {0};
					gboolean _tmp14_ = FALSE;
					_tmp12_ = item;
					_tmp13_ = _tmp12_->rect;
					_tmp14_ = gdk_rectangle_intersect (&clip, &_tmp13_, NULL);
					_tmp4_ = _tmp14_;
				} else {
					_tmp4_ = FALSE;
				}
				_tmp15_ = _tmp4_;
				if (_tmp15_) {
					BaobabChartItem* _tmp16_ = NULL;
					guint _tmp17_ = 0U;
					guint _tmp18_ = 0U;
					guint _tmp19_ = 0U;
					_tmp16_ = item;
					_tmp17_ = _tmp16_->depth;
					_tmp18_ = baobab_chart_get_max_depth (self);
					_tmp19_ = _tmp18_;
					_tmp3_ = _tmp17_ <= _tmp19_;
				} else {
					_tmp3_ = FALSE;
				}
				_tmp20_ = _tmp3_;
				if (_tmp20_) {
					gboolean highlighted = FALSE;
					BaobabChartItem* _tmp21_ = NULL;
					BaobabChartItem* _tmp22_ = NULL;
					BaobabChartItem* _tmp23_ = NULL;
					cairo_t* _tmp24_ = NULL;
					BaobabChartItem* _tmp25_ = NULL;
					gboolean _tmp26_ = FALSE;
					_tmp21_ = item;
					_tmp22_ = baobab_chart_get_highlighted_item (self);
					_tmp23_ = _tmp22_;
					highlighted = _tmp21_ == _tmp23_;
					_tmp24_ = cr;
					_tmp25_ = item;
					_tmp26_ = highlighted;
					baobab_chart_draw_item (self, _tmp24_, _tmp25_, _tmp26_);
				}
				_baobab_chart_item_unref0 (item);
			}
		}
	}
	_tmp27_ = cr;
	cairo_restore (_tmp27_);
	_tmp28_ = cr;
	baobab_chart_post_draw (self, _tmp28_);
}


static void baobab_chart_update_draw (BaobabChart* self, GtkTreePath* path) {
	gboolean _tmp0_ = FALSE;
	gint root_depth = 0;
	GtkTreePath* _tmp1_ = NULL;
	GtkTreePath* _tmp2_ = NULL;
	GtkTreePath* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint node_depth = 0;
	GtkTreePath* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gboolean _tmp8_ = FALSE;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	guint _tmp11_ = 0U;
	guint _tmp12_ = 0U;
	gboolean _tmp26_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = gtk_widget_get_realized ((GtkWidget*) self);
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = baobab_chart_get_root (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = gtk_tree_path_get_depth (_tmp3_);
	_tmp5_ = _tmp4_;
	_gtk_tree_path_free0 (_tmp3_);
	root_depth = _tmp5_;
	_tmp6_ = path;
	_tmp7_ = gtk_tree_path_get_depth (_tmp6_);
	node_depth = _tmp7_;
	_tmp9_ = node_depth;
	_tmp10_ = root_depth;
	_tmp11_ = baobab_chart_get_max_depth (self);
	_tmp12_ = _tmp11_;
	if (((guint) (_tmp9_ - _tmp10_)) <= _tmp12_) {
		gboolean _tmp13_ = FALSE;
		GtkTreePath* _tmp14_ = NULL;
		GtkTreePath* _tmp15_ = NULL;
		GtkTreePath* _tmp16_ = NULL;
		GtkTreePath* _tmp17_ = NULL;
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_ = FALSE;
		gboolean _tmp25_ = FALSE;
		_tmp14_ = baobab_chart_get_root (self);
		_tmp15_ = _tmp14_;
		_tmp16_ = _tmp15_;
		_tmp17_ = path;
		_tmp18_ = gtk_tree_path_is_ancestor (_tmp16_, _tmp17_);
		_tmp19_ = _tmp18_;
		_gtk_tree_path_free0 (_tmp16_);
		if (_tmp19_) {
			_tmp13_ = TRUE;
		} else {
			GtkTreePath* _tmp20_ = NULL;
			GtkTreePath* _tmp21_ = NULL;
			GtkTreePath* _tmp22_ = NULL;
			GtkTreePath* _tmp23_ = NULL;
			gint _tmp24_ = 0;
			_tmp20_ = baobab_chart_get_root (self);
			_tmp21_ = _tmp20_;
			_tmp22_ = _tmp21_;
			_tmp23_ = path;
			_tmp24_ = gtk_tree_path_compare (_tmp22_, _tmp23_);
			_tmp13_ = _tmp24_ == 0;
			_gtk_tree_path_free0 (_tmp22_);
		}
		_tmp25_ = _tmp13_;
		_tmp8_ = _tmp25_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp26_ = _tmp8_;
	if (_tmp26_) {
		gtk_widget_queue_draw ((GtkWidget*) self);
	}
}


static void baobab_chart_row_changed (BaobabChart* self, GtkTreeModel* model, GtkTreePath* path, GtkTreeIter* iter) {
	GtkTreePath* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (iter != NULL);
	self->priv->model_changed = TRUE;
	_tmp0_ = path;
	baobab_chart_update_draw (self, _tmp0_);
}


static void baobab_chart_row_inserted (BaobabChart* self, GtkTreeModel* model, GtkTreePath* path, GtkTreeIter* iter) {
	GtkTreePath* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (iter != NULL);
	self->priv->model_changed = TRUE;
	_tmp0_ = path;
	baobab_chart_update_draw (self, _tmp0_);
}


static void baobab_chart_row_deleted (BaobabChart* self, GtkTreeModel* model, GtkTreePath* path) {
	GtkTreePath* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (path != NULL);
	self->priv->model_changed = TRUE;
	_tmp0_ = path;
	baobab_chart_update_draw (self, _tmp0_);
}


static void baobab_chart_row_has_child_toggled (BaobabChart* self, GtkTreeModel* model, GtkTreePath* path, GtkTreeIter* iter) {
	GtkTreePath* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (iter != NULL);
	self->priv->model_changed = TRUE;
	_tmp0_ = path;
	baobab_chart_update_draw (self, _tmp0_);
}


static void baobab_chart_rows_reordered (BaobabChart* self, GtkTreeModel* model, GtkTreePath* path, GtkTreeIter* iter, void* new_order) {
	GtkTreePath* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (path != NULL);
	self->priv->model_changed = TRUE;
	_tmp0_ = path;
	baobab_chart_update_draw (self, _tmp0_);
}


static gboolean baobab_chart_real_draw (GtkWidget* base, cairo_t* cr) {
	BaobabChart * self;
	gboolean result = FALSE;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	GtkTreeModel* _tmp2_ = NULL;
	GtkTreeModel* _tmp3_ = NULL;
	self = (BaobabChart*) base;
	g_return_val_if_fail (cr != NULL, FALSE);
	_tmp0_ = self->priv->name_column;
	_tmp1_ = self->priv->percentage_column;
	if (_tmp0_ == _tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = baobab_chart_get_model (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp7_ = FALSE;
		cairo_t* _tmp26_ = NULL;
		_tmp5_ = self->priv->model_changed;
		if (_tmp5_) {
			_tmp4_ = TRUE;
		} else {
			GList* _tmp6_ = NULL;
			_tmp6_ = self->priv->items;
			_tmp4_ = _tmp6_ == NULL;
		}
		_tmp7_ = _tmp4_;
		if (_tmp7_) {
			GtkTreePath* _tmp8_ = NULL;
			GtkTreePath* _tmp9_ = NULL;
			GtkTreePath* _tmp10_ = NULL;
			_tmp8_ = baobab_chart_get_root (self);
			_tmp9_ = _tmp8_;
			_tmp10_ = _tmp9_;
			baobab_chart_get_items (self, _tmp10_);
			_gtk_tree_path_free0 (_tmp10_);
		} else {
			GtkTreePath* current_path = NULL;
			GtkTreeModel* _tmp11_ = NULL;
			GtkTreeModel* _tmp12_ = NULL;
			GList* _tmp13_ = NULL;
			gconstpointer _tmp14_ = NULL;
			GtkTreeIter _tmp15_ = {0};
			GtkTreePath* _tmp16_ = NULL;
			GtkTreePath* _tmp17_ = NULL;
			GtkTreePath* _tmp18_ = NULL;
			GtkTreePath* _tmp19_ = NULL;
			GtkTreePath* _tmp20_ = NULL;
			gint _tmp21_ = 0;
			gboolean _tmp22_ = FALSE;
			_tmp11_ = baobab_chart_get_model (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = self->priv->items;
			_tmp14_ = _tmp13_->data;
			_tmp15_ = ((BaobabChartItem*) _tmp14_)->iter;
			_tmp16_ = gtk_tree_model_get_path (_tmp12_, &_tmp15_);
			current_path = _tmp16_;
			_tmp17_ = baobab_chart_get_root (self);
			_tmp18_ = _tmp17_;
			_tmp19_ = _tmp18_;
			_tmp20_ = current_path;
			_tmp21_ = gtk_tree_path_compare (_tmp19_, _tmp20_);
			_tmp22_ = _tmp21_ != 0;
			_gtk_tree_path_free0 (_tmp19_);
			if (_tmp22_) {
				GtkTreePath* _tmp23_ = NULL;
				GtkTreePath* _tmp24_ = NULL;
				GtkTreePath* _tmp25_ = NULL;
				_tmp23_ = baobab_chart_get_root (self);
				_tmp24_ = _tmp23_;
				_tmp25_ = _tmp24_;
				baobab_chart_get_items (self, _tmp25_);
				_gtk_tree_path_free0 (_tmp25_);
			}
			_gtk_tree_path_free0 (current_path);
		}
		_tmp26_ = cr;
		baobab_chart_draw_chart (self, _tmp26_);
	}
	result = FALSE;
	return result;
}


static void baobab_chart_interpolate_colors (BaobabChart* self, GdkRGBA* colora, GdkRGBA* colorb, gdouble percentage, GdkRGBA* result) {
	GdkRGBA color = {0};
	gdouble diff = 0.0;
	GdkRGBA _tmp0_ = {0};
	gdouble _tmp1_ = 0.0;
	GdkRGBA _tmp2_ = {0};
	gdouble _tmp3_ = 0.0;
	GdkRGBA _tmp4_ = {0};
	gdouble _tmp5_ = 0.0;
	gdouble _tmp6_ = 0.0;
	gdouble _tmp7_ = 0.0;
	GdkRGBA _tmp8_ = {0};
	gdouble _tmp9_ = 0.0;
	GdkRGBA _tmp10_ = {0};
	gdouble _tmp11_ = 0.0;
	GdkRGBA _tmp12_ = {0};
	gdouble _tmp13_ = 0.0;
	gdouble _tmp14_ = 0.0;
	gdouble _tmp15_ = 0.0;
	GdkRGBA _tmp16_ = {0};
	gdouble _tmp17_ = 0.0;
	GdkRGBA _tmp18_ = {0};
	gdouble _tmp19_ = 0.0;
	GdkRGBA _tmp20_ = {0};
	gdouble _tmp21_ = 0.0;
	gdouble _tmp22_ = 0.0;
	gdouble _tmp23_ = 0.0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (colora != NULL);
	g_return_if_fail (colorb != NULL);
	memset (&color, 0, sizeof (GdkRGBA));
	_tmp0_ = *colora;
	_tmp1_ = _tmp0_.red;
	_tmp2_ = *colorb;
	_tmp3_ = _tmp2_.red;
	diff = _tmp1_ - _tmp3_;
	_tmp4_ = *colora;
	_tmp5_ = _tmp4_.red;
	_tmp6_ = diff;
	_tmp7_ = percentage;
	color.red = _tmp5_ - (_tmp6_ * _tmp7_);
	_tmp8_ = *colora;
	_tmp9_ = _tmp8_.green;
	_tmp10_ = *colorb;
	_tmp11_ = _tmp10_.green;
	diff = _tmp9_ - _tmp11_;
	_tmp12_ = *colora;
	_tmp13_ = _tmp12_.green;
	_tmp14_ = diff;
	_tmp15_ = percentage;
	color.green = _tmp13_ - (_tmp14_ * _tmp15_);
	_tmp16_ = *colora;
	_tmp17_ = _tmp16_.blue;
	_tmp18_ = *colorb;
	_tmp19_ = _tmp18_.blue;
	diff = _tmp17_ - _tmp19_;
	_tmp20_ = *colora;
	_tmp21_ = _tmp20_.blue;
	_tmp22_ = diff;
	_tmp23_ = percentage;
	color.blue = _tmp21_ - (_tmp22_ * _tmp23_);
	color.alpha = 1.0;
	*result = color;
	return;
}


void baobab_chart_get_item_color (BaobabChart* self, gdouble rel_position, guint depth, gboolean highlighted, GdkRGBA* result) {
	static const GdkRGBA level_color = {0.83, 0.84, 0.82, 1.0};
	static const GdkRGBA level_color_hi = {0.88, 0.89, 0.87, 1.0};
	GdkRGBA color = {0};
	gdouble intensity = 0.0;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	gboolean _tmp17_ = FALSE;
	g_return_if_fail (self != NULL);
	memset (&color, 0, sizeof (GdkRGBA));
	_tmp0_ = depth;
	intensity = 1 - (((_tmp0_ - 1) * 0.3) / BAOBAB_CHART_MAX_DEPTH);
	_tmp1_ = depth;
	if (_tmp1_ == ((guint) 0)) {
		color = level_color;
	} else {
		gint color_number = 0;
		gdouble _tmp2_ = 0.0;
		gint next_color_number = 0;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		GdkRGBA _tmp5_ = {0};
		gint _tmp6_ = 0;
		GdkRGBA _tmp7_ = {0};
		gdouble _tmp8_ = 0.0;
		gint _tmp9_ = 0;
		GdkRGBA _tmp10_ = {0};
		gdouble _tmp11_ = 0.0;
		gdouble _tmp12_ = 0.0;
		gdouble _tmp13_ = 0.0;
		gdouble _tmp14_ = 0.0;
		gdouble _tmp15_ = 0.0;
		gdouble _tmp16_ = 0.0;
		_tmp2_ = rel_position;
		color_number = (gint) (_tmp2_ / (100.0 / 3));
		_tmp3_ = color_number;
		next_color_number = (_tmp3_ + 1) % 6;
		_tmp4_ = color_number;
		_tmp5_ = BAOBAB_CHART_TANGO_COLORS[_tmp4_];
		_tmp6_ = next_color_number;
		_tmp7_ = BAOBAB_CHART_TANGO_COLORS[_tmp6_];
		_tmp8_ = rel_position;
		_tmp9_ = color_number;
		baobab_chart_interpolate_colors (self, &_tmp5_, &_tmp7_, (_tmp8_ - ((_tmp9_ * 100) / 3)) / (100 / 3), &_tmp10_);
		color = _tmp10_;
		_tmp11_ = color.red;
		_tmp12_ = intensity;
		color.red = _tmp11_ * _tmp12_;
		_tmp13_ = color.green;
		_tmp14_ = intensity;
		color.green = _tmp13_ * _tmp14_;
		_tmp15_ = color.blue;
		_tmp16_ = intensity;
		color.blue = _tmp15_ * _tmp16_;
	}
	_tmp17_ = highlighted;
	if (_tmp17_) {
		guint _tmp18_ = 0U;
		_tmp18_ = depth;
		if (_tmp18_ == ((guint) 0)) {
			color = level_color_hi;
		} else {
			gdouble maximum = 0.0;
			GdkRGBA _tmp19_ = {0};
			gdouble _tmp20_ = 0.0;
			GdkRGBA _tmp21_ = {0};
			gdouble _tmp22_ = 0.0;
			GdkRGBA _tmp23_ = {0};
			gdouble _tmp24_ = 0.0;
			gdouble _tmp25_ = 0.0;
			gdouble _tmp26_ = 0.0;
			gdouble _tmp27_ = 0.0;
			gdouble _tmp28_ = 0.0;
			gdouble _tmp29_ = 0.0;
			gdouble _tmp30_ = 0.0;
			gdouble _tmp31_ = 0.0;
			gdouble _tmp32_ = 0.0;
			_tmp19_ = color;
			_tmp20_ = _tmp19_.red;
			_tmp21_ = color;
			_tmp22_ = _tmp21_.green;
			_tmp23_ = color;
			_tmp24_ = _tmp23_.blue;
			_tmp25_ = MAX (_tmp22_, _tmp24_);
			_tmp26_ = MAX (_tmp20_, _tmp25_);
			maximum = _tmp26_;
			_tmp27_ = color.red;
			_tmp28_ = maximum;
			color.red = _tmp27_ / _tmp28_;
			_tmp29_ = color.green;
			_tmp30_ = maximum;
			color.green = _tmp29_ / _tmp30_;
			_tmp31_ = color.blue;
			_tmp32_ = maximum;
			color.blue = _tmp31_ / _tmp32_;
		}
	}
	*result = color;
	return;
}


static gboolean baobab_chart_real_button_press_event (GtkWidget* base, GdkEventButton* event) {
	BaobabChart * self;
	gboolean result = FALSE;
	GdkEventButton _tmp0_ = {0};
	GdkEventType _tmp1_ = 0;
	self = (BaobabChart*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = *event;
	_tmp1_ = _tmp0_.type;
	if (_tmp1_ == GDK_BUTTON_PRESS) {
		gboolean _tmp2_ = FALSE;
		GdkEventButton _tmp4_ = {0};
		guint _tmp5_ = 0U;
		_tmp2_ = gdk_event_triggers_context_menu ((GdkEvent*) (event));
		if (_tmp2_) {
			GdkEventButton _tmp3_ = {0};
			_tmp3_ = *event;
			baobab_chart_show_popup_menu (self, &_tmp3_);
			result = TRUE;
			return result;
		}
		_tmp4_ = *event;
		_tmp5_ = _tmp4_.button;
		switch (_tmp5_) {
			case GDK_BUTTON_PRIMARY:
			{
				GdkEventButton _tmp6_ = {0};
				gdouble _tmp7_ = 0.0;
				GdkEventButton _tmp8_ = {0};
				gdouble _tmp9_ = 0.0;
				gboolean _tmp10_ = FALSE;
				_tmp6_ = *event;
				_tmp7_ = _tmp6_.x;
				_tmp8_ = *event;
				_tmp9_ = _tmp8_.y;
				_tmp10_ = baobab_chart_highlight_item_at_point (self, _tmp7_, _tmp9_);
				if (_tmp10_) {
					GtkTreePath* path = NULL;
					GtkTreeModel* _tmp11_ = NULL;
					GtkTreeModel* _tmp12_ = NULL;
					BaobabChartItem* _tmp13_ = NULL;
					BaobabChartItem* _tmp14_ = NULL;
					GtkTreeIter _tmp15_ = {0};
					GtkTreePath* _tmp16_ = NULL;
					GtkTreePath* _tmp17_ = NULL;
					GtkTreePath* _tmp18_ = NULL;
					GtkTreePath* _tmp19_ = NULL;
					GtkTreePath* _tmp20_ = NULL;
					gint _tmp21_ = 0;
					gboolean _tmp22_ = FALSE;
					_tmp11_ = baobab_chart_get_model (self);
					_tmp12_ = _tmp11_;
					_tmp13_ = baobab_chart_get_highlighted_item (self);
					_tmp14_ = _tmp13_;
					_tmp15_ = _tmp14_->iter;
					_tmp16_ = gtk_tree_model_get_path (_tmp12_, &_tmp15_);
					path = _tmp16_;
					_tmp17_ = baobab_chart_get_root (self);
					_tmp18_ = _tmp17_;
					_tmp19_ = _tmp18_;
					_tmp20_ = path;
					_tmp21_ = gtk_tree_path_compare (_tmp19_, _tmp20_);
					_tmp22_ = _tmp21_ == 0;
					_gtk_tree_path_free0 (_tmp19_);
					if (_tmp22_) {
						baobab_chart_move_up_root (self);
					} else {
						BaobabChartItem* _tmp23_ = NULL;
						BaobabChartItem* _tmp24_ = NULL;
						GtkTreeIter _tmp25_ = {0};
						_tmp23_ = baobab_chart_get_highlighted_item (self);
						_tmp24_ = _tmp23_;
						_tmp25_ = _tmp24_->iter;
						g_signal_emit_by_name (self, "item-activated", &_tmp25_);
					}
					_gtk_tree_path_free0 (path);
				}
				break;
			}
			case GDK_BUTTON_MIDDLE:
			{
				baobab_chart_move_up_root (self);
				break;
			}
			default:
			break;
		}
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static gboolean baobab_chart_real_scroll_event (GtkWidget* base, GdkEventScroll* event) {
	BaobabChart * self;
	gboolean result = FALSE;
	GdkEventMotion* e = NULL;
	GdkEventScroll _tmp0_ = {0};
	GdkScrollDirection _tmp1_ = 0;
	self = (BaobabChart*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	e = (GdkEventMotion*) (event);
	_tmp0_ = *event;
	_tmp1_ = _tmp0_.direction;
	switch (_tmp1_) {
		case GDK_SCROLL_LEFT:
		case GDK_SCROLL_UP:
		{
			GdkEventMotion* _tmp2_ = NULL;
			GdkEventMotion _tmp3_ = {0};
			gboolean _tmp4_ = FALSE;
			baobab_chart_zoom_out (self);
			_tmp2_ = e;
			_tmp3_ = *_tmp2_;
			g_signal_emit_by_name ((GtkWidget*) self, "motion-notify-event", &_tmp3_, &_tmp4_);
			break;
		}
		case GDK_SCROLL_RIGHT:
		case GDK_SCROLL_DOWN:
		{
			GdkEventMotion* _tmp5_ = NULL;
			GdkEventMotion _tmp6_ = {0};
			gboolean _tmp7_ = FALSE;
			baobab_chart_zoom_in (self);
			_tmp5_ = e;
			_tmp6_ = *_tmp5_;
			g_signal_emit_by_name ((GtkWidget*) self, "motion-notify-event", &_tmp6_, &_tmp7_);
			break;
		}
		case GDK_SCROLL_SMOOTH:
		{
			break;
		}
		default:
		break;
	}
	result = FALSE;
	return result;
}


void baobab_chart_open_file (BaobabChart* self) {
	GtkWidget* _tmp0_ = NULL;
	BaobabChartItem* _tmp1_ = NULL;
	BaobabChartItem* _tmp2_ = NULL;
	GtkTreeIter _tmp3_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	_tmp1_ = baobab_chart_get_highlighted_item (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_->iter;
	baobab_window_open_item (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, BAOBAB_TYPE_WINDOW) ? ((BaobabWindow*) _tmp0_) : NULL, &_tmp3_);
}


void baobab_chart_copy_path (BaobabChart* self) {
	GtkWidget* _tmp0_ = NULL;
	BaobabChartItem* _tmp1_ = NULL;
	BaobabChartItem* _tmp2_ = NULL;
	GtkTreeIter _tmp3_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	_tmp1_ = baobab_chart_get_highlighted_item (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_->iter;
	baobab_window_copy_path (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, BAOBAB_TYPE_WINDOW) ? ((BaobabWindow*) _tmp0_) : NULL, &_tmp3_);
}


void baobab_chart_trash_file (BaobabChart* self) {
	GtkWidget* _tmp0_ = NULL;
	BaobabChartItem* _tmp1_ = NULL;
	BaobabChartItem* _tmp2_ = NULL;
	GtkTreeIter _tmp3_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	_tmp1_ = baobab_chart_get_highlighted_item (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_->iter;
	baobab_window_trash_file (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, BAOBAB_TYPE_WINDOW) ? ((BaobabWindow*) _tmp0_) : NULL, &_tmp3_);
}


void baobab_chart_move_up_root (BaobabChart* self) {
	GtkTreeIter iter = {0};
	GtkTreeIter parent_iter = {0};
	GtkTreeModel* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreePath* _tmp2_ = NULL;
	GtkTreePath* _tmp3_ = NULL;
	GtkTreePath* _tmp4_ = NULL;
	GtkTreeIter _tmp5_ = {0};
	GtkTreeModel* _tmp6_ = NULL;
	GtkTreeModel* _tmp7_ = NULL;
	GtkTreeIter _tmp8_ = {0};
	GtkTreeIter _tmp9_ = {0};
	gboolean _tmp10_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = baobab_chart_get_model (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = baobab_chart_get_root (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	gtk_tree_model_get_iter (_tmp1_, &_tmp5_, _tmp4_);
	iter = _tmp5_;
	_gtk_tree_path_free0 (_tmp4_);
	_tmp6_ = baobab_chart_get_model (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = iter;
	_tmp10_ = gtk_tree_model_iter_parent (_tmp7_, &_tmp9_, &_tmp8_);
	parent_iter = _tmp9_;
	if (_tmp10_) {
		GtkTreeModel* _tmp11_ = NULL;
		GtkTreeModel* _tmp12_ = NULL;
		GtkTreeIter _tmp13_ = {0};
		GtkTreePath* _tmp14_ = NULL;
		GtkTreePath* _tmp15_ = NULL;
		GtkTreeIter _tmp16_ = {0};
		_tmp11_ = baobab_chart_get_model (self);
		_tmp12_ = _tmp11_;
		_tmp13_ = parent_iter;
		_tmp14_ = gtk_tree_model_get_path (_tmp12_, &_tmp13_);
		_tmp15_ = _tmp14_;
		baobab_chart_set_root (self, _tmp15_);
		_gtk_tree_path_free0 (_tmp15_);
		_tmp16_ = parent_iter;
		g_signal_emit_by_name (self, "item-activated", &_tmp16_);
	}
}


void baobab_chart_zoom_in (BaobabChart* self) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = baobab_chart_can_zoom_in (self);
	if (_tmp0_) {
		guint _tmp1_ = 0U;
		guint _tmp2_ = 0U;
		_tmp1_ = baobab_chart_get_max_depth (self);
		_tmp2_ = _tmp1_;
		baobab_chart_set_max_depth (self, _tmp2_ - 1);
	}
}


void baobab_chart_zoom_out (BaobabChart* self) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = baobab_chart_can_zoom_out (self);
	if (_tmp0_) {
		guint _tmp1_ = 0U;
		guint _tmp2_ = 0U;
		_tmp1_ = baobab_chart_get_max_depth (self);
		_tmp2_ = _tmp1_;
		baobab_chart_set_max_depth (self, _tmp2_ + 1);
	}
}


static void baobab_chart_build_context_menu (BaobabChart* self) {
	GtkMenu* _tmp0_ = NULL;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp1_ = NULL;
	GMenuModel* menu_model = NULL;
	GtkBuilder* _tmp4_ = NULL;
	GObject* _tmp5_ = NULL;
	GMenuModel* _tmp6_ = NULL;
	GMenuModel* _tmp7_ = NULL;
	GtkMenu* _tmp8_ = NULL;
	GtkMenu* _tmp9_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->context_menu;
	if (_tmp0_ != NULL) {
		return;
	}
	_tmp1_ = gtk_builder_new ();
	builder = _tmp1_;
	{
		GtkBuilder* _tmp2_ = NULL;
		_tmp2_ = builder;
		gtk_builder_add_from_resource (_tmp2_, "/org/gnome/baobab/ui/baobab-menu.ui", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp3_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e->message;
		g_error ("baobab-chart.vala:609: loading context menu from resources: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp4_ = builder;
	_tmp5_ = gtk_builder_get_object (_tmp4_, "chartmenu");
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, g_menu_model_get_type ()) ? ((GMenuModel*) _tmp5_) : NULL);
	menu_model = _tmp6_;
	_tmp7_ = menu_model;
	_tmp8_ = (GtkMenu*) gtk_menu_new_from_model (_tmp7_);
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->context_menu);
	self->priv->context_menu = _tmp8_;
	_tmp9_ = self->priv->context_menu;
	gtk_menu_attach_to_widget (_tmp9_, (GtkWidget*) self, NULL);
	_g_object_unref0 (menu_model);
	_g_object_unref0 (builder);
}


static void baobab_chart_show_popup_menu (BaobabChart* self, GdkEventButton* event) {
	gboolean enable = FALSE;
	BaobabChartItem* _tmp0_ = NULL;
	BaobabChartItem* _tmp1_ = NULL;
	GSimpleAction* action = NULL;
	GSimpleActionGroup* _tmp2_ = NULL;
	GAction* _tmp3_ = NULL;
	GSimpleAction* _tmp4_ = NULL;
	GSimpleAction* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	GSimpleActionGroup* _tmp7_ = NULL;
	GAction* _tmp8_ = NULL;
	GSimpleAction* _tmp9_ = NULL;
	GSimpleAction* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	GSimpleActionGroup* _tmp12_ = NULL;
	GAction* _tmp13_ = NULL;
	GSimpleAction* _tmp14_ = NULL;
	GSimpleAction* _tmp15_ = NULL;
	gboolean _tmp16_ = FALSE;
	GdkEventButton* _tmp17_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = baobab_chart_get_highlighted_item (self);
	_tmp1_ = _tmp0_;
	enable = _tmp1_ != NULL;
	_tmp2_ = self->priv->action_group;
	_tmp3_ = g_action_map_lookup_action ((GActionMap*) _tmp2_, "open-file");
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp3_) : NULL);
	action = _tmp4_;
	_tmp5_ = action;
	_tmp6_ = enable;
	g_simple_action_set_enabled (_tmp5_, _tmp6_);
	_tmp7_ = self->priv->action_group;
	_tmp8_ = g_action_map_lookup_action ((GActionMap*) _tmp7_, "copy-path");
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp8_) : NULL);
	_g_object_unref0 (action);
	action = _tmp9_;
	_tmp10_ = action;
	_tmp11_ = enable;
	g_simple_action_set_enabled (_tmp10_, _tmp11_);
	_tmp12_ = self->priv->action_group;
	_tmp13_ = g_action_map_lookup_action ((GActionMap*) _tmp12_, "trash-file");
	_tmp14_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp13_) : NULL);
	_g_object_unref0 (action);
	action = _tmp14_;
	_tmp15_ = action;
	_tmp16_ = enable;
	g_simple_action_set_enabled (_tmp15_, _tmp16_);
	_tmp17_ = event;
	if (_tmp17_ != NULL) {
		GtkMenu* _tmp18_ = NULL;
		GdkEventButton* _tmp19_ = NULL;
		guint _tmp20_ = 0U;
		GdkEventButton* _tmp21_ = NULL;
		guint32 _tmp22_ = 0U;
		_tmp18_ = self->priv->context_menu;
		_tmp19_ = event;
		_tmp20_ = (*_tmp19_).button;
		_tmp21_ = event;
		_tmp22_ = (*_tmp21_).time;
		gtk_menu_popup (_tmp18_, NULL, NULL, NULL, NULL, _tmp20_, _tmp22_);
	} else {
		GtkMenu* _tmp23_ = NULL;
		guint32 _tmp24_ = 0U;
		_tmp23_ = self->priv->context_menu;
		_tmp24_ = gtk_get_current_event_time ();
		gtk_menu_popup (_tmp23_, NULL, NULL, NULL, NULL, (guint) 0, _tmp24_);
	}
	_g_object_unref0 (action);
}


static void _baobab_chart_row_changed_gtk_tree_model_row_changed (GtkTreeModel* _sender, GtkTreePath* path, GtkTreeIter* iter, gpointer self) {
	baobab_chart_row_changed (self, _sender, path, iter);
}


static void _baobab_chart_row_inserted_gtk_tree_model_row_inserted (GtkTreeModel* _sender, GtkTreePath* path, GtkTreeIter* iter, gpointer self) {
	baobab_chart_row_inserted (self, _sender, path, iter);
}


static void _baobab_chart_row_has_child_toggled_gtk_tree_model_row_has_child_toggled (GtkTreeModel* _sender, GtkTreePath* path, GtkTreeIter* iter, gpointer self) {
	baobab_chart_row_has_child_toggled (self, _sender, path, iter);
}


static void _baobab_chart_row_deleted_gtk_tree_model_row_deleted (GtkTreeModel* _sender, GtkTreePath* path, gpointer self) {
	baobab_chart_row_deleted (self, _sender, path);
}


static void _baobab_chart_rows_reordered_gtk_tree_model_rows_reordered (GtkTreeModel* _sender, GtkTreePath* path, GtkTreeIter* iter, void* new_order, gpointer self) {
	baobab_chart_rows_reordered (self, _sender, path, iter, new_order);
}


static void baobab_chart_connect_model_signals (BaobabChart* self, GtkTreeModel* m) {
	GtkTreeModel* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeModel* _tmp2_ = NULL;
	GtkTreeModel* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (m != NULL);
	_tmp0_ = m;
	g_signal_connect_object (_tmp0_, "row-changed", (GCallback) _baobab_chart_row_changed_gtk_tree_model_row_changed, self, 0);
	_tmp1_ = m;
	g_signal_connect_object (_tmp1_, "row-inserted", (GCallback) _baobab_chart_row_inserted_gtk_tree_model_row_inserted, self, 0);
	_tmp2_ = m;
	g_signal_connect_object (_tmp2_, "row-has-child-toggled", (GCallback) _baobab_chart_row_has_child_toggled_gtk_tree_model_row_has_child_toggled, self, 0);
	_tmp3_ = m;
	g_signal_connect_object (_tmp3_, "row-deleted", (GCallback) _baobab_chart_row_deleted_gtk_tree_model_row_deleted, self, 0);
	_tmp4_ = m;
	g_signal_connect_object (_tmp4_, "rows-reordered", (GCallback) _baobab_chart_rows_reordered_gtk_tree_model_rows_reordered, self, 0);
}


static void baobab_chart_disconnect_model_signals (BaobabChart* self, GtkTreeModel* m) {
	GtkTreeModel* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	GtkTreeModel* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	GtkTreeModel* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	GtkTreeModel* _tmp6_ = NULL;
	guint _tmp7_ = 0U;
	GtkTreeModel* _tmp8_ = NULL;
	guint _tmp9_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (m != NULL);
	_tmp0_ = m;
	g_signal_parse_name ("row-changed", GTK_TYPE_TREE_MODEL, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _baobab_chart_row_changed_gtk_tree_model_row_changed, self);
	_tmp2_ = m;
	g_signal_parse_name ("row-inserted", GTK_TYPE_TREE_MODEL, &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _baobab_chart_row_inserted_gtk_tree_model_row_inserted, self);
	_tmp4_ = m;
	g_signal_parse_name ("row-has-child-toggled", GTK_TYPE_TREE_MODEL, &_tmp5_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _baobab_chart_row_has_child_toggled_gtk_tree_model_row_has_child_toggled, self);
	_tmp6_ = m;
	g_signal_parse_name ("row-deleted", GTK_TYPE_TREE_MODEL, &_tmp7_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _baobab_chart_row_deleted_gtk_tree_model_row_deleted, self);
	_tmp8_ = m;
	g_signal_parse_name ("rows-reordered", GTK_TYPE_TREE_MODEL, &_tmp9_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp8_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp9_, 0, NULL, (GCallback) _baobab_chart_rows_reordered_gtk_tree_model_rows_reordered, self);
}


static gboolean baobab_chart_real_query_tooltip (GtkWidget* base, gint x, gint y, gboolean keyboard_tooltip, GtkTooltip* tooltip) {
	BaobabChart * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	BaobabChartItem* _tmp2_ = NULL;
	BaobabChartItem* _tmp3_ = NULL;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp11_ = FALSE;
	GtkTooltip* _tmp12_ = NULL;
	BaobabChartItem* _tmp13_ = NULL;
	BaobabChartItem* _tmp14_ = NULL;
	GdkRectangle _tmp15_ = {0};
	gchar* markup = NULL;
	BaobabChartItem* _tmp16_ = NULL;
	BaobabChartItem* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	BaobabChartItem* _tmp21_ = NULL;
	BaobabChartItem* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	GtkTooltip* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
	gchar* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	self = (BaobabChart*) base;
	g_return_val_if_fail (tooltip != NULL, FALSE);
	_tmp2_ = baobab_chart_get_highlighted_item (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		BaobabChartItem* _tmp4_ = NULL;
		BaobabChartItem* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		_tmp4_ = baobab_chart_get_highlighted_item (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = _tmp5_->name;
		_tmp1_ = _tmp6_ == NULL;
	}
	_tmp7_ = _tmp1_;
	if (_tmp7_) {
		_tmp0_ = TRUE;
	} else {
		BaobabChartItem* _tmp8_ = NULL;
		BaobabChartItem* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		_tmp8_ = baobab_chart_get_highlighted_item (self);
		_tmp9_ = _tmp8_;
		_tmp10_ = _tmp9_->size;
		_tmp0_ = _tmp10_ == NULL;
	}
	_tmp11_ = _tmp0_;
	if (_tmp11_) {
		result = FALSE;
		return result;
	}
	_tmp12_ = tooltip;
	_tmp13_ = baobab_chart_get_highlighted_item (self);
	_tmp14_ = _tmp13_;
	_tmp15_ = _tmp14_->rect;
	gtk_tooltip_set_tip_area (_tmp12_, &_tmp15_);
	_tmp16_ = baobab_chart_get_highlighted_item (self);
	_tmp17_ = _tmp16_;
	_tmp18_ = _tmp17_->name;
	_tmp19_ = g_strconcat (_tmp18_, "\n", NULL);
	_tmp20_ = _tmp19_;
	_tmp21_ = baobab_chart_get_highlighted_item (self);
	_tmp22_ = _tmp21_;
	_tmp23_ = _tmp22_->size;
	_tmp24_ = g_strconcat (_tmp20_, _tmp23_, NULL);
	_tmp25_ = _tmp24_;
	_g_free0 (_tmp20_);
	markup = _tmp25_;
	_tmp26_ = tooltip;
	_tmp27_ = markup;
	_tmp28_ = g_markup_escape_text (_tmp27_, (gssize) (-1));
	_tmp29_ = _tmp28_;
	gtk_tooltip_set_markup (_tmp26_, _tmp29_);
	_g_free0 (_tmp29_);
	result = TRUE;
	_g_free0 (markup);
	return result;
}


BaobabChart* baobab_chart_construct (GType object_type) {
	BaobabChart * self = NULL;
	self = (BaobabChart*) gtk_widget_new (object_type, NULL);
	return self;
}


guint baobab_chart_get_max_depth (BaobabChart* self) {
	guint result;
	guint _tmp0_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->max_depth_;
	result = _tmp0_;
	return result;
}


void baobab_chart_set_max_depth (BaobabChart* self, guint value) {
	guint m = 0U;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = CLAMP (_tmp0_, BAOBAB_CHART_MIN_DEPTH, BAOBAB_CHART_MAX_DEPTH);
	m = _tmp1_;
	_tmp2_ = self->priv->max_depth_;
	_tmp3_ = m;
	if (_tmp2_ == _tmp3_) {
		return;
	}
	_tmp4_ = m;
	self->priv->max_depth_ = _tmp4_;
	self->priv->model_changed = TRUE;
	gtk_widget_queue_draw ((GtkWidget*) self);
	g_object_notify ((GObject *) self, "max-depth");
}


GtkTreeModel* baobab_chart_get_model (BaobabChart* self) {
	GtkTreeModel* result;
	GtkTreeModel* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->model_;
	result = _tmp0_;
	return result;
}


void baobab_chart_set_model (BaobabChart* self, GtkTreeModel* value) {
	GtkTreeModel* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeModel* _tmp2_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeModel* _tmp5_ = NULL;
	GtkTreeModel* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->model_;
	_tmp1_ = value;
	if (_tmp0_ == _tmp1_) {
		return;
	}
	_tmp2_ = self->priv->model_;
	if (_tmp2_ != NULL) {
		GtkTreeModel* _tmp3_ = NULL;
		_tmp3_ = self->priv->model_;
		baobab_chart_disconnect_model_signals (self, _tmp3_);
	}
	_tmp4_ = value;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (self->priv->model_);
	self->priv->model_ = _tmp5_;
	self->priv->model_changed = TRUE;
	baobab_chart_set_root (self, NULL);
	_tmp6_ = self->priv->model_;
	baobab_chart_connect_model_signals (self, _tmp6_);
	gtk_widget_queue_draw ((GtkWidget*) self);
	g_object_notify ((GObject *) self, "model");
}


GtkTreePath* baobab_chart_get_root (BaobabChart* self) {
	GtkTreePath* result;
	const GtkTreeRowReference* _tmp0_ = NULL;
	GtkTreePath* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->root_;
	if (_tmp0_ != NULL) {
		GtkTreePath* path = NULL;
		const GtkTreeRowReference* _tmp1_ = NULL;
		GtkTreePath* _tmp2_ = NULL;
		GtkTreePath* _tmp3_ = NULL;
		_tmp1_ = self->priv->root_;
		_tmp2_ = gtk_tree_row_reference_get_path (_tmp1_);
		path = _tmp2_;
		_tmp3_ = path;
		if (_tmp3_ != NULL) {
			result = path;
			return result;
		}
		_gtk_tree_row_reference_free0 (self->priv->root_);
		self->priv->root_ = NULL;
		_gtk_tree_path_free0 (path);
	}
	_tmp4_ = gtk_tree_path_new_first ();
	result = _tmp4_;
	return result;
}


static gpointer _gtk_tree_row_reference_copy0 (gpointer self) {
	return self ? gtk_tree_row_reference_copy (self) : NULL;
}


void baobab_chart_set_root (BaobabChart* self, GtkTreePath* value) {
	GtkTreeModel* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	const GtkTreeRowReference* _tmp2_ = NULL;
	GtkTreeRowReference* _tmp15_ = NULL;
	GtkTreePath* _tmp16_ = NULL;
	const GtkTreeRowReference* _tmp21_ = NULL;
	GtkTreeRowReference* _tmp22_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = baobab_chart_get_model (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp2_ = self->priv->root_;
	if (_tmp2_ != NULL) {
		GtkTreePath* current_root = NULL;
		const GtkTreeRowReference* _tmp3_ = NULL;
		GtkTreePath* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		GtkTreePath* _tmp7_ = NULL;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp13_ = FALSE;
		_tmp3_ = self->priv->root_;
		_tmp4_ = gtk_tree_row_reference_get_path (_tmp3_);
		current_root = _tmp4_;
		_tmp7_ = current_root;
		if (_tmp7_ != NULL) {
			GtkTreePath* _tmp8_ = NULL;
			_tmp8_ = value;
			_tmp6_ = _tmp8_ != NULL;
		} else {
			_tmp6_ = FALSE;
		}
		_tmp9_ = _tmp6_;
		if (_tmp9_) {
			GtkTreePath* _tmp10_ = NULL;
			GtkTreePath* _tmp11_ = NULL;
			gint _tmp12_ = 0;
			_tmp10_ = current_root;
			_tmp11_ = value;
			_tmp12_ = gtk_tree_path_compare (_tmp10_, _tmp11_);
			_tmp5_ = _tmp12_ == 0;
		} else {
			_tmp5_ = FALSE;
		}
		_tmp13_ = _tmp5_;
		if (_tmp13_) {
			_gtk_tree_path_free0 (current_root);
			return;
		}
		_gtk_tree_path_free0 (current_root);
	} else {
		GtkTreePath* _tmp14_ = NULL;
		_tmp14_ = value;
		if (_tmp14_ == NULL) {
			return;
		}
	}
	_tmp16_ = value;
	if (_tmp16_ != NULL) {
		GtkTreeModel* _tmp17_ = NULL;
		GtkTreeModel* _tmp18_ = NULL;
		GtkTreePath* _tmp19_ = NULL;
		GtkTreeRowReference* _tmp20_ = NULL;
		_tmp17_ = baobab_chart_get_model (self);
		_tmp18_ = _tmp17_;
		_tmp19_ = value;
		_tmp20_ = gtk_tree_row_reference_new (_tmp18_, _tmp19_);
		_gtk_tree_row_reference_free0 (_tmp15_);
		_tmp15_ = _tmp20_;
	} else {
		_gtk_tree_row_reference_free0 (_tmp15_);
		_tmp15_ = NULL;
	}
	_tmp21_ = _tmp15_;
	_tmp22_ = _gtk_tree_row_reference_copy0 (_tmp21_);
	_gtk_tree_row_reference_free0 (self->priv->root_);
	self->priv->root_ = _tmp22_;
	baobab_chart_set_highlighted_item (self, NULL);
	gtk_widget_queue_draw ((GtkWidget*) self);
	_gtk_tree_row_reference_free0 (_tmp15_);
	g_object_notify ((GObject *) self, "root");
}


BaobabChartItem* baobab_chart_get_highlighted_item (BaobabChart* self) {
	BaobabChartItem* result;
	BaobabChartItem* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->highlighted_item_;
	result = _tmp0_;
	return result;
}


void baobab_chart_set_highlighted_item (BaobabChart* self, BaobabChartItem* value) {
	BaobabChartItem* _tmp0_ = NULL;
	BaobabChartItem* _tmp1_ = NULL;
	BaobabChartItem* _tmp2_ = NULL;
	BaobabChartItem* _tmp6_ = NULL;
	BaobabChartItem* _tmp10_ = NULL;
	BaobabChartItem* _tmp11_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->highlighted_item_;
	_tmp1_ = value;
	if (_tmp0_ == _tmp1_) {
		return;
	}
	_tmp2_ = self->priv->highlighted_item_;
	if (_tmp2_ != NULL) {
		GdkWindow* _tmp3_ = NULL;
		BaobabChartItem* _tmp4_ = NULL;
		GdkRectangle _tmp5_ = {0};
		_tmp3_ = gtk_widget_get_window ((GtkWidget*) self);
		_tmp4_ = self->priv->highlighted_item_;
		_tmp5_ = _tmp4_->rect;
		gdk_window_invalidate_rect (_tmp3_, &_tmp5_, TRUE);
	}
	_tmp6_ = value;
	if (_tmp6_ != NULL) {
		GdkWindow* _tmp7_ = NULL;
		BaobabChartItem* _tmp8_ = NULL;
		GdkRectangle _tmp9_ = {0};
		_tmp7_ = gtk_widget_get_window ((GtkWidget*) self);
		_tmp8_ = value;
		_tmp9_ = _tmp8_->rect;
		gdk_window_invalidate_rect (_tmp7_, &_tmp9_, TRUE);
	}
	_tmp10_ = value;
	_tmp11_ = _baobab_chart_item_ref0 (_tmp10_);
	_baobab_chart_item_unref0 (self->priv->highlighted_item_);
	self->priv->highlighted_item_ = _tmp11_;
	g_object_notify ((GObject *) self, "highlighted-item");
}


static void baobab_chart_real_item_activated (BaobabChart* self, GtkTreeIter* iter) {
	GtkTreeModel* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeIter _tmp2_ = {0};
	GtkTreePath* _tmp3_ = NULL;
	GtkTreePath* _tmp4_ = NULL;
	g_return_if_fail (iter != NULL);
	_tmp0_ = baobab_chart_get_model (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = *iter;
	_tmp3_ = gtk_tree_model_get_path (_tmp1_, &_tmp2_);
	_tmp4_ = _tmp3_;
	baobab_chart_set_root (self, _tmp4_);
	_gtk_tree_path_free0 (_tmp4_);
}


static void g_cclosure_user_marshal_VOID__BOXED (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__BOXED) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__BOXED callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOXED) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boxed (param_values + 1), data2);
}


static GObject * baobab_chart_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	BaobabChart * self;
	GSimpleActionGroup* _tmp0_ = NULL;
	GSimpleActionGroup* _tmp1_ = NULL;
	GSimpleActionGroup* _tmp2_ = NULL;
	parent_class = G_OBJECT_CLASS (baobab_chart_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BAOBAB_TYPE_CHART, BaobabChart);
	_tmp0_ = g_simple_action_group_new ();
	_g_object_unref0 (self->priv->action_group);
	self->priv->action_group = _tmp0_;
	_tmp1_ = self->priv->action_group;
	g_action_map_add_action_entries ((GActionMap*) _tmp1_, BAOBAB_CHART_action_entries, G_N_ELEMENTS (BAOBAB_CHART_action_entries), self);
	_tmp2_ = self->priv->action_group;
	gtk_widget_insert_action_group ((GtkWidget*) self, "chart", (GActionGroup*) _tmp2_);
	baobab_chart_build_context_menu (self);
	return obj;
}


static void baobab_chart_class_init (BaobabChartClass * klass) {
	baobab_chart_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BaobabChartPrivate));
	BAOBAB_CHART_CLASS (klass)->post_draw = baobab_chart_real_post_draw;
	BAOBAB_CHART_CLASS (klass)->draw_item = baobab_chart_real_draw_item;
	BAOBAB_CHART_CLASS (klass)->calculate_item_geometry = baobab_chart_real_calculate_item_geometry;
	BAOBAB_CHART_CLASS (klass)->is_point_over_item = baobab_chart_real_is_point_over_item;
	BAOBAB_CHART_CLASS (klass)->get_item_rectangle = baobab_chart_real_get_item_rectangle;
	BAOBAB_CHART_CLASS (klass)->can_zoom_in = baobab_chart_real_can_zoom_in;
	BAOBAB_CHART_CLASS (klass)->can_zoom_out = baobab_chart_real_can_zoom_out;
	BAOBAB_CHART_CLASS (klass)->create_new_chartitem = baobab_chart_real_create_new_chartitem;
	GTK_WIDGET_CLASS (klass)->realize = baobab_chart_real_realize;
	GTK_WIDGET_CLASS (klass)->size_allocate = baobab_chart_real_size_allocate;
	GTK_WIDGET_CLASS (klass)->motion_notify_event = baobab_chart_real_motion_notify_event;
	GTK_WIDGET_CLASS (klass)->leave_notify_event = baobab_chart_real_leave_notify_event;
	GTK_WIDGET_CLASS (klass)->draw = baobab_chart_real_draw;
	GTK_WIDGET_CLASS (klass)->button_press_event = baobab_chart_real_button_press_event;
	GTK_WIDGET_CLASS (klass)->scroll_event = baobab_chart_real_scroll_event;
	GTK_WIDGET_CLASS (klass)->query_tooltip = baobab_chart_real_query_tooltip;
	BAOBAB_CHART_CLASS (klass)->item_activated = baobab_chart_real_item_activated;
	G_OBJECT_CLASS (klass)->get_property = _vala_baobab_chart_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_baobab_chart_set_property;
	G_OBJECT_CLASS (klass)->constructor = baobab_chart_constructor;
	G_OBJECT_CLASS (klass)->finalize = baobab_chart_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BAOBAB_CHART_MAX_DEPTH, g_param_spec_uint ("max-depth", "max-depth", "max-depth", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BAOBAB_CHART_MODEL, g_param_spec_object ("model", "model", "model", GTK_TYPE_TREE_MODEL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BAOBAB_CHART_ROOT, g_param_spec_boxed ("root", "root", "root", gtk_tree_path_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BAOBAB_CHART_HIGHLIGHTED_ITEM, baobab_param_spec_chart_item ("highlighted-item", "highlighted-item", "highlighted-item", BAOBAB_TYPE_CHART_ITEM, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("item_activated", BAOBAB_TYPE_CHART, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (BaobabChartClass, item_activated), NULL, NULL, g_cclosure_user_marshal_VOID__BOXED, G_TYPE_NONE, 1, GTK_TYPE_TREE_ITER);
}


static void baobab_chart_instance_init (BaobabChart * self) {
	self->priv = BAOBAB_CHART_GET_PRIVATE (self);
	self->priv->context_menu = NULL;
	self->priv->max_depth_ = BAOBAB_CHART_MAX_DEPTH;
	self->priv->highlighted_item_ = NULL;
}


static void baobab_chart_finalize (GObject* obj) {
	BaobabChart * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BAOBAB_TYPE_CHART, BaobabChart);
	_g_object_unref0 (self->priv->context_menu);
	__g_list_free__baobab_chart_item_unref0_0 (self->priv->items);
	_g_object_unref0 (self->priv->model_);
	_gtk_tree_row_reference_free0 (self->priv->root_);
	_baobab_chart_item_unref0 (self->priv->highlighted_item_);
	_g_object_unref0 (self->priv->action_group);
	G_OBJECT_CLASS (baobab_chart_parent_class)->finalize (obj);
}


GType baobab_chart_get_type (void) {
	static volatile gsize baobab_chart_type_id__volatile = 0;
	if (g_once_init_enter (&baobab_chart_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BaobabChartClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) baobab_chart_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BaobabChart), 0, (GInstanceInitFunc) baobab_chart_instance_init, NULL };
		GType baobab_chart_type_id;
		baobab_chart_type_id = g_type_register_static (GTK_TYPE_WIDGET, "BaobabChart", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&baobab_chart_type_id__volatile, baobab_chart_type_id);
	}
	return baobab_chart_type_id__volatile;
}


static void _vala_baobab_chart_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	BaobabChart * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BAOBAB_TYPE_CHART, BaobabChart);
	switch (property_id) {
		case BAOBAB_CHART_MAX_DEPTH:
		g_value_set_uint (value, baobab_chart_get_max_depth (self));
		break;
		case BAOBAB_CHART_MODEL:
		g_value_set_object (value, baobab_chart_get_model (self));
		break;
		case BAOBAB_CHART_ROOT:
		g_value_take_boxed (value, baobab_chart_get_root (self));
		break;
		case BAOBAB_CHART_HIGHLIGHTED_ITEM:
		baobab_value_set_chart_item (value, baobab_chart_get_highlighted_item (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_baobab_chart_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	BaobabChart * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BAOBAB_TYPE_CHART, BaobabChart);
	switch (property_id) {
		case BAOBAB_CHART_MAX_DEPTH:
		baobab_chart_set_max_depth (self, g_value_get_uint (value));
		break;
		case BAOBAB_CHART_MODEL:
		baobab_chart_set_model (self, g_value_get_object (value));
		break;
		case BAOBAB_CHART_ROOT:
		baobab_chart_set_root (self, g_value_get_boxed (value));
		break;
		case BAOBAB_CHART_HIGHLIGHTED_ITEM:
		baobab_chart_set_highlighted_item (self, baobab_value_get_chart_item (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



