/* ofono-backend.c generated by valac 0.20.1.51-7ff1, the Vala compiler
 * generated from ofono-backend.vala, do not modify */

/*
 * Copyright (C) 2012 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Jeremy Whiting <jeremy.whiting@collabora.co.uk>
 *
 * Based on kf-backend.vala by:
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <folks/folks.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <folks-internal.h>


#define FOLKS_BACKENDS_OFONO_TYPE_BACKEND (folks_backends_ofono_backend_get_type ())
#define FOLKS_BACKENDS_OFONO_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_BACKENDS_OFONO_TYPE_BACKEND, FolksBackendsOfonoBackend))
#define FOLKS_BACKENDS_OFONO_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_BACKENDS_OFONO_TYPE_BACKEND, FolksBackendsOfonoBackendClass))
#define FOLKS_BACKENDS_OFONO_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_BACKENDS_OFONO_TYPE_BACKEND))
#define FOLKS_BACKENDS_OFONO_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_BACKENDS_OFONO_TYPE_BACKEND))
#define FOLKS_BACKENDS_OFONO_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_BACKENDS_OFONO_TYPE_BACKEND, FolksBackendsOfonoBackendClass))

typedef struct _FolksBackendsOfonoBackend FolksBackendsOfonoBackend;
typedef struct _FolksBackendsOfonoBackendClass FolksBackendsOfonoBackendClass;
typedef struct _FolksBackendsOfonoBackendPrivate FolksBackendsOfonoBackendPrivate;

#define FOLKS_BACKENDS_OFONO_TYPE_PERSONA_STORE (folks_backends_ofono_persona_store_get_type ())
#define FOLKS_BACKENDS_OFONO_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_BACKENDS_OFONO_TYPE_PERSONA_STORE, FolksBackendsOfonoPersonaStore))
#define FOLKS_BACKENDS_OFONO_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_BACKENDS_OFONO_TYPE_PERSONA_STORE, FolksBackendsOfonoPersonaStoreClass))
#define FOLKS_BACKENDS_OFONO_IS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_BACKENDS_OFONO_TYPE_PERSONA_STORE))
#define FOLKS_BACKENDS_OFONO_IS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_BACKENDS_OFONO_TYPE_PERSONA_STORE))
#define FOLKS_BACKENDS_OFONO_PERSONA_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_BACKENDS_OFONO_TYPE_PERSONA_STORE, FolksBackendsOfonoPersonaStoreClass))

typedef struct _FolksBackendsOfonoPersonaStore FolksBackendsOfonoPersonaStore;
typedef struct _FolksBackendsOfonoPersonaStoreClass FolksBackendsOfonoPersonaStoreClass;

#define ORG_OFONO_TYPE_MODEM_PROPERTIES (org_ofono_modem_properties_get_type ())
typedef struct _orgofonoModemProperties orgofonoModemProperties;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define ORG_OFONO_TYPE_MANAGER (org_ofono_manager_get_type ())
#define ORG_OFONO_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ORG_OFONO_TYPE_MANAGER, orgofonoManager))
#define ORG_OFONO_IS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ORG_OFONO_TYPE_MANAGER))
#define ORG_OFONO_MANAGER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), ORG_OFONO_TYPE_MANAGER, orgofonoManagerIface))

typedef struct _orgofonoManager orgofonoManager;
typedef struct _orgofonoManagerIface orgofonoManagerIface;

#define ORG_OFONO_TYPE_MANAGER_PROXY (org_ofono_manager_proxy_get_type ())
typedef struct _FolksBackendsOfonoBackendPrepareData FolksBackendsOfonoBackendPrepareData;
typedef struct _FolksBackendsOfonoBackendUnprepareData FolksBackendsOfonoBackendUnprepareData;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

struct _FolksBackendsOfonoBackend {
	FolksBackend parent_instance;
	FolksBackendsOfonoBackendPrivate * priv;
};

struct _FolksBackendsOfonoBackendClass {
	FolksBackendClass parent_class;
};

struct _orgofonoModemProperties {
	char* path;
	GHashTable* properties;
};

struct _FolksBackendsOfonoBackendPrivate {
	gboolean _is_prepared;
	gboolean _prepare_pending;
	gboolean _is_quiescent;
	GeeHashMap* _persona_stores;
	GeeMap* _persona_stores_ro;
	orgofonoModemProperties* _modems;
	gint _modems_length1;
	gint __modems_size_;
};

struct _orgofonoManagerIface {
	GTypeInterface parent_iface;
	orgofonoModemProperties* (*GetModems) (orgofonoManager* self, int* result_length1, GError** error);
};

struct _FolksBackendsOfonoBackendPrepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendsOfonoBackend* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	orgofonoManager* manager;
	orgofonoManager* _tmp4_;
	orgofonoManager* _tmp5_;
	orgofonoManager* _tmp6_;
	orgofonoModemProperties* _tmp7_;
	orgofonoManager* _tmp8_;
	gint _tmp9_;
	orgofonoModemProperties* _tmp10_;
	gint _tmp7__length1;
	gint __tmp7__size_;
	orgofonoModemProperties* _tmp11_;
	gint _tmp11__length1;
	orgofonoModemProperties* modem_collection;
	gint modem_collection_length1;
	gint _modem_collection_size_;
	gint modem_it;
	orgofonoModemProperties _tmp12_;
	orgofonoModemProperties modem;
	orgofonoModemProperties _tmp13_;
	const char* _tmp14_;
	orgofonoModemProperties _tmp15_;
	GHashTable* _tmp16_;
	GError * _inner_error_;
};

struct _FolksBackendsOfonoBackendUnprepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendsOfonoBackend* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GeeIterator* _persona_store_it;
	GeeHashMap* _tmp4_;
	GeeCollection* _tmp5_;
	GeeCollection* _tmp6_;
	GeeCollection* _tmp7_;
	GeeIterator* _tmp8_;
	GeeIterator* _tmp9_;
	GeeIterator* _tmp10_;
	gboolean _tmp11_;
	FolksBackendsOfonoPersonaStore* persona_store;
	GeeIterator* _tmp12_;
	gpointer _tmp13_;
	FolksBackendsOfonoPersonaStore* _tmp14_;
	GeeHashMap* _tmp15_;
	GError * _inner_error_;
};


static gpointer folks_backends_ofono_backend_parent_class = NULL;

GType folks_backends_ofono_backend_get_type (void) G_GNUC_CONST;
GType folks_backends_ofono_persona_store_get_type (void) G_GNUC_CONST;
GType org_ofono_modem_properties_get_type (void) G_GNUC_CONST;
orgofonoModemProperties* org_ofono_modem_properties_dup (const orgofonoModemProperties* self);
void org_ofono_modem_properties_free (orgofonoModemProperties* self);
void org_ofono_modem_properties_copy (const orgofonoModemProperties* self, orgofonoModemProperties* dest);
void org_ofono_modem_properties_destroy (orgofonoModemProperties* self);
#define FOLKS_BACKENDS_OFONO_BACKEND_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_BACKENDS_OFONO_TYPE_BACKEND, FolksBackendsOfonoBackendPrivate))
enum  {
	FOLKS_BACKENDS_OFONO_BACKEND_DUMMY_PROPERTY,
	FOLKS_BACKENDS_OFONO_BACKEND_IS_PREPARED,
	FOLKS_BACKENDS_OFONO_BACKEND_IS_QUIESCENT,
	FOLKS_BACKENDS_OFONO_BACKEND_NAME,
	FOLKS_BACKENDS_OFONO_BACKEND_PERSONA_STORES
};
static void _vala_orgofonoModemProperties_array_free (orgofonoModemProperties* array, gint array_length);
static void folks_backends_ofono_backend_real_disable_persona_store (FolksBackend* base, FolksPersonaStore* store);
static void _folks_backends_ofono_backend_store_removed_cb (FolksBackendsOfonoBackend* self, FolksPersonaStore* store);
static void folks_backends_ofono_backend_real_enable_persona_store (FolksBackend* base, FolksPersonaStore* store);
static void _folks_backends_ofono_backend_add_store (FolksBackendsOfonoBackend* self, FolksBackendsOfonoPersonaStore* store, gboolean notify);
static void folks_backends_ofono_backend_real_set_persona_stores (FolksBackend* base, GeeSet* storeids);
static gchar* _folks_backends_ofono_backend_modem_alias (FolksBackendsOfonoBackend* self, GHashTable* properties);
FolksBackendsOfonoPersonaStore* folks_backends_ofono_persona_store_new (const char* path, const gchar* alias);
FolksBackendsOfonoPersonaStore* folks_backends_ofono_persona_store_construct (GType object_type, const char* path, const gchar* alias);
static void _vala_array_add1 (FolksBackendsOfonoPersonaStore*** array, int* length, int* size, FolksBackendsOfonoPersonaStore* value);
static void _folks_backends_ofono_backend_remove_store (FolksBackendsOfonoBackend* self, FolksBackendsOfonoPersonaStore* store, gboolean notify);
FolksBackendsOfonoBackend* folks_backends_ofono_backend_new (void);
FolksBackendsOfonoBackend* folks_backends_ofono_backend_construct (GType object_type);
static void _folks_backends_ofono_backend_add_modem (FolksBackendsOfonoBackend* self, const char* path, const gchar* alias);
static void folks_backends_ofono_backend_real_prepare_data_free (gpointer _data);
static void folks_backends_ofono_backend_real_prepare (FolksBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean folks_backends_ofono_backend_real_prepare_co (FolksBackendsOfonoBackendPrepareData* _data_);
GType org_ofono_manager_proxy_get_type (void) G_GNUC_CONST;
guint org_ofono_manager_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType org_ofono_manager_get_type (void) G_GNUC_CONST;
static void folks_backends_ofono_backend_prepare_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _folks_backends_ofono_backend_modem_added (FolksBackendsOfonoBackend* self, const char* path, GHashTable* properties);
static void __folks_backends_ofono_backend_modem_added_org_ofono_manager_modem_added (orgofonoManager* _sender, const char* path, GHashTable* properties, gpointer self);
static void _folks_backends_ofono_backend_modem_removed (FolksBackendsOfonoBackend* self, const char* path);
static void __folks_backends_ofono_backend_modem_removed_org_ofono_manager_modem_removed (orgofonoManager* _sender, const char* path, gpointer self);
orgofonoModemProperties* org_ofono_manager_GetModems (orgofonoManager* self, int* result_length1, GError** error);
static void folks_backends_ofono_backend_real_unprepare_data_free (gpointer _data);
static void folks_backends_ofono_backend_real_unprepare (FolksBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean folks_backends_ofono_backend_real_unprepare_co (FolksBackendsOfonoBackendUnprepareData* _data_);
static void __folks_backends_ofono_backend_store_removed_cb_folks_persona_store_removed (FolksPersonaStore* _sender, gpointer self);
static GObject * folks_backends_ofono_backend_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void folks_backends_ofono_backend_finalize (GObject* obj);
static void _vala_folks_backends_ofono_backend_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void _vala_orgofonoModemProperties_array_free (orgofonoModemProperties* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			org_ofono_modem_properties_destroy (&array[i]);
		}
	}
	g_free (array);
}


/**
   * {@inheritDoc}
   */
static void folks_backends_ofono_backend_real_disable_persona_store (FolksBackend* base, FolksPersonaStore* store) {
	FolksBackendsOfonoBackend * self;
	GeeHashMap* _tmp0_ = NULL;
	FolksPersonaStore* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	self = (FolksBackendsOfonoBackend*) base;
	g_return_if_fail (store != NULL);
	_tmp0_ = self->priv->_persona_stores;
	_tmp1_ = store;
	_tmp2_ = folks_persona_store_get_id (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, _tmp3_);
	if (_tmp4_) {
		FolksPersonaStore* _tmp5_ = NULL;
		_tmp5_ = store;
		_folks_backends_ofono_backend_store_removed_cb (self, _tmp5_);
	}
}


/**
   * {@inheritDoc}
   */
static void folks_backends_ofono_backend_real_enable_persona_store (FolksBackend* base, FolksPersonaStore* store) {
	FolksBackendsOfonoBackend * self;
	GeeHashMap* _tmp0_ = NULL;
	FolksPersonaStore* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	self = (FolksBackendsOfonoBackend*) base;
	g_return_if_fail (store != NULL);
	_tmp0_ = self->priv->_persona_stores;
	_tmp1_ = store;
	_tmp2_ = folks_persona_store_get_id (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, _tmp3_);
	if (_tmp4_ == FALSE) {
		FolksPersonaStore* _tmp5_ = NULL;
		_tmp5_ = store;
		_folks_backends_ofono_backend_add_store (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, FOLKS_BACKENDS_OFONO_TYPE_PERSONA_STORE, FolksBackendsOfonoPersonaStore), TRUE);
	}
}


/**
   * {@inheritDoc}
   */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _vala_array_add1 (FolksBackendsOfonoPersonaStore*** array, int* length, int* size, FolksBackendsOfonoPersonaStore* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (FolksBackendsOfonoPersonaStore*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void folks_backends_ofono_backend_real_set_persona_stores (FolksBackend* base, GeeSet* storeids) {
	FolksBackendsOfonoBackend * self;
	gboolean added_stores = FALSE;
	FolksBackendsOfonoPersonaStore** removed_stores = NULL;
	FolksBackendsOfonoPersonaStore** _tmp0_ = NULL;
	gint removed_stores_length1 = 0;
	gint _removed_stores_size_ = 0;
	orgofonoModemProperties* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gboolean _tmp47_ = FALSE;
	gboolean _tmp48_ = FALSE;
	gboolean _tmp50_ = FALSE;
	self = (FolksBackendsOfonoBackend*) base;
	added_stores = FALSE;
	_tmp0_ = g_new0 (FolksBackendsOfonoPersonaStore*, 0 + 1);
	removed_stores = _tmp0_;
	removed_stores_length1 = 0;
	_removed_stores_size_ = removed_stores_length1;
	_tmp1_ = self->priv->_modems;
	_tmp1__length1 = self->priv->_modems_length1;
	{
		orgofonoModemProperties* modem_collection = NULL;
		gint modem_collection_length1 = 0;
		gint _modem_collection_size_ = 0;
		gint modem_it = 0;
		modem_collection = _tmp1_;
		modem_collection_length1 = _tmp1__length1;
		for (modem_it = 0; modem_it < _tmp1__length1; modem_it = modem_it + 1) {
			orgofonoModemProperties _tmp2_ = {0};
			orgofonoModemProperties modem = {0};
			org_ofono_modem_properties_copy (&modem_collection[modem_it], &_tmp2_);
			modem = _tmp2_;
			{
				gboolean _tmp3_ = FALSE;
				GeeSet* _tmp4_ = NULL;
				orgofonoModemProperties _tmp5_ = {0};
				const char* _tmp6_ = NULL;
				gboolean _tmp7_ = FALSE;
				gboolean _tmp12_ = FALSE;
				_tmp4_ = storeids;
				_tmp5_ = modem;
				_tmp6_ = _tmp5_.path;
				_tmp7_ = gee_collection_contains ((GeeCollection*) _tmp4_, (const gchar*) _tmp6_);
				if (_tmp7_) {
					GeeHashMap* _tmp8_ = NULL;
					orgofonoModemProperties _tmp9_ = {0};
					const char* _tmp10_ = NULL;
					gboolean _tmp11_ = FALSE;
					_tmp8_ = self->priv->_persona_stores;
					_tmp9_ = modem;
					_tmp10_ = _tmp9_.path;
					_tmp11_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp8_, (const gchar*) _tmp10_);
					_tmp3_ = _tmp11_ == FALSE;
				} else {
					_tmp3_ = FALSE;
				}
				_tmp12_ = _tmp3_;
				if (_tmp12_) {
					gchar* alias = NULL;
					orgofonoModemProperties _tmp13_ = {0};
					GHashTable* _tmp14_ = NULL;
					gchar* _tmp15_ = NULL;
					FolksBackendsOfonoPersonaStore* store = NULL;
					orgofonoModemProperties _tmp16_ = {0};
					const char* _tmp17_ = NULL;
					const gchar* _tmp18_ = NULL;
					FolksBackendsOfonoPersonaStore* _tmp19_ = NULL;
					FolksBackendsOfonoPersonaStore* _tmp20_ = NULL;
					_tmp13_ = modem;
					_tmp14_ = _tmp13_.properties;
					_tmp15_ = _folks_backends_ofono_backend_modem_alias (self, _tmp14_);
					alias = _tmp15_;
					_tmp16_ = modem;
					_tmp17_ = _tmp16_.path;
					_tmp18_ = alias;
					_tmp19_ = folks_backends_ofono_persona_store_new (_tmp17_, _tmp18_);
					store = _tmp19_;
					_tmp20_ = store;
					_folks_backends_ofono_backend_add_store (self, _tmp20_, FALSE);
					added_stores = TRUE;
					_g_object_unref0 (store);
					_g_free0 (alias);
				}
				org_ofono_modem_properties_destroy (&modem);
			}
		}
	}
	{
		GeeIterator* _store_it = NULL;
		GeeHashMap* _tmp21_ = NULL;
		GeeCollection* _tmp22_ = NULL;
		GeeCollection* _tmp23_ = NULL;
		GeeCollection* _tmp24_ = NULL;
		GeeIterator* _tmp25_ = NULL;
		GeeIterator* _tmp26_ = NULL;
		_tmp21_ = self->priv->_persona_stores;
		_tmp22_ = gee_abstract_map_get_values ((GeeMap*) _tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = _tmp23_;
		_tmp25_ = gee_iterable_iterator ((GeeIterable*) _tmp24_);
		_tmp26_ = _tmp25_;
		_g_object_unref0 (_tmp24_);
		_store_it = _tmp26_;
		while (TRUE) {
			GeeIterator* _tmp27_ = NULL;
			gboolean _tmp28_ = FALSE;
			FolksBackendsOfonoPersonaStore* store = NULL;
			GeeIterator* _tmp29_ = NULL;
			gpointer _tmp30_ = NULL;
			GeeSet* _tmp31_ = NULL;
			FolksBackendsOfonoPersonaStore* _tmp32_ = NULL;
			const gchar* _tmp33_ = NULL;
			const gchar* _tmp34_ = NULL;
			gboolean _tmp35_ = FALSE;
			_tmp27_ = _store_it;
			_tmp28_ = gee_iterator_next (_tmp27_);
			if (!_tmp28_) {
				break;
			}
			_tmp29_ = _store_it;
			_tmp30_ = gee_iterator_get (_tmp29_);
			store = (FolksBackendsOfonoPersonaStore*) _tmp30_;
			_tmp31_ = storeids;
			_tmp32_ = store;
			_tmp33_ = folks_persona_store_get_id ((FolksPersonaStore*) _tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = gee_collection_contains ((GeeCollection*) _tmp31_, _tmp34_);
			if (!_tmp35_) {
				FolksBackendsOfonoPersonaStore** _tmp36_ = NULL;
				gint _tmp36__length1 = 0;
				FolksBackendsOfonoPersonaStore* _tmp37_ = NULL;
				FolksBackendsOfonoPersonaStore* _tmp38_ = NULL;
				_tmp36_ = removed_stores;
				_tmp36__length1 = removed_stores_length1;
				_tmp37_ = store;
				_tmp38_ = _g_object_ref0 (_tmp37_);
				_vala_array_add1 (&removed_stores, &removed_stores_length1, &_removed_stores_size_, _tmp38_);
			}
			_g_object_unref0 (store);
		}
		_g_object_unref0 (_store_it);
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp39_ = FALSE;
			_tmp39_ = TRUE;
			while (TRUE) {
				gboolean _tmp40_ = FALSE;
				gint _tmp42_ = 0;
				FolksBackendsOfonoPersonaStore** _tmp43_ = NULL;
				gint _tmp43__length1 = 0;
				FolksBackendsOfonoPersonaStore** _tmp44_ = NULL;
				gint _tmp44__length1 = 0;
				gint _tmp45_ = 0;
				FolksBackendsOfonoPersonaStore* _tmp46_ = NULL;
				_tmp40_ = _tmp39_;
				if (!_tmp40_) {
					gint _tmp41_ = 0;
					_tmp41_ = i;
					i = _tmp41_ + 1;
				}
				_tmp39_ = FALSE;
				_tmp42_ = i;
				_tmp43_ = removed_stores;
				_tmp43__length1 = removed_stores_length1;
				if (!(_tmp42_ < _tmp43__length1)) {
					break;
				}
				_tmp44_ = removed_stores;
				_tmp44__length1 = removed_stores_length1;
				_tmp45_ = i;
				_tmp46_ = _tmp44_[_tmp45_];
				_folks_backends_ofono_backend_remove_store (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, FOLKS_BACKENDS_OFONO_TYPE_PERSONA_STORE, FolksBackendsOfonoPersonaStore), FALSE);
			}
		}
	}
	_tmp48_ = added_stores;
	if (_tmp48_) {
		_tmp47_ = TRUE;
	} else {
		FolksBackendsOfonoPersonaStore** _tmp49_ = NULL;
		gint _tmp49__length1 = 0;
		_tmp49_ = removed_stores;
		_tmp49__length1 = removed_stores_length1;
		_tmp47_ = _tmp49__length1 > 0;
	}
	_tmp50_ = _tmp47_;
	if (_tmp50_) {
		g_object_notify ((GObject*) self, "persona-stores");
	}
	removed_stores = (_vala_array_free (removed_stores, removed_stores_length1, (GDestroyNotify) g_object_unref), NULL);
}


/**
   * {@inheritDoc}
   */
FolksBackendsOfonoBackend* folks_backends_ofono_backend_construct (GType object_type) {
	FolksBackendsOfonoBackend * self = NULL;
	self = (FolksBackendsOfonoBackend*) g_object_new (object_type, NULL);
	return self;
}


FolksBackendsOfonoBackend* folks_backends_ofono_backend_new (void) {
	return folks_backends_ofono_backend_construct (FOLKS_BACKENDS_OFONO_TYPE_BACKEND);
}


static void _folks_backends_ofono_backend_add_modem (FolksBackendsOfonoBackend* self, const char* path, const gchar* alias) {
	FolksBackendsOfonoPersonaStore* store = NULL;
	const char* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	FolksBackendsOfonoPersonaStore* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (alias != NULL);
	_tmp0_ = path;
	_tmp1_ = alias;
	_tmp2_ = folks_backends_ofono_persona_store_new (_tmp0_, _tmp1_);
	store = _tmp2_;
	_folks_backends_ofono_backend_add_store (self, store, TRUE);
	_g_object_unref0 (store);
}


static void folks_backends_ofono_backend_real_prepare_data_free (gpointer _data) {
	FolksBackendsOfonoBackendPrepareData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendsOfonoBackendPrepareData, _data_);
}


static void folks_backends_ofono_backend_real_prepare (FolksBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendsOfonoBackend * self;
	FolksBackendsOfonoBackendPrepareData* _data_;
	FolksBackendsOfonoBackend* _tmp0_ = NULL;
	self = (FolksBackendsOfonoBackend*) base;
	_data_ = g_slice_new0 (FolksBackendsOfonoBackendPrepareData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_backends_ofono_backend_real_prepare);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_backends_ofono_backend_real_prepare_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	folks_backends_ofono_backend_real_prepare_co (_data_);
}


static void folks_backends_ofono_backend_real_prepare_finish (FolksBackend* base, GAsyncResult* _res_, GError** error) {
	FolksBackendsOfonoBackendPrepareData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   */
static void folks_backends_ofono_backend_prepare_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksBackendsOfonoBackendPrepareData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_backends_ofono_backend_real_prepare_co (_data_);
}


static void __folks_backends_ofono_backend_modem_added_org_ofono_manager_modem_added (orgofonoManager* _sender, const char* path, GHashTable* properties, gpointer self) {
	_folks_backends_ofono_backend_modem_added (self, path, properties);
}


static void __folks_backends_ofono_backend_modem_removed_org_ofono_manager_modem_removed (orgofonoManager* _sender, const char* path, gpointer self) {
	_folks_backends_ofono_backend_modem_removed (self, path);
}


static gboolean folks_backends_ofono_backend_real_prepare_co (FolksBackendsOfonoBackendPrepareData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	folks_internal_profiling_start ("preparing Ofono.Backend", NULL);
	_data_->_tmp1_ = FALSE;
	_data_->_tmp1_ = _data_->self->priv->_is_prepared;
	if (_data_->_tmp1_) {
		_data_->_tmp0_ = TRUE;
	} else {
		_data_->_tmp2_ = FALSE;
		_data_->_tmp2_ = _data_->self->priv->_prepare_pending;
		_data_->_tmp0_ = _data_->_tmp2_;
	}
	_data_->_tmp3_ = FALSE;
	_data_->_tmp3_ = _data_->_tmp0_;
	if (_data_->_tmp3_) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->self->priv->_prepare_pending = TRUE;
		_data_->_state_ = 1;
		g_async_initable_new_async (ORG_OFONO_TYPE_MANAGER_PROXY, 0, NULL, folks_backends_ofono_backend_prepare_ready, _data_, "g-flags", 0, "g-name", "org.ofono", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", "/", "g-interface-name", "org.ofono.Manager", NULL);
		return FALSE;
		_state_1:
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = g_async_initable_new_finish (_data_->_source_object_, _data_->_res_, &_data_->_inner_error_);
		_data_->manager = (orgofonoManager*) _data_->_tmp4_;
		if (_data_->_inner_error_ != NULL) {
			goto __finally0;
		}
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = _data_->manager;
		g_signal_connect_object (_data_->_tmp5_, "modem-added", (GCallback) __folks_backends_ofono_backend_modem_added_org_ofono_manager_modem_added, _data_->self, 0);
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = _data_->manager;
		g_signal_connect_object (_data_->_tmp6_, "modem-removed", (GCallback) __folks_backends_ofono_backend_modem_removed_org_ofono_manager_modem_removed, _data_->self, 0);
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = _data_->manager;
		_data_->_tmp9_ = 0;
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = org_ofono_manager_GetModems (_data_->_tmp8_, &_data_->_tmp9_, &_data_->_inner_error_);
		_data_->_tmp7__length1 = 0;
		_data_->__tmp7__size_ = 0;
		_data_->_tmp7_ = _data_->_tmp10_;
		_data_->_tmp7__length1 = _data_->_tmp9_;
		_data_->__tmp7__size_ = _data_->_tmp7__length1;
		if (_data_->_inner_error_ != NULL) {
			_g_object_unref0 (_data_->manager);
			goto __finally0;
		}
		_data_->self->priv->_modems = (_vala_orgofonoModemProperties_array_free (_data_->self->priv->_modems, _data_->self->priv->_modems_length1), NULL);
		_data_->self->priv->_modems = _data_->_tmp7_;
		_data_->self->priv->_modems_length1 = _data_->_tmp7__length1;
		_data_->self->priv->__modems_size_ = _data_->self->priv->_modems_length1;
		_data_->_tmp11_ = NULL;
		_data_->_tmp11__length1 = 0;
		_data_->_tmp11_ = _data_->self->priv->_modems;
		_data_->_tmp11__length1 = _data_->self->priv->_modems_length1;
		{
			_data_->modem_collection_length1 = 0;
			_data_->_modem_collection_size_ = 0;
			_data_->modem_collection = _data_->_tmp11_;
			_data_->modem_collection_length1 = _data_->_tmp11__length1;
			for (_data_->modem_it = 0; _data_->modem_it < _data_->_tmp11__length1; _data_->modem_it = _data_->modem_it + 1) {
				memset (&_data_->_tmp12_, 0, sizeof (orgofonoModemProperties));
				org_ofono_modem_properties_copy (&_data_->modem_collection[_data_->modem_it], &_data_->_tmp12_);
				_data_->modem = _data_->_tmp12_;
				{
					memset (&_data_->_tmp13_, 0, sizeof (orgofonoModemProperties));
					_data_->_tmp13_ = _data_->modem;
					_data_->_tmp14_ = NULL;
					_data_->_tmp14_ = _data_->_tmp13_.path;
					memset (&_data_->_tmp15_, 0, sizeof (orgofonoModemProperties));
					_data_->_tmp15_ = _data_->modem;
					_data_->_tmp16_ = NULL;
					_data_->_tmp16_ = _data_->_tmp15_.properties;
					_folks_backends_ofono_backend_modem_added (_data_->self, _data_->_tmp14_, _data_->_tmp16_);
					org_ofono_modem_properties_destroy (&_data_->modem);
				}
			}
		}
		g_object_freeze_notify ((GObject*) _data_->self);
		_data_->self->priv->_is_prepared = TRUE;
		g_object_notify ((GObject*) _data_->self, "is-prepared");
		_data_->self->priv->_is_quiescent = TRUE;
		g_object_notify ((GObject*) _data_->self, "is-quiescent");
		g_object_thaw_notify ((GObject*) _data_->self);
		_g_object_unref0 (_data_->manager);
	}
	__finally0:
	{
		_data_->self->priv->_prepare_pending = FALSE;
	}
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	folks_internal_profiling_end ("preparing Ofono.Backend", NULL);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void folks_backends_ofono_backend_real_unprepare_data_free (gpointer _data) {
	FolksBackendsOfonoBackendUnprepareData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendsOfonoBackendUnprepareData, _data_);
}


static void folks_backends_ofono_backend_real_unprepare (FolksBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendsOfonoBackend * self;
	FolksBackendsOfonoBackendUnprepareData* _data_;
	FolksBackendsOfonoBackend* _tmp0_ = NULL;
	self = (FolksBackendsOfonoBackend*) base;
	_data_ = g_slice_new0 (FolksBackendsOfonoBackendUnprepareData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_backends_ofono_backend_real_unprepare);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_backends_ofono_backend_real_unprepare_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	folks_backends_ofono_backend_real_unprepare_co (_data_);
}


static void folks_backends_ofono_backend_real_unprepare_finish (FolksBackend* base, GAsyncResult* _res_, GError** error) {
	FolksBackendsOfonoBackendUnprepareData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   */
static gboolean folks_backends_ofono_backend_real_unprepare_co (FolksBackendsOfonoBackendUnprepareData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = FALSE;
	_data_->_tmp1_ = _data_->self->priv->_is_prepared;
	if (!_data_->_tmp1_) {
		_data_->_tmp0_ = TRUE;
	} else {
		_data_->_tmp2_ = FALSE;
		_data_->_tmp2_ = _data_->self->priv->_prepare_pending;
		_data_->_tmp0_ = _data_->_tmp2_ == TRUE;
	}
	_data_->_tmp3_ = FALSE;
	_data_->_tmp3_ = _data_->_tmp0_;
	if (_data_->_tmp3_) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->self->priv->_prepare_pending = TRUE;
		{
			_data_->_tmp4_ = NULL;
			_data_->_tmp4_ = _data_->self->priv->_persona_stores;
			_data_->_tmp5_ = NULL;
			_data_->_tmp5_ = gee_abstract_map_get_values ((GeeMap*) _data_->_tmp4_);
			_data_->_tmp6_ = NULL;
			_data_->_tmp6_ = _data_->_tmp5_;
			_data_->_tmp7_ = NULL;
			_data_->_tmp7_ = _data_->_tmp6_;
			_data_->_tmp8_ = NULL;
			_data_->_tmp8_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp7_);
			_data_->_tmp9_ = NULL;
			_data_->_tmp9_ = _data_->_tmp8_;
			_g_object_unref0 (_data_->_tmp7_);
			_data_->_persona_store_it = _data_->_tmp9_;
			while (TRUE) {
				_data_->_tmp10_ = NULL;
				_data_->_tmp10_ = _data_->_persona_store_it;
				_data_->_tmp11_ = FALSE;
				_data_->_tmp11_ = gee_iterator_next (_data_->_tmp10_);
				if (!_data_->_tmp11_) {
					break;
				}
				_data_->_tmp12_ = NULL;
				_data_->_tmp12_ = _data_->_persona_store_it;
				_data_->_tmp13_ = NULL;
				_data_->_tmp13_ = gee_iterator_get (_data_->_tmp12_);
				_data_->persona_store = (FolksBackendsOfonoPersonaStore*) _data_->_tmp13_;
				_data_->_tmp14_ = NULL;
				_data_->_tmp14_ = _data_->persona_store;
				g_signal_emit_by_name ((FolksBackend*) _data_->self, "persona-store-removed", (FolksPersonaStore*) _data_->_tmp14_);
				_g_object_unref0 (_data_->persona_store);
			}
			_g_object_unref0 (_data_->_persona_store_it);
		}
		g_object_freeze_notify ((GObject*) _data_->self);
		_data_->_tmp15_ = NULL;
		_data_->_tmp15_ = _data_->self->priv->_persona_stores;
		gee_abstract_map_clear ((GeeAbstractMap*) _data_->_tmp15_);
		g_object_notify ((GObject*) _data_->self, "persona-stores");
		_data_->self->priv->_is_quiescent = FALSE;
		g_object_notify ((GObject*) _data_->self, "is-quiescent");
		_data_->self->priv->_is_prepared = FALSE;
		g_object_notify ((GObject*) _data_->self, "is-prepared");
		g_object_thaw_notify ((GObject*) _data_->self);
	}
	__finally1:
	{
		_data_->self->priv->_prepare_pending = FALSE;
	}
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


/**
   * Utility function to extract a modem's alias from its properties.
   *
   * @param properties, the properties of the modem.
   * @return the alias to use for this modem.
   */
static gpointer _g_variant_ref0 (gpointer self) {
	return self ? g_variant_ref (self) : NULL;
}


static gchar* _folks_backends_ofono_backend_modem_alias (FolksBackendsOfonoBackend* self, GHashTable* properties) {
	gchar* result = NULL;
	gchar* alias = NULL;
	gchar* _tmp0_ = NULL;
	GVariant* name_variant = NULL;
	GHashTable* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	GVariant* _tmp3_ = NULL;
	GVariant* manufacturer_variant = NULL;
	GHashTable* _tmp4_ = NULL;
	gconstpointer _tmp5_ = NULL;
	GVariant* _tmp6_ = NULL;
	GVariant* _tmp7_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (properties != NULL, NULL);
	_tmp0_ = g_strdup ("");
	alias = _tmp0_;
	_tmp1_ = properties;
	_tmp2_ = g_hash_table_lookup (_tmp1_, "Name");
	_tmp3_ = _g_variant_ref0 ((GVariant*) _tmp2_);
	name_variant = _tmp3_;
	_tmp4_ = properties;
	_tmp5_ = g_hash_table_lookup (_tmp4_, "Manufacturer");
	_tmp6_ = _g_variant_ref0 ((GVariant*) _tmp5_);
	manufacturer_variant = _tmp6_;
	_tmp7_ = name_variant;
	if (_tmp7_ != NULL) {
		GVariant* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		_tmp8_ = name_variant;
		_tmp9_ = g_variant_get_string (_tmp8_, NULL);
		_tmp10_ = g_strdup (_tmp9_);
		_g_free0 (alias);
		alias = _tmp10_;
	} else {
		GVariant* _tmp11_ = NULL;
		_tmp11_ = manufacturer_variant;
		if (_tmp11_ != NULL) {
			GVariant* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
			gchar* _tmp14_ = NULL;
			_tmp12_ = manufacturer_variant;
			_tmp13_ = g_variant_get_string (_tmp12_, NULL);
			_tmp14_ = g_strdup (_tmp13_);
			_g_free0 (alias);
			alias = _tmp14_;
		}
	}
	result = alias;
	_g_variant_unref0 (manufacturer_variant);
	_g_variant_unref0 (name_variant);
	return result;
}


static void _folks_backends_ofono_backend_modem_added (FolksBackendsOfonoBackend* self, const char* path, GHashTable* properties) {
	GVariant* features_variant = NULL;
	GHashTable* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	GVariant* _tmp2_ = NULL;
	GVariant* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (properties != NULL);
	_tmp0_ = properties;
	_tmp1_ = g_hash_table_lookup (_tmp0_, "Features");
	_tmp2_ = _g_variant_ref0 ((GVariant*) _tmp1_);
	features_variant = _tmp2_;
	_tmp3_ = features_variant;
	if (_tmp3_ != NULL) {
		gchar* alias = NULL;
		GHashTable* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar** features = NULL;
		GVariant* _tmp6_ = NULL;
		size_t _tmp7_;
		const gchar** _tmp8_ = NULL;
		gint features_length1 = 0;
		gint _features_size_ = 0;
		gchar** _tmp9_ = NULL;
		gint _tmp9__length1 = 0;
		_tmp4_ = properties;
		_tmp5_ = _folks_backends_ofono_backend_modem_alias (self, _tmp4_);
		alias = _tmp5_;
		_tmp6_ = features_variant;
		_tmp8_ = g_variant_get_strv (_tmp6_, &_tmp7_);
		features = _tmp8_;
		features_length1 = _tmp7_;
		_features_size_ = features_length1;
		_tmp9_ = features;
		_tmp9__length1 = features_length1;
		{
			gchar** feature_collection = NULL;
			gint feature_collection_length1 = 0;
			gint _feature_collection_size_ = 0;
			gint feature_it = 0;
			feature_collection = _tmp9_;
			feature_collection_length1 = _tmp9__length1;
			for (feature_it = 0; feature_it < _tmp9__length1; feature_it = feature_it + 1) {
				gchar* _tmp10_ = NULL;
				gchar* feature = NULL;
				_tmp10_ = g_strdup (feature_collection[feature_it]);
				feature = _tmp10_;
				{
					const gchar* _tmp11_ = NULL;
					_tmp11_ = feature;
					if (g_strcmp0 (_tmp11_, "sim") == 0) {
						const char* _tmp12_ = NULL;
						const gchar* _tmp13_ = NULL;
						_tmp12_ = path;
						_tmp13_ = alias;
						_folks_backends_ofono_backend_add_modem (self, _tmp12_, _tmp13_);
						_g_free0 (feature);
						break;
					}
					_g_free0 (feature);
				}
			}
		}
		features = (_vala_array_free (features, features_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (alias);
	}
	_g_variant_unref0 (features_variant);
}


/**
   * Utility function to add a persona store.
   *
   * @param store the store to add.
   * @param notify whether or not to emit notification signals.
   */
static void __folks_backends_ofono_backend_store_removed_cb_folks_persona_store_removed (FolksPersonaStore* _sender, gpointer self) {
	_folks_backends_ofono_backend_store_removed_cb (self, _sender);
}


static void _folks_backends_ofono_backend_add_store (FolksBackendsOfonoBackend* self, FolksBackendsOfonoPersonaStore* store, gboolean notify) {
	GeeHashMap* _tmp0_ = NULL;
	FolksBackendsOfonoPersonaStore* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	FolksBackendsOfonoPersonaStore* _tmp4_ = NULL;
	FolksBackendsOfonoPersonaStore* _tmp5_ = NULL;
	FolksBackendsOfonoPersonaStore* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	_tmp0_ = self->priv->_persona_stores;
	_tmp1_ = store;
	_tmp2_ = folks_persona_store_get_id ((FolksPersonaStore*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = store;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp0_, _tmp3_, _tmp4_);
	_tmp5_ = store;
	g_signal_connect_object ((FolksPersonaStore*) _tmp5_, "removed", (GCallback) __folks_backends_ofono_backend_store_removed_cb_folks_persona_store_removed, self, 0);
	_tmp6_ = store;
	g_signal_emit_by_name ((FolksBackend*) self, "persona-store-added", (FolksPersonaStore*) _tmp6_);
	_tmp7_ = notify;
	if (_tmp7_) {
		g_object_notify ((GObject*) self, "persona-stores");
	}
}


/**
   * Utility function to remove a persona store.
   *
   * @param store the store to remove.
   * @param notify whether or not to emit notification signals.
   */
static void _folks_backends_ofono_backend_remove_store (FolksBackendsOfonoBackend* self, FolksBackendsOfonoPersonaStore* store, gboolean notify) {
	FolksBackendsOfonoPersonaStore* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	GeeHashMap* _tmp2_ = NULL;
	FolksBackendsOfonoPersonaStore* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	FolksBackendsOfonoPersonaStore* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	_tmp0_ = store;
	g_signal_parse_name ("removed", FOLKS_TYPE_PERSONA_STORE, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((FolksPersonaStore*) _tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) __folks_backends_ofono_backend_store_removed_cb_folks_persona_store_removed, self);
	_tmp2_ = self->priv->_persona_stores;
	_tmp3_ = store;
	_tmp4_ = folks_persona_store_get_id ((FolksPersonaStore*) _tmp3_);
	_tmp5_ = _tmp4_;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp2_, _tmp5_, NULL);
	_tmp6_ = store;
	g_signal_emit_by_name ((FolksBackend*) self, "persona-store-removed", (FolksPersonaStore*) _tmp6_);
	_tmp7_ = notify;
	if (_tmp7_) {
		g_object_notify ((GObject*) self, "persona-stores");
	}
}


static void _folks_backends_ofono_backend_modem_removed (FolksBackendsOfonoBackend* self, const char* path) {
	GeeHashMap* _tmp0_ = NULL;
	const char* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = self->priv->_persona_stores;
	_tmp1_ = path;
	_tmp2_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, (const gchar*) _tmp1_);
	if (_tmp2_) {
		GeeHashMap* _tmp3_ = NULL;
		const char* _tmp4_ = NULL;
		gpointer _tmp5_ = NULL;
		FolksBackendsOfonoPersonaStore* _tmp6_ = NULL;
		_tmp3_ = self->priv->_persona_stores;
		_tmp4_ = path;
		_tmp5_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp3_, (const gchar*) _tmp4_);
		_tmp6_ = (FolksBackendsOfonoPersonaStore*) _tmp5_;
		_folks_backends_ofono_backend_store_removed_cb (self, (FolksPersonaStore*) _tmp6_);
		_g_object_unref0 (_tmp6_);
	}
}


static void _folks_backends_ofono_backend_store_removed_cb (FolksBackendsOfonoBackend* self, FolksPersonaStore* store) {
	FolksPersonaStore* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	_tmp0_ = store;
	_folks_backends_ofono_backend_remove_store (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, FOLKS_BACKENDS_OFONO_TYPE_PERSONA_STORE, FolksBackendsOfonoPersonaStore), TRUE);
}


static gboolean folks_backends_ofono_backend_real_get_is_prepared (FolksBackend* base) {
	gboolean result;
	FolksBackendsOfonoBackend* self;
	gboolean _tmp0_ = FALSE;
	self = (FolksBackendsOfonoBackend*) base;
	_tmp0_ = self->priv->_is_prepared;
	result = _tmp0_;
	return result;
}


static gboolean folks_backends_ofono_backend_real_get_is_quiescent (FolksBackend* base) {
	gboolean result;
	FolksBackendsOfonoBackend* self;
	gboolean _tmp0_ = FALSE;
	self = (FolksBackendsOfonoBackend*) base;
	_tmp0_ = self->priv->_is_quiescent;
	result = _tmp0_;
	return result;
}


static const gchar* folks_backends_ofono_backend_real_get_name (FolksBackend* base) {
	const gchar* result;
	FolksBackendsOfonoBackend* self;
	self = (FolksBackendsOfonoBackend*) base;
	result = BACKEND_NAME;
	return result;
}


static GeeMap* folks_backends_ofono_backend_real_get_persona_stores (FolksBackend* base) {
	GeeMap* result;
	FolksBackendsOfonoBackend* self;
	GeeMap* _tmp0_ = NULL;
	self = (FolksBackendsOfonoBackend*) base;
	_tmp0_ = self->priv->_persona_stores_ro;
	result = _tmp0_;
	return result;
}


static GObject * folks_backends_ofono_backend_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	FolksBackendsOfonoBackend * self;
	GeeHashMap* _tmp0_ = NULL;
	GeeHashMap* _tmp1_ = NULL;
	GeeMap* _tmp2_ = NULL;
	GeeMap* _tmp3_ = NULL;
	parent_class = G_OBJECT_CLASS (folks_backends_ofono_backend_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_BACKENDS_OFONO_TYPE_BACKEND, FolksBackendsOfonoBackend);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, FOLKS_BACKENDS_OFONO_TYPE_PERSONA_STORE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_persona_stores);
	self->priv->_persona_stores = _tmp0_;
	_tmp1_ = self->priv->_persona_stores;
	_tmp2_ = gee_abstract_map_get_read_only_view ((GeeAbstractMap*) _tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (self->priv->_persona_stores_ro);
	self->priv->_persona_stores_ro = _tmp3_;
	return obj;
}


static void folks_backends_ofono_backend_class_init (FolksBackendsOfonoBackendClass * klass) {
	folks_backends_ofono_backend_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksBackendsOfonoBackendPrivate));
	FOLKS_BACKEND_CLASS (klass)->disable_persona_store = folks_backends_ofono_backend_real_disable_persona_store;
	FOLKS_BACKEND_CLASS (klass)->enable_persona_store = folks_backends_ofono_backend_real_enable_persona_store;
	FOLKS_BACKEND_CLASS (klass)->set_persona_stores = folks_backends_ofono_backend_real_set_persona_stores;
	FOLKS_BACKEND_CLASS (klass)->prepare = folks_backends_ofono_backend_real_prepare;
	FOLKS_BACKEND_CLASS (klass)->prepare_finish = folks_backends_ofono_backend_real_prepare_finish;
	FOLKS_BACKEND_CLASS (klass)->unprepare = folks_backends_ofono_backend_real_unprepare;
	FOLKS_BACKEND_CLASS (klass)->unprepare_finish = folks_backends_ofono_backend_real_unprepare_finish;
	FOLKS_BACKEND_CLASS (klass)->get_is_prepared = folks_backends_ofono_backend_real_get_is_prepared;
	FOLKS_BACKEND_CLASS (klass)->get_is_quiescent = folks_backends_ofono_backend_real_get_is_quiescent;
	FOLKS_BACKEND_CLASS (klass)->get_name = folks_backends_ofono_backend_real_get_name;
	FOLKS_BACKEND_CLASS (klass)->get_persona_stores = folks_backends_ofono_backend_real_get_persona_stores;
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_backends_ofono_backend_get_property;
	G_OBJECT_CLASS (klass)->constructor = folks_backends_ofono_backend_constructor;
	G_OBJECT_CLASS (klass)->finalize = folks_backends_ofono_backend_finalize;
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_OFONO_BACKEND_IS_PREPARED, g_param_spec_boolean ("is-prepared", "is-prepared", "is-prepared", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_OFONO_BACKEND_IS_QUIESCENT, g_param_spec_boolean ("is-quiescent", "is-quiescent", "is-quiescent", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_OFONO_BACKEND_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_OFONO_BACKEND_PERSONA_STORES, g_param_spec_object ("persona-stores", "persona-stores", "persona-stores", GEE_TYPE_MAP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void folks_backends_ofono_backend_instance_init (FolksBackendsOfonoBackend * self) {
	self->priv = FOLKS_BACKENDS_OFONO_BACKEND_GET_PRIVATE (self);
	self->priv->_is_prepared = FALSE;
	self->priv->_prepare_pending = FALSE;
	self->priv->_is_quiescent = FALSE;
}


static void folks_backends_ofono_backend_finalize (GObject* obj) {
	FolksBackendsOfonoBackend * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_BACKENDS_OFONO_TYPE_BACKEND, FolksBackendsOfonoBackend);
	_g_object_unref0 (self->priv->_persona_stores);
	_g_object_unref0 (self->priv->_persona_stores_ro);
	self->priv->_modems = (_vala_orgofonoModemProperties_array_free (self->priv->_modems, self->priv->_modems_length1), NULL);
	G_OBJECT_CLASS (folks_backends_ofono_backend_parent_class)->finalize (obj);
}


/**
 * A backend which loads {@link Persona}s from Modem
 * devices using the Ofono Phonebook D-Bus API and presents them
 * using one {@link PersonaStore} per device.
 *
 * @since 0.9.0
 */
GType folks_backends_ofono_backend_get_type (void) {
	static volatile gsize folks_backends_ofono_backend_type_id__volatile = 0;
	if (g_once_init_enter (&folks_backends_ofono_backend_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksBackendsOfonoBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_backends_ofono_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksBackendsOfonoBackend), 0, (GInstanceInitFunc) folks_backends_ofono_backend_instance_init, NULL };
		GType folks_backends_ofono_backend_type_id;
		folks_backends_ofono_backend_type_id = g_type_register_static (FOLKS_TYPE_BACKEND, "FolksBackendsOfonoBackend", &g_define_type_info, 0);
		g_once_init_leave (&folks_backends_ofono_backend_type_id__volatile, folks_backends_ofono_backend_type_id);
	}
	return folks_backends_ofono_backend_type_id__volatile;
}


static void _vala_folks_backends_ofono_backend_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FolksBackendsOfonoBackend * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_BACKENDS_OFONO_TYPE_BACKEND, FolksBackendsOfonoBackend);
	switch (property_id) {
		case FOLKS_BACKENDS_OFONO_BACKEND_IS_PREPARED:
		g_value_set_boolean (value, folks_backend_get_is_prepared ((FolksBackend*) self));
		break;
		case FOLKS_BACKENDS_OFONO_BACKEND_IS_QUIESCENT:
		g_value_set_boolean (value, folks_backend_get_is_quiescent ((FolksBackend*) self));
		break;
		case FOLKS_BACKENDS_OFONO_BACKEND_NAME:
		g_value_set_string (value, folks_backend_get_name ((FolksBackend*) self));
		break;
		case FOLKS_BACKENDS_OFONO_BACKEND_PERSONA_STORES:
		g_value_set_object (value, folks_backend_get_persona_stores ((FolksBackend*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



