/* debug.c generated by valac 0.20.1.73-5d18, the Vala compiler
 * generated from debug.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <stdio.h>
#include <stdarg.h>


#define FOLKS_TYPE_DEBUG (folks_debug_get_type ())
#define FOLKS_DEBUG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_DEBUG, FolksDebug))
#define FOLKS_DEBUG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_DEBUG, FolksDebugClass))
#define FOLKS_IS_DEBUG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_DEBUG))
#define FOLKS_IS_DEBUG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_DEBUG))
#define FOLKS_DEBUG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_DEBUG, FolksDebugClass))

typedef struct _FolksDebug FolksDebug;
typedef struct _FolksDebugClass FolksDebugClass;
typedef struct _FolksDebugPrivate FolksDebugPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define FOLKS_DEBUG_TYPE_DOMAINS (folks_debug_domains_get_type ())

#define FOLKS_DEBUG_TYPE_KEY_VALUE_PAIR (folks_debug_key_value_pair_get_type ())
typedef struct _FolksDebugKeyValuePair FolksDebugKeyValuePair;

struct _FolksDebug {
	GObject parent_instance;
	FolksDebugPrivate * priv;
};

struct _FolksDebugClass {
	GObjectClass parent_class;
};

struct _FolksDebugPrivate {
	GeeHashSet* _domains;
	GStaticRecMutex __lock__domains;
	gboolean _all;
	guint _indentation;
	gchar* _indentation_string;
	gboolean _colour_enabled;
	GStaticRecMutex __lock__colour_enabled;
	GeeHashSet* _domains_handled;
	gboolean _debug_output_enabled;
	GStaticRecMutex __lock__debug_output_enabled;
};

typedef enum  {
	FOLKS_DEBUG_DOMAINS_CORE = 1 << 0,
	FOLKS_DEBUG_DOMAINS_TELEPATHY_BACKEND = 1 << 1,
	FOLKS_DEBUG_DOMAINS_KEY_FILE_BACKEND = 1 << 2
} FolksDebugDomains;

struct _FolksDebugKeyValuePair {
	gchar* key;
	gchar* val;
};


static gpointer folks_debug_parent_class = NULL;
static FolksDebug* folks_debug__instance;
static GStaticRecMutex __lock_folks_debug__instance = {0};
static FolksDebug* folks_debug__instance = NULL;

void g_log (const gchar* log_domain, GLogLevelFlags log_level, const gchar* format, ...);
GType folks_debug_get_type (void) G_GNUC_CONST;
#define FOLKS_DEBUG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_TYPE_DEBUG, FolksDebugPrivate))
enum  {
	FOLKS_DEBUG_DUMMY_PROPERTY,
	FOLKS_DEBUG_COLOUR_ENABLED,
	FOLKS_DEBUG_DEBUG_OUTPUT_ENABLED
};
static void _folks_debug_remove_handler (FolksDebug* self, const gchar* domain, gboolean keep_in_map);
static GType folks_debug_domains_get_type (void) G_GNUC_UNUSED;
#define FOLKS_DEBUG_STATUS_LOG_DOMAIN "folks-status"
static void _folks_debug_print_status_log_handler_cb (FolksDebug* self, const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message);
static void _folks_debug_log_handler_cb (FolksDebug* self, const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message);
gboolean folks_debug_get_debug_output_enabled (FolksDebug* self);
void _folks_debug_register_domain (FolksDebug* self, const gchar* domain);
static void _folks_debug_set_handler (FolksDebug* self, const gchar* domain, GLogLevelFlags flags, GLogFunc log_func, void* log_func_target);
static void __folks_debug_log_handler_cb_glog_func (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message, gpointer self);
static void __lambda63_ (FolksDebug* self, const gchar* domain_arg, GLogLevelFlags flags, const gchar* message);
static void ___lambda63__glog_func (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message, gpointer self);
FolksDebug* folks_debug_dup (void);
static FolksDebug* folks_debug_new (void);
static FolksDebug* folks_debug_construct (GType object_type);
FolksDebug* folks_debug_dup_with_flags (const gchar* debug_flags, gboolean colour_enabled);
void folks_debug_set_debug_output_enabled (FolksDebug* self, gboolean value);
void folks_debug_set_colour_enabled (FolksDebug* self, gboolean value);
void folks_debug_emit_print_status (FolksDebug* self);
void folks_debug_indent (FolksDebug* self);
void folks_debug_unindent (FolksDebug* self);
void folks_debug_print_line (FolksDebug* self, const gchar* domain, GLogLevelFlags level, const gchar* format, ...);
void folks_debug_print_heading (FolksDebug* self, const gchar* domain, GLogLevelFlags level, const gchar* format, ...);
gboolean folks_debug_get_colour_enabled (FolksDebug* self);
static gchar* _folks_debug_format_nullable_string (FolksDebug* self, const gchar* input);
void folks_debug_print_key_value_pairs (FolksDebug* self, const gchar* domain, GLogLevelFlags level, ...);
static GType folks_debug_key_value_pair_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static FolksDebugKeyValuePair* folks_debug_key_value_pair_dup (const FolksDebugKeyValuePair* self);
static void folks_debug_key_value_pair_free (FolksDebugKeyValuePair* self);
static void folks_debug_key_value_pair_copy (const FolksDebugKeyValuePair* self, FolksDebugKeyValuePair* dest);
static void folks_debug_key_value_pair_destroy (FolksDebugKeyValuePair* self);
static void _vala_array_add1 (FolksDebugKeyValuePair** array, int* length, int* size, const FolksDebugKeyValuePair* value);
static void _vala_FolksDebugKeyValuePair_array_free (FolksDebugKeyValuePair* array, gint array_length);
static GObject * folks_debug_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void __folks_debug_print_status_log_handler_cb_glog_func (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message, gpointer self);
static void folks_debug_finalize (GObject* obj);
static void _vala_folks_debug_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_folks_debug_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static GType folks_debug_domains_get_type (void) {
	static volatile gsize folks_debug_domains_type_id__volatile = 0;
	if (g_once_init_enter (&folks_debug_domains_type_id__volatile)) {
		static const GEnumValue values[] = {{FOLKS_DEBUG_DOMAINS_CORE, "FOLKS_DEBUG_DOMAINS_CORE", "core"}, {FOLKS_DEBUG_DOMAINS_TELEPATHY_BACKEND, "FOLKS_DEBUG_DOMAINS_TELEPATHY_BACKEND", "telepathy-backend"}, {FOLKS_DEBUG_DOMAINS_KEY_FILE_BACKEND, "FOLKS_DEBUG_DOMAINS_KEY_FILE_BACKEND", "key-file-backend"}, {0, NULL, NULL}};
		GType folks_debug_domains_type_id;
		folks_debug_domains_type_id = g_enum_register_static ("FolksDebugDomains", values);
		g_once_init_leave (&folks_debug_domains_type_id__volatile, folks_debug_domains_type_id);
	}
	return folks_debug_domains_type_id__volatile;
}


static void _folks_debug_print_status_log_handler_cb (FolksDebug* self, const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message) {
	FILE* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = stdout;
	_tmp1_ = message;
	fprintf (_tmp0_, "%s\n", _tmp1_);
}


static void _folks_debug_log_handler_cb (FolksDebug* self, const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GLogFunc _tmp2_ = NULL;
	void* _tmp2__target = NULL;
	const gchar* _tmp3_ = NULL;
	GLogLevelFlags _tmp4_ = 0;
	const gchar* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = folks_debug_get_debug_output_enabled (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == FALSE) {
		return;
	}
	_tmp2_ = g_log_default_handler;
	_tmp2__target = NULL;
	_tmp3_ = log_domain;
	_tmp4_ = log_levels;
	_tmp5_ = message;
	_tmp2_ (_tmp3_, _tmp4_, _tmp5_, _tmp2__target);
}


static void __folks_debug_log_handler_cb_glog_func (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message, gpointer self) {
	_folks_debug_log_handler_cb (self, log_domain, log_levels, message);
}


static void __lambda63_ (FolksDebug* self, const gchar* domain_arg, GLogLevelFlags flags, const gchar* message) {
	g_return_if_fail (message != NULL);
}


static void ___lambda63__glog_func (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message, gpointer self) {
	__lambda63_ (self, log_domain, log_levels, message);
}


void _folks_debug_register_domain (FolksDebug* self, const gchar* domain) {
	const gchar* _tmp12_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (domain != NULL);
	{
		GeeHashSet* _tmp0_ = NULL;
		_tmp0_ = self->priv->_domains;
		g_static_rec_mutex_lock (&self->priv->__lock__domains);
		{
			gboolean _tmp1_ = FALSE;
			gboolean _tmp2_ = FALSE;
			gboolean _tmp8_ = FALSE;
			_tmp2_ = self->priv->_all;
			if (_tmp2_) {
				_tmp1_ = TRUE;
			} else {
				GeeHashSet* _tmp3_ = NULL;
				const gchar* _tmp4_ = NULL;
				gchar* _tmp5_ = NULL;
				gchar* _tmp6_ = NULL;
				gboolean _tmp7_ = FALSE;
				_tmp3_ = self->priv->_domains;
				_tmp4_ = domain;
				_tmp5_ = g_utf8_strdown (_tmp4_, (gssize) (-1));
				_tmp6_ = _tmp5_;
				_tmp7_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp3_, _tmp6_);
				_tmp1_ = _tmp7_;
				_g_free0 (_tmp6_);
			}
			_tmp8_ = _tmp1_;
			if (_tmp8_) {
				const gchar* _tmp9_ = NULL;
				_tmp9_ = domain;
				_folks_debug_set_handler (self, _tmp9_, G_LOG_LEVEL_MASK, __folks_debug_log_handler_cb_glog_func, self);
				{
					GeeHashSet* _tmp10_ = NULL;
					_tmp10_ = self->priv->_domains;
					g_static_rec_mutex_unlock (&self->priv->__lock__domains);
				}
				return;
			}
		}
		__finally25:
		{
			GeeHashSet* _tmp11_ = NULL;
			_tmp11_ = self->priv->_domains;
			g_static_rec_mutex_unlock (&self->priv->__lock__domains);
		}
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp12_ = domain;
	_folks_debug_set_handler (self, _tmp12_, G_LOG_LEVEL_DEBUG, ___lambda63__glog_func, self);
}


/**
   * Create or return the singleton {@link Folks.Debug} class instance.
   * If the instance doesn't exist already, it will be created with no debug
   * domains enabled.
   *
   * This function is thread-safe.
   *
   * @return  Singleton {@link Folks.Debug} instance
   * @since 0.5.1
   */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


FolksDebug* folks_debug_dup (void) {
	FolksDebug* result = NULL;
	GError * _inner_error_ = NULL;
	{
		FolksDebug* _tmp0_ = NULL;
		_tmp0_ = folks_debug__instance;
		g_static_rec_mutex_lock (&__lock_folks_debug__instance);
		{
			FolksDebug* _retval = NULL;
			FolksDebug* _tmp1_ = NULL;
			FolksDebug* _tmp2_ = NULL;
			FolksDebug* retval = NULL;
			FolksDebug* _tmp3_ = NULL;
			_tmp1_ = folks_debug__instance;
			_tmp2_ = _g_object_ref0 (_tmp1_);
			_retval = _tmp2_;
			_tmp3_ = _retval;
			if (_tmp3_ == NULL) {
				FolksDebug* _tmp4_ = NULL;
				FolksDebug* _tmp5_ = NULL;
				_tmp4_ = folks_debug_new ();
				_g_object_unref0 (retval);
				retval = _tmp4_;
				_tmp5_ = retval;
				folks_debug__instance = _tmp5_;
			} else {
				FolksDebug* _tmp6_ = NULL;
				FolksDebug* _tmp7_ = NULL;
				_tmp6_ = _retval;
				_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, FOLKS_TYPE_DEBUG, FolksDebug));
				_g_object_unref0 (retval);
				retval = _tmp7_;
			}
			result = retval;
			_g_object_unref0 (_retval);
			{
				FolksDebug* _tmp8_ = NULL;
				_tmp8_ = folks_debug__instance;
				g_static_rec_mutex_unlock (&__lock_folks_debug__instance);
			}
			return result;
		}
		__finally26:
		{
			FolksDebug* _tmp9_ = NULL;
			_tmp9_ = folks_debug__instance;
			g_static_rec_mutex_unlock (&__lock_folks_debug__instance);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


/**
   * Create or return the singleton {@link Folks.Debug} class instance.
   * If the instance doesn't exist already, it will be created with the given
   * set of debug domains enabled. Otherwise, the existing instance will have
   * its set of enabled domains changed to the provided set.
   *
   * @param debug_flags A comma-separated list of debug domains to enable, or
   * null to disable debug output
   * @param colour_enabled Whether debug output should be coloured using
   * terminal escape sequences
   * @return Singleton {@link Folks.Debug} instance
   * @since 0.5.1
   */
FolksDebug* folks_debug_dup_with_flags (const gchar* debug_flags, gboolean colour_enabled) {
	FolksDebug* result = NULL;
	FolksDebug* retval = NULL;
	FolksDebug* _tmp0_ = NULL;
	gboolean _tmp26_ = FALSE;
	FolksDebug* _tmp27_ = NULL;
	gboolean _tmp28_ = FALSE;
	FolksDebug* _tmp33_ = NULL;
	gboolean _tmp34_ = FALSE;
	FolksDebug* _tmp35_ = NULL;
	gboolean _tmp36_ = FALSE;
	GError * _inner_error_ = NULL;
	_tmp0_ = folks_debug_dup ();
	retval = _tmp0_;
	{
		FolksDebug* _tmp1_ = NULL;
		GeeHashSet* _tmp2_ = NULL;
		_tmp1_ = retval;
		_tmp2_ = _tmp1_->priv->_domains;
		g_static_rec_mutex_lock (&_tmp1_->priv->__lock__domains);
		{
			FolksDebug* _tmp3_ = NULL;
			FolksDebug* _tmp4_ = NULL;
			GeeHashSet* _tmp5_ = NULL;
			gboolean _tmp6_ = FALSE;
			const gchar* _tmp7_ = NULL;
			gboolean _tmp9_ = FALSE;
			_tmp3_ = retval;
			_tmp3_->priv->_all = FALSE;
			_tmp4_ = retval;
			_tmp5_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL);
			_g_object_unref0 (_tmp4_->priv->_domains);
			_tmp4_->priv->_domains = _tmp5_;
			_tmp7_ = debug_flags;
			if (_tmp7_ != NULL) {
				const gchar* _tmp8_ = NULL;
				_tmp8_ = debug_flags;
				_tmp6_ = g_strcmp0 (_tmp8_, "") != 0;
			} else {
				_tmp6_ = FALSE;
			}
			_tmp9_ = _tmp6_;
			if (_tmp9_) {
				gchar** domains_split = NULL;
				const gchar* _tmp10_ = NULL;
				gchar** _tmp11_ = NULL;
				gchar** _tmp12_ = NULL;
				gint domains_split_length1 = 0;
				gint _domains_split_size_ = 0;
				gchar** _tmp13_ = NULL;
				gint _tmp13__length1 = 0;
				_tmp10_ = debug_flags;
				_tmp12_ = _tmp11_ = g_strsplit ((const gchar*) _tmp10_, ",", 0);
				domains_split = _tmp12_;
				domains_split_length1 = _vala_array_length (_tmp11_);
				_domains_split_size_ = domains_split_length1;
				_tmp13_ = domains_split;
				_tmp13__length1 = domains_split_length1;
				{
					gchar** domain_collection = NULL;
					gint domain_collection_length1 = 0;
					gint _domain_collection_size_ = 0;
					gint domain_it = 0;
					domain_collection = _tmp13_;
					domain_collection_length1 = _tmp13__length1;
					for (domain_it = 0; domain_it < _tmp13__length1; domain_it = domain_it + 1) {
						gchar* _tmp14_ = NULL;
						gchar* domain = NULL;
						_tmp14_ = g_strdup (domain_collection[domain_it]);
						domain = _tmp14_;
						{
							gchar* domain_lower = NULL;
							const gchar* _tmp15_ = NULL;
							gchar* _tmp16_ = NULL;
							GCompareFunc _tmp17_ = NULL;
							const gchar* _tmp18_ = NULL;
							gint _tmp19_ = 0;
							_tmp15_ = domain;
							_tmp16_ = g_utf8_strdown (_tmp15_, (gssize) (-1));
							domain_lower = _tmp16_;
							_tmp17_ = g_strcmp0;
							_tmp18_ = domain_lower;
							_tmp19_ = _tmp17_ (_tmp18_, "all");
							if (_tmp19_ == 0) {
								FolksDebug* _tmp20_ = NULL;
								_tmp20_ = retval;
								_tmp20_->priv->_all = TRUE;
							} else {
								FolksDebug* _tmp21_ = NULL;
								GeeHashSet* _tmp22_ = NULL;
								const gchar* _tmp23_ = NULL;
								_tmp21_ = retval;
								_tmp22_ = _tmp21_->priv->_domains;
								_tmp23_ = domain_lower;
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp22_, _tmp23_);
							}
							_g_free0 (domain_lower);
							_g_free0 (domain);
						}
					}
				}
				domains_split = (_vala_array_free (domains_split, domains_split_length1, (GDestroyNotify) g_free), NULL);
			}
		}
		__finally27:
		{
			FolksDebug* _tmp24_ = NULL;
			GeeHashSet* _tmp25_ = NULL;
			_tmp24_ = retval;
			_tmp25_ = _tmp24_->priv->_domains;
			g_static_rec_mutex_unlock (&_tmp24_->priv->__lock__domains);
		}
		if (_inner_error_ != NULL) {
			_g_object_unref0 (retval);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp27_ = retval;
	_tmp28_ = _tmp27_->priv->_all;
	if (_tmp28_) {
		_tmp26_ = TRUE;
	} else {
		FolksDebug* _tmp29_ = NULL;
		GeeHashSet* _tmp30_ = NULL;
		gboolean _tmp31_ = FALSE;
		gboolean _tmp32_ = FALSE;
		_tmp29_ = retval;
		_tmp30_ = _tmp29_->priv->_domains;
		_tmp31_ = gee_collection_get_is_empty ((GeeCollection*) _tmp30_);
		_tmp32_ = _tmp31_;
		_tmp26_ = !_tmp32_;
	}
	_tmp33_ = retval;
	_tmp34_ = _tmp26_;
	folks_debug_set_debug_output_enabled (_tmp33_, _tmp34_);
	_tmp35_ = retval;
	_tmp36_ = colour_enabled;
	folks_debug_set_colour_enabled (_tmp35_, _tmp36_);
	result = retval;
	return result;
}


static FolksDebug* folks_debug_construct (GType object_type) {
	FolksDebug * self = NULL;
	self = (FolksDebug*) g_object_new (object_type, NULL);
	return self;
}


static FolksDebug* folks_debug_new (void) {
	return folks_debug_construct (FOLKS_TYPE_DEBUG);
}


static void _folks_debug_set_handler (FolksDebug* self, const gchar* domain, GLogLevelFlags flags, GLogFunc log_func, void* log_func_target) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GLogLevelFlags _tmp2_ = 0;
	GLogFunc _tmp3_ = NULL;
	void* _tmp3__target = NULL;
	GeeHashSet* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (domain != NULL);
	_tmp0_ = domain;
	_folks_debug_remove_handler (self, _tmp0_, FALSE);
	_tmp1_ = domain;
	_tmp2_ = flags;
	_tmp3_ = log_func;
	_tmp3__target = log_func_target;
	g_log_set_handler (_tmp1_, _tmp2_, _tmp3_, _tmp3__target);
	_tmp4_ = self->priv->_domains_handled;
	_tmp5_ = domain;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp4_, _tmp5_);
}


static void _folks_debug_remove_handler (FolksDebug* self, const gchar* domain, gboolean keep_in_map) {
	GeeHashSet* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (domain != NULL);
	_tmp0_ = self->priv->_domains_handled;
	_tmp1_ = domain;
	_tmp2_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp0_, _tmp1_);
	if (_tmp2_) {
		const gchar* _tmp3_ = NULL;
		GLogFunc _tmp4_ = NULL;
		void* _tmp4__target = NULL;
		gboolean _tmp5_ = FALSE;
		_tmp3_ = domain;
		_tmp4_ = g_log_default_handler;
		_tmp4__target = NULL;
		g_log_set_handler (_tmp3_, (G_LOG_LEVEL_MASK | G_LOG_FLAG_RECURSION) | G_LOG_FLAG_FATAL, _tmp4_, _tmp4__target);
		_tmp5_ = keep_in_map;
		if (!_tmp5_) {
			GeeHashSet* _tmp6_ = NULL;
			const gchar* _tmp7_ = NULL;
			_tmp6_ = self->priv->_domains_handled;
			_tmp7_ = domain;
			gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp6_, _tmp7_);
		}
	}
}


/**
   * Causes all significant objects in the library to print their current
   * status to standard output, obeying the options set on this
   * {@link Folks.Debug} instance for colouring and other formatting.
   *
   * @since 0.5.1
   */
void folks_debug_emit_print_status (FolksDebug* self) {
	g_return_if_fail (self != NULL);
	g_print ("Dumping status information…\n");
	g_signal_emit_by_name (self, "print-status");
}


/**
   * Increment the indentation level used when printing output through the
   * object.
   *
   * This is intended to be used by backend libraries only.
   *
   * @since 0.5.1
   */
void folks_debug_indent (FolksDebug* self) {
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_indentation;
	self->priv->_indentation = _tmp0_ + 1;
	_tmp1_ = self->priv->_indentation;
	_tmp2_ = g_strnfill ((gsize) (_tmp1_ * 2), ' ');
	_g_free0 (self->priv->_indentation_string);
	self->priv->_indentation_string = _tmp2_;
}


/**
   * Decrement the indentation level used when printing output through the
   * object.
   *
   * This is intended to be used by backend libraries only.
   *
   * @since 0.5.1
   */
void folks_debug_unindent (FolksDebug* self) {
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_indentation;
	self->priv->_indentation = _tmp0_ - 1;
	_tmp1_ = self->priv->_indentation;
	_tmp2_ = g_strnfill ((gsize) (_tmp1_ * 2), ' ');
	_g_free0 (self->priv->_indentation_string);
	self->priv->_indentation_string = _tmp2_;
}


/**
   * Print a debug line with the current indentation level for the specified
   * debug domain.
   *
   * This is intended to be used by backend libraries only.
   *
   * @param domain The debug domain name
   * @param level A set of log level flags for the message
   * @param format A printf-style format string for the heading
   * @param ... Arguments for the format string
   * @since 0.5.1
   */
void folks_debug_print_line (FolksDebug* self, const gchar* domain, GLogLevelFlags level, const gchar* format, ...) {
	va_list valist = {0};
	gchar* output = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GLogLevelFlags _tmp3_ = 0;
	const gchar* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (domain != NULL);
	g_return_if_fail (format != NULL);
	va_start (valist, format);
	_tmp0_ = format;
	_tmp1_ = g_strdup_vprintf (_tmp0_, valist);
	output = _tmp1_;
	_tmp2_ = domain;
	_tmp3_ = level;
	_tmp4_ = self->priv->_indentation_string;
	g_log (_tmp2_, _tmp3_, "%s%s", _tmp4_, output);
	_g_free0 (output);
	va_end (valist);
}


/**
   * Print a debug line as a heading. It will be coloured according to the
   * current indentation level so that different levels of headings stand out.
   *
   * This is intended to be used by backend libraries only.
   *
   * @param domain The debug domain name
   * @param level A set of log level flags for the message
   * @param format A printf-style format string for the heading
   * @param ... Arguments for the format string
   * @since 0.5.1
   */
void folks_debug_print_heading (FolksDebug* self, const gchar* domain, GLogLevelFlags level, const gchar* format, ...) {
	static const gint heading_colours[] = {31, 32, 34};
	gchar* wrapper_format = NULL;
	gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	va_list valist = {0};
	gchar* output = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	GLogLevelFlags _tmp11_ = 0;
	const gchar* _tmp12_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (domain != NULL);
	g_return_if_fail (format != NULL);
	_tmp0_ = g_strdup ("%s");
	wrapper_format = _tmp0_;
	_tmp1_ = folks_debug_get_colour_enabled (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == TRUE) {
		guint indentation = 0U;
		guint _tmp3_ = 0U;
		guint _tmp4_ = 0U;
		guint _tmp5_ = 0U;
		gint _tmp6_ = 0;
		gchar* _tmp7_ = NULL;
		_tmp3_ = self->priv->_indentation;
		_tmp4_ = CLAMP (_tmp3_, (guint) 0, (guint) (G_N_ELEMENTS (heading_colours) - 1));
		indentation = _tmp4_;
		_tmp5_ = indentation;
		_tmp6_ = heading_colours[_tmp5_];
		_tmp7_ = g_strdup_printf ("\033[1;%im%%s\033[0m", _tmp6_);
		_g_free0 (wrapper_format);
		wrapper_format = _tmp7_;
	}
	va_start (valist, format);
	_tmp8_ = format;
	_tmp9_ = g_strdup_vprintf (_tmp8_, valist);
	output = _tmp9_;
	_tmp10_ = domain;
	_tmp11_ = level;
	_tmp12_ = wrapper_format;
	folks_debug_print_line (self, _tmp10_, _tmp11_, _tmp12_, output);
	_g_free0 (output);
	va_end (valist);
	_g_free0 (wrapper_format);
}


static gchar* _folks_debug_format_nullable_string (FolksDebug* self, const gchar* input) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = folks_debug_get_colour_enabled (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == TRUE) {
		const gchar* _tmp3_ = NULL;
		_tmp3_ = input;
		_tmp0_ = _tmp3_ == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp4_ = _tmp0_;
	if (_tmp4_) {
		gchar* _tmp5_ = NULL;
		_tmp5_ = g_strdup ("\033[1;36m(null)\033[0m");
		result = _tmp5_;
		return result;
	} else {
		const gchar* _tmp6_ = NULL;
		_tmp6_ = input;
		if (_tmp6_ == NULL) {
			gchar* _tmp7_ = NULL;
			_tmp7_ = g_strdup ("(null)");
			result = _tmp7_;
			return result;
		}
	}
	_tmp8_ = input;
	_tmp9_ = g_strdup ((const gchar*) _tmp8_);
	result = _tmp9_;
	return result;
}


/**
   * Print a set of key–value pairs in a table. The width of the key column is
   * automatically set to the width of the longest key. The keys and values
   * must be provided as a null-delimited list of alternating key–value varargs.
   * Values may be null but keys may not.
   *
   * This is intended to be used by backend libraries only.
   *
   * The table will be printed at the current indentation level plus one.
   *
   * @param domain The debug domain name
   * @param level A set of log level flags for the message
   * @param ... Alternating keys and values, terminated with null
   * @since 0.5.1
   */
static void _vala_array_add1 (FolksDebugKeyValuePair** array, int* length, int* size, const FolksDebugKeyValuePair* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (FolksDebugKeyValuePair, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static void _vala_FolksDebugKeyValuePair_array_free (FolksDebugKeyValuePair* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			folks_debug_key_value_pair_destroy (&array[i]);
		}
	}
	g_free (array);
}


void folks_debug_print_key_value_pairs (FolksDebug* self, const gchar* domain, GLogLevelFlags level, ...) {
	va_list valist = {0};
	FolksDebugKeyValuePair* lines = NULL;
	FolksDebugKeyValuePair* _tmp0_ = NULL;
	gint lines_length1 = 0;
	gint _lines_size_ = 0;
	guint max_key_length = 0U;
	FolksDebugKeyValuePair* _tmp19_ = NULL;
	gint _tmp19__length1 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (domain != NULL);
	va_start (valist, level);
	_tmp0_ = g_new0 (FolksDebugKeyValuePair, 0);
	lines = _tmp0_;
	lines_length1 = 0;
	_lines_size_ = lines_length1;
	max_key_length = (guint) 0;
	while (TRUE) {
		gchar* _key = NULL;
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		gchar* key = NULL;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* val = NULL;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		guint _tmp11_ = 0U;
		guint _tmp12_ = 0U;
		FolksDebugKeyValuePair* _tmp13_ = NULL;
		gint _tmp13__length1 = 0;
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		FolksDebugKeyValuePair _tmp18_ = {0};
		_tmp1_ = va_arg (valist, gchar*);
		_tmp2_ = g_strdup (_tmp1_);
		_key = _tmp2_;
		_tmp3_ = _key;
		if (_tmp3_ == NULL) {
			_g_free0 (_key);
			break;
		}
		_tmp4_ = _key;
		_tmp5_ = g_strdup ((const gchar*) _tmp4_);
		key = _tmp5_;
		_tmp6_ = va_arg (valist, gchar*);
		_tmp7_ = g_strdup (_tmp6_);
		val = _tmp7_;
		_tmp8_ = key;
		_tmp9_ = strlen (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = max_key_length;
		_tmp12_ = MAX ((guint) _tmp10_, _tmp11_);
		max_key_length = _tmp12_;
		_tmp13_ = lines;
		_tmp13__length1 = lines_length1;
		_tmp14_ = key;
		_tmp15_ = g_strdup (_tmp14_);
		_tmp16_ = val;
		_tmp17_ = g_strdup (_tmp16_);
		memset (&_tmp18_, 0, sizeof (FolksDebugKeyValuePair));
		_g_free0 (_tmp18_.key);
		_tmp18_.key = _tmp15_;
		_g_free0 (_tmp18_.val);
		_tmp18_.val = _tmp17_;
		_vala_array_add1 (&lines, &lines_length1, &_lines_size_, &_tmp18_);
		_g_free0 (val);
		_g_free0 (key);
		_g_free0 (_key);
	}
	folks_debug_indent (self);
	_tmp19_ = lines;
	_tmp19__length1 = lines_length1;
	{
		FolksDebugKeyValuePair* line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp19_;
		line_collection_length1 = _tmp19__length1;
		for (line_it = 0; line_it < _tmp19__length1; line_it = line_it + 1) {
			FolksDebugKeyValuePair _tmp20_ = {0};
			FolksDebugKeyValuePair line = {0};
			folks_debug_key_value_pair_copy (&line_collection[line_it], &_tmp20_);
			line = _tmp20_;
			{
				gchar* padding = NULL;
				guint _tmp21_ = 0U;
				FolksDebugKeyValuePair _tmp22_ = {0};
				const gchar* _tmp23_ = NULL;
				gint _tmp24_ = 0;
				gint _tmp25_ = 0;
				gchar* _tmp26_ = NULL;
				const gchar* _tmp27_ = NULL;
				GLogLevelFlags _tmp28_ = 0;
				FolksDebugKeyValuePair _tmp29_ = {0};
				const gchar* _tmp30_ = NULL;
				const gchar* _tmp31_ = NULL;
				FolksDebugKeyValuePair _tmp32_ = {0};
				const gchar* _tmp33_ = NULL;
				gchar* _tmp34_ = NULL;
				gchar* _tmp35_ = NULL;
				_tmp21_ = max_key_length;
				_tmp22_ = line;
				_tmp23_ = _tmp22_.key;
				_tmp24_ = strlen (_tmp23_);
				_tmp25_ = _tmp24_;
				_tmp26_ = g_strnfill ((gsize) (_tmp21_ - _tmp25_), ' ');
				padding = _tmp26_;
				_tmp27_ = domain;
				_tmp28_ = level;
				_tmp29_ = line;
				_tmp30_ = _tmp29_.key;
				_tmp31_ = padding;
				_tmp32_ = line;
				_tmp33_ = _tmp32_.val;
				_tmp34_ = _folks_debug_format_nullable_string (self, _tmp33_);
				_tmp35_ = _tmp34_;
				folks_debug_print_line (self, _tmp27_, _tmp28_, "%s: %s%s", _tmp30_, _tmp31_, _tmp35_);
				_g_free0 (_tmp35_);
				_g_free0 (padding);
				folks_debug_key_value_pair_destroy (&line);
			}
		}
	}
	folks_debug_unindent (self);
	lines = (_vala_FolksDebugKeyValuePair_array_free (lines, lines_length1), NULL);
	va_end (valist);
}


gboolean folks_debug_get_colour_enabled (FolksDebug* self) {
	gboolean result;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = self->priv->_colour_enabled;
		g_static_rec_mutex_lock (&self->priv->__lock__colour_enabled);
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = self->priv->_colour_enabled;
			result = _tmp1_;
			{
				gboolean _tmp2_ = FALSE;
				_tmp2_ = self->priv->_colour_enabled;
				g_static_rec_mutex_unlock (&self->priv->__lock__colour_enabled);
			}
			return result;
		}
		__finally28:
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = self->priv->_colour_enabled;
			g_static_rec_mutex_unlock (&self->priv->__lock__colour_enabled);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
}


void folks_debug_set_colour_enabled (FolksDebug* self, gboolean value) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = self->priv->_colour_enabled;
		g_static_rec_mutex_lock (&self->priv->__lock__colour_enabled);
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = value;
			self->priv->_colour_enabled = _tmp1_;
		}
		__finally29:
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = self->priv->_colour_enabled;
			g_static_rec_mutex_unlock (&self->priv->__lock__colour_enabled);
		}
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	g_object_notify ((GObject *) self, "colour-enabled");
}


gboolean folks_debug_get_debug_output_enabled (FolksDebug* self) {
	gboolean result;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = self->priv->_debug_output_enabled;
		g_static_rec_mutex_lock (&self->priv->__lock__debug_output_enabled);
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = self->priv->_debug_output_enabled;
			result = _tmp1_;
			{
				gboolean _tmp2_ = FALSE;
				_tmp2_ = self->priv->_debug_output_enabled;
				g_static_rec_mutex_unlock (&self->priv->__lock__debug_output_enabled);
			}
			return result;
		}
		__finally30:
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = self->priv->_debug_output_enabled;
			g_static_rec_mutex_unlock (&self->priv->__lock__debug_output_enabled);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
}


void folks_debug_set_debug_output_enabled (FolksDebug* self, gboolean value) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = self->priv->_debug_output_enabled;
		g_static_rec_mutex_lock (&self->priv->__lock__debug_output_enabled);
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = value;
			self->priv->_debug_output_enabled = _tmp1_;
		}
		__finally31:
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = self->priv->_debug_output_enabled;
			g_static_rec_mutex_unlock (&self->priv->__lock__debug_output_enabled);
		}
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	g_object_notify ((GObject *) self, "debug-output-enabled");
}


static void __folks_debug_print_status_log_handler_cb_glog_func (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message, gpointer self) {
	_folks_debug_print_status_log_handler_cb (self, log_domain, log_levels, message);
}


static GObject * folks_debug_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	FolksDebug * self;
	GeeHashSet* _tmp0_ = NULL;
	parent_class = G_OBJECT_CLASS (folks_debug_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_TYPE_DEBUG, FolksDebug);
	_tmp0_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_domains_handled);
	self->priv->_domains_handled = _tmp0_;
	_folks_debug_set_handler (self, FOLKS_DEBUG_STATUS_LOG_DOMAIN, G_LOG_LEVEL_MASK, __folks_debug_print_status_log_handler_cb_glog_func, self);
	return obj;
}


static void folks_debug_key_value_pair_copy (const FolksDebugKeyValuePair* self, FolksDebugKeyValuePair* dest) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = (*self).key;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).key);
	(*dest).key = _tmp1_;
	_tmp2_ = (*self).val;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).val);
	(*dest).val = _tmp3_;
}


static void folks_debug_key_value_pair_destroy (FolksDebugKeyValuePair* self) {
	_g_free0 ((*self).key);
	_g_free0 ((*self).val);
}


static FolksDebugKeyValuePair* folks_debug_key_value_pair_dup (const FolksDebugKeyValuePair* self) {
	FolksDebugKeyValuePair* dup;
	dup = g_new0 (FolksDebugKeyValuePair, 1);
	folks_debug_key_value_pair_copy (self, dup);
	return dup;
}


static void folks_debug_key_value_pair_free (FolksDebugKeyValuePair* self) {
	folks_debug_key_value_pair_destroy (self);
	g_free (self);
}


static GType folks_debug_key_value_pair_get_type (void) {
	static volatile gsize folks_debug_key_value_pair_type_id__volatile = 0;
	if (g_once_init_enter (&folks_debug_key_value_pair_type_id__volatile)) {
		GType folks_debug_key_value_pair_type_id;
		folks_debug_key_value_pair_type_id = g_boxed_type_register_static ("FolksDebugKeyValuePair", (GBoxedCopyFunc) folks_debug_key_value_pair_dup, (GBoxedFreeFunc) folks_debug_key_value_pair_free);
		g_once_init_leave (&folks_debug_key_value_pair_type_id__volatile, folks_debug_key_value_pair_type_id);
	}
	return folks_debug_key_value_pair_type_id__volatile;
}


static void folks_debug_class_init (FolksDebugClass * klass) {
	folks_debug_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksDebugPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_debug_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_folks_debug_set_property;
	G_OBJECT_CLASS (klass)->constructor = folks_debug_constructor;
	G_OBJECT_CLASS (klass)->finalize = folks_debug_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_DEBUG_COLOUR_ENABLED, g_param_spec_boolean ("colour-enabled", "colour-enabled", "colour-enabled", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * Whether debug output is enabled. This is orthogonal to the set of enabled
	   * debug domains; filtering of debug output as a whole is done after filtering
	   * by enabled domains.
	   *
	   * @since 0.5.1
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_DEBUG_DEBUG_OUTPUT_ENABLED, g_param_spec_boolean ("debug-output-enabled", "debug-output-enabled", "debug-output-enabled", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * Signal emitted in the main thread whenever objects should print their
	   * current status. All significant objects in the library should connect
	   * to this and print their current status in some suitable format when it's
	   * emitted.
	   *
	   * Client processes should emit this signal by calling
	   * {@link Debug.emit_print_status}.
	   *
	   * @since 0.5.1
	   */
	g_signal_new ("print_status", FOLKS_TYPE_DEBUG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_static_rec_mutex_init (&__lock_folks_debug__instance);
}


static void folks_debug_instance_init (FolksDebug * self) {
	gchar* _tmp0_ = NULL;
	self->priv = FOLKS_DEBUG_GET_PRIVATE (self);
	g_static_rec_mutex_init (&self->priv->__lock__domains);
	self->priv->_all = FALSE;
	self->priv->_indentation = (guint) 0;
	_tmp0_ = g_strdup ("");
	self->priv->_indentation_string = _tmp0_;
	g_static_rec_mutex_init (&self->priv->__lock__colour_enabled);
	self->priv->_colour_enabled = TRUE;
	g_static_rec_mutex_init (&self->priv->__lock__debug_output_enabled);
	self->priv->_debug_output_enabled = FALSE;
}


static void folks_debug_finalize (GObject* obj) {
	FolksDebug * self;
	GeeHashSet* _tmp7_ = NULL;
	GError * _inner_error_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_TYPE_DEBUG, FolksDebug);
	{
		GeeIterator* _domain_it = NULL;
		GeeHashSet* _tmp0_ = NULL;
		GeeIterator* _tmp1_ = NULL;
		_tmp0_ = self->priv->_domains_handled;
		_tmp1_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp0_);
		_domain_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_ = NULL;
			gboolean _tmp3_ = FALSE;
			gchar* domain = NULL;
			GeeIterator* _tmp4_ = NULL;
			gpointer _tmp5_ = NULL;
			const gchar* _tmp6_ = NULL;
			_tmp2_ = _domain_it;
			_tmp3_ = gee_iterator_next (_tmp2_);
			if (!_tmp3_) {
				break;
			}
			_tmp4_ = _domain_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			domain = (gchar*) _tmp5_;
			_tmp6_ = domain;
			_folks_debug_remove_handler (self, _tmp6_, TRUE);
			_g_free0 (domain);
		}
		_g_object_unref0 (_domain_it);
	}
	_tmp7_ = self->priv->_domains_handled;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp7_);
	{
		FolksDebug* _tmp8_ = NULL;
		_tmp8_ = folks_debug__instance;
		g_static_rec_mutex_lock (&__lock_folks_debug__instance);
		{
			folks_debug__instance = NULL;
		}
		__finally24:
		{
			FolksDebug* _tmp9_ = NULL;
			_tmp9_ = folks_debug__instance;
			g_static_rec_mutex_unlock (&__lock_folks_debug__instance);
		}
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
	}
	g_static_rec_mutex_free (&self->priv->__lock__domains);
	_g_object_unref0 (self->priv->_domains);
	_g_free0 (self->priv->_indentation_string);
	g_static_rec_mutex_free (&self->priv->__lock__colour_enabled);
	_g_object_unref0 (self->priv->_domains_handled);
	g_static_rec_mutex_free (&self->priv->__lock__debug_output_enabled);
	G_OBJECT_CLASS (folks_debug_parent_class)->finalize (obj);
}


/**
 * Manages debug output and status reporting for all folks objects.
 *
 * All GLib debug logging calls are passed through a log handler in this class,
 * which allows debug domains to be outputted according to whether they've been
 * enabled by being passed to {@link Debug.dup}.
 *
 * @since 0.5.1
 */
GType folks_debug_get_type (void) {
	static volatile gsize folks_debug_type_id__volatile = 0;
	if (g_once_init_enter (&folks_debug_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksDebugClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_debug_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksDebug), 0, (GInstanceInitFunc) folks_debug_instance_init, NULL };
		GType folks_debug_type_id;
		folks_debug_type_id = g_type_register_static (G_TYPE_OBJECT, "FolksDebug", &g_define_type_info, 0);
		g_once_init_leave (&folks_debug_type_id__volatile, folks_debug_type_id);
	}
	return folks_debug_type_id__volatile;
}


static void _vala_folks_debug_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FolksDebug * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_TYPE_DEBUG, FolksDebug);
	switch (property_id) {
		case FOLKS_DEBUG_COLOUR_ENABLED:
		g_value_set_boolean (value, folks_debug_get_colour_enabled (self));
		break;
		case FOLKS_DEBUG_DEBUG_OUTPUT_ENABLED:
		g_value_set_boolean (value, folks_debug_get_debug_output_enabled (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_folks_debug_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	FolksDebug * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_TYPE_DEBUG, FolksDebug);
	switch (property_id) {
		case FOLKS_DEBUG_COLOUR_ENABLED:
		folks_debug_set_colour_enabled (self, g_value_get_boolean (value));
		break;
		case FOLKS_DEBUG_DEBUG_OUTPUT_ENABLED:
		folks_debug_set_debug_output_enabled (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



