/* valamethodcall.c generated by valac, the Vala compiler
 * generated from valamethodcall.vala, do not modify */

/* valamethodcall.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _ValaMethodCallPrivate {
	gboolean _is_yield_expression;
	gboolean _is_assert;
	gboolean _is_constructv_chainup;
	gboolean _is_chainup;
	ValaExpression* _call;
	ValaList* argument_list;
};

static gint ValaMethodCall_private_offset;
static gpointer vala_method_call_parent_class = NULL;
static ValaCallableExpressionIface * vala_method_call_vala_callable_expression_parent_iface = NULL;

static void vala_method_call_set_call (ValaMethodCall* self,
                                ValaExpression* value);
static void vala_method_call_set_is_assert (ValaMethodCall* self,
                                     gboolean value);
static void vala_method_call_set_is_constructv_chainup (ValaMethodCall* self,
                                                 gboolean value);
static void vala_method_call_set_is_chainup (ValaMethodCall* self,
                                      gboolean value);
static void vala_method_call_real_add_argument (ValaCallableExpression* base,
                                         ValaExpression* arg);
static ValaList* vala_method_call_real_get_argument_list (ValaCallableExpression* base);
static void vala_method_call_real_accept (ValaCodeNode* base,
                                   ValaCodeVisitor* visitor);
static void vala_method_call_real_accept_children (ValaCodeNode* base,
                                            ValaCodeVisitor* visitor);
static void vala_method_call_real_replace_expression (ValaCodeNode* base,
                                               ValaExpression* old_node,
                                               ValaExpression* new_node);
static gboolean vala_method_call_real_is_constant (ValaExpression* base);
static gboolean vala_method_call_real_is_pure (ValaExpression* base);
static gboolean vala_method_call_real_is_accessible (ValaExpression* base,
                                              ValaSymbol* sym);
static void vala_method_call_real_get_error_types (ValaCodeNode* base,
                                            ValaCollection* collection,
                                            ValaSourceReference* source_reference);
static gboolean vala_method_call_real_check (ValaCodeNode* base,
                                      ValaCodeContext* context);
static void vala_method_call_real_emit (ValaCodeNode* base,
                                 ValaCodeGenerator* codegen);
static void vala_method_call_real_get_defined_variables (ValaCodeNode* base,
                                                  ValaCollection* collection);
static void vala_method_call_real_get_used_variables (ValaCodeNode* base,
                                               ValaCollection* collection);
static gchar* vala_method_call_real_to_string (ValaCodeNode* base);
static void vala_method_call_finalize (ValaCodeNode * obj);
static GType vala_method_call_get_type_once (void);

static inline gpointer
vala_method_call_get_instance_private (ValaMethodCall* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMethodCall_private_offset);
}

ValaExpression*
vala_method_call_get_call (ValaMethodCall* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_call;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static void
vala_method_call_set_call (ValaMethodCall* self,
                           ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_call);
	self->priv->_call = _tmp0_;
	_tmp1_ = self->priv->_call;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

static gboolean
vala_method_call_real_get_is_yield_expression (ValaCallableExpression* base)
{
	gboolean result;
	ValaMethodCall* self;
	self = (ValaMethodCall*) base;
	result = self->priv->_is_yield_expression;
	return result;
}

static void
vala_method_call_real_set_is_yield_expression (ValaCallableExpression* base,
                                               gboolean value)
{
	ValaMethodCall* self;
	self = (ValaMethodCall*) base;
	self->priv->_is_yield_expression = value;
}

gboolean
vala_method_call_get_is_assert (ValaMethodCall* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_assert;
	return result;
}

static void
vala_method_call_set_is_assert (ValaMethodCall* self,
                                gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_assert = value;
}

gboolean
vala_method_call_get_is_constructv_chainup (ValaMethodCall* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_constructv_chainup;
	return result;
}

static void
vala_method_call_set_is_constructv_chainup (ValaMethodCall* self,
                                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_constructv_chainup = value;
}

gboolean
vala_method_call_get_is_chainup (ValaMethodCall* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_chainup;
	return result;
}

static void
vala_method_call_set_is_chainup (ValaMethodCall* self,
                                 gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_chainup = value;
}

/**
 * Creates a new invocation expression.
 *
 * @param call             method to call
 * @param source_reference reference to source code
 * @return                 newly created invocation expression
 */
ValaMethodCall*
vala_method_call_construct (GType object_type,
                            ValaExpression* call,
                            ValaSourceReference* source_reference)
{
	ValaMethodCall* self = NULL;
	g_return_val_if_fail (call != NULL, NULL);
	self = (ValaMethodCall*) vala_expression_construct (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_method_call_set_call (self, call);
	return self;
}

ValaMethodCall*
vala_method_call_new (ValaExpression* call,
                      ValaSourceReference* source_reference)
{
	return vala_method_call_construct (VALA_TYPE_METHOD_CALL, call, source_reference);
}

/**
 * Appends the specified expression to the list of arguments.
 *
 * @param arg an argument
 */
static void
vala_method_call_real_add_argument (ValaCallableExpression* base,
                                    ValaExpression* arg)
{
	ValaMethodCall * self;
	ValaList* _tmp0_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}

/**
 * Returns the argument list.
 *
 * @return argument list
 */
static ValaList*
vala_method_call_real_get_argument_list (ValaCallableExpression* base)
{
	ValaMethodCall * self;
	ValaList* _tmp0_;
	ValaList* result = NULL;
	self = (ValaMethodCall*) base;
	_tmp0_ = self->priv->argument_list;
	result = _tmp0_;
	return result;
}

static void
vala_method_call_real_accept (ValaCodeNode* base,
                              ValaCodeVisitor* visitor)
{
	ValaMethodCall * self;
	self = (ValaMethodCall*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_method_call (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_method_call_real_accept_children (ValaCodeNode* base,
                                       ValaCodeVisitor* visitor)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp2_;
		gint _expr_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _expr_index = 0;
		_tmp2_ = self->priv->argument_list;
		_expr_list = _tmp2_;
		_tmp3_ = _expr_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_expr_size = _tmp5_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* expr = NULL;
			ValaList* _tmp8_;
			gpointer _tmp9_;
			ValaExpression* _tmp10_;
			_expr_index = _expr_index + 1;
			_tmp6_ = _expr_index;
			_tmp7_ = _expr_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _expr_list;
			_tmp9_ = vala_list_get (_tmp8_, _expr_index);
			expr = (ValaExpression*) _tmp9_;
			_tmp10_ = expr;
			vala_code_node_accept ((ValaCodeNode*) _tmp10_, visitor);
			_vala_code_node_unref0 (expr);
		}
	}
}

static void
vala_method_call_real_replace_expression (ValaCodeNode* base,
                                          ValaExpression* old_node,
                                          ValaExpression* new_node)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gint index = 0;
	ValaList* _tmp2_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_method_call_set_call (self, new_node);
	}
	_tmp2_ = self->priv->argument_list;
	index = vala_list_index_of (_tmp2_, old_node);
	if (index >= 0) {
		ValaList* _tmp3_;
		_tmp3_ = self->priv->argument_list;
		vala_list_set (_tmp3_, index, new_node);
		vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
	}
}

static gboolean
vala_method_call_real_is_constant (ValaExpression* base)
{
	ValaMethodCall * self;
	ValaMethodType* method_type = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaMethodType* _tmp4_;
	gboolean result = FALSE;
	self = (ValaMethodCall*) base;
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	method_type = VALA_IS_METHOD_TYPE (_tmp3_) ? ((ValaMethodType*) _tmp3_) : NULL;
	_tmp4_ = method_type;
	if (_tmp4_ != NULL) {
		ValaMethodType* _tmp5_;
		ValaMethod* _tmp6_;
		ValaMethod* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gboolean _tmp10_;
		_tmp5_ = method_type;
		_tmp6_ = vala_method_type_get_method_symbol (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strcmp0 (_tmp9_, "GLib.N_") == 0;
		_g_free0 (_tmp9_);
		if (_tmp10_) {
			ValaList* _tmp11_;
			gpointer _tmp12_;
			ValaExpression* _tmp13_;
			gboolean _tmp14_;
			_tmp11_ = self->priv->argument_list;
			_tmp12_ = vala_list_get (_tmp11_, 0);
			_tmp13_ = (ValaExpression*) _tmp12_;
			_tmp14_ = vala_expression_is_constant (_tmp13_);
			_vala_code_node_unref0 (_tmp13_);
			result = _tmp14_;
			return result;
		} else {
			ValaMethodType* _tmp15_;
			ValaMethod* _tmp16_;
			ValaMethod* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gboolean _tmp20_;
			_tmp15_ = method_type;
			_tmp16_ = vala_method_type_get_method_symbol (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = g_strcmp0 (_tmp19_, "GLib.NC_") == 0;
			_g_free0 (_tmp19_);
			if (_tmp20_) {
				gboolean _tmp21_ = FALSE;
				ValaList* _tmp22_;
				gpointer _tmp23_;
				ValaExpression* _tmp24_;
				gboolean _tmp25_;
				_tmp22_ = self->priv->argument_list;
				_tmp23_ = vala_list_get (_tmp22_, 0);
				_tmp24_ = (ValaExpression*) _tmp23_;
				_tmp25_ = vala_expression_is_constant (_tmp24_);
				_vala_code_node_unref0 (_tmp24_);
				if (_tmp25_) {
					ValaList* _tmp26_;
					gpointer _tmp27_;
					ValaExpression* _tmp28_;
					_tmp26_ = self->priv->argument_list;
					_tmp27_ = vala_list_get (_tmp26_, 1);
					_tmp28_ = (ValaExpression*) _tmp27_;
					_tmp21_ = vala_expression_is_constant (_tmp28_);
					_vala_code_node_unref0 (_tmp28_);
				} else {
					_tmp21_ = FALSE;
				}
				result = _tmp21_;
				return result;
			}
		}
	}
	result = FALSE;
	return result;
}

static gboolean
vala_method_call_real_is_pure (ValaExpression* base)
{
	ValaMethodCall * self;
	gboolean result = FALSE;
	self = (ValaMethodCall*) base;
	result = FALSE;
	return result;
}

static gboolean
vala_method_call_real_is_accessible (ValaExpression* base,
                                     ValaSymbol* sym)
{
	ValaMethodCall * self;
	ValaExpression* _tmp9_;
	ValaExpression* _tmp10_;
	gboolean result = FALSE;
	self = (ValaMethodCall*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		gint _arg_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_arg_list = _tmp0_;
		_tmp1_ = _arg_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_arg_size = _tmp3_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaExpression* arg = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaExpression* _tmp8_;
			_arg_index = _arg_index + 1;
			_tmp4_ = _arg_index;
			_tmp5_ = _arg_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _arg_list;
			_tmp7_ = vala_list_get (_tmp6_, _arg_index);
			arg = (ValaExpression*) _tmp7_;
			_tmp8_ = arg;
			if (!vala_expression_is_accessible (_tmp8_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (arg);
				return result;
			}
			_vala_code_node_unref0 (arg);
		}
	}
	_tmp9_ = vala_method_call_get_call (self);
	_tmp10_ = _tmp9_;
	result = vala_expression_is_accessible (_tmp10_, sym);
	return result;
}

static void
vala_method_call_real_get_error_types (ValaCodeNode* base,
                                       ValaCollection* collection,
                                       ValaSourceReference* source_reference)
{
	ValaMethodCall * self;
	ValaDataType* mtype = NULL;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	ValaDataType* _tmp6_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (collection != NULL);
	if (source_reference == NULL) {
		ValaSourceReference* _tmp0_;
		ValaSourceReference* _tmp1_;
		_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp1_ = _tmp0_;
		source_reference = _tmp1_;
	}
	_tmp2_ = vala_method_call_get_call (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_expression_get_value_type (_tmp3_);
	_tmp5_ = _tmp4_;
	mtype = _tmp5_;
	_tmp6_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp6_)) {
		ValaMethod* m = NULL;
		ValaDataType* _tmp7_;
		ValaMethod* _tmp8_;
		ValaMethod* _tmp9_;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		ValaMethod* _tmp12_;
		gboolean _tmp13_;
		gboolean _tmp14_;
		_tmp7_ = mtype;
		_tmp8_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp9_ = _tmp8_;
		m = _tmp9_;
		_tmp12_ = m;
		_tmp13_ = vala_method_get_coroutine (_tmp12_);
		_tmp14_ = _tmp13_;
		if (_tmp14_) {
			gboolean _tmp15_;
			gboolean _tmp16_;
			_tmp15_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) self);
			_tmp16_ = _tmp15_;
			_tmp11_ = !_tmp16_;
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			ValaExpression* _tmp17_;
			ValaExpression* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			_tmp17_ = vala_method_call_get_call (self);
			_tmp18_ = _tmp17_;
			_tmp19_ = vala_member_access_get_member_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp20_ = _tmp19_;
			_tmp10_ = g_strcmp0 (_tmp20_, "end") != 0;
		} else {
			_tmp10_ = FALSE;
		}
		if (!_tmp10_) {
			ValaMethod* _tmp21_;
			_tmp21_ = m;
			vala_code_node_get_error_types ((ValaCodeNode*) _tmp21_, collection, source_reference);
		}
	} else {
		ValaDataType* _tmp22_;
		_tmp22_ = mtype;
		if (VALA_IS_OBJECT_TYPE (_tmp22_)) {
			ValaClass* cl = NULL;
			ValaDataType* _tmp23_;
			ValaTypeSymbol* _tmp24_;
			ValaTypeSymbol* _tmp25_;
			ValaMethod* m = NULL;
			ValaClass* _tmp26_;
			ValaCreationMethod* _tmp27_;
			ValaCreationMethod* _tmp28_;
			ValaMethod* _tmp29_;
			_tmp23_ = mtype;
			_tmp24_ = vala_data_type_get_type_symbol ((ValaDataType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
			_tmp25_ = _tmp24_;
			cl = G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, VALA_TYPE_CLASS, ValaClass);
			_tmp26_ = cl;
			_tmp27_ = vala_class_get_default_construction_method (_tmp26_);
			_tmp28_ = _tmp27_;
			m = (ValaMethod*) _tmp28_;
			_tmp29_ = m;
			vala_code_node_get_error_types ((ValaCodeNode*) _tmp29_, collection, source_reference);
		} else {
			ValaDataType* _tmp30_;
			_tmp30_ = mtype;
			if (VALA_IS_DELEGATE_TYPE (_tmp30_)) {
				ValaDelegate* d = NULL;
				ValaDataType* _tmp31_;
				ValaDelegate* _tmp32_;
				ValaDelegate* _tmp33_;
				ValaDelegate* _tmp34_;
				_tmp31_ = mtype;
				_tmp32_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
				_tmp33_ = _tmp32_;
				d = _tmp33_;
				_tmp34_ = d;
				vala_code_node_get_error_types ((ValaCodeNode*) _tmp34_, collection, source_reference);
			}
		}
	}
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp35_;
		gint _expr_size = 0;
		ValaList* _tmp36_;
		gint _tmp37_;
		gint _tmp38_;
		gint _expr_index = 0;
		_tmp35_ = self->priv->argument_list;
		_expr_list = _tmp35_;
		_tmp36_ = _expr_list;
		_tmp37_ = vala_collection_get_size ((ValaCollection*) _tmp36_);
		_tmp38_ = _tmp37_;
		_expr_size = _tmp38_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp39_;
			gint _tmp40_;
			ValaExpression* expr = NULL;
			ValaList* _tmp41_;
			gpointer _tmp42_;
			ValaExpression* _tmp43_;
			_expr_index = _expr_index + 1;
			_tmp39_ = _expr_index;
			_tmp40_ = _expr_size;
			if (!(_tmp39_ < _tmp40_)) {
				break;
			}
			_tmp41_ = _expr_list;
			_tmp42_ = vala_list_get (_tmp41_, _expr_index);
			expr = (ValaExpression*) _tmp42_;
			_tmp43_ = expr;
			vala_code_node_get_error_types ((ValaCodeNode*) _tmp43_, collection, source_reference);
			_vala_code_node_unref0 (expr);
		}
	}
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static gboolean
vala_method_call_real_check (ValaCodeNode* base,
                             ValaCodeContext* context)
{
	ValaMethodCall * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaDataType* target_object_type = NULL;
	ValaList* method_type_args = NULL;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaDataType* _tmp8_;
	ValaDataType* _tmp9_;
	ValaDataType* mtype = NULL;
	ValaExpression* _tmp102_;
	ValaExpression* _tmp103_;
	ValaDataType* _tmp104_;
	ValaDataType* _tmp105_;
	ValaDataType* _tmp106_;
	gboolean _tmp107_ = FALSE;
	ValaProfile _tmp108_;
	ValaProfile _tmp109_;
	gboolean gobject_chainup = FALSE;
	ValaCreationMethod* base_cm = NULL;
	gboolean _tmp135_;
	gboolean _tmp221_ = FALSE;
	ValaExpression* _tmp222_;
	ValaExpression* _tmp223_;
	gboolean _tmp296_ = FALSE;
	gboolean _tmp297_;
	ValaDataType* ret_type = NULL;
	ValaDataType* _tmp312_;
	ValaDataType* _tmp313_;
	ValaDataType* _tmp314_;
	ValaList* params = NULL;
	ValaDataType* _tmp315_;
	ValaList* _tmp316_;
	ValaList* _tmp317_;
	ValaDataType* _tmp318_;
	ValaExpression* last_arg = NULL;
	ValaIterator* arg_it = NULL;
	ValaList* _tmp374_;
	ValaIterator* _tmp375_;
	gboolean _tmp425_ = FALSE;
	ValaDataType* _tmp426_;
	gboolean _tmp447_ = FALSE;
	ValaDataType* _tmp448_;
	gboolean force_lambda_method_closure = FALSE;
	gboolean _tmp528_ = FALSE;
	gboolean _tmp529_;
	gboolean _tmp530_;
	ValaDataType* _tmp550_;
	ValaDataType* _tmp561_;
	ValaDataType* _tmp562_;
	ValaDataType* _tmp563_;
	ValaDataType* _tmp564_;
	ValaDataType* _tmp565_;
	ValaDataType* _tmp566_;
	ValaList* _tmp567_;
	ValaDataType* _tmp568_;
	ValaDataType* _tmp569_;
	gboolean _tmp570_;
	gboolean _tmp571_;
	ValaDataType* _tmp594_;
	ValaSemanticAnalyzer* _tmp843_;
	ValaSemanticAnalyzer* _tmp844_;
	ValaDataType* _tmp845_;
	ValaList* _tmp846_;
	ValaList* _tmp847_;
	gboolean _tmp874_ = FALSE;
	gboolean _tmp875_ = FALSE;
	ValaCreationMethod* _tmp876_;
	ValaDataType* _tmp904_;
	ValaDataType* _tmp905_;
	gboolean _tmp906_;
	gboolean _tmp907_;
	gboolean _tmp968_;
	gboolean _tmp969_;
	gboolean result = FALSE;
	self = (ValaMethodCall*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_method_call_get_call (self);
	_tmp5_ = _tmp4_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp5_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	target_object_type = NULL;
	method_type_args = NULL;
	_tmp6_ = vala_method_call_get_call (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_expression_get_value_type (_tmp7_);
	_tmp9_ = _tmp8_;
	if (VALA_IS_DELEGATE_TYPE (_tmp9_)) {
		ValaExpression* _tmp10_;
		ValaExpression* _tmp11_;
		ValaDataType* _tmp12_;
		ValaDataType* _tmp13_;
		ValaDataType* _tmp14_;
		_tmp10_ = vala_method_call_get_call (self);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_expression_get_value_type (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = _vala_code_node_ref0 (_tmp13_);
		_vala_code_node_unref0 (target_object_type);
		target_object_type = _tmp14_;
	} else {
		ValaExpression* _tmp15_;
		ValaExpression* _tmp16_;
		_tmp15_ = vala_method_call_get_call (self);
		_tmp16_ = _tmp15_;
		if (VALA_IS_MEMBER_ACCESS (_tmp16_)) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp17_;
			ValaExpression* _tmp18_;
			ValaMemberAccess* _tmp19_;
			gboolean _tmp20_;
			gboolean _tmp21_;
			ValaMemberAccess* _tmp30_;
			ValaList* _tmp31_;
			ValaList* _tmp32_;
			ValaMemberAccess* _tmp33_;
			ValaExpression* _tmp34_;
			ValaExpression* _tmp35_;
			gboolean _tmp86_ = FALSE;
			ValaMemberAccess* _tmp87_;
			ValaSymbol* _tmp88_;
			ValaSymbol* _tmp89_;
			_tmp17_ = vala_method_call_get_call (self);
			_tmp18_ = _tmp17_;
			ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
			_tmp19_ = ma;
			_tmp20_ = vala_member_access_get_prototype_access (_tmp19_);
			_tmp21_ = _tmp20_;
			if (_tmp21_) {
				ValaSourceReference* _tmp22_;
				ValaSourceReference* _tmp23_;
				ValaExpression* _tmp24_;
				ValaExpression* _tmp25_;
				ValaSymbol* _tmp26_;
				ValaSymbol* _tmp27_;
				gchar* _tmp28_;
				gchar* _tmp29_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp22_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp23_ = _tmp22_;
				_tmp24_ = vala_method_call_get_call (self);
				_tmp25_ = _tmp24_;
				_tmp26_ = vala_expression_get_symbol_reference (_tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = vala_symbol_get_full_name (_tmp27_);
				_tmp29_ = _tmp28_;
				vala_report_error (_tmp23_, "Access to instance member `%s' denied", _tmp29_);
				_g_free0 (_tmp29_);
				result = FALSE;
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
			_tmp30_ = ma;
			_tmp31_ = vala_member_access_get_type_arguments (_tmp30_);
			_tmp32_ = _vala_iterable_ref0 (_tmp31_);
			_vala_iterable_unref0 (method_type_args);
			method_type_args = _tmp32_;
			_tmp33_ = ma;
			_tmp34_ = vala_member_access_get_inner (_tmp33_);
			_tmp35_ = _tmp34_;
			if (_tmp35_ != NULL) {
				ValaMemberAccess* _tmp36_;
				ValaExpression* _tmp37_;
				ValaExpression* _tmp38_;
				ValaDataType* _tmp39_;
				ValaDataType* _tmp40_;
				ValaDataType* _tmp41_;
				ValaMemberAccess* _tmp42_;
				ValaExpression* _tmp43_;
				ValaExpression* _tmp44_;
				ValaSymbol* _tmp45_;
				ValaSymbol* _tmp46_;
				ValaMethod* m = NULL;
				ValaMemberAccess* _tmp57_;
				ValaSymbol* _tmp58_;
				ValaSymbol* _tmp59_;
				gboolean _tmp60_ = FALSE;
				ValaMethod* _tmp61_;
				_tmp36_ = ma;
				_tmp37_ = vala_member_access_get_inner (_tmp36_);
				_tmp38_ = _tmp37_;
				_tmp39_ = vala_expression_get_value_type (_tmp38_);
				_tmp40_ = _tmp39_;
				_tmp41_ = _vala_code_node_ref0 (_tmp40_);
				_vala_code_node_unref0 (target_object_type);
				target_object_type = _tmp41_;
				_tmp42_ = ma;
				_tmp43_ = vala_member_access_get_inner (_tmp42_);
				_tmp44_ = _tmp43_;
				_tmp45_ = vala_expression_get_symbol_reference (_tmp44_);
				_tmp46_ = _tmp45_;
				if (VALA_IS_SIGNAL (_tmp46_)) {
					ValaMemberAccess* sig = NULL;
					ValaMemberAccess* _tmp47_;
					ValaExpression* _tmp48_;
					ValaExpression* _tmp49_;
					ValaMemberAccess* _tmp50_;
					_tmp47_ = ma;
					_tmp48_ = vala_member_access_get_inner (_tmp47_);
					_tmp49_ = _tmp48_;
					sig = VALA_IS_MEMBER_ACCESS (_tmp49_) ? ((ValaMemberAccess*) _tmp49_) : NULL;
					_tmp50_ = sig;
					if (_tmp50_ != NULL) {
						ValaMemberAccess* _tmp51_;
						ValaExpression* _tmp52_;
						ValaExpression* _tmp53_;
						ValaDataType* _tmp54_;
						ValaDataType* _tmp55_;
						ValaDataType* _tmp56_;
						_tmp51_ = sig;
						_tmp52_ = vala_member_access_get_inner (_tmp51_);
						_tmp53_ = _tmp52_;
						_tmp54_ = vala_expression_get_value_type (_tmp53_);
						_tmp55_ = _tmp54_;
						_tmp56_ = _vala_code_node_ref0 (_tmp55_);
						_vala_code_node_unref0 (target_object_type);
						target_object_type = _tmp56_;
					}
				}
				_tmp57_ = ma;
				_tmp58_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp57_);
				_tmp59_ = _tmp58_;
				m = VALA_IS_METHOD (_tmp59_) ? ((ValaMethod*) _tmp59_) : NULL;
				_tmp61_ = m;
				if (_tmp61_ != NULL) {
					ValaMethod* _tmp62_;
					gboolean _tmp63_;
					gboolean _tmp64_;
					_tmp62_ = m;
					_tmp63_ = vala_method_get_coroutine (_tmp62_);
					_tmp64_ = _tmp63_;
					_tmp60_ = _tmp64_;
				} else {
					_tmp60_ = FALSE;
				}
				if (_tmp60_) {
					gboolean _tmp65_ = FALSE;
					ValaMemberAccess* _tmp66_;
					const gchar* _tmp67_;
					const gchar* _tmp68_;
					_tmp66_ = ma;
					_tmp67_ = vala_member_access_get_member_name (_tmp66_);
					_tmp68_ = _tmp67_;
					if (g_strcmp0 (_tmp68_, "begin") == 0) {
						_tmp65_ = TRUE;
					} else {
						ValaMemberAccess* _tmp69_;
						const gchar* _tmp70_;
						const gchar* _tmp71_;
						_tmp69_ = ma;
						_tmp70_ = vala_member_access_get_member_name (_tmp69_);
						_tmp71_ = _tmp70_;
						_tmp65_ = g_strcmp0 (_tmp71_, "end") == 0;
					}
					if (_tmp65_) {
						ValaMemberAccess* method_access = NULL;
						ValaMemberAccess* _tmp72_;
						ValaExpression* _tmp73_;
						ValaExpression* _tmp74_;
						gboolean _tmp75_ = FALSE;
						ValaMemberAccess* _tmp76_;
						_tmp72_ = ma;
						_tmp73_ = vala_member_access_get_inner (_tmp72_);
						_tmp74_ = _tmp73_;
						method_access = VALA_IS_MEMBER_ACCESS (_tmp74_) ? ((ValaMemberAccess*) _tmp74_) : NULL;
						_tmp76_ = method_access;
						if (_tmp76_ != NULL) {
							ValaMemberAccess* _tmp77_;
							ValaExpression* _tmp78_;
							ValaExpression* _tmp79_;
							_tmp77_ = method_access;
							_tmp78_ = vala_member_access_get_inner (_tmp77_);
							_tmp79_ = _tmp78_;
							_tmp75_ = _tmp79_ != NULL;
						} else {
							_tmp75_ = FALSE;
						}
						if (_tmp75_) {
							ValaMemberAccess* _tmp80_;
							ValaExpression* _tmp81_;
							ValaExpression* _tmp82_;
							ValaDataType* _tmp83_;
							ValaDataType* _tmp84_;
							ValaDataType* _tmp85_;
							_tmp80_ = method_access;
							_tmp81_ = vala_member_access_get_inner (_tmp80_);
							_tmp82_ = _tmp81_;
							_tmp83_ = vala_expression_get_value_type (_tmp82_);
							_tmp84_ = _tmp83_;
							_tmp85_ = _vala_code_node_ref0 (_tmp84_);
							_vala_code_node_unref0 (target_object_type);
							target_object_type = _tmp85_;
						} else {
							_vala_code_node_unref0 (target_object_type);
							target_object_type = NULL;
						}
					}
				}
			}
			_tmp87_ = ma;
			_tmp88_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp87_);
			_tmp89_ = _tmp88_;
			if (_tmp89_ != NULL) {
				ValaMemberAccess* _tmp90_;
				ValaSymbol* _tmp91_;
				ValaSymbol* _tmp92_;
				ValaAttribute* _tmp93_;
				_tmp90_ = ma;
				_tmp91_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp90_);
				_tmp92_ = _tmp91_;
				_tmp93_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp92_, "Assert");
				_tmp86_ = _tmp93_ != NULL;
			} else {
				_tmp86_ = FALSE;
			}
			if (_tmp86_) {
				ValaList* _tmp94_;
				gint _tmp95_;
				gint _tmp96_;
				vala_method_call_set_is_assert (self, TRUE);
				_tmp94_ = self->priv->argument_list;
				_tmp95_ = vala_collection_get_size ((ValaCollection*) _tmp94_);
				_tmp96_ = _tmp95_;
				if (_tmp96_ == 1) {
					ValaList* _tmp97_;
					gpointer _tmp98_;
					ValaExpression* _tmp99_;
					ValaSourceReference* _tmp100_;
					ValaSourceReference* _tmp101_;
					_tmp97_ = self->priv->argument_list;
					_tmp98_ = vala_list_get (_tmp97_, 0);
					_tmp99_ = (ValaExpression*) _tmp98_;
					_tmp100_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp99_);
					_tmp101_ = _tmp100_;
					vala_code_node_set_source_reference ((ValaCodeNode*) self, _tmp101_);
					_vala_code_node_unref0 (_tmp99_);
				}
			}
		}
	}
	_tmp102_ = vala_method_call_get_call (self);
	_tmp103_ = _tmp102_;
	_tmp104_ = vala_expression_get_value_type (_tmp103_);
	_tmp105_ = _tmp104_;
	_tmp106_ = _vala_code_node_ref0 (_tmp105_);
	mtype = _tmp106_;
	_tmp108_ = vala_code_context_get_profile (context);
	_tmp109_ = _tmp108_;
	if (_tmp109_ == VALA_PROFILE_GOBJECT) {
		ValaExpression* _tmp110_;
		ValaExpression* _tmp111_;
		ValaSymbol* _tmp112_;
		ValaSymbol* _tmp113_;
		ValaSemanticAnalyzer* _tmp114_;
		ValaSemanticAnalyzer* _tmp115_;
		ValaClass* _tmp116_;
		_tmp110_ = vala_method_call_get_call (self);
		_tmp111_ = _tmp110_;
		_tmp112_ = vala_expression_get_symbol_reference (_tmp111_);
		_tmp113_ = _tmp112_;
		_tmp114_ = vala_code_context_get_analyzer (context);
		_tmp115_ = _tmp114_;
		_tmp116_ = _tmp115_->object_type;
		_tmp107_ = _tmp113_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp116_, VALA_TYPE_SYMBOL, ValaSymbol);
	} else {
		_tmp107_ = FALSE;
	}
	gobject_chainup = _tmp107_;
	vala_method_call_set_is_chainup (self, gobject_chainup);
	if (!gobject_chainup) {
		ValaExpression* expr = NULL;
		ValaExpression* _tmp117_;
		ValaExpression* _tmp118_;
		ValaMemberAccess* ma = NULL;
		ValaExpression* _tmp119_;
		gboolean _tmp120_ = FALSE;
		ValaMemberAccess* _tmp121_;
		gboolean _tmp129_ = FALSE;
		ValaMemberAccess* _tmp130_;
		_tmp117_ = vala_method_call_get_call (self);
		_tmp118_ = _tmp117_;
		expr = _tmp118_;
		_tmp119_ = expr;
		ma = VALA_IS_MEMBER_ACCESS (_tmp119_) ? ((ValaMemberAccess*) _tmp119_) : NULL;
		_tmp121_ = ma;
		if (_tmp121_ != NULL) {
			ValaMemberAccess* _tmp122_;
			ValaSymbol* _tmp123_;
			ValaSymbol* _tmp124_;
			_tmp122_ = ma;
			_tmp123_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp122_);
			_tmp124_ = _tmp123_;
			_tmp120_ = VALA_IS_CREATION_METHOD (_tmp124_);
		} else {
			_tmp120_ = FALSE;
		}
		if (_tmp120_) {
			ValaMemberAccess* _tmp125_;
			ValaExpression* _tmp126_;
			ValaExpression* _tmp127_;
			ValaExpression* _tmp128_;
			_tmp125_ = ma;
			_tmp126_ = vala_member_access_get_inner (_tmp125_);
			_tmp127_ = _tmp126_;
			expr = _tmp127_;
			_tmp128_ = expr;
			ma = VALA_IS_MEMBER_ACCESS (_tmp128_) ? ((ValaMemberAccess*) _tmp128_) : NULL;
		}
		_tmp130_ = ma;
		if (_tmp130_ != NULL) {
			ValaMemberAccess* _tmp131_;
			const gchar* _tmp132_;
			const gchar* _tmp133_;
			_tmp131_ = ma;
			_tmp132_ = vala_member_access_get_member_name (_tmp131_);
			_tmp133_ = _tmp132_;
			_tmp129_ = g_strcmp0 (_tmp133_, "this") == 0;
		} else {
			_tmp129_ = FALSE;
		}
		if (_tmp129_) {
			vala_method_call_set_is_chainup (self, TRUE);
		} else {
			ValaExpression* _tmp134_;
			_tmp134_ = expr;
			if (VALA_IS_BASE_ACCESS (_tmp134_)) {
				vala_method_call_set_is_chainup (self, TRUE);
			}
		}
	}
	base_cm = NULL;
	_tmp135_ = self->priv->_is_chainup;
	if (_tmp135_) {
		ValaCreationMethod* cm = NULL;
		ValaSemanticAnalyzer* _tmp136_;
		ValaSemanticAnalyzer* _tmp137_;
		ValaMethod* _tmp138_;
		ValaCreationMethod* _tmp139_;
		ValaCreationMethod* _tmp147_;
		ValaDataType* _tmp148_;
		_tmp136_ = vala_code_context_get_analyzer (context);
		_tmp137_ = _tmp136_;
		_tmp138_ = vala_semantic_analyzer_find_current_method (_tmp137_);
		cm = VALA_IS_CREATION_METHOD (_tmp138_) ? ((ValaCreationMethod*) _tmp138_) : NULL;
		_tmp139_ = cm;
		if (_tmp139_ == NULL) {
			ValaSourceReference* _tmp140_;
			ValaSourceReference* _tmp141_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp140_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp141_ = _tmp140_;
			vala_report_error (_tmp141_, "invocation not supported in this context");
			result = FALSE;
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		} else {
			ValaCreationMethod* _tmp142_;
			gboolean _tmp143_;
			gboolean _tmp144_;
			_tmp142_ = cm;
			_tmp143_ = vala_creation_method_get_chain_up (_tmp142_);
			_tmp144_ = _tmp143_;
			if (_tmp144_) {
				ValaSourceReference* _tmp145_;
				ValaSourceReference* _tmp146_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp145_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp146_ = _tmp145_;
				vala_report_error (_tmp146_, "Multiple constructor calls in the same constructor are not permitted");
				result = FALSE;
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
		_tmp147_ = cm;
		vala_creation_method_set_chain_up (_tmp147_, TRUE);
		_tmp148_ = mtype;
		if (VALA_IS_OBJECT_TYPE (_tmp148_)) {
			ValaClass* cl = NULL;
			ValaDataType* _tmp149_;
			ValaTypeSymbol* _tmp150_;
			ValaTypeSymbol* _tmp151_;
			ValaClass* _tmp152_;
			ValaCreationMethod* _tmp153_;
			ValaCreationMethod* _tmp154_;
			ValaCreationMethod* _tmp155_;
			_tmp149_ = mtype;
			_tmp150_ = vala_data_type_get_type_symbol ((ValaDataType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp149_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
			_tmp151_ = _tmp150_;
			cl = G_TYPE_CHECK_INSTANCE_CAST (_tmp151_, VALA_TYPE_CLASS, ValaClass);
			_tmp152_ = cl;
			_tmp153_ = vala_class_get_default_construction_method (_tmp152_);
			_tmp154_ = _tmp153_;
			base_cm = _tmp154_;
			_tmp155_ = base_cm;
			if (_tmp155_ == NULL) {
				ValaSourceReference* _tmp156_;
				ValaSourceReference* _tmp157_;
				ValaClass* _tmp158_;
				gchar* _tmp159_;
				gchar* _tmp160_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp156_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp157_ = _tmp156_;
				_tmp158_ = cl;
				_tmp159_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp158_);
				_tmp160_ = _tmp159_;
				vala_report_error (_tmp157_, "chain up to `%s' not supported", _tmp160_);
				_g_free0 (_tmp160_);
				result = FALSE;
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			} else {
				ValaCreationMethod* _tmp161_;
				gboolean _tmp162_;
				gboolean _tmp163_;
				_tmp161_ = base_cm;
				_tmp162_ = vala_method_get_has_construct_function ((ValaMethod*) _tmp161_);
				_tmp163_ = _tmp162_;
				if (!_tmp163_) {
					ValaSourceReference* _tmp164_;
					ValaSourceReference* _tmp165_;
					ValaCreationMethod* _tmp166_;
					gchar* _tmp167_;
					gchar* _tmp168_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp164_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp165_ = _tmp164_;
					_tmp166_ = base_cm;
					_tmp167_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp166_);
					_tmp168_ = _tmp167_;
					vala_report_error (_tmp165_, "chain up to `%s' not supported", _tmp168_);
					_g_free0 (_tmp168_);
					result = FALSE;
					_vala_code_node_unref0 (mtype);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (target_object_type);
					return result;
				}
			}
		} else {
			gboolean _tmp169_ = FALSE;
			ValaExpression* _tmp170_;
			ValaExpression* _tmp171_;
			ValaSymbol* _tmp172_;
			ValaSymbol* _tmp173_;
			_tmp170_ = vala_method_call_get_call (self);
			_tmp171_ = _tmp170_;
			_tmp172_ = vala_expression_get_symbol_reference (_tmp171_);
			_tmp173_ = _tmp172_;
			if (VALA_IS_CREATION_METHOD (_tmp173_)) {
				ValaExpression* _tmp174_;
				ValaExpression* _tmp175_;
				ValaSymbol* _tmp176_;
				ValaSymbol* _tmp177_;
				ValaSymbol* _tmp178_;
				ValaSymbol* _tmp179_;
				_tmp174_ = vala_method_call_get_call (self);
				_tmp175_ = _tmp174_;
				_tmp176_ = vala_expression_get_symbol_reference (_tmp175_);
				_tmp177_ = _tmp176_;
				_tmp178_ = vala_symbol_get_parent_symbol (_tmp177_);
				_tmp179_ = _tmp178_;
				_tmp169_ = VALA_IS_CLASS (_tmp179_);
			} else {
				_tmp169_ = FALSE;
			}
			if (_tmp169_) {
				ValaExpression* _tmp180_;
				ValaExpression* _tmp181_;
				ValaSymbol* _tmp182_;
				ValaSymbol* _tmp183_;
				ValaCreationMethod* _tmp184_;
				gboolean _tmp185_;
				gboolean _tmp186_;
				_tmp180_ = vala_method_call_get_call (self);
				_tmp181_ = _tmp180_;
				_tmp182_ = vala_expression_get_symbol_reference (_tmp181_);
				_tmp183_ = _tmp182_;
				base_cm = G_TYPE_CHECK_INSTANCE_CAST (_tmp183_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod);
				_tmp184_ = base_cm;
				_tmp185_ = vala_method_get_has_construct_function ((ValaMethod*) _tmp184_);
				_tmp186_ = _tmp185_;
				if (!_tmp186_) {
					ValaSourceReference* _tmp187_;
					ValaSourceReference* _tmp188_;
					ValaCreationMethod* _tmp189_;
					gchar* _tmp190_;
					gchar* _tmp191_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp187_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp188_ = _tmp187_;
					_tmp189_ = base_cm;
					_tmp190_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp189_);
					_tmp191_ = _tmp190_;
					vala_report_error (_tmp188_, "chain up to `%s' not supported", _tmp191_);
					_g_free0 (_tmp191_);
					result = FALSE;
					_vala_code_node_unref0 (mtype);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (target_object_type);
					return result;
				}
			} else {
				if (gobject_chainup) {
					ValaClass* cl = NULL;
					ValaCreationMethod* _tmp192_;
					ValaSymbol* _tmp193_;
					ValaSymbol* _tmp194_;
					gboolean _tmp195_ = FALSE;
					ValaClass* _tmp196_;
					ValaExpression* _tmp203_;
					ValaExpression* _tmp204_;
					ValaSemanticAnalyzer* _tmp205_;
					ValaSemanticAnalyzer* _tmp206_;
					ValaClass* _tmp207_;
					ValaObjectType* _tmp208_;
					ValaObjectType* _tmp209_;
					ValaExpression* _tmp210_;
					ValaExpression* _tmp211_;
					ValaDataType* _tmp212_;
					ValaDataType* _tmp213_;
					ValaSourceReference* _tmp214_;
					ValaSourceReference* _tmp215_;
					ValaExpression* _tmp216_;
					ValaExpression* _tmp217_;
					ValaDataType* _tmp218_;
					ValaDataType* _tmp219_;
					ValaDataType* _tmp220_;
					_tmp192_ = cm;
					_tmp193_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp192_);
					_tmp194_ = _tmp193_;
					cl = VALA_IS_CLASS (_tmp194_) ? ((ValaClass*) _tmp194_) : NULL;
					_tmp196_ = cl;
					if (_tmp196_ == NULL) {
						_tmp195_ = TRUE;
					} else {
						ValaClass* _tmp197_;
						ValaSemanticAnalyzer* _tmp198_;
						ValaSemanticAnalyzer* _tmp199_;
						ValaClass* _tmp200_;
						_tmp197_ = cl;
						_tmp198_ = vala_code_context_get_analyzer (context);
						_tmp199_ = _tmp198_;
						_tmp200_ = _tmp199_->object_type;
						_tmp195_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp197_, (ValaTypeSymbol*) _tmp200_);
					}
					if (_tmp195_) {
						ValaSourceReference* _tmp201_;
						ValaSourceReference* _tmp202_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp201_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp202_ = _tmp201_;
						vala_report_error (_tmp202_, "chain up to `GLib.Object' not supported");
						result = FALSE;
						_vala_code_node_unref0 (mtype);
						_vala_iterable_unref0 (method_type_args);
						_vala_code_node_unref0 (target_object_type);
						return result;
					}
					_tmp203_ = vala_method_call_get_call (self);
					_tmp204_ = _tmp203_;
					_tmp205_ = vala_code_context_get_analyzer (context);
					_tmp206_ = _tmp205_;
					_tmp207_ = _tmp206_->object_type;
					_tmp208_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp207_);
					_tmp209_ = _tmp208_;
					vala_expression_set_value_type (_tmp204_, (ValaDataType*) _tmp209_);
					_vala_code_node_unref0 (_tmp209_);
					_tmp210_ = vala_method_call_get_call (self);
					_tmp211_ = _tmp210_;
					_tmp212_ = vala_expression_get_value_type (_tmp211_);
					_tmp213_ = _tmp212_;
					_tmp214_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp215_ = _tmp214_;
					vala_code_node_set_source_reference ((ValaCodeNode*) _tmp213_, _tmp215_);
					_tmp216_ = vala_method_call_get_call (self);
					_tmp217_ = _tmp216_;
					_tmp218_ = vala_expression_get_value_type (_tmp217_);
					_tmp219_ = _tmp218_;
					_tmp220_ = _vala_code_node_ref0 (_tmp219_);
					_vala_code_node_unref0 (mtype);
					mtype = _tmp220_;
				}
			}
		}
	}
	_tmp222_ = vala_method_call_get_call (self);
	_tmp223_ = _tmp222_;
	if (VALA_IS_MEMBER_ACCESS (_tmp223_)) {
		gboolean _tmp224_ = FALSE;
		gboolean _tmp225_ = FALSE;
		ValaExpression* _tmp226_;
		ValaExpression* _tmp227_;
		ValaSymbol* _tmp228_;
		ValaSymbol* _tmp229_;
		_tmp226_ = vala_method_call_get_call (self);
		_tmp227_ = _tmp226_;
		_tmp228_ = vala_expression_get_symbol_reference (_tmp227_);
		_tmp229_ = _tmp228_;
		if (VALA_IS_CREATION_METHOD (_tmp229_)) {
			ValaExpression* _tmp230_;
			ValaExpression* _tmp231_;
			ValaSymbol* _tmp232_;
			ValaSymbol* _tmp233_;
			ValaSymbol* _tmp234_;
			ValaSymbol* _tmp235_;
			_tmp230_ = vala_method_call_get_call (self);
			_tmp231_ = _tmp230_;
			_tmp232_ = vala_expression_get_symbol_reference (_tmp231_);
			_tmp233_ = _tmp232_;
			_tmp234_ = vala_symbol_get_parent_symbol (_tmp233_);
			_tmp235_ = _tmp234_;
			_tmp225_ = VALA_IS_STRUCT (_tmp235_);
		} else {
			_tmp225_ = FALSE;
		}
		if (_tmp225_) {
			_tmp224_ = TRUE;
		} else {
			ValaExpression* _tmp236_;
			ValaExpression* _tmp237_;
			ValaSymbol* _tmp238_;
			ValaSymbol* _tmp239_;
			_tmp236_ = vala_method_call_get_call (self);
			_tmp237_ = _tmp236_;
			_tmp238_ = vala_expression_get_symbol_reference (_tmp237_);
			_tmp239_ = _tmp238_;
			_tmp224_ = VALA_IS_STRUCT (_tmp239_);
		}
		_tmp221_ = _tmp224_;
	} else {
		_tmp221_ = FALSE;
	}
	if (_tmp221_) {
		ValaStruct* st = NULL;
		ValaExpression* _tmp240_;
		ValaExpression* _tmp241_;
		ValaSymbol* _tmp242_;
		ValaSymbol* _tmp243_;
		gboolean _tmp244_ = FALSE;
		gboolean _tmp245_ = FALSE;
		ValaStruct* _tmp246_;
		ValaObjectCreationExpression* struct_creation_expression = NULL;
		ValaExpression* _tmp257_;
		ValaExpression* _tmp258_;
		ValaSourceReference* _tmp259_;
		ValaSourceReference* _tmp260_;
		ValaObjectCreationExpression* _tmp261_;
		ValaObjectCreationExpression* _tmp262_;
		ValaObjectCreationExpression* _tmp263_;
		gboolean _tmp264_;
		ValaObjectCreationExpression* _tmp275_;
		ValaDataType* _tmp276_;
		ValaDataType* _tmp277_;
		ValaSemanticAnalyzer* _tmp278_;
		ValaSemanticAnalyzer* _tmp279_;
		ValaList* _tmp280_;
		ValaCodeNode* _tmp281_;
		ValaCodeNode* _tmp282_;
		ValaObjectCreationExpression* _tmp283_;
		ValaObjectCreationExpression* _tmp284_;
		_tmp240_ = vala_method_call_get_call (self);
		_tmp241_ = _tmp240_;
		_tmp242_ = vala_expression_get_symbol_reference (_tmp241_);
		_tmp243_ = _tmp242_;
		st = VALA_IS_STRUCT (_tmp243_) ? ((ValaStruct*) _tmp243_) : NULL;
		_tmp246_ = st;
		if (_tmp246_ != NULL) {
			ValaStruct* _tmp247_;
			ValaCreationMethod* _tmp248_;
			ValaCreationMethod* _tmp249_;
			_tmp247_ = st;
			_tmp248_ = vala_struct_get_default_construction_method (_tmp247_);
			_tmp249_ = _tmp248_;
			_tmp245_ = _tmp249_ == NULL;
		} else {
			_tmp245_ = FALSE;
		}
		if (_tmp245_) {
			gboolean _tmp250_ = FALSE;
			gboolean _tmp251_ = FALSE;
			ValaStruct* _tmp252_;
			_tmp252_ = st;
			if (vala_struct_is_boolean_type (_tmp252_)) {
				_tmp251_ = TRUE;
			} else {
				ValaStruct* _tmp253_;
				_tmp253_ = st;
				_tmp251_ = vala_struct_is_integer_type (_tmp253_);
			}
			if (_tmp251_) {
				_tmp250_ = TRUE;
			} else {
				ValaStruct* _tmp254_;
				_tmp254_ = st;
				_tmp250_ = vala_struct_is_floating_type (_tmp254_);
			}
			_tmp244_ = _tmp250_;
		} else {
			_tmp244_ = FALSE;
		}
		if (_tmp244_) {
			ValaSourceReference* _tmp255_;
			ValaSourceReference* _tmp256_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp255_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp256_ = _tmp255_;
			vala_report_error (_tmp256_, "invocation not supported in this context");
			result = FALSE;
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
		_tmp257_ = vala_method_call_get_call (self);
		_tmp258_ = _tmp257_;
		_tmp259_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp260_ = _tmp259_;
		_tmp261_ = vala_object_creation_expression_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp258_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess), _tmp260_);
		struct_creation_expression = _tmp261_;
		_tmp262_ = struct_creation_expression;
		vala_object_creation_expression_set_struct_creation (_tmp262_, TRUE);
		_tmp263_ = struct_creation_expression;
		_tmp264_ = self->priv->_is_chainup;
		vala_object_creation_expression_set_is_chainup (_tmp263_, _tmp264_);
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp265_;
			gint _arg_size = 0;
			ValaList* _tmp266_;
			gint _tmp267_;
			gint _tmp268_;
			gint _arg_index = 0;
			_tmp265_ = self->priv->argument_list;
			_arg_list = _tmp265_;
			_tmp266_ = _arg_list;
			_tmp267_ = vala_collection_get_size ((ValaCollection*) _tmp266_);
			_tmp268_ = _tmp267_;
			_arg_size = _tmp268_;
			_arg_index = -1;
			while (TRUE) {
				gint _tmp269_;
				gint _tmp270_;
				ValaExpression* arg = NULL;
				ValaList* _tmp271_;
				gpointer _tmp272_;
				ValaObjectCreationExpression* _tmp273_;
				ValaExpression* _tmp274_;
				_arg_index = _arg_index + 1;
				_tmp269_ = _arg_index;
				_tmp270_ = _arg_size;
				if (!(_tmp269_ < _tmp270_)) {
					break;
				}
				_tmp271_ = _arg_list;
				_tmp272_ = vala_list_get (_tmp271_, _arg_index);
				arg = (ValaExpression*) _tmp272_;
				_tmp273_ = struct_creation_expression;
				_tmp274_ = arg;
				vala_callable_expression_add_argument ((ValaCallableExpression*) _tmp273_, _tmp274_);
				_vala_code_node_unref0 (arg);
			}
		}
		_tmp275_ = struct_creation_expression;
		_tmp276_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp277_ = _tmp276_;
		vala_expression_set_target_type ((ValaExpression*) _tmp275_, _tmp277_);
		_tmp278_ = vala_code_context_get_analyzer (context);
		_tmp279_ = _tmp278_;
		_tmp280_ = _tmp279_->replaced_nodes;
		vala_collection_add ((ValaCollection*) _tmp280_, (ValaCodeNode*) self);
		_tmp281_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp282_ = _tmp281_;
		_tmp283_ = struct_creation_expression;
		vala_code_node_replace_expression (_tmp282_, (ValaExpression*) self, (ValaExpression*) _tmp283_);
		_tmp284_ = struct_creation_expression;
		vala_code_node_check ((ValaCodeNode*) _tmp284_, context);
		result = TRUE;
		_vala_code_node_unref0 (struct_creation_expression);
		_vala_code_node_unref0 (mtype);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (target_object_type);
		return result;
	} else {
		gboolean _tmp285_ = FALSE;
		gboolean _tmp286_ = FALSE;
		gboolean _tmp287_;
		_tmp287_ = self->priv->_is_chainup;
		if (!_tmp287_) {
			ValaExpression* _tmp288_;
			ValaExpression* _tmp289_;
			_tmp288_ = vala_method_call_get_call (self);
			_tmp289_ = _tmp288_;
			_tmp286_ = VALA_IS_MEMBER_ACCESS (_tmp289_);
		} else {
			_tmp286_ = FALSE;
		}
		if (_tmp286_) {
			ValaExpression* _tmp290_;
			ValaExpression* _tmp291_;
			ValaSymbol* _tmp292_;
			ValaSymbol* _tmp293_;
			_tmp290_ = vala_method_call_get_call (self);
			_tmp291_ = _tmp290_;
			_tmp292_ = vala_expression_get_symbol_reference (_tmp291_);
			_tmp293_ = _tmp292_;
			_tmp285_ = VALA_IS_CREATION_METHOD (_tmp293_);
		} else {
			_tmp285_ = FALSE;
		}
		if (_tmp285_) {
			ValaSourceReference* _tmp294_;
			ValaSourceReference* _tmp295_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp294_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp295_ = _tmp294_;
			vala_report_error (_tmp295_, "use `new' operator to create new objects");
			result = FALSE;
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
	}
	_tmp297_ = self->priv->_is_chainup;
	if (!_tmp297_) {
		ValaDataType* _tmp298_;
		_tmp298_ = mtype;
		_tmp296_ = VALA_IS_OBJECT_TYPE (_tmp298_);
	} else {
		_tmp296_ = FALSE;
	}
	if (_tmp296_) {
		ValaSourceReference* _tmp299_;
		ValaSourceReference* _tmp300_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp299_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp300_ = _tmp299_;
		vala_report_error (_tmp300_, "invocation not supported in this context");
		result = FALSE;
		_vala_code_node_unref0 (mtype);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (target_object_type);
		return result;
	} else {
		gboolean _tmp301_ = FALSE;
		ValaDataType* _tmp302_;
		_tmp302_ = mtype;
		if (_tmp302_ != NULL) {
			ValaDataType* _tmp303_;
			_tmp303_ = mtype;
			_tmp301_ = vala_data_type_is_invokable (_tmp303_);
		} else {
			_tmp301_ = FALSE;
		}
		if (_tmp301_) {
		} else {
			ValaExpression* _tmp304_;
			ValaExpression* _tmp305_;
			ValaSymbol* _tmp306_;
			ValaSymbol* _tmp307_;
			_tmp304_ = vala_method_call_get_call (self);
			_tmp305_ = _tmp304_;
			_tmp306_ = vala_expression_get_symbol_reference (_tmp305_);
			_tmp307_ = _tmp306_;
			if (VALA_IS_CLASS (_tmp307_)) {
				ValaSourceReference* _tmp308_;
				ValaSourceReference* _tmp309_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp308_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp309_ = _tmp308_;
				vala_report_error (_tmp309_, "use `new' operator to create new objects");
				result = FALSE;
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			} else {
				ValaSourceReference* _tmp310_;
				ValaSourceReference* _tmp311_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp310_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp311_ = _tmp310_;
				vala_report_error (_tmp311_, "invocation not supported in this context");
				result = FALSE;
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
	}
	_tmp312_ = mtype;
	_tmp313_ = vala_data_type_get_return_type (_tmp312_);
	_tmp314_ = _vala_code_node_ref0 (_tmp313_);
	ret_type = _tmp314_;
	_tmp315_ = mtype;
	_tmp316_ = vala_data_type_get_parameters (_tmp315_);
	_tmp317_ = _vala_iterable_ref0 (_tmp316_);
	params = _tmp317_;
	_tmp318_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp318_)) {
		ValaMemberAccess* ma = NULL;
		ValaExpression* _tmp319_;
		ValaExpression* _tmp320_;
		ValaMethod* m = NULL;
		ValaDataType* _tmp321_;
		ValaMethod* _tmp322_;
		ValaMethod* _tmp323_;
		ValaMethod* _tmp324_;
		gboolean _tmp325_;
		gboolean _tmp326_;
		gint n_type_params = 0;
		ValaMethod* _tmp358_;
		ValaList* _tmp359_;
		gint _tmp360_;
		gint _tmp361_;
		gint n_type_args = 0;
		ValaMemberAccess* _tmp362_;
		ValaList* _tmp363_;
		gint _tmp364_;
		gint _tmp365_;
		gboolean _tmp366_ = FALSE;
		_tmp319_ = vala_method_call_get_call (self);
		_tmp320_ = _tmp319_;
		ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp320_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
		_tmp321_ = mtype;
		_tmp322_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp321_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp323_ = _tmp322_;
		m = _tmp323_;
		_tmp324_ = m;
		_tmp325_ = vala_method_get_coroutine (_tmp324_);
		_tmp326_ = _tmp325_;
		if (_tmp326_) {
			gboolean _tmp327_;
			gboolean _tmp328_;
			_tmp327_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) self);
			_tmp328_ = _tmp327_;
			if (!_tmp328_) {
				ValaMemberAccess* _tmp329_;
				const gchar* _tmp330_;
				const gchar* _tmp331_;
				_tmp329_ = ma;
				_tmp330_ = vala_member_access_get_member_name (_tmp329_);
				_tmp331_ = _tmp330_;
				if (g_strcmp0 (_tmp331_, "end") != 0) {
					ValaMemberAccess* _tmp332_;
					const gchar* _tmp333_;
					const gchar* _tmp334_;
					ValaMethod* _tmp338_;
					ValaList* _tmp339_;
					ValaList* _tmp340_;
					ValaVoidType* _tmp341_;
					_tmp332_ = ma;
					_tmp333_ = vala_member_access_get_member_name (_tmp332_);
					_tmp334_ = _tmp333_;
					if (g_strcmp0 (_tmp334_, "begin") != 0) {
						ValaMemberAccess* _tmp335_;
						ValaSourceReference* _tmp336_;
						ValaSourceReference* _tmp337_;
						_tmp335_ = ma;
						_tmp336_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp335_);
						_tmp337_ = _tmp336_;
						vala_report_deprecated (_tmp337_, "implicit .begin is deprecated");
					}
					_tmp338_ = m;
					_tmp339_ = vala_method_get_async_begin_parameters (_tmp338_);
					_tmp340_ = _vala_iterable_ref0 (_tmp339_);
					_vala_iterable_unref0 (params);
					params = _tmp340_;
					_tmp341_ = vala_void_type_new (NULL);
					_vala_code_node_unref0 (ret_type);
					ret_type = (ValaDataType*) _tmp341_;
				} else {
					ValaMethod* _tmp342_;
					ValaList* _tmp343_;
					ValaList* _tmp344_;
					_tmp342_ = m;
					_tmp343_ = vala_method_get_async_end_parameters (_tmp342_);
					_tmp344_ = _vala_iterable_ref0 (_tmp343_);
					_vala_iterable_unref0 (params);
					params = _tmp344_;
				}
			} else {
				gboolean _tmp345_ = FALSE;
				ValaMemberAccess* _tmp346_;
				const gchar* _tmp347_;
				const gchar* _tmp348_;
				_tmp346_ = ma;
				_tmp347_ = vala_member_access_get_member_name (_tmp346_);
				_tmp348_ = _tmp347_;
				if (g_strcmp0 (_tmp348_, "begin") == 0) {
					_tmp345_ = TRUE;
				} else {
					ValaMemberAccess* _tmp349_;
					const gchar* _tmp350_;
					const gchar* _tmp351_;
					_tmp349_ = ma;
					_tmp350_ = vala_member_access_get_member_name (_tmp349_);
					_tmp351_ = _tmp350_;
					_tmp345_ = g_strcmp0 (_tmp351_, "end") == 0;
				}
				if (_tmp345_) {
					ValaMemberAccess* _tmp352_;
					ValaSourceReference* _tmp353_;
					ValaSourceReference* _tmp354_;
					ValaMemberAccess* _tmp355_;
					const gchar* _tmp356_;
					const gchar* _tmp357_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp352_ = ma;
					_tmp353_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp352_);
					_tmp354_ = _tmp353_;
					_tmp355_ = ma;
					_tmp356_ = vala_member_access_get_member_name (_tmp355_);
					_tmp357_ = _tmp356_;
					vala_report_error (_tmp354_, "use of `%s' not allowed in yield statement", _tmp357_);
				}
			}
		}
		_tmp358_ = m;
		_tmp359_ = vala_method_get_type_parameters (_tmp358_);
		_tmp360_ = vala_collection_get_size ((ValaCollection*) _tmp359_);
		_tmp361_ = _tmp360_;
		n_type_params = _tmp361_;
		_tmp362_ = ma;
		_tmp363_ = vala_member_access_get_type_arguments (_tmp362_);
		_tmp364_ = vala_collection_get_size ((ValaCollection*) _tmp363_);
		_tmp365_ = _tmp364_;
		n_type_args = _tmp365_;
		if (n_type_args > 0) {
			_tmp366_ = n_type_args < n_type_params;
		} else {
			_tmp366_ = FALSE;
		}
		if (_tmp366_) {
			ValaMemberAccess* _tmp367_;
			ValaSourceReference* _tmp368_;
			ValaSourceReference* _tmp369_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp367_ = ma;
			_tmp368_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp367_);
			_tmp369_ = _tmp368_;
			vala_report_error (_tmp369_, "too few type arguments");
			result = FALSE;
			_vala_iterable_unref0 (params);
			_vala_code_node_unref0 (ret_type);
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		} else {
			gboolean _tmp370_ = FALSE;
			if (n_type_args > 0) {
				_tmp370_ = n_type_args > n_type_params;
			} else {
				_tmp370_ = FALSE;
			}
			if (_tmp370_) {
				ValaMemberAccess* _tmp371_;
				ValaSourceReference* _tmp372_;
				ValaSourceReference* _tmp373_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp371_ = ma;
				_tmp372_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp371_);
				_tmp373_ = _tmp372_;
				vala_report_error (_tmp373_, "too many type arguments");
				result = FALSE;
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (ret_type);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
	}
	last_arg = NULL;
	_tmp374_ = self->priv->argument_list;
	_tmp375_ = vala_iterable_iterator ((ValaIterable*) _tmp374_);
	arg_it = _tmp375_;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp376_;
		gint _param_size = 0;
		ValaList* _tmp377_;
		gint _tmp378_;
		gint _tmp379_;
		gint _param_index = 0;
		_tmp376_ = params;
		_param_list = _tmp376_;
		_tmp377_ = _param_list;
		_tmp378_ = vala_collection_get_size ((ValaCollection*) _tmp377_);
		_tmp379_ = _tmp378_;
		_param_size = _tmp379_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp380_;
			gint _tmp381_;
			ValaParameter* param = NULL;
			ValaList* _tmp382_;
			gpointer _tmp383_;
			ValaParameter* _tmp384_;
			ValaParameter* _tmp385_;
			gboolean _tmp386_;
			gboolean _tmp387_;
			ValaParameter* _tmp388_;
			gboolean _tmp389_;
			gboolean _tmp390_;
			ValaIterator* _tmp408_;
			_param_index = _param_index + 1;
			_tmp380_ = _param_index;
			_tmp381_ = _param_size;
			if (!(_tmp380_ < _tmp381_)) {
				break;
			}
			_tmp382_ = _param_list;
			_tmp383_ = vala_list_get (_tmp382_, _param_index);
			param = (ValaParameter*) _tmp383_;
			_tmp384_ = param;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp384_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			_tmp385_ = param;
			_tmp386_ = vala_parameter_get_ellipsis (_tmp385_);
			_tmp387_ = _tmp386_;
			if (_tmp387_) {
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp388_ = param;
			_tmp389_ = vala_parameter_get_params_array (_tmp388_);
			_tmp390_ = _tmp389_;
			if (_tmp390_) {
				ValaArrayType* array_type = NULL;
				ValaParameter* _tmp391_;
				ValaDataType* _tmp392_;
				ValaDataType* _tmp393_;
				ValaArrayType* _tmp394_;
				_tmp391_ = param;
				_tmp392_ = vala_variable_get_variable_type ((ValaVariable*) _tmp391_);
				_tmp393_ = _tmp392_;
				_tmp394_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp393_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				array_type = _tmp394_;
				while (TRUE) {
					ValaIterator* _tmp395_;
					ValaExpression* arg = NULL;
					ValaIterator* _tmp396_;
					gpointer _tmp397_;
					ValaExpression* _tmp398_;
					ValaArrayType* _tmp399_;
					ValaDataType* _tmp400_;
					ValaDataType* _tmp401_;
					ValaExpression* _tmp402_;
					ValaDataType* _tmp403_;
					ValaDataType* _tmp404_;
					ValaArrayType* _tmp405_;
					gboolean _tmp406_;
					gboolean _tmp407_;
					_tmp395_ = arg_it;
					if (!vala_iterator_next (_tmp395_)) {
						break;
					}
					_tmp396_ = arg_it;
					_tmp397_ = vala_iterator_get (_tmp396_);
					arg = (ValaExpression*) _tmp397_;
					_tmp398_ = arg;
					_tmp399_ = array_type;
					_tmp400_ = vala_array_type_get_element_type (_tmp399_);
					_tmp401_ = _tmp400_;
					vala_expression_set_target_type (_tmp398_, _tmp401_);
					_tmp402_ = arg;
					_tmp403_ = vala_expression_get_target_type (_tmp402_);
					_tmp404_ = _tmp403_;
					_tmp405_ = array_type;
					_tmp406_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp405_);
					_tmp407_ = _tmp406_;
					vala_data_type_set_value_owned (_tmp404_, _tmp407_);
					_vala_code_node_unref0 (arg);
				}
				_vala_code_node_unref0 (array_type);
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp408_ = arg_it;
			if (vala_iterator_next (_tmp408_)) {
				ValaExpression* arg = NULL;
				ValaIterator* _tmp409_;
				gpointer _tmp410_;
				ValaExpression* _tmp411_;
				ValaParameter* _tmp412_;
				ValaDataType* _tmp413_;
				ValaDataType* _tmp414_;
				ValaExpression* _tmp415_;
				ValaExpression* _tmp416_;
				ValaDataType* _tmp417_;
				ValaDataType* _tmp418_;
				ValaDataType* _tmp419_;
				ValaList* _tmp420_;
				ValaDataType* _tmp421_;
				ValaDataType* _tmp422_;
				ValaExpression* _tmp423_;
				ValaExpression* _tmp424_;
				_tmp409_ = arg_it;
				_tmp410_ = vala_iterator_get (_tmp409_);
				arg = (ValaExpression*) _tmp410_;
				_tmp411_ = arg;
				_tmp412_ = param;
				_tmp413_ = vala_variable_get_variable_type ((ValaVariable*) _tmp412_);
				_tmp414_ = _tmp413_;
				vala_expression_set_formal_target_type (_tmp411_, _tmp414_);
				_tmp415_ = arg;
				_tmp416_ = arg;
				_tmp417_ = vala_expression_get_formal_target_type (_tmp416_);
				_tmp418_ = _tmp417_;
				_tmp419_ = target_object_type;
				_tmp420_ = method_type_args;
				_tmp421_ = vala_data_type_get_actual_type (_tmp418_, _tmp419_, _tmp420_, (ValaCodeNode*) self);
				_tmp422_ = _tmp421_;
				vala_expression_set_target_type (_tmp415_, _tmp422_);
				_vala_code_node_unref0 (_tmp422_);
				_tmp423_ = arg;
				_tmp424_ = _vala_code_node_ref0 (_tmp423_);
				_vala_code_node_unref0 (last_arg);
				last_arg = _tmp424_;
				_vala_code_node_unref0 (arg);
			}
			_vala_code_node_unref0 (param);
		}
	}
	_tmp426_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp426_)) {
		ValaDataType* _tmp427_;
		ValaMethod* _tmp428_;
		ValaMethod* _tmp429_;
		ValaAttribute* _tmp430_;
		_tmp427_ = mtype;
		_tmp428_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp427_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp429_ = _tmp428_;
		_tmp430_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp429_, "Print");
		_tmp425_ = _tmp430_ != NULL;
	} else {
		_tmp425_ = FALSE;
	}
	if (_tmp425_) {
		ValaTemplate* template = NULL;
		ValaSourceReference* _tmp431_;
		ValaSourceReference* _tmp432_;
		ValaTemplate* _tmp433_;
		ValaList* _tmp445_;
		ValaTemplate* _tmp446_;
		_tmp431_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp432_ = _tmp431_;
		_tmp433_ = vala_template_new (_tmp432_);
		template = _tmp433_;
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp434_;
			gint _arg_size = 0;
			ValaList* _tmp435_;
			gint _tmp436_;
			gint _tmp437_;
			gint _arg_index = 0;
			_tmp434_ = self->priv->argument_list;
			_arg_list = _tmp434_;
			_tmp435_ = _arg_list;
			_tmp436_ = vala_collection_get_size ((ValaCollection*) _tmp435_);
			_tmp437_ = _tmp436_;
			_arg_size = _tmp437_;
			_arg_index = -1;
			while (TRUE) {
				gint _tmp438_;
				gint _tmp439_;
				ValaExpression* arg = NULL;
				ValaList* _tmp440_;
				gpointer _tmp441_;
				ValaExpression* _tmp442_;
				ValaTemplate* _tmp443_;
				ValaExpression* _tmp444_;
				_arg_index = _arg_index + 1;
				_tmp438_ = _arg_index;
				_tmp439_ = _arg_size;
				if (!(_tmp438_ < _tmp439_)) {
					break;
				}
				_tmp440_ = _arg_list;
				_tmp441_ = vala_list_get (_tmp440_, _arg_index);
				arg = (ValaExpression*) _tmp441_;
				_tmp442_ = arg;
				vala_code_node_set_parent_node ((ValaCodeNode*) _tmp442_, NULL);
				_tmp443_ = template;
				_tmp444_ = arg;
				vala_template_add_expression (_tmp443_, _tmp444_);
				_vala_code_node_unref0 (arg);
			}
		}
		_tmp445_ = self->priv->argument_list;
		vala_collection_clear ((ValaCollection*) _tmp445_);
		_tmp446_ = template;
		vala_callable_expression_add_argument ((ValaCallableExpression*) self, (ValaExpression*) _tmp446_);
		_vala_code_node_unref0 (template);
	}
	_tmp448_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp448_)) {
		ValaDataType* _tmp449_;
		ValaMethod* _tmp450_;
		ValaMethod* _tmp451_;
		gboolean _tmp452_;
		gboolean _tmp453_;
		_tmp449_ = mtype;
		_tmp450_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp449_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp451_ = _tmp450_;
		_tmp452_ = vala_method_get_printf_format (_tmp451_);
		_tmp453_ = _tmp452_;
		_tmp447_ = _tmp453_;
	} else {
		_tmp447_ = FALSE;
	}
	if (_tmp447_) {
		ValaStringLiteral* format_literal = NULL;
		ValaExpression* _tmp454_;
		ValaStringLiteral* _tmp503_;
		format_literal = NULL;
		_tmp454_ = last_arg;
		if (VALA_IS_NULL_LITERAL (_tmp454_)) {
		} else {
			ValaExpression* _tmp455_;
			_tmp455_ = last_arg;
			if (_tmp455_ != NULL) {
				ValaExpression* _tmp456_;
				ValaStringLiteral* _tmp457_;
				gboolean _tmp458_ = FALSE;
				ValaStringLiteral* _tmp459_;
				_tmp456_ = last_arg;
				_tmp457_ = vala_string_literal_get_format_literal (_tmp456_);
				_vala_code_node_unref0 (format_literal);
				format_literal = _tmp457_;
				_tmp459_ = format_literal;
				if (_tmp459_ == NULL) {
					ValaList* _tmp460_;
					gint _tmp461_;
					gint _tmp462_;
					ValaList* _tmp463_;
					gint _tmp464_;
					gint _tmp465_;
					_tmp460_ = self->priv->argument_list;
					_tmp461_ = vala_collection_get_size ((ValaCollection*) _tmp460_);
					_tmp462_ = _tmp461_;
					_tmp463_ = params;
					_tmp464_ = vala_collection_get_size ((ValaCollection*) _tmp463_);
					_tmp465_ = _tmp464_;
					_tmp458_ = _tmp462_ == (_tmp465_ - 1);
				} else {
					_tmp458_ = FALSE;
				}
				if (_tmp458_) {
					ValaStringLiteral* _tmp466_;
					ValaStringLiteral* _tmp467_;
					ValaSemanticAnalyzer* _tmp468_;
					ValaSemanticAnalyzer* _tmp469_;
					ValaDataType* _tmp470_;
					ValaDataType* _tmp471_;
					ValaDataType* _tmp472_;
					ValaList* _tmp473_;
					ValaList* _tmp474_;
					gint _tmp475_;
					gint _tmp476_;
					ValaStringLiteral* _tmp477_;
					ValaList* _tmp478_;
					ValaIterator* _tmp479_;
					_tmp466_ = vala_string_literal_new ("\"%s\"", NULL);
					_vala_code_node_unref0 (format_literal);
					format_literal = _tmp466_;
					_tmp467_ = format_literal;
					_tmp468_ = vala_code_context_get_analyzer (context);
					_tmp469_ = _tmp468_;
					_tmp470_ = _tmp469_->string_type;
					_tmp471_ = vala_data_type_copy (_tmp470_);
					_tmp472_ = _tmp471_;
					vala_expression_set_target_type ((ValaExpression*) _tmp467_, _tmp472_);
					_vala_code_node_unref0 (_tmp472_);
					_tmp473_ = self->priv->argument_list;
					_tmp474_ = self->priv->argument_list;
					_tmp475_ = vala_collection_get_size ((ValaCollection*) _tmp474_);
					_tmp476_ = _tmp475_;
					_tmp477_ = format_literal;
					vala_list_insert (_tmp473_, _tmp476_ - 1, (ValaExpression*) _tmp477_);
					_tmp478_ = self->priv->argument_list;
					_tmp479_ = vala_iterable_iterator ((ValaIterable*) _tmp478_);
					_vala_iterator_unref0 (arg_it);
					arg_it = _tmp479_;
					{
						ValaList* _param_list = NULL;
						ValaList* _tmp480_;
						gint _param_size = 0;
						ValaList* _tmp481_;
						gint _tmp482_;
						gint _tmp483_;
						gint _param_index = 0;
						_tmp480_ = params;
						_param_list = _tmp480_;
						_tmp481_ = _param_list;
						_tmp482_ = vala_collection_get_size ((ValaCollection*) _tmp481_);
						_tmp483_ = _tmp482_;
						_param_size = _tmp483_;
						_param_index = -1;
						while (TRUE) {
							gint _tmp484_;
							gint _tmp485_;
							ValaParameter* param = NULL;
							ValaList* _tmp486_;
							gpointer _tmp487_;
							gboolean _tmp488_ = FALSE;
							ValaParameter* _tmp489_;
							gboolean _tmp490_;
							gboolean _tmp491_;
							ValaIterator* _tmp495_;
							_param_index = _param_index + 1;
							_tmp484_ = _param_index;
							_tmp485_ = _param_size;
							if (!(_tmp484_ < _tmp485_)) {
								break;
							}
							_tmp486_ = _param_list;
							_tmp487_ = vala_list_get (_tmp486_, _param_index);
							param = (ValaParameter*) _tmp487_;
							_tmp489_ = param;
							_tmp490_ = vala_parameter_get_ellipsis (_tmp489_);
							_tmp491_ = _tmp490_;
							if (_tmp491_) {
								_tmp488_ = TRUE;
							} else {
								ValaParameter* _tmp492_;
								gboolean _tmp493_;
								gboolean _tmp494_;
								_tmp492_ = param;
								_tmp493_ = vala_parameter_get_params_array (_tmp492_);
								_tmp494_ = _tmp493_;
								_tmp488_ = _tmp494_;
							}
							if (_tmp488_) {
								_vala_code_node_unref0 (param);
								break;
							}
							_tmp495_ = arg_it;
							vala_iterator_next (_tmp495_);
							_vala_code_node_unref0 (param);
						}
					}
				}
			} else {
				ValaMemberAccess* ma = NULL;
				ValaExpression* _tmp496_;
				ValaExpression* _tmp497_;
				ValaMemberAccess* _tmp498_;
				_tmp496_ = vala_method_call_get_call (self);
				_tmp497_ = _tmp496_;
				ma = VALA_IS_MEMBER_ACCESS (_tmp497_) ? ((ValaMemberAccess*) _tmp497_) : NULL;
				_tmp498_ = ma;
				if (_tmp498_ != NULL) {
					ValaMemberAccess* _tmp499_;
					ValaExpression* _tmp500_;
					ValaExpression* _tmp501_;
					ValaStringLiteral* _tmp502_;
					_tmp499_ = ma;
					_tmp500_ = vala_member_access_get_inner (_tmp499_);
					_tmp501_ = _tmp500_;
					_tmp502_ = vala_string_literal_get_format_literal (_tmp501_);
					_vala_code_node_unref0 (format_literal);
					format_literal = _tmp502_;
				}
			}
		}
		_tmp503_ = format_literal;
		if (_tmp503_ != NULL) {
			gchar* format = NULL;
			ValaStringLiteral* _tmp504_;
			gchar* _tmp505_;
			ValaSemanticAnalyzer* _tmp506_;
			ValaSemanticAnalyzer* _tmp507_;
			const gchar* _tmp508_;
			ValaIterator* _tmp509_;
			ValaSourceReference* _tmp510_;
			ValaSourceReference* _tmp511_;
			_tmp504_ = format_literal;
			_tmp505_ = vala_string_literal_eval (_tmp504_);
			format = _tmp505_;
			_tmp506_ = vala_code_context_get_analyzer (context);
			_tmp507_ = _tmp506_;
			_tmp508_ = format;
			_tmp509_ = arg_it;
			_tmp510_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp511_ = _tmp510_;
			if (!vala_semantic_analyzer_check_print_format (_tmp507_, _tmp508_, _tmp509_, _tmp511_)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_g_free0 (format);
				_vala_code_node_unref0 (format_literal);
				_vala_iterator_unref0 (arg_it);
				_vala_code_node_unref0 (last_arg);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (ret_type);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
			_g_free0 (format);
		}
		_vala_code_node_unref0 (format_literal);
	}
	force_lambda_method_closure = FALSE;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp512_;
		gint _arg_size = 0;
		ValaList* _tmp513_;
		gint _tmp514_;
		gint _tmp515_;
		gint _arg_index = 0;
		_tmp512_ = self->priv->argument_list;
		_arg_list = _tmp512_;
		_tmp513_ = _arg_list;
		_tmp514_ = vala_collection_get_size ((ValaCollection*) _tmp513_);
		_tmp515_ = _tmp514_;
		_arg_size = _tmp515_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp516_;
			gint _tmp517_;
			ValaExpression* arg = NULL;
			ValaList* _tmp518_;
			gpointer _tmp519_;
			ValaExpression* _tmp520_;
			gboolean _tmp521_ = FALSE;
			ValaExpression* _tmp522_;
			_arg_index = _arg_index + 1;
			_tmp516_ = _arg_index;
			_tmp517_ = _arg_size;
			if (!(_tmp516_ < _tmp517_)) {
				break;
			}
			_tmp518_ = _arg_list;
			_tmp519_ = vala_list_get (_tmp518_, _arg_index);
			arg = (ValaExpression*) _tmp519_;
			_tmp520_ = arg;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp520_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_vala_code_node_unref0 (arg);
				continue;
			}
			_tmp522_ = arg;
			if (VALA_IS_LAMBDA_EXPRESSION (_tmp522_)) {
				ValaExpression* _tmp523_;
				ValaMethod* _tmp524_;
				ValaMethod* _tmp525_;
				gboolean _tmp526_;
				gboolean _tmp527_;
				_tmp523_ = arg;
				_tmp524_ = vala_lambda_expression_get_method (G_TYPE_CHECK_INSTANCE_CAST (_tmp523_, VALA_TYPE_LAMBDA_EXPRESSION, ValaLambdaExpression));
				_tmp525_ = _tmp524_;
				_tmp526_ = vala_method_get_closure (_tmp525_);
				_tmp527_ = _tmp526_;
				_tmp521_ = _tmp527_;
			} else {
				_tmp521_ = FALSE;
			}
			if (_tmp521_) {
				force_lambda_method_closure = TRUE;
			}
			_vala_code_node_unref0 (arg);
		}
	}
	_tmp529_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp530_ = _tmp529_;
	if (!_tmp530_) {
		_tmp528_ = force_lambda_method_closure;
	} else {
		_tmp528_ = FALSE;
	}
	if (_tmp528_) {
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp531_;
			gint _arg_size = 0;
			ValaList* _tmp532_;
			gint _tmp533_;
			gint _tmp534_;
			gint _arg_index = 0;
			_tmp531_ = self->priv->argument_list;
			_arg_list = _tmp531_;
			_tmp532_ = _arg_list;
			_tmp533_ = vala_collection_get_size ((ValaCollection*) _tmp532_);
			_tmp534_ = _tmp533_;
			_arg_size = _tmp534_;
			_arg_index = -1;
			while (TRUE) {
				gint _tmp535_;
				gint _tmp536_;
				ValaExpression* arg = NULL;
				ValaList* _tmp537_;
				gpointer _tmp538_;
				ValaLambdaExpression* lambda = NULL;
				ValaExpression* _tmp539_;
				gboolean _tmp540_ = FALSE;
				ValaLambdaExpression* _tmp541_;
				_arg_index = _arg_index + 1;
				_tmp535_ = _arg_index;
				_tmp536_ = _arg_size;
				if (!(_tmp535_ < _tmp536_)) {
					break;
				}
				_tmp537_ = _arg_list;
				_tmp538_ = vala_list_get (_tmp537_, _arg_index);
				arg = (ValaExpression*) _tmp538_;
				_tmp539_ = arg;
				lambda = VALA_IS_LAMBDA_EXPRESSION (_tmp539_) ? ((ValaLambdaExpression*) _tmp539_) : NULL;
				_tmp541_ = lambda;
				if (_tmp541_ != NULL) {
					ValaLambdaExpression* _tmp542_;
					ValaMethod* _tmp543_;
					ValaMethod* _tmp544_;
					ValaMemberBinding _tmp545_;
					ValaMemberBinding _tmp546_;
					_tmp542_ = lambda;
					_tmp543_ = vala_lambda_expression_get_method (_tmp542_);
					_tmp544_ = _tmp543_;
					_tmp545_ = vala_method_get_binding (_tmp544_);
					_tmp546_ = _tmp545_;
					_tmp540_ = _tmp546_ != VALA_MEMBER_BINDING_STATIC;
				} else {
					_tmp540_ = FALSE;
				}
				if (_tmp540_) {
					ValaLambdaExpression* _tmp547_;
					ValaMethod* _tmp548_;
					ValaMethod* _tmp549_;
					_tmp547_ = lambda;
					_tmp548_ = vala_lambda_expression_get_method (_tmp547_);
					_tmp549_ = _tmp548_;
					vala_method_set_closure (_tmp549_, TRUE);
				}
				_vala_code_node_unref0 (arg);
			}
		}
	}
	_tmp550_ = ret_type;
	if (VALA_IS_VOID_TYPE (_tmp550_)) {
		gboolean _tmp551_ = FALSE;
		gboolean _tmp552_ = FALSE;
		ValaCodeNode* _tmp553_;
		ValaCodeNode* _tmp554_;
		_tmp553_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp554_ = _tmp553_;
		if (!VALA_IS_EXPRESSION_STATEMENT (_tmp554_)) {
			ValaCodeNode* _tmp555_;
			ValaCodeNode* _tmp556_;
			_tmp555_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp556_ = _tmp555_;
			_tmp552_ = !VALA_IS_FOR_STATEMENT (_tmp556_);
		} else {
			_tmp552_ = FALSE;
		}
		if (_tmp552_) {
			ValaCodeNode* _tmp557_;
			ValaCodeNode* _tmp558_;
			_tmp557_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp558_ = _tmp557_;
			_tmp551_ = !VALA_IS_YIELD_STATEMENT (_tmp558_);
		} else {
			_tmp551_ = FALSE;
		}
		if (_tmp551_) {
			ValaSourceReference* _tmp559_;
			ValaSourceReference* _tmp560_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp559_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp560_ = _tmp559_;
			vala_report_error (_tmp560_, "invocation of void method not allowed as expression");
			result = FALSE;
			_vala_iterator_unref0 (arg_it);
			_vala_code_node_unref0 (last_arg);
			_vala_iterable_unref0 (params);
			_vala_code_node_unref0 (ret_type);
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
	}
	_tmp561_ = ret_type;
	_tmp562_ = vala_data_type_copy (_tmp561_);
	_tmp563_ = _tmp562_;
	vala_expression_set_formal_value_type ((ValaExpression*) self, _tmp563_);
	_vala_code_node_unref0 (_tmp563_);
	_tmp564_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
	_tmp565_ = _tmp564_;
	_tmp566_ = target_object_type;
	_tmp567_ = method_type_args;
	_tmp568_ = vala_data_type_get_actual_type (_tmp565_, _tmp566_, _tmp567_, (ValaCodeNode*) self);
	_tmp569_ = _tmp568_;
	vala_expression_set_value_type ((ValaExpression*) self, _tmp569_);
	_vala_code_node_unref0 (_tmp569_);
	_tmp570_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) self);
	_tmp571_ = _tmp570_;
	if (_tmp571_) {
		gboolean _tmp572_ = FALSE;
		ValaDataType* _tmp573_;
		gboolean _tmp581_ = FALSE;
		ValaSemanticAnalyzer* _tmp582_;
		ValaSemanticAnalyzer* _tmp583_;
		ValaMethod* _tmp584_;
		ValaMethod* _tmp585_;
		_tmp573_ = mtype;
		if (!VALA_IS_METHOD_TYPE (_tmp573_)) {
			_tmp572_ = TRUE;
		} else {
			ValaDataType* _tmp574_;
			ValaMethod* _tmp575_;
			ValaMethod* _tmp576_;
			gboolean _tmp577_;
			gboolean _tmp578_;
			_tmp574_ = mtype;
			_tmp575_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp574_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
			_tmp576_ = _tmp575_;
			_tmp577_ = vala_method_get_coroutine (_tmp576_);
			_tmp578_ = _tmp577_;
			_tmp572_ = !_tmp578_;
		}
		if (_tmp572_) {
			ValaSourceReference* _tmp579_;
			ValaSourceReference* _tmp580_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp579_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp580_ = _tmp579_;
			vala_report_error (_tmp580_, "yield expression requires async method");
		}
		_tmp582_ = vala_code_context_get_analyzer (context);
		_tmp583_ = _tmp582_;
		_tmp584_ = vala_semantic_analyzer_get_current_method (_tmp583_);
		_tmp585_ = _tmp584_;
		if (_tmp585_ == NULL) {
			_tmp581_ = TRUE;
		} else {
			ValaSemanticAnalyzer* _tmp586_;
			ValaSemanticAnalyzer* _tmp587_;
			ValaMethod* _tmp588_;
			ValaMethod* _tmp589_;
			gboolean _tmp590_;
			gboolean _tmp591_;
			_tmp586_ = vala_code_context_get_analyzer (context);
			_tmp587_ = _tmp586_;
			_tmp588_ = vala_semantic_analyzer_get_current_method (_tmp587_);
			_tmp589_ = _tmp588_;
			_tmp590_ = vala_method_get_coroutine (_tmp589_);
			_tmp591_ = _tmp590_;
			_tmp581_ = !_tmp591_;
		}
		if (_tmp581_) {
			ValaSourceReference* _tmp592_;
			ValaSourceReference* _tmp593_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp592_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp593_ = _tmp592_;
			vala_report_error (_tmp593_, "yield expression not available outside async method");
		}
	}
	_tmp594_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp594_)) {
		ValaMethod* m = NULL;
		ValaDataType* _tmp595_;
		ValaMethod* _tmp596_;
		ValaMethod* _tmp597_;
		ValaMethod* _tmp598_;
		gboolean _tmp599_;
		gboolean _tmp600_;
		ValaMethod* _tmp603_;
		gboolean _tmp604_;
		gboolean _tmp605_;
		gboolean _tmp631_ = FALSE;
		gboolean _tmp632_ = FALSE;
		gboolean _tmp633_ = FALSE;
		gboolean _tmp634_;
		gboolean _tmp635_;
		ValaSignal* sig = NULL;
		ValaMethod* _tmp647_;
		ValaSymbol* _tmp648_;
		ValaSymbol* _tmp649_;
		gboolean _tmp650_ = FALSE;
		ValaSignal* _tmp651_;
		ValaDynamicSignal* dynamic_sig = NULL;
		ValaMethod* _tmp664_;
		ValaSymbol* _tmp665_;
		ValaSymbol* _tmp666_;
		gboolean _tmp667_ = FALSE;
		ValaDynamicSignal* _tmp668_;
		gboolean _tmp718_ = FALSE;
		ValaMethod* _tmp719_;
		gboolean _tmp827_ = FALSE;
		ValaMethod* _tmp828_;
		_tmp595_ = mtype;
		_tmp596_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp595_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp597_ = _tmp596_;
		m = _tmp597_;
		_tmp598_ = m;
		_tmp599_ = vala_method_get_returns_floating_reference (_tmp598_);
		_tmp600_ = _tmp599_;
		if (_tmp600_) {
			ValaDataType* _tmp601_;
			ValaDataType* _tmp602_;
			_tmp601_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp602_ = _tmp601_;
			vala_data_type_set_floating_reference (_tmp602_, TRUE);
		}
		_tmp603_ = m;
		_tmp604_ = vala_method_get_returns_modified_pointer (_tmp603_);
		_tmp605_ = _tmp604_;
		if (_tmp605_) {
			ValaExpression* inner = NULL;
			ValaExpression* _tmp606_;
			ValaExpression* _tmp607_;
			ValaExpression* _tmp608_;
			ValaExpression* _tmp609_;
			ValaExpression* _tmp610_;
			ValaProperty* prop = NULL;
			ValaExpression* _tmp611_;
			ValaSymbol* _tmp612_;
			ValaSymbol* _tmp613_;
			gboolean _tmp614_ = FALSE;
			ValaProperty* _tmp615_;
			_tmp606_ = vala_method_call_get_call (self);
			_tmp607_ = _tmp606_;
			_tmp608_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp607_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp609_ = _tmp608_;
			inner = _tmp609_;
			_tmp610_ = inner;
			vala_expression_set_lvalue (_tmp610_, TRUE);
			_tmp611_ = inner;
			_tmp612_ = vala_expression_get_symbol_reference (_tmp611_);
			_tmp613_ = _tmp612_;
			prop = VALA_IS_PROPERTY (_tmp613_) ? ((ValaProperty*) _tmp613_) : NULL;
			_tmp615_ = prop;
			if (_tmp615_ != NULL) {
				gboolean _tmp616_ = FALSE;
				ValaProperty* _tmp617_;
				ValaPropertyAccessor* _tmp618_;
				ValaPropertyAccessor* _tmp619_;
				_tmp617_ = prop;
				_tmp618_ = vala_property_get_set_accessor (_tmp617_);
				_tmp619_ = _tmp618_;
				if (_tmp619_ == NULL) {
					_tmp616_ = TRUE;
				} else {
					ValaProperty* _tmp620_;
					ValaPropertyAccessor* _tmp621_;
					ValaPropertyAccessor* _tmp622_;
					gboolean _tmp623_;
					gboolean _tmp624_;
					_tmp620_ = prop;
					_tmp621_ = vala_property_get_set_accessor (_tmp620_);
					_tmp622_ = _tmp621_;
					_tmp623_ = vala_property_accessor_get_writable (_tmp622_);
					_tmp624_ = _tmp623_;
					_tmp616_ = !_tmp624_;
				}
				_tmp614_ = _tmp616_;
			} else {
				_tmp614_ = FALSE;
			}
			if (_tmp614_) {
				ValaExpression* _tmp625_;
				ValaSourceReference* _tmp626_;
				ValaSourceReference* _tmp627_;
				ValaProperty* _tmp628_;
				gchar* _tmp629_;
				gchar* _tmp630_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp625_ = inner;
				_tmp626_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp625_);
				_tmp627_ = _tmp626_;
				_tmp628_ = prop;
				_tmp629_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp628_);
				_tmp630_ = _tmp629_;
				vala_report_error (_tmp627_, "Property `%s' is read-only", _tmp630_);
				_g_free0 (_tmp630_);
			}
		}
		_tmp634_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
		_tmp635_ = _tmp634_;
		if (_tmp635_) {
			ValaDataType* _tmp636_;
			ValaDataType* _tmp637_;
			gboolean _tmp638_;
			gboolean _tmp639_;
			_tmp636_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp637_ = _tmp636_;
			_tmp638_ = vala_data_type_get_nullable (_tmp637_);
			_tmp639_ = _tmp638_;
			_tmp633_ = !_tmp639_;
		} else {
			_tmp633_ = FALSE;
		}
		if (_tmp633_) {
			ValaDataType* _tmp640_;
			ValaDataType* _tmp641_;
			gboolean _tmp642_;
			gboolean _tmp643_;
			_tmp640_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp641_ = _tmp640_;
			_tmp642_ = vala_data_type_get_floating_reference (_tmp641_);
			_tmp643_ = _tmp642_;
			_tmp632_ = _tmp643_;
		} else {
			_tmp632_ = FALSE;
		}
		if (_tmp632_) {
			ValaDataType* _tmp644_;
			_tmp644_ = ret_type;
			_tmp631_ = VALA_IS_OBJECT_TYPE (_tmp644_);
		} else {
			_tmp631_ = FALSE;
		}
		if (_tmp631_) {
			ValaDataType* _tmp645_;
			ValaDataType* _tmp646_;
			_tmp645_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp646_ = _tmp645_;
			vala_data_type_set_nullable (_tmp646_, TRUE);
		}
		_tmp647_ = m;
		_tmp648_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp647_);
		_tmp649_ = _tmp648_;
		sig = VALA_IS_SIGNAL (_tmp649_) ? ((ValaSignal*) _tmp649_) : NULL;
		_tmp651_ = sig;
		if (_tmp651_ != NULL) {
			ValaMethod* _tmp652_;
			const gchar* _tmp653_;
			const gchar* _tmp654_;
			_tmp652_ = m;
			_tmp653_ = vala_symbol_get_name ((ValaSymbol*) _tmp652_);
			_tmp654_ = _tmp653_;
			_tmp650_ = g_strcmp0 (_tmp654_, "disconnect") == 0;
		} else {
			_tmp650_ = FALSE;
		}
		if (_tmp650_) {
			gboolean _tmp655_ = FALSE;
			ValaList* _tmp656_;
			gboolean _tmp657_;
			gboolean _tmp658_;
			_tmp656_ = self->priv->argument_list;
			_tmp657_ = vala_collection_get_is_empty ((ValaCollection*) _tmp656_);
			_tmp658_ = _tmp657_;
			if (!_tmp658_) {
				ValaList* _tmp659_;
				gpointer _tmp660_;
				ValaExpression* _tmp661_;
				_tmp659_ = self->priv->argument_list;
				_tmp660_ = vala_list_get (_tmp659_, 0);
				_tmp661_ = (ValaExpression*) _tmp660_;
				_tmp655_ = VALA_IS_LAMBDA_EXPRESSION (_tmp661_);
				_vala_code_node_unref0 (_tmp661_);
			} else {
				_tmp655_ = FALSE;
			}
			if (_tmp655_) {
				ValaSourceReference* _tmp662_;
				ValaSourceReference* _tmp663_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp662_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp663_ = _tmp662_;
				vala_report_error (_tmp663_, "Cannot disconnect lambda expression from signal");
				result = FALSE;
				_vala_iterator_unref0 (arg_it);
				_vala_code_node_unref0 (last_arg);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (ret_type);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
		_tmp664_ = m;
		_tmp665_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp664_);
		_tmp666_ = _tmp665_;
		dynamic_sig = VALA_IS_DYNAMIC_SIGNAL (_tmp666_) ? ((ValaDynamicSignal*) _tmp666_) : NULL;
		_tmp668_ = dynamic_sig;
		if (_tmp668_ != NULL) {
			ValaDynamicSignal* _tmp669_;
			ValaExpression* _tmp670_;
			ValaExpression* _tmp671_;
			_tmp669_ = dynamic_sig;
			_tmp670_ = vala_dynamic_signal_get_handler (_tmp669_);
			_tmp671_ = _tmp670_;
			_tmp667_ = _tmp671_ != NULL;
		} else {
			_tmp667_ = FALSE;
		}
		if (_tmp667_) {
			ValaDynamicSignal* _tmp672_;
			ValaDynamicSignal* _tmp673_;
			ValaExpression* _tmp674_;
			ValaExpression* _tmp675_;
			ValaDataType* _tmp676_;
			ValaDataType* _tmp677_;
			ValaDataType* _tmp678_;
			ValaDataType* _tmp679_;
			ValaDataType* _tmp680_;
			gboolean first = FALSE;
			ValaDynamicSignal* _tmp698_;
			ValaExpression* _tmp699_;
			ValaExpression* _tmp700_;
			ValaDynamicSignal* _tmp701_;
			ValaDynamicSignal* _tmp702_;
			ValaSymbol* _tmp703_;
			ValaSymbol* _tmp704_;
			ValaObjectType* _tmp705_;
			ValaObjectType* _tmp706_;
			ValaDelegate* _tmp707_;
			ValaDelegate* _tmp708_;
			ValaDelegateType* _tmp709_;
			ValaDelegateType* _tmp710_;
			ValaDynamicSignal* _tmp711_;
			ValaExpression* _tmp712_;
			ValaExpression* _tmp713_;
			ValaDataType* _tmp714_;
			ValaDataType* _tmp715_;
			ValaSourceReference* _tmp716_;
			ValaSourceReference* _tmp717_;
			_tmp672_ = dynamic_sig;
			_tmp673_ = dynamic_sig;
			_tmp674_ = vala_dynamic_signal_get_handler (_tmp673_);
			_tmp675_ = _tmp674_;
			_tmp676_ = vala_expression_get_value_type (_tmp675_);
			_tmp677_ = _tmp676_;
			_tmp678_ = vala_data_type_get_return_type (_tmp677_);
			_tmp679_ = vala_data_type_copy (_tmp678_);
			_tmp680_ = _tmp679_;
			vala_callable_set_return_type ((ValaCallable*) _tmp672_, _tmp680_);
			_vala_code_node_unref0 (_tmp680_);
			first = TRUE;
			{
				ValaList* _param_list = NULL;
				ValaDynamicSignal* _tmp681_;
				ValaExpression* _tmp682_;
				ValaExpression* _tmp683_;
				ValaDataType* _tmp684_;
				ValaDataType* _tmp685_;
				ValaList* _tmp686_;
				gint _param_size = 0;
				ValaList* _tmp687_;
				gint _tmp688_;
				gint _tmp689_;
				gint _param_index = 0;
				_tmp681_ = dynamic_sig;
				_tmp682_ = vala_dynamic_signal_get_handler (_tmp681_);
				_tmp683_ = _tmp682_;
				_tmp684_ = vala_expression_get_value_type (_tmp683_);
				_tmp685_ = _tmp684_;
				_tmp686_ = vala_data_type_get_parameters (_tmp685_);
				_param_list = _tmp686_;
				_tmp687_ = _param_list;
				_tmp688_ = vala_collection_get_size ((ValaCollection*) _tmp687_);
				_tmp689_ = _tmp688_;
				_param_size = _tmp689_;
				_param_index = -1;
				while (TRUE) {
					gint _tmp690_;
					gint _tmp691_;
					ValaParameter* param = NULL;
					ValaList* _tmp692_;
					gpointer _tmp693_;
					_param_index = _param_index + 1;
					_tmp690_ = _param_index;
					_tmp691_ = _param_size;
					if (!(_tmp690_ < _tmp691_)) {
						break;
					}
					_tmp692_ = _param_list;
					_tmp693_ = vala_list_get (_tmp692_, _param_index);
					param = (ValaParameter*) _tmp693_;
					if (first) {
						first = FALSE;
					} else {
						ValaDynamicSignal* _tmp694_;
						ValaParameter* _tmp695_;
						ValaParameter* _tmp696_;
						ValaParameter* _tmp697_;
						_tmp694_ = dynamic_sig;
						_tmp695_ = param;
						_tmp696_ = vala_parameter_copy (_tmp695_);
						_tmp697_ = _tmp696_;
						vala_callable_add_parameter ((ValaCallable*) _tmp694_, _tmp697_);
						_vala_code_node_unref0 (_tmp697_);
					}
					_vala_code_node_unref0 (param);
				}
			}
			_tmp698_ = dynamic_sig;
			_tmp699_ = vala_dynamic_signal_get_handler (_tmp698_);
			_tmp700_ = _tmp699_;
			_tmp701_ = dynamic_sig;
			_tmp702_ = dynamic_sig;
			_tmp703_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp702_);
			_tmp704_ = _tmp703_;
			_tmp705_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp704_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp706_ = _tmp705_;
			_tmp707_ = vala_signal_get_delegate ((ValaSignal*) _tmp701_, (ValaDataType*) _tmp706_, (ValaCodeNode*) self);
			_tmp708_ = _tmp707_;
			_tmp709_ = vala_delegate_type_new (_tmp708_);
			_tmp710_ = _tmp709_;
			vala_expression_set_target_type (_tmp700_, (ValaDataType*) _tmp710_);
			_vala_code_node_unref0 (_tmp710_);
			_vala_code_node_unref0 (_tmp708_);
			_vala_code_node_unref0 (_tmp706_);
			_tmp711_ = dynamic_sig;
			_tmp712_ = vala_dynamic_signal_get_handler (_tmp711_);
			_tmp713_ = _tmp712_;
			_tmp714_ = vala_expression_get_target_type (_tmp713_);
			_tmp715_ = _tmp714_;
			_tmp716_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp717_ = _tmp716_;
			vala_code_node_set_source_reference ((ValaCodeNode*) _tmp715_, _tmp717_);
		}
		_tmp719_ = m;
		if (_tmp719_ != NULL) {
			ValaMethod* _tmp720_;
			_tmp720_ = m;
			_tmp718_ = vala_method_has_type_parameters (_tmp720_);
		} else {
			_tmp718_ = FALSE;
		}
		if (_tmp718_) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp721_;
			ValaExpression* _tmp722_;
			ValaMemberAccess* _tmp723_;
			ValaList* _tmp724_;
			gint _tmp725_;
			gint _tmp726_;
			_tmp721_ = vala_method_call_get_call (self);
			_tmp722_ = _tmp721_;
			ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp722_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
			_tmp723_ = ma;
			_tmp724_ = vala_member_access_get_type_arguments (_tmp723_);
			_tmp725_ = vala_collection_get_size ((ValaCollection*) _tmp724_);
			_tmp726_ = _tmp725_;
			if (_tmp726_ == 0) {
				ValaList* _tmp793_;
				ValaIterator* _tmp794_;
				ValaDataType* _tmp821_;
				ValaDataType* _tmp822_;
				ValaDataType* _tmp823_;
				ValaList* _tmp824_;
				ValaDataType* _tmp825_;
				ValaDataType* _tmp826_;
				{
					ValaList* _type_param_list = NULL;
					ValaMethod* _tmp727_;
					ValaList* _tmp728_;
					gint _type_param_size = 0;
					ValaList* _tmp729_;
					gint _tmp730_;
					gint _tmp731_;
					gint _type_param_index = 0;
					_tmp727_ = m;
					_tmp728_ = vala_method_get_type_parameters (_tmp727_);
					_type_param_list = _tmp728_;
					_tmp729_ = _type_param_list;
					_tmp730_ = vala_collection_get_size ((ValaCollection*) _tmp729_);
					_tmp731_ = _tmp730_;
					_type_param_size = _tmp731_;
					_type_param_index = -1;
					while (TRUE) {
						gint _tmp732_;
						gint _tmp733_;
						ValaTypeParameter* type_param = NULL;
						ValaList* _tmp734_;
						gpointer _tmp735_;
						ValaDataType* type_arg = NULL;
						ValaList* _tmp736_;
						ValaIterator* _tmp737_;
						gboolean _tmp773_ = FALSE;
						ValaDataType* _tmp774_;
						ValaDataType* _tmp784_;
						ValaMemberAccess* _tmp791_;
						ValaDataType* _tmp792_;
						_type_param_index = _type_param_index + 1;
						_tmp732_ = _type_param_index;
						_tmp733_ = _type_param_size;
						if (!(_tmp732_ < _tmp733_)) {
							break;
						}
						_tmp734_ = _type_param_list;
						_tmp735_ = vala_list_get (_tmp734_, _type_param_index);
						type_param = (ValaTypeParameter*) _tmp735_;
						type_arg = NULL;
						_tmp736_ = self->priv->argument_list;
						_tmp737_ = vala_iterable_iterator ((ValaIterable*) _tmp736_);
						_vala_iterator_unref0 (arg_it);
						arg_it = _tmp737_;
						{
							ValaList* _param_list = NULL;
							ValaList* _tmp738_;
							gint _param_size = 0;
							ValaList* _tmp739_;
							gint _tmp740_;
							gint _tmp741_;
							gint _param_index = 0;
							_tmp738_ = params;
							_param_list = _tmp738_;
							_tmp739_ = _param_list;
							_tmp740_ = vala_collection_get_size ((ValaCollection*) _tmp739_);
							_tmp741_ = _tmp740_;
							_param_size = _tmp741_;
							_param_index = -1;
							while (TRUE) {
								gint _tmp742_;
								gint _tmp743_;
								ValaParameter* param = NULL;
								ValaList* _tmp744_;
								gpointer _tmp745_;
								gboolean _tmp746_ = FALSE;
								ValaParameter* _tmp747_;
								gboolean _tmp748_;
								gboolean _tmp749_;
								ValaIterator* _tmp753_;
								_param_index = _param_index + 1;
								_tmp742_ = _param_index;
								_tmp743_ = _param_size;
								if (!(_tmp742_ < _tmp743_)) {
									break;
								}
								_tmp744_ = _param_list;
								_tmp745_ = vala_list_get (_tmp744_, _param_index);
								param = (ValaParameter*) _tmp745_;
								_tmp747_ = param;
								_tmp748_ = vala_parameter_get_ellipsis (_tmp747_);
								_tmp749_ = _tmp748_;
								if (_tmp749_) {
									_tmp746_ = TRUE;
								} else {
									ValaParameter* _tmp750_;
									gboolean _tmp751_;
									gboolean _tmp752_;
									_tmp750_ = param;
									_tmp751_ = vala_parameter_get_params_array (_tmp750_);
									_tmp752_ = _tmp751_;
									_tmp746_ = _tmp752_;
								}
								if (_tmp746_) {
									_vala_code_node_unref0 (param);
									break;
								}
								_tmp753_ = arg_it;
								if (vala_iterator_next (_tmp753_)) {
									ValaExpression* arg = NULL;
									ValaIterator* _tmp754_;
									gpointer _tmp755_;
									ValaParameter* _tmp756_;
									ValaDataType* _tmp757_;
									ValaDataType* _tmp758_;
									ValaTypeParameter* _tmp759_;
									ValaExpression* _tmp760_;
									ValaDataType* _tmp761_;
									ValaDataType* _tmp762_;
									ValaDataType* _tmp763_;
									ValaDataType* _tmp764_;
									ValaExpression* _tmp765_;
									ValaExpression* _tmp766_;
									ValaDataType* _tmp767_;
									ValaDataType* _tmp768_;
									ValaDataType* _tmp769_;
									ValaList* _tmp770_;
									ValaDataType* _tmp771_;
									ValaDataType* _tmp772_;
									_tmp754_ = arg_it;
									_tmp755_ = vala_iterator_get (_tmp754_);
									arg = (ValaExpression*) _tmp755_;
									_tmp756_ = param;
									_tmp757_ = vala_variable_get_variable_type ((ValaVariable*) _tmp756_);
									_tmp758_ = _tmp757_;
									_tmp759_ = type_param;
									_tmp760_ = arg;
									_tmp761_ = vala_expression_get_value_type (_tmp760_);
									_tmp762_ = _tmp761_;
									_tmp763_ = vala_data_type_infer_type_argument (_tmp758_, _tmp759_, _tmp762_);
									_vala_code_node_unref0 (type_arg);
									type_arg = _tmp763_;
									_tmp764_ = type_arg;
									if (_tmp764_ != NULL) {
										_vala_code_node_unref0 (arg);
										_vala_code_node_unref0 (param);
										break;
									}
									_tmp765_ = arg;
									_tmp766_ = arg;
									_tmp767_ = vala_expression_get_formal_target_type (_tmp766_);
									_tmp768_ = _tmp767_;
									_tmp769_ = target_object_type;
									_tmp770_ = method_type_args;
									_tmp771_ = vala_data_type_get_actual_type (_tmp768_, _tmp769_, _tmp770_, (ValaCodeNode*) self);
									_tmp772_ = _tmp771_;
									vala_expression_set_target_type (_tmp765_, _tmp772_);
									_vala_code_node_unref0 (_tmp772_);
									_vala_code_node_unref0 (arg);
								}
								_vala_code_node_unref0 (param);
							}
						}
						_tmp774_ = type_arg;
						if (_tmp774_ == NULL) {
							ValaDataType* _tmp775_;
							ValaDataType* _tmp776_;
							_tmp775_ = vala_expression_get_target_type ((ValaExpression*) self);
							_tmp776_ = _tmp775_;
							_tmp773_ = _tmp776_ != NULL;
						} else {
							_tmp773_ = FALSE;
						}
						if (_tmp773_) {
							ValaMethod* _tmp777_;
							ValaDataType* _tmp778_;
							ValaDataType* _tmp779_;
							ValaTypeParameter* _tmp780_;
							ValaDataType* _tmp781_;
							ValaDataType* _tmp782_;
							ValaDataType* _tmp783_;
							_tmp777_ = m;
							_tmp778_ = vala_callable_get_return_type ((ValaCallable*) _tmp777_);
							_tmp779_ = _tmp778_;
							_tmp780_ = type_param;
							_tmp781_ = vala_expression_get_target_type ((ValaExpression*) self);
							_tmp782_ = _tmp781_;
							_tmp783_ = vala_data_type_infer_type_argument (_tmp779_, _tmp780_, _tmp782_);
							_vala_code_node_unref0 (type_arg);
							type_arg = _tmp783_;
						}
						_tmp784_ = type_arg;
						if (_tmp784_ == NULL) {
							ValaMemberAccess* _tmp785_;
							ValaSourceReference* _tmp786_;
							ValaSourceReference* _tmp787_;
							ValaTypeParameter* _tmp788_;
							gchar* _tmp789_;
							gchar* _tmp790_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp785_ = ma;
							_tmp786_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp785_);
							_tmp787_ = _tmp786_;
							_tmp788_ = type_param;
							_tmp789_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp788_);
							_tmp790_ = _tmp789_;
							vala_report_error (_tmp787_, "cannot infer generic type argument for type parameter `%s'", _tmp790_);
							_g_free0 (_tmp790_);
							result = FALSE;
							_vala_code_node_unref0 (type_arg);
							_vala_code_node_unref0 (type_param);
							_vala_iterator_unref0 (arg_it);
							_vala_code_node_unref0 (last_arg);
							_vala_iterable_unref0 (params);
							_vala_code_node_unref0 (ret_type);
							_vala_code_node_unref0 (mtype);
							_vala_iterable_unref0 (method_type_args);
							_vala_code_node_unref0 (target_object_type);
							return result;
						}
						_tmp791_ = ma;
						_tmp792_ = type_arg;
						vala_member_access_add_type_argument (_tmp791_, _tmp792_);
						_vala_code_node_unref0 (type_arg);
						_vala_code_node_unref0 (type_param);
					}
				}
				_tmp793_ = self->priv->argument_list;
				_tmp794_ = vala_iterable_iterator ((ValaIterable*) _tmp793_);
				_vala_iterator_unref0 (arg_it);
				arg_it = _tmp794_;
				{
					ValaList* _param_list = NULL;
					ValaList* _tmp795_;
					gint _param_size = 0;
					ValaList* _tmp796_;
					gint _tmp797_;
					gint _tmp798_;
					gint _param_index = 0;
					_tmp795_ = params;
					_param_list = _tmp795_;
					_tmp796_ = _param_list;
					_tmp797_ = vala_collection_get_size ((ValaCollection*) _tmp796_);
					_tmp798_ = _tmp797_;
					_param_size = _tmp798_;
					_param_index = -1;
					while (TRUE) {
						gint _tmp799_;
						gint _tmp800_;
						ValaParameter* param = NULL;
						ValaList* _tmp801_;
						gpointer _tmp802_;
						gboolean _tmp803_ = FALSE;
						ValaParameter* _tmp804_;
						gboolean _tmp805_;
						gboolean _tmp806_;
						ValaIterator* _tmp810_;
						_param_index = _param_index + 1;
						_tmp799_ = _param_index;
						_tmp800_ = _param_size;
						if (!(_tmp799_ < _tmp800_)) {
							break;
						}
						_tmp801_ = _param_list;
						_tmp802_ = vala_list_get (_tmp801_, _param_index);
						param = (ValaParameter*) _tmp802_;
						_tmp804_ = param;
						_tmp805_ = vala_parameter_get_ellipsis (_tmp804_);
						_tmp806_ = _tmp805_;
						if (_tmp806_) {
							_tmp803_ = TRUE;
						} else {
							ValaParameter* _tmp807_;
							gboolean _tmp808_;
							gboolean _tmp809_;
							_tmp807_ = param;
							_tmp808_ = vala_parameter_get_params_array (_tmp807_);
							_tmp809_ = _tmp808_;
							_tmp803_ = _tmp809_;
						}
						if (_tmp803_) {
							_vala_code_node_unref0 (param);
							break;
						}
						_tmp810_ = arg_it;
						if (vala_iterator_next (_tmp810_)) {
							ValaExpression* arg = NULL;
							ValaIterator* _tmp811_;
							gpointer _tmp812_;
							ValaExpression* _tmp813_;
							ValaExpression* _tmp814_;
							ValaDataType* _tmp815_;
							ValaDataType* _tmp816_;
							ValaDataType* _tmp817_;
							ValaList* _tmp818_;
							ValaDataType* _tmp819_;
							ValaDataType* _tmp820_;
							_tmp811_ = arg_it;
							_tmp812_ = vala_iterator_get (_tmp811_);
							arg = (ValaExpression*) _tmp812_;
							_tmp813_ = arg;
							_tmp814_ = arg;
							_tmp815_ = vala_expression_get_formal_target_type (_tmp814_);
							_tmp816_ = _tmp815_;
							_tmp817_ = target_object_type;
							_tmp818_ = method_type_args;
							_tmp819_ = vala_data_type_get_actual_type (_tmp816_, _tmp817_, _tmp818_, (ValaCodeNode*) self);
							_tmp820_ = _tmp819_;
							vala_expression_set_target_type (_tmp813_, _tmp820_);
							_vala_code_node_unref0 (_tmp820_);
							_vala_code_node_unref0 (arg);
						}
						_vala_code_node_unref0 (param);
					}
				}
				_tmp821_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
				_tmp822_ = _tmp821_;
				_tmp823_ = target_object_type;
				_tmp824_ = method_type_args;
				_tmp825_ = vala_data_type_get_actual_type (_tmp822_, _tmp823_, _tmp824_, (ValaCodeNode*) self);
				_tmp826_ = _tmp825_;
				vala_expression_set_value_type ((ValaExpression*) self, _tmp826_);
				_vala_code_node_unref0 (_tmp826_);
			}
		}
		_tmp828_ = m;
		if (_tmp828_ != NULL) {
			ValaMethod* _tmp829_;
			gboolean _tmp830_;
			gboolean _tmp831_;
			_tmp829_ = m;
			_tmp830_ = vala_method_get_coroutine (_tmp829_);
			_tmp831_ = _tmp830_;
			_tmp827_ = _tmp831_;
		} else {
			_tmp827_ = FALSE;
		}
		if (_tmp827_) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp832_;
			ValaExpression* _tmp833_;
			ValaMemberAccess* _tmp834_;
			const gchar* _tmp835_;
			const gchar* _tmp836_;
			_tmp832_ = vala_method_call_get_call (self);
			_tmp833_ = _tmp832_;
			ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp833_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
			_tmp834_ = ma;
			_tmp835_ = vala_member_access_get_member_name (_tmp834_);
			_tmp836_ = _tmp835_;
			if (g_strcmp0 (_tmp836_, "end") == 0) {
				ValaMethod* _tmp837_;
				ValaMethod* _tmp838_;
				ValaMethodType* _tmp839_;
				ValaDataType* _tmp840_;
				ValaSourceReference* _tmp841_;
				ValaSourceReference* _tmp842_;
				_tmp837_ = m;
				_tmp838_ = vala_method_get_end_method (_tmp837_);
				_tmp839_ = vala_method_type_new (_tmp838_);
				_vala_code_node_unref0 (mtype);
				mtype = (ValaDataType*) _tmp839_;
				_tmp840_ = mtype;
				_tmp841_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp842_ = _tmp841_;
				vala_code_node_set_source_reference ((ValaCodeNode*) _tmp840_, _tmp842_);
			}
		}
	}
	_tmp843_ = vala_code_context_get_analyzer (context);
	_tmp844_ = _tmp843_;
	_tmp845_ = mtype;
	_tmp846_ = params;
	_tmp847_ = self->priv->argument_list;
	if (!vala_semantic_analyzer_check_arguments (_tmp844_, (ValaExpression*) self, _tmp845_, _tmp846_, _tmp847_)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		_vala_iterator_unref0 (arg_it);
		_vala_code_node_unref0 (last_arg);
		_vala_iterable_unref0 (params);
		_vala_code_node_unref0 (ret_type);
		_vala_code_node_unref0 (mtype);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (target_object_type);
		return result;
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp848_;
		gint _arg_size = 0;
		ValaList* _tmp849_;
		gint _tmp850_;
		gint _tmp851_;
		gint _arg_index = 0;
		_tmp848_ = self->priv->argument_list;
		_arg_list = _tmp848_;
		_tmp849_ = _arg_list;
		_tmp850_ = vala_collection_get_size ((ValaCollection*) _tmp849_);
		_tmp851_ = _tmp850_;
		_arg_size = _tmp851_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp852_;
			gint _tmp853_;
			ValaExpression* arg = NULL;
			ValaList* _tmp854_;
			gpointer _tmp855_;
			ValaSizeofExpression* sizeof_expr = NULL;
			ValaExpression* _tmp856_;
			gboolean _tmp857_ = FALSE;
			ValaSizeofExpression* _tmp858_;
			_arg_index = _arg_index + 1;
			_tmp852_ = _arg_index;
			_tmp853_ = _arg_size;
			if (!(_tmp852_ < _tmp853_)) {
				break;
			}
			_tmp854_ = _arg_list;
			_tmp855_ = vala_list_get (_tmp854_, _arg_index);
			arg = (ValaExpression*) _tmp855_;
			_tmp856_ = arg;
			sizeof_expr = VALA_IS_SIZEOF_EXPRESSION (_tmp856_) ? ((ValaSizeofExpression*) _tmp856_) : NULL;
			_tmp858_ = sizeof_expr;
			if (_tmp858_ != NULL) {
				ValaSizeofExpression* _tmp859_;
				ValaDataType* _tmp860_;
				ValaDataType* _tmp861_;
				_tmp859_ = sizeof_expr;
				_tmp860_ = vala_sizeof_expression_get_type_reference (_tmp859_);
				_tmp861_ = _tmp860_;
				_tmp857_ = VALA_IS_GENERIC_TYPE (_tmp861_);
			} else {
				_tmp857_ = FALSE;
			}
			if (_tmp857_) {
				ValaDataType* sizeof_type = NULL;
				ValaSizeofExpression* _tmp862_;
				ValaDataType* _tmp863_;
				ValaDataType* _tmp864_;
				ValaDataType* _tmp865_;
				ValaList* _tmp866_;
				ValaDataType* _tmp867_;
				ValaExpression* _tmp868_;
				ValaDataType* _tmp869_;
				ValaSourceReference* _tmp870_;
				ValaSourceReference* _tmp871_;
				ValaSizeofExpression* _tmp872_;
				ValaSizeofExpression* _tmp873_;
				_tmp862_ = sizeof_expr;
				_tmp863_ = vala_sizeof_expression_get_type_reference (_tmp862_);
				_tmp864_ = _tmp863_;
				_tmp865_ = target_object_type;
				_tmp866_ = method_type_args;
				_tmp867_ = vala_data_type_get_actual_type (_tmp864_, _tmp865_, _tmp866_, (ValaCodeNode*) self);
				sizeof_type = _tmp867_;
				_tmp868_ = arg;
				_tmp869_ = sizeof_type;
				_tmp870_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp871_ = _tmp870_;
				_tmp872_ = vala_sizeof_expression_new (_tmp869_, _tmp871_);
				_tmp873_ = _tmp872_;
				vala_code_node_replace_expression ((ValaCodeNode*) self, _tmp868_, (ValaExpression*) _tmp873_);
				_vala_code_node_unref0 (_tmp873_);
				_vala_code_node_unref0 (sizeof_type);
			}
			_vala_code_node_unref0 (arg);
		}
	}
	_tmp876_ = base_cm;
	if (_tmp876_ != NULL) {
		ValaCreationMethod* _tmp877_;
		_tmp877_ = base_cm;
		_tmp875_ = vala_method_is_variadic ((ValaMethod*) _tmp877_);
	} else {
		_tmp875_ = FALSE;
	}
	if (_tmp875_) {
		ValaList* _tmp878_;
		gint _tmp879_;
		gint _tmp880_;
		ValaCreationMethod* _tmp881_;
		ValaList* _tmp882_;
		gint _tmp883_;
		gint _tmp884_;
		_tmp878_ = self->priv->argument_list;
		_tmp879_ = vala_collection_get_size ((ValaCollection*) _tmp878_);
		_tmp880_ = _tmp879_;
		_tmp881_ = base_cm;
		_tmp882_ = vala_callable_get_parameters ((ValaCallable*) _tmp881_);
		_tmp883_ = vala_collection_get_size ((ValaCollection*) _tmp882_);
		_tmp884_ = _tmp883_;
		_tmp874_ = _tmp880_ == _tmp884_;
	} else {
		_tmp874_ = FALSE;
	}
	if (_tmp874_) {
		ValaExpression* this_last_arg = NULL;
		ValaList* _tmp885_;
		ValaList* _tmp886_;
		gint _tmp887_;
		gint _tmp888_;
		gpointer _tmp889_;
		gboolean _tmp890_ = FALSE;
		ValaExpression* _tmp891_;
		ValaDataType* _tmp892_;
		ValaDataType* _tmp893_;
		_tmp885_ = self->priv->argument_list;
		_tmp886_ = self->priv->argument_list;
		_tmp887_ = vala_collection_get_size ((ValaCollection*) _tmp886_);
		_tmp888_ = _tmp887_;
		_tmp889_ = vala_list_get (_tmp885_, _tmp888_ - 1);
		this_last_arg = (ValaExpression*) _tmp889_;
		_tmp891_ = this_last_arg;
		_tmp892_ = vala_expression_get_value_type (_tmp891_);
		_tmp893_ = _tmp892_;
		if (VALA_IS_STRUCT_VALUE_TYPE (_tmp893_)) {
			ValaExpression* _tmp894_;
			ValaDataType* _tmp895_;
			ValaDataType* _tmp896_;
			ValaTypeSymbol* _tmp897_;
			ValaTypeSymbol* _tmp898_;
			ValaSemanticAnalyzer* _tmp899_;
			ValaSemanticAnalyzer* _tmp900_;
			ValaDataType* _tmp901_;
			ValaTypeSymbol* _tmp902_;
			ValaTypeSymbol* _tmp903_;
			_tmp894_ = this_last_arg;
			_tmp895_ = vala_expression_get_value_type (_tmp894_);
			_tmp896_ = _tmp895_;
			_tmp897_ = vala_data_type_get_type_symbol (_tmp896_);
			_tmp898_ = _tmp897_;
			_tmp899_ = vala_code_context_get_analyzer (context);
			_tmp900_ = _tmp899_;
			_tmp901_ = _tmp900_->va_list_type;
			_tmp902_ = vala_data_type_get_type_symbol (_tmp901_);
			_tmp903_ = _tmp902_;
			_tmp890_ = _tmp898_ == _tmp903_;
		} else {
			_tmp890_ = FALSE;
		}
		if (_tmp890_) {
			vala_method_call_set_is_constructv_chainup (self, TRUE);
		}
		_vala_code_node_unref0 (this_last_arg);
	}
	_tmp904_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp905_ = _tmp904_;
	vala_code_node_check ((ValaCodeNode*) _tmp905_, context);
	_tmp906_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
	_tmp907_ = _tmp906_;
	if (_tmp907_) {
		gboolean _tmp908_ = FALSE;
		ValaCodeNode* _tmp909_;
		ValaCodeNode* _tmp910_;
		_tmp909_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp910_ = _tmp909_;
		if (VALA_IS_LOCAL_VARIABLE (_tmp910_)) {
			_tmp908_ = TRUE;
		} else {
			ValaCodeNode* _tmp911_;
			ValaCodeNode* _tmp912_;
			_tmp911_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp912_ = _tmp911_;
			_tmp908_ = VALA_IS_EXPRESSION_STATEMENT (_tmp912_);
		}
		if (_tmp908_) {
		} else {
			ValaSemanticAnalyzer* _tmp913_;
			ValaSemanticAnalyzer* _tmp914_;
			ValaSymbol* _tmp915_;
			ValaSymbol* _tmp916_;
			_tmp913_ = vala_code_context_get_analyzer (context);
			_tmp914_ = _tmp913_;
			_tmp915_ = vala_semantic_analyzer_get_current_symbol (_tmp914_);
			_tmp916_ = _tmp915_;
			if (!VALA_IS_BLOCK (_tmp916_)) {
				ValaSourceReference* _tmp917_;
				ValaSourceReference* _tmp918_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp917_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp918_ = _tmp917_;
				vala_report_error (_tmp918_, "Field initializers must not throw errors");
			} else {
				ValaCodeNode* old_parent_node = NULL;
				ValaCodeNode* _tmp919_;
				ValaCodeNode* _tmp920_;
				ValaCodeNode* _tmp921_;
				ValaLocalVariable* local = NULL;
				ValaDataType* _tmp922_;
				ValaDataType* _tmp923_;
				ValaDataType* _tmp924_;
				ValaDataType* _tmp925_;
				gchar* _tmp926_;
				gchar* _tmp927_;
				ValaSourceReference* _tmp928_;
				ValaSourceReference* _tmp929_;
				ValaLocalVariable* _tmp930_;
				ValaLocalVariable* _tmp931_;
				ValaDeclarationStatement* decl = NULL;
				ValaLocalVariable* _tmp932_;
				ValaSourceReference* _tmp933_;
				ValaSourceReference* _tmp934_;
				ValaDeclarationStatement* _tmp935_;
				ValaDataType* _tmp936_;
				ValaDataType* _tmp937_;
				ValaSemanticAnalyzer* _tmp941_;
				ValaSemanticAnalyzer* _tmp942_;
				ValaBlock* _tmp943_;
				ValaDeclarationStatement* _tmp944_;
				ValaExpression* temp_access = NULL;
				ValaLocalVariable* _tmp945_;
				ValaDataType* _tmp946_;
				ValaDataType* _tmp947_;
				ValaExpression* _tmp948_;
				ValaExpression* _tmp949_;
				ValaDataType* _tmp950_;
				ValaDataType* _tmp951_;
				ValaLocalVariable* _tmp952_;
				ValaDeclarationStatement* _tmp953_;
				ValaBlock* block = NULL;
				ValaSemanticAnalyzer* _tmp954_;
				ValaSemanticAnalyzer* _tmp955_;
				ValaSymbol* _tmp956_;
				ValaSymbol* _tmp957_;
				ValaBlock* _tmp958_;
				ValaBlock* _tmp959_;
				ValaLocalVariable* _tmp960_;
				ValaSemanticAnalyzer* _tmp961_;
				ValaSemanticAnalyzer* _tmp962_;
				ValaBlock* _tmp963_;
				ValaLocalVariable* _tmp964_;
				ValaCodeNode* _tmp965_;
				ValaExpression* _tmp966_;
				ValaExpression* _tmp967_;
				_tmp919_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp920_ = _tmp919_;
				_tmp921_ = _vala_code_node_ref0 (_tmp920_);
				old_parent_node = _tmp921_;
				_tmp922_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp923_ = _tmp922_;
				_tmp924_ = vala_data_type_copy (_tmp923_);
				_tmp925_ = _tmp924_;
				_tmp926_ = vala_code_node_get_temp_name ();
				_tmp927_ = _tmp926_;
				_tmp928_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp929_ = _tmp928_;
				_tmp930_ = vala_local_variable_new (_tmp925_, _tmp927_, NULL, _tmp929_);
				_tmp931_ = _tmp930_;
				_g_free0 (_tmp927_);
				_vala_code_node_unref0 (_tmp925_);
				local = _tmp931_;
				_tmp932_ = local;
				_tmp933_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp934_ = _tmp933_;
				_tmp935_ = vala_declaration_statement_new ((ValaSymbol*) _tmp932_, _tmp934_);
				decl = _tmp935_;
				_tmp936_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp937_ = _tmp936_;
				if (_tmp937_ == NULL) {
					ValaLocalVariable* _tmp938_;
					ValaDataType* _tmp939_;
					ValaDataType* _tmp940_;
					_tmp938_ = local;
					_tmp939_ = vala_variable_get_variable_type ((ValaVariable*) _tmp938_);
					_tmp940_ = _tmp939_;
					vala_data_type_set_floating_reference (_tmp940_, FALSE);
				}
				_tmp941_ = vala_code_context_get_analyzer (context);
				_tmp942_ = _tmp941_;
				_tmp943_ = _tmp942_->insert_block;
				_tmp944_ = decl;
				vala_expression_insert_statement ((ValaExpression*) self, _tmp943_, (ValaStatement*) _tmp944_);
				_tmp945_ = local;
				_tmp946_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp947_ = _tmp946_;
				_tmp948_ = vala_semantic_analyzer_create_temp_access (_tmp945_, _tmp947_);
				temp_access = _tmp948_;
				_tmp949_ = temp_access;
				_tmp950_ = vala_expression_get_formal_target_type ((ValaExpression*) self);
				_tmp951_ = _tmp950_;
				vala_expression_set_formal_target_type (_tmp949_, _tmp951_);
				_tmp952_ = local;
				vala_variable_set_initializer ((ValaVariable*) _tmp952_, (ValaExpression*) self);
				_tmp953_ = decl;
				vala_code_node_check ((ValaCodeNode*) _tmp953_, context);
				_tmp954_ = vala_code_context_get_analyzer (context);
				_tmp955_ = _tmp954_;
				_tmp956_ = vala_semantic_analyzer_get_current_symbol (_tmp955_);
				_tmp957_ = _tmp956_;
				_tmp958_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp957_, VALA_TYPE_BLOCK, ValaBlock));
				block = _tmp958_;
				_tmp959_ = block;
				_tmp960_ = local;
				vala_block_remove_local_variable (_tmp959_, _tmp960_);
				_tmp961_ = vala_code_context_get_analyzer (context);
				_tmp962_ = _tmp961_;
				_tmp963_ = _tmp962_->insert_block;
				_tmp964_ = local;
				vala_block_add_local_variable (_tmp963_, _tmp964_);
				_tmp965_ = old_parent_node;
				_tmp966_ = temp_access;
				vala_code_node_replace_expression (_tmp965_, (ValaExpression*) self, _tmp966_);
				_tmp967_ = temp_access;
				vala_code_node_check ((ValaCodeNode*) _tmp967_, context);
				_vala_code_node_unref0 (block);
				_vala_code_node_unref0 (temp_access);
				_vala_code_node_unref0 (decl);
				_vala_code_node_unref0 (local);
				_vala_code_node_unref0 (old_parent_node);
			}
		}
	}
	_tmp968_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp969_ = _tmp968_;
	result = !_tmp969_;
	_vala_iterator_unref0 (arg_it);
	_vala_code_node_unref0 (last_arg);
	_vala_iterable_unref0 (params);
	_vala_code_node_unref0 (ret_type);
	_vala_code_node_unref0 (mtype);
	_vala_iterable_unref0 (method_type_args);
	_vala_code_node_unref0 (target_object_type);
	return result;
}

static void
vala_method_call_real_emit (ValaCodeNode* base,
                            ValaCodeGenerator* codegen)
{
	ValaMethodCall * self;
	ValaMethodType* method_type = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	gboolean _tmp4_ = FALSE;
	ValaMethodType* _tmp5_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	method_type = VALA_IS_METHOD_TYPE (_tmp3_) ? ((ValaMethodType*) _tmp3_) : NULL;
	_tmp5_ = method_type;
	if (_tmp5_ != NULL) {
		ValaMethodType* _tmp6_;
		ValaMethod* _tmp7_;
		ValaMethod* _tmp8_;
		ValaSymbol* _tmp9_;
		ValaSymbol* _tmp10_;
		_tmp6_ = method_type;
		_tmp7_ = vala_method_type_get_method_symbol (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp4_ = VALA_IS_SIGNAL (_tmp10_);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaExpression* _tmp11_;
		ValaExpression* _tmp12_;
		ValaExpression* _tmp13_;
		ValaExpression* _tmp14_;
		_tmp11_ = vala_method_call_get_call (self);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		_tmp14_ = _tmp13_;
		vala_code_node_emit ((ValaCodeNode*) _tmp14_, codegen);
	} else {
		ValaExpression* _tmp15_;
		ValaExpression* _tmp16_;
		_tmp15_ = vala_method_call_get_call (self);
		_tmp16_ = _tmp15_;
		vala_code_node_emit ((ValaCodeNode*) _tmp16_, codegen);
	}
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp17_;
		gint _expr_size = 0;
		ValaList* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _expr_index = 0;
		_tmp17_ = self->priv->argument_list;
		_expr_list = _tmp17_;
		_tmp18_ = _expr_list;
		_tmp19_ = vala_collection_get_size ((ValaCollection*) _tmp18_);
		_tmp20_ = _tmp19_;
		_expr_size = _tmp20_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp21_;
			gint _tmp22_;
			ValaExpression* expr = NULL;
			ValaList* _tmp23_;
			gpointer _tmp24_;
			ValaExpression* _tmp25_;
			_expr_index = _expr_index + 1;
			_tmp21_ = _expr_index;
			_tmp22_ = _expr_size;
			if (!(_tmp21_ < _tmp22_)) {
				break;
			}
			_tmp23_ = _expr_list;
			_tmp24_ = vala_list_get (_tmp23_, _expr_index);
			expr = (ValaExpression*) _tmp24_;
			_tmp25_ = expr;
			vala_code_node_emit ((ValaCodeNode*) _tmp25_, codegen);
			_vala_code_node_unref0 (expr);
		}
	}
	vala_code_visitor_visit_method_call ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_method_call_real_get_defined_variables (ValaCodeNode* base,
                                             ValaCollection* collection)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, collection);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp2_;
		gint _arg_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _arg_index = 0;
		_tmp2_ = self->priv->argument_list;
		_arg_list = _tmp2_;
		_tmp3_ = _arg_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_arg_size = _tmp5_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* arg = NULL;
			ValaList* _tmp8_;
			gpointer _tmp9_;
			ValaExpression* _tmp10_;
			_arg_index = _arg_index + 1;
			_tmp6_ = _arg_index;
			_tmp7_ = _arg_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _arg_list;
			_tmp9_ = vala_list_get (_tmp8_, _arg_index);
			arg = (ValaExpression*) _tmp9_;
			_tmp10_ = arg;
			vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp10_, collection);
			_vala_code_node_unref0 (arg);
		}
	}
}

static void
vala_method_call_real_get_used_variables (ValaCodeNode* base,
                                          ValaCollection* collection)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp1_, collection);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp2_;
		gint _arg_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _arg_index = 0;
		_tmp2_ = self->priv->argument_list;
		_arg_list = _tmp2_;
		_tmp3_ = _arg_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_arg_size = _tmp5_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* arg = NULL;
			ValaList* _tmp8_;
			gpointer _tmp9_;
			ValaExpression* _tmp10_;
			_arg_index = _arg_index + 1;
			_tmp6_ = _arg_index;
			_tmp7_ = _arg_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _arg_list;
			_tmp9_ = vala_list_get (_tmp8_, _arg_index);
			arg = (ValaExpression*) _tmp9_;
			_tmp10_ = arg;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp10_, collection);
			_vala_code_node_unref0 (arg);
		}
	}
}

ValaStringLiteral*
vala_method_call_get_format_literal (ValaMethodCall* self)
{
	ValaMethodType* mtype = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaMethodType* _tmp4_;
	ValaStringLiteral* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	mtype = VALA_IS_METHOD_TYPE (_tmp3_) ? ((ValaMethodType*) _tmp3_) : NULL;
	_tmp4_ = mtype;
	if (_tmp4_ != NULL) {
		gint format_arg = 0;
		ValaMethodType* _tmp5_;
		ValaMethod* _tmp6_;
		ValaMethod* _tmp7_;
		gboolean _tmp8_ = FALSE;
		_tmp5_ = mtype;
		_tmp6_ = vala_method_type_get_method_symbol (_tmp5_);
		_tmp7_ = _tmp6_;
		format_arg = vala_method_get_format_arg_index (_tmp7_);
		if (format_arg >= 0) {
			ValaList* _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			_tmp9_ = self->priv->argument_list;
			_tmp10_ = vala_collection_get_size ((ValaCollection*) _tmp9_);
			_tmp11_ = _tmp10_;
			_tmp8_ = format_arg < _tmp11_;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			ValaList* _tmp12_;
			gpointer _tmp13_;
			ValaExpression* _tmp14_;
			ValaStringLiteral* _tmp15_;
			ValaStringLiteral* _tmp16_;
			_tmp12_ = self->priv->argument_list;
			_tmp13_ = vala_list_get (_tmp12_, format_arg);
			_tmp14_ = (ValaExpression*) _tmp13_;
			_tmp15_ = vala_string_literal_get_format_literal (_tmp14_);
			_tmp16_ = _tmp15_;
			_vala_code_node_unref0 (_tmp14_);
			result = _tmp16_;
			return result;
		}
	}
	result = NULL;
	return result;
}

static gchar*
vala_method_call_real_to_string (ValaCodeNode* base)
{
	ValaMethodCall * self;
	GString* b = NULL;
	GString* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GString* _tmp4_;
	ValaExpression* _tmp5_;
	ValaExpression* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GString* _tmp9_;
	gboolean first = FALSE;
	GString* _tmp23_;
	GString* _tmp24_;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* result = NULL;
	self = (ValaMethodCall*) base;
	_tmp0_ = g_string_new ("");
	b = _tmp0_;
	_tmp1_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GString* _tmp3_;
		_tmp3_ = b;
		g_string_append (_tmp3_, "yield ");
	}
	_tmp4_ = b;
	_tmp5_ = vala_method_call_get_call (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_code_node_to_string ((ValaCodeNode*) _tmp6_);
	_tmp8_ = _tmp7_;
	g_string_append (_tmp4_, _tmp8_);
	_g_free0 (_tmp8_);
	_tmp9_ = b;
	g_string_append_c (_tmp9_, '(');
	first = TRUE;
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp10_;
		gint _expr_size = 0;
		ValaList* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gint _expr_index = 0;
		_tmp10_ = self->priv->argument_list;
		_expr_list = _tmp10_;
		_tmp11_ = _expr_list;
		_tmp12_ = vala_collection_get_size ((ValaCollection*) _tmp11_);
		_tmp13_ = _tmp12_;
		_expr_size = _tmp13_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp14_;
			gint _tmp15_;
			ValaExpression* expr = NULL;
			ValaList* _tmp16_;
			gpointer _tmp17_;
			GString* _tmp19_;
			ValaExpression* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			_expr_index = _expr_index + 1;
			_tmp14_ = _expr_index;
			_tmp15_ = _expr_size;
			if (!(_tmp14_ < _tmp15_)) {
				break;
			}
			_tmp16_ = _expr_list;
			_tmp17_ = vala_list_get (_tmp16_, _expr_index);
			expr = (ValaExpression*) _tmp17_;
			if (!first) {
				GString* _tmp18_;
				_tmp18_ = b;
				g_string_append (_tmp18_, ", ");
			}
			_tmp19_ = b;
			_tmp20_ = expr;
			_tmp21_ = vala_code_node_to_string ((ValaCodeNode*) _tmp20_);
			_tmp22_ = _tmp21_;
			g_string_append (_tmp19_, _tmp22_);
			_g_free0 (_tmp22_);
			first = FALSE;
			_vala_code_node_unref0 (expr);
		}
	}
	_tmp23_ = b;
	g_string_append_c (_tmp23_, ')');
	_tmp24_ = b;
	_tmp25_ = _tmp24_->str;
	_tmp26_ = g_strdup (_tmp25_);
	result = _tmp26_;
	_g_string_free0 (b);
	return result;
}

static void
vala_method_call_class_init (ValaMethodCallClass * klass,
                             gpointer klass_data)
{
	vala_method_call_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_method_call_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMethodCall_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_method_call_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_method_call_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_method_call_real_replace_expression;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_method_call_real_is_constant;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_method_call_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_method_call_real_is_accessible;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_method_call_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_method_call_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_method_call_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_method_call_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_method_call_real_get_used_variables;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_method_call_real_to_string;
}

static void
vala_method_call_vala_callable_expression_interface_init (ValaCallableExpressionIface * iface,
                                                          gpointer iface_data)
{
	vala_method_call_vala_callable_expression_parent_iface = g_type_interface_peek_parent (iface);
	iface->add_argument = (void (*) (ValaCallableExpression*, ValaExpression*)) vala_method_call_real_add_argument;
	iface->get_argument_list = (ValaList* (*) (ValaCallableExpression*)) vala_method_call_real_get_argument_list;
	iface->get_is_yield_expression = vala_method_call_real_get_is_yield_expression;
	iface->set_is_yield_expression = vala_method_call_real_set_is_yield_expression;
}

static void
vala_method_call_instance_init (ValaMethodCall * self,
                                gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_method_call_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->argument_list = (ValaList*) _tmp1_;
}

static void
vala_method_call_finalize (ValaCodeNode * obj)
{
	ValaMethodCall * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_METHOD_CALL, ValaMethodCall);
	_vala_code_node_unref0 (self->priv->_call);
	_vala_iterable_unref0 (self->priv->argument_list);
	VALA_CODE_NODE_CLASS (vala_method_call_parent_class)->finalize (obj);
}

/**
 * Represents an invocation expression in the source code.
 */
static GType
vala_method_call_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaMethodCallClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_method_call_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMethodCall), 0, (GInstanceInitFunc) vala_method_call_instance_init, NULL };
	static const GInterfaceInfo vala_callable_expression_info = { (GInterfaceInitFunc) vala_method_call_vala_callable_expression_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType vala_method_call_type_id;
	vala_method_call_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMethodCall", &g_define_type_info, 0);
	g_type_add_interface_static (vala_method_call_type_id, VALA_TYPE_CALLABLE_EXPRESSION, &vala_callable_expression_info);
	ValaMethodCall_private_offset = g_type_add_instance_private (vala_method_call_type_id, sizeof (ValaMethodCallPrivate));
	return vala_method_call_type_id;
}

GType
vala_method_call_get_type (void)
{
	static volatile gsize vala_method_call_type_id__volatile = 0;
	if (g_once_init_enter (&vala_method_call_type_id__volatile)) {
		GType vala_method_call_type_id;
		vala_method_call_type_id = vala_method_call_get_type_once ();
		g_once_init_leave (&vala_method_call_type_id__volatile, vala_method_call_type_id);
	}
	return vala_method_call_type_id__volatile;
}

