// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use gio_sys;
use glib::object::IsA;
use glib::translate::*;
use std::fmt;
use MenuItem;
use MenuModel;

glib_wrapper! {
    pub struct Menu(Object<gio_sys::GMenu, MenuClass>) @extends MenuModel;

    match fn {
        get_type => || gio_sys::g_menu_get_type(),
    }
}

impl Menu {
    pub fn new() -> Menu {
        unsafe { from_glib_full(gio_sys::g_menu_new()) }
    }

    pub fn append(&self, label: Option<&str>, detailed_action: Option<&str>) {
        unsafe {
            gio_sys::g_menu_append(
                self.to_glib_none().0,
                label.to_glib_none().0,
                detailed_action.to_glib_none().0,
            );
        }
    }

    pub fn append_item(&self, item: &MenuItem) {
        unsafe {
            gio_sys::g_menu_append_item(self.to_glib_none().0, item.to_glib_none().0);
        }
    }

    pub fn append_section<P: IsA<MenuModel>>(&self, label: Option<&str>, section: &P) {
        unsafe {
            gio_sys::g_menu_append_section(
                self.to_glib_none().0,
                label.to_glib_none().0,
                section.as_ref().to_glib_none().0,
            );
        }
    }

    pub fn append_submenu<P: IsA<MenuModel>>(&self, label: Option<&str>, submenu: &P) {
        unsafe {
            gio_sys::g_menu_append_submenu(
                self.to_glib_none().0,
                label.to_glib_none().0,
                submenu.as_ref().to_glib_none().0,
            );
        }
    }

    pub fn freeze(&self) {
        unsafe {
            gio_sys::g_menu_freeze(self.to_glib_none().0);
        }
    }

    pub fn insert(&self, position: i32, label: Option<&str>, detailed_action: Option<&str>) {
        unsafe {
            gio_sys::g_menu_insert(
                self.to_glib_none().0,
                position,
                label.to_glib_none().0,
                detailed_action.to_glib_none().0,
            );
        }
    }

    pub fn insert_item(&self, position: i32, item: &MenuItem) {
        unsafe {
            gio_sys::g_menu_insert_item(self.to_glib_none().0, position, item.to_glib_none().0);
        }
    }

    pub fn insert_section<P: IsA<MenuModel>>(
        &self,
        position: i32,
        label: Option<&str>,
        section: &P,
    ) {
        unsafe {
            gio_sys::g_menu_insert_section(
                self.to_glib_none().0,
                position,
                label.to_glib_none().0,
                section.as_ref().to_glib_none().0,
            );
        }
    }

    pub fn insert_submenu<P: IsA<MenuModel>>(
        &self,
        position: i32,
        label: Option<&str>,
        submenu: &P,
    ) {
        unsafe {
            gio_sys::g_menu_insert_submenu(
                self.to_glib_none().0,
                position,
                label.to_glib_none().0,
                submenu.as_ref().to_glib_none().0,
            );
        }
    }

    pub fn prepend(&self, label: Option<&str>, detailed_action: Option<&str>) {
        unsafe {
            gio_sys::g_menu_prepend(
                self.to_glib_none().0,
                label.to_glib_none().0,
                detailed_action.to_glib_none().0,
            );
        }
    }

    pub fn prepend_item(&self, item: &MenuItem) {
        unsafe {
            gio_sys::g_menu_prepend_item(self.to_glib_none().0, item.to_glib_none().0);
        }
    }

    pub fn prepend_section<P: IsA<MenuModel>>(&self, label: Option<&str>, section: &P) {
        unsafe {
            gio_sys::g_menu_prepend_section(
                self.to_glib_none().0,
                label.to_glib_none().0,
                section.as_ref().to_glib_none().0,
            );
        }
    }

    pub fn prepend_submenu<P: IsA<MenuModel>>(&self, label: Option<&str>, submenu: &P) {
        unsafe {
            gio_sys::g_menu_prepend_submenu(
                self.to_glib_none().0,
                label.to_glib_none().0,
                submenu.as_ref().to_glib_none().0,
            );
        }
    }

    pub fn remove(&self, position: i32) {
        unsafe {
            gio_sys::g_menu_remove(self.to_glib_none().0, position);
        }
    }

    pub fn remove_all(&self) {
        unsafe {
            gio_sys::g_menu_remove_all(self.to_glib_none().0);
        }
    }
}

impl Default for Menu {
    fn default() -> Self {
        Self::new()
    }
}

impl fmt::Display for Menu {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "Menu")
    }
}
