/* valamemberaccess.c generated by valac, the Vala compiler
 * generated from valamemberaccess.vala, do not modify */

/* valamemberaccess.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))

struct _ValaMemberAccessPrivate {
	gchar* _member_name;
	gboolean _pointer_member_access;
	gboolean _prototype_access;
	gboolean _tainted_access;
	gboolean _creation_member;
	gboolean _qualified;
	gboolean _null_safe_access;
	ValaExpression* _inner;
	ValaList* type_argument_list;
	gboolean is_with_variable_access;
};

struct _Block1Data {
	int _ref_count_;
	ValaMemberAccess* self;
	gboolean found;
};

static gint ValaMemberAccess_private_offset;
static gpointer vala_member_access_parent_class = NULL;

static void vala_member_access_real_accept (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor);
static void vala_member_access_real_accept_children (ValaCodeNode* base,
                                              ValaCodeVisitor* visitor);
static gchar* vala_member_access_real_to_string (ValaCodeNode* base);
static void vala_member_access_real_replace_expression (ValaCodeNode* base,
                                                 ValaExpression* old_node,
                                                 ValaExpression* new_node);
static gboolean vala_member_access_real_is_pure (ValaExpression* base);
static gboolean vala_member_access_real_is_accessible (ValaExpression* base,
                                                ValaSymbol* sym);
static void vala_member_access_real_replace_type (ValaCodeNode* base,
                                           ValaDataType* old_type,
                                           ValaDataType* new_type);
static gboolean vala_member_access_real_is_constant (ValaExpression* base);
static gboolean vala_member_access_real_is_non_null (ValaExpression* base);
static void vala_member_access_real_get_error_types (ValaCodeNode* base,
                                              ValaCollection* collection,
                                              ValaSourceReference* source_reference);
static gboolean vala_member_access_real_check (ValaCodeNode* base,
                                        ValaCodeContext* context);
static gboolean vala_member_access_is_instance_symbol (ValaSymbol* symbol);
static void vala_member_access_check_narrowed_value_type (ValaMemberAccess* self);
static gboolean vala_member_access_is_tainted (ValaMemberAccess* self);
static void vala_member_access_real_emit (ValaCodeNode* base,
                                   ValaCodeGenerator* codegen);
static void vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                                    ValaCollection* collection);
static void vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                                 ValaCollection* collection);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static ValaTraverseStatus __lambda4_ (Block1Data* _data1_,
                               ValaCodeNode* n);
static ValaTraverseStatus ___lambda4__vala_traverse_func (ValaCodeNode* node,
                                                   gpointer self);
static void vala_member_access_finalize (ValaCodeNode * obj);
static GType vala_member_access_get_type_once (void);

static inline gpointer
vala_member_access_get_instance_private (ValaMemberAccess* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMemberAccess_private_offset);
}

ValaExpression*
vala_member_access_get_inner (ValaMemberAccess* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_inner;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_member_access_set_inner (ValaMemberAccess* self,
                              ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_inner);
	self->priv->_inner = _tmp0_;
	_tmp1_ = self->priv->_inner;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		_tmp2_ = self->priv->_inner;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}

const gchar*
vala_member_access_get_member_name (ValaMemberAccess* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_member_name;
	result = _tmp0_;
	return result;
}

void
vala_member_access_set_member_name (ValaMemberAccess* self,
                                    const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_member_name);
	self->priv->_member_name = _tmp0_;
}

gboolean
vala_member_access_get_pointer_member_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_pointer_member_access;
	return result;
}

void
vala_member_access_set_pointer_member_access (ValaMemberAccess* self,
                                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_pointer_member_access = value;
}

gboolean
vala_member_access_get_prototype_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_prototype_access;
	return result;
}

void
vala_member_access_set_prototype_access (ValaMemberAccess* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_prototype_access = value;
}

gboolean
vala_member_access_get_tainted_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_tainted_access;
	return result;
}

void
vala_member_access_set_tainted_access (ValaMemberAccess* self,
                                       gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_tainted_access = value;
}

gboolean
vala_member_access_get_creation_member (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_creation_member;
	return result;
}

void
vala_member_access_set_creation_member (ValaMemberAccess* self,
                                        gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_creation_member = value;
}

gboolean
vala_member_access_get_qualified (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_qualified;
	return result;
}

void
vala_member_access_set_qualified (ValaMemberAccess* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_qualified = value;
}

gboolean
vala_member_access_get_null_safe_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_null_safe_access;
	return result;
}

void
vala_member_access_set_null_safe_access (ValaMemberAccess* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_null_safe_access = value;
}

/**
 * Creates a new member access expression.
 *
 * @param inner            parent of the member
 * @param member_name      member name
 * @param source_reference reference to source code
 * @return                 newly created member access expression
 */
ValaMemberAccess*
vala_member_access_construct (GType object_type,
                              ValaExpression* inner,
                              const gchar* member_name,
                              ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new (ValaExpression* inner,
                        const gchar* member_name,
                        ValaSourceReference* source_reference)
{
	return vala_member_access_construct (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_simple (GType object_type,
                                     const gchar* member_name,
                                     ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, NULL);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new_simple (const gchar* member_name,
                               ValaSourceReference* source_reference)
{
	return vala_member_access_construct_simple (VALA_TYPE_MEMBER_ACCESS, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_pointer (GType object_type,
                                      ValaExpression* inner,
                                      const gchar* member_name,
                                      ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (inner != NULL, NULL);
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_member_access_set_pointer_member_access (self, TRUE);
	return self;
}

ValaMemberAccess*
vala_member_access_new_pointer (ValaExpression* inner,
                                const gchar* member_name,
                                ValaSourceReference* source_reference)
{
	return vala_member_access_construct_pointer (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

/**
 * Appends the specified type as generic type argument.
 *
 * @param arg a type reference
 */
void
vala_member_access_add_type_argument (ValaMemberAccess* self,
                                      ValaDataType* arg)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->type_argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}

/**
 * Returns the list of generic type arguments.
 *
 * @return type argument list
 */
ValaList*
vala_member_access_get_type_arguments (ValaMemberAccess* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_argument_list;
	result = _tmp0_;
	return result;
}

static void
vala_member_access_real_accept (ValaCodeNode* base,
                                ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_member_access (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_member_access_real_accept_children (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp4_;
		gint _type_arg_size = 0;
		ValaList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _type_arg_index = 0;
		_tmp4_ = self->priv->type_argument_list;
		_type_arg_list = _tmp4_;
		_tmp5_ = _type_arg_list;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_type_arg_size = _tmp7_;
		_type_arg_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			ValaDataType* type_arg = NULL;
			ValaList* _tmp10_;
			gpointer _tmp11_;
			ValaDataType* _tmp12_;
			_type_arg_index = _type_arg_index + 1;
			_tmp8_ = _type_arg_index;
			_tmp9_ = _type_arg_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _type_arg_list;
			_tmp11_ = vala_list_get (_tmp10_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp11_;
			_tmp12_ = type_arg;
			vala_code_node_accept ((ValaCodeNode*) _tmp12_, visitor);
			_vala_code_node_unref0 (type_arg);
		}
	}
}

static gchar*
vala_member_access_real_to_string (ValaCodeNode* base)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	gchar* result = NULL;
	self = (ValaMemberAccess*) base;
	_tmp1_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_symbol_is_instance_member (_tmp4_);
	}
	if (_tmp0_) {
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		_tmp5_ = vala_member_access_get_inner (self);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == NULL) {
			const gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp7_ = self->priv->_member_name;
			_tmp8_ = g_strdup (_tmp7_);
			result = _tmp8_;
			return result;
		} else {
			const gchar* _tmp9_ = NULL;
			gboolean _tmp10_;
			ValaExpression* _tmp11_;
			ValaExpression* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp10_ = self->priv->_pointer_member_access;
			if (_tmp10_) {
				_tmp9_ = "->";
			} else {
				_tmp9_ = ".";
			}
			_tmp11_ = vala_member_access_get_inner (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_code_node_to_string ((ValaCodeNode*) _tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = self->priv->_member_name;
			_tmp16_ = g_strdup_printf ("%s%s%s", _tmp14_, _tmp9_, _tmp15_);
			_tmp17_ = _tmp16_;
			_g_free0 (_tmp14_);
			result = _tmp17_;
			return result;
		}
	} else {
		ValaSymbol* _tmp18_;
		ValaSymbol* _tmp19_;
		gchar* _tmp20_;
		_tmp18_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_symbol_get_full_name (_tmp19_);
		result = _tmp20_;
		return result;
	}
}

static void
vala_member_access_real_replace_expression (ValaCodeNode* base,
                                            ValaExpression* old_node,
                                            ValaExpression* new_node)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_member_access_set_inner (self, new_node);
	}
}

static gboolean
vala_member_access_real_is_pure (ValaExpression* base)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_pure (_tmp5_);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = !VALA_IS_PROPERTY (_tmp7_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_member_access_real_is_accessible (ValaExpression* base,
                                       ValaSymbol* sym)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_accessible (_tmp5_, sym);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = vala_symbol_is_accessible (_tmp7_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
vala_member_access_real_replace_type (ValaCodeNode* base,
                                      ValaDataType* old_type,
                                      ValaDataType* new_type)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaDataType* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->type_argument_list;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->type_argument_list;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaDataType*) _tmp6_;
				_tmp8_ = _tmp7_ == old_type;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->type_argument_list;
					vala_list_set (_tmp9_, i, new_type);
					return;
				}
			}
		}
	}
}

static gboolean
vala_member_access_real_is_constant (ValaExpression* base)
{
	ValaMemberAccess * self;
	ValaMethod* method = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	method = VALA_IS_METHOD (_tmp1_) ? ((ValaMethod*) _tmp1_) : NULL;
	_tmp2_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp3_ = _tmp2_;
	if (VALA_IS_CONSTANT (_tmp3_)) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		if (VALA_IS_ARRAY_LENGTH_FIELD (_tmp7_)) {
			ValaExpression* _tmp8_;
			ValaExpression* _tmp9_;
			_tmp8_ = vala_member_access_get_inner (self);
			_tmp9_ = _tmp8_;
			_tmp5_ = _tmp9_ != NULL;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			ValaExpression* _tmp10_;
			ValaExpression* _tmp11_;
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			_tmp10_ = vala_member_access_get_inner (self);
			_tmp11_ = _tmp10_;
			_tmp12_ = vala_expression_get_symbol_reference (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp4_ = VALA_IS_CONSTANT (_tmp13_);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp14_ = FALSE;
			ValaMethod* _tmp15_;
			_tmp15_ = method;
			if (_tmp15_ != NULL) {
				gboolean _tmp16_ = FALSE;
				ValaMethod* _tmp17_;
				ValaMemberBinding _tmp18_;
				ValaMemberBinding _tmp19_;
				_tmp17_ = method;
				_tmp18_ = vala_method_get_binding (_tmp17_);
				_tmp19_ = _tmp18_;
				if (_tmp19_ == VALA_MEMBER_BINDING_STATIC) {
					_tmp16_ = TRUE;
				} else {
					gboolean _tmp20_;
					_tmp20_ = self->priv->_prototype_access;
					_tmp16_ = _tmp20_;
				}
				_tmp14_ = _tmp16_;
			} else {
				_tmp14_ = FALSE;
			}
			if (_tmp14_) {
				result = TRUE;
				return result;
			} else {
				result = FALSE;
				return result;
			}
		}
	}
}

static gboolean
vala_member_access_real_is_non_null (ValaExpression* base)
{
	ValaMemberAccess * self;
	ValaConstant* c = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaConstant* _tmp2_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	c = VALA_IS_CONSTANT (_tmp1_) ? ((ValaConstant*) _tmp1_) : NULL;
	_tmp2_ = c;
	if (_tmp2_ != NULL) {
		gboolean _tmp3_ = FALSE;
		ValaConstant* _tmp4_;
		_tmp4_ = c;
		if (VALA_IS_ENUM_VALUE (_tmp4_)) {
			_tmp3_ = TRUE;
		} else {
			ValaConstant* _tmp5_;
			ValaDataType* _tmp6_;
			ValaDataType* _tmp7_;
			gboolean _tmp8_;
			gboolean _tmp9_;
			_tmp5_ = c;
			_tmp6_ = vala_constant_get_type_reference (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = vala_data_type_get_nullable (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp3_ = !_tmp9_;
		}
		result = _tmp3_;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

static void
vala_member_access_real_get_error_types (ValaCodeNode* base,
                                         ValaCollection* collection,
                                         ValaSourceReference* source_reference)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp3_, collection, source_reference);
	}
}

static gboolean
vala_member_access_real_check (ValaCodeNode* base,
                               ValaCodeContext* context)
{
	ValaMemberAccess * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_;
	ValaExpression* _tmp7_;
	ValaExpression* _tmp8_;
	ValaSymbol* base_symbol = NULL;
	ValaParameter* this_parameter = NULL;
	gboolean may_access_instance_members = FALSE;
	gboolean may_access_klass_members = FALSE;
	ValaArrayList* visited_types = NULL;
	GEqualFunc _tmp20_;
	ValaArrayList* _tmp21_;
	gboolean _tmp22_;
	gboolean _tmp665_ = FALSE;
	gboolean _tmp666_ = FALSE;
	gboolean _tmp667_ = FALSE;
	ValaExpression* _tmp668_;
	ValaExpression* _tmp669_;
	ValaSymbol* _tmp696_;
	ValaSymbol* _tmp697_;
	ValaSymbol* _tmp766_;
	ValaSymbol* _tmp767_;
	ValaSymbol* member = NULL;
	ValaSymbol* _tmp803_;
	ValaSymbol* _tmp804_;
	ValaSymbolAccessibility access = 0;
	gboolean instance = FALSE;
	gboolean klass = FALSE;
	gboolean generics = FALSE;
	ValaSymbol* _tmp805_;
	ValaSymbol* _tmp806_;
	ValaCodeNode* parent = NULL;
	ValaCodeNode* _tmp1254_;
	ValaSymbol* _tmp1255_;
	ValaSymbol* _tmp1257_;
	ValaVersionAttribute* _tmp1258_;
	ValaVersionAttribute* _tmp1259_;
	ValaSourceReference* _tmp1260_;
	ValaSourceReference* _tmp1261_;
	gboolean _tmp1262_ = FALSE;
	ValaSymbolAccessibility _tmp1263_;
	gboolean _tmp1315_ = FALSE;
	gboolean _tmp1342_ = FALSE;
	gboolean _tmp1343_ = FALSE;
	ValaDataType* _tmp1644_;
	ValaDataType* _tmp1645_;
	gboolean _tmp1648_;
	gboolean _tmp1649_;
	gboolean _tmp1650_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = self->priv->_null_safe_access;
	if (_tmp4_) {
		gboolean _tmp5_;
		gboolean _tmp6_;
		vala_code_node_set_error ((ValaCodeNode*) self, !VALA_CODE_NODE_CLASS (vala_member_access_parent_class)->check ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression), context));
		_tmp5_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp6_ = _tmp5_;
		result = !_tmp6_;
		return result;
	}
	_tmp7_ = vala_member_access_get_inner (self);
	_tmp8_ = _tmp7_;
	if (_tmp8_ != NULL) {
		ValaExpression* _tmp9_;
		ValaExpression* _tmp10_;
		_tmp9_ = vala_member_access_get_inner (self);
		_tmp10_ = _tmp9_;
		vala_code_node_check ((ValaCodeNode*) _tmp10_, context);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp11_;
		gint _type_arg_size = 0;
		ValaList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _type_arg_index = 0;
		_tmp11_ = self->priv->type_argument_list;
		_type_arg_list = _tmp11_;
		_tmp12_ = _type_arg_list;
		_tmp13_ = vala_collection_get_size ((ValaCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		_type_arg_size = _tmp14_;
		_type_arg_index = -1;
		while (TRUE) {
			gint _tmp15_;
			gint _tmp16_;
			ValaDataType* type_arg = NULL;
			ValaList* _tmp17_;
			gpointer _tmp18_;
			ValaDataType* _tmp19_;
			_type_arg_index = _type_arg_index + 1;
			_tmp15_ = _type_arg_index;
			_tmp16_ = _type_arg_size;
			if (!(_tmp15_ < _tmp16_)) {
				break;
			}
			_tmp17_ = _type_arg_list;
			_tmp18_ = vala_list_get (_tmp17_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp18_;
			_tmp19_ = type_arg;
			vala_code_node_check ((ValaCodeNode*) _tmp19_, context);
			_vala_code_node_unref0 (type_arg);
		}
	}
	base_symbol = NULL;
	this_parameter = NULL;
	may_access_instance_members = FALSE;
	may_access_klass_members = FALSE;
	_tmp20_ = g_direct_equal;
	_tmp21_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp20_);
	visited_types = _tmp21_;
	vala_expression_set_symbol_reference ((ValaExpression*) self, NULL);
	_tmp22_ = self->priv->_qualified;
	if (_tmp22_) {
		ValaNamespace* _tmp23_;
		ValaNamespace* _tmp24_;
		ValaSymbol* _tmp25_;
		ValaScope* _tmp26_;
		ValaScope* _tmp27_;
		const gchar* _tmp28_;
		ValaSymbol* _tmp29_;
		ValaSymbol* _tmp30_;
		_tmp23_ = vala_code_context_get_root (context);
		_tmp24_ = _tmp23_;
		base_symbol = (ValaSymbol*) _tmp24_;
		_tmp25_ = base_symbol;
		_tmp26_ = vala_symbol_get_scope (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = self->priv->_member_name;
		_tmp29_ = vala_scope_lookup (_tmp27_, _tmp28_);
		_tmp30_ = _tmp29_;
		vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp30_);
		_vala_code_node_unref0 (_tmp30_);
	} else {
		ValaExpression* _tmp31_;
		ValaExpression* _tmp32_;
		_tmp31_ = vala_member_access_get_inner (self);
		_tmp32_ = _tmp31_;
		if (_tmp32_ == NULL) {
			const gchar* _tmp33_;
			ValaSemanticAnalyzer* _tmp38_;
			ValaSemanticAnalyzer* _tmp39_;
			ValaSymbol* _tmp40_;
			ValaSymbol* _tmp41_;
			gboolean method_found = FALSE;
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp42_;
			ValaSemanticAnalyzer* _tmp43_;
			ValaSymbol* _tmp44_;
			ValaSymbol* _tmp45_;
			gboolean _tmp182_ = FALSE;
			ValaSymbol* _tmp183_;
			ValaSymbol* _tmp184_;
			_tmp33_ = self->priv->_member_name;
			if (g_strcmp0 (_tmp33_, "this") == 0) {
				ValaSemanticAnalyzer* _tmp34_;
				ValaSemanticAnalyzer* _tmp35_;
				_tmp34_ = vala_code_context_get_analyzer (context);
				_tmp35_ = _tmp34_;
				if (!vala_semantic_analyzer_is_in_instance_method (_tmp35_)) {
					ValaSourceReference* _tmp36_;
					ValaSourceReference* _tmp37_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp36_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp37_ = _tmp36_;
					vala_report_error (_tmp37_, "This access invalid outside of instance methods");
					result = FALSE;
					_vala_iterable_unref0 (visited_types);
					return result;
				}
			}
			_tmp38_ = vala_code_context_get_analyzer (context);
			_tmp39_ = _tmp38_;
			_tmp40_ = vala_semantic_analyzer_get_current_symbol (_tmp39_);
			_tmp41_ = _tmp40_;
			base_symbol = _tmp41_;
			method_found = FALSE;
			_tmp42_ = vala_code_context_get_analyzer (context);
			_tmp43_ = _tmp42_;
			_tmp44_ = vala_semantic_analyzer_get_current_symbol (_tmp43_);
			_tmp45_ = _tmp44_;
			sym = _tmp45_;
			while (TRUE) {
				gboolean _tmp46_ = FALSE;
				ValaSymbol* _tmp47_;
				ValaSymbol* _tmp93_;
				const gchar* _tmp94_;
				ValaSymbol* _tmp95_;
				ValaSymbol* _tmp96_;
				gboolean _tmp97_ = FALSE;
				gboolean _tmp98_ = FALSE;
				gboolean _tmp135_ = FALSE;
				gboolean _tmp136_ = FALSE;
				ValaSymbol* _tmp137_;
				ValaSymbol* _tmp138_;
				ValaSymbol* _tmp176_;
				ValaSymbol* _tmp177_;
				ValaSymbol* _tmp179_;
				ValaSymbol* _tmp180_;
				ValaSymbol* _tmp181_;
				_tmp47_ = sym;
				if (_tmp47_ != NULL) {
					ValaSymbol* _tmp48_;
					ValaSymbol* _tmp49_;
					_tmp48_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp49_ = _tmp48_;
					_tmp46_ = _tmp49_ == NULL;
				} else {
					_tmp46_ = FALSE;
				}
				if (!_tmp46_) {
					break;
				}
				if (!method_found) {
					ValaSymbol* _tmp50_;
					_tmp50_ = sym;
					if (VALA_IS_CREATION_METHOD (_tmp50_)) {
						ValaCreationMethod* cm = NULL;
						ValaSymbol* _tmp51_;
						ValaCreationMethod* _tmp52_;
						ValaParameter* _tmp53_;
						ValaParameter* _tmp54_;
						_tmp51_ = sym;
						cm = G_TYPE_CHECK_INSTANCE_CAST (_tmp51_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod);
						_tmp52_ = cm;
						_tmp53_ = vala_method_get_this_parameter ((ValaMethod*) _tmp52_);
						_tmp54_ = _tmp53_;
						this_parameter = _tmp54_;
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
						method_found = TRUE;
					} else {
						ValaSymbol* _tmp55_;
						_tmp55_ = sym;
						if (VALA_IS_PROPERTY (_tmp55_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp56_;
							ValaProperty* _tmp57_;
							ValaParameter* _tmp58_;
							ValaParameter* _tmp59_;
							ValaProperty* _tmp60_;
							ValaMemberBinding _tmp61_;
							ValaMemberBinding _tmp62_;
							ValaProperty* _tmp63_;
							ValaMemberBinding _tmp64_;
							ValaMemberBinding _tmp65_;
							_tmp56_ = sym;
							prop = G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, VALA_TYPE_PROPERTY, ValaProperty);
							_tmp57_ = prop;
							_tmp58_ = vala_property_get_this_parameter (_tmp57_);
							_tmp59_ = _tmp58_;
							this_parameter = _tmp59_;
							_tmp60_ = prop;
							_tmp61_ = vala_property_get_binding (_tmp60_);
							_tmp62_ = _tmp61_;
							may_access_instance_members = _tmp62_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp63_ = prop;
							_tmp64_ = vala_property_get_binding (_tmp63_);
							_tmp65_ = _tmp64_;
							may_access_klass_members = _tmp65_ != VALA_MEMBER_BINDING_STATIC;
							method_found = TRUE;
						} else {
							ValaSymbol* _tmp66_;
							_tmp66_ = sym;
							if (VALA_IS_CONSTRUCTOR (_tmp66_)) {
								ValaConstructor* c = NULL;
								ValaSymbol* _tmp67_;
								ValaConstructor* _tmp68_;
								ValaParameter* _tmp69_;
								ValaParameter* _tmp70_;
								ValaConstructor* _tmp71_;
								ValaMemberBinding _tmp72_;
								ValaMemberBinding _tmp73_;
								_tmp67_ = sym;
								c = G_TYPE_CHECK_INSTANCE_CAST (_tmp67_, VALA_TYPE_CONSTRUCTOR, ValaConstructor);
								_tmp68_ = c;
								_tmp69_ = vala_constructor_get_this_parameter (_tmp68_);
								_tmp70_ = _tmp69_;
								this_parameter = _tmp70_;
								_tmp71_ = c;
								_tmp72_ = vala_constructor_get_binding (_tmp71_);
								_tmp73_ = _tmp72_;
								may_access_instance_members = _tmp73_ == VALA_MEMBER_BINDING_INSTANCE;
								may_access_klass_members = TRUE;
								method_found = TRUE;
							} else {
								ValaSymbol* _tmp74_;
								_tmp74_ = sym;
								if (VALA_IS_DESTRUCTOR (_tmp74_)) {
									ValaDestructor* d = NULL;
									ValaSymbol* _tmp75_;
									ValaDestructor* _tmp76_;
									ValaParameter* _tmp77_;
									ValaParameter* _tmp78_;
									ValaDestructor* _tmp79_;
									ValaMemberBinding _tmp80_;
									ValaMemberBinding _tmp81_;
									_tmp75_ = sym;
									d = G_TYPE_CHECK_INSTANCE_CAST (_tmp75_, VALA_TYPE_DESTRUCTOR, ValaDestructor);
									_tmp76_ = d;
									_tmp77_ = vala_destructor_get_this_parameter (_tmp76_);
									_tmp78_ = _tmp77_;
									this_parameter = _tmp78_;
									_tmp79_ = d;
									_tmp80_ = vala_destructor_get_binding (_tmp79_);
									_tmp81_ = _tmp80_;
									may_access_instance_members = _tmp81_ == VALA_MEMBER_BINDING_INSTANCE;
									may_access_klass_members = TRUE;
									method_found = TRUE;
								} else {
									ValaSymbol* _tmp82_;
									_tmp82_ = sym;
									if (VALA_IS_METHOD (_tmp82_)) {
										ValaMethod* m = NULL;
										ValaSymbol* _tmp83_;
										ValaMethod* _tmp84_;
										ValaParameter* _tmp85_;
										ValaParameter* _tmp86_;
										ValaMethod* _tmp87_;
										ValaMemberBinding _tmp88_;
										ValaMemberBinding _tmp89_;
										ValaMethod* _tmp90_;
										ValaMemberBinding _tmp91_;
										ValaMemberBinding _tmp92_;
										_tmp83_ = sym;
										m = G_TYPE_CHECK_INSTANCE_CAST (_tmp83_, VALA_TYPE_METHOD, ValaMethod);
										_tmp84_ = m;
										_tmp85_ = vala_method_get_this_parameter (_tmp84_);
										_tmp86_ = _tmp85_;
										this_parameter = _tmp86_;
										_tmp87_ = m;
										_tmp88_ = vala_method_get_binding (_tmp87_);
										_tmp89_ = _tmp88_;
										may_access_instance_members = _tmp89_ == VALA_MEMBER_BINDING_INSTANCE;
										_tmp90_ = m;
										_tmp91_ = vala_method_get_binding (_tmp90_);
										_tmp92_ = _tmp91_;
										may_access_klass_members = _tmp92_ != VALA_MEMBER_BINDING_STATIC;
										method_found = TRUE;
									}
								}
							}
						}
					}
				}
				_tmp93_ = sym;
				_tmp94_ = self->priv->_member_name;
				_tmp95_ = vala_semantic_analyzer_symbol_lookup_inherited (_tmp93_, _tmp94_);
				_tmp96_ = _tmp95_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp96_);
				_vala_code_node_unref0 (_tmp96_);
				if (!self->priv->is_with_variable_access) {
					ValaSymbol* _tmp99_;
					ValaSymbol* _tmp100_;
					_tmp99_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp100_ = _tmp99_;
					_tmp98_ = _tmp100_ == NULL;
				} else {
					_tmp98_ = FALSE;
				}
				if (_tmp98_) {
					ValaSymbol* _tmp101_;
					_tmp101_ = sym;
					_tmp97_ = VALA_IS_WITH_STATEMENT (_tmp101_);
				} else {
					_tmp97_ = FALSE;
				}
				if (_tmp97_) {
					ValaWithStatement* w = NULL;
					ValaSymbol* _tmp102_;
					ValaDataType* variable_type = NULL;
					ValaWithStatement* _tmp103_;
					ValaLocalVariable* _tmp104_;
					ValaLocalVariable* _tmp105_;
					ValaDataType* _tmp106_;
					ValaDataType* _tmp107_;
					ValaDataType* _tmp108_;
					ValaDataType* _tmp109_;
					ValaArrayList* _tmp114_;
					ValaDataType* _tmp115_;
					ValaDataType* _tmp116_;
					const gchar* _tmp117_;
					ValaSymbol* _tmp118_;
					ValaSymbol* _tmp119_;
					ValaSymbol* _tmp120_;
					ValaSymbol* _tmp121_;
					_tmp102_ = sym;
					w = G_TYPE_CHECK_INSTANCE_CAST (_tmp102_, VALA_TYPE_WITH_STATEMENT, ValaWithStatement);
					_tmp103_ = w;
					_tmp104_ = vala_with_statement_get_with_variable (_tmp103_);
					_tmp105_ = _tmp104_;
					_tmp106_ = vala_variable_get_variable_type ((ValaVariable*) _tmp105_);
					_tmp107_ = _tmp106_;
					_tmp108_ = _vala_code_node_ref0 (_tmp107_);
					variable_type = _tmp108_;
					_tmp109_ = variable_type;
					if (VALA_IS_POINTER_TYPE (_tmp109_)) {
						ValaDataType* _tmp110_;
						ValaDataType* _tmp111_;
						ValaDataType* _tmp112_;
						ValaDataType* _tmp113_;
						_tmp110_ = variable_type;
						_tmp111_ = vala_pointer_type_get_base_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp110_, VALA_TYPE_POINTER_TYPE, ValaPointerType));
						_tmp112_ = _tmp111_;
						_tmp113_ = _vala_code_node_ref0 (_tmp112_);
						_vala_code_node_unref0 (variable_type);
						variable_type = _tmp113_;
					}
					_tmp114_ = visited_types;
					_tmp115_ = variable_type;
					vala_collection_add ((ValaCollection*) _tmp114_, _tmp115_);
					_tmp116_ = variable_type;
					_tmp117_ = self->priv->_member_name;
					_tmp118_ = vala_data_type_get_member (_tmp116_, _tmp117_);
					_tmp119_ = _tmp118_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp119_);
					_vala_code_node_unref0 (_tmp119_);
					_tmp120_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp121_ = _tmp120_;
					if (_tmp121_ != NULL) {
						ValaWithStatement* _tmp122_;
						ValaLocalVariable* _tmp123_;
						ValaLocalVariable* _tmp124_;
						const gchar* _tmp125_;
						const gchar* _tmp126_;
						ValaSourceReference* _tmp127_;
						ValaSourceReference* _tmp128_;
						ValaMemberAccess* _tmp129_;
						ValaMemberAccess* _tmp130_;
						ValaExpression* _tmp131_;
						ValaExpression* _tmp132_;
						ValaExpression* _tmp133_;
						ValaExpression* _tmp134_;
						_tmp122_ = w;
						_tmp123_ = vala_with_statement_get_with_variable (_tmp122_);
						_tmp124_ = _tmp123_;
						_tmp125_ = vala_symbol_get_name ((ValaSymbol*) _tmp124_);
						_tmp126_ = _tmp125_;
						_tmp127_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp128_ = _tmp127_;
						_tmp129_ = vala_member_access_new (NULL, _tmp126_, _tmp128_);
						_tmp130_ = _tmp129_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp130_);
						_vala_code_node_unref0 (_tmp130_);
						_tmp131_ = vala_member_access_get_inner (self);
						_tmp132_ = _tmp131_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp132_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess)->priv->is_with_variable_access = TRUE;
						_tmp133_ = vala_member_access_get_inner (self);
						_tmp134_ = _tmp133_;
						vala_code_node_check ((ValaCodeNode*) _tmp134_, context);
						may_access_instance_members = TRUE;
					}
					_vala_code_node_unref0 (variable_type);
				}
				_tmp137_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp138_ = _tmp137_;
				if (_tmp138_ == NULL) {
					ValaSymbol* _tmp139_;
					_tmp139_ = sym;
					_tmp136_ = VALA_IS_TYPESYMBOL (_tmp139_);
				} else {
					_tmp136_ = FALSE;
				}
				if (_tmp136_) {
					_tmp135_ = may_access_instance_members;
				} else {
					_tmp135_ = FALSE;
				}
				if (_tmp135_) {
					ValaParameter* _tmp140_;
					ValaDataType* _tmp141_;
					ValaDataType* _tmp142_;
					const gchar* _tmp143_;
					ValaSymbol* _tmp144_;
					ValaSymbol* _tmp145_;
					gboolean _tmp146_ = FALSE;
					ValaSymbol* _tmp147_;
					ValaSymbol* _tmp148_;
					_tmp140_ = this_parameter;
					_tmp141_ = vala_variable_get_variable_type ((ValaVariable*) _tmp140_);
					_tmp142_ = _tmp141_;
					_tmp143_ = self->priv->_member_name;
					_tmp144_ = vala_data_type_get_member (_tmp142_, _tmp143_);
					_tmp145_ = _tmp144_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp145_);
					_vala_code_node_unref0 (_tmp145_);
					_tmp147_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp148_ = _tmp147_;
					if (_tmp148_ != NULL) {
						ValaSymbol* _tmp149_;
						ValaSymbol* _tmp150_;
						_tmp149_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
						_tmp150_ = _tmp149_;
						_tmp146_ = vala_member_access_is_instance_symbol (_tmp150_);
					} else {
						_tmp146_ = FALSE;
					}
					if (_tmp146_) {
						ValaSourceReference* _tmp151_;
						ValaSourceReference* _tmp152_;
						ValaMemberAccess* _tmp153_;
						ValaMemberAccess* _tmp154_;
						ValaExpression* _tmp155_;
						ValaExpression* _tmp156_;
						ValaParameter* _tmp157_;
						ValaDataType* _tmp158_;
						ValaDataType* _tmp159_;
						ValaDataType* _tmp160_;
						ValaDataType* _tmp161_;
						ValaExpression* _tmp162_;
						ValaExpression* _tmp163_;
						ValaDataType* _tmp164_;
						ValaDataType* _tmp165_;
						ValaExpression* _tmp166_;
						ValaExpression* _tmp167_;
						ValaParameter* _tmp168_;
						ValaExpression* _tmp169_;
						ValaExpression* _tmp170_;
						ValaDataType* _tmp171_;
						ValaDataType* _tmp172_;
						const gchar* _tmp173_;
						ValaSymbol* _tmp174_;
						ValaSymbol* _tmp175_;
						_tmp151_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp152_ = _tmp151_;
						_tmp153_ = vala_member_access_new (NULL, "this", _tmp152_);
						_tmp154_ = _tmp153_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp154_);
						_vala_code_node_unref0 (_tmp154_);
						_tmp155_ = vala_member_access_get_inner (self);
						_tmp156_ = _tmp155_;
						_tmp157_ = this_parameter;
						_tmp158_ = vala_variable_get_variable_type ((ValaVariable*) _tmp157_);
						_tmp159_ = _tmp158_;
						_tmp160_ = vala_data_type_copy (_tmp159_);
						_tmp161_ = _tmp160_;
						vala_expression_set_value_type (_tmp156_, _tmp161_);
						_vala_code_node_unref0 (_tmp161_);
						_tmp162_ = vala_member_access_get_inner (self);
						_tmp163_ = _tmp162_;
						_tmp164_ = vala_expression_get_value_type (_tmp163_);
						_tmp165_ = _tmp164_;
						vala_data_type_set_value_owned (_tmp165_, FALSE);
						_tmp166_ = vala_member_access_get_inner (self);
						_tmp167_ = _tmp166_;
						_tmp168_ = this_parameter;
						vala_expression_set_symbol_reference (_tmp167_, (ValaSymbol*) _tmp168_);
						_tmp169_ = vala_member_access_get_inner (self);
						_tmp170_ = _tmp169_;
						_tmp171_ = vala_expression_get_value_type (_tmp170_);
						_tmp172_ = _tmp171_;
						_tmp173_ = self->priv->_member_name;
						_tmp174_ = vala_data_type_get_member (_tmp172_, _tmp173_);
						_tmp175_ = _tmp174_;
						vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp175_);
						_vala_code_node_unref0 (_tmp175_);
					}
				}
				_tmp176_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp177_ = _tmp176_;
				if (_tmp177_ == NULL) {
					ValaSymbol* _tmp178_;
					_tmp178_ = sym;
					if (VALA_IS_TYPESYMBOL (_tmp178_)) {
						this_parameter = NULL;
						may_access_instance_members = FALSE;
						may_access_klass_members = FALSE;
					}
				}
				_tmp179_ = sym;
				_tmp180_ = vala_symbol_get_parent_symbol (_tmp179_);
				_tmp181_ = _tmp180_;
				sym = _tmp181_;
			}
			_tmp183_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp184_ = _tmp183_;
			if (_tmp184_ == NULL) {
				ValaSourceReference* _tmp185_;
				ValaSourceReference* _tmp186_;
				_tmp185_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp186_ = _tmp185_;
				_tmp182_ = _tmp186_ != NULL;
			} else {
				_tmp182_ = FALSE;
			}
			if (_tmp182_) {
				{
					ValaList* _ns_list = NULL;
					ValaSourceReference* _tmp187_;
					ValaSourceReference* _tmp188_;
					ValaList* _tmp189_;
					ValaList* _tmp190_;
					gint _ns_size = 0;
					ValaList* _tmp191_;
					gint _tmp192_;
					gint _tmp193_;
					gint _ns_index = 0;
					_tmp187_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp188_ = _tmp187_;
					_tmp189_ = vala_source_reference_get_using_directives (_tmp188_);
					_tmp190_ = _tmp189_;
					_ns_list = _tmp190_;
					_tmp191_ = _ns_list;
					_tmp192_ = vala_collection_get_size ((ValaCollection*) _tmp191_);
					_tmp193_ = _tmp192_;
					_ns_size = _tmp193_;
					_ns_index = -1;
					while (TRUE) {
						gint _tmp194_;
						gint _tmp195_;
						ValaUsingDirective* ns = NULL;
						ValaList* _tmp196_;
						gpointer _tmp197_;
						ValaUsingDirective* _tmp198_;
						gboolean _tmp199_;
						gboolean _tmp200_;
						ValaSymbol* local_sym = NULL;
						ValaUsingDirective* _tmp201_;
						ValaSymbol* _tmp202_;
						ValaSymbol* _tmp203_;
						ValaScope* _tmp204_;
						ValaScope* _tmp205_;
						const gchar* _tmp206_;
						ValaSymbol* _tmp207_;
						ValaSymbol* _tmp208_;
						_ns_index = _ns_index + 1;
						_tmp194_ = _ns_index;
						_tmp195_ = _ns_size;
						if (!(_tmp194_ < _tmp195_)) {
							break;
						}
						_tmp196_ = _ns_list;
						_tmp197_ = vala_list_get (_tmp196_, _ns_index);
						ns = (ValaUsingDirective*) _tmp197_;
						_tmp198_ = ns;
						_tmp199_ = vala_code_node_get_error ((ValaCodeNode*) _tmp198_);
						_tmp200_ = _tmp199_;
						if (_tmp200_) {
							_vala_code_node_unref0 (ns);
							continue;
						}
						_tmp201_ = ns;
						_tmp202_ = vala_using_directive_get_namespace_symbol (_tmp201_);
						_tmp203_ = _tmp202_;
						_tmp204_ = vala_symbol_get_scope (_tmp203_);
						_tmp205_ = _tmp204_;
						_tmp206_ = self->priv->_member_name;
						_tmp207_ = vala_scope_lookup (_tmp205_, _tmp206_);
						local_sym = _tmp207_;
						_tmp208_ = local_sym;
						if (_tmp208_ != NULL) {
							gboolean _tmp209_ = FALSE;
							ValaSymbol* _tmp210_;
							ValaSymbol* _tmp211_;
							ValaSymbol* inner_sym = NULL;
							ValaSymbol* _tmp225_;
							ValaSymbol* _tmp226_;
							ValaSymbol* _tmp227_;
							ValaMemberAccess* inner_ma = NULL;
							ValaMemberAccess* _tmp247_;
							ValaExpression* _tmp248_;
							ValaExpression* _tmp249_;
							ValaSymbol* _tmp250_;
							_tmp210_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp211_ = _tmp210_;
							if (_tmp211_ != NULL) {
								ValaSymbol* _tmp212_;
								ValaSymbol* _tmp213_;
								ValaSymbol* _tmp214_;
								_tmp212_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp213_ = _tmp212_;
								_tmp214_ = local_sym;
								_tmp209_ = _tmp213_ != _tmp214_;
							} else {
								_tmp209_ = FALSE;
							}
							if (_tmp209_) {
								ValaSourceReference* _tmp215_;
								ValaSourceReference* _tmp216_;
								const gchar* _tmp217_;
								ValaSymbol* _tmp218_;
								ValaSymbol* _tmp219_;
								gchar* _tmp220_;
								gchar* _tmp221_;
								ValaSymbol* _tmp222_;
								gchar* _tmp223_;
								gchar* _tmp224_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp215_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp216_ = _tmp215_;
								_tmp217_ = self->priv->_member_name;
								_tmp218_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp219_ = _tmp218_;
								_tmp220_ = vala_symbol_get_full_name (_tmp219_);
								_tmp221_ = _tmp220_;
								_tmp222_ = local_sym;
								_tmp223_ = vala_symbol_get_full_name (_tmp222_);
								_tmp224_ = _tmp223_;
								vala_report_error (_tmp216_, "`%s' is an ambiguous reference between `%s' and `%s'", _tmp217_, _tmp221_, _tmp224_);
								_g_free0 (_tmp224_);
								_g_free0 (_tmp221_);
								result = FALSE;
								_vala_code_node_unref0 (local_sym);
								_vala_code_node_unref0 (ns);
								_vala_iterable_unref0 (visited_types);
								return result;
							}
							_tmp225_ = local_sym;
							_tmp226_ = vala_symbol_get_parent_symbol (_tmp225_);
							_tmp227_ = _tmp226_;
							inner_sym = _tmp227_;
							inner_ma = self;
							while (TRUE) {
								gboolean _tmp228_ = FALSE;
								ValaSymbol* _tmp229_;
								ValaMemberAccess* _tmp233_;
								ValaSymbol* _tmp234_;
								const gchar* _tmp235_;
								const gchar* _tmp236_;
								ValaSourceReference* _tmp237_;
								ValaSourceReference* _tmp238_;
								ValaMemberAccess* _tmp239_;
								ValaMemberAccess* _tmp240_;
								ValaMemberAccess* _tmp241_;
								ValaExpression* _tmp242_;
								ValaExpression* _tmp243_;
								ValaSymbol* _tmp244_;
								ValaSymbol* _tmp245_;
								ValaSymbol* _tmp246_;
								_tmp229_ = inner_sym;
								if (_tmp229_ != NULL) {
									ValaSymbol* _tmp230_;
									const gchar* _tmp231_;
									const gchar* _tmp232_;
									_tmp230_ = inner_sym;
									_tmp231_ = vala_symbol_get_name (_tmp230_);
									_tmp232_ = _tmp231_;
									_tmp228_ = _tmp232_ != NULL;
								} else {
									_tmp228_ = FALSE;
								}
								if (!_tmp228_) {
									break;
								}
								_tmp233_ = inner_ma;
								_tmp234_ = inner_sym;
								_tmp235_ = vala_symbol_get_name (_tmp234_);
								_tmp236_ = _tmp235_;
								_tmp237_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp238_ = _tmp237_;
								_tmp239_ = vala_member_access_new (NULL, _tmp236_, _tmp238_);
								_tmp240_ = _tmp239_;
								vala_member_access_set_inner (_tmp233_, (ValaExpression*) _tmp240_);
								_vala_code_node_unref0 (_tmp240_);
								_tmp241_ = inner_ma;
								_tmp242_ = vala_member_access_get_inner (_tmp241_);
								_tmp243_ = _tmp242_;
								inner_ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp243_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
								_tmp244_ = inner_sym;
								_tmp245_ = vala_symbol_get_parent_symbol (_tmp244_);
								_tmp246_ = _tmp245_;
								inner_sym = _tmp246_;
							}
							_tmp247_ = inner_ma;
							vala_member_access_set_qualified (_tmp247_, TRUE);
							_tmp248_ = vala_member_access_get_inner (self);
							_tmp249_ = _tmp248_;
							vala_code_node_check ((ValaCodeNode*) _tmp249_, context);
							_tmp250_ = local_sym;
							vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp250_);
						}
						_vala_code_node_unref0 (local_sym);
						_vala_code_node_unref0 (ns);
					}
				}
			}
		} else {
			ValaExpression* _tmp251_;
			ValaExpression* _tmp252_;
			gboolean _tmp253_;
			gboolean _tmp254_;
			ValaExpression* _tmp255_;
			ValaExpression* _tmp256_;
			ValaDataType* _tmp257_;
			ValaDataType* _tmp258_;
			ValaExpression* _tmp289_;
			ValaExpression* _tmp290_;
			gboolean _tmp303_ = FALSE;
			ValaExpression* _tmp304_;
			ValaExpression* _tmp305_;
			gboolean _tmp312_ = FALSE;
			ValaExpression* _tmp313_;
			ValaExpression* _tmp314_;
			gboolean _tmp335_ = FALSE;
			ValaExpression* _tmp336_;
			ValaExpression* _tmp337_;
			gboolean _tmp356_ = FALSE;
			ValaSymbol* _tmp357_;
			ValaSymbol* _tmp358_;
			gboolean _tmp392_ = FALSE;
			gboolean _tmp393_ = FALSE;
			ValaSymbol* _tmp394_;
			ValaSymbol* _tmp395_;
			ValaSymbol* _tmp631_;
			ValaSymbol* _tmp632_;
			_tmp251_ = vala_member_access_get_inner (self);
			_tmp252_ = _tmp251_;
			_tmp253_ = vala_code_node_get_error ((ValaCodeNode*) _tmp252_);
			_tmp254_ = _tmp253_;
			if (_tmp254_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_iterable_unref0 (visited_types);
				return result;
			}
			_tmp255_ = vala_member_access_get_inner (self);
			_tmp256_ = _tmp255_;
			_tmp257_ = vala_expression_get_value_type (_tmp256_);
			_tmp258_ = _tmp257_;
			if (VALA_IS_POINTER_TYPE (_tmp258_)) {
				ValaPointerType* pointer_type = NULL;
				ValaExpression* _tmp259_;
				ValaExpression* _tmp260_;
				ValaDataType* _tmp261_;
				ValaDataType* _tmp262_;
				gboolean _tmp263_ = FALSE;
				ValaPointerType* _tmp264_;
				_tmp259_ = vala_member_access_get_inner (self);
				_tmp260_ = _tmp259_;
				_tmp261_ = vala_expression_get_value_type (_tmp260_);
				_tmp262_ = _tmp261_;
				pointer_type = VALA_IS_POINTER_TYPE (_tmp262_) ? ((ValaPointerType*) _tmp262_) : NULL;
				_tmp264_ = pointer_type;
				if (_tmp264_ != NULL) {
					ValaPointerType* _tmp265_;
					ValaDataType* _tmp266_;
					ValaDataType* _tmp267_;
					_tmp265_ = pointer_type;
					_tmp266_ = vala_pointer_type_get_base_type (_tmp265_);
					_tmp267_ = _tmp266_;
					_tmp263_ = VALA_IS_VALUE_TYPE (_tmp267_);
				} else {
					_tmp263_ = FALSE;
				}
				if (_tmp263_) {
					ValaExpression* _tmp268_;
					ValaExpression* _tmp269_;
					ValaDataType* _tmp270_;
					ValaDataType* _tmp271_;
					ValaExpression* _tmp281_;
					ValaExpression* _tmp282_;
					ValaSourceReference* _tmp283_;
					ValaSourceReference* _tmp284_;
					ValaPointerIndirection* _tmp285_;
					ValaPointerIndirection* _tmp286_;
					ValaExpression* _tmp287_;
					ValaExpression* _tmp288_;
					_tmp268_ = vala_member_access_get_inner (self);
					_tmp269_ = _tmp268_;
					_tmp270_ = vala_expression_get_formal_value_type (_tmp269_);
					_tmp271_ = _tmp270_;
					if (VALA_IS_GENERIC_TYPE (_tmp271_)) {
						ValaExpression* _tmp272_;
						ValaExpression* _tmp273_;
						ValaPointerType* _tmp274_;
						ValaDataType* _tmp275_;
						ValaDataType* _tmp276_;
						ValaSourceReference* _tmp277_;
						ValaSourceReference* _tmp278_;
						ValaCastExpression* _tmp279_;
						ValaCastExpression* _tmp280_;
						_tmp272_ = vala_member_access_get_inner (self);
						_tmp273_ = _tmp272_;
						_tmp274_ = pointer_type;
						_tmp275_ = vala_data_type_copy ((ValaDataType*) _tmp274_);
						_tmp276_ = _tmp275_;
						_tmp277_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp278_ = _tmp277_;
						_tmp279_ = vala_cast_expression_new (_tmp273_, _tmp276_, _tmp278_);
						_tmp280_ = _tmp279_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp280_);
						_vala_code_node_unref0 (_tmp280_);
						_vala_code_node_unref0 (_tmp276_);
					}
					_tmp281_ = vala_member_access_get_inner (self);
					_tmp282_ = _tmp281_;
					_tmp283_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp284_ = _tmp283_;
					_tmp285_ = vala_pointer_indirection_new (_tmp282_, _tmp284_);
					_tmp286_ = _tmp285_;
					vala_member_access_set_inner (self, (ValaExpression*) _tmp286_);
					_vala_code_node_unref0 (_tmp286_);
					_tmp287_ = vala_member_access_get_inner (self);
					_tmp288_ = _tmp287_;
					vala_code_node_check ((ValaCodeNode*) _tmp288_, context);
					vala_member_access_set_pointer_member_access (self, FALSE);
				}
			}
			_tmp289_ = vala_member_access_get_inner (self);
			_tmp290_ = _tmp289_;
			if (VALA_IS_MEMBER_ACCESS (_tmp290_)) {
				ValaMemberAccess* ma = NULL;
				ValaExpression* _tmp291_;
				ValaExpression* _tmp292_;
				ValaMemberAccess* _tmp293_;
				gboolean _tmp294_;
				_tmp291_ = vala_member_access_get_inner (self);
				_tmp292_ = _tmp291_;
				ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp292_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
				_tmp293_ = ma;
				_tmp294_ = _tmp293_->priv->_prototype_access;
				if (_tmp294_) {
					ValaSourceReference* _tmp295_;
					ValaSourceReference* _tmp296_;
					ValaExpression* _tmp297_;
					ValaExpression* _tmp298_;
					ValaSymbol* _tmp299_;
					ValaSymbol* _tmp300_;
					gchar* _tmp301_;
					gchar* _tmp302_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp295_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp296_ = _tmp295_;
					_tmp297_ = vala_member_access_get_inner (self);
					_tmp298_ = _tmp297_;
					_tmp299_ = vala_expression_get_symbol_reference (_tmp298_);
					_tmp300_ = _tmp299_;
					_tmp301_ = vala_symbol_get_full_name (_tmp300_);
					_tmp302_ = _tmp301_;
					vala_report_error (_tmp296_, "Access to instance member `%s' denied", _tmp302_);
					_g_free0 (_tmp302_);
					result = FALSE;
					_vala_iterable_unref0 (visited_types);
					return result;
				}
			}
			_tmp304_ = vala_member_access_get_inner (self);
			_tmp305_ = _tmp304_;
			if (VALA_IS_CAST_EXPRESSION (_tmp305_)) {
				ValaExpression* _tmp306_;
				ValaExpression* _tmp307_;
				gboolean _tmp308_;
				gboolean _tmp309_;
				_tmp306_ = vala_member_access_get_inner (self);
				_tmp307_ = _tmp306_;
				_tmp308_ = vala_cast_expression_get_is_silent_cast (G_TYPE_CHECK_INSTANCE_CAST (_tmp307_, VALA_TYPE_CAST_EXPRESSION, ValaCastExpression));
				_tmp309_ = _tmp308_;
				_tmp303_ = _tmp309_;
			} else {
				_tmp303_ = FALSE;
			}
			if (_tmp303_) {
				ValaSourceReference* _tmp310_;
				ValaSourceReference* _tmp311_;
				_tmp310_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp311_ = _tmp310_;
				vala_report_warning (_tmp311_, "Access to possible `null'. Perform a check or use an unsafe cast.");
			}
			_tmp313_ = vala_member_access_get_inner (self);
			_tmp314_ = _tmp313_;
			if (VALA_IS_MEMBER_ACCESS (_tmp314_)) {
				_tmp312_ = TRUE;
			} else {
				ValaExpression* _tmp315_;
				ValaExpression* _tmp316_;
				_tmp315_ = vala_member_access_get_inner (self);
				_tmp316_ = _tmp315_;
				_tmp312_ = VALA_IS_BASE_ACCESS (_tmp316_);
			}
			if (_tmp312_) {
				ValaExpression* _tmp317_;
				ValaExpression* _tmp318_;
				ValaSymbol* _tmp319_;
				ValaSymbol* _tmp320_;
				gboolean _tmp321_ = FALSE;
				ValaSymbol* _tmp322_;
				ValaSymbol* _tmp323_;
				_tmp317_ = vala_member_access_get_inner (self);
				_tmp318_ = _tmp317_;
				_tmp319_ = vala_expression_get_symbol_reference (_tmp318_);
				_tmp320_ = _tmp319_;
				base_symbol = _tmp320_;
				_tmp322_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp323_ = _tmp322_;
				if (_tmp323_ == NULL) {
					gboolean _tmp324_ = FALSE;
					ValaSymbol* _tmp325_;
					_tmp325_ = base_symbol;
					if (VALA_IS_NAMESPACE (_tmp325_)) {
						_tmp324_ = TRUE;
					} else {
						ValaSymbol* _tmp326_;
						_tmp326_ = base_symbol;
						_tmp324_ = VALA_IS_TYPESYMBOL (_tmp326_);
					}
					_tmp321_ = _tmp324_;
				} else {
					_tmp321_ = FALSE;
				}
				if (_tmp321_) {
					ValaSymbol* _tmp327_;
					ValaScope* _tmp328_;
					ValaScope* _tmp329_;
					const gchar* _tmp330_;
					ValaSymbol* _tmp331_;
					ValaSymbol* _tmp332_;
					ValaExpression* _tmp333_;
					ValaExpression* _tmp334_;
					_tmp327_ = base_symbol;
					_tmp328_ = vala_symbol_get_scope (_tmp327_);
					_tmp329_ = _tmp328_;
					_tmp330_ = self->priv->_member_name;
					_tmp331_ = vala_scope_lookup (_tmp329_, _tmp330_);
					_tmp332_ = _tmp331_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp332_);
					_vala_code_node_unref0 (_tmp332_);
					_tmp333_ = vala_member_access_get_inner (self);
					_tmp334_ = _tmp333_;
					if (VALA_IS_BASE_ACCESS (_tmp334_)) {
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
					}
				}
			}
			_tmp336_ = vala_member_access_get_inner (self);
			_tmp337_ = _tmp336_;
			if (VALA_IS_MEMBER_ACCESS (_tmp337_)) {
				ValaExpression* _tmp338_;
				ValaExpression* _tmp339_;
				ValaSymbol* _tmp340_;
				ValaSymbol* _tmp341_;
				_tmp338_ = vala_member_access_get_inner (self);
				_tmp339_ = _tmp338_;
				_tmp340_ = vala_expression_get_symbol_reference (_tmp339_);
				_tmp341_ = _tmp340_;
				_tmp335_ = VALA_IS_TYPEPARAMETER (_tmp341_);
			} else {
				_tmp335_ = FALSE;
			}
			if (_tmp335_) {
				ValaExpression* _tmp342_;
				ValaExpression* _tmp343_;
				ValaExpression* _tmp344_;
				ValaExpression* _tmp345_;
				ValaSymbol* _tmp346_;
				ValaSymbol* _tmp347_;
				ValaGenericType* _tmp348_;
				ValaGenericType* _tmp349_;
				ValaExpression* _tmp350_;
				ValaExpression* _tmp351_;
				ValaDataType* _tmp352_;
				ValaDataType* _tmp353_;
				ValaSourceReference* _tmp354_;
				ValaSourceReference* _tmp355_;
				_tmp342_ = vala_member_access_get_inner (self);
				_tmp343_ = _tmp342_;
				_tmp344_ = vala_member_access_get_inner (self);
				_tmp345_ = _tmp344_;
				_tmp346_ = vala_expression_get_symbol_reference (_tmp345_);
				_tmp347_ = _tmp346_;
				_tmp348_ = vala_generic_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp347_, VALA_TYPE_TYPEPARAMETER, ValaTypeParameter));
				_tmp349_ = _tmp348_;
				vala_expression_set_value_type (_tmp343_, (ValaDataType*) _tmp349_);
				_vala_code_node_unref0 (_tmp349_);
				_tmp350_ = vala_member_access_get_inner (self);
				_tmp351_ = _tmp350_;
				_tmp352_ = vala_expression_get_value_type (_tmp351_);
				_tmp353_ = _tmp352_;
				_tmp354_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp355_ = _tmp354_;
				vala_code_node_set_source_reference ((ValaCodeNode*) _tmp353_, _tmp355_);
			}
			_tmp357_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp358_ = _tmp357_;
			if (_tmp358_ == NULL) {
				ValaExpression* _tmp359_;
				ValaExpression* _tmp360_;
				ValaDataType* _tmp361_;
				ValaDataType* _tmp362_;
				_tmp359_ = vala_member_access_get_inner (self);
				_tmp360_ = _tmp359_;
				_tmp361_ = vala_expression_get_value_type (_tmp360_);
				_tmp362_ = _tmp361_;
				_tmp356_ = _tmp362_ != NULL;
			} else {
				_tmp356_ = FALSE;
			}
			if (_tmp356_) {
				gboolean _tmp363_;
				ValaSymbol* _tmp390_;
				ValaSymbol* _tmp391_;
				_tmp363_ = self->priv->_pointer_member_access;
				if (_tmp363_) {
					ValaExpression* _tmp364_;
					ValaExpression* _tmp365_;
					ValaDataType* _tmp366_;
					ValaDataType* _tmp367_;
					const gchar* _tmp368_;
					ValaSymbol* _tmp369_;
					ValaSymbol* _tmp370_;
					_tmp364_ = vala_member_access_get_inner (self);
					_tmp365_ = _tmp364_;
					_tmp366_ = vala_expression_get_value_type (_tmp365_);
					_tmp367_ = _tmp366_;
					_tmp368_ = self->priv->_member_name;
					_tmp369_ = vala_data_type_get_pointer_member (_tmp367_, _tmp368_);
					_tmp370_ = _tmp369_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp370_);
					_vala_code_node_unref0 (_tmp370_);
				} else {
					ValaExpression* _tmp371_;
					ValaExpression* _tmp372_;
					ValaDataType* _tmp373_;
					ValaDataType* _tmp374_;
					ValaTypeSymbol* _tmp375_;
					ValaTypeSymbol* _tmp376_;
					ValaExpression* _tmp383_;
					ValaExpression* _tmp384_;
					ValaDataType* _tmp385_;
					ValaDataType* _tmp386_;
					const gchar* _tmp387_;
					ValaSymbol* _tmp388_;
					ValaSymbol* _tmp389_;
					_tmp371_ = vala_member_access_get_inner (self);
					_tmp372_ = _tmp371_;
					_tmp373_ = vala_expression_get_value_type (_tmp372_);
					_tmp374_ = _tmp373_;
					_tmp375_ = vala_data_type_get_type_symbol (_tmp374_);
					_tmp376_ = _tmp375_;
					if (_tmp376_ != NULL) {
						ValaExpression* _tmp377_;
						ValaExpression* _tmp378_;
						ValaDataType* _tmp379_;
						ValaDataType* _tmp380_;
						ValaTypeSymbol* _tmp381_;
						ValaTypeSymbol* _tmp382_;
						_tmp377_ = vala_member_access_get_inner (self);
						_tmp378_ = _tmp377_;
						_tmp379_ = vala_expression_get_value_type (_tmp378_);
						_tmp380_ = _tmp379_;
						_tmp381_ = vala_data_type_get_type_symbol (_tmp380_);
						_tmp382_ = _tmp381_;
						base_symbol = (ValaSymbol*) _tmp382_;
					}
					_tmp383_ = vala_member_access_get_inner (self);
					_tmp384_ = _tmp383_;
					_tmp385_ = vala_expression_get_value_type (_tmp384_);
					_tmp386_ = _tmp385_;
					_tmp387_ = self->priv->_member_name;
					_tmp388_ = vala_data_type_get_member (_tmp386_, _tmp387_);
					_tmp389_ = _tmp388_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp389_);
					_vala_code_node_unref0 (_tmp389_);
				}
				_tmp390_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp391_ = _tmp390_;
				if (_tmp391_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
			}
			_tmp394_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp395_ = _tmp394_;
			if (_tmp395_ == NULL) {
				ValaExpression* _tmp396_;
				ValaExpression* _tmp397_;
				ValaDataType* _tmp398_;
				ValaDataType* _tmp399_;
				_tmp396_ = vala_member_access_get_inner (self);
				_tmp397_ = _tmp396_;
				_tmp398_ = vala_expression_get_value_type (_tmp397_);
				_tmp399_ = _tmp398_;
				_tmp393_ = _tmp399_ != NULL;
			} else {
				_tmp393_ = FALSE;
			}
			if (_tmp393_) {
				ValaExpression* _tmp400_;
				ValaExpression* _tmp401_;
				ValaDataType* _tmp402_;
				ValaDataType* _tmp403_;
				gboolean _tmp404_;
				gboolean _tmp405_;
				_tmp400_ = vala_member_access_get_inner (self);
				_tmp401_ = _tmp400_;
				_tmp402_ = vala_expression_get_value_type (_tmp401_);
				_tmp403_ = _tmp402_;
				_tmp404_ = vala_data_type_get_is_dynamic (_tmp403_);
				_tmp405_ = _tmp404_;
				_tmp392_ = _tmp405_;
			} else {
				_tmp392_ = FALSE;
			}
			if (_tmp392_) {
				ValaObjectType* dynamic_object_type = NULL;
				ValaExpression* _tmp406_;
				ValaExpression* _tmp407_;
				ValaDataType* _tmp408_;
				ValaDataType* _tmp409_;
				ValaObjectType* _tmp410_;
				ValaCodeNode* _tmp411_;
				ValaCodeNode* _tmp412_;
				ValaSymbol* _tmp579_;
				ValaSymbol* _tmp580_;
				ValaSymbol* _tmp629_;
				ValaSymbol* _tmp630_;
				_tmp406_ = vala_member_access_get_inner (self);
				_tmp407_ = _tmp406_;
				_tmp408_ = vala_expression_get_value_type (_tmp407_);
				_tmp409_ = _tmp408_;
				_tmp410_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp409_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				dynamic_object_type = _tmp410_;
				_tmp411_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp412_ = _tmp411_;
				if (VALA_IS_METHOD_CALL (_tmp412_)) {
					ValaMethodCall* invoc = NULL;
					ValaCodeNode* _tmp413_;
					ValaCodeNode* _tmp414_;
					ValaMethodCall* _tmp415_;
					ValaExpression* _tmp416_;
					ValaExpression* _tmp417_;
					_tmp413_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp414_ = _tmp413_;
					invoc = G_TYPE_CHECK_INSTANCE_CAST (_tmp414_, VALA_TYPE_METHOD_CALL, ValaMethodCall);
					_tmp415_ = invoc;
					_tmp416_ = vala_method_call_get_call (_tmp415_);
					_tmp417_ = _tmp416_;
					if (_tmp417_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
						ValaDataType* ret_type = NULL;
						ValaMethodCall* _tmp418_;
						ValaDataType* _tmp419_;
						ValaDataType* _tmp420_;
						ValaDynamicMethod* m = NULL;
						ValaExpression* _tmp435_;
						ValaExpression* _tmp436_;
						ValaDataType* _tmp437_;
						ValaDataType* _tmp438_;
						const gchar* _tmp439_;
						ValaDataType* _tmp440_;
						ValaSourceReference* _tmp441_;
						ValaSourceReference* _tmp442_;
						ValaDynamicMethod* _tmp443_;
						ValaDynamicMethod* _tmp444_;
						ValaMethodCall* _tmp445_;
						ValaErrorType* err = NULL;
						ValaDynamicMethod* _tmp446_;
						ValaSourceReference* _tmp447_;
						ValaSourceReference* _tmp448_;
						ValaErrorType* _tmp449_;
						ValaErrorType* _tmp450_;
						ValaDynamicMethod* _tmp451_;
						ValaErrorType* _tmp452_;
						ValaDynamicMethod* _tmp453_;
						ValaDynamicMethod* _tmp454_;
						ValaParameter* _tmp455_;
						ValaParameter* _tmp456_;
						ValaDynamicMethod* _tmp457_;
						ValaObjectType* _tmp458_;
						ValaDataType* _tmp459_;
						ValaDataType* _tmp460_;
						ValaDynamicMethod* _tmp461_;
						ValaSourceReference* _tmp462_;
						ValaSourceReference* _tmp463_;
						ValaParameter* _tmp464_;
						ValaParameter* _tmp465_;
						ValaObjectType* _tmp466_;
						ValaTypeSymbol* _tmp467_;
						ValaTypeSymbol* _tmp468_;
						ValaScope* _tmp469_;
						ValaScope* _tmp470_;
						ValaDynamicMethod* _tmp471_;
						ValaDynamicMethod* _tmp472_;
						_tmp418_ = invoc;
						_tmp419_ = vala_expression_get_target_type ((ValaExpression*) _tmp418_);
						_tmp420_ = _tmp419_;
						if (_tmp420_ != NULL) {
							ValaMethodCall* _tmp421_;
							ValaDataType* _tmp422_;
							ValaDataType* _tmp423_;
							ValaDataType* _tmp424_;
							ValaDataType* _tmp425_;
							_tmp421_ = invoc;
							_tmp422_ = vala_expression_get_target_type ((ValaExpression*) _tmp421_);
							_tmp423_ = _tmp422_;
							_tmp424_ = vala_data_type_copy (_tmp423_);
							_vala_code_node_unref0 (ret_type);
							ret_type = _tmp424_;
							_tmp425_ = ret_type;
							vala_data_type_set_value_owned (_tmp425_, TRUE);
						} else {
							ValaMethodCall* _tmp426_;
							ValaCodeNode* _tmp427_;
							ValaCodeNode* _tmp428_;
							_tmp426_ = invoc;
							_tmp427_ = vala_code_node_get_parent_node ((ValaCodeNode*) _tmp426_);
							_tmp428_ = _tmp427_;
							if (VALA_IS_EXPRESSION_STATEMENT (_tmp428_)) {
								ValaVoidType* _tmp429_;
								_tmp429_ = vala_void_type_new (NULL);
								_vala_code_node_unref0 (ret_type);
								ret_type = (ValaDataType*) _tmp429_;
							} else {
								ValaExpression* _tmp430_;
								ValaExpression* _tmp431_;
								ValaDataType* _tmp432_;
								ValaDataType* _tmp433_;
								ValaDataType* _tmp434_;
								_tmp430_ = vala_member_access_get_inner (self);
								_tmp431_ = _tmp430_;
								_tmp432_ = vala_expression_get_value_type (_tmp431_);
								_tmp433_ = _tmp432_;
								_tmp434_ = vala_data_type_copy (_tmp433_);
								_vala_code_node_unref0 (ret_type);
								ret_type = _tmp434_;
							}
						}
						_tmp435_ = vala_member_access_get_inner (self);
						_tmp436_ = _tmp435_;
						_tmp437_ = vala_expression_get_value_type (_tmp436_);
						_tmp438_ = _tmp437_;
						_tmp439_ = self->priv->_member_name;
						_tmp440_ = ret_type;
						_tmp441_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp442_ = _tmp441_;
						_tmp443_ = vala_dynamic_method_new (_tmp438_, _tmp439_, _tmp440_, _tmp442_, NULL);
						m = _tmp443_;
						_tmp444_ = m;
						_tmp445_ = invoc;
						vala_dynamic_method_set_invocation (_tmp444_, _tmp445_);
						_tmp446_ = m;
						_tmp447_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp446_);
						_tmp448_ = _tmp447_;
						_tmp449_ = vala_error_type_new (NULL, NULL, _tmp448_);
						err = _tmp449_;
						_tmp450_ = err;
						vala_error_type_set_dynamic_error (_tmp450_, TRUE);
						_tmp451_ = m;
						_tmp452_ = err;
						vala_method_add_error_type ((ValaMethod*) _tmp451_, (ValaDataType*) _tmp452_);
						_tmp453_ = m;
						vala_symbol_set_access ((ValaSymbol*) _tmp453_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
						_tmp454_ = m;
						_tmp455_ = vala_parameter_new_with_ellipsis (NULL);
						_tmp456_ = _tmp455_;
						vala_callable_add_parameter ((ValaCallable*) _tmp454_, _tmp456_);
						_vala_code_node_unref0 (_tmp456_);
						_tmp457_ = m;
						_tmp458_ = dynamic_object_type;
						_tmp459_ = vala_data_type_copy ((ValaDataType*) _tmp458_);
						_tmp460_ = _tmp459_;
						_tmp461_ = m;
						_tmp462_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp461_);
						_tmp463_ = _tmp462_;
						_tmp464_ = vala_parameter_new ("this", _tmp460_, _tmp463_);
						_tmp465_ = _tmp464_;
						vala_method_set_this_parameter ((ValaMethod*) _tmp457_, _tmp465_);
						_vala_code_node_unref0 (_tmp465_);
						_vala_code_node_unref0 (_tmp460_);
						_tmp466_ = dynamic_object_type;
						_tmp467_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp466_);
						_tmp468_ = _tmp467_;
						_tmp469_ = vala_symbol_get_scope ((ValaSymbol*) _tmp468_);
						_tmp470_ = _tmp469_;
						_tmp471_ = m;
						vala_scope_add (_tmp470_, NULL, (ValaSymbol*) _tmp471_);
						_tmp472_ = m;
						vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp472_);
						_vala_code_node_unref0 (err);
						_vala_code_node_unref0 (m);
						_vala_code_node_unref0 (ret_type);
					}
				} else {
					ValaCodeNode* _tmp473_;
					ValaCodeNode* _tmp474_;
					_tmp473_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp474_ = _tmp473_;
					if (VALA_IS_ASSIGNMENT (_tmp474_)) {
						ValaAssignment* a = NULL;
						ValaCodeNode* _tmp475_;
						ValaCodeNode* _tmp476_;
						ValaAssignment* _tmp477_;
						ValaExpression* _tmp478_;
						ValaExpression* _tmp479_;
						_tmp475_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp476_ = _tmp475_;
						a = G_TYPE_CHECK_INSTANCE_CAST (_tmp476_, VALA_TYPE_ASSIGNMENT, ValaAssignment);
						_tmp477_ = a;
						_tmp478_ = vala_assignment_get_left (_tmp477_);
						_tmp479_ = _tmp478_;
						if (_tmp479_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
							ValaDynamicProperty* prop = NULL;
							ValaExpression* _tmp480_;
							ValaExpression* _tmp481_;
							ValaDataType* _tmp482_;
							ValaDataType* _tmp483_;
							const gchar* _tmp484_;
							ValaSourceReference* _tmp485_;
							ValaSourceReference* _tmp486_;
							ValaDynamicProperty* _tmp487_;
							ValaDynamicProperty* _tmp488_;
							ValaDynamicProperty* _tmp489_;
							ValaDynamicProperty* _tmp490_;
							ValaSourceReference* _tmp491_;
							ValaSourceReference* _tmp492_;
							ValaPropertyAccessor* _tmp493_;
							ValaPropertyAccessor* _tmp494_;
							ValaDynamicProperty* _tmp495_;
							ValaExpression* _tmp496_;
							ValaExpression* _tmp497_;
							ValaDataType* _tmp498_;
							ValaDataType* _tmp499_;
							ValaTypeSymbol* _tmp500_;
							ValaTypeSymbol* _tmp501_;
							ValaScope* _tmp502_;
							ValaScope* _tmp503_;
							ValaObjectType* _tmp504_;
							ValaTypeSymbol* _tmp505_;
							ValaTypeSymbol* _tmp506_;
							ValaScope* _tmp507_;
							ValaScope* _tmp508_;
							ValaDynamicProperty* _tmp509_;
							ValaDynamicProperty* _tmp510_;
							_tmp480_ = vala_member_access_get_inner (self);
							_tmp481_ = _tmp480_;
							_tmp482_ = vala_expression_get_value_type (_tmp481_);
							_tmp483_ = _tmp482_;
							_tmp484_ = self->priv->_member_name;
							_tmp485_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp486_ = _tmp485_;
							_tmp487_ = vala_dynamic_property_new (_tmp483_, _tmp484_, _tmp486_, NULL);
							prop = _tmp487_;
							_tmp488_ = prop;
							vala_symbol_set_access ((ValaSymbol*) _tmp488_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
							_tmp489_ = prop;
							_tmp490_ = prop;
							_tmp491_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp490_);
							_tmp492_ = _tmp491_;
							_tmp493_ = vala_property_accessor_new (FALSE, TRUE, FALSE, NULL, NULL, _tmp492_, NULL);
							_tmp494_ = _tmp493_;
							vala_property_set_set_accessor ((ValaProperty*) _tmp489_, _tmp494_);
							_vala_code_node_unref0 (_tmp494_);
							_tmp495_ = prop;
							_tmp496_ = vala_member_access_get_inner (self);
							_tmp497_ = _tmp496_;
							_tmp498_ = vala_expression_get_value_type (_tmp497_);
							_tmp499_ = _tmp498_;
							_tmp500_ = vala_data_type_get_type_symbol (_tmp499_);
							_tmp501_ = _tmp500_;
							_tmp502_ = vala_symbol_get_scope ((ValaSymbol*) _tmp501_);
							_tmp503_ = _tmp502_;
							vala_symbol_set_owner ((ValaSymbol*) _tmp495_, _tmp503_);
							_tmp504_ = dynamic_object_type;
							_tmp505_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp504_);
							_tmp506_ = _tmp505_;
							_tmp507_ = vala_symbol_get_scope ((ValaSymbol*) _tmp506_);
							_tmp508_ = _tmp507_;
							_tmp509_ = prop;
							vala_scope_add (_tmp508_, NULL, (ValaSymbol*) _tmp509_);
							_tmp510_ = prop;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp510_);
							_vala_code_node_unref0 (prop);
						}
					} else {
						gboolean _tmp511_ = FALSE;
						gboolean _tmp512_ = FALSE;
						ValaCodeNode* _tmp513_;
						ValaCodeNode* _tmp514_;
						_tmp513_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp514_ = _tmp513_;
						if (VALA_IS_MEMBER_ACCESS (_tmp514_)) {
							ValaExpression* _tmp515_;
							ValaExpression* _tmp516_;
							_tmp515_ = vala_member_access_get_inner (self);
							_tmp516_ = _tmp515_;
							_tmp512_ = VALA_IS_MEMBER_ACCESS (_tmp516_);
						} else {
							_tmp512_ = FALSE;
						}
						if (_tmp512_) {
							ValaCodeNode* _tmp517_;
							ValaCodeNode* _tmp518_;
							ValaCodeNode* _tmp519_;
							ValaCodeNode* _tmp520_;
							_tmp517_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp518_ = _tmp517_;
							_tmp519_ = vala_code_node_get_parent_node (_tmp518_);
							_tmp520_ = _tmp519_;
							_tmp511_ = VALA_IS_METHOD_CALL (_tmp520_);
						} else {
							_tmp511_ = FALSE;
						}
						if (_tmp511_) {
							ValaMemberAccess* ma = NULL;
							ValaCodeNode* _tmp521_;
							ValaCodeNode* _tmp522_;
							gboolean _tmp523_ = FALSE;
							ValaMemberAccess* _tmp524_;
							const gchar* _tmp525_;
							_tmp521_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp522_ = _tmp521_;
							ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp522_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
							_tmp524_ = ma;
							_tmp525_ = _tmp524_->priv->_member_name;
							if (g_strcmp0 (_tmp525_, "connect") == 0) {
								_tmp523_ = TRUE;
							} else {
								ValaMemberAccess* _tmp526_;
								const gchar* _tmp527_;
								_tmp526_ = ma;
								_tmp527_ = _tmp526_->priv->_member_name;
								_tmp523_ = g_strcmp0 (_tmp527_, "connect_after") == 0;
							}
							if (_tmp523_) {
								ValaDynamicSignal* s = NULL;
								ValaExpression* _tmp528_;
								ValaExpression* _tmp529_;
								ValaDataType* _tmp530_;
								ValaDataType* _tmp531_;
								const gchar* _tmp532_;
								ValaVoidType* _tmp533_;
								ValaVoidType* _tmp534_;
								ValaSourceReference* _tmp535_;
								ValaSourceReference* _tmp536_;
								ValaDynamicSignal* _tmp537_;
								ValaDynamicSignal* _tmp538_;
								ValaMethodCall* mcall = NULL;
								ValaCodeNode* _tmp539_;
								ValaCodeNode* _tmp540_;
								ValaCodeNode* _tmp541_;
								ValaCodeNode* _tmp542_;
								ValaMethodCall* _tmp543_;
								ValaMethodCall* _tmp544_;
								ValaList* _tmp545_;
								gint _tmp546_;
								gint _tmp547_;
								ValaDynamicSignal* _tmp571_;
								ValaObjectType* _tmp572_;
								ValaTypeSymbol* _tmp573_;
								ValaTypeSymbol* _tmp574_;
								ValaScope* _tmp575_;
								ValaScope* _tmp576_;
								ValaDynamicSignal* _tmp577_;
								ValaDynamicSignal* _tmp578_;
								_tmp528_ = vala_member_access_get_inner (self);
								_tmp529_ = _tmp528_;
								_tmp530_ = vala_expression_get_value_type (_tmp529_);
								_tmp531_ = _tmp530_;
								_tmp532_ = self->priv->_member_name;
								_tmp533_ = vala_void_type_new (NULL);
								_tmp534_ = _tmp533_;
								_tmp535_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp536_ = _tmp535_;
								_tmp537_ = vala_dynamic_signal_new (_tmp531_, _tmp532_, (ValaDataType*) _tmp534_, _tmp536_, NULL);
								_tmp538_ = _tmp537_;
								_vala_code_node_unref0 (_tmp534_);
								s = _tmp538_;
								_tmp539_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
								_tmp540_ = _tmp539_;
								_tmp541_ = vala_code_node_get_parent_node (_tmp540_);
								_tmp542_ = _tmp541_;
								_tmp543_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp542_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
								mcall = _tmp543_;
								_tmp544_ = mcall;
								_tmp545_ = vala_callable_expression_get_argument_list ((ValaCallableExpression*) _tmp544_);
								_tmp546_ = vala_collection_get_size ((ValaCollection*) _tmp545_);
								_tmp547_ = _tmp546_;
								if (_tmp547_ > 0) {
									ValaDynamicSignal* _tmp548_;
									ValaMethodCall* _tmp549_;
									ValaList* _tmp550_;
									gpointer _tmp551_;
									ValaExpression* _tmp552_;
									ValaMemberAccess* arg = NULL;
									ValaDynamicSignal* _tmp553_;
									ValaExpression* _tmp554_;
									ValaExpression* _tmp555_;
									gboolean _tmp556_ = FALSE;
									gboolean _tmp557_ = FALSE;
									ValaMemberAccess* _tmp558_;
									_tmp548_ = s;
									_tmp549_ = mcall;
									_tmp550_ = vala_callable_expression_get_argument_list ((ValaCallableExpression*) _tmp549_);
									_tmp551_ = vala_list_get (_tmp550_, 0);
									_tmp552_ = (ValaExpression*) _tmp551_;
									vala_dynamic_signal_set_handler (_tmp548_, _tmp552_);
									_vala_code_node_unref0 (_tmp552_);
									_tmp553_ = s;
									_tmp554_ = vala_dynamic_signal_get_handler (_tmp553_);
									_tmp555_ = _tmp554_;
									arg = VALA_IS_MEMBER_ACCESS (_tmp555_) ? ((ValaMemberAccess*) _tmp555_) : NULL;
									_tmp558_ = arg;
									if (_tmp558_ == NULL) {
										_tmp557_ = TRUE;
									} else {
										ValaMemberAccess* _tmp559_;
										_tmp559_ = arg;
										_tmp557_ = !vala_code_node_check ((ValaCodeNode*) _tmp559_, context);
									}
									if (_tmp557_) {
										_tmp556_ = TRUE;
									} else {
										ValaMemberAccess* _tmp560_;
										ValaSymbol* _tmp561_;
										ValaSymbol* _tmp562_;
										_tmp560_ = arg;
										_tmp561_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp560_);
										_tmp562_ = _tmp561_;
										_tmp556_ = !VALA_IS_METHOD (_tmp562_);
									}
									if (_tmp556_) {
										ValaDynamicSignal* _tmp563_;
										ValaExpression* _tmp564_;
										ValaExpression* _tmp565_;
										ValaSourceReference* _tmp566_;
										ValaSourceReference* _tmp567_;
										ValaDynamicSignal* _tmp568_;
										gchar* _tmp569_;
										gchar* _tmp570_;
										vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
										_tmp563_ = s;
										_tmp564_ = vala_dynamic_signal_get_handler (_tmp563_);
										_tmp565_ = _tmp564_;
										_tmp566_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp565_);
										_tmp567_ = _tmp566_;
										_tmp568_ = s;
										_tmp569_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp568_);
										_tmp570_ = _tmp569_;
										vala_report_error (_tmp567_, "Invalid handler for `%s'", _tmp570_);
										_g_free0 (_tmp570_);
									}
								}
								_tmp571_ = s;
								vala_symbol_set_access ((ValaSymbol*) _tmp571_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
								_tmp572_ = dynamic_object_type;
								_tmp573_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp572_);
								_tmp574_ = _tmp573_;
								_tmp575_ = vala_symbol_get_scope ((ValaSymbol*) _tmp574_);
								_tmp576_ = _tmp575_;
								_tmp577_ = s;
								vala_scope_add (_tmp576_, NULL, (ValaSymbol*) _tmp577_);
								_tmp578_ = s;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp578_);
								_vala_code_node_unref0 (mcall);
								_vala_code_node_unref0 (s);
							}
						}
					}
				}
				_tmp579_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp580_ = _tmp579_;
				if (_tmp580_ == NULL) {
					ValaDynamicProperty* prop = NULL;
					ValaExpression* _tmp581_;
					ValaExpression* _tmp582_;
					ValaDataType* _tmp583_;
					ValaDataType* _tmp584_;
					const gchar* _tmp585_;
					ValaSourceReference* _tmp586_;
					ValaSourceReference* _tmp587_;
					ValaDynamicProperty* _tmp588_;
					ValaDataType* _tmp589_;
					ValaDataType* _tmp590_;
					ValaDynamicProperty* _tmp601_;
					ValaDynamicProperty* _tmp602_;
					ValaDynamicProperty* _tmp603_;
					ValaDataType* _tmp604_;
					ValaDataType* _tmp605_;
					ValaDataType* _tmp606_;
					ValaDataType* _tmp607_;
					ValaDynamicProperty* _tmp608_;
					ValaSourceReference* _tmp609_;
					ValaSourceReference* _tmp610_;
					ValaPropertyAccessor* _tmp611_;
					ValaPropertyAccessor* _tmp612_;
					ValaDynamicProperty* _tmp613_;
					ValaExpression* _tmp614_;
					ValaExpression* _tmp615_;
					ValaDataType* _tmp616_;
					ValaDataType* _tmp617_;
					ValaTypeSymbol* _tmp618_;
					ValaTypeSymbol* _tmp619_;
					ValaScope* _tmp620_;
					ValaScope* _tmp621_;
					ValaObjectType* _tmp622_;
					ValaTypeSymbol* _tmp623_;
					ValaTypeSymbol* _tmp624_;
					ValaScope* _tmp625_;
					ValaScope* _tmp626_;
					ValaDynamicProperty* _tmp627_;
					ValaDynamicProperty* _tmp628_;
					_tmp581_ = vala_member_access_get_inner (self);
					_tmp582_ = _tmp581_;
					_tmp583_ = vala_expression_get_value_type (_tmp582_);
					_tmp584_ = _tmp583_;
					_tmp585_ = self->priv->_member_name;
					_tmp586_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp587_ = _tmp586_;
					_tmp588_ = vala_dynamic_property_new (_tmp584_, _tmp585_, _tmp587_, NULL);
					prop = _tmp588_;
					_tmp589_ = vala_expression_get_target_type ((ValaExpression*) self);
					_tmp590_ = _tmp589_;
					if (_tmp590_ != NULL) {
						ValaDynamicProperty* _tmp591_;
						ValaDataType* _tmp592_;
						ValaDataType* _tmp593_;
						_tmp591_ = prop;
						_tmp592_ = vala_expression_get_target_type ((ValaExpression*) self);
						_tmp593_ = _tmp592_;
						vala_property_set_property_type ((ValaProperty*) _tmp591_, _tmp593_);
					} else {
						ValaDynamicProperty* _tmp594_;
						ValaExpression* _tmp595_;
						ValaExpression* _tmp596_;
						ValaDataType* _tmp597_;
						ValaDataType* _tmp598_;
						ValaDataType* _tmp599_;
						ValaDataType* _tmp600_;
						_tmp594_ = prop;
						_tmp595_ = vala_member_access_get_inner (self);
						_tmp596_ = _tmp595_;
						_tmp597_ = vala_expression_get_value_type (_tmp596_);
						_tmp598_ = _tmp597_;
						_tmp599_ = vala_data_type_copy (_tmp598_);
						_tmp600_ = _tmp599_;
						vala_property_set_property_type ((ValaProperty*) _tmp594_, _tmp600_);
						_vala_code_node_unref0 (_tmp600_);
					}
					_tmp601_ = prop;
					vala_symbol_set_access ((ValaSymbol*) _tmp601_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
					_tmp602_ = prop;
					_tmp603_ = prop;
					_tmp604_ = vala_property_get_property_type ((ValaProperty*) _tmp603_);
					_tmp605_ = _tmp604_;
					_tmp606_ = vala_data_type_copy (_tmp605_);
					_tmp607_ = _tmp606_;
					_tmp608_ = prop;
					_tmp609_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp608_);
					_tmp610_ = _tmp609_;
					_tmp611_ = vala_property_accessor_new (TRUE, FALSE, FALSE, _tmp607_, NULL, _tmp610_, NULL);
					_tmp612_ = _tmp611_;
					vala_property_set_get_accessor ((ValaProperty*) _tmp602_, _tmp612_);
					_vala_code_node_unref0 (_tmp612_);
					_vala_code_node_unref0 (_tmp607_);
					_tmp613_ = prop;
					_tmp614_ = vala_member_access_get_inner (self);
					_tmp615_ = _tmp614_;
					_tmp616_ = vala_expression_get_value_type (_tmp615_);
					_tmp617_ = _tmp616_;
					_tmp618_ = vala_data_type_get_type_symbol (_tmp617_);
					_tmp619_ = _tmp618_;
					_tmp620_ = vala_symbol_get_scope ((ValaSymbol*) _tmp619_);
					_tmp621_ = _tmp620_;
					vala_symbol_set_owner ((ValaSymbol*) _tmp613_, _tmp621_);
					_tmp622_ = dynamic_object_type;
					_tmp623_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp622_);
					_tmp624_ = _tmp623_;
					_tmp625_ = vala_symbol_get_scope ((ValaSymbol*) _tmp624_);
					_tmp626_ = _tmp625_;
					_tmp627_ = prop;
					vala_scope_add (_tmp626_, NULL, (ValaSymbol*) _tmp627_);
					_tmp628_ = prop;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp628_);
					_vala_code_node_unref0 (prop);
				}
				_tmp629_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp630_ = _tmp629_;
				if (_tmp630_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
				_vala_code_node_unref0 (dynamic_object_type);
			}
			_tmp631_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp632_ = _tmp631_;
			if (VALA_IS_ARRAY_RESIZE_METHOD (_tmp632_)) {
				ValaExpression* _tmp633_;
				ValaExpression* _tmp634_;
				ValaSymbol* _tmp635_;
				ValaSymbol* _tmp636_;
				_tmp633_ = vala_member_access_get_inner (self);
				_tmp634_ = _tmp633_;
				_tmp635_ = vala_expression_get_symbol_reference (_tmp634_);
				_tmp636_ = _tmp635_;
				if (VALA_IS_VARIABLE (_tmp636_)) {
					ValaArrayType* inner_type = NULL;
					ValaSemanticAnalyzer* _tmp637_;
					ValaSemanticAnalyzer* _tmp638_;
					ValaExpression* _tmp639_;
					ValaExpression* _tmp640_;
					ValaSymbol* _tmp641_;
					ValaSymbol* _tmp642_;
					ValaDataType* _tmp643_;
					ValaArrayType* _tmp644_;
					gboolean _tmp645_ = FALSE;
					ValaArrayType* _tmp646_;
					_tmp637_ = vala_code_context_get_analyzer (context);
					_tmp638_ = _tmp637_;
					_tmp639_ = vala_member_access_get_inner (self);
					_tmp640_ = _tmp639_;
					_tmp641_ = vala_expression_get_symbol_reference (_tmp640_);
					_tmp642_ = _tmp641_;
					_tmp643_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp638_, _tmp642_, TRUE);
					_tmp644_ = VALA_IS_ARRAY_TYPE (_tmp643_) ? ((ValaArrayType*) _tmp643_) : NULL;
					if (_tmp644_ == NULL) {
						_vala_code_node_unref0 (_tmp643_);
					}
					inner_type = _tmp644_;
					_tmp646_ = inner_type;
					if (_tmp646_ != NULL) {
						ValaArrayType* _tmp647_;
						gboolean _tmp648_;
						gboolean _tmp649_;
						_tmp647_ = inner_type;
						_tmp648_ = vala_array_type_get_inline_allocated (_tmp647_);
						_tmp649_ = _tmp648_;
						_tmp645_ = _tmp649_;
					} else {
						_tmp645_ = FALSE;
					}
					if (_tmp645_) {
						ValaSourceReference* _tmp650_;
						ValaSourceReference* _tmp651_;
						_tmp650_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp651_ = _tmp650_;
						vala_report_error (_tmp651_, "`resize' is not supported for arrays with fixed length");
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					} else {
						gboolean _tmp652_ = FALSE;
						ValaArrayType* _tmp653_;
						_tmp653_ = inner_type;
						if (_tmp653_ != NULL) {
							ValaArrayType* _tmp654_;
							gboolean _tmp655_;
							gboolean _tmp656_;
							_tmp654_ = inner_type;
							_tmp655_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp654_);
							_tmp656_ = _tmp655_;
							_tmp652_ = !_tmp656_;
						} else {
							_tmp652_ = FALSE;
						}
						if (_tmp652_) {
							ValaSourceReference* _tmp657_;
							ValaSourceReference* _tmp658_;
							_tmp657_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp658_ = _tmp657_;
							vala_report_error (_tmp658_, "`resize' is not allowed for unowned array references");
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						}
					}
					_vala_code_node_unref0 (inner_type);
				} else {
					ValaExpression* _tmp659_;
					ValaExpression* _tmp660_;
					ValaSymbol* _tmp661_;
					ValaSymbol* _tmp662_;
					_tmp659_ = vala_member_access_get_inner (self);
					_tmp660_ = _tmp659_;
					_tmp661_ = vala_expression_get_symbol_reference (_tmp660_);
					_tmp662_ = _tmp661_;
					if (VALA_IS_CONSTANT (_tmp662_)) {
						ValaSourceReference* _tmp663_;
						ValaSourceReference* _tmp664_;
						_tmp663_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp664_ = _tmp663_;
						vala_report_error (_tmp664_, "`resize' is not allowed for constant arrays");
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					}
				}
			}
		}
	}
	_tmp668_ = vala_member_access_get_inner (self);
	_tmp669_ = _tmp668_;
	if (_tmp669_ == NULL) {
		ValaSymbol* _tmp670_;
		ValaSymbol* _tmp671_;
		_tmp670_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp671_ = _tmp670_;
		_tmp667_ = _tmp671_ == NULL;
	} else {
		_tmp667_ = FALSE;
	}
	if (_tmp667_) {
		ValaDataType* _tmp672_;
		ValaDataType* _tmp673_;
		_tmp672_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp673_ = _tmp672_;
		_tmp666_ = _tmp673_ != NULL;
	} else {
		_tmp666_ = FALSE;
	}
	if (_tmp666_) {
		ValaDataType* _tmp674_;
		ValaDataType* _tmp675_;
		ValaTypeSymbol* _tmp676_;
		ValaTypeSymbol* _tmp677_;
		_tmp674_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp675_ = _tmp674_;
		_tmp676_ = vala_data_type_get_type_symbol (_tmp675_);
		_tmp677_ = _tmp676_;
		_tmp665_ = VALA_IS_ENUM (_tmp677_);
	} else {
		_tmp665_ = FALSE;
	}
	if (_tmp665_) {
		ValaEnum* enum_type = NULL;
		ValaDataType* _tmp678_;
		ValaDataType* _tmp679_;
		ValaTypeSymbol* _tmp680_;
		ValaTypeSymbol* _tmp681_;
		_tmp678_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp679_ = _tmp678_;
		_tmp680_ = vala_data_type_get_type_symbol (_tmp679_);
		_tmp681_ = _tmp680_;
		enum_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp681_, VALA_TYPE_ENUM, ValaEnum);
		{
			ValaList* _val_list = NULL;
			ValaEnum* _tmp682_;
			ValaList* _tmp683_;
			gint _val_size = 0;
			ValaList* _tmp684_;
			gint _tmp685_;
			gint _tmp686_;
			gint _val_index = 0;
			_tmp682_ = enum_type;
			_tmp683_ = vala_enum_get_values (_tmp682_);
			_val_list = _tmp683_;
			_tmp684_ = _val_list;
			_tmp685_ = vala_collection_get_size ((ValaCollection*) _tmp684_);
			_tmp686_ = _tmp685_;
			_val_size = _tmp686_;
			_val_index = -1;
			while (TRUE) {
				gint _tmp687_;
				gint _tmp688_;
				ValaEnumValue* val = NULL;
				ValaList* _tmp689_;
				gpointer _tmp690_;
				const gchar* _tmp691_;
				ValaEnumValue* _tmp692_;
				const gchar* _tmp693_;
				const gchar* _tmp694_;
				_val_index = _val_index + 1;
				_tmp687_ = _val_index;
				_tmp688_ = _val_size;
				if (!(_tmp687_ < _tmp688_)) {
					break;
				}
				_tmp689_ = _val_list;
				_tmp690_ = vala_list_get (_tmp689_, _val_index);
				val = (ValaEnumValue*) _tmp690_;
				_tmp691_ = self->priv->_member_name;
				_tmp692_ = val;
				_tmp693_ = vala_symbol_get_name ((ValaSymbol*) _tmp692_);
				_tmp694_ = _tmp693_;
				if (g_strcmp0 (_tmp691_, _tmp694_) == 0) {
					ValaEnumValue* _tmp695_;
					_tmp695_ = val;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp695_);
					_vala_code_node_unref0 (val);
					break;
				}
				_vala_code_node_unref0 (val);
			}
		}
	}
	_tmp696_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp697_ = _tmp696_;
	if (_tmp697_ == NULL) {
		gchar* base_type_name = NULL;
		gchar* _tmp698_;
		ValaSymbol* base_type = NULL;
		gboolean _tmp699_ = FALSE;
		ValaExpression* _tmp700_;
		ValaExpression* _tmp701_;
		gchar* base_type_package = NULL;
		gchar* _tmp721_;
		gboolean _tmp722_ = FALSE;
		ValaSymbol* _tmp723_;
		gchar* visited_types_string = NULL;
		gchar* _tmp738_;
		ValaSourceReference* _tmp754_;
		ValaSourceReference* _tmp755_;
		const gchar* _tmp756_;
		const gchar* _tmp757_;
		const gchar* _tmp758_;
		const gchar* _tmp759_;
		ValaInvalidType* _tmp760_;
		ValaInvalidType* _tmp761_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp698_ = g_strdup ("(null)");
		base_type_name = _tmp698_;
		base_type = NULL;
		_tmp700_ = vala_member_access_get_inner (self);
		_tmp701_ = _tmp700_;
		if (_tmp701_ != NULL) {
			ValaExpression* _tmp702_;
			ValaExpression* _tmp703_;
			ValaDataType* _tmp704_;
			ValaDataType* _tmp705_;
			_tmp702_ = vala_member_access_get_inner (self);
			_tmp703_ = _tmp702_;
			_tmp704_ = vala_expression_get_value_type (_tmp703_);
			_tmp705_ = _tmp704_;
			_tmp699_ = _tmp705_ != NULL;
		} else {
			_tmp699_ = FALSE;
		}
		if (_tmp699_) {
			ValaExpression* _tmp706_;
			ValaExpression* _tmp707_;
			ValaDataType* _tmp708_;
			ValaDataType* _tmp709_;
			gchar* _tmp710_;
			ValaExpression* _tmp711_;
			ValaExpression* _tmp712_;
			ValaDataType* _tmp713_;
			ValaDataType* _tmp714_;
			ValaTypeSymbol* _tmp715_;
			ValaTypeSymbol* _tmp716_;
			_tmp706_ = vala_member_access_get_inner (self);
			_tmp707_ = _tmp706_;
			_tmp708_ = vala_expression_get_value_type (_tmp707_);
			_tmp709_ = _tmp708_;
			_tmp710_ = vala_code_node_to_string ((ValaCodeNode*) _tmp709_);
			_g_free0 (base_type_name);
			base_type_name = _tmp710_;
			_tmp711_ = vala_member_access_get_inner (self);
			_tmp712_ = _tmp711_;
			_tmp713_ = vala_expression_get_value_type (_tmp712_);
			_tmp714_ = _tmp713_;
			_tmp715_ = vala_data_type_get_type_symbol (_tmp714_);
			_tmp716_ = _tmp715_;
			base_type = (ValaSymbol*) _tmp716_;
		} else {
			ValaSymbol* _tmp717_;
			_tmp717_ = base_symbol;
			if (_tmp717_ != NULL) {
				ValaSymbol* _tmp718_;
				gchar* _tmp719_;
				ValaSymbol* _tmp720_;
				_tmp718_ = base_symbol;
				_tmp719_ = vala_symbol_get_full_name (_tmp718_);
				_g_free0 (base_type_name);
				base_type_name = _tmp719_;
				_tmp720_ = base_symbol;
				base_type = _tmp720_;
			}
		}
		_tmp721_ = g_strdup ("");
		base_type_package = _tmp721_;
		_tmp723_ = base_type;
		if (_tmp723_ != NULL) {
			ValaSymbol* _tmp724_;
			gboolean _tmp725_;
			gboolean _tmp726_;
			_tmp724_ = base_type;
			_tmp725_ = vala_symbol_get_external_package (_tmp724_);
			_tmp726_ = _tmp725_;
			_tmp722_ = _tmp726_;
		} else {
			_tmp722_ = FALSE;
		}
		if (_tmp722_) {
			ValaSymbol* _tmp727_;
			ValaSourceReference* _tmp728_;
			ValaSourceReference* _tmp729_;
			ValaSourceFile* _tmp730_;
			ValaSourceFile* _tmp731_;
			const gchar* _tmp732_;
			const gchar* _tmp733_;
			gchar* _tmp734_;
			const gchar* _tmp735_;
			_tmp727_ = base_symbol;
			_tmp728_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp727_);
			_tmp729_ = _tmp728_;
			_tmp730_ = vala_source_reference_get_file (_tmp729_);
			_tmp731_ = _tmp730_;
			_tmp732_ = vala_source_file_get_package_name (_tmp731_);
			_tmp733_ = _tmp732_;
			_tmp734_ = g_strdup (_tmp733_);
			_g_free0 (base_type_package);
			base_type_package = _tmp734_;
			_tmp735_ = base_type_package;
			if (_tmp735_ != NULL) {
				const gchar* _tmp736_;
				gchar* _tmp737_;
				_tmp736_ = base_type_package;
				_tmp737_ = g_strdup_printf (" (%s)", _tmp736_);
				_g_free0 (base_type_package);
				base_type_package = _tmp737_;
			}
		}
		_tmp738_ = g_strdup ("");
		visited_types_string = _tmp738_;
		{
			ValaArrayList* _type_list = NULL;
			ValaArrayList* _tmp739_;
			gint _type_size = 0;
			ValaArrayList* _tmp740_;
			gint _tmp741_;
			gint _tmp742_;
			gint _type_index = 0;
			_tmp739_ = visited_types;
			_type_list = _tmp739_;
			_tmp740_ = _type_list;
			_tmp741_ = vala_collection_get_size ((ValaCollection*) _tmp740_);
			_tmp742_ = _tmp741_;
			_type_size = _tmp742_;
			_type_index = -1;
			while (TRUE) {
				gint _tmp743_;
				gint _tmp744_;
				ValaDataType* type = NULL;
				ValaArrayList* _tmp745_;
				gpointer _tmp746_;
				const gchar* _tmp747_;
				ValaDataType* _tmp748_;
				gchar* _tmp749_;
				gchar* _tmp750_;
				gchar* _tmp751_;
				gchar* _tmp752_;
				gchar* _tmp753_;
				_type_index = _type_index + 1;
				_tmp743_ = _type_index;
				_tmp744_ = _type_size;
				if (!(_tmp743_ < _tmp744_)) {
					break;
				}
				_tmp745_ = _type_list;
				_tmp746_ = vala_list_get ((ValaList*) _tmp745_, _type_index);
				type = (ValaDataType*) _tmp746_;
				_tmp747_ = visited_types_string;
				_tmp748_ = type;
				_tmp749_ = vala_code_node_to_string ((ValaCodeNode*) _tmp748_);
				_tmp750_ = _tmp749_;
				_tmp751_ = g_strdup_printf (" or `%s'", _tmp750_);
				_tmp752_ = _tmp751_;
				_tmp753_ = g_strconcat (_tmp747_, _tmp752_, NULL);
				_g_free0 (visited_types_string);
				visited_types_string = _tmp753_;
				_g_free0 (_tmp752_);
				_g_free0 (_tmp750_);
				_vala_code_node_unref0 (type);
			}
		}
		_tmp754_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp755_ = _tmp754_;
		_tmp756_ = self->priv->_member_name;
		_tmp757_ = base_type_name;
		_tmp758_ = base_type_package;
		_tmp759_ = visited_types_string;
		vala_report_error (_tmp755_, "The name `%s' does not exist in the context of `%s'%s%s", _tmp756_, _tmp757_, _tmp758_, _tmp759_);
		_tmp760_ = vala_invalid_type_new ();
		_tmp761_ = _tmp760_;
		vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp761_);
		_vala_code_node_unref0 (_tmp761_);
		result = FALSE;
		_g_free0 (visited_types_string);
		_g_free0 (base_type_package);
		_g_free0 (base_type_name);
		_vala_iterable_unref0 (visited_types);
		return result;
	} else {
		ValaSymbol* _tmp762_;
		ValaSymbol* _tmp763_;
		gboolean _tmp764_;
		gboolean _tmp765_;
		_tmp762_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp763_ = _tmp762_;
		_tmp764_ = vala_code_node_get_error ((ValaCodeNode*) _tmp763_);
		_tmp765_ = _tmp764_;
		if (_tmp765_) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_iterable_unref0 (visited_types);
			return result;
		}
	}
	_tmp766_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp767_ = _tmp766_;
	if (VALA_IS_SIGNAL (_tmp767_)) {
		ValaSignal* sig = NULL;
		ValaSymbol* _tmp768_;
		ValaSymbol* _tmp769_;
		ValaCodeNode* ma = NULL;
		ValaCodeNode* parent = NULL;
		ValaCodeNode* _tmp776_;
		ValaCodeNode* _tmp777_;
		ValaCodeNode* _tmp778_;
		gboolean _tmp779_ = FALSE;
		gboolean _tmp780_ = FALSE;
		gboolean _tmp781_ = FALSE;
		ValaCodeNode* _tmp782_;
		_tmp768_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp769_ = _tmp768_;
		sig = G_TYPE_CHECK_INSTANCE_CAST (_tmp769_, VALA_TYPE_SIGNAL, ValaSignal);
		ma = (ValaCodeNode*) self;
		while (TRUE) {
			ValaCodeNode* _tmp770_;
			ValaCodeNode* _tmp771_;
			ValaCodeNode* _tmp772_;
			ValaCodeNode* _tmp773_;
			ValaCodeNode* _tmp774_;
			ValaCodeNode* _tmp775_;
			_tmp770_ = ma;
			_tmp771_ = vala_code_node_get_parent_node (_tmp770_);
			_tmp772_ = _tmp771_;
			if (!VALA_IS_MEMBER_ACCESS (_tmp772_)) {
				break;
			}
			_tmp773_ = ma;
			_tmp774_ = vala_code_node_get_parent_node (_tmp773_);
			_tmp775_ = _tmp774_;
			ma = _tmp775_;
		}
		_tmp776_ = ma;
		_tmp777_ = vala_code_node_get_parent_node (_tmp776_);
		_tmp778_ = _tmp777_;
		parent = _tmp778_;
		_tmp782_ = parent;
		if (_tmp782_ != NULL) {
			ValaCodeNode* _tmp783_;
			_tmp783_ = parent;
			_tmp781_ = !VALA_IS_ELEMENT_ACCESS (_tmp783_);
		} else {
			_tmp781_ = FALSE;
		}
		if (_tmp781_) {
			ValaCodeNode* _tmp784_;
			ValaExpression* _tmp785_;
			ValaExpression* _tmp786_;
			_tmp784_ = ma;
			_tmp785_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp784_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp786_ = _tmp785_;
			_tmp780_ = !VALA_IS_BASE_ACCESS (_tmp786_);
		} else {
			_tmp780_ = FALSE;
		}
		if (_tmp780_) {
			gboolean _tmp787_ = FALSE;
			ValaCodeNode* _tmp788_;
			_tmp788_ = parent;
			if (!VALA_IS_METHOD_CALL (_tmp788_)) {
				_tmp787_ = TRUE;
			} else {
				ValaCodeNode* _tmp789_;
				ValaList* _tmp790_;
				_tmp789_ = parent;
				_tmp790_ = vala_callable_expression_get_argument_list ((ValaCallableExpression*) G_TYPE_CHECK_INSTANCE_CAST (_tmp789_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
				_tmp787_ = vala_collection_contains ((ValaCollection*) _tmp790_, (ValaExpression*) self);
			}
			_tmp779_ = _tmp787_;
		} else {
			_tmp779_ = FALSE;
		}
		if (_tmp779_) {
			ValaSignal* _tmp791_;
			ValaAttribute* _tmp792_;
			_tmp791_ = sig;
			_tmp792_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp791_, "HasEmitter");
			if (_tmp792_ != NULL) {
				ValaSignal* _tmp793_;
				ValaSignal* _tmp794_;
				ValaMethod* _tmp795_;
				ValaMethod* _tmp796_;
				_tmp793_ = sig;
				if (!vala_code_node_check ((ValaCodeNode*) _tmp793_, context)) {
					result = FALSE;
					_vala_iterable_unref0 (visited_types);
					return result;
				}
				_tmp794_ = sig;
				_tmp795_ = vala_signal_get_emitter (_tmp794_);
				_tmp796_ = _tmp795_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp796_);
			} else {
				ValaSourceReference* _tmp797_;
				ValaSourceReference* _tmp798_;
				ValaSymbol* _tmp799_;
				ValaSymbol* _tmp800_;
				gchar* _tmp801_;
				gchar* _tmp802_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp797_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp798_ = _tmp797_;
				_tmp799_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp800_ = _tmp799_;
				_tmp801_ = vala_symbol_get_full_name (_tmp800_);
				_tmp802_ = _tmp801_;
				vala_report_error (_tmp798_, "Signal `%s' requires emitter in this context", _tmp802_);
				_g_free0 (_tmp802_);
				result = FALSE;
				_vala_iterable_unref0 (visited_types);
				return result;
			}
		}
	}
	_tmp803_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp804_ = _tmp803_;
	member = _tmp804_;
	access = VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
	instance = FALSE;
	klass = FALSE;
	generics = FALSE;
	_tmp805_ = member;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp805_, context)) {
		result = FALSE;
		_vala_iterable_unref0 (visited_types);
		return result;
	}
	_tmp806_ = member;
	if (VALA_IS_LOCAL_VARIABLE (_tmp806_)) {
		ValaLocalVariable* local = NULL;
		ValaSymbol* _tmp807_;
		ValaBlock* block = NULL;
		ValaLocalVariable* _tmp808_;
		ValaSymbol* _tmp809_;
		ValaSymbol* _tmp810_;
		gboolean _tmp811_ = FALSE;
		ValaBlock* _tmp812_;
		_tmp807_ = member;
		local = G_TYPE_CHECK_INSTANCE_CAST (_tmp807_, VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable);
		_tmp808_ = local;
		_tmp809_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp808_);
		_tmp810_ = _tmp809_;
		block = VALA_IS_BLOCK (_tmp810_) ? ((ValaBlock*) _tmp810_) : NULL;
		_tmp812_ = block;
		if (_tmp812_ != NULL) {
			ValaBlock* _tmp813_;
			ValaSymbol* _tmp814_;
			ValaSemanticAnalyzer* _tmp815_;
			ValaSemanticAnalyzer* _tmp816_;
			ValaSymbol* _tmp817_;
			ValaSymbol* _tmp818_;
			_tmp813_ = block;
			_tmp814_ = vala_semantic_analyzer_find_parent_method_or_property_accessor ((ValaSymbol*) _tmp813_);
			_tmp815_ = vala_code_context_get_analyzer (context);
			_tmp816_ = _tmp815_;
			_tmp817_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp816_);
			_tmp818_ = _tmp817_;
			_tmp811_ = _tmp814_ != _tmp818_;
		} else {
			_tmp811_ = FALSE;
		}
		if (_tmp811_) {
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp819_;
			ValaSemanticAnalyzer* _tmp820_;
			ValaSymbol* _tmp821_;
			ValaSymbol* _tmp822_;
			ValaLocalVariable* _tmp833_;
			ValaBlock* _tmp834_;
			ValaLocalVariable* _tmp835_;
			ValaDataType* _tmp836_;
			ValaDataType* _tmp837_;
			ValaTypeSymbol* _tmp838_;
			ValaTypeSymbol* _tmp839_;
			ValaSemanticAnalyzer* _tmp840_;
			ValaSemanticAnalyzer* _tmp841_;
			ValaDataType* _tmp842_;
			ValaTypeSymbol* _tmp843_;
			ValaTypeSymbol* _tmp844_;
			_tmp819_ = vala_code_context_get_analyzer (context);
			_tmp820_ = _tmp819_;
			_tmp821_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp820_);
			_tmp822_ = _tmp821_;
			sym = _tmp822_;
			while (TRUE) {
				ValaSymbol* _tmp823_;
				ValaBlock* _tmp824_;
				ValaMethod* method = NULL;
				ValaSymbol* _tmp825_;
				ValaMethod* _tmp826_;
				ValaSymbol* _tmp830_;
				ValaSymbol* _tmp831_;
				ValaSymbol* _tmp832_;
				_tmp823_ = sym;
				_tmp824_ = block;
				if (!(_tmp823_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp824_, VALA_TYPE_SYMBOL, ValaSymbol))) {
					break;
				}
				_tmp825_ = sym;
				method = VALA_IS_METHOD (_tmp825_) ? ((ValaMethod*) _tmp825_) : NULL;
				_tmp826_ = method;
				if (_tmp826_ != NULL) {
					ValaMethod* _tmp827_;
					ValaMethod* _tmp828_;
					ValaLocalVariable* _tmp829_;
					_tmp827_ = method;
					vala_method_set_closure (_tmp827_, TRUE);
					_tmp828_ = method;
					_tmp829_ = local;
					vala_method_add_captured_variable (_tmp828_, _tmp829_);
				}
				_tmp830_ = sym;
				_tmp831_ = vala_symbol_get_parent_symbol (_tmp830_);
				_tmp832_ = _tmp831_;
				sym = _tmp832_;
			}
			_tmp833_ = local;
			vala_local_variable_set_captured (_tmp833_, TRUE);
			_tmp834_ = block;
			vala_block_set_captured (_tmp834_, TRUE);
			_tmp835_ = local;
			_tmp836_ = vala_variable_get_variable_type ((ValaVariable*) _tmp835_);
			_tmp837_ = _tmp836_;
			_tmp838_ = vala_data_type_get_type_symbol (_tmp837_);
			_tmp839_ = _tmp838_;
			_tmp840_ = vala_code_context_get_analyzer (context);
			_tmp841_ = _tmp840_;
			_tmp842_ = _tmp841_->va_list_type;
			_tmp843_ = vala_data_type_get_type_symbol (_tmp842_);
			_tmp844_ = _tmp843_;
			if (_tmp839_ == _tmp844_) {
				ValaSourceReference* _tmp845_;
				ValaSourceReference* _tmp846_;
				ValaLocalVariable* _tmp847_;
				gchar* _tmp848_;
				gchar* _tmp849_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp845_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp846_ = _tmp845_;
				_tmp847_ = local;
				_tmp848_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp847_);
				_tmp849_ = _tmp848_;
				vala_report_error (_tmp846_, "Capturing `va_list' variable `%s' is not allowed", _tmp849_);
				_g_free0 (_tmp849_);
			}
		}
	} else {
		ValaSymbol* _tmp850_;
		_tmp850_ = member;
		if (VALA_IS_PARAMETER (_tmp850_)) {
			ValaParameter* param = NULL;
			ValaSymbol* _tmp851_;
			ValaMethod* m = NULL;
			ValaParameter* _tmp852_;
			ValaSymbol* _tmp853_;
			ValaSymbol* _tmp854_;
			gboolean _tmp855_ = FALSE;
			gboolean _tmp856_ = FALSE;
			ValaMethod* _tmp857_;
			_tmp851_ = member;
			param = G_TYPE_CHECK_INSTANCE_CAST (_tmp851_, VALA_TYPE_PARAMETER, ValaParameter);
			_tmp852_ = param;
			_tmp853_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp852_);
			_tmp854_ = _tmp853_;
			m = VALA_IS_METHOD (_tmp854_) ? ((ValaMethod*) _tmp854_) : NULL;
			_tmp857_ = m;
			if (_tmp857_ != NULL) {
				ValaMethod* _tmp858_;
				ValaSemanticAnalyzer* _tmp859_;
				ValaSemanticAnalyzer* _tmp860_;
				ValaSymbol* _tmp861_;
				ValaSymbol* _tmp862_;
				_tmp858_ = m;
				_tmp859_ = vala_code_context_get_analyzer (context);
				_tmp860_ = _tmp859_;
				_tmp861_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp860_);
				_tmp862_ = _tmp861_;
				_tmp856_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp858_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp862_;
			} else {
				_tmp856_ = FALSE;
			}
			if (_tmp856_) {
				ValaParameter* _tmp863_;
				ValaMethod* _tmp864_;
				ValaParameter* _tmp865_;
				ValaParameter* _tmp866_;
				_tmp863_ = param;
				_tmp864_ = m;
				_tmp865_ = vala_method_get_this_parameter (_tmp864_);
				_tmp866_ = _tmp865_;
				_tmp855_ = _tmp863_ != _tmp866_;
			} else {
				_tmp855_ = FALSE;
			}
			if (_tmp855_) {
				ValaSymbol* sym = NULL;
				ValaSemanticAnalyzer* _tmp867_;
				ValaSemanticAnalyzer* _tmp868_;
				ValaSymbol* _tmp869_;
				ValaSymbol* _tmp870_;
				ValaParameter* _tmp879_;
				ValaMethod* _tmp880_;
				ValaBlock* _tmp881_;
				ValaBlock* _tmp882_;
				ValaParameter* _tmp883_;
				ValaParameterDirection _tmp884_;
				ValaParameterDirection _tmp885_;
				ValaParameter* _tmp891_;
				ValaDataType* _tmp892_;
				ValaDataType* _tmp893_;
				ValaTypeSymbol* _tmp894_;
				ValaTypeSymbol* _tmp895_;
				ValaSemanticAnalyzer* _tmp896_;
				ValaSemanticAnalyzer* _tmp897_;
				ValaDataType* _tmp898_;
				ValaTypeSymbol* _tmp899_;
				ValaTypeSymbol* _tmp900_;
				_tmp867_ = vala_code_context_get_analyzer (context);
				_tmp868_ = _tmp867_;
				_tmp869_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp868_);
				_tmp870_ = _tmp869_;
				sym = _tmp870_;
				while (TRUE) {
					ValaSymbol* _tmp871_;
					ValaMethod* _tmp872_;
					ValaMethod* method = NULL;
					ValaSymbol* _tmp873_;
					ValaMethod* _tmp874_;
					ValaSymbol* _tmp876_;
					ValaSymbol* _tmp877_;
					ValaSymbol* _tmp878_;
					_tmp871_ = sym;
					_tmp872_ = m;
					if (!(_tmp871_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp872_, VALA_TYPE_SYMBOL, ValaSymbol))) {
						break;
					}
					_tmp873_ = sym;
					method = VALA_IS_METHOD (_tmp873_) ? ((ValaMethod*) _tmp873_) : NULL;
					_tmp874_ = method;
					if (_tmp874_ != NULL) {
						ValaMethod* _tmp875_;
						_tmp875_ = method;
						vala_method_set_closure (_tmp875_, TRUE);
					}
					_tmp876_ = sym;
					_tmp877_ = vala_symbol_get_parent_symbol (_tmp876_);
					_tmp878_ = _tmp877_;
					sym = _tmp878_;
				}
				_tmp879_ = param;
				vala_parameter_set_captured (_tmp879_, TRUE);
				_tmp880_ = m;
				_tmp881_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp880_);
				_tmp882_ = _tmp881_;
				vala_block_set_captured (_tmp882_, TRUE);
				_tmp883_ = param;
				_tmp884_ = vala_parameter_get_direction (_tmp883_);
				_tmp885_ = _tmp884_;
				if (_tmp885_ != VALA_PARAMETER_DIRECTION_IN) {
					ValaSourceReference* _tmp886_;
					ValaSourceReference* _tmp887_;
					ValaParameter* _tmp888_;
					gchar* _tmp889_;
					gchar* _tmp890_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp886_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp887_ = _tmp886_;
					_tmp888_ = param;
					_tmp889_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp888_);
					_tmp890_ = _tmp889_;
					vala_report_error (_tmp887_, "Cannot capture reference or output parameter `%s'", _tmp890_);
					_g_free0 (_tmp890_);
				}
				_tmp891_ = param;
				_tmp892_ = vala_variable_get_variable_type ((ValaVariable*) _tmp891_);
				_tmp893_ = _tmp892_;
				_tmp894_ = vala_data_type_get_type_symbol (_tmp893_);
				_tmp895_ = _tmp894_;
				_tmp896_ = vala_code_context_get_analyzer (context);
				_tmp897_ = _tmp896_;
				_tmp898_ = _tmp897_->va_list_type;
				_tmp899_ = vala_data_type_get_type_symbol (_tmp898_);
				_tmp900_ = _tmp899_;
				if (_tmp895_ == _tmp900_) {
					ValaSourceReference* _tmp901_;
					ValaSourceReference* _tmp902_;
					ValaParameter* _tmp903_;
					gchar* _tmp904_;
					gchar* _tmp905_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp901_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp902_ = _tmp901_;
					_tmp903_ = param;
					_tmp904_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp903_);
					_tmp905_ = _tmp904_;
					vala_report_error (_tmp902_, "Capturing `va_list' parameter `%s' is not allowed", _tmp905_);
					_g_free0 (_tmp905_);
				}
			} else {
				ValaPropertyAccessor* acc = NULL;
				ValaParameter* _tmp906_;
				ValaSymbol* _tmp907_;
				ValaSymbol* _tmp908_;
				ValaSymbol* _tmp909_;
				ValaSymbol* _tmp910_;
				gboolean _tmp911_ = FALSE;
				gboolean _tmp912_ = FALSE;
				ValaPropertyAccessor* _tmp913_;
				_tmp906_ = param;
				_tmp907_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp906_);
				_tmp908_ = _tmp907_;
				_tmp909_ = vala_symbol_get_parent_symbol (_tmp908_);
				_tmp910_ = _tmp909_;
				acc = VALA_IS_PROPERTY_ACCESSOR (_tmp910_) ? ((ValaPropertyAccessor*) _tmp910_) : NULL;
				_tmp913_ = acc;
				if (_tmp913_ != NULL) {
					ValaPropertyAccessor* _tmp914_;
					ValaSemanticAnalyzer* _tmp915_;
					ValaSemanticAnalyzer* _tmp916_;
					ValaSymbol* _tmp917_;
					ValaSymbol* _tmp918_;
					_tmp914_ = acc;
					_tmp915_ = vala_code_context_get_analyzer (context);
					_tmp916_ = _tmp915_;
					_tmp917_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp916_);
					_tmp918_ = _tmp917_;
					_tmp912_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp914_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp918_;
				} else {
					_tmp912_ = FALSE;
				}
				if (_tmp912_) {
					ValaParameter* _tmp919_;
					ValaPropertyAccessor* _tmp920_;
					ValaProperty* _tmp921_;
					ValaProperty* _tmp922_;
					ValaParameter* _tmp923_;
					ValaParameter* _tmp924_;
					_tmp919_ = param;
					_tmp920_ = acc;
					_tmp921_ = vala_property_accessor_get_prop (_tmp920_);
					_tmp922_ = _tmp921_;
					_tmp923_ = vala_property_get_this_parameter (_tmp922_);
					_tmp924_ = _tmp923_;
					_tmp911_ = _tmp919_ != _tmp924_;
				} else {
					_tmp911_ = FALSE;
				}
				if (_tmp911_) {
					ValaSymbol* sym = NULL;
					ValaSemanticAnalyzer* _tmp925_;
					ValaSemanticAnalyzer* _tmp926_;
					ValaSymbol* _tmp927_;
					ValaSymbol* _tmp928_;
					ValaParameter* _tmp937_;
					ValaPropertyAccessor* _tmp938_;
					ValaBlock* _tmp939_;
					ValaBlock* _tmp940_;
					_tmp925_ = vala_code_context_get_analyzer (context);
					_tmp926_ = _tmp925_;
					_tmp927_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp926_);
					_tmp928_ = _tmp927_;
					sym = _tmp928_;
					while (TRUE) {
						ValaSymbol* _tmp929_;
						ValaMethod* _tmp930_;
						ValaMethod* method = NULL;
						ValaSymbol* _tmp931_;
						ValaMethod* _tmp932_;
						ValaSymbol* _tmp934_;
						ValaSymbol* _tmp935_;
						ValaSymbol* _tmp936_;
						_tmp929_ = sym;
						_tmp930_ = m;
						if (!(_tmp929_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp930_, VALA_TYPE_SYMBOL, ValaSymbol))) {
							break;
						}
						_tmp931_ = sym;
						method = VALA_IS_METHOD (_tmp931_) ? ((ValaMethod*) _tmp931_) : NULL;
						_tmp932_ = method;
						if (_tmp932_ != NULL) {
							ValaMethod* _tmp933_;
							_tmp933_ = method;
							vala_method_set_closure (_tmp933_, TRUE);
						}
						_tmp934_ = sym;
						_tmp935_ = vala_symbol_get_parent_symbol (_tmp934_);
						_tmp936_ = _tmp935_;
						sym = _tmp936_;
					}
					_tmp937_ = param;
					vala_parameter_set_captured (_tmp937_, TRUE);
					_tmp938_ = acc;
					_tmp939_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp938_);
					_tmp940_ = _tmp939_;
					vala_block_set_captured (_tmp940_, TRUE);
				}
			}
		} else {
			ValaSymbol* _tmp941_;
			_tmp941_ = member;
			if (VALA_IS_FIELD (_tmp941_)) {
				ValaField* f = NULL;
				ValaSymbol* _tmp942_;
				ValaField* _tmp943_;
				ValaSymbolAccessibility _tmp944_;
				ValaSymbolAccessibility _tmp945_;
				ValaField* _tmp946_;
				ValaMemberBinding _tmp947_;
				ValaMemberBinding _tmp948_;
				ValaField* _tmp949_;
				ValaMemberBinding _tmp950_;
				ValaMemberBinding _tmp951_;
				ValaField* _tmp952_;
				ValaDataType* _tmp953_;
				ValaDataType* _tmp954_;
				_tmp942_ = member;
				f = G_TYPE_CHECK_INSTANCE_CAST (_tmp942_, VALA_TYPE_FIELD, ValaField);
				_tmp943_ = f;
				_tmp944_ = vala_symbol_get_access ((ValaSymbol*) _tmp943_);
				_tmp945_ = _tmp944_;
				access = _tmp945_;
				_tmp946_ = f;
				_tmp947_ = vala_field_get_binding (_tmp946_);
				_tmp948_ = _tmp947_;
				instance = _tmp948_ == VALA_MEMBER_BINDING_INSTANCE;
				_tmp949_ = f;
				_tmp950_ = vala_field_get_binding (_tmp949_);
				_tmp951_ = _tmp950_;
				klass = _tmp951_ == VALA_MEMBER_BINDING_CLASS;
				_tmp952_ = f;
				_tmp953_ = vala_variable_get_variable_type ((ValaVariable*) _tmp952_);
				_tmp954_ = _tmp953_;
				if (VALA_IS_GENERIC_TYPE (_tmp954_)) {
					generics = TRUE;
				}
			} else {
				ValaSymbol* _tmp955_;
				_tmp955_ = member;
				if (VALA_IS_CONSTANT (_tmp955_)) {
					ValaConstant* c = NULL;
					ValaSymbol* _tmp956_;
					ValaConstant* _tmp957_;
					ValaSymbolAccessibility _tmp958_;
					ValaSymbolAccessibility _tmp959_;
					ValaBlock* block = NULL;
					ValaConstant* _tmp960_;
					ValaSymbol* _tmp961_;
					ValaSymbol* _tmp962_;
					gboolean _tmp963_ = FALSE;
					ValaBlock* _tmp964_;
					_tmp956_ = member;
					c = G_TYPE_CHECK_INSTANCE_CAST (_tmp956_, VALA_TYPE_CONSTANT, ValaConstant);
					_tmp957_ = c;
					_tmp958_ = vala_symbol_get_access ((ValaSymbol*) _tmp957_);
					_tmp959_ = _tmp958_;
					access = _tmp959_;
					_tmp960_ = c;
					_tmp961_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp960_);
					_tmp962_ = _tmp961_;
					block = VALA_IS_BLOCK (_tmp962_) ? ((ValaBlock*) _tmp962_) : NULL;
					_tmp964_ = block;
					if (_tmp964_ != NULL) {
						ValaBlock* _tmp965_;
						ValaSymbol* _tmp966_;
						ValaSemanticAnalyzer* _tmp967_;
						ValaSemanticAnalyzer* _tmp968_;
						ValaSymbol* _tmp969_;
						ValaSymbol* _tmp970_;
						_tmp965_ = block;
						_tmp966_ = vala_semantic_analyzer_find_parent_method_or_property_accessor ((ValaSymbol*) _tmp965_);
						_tmp967_ = vala_code_context_get_analyzer (context);
						_tmp968_ = _tmp967_;
						_tmp969_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp968_);
						_tmp970_ = _tmp969_;
						_tmp963_ = _tmp966_ != _tmp970_;
					} else {
						_tmp963_ = FALSE;
					}
					if (_tmp963_) {
						ValaSourceReference* _tmp971_;
						ValaSourceReference* _tmp972_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp971_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp972_ = _tmp971_;
						vala_report_error (_tmp972_, "internal error: accessing local constants of outer methods is not supp" \
"orted yet");
						result = FALSE;
						_vala_iterable_unref0 (visited_types);
						return result;
					}
				} else {
					ValaSymbol* _tmp973_;
					_tmp973_ = member;
					if (VALA_IS_METHOD (_tmp973_)) {
						ValaMethod* m = NULL;
						ValaSymbol* _tmp974_;
						ValaMethod* _tmp975_;
						gboolean _tmp976_;
						gboolean _tmp977_;
						ValaMethod* _tmp1064_;
						ValaSymbolAccessibility _tmp1065_;
						ValaSymbolAccessibility _tmp1066_;
						ValaMethod* _tmp1067_;
						ValaMethod* _tmp1071_;
						ValaMemberBinding _tmp1072_;
						ValaMemberBinding _tmp1073_;
						ValaGenericType* generic_type = NULL;
						ValaMethod* _tmp1093_;
						ValaDataType* _tmp1094_;
						ValaDataType* _tmp1095_;
						gboolean _tmp1096_ = FALSE;
						ValaGenericType* _tmp1097_;
						_tmp974_ = member;
						m = G_TYPE_CHECK_INSTANCE_CAST (_tmp974_, VALA_TYPE_METHOD, ValaMethod);
						_tmp975_ = m;
						_tmp976_ = vala_method_get_is_async_callback (_tmp975_);
						_tmp977_ = _tmp976_;
						if (_tmp977_) {
							ValaMethod* async_method = NULL;
							ValaSemanticAnalyzer* _tmp978_;
							ValaSemanticAnalyzer* _tmp979_;
							ValaMethod* _tmp980_;
							ValaMethod* _tmp981_;
							gboolean is_valid_access = FALSE;
							ValaMethod* _tmp982_;
							ValaMethod* _tmp1009_;
							ValaSemanticAnalyzer* _tmp1010_;
							ValaSemanticAnalyzer* _tmp1011_;
							ValaMethod* _tmp1012_;
							ValaMethod* _tmp1013_;
							ValaMethod* _tmp1029_;
							ValaMethod* _tmp1030_;
							ValaMethod* _tmp1031_;
							ValaSymbol* _tmp1032_;
							ValaSymbol* _tmp1033_;
							_tmp978_ = vala_code_context_get_analyzer (context);
							_tmp979_ = _tmp978_;
							_tmp980_ = vala_semantic_analyzer_get_current_async_method (_tmp979_);
							_tmp981_ = _tmp980_;
							async_method = _tmp981_;
							is_valid_access = FALSE;
							_tmp982_ = async_method;
							if (_tmp982_ != NULL) {
								ValaMethod* _tmp983_;
								ValaMethod* _tmp984_;
								ValaMethod* _tmp985_;
								_tmp983_ = m;
								_tmp984_ = async_method;
								_tmp985_ = vala_method_get_callback_method (_tmp984_);
								if (_tmp983_ == _tmp985_) {
									is_valid_access = TRUE;
								} else {
									gboolean _tmp986_ = FALSE;
									ValaMethod* _tmp987_;
									ValaMethod* _tmp988_;
									ValaMethod* _tmp989_;
									_tmp987_ = async_method;
									_tmp988_ = vala_method_get_base_method (_tmp987_);
									_tmp989_ = _tmp988_;
									if (_tmp989_ != NULL) {
										ValaMethod* _tmp990_;
										ValaMethod* _tmp991_;
										ValaMethod* _tmp992_;
										ValaMethod* _tmp993_;
										ValaMethod* _tmp994_;
										_tmp990_ = m;
										_tmp991_ = async_method;
										_tmp992_ = vala_method_get_base_method (_tmp991_);
										_tmp993_ = _tmp992_;
										_tmp994_ = vala_method_get_callback_method (_tmp993_);
										_tmp986_ = _tmp990_ == _tmp994_;
									} else {
										_tmp986_ = FALSE;
									}
									if (_tmp986_) {
										is_valid_access = TRUE;
									} else {
										gboolean _tmp995_ = FALSE;
										ValaMethod* _tmp996_;
										ValaMethod* _tmp997_;
										ValaMethod* _tmp998_;
										_tmp996_ = async_method;
										_tmp997_ = vala_method_get_base_interface_method (_tmp996_);
										_tmp998_ = _tmp997_;
										if (_tmp998_ != NULL) {
											ValaMethod* _tmp999_;
											ValaMethod* _tmp1000_;
											ValaMethod* _tmp1001_;
											ValaMethod* _tmp1002_;
											ValaMethod* _tmp1003_;
											_tmp999_ = m;
											_tmp1000_ = async_method;
											_tmp1001_ = vala_method_get_base_interface_method (_tmp1000_);
											_tmp1002_ = _tmp1001_;
											_tmp1003_ = vala_method_get_callback_method (_tmp1002_);
											_tmp995_ = _tmp999_ == _tmp1003_;
										} else {
											_tmp995_ = FALSE;
										}
										if (_tmp995_) {
											is_valid_access = TRUE;
										}
									}
								}
							}
							if (!is_valid_access) {
								ValaSourceReference* _tmp1004_;
								ValaSourceReference* _tmp1005_;
								ValaMethod* _tmp1006_;
								gchar* _tmp1007_;
								gchar* _tmp1008_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp1004_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp1005_ = _tmp1004_;
								_tmp1006_ = m;
								_tmp1007_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1006_);
								_tmp1008_ = _tmp1007_;
								vala_report_error (_tmp1005_, "Access to async callback `%s' not allowed in this context", _tmp1008_);
								_g_free0 (_tmp1008_);
								result = FALSE;
								_vala_iterable_unref0 (visited_types);
								return result;
							}
							_tmp1009_ = async_method;
							_tmp1010_ = vala_code_context_get_analyzer (context);
							_tmp1011_ = _tmp1010_;
							_tmp1012_ = vala_semantic_analyzer_get_current_method (_tmp1011_);
							_tmp1013_ = _tmp1012_;
							if (_tmp1009_ != _tmp1013_) {
								ValaSymbol* sym = NULL;
								ValaSemanticAnalyzer* _tmp1014_;
								ValaSemanticAnalyzer* _tmp1015_;
								ValaMethod* _tmp1016_;
								ValaMethod* _tmp1017_;
								ValaMethod* _tmp1026_;
								ValaBlock* _tmp1027_;
								ValaBlock* _tmp1028_;
								_tmp1014_ = vala_code_context_get_analyzer (context);
								_tmp1015_ = _tmp1014_;
								_tmp1016_ = vala_semantic_analyzer_get_current_method (_tmp1015_);
								_tmp1017_ = _tmp1016_;
								sym = (ValaSymbol*) _tmp1017_;
								while (TRUE) {
									ValaSymbol* _tmp1018_;
									ValaMethod* _tmp1019_;
									ValaMethod* method = NULL;
									ValaSymbol* _tmp1020_;
									ValaMethod* _tmp1021_;
									ValaSymbol* _tmp1023_;
									ValaSymbol* _tmp1024_;
									ValaSymbol* _tmp1025_;
									_tmp1018_ = sym;
									_tmp1019_ = async_method;
									if (!(_tmp1018_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1019_, VALA_TYPE_SYMBOL, ValaSymbol))) {
										break;
									}
									_tmp1020_ = sym;
									method = VALA_IS_METHOD (_tmp1020_) ? ((ValaMethod*) _tmp1020_) : NULL;
									_tmp1021_ = method;
									if (_tmp1021_ != NULL) {
										ValaMethod* _tmp1022_;
										_tmp1022_ = method;
										vala_method_set_closure (_tmp1022_, TRUE);
									}
									_tmp1023_ = sym;
									_tmp1024_ = vala_symbol_get_parent_symbol (_tmp1023_);
									_tmp1025_ = _tmp1024_;
									sym = _tmp1025_;
								}
								_tmp1026_ = async_method;
								_tmp1027_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp1026_);
								_tmp1028_ = _tmp1027_;
								vala_block_set_captured (_tmp1028_, TRUE);
							}
							_tmp1029_ = async_method;
							_tmp1030_ = vala_method_get_callback_method (_tmp1029_);
							m = _tmp1030_;
							_tmp1031_ = m;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1031_);
							_tmp1032_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp1033_ = _tmp1032_;
							member = _tmp1033_;
						} else {
							ValaMethod* _tmp1034_;
							ValaMethod* _tmp1035_;
							ValaMethod* _tmp1036_;
							_tmp1034_ = m;
							_tmp1035_ = vala_method_get_base_method (_tmp1034_);
							_tmp1036_ = _tmp1035_;
							if (_tmp1036_ != NULL) {
								ValaMethod* _tmp1037_;
								ValaMethod* _tmp1038_;
								ValaMethod* _tmp1039_;
								ValaMethod* _tmp1040_;
								ValaSignal* _tmp1041_;
								ValaSignal* _tmp1042_;
								ValaSymbol* _tmp1047_;
								ValaSymbol* _tmp1048_;
								_tmp1037_ = m;
								_tmp1038_ = vala_method_get_base_method (_tmp1037_);
								_tmp1039_ = _tmp1038_;
								m = _tmp1039_;
								_tmp1040_ = m;
								_tmp1041_ = vala_method_get_signal_reference (_tmp1040_);
								_tmp1042_ = _tmp1041_;
								if (_tmp1042_ != NULL) {
									ValaMethod* _tmp1043_;
									ValaSignal* _tmp1044_;
									ValaSignal* _tmp1045_;
									_tmp1043_ = m;
									_tmp1044_ = vala_method_get_signal_reference (_tmp1043_);
									_tmp1045_ = _tmp1044_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1045_);
								} else {
									ValaMethod* _tmp1046_;
									_tmp1046_ = m;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1046_);
								}
								_tmp1047_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp1048_ = _tmp1047_;
								member = _tmp1048_;
							} else {
								ValaMethod* _tmp1049_;
								ValaMethod* _tmp1050_;
								ValaMethod* _tmp1051_;
								_tmp1049_ = m;
								_tmp1050_ = vala_method_get_base_interface_method (_tmp1049_);
								_tmp1051_ = _tmp1050_;
								if (_tmp1051_ != NULL) {
									ValaMethod* _tmp1052_;
									ValaMethod* _tmp1053_;
									ValaMethod* _tmp1054_;
									ValaMethod* _tmp1055_;
									ValaSignal* _tmp1056_;
									ValaSignal* _tmp1057_;
									ValaSymbol* _tmp1062_;
									ValaSymbol* _tmp1063_;
									_tmp1052_ = m;
									_tmp1053_ = vala_method_get_base_interface_method (_tmp1052_);
									_tmp1054_ = _tmp1053_;
									m = _tmp1054_;
									_tmp1055_ = m;
									_tmp1056_ = vala_method_get_signal_reference (_tmp1055_);
									_tmp1057_ = _tmp1056_;
									if (_tmp1057_ != NULL) {
										ValaMethod* _tmp1058_;
										ValaSignal* _tmp1059_;
										ValaSignal* _tmp1060_;
										_tmp1058_ = m;
										_tmp1059_ = vala_method_get_signal_reference (_tmp1058_);
										_tmp1060_ = _tmp1059_;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1060_);
									} else {
										ValaMethod* _tmp1061_;
										_tmp1061_ = m;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1061_);
									}
									_tmp1062_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1063_ = _tmp1062_;
									member = _tmp1063_;
								}
							}
						}
						_tmp1064_ = m;
						_tmp1065_ = vala_symbol_get_access ((ValaSymbol*) _tmp1064_);
						_tmp1066_ = _tmp1065_;
						access = _tmp1066_;
						_tmp1067_ = m;
						if (!VALA_IS_CREATION_METHOD (_tmp1067_)) {
							ValaMethod* _tmp1068_;
							ValaMemberBinding _tmp1069_;
							ValaMemberBinding _tmp1070_;
							_tmp1068_ = m;
							_tmp1069_ = vala_method_get_binding (_tmp1068_);
							_tmp1070_ = _tmp1069_;
							instance = _tmp1070_ == VALA_MEMBER_BINDING_INSTANCE;
						}
						_tmp1071_ = m;
						_tmp1072_ = vala_method_get_binding (_tmp1071_);
						_tmp1073_ = _tmp1072_;
						klass = _tmp1073_ == VALA_MEMBER_BINDING_CLASS;
						{
							ValaList* _param_list = NULL;
							ValaMethod* _tmp1074_;
							ValaList* _tmp1075_;
							gint _param_size = 0;
							ValaList* _tmp1076_;
							gint _tmp1077_;
							gint _tmp1078_;
							gint _param_index = 0;
							_tmp1074_ = m;
							_tmp1075_ = vala_callable_get_parameters ((ValaCallable*) _tmp1074_);
							_param_list = _tmp1075_;
							_tmp1076_ = _param_list;
							_tmp1077_ = vala_collection_get_size ((ValaCollection*) _tmp1076_);
							_tmp1078_ = _tmp1077_;
							_param_size = _tmp1078_;
							_param_index = -1;
							while (TRUE) {
								gint _tmp1079_;
								gint _tmp1080_;
								ValaParameter* param = NULL;
								ValaList* _tmp1081_;
								gpointer _tmp1082_;
								ValaGenericType* generic_type = NULL;
								ValaParameter* _tmp1083_;
								ValaDataType* _tmp1084_;
								ValaDataType* _tmp1085_;
								gboolean _tmp1086_ = FALSE;
								ValaGenericType* _tmp1087_;
								_param_index = _param_index + 1;
								_tmp1079_ = _param_index;
								_tmp1080_ = _param_size;
								if (!(_tmp1079_ < _tmp1080_)) {
									break;
								}
								_tmp1081_ = _param_list;
								_tmp1082_ = vala_list_get (_tmp1081_, _param_index);
								param = (ValaParameter*) _tmp1082_;
								_tmp1083_ = param;
								_tmp1084_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1083_);
								_tmp1085_ = _tmp1084_;
								generic_type = VALA_IS_GENERIC_TYPE (_tmp1085_) ? ((ValaGenericType*) _tmp1085_) : NULL;
								_tmp1087_ = generic_type;
								if (_tmp1087_ != NULL) {
									ValaGenericType* _tmp1088_;
									ValaTypeParameter* _tmp1089_;
									ValaTypeParameter* _tmp1090_;
									ValaSymbol* _tmp1091_;
									ValaSymbol* _tmp1092_;
									_tmp1088_ = generic_type;
									_tmp1089_ = vala_generic_type_get_type_parameter (_tmp1088_);
									_tmp1090_ = _tmp1089_;
									_tmp1091_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1090_);
									_tmp1092_ = _tmp1091_;
									_tmp1086_ = VALA_IS_TYPESYMBOL (_tmp1092_);
								} else {
									_tmp1086_ = FALSE;
								}
								if (_tmp1086_) {
									generics = TRUE;
									_vala_code_node_unref0 (param);
									break;
								}
								_vala_code_node_unref0 (param);
							}
						}
						_tmp1093_ = m;
						_tmp1094_ = vala_callable_get_return_type ((ValaCallable*) _tmp1093_);
						_tmp1095_ = _tmp1094_;
						generic_type = VALA_IS_GENERIC_TYPE (_tmp1095_) ? ((ValaGenericType*) _tmp1095_) : NULL;
						_tmp1097_ = generic_type;
						if (_tmp1097_ != NULL) {
							ValaGenericType* _tmp1098_;
							ValaTypeParameter* _tmp1099_;
							ValaTypeParameter* _tmp1100_;
							ValaSymbol* _tmp1101_;
							ValaSymbol* _tmp1102_;
							_tmp1098_ = generic_type;
							_tmp1099_ = vala_generic_type_get_type_parameter (_tmp1098_);
							_tmp1100_ = _tmp1099_;
							_tmp1101_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1100_);
							_tmp1102_ = _tmp1101_;
							_tmp1096_ = VALA_IS_TYPESYMBOL (_tmp1102_);
						} else {
							_tmp1096_ = FALSE;
						}
						if (_tmp1096_) {
							generics = TRUE;
						}
					} else {
						ValaSymbol* _tmp1103_;
						_tmp1103_ = member;
						if (VALA_IS_PROPERTY (_tmp1103_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp1104_;
							ValaProperty* _tmp1105_;
							ValaProperty* _tmp1106_;
							ValaProperty* _tmp1107_;
							ValaProperty* _tmp1108_;
							ValaProperty* _tmp1124_;
							ValaSymbolAccessibility _tmp1125_;
							ValaSymbolAccessibility _tmp1126_;
							gboolean _tmp1127_;
							gboolean _tmp1128_;
							ValaProperty* _tmp1227_;
							ValaMemberBinding _tmp1228_;
							ValaMemberBinding _tmp1229_;
							ValaProperty* _tmp1230_;
							ValaDataType* _tmp1231_;
							ValaDataType* _tmp1232_;
							_tmp1104_ = member;
							prop = G_TYPE_CHECK_INSTANCE_CAST (_tmp1104_, VALA_TYPE_PROPERTY, ValaProperty);
							_tmp1105_ = prop;
							if (!vala_code_node_check ((ValaCodeNode*) _tmp1105_, context)) {
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								result = FALSE;
								_vala_iterable_unref0 (visited_types);
								return result;
							}
							_tmp1106_ = prop;
							_tmp1107_ = vala_property_get_base_property (_tmp1106_);
							_tmp1108_ = _tmp1107_;
							if (_tmp1108_ != NULL) {
								ValaProperty* _tmp1109_;
								ValaProperty* _tmp1110_;
								ValaProperty* _tmp1111_;
								ValaProperty* _tmp1112_;
								ValaSymbol* _tmp1113_;
								ValaSymbol* _tmp1114_;
								_tmp1109_ = prop;
								_tmp1110_ = vala_property_get_base_property (_tmp1109_);
								_tmp1111_ = _tmp1110_;
								prop = _tmp1111_;
								_tmp1112_ = prop;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1112_);
								_tmp1113_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp1114_ = _tmp1113_;
								member = _tmp1114_;
							} else {
								ValaProperty* _tmp1115_;
								ValaProperty* _tmp1116_;
								ValaProperty* _tmp1117_;
								_tmp1115_ = prop;
								_tmp1116_ = vala_property_get_base_interface_property (_tmp1115_);
								_tmp1117_ = _tmp1116_;
								if (_tmp1117_ != NULL) {
									ValaProperty* _tmp1118_;
									ValaProperty* _tmp1119_;
									ValaProperty* _tmp1120_;
									ValaProperty* _tmp1121_;
									ValaSymbol* _tmp1122_;
									ValaSymbol* _tmp1123_;
									_tmp1118_ = prop;
									_tmp1119_ = vala_property_get_base_interface_property (_tmp1118_);
									_tmp1120_ = _tmp1119_;
									prop = _tmp1120_;
									_tmp1121_ = prop;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1121_);
									_tmp1122_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1123_ = _tmp1122_;
									member = _tmp1123_;
								}
							}
							_tmp1124_ = prop;
							_tmp1125_ = vala_symbol_get_access ((ValaSymbol*) _tmp1124_);
							_tmp1126_ = _tmp1125_;
							access = _tmp1126_;
							_tmp1127_ = vala_expression_get_lvalue ((ValaExpression*) self);
							_tmp1128_ = _tmp1127_;
							if (_tmp1128_) {
								ValaProperty* _tmp1129_;
								ValaPropertyAccessor* _tmp1130_;
								ValaPropertyAccessor* _tmp1131_;
								ValaProperty* _tmp1175_;
								ValaSymbolAccessibility _tmp1176_;
								ValaSymbolAccessibility _tmp1177_;
								_tmp1129_ = prop;
								_tmp1130_ = vala_property_get_set_accessor (_tmp1129_);
								_tmp1131_ = _tmp1130_;
								if (_tmp1131_ == NULL) {
									ValaSourceReference* _tmp1132_;
									ValaSourceReference* _tmp1133_;
									ValaProperty* _tmp1134_;
									gchar* _tmp1135_;
									gchar* _tmp1136_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp1132_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp1133_ = _tmp1132_;
									_tmp1134_ = prop;
									_tmp1135_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1134_);
									_tmp1136_ = _tmp1135_;
									vala_report_error (_tmp1133_, "Property `%s' is read-only", _tmp1136_);
									_g_free0 (_tmp1136_);
									result = FALSE;
									_vala_iterable_unref0 (visited_types);
									return result;
								} else {
									gboolean _tmp1137_ = FALSE;
									ValaProperty* _tmp1138_;
									ValaPropertyAccessor* _tmp1139_;
									ValaPropertyAccessor* _tmp1140_;
									gboolean _tmp1141_;
									gboolean _tmp1142_;
									_tmp1138_ = prop;
									_tmp1139_ = vala_property_get_set_accessor (_tmp1138_);
									_tmp1140_ = _tmp1139_;
									_tmp1141_ = vala_property_accessor_get_writable (_tmp1140_);
									_tmp1142_ = _tmp1141_;
									if (!_tmp1142_) {
										ValaProperty* _tmp1143_;
										ValaPropertyAccessor* _tmp1144_;
										ValaPropertyAccessor* _tmp1145_;
										gboolean _tmp1146_;
										gboolean _tmp1147_;
										_tmp1143_ = prop;
										_tmp1144_ = vala_property_get_set_accessor (_tmp1143_);
										_tmp1145_ = _tmp1144_;
										_tmp1146_ = vala_property_accessor_get_construction (_tmp1145_);
										_tmp1147_ = _tmp1146_;
										_tmp1137_ = _tmp1147_;
									} else {
										_tmp1137_ = FALSE;
									}
									if (_tmp1137_) {
										ValaSemanticAnalyzer* _tmp1148_;
										ValaSemanticAnalyzer* _tmp1149_;
										ValaMethod* _tmp1150_;
										_tmp1148_ = vala_code_context_get_analyzer (context);
										_tmp1149_ = _tmp1148_;
										_tmp1150_ = vala_semantic_analyzer_find_current_method (_tmp1149_);
										if (VALA_IS_CREATION_METHOD (_tmp1150_)) {
											ValaSourceReference* _tmp1151_;
											ValaSourceReference* _tmp1152_;
											vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
											_tmp1151_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
											_tmp1152_ = _tmp1151_;
											vala_report_error (_tmp1152_, "Cannot assign to construct-only properties, use Object (property: valu" \
"e) constructor chain up");
											result = FALSE;
											_vala_iterable_unref0 (visited_types);
											return result;
										} else {
											ValaSemanticAnalyzer* _tmp1153_;
											ValaSemanticAnalyzer* _tmp1154_;
											_tmp1153_ = vala_code_context_get_analyzer (context);
											_tmp1154_ = _tmp1153_;
											if (vala_semantic_analyzer_is_in_constructor (_tmp1154_)) {
												ValaSemanticAnalyzer* _tmp1155_;
												ValaSemanticAnalyzer* _tmp1156_;
												ValaTypeSymbol* _tmp1157_;
												ValaTypeSymbol* _tmp1158_;
												ValaProperty* _tmp1159_;
												ValaSymbol* _tmp1160_;
												ValaSymbol* _tmp1161_;
												_tmp1155_ = vala_code_context_get_analyzer (context);
												_tmp1156_ = _tmp1155_;
												_tmp1157_ = vala_semantic_analyzer_get_current_type_symbol (_tmp1156_);
												_tmp1158_ = _tmp1157_;
												_tmp1159_ = prop;
												_tmp1160_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1159_);
												_tmp1161_ = _tmp1160_;
												if (!vala_typesymbol_is_subtype_of (_tmp1158_, G_TYPE_CHECK_INSTANCE_CAST (_tmp1161_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol))) {
													ValaSourceReference* _tmp1162_;
													ValaSourceReference* _tmp1163_;
													ValaProperty* _tmp1164_;
													gchar* _tmp1165_;
													gchar* _tmp1166_;
													ValaSemanticAnalyzer* _tmp1167_;
													ValaSemanticAnalyzer* _tmp1168_;
													ValaTypeSymbol* _tmp1169_;
													ValaTypeSymbol* _tmp1170_;
													gchar* _tmp1171_;
													gchar* _tmp1172_;
													vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
													_tmp1162_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
													_tmp1163_ = _tmp1162_;
													_tmp1164_ = prop;
													_tmp1165_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1164_);
													_tmp1166_ = _tmp1165_;
													_tmp1167_ = vala_code_context_get_analyzer (context);
													_tmp1168_ = _tmp1167_;
													_tmp1169_ = vala_semantic_analyzer_get_current_type_symbol (_tmp1168_);
													_tmp1170_ = _tmp1169_;
													_tmp1171_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1170_);
													_tmp1172_ = _tmp1171_;
													vala_report_error (_tmp1163_, "Cannot assign to construct-only property `%s' in `construct' of `%s'", _tmp1166_, _tmp1172_);
													_g_free0 (_tmp1172_);
													_g_free0 (_tmp1166_);
													result = FALSE;
													_vala_iterable_unref0 (visited_types);
													return result;
												}
											} else {
												ValaSourceReference* _tmp1173_;
												ValaSourceReference* _tmp1174_;
												vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
												_tmp1173_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
												_tmp1174_ = _tmp1173_;
												vala_report_error (_tmp1174_, "Cannot assign to construct-only property in this context");
												result = FALSE;
												_vala_iterable_unref0 (visited_types);
												return result;
											}
										}
									}
								}
								_tmp1175_ = prop;
								_tmp1176_ = vala_symbol_get_access ((ValaSymbol*) _tmp1175_);
								_tmp1177_ = _tmp1176_;
								if (_tmp1177_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp1178_;
									ValaPropertyAccessor* _tmp1179_;
									ValaPropertyAccessor* _tmp1180_;
									ValaSymbolAccessibility _tmp1181_;
									ValaSymbolAccessibility _tmp1182_;
									_tmp1178_ = prop;
									_tmp1179_ = vala_property_get_set_accessor (_tmp1178_);
									_tmp1180_ = _tmp1179_;
									_tmp1181_ = vala_symbol_get_access ((ValaSymbol*) _tmp1180_);
									_tmp1182_ = _tmp1181_;
									access = _tmp1182_;
								} else {
									gboolean _tmp1183_ = FALSE;
									ValaProperty* _tmp1184_;
									ValaSymbolAccessibility _tmp1185_;
									ValaSymbolAccessibility _tmp1186_;
									_tmp1184_ = prop;
									_tmp1185_ = vala_symbol_get_access ((ValaSymbol*) _tmp1184_);
									_tmp1186_ = _tmp1185_;
									if (_tmp1186_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp1187_;
										ValaPropertyAccessor* _tmp1188_;
										ValaPropertyAccessor* _tmp1189_;
										ValaSymbolAccessibility _tmp1190_;
										ValaSymbolAccessibility _tmp1191_;
										_tmp1187_ = prop;
										_tmp1188_ = vala_property_get_set_accessor (_tmp1187_);
										_tmp1189_ = _tmp1188_;
										_tmp1190_ = vala_symbol_get_access ((ValaSymbol*) _tmp1189_);
										_tmp1191_ = _tmp1190_;
										_tmp1183_ = _tmp1191_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp1183_ = FALSE;
									}
									if (_tmp1183_) {
										ValaProperty* _tmp1192_;
										ValaPropertyAccessor* _tmp1193_;
										ValaPropertyAccessor* _tmp1194_;
										ValaSymbolAccessibility _tmp1195_;
										ValaSymbolAccessibility _tmp1196_;
										_tmp1192_ = prop;
										_tmp1193_ = vala_property_get_set_accessor (_tmp1192_);
										_tmp1194_ = _tmp1193_;
										_tmp1195_ = vala_symbol_get_access ((ValaSymbol*) _tmp1194_);
										_tmp1196_ = _tmp1195_;
										access = _tmp1196_;
									}
								}
							} else {
								ValaProperty* _tmp1197_;
								ValaPropertyAccessor* _tmp1198_;
								ValaPropertyAccessor* _tmp1199_;
								ValaProperty* _tmp1205_;
								ValaSymbolAccessibility _tmp1206_;
								ValaSymbolAccessibility _tmp1207_;
								_tmp1197_ = prop;
								_tmp1198_ = vala_property_get_get_accessor (_tmp1197_);
								_tmp1199_ = _tmp1198_;
								if (_tmp1199_ == NULL) {
									ValaSourceReference* _tmp1200_;
									ValaSourceReference* _tmp1201_;
									ValaProperty* _tmp1202_;
									gchar* _tmp1203_;
									gchar* _tmp1204_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp1200_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp1201_ = _tmp1200_;
									_tmp1202_ = prop;
									_tmp1203_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1202_);
									_tmp1204_ = _tmp1203_;
									vala_report_error (_tmp1201_, "Property `%s' is write-only", _tmp1204_);
									_g_free0 (_tmp1204_);
									result = FALSE;
									_vala_iterable_unref0 (visited_types);
									return result;
								}
								_tmp1205_ = prop;
								_tmp1206_ = vala_symbol_get_access ((ValaSymbol*) _tmp1205_);
								_tmp1207_ = _tmp1206_;
								if (_tmp1207_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp1208_;
									ValaPropertyAccessor* _tmp1209_;
									ValaPropertyAccessor* _tmp1210_;
									ValaSymbolAccessibility _tmp1211_;
									ValaSymbolAccessibility _tmp1212_;
									_tmp1208_ = prop;
									_tmp1209_ = vala_property_get_get_accessor (_tmp1208_);
									_tmp1210_ = _tmp1209_;
									_tmp1211_ = vala_symbol_get_access ((ValaSymbol*) _tmp1210_);
									_tmp1212_ = _tmp1211_;
									access = _tmp1212_;
								} else {
									gboolean _tmp1213_ = FALSE;
									ValaProperty* _tmp1214_;
									ValaSymbolAccessibility _tmp1215_;
									ValaSymbolAccessibility _tmp1216_;
									_tmp1214_ = prop;
									_tmp1215_ = vala_symbol_get_access ((ValaSymbol*) _tmp1214_);
									_tmp1216_ = _tmp1215_;
									if (_tmp1216_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp1217_;
										ValaPropertyAccessor* _tmp1218_;
										ValaPropertyAccessor* _tmp1219_;
										ValaSymbolAccessibility _tmp1220_;
										ValaSymbolAccessibility _tmp1221_;
										_tmp1217_ = prop;
										_tmp1218_ = vala_property_get_get_accessor (_tmp1217_);
										_tmp1219_ = _tmp1218_;
										_tmp1220_ = vala_symbol_get_access ((ValaSymbol*) _tmp1219_);
										_tmp1221_ = _tmp1220_;
										_tmp1213_ = _tmp1221_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp1213_ = FALSE;
									}
									if (_tmp1213_) {
										ValaProperty* _tmp1222_;
										ValaPropertyAccessor* _tmp1223_;
										ValaPropertyAccessor* _tmp1224_;
										ValaSymbolAccessibility _tmp1225_;
										ValaSymbolAccessibility _tmp1226_;
										_tmp1222_ = prop;
										_tmp1223_ = vala_property_get_get_accessor (_tmp1222_);
										_tmp1224_ = _tmp1223_;
										_tmp1225_ = vala_symbol_get_access ((ValaSymbol*) _tmp1224_);
										_tmp1226_ = _tmp1225_;
										access = _tmp1226_;
									}
								}
							}
							_tmp1227_ = prop;
							_tmp1228_ = vala_property_get_binding (_tmp1227_);
							_tmp1229_ = _tmp1228_;
							instance = _tmp1229_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp1230_ = prop;
							_tmp1231_ = vala_property_get_property_type (_tmp1230_);
							_tmp1232_ = _tmp1231_;
							if (VALA_IS_GENERIC_TYPE (_tmp1232_)) {
								generics = TRUE;
							}
						} else {
							ValaSymbol* _tmp1233_;
							_tmp1233_ = member;
							if (VALA_IS_SIGNAL (_tmp1233_)) {
								ValaSymbol* _tmp1234_;
								ValaSymbolAccessibility _tmp1235_;
								ValaSymbolAccessibility _tmp1236_;
								instance = TRUE;
								_tmp1234_ = member;
								_tmp1235_ = vala_symbol_get_access (_tmp1234_);
								_tmp1236_ = _tmp1235_;
								access = _tmp1236_;
							} else {
								gboolean _tmp1237_ = FALSE;
								gboolean _tmp1238_;
								_tmp1238_ = self->priv->_creation_member;
								if (!_tmp1238_) {
									ValaSymbol* _tmp1239_;
									_tmp1239_ = member;
									_tmp1237_ = VALA_IS_ERROR_CODE (_tmp1239_);
								} else {
									_tmp1237_ = FALSE;
								}
								if (_tmp1237_) {
									ValaSymbol* _tmp1240_;
									ValaConstant* _tmp1241_;
									ValaConstant* _tmp1242_;
									ValaSymbol* _tmp1243_;
									ValaSymbol* _tmp1244_;
									_tmp1240_ = member;
									_tmp1241_ = vala_error_code_get_code (G_TYPE_CHECK_INSTANCE_CAST (_tmp1240_, VALA_TYPE_ERROR_CODE, ValaErrorCode));
									_tmp1242_ = _tmp1241_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1242_);
									_tmp1243_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1244_ = _tmp1243_;
									member = _tmp1244_;
								}
							}
						}
					}
				}
			}
		}
	}
	parent = (ValaCodeNode*) self;
	while (TRUE) {
		ValaCodeNode* _tmp1245_;
		ValaSymbol* _tmp1246_;
		ValaCodeNode* _tmp1247_;
		ValaCodeNode* _tmp1248_;
		ValaCodeNode* _tmp1249_;
		gboolean _tmp1250_ = FALSE;
		ValaCodeNode* _tmp1251_;
		_tmp1245_ = parent;
		_tmp1246_ = member;
		if (!(_tmp1245_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1246_, VALA_TYPE_CODE_NODE, ValaCodeNode))) {
			break;
		}
		_tmp1247_ = parent;
		_tmp1248_ = vala_code_node_get_parent_node (_tmp1247_);
		_tmp1249_ = _tmp1248_;
		parent = _tmp1249_;
		_tmp1251_ = parent;
		if (_tmp1251_ == NULL) {
			_tmp1250_ = TRUE;
		} else {
			ValaCodeNode* _tmp1252_;
			ValaSymbol* _tmp1253_;
			_tmp1252_ = parent;
			_tmp1253_ = member;
			_tmp1250_ = _tmp1252_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1253_, VALA_TYPE_CODE_NODE, ValaCodeNode);
		}
		if (_tmp1250_) {
			break;
		}
	}
	_tmp1254_ = parent;
	_tmp1255_ = member;
	if (_tmp1254_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1255_, VALA_TYPE_CODE_NODE, ValaCodeNode)) {
		ValaSymbol* _tmp1256_;
		_tmp1256_ = member;
		vala_symbol_set_used (_tmp1256_, TRUE);
	}
	_tmp1257_ = member;
	_tmp1258_ = vala_symbol_get_version (_tmp1257_);
	_tmp1259_ = _tmp1258_;
	_tmp1260_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp1261_ = _tmp1260_;
	vala_version_attribute_check (_tmp1259_, context, _tmp1261_);
	_tmp1263_ = access;
	if (_tmp1263_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
		ValaSymbol* _tmp1264_;
		ValaSymbol* _tmp1265_;
		ValaSymbol* _tmp1266_;
		_tmp1264_ = member;
		_tmp1265_ = vala_symbol_get_parent_symbol (_tmp1264_);
		_tmp1266_ = _tmp1265_;
		_tmp1262_ = VALA_IS_TYPESYMBOL (_tmp1266_);
	} else {
		_tmp1262_ = FALSE;
	}
	if (_tmp1262_) {
		ValaTypeSymbol* target_type = NULL;
		ValaSymbol* _tmp1267_;
		ValaSymbol* _tmp1268_;
		ValaSymbol* _tmp1269_;
		gboolean in_subtype = FALSE;
		_tmp1267_ = member;
		_tmp1268_ = vala_symbol_get_parent_symbol (_tmp1267_);
		_tmp1269_ = _tmp1268_;
		target_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp1269_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
		in_subtype = FALSE;
		{
			ValaSymbol* this_symbol = NULL;
			ValaSemanticAnalyzer* _tmp1270_;
			ValaSemanticAnalyzer* _tmp1271_;
			ValaSymbol* _tmp1272_;
			ValaSymbol* _tmp1273_;
			ValaSymbol* _tmp1274_;
			_tmp1270_ = vala_code_context_get_analyzer (context);
			_tmp1271_ = _tmp1270_;
			_tmp1272_ = vala_semantic_analyzer_get_current_symbol (_tmp1271_);
			_tmp1273_ = _tmp1272_;
			_tmp1274_ = _vala_code_node_ref0 (_tmp1273_);
			this_symbol = _tmp1274_;
			{
				gboolean _tmp1275_ = FALSE;
				_tmp1275_ = TRUE;
				while (TRUE) {
					ValaSymbol* _tmp1280_;
					ValaSymbol* _tmp1281_;
					ValaTypeSymbol* _tmp1282_;
					ValaClass* cl = NULL;
					ValaSymbol* _tmp1283_;
					gboolean _tmp1284_ = FALSE;
					ValaClass* _tmp1285_;
					if (!_tmp1275_) {
						ValaSymbol* _tmp1276_;
						ValaSymbol* _tmp1277_;
						ValaSymbol* _tmp1278_;
						ValaSymbol* _tmp1279_;
						_tmp1276_ = this_symbol;
						_tmp1277_ = vala_symbol_get_parent_symbol (_tmp1276_);
						_tmp1278_ = _tmp1277_;
						_tmp1279_ = _vala_code_node_ref0 (_tmp1278_);
						_vala_code_node_unref0 (this_symbol);
						this_symbol = _tmp1279_;
					}
					_tmp1275_ = FALSE;
					_tmp1280_ = this_symbol;
					if (!(_tmp1280_ != NULL)) {
						break;
					}
					_tmp1281_ = this_symbol;
					_tmp1282_ = target_type;
					if (_tmp1281_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1282_, VALA_TYPE_SYMBOL, ValaSymbol)) {
						in_subtype = TRUE;
						break;
					}
					_tmp1283_ = this_symbol;
					cl = VALA_IS_CLASS (_tmp1283_) ? ((ValaClass*) _tmp1283_) : NULL;
					_tmp1285_ = cl;
					if (_tmp1285_ != NULL) {
						ValaClass* _tmp1286_;
						ValaTypeSymbol* _tmp1287_;
						_tmp1286_ = cl;
						_tmp1287_ = target_type;
						_tmp1284_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp1286_, _tmp1287_);
					} else {
						_tmp1284_ = FALSE;
					}
					if (_tmp1284_) {
						in_subtype = TRUE;
						break;
					}
				}
			}
			_vala_code_node_unref0 (this_symbol);
		}
		if (!in_subtype) {
			ValaSourceReference* _tmp1288_;
			ValaSourceReference* _tmp1289_;
			ValaSymbol* _tmp1290_;
			gchar* _tmp1291_;
			gchar* _tmp1292_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1288_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1289_ = _tmp1288_;
			_tmp1290_ = member;
			_tmp1291_ = vala_symbol_get_full_name (_tmp1290_);
			_tmp1292_ = _tmp1291_;
			vala_report_error (_tmp1289_, "Access to protected member `%s' denied", _tmp1292_);
			_g_free0 (_tmp1292_);
			result = FALSE;
			_vala_iterable_unref0 (visited_types);
			return result;
		}
	} else {
		ValaSymbolAccessibility _tmp1293_;
		_tmp1293_ = access;
		if (_tmp1293_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaSymbol* target_type = NULL;
			ValaSymbol* _tmp1294_;
			ValaSymbol* _tmp1295_;
			ValaSymbol* _tmp1296_;
			gboolean in_target_type = FALSE;
			_tmp1294_ = member;
			_tmp1295_ = vala_symbol_get_parent_symbol (_tmp1294_);
			_tmp1296_ = _tmp1295_;
			target_type = _tmp1296_;
			in_target_type = FALSE;
			{
				ValaSymbol* this_symbol = NULL;
				ValaSemanticAnalyzer* _tmp1297_;
				ValaSemanticAnalyzer* _tmp1298_;
				ValaSymbol* _tmp1299_;
				ValaSymbol* _tmp1300_;
				ValaSymbol* _tmp1301_;
				_tmp1297_ = vala_code_context_get_analyzer (context);
				_tmp1298_ = _tmp1297_;
				_tmp1299_ = vala_semantic_analyzer_get_current_symbol (_tmp1298_);
				_tmp1300_ = _tmp1299_;
				_tmp1301_ = _vala_code_node_ref0 (_tmp1300_);
				this_symbol = _tmp1301_;
				{
					gboolean _tmp1302_ = FALSE;
					_tmp1302_ = TRUE;
					while (TRUE) {
						ValaSymbol* _tmp1307_;
						ValaSymbol* _tmp1308_;
						ValaSymbol* _tmp1309_;
						if (!_tmp1302_) {
							ValaSymbol* _tmp1303_;
							ValaSymbol* _tmp1304_;
							ValaSymbol* _tmp1305_;
							ValaSymbol* _tmp1306_;
							_tmp1303_ = this_symbol;
							_tmp1304_ = vala_symbol_get_parent_symbol (_tmp1303_);
							_tmp1305_ = _tmp1304_;
							_tmp1306_ = _vala_code_node_ref0 (_tmp1305_);
							_vala_code_node_unref0 (this_symbol);
							this_symbol = _tmp1306_;
						}
						_tmp1302_ = FALSE;
						_tmp1307_ = this_symbol;
						if (!(_tmp1307_ != NULL)) {
							break;
						}
						_tmp1308_ = target_type;
						_tmp1309_ = this_symbol;
						if (_tmp1308_ == _tmp1309_) {
							in_target_type = TRUE;
							break;
						}
					}
				}
				_vala_code_node_unref0 (this_symbol);
			}
			if (!in_target_type) {
				ValaSourceReference* _tmp1310_;
				ValaSourceReference* _tmp1311_;
				ValaSymbol* _tmp1312_;
				gchar* _tmp1313_;
				gchar* _tmp1314_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp1310_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1311_ = _tmp1310_;
				_tmp1312_ = member;
				_tmp1313_ = vala_symbol_get_full_name (_tmp1312_);
				_tmp1314_ = _tmp1313_;
				vala_report_error (_tmp1311_, "Access to private member `%s' denied", _tmp1314_);
				_g_free0 (_tmp1314_);
				result = FALSE;
				_vala_iterable_unref0 (visited_types);
				return result;
			}
		}
	}
	if (generics) {
		ValaExpression* _tmp1316_;
		ValaExpression* _tmp1317_;
		_tmp1316_ = vala_member_access_get_inner (self);
		_tmp1317_ = _tmp1316_;
		_tmp1315_ = _tmp1317_ != NULL;
	} else {
		_tmp1315_ = FALSE;
	}
	if (_tmp1315_) {
		ValaDataType* instance_type = NULL;
		ValaExpression* _tmp1318_;
		ValaExpression* _tmp1319_;
		ValaDataType* _tmp1320_;
		ValaDataType* _tmp1321_;
		ValaPointerType* pointer_type = NULL;
		ValaExpression* _tmp1322_;
		ValaExpression* _tmp1323_;
		ValaDataType* _tmp1324_;
		ValaDataType* _tmp1325_;
		ValaPointerType* _tmp1326_;
		ValaObjectType* object_type = NULL;
		ValaDataType* _tmp1330_;
		gboolean _tmp1331_ = FALSE;
		gboolean _tmp1332_ = FALSE;
		ValaObjectType* _tmp1333_;
		_tmp1318_ = vala_member_access_get_inner (self);
		_tmp1319_ = _tmp1318_;
		_tmp1320_ = vala_expression_get_value_type (_tmp1319_);
		_tmp1321_ = _tmp1320_;
		instance_type = _tmp1321_;
		_tmp1322_ = vala_member_access_get_inner (self);
		_tmp1323_ = _tmp1322_;
		_tmp1324_ = vala_expression_get_value_type (_tmp1323_);
		_tmp1325_ = _tmp1324_;
		pointer_type = VALA_IS_POINTER_TYPE (_tmp1325_) ? ((ValaPointerType*) _tmp1325_) : NULL;
		_tmp1326_ = pointer_type;
		if (_tmp1326_ != NULL) {
			ValaPointerType* _tmp1327_;
			ValaDataType* _tmp1328_;
			ValaDataType* _tmp1329_;
			_tmp1327_ = pointer_type;
			_tmp1328_ = vala_pointer_type_get_base_type (_tmp1327_);
			_tmp1329_ = _tmp1328_;
			instance_type = _tmp1329_;
		}
		_tmp1330_ = instance_type;
		object_type = VALA_IS_OBJECT_TYPE (_tmp1330_) ? ((ValaObjectType*) _tmp1330_) : NULL;
		_tmp1333_ = object_type;
		if (_tmp1333_ != NULL) {
			ValaObjectType* _tmp1334_;
			ValaObjectTypeSymbol* _tmp1335_;
			ValaObjectTypeSymbol* _tmp1336_;
			_tmp1334_ = object_type;
			_tmp1335_ = vala_object_type_get_object_type_symbol (_tmp1334_);
			_tmp1336_ = _tmp1335_;
			_tmp1332_ = vala_object_type_symbol_has_type_parameters (_tmp1336_);
		} else {
			_tmp1332_ = FALSE;
		}
		if (_tmp1332_) {
			ValaDataType* _tmp1337_;
			_tmp1337_ = instance_type;
			_tmp1331_ = !vala_data_type_has_type_arguments (_tmp1337_);
		} else {
			_tmp1331_ = FALSE;
		}
		if (_tmp1331_) {
			ValaExpression* _tmp1338_;
			ValaExpression* _tmp1339_;
			ValaSourceReference* _tmp1340_;
			ValaSourceReference* _tmp1341_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1338_ = vala_member_access_get_inner (self);
			_tmp1339_ = _tmp1338_;
			_tmp1340_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1339_);
			_tmp1341_ = _tmp1340_;
			vala_report_error (_tmp1341_, "missing generic type arguments");
			result = FALSE;
			_vala_iterable_unref0 (visited_types);
			return result;
		}
	}
	if (instance) {
		_tmp1343_ = !may_access_instance_members;
	} else {
		_tmp1343_ = FALSE;
	}
	if (_tmp1343_) {
		_tmp1342_ = TRUE;
	} else {
		gboolean _tmp1344_ = FALSE;
		if (klass) {
			_tmp1344_ = !may_access_klass_members;
		} else {
			_tmp1344_ = FALSE;
		}
		_tmp1342_ = _tmp1344_;
	}
	if (_tmp1342_) {
		ValaSymbol* _tmp1345_;
		ValaSymbol* _tmp1346_;
		ValaDataType* _tmp1381_;
		ValaDataType* _tmp1382_;
		vala_member_access_set_prototype_access (self, TRUE);
		_tmp1345_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1346_ = _tmp1345_;
		if (VALA_IS_METHOD (_tmp1346_)) {
			ValaSemanticAnalyzer* _tmp1347_;
			ValaSemanticAnalyzer* _tmp1348_;
			ValaSymbol* _tmp1349_;
			ValaSymbol* _tmp1350_;
			gboolean _tmp1351_;
			gboolean _tmp1352_;
			ValaDataType* _tmp1353_;
			ValaDataType* _tmp1354_;
			ValaDataType* _tmp1355_;
			ValaDataType* _tmp1356_;
			ValaSourceReference* _tmp1357_;
			ValaSourceReference* _tmp1358_;
			_tmp1347_ = vala_code_context_get_analyzer (context);
			_tmp1348_ = _tmp1347_;
			_tmp1349_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1350_ = _tmp1349_;
			_tmp1351_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp1352_ = _tmp1351_;
			_tmp1353_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1348_, _tmp1350_, _tmp1352_);
			_tmp1354_ = _tmp1353_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1354_);
			_vala_code_node_unref0 (_tmp1354_);
			_tmp1355_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp1356_ = _tmp1355_;
			_tmp1357_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1358_ = _tmp1357_;
			vala_code_node_set_source_reference ((ValaCodeNode*) _tmp1356_, _tmp1358_);
		} else {
			ValaSymbol* _tmp1359_;
			ValaSymbol* _tmp1360_;
			_tmp1359_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1360_ = _tmp1359_;
			if (VALA_IS_FIELD (_tmp1360_)) {
				ValaSymbol* _tmp1361_;
				ValaSymbol* _tmp1362_;
				ValaFieldPrototype* _tmp1363_;
				ValaFieldPrototype* _tmp1364_;
				ValaDataType* _tmp1365_;
				ValaDataType* _tmp1366_;
				ValaSourceReference* _tmp1367_;
				ValaSourceReference* _tmp1368_;
				_tmp1361_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1362_ = _tmp1361_;
				_tmp1363_ = vala_field_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1362_, VALA_TYPE_FIELD, ValaField));
				_tmp1364_ = _tmp1363_;
				vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1364_);
				_vala_code_node_unref0 (_tmp1364_);
				_tmp1365_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp1366_ = _tmp1365_;
				_tmp1367_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1368_ = _tmp1367_;
				vala_code_node_set_source_reference ((ValaCodeNode*) _tmp1366_, _tmp1368_);
			} else {
				ValaSymbol* _tmp1369_;
				ValaSymbol* _tmp1370_;
				_tmp1369_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1370_ = _tmp1369_;
				if (VALA_IS_PROPERTY (_tmp1370_)) {
					ValaSymbol* _tmp1371_;
					ValaSymbol* _tmp1372_;
					ValaPropertyPrototype* _tmp1373_;
					ValaPropertyPrototype* _tmp1374_;
					ValaDataType* _tmp1375_;
					ValaDataType* _tmp1376_;
					ValaSourceReference* _tmp1377_;
					ValaSourceReference* _tmp1378_;
					_tmp1371_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1372_ = _tmp1371_;
					_tmp1373_ = vala_property_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1372_, VALA_TYPE_PROPERTY, ValaProperty));
					_tmp1374_ = _tmp1373_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1374_);
					_vala_code_node_unref0 (_tmp1374_);
					_tmp1375_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp1376_ = _tmp1375_;
					_tmp1377_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp1378_ = _tmp1377_;
					vala_code_node_set_source_reference ((ValaCodeNode*) _tmp1376_, _tmp1378_);
				} else {
					ValaInvalidType* _tmp1379_;
					ValaInvalidType* _tmp1380_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp1379_ = vala_invalid_type_new ();
					_tmp1380_ = _tmp1379_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1380_);
					_vala_code_node_unref0 (_tmp1380_);
				}
			}
		}
		_tmp1381_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp1382_ = _tmp1381_;
		if (_tmp1382_ != NULL) {
			ValaDataType* _tmp1383_;
			ValaDataType* _tmp1384_;
			ValaDataType* _tmp1385_;
			ValaDataType* _tmp1386_;
			gboolean _tmp1387_;
			gboolean _tmp1388_;
			_tmp1383_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp1384_ = _tmp1383_;
			_tmp1385_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1386_ = _tmp1385_;
			_tmp1387_ = vala_data_type_get_value_owned (_tmp1386_);
			_tmp1388_ = _tmp1387_;
			vala_data_type_set_value_owned (_tmp1384_, _tmp1388_);
		}
	} else {
		gboolean _tmp1389_ = FALSE;
		gboolean _tmp1410_ = FALSE;
		gboolean _tmp1411_ = FALSE;
		gboolean _tmp1412_ = FALSE;
		gboolean _tmp1413_ = FALSE;
		gboolean _tmp1454_ = FALSE;
		gboolean _tmp1455_ = FALSE;
		gboolean _tmp1456_ = FALSE;
		gboolean _tmp1457_ = FALSE;
		gboolean _tmp1458_ = FALSE;
		gboolean _tmp1459_;
		gboolean _tmp1460_;
		ValaMethod* m = NULL;
		ValaSymbol* _tmp1485_;
		ValaSymbol* _tmp1486_;
		ValaMemberAccess* inner_ma = NULL;
		ValaExpression* _tmp1487_;
		ValaExpression* _tmp1488_;
		gboolean _tmp1489_ = FALSE;
		gboolean _tmp1490_ = FALSE;
		gboolean _tmp1491_ = FALSE;
		gboolean _tmp1492_ = FALSE;
		gboolean _tmp1493_ = FALSE;
		ValaMethod* _tmp1494_;
		ValaSemanticAnalyzer* _tmp1538_;
		ValaSemanticAnalyzer* _tmp1539_;
		ValaSymbol* _tmp1540_;
		ValaSymbol* _tmp1541_;
		gboolean _tmp1542_;
		gboolean _tmp1543_;
		ValaDataType* _tmp1544_;
		ValaDataType* _tmp1545_;
		gboolean _tmp1546_ = FALSE;
		ValaExpression* _tmp1547_;
		ValaExpression* _tmp1548_;
		ValaSymbol* _tmp1561_;
		ValaSymbol* _tmp1562_;
		gboolean _tmp1636_ = FALSE;
		gboolean _tmp1637_ = FALSE;
		ValaExpression* _tmp1638_;
		ValaExpression* _tmp1639_;
		if (instance) {
			ValaExpression* _tmp1390_;
			ValaExpression* _tmp1391_;
			_tmp1390_ = vala_member_access_get_inner (self);
			_tmp1391_ = _tmp1390_;
			_tmp1389_ = _tmp1391_ == NULL;
		} else {
			_tmp1389_ = FALSE;
		}
		if (_tmp1389_) {
			ValaSourceReference* _tmp1392_;
			ValaSourceReference* _tmp1393_;
			ValaMemberAccess* _tmp1394_;
			ValaMemberAccess* _tmp1395_;
			ValaExpression* _tmp1396_;
			ValaExpression* _tmp1397_;
			ValaParameter* _tmp1398_;
			ValaDataType* _tmp1399_;
			ValaDataType* _tmp1400_;
			ValaDataType* _tmp1401_;
			ValaDataType* _tmp1402_;
			ValaExpression* _tmp1403_;
			ValaExpression* _tmp1404_;
			ValaDataType* _tmp1405_;
			ValaDataType* _tmp1406_;
			ValaExpression* _tmp1407_;
			ValaExpression* _tmp1408_;
			ValaParameter* _tmp1409_;
			_tmp1392_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1393_ = _tmp1392_;
			_tmp1394_ = vala_member_access_new (NULL, "this", _tmp1393_);
			_tmp1395_ = _tmp1394_;
			vala_member_access_set_inner (self, (ValaExpression*) _tmp1395_);
			_vala_code_node_unref0 (_tmp1395_);
			_tmp1396_ = vala_member_access_get_inner (self);
			_tmp1397_ = _tmp1396_;
			_tmp1398_ = this_parameter;
			_tmp1399_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1398_);
			_tmp1400_ = _tmp1399_;
			_tmp1401_ = vala_data_type_copy (_tmp1400_);
			_tmp1402_ = _tmp1401_;
			vala_expression_set_value_type (_tmp1397_, _tmp1402_);
			_vala_code_node_unref0 (_tmp1402_);
			_tmp1403_ = vala_member_access_get_inner (self);
			_tmp1404_ = _tmp1403_;
			_tmp1405_ = vala_expression_get_value_type (_tmp1404_);
			_tmp1406_ = _tmp1405_;
			vala_data_type_set_value_owned (_tmp1406_, FALSE);
			_tmp1407_ = vala_member_access_get_inner (self);
			_tmp1408_ = _tmp1407_;
			_tmp1409_ = this_parameter;
			vala_expression_set_symbol_reference (_tmp1408_, (ValaSymbol*) _tmp1409_);
		} else {
			vala_member_access_check_lvalue_access (self);
		}
		if (!instance) {
			_tmp1413_ = !klass;
		} else {
			_tmp1413_ = FALSE;
		}
		if (_tmp1413_) {
			ValaSymbol* _tmp1414_;
			ValaSymbol* _tmp1415_;
			_tmp1414_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1415_ = _tmp1414_;
			_tmp1412_ = !VALA_IS_CREATION_METHOD (_tmp1415_);
		} else {
			_tmp1412_ = FALSE;
		}
		if (_tmp1412_) {
			_tmp1411_ = may_access_instance_members;
		} else {
			_tmp1411_ = FALSE;
		}
		if (_tmp1411_) {
			ValaExpression* _tmp1416_;
			ValaExpression* _tmp1417_;
			_tmp1416_ = vala_member_access_get_inner (self);
			_tmp1417_ = _tmp1416_;
			_tmp1410_ = _tmp1417_ != NULL;
		} else {
			_tmp1410_ = FALSE;
		}
		if (_tmp1410_) {
			ValaExpression* _tmp1418_;
			ValaExpression* _tmp1419_;
			ValaSymbol* _tmp1420_;
			ValaSymbol* _tmp1421_;
			_tmp1418_ = vala_member_access_get_inner (self);
			_tmp1419_ = _tmp1418_;
			_tmp1420_ = vala_expression_get_symbol_reference (_tmp1419_);
			_tmp1421_ = _tmp1420_;
			if (VALA_IS_METHOD (_tmp1421_)) {
			} else {
				ValaSourceReference* _tmp1422_;
				ValaSourceReference* _tmp1423_;
				ValaSymbol* _tmp1424_;
				ValaSymbol* _tmp1425_;
				gchar* _tmp1426_;
				gchar* _tmp1427_;
				ValaSymbol* inner_sym = NULL;
				ValaSymbol* _tmp1428_;
				ValaSymbol* _tmp1429_;
				ValaSymbol* _tmp1430_;
				ValaSymbol* _tmp1431_;
				ValaMemberAccess* inner_ma = NULL;
				ValaMemberAccess* _tmp1451_;
				ValaExpression* _tmp1452_;
				ValaExpression* _tmp1453_;
				_tmp1422_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1423_ = _tmp1422_;
				_tmp1424_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1425_ = _tmp1424_;
				_tmp1426_ = vala_symbol_get_full_name (_tmp1425_);
				_tmp1427_ = _tmp1426_;
				vala_report_warning (_tmp1423_, "Access to static member `%s' with an instance reference", _tmp1427_);
				_g_free0 (_tmp1427_);
				_tmp1428_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1429_ = _tmp1428_;
				_tmp1430_ = vala_symbol_get_parent_symbol (_tmp1429_);
				_tmp1431_ = _tmp1430_;
				inner_sym = _tmp1431_;
				inner_ma = self;
				while (TRUE) {
					gboolean _tmp1432_ = FALSE;
					ValaSymbol* _tmp1433_;
					ValaMemberAccess* _tmp1437_;
					ValaSymbol* _tmp1438_;
					const gchar* _tmp1439_;
					const gchar* _tmp1440_;
					ValaSourceReference* _tmp1441_;
					ValaSourceReference* _tmp1442_;
					ValaMemberAccess* _tmp1443_;
					ValaMemberAccess* _tmp1444_;
					ValaMemberAccess* _tmp1445_;
					ValaExpression* _tmp1446_;
					ValaExpression* _tmp1447_;
					ValaSymbol* _tmp1448_;
					ValaSymbol* _tmp1449_;
					ValaSymbol* _tmp1450_;
					_tmp1433_ = inner_sym;
					if (_tmp1433_ != NULL) {
						ValaSymbol* _tmp1434_;
						const gchar* _tmp1435_;
						const gchar* _tmp1436_;
						_tmp1434_ = inner_sym;
						_tmp1435_ = vala_symbol_get_name (_tmp1434_);
						_tmp1436_ = _tmp1435_;
						_tmp1432_ = _tmp1436_ != NULL;
					} else {
						_tmp1432_ = FALSE;
					}
					if (!_tmp1432_) {
						break;
					}
					_tmp1437_ = inner_ma;
					_tmp1438_ = inner_sym;
					_tmp1439_ = vala_symbol_get_name (_tmp1438_);
					_tmp1440_ = _tmp1439_;
					_tmp1441_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp1442_ = _tmp1441_;
					_tmp1443_ = vala_member_access_new (NULL, _tmp1440_, _tmp1442_);
					_tmp1444_ = _tmp1443_;
					vala_member_access_set_inner (_tmp1437_, (ValaExpression*) _tmp1444_);
					_vala_code_node_unref0 (_tmp1444_);
					_tmp1445_ = inner_ma;
					_tmp1446_ = vala_member_access_get_inner (_tmp1445_);
					_tmp1447_ = _tmp1446_;
					inner_ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp1447_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
					_tmp1448_ = inner_sym;
					_tmp1449_ = vala_symbol_get_parent_symbol (_tmp1448_);
					_tmp1450_ = _tmp1449_;
					inner_sym = _tmp1450_;
				}
				_tmp1451_ = inner_ma;
				vala_member_access_set_qualified (_tmp1451_, TRUE);
				_tmp1452_ = vala_member_access_get_inner (self);
				_tmp1453_ = _tmp1452_;
				vala_code_node_check ((ValaCodeNode*) _tmp1453_, context);
			}
		}
		_tmp1459_ = vala_code_context_get_experimental_non_null (context);
		_tmp1460_ = _tmp1459_;
		if (_tmp1460_) {
			_tmp1458_ = instance;
		} else {
			_tmp1458_ = FALSE;
		}
		if (_tmp1458_) {
			ValaExpression* _tmp1461_;
			ValaExpression* _tmp1462_;
			ValaDataType* _tmp1463_;
			ValaDataType* _tmp1464_;
			gboolean _tmp1465_;
			gboolean _tmp1466_;
			_tmp1461_ = vala_member_access_get_inner (self);
			_tmp1462_ = _tmp1461_;
			_tmp1463_ = vala_expression_get_value_type (_tmp1462_);
			_tmp1464_ = _tmp1463_;
			_tmp1465_ = vala_data_type_get_nullable (_tmp1464_);
			_tmp1466_ = _tmp1465_;
			_tmp1457_ = _tmp1466_;
		} else {
			_tmp1457_ = FALSE;
		}
		if (_tmp1457_) {
			ValaExpression* _tmp1467_;
			ValaExpression* _tmp1468_;
			ValaDataType* _tmp1469_;
			ValaDataType* _tmp1470_;
			_tmp1467_ = vala_member_access_get_inner (self);
			_tmp1468_ = _tmp1467_;
			_tmp1469_ = vala_expression_get_value_type (_tmp1468_);
			_tmp1470_ = _tmp1469_;
			_tmp1456_ = !VALA_IS_POINTER_TYPE (_tmp1470_);
		} else {
			_tmp1456_ = FALSE;
		}
		if (_tmp1456_) {
			ValaExpression* _tmp1471_;
			ValaExpression* _tmp1472_;
			ValaDataType* _tmp1473_;
			ValaDataType* _tmp1474_;
			_tmp1471_ = vala_member_access_get_inner (self);
			_tmp1472_ = _tmp1471_;
			_tmp1473_ = vala_expression_get_value_type (_tmp1472_);
			_tmp1474_ = _tmp1473_;
			_tmp1455_ = !VALA_IS_GENERIC_TYPE (_tmp1474_);
		} else {
			_tmp1455_ = FALSE;
		}
		if (_tmp1455_) {
			ValaExpression* _tmp1475_;
			ValaExpression* _tmp1476_;
			ValaDataType* _tmp1477_;
			ValaDataType* _tmp1478_;
			_tmp1475_ = vala_member_access_get_inner (self);
			_tmp1476_ = _tmp1475_;
			_tmp1477_ = vala_expression_get_value_type (_tmp1476_);
			_tmp1478_ = _tmp1477_;
			_tmp1454_ = !VALA_IS_ARRAY_TYPE (_tmp1478_);
		} else {
			_tmp1454_ = FALSE;
		}
		if (_tmp1454_) {
			ValaSourceReference* _tmp1479_;
			ValaSourceReference* _tmp1480_;
			ValaSymbol* _tmp1481_;
			ValaSymbol* _tmp1482_;
			gchar* _tmp1483_;
			gchar* _tmp1484_;
			_tmp1479_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1480_ = _tmp1479_;
			_tmp1481_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1482_ = _tmp1481_;
			_tmp1483_ = vala_symbol_get_full_name (_tmp1482_);
			_tmp1484_ = _tmp1483_;
			vala_report_error (_tmp1480_, "Access to instance member `%s' from nullable reference denied", _tmp1484_);
			_g_free0 (_tmp1484_);
		}
		_tmp1485_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1486_ = _tmp1485_;
		m = VALA_IS_METHOD (_tmp1486_) ? ((ValaMethod*) _tmp1486_) : NULL;
		_tmp1487_ = vala_member_access_get_inner (self);
		_tmp1488_ = _tmp1487_;
		inner_ma = VALA_IS_MEMBER_ACCESS (_tmp1488_) ? ((ValaMemberAccess*) _tmp1488_) : NULL;
		_tmp1494_ = m;
		if (_tmp1494_ != NULL) {
			ValaMethod* _tmp1495_;
			ValaMemberBinding _tmp1496_;
			ValaMemberBinding _tmp1497_;
			_tmp1495_ = m;
			_tmp1496_ = vala_method_get_binding (_tmp1495_);
			_tmp1497_ = _tmp1496_;
			_tmp1493_ = _tmp1497_ == VALA_MEMBER_BINDING_STATIC;
		} else {
			_tmp1493_ = FALSE;
		}
		if (_tmp1493_) {
			ValaMethod* _tmp1498_;
			ValaSymbol* _tmp1499_;
			ValaSymbol* _tmp1500_;
			_tmp1498_ = m;
			_tmp1499_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1498_);
			_tmp1500_ = _tmp1499_;
			_tmp1492_ = VALA_IS_OBJECT_TYPE_SYMBOL (_tmp1500_);
		} else {
			_tmp1492_ = FALSE;
		}
		if (_tmp1492_) {
			ValaExpression* _tmp1501_;
			ValaExpression* _tmp1502_;
			_tmp1501_ = vala_member_access_get_inner (self);
			_tmp1502_ = _tmp1501_;
			_tmp1491_ = _tmp1502_ != NULL;
		} else {
			_tmp1491_ = FALSE;
		}
		if (_tmp1491_) {
			ValaExpression* _tmp1503_;
			ValaExpression* _tmp1504_;
			ValaDataType* _tmp1505_;
			ValaDataType* _tmp1506_;
			_tmp1503_ = vala_member_access_get_inner (self);
			_tmp1504_ = _tmp1503_;
			_tmp1505_ = vala_expression_get_value_type (_tmp1504_);
			_tmp1506_ = _tmp1505_;
			_tmp1490_ = _tmp1506_ == NULL;
		} else {
			_tmp1490_ = FALSE;
		}
		if (_tmp1490_) {
			ValaMemberAccess* _tmp1507_;
			ValaList* _tmp1508_;
			gint _tmp1509_;
			gint _tmp1510_;
			_tmp1507_ = inner_ma;
			_tmp1508_ = _tmp1507_->priv->type_argument_list;
			_tmp1509_ = vala_collection_get_size ((ValaCollection*) _tmp1508_);
			_tmp1510_ = _tmp1509_;
			_tmp1489_ = _tmp1510_ > 0;
		} else {
			_tmp1489_ = FALSE;
		}
		if (_tmp1489_) {
			ValaExpression* _tmp1511_;
			ValaExpression* _tmp1512_;
			ValaMethod* _tmp1513_;
			ValaSymbol* _tmp1514_;
			ValaSymbol* _tmp1515_;
			ValaObjectType* _tmp1516_;
			ValaObjectType* _tmp1517_;
			ValaExpression* _tmp1518_;
			ValaExpression* _tmp1519_;
			ValaDataType* _tmp1520_;
			ValaDataType* _tmp1521_;
			ValaSourceReference* _tmp1522_;
			ValaSourceReference* _tmp1523_;
			_tmp1511_ = vala_member_access_get_inner (self);
			_tmp1512_ = _tmp1511_;
			_tmp1513_ = m;
			_tmp1514_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1513_);
			_tmp1515_ = _tmp1514_;
			_tmp1516_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1515_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp1517_ = _tmp1516_;
			vala_expression_set_value_type (_tmp1512_, (ValaDataType*) _tmp1517_);
			_vala_code_node_unref0 (_tmp1517_);
			_tmp1518_ = vala_member_access_get_inner (self);
			_tmp1519_ = _tmp1518_;
			_tmp1520_ = vala_expression_get_value_type (_tmp1519_);
			_tmp1521_ = _tmp1520_;
			_tmp1522_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1523_ = _tmp1522_;
			vala_code_node_set_source_reference ((ValaCodeNode*) _tmp1521_, _tmp1523_);
			{
				ValaList* _type_argument_list = NULL;
				ValaMemberAccess* _tmp1524_;
				ValaList* _tmp1525_;
				gint _type_argument_size = 0;
				ValaList* _tmp1526_;
				gint _tmp1527_;
				gint _tmp1528_;
				gint _type_argument_index = 0;
				_tmp1524_ = inner_ma;
				_tmp1525_ = _tmp1524_->priv->type_argument_list;
				_type_argument_list = _tmp1525_;
				_tmp1526_ = _type_argument_list;
				_tmp1527_ = vala_collection_get_size ((ValaCollection*) _tmp1526_);
				_tmp1528_ = _tmp1527_;
				_type_argument_size = _tmp1528_;
				_type_argument_index = -1;
				while (TRUE) {
					gint _tmp1529_;
					gint _tmp1530_;
					ValaDataType* type_argument = NULL;
					ValaList* _tmp1531_;
					gpointer _tmp1532_;
					ValaExpression* _tmp1533_;
					ValaExpression* _tmp1534_;
					ValaDataType* _tmp1535_;
					ValaDataType* _tmp1536_;
					ValaDataType* _tmp1537_;
					_type_argument_index = _type_argument_index + 1;
					_tmp1529_ = _type_argument_index;
					_tmp1530_ = _type_argument_size;
					if (!(_tmp1529_ < _tmp1530_)) {
						break;
					}
					_tmp1531_ = _type_argument_list;
					_tmp1532_ = vala_list_get (_tmp1531_, _type_argument_index);
					type_argument = (ValaDataType*) _tmp1532_;
					_tmp1533_ = vala_member_access_get_inner (self);
					_tmp1534_ = _tmp1533_;
					_tmp1535_ = vala_expression_get_value_type (_tmp1534_);
					_tmp1536_ = _tmp1535_;
					_tmp1537_ = type_argument;
					vala_data_type_add_type_argument (_tmp1536_, _tmp1537_);
					_vala_code_node_unref0 (type_argument);
				}
			}
		}
		_tmp1538_ = vala_code_context_get_analyzer (context);
		_tmp1539_ = _tmp1538_;
		_tmp1540_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1541_ = _tmp1540_;
		_tmp1542_ = vala_expression_get_lvalue ((ValaExpression*) self);
		_tmp1543_ = _tmp1542_;
		_tmp1544_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1539_, _tmp1541_, _tmp1543_);
		_tmp1545_ = _tmp1544_;
		vala_expression_set_formal_value_type ((ValaExpression*) self, _tmp1545_);
		_vala_code_node_unref0 (_tmp1545_);
		_tmp1547_ = vala_member_access_get_inner (self);
		_tmp1548_ = _tmp1547_;
		if (_tmp1548_ != NULL) {
			ValaDataType* _tmp1549_;
			ValaDataType* _tmp1550_;
			_tmp1549_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1550_ = _tmp1549_;
			_tmp1546_ = _tmp1550_ != NULL;
		} else {
			_tmp1546_ = FALSE;
		}
		if (_tmp1546_) {
			ValaDataType* _tmp1551_;
			ValaDataType* _tmp1552_;
			ValaExpression* _tmp1553_;
			ValaExpression* _tmp1554_;
			ValaDataType* _tmp1555_;
			ValaDataType* _tmp1556_;
			ValaDataType* _tmp1557_;
			ValaDataType* _tmp1558_;
			_tmp1551_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1552_ = _tmp1551_;
			_tmp1553_ = vala_member_access_get_inner (self);
			_tmp1554_ = _tmp1553_;
			_tmp1555_ = vala_expression_get_value_type (_tmp1554_);
			_tmp1556_ = _tmp1555_;
			_tmp1557_ = vala_data_type_get_actual_type (_tmp1552_, _tmp1556_, NULL, (ValaCodeNode*) self);
			_tmp1558_ = _tmp1557_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1558_);
			_vala_code_node_unref0 (_tmp1558_);
		} else {
			ValaDataType* _tmp1559_;
			ValaDataType* _tmp1560_;
			_tmp1559_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1560_ = _tmp1559_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1560_);
		}
		_tmp1561_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1562_ = _tmp1561_;
		if (VALA_IS_METHOD (_tmp1562_)) {
			ValaMethod* method = NULL;
			ValaSymbol* _tmp1563_;
			ValaSymbol* _tmp1564_;
			ValaDataType* _tmp1565_;
			ValaDataType* _tmp1566_;
			gboolean _tmp1573_ = FALSE;
			_tmp1563_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1564_ = _tmp1563_;
			method = G_TYPE_CHECK_INSTANCE_CAST (_tmp1564_, VALA_TYPE_METHOD, ValaMethod);
			_tmp1565_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1566_ = _tmp1565_;
			if (_tmp1566_ != NULL) {
				ValaDataType* _tmp1567_;
				ValaDataType* _tmp1568_;
				ValaDataType* _tmp1569_;
				ValaDataType* _tmp1570_;
				gboolean _tmp1571_;
				gboolean _tmp1572_;
				_tmp1567_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp1568_ = _tmp1567_;
				_tmp1569_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp1570_ = _tmp1569_;
				_tmp1571_ = vala_data_type_get_value_owned (_tmp1570_);
				_tmp1572_ = _tmp1571_;
				vala_data_type_set_value_owned (_tmp1568_, _tmp1572_);
			}
			if (instance) {
				ValaMethod* _tmp1574_;
				ValaSymbol* _tmp1575_;
				ValaSymbol* _tmp1576_;
				_tmp1574_ = method;
				_tmp1575_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1574_);
				_tmp1576_ = _tmp1575_;
				_tmp1573_ = VALA_IS_TYPESYMBOL (_tmp1576_);
			} else {
				_tmp1573_ = FALSE;
			}
			if (_tmp1573_) {
				ValaExpression* _tmp1577_;
				ValaExpression* _tmp1578_;
				ValaMethod* _tmp1579_;
				ValaSymbol* _tmp1580_;
				ValaSymbol* _tmp1581_;
				ValaDataType* _tmp1582_;
				ValaDataType* _tmp1583_;
				ValaExpression* _tmp1584_;
				ValaExpression* _tmp1585_;
				ValaDataType* _tmp1586_;
				ValaDataType* _tmp1587_;
				ValaMethod* _tmp1588_;
				ValaParameter* _tmp1589_;
				ValaParameter* _tmp1590_;
				ValaDataType* _tmp1591_;
				ValaDataType* _tmp1592_;
				gboolean _tmp1593_;
				gboolean _tmp1594_;
				_tmp1577_ = vala_member_access_get_inner (self);
				_tmp1578_ = _tmp1577_;
				_tmp1579_ = method;
				_tmp1580_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1579_);
				_tmp1581_ = _tmp1580_;
				_tmp1582_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1581_);
				_tmp1583_ = _tmp1582_;
				vala_expression_set_target_type (_tmp1578_, _tmp1583_);
				_vala_code_node_unref0 (_tmp1583_);
				_tmp1584_ = vala_member_access_get_inner (self);
				_tmp1585_ = _tmp1584_;
				_tmp1586_ = vala_expression_get_target_type (_tmp1585_);
				_tmp1587_ = _tmp1586_;
				_tmp1588_ = method;
				_tmp1589_ = vala_method_get_this_parameter (_tmp1588_);
				_tmp1590_ = _tmp1589_;
				_tmp1591_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1590_);
				_tmp1592_ = _tmp1591_;
				_tmp1593_ = vala_data_type_get_value_owned (_tmp1592_);
				_tmp1594_ = _tmp1593_;
				vala_data_type_set_value_owned (_tmp1587_, _tmp1594_);
			}
		} else {
			gboolean _tmp1595_ = FALSE;
			gboolean _tmp1596_ = FALSE;
			ValaSymbol* _tmp1597_;
			ValaSymbol* _tmp1598_;
			_tmp1597_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1598_ = _tmp1597_;
			if (VALA_IS_PROPERTY (_tmp1598_)) {
				_tmp1596_ = instance;
			} else {
				_tmp1596_ = FALSE;
			}
			if (_tmp1596_) {
				ValaSymbol* _tmp1599_;
				ValaSymbol* _tmp1600_;
				ValaSymbol* _tmp1601_;
				ValaSymbol* _tmp1602_;
				_tmp1599_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1600_ = _tmp1599_;
				_tmp1601_ = vala_symbol_get_parent_symbol (_tmp1600_);
				_tmp1602_ = _tmp1601_;
				_tmp1595_ = _tmp1602_ != NULL;
			} else {
				_tmp1595_ = FALSE;
			}
			if (_tmp1595_) {
				ValaExpression* _tmp1603_;
				ValaExpression* _tmp1604_;
				ValaSymbol* _tmp1605_;
				ValaSymbol* _tmp1606_;
				ValaSymbol* _tmp1607_;
				ValaSymbol* _tmp1608_;
				ValaDataType* _tmp1609_;
				ValaDataType* _tmp1610_;
				_tmp1603_ = vala_member_access_get_inner (self);
				_tmp1604_ = _tmp1603_;
				_tmp1605_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1606_ = _tmp1605_;
				_tmp1607_ = vala_symbol_get_parent_symbol (_tmp1606_);
				_tmp1608_ = _tmp1607_;
				_tmp1609_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1608_);
				_tmp1610_ = _tmp1609_;
				vala_expression_set_target_type (_tmp1604_, _tmp1610_);
				_vala_code_node_unref0 (_tmp1610_);
			} else {
				gboolean _tmp1611_ = FALSE;
				gboolean _tmp1612_ = FALSE;
				gboolean _tmp1613_ = FALSE;
				ValaSymbol* _tmp1614_;
				ValaSymbol* _tmp1615_;
				_tmp1614_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1615_ = _tmp1614_;
				if (VALA_IS_FIELD (_tmp1615_)) {
					_tmp1613_ = TRUE;
				} else {
					ValaSymbol* _tmp1616_;
					ValaSymbol* _tmp1617_;
					_tmp1616_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1617_ = _tmp1616_;
					_tmp1613_ = VALA_IS_SIGNAL (_tmp1617_);
				}
				if (_tmp1613_) {
					_tmp1612_ = instance;
				} else {
					_tmp1612_ = FALSE;
				}
				if (_tmp1612_) {
					ValaSymbol* _tmp1618_;
					ValaSymbol* _tmp1619_;
					ValaSymbol* _tmp1620_;
					ValaSymbol* _tmp1621_;
					_tmp1618_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1619_ = _tmp1618_;
					_tmp1620_ = vala_symbol_get_parent_symbol (_tmp1619_);
					_tmp1621_ = _tmp1620_;
					_tmp1611_ = _tmp1621_ != NULL;
				} else {
					_tmp1611_ = FALSE;
				}
				if (_tmp1611_) {
					ValaDataType* parent_type = NULL;
					ValaSymbol* _tmp1622_;
					ValaSymbol* _tmp1623_;
					ValaSymbol* _tmp1624_;
					ValaSymbol* _tmp1625_;
					ValaDataType* _tmp1626_;
					ValaExpression* _tmp1627_;
					ValaExpression* _tmp1628_;
					ValaDataType* _tmp1629_;
					ValaExpression* _tmp1630_;
					ValaExpression* _tmp1631_;
					ValaDataType* _tmp1632_;
					ValaDataType* _tmp1633_;
					ValaDataType* _tmp1634_;
					ValaDataType* _tmp1635_;
					_tmp1622_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1623_ = _tmp1622_;
					_tmp1624_ = vala_symbol_get_parent_symbol (_tmp1623_);
					_tmp1625_ = _tmp1624_;
					_tmp1626_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1625_);
					parent_type = _tmp1626_;
					_tmp1627_ = vala_member_access_get_inner (self);
					_tmp1628_ = _tmp1627_;
					_tmp1629_ = parent_type;
					_tmp1630_ = vala_member_access_get_inner (self);
					_tmp1631_ = _tmp1630_;
					_tmp1632_ = vala_expression_get_value_type (_tmp1631_);
					_tmp1633_ = _tmp1632_;
					_tmp1634_ = vala_data_type_get_actual_type (_tmp1629_, _tmp1633_, NULL, (ValaCodeNode*) self);
					_tmp1635_ = _tmp1634_;
					vala_expression_set_target_type (_tmp1628_, _tmp1635_);
					_vala_code_node_unref0 (_tmp1635_);
					_vala_code_node_unref0 (parent_type);
				}
			}
		}
		_tmp1638_ = vala_member_access_get_inner (self);
		_tmp1639_ = _tmp1638_;
		if (_tmp1639_ == NULL) {
			ValaDataType* _tmp1640_;
			ValaDataType* _tmp1641_;
			_tmp1640_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp1641_ = _tmp1640_;
			_tmp1637_ = _tmp1641_ != NULL;
		} else {
			_tmp1637_ = FALSE;
		}
		if (_tmp1637_) {
			ValaProfile _tmp1642_;
			ValaProfile _tmp1643_;
			_tmp1642_ = vala_code_context_get_profile (context);
			_tmp1643_ = _tmp1642_;
			_tmp1636_ = _tmp1643_ == VALA_PROFILE_GOBJECT;
		} else {
			_tmp1636_ = FALSE;
		}
		if (_tmp1636_) {
			vala_member_access_check_narrowed_value_type (self);
		}
	}
	_tmp1644_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp1645_ = _tmp1644_;
	if (_tmp1645_ != NULL) {
		ValaDataType* _tmp1646_;
		ValaDataType* _tmp1647_;
		_tmp1646_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp1647_ = _tmp1646_;
		vala_code_node_check ((ValaCodeNode*) _tmp1647_, context);
	}
	_tmp1648_ = self->priv->_tainted_access;
	if (!_tmp1648_) {
		vala_member_access_set_tainted_access (self, vala_member_access_is_tainted (self));
	}
	_tmp1649_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp1650_ = _tmp1649_;
	result = !_tmp1650_;
	_vala_iterable_unref0 (visited_types);
	return result;
}

static gboolean
vala_member_access_is_instance_symbol (ValaSymbol* symbol)
{
	gboolean _tmp0_ = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (symbol != NULL, FALSE);
	if (VALA_IS_FIELD (symbol)) {
		ValaMemberBinding _tmp1_;
		ValaMemberBinding _tmp2_;
		_tmp1_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_FIELD, ValaField));
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		if (VALA_IS_METHOD (symbol)) {
			_tmp4_ = !VALA_IS_CREATION_METHOD (symbol);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			ValaMemberBinding _tmp5_;
			ValaMemberBinding _tmp6_;
			_tmp5_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_METHOD, ValaMethod));
			_tmp6_ = _tmp5_;
			_tmp3_ = _tmp6_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp7_ = FALSE;
			if (VALA_IS_PROPERTY (symbol)) {
				ValaMemberBinding _tmp8_;
				ValaMemberBinding _tmp9_;
				_tmp8_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_PROPERTY, ValaProperty));
				_tmp9_ = _tmp8_;
				_tmp7_ = _tmp9_ == VALA_MEMBER_BINDING_INSTANCE;
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				result = TRUE;
				return result;
			} else {
				if (VALA_IS_SIGNAL (symbol)) {
					result = TRUE;
					return result;
				} else {
					result = FALSE;
					return result;
				}
			}
		}
	}
}

void
vala_member_access_check_lvalue_access (ValaMemberAccess* self)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	gboolean instance = FALSE;
	gboolean _tmp23_ = FALSE;
	ValaExpression* _tmp24_;
	ValaExpression* _tmp25_;
	ValaSymbol* _tmp26_;
	ValaSymbol* _tmp27_;
	gboolean this_access = FALSE;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp35_ = FALSE;
	ValaExpression* _tmp36_;
	ValaExpression* _tmp37_;
	ValaDataType* _tmp38_;
	ValaDataType* _tmp39_;
	gboolean struct_or_array = FALSE;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp50_;
	ValaExpression* _tmp51_;
	gboolean _tmp52_ = FALSE;
	gboolean _tmp53_ = FALSE;
	ValaMemberAccess* _tmp54_;
	gboolean _tmp61_ = FALSE;
	gboolean _tmp62_ = FALSE;
	gboolean _tmp63_ = FALSE;
	gboolean _tmp64_ = FALSE;
	gboolean _tmp83_ = FALSE;
	ValaSymbol* _tmp84_;
	ValaSymbol* _tmp85_;
	g_return_if_fail (self != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp4_ = _tmp3_;
	if (VALA_IS_FIELD (_tmp4_)) {
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		ValaMemberBinding _tmp7_;
		ValaMemberBinding _tmp8_;
		_tmp5_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_FIELD, ValaField));
		_tmp8_ = _tmp7_;
		_tmp2_ = _tmp8_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp2_ = FALSE;
	}
	instance = _tmp2_;
	if (!instance) {
		gboolean _tmp9_ = FALSE;
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		_tmp10_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp11_ = _tmp10_;
		if (VALA_IS_METHOD (_tmp11_)) {
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			ValaMemberBinding _tmp14_;
			ValaMemberBinding _tmp15_;
			_tmp12_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_METHOD, ValaMethod));
			_tmp15_ = _tmp14_;
			_tmp9_ = _tmp15_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp9_ = FALSE;
		}
		instance = _tmp9_;
	}
	if (!instance) {
		gboolean _tmp16_ = FALSE;
		ValaSymbol* _tmp17_;
		ValaSymbol* _tmp18_;
		_tmp17_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp18_ = _tmp17_;
		if (VALA_IS_PROPERTY (_tmp18_)) {
			ValaSymbol* _tmp19_;
			ValaSymbol* _tmp20_;
			ValaMemberBinding _tmp21_;
			ValaMemberBinding _tmp22_;
			_tmp19_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, VALA_TYPE_PROPERTY, ValaProperty));
			_tmp22_ = _tmp21_;
			_tmp16_ = _tmp22_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp16_ = FALSE;
		}
		instance = _tmp16_;
	}
	_tmp24_ = vala_member_access_get_inner (self);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_expression_get_symbol_reference (_tmp25_);
	_tmp27_ = _tmp26_;
	if (VALA_IS_PARAMETER (_tmp27_)) {
		ValaExpression* _tmp28_;
		ValaExpression* _tmp29_;
		ValaSymbol* _tmp30_;
		ValaSymbol* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		_tmp28_ = vala_member_access_get_inner (self);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_expression_get_symbol_reference (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_symbol_get_name (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp23_ = g_strcmp0 (_tmp33_, "this") == 0;
	} else {
		_tmp23_ = FALSE;
	}
	this_access = _tmp23_;
	_tmp36_ = vala_member_access_get_inner (self);
	_tmp37_ = _tmp36_;
	_tmp38_ = vala_expression_get_value_type (_tmp37_);
	_tmp39_ = _tmp38_;
	if (VALA_IS_STRUCT_VALUE_TYPE (_tmp39_)) {
		ValaExpression* _tmp40_;
		ValaExpression* _tmp41_;
		ValaDataType* _tmp42_;
		ValaDataType* _tmp43_;
		gboolean _tmp44_;
		gboolean _tmp45_;
		_tmp40_ = vala_member_access_get_inner (self);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_expression_get_value_type (_tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_data_type_get_nullable (_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp35_ = !_tmp45_;
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		_tmp34_ = TRUE;
	} else {
		ValaExpression* _tmp46_;
		ValaExpression* _tmp47_;
		ValaDataType* _tmp48_;
		ValaDataType* _tmp49_;
		_tmp46_ = vala_member_access_get_inner (self);
		_tmp47_ = _tmp46_;
		_tmp48_ = vala_expression_get_value_type (_tmp47_);
		_tmp49_ = _tmp48_;
		_tmp34_ = VALA_IS_ARRAY_TYPE (_tmp49_);
	}
	struct_or_array = _tmp34_;
	_tmp50_ = vala_member_access_get_inner (self);
	_tmp51_ = _tmp50_;
	ma = VALA_IS_MEMBER_ACCESS (_tmp51_) ? ((ValaMemberAccess*) _tmp51_) : NULL;
	_tmp54_ = ma;
	if (_tmp54_ == NULL) {
		_tmp53_ = struct_or_array;
	} else {
		_tmp53_ = FALSE;
	}
	if (_tmp53_) {
		ValaExpression* _tmp55_;
		ValaExpression* _tmp56_;
		_tmp55_ = vala_member_access_get_inner (self);
		_tmp56_ = _tmp55_;
		_tmp52_ = VALA_IS_POINTER_INDIRECTION (_tmp56_);
	} else {
		_tmp52_ = FALSE;
	}
	if (_tmp52_) {
		ValaExpression* _tmp57_;
		ValaExpression* _tmp58_;
		ValaExpression* _tmp59_;
		ValaExpression* _tmp60_;
		_tmp57_ = vala_member_access_get_inner (self);
		_tmp58_ = _tmp57_;
		_tmp59_ = vala_pointer_indirection_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, VALA_TYPE_POINTER_INDIRECTION, ValaPointerIndirection));
		_tmp60_ = _tmp59_;
		ma = VALA_IS_MEMBER_ACCESS (_tmp60_) ? ((ValaMemberAccess*) _tmp60_) : NULL;
	}
	if (instance) {
		_tmp64_ = struct_or_array;
	} else {
		_tmp64_ = FALSE;
	}
	if (_tmp64_) {
		gboolean _tmp65_ = FALSE;
		ValaSymbol* _tmp66_;
		ValaSymbol* _tmp67_;
		_tmp66_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp67_ = _tmp66_;
		if (VALA_IS_METHOD (_tmp67_)) {
			_tmp65_ = TRUE;
		} else {
			gboolean _tmp68_;
			gboolean _tmp69_;
			_tmp68_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp69_ = _tmp68_;
			_tmp65_ = _tmp69_;
		}
		_tmp63_ = _tmp65_;
	} else {
		_tmp63_ = FALSE;
	}
	if (_tmp63_) {
		gboolean _tmp70_ = FALSE;
		gboolean _tmp71_ = FALSE;
		ValaMemberAccess* _tmp72_;
		_tmp72_ = ma;
		if (_tmp72_ != NULL) {
			ValaMemberAccess* _tmp73_;
			ValaSymbol* _tmp74_;
			ValaSymbol* _tmp75_;
			_tmp73_ = ma;
			_tmp74_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp73_);
			_tmp75_ = _tmp74_;
			_tmp71_ = VALA_IS_VARIABLE (_tmp75_);
		} else {
			_tmp71_ = FALSE;
		}
		if (_tmp71_) {
			_tmp70_ = TRUE;
		} else {
			ValaExpression* _tmp76_;
			ValaExpression* _tmp77_;
			_tmp76_ = vala_member_access_get_inner (self);
			_tmp77_ = _tmp76_;
			_tmp70_ = VALA_IS_ELEMENT_ACCESS (_tmp77_);
		}
		_tmp62_ = _tmp70_;
	} else {
		_tmp62_ = FALSE;
	}
	if (_tmp62_) {
		_tmp61_ = !this_access;
	} else {
		_tmp61_ = FALSE;
	}
	if (_tmp61_) {
		ValaExpression* _tmp78_;
		ValaExpression* _tmp79_;
		ValaMemberAccess* _tmp80_;
		_tmp78_ = vala_member_access_get_inner (self);
		_tmp79_ = _tmp78_;
		vala_expression_set_lvalue (_tmp79_, TRUE);
		_tmp80_ = ma;
		if (_tmp80_ != NULL) {
			ValaMemberAccess* _tmp81_;
			ValaMemberAccess* _tmp82_;
			_tmp81_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp81_, TRUE);
			_tmp82_ = ma;
			vala_member_access_check_lvalue_access (_tmp82_);
		}
	}
	_tmp84_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp85_ = _tmp84_;
	if (VALA_IS_METHOD (_tmp85_)) {
		ValaSymbol* _tmp86_;
		ValaSymbol* _tmp87_;
		ValaAttribute* _tmp88_;
		_tmp86_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp87_ = _tmp86_;
		_tmp88_ = vala_code_node_get_attribute ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (_tmp87_, VALA_TYPE_METHOD, ValaMethod), "DestroysInstance");
		_tmp83_ = _tmp88_ != NULL;
	} else {
		_tmp83_ = FALSE;
	}
	if (_tmp83_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp89_;
		ValaSymbol* _tmp90_;
		ValaSymbol* _tmp91_;
		ValaSymbol* _tmp92_;
		gboolean _tmp93_ = FALSE;
		gboolean _tmp94_ = FALSE;
		ValaClass* _tmp95_;
		_tmp89_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp90_ = _tmp89_;
		_tmp91_ = vala_symbol_get_parent_symbol ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp90_, VALA_TYPE_METHOD, ValaMethod));
		_tmp92_ = _tmp91_;
		cl = VALA_IS_CLASS (_tmp92_) ? ((ValaClass*) _tmp92_) : NULL;
		_tmp95_ = cl;
		if (_tmp95_ != NULL) {
			ValaClass* _tmp96_;
			gboolean _tmp97_;
			gboolean _tmp98_;
			_tmp96_ = cl;
			_tmp97_ = vala_class_get_is_compact (_tmp96_);
			_tmp98_ = _tmp97_;
			_tmp94_ = _tmp98_;
		} else {
			_tmp94_ = FALSE;
		}
		if (_tmp94_) {
			ValaMemberAccess* _tmp99_;
			_tmp99_ = ma;
			_tmp93_ = _tmp99_ != NULL;
		} else {
			_tmp93_ = FALSE;
		}
		if (_tmp93_) {
			ValaMemberAccess* _tmp100_;
			ValaMemberAccess* _tmp101_;
			_tmp100_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp100_, TRUE);
			_tmp101_ = ma;
			vala_member_access_check_lvalue_access (_tmp101_);
		}
	}
}

static void
vala_member_access_real_emit (ValaCodeNode* base,
                              ValaCodeGenerator* codegen)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_emit ((ValaCodeNode*) _tmp3_, codegen);
	}
	vala_code_visitor_visit_member_access ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                               ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, collection);
	}
}

static void
vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                            ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaLocalVariable* local = NULL;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaParameter* param = NULL;
	ValaSymbol* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaLocalVariable* _tmp8_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp3_, collection);
	}
	_tmp4_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp5_ = _tmp4_;
	local = VALA_IS_LOCAL_VARIABLE (_tmp5_) ? ((ValaLocalVariable*) _tmp5_) : NULL;
	_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp7_ = _tmp6_;
	param = VALA_IS_PARAMETER (_tmp7_) ? ((ValaParameter*) _tmp7_) : NULL;
	_tmp8_ = local;
	if (_tmp8_ != NULL) {
		ValaLocalVariable* _tmp9_;
		_tmp9_ = local;
		vala_collection_add (collection, (ValaVariable*) _tmp9_);
	} else {
		gboolean _tmp10_ = FALSE;
		ValaParameter* _tmp11_;
		_tmp11_ = param;
		if (_tmp11_ != NULL) {
			ValaParameter* _tmp12_;
			ValaParameterDirection _tmp13_;
			ValaParameterDirection _tmp14_;
			_tmp12_ = param;
			_tmp13_ = vala_parameter_get_direction (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp10_ = _tmp14_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			ValaParameter* _tmp15_;
			_tmp15_ = param;
			vala_collection_add (collection, (ValaVariable*) _tmp15_);
		}
	}
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		ValaMemberAccess* self;
		self = _data1_->self;
		_vala_code_node_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static ValaTraverseStatus
__lambda4_ (Block1Data* _data1_,
            ValaCodeNode* n)
{
	ValaMemberAccess* self;
	ValaTraverseStatus result = 0;
	self = _data1_->self;
	g_return_val_if_fail (n != NULL, 0);
	if (VALA_IS_POSTFIX_EXPRESSION (n)) {
		_data1_->found = TRUE;
		result = VALA_TRAVERSE_STATUS_STOP;
		return result;
	} else {
		if (VALA_IS_UNARY_EXPRESSION (n)) {
			ValaUnaryExpression* e = NULL;
			gboolean _tmp0_ = FALSE;
			ValaUnaryExpression* _tmp1_;
			ValaUnaryOperator _tmp2_;
			ValaUnaryOperator _tmp3_;
			e = G_TYPE_CHECK_INSTANCE_CAST (n, VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression);
			_tmp1_ = e;
			_tmp2_ = vala_unary_expression_get_operator (_tmp1_);
			_tmp3_ = _tmp2_;
			if (_tmp3_ == VALA_UNARY_OPERATOR_INCREMENT) {
				_tmp0_ = TRUE;
			} else {
				ValaUnaryExpression* _tmp4_;
				ValaUnaryOperator _tmp5_;
				ValaUnaryOperator _tmp6_;
				_tmp4_ = e;
				_tmp5_ = vala_unary_expression_get_operator (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp0_ = _tmp6_ == VALA_UNARY_OPERATOR_DECREMENT;
			}
			if (_tmp0_) {
				_data1_->found = TRUE;
				result = VALA_TRAVERSE_STATUS_STOP;
				return result;
			}
		}
	}
	result = VALA_TRAVERSE_STATUS_CONTINUE;
	return result;
}

static ValaTraverseStatus
___lambda4__vala_traverse_func (ValaCodeNode* node,
                                gpointer self)
{
	ValaTraverseStatus result;
	result = __lambda4_ (self, node);
	return result;
}

static gboolean
vala_member_access_is_tainted (ValaMemberAccess* self)
{
	Block1Data* _data1_;
	ValaCodeNode* node = NULL;
	ValaCodeNode* _tmp0_;
	ValaCodeNode* _tmp1_;
	ValaCodeNode* _tmp2_;
	ValaTraverseVisitor* traverse = NULL;
	ValaTraverseVisitor* _tmp14_;
	ValaCodeNode* _tmp15_;
	ValaTraverseVisitor* _tmp16_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = vala_code_node_ref (self);
	node = (ValaCodeNode*) self;
	_tmp0_ = node;
	_tmp1_ = vala_code_node_get_parent_node (_tmp0_);
	_tmp2_ = _tmp1_;
	if (VALA_IS_MEMBER_ACCESS (_tmp2_)) {
		result = FALSE;
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return result;
	}
	while (TRUE) {
		ValaCodeNode* _tmp3_;
		ValaCodeNode* _tmp4_;
		ValaCodeNode* _tmp5_;
		ValaCodeNode* _tmp6_;
		ValaCodeNode* _tmp7_;
		ValaCodeNode* _tmp8_;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		ValaCodeNode* _tmp11_;
		_tmp3_ = node;
		_tmp4_ = vala_code_node_get_parent_node (_tmp3_);
		_tmp5_ = _tmp4_;
		if (!VALA_IS_EXPRESSION (_tmp5_)) {
			break;
		}
		_tmp6_ = node;
		_tmp7_ = vala_code_node_get_parent_node (_tmp6_);
		_tmp8_ = _tmp7_;
		node = _tmp8_;
		_tmp11_ = node;
		if (VALA_IS_ASSIGNMENT (_tmp11_)) {
			_tmp10_ = TRUE;
		} else {
			ValaCodeNode* _tmp12_;
			_tmp12_ = node;
			_tmp10_ = VALA_IS_METHOD_CALL (_tmp12_);
		}
		if (_tmp10_) {
			_tmp9_ = TRUE;
		} else {
			ValaCodeNode* _tmp13_;
			_tmp13_ = node;
			_tmp9_ = VALA_IS_OBJECT_CREATION_EXPRESSION (_tmp13_);
		}
		if (_tmp9_) {
			break;
		}
	}
	_data1_->found = FALSE;
	_tmp14_ = vala_traverse_visitor_new (___lambda4__vala_traverse_func, block1_data_ref (_data1_), block1_data_unref);
	traverse = _tmp14_;
	_tmp15_ = node;
	_tmp16_ = traverse;
	vala_code_node_accept (_tmp15_, (ValaCodeVisitor*) _tmp16_);
	result = _data1_->found;
	_vala_code_visitor_unref0 (traverse);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}

static void
vala_member_access_check_narrowed_value_type (ValaMemberAccess* self)
{
	ValaVariable* variable = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaVariable* _tmp2_;
	ValaCodeNode* _tmp3_;
	ValaCodeNode* _tmp4_;
	gboolean is_negation = FALSE;
	ValaCodeNode* parent = NULL;
	ValaCodeNode* _tmp5_;
	ValaCodeNode* _tmp6_;
	ValaIfStatement* if_statement = NULL;
	ValaArrayList* scope_type_checks = NULL;
	GEqualFunc _tmp7_;
	ValaArrayList* _tmp8_;
	ValaIfStatement* _tmp43_;
	ValaDataType* _tmp79_;
	ValaDataType* _tmp80_;
	ValaSymbol* _tmp81_;
	ValaSymbol* _tmp82_;
	g_return_if_fail (self != NULL);
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	variable = VALA_IS_VARIABLE (_tmp1_) ? ((ValaVariable*) _tmp1_) : NULL;
	_tmp2_ = variable;
	if (_tmp2_ == NULL) {
		return;
	}
	_tmp3_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
	_tmp4_ = _tmp3_;
	if (!VALA_IS_MEMBER_ACCESS (_tmp4_)) {
		return;
	}
	is_negation = FALSE;
	_tmp5_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
	_tmp6_ = _tmp5_;
	parent = _tmp6_;
	if_statement = NULL;
	_tmp7_ = g_direct_equal;
	_tmp8_ = vala_array_list_new (VALA_TYPE_TYPECHECK, NULL, NULL, _tmp7_);
	scope_type_checks = _tmp8_;
	while (TRUE) {
		gboolean _tmp9_ = FALSE;
		ValaCodeNode* _tmp10_;
		ValaCodeNode* _tmp12_;
		ValaCodeNode* _tmp13_;
		ValaCodeNode* _tmp14_;
		ValaCodeNode* _tmp15_;
		ValaCodeNode* _tmp23_;
		ValaCodeNode* _tmp24_;
		ValaCodeNode* _tmp25_;
		ValaCodeNode* _tmp40_;
		ValaCodeNode* _tmp41_;
		ValaCodeNode* _tmp42_;
		_tmp10_ = parent;
		if (_tmp10_ != NULL) {
			ValaCodeNode* _tmp11_;
			_tmp11_ = parent;
			_tmp9_ = !VALA_IS_METHOD (_tmp11_);
		} else {
			_tmp9_ = FALSE;
		}
		if (!_tmp9_) {
			break;
		}
		_tmp12_ = parent;
		if (VALA_IS_TYPECHECK (_tmp12_)) {
			parent = NULL;
			break;
		}
		_tmp13_ = parent;
		_tmp14_ = vala_code_node_get_parent_node (_tmp13_);
		_tmp15_ = _tmp14_;
		if (VALA_IS_IF_STATEMENT (_tmp15_)) {
			ValaCodeNode* _tmp16_;
			ValaCodeNode* _tmp17_;
			ValaCodeNode* _tmp18_;
			ValaIfStatement* _tmp19_;
			ValaBlock* _tmp20_;
			ValaBlock* _tmp21_;
			ValaCodeNode* _tmp22_;
			_tmp16_ = parent;
			_tmp17_ = vala_code_node_get_parent_node (_tmp16_);
			_tmp18_ = _tmp17_;
			if_statement = G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_IF_STATEMENT, ValaIfStatement);
			_tmp19_ = if_statement;
			_tmp20_ = vala_if_statement_get_false_statement (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = parent;
			is_negation = G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, VALA_TYPE_CODE_NODE, ValaCodeNode) == _tmp22_;
			break;
		}
		_tmp23_ = parent;
		_tmp24_ = vala_code_node_get_parent_node (_tmp23_);
		_tmp25_ = _tmp24_;
		if (VALA_IS_METHOD (_tmp25_)) {
			{
				ValaList* _expr_list = NULL;
				ValaCodeNode* _tmp26_;
				ValaCodeNode* _tmp27_;
				ValaCodeNode* _tmp28_;
				ValaList* _tmp29_;
				gint _expr_size = 0;
				ValaList* _tmp30_;
				gint _tmp31_;
				gint _tmp32_;
				gint _expr_index = 0;
				_tmp26_ = parent;
				_tmp27_ = vala_code_node_get_parent_node (_tmp26_);
				_tmp28_ = _tmp27_;
				_tmp29_ = vala_method_get_preconditions (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, VALA_TYPE_METHOD, ValaMethod));
				_expr_list = _tmp29_;
				_tmp30_ = _expr_list;
				_tmp31_ = vala_collection_get_size ((ValaCollection*) _tmp30_);
				_tmp32_ = _tmp31_;
				_expr_size = _tmp32_;
				_expr_index = -1;
				while (TRUE) {
					gint _tmp33_;
					gint _tmp34_;
					ValaExpression* expr = NULL;
					ValaList* _tmp35_;
					gpointer _tmp36_;
					ValaExpression* _tmp37_;
					_expr_index = _expr_index + 1;
					_tmp33_ = _expr_index;
					_tmp34_ = _expr_size;
					if (!(_tmp33_ < _tmp34_)) {
						break;
					}
					_tmp35_ = _expr_list;
					_tmp36_ = vala_list_get (_tmp35_, _expr_index);
					expr = (ValaExpression*) _tmp36_;
					_tmp37_ = expr;
					if (VALA_IS_TYPECHECK (_tmp37_)) {
						ValaArrayList* _tmp38_;
						ValaExpression* _tmp39_;
						_tmp38_ = scope_type_checks;
						_tmp39_ = expr;
						vala_collection_add ((ValaCollection*) _tmp38_, G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, VALA_TYPE_TYPECHECK, ValaTypeCheck));
					}
					_vala_code_node_unref0 (expr);
				}
			}
			break;
		}
		_tmp40_ = parent;
		_tmp41_ = vala_code_node_get_parent_node (_tmp40_);
		_tmp42_ = _tmp41_;
		parent = _tmp42_;
	}
	_tmp43_ = if_statement;
	if (_tmp43_ != NULL) {
		ValaExpression* expr = NULL;
		ValaIfStatement* _tmp44_;
		ValaExpression* _tmp45_;
		ValaExpression* _tmp46_;
		gboolean _tmp47_ = FALSE;
		ValaExpression* _tmp48_;
		ValaTypeCheck* type_check = NULL;
		ValaExpression* _tmp55_;
		gboolean _tmp56_ = FALSE;
		_tmp44_ = if_statement;
		_tmp45_ = vala_if_statement_get_condition (_tmp44_);
		_tmp46_ = _tmp45_;
		expr = _tmp46_;
		_tmp48_ = expr;
		if (VALA_IS_UNARY_EXPRESSION (_tmp48_)) {
			ValaExpression* _tmp49_;
			ValaUnaryOperator _tmp50_;
			ValaUnaryOperator _tmp51_;
			_tmp49_ = expr;
			_tmp50_ = vala_unary_expression_get_operator (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression));
			_tmp51_ = _tmp50_;
			_tmp47_ = _tmp51_ == VALA_UNARY_OPERATOR_LOGICAL_NEGATION;
		} else {
			_tmp47_ = FALSE;
		}
		if (_tmp47_) {
			ValaExpression* _tmp52_;
			ValaExpression* _tmp53_;
			ValaExpression* _tmp54_;
			_tmp52_ = expr;
			_tmp53_ = vala_unary_expression_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression));
			_tmp54_ = _tmp53_;
			expr = _tmp54_;
			is_negation = !is_negation;
		}
		_tmp55_ = expr;
		type_check = VALA_IS_TYPECHECK (_tmp55_) ? ((ValaTypeCheck*) _tmp55_) : NULL;
		if (!is_negation) {
			ValaTypeCheck* _tmp57_;
			_tmp57_ = type_check;
			_tmp56_ = _tmp57_ != NULL;
		} else {
			_tmp56_ = FALSE;
		}
		if (_tmp56_) {
			ValaTypeSymbol* narrowed_symnol = NULL;
			ValaTypeCheck* _tmp58_;
			ValaDataType* _tmp59_;
			ValaDataType* _tmp60_;
			ValaTypeSymbol* _tmp61_;
			ValaTypeSymbol* _tmp62_;
			ValaVariable* _tmp63_;
			ValaTypeCheck* _tmp64_;
			ValaExpression* _tmp65_;
			ValaExpression* _tmp66_;
			ValaSymbol* _tmp67_;
			ValaSymbol* _tmp68_;
			_tmp58_ = type_check;
			_tmp59_ = vala_typecheck_get_type_reference (_tmp58_);
			_tmp60_ = _tmp59_;
			_tmp61_ = vala_data_type_get_type_symbol (_tmp60_);
			_tmp62_ = _tmp61_;
			narrowed_symnol = _tmp62_;
			_tmp63_ = variable;
			_tmp64_ = type_check;
			_tmp65_ = vala_typecheck_get_expression (_tmp64_);
			_tmp66_ = _tmp65_;
			_tmp67_ = vala_expression_get_symbol_reference (_tmp66_);
			_tmp68_ = _tmp67_;
			if (G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, VALA_TYPE_SYMBOL, ValaSymbol) == _tmp68_) {
				ValaTypeSymbol* _tmp69_;
				ValaDataType* _tmp70_;
				ValaDataType* _tmp71_;
				ValaTypeSymbol* _tmp72_;
				ValaTypeSymbol* _tmp73_;
				ValaDataType* _tmp77_;
				ValaDataType* _tmp78_;
				_tmp69_ = narrowed_symnol;
				_tmp70_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp71_ = _tmp70_;
				_tmp72_ = vala_data_type_get_type_symbol (_tmp71_);
				_tmp73_ = _tmp72_;
				if (_tmp69_ != _tmp73_) {
					ValaDataType* _tmp74_;
					ValaDataType* _tmp75_;
					ValaTypeSymbol* _tmp76_;
					_tmp74_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp75_ = _tmp74_;
					_tmp76_ = narrowed_symnol;
					vala_data_type_set_context_symbol (_tmp75_, (ValaSymbol*) _tmp76_);
				}
				_tmp77_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp78_ = _tmp77_;
				vala_data_type_set_nullable (_tmp78_, FALSE);
			}
		}
	}
	_tmp79_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp80_ = _tmp79_;
	_tmp81_ = vala_data_type_get_context_symbol (_tmp80_);
	_tmp82_ = _tmp81_;
	if (_tmp82_ == NULL) {
		{
			ValaArrayList* _type_check_list = NULL;
			ValaArrayList* _tmp83_;
			gint _type_check_size = 0;
			ValaArrayList* _tmp84_;
			gint _tmp85_;
			gint _tmp86_;
			gint _type_check_index = 0;
			_tmp83_ = scope_type_checks;
			_type_check_list = _tmp83_;
			_tmp84_ = _type_check_list;
			_tmp85_ = vala_collection_get_size ((ValaCollection*) _tmp84_);
			_tmp86_ = _tmp85_;
			_type_check_size = _tmp86_;
			_type_check_index = -1;
			while (TRUE) {
				gint _tmp87_;
				gint _tmp88_;
				ValaTypeCheck* type_check = NULL;
				ValaArrayList* _tmp89_;
				gpointer _tmp90_;
				ValaTypeCheck* _tmp91_;
				ValaTypeSymbol* narrowed_symnol = NULL;
				ValaTypeCheck* _tmp92_;
				ValaDataType* _tmp93_;
				ValaDataType* _tmp94_;
				ValaTypeSymbol* _tmp95_;
				ValaTypeSymbol* _tmp96_;
				ValaVariable* _tmp97_;
				ValaTypeCheck* _tmp98_;
				ValaExpression* _tmp99_;
				ValaExpression* _tmp100_;
				ValaSymbol* _tmp101_;
				ValaSymbol* _tmp102_;
				_type_check_index = _type_check_index + 1;
				_tmp87_ = _type_check_index;
				_tmp88_ = _type_check_size;
				if (!(_tmp87_ < _tmp88_)) {
					break;
				}
				_tmp89_ = _type_check_list;
				_tmp90_ = vala_list_get ((ValaList*) _tmp89_, _type_check_index);
				_tmp91_ = _vala_code_node_ref0 ((ValaTypeCheck*) _tmp90_);
				type_check = _tmp91_;
				_tmp92_ = type_check;
				_tmp93_ = vala_typecheck_get_type_reference (_tmp92_);
				_tmp94_ = _tmp93_;
				_tmp95_ = vala_data_type_get_type_symbol (_tmp94_);
				_tmp96_ = _tmp95_;
				narrowed_symnol = _tmp96_;
				_tmp97_ = variable;
				_tmp98_ = type_check;
				_tmp99_ = vala_typecheck_get_expression (_tmp98_);
				_tmp100_ = _tmp99_;
				_tmp101_ = vala_expression_get_symbol_reference (_tmp100_);
				_tmp102_ = _tmp101_;
				if (G_TYPE_CHECK_INSTANCE_CAST (_tmp97_, VALA_TYPE_SYMBOL, ValaSymbol) == _tmp102_) {
					ValaTypeSymbol* _tmp103_;
					ValaDataType* _tmp104_;
					ValaDataType* _tmp105_;
					ValaTypeSymbol* _tmp106_;
					ValaTypeSymbol* _tmp107_;
					ValaDataType* _tmp111_;
					ValaDataType* _tmp112_;
					_tmp103_ = narrowed_symnol;
					_tmp104_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp105_ = _tmp104_;
					_tmp106_ = vala_data_type_get_type_symbol (_tmp105_);
					_tmp107_ = _tmp106_;
					if (_tmp103_ != _tmp107_) {
						ValaDataType* _tmp108_;
						ValaDataType* _tmp109_;
						ValaTypeSymbol* _tmp110_;
						_tmp108_ = vala_expression_get_value_type ((ValaExpression*) self);
						_tmp109_ = _tmp108_;
						_tmp110_ = narrowed_symnol;
						vala_data_type_set_context_symbol (_tmp109_, (ValaSymbol*) _tmp110_);
					}
					_tmp111_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp112_ = _tmp111_;
					vala_data_type_set_nullable (_tmp112_, FALSE);
				}
				_vala_code_node_unref0 (type_check);
			}
		}
	}
	_vala_iterable_unref0 (scope_type_checks);
}

static void
vala_member_access_class_init (ValaMemberAccessClass * klass,
                               gpointer klass_data)
{
	vala_member_access_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_member_access_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMemberAccess_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept_children;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_member_access_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_member_access_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_member_access_real_is_accessible;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_member_access_real_replace_type;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_constant;
	((ValaExpressionClass *) klass)->is_non_null = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_non_null;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_member_access_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_member_access_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_member_access_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_used_variables;
}

static void
vala_member_access_instance_init (ValaMemberAccess * self,
                                  gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_member_access_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->type_argument_list = (ValaList*) _tmp1_;
}

static void
vala_member_access_finalize (ValaCodeNode * obj)
{
	ValaMemberAccess * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
	_g_free0 (self->priv->_member_name);
	_vala_code_node_unref0 (self->priv->_inner);
	_vala_iterable_unref0 (self->priv->type_argument_list);
	VALA_CODE_NODE_CLASS (vala_member_access_parent_class)->finalize (obj);
}

/**
 * Represents an access to a type member in the source code.
 */
static GType
vala_member_access_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaMemberAccessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_member_access_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMemberAccess), 0, (GInstanceInitFunc) vala_member_access_instance_init, NULL };
	GType vala_member_access_type_id;
	vala_member_access_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMemberAccess", &g_define_type_info, 0);
	ValaMemberAccess_private_offset = g_type_add_instance_private (vala_member_access_type_id, sizeof (ValaMemberAccessPrivate));
	return vala_member_access_type_id;
}

GType
vala_member_access_get_type (void)
{
	static volatile gsize vala_member_access_type_id__volatile = 0;
	if (g_once_init_enter (&vala_member_access_type_id__volatile)) {
		GType vala_member_access_type_id;
		vala_member_access_type_id = vala_member_access_get_type_once ();
		g_once_init_leave (&vala_member_access_type_id__volatile, vala_member_access_type_id);
	}
	return vala_member_access_type_id__volatile;
}

