// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use atk_sys;
use glib::object::Cast;
use glib::object::IsA;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib_sys;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem;
use std::mem::transmute;
use CoordType;
use Layer;
use Object;
use Rectangle;
#[cfg(any(feature = "v2_30", feature = "dox"))]
use ScrollType;

glib_wrapper! {
    pub struct Component(Interface<atk_sys::AtkComponent>);

    match fn {
        get_type => || atk_sys::atk_component_get_type(),
    }
}

pub const NONE_COMPONENT: Option<&Component> = None;

pub trait ComponentExt: 'static {
    fn contains(&self, x: i32, y: i32, coord_type: CoordType) -> bool;

    fn get_alpha(&self) -> f64;

    fn get_extents(&self, coord_type: CoordType) -> (i32, i32, i32, i32);

    fn get_layer(&self) -> Layer;

    fn get_mdi_zorder(&self) -> i32;

    fn get_position(&self, coord_type: CoordType) -> (i32, i32);

    fn get_size(&self) -> (i32, i32);

    fn grab_focus(&self) -> bool;

    fn ref_accessible_at_point(&self, x: i32, y: i32, coord_type: CoordType) -> Option<Object>;

    #[cfg(any(feature = "v2_30", feature = "dox"))]
    fn scroll_to(&self, type_: ScrollType) -> bool;

    #[cfg(any(feature = "v2_30", feature = "dox"))]
    fn scroll_to_point(&self, coords: CoordType, x: i32, y: i32) -> bool;

    fn set_extents(&self, x: i32, y: i32, width: i32, height: i32, coord_type: CoordType) -> bool;

    fn set_position(&self, x: i32, y: i32, coord_type: CoordType) -> bool;

    fn set_size(&self, width: i32, height: i32) -> bool;

    fn connect_bounds_changed<F: Fn(&Self, &Rectangle) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<Component>> ComponentExt for O {
    fn contains(&self, x: i32, y: i32, coord_type: CoordType) -> bool {
        unsafe {
            from_glib(atk_sys::atk_component_contains(
                self.as_ref().to_glib_none().0,
                x,
                y,
                coord_type.to_glib(),
            ))
        }
    }

    fn get_alpha(&self) -> f64 {
        unsafe { atk_sys::atk_component_get_alpha(self.as_ref().to_glib_none().0) }
    }

    fn get_extents(&self, coord_type: CoordType) -> (i32, i32, i32, i32) {
        unsafe {
            let mut x = mem::MaybeUninit::uninit();
            let mut y = mem::MaybeUninit::uninit();
            let mut width = mem::MaybeUninit::uninit();
            let mut height = mem::MaybeUninit::uninit();
            atk_sys::atk_component_get_extents(
                self.as_ref().to_glib_none().0,
                x.as_mut_ptr(),
                y.as_mut_ptr(),
                width.as_mut_ptr(),
                height.as_mut_ptr(),
                coord_type.to_glib(),
            );
            let x = x.assume_init();
            let y = y.assume_init();
            let width = width.assume_init();
            let height = height.assume_init();
            (x, y, width, height)
        }
    }

    fn get_layer(&self) -> Layer {
        unsafe {
            from_glib(atk_sys::atk_component_get_layer(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_mdi_zorder(&self) -> i32 {
        unsafe { atk_sys::atk_component_get_mdi_zorder(self.as_ref().to_glib_none().0) }
    }

    fn get_position(&self, coord_type: CoordType) -> (i32, i32) {
        unsafe {
            let mut x = mem::MaybeUninit::uninit();
            let mut y = mem::MaybeUninit::uninit();
            atk_sys::atk_component_get_position(
                self.as_ref().to_glib_none().0,
                x.as_mut_ptr(),
                y.as_mut_ptr(),
                coord_type.to_glib(),
            );
            let x = x.assume_init();
            let y = y.assume_init();
            (x, y)
        }
    }

    fn get_size(&self) -> (i32, i32) {
        unsafe {
            let mut width = mem::MaybeUninit::uninit();
            let mut height = mem::MaybeUninit::uninit();
            atk_sys::atk_component_get_size(
                self.as_ref().to_glib_none().0,
                width.as_mut_ptr(),
                height.as_mut_ptr(),
            );
            let width = width.assume_init();
            let height = height.assume_init();
            (width, height)
        }
    }

    fn grab_focus(&self) -> bool {
        unsafe {
            from_glib(atk_sys::atk_component_grab_focus(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn ref_accessible_at_point(&self, x: i32, y: i32, coord_type: CoordType) -> Option<Object> {
        unsafe {
            from_glib_full(atk_sys::atk_component_ref_accessible_at_point(
                self.as_ref().to_glib_none().0,
                x,
                y,
                coord_type.to_glib(),
            ))
        }
    }

    #[cfg(any(feature = "v2_30", feature = "dox"))]
    fn scroll_to(&self, type_: ScrollType) -> bool {
        unsafe {
            from_glib(atk_sys::atk_component_scroll_to(
                self.as_ref().to_glib_none().0,
                type_.to_glib(),
            ))
        }
    }

    #[cfg(any(feature = "v2_30", feature = "dox"))]
    fn scroll_to_point(&self, coords: CoordType, x: i32, y: i32) -> bool {
        unsafe {
            from_glib(atk_sys::atk_component_scroll_to_point(
                self.as_ref().to_glib_none().0,
                coords.to_glib(),
                x,
                y,
            ))
        }
    }

    fn set_extents(&self, x: i32, y: i32, width: i32, height: i32, coord_type: CoordType) -> bool {
        unsafe {
            from_glib(atk_sys::atk_component_set_extents(
                self.as_ref().to_glib_none().0,
                x,
                y,
                width,
                height,
                coord_type.to_glib(),
            ))
        }
    }

    fn set_position(&self, x: i32, y: i32, coord_type: CoordType) -> bool {
        unsafe {
            from_glib(atk_sys::atk_component_set_position(
                self.as_ref().to_glib_none().0,
                x,
                y,
                coord_type.to_glib(),
            ))
        }
    }

    fn set_size(&self, width: i32, height: i32) -> bool {
        unsafe {
            from_glib(atk_sys::atk_component_set_size(
                self.as_ref().to_glib_none().0,
                width,
                height,
            ))
        }
    }

    fn connect_bounds_changed<F: Fn(&Self, &Rectangle) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn bounds_changed_trampoline<P, F: Fn(&P, &Rectangle) + 'static>(
            this: *mut atk_sys::AtkComponent,
            arg1: *mut atk_sys::AtkRectangle,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Component>,
        {
            let f: &F = &*(f as *const F);
            f(
                &Component::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(arg1),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"bounds-changed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    bounds_changed_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for Component {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "Component")
    }
}
