/* valamemberaccess.c generated by valac, the Vala compiler
 * generated from valamemberaccess.vala, do not modify */

/* valamemberaccess.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))

struct _ValaMemberAccessPrivate {
	gchar* _member_name;
	gboolean _pointer_member_access;
	gboolean _prototype_access;
	gboolean _tainted_access;
	gboolean _creation_member;
	gboolean _qualified;
	gboolean _null_safe_access;
	ValaExpression* _inner;
	ValaList* type_argument_list;
	gboolean is_with_variable_access;
};

struct _Block1Data {
	int _ref_count_;
	ValaMemberAccess* self;
	gboolean found;
};

static gint ValaMemberAccess_private_offset;
static gpointer vala_member_access_parent_class = NULL;

static void vala_member_access_real_accept (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor);
static void vala_member_access_real_accept_children (ValaCodeNode* base,
                                              ValaCodeVisitor* visitor);
static gchar* vala_member_access_real_to_string (ValaCodeNode* base);
static void vala_member_access_real_replace_expression (ValaCodeNode* base,
                                                 ValaExpression* old_node,
                                                 ValaExpression* new_node);
static gboolean vala_member_access_real_is_pure (ValaExpression* base);
static gboolean vala_member_access_real_is_accessible (ValaExpression* base,
                                                ValaSymbol* sym);
static void vala_member_access_real_replace_type (ValaCodeNode* base,
                                           ValaDataType* old_type,
                                           ValaDataType* new_type);
static gboolean vala_member_access_real_is_constant (ValaExpression* base);
static gboolean vala_member_access_real_is_non_null (ValaExpression* base);
static void vala_member_access_real_get_error_types (ValaCodeNode* base,
                                              ValaCollection* collection,
                                              ValaSourceReference* source_reference);
static gboolean vala_member_access_real_check (ValaCodeNode* base,
                                        ValaCodeContext* context);
static gboolean vala_member_access_is_instance_symbol (ValaSymbol* symbol);
static void vala_member_access_check_narrowed_value_type (ValaMemberAccess* self);
static gboolean vala_member_access_is_tainted (ValaMemberAccess* self);
static void vala_member_access_real_emit (ValaCodeNode* base,
                                   ValaCodeGenerator* codegen);
static void vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                                    ValaCollection* collection);
static void vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                                 ValaCollection* collection);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static ValaTraverseStatus __lambda4_ (Block1Data* _data1_,
                               ValaCodeNode* n);
static ValaTraverseStatus ___lambda4__vala_traverse_func (ValaCodeNode* node,
                                                   gpointer self);
static void vala_member_access_finalize (ValaCodeNode * obj);
static GType vala_member_access_get_type_once (void);

static inline gpointer
vala_member_access_get_instance_private (ValaMemberAccess* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMemberAccess_private_offset);
}

ValaExpression*
vala_member_access_get_inner (ValaMemberAccess* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_inner;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_member_access_set_inner (ValaMemberAccess* self,
                              ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_inner);
	self->priv->_inner = _tmp0_;
	_tmp1_ = self->priv->_inner;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		_tmp2_ = self->priv->_inner;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}

const gchar*
vala_member_access_get_member_name (ValaMemberAccess* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_member_name;
	result = _tmp0_;
	return result;
}

void
vala_member_access_set_member_name (ValaMemberAccess* self,
                                    const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_member_name);
	self->priv->_member_name = _tmp0_;
}

gboolean
vala_member_access_get_pointer_member_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_pointer_member_access;
	return result;
}

void
vala_member_access_set_pointer_member_access (ValaMemberAccess* self,
                                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_pointer_member_access = value;
}

gboolean
vala_member_access_get_prototype_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_prototype_access;
	return result;
}

void
vala_member_access_set_prototype_access (ValaMemberAccess* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_prototype_access = value;
}

gboolean
vala_member_access_get_tainted_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_tainted_access;
	return result;
}

void
vala_member_access_set_tainted_access (ValaMemberAccess* self,
                                       gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_tainted_access = value;
}

gboolean
vala_member_access_get_creation_member (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_creation_member;
	return result;
}

void
vala_member_access_set_creation_member (ValaMemberAccess* self,
                                        gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_creation_member = value;
}

gboolean
vala_member_access_get_qualified (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_qualified;
	return result;
}

void
vala_member_access_set_qualified (ValaMemberAccess* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_qualified = value;
}

gboolean
vala_member_access_get_null_safe_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_null_safe_access;
	return result;
}

void
vala_member_access_set_null_safe_access (ValaMemberAccess* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_null_safe_access = value;
}

/**
 * Creates a new member access expression.
 *
 * @param inner            parent of the member
 * @param member_name      member name
 * @param source_reference reference to source code
 * @return                 newly created member access expression
 */
ValaMemberAccess*
vala_member_access_construct (GType object_type,
                              ValaExpression* inner,
                              const gchar* member_name,
                              ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new (ValaExpression* inner,
                        const gchar* member_name,
                        ValaSourceReference* source_reference)
{
	return vala_member_access_construct (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_simple (GType object_type,
                                     const gchar* member_name,
                                     ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, NULL);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new_simple (const gchar* member_name,
                               ValaSourceReference* source_reference)
{
	return vala_member_access_construct_simple (VALA_TYPE_MEMBER_ACCESS, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_pointer (GType object_type,
                                      ValaExpression* inner,
                                      const gchar* member_name,
                                      ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (inner != NULL, NULL);
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_member_access_set_pointer_member_access (self, TRUE);
	return self;
}

ValaMemberAccess*
vala_member_access_new_pointer (ValaExpression* inner,
                                const gchar* member_name,
                                ValaSourceReference* source_reference)
{
	return vala_member_access_construct_pointer (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

/**
 * Appends the specified type as generic type argument.
 *
 * @param arg a type reference
 */
void
vala_member_access_add_type_argument (ValaMemberAccess* self,
                                      ValaDataType* arg)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->type_argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}

/**
 * Returns the list of generic type arguments.
 *
 * @return type argument list
 */
ValaList*
vala_member_access_get_type_arguments (ValaMemberAccess* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_argument_list;
	result = _tmp0_;
	return result;
}

static void
vala_member_access_real_accept (ValaCodeNode* base,
                                ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_member_access (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_member_access_real_accept_children (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp4_;
		gint _type_arg_size = 0;
		ValaList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _type_arg_index = 0;
		_tmp4_ = self->priv->type_argument_list;
		_type_arg_list = _tmp4_;
		_tmp5_ = _type_arg_list;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_type_arg_size = _tmp7_;
		_type_arg_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			ValaDataType* type_arg = NULL;
			ValaList* _tmp10_;
			gpointer _tmp11_;
			ValaDataType* _tmp12_;
			_type_arg_index = _type_arg_index + 1;
			_tmp8_ = _type_arg_index;
			_tmp9_ = _type_arg_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _type_arg_list;
			_tmp11_ = vala_list_get (_tmp10_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp11_;
			_tmp12_ = type_arg;
			vala_code_node_accept ((ValaCodeNode*) _tmp12_, visitor);
			_vala_code_node_unref0 (type_arg);
		}
	}
}

static gchar*
vala_member_access_real_to_string (ValaCodeNode* base)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	gchar* result = NULL;
	self = (ValaMemberAccess*) base;
	_tmp1_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_symbol_is_instance_member (_tmp4_);
	}
	if (_tmp0_) {
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		_tmp5_ = vala_member_access_get_inner (self);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == NULL) {
			const gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp7_ = self->priv->_member_name;
			_tmp8_ = g_strdup (_tmp7_);
			result = _tmp8_;
			return result;
		} else {
			const gchar* _tmp9_ = NULL;
			gboolean _tmp10_;
			ValaExpression* _tmp11_;
			ValaExpression* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp10_ = self->priv->_pointer_member_access;
			if (_tmp10_) {
				_tmp9_ = "->";
			} else {
				_tmp9_ = ".";
			}
			_tmp11_ = vala_member_access_get_inner (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_code_node_to_string ((ValaCodeNode*) _tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = self->priv->_member_name;
			_tmp16_ = g_strdup_printf ("%s%s%s", _tmp14_, _tmp9_, _tmp15_);
			_tmp17_ = _tmp16_;
			_g_free0 (_tmp14_);
			result = _tmp17_;
			return result;
		}
	} else {
		ValaSymbol* _tmp18_;
		ValaSymbol* _tmp19_;
		gchar* _tmp20_;
		_tmp18_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_symbol_get_full_name (_tmp19_);
		result = _tmp20_;
		return result;
	}
}

static void
vala_member_access_real_replace_expression (ValaCodeNode* base,
                                            ValaExpression* old_node,
                                            ValaExpression* new_node)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_member_access_set_inner (self, new_node);
	}
}

static gboolean
vala_member_access_real_is_pure (ValaExpression* base)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_pure (_tmp5_);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = !VALA_IS_PROPERTY (_tmp7_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_member_access_real_is_accessible (ValaExpression* base,
                                       ValaSymbol* sym)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_accessible (_tmp5_, sym);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = vala_symbol_is_accessible (_tmp7_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
vala_member_access_real_replace_type (ValaCodeNode* base,
                                      ValaDataType* old_type,
                                      ValaDataType* new_type)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaDataType* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->type_argument_list;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->type_argument_list;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaDataType*) _tmp6_;
				_tmp8_ = _tmp7_ == old_type;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->type_argument_list;
					vala_list_set (_tmp9_, i, new_type);
					return;
				}
			}
		}
	}
}

static gboolean
vala_member_access_real_is_constant (ValaExpression* base)
{
	ValaMemberAccess * self;
	ValaMethod* method = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	method = VALA_IS_METHOD (_tmp1_) ? ((ValaMethod*) _tmp1_) : NULL;
	_tmp2_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp3_ = _tmp2_;
	if (VALA_IS_CONSTANT (_tmp3_)) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		if (VALA_IS_ARRAY_LENGTH_FIELD (_tmp7_)) {
			ValaExpression* _tmp8_;
			ValaExpression* _tmp9_;
			_tmp8_ = vala_member_access_get_inner (self);
			_tmp9_ = _tmp8_;
			_tmp5_ = _tmp9_ != NULL;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			ValaExpression* _tmp10_;
			ValaExpression* _tmp11_;
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			_tmp10_ = vala_member_access_get_inner (self);
			_tmp11_ = _tmp10_;
			_tmp12_ = vala_expression_get_symbol_reference (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp4_ = VALA_IS_CONSTANT (_tmp13_);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp14_ = FALSE;
			ValaMethod* _tmp15_;
			_tmp15_ = method;
			if (_tmp15_ != NULL) {
				gboolean _tmp16_ = FALSE;
				ValaMethod* _tmp17_;
				ValaMemberBinding _tmp18_;
				ValaMemberBinding _tmp19_;
				_tmp17_ = method;
				_tmp18_ = vala_method_get_binding (_tmp17_);
				_tmp19_ = _tmp18_;
				if (_tmp19_ == VALA_MEMBER_BINDING_STATIC) {
					_tmp16_ = TRUE;
				} else {
					gboolean _tmp20_;
					_tmp20_ = self->priv->_prototype_access;
					_tmp16_ = _tmp20_;
				}
				_tmp14_ = _tmp16_;
			} else {
				_tmp14_ = FALSE;
			}
			if (_tmp14_) {
				result = TRUE;
				return result;
			} else {
				result = FALSE;
				return result;
			}
		}
	}
}

static gboolean
vala_member_access_real_is_non_null (ValaExpression* base)
{
	ValaMemberAccess * self;
	ValaConstant* c = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaConstant* _tmp2_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	c = VALA_IS_CONSTANT (_tmp1_) ? ((ValaConstant*) _tmp1_) : NULL;
	_tmp2_ = c;
	if (_tmp2_ != NULL) {
		gboolean _tmp3_ = FALSE;
		ValaConstant* _tmp4_;
		_tmp4_ = c;
		if (VALA_IS_ENUM_VALUE (_tmp4_)) {
			_tmp3_ = TRUE;
		} else {
			ValaConstant* _tmp5_;
			ValaDataType* _tmp6_;
			ValaDataType* _tmp7_;
			gboolean _tmp8_;
			gboolean _tmp9_;
			_tmp5_ = c;
			_tmp6_ = vala_constant_get_type_reference (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = vala_data_type_get_nullable (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp3_ = !_tmp9_;
		}
		result = _tmp3_;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

static void
vala_member_access_real_get_error_types (ValaCodeNode* base,
                                         ValaCollection* collection,
                                         ValaSourceReference* source_reference)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp3_, collection, source_reference);
	}
}

static gboolean
vala_member_access_real_check (ValaCodeNode* base,
                               ValaCodeContext* context)
{
	ValaMemberAccess * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_;
	ValaExpression* _tmp7_;
	ValaExpression* _tmp8_;
	ValaSymbol* base_symbol = NULL;
	ValaParameter* this_parameter = NULL;
	gboolean may_access_instance_members = FALSE;
	gboolean may_access_klass_members = FALSE;
	ValaArrayList* visited_types = NULL;
	GEqualFunc _tmp20_;
	ValaArrayList* _tmp21_;
	gboolean _tmp22_;
	gboolean _tmp678_ = FALSE;
	gboolean _tmp679_ = FALSE;
	gboolean _tmp680_ = FALSE;
	ValaExpression* _tmp681_;
	ValaExpression* _tmp682_;
	ValaSymbol* _tmp709_;
	ValaSymbol* _tmp710_;
	ValaSymbol* _tmp779_;
	ValaSymbol* _tmp780_;
	ValaSymbol* member = NULL;
	ValaSymbol* _tmp816_;
	ValaSymbol* _tmp817_;
	ValaSymbolAccessibility access = 0;
	gboolean instance = FALSE;
	gboolean klass = FALSE;
	gboolean generics = FALSE;
	ValaSymbol* _tmp818_;
	ValaSymbol* _tmp819_;
	ValaCodeNode* parent = NULL;
	ValaCodeNode* _tmp1267_;
	ValaSymbol* _tmp1268_;
	ValaSymbol* _tmp1270_;
	ValaVersionAttribute* _tmp1271_;
	ValaVersionAttribute* _tmp1272_;
	ValaSourceReference* _tmp1273_;
	ValaSourceReference* _tmp1274_;
	gboolean _tmp1275_ = FALSE;
	ValaSymbolAccessibility _tmp1276_;
	gboolean _tmp1328_ = FALSE;
	gboolean _tmp1355_ = FALSE;
	gboolean _tmp1356_ = FALSE;
	ValaDataType* _tmp1657_;
	ValaDataType* _tmp1658_;
	gboolean _tmp1661_;
	gboolean _tmp1662_;
	gboolean _tmp1663_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = self->priv->_null_safe_access;
	if (_tmp4_) {
		gboolean _tmp5_;
		gboolean _tmp6_;
		vala_code_node_set_error ((ValaCodeNode*) self, !VALA_CODE_NODE_CLASS (vala_member_access_parent_class)->check ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression), context));
		_tmp5_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp6_ = _tmp5_;
		result = !_tmp6_;
		return result;
	}
	_tmp7_ = vala_member_access_get_inner (self);
	_tmp8_ = _tmp7_;
	if (_tmp8_ != NULL) {
		ValaExpression* _tmp9_;
		ValaExpression* _tmp10_;
		_tmp9_ = vala_member_access_get_inner (self);
		_tmp10_ = _tmp9_;
		vala_code_node_check ((ValaCodeNode*) _tmp10_, context);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp11_;
		gint _type_arg_size = 0;
		ValaList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _type_arg_index = 0;
		_tmp11_ = self->priv->type_argument_list;
		_type_arg_list = _tmp11_;
		_tmp12_ = _type_arg_list;
		_tmp13_ = vala_collection_get_size ((ValaCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		_type_arg_size = _tmp14_;
		_type_arg_index = -1;
		while (TRUE) {
			gint _tmp15_;
			gint _tmp16_;
			ValaDataType* type_arg = NULL;
			ValaList* _tmp17_;
			gpointer _tmp18_;
			ValaDataType* _tmp19_;
			_type_arg_index = _type_arg_index + 1;
			_tmp15_ = _type_arg_index;
			_tmp16_ = _type_arg_size;
			if (!(_tmp15_ < _tmp16_)) {
				break;
			}
			_tmp17_ = _type_arg_list;
			_tmp18_ = vala_list_get (_tmp17_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp18_;
			_tmp19_ = type_arg;
			vala_code_node_check ((ValaCodeNode*) _tmp19_, context);
			_vala_code_node_unref0 (type_arg);
		}
	}
	base_symbol = NULL;
	this_parameter = NULL;
	may_access_instance_members = FALSE;
	may_access_klass_members = FALSE;
	_tmp20_ = g_direct_equal;
	_tmp21_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp20_);
	visited_types = _tmp21_;
	vala_expression_set_symbol_reference ((ValaExpression*) self, NULL);
	_tmp22_ = self->priv->_qualified;
	if (_tmp22_) {
		ValaNamespace* _tmp23_;
		ValaNamespace* _tmp24_;
		ValaSymbol* _tmp25_;
		ValaScope* _tmp26_;
		ValaScope* _tmp27_;
		const gchar* _tmp28_;
		ValaSymbol* _tmp29_;
		ValaSymbol* _tmp30_;
		_tmp23_ = vala_code_context_get_root (context);
		_tmp24_ = _tmp23_;
		base_symbol = (ValaSymbol*) _tmp24_;
		_tmp25_ = base_symbol;
		_tmp26_ = vala_symbol_get_scope (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = self->priv->_member_name;
		_tmp29_ = vala_scope_lookup (_tmp27_, _tmp28_);
		_tmp30_ = _tmp29_;
		vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp30_);
		_vala_code_node_unref0 (_tmp30_);
	} else {
		ValaExpression* _tmp31_;
		ValaExpression* _tmp32_;
		_tmp31_ = vala_member_access_get_inner (self);
		_tmp32_ = _tmp31_;
		if (_tmp32_ == NULL) {
			const gchar* _tmp33_;
			ValaSemanticAnalyzer* _tmp38_;
			ValaSemanticAnalyzer* _tmp39_;
			ValaSymbol* _tmp40_;
			ValaSymbol* _tmp41_;
			gboolean method_found = FALSE;
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp42_;
			ValaSemanticAnalyzer* _tmp43_;
			ValaSymbol* _tmp44_;
			ValaSymbol* _tmp45_;
			gboolean _tmp182_ = FALSE;
			ValaSymbol* _tmp183_;
			ValaSymbol* _tmp184_;
			_tmp33_ = self->priv->_member_name;
			if (g_strcmp0 (_tmp33_, "this") == 0) {
				ValaSemanticAnalyzer* _tmp34_;
				ValaSemanticAnalyzer* _tmp35_;
				_tmp34_ = vala_code_context_get_analyzer (context);
				_tmp35_ = _tmp34_;
				if (!vala_semantic_analyzer_is_in_instance_method (_tmp35_)) {
					ValaSourceReference* _tmp36_;
					ValaSourceReference* _tmp37_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp36_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp37_ = _tmp36_;
					vala_report_error (_tmp37_, "This access invalid outside of instance methods");
					result = FALSE;
					_vala_iterable_unref0 (visited_types);
					return result;
				}
			}
			_tmp38_ = vala_code_context_get_analyzer (context);
			_tmp39_ = _tmp38_;
			_tmp40_ = vala_semantic_analyzer_get_current_symbol (_tmp39_);
			_tmp41_ = _tmp40_;
			base_symbol = _tmp41_;
			method_found = FALSE;
			_tmp42_ = vala_code_context_get_analyzer (context);
			_tmp43_ = _tmp42_;
			_tmp44_ = vala_semantic_analyzer_get_current_symbol (_tmp43_);
			_tmp45_ = _tmp44_;
			sym = _tmp45_;
			while (TRUE) {
				gboolean _tmp46_ = FALSE;
				ValaSymbol* _tmp47_;
				ValaSymbol* _tmp93_;
				const gchar* _tmp94_;
				ValaSymbol* _tmp95_;
				ValaSymbol* _tmp96_;
				gboolean _tmp97_ = FALSE;
				gboolean _tmp98_ = FALSE;
				gboolean _tmp135_ = FALSE;
				gboolean _tmp136_ = FALSE;
				ValaSymbol* _tmp137_;
				ValaSymbol* _tmp138_;
				ValaSymbol* _tmp176_;
				ValaSymbol* _tmp177_;
				ValaSymbol* _tmp179_;
				ValaSymbol* _tmp180_;
				ValaSymbol* _tmp181_;
				_tmp47_ = sym;
				if (_tmp47_ != NULL) {
					ValaSymbol* _tmp48_;
					ValaSymbol* _tmp49_;
					_tmp48_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp49_ = _tmp48_;
					_tmp46_ = _tmp49_ == NULL;
				} else {
					_tmp46_ = FALSE;
				}
				if (!_tmp46_) {
					break;
				}
				if (!method_found) {
					ValaSymbol* _tmp50_;
					_tmp50_ = sym;
					if (VALA_IS_CREATION_METHOD (_tmp50_)) {
						ValaCreationMethod* cm = NULL;
						ValaSymbol* _tmp51_;
						ValaCreationMethod* _tmp52_;
						ValaParameter* _tmp53_;
						ValaParameter* _tmp54_;
						_tmp51_ = sym;
						cm = G_TYPE_CHECK_INSTANCE_CAST (_tmp51_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod);
						_tmp52_ = cm;
						_tmp53_ = vala_method_get_this_parameter ((ValaMethod*) _tmp52_);
						_tmp54_ = _tmp53_;
						this_parameter = _tmp54_;
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
						method_found = TRUE;
					} else {
						ValaSymbol* _tmp55_;
						_tmp55_ = sym;
						if (VALA_IS_PROPERTY (_tmp55_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp56_;
							ValaProperty* _tmp57_;
							ValaParameter* _tmp58_;
							ValaParameter* _tmp59_;
							ValaProperty* _tmp60_;
							ValaMemberBinding _tmp61_;
							ValaMemberBinding _tmp62_;
							ValaProperty* _tmp63_;
							ValaMemberBinding _tmp64_;
							ValaMemberBinding _tmp65_;
							_tmp56_ = sym;
							prop = G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, VALA_TYPE_PROPERTY, ValaProperty);
							_tmp57_ = prop;
							_tmp58_ = vala_property_get_this_parameter (_tmp57_);
							_tmp59_ = _tmp58_;
							this_parameter = _tmp59_;
							_tmp60_ = prop;
							_tmp61_ = vala_property_get_binding (_tmp60_);
							_tmp62_ = _tmp61_;
							may_access_instance_members = _tmp62_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp63_ = prop;
							_tmp64_ = vala_property_get_binding (_tmp63_);
							_tmp65_ = _tmp64_;
							may_access_klass_members = _tmp65_ != VALA_MEMBER_BINDING_STATIC;
							method_found = TRUE;
						} else {
							ValaSymbol* _tmp66_;
							_tmp66_ = sym;
							if (VALA_IS_CONSTRUCTOR (_tmp66_)) {
								ValaConstructor* c = NULL;
								ValaSymbol* _tmp67_;
								ValaConstructor* _tmp68_;
								ValaParameter* _tmp69_;
								ValaParameter* _tmp70_;
								ValaConstructor* _tmp71_;
								ValaMemberBinding _tmp72_;
								ValaMemberBinding _tmp73_;
								_tmp67_ = sym;
								c = G_TYPE_CHECK_INSTANCE_CAST (_tmp67_, VALA_TYPE_CONSTRUCTOR, ValaConstructor);
								_tmp68_ = c;
								_tmp69_ = vala_constructor_get_this_parameter (_tmp68_);
								_tmp70_ = _tmp69_;
								this_parameter = _tmp70_;
								_tmp71_ = c;
								_tmp72_ = vala_constructor_get_binding (_tmp71_);
								_tmp73_ = _tmp72_;
								may_access_instance_members = _tmp73_ == VALA_MEMBER_BINDING_INSTANCE;
								may_access_klass_members = TRUE;
								method_found = TRUE;
							} else {
								ValaSymbol* _tmp74_;
								_tmp74_ = sym;
								if (VALA_IS_DESTRUCTOR (_tmp74_)) {
									ValaDestructor* d = NULL;
									ValaSymbol* _tmp75_;
									ValaDestructor* _tmp76_;
									ValaParameter* _tmp77_;
									ValaParameter* _tmp78_;
									ValaDestructor* _tmp79_;
									ValaMemberBinding _tmp80_;
									ValaMemberBinding _tmp81_;
									_tmp75_ = sym;
									d = G_TYPE_CHECK_INSTANCE_CAST (_tmp75_, VALA_TYPE_DESTRUCTOR, ValaDestructor);
									_tmp76_ = d;
									_tmp77_ = vala_destructor_get_this_parameter (_tmp76_);
									_tmp78_ = _tmp77_;
									this_parameter = _tmp78_;
									_tmp79_ = d;
									_tmp80_ = vala_destructor_get_binding (_tmp79_);
									_tmp81_ = _tmp80_;
									may_access_instance_members = _tmp81_ == VALA_MEMBER_BINDING_INSTANCE;
									may_access_klass_members = TRUE;
									method_found = TRUE;
								} else {
									ValaSymbol* _tmp82_;
									_tmp82_ = sym;
									if (VALA_IS_METHOD (_tmp82_)) {
										ValaMethod* m = NULL;
										ValaSymbol* _tmp83_;
										ValaMethod* _tmp84_;
										ValaParameter* _tmp85_;
										ValaParameter* _tmp86_;
										ValaMethod* _tmp87_;
										ValaMemberBinding _tmp88_;
										ValaMemberBinding _tmp89_;
										ValaMethod* _tmp90_;
										ValaMemberBinding _tmp91_;
										ValaMemberBinding _tmp92_;
										_tmp83_ = sym;
										m = G_TYPE_CHECK_INSTANCE_CAST (_tmp83_, VALA_TYPE_METHOD, ValaMethod);
										_tmp84_ = m;
										_tmp85_ = vala_method_get_this_parameter (_tmp84_);
										_tmp86_ = _tmp85_;
										this_parameter = _tmp86_;
										_tmp87_ = m;
										_tmp88_ = vala_method_get_binding (_tmp87_);
										_tmp89_ = _tmp88_;
										may_access_instance_members = _tmp89_ == VALA_MEMBER_BINDING_INSTANCE;
										_tmp90_ = m;
										_tmp91_ = vala_method_get_binding (_tmp90_);
										_tmp92_ = _tmp91_;
										may_access_klass_members = _tmp92_ != VALA_MEMBER_BINDING_STATIC;
										method_found = TRUE;
									}
								}
							}
						}
					}
				}
				_tmp93_ = sym;
				_tmp94_ = self->priv->_member_name;
				_tmp95_ = vala_semantic_analyzer_symbol_lookup_inherited (_tmp93_, _tmp94_);
				_tmp96_ = _tmp95_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp96_);
				_vala_code_node_unref0 (_tmp96_);
				if (!self->priv->is_with_variable_access) {
					ValaSymbol* _tmp99_;
					ValaSymbol* _tmp100_;
					_tmp99_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp100_ = _tmp99_;
					_tmp98_ = _tmp100_ == NULL;
				} else {
					_tmp98_ = FALSE;
				}
				if (_tmp98_) {
					ValaSymbol* _tmp101_;
					_tmp101_ = sym;
					_tmp97_ = VALA_IS_WITH_STATEMENT (_tmp101_);
				} else {
					_tmp97_ = FALSE;
				}
				if (_tmp97_) {
					ValaWithStatement* w = NULL;
					ValaSymbol* _tmp102_;
					ValaDataType* variable_type = NULL;
					ValaWithStatement* _tmp103_;
					ValaLocalVariable* _tmp104_;
					ValaLocalVariable* _tmp105_;
					ValaDataType* _tmp106_;
					ValaDataType* _tmp107_;
					ValaDataType* _tmp108_;
					ValaDataType* _tmp109_;
					ValaArrayList* _tmp114_;
					ValaDataType* _tmp115_;
					ValaDataType* _tmp116_;
					const gchar* _tmp117_;
					ValaSymbol* _tmp118_;
					ValaSymbol* _tmp119_;
					ValaSymbol* _tmp120_;
					ValaSymbol* _tmp121_;
					_tmp102_ = sym;
					w = G_TYPE_CHECK_INSTANCE_CAST (_tmp102_, VALA_TYPE_WITH_STATEMENT, ValaWithStatement);
					_tmp103_ = w;
					_tmp104_ = vala_with_statement_get_with_variable (_tmp103_);
					_tmp105_ = _tmp104_;
					_tmp106_ = vala_variable_get_variable_type ((ValaVariable*) _tmp105_);
					_tmp107_ = _tmp106_;
					_tmp108_ = _vala_code_node_ref0 (_tmp107_);
					variable_type = _tmp108_;
					_tmp109_ = variable_type;
					if (VALA_IS_POINTER_TYPE (_tmp109_)) {
						ValaDataType* _tmp110_;
						ValaDataType* _tmp111_;
						ValaDataType* _tmp112_;
						ValaDataType* _tmp113_;
						_tmp110_ = variable_type;
						_tmp111_ = vala_pointer_type_get_base_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp110_, VALA_TYPE_POINTER_TYPE, ValaPointerType));
						_tmp112_ = _tmp111_;
						_tmp113_ = _vala_code_node_ref0 (_tmp112_);
						_vala_code_node_unref0 (variable_type);
						variable_type = _tmp113_;
					}
					_tmp114_ = visited_types;
					_tmp115_ = variable_type;
					vala_collection_add ((ValaCollection*) _tmp114_, _tmp115_);
					_tmp116_ = variable_type;
					_tmp117_ = self->priv->_member_name;
					_tmp118_ = vala_data_type_get_member (_tmp116_, _tmp117_);
					_tmp119_ = _tmp118_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp119_);
					_vala_code_node_unref0 (_tmp119_);
					_tmp120_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp121_ = _tmp120_;
					if (_tmp121_ != NULL) {
						ValaWithStatement* _tmp122_;
						ValaLocalVariable* _tmp123_;
						ValaLocalVariable* _tmp124_;
						const gchar* _tmp125_;
						const gchar* _tmp126_;
						ValaSourceReference* _tmp127_;
						ValaSourceReference* _tmp128_;
						ValaMemberAccess* _tmp129_;
						ValaMemberAccess* _tmp130_;
						ValaExpression* _tmp131_;
						ValaExpression* _tmp132_;
						ValaExpression* _tmp133_;
						ValaExpression* _tmp134_;
						_tmp122_ = w;
						_tmp123_ = vala_with_statement_get_with_variable (_tmp122_);
						_tmp124_ = _tmp123_;
						_tmp125_ = vala_symbol_get_name ((ValaSymbol*) _tmp124_);
						_tmp126_ = _tmp125_;
						_tmp127_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp128_ = _tmp127_;
						_tmp129_ = vala_member_access_new (NULL, _tmp126_, _tmp128_);
						_tmp130_ = _tmp129_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp130_);
						_vala_code_node_unref0 (_tmp130_);
						_tmp131_ = vala_member_access_get_inner (self);
						_tmp132_ = _tmp131_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp132_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess)->priv->is_with_variable_access = TRUE;
						_tmp133_ = vala_member_access_get_inner (self);
						_tmp134_ = _tmp133_;
						vala_code_node_check ((ValaCodeNode*) _tmp134_, context);
						may_access_instance_members = TRUE;
					}
					_vala_code_node_unref0 (variable_type);
				}
				_tmp137_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp138_ = _tmp137_;
				if (_tmp138_ == NULL) {
					ValaSymbol* _tmp139_;
					_tmp139_ = sym;
					_tmp136_ = VALA_IS_TYPESYMBOL (_tmp139_);
				} else {
					_tmp136_ = FALSE;
				}
				if (_tmp136_) {
					_tmp135_ = may_access_instance_members;
				} else {
					_tmp135_ = FALSE;
				}
				if (_tmp135_) {
					ValaParameter* _tmp140_;
					ValaDataType* _tmp141_;
					ValaDataType* _tmp142_;
					const gchar* _tmp143_;
					ValaSymbol* _tmp144_;
					ValaSymbol* _tmp145_;
					gboolean _tmp146_ = FALSE;
					ValaSymbol* _tmp147_;
					ValaSymbol* _tmp148_;
					_tmp140_ = this_parameter;
					_tmp141_ = vala_variable_get_variable_type ((ValaVariable*) _tmp140_);
					_tmp142_ = _tmp141_;
					_tmp143_ = self->priv->_member_name;
					_tmp144_ = vala_data_type_get_member (_tmp142_, _tmp143_);
					_tmp145_ = _tmp144_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp145_);
					_vala_code_node_unref0 (_tmp145_);
					_tmp147_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp148_ = _tmp147_;
					if (_tmp148_ != NULL) {
						ValaSymbol* _tmp149_;
						ValaSymbol* _tmp150_;
						_tmp149_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
						_tmp150_ = _tmp149_;
						_tmp146_ = vala_member_access_is_instance_symbol (_tmp150_);
					} else {
						_tmp146_ = FALSE;
					}
					if (_tmp146_) {
						ValaSourceReference* _tmp151_;
						ValaSourceReference* _tmp152_;
						ValaMemberAccess* _tmp153_;
						ValaMemberAccess* _tmp154_;
						ValaExpression* _tmp155_;
						ValaExpression* _tmp156_;
						ValaParameter* _tmp157_;
						ValaDataType* _tmp158_;
						ValaDataType* _tmp159_;
						ValaDataType* _tmp160_;
						ValaDataType* _tmp161_;
						ValaExpression* _tmp162_;
						ValaExpression* _tmp163_;
						ValaDataType* _tmp164_;
						ValaDataType* _tmp165_;
						ValaExpression* _tmp166_;
						ValaExpression* _tmp167_;
						ValaParameter* _tmp168_;
						ValaExpression* _tmp169_;
						ValaExpression* _tmp170_;
						ValaDataType* _tmp171_;
						ValaDataType* _tmp172_;
						const gchar* _tmp173_;
						ValaSymbol* _tmp174_;
						ValaSymbol* _tmp175_;
						_tmp151_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp152_ = _tmp151_;
						_tmp153_ = vala_member_access_new (NULL, "this", _tmp152_);
						_tmp154_ = _tmp153_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp154_);
						_vala_code_node_unref0 (_tmp154_);
						_tmp155_ = vala_member_access_get_inner (self);
						_tmp156_ = _tmp155_;
						_tmp157_ = this_parameter;
						_tmp158_ = vala_variable_get_variable_type ((ValaVariable*) _tmp157_);
						_tmp159_ = _tmp158_;
						_tmp160_ = vala_data_type_copy (_tmp159_);
						_tmp161_ = _tmp160_;
						vala_expression_set_value_type (_tmp156_, _tmp161_);
						_vala_code_node_unref0 (_tmp161_);
						_tmp162_ = vala_member_access_get_inner (self);
						_tmp163_ = _tmp162_;
						_tmp164_ = vala_expression_get_value_type (_tmp163_);
						_tmp165_ = _tmp164_;
						vala_data_type_set_value_owned (_tmp165_, FALSE);
						_tmp166_ = vala_member_access_get_inner (self);
						_tmp167_ = _tmp166_;
						_tmp168_ = this_parameter;
						vala_expression_set_symbol_reference (_tmp167_, (ValaSymbol*) _tmp168_);
						_tmp169_ = vala_member_access_get_inner (self);
						_tmp170_ = _tmp169_;
						_tmp171_ = vala_expression_get_value_type (_tmp170_);
						_tmp172_ = _tmp171_;
						_tmp173_ = self->priv->_member_name;
						_tmp174_ = vala_data_type_get_member (_tmp172_, _tmp173_);
						_tmp175_ = _tmp174_;
						vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp175_);
						_vala_code_node_unref0 (_tmp175_);
					}
				}
				_tmp176_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp177_ = _tmp176_;
				if (_tmp177_ == NULL) {
					ValaSymbol* _tmp178_;
					_tmp178_ = sym;
					if (VALA_IS_TYPESYMBOL (_tmp178_)) {
						this_parameter = NULL;
						may_access_instance_members = FALSE;
						may_access_klass_members = FALSE;
					}
				}
				_tmp179_ = sym;
				_tmp180_ = vala_symbol_get_parent_symbol (_tmp179_);
				_tmp181_ = _tmp180_;
				sym = _tmp181_;
			}
			_tmp183_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp184_ = _tmp183_;
			if (_tmp184_ == NULL) {
				ValaSourceReference* _tmp185_;
				ValaSourceReference* _tmp186_;
				_tmp185_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp186_ = _tmp185_;
				_tmp182_ = _tmp186_ != NULL;
			} else {
				_tmp182_ = FALSE;
			}
			if (_tmp182_) {
				{
					ValaList* _ns_list = NULL;
					ValaSourceReference* _tmp187_;
					ValaSourceReference* _tmp188_;
					ValaList* _tmp189_;
					ValaList* _tmp190_;
					gint _ns_size = 0;
					ValaList* _tmp191_;
					gint _tmp192_;
					gint _tmp193_;
					gint _ns_index = 0;
					_tmp187_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp188_ = _tmp187_;
					_tmp189_ = vala_source_reference_get_using_directives (_tmp188_);
					_tmp190_ = _tmp189_;
					_ns_list = _tmp190_;
					_tmp191_ = _ns_list;
					_tmp192_ = vala_collection_get_size ((ValaCollection*) _tmp191_);
					_tmp193_ = _tmp192_;
					_ns_size = _tmp193_;
					_ns_index = -1;
					while (TRUE) {
						gint _tmp194_;
						gint _tmp195_;
						ValaUsingDirective* ns = NULL;
						ValaList* _tmp196_;
						gpointer _tmp197_;
						ValaUsingDirective* _tmp198_;
						gboolean _tmp199_;
						gboolean _tmp200_;
						ValaSymbol* local_sym = NULL;
						ValaUsingDirective* _tmp201_;
						ValaSymbol* _tmp202_;
						ValaSymbol* _tmp203_;
						ValaScope* _tmp204_;
						ValaScope* _tmp205_;
						const gchar* _tmp206_;
						ValaSymbol* _tmp207_;
						ValaSymbol* _tmp208_;
						_ns_index = _ns_index + 1;
						_tmp194_ = _ns_index;
						_tmp195_ = _ns_size;
						if (!(_tmp194_ < _tmp195_)) {
							break;
						}
						_tmp196_ = _ns_list;
						_tmp197_ = vala_list_get (_tmp196_, _ns_index);
						ns = (ValaUsingDirective*) _tmp197_;
						_tmp198_ = ns;
						_tmp199_ = vala_code_node_get_error ((ValaCodeNode*) _tmp198_);
						_tmp200_ = _tmp199_;
						if (_tmp200_) {
							_vala_code_node_unref0 (ns);
							continue;
						}
						_tmp201_ = ns;
						_tmp202_ = vala_using_directive_get_namespace_symbol (_tmp201_);
						_tmp203_ = _tmp202_;
						_tmp204_ = vala_symbol_get_scope (_tmp203_);
						_tmp205_ = _tmp204_;
						_tmp206_ = self->priv->_member_name;
						_tmp207_ = vala_scope_lookup (_tmp205_, _tmp206_);
						local_sym = _tmp207_;
						_tmp208_ = local_sym;
						if (_tmp208_ != NULL) {
							gboolean _tmp209_ = FALSE;
							ValaSymbol* _tmp210_;
							ValaSymbol* _tmp211_;
							ValaSymbol* inner_sym = NULL;
							ValaSymbol* _tmp225_;
							ValaSymbol* _tmp226_;
							ValaSymbol* _tmp227_;
							ValaMemberAccess* inner_ma = NULL;
							ValaMemberAccess* _tmp247_;
							ValaExpression* _tmp248_;
							ValaExpression* _tmp249_;
							ValaSymbol* _tmp250_;
							_tmp210_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp211_ = _tmp210_;
							if (_tmp211_ != NULL) {
								ValaSymbol* _tmp212_;
								ValaSymbol* _tmp213_;
								ValaSymbol* _tmp214_;
								_tmp212_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp213_ = _tmp212_;
								_tmp214_ = local_sym;
								_tmp209_ = _tmp213_ != _tmp214_;
							} else {
								_tmp209_ = FALSE;
							}
							if (_tmp209_) {
								ValaSourceReference* _tmp215_;
								ValaSourceReference* _tmp216_;
								const gchar* _tmp217_;
								ValaSymbol* _tmp218_;
								ValaSymbol* _tmp219_;
								gchar* _tmp220_;
								gchar* _tmp221_;
								ValaSymbol* _tmp222_;
								gchar* _tmp223_;
								gchar* _tmp224_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp215_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp216_ = _tmp215_;
								_tmp217_ = self->priv->_member_name;
								_tmp218_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp219_ = _tmp218_;
								_tmp220_ = vala_symbol_get_full_name (_tmp219_);
								_tmp221_ = _tmp220_;
								_tmp222_ = local_sym;
								_tmp223_ = vala_symbol_get_full_name (_tmp222_);
								_tmp224_ = _tmp223_;
								vala_report_error (_tmp216_, "`%s' is an ambiguous reference between `%s' and `%s'", _tmp217_, _tmp221_, _tmp224_);
								_g_free0 (_tmp224_);
								_g_free0 (_tmp221_);
								result = FALSE;
								_vala_code_node_unref0 (local_sym);
								_vala_code_node_unref0 (ns);
								_vala_iterable_unref0 (visited_types);
								return result;
							}
							_tmp225_ = local_sym;
							_tmp226_ = vala_symbol_get_parent_symbol (_tmp225_);
							_tmp227_ = _tmp226_;
							inner_sym = _tmp227_;
							inner_ma = self;
							while (TRUE) {
								gboolean _tmp228_ = FALSE;
								ValaSymbol* _tmp229_;
								ValaMemberAccess* _tmp233_;
								ValaSymbol* _tmp234_;
								const gchar* _tmp235_;
								const gchar* _tmp236_;
								ValaSourceReference* _tmp237_;
								ValaSourceReference* _tmp238_;
								ValaMemberAccess* _tmp239_;
								ValaMemberAccess* _tmp240_;
								ValaMemberAccess* _tmp241_;
								ValaExpression* _tmp242_;
								ValaExpression* _tmp243_;
								ValaSymbol* _tmp244_;
								ValaSymbol* _tmp245_;
								ValaSymbol* _tmp246_;
								_tmp229_ = inner_sym;
								if (_tmp229_ != NULL) {
									ValaSymbol* _tmp230_;
									const gchar* _tmp231_;
									const gchar* _tmp232_;
									_tmp230_ = inner_sym;
									_tmp231_ = vala_symbol_get_name (_tmp230_);
									_tmp232_ = _tmp231_;
									_tmp228_ = _tmp232_ != NULL;
								} else {
									_tmp228_ = FALSE;
								}
								if (!_tmp228_) {
									break;
								}
								_tmp233_ = inner_ma;
								_tmp234_ = inner_sym;
								_tmp235_ = vala_symbol_get_name (_tmp234_);
								_tmp236_ = _tmp235_;
								_tmp237_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp238_ = _tmp237_;
								_tmp239_ = vala_member_access_new (NULL, _tmp236_, _tmp238_);
								_tmp240_ = _tmp239_;
								vala_member_access_set_inner (_tmp233_, (ValaExpression*) _tmp240_);
								_vala_code_node_unref0 (_tmp240_);
								_tmp241_ = inner_ma;
								_tmp242_ = vala_member_access_get_inner (_tmp241_);
								_tmp243_ = _tmp242_;
								inner_ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp243_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
								_tmp244_ = inner_sym;
								_tmp245_ = vala_symbol_get_parent_symbol (_tmp244_);
								_tmp246_ = _tmp245_;
								inner_sym = _tmp246_;
							}
							_tmp247_ = inner_ma;
							vala_member_access_set_qualified (_tmp247_, TRUE);
							_tmp248_ = vala_member_access_get_inner (self);
							_tmp249_ = _tmp248_;
							vala_code_node_check ((ValaCodeNode*) _tmp249_, context);
							_tmp250_ = local_sym;
							vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp250_);
						}
						_vala_code_node_unref0 (local_sym);
						_vala_code_node_unref0 (ns);
					}
				}
			}
		} else {
			ValaExpression* _tmp251_;
			ValaExpression* _tmp252_;
			gboolean _tmp253_;
			gboolean _tmp254_;
			ValaExpression* _tmp255_;
			ValaExpression* _tmp256_;
			ValaDataType* _tmp257_;
			ValaDataType* _tmp258_;
			ValaExpression* _tmp289_;
			ValaExpression* _tmp290_;
			gboolean _tmp303_ = FALSE;
			ValaExpression* _tmp304_;
			ValaExpression* _tmp305_;
			gboolean _tmp312_ = FALSE;
			ValaExpression* _tmp313_;
			ValaExpression* _tmp314_;
			gboolean _tmp335_ = FALSE;
			ValaExpression* _tmp336_;
			ValaExpression* _tmp337_;
			gboolean _tmp356_ = FALSE;
			ValaSymbol* _tmp357_;
			ValaSymbol* _tmp358_;
			gboolean _tmp392_ = FALSE;
			gboolean _tmp393_ = FALSE;
			ValaSymbol* _tmp394_;
			ValaSymbol* _tmp395_;
			ValaSymbol* _tmp644_;
			ValaSymbol* _tmp645_;
			_tmp251_ = vala_member_access_get_inner (self);
			_tmp252_ = _tmp251_;
			_tmp253_ = vala_code_node_get_error ((ValaCodeNode*) _tmp252_);
			_tmp254_ = _tmp253_;
			if (_tmp254_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_iterable_unref0 (visited_types);
				return result;
			}
			_tmp255_ = vala_member_access_get_inner (self);
			_tmp256_ = _tmp255_;
			_tmp257_ = vala_expression_get_value_type (_tmp256_);
			_tmp258_ = _tmp257_;
			if (VALA_IS_POINTER_TYPE (_tmp258_)) {
				ValaPointerType* pointer_type = NULL;
				ValaExpression* _tmp259_;
				ValaExpression* _tmp260_;
				ValaDataType* _tmp261_;
				ValaDataType* _tmp262_;
				gboolean _tmp263_ = FALSE;
				ValaPointerType* _tmp264_;
				_tmp259_ = vala_member_access_get_inner (self);
				_tmp260_ = _tmp259_;
				_tmp261_ = vala_expression_get_value_type (_tmp260_);
				_tmp262_ = _tmp261_;
				pointer_type = VALA_IS_POINTER_TYPE (_tmp262_) ? ((ValaPointerType*) _tmp262_) : NULL;
				_tmp264_ = pointer_type;
				if (_tmp264_ != NULL) {
					ValaPointerType* _tmp265_;
					ValaDataType* _tmp266_;
					ValaDataType* _tmp267_;
					_tmp265_ = pointer_type;
					_tmp266_ = vala_pointer_type_get_base_type (_tmp265_);
					_tmp267_ = _tmp266_;
					_tmp263_ = VALA_IS_VALUE_TYPE (_tmp267_);
				} else {
					_tmp263_ = FALSE;
				}
				if (_tmp263_) {
					ValaExpression* _tmp268_;
					ValaExpression* _tmp269_;
					ValaDataType* _tmp270_;
					ValaDataType* _tmp271_;
					ValaExpression* _tmp281_;
					ValaExpression* _tmp282_;
					ValaSourceReference* _tmp283_;
					ValaSourceReference* _tmp284_;
					ValaPointerIndirection* _tmp285_;
					ValaPointerIndirection* _tmp286_;
					ValaExpression* _tmp287_;
					ValaExpression* _tmp288_;
					_tmp268_ = vala_member_access_get_inner (self);
					_tmp269_ = _tmp268_;
					_tmp270_ = vala_expression_get_formal_value_type (_tmp269_);
					_tmp271_ = _tmp270_;
					if (VALA_IS_GENERIC_TYPE (_tmp271_)) {
						ValaExpression* _tmp272_;
						ValaExpression* _tmp273_;
						ValaPointerType* _tmp274_;
						ValaDataType* _tmp275_;
						ValaDataType* _tmp276_;
						ValaSourceReference* _tmp277_;
						ValaSourceReference* _tmp278_;
						ValaCastExpression* _tmp279_;
						ValaCastExpression* _tmp280_;
						_tmp272_ = vala_member_access_get_inner (self);
						_tmp273_ = _tmp272_;
						_tmp274_ = pointer_type;
						_tmp275_ = vala_data_type_copy ((ValaDataType*) _tmp274_);
						_tmp276_ = _tmp275_;
						_tmp277_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp278_ = _tmp277_;
						_tmp279_ = vala_cast_expression_new (_tmp273_, _tmp276_, _tmp278_);
						_tmp280_ = _tmp279_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp280_);
						_vala_code_node_unref0 (_tmp280_);
						_vala_code_node_unref0 (_tmp276_);
					}
					_tmp281_ = vala_member_access_get_inner (self);
					_tmp282_ = _tmp281_;
					_tmp283_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp284_ = _tmp283_;
					_tmp285_ = vala_pointer_indirection_new (_tmp282_, _tmp284_);
					_tmp286_ = _tmp285_;
					vala_member_access_set_inner (self, (ValaExpression*) _tmp286_);
					_vala_code_node_unref0 (_tmp286_);
					_tmp287_ = vala_member_access_get_inner (self);
					_tmp288_ = _tmp287_;
					vala_code_node_check ((ValaCodeNode*) _tmp288_, context);
					vala_member_access_set_pointer_member_access (self, FALSE);
				}
			}
			_tmp289_ = vala_member_access_get_inner (self);
			_tmp290_ = _tmp289_;
			if (VALA_IS_MEMBER_ACCESS (_tmp290_)) {
				ValaMemberAccess* ma = NULL;
				ValaExpression* _tmp291_;
				ValaExpression* _tmp292_;
				ValaMemberAccess* _tmp293_;
				gboolean _tmp294_;
				_tmp291_ = vala_member_access_get_inner (self);
				_tmp292_ = _tmp291_;
				ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp292_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
				_tmp293_ = ma;
				_tmp294_ = _tmp293_->priv->_prototype_access;
				if (_tmp294_) {
					ValaSourceReference* _tmp295_;
					ValaSourceReference* _tmp296_;
					ValaExpression* _tmp297_;
					ValaExpression* _tmp298_;
					ValaSymbol* _tmp299_;
					ValaSymbol* _tmp300_;
					gchar* _tmp301_;
					gchar* _tmp302_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp295_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp296_ = _tmp295_;
					_tmp297_ = vala_member_access_get_inner (self);
					_tmp298_ = _tmp297_;
					_tmp299_ = vala_expression_get_symbol_reference (_tmp298_);
					_tmp300_ = _tmp299_;
					_tmp301_ = vala_symbol_get_full_name (_tmp300_);
					_tmp302_ = _tmp301_;
					vala_report_error (_tmp296_, "Access to instance member `%s' denied", _tmp302_);
					_g_free0 (_tmp302_);
					result = FALSE;
					_vala_iterable_unref0 (visited_types);
					return result;
				}
			}
			_tmp304_ = vala_member_access_get_inner (self);
			_tmp305_ = _tmp304_;
			if (VALA_IS_CAST_EXPRESSION (_tmp305_)) {
				ValaExpression* _tmp306_;
				ValaExpression* _tmp307_;
				gboolean _tmp308_;
				gboolean _tmp309_;
				_tmp306_ = vala_member_access_get_inner (self);
				_tmp307_ = _tmp306_;
				_tmp308_ = vala_cast_expression_get_is_silent_cast (G_TYPE_CHECK_INSTANCE_CAST (_tmp307_, VALA_TYPE_CAST_EXPRESSION, ValaCastExpression));
				_tmp309_ = _tmp308_;
				_tmp303_ = _tmp309_;
			} else {
				_tmp303_ = FALSE;
			}
			if (_tmp303_) {
				ValaSourceReference* _tmp310_;
				ValaSourceReference* _tmp311_;
				_tmp310_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp311_ = _tmp310_;
				vala_report_warning (_tmp311_, "Access to possible `null'. Perform a check or use an unsafe cast.");
			}
			_tmp313_ = vala_member_access_get_inner (self);
			_tmp314_ = _tmp313_;
			if (VALA_IS_MEMBER_ACCESS (_tmp314_)) {
				_tmp312_ = TRUE;
			} else {
				ValaExpression* _tmp315_;
				ValaExpression* _tmp316_;
				_tmp315_ = vala_member_access_get_inner (self);
				_tmp316_ = _tmp315_;
				_tmp312_ = VALA_IS_BASE_ACCESS (_tmp316_);
			}
			if (_tmp312_) {
				ValaExpression* _tmp317_;
				ValaExpression* _tmp318_;
				ValaSymbol* _tmp319_;
				ValaSymbol* _tmp320_;
				gboolean _tmp321_ = FALSE;
				ValaSymbol* _tmp322_;
				ValaSymbol* _tmp323_;
				_tmp317_ = vala_member_access_get_inner (self);
				_tmp318_ = _tmp317_;
				_tmp319_ = vala_expression_get_symbol_reference (_tmp318_);
				_tmp320_ = _tmp319_;
				base_symbol = _tmp320_;
				_tmp322_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp323_ = _tmp322_;
				if (_tmp323_ == NULL) {
					gboolean _tmp324_ = FALSE;
					ValaSymbol* _tmp325_;
					_tmp325_ = base_symbol;
					if (VALA_IS_NAMESPACE (_tmp325_)) {
						_tmp324_ = TRUE;
					} else {
						ValaSymbol* _tmp326_;
						_tmp326_ = base_symbol;
						_tmp324_ = VALA_IS_TYPESYMBOL (_tmp326_);
					}
					_tmp321_ = _tmp324_;
				} else {
					_tmp321_ = FALSE;
				}
				if (_tmp321_) {
					ValaSymbol* _tmp327_;
					ValaScope* _tmp328_;
					ValaScope* _tmp329_;
					const gchar* _tmp330_;
					ValaSymbol* _tmp331_;
					ValaSymbol* _tmp332_;
					ValaExpression* _tmp333_;
					ValaExpression* _tmp334_;
					_tmp327_ = base_symbol;
					_tmp328_ = vala_symbol_get_scope (_tmp327_);
					_tmp329_ = _tmp328_;
					_tmp330_ = self->priv->_member_name;
					_tmp331_ = vala_scope_lookup (_tmp329_, _tmp330_);
					_tmp332_ = _tmp331_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp332_);
					_vala_code_node_unref0 (_tmp332_);
					_tmp333_ = vala_member_access_get_inner (self);
					_tmp334_ = _tmp333_;
					if (VALA_IS_BASE_ACCESS (_tmp334_)) {
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
					}
				}
			}
			_tmp336_ = vala_member_access_get_inner (self);
			_tmp337_ = _tmp336_;
			if (VALA_IS_MEMBER_ACCESS (_tmp337_)) {
				ValaExpression* _tmp338_;
				ValaExpression* _tmp339_;
				ValaSymbol* _tmp340_;
				ValaSymbol* _tmp341_;
				_tmp338_ = vala_member_access_get_inner (self);
				_tmp339_ = _tmp338_;
				_tmp340_ = vala_expression_get_symbol_reference (_tmp339_);
				_tmp341_ = _tmp340_;
				_tmp335_ = VALA_IS_TYPEPARAMETER (_tmp341_);
			} else {
				_tmp335_ = FALSE;
			}
			if (_tmp335_) {
				ValaExpression* _tmp342_;
				ValaExpression* _tmp343_;
				ValaExpression* _tmp344_;
				ValaExpression* _tmp345_;
				ValaSymbol* _tmp346_;
				ValaSymbol* _tmp347_;
				ValaGenericType* _tmp348_;
				ValaGenericType* _tmp349_;
				ValaExpression* _tmp350_;
				ValaExpression* _tmp351_;
				ValaDataType* _tmp352_;
				ValaDataType* _tmp353_;
				ValaSourceReference* _tmp354_;
				ValaSourceReference* _tmp355_;
				_tmp342_ = vala_member_access_get_inner (self);
				_tmp343_ = _tmp342_;
				_tmp344_ = vala_member_access_get_inner (self);
				_tmp345_ = _tmp344_;
				_tmp346_ = vala_expression_get_symbol_reference (_tmp345_);
				_tmp347_ = _tmp346_;
				_tmp348_ = vala_generic_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp347_, VALA_TYPE_TYPEPARAMETER, ValaTypeParameter));
				_tmp349_ = _tmp348_;
				vala_expression_set_value_type (_tmp343_, (ValaDataType*) _tmp349_);
				_vala_code_node_unref0 (_tmp349_);
				_tmp350_ = vala_member_access_get_inner (self);
				_tmp351_ = _tmp350_;
				_tmp352_ = vala_expression_get_value_type (_tmp351_);
				_tmp353_ = _tmp352_;
				_tmp354_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp355_ = _tmp354_;
				vala_code_node_set_source_reference ((ValaCodeNode*) _tmp353_, _tmp355_);
			}
			_tmp357_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp358_ = _tmp357_;
			if (_tmp358_ == NULL) {
				ValaExpression* _tmp359_;
				ValaExpression* _tmp360_;
				ValaDataType* _tmp361_;
				ValaDataType* _tmp362_;
				_tmp359_ = vala_member_access_get_inner (self);
				_tmp360_ = _tmp359_;
				_tmp361_ = vala_expression_get_value_type (_tmp360_);
				_tmp362_ = _tmp361_;
				_tmp356_ = _tmp362_ != NULL;
			} else {
				_tmp356_ = FALSE;
			}
			if (_tmp356_) {
				gboolean _tmp363_;
				ValaSymbol* _tmp390_;
				ValaSymbol* _tmp391_;
				_tmp363_ = self->priv->_pointer_member_access;
				if (_tmp363_) {
					ValaExpression* _tmp364_;
					ValaExpression* _tmp365_;
					ValaDataType* _tmp366_;
					ValaDataType* _tmp367_;
					const gchar* _tmp368_;
					ValaSymbol* _tmp369_;
					ValaSymbol* _tmp370_;
					_tmp364_ = vala_member_access_get_inner (self);
					_tmp365_ = _tmp364_;
					_tmp366_ = vala_expression_get_value_type (_tmp365_);
					_tmp367_ = _tmp366_;
					_tmp368_ = self->priv->_member_name;
					_tmp369_ = vala_data_type_get_pointer_member (_tmp367_, _tmp368_);
					_tmp370_ = _tmp369_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp370_);
					_vala_code_node_unref0 (_tmp370_);
				} else {
					ValaExpression* _tmp371_;
					ValaExpression* _tmp372_;
					ValaDataType* _tmp373_;
					ValaDataType* _tmp374_;
					ValaTypeSymbol* _tmp375_;
					ValaTypeSymbol* _tmp376_;
					ValaExpression* _tmp383_;
					ValaExpression* _tmp384_;
					ValaDataType* _tmp385_;
					ValaDataType* _tmp386_;
					const gchar* _tmp387_;
					ValaSymbol* _tmp388_;
					ValaSymbol* _tmp389_;
					_tmp371_ = vala_member_access_get_inner (self);
					_tmp372_ = _tmp371_;
					_tmp373_ = vala_expression_get_value_type (_tmp372_);
					_tmp374_ = _tmp373_;
					_tmp375_ = vala_data_type_get_type_symbol (_tmp374_);
					_tmp376_ = _tmp375_;
					if (_tmp376_ != NULL) {
						ValaExpression* _tmp377_;
						ValaExpression* _tmp378_;
						ValaDataType* _tmp379_;
						ValaDataType* _tmp380_;
						ValaTypeSymbol* _tmp381_;
						ValaTypeSymbol* _tmp382_;
						_tmp377_ = vala_member_access_get_inner (self);
						_tmp378_ = _tmp377_;
						_tmp379_ = vala_expression_get_value_type (_tmp378_);
						_tmp380_ = _tmp379_;
						_tmp381_ = vala_data_type_get_type_symbol (_tmp380_);
						_tmp382_ = _tmp381_;
						base_symbol = (ValaSymbol*) _tmp382_;
					}
					_tmp383_ = vala_member_access_get_inner (self);
					_tmp384_ = _tmp383_;
					_tmp385_ = vala_expression_get_value_type (_tmp384_);
					_tmp386_ = _tmp385_;
					_tmp387_ = self->priv->_member_name;
					_tmp388_ = vala_data_type_get_member (_tmp386_, _tmp387_);
					_tmp389_ = _tmp388_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp389_);
					_vala_code_node_unref0 (_tmp389_);
				}
				_tmp390_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp391_ = _tmp390_;
				if (_tmp391_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
			}
			_tmp394_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp395_ = _tmp394_;
			if (_tmp395_ == NULL) {
				ValaExpression* _tmp396_;
				ValaExpression* _tmp397_;
				ValaDataType* _tmp398_;
				ValaDataType* _tmp399_;
				_tmp396_ = vala_member_access_get_inner (self);
				_tmp397_ = _tmp396_;
				_tmp398_ = vala_expression_get_value_type (_tmp397_);
				_tmp399_ = _tmp398_;
				_tmp393_ = _tmp399_ != NULL;
			} else {
				_tmp393_ = FALSE;
			}
			if (_tmp393_) {
				ValaExpression* _tmp400_;
				ValaExpression* _tmp401_;
				ValaDataType* _tmp402_;
				ValaDataType* _tmp403_;
				gboolean _tmp404_;
				gboolean _tmp405_;
				_tmp400_ = vala_member_access_get_inner (self);
				_tmp401_ = _tmp400_;
				_tmp402_ = vala_expression_get_value_type (_tmp401_);
				_tmp403_ = _tmp402_;
				_tmp404_ = vala_data_type_get_is_dynamic (_tmp403_);
				_tmp405_ = _tmp404_;
				_tmp392_ = _tmp405_;
			} else {
				_tmp392_ = FALSE;
			}
			if (_tmp392_) {
				ValaObjectType* dynamic_object_type = NULL;
				ValaExpression* _tmp406_;
				ValaExpression* _tmp407_;
				ValaDataType* _tmp408_;
				ValaDataType* _tmp409_;
				ValaObjectType* _tmp410_;
				ValaCodeNode* _tmp411_;
				ValaCodeNode* _tmp412_;
				ValaSymbol* _tmp592_;
				ValaSymbol* _tmp593_;
				ValaSymbol* _tmp642_;
				ValaSymbol* _tmp643_;
				_tmp406_ = vala_member_access_get_inner (self);
				_tmp407_ = _tmp406_;
				_tmp408_ = vala_expression_get_value_type (_tmp407_);
				_tmp409_ = _tmp408_;
				_tmp410_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp409_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				dynamic_object_type = _tmp410_;
				_tmp411_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp412_ = _tmp411_;
				if (VALA_IS_METHOD_CALL (_tmp412_)) {
					ValaMethodCall* invoc = NULL;
					ValaCodeNode* _tmp413_;
					ValaCodeNode* _tmp414_;
					ValaMethodCall* _tmp415_;
					ValaExpression* _tmp416_;
					ValaExpression* _tmp417_;
					_tmp413_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp414_ = _tmp413_;
					invoc = G_TYPE_CHECK_INSTANCE_CAST (_tmp414_, VALA_TYPE_METHOD_CALL, ValaMethodCall);
					_tmp415_ = invoc;
					_tmp416_ = vala_method_call_get_call (_tmp415_);
					_tmp417_ = _tmp416_;
					if (_tmp417_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
						ValaDataType* ret_type = NULL;
						ValaMethodCall* _tmp418_;
						ValaDataType* _tmp419_;
						ValaDataType* _tmp420_;
						ValaDynamicMethod* m = NULL;
						ValaExpression* _tmp435_;
						ValaExpression* _tmp436_;
						ValaDataType* _tmp437_;
						ValaDataType* _tmp438_;
						const gchar* _tmp439_;
						ValaDataType* _tmp440_;
						ValaSourceReference* _tmp441_;
						ValaSourceReference* _tmp442_;
						ValaDynamicMethod* _tmp443_;
						ValaDynamicMethod* _tmp444_;
						ValaMethodCall* _tmp445_;
						ValaErrorType* err = NULL;
						ValaDynamicMethod* _tmp446_;
						ValaSourceReference* _tmp447_;
						ValaSourceReference* _tmp448_;
						ValaErrorType* _tmp449_;
						ValaErrorType* _tmp450_;
						ValaDynamicMethod* _tmp451_;
						ValaErrorType* _tmp452_;
						ValaDynamicMethod* _tmp453_;
						ValaDynamicMethod* _tmp454_;
						ValaParameter* _tmp455_;
						ValaParameter* _tmp456_;
						ValaDynamicMethod* _tmp457_;
						ValaObjectType* _tmp458_;
						ValaDataType* _tmp459_;
						ValaDataType* _tmp460_;
						ValaDynamicMethod* _tmp461_;
						ValaSourceReference* _tmp462_;
						ValaSourceReference* _tmp463_;
						ValaParameter* _tmp464_;
						ValaParameter* _tmp465_;
						ValaObjectType* _tmp466_;
						ValaTypeSymbol* _tmp467_;
						ValaTypeSymbol* _tmp468_;
						ValaScope* _tmp469_;
						ValaScope* _tmp470_;
						ValaDynamicMethod* _tmp471_;
						ValaDynamicMethod* _tmp472_;
						_tmp418_ = invoc;
						_tmp419_ = vala_expression_get_target_type ((ValaExpression*) _tmp418_);
						_tmp420_ = _tmp419_;
						if (_tmp420_ != NULL) {
							ValaMethodCall* _tmp421_;
							ValaDataType* _tmp422_;
							ValaDataType* _tmp423_;
							ValaDataType* _tmp424_;
							ValaDataType* _tmp425_;
							_tmp421_ = invoc;
							_tmp422_ = vala_expression_get_target_type ((ValaExpression*) _tmp421_);
							_tmp423_ = _tmp422_;
							_tmp424_ = vala_data_type_copy (_tmp423_);
							_vala_code_node_unref0 (ret_type);
							ret_type = _tmp424_;
							_tmp425_ = ret_type;
							vala_data_type_set_value_owned (_tmp425_, TRUE);
						} else {
							ValaMethodCall* _tmp426_;
							ValaCodeNode* _tmp427_;
							ValaCodeNode* _tmp428_;
							_tmp426_ = invoc;
							_tmp427_ = vala_code_node_get_parent_node ((ValaCodeNode*) _tmp426_);
							_tmp428_ = _tmp427_;
							if (VALA_IS_EXPRESSION_STATEMENT (_tmp428_)) {
								ValaVoidType* _tmp429_;
								_tmp429_ = vala_void_type_new (NULL);
								_vala_code_node_unref0 (ret_type);
								ret_type = (ValaDataType*) _tmp429_;
							} else {
								ValaExpression* _tmp430_;
								ValaExpression* _tmp431_;
								ValaDataType* _tmp432_;
								ValaDataType* _tmp433_;
								ValaDataType* _tmp434_;
								_tmp430_ = vala_member_access_get_inner (self);
								_tmp431_ = _tmp430_;
								_tmp432_ = vala_expression_get_value_type (_tmp431_);
								_tmp433_ = _tmp432_;
								_tmp434_ = vala_data_type_copy (_tmp433_);
								_vala_code_node_unref0 (ret_type);
								ret_type = _tmp434_;
							}
						}
						_tmp435_ = vala_member_access_get_inner (self);
						_tmp436_ = _tmp435_;
						_tmp437_ = vala_expression_get_value_type (_tmp436_);
						_tmp438_ = _tmp437_;
						_tmp439_ = self->priv->_member_name;
						_tmp440_ = ret_type;
						_tmp441_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp442_ = _tmp441_;
						_tmp443_ = vala_dynamic_method_new (_tmp438_, _tmp439_, _tmp440_, _tmp442_, NULL);
						m = _tmp443_;
						_tmp444_ = m;
						_tmp445_ = invoc;
						vala_dynamic_method_set_invocation (_tmp444_, _tmp445_);
						_tmp446_ = m;
						_tmp447_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp446_);
						_tmp448_ = _tmp447_;
						_tmp449_ = vala_error_type_new (NULL, NULL, _tmp448_);
						err = _tmp449_;
						_tmp450_ = err;
						vala_error_type_set_dynamic_error (_tmp450_, TRUE);
						_tmp451_ = m;
						_tmp452_ = err;
						vala_method_add_error_type ((ValaMethod*) _tmp451_, (ValaDataType*) _tmp452_);
						_tmp453_ = m;
						vala_symbol_set_access ((ValaSymbol*) _tmp453_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
						_tmp454_ = m;
						_tmp455_ = vala_parameter_new_with_ellipsis (NULL);
						_tmp456_ = _tmp455_;
						vala_callable_add_parameter ((ValaCallable*) _tmp454_, _tmp456_);
						_vala_code_node_unref0 (_tmp456_);
						_tmp457_ = m;
						_tmp458_ = dynamic_object_type;
						_tmp459_ = vala_data_type_copy ((ValaDataType*) _tmp458_);
						_tmp460_ = _tmp459_;
						_tmp461_ = m;
						_tmp462_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp461_);
						_tmp463_ = _tmp462_;
						_tmp464_ = vala_parameter_new ("this", _tmp460_, _tmp463_);
						_tmp465_ = _tmp464_;
						vala_method_set_this_parameter ((ValaMethod*) _tmp457_, _tmp465_);
						_vala_code_node_unref0 (_tmp465_);
						_vala_code_node_unref0 (_tmp460_);
						_tmp466_ = dynamic_object_type;
						_tmp467_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp466_);
						_tmp468_ = _tmp467_;
						_tmp469_ = vala_symbol_get_scope ((ValaSymbol*) _tmp468_);
						_tmp470_ = _tmp469_;
						_tmp471_ = m;
						vala_scope_add (_tmp470_, NULL, (ValaSymbol*) _tmp471_);
						_tmp472_ = m;
						vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp472_);
						_vala_code_node_unref0 (err);
						_vala_code_node_unref0 (m);
						_vala_code_node_unref0 (ret_type);
					}
				} else {
					ValaCodeNode* _tmp473_;
					ValaCodeNode* _tmp474_;
					_tmp473_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp474_ = _tmp473_;
					if (VALA_IS_ASSIGNMENT (_tmp474_)) {
						ValaAssignment* a = NULL;
						ValaCodeNode* _tmp475_;
						ValaCodeNode* _tmp476_;
						ValaAssignment* _tmp477_;
						ValaExpression* _tmp478_;
						ValaExpression* _tmp479_;
						_tmp475_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp476_ = _tmp475_;
						a = G_TYPE_CHECK_INSTANCE_CAST (_tmp476_, VALA_TYPE_ASSIGNMENT, ValaAssignment);
						_tmp477_ = a;
						_tmp478_ = vala_assignment_get_left (_tmp477_);
						_tmp479_ = _tmp478_;
						if (_tmp479_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
							ValaDynamicProperty* prop = NULL;
							ValaExpression* _tmp480_;
							ValaExpression* _tmp481_;
							ValaDataType* _tmp482_;
							ValaDataType* _tmp483_;
							const gchar* _tmp484_;
							ValaSourceReference* _tmp485_;
							ValaSourceReference* _tmp486_;
							ValaDynamicProperty* _tmp487_;
							ValaDynamicProperty* _tmp488_;
							ValaDynamicProperty* _tmp489_;
							ValaDynamicProperty* _tmp490_;
							ValaSourceReference* _tmp491_;
							ValaSourceReference* _tmp492_;
							ValaPropertyAccessor* _tmp493_;
							ValaPropertyAccessor* _tmp494_;
							ValaDynamicProperty* _tmp495_;
							ValaExpression* _tmp496_;
							ValaExpression* _tmp497_;
							ValaDataType* _tmp498_;
							ValaDataType* _tmp499_;
							ValaTypeSymbol* _tmp500_;
							ValaTypeSymbol* _tmp501_;
							ValaScope* _tmp502_;
							ValaScope* _tmp503_;
							ValaObjectType* _tmp504_;
							ValaTypeSymbol* _tmp505_;
							ValaTypeSymbol* _tmp506_;
							ValaScope* _tmp507_;
							ValaScope* _tmp508_;
							ValaDynamicProperty* _tmp509_;
							ValaDynamicProperty* _tmp510_;
							_tmp480_ = vala_member_access_get_inner (self);
							_tmp481_ = _tmp480_;
							_tmp482_ = vala_expression_get_value_type (_tmp481_);
							_tmp483_ = _tmp482_;
							_tmp484_ = self->priv->_member_name;
							_tmp485_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp486_ = _tmp485_;
							_tmp487_ = vala_dynamic_property_new (_tmp483_, _tmp484_, _tmp486_, NULL);
							prop = _tmp487_;
							_tmp488_ = prop;
							vala_symbol_set_access ((ValaSymbol*) _tmp488_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
							_tmp489_ = prop;
							_tmp490_ = prop;
							_tmp491_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp490_);
							_tmp492_ = _tmp491_;
							_tmp493_ = vala_property_accessor_new (FALSE, TRUE, FALSE, NULL, NULL, _tmp492_, NULL);
							_tmp494_ = _tmp493_;
							vala_property_set_set_accessor ((ValaProperty*) _tmp489_, _tmp494_);
							_vala_code_node_unref0 (_tmp494_);
							_tmp495_ = prop;
							_tmp496_ = vala_member_access_get_inner (self);
							_tmp497_ = _tmp496_;
							_tmp498_ = vala_expression_get_value_type (_tmp497_);
							_tmp499_ = _tmp498_;
							_tmp500_ = vala_data_type_get_type_symbol (_tmp499_);
							_tmp501_ = _tmp500_;
							_tmp502_ = vala_symbol_get_scope ((ValaSymbol*) _tmp501_);
							_tmp503_ = _tmp502_;
							vala_symbol_set_owner ((ValaSymbol*) _tmp495_, _tmp503_);
							_tmp504_ = dynamic_object_type;
							_tmp505_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp504_);
							_tmp506_ = _tmp505_;
							_tmp507_ = vala_symbol_get_scope ((ValaSymbol*) _tmp506_);
							_tmp508_ = _tmp507_;
							_tmp509_ = prop;
							vala_scope_add (_tmp508_, NULL, (ValaSymbol*) _tmp509_);
							_tmp510_ = prop;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp510_);
							_vala_code_node_unref0 (prop);
						}
					} else {
						gboolean _tmp511_ = FALSE;
						gboolean _tmp512_ = FALSE;
						ValaCodeNode* _tmp513_;
						ValaCodeNode* _tmp514_;
						_tmp513_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp514_ = _tmp513_;
						if (VALA_IS_MEMBER_ACCESS (_tmp514_)) {
							ValaExpression* _tmp515_;
							ValaExpression* _tmp516_;
							_tmp515_ = vala_member_access_get_inner (self);
							_tmp516_ = _tmp515_;
							_tmp512_ = VALA_IS_MEMBER_ACCESS (_tmp516_);
						} else {
							_tmp512_ = FALSE;
						}
						if (_tmp512_) {
							ValaCodeNode* _tmp517_;
							ValaCodeNode* _tmp518_;
							ValaCodeNode* _tmp519_;
							ValaCodeNode* _tmp520_;
							_tmp517_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp518_ = _tmp517_;
							_tmp519_ = vala_code_node_get_parent_node (_tmp518_);
							_tmp520_ = _tmp519_;
							_tmp511_ = VALA_IS_METHOD_CALL (_tmp520_);
						} else {
							_tmp511_ = FALSE;
						}
						if (_tmp511_) {
							ValaMemberAccess* ma = NULL;
							ValaCodeNode* _tmp521_;
							ValaCodeNode* _tmp522_;
							gboolean _tmp523_ = FALSE;
							ValaMemberAccess* _tmp524_;
							const gchar* _tmp525_;
							_tmp521_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp522_ = _tmp521_;
							ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp522_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
							_tmp524_ = ma;
							_tmp525_ = _tmp524_->priv->_member_name;
							if (g_strcmp0 (_tmp525_, "connect") == 0) {
								_tmp523_ = TRUE;
							} else {
								ValaMemberAccess* _tmp526_;
								const gchar* _tmp527_;
								_tmp526_ = ma;
								_tmp527_ = _tmp526_->priv->_member_name;
								_tmp523_ = g_strcmp0 (_tmp527_, "connect_after") == 0;
							}
							if (_tmp523_) {
								ValaDynamicSignal* s = NULL;
								ValaExpression* _tmp528_;
								ValaExpression* _tmp529_;
								ValaDataType* _tmp530_;
								ValaDataType* _tmp531_;
								const gchar* _tmp532_;
								ValaVoidType* _tmp533_;
								ValaVoidType* _tmp534_;
								ValaSourceReference* _tmp535_;
								ValaSourceReference* _tmp536_;
								ValaDynamicSignal* _tmp537_;
								ValaDynamicSignal* _tmp538_;
								ValaMethodCall* mcall = NULL;
								ValaCodeNode* _tmp539_;
								ValaCodeNode* _tmp540_;
								ValaCodeNode* _tmp541_;
								ValaCodeNode* _tmp542_;
								ValaMethodCall* _tmp543_;
								ValaMethodCall* _tmp544_;
								ValaList* _tmp545_;
								gint _tmp546_;
								gint _tmp547_;
								ValaDynamicSignal* _tmp579_;
								ValaObjectType* _tmp580_;
								ValaTypeSymbol* _tmp581_;
								ValaTypeSymbol* _tmp582_;
								ValaScope* _tmp583_;
								ValaScope* _tmp584_;
								ValaDynamicSignal* _tmp585_;
								ValaDynamicSignal* _tmp586_;
								_tmp528_ = vala_member_access_get_inner (self);
								_tmp529_ = _tmp528_;
								_tmp530_ = vala_expression_get_value_type (_tmp529_);
								_tmp531_ = _tmp530_;
								_tmp532_ = self->priv->_member_name;
								_tmp533_ = vala_void_type_new (NULL);
								_tmp534_ = _tmp533_;
								_tmp535_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp536_ = _tmp535_;
								_tmp537_ = vala_dynamic_signal_new (_tmp531_, _tmp532_, (ValaDataType*) _tmp534_, _tmp536_, NULL);
								_tmp538_ = _tmp537_;
								_vala_code_node_unref0 (_tmp534_);
								s = _tmp538_;
								_tmp539_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
								_tmp540_ = _tmp539_;
								_tmp541_ = vala_code_node_get_parent_node (_tmp540_);
								_tmp542_ = _tmp541_;
								_tmp543_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp542_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
								mcall = _tmp543_;
								_tmp544_ = mcall;
								_tmp545_ = vala_callable_expression_get_argument_list ((ValaCallableExpression*) _tmp544_);
								_tmp546_ = vala_collection_get_size ((ValaCollection*) _tmp545_);
								_tmp547_ = _tmp546_;
								if (_tmp547_ > 0) {
									ValaDynamicSignal* _tmp548_;
									ValaMethodCall* _tmp549_;
									ValaList* _tmp550_;
									gpointer _tmp551_;
									ValaExpression* _tmp552_;
									ValaMemberAccess* arg = NULL;
									ValaDynamicSignal* _tmp553_;
									ValaExpression* _tmp554_;
									ValaExpression* _tmp555_;
									gboolean _tmp556_ = FALSE;
									gboolean _tmp557_ = FALSE;
									ValaMemberAccess* _tmp558_;
									_tmp548_ = s;
									_tmp549_ = mcall;
									_tmp550_ = vala_callable_expression_get_argument_list ((ValaCallableExpression*) _tmp549_);
									_tmp551_ = vala_list_get (_tmp550_, 0);
									_tmp552_ = (ValaExpression*) _tmp551_;
									vala_dynamic_signal_set_handler (_tmp548_, _tmp552_);
									_vala_code_node_unref0 (_tmp552_);
									_tmp553_ = s;
									_tmp554_ = vala_dynamic_signal_get_handler (_tmp553_);
									_tmp555_ = _tmp554_;
									arg = VALA_IS_MEMBER_ACCESS (_tmp555_) ? ((ValaMemberAccess*) _tmp555_) : NULL;
									_tmp558_ = arg;
									if (_tmp558_ == NULL) {
										_tmp557_ = TRUE;
									} else {
										ValaMemberAccess* _tmp559_;
										_tmp559_ = arg;
										_tmp557_ = !vala_code_node_check ((ValaCodeNode*) _tmp559_, context);
									}
									if (_tmp557_) {
										_tmp556_ = TRUE;
									} else {
										ValaMemberAccess* _tmp560_;
										ValaSymbol* _tmp561_;
										ValaSymbol* _tmp562_;
										_tmp560_ = arg;
										_tmp561_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp560_);
										_tmp562_ = _tmp561_;
										_tmp556_ = !VALA_IS_METHOD (_tmp562_);
									}
									if (_tmp556_) {
										ValaDynamicSignal* _tmp563_;
										ValaExpression* _tmp564_;
										ValaExpression* _tmp565_;
										vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
										_tmp563_ = s;
										_tmp564_ = vala_dynamic_signal_get_handler (_tmp563_);
										_tmp565_ = _tmp564_;
										if (VALA_IS_LAMBDA_EXPRESSION (_tmp565_)) {
											ValaDynamicSignal* _tmp566_;
											ValaExpression* _tmp567_;
											ValaExpression* _tmp568_;
											ValaSourceReference* _tmp569_;
											ValaSourceReference* _tmp570_;
											_tmp566_ = s;
											_tmp567_ = vala_dynamic_signal_get_handler (_tmp566_);
											_tmp568_ = _tmp567_;
											_tmp569_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp568_);
											_tmp570_ = _tmp569_;
											vala_report_error (_tmp570_, "Lambdas are not allowed for dynamic signals");
										} else {
											ValaDynamicSignal* _tmp571_;
											ValaExpression* _tmp572_;
											ValaExpression* _tmp573_;
											ValaSourceReference* _tmp574_;
											ValaSourceReference* _tmp575_;
											ValaDynamicSignal* _tmp576_;
											gchar* _tmp577_;
											gchar* _tmp578_;
											_tmp571_ = s;
											_tmp572_ = vala_dynamic_signal_get_handler (_tmp571_);
											_tmp573_ = _tmp572_;
											_tmp574_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp573_);
											_tmp575_ = _tmp574_;
											_tmp576_ = s;
											_tmp577_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp576_);
											_tmp578_ = _tmp577_;
											vala_report_error (_tmp575_, "Cannot infer call signature for dynamic signal `%s' from given express" \
"ion", _tmp578_);
											_g_free0 (_tmp578_);
										}
									}
								}
								_tmp579_ = s;
								vala_symbol_set_access ((ValaSymbol*) _tmp579_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
								_tmp580_ = dynamic_object_type;
								_tmp581_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp580_);
								_tmp582_ = _tmp581_;
								_tmp583_ = vala_symbol_get_scope ((ValaSymbol*) _tmp582_);
								_tmp584_ = _tmp583_;
								_tmp585_ = s;
								vala_scope_add (_tmp584_, NULL, (ValaSymbol*) _tmp585_);
								_tmp586_ = s;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp586_);
								_vala_code_node_unref0 (mcall);
								_vala_code_node_unref0 (s);
							} else {
								ValaMemberAccess* _tmp587_;
								const gchar* _tmp588_;
								_tmp587_ = ma;
								_tmp588_ = _tmp587_->priv->_member_name;
								if (g_strcmp0 (_tmp588_, "disconnect") == 0) {
									ValaMemberAccess* _tmp589_;
									ValaSourceReference* _tmp590_;
									ValaSourceReference* _tmp591_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp589_ = ma;
									_tmp590_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp589_);
									_tmp591_ = _tmp590_;
									vala_report_error (_tmp591_, "Use SignalHandler.disconnect() to disconnect from dynamic signal");
								}
							}
						}
					}
				}
				_tmp592_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp593_ = _tmp592_;
				if (_tmp593_ == NULL) {
					ValaDynamicProperty* prop = NULL;
					ValaExpression* _tmp594_;
					ValaExpression* _tmp595_;
					ValaDataType* _tmp596_;
					ValaDataType* _tmp597_;
					const gchar* _tmp598_;
					ValaSourceReference* _tmp599_;
					ValaSourceReference* _tmp600_;
					ValaDynamicProperty* _tmp601_;
					ValaDataType* _tmp602_;
					ValaDataType* _tmp603_;
					ValaDynamicProperty* _tmp614_;
					ValaDynamicProperty* _tmp615_;
					ValaDynamicProperty* _tmp616_;
					ValaDataType* _tmp617_;
					ValaDataType* _tmp618_;
					ValaDataType* _tmp619_;
					ValaDataType* _tmp620_;
					ValaDynamicProperty* _tmp621_;
					ValaSourceReference* _tmp622_;
					ValaSourceReference* _tmp623_;
					ValaPropertyAccessor* _tmp624_;
					ValaPropertyAccessor* _tmp625_;
					ValaDynamicProperty* _tmp626_;
					ValaExpression* _tmp627_;
					ValaExpression* _tmp628_;
					ValaDataType* _tmp629_;
					ValaDataType* _tmp630_;
					ValaTypeSymbol* _tmp631_;
					ValaTypeSymbol* _tmp632_;
					ValaScope* _tmp633_;
					ValaScope* _tmp634_;
					ValaObjectType* _tmp635_;
					ValaTypeSymbol* _tmp636_;
					ValaTypeSymbol* _tmp637_;
					ValaScope* _tmp638_;
					ValaScope* _tmp639_;
					ValaDynamicProperty* _tmp640_;
					ValaDynamicProperty* _tmp641_;
					_tmp594_ = vala_member_access_get_inner (self);
					_tmp595_ = _tmp594_;
					_tmp596_ = vala_expression_get_value_type (_tmp595_);
					_tmp597_ = _tmp596_;
					_tmp598_ = self->priv->_member_name;
					_tmp599_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp600_ = _tmp599_;
					_tmp601_ = vala_dynamic_property_new (_tmp597_, _tmp598_, _tmp600_, NULL);
					prop = _tmp601_;
					_tmp602_ = vala_expression_get_target_type ((ValaExpression*) self);
					_tmp603_ = _tmp602_;
					if (_tmp603_ != NULL) {
						ValaDynamicProperty* _tmp604_;
						ValaDataType* _tmp605_;
						ValaDataType* _tmp606_;
						_tmp604_ = prop;
						_tmp605_ = vala_expression_get_target_type ((ValaExpression*) self);
						_tmp606_ = _tmp605_;
						vala_property_set_property_type ((ValaProperty*) _tmp604_, _tmp606_);
					} else {
						ValaDynamicProperty* _tmp607_;
						ValaExpression* _tmp608_;
						ValaExpression* _tmp609_;
						ValaDataType* _tmp610_;
						ValaDataType* _tmp611_;
						ValaDataType* _tmp612_;
						ValaDataType* _tmp613_;
						_tmp607_ = prop;
						_tmp608_ = vala_member_access_get_inner (self);
						_tmp609_ = _tmp608_;
						_tmp610_ = vala_expression_get_value_type (_tmp609_);
						_tmp611_ = _tmp610_;
						_tmp612_ = vala_data_type_copy (_tmp611_);
						_tmp613_ = _tmp612_;
						vala_property_set_property_type ((ValaProperty*) _tmp607_, _tmp613_);
						_vala_code_node_unref0 (_tmp613_);
					}
					_tmp614_ = prop;
					vala_symbol_set_access ((ValaSymbol*) _tmp614_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
					_tmp615_ = prop;
					_tmp616_ = prop;
					_tmp617_ = vala_property_get_property_type ((ValaProperty*) _tmp616_);
					_tmp618_ = _tmp617_;
					_tmp619_ = vala_data_type_copy (_tmp618_);
					_tmp620_ = _tmp619_;
					_tmp621_ = prop;
					_tmp622_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp621_);
					_tmp623_ = _tmp622_;
					_tmp624_ = vala_property_accessor_new (TRUE, FALSE, FALSE, _tmp620_, NULL, _tmp623_, NULL);
					_tmp625_ = _tmp624_;
					vala_property_set_get_accessor ((ValaProperty*) _tmp615_, _tmp625_);
					_vala_code_node_unref0 (_tmp625_);
					_vala_code_node_unref0 (_tmp620_);
					_tmp626_ = prop;
					_tmp627_ = vala_member_access_get_inner (self);
					_tmp628_ = _tmp627_;
					_tmp629_ = vala_expression_get_value_type (_tmp628_);
					_tmp630_ = _tmp629_;
					_tmp631_ = vala_data_type_get_type_symbol (_tmp630_);
					_tmp632_ = _tmp631_;
					_tmp633_ = vala_symbol_get_scope ((ValaSymbol*) _tmp632_);
					_tmp634_ = _tmp633_;
					vala_symbol_set_owner ((ValaSymbol*) _tmp626_, _tmp634_);
					_tmp635_ = dynamic_object_type;
					_tmp636_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp635_);
					_tmp637_ = _tmp636_;
					_tmp638_ = vala_symbol_get_scope ((ValaSymbol*) _tmp637_);
					_tmp639_ = _tmp638_;
					_tmp640_ = prop;
					vala_scope_add (_tmp639_, NULL, (ValaSymbol*) _tmp640_);
					_tmp641_ = prop;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp641_);
					_vala_code_node_unref0 (prop);
				}
				_tmp642_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp643_ = _tmp642_;
				if (_tmp643_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
				_vala_code_node_unref0 (dynamic_object_type);
			}
			_tmp644_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp645_ = _tmp644_;
			if (VALA_IS_ARRAY_RESIZE_METHOD (_tmp645_)) {
				ValaExpression* _tmp646_;
				ValaExpression* _tmp647_;
				ValaSymbol* _tmp648_;
				ValaSymbol* _tmp649_;
				_tmp646_ = vala_member_access_get_inner (self);
				_tmp647_ = _tmp646_;
				_tmp648_ = vala_expression_get_symbol_reference (_tmp647_);
				_tmp649_ = _tmp648_;
				if (VALA_IS_VARIABLE (_tmp649_)) {
					ValaArrayType* inner_type = NULL;
					ValaSemanticAnalyzer* _tmp650_;
					ValaSemanticAnalyzer* _tmp651_;
					ValaExpression* _tmp652_;
					ValaExpression* _tmp653_;
					ValaSymbol* _tmp654_;
					ValaSymbol* _tmp655_;
					ValaDataType* _tmp656_;
					ValaArrayType* _tmp657_;
					gboolean _tmp658_ = FALSE;
					ValaArrayType* _tmp659_;
					_tmp650_ = vala_code_context_get_analyzer (context);
					_tmp651_ = _tmp650_;
					_tmp652_ = vala_member_access_get_inner (self);
					_tmp653_ = _tmp652_;
					_tmp654_ = vala_expression_get_symbol_reference (_tmp653_);
					_tmp655_ = _tmp654_;
					_tmp656_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp651_, _tmp655_, TRUE);
					_tmp657_ = VALA_IS_ARRAY_TYPE (_tmp656_) ? ((ValaArrayType*) _tmp656_) : NULL;
					if (_tmp657_ == NULL) {
						_vala_code_node_unref0 (_tmp656_);
					}
					inner_type = _tmp657_;
					_tmp659_ = inner_type;
					if (_tmp659_ != NULL) {
						ValaArrayType* _tmp660_;
						gboolean _tmp661_;
						gboolean _tmp662_;
						_tmp660_ = inner_type;
						_tmp661_ = vala_array_type_get_inline_allocated (_tmp660_);
						_tmp662_ = _tmp661_;
						_tmp658_ = _tmp662_;
					} else {
						_tmp658_ = FALSE;
					}
					if (_tmp658_) {
						ValaSourceReference* _tmp663_;
						ValaSourceReference* _tmp664_;
						_tmp663_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp664_ = _tmp663_;
						vala_report_error (_tmp664_, "`resize' is not supported for arrays with fixed length");
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					} else {
						gboolean _tmp665_ = FALSE;
						ValaArrayType* _tmp666_;
						_tmp666_ = inner_type;
						if (_tmp666_ != NULL) {
							ValaArrayType* _tmp667_;
							gboolean _tmp668_;
							gboolean _tmp669_;
							_tmp667_ = inner_type;
							_tmp668_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp667_);
							_tmp669_ = _tmp668_;
							_tmp665_ = !_tmp669_;
						} else {
							_tmp665_ = FALSE;
						}
						if (_tmp665_) {
							ValaSourceReference* _tmp670_;
							ValaSourceReference* _tmp671_;
							_tmp670_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp671_ = _tmp670_;
							vala_report_error (_tmp671_, "`resize' is not allowed for unowned array references");
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						}
					}
					_vala_code_node_unref0 (inner_type);
				} else {
					ValaExpression* _tmp672_;
					ValaExpression* _tmp673_;
					ValaSymbol* _tmp674_;
					ValaSymbol* _tmp675_;
					_tmp672_ = vala_member_access_get_inner (self);
					_tmp673_ = _tmp672_;
					_tmp674_ = vala_expression_get_symbol_reference (_tmp673_);
					_tmp675_ = _tmp674_;
					if (VALA_IS_CONSTANT (_tmp675_)) {
						ValaSourceReference* _tmp676_;
						ValaSourceReference* _tmp677_;
						_tmp676_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp677_ = _tmp676_;
						vala_report_error (_tmp677_, "`resize' is not allowed for constant arrays");
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					}
				}
			}
		}
	}
	_tmp681_ = vala_member_access_get_inner (self);
	_tmp682_ = _tmp681_;
	if (_tmp682_ == NULL) {
		ValaSymbol* _tmp683_;
		ValaSymbol* _tmp684_;
		_tmp683_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp684_ = _tmp683_;
		_tmp680_ = _tmp684_ == NULL;
	} else {
		_tmp680_ = FALSE;
	}
	if (_tmp680_) {
		ValaDataType* _tmp685_;
		ValaDataType* _tmp686_;
		_tmp685_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp686_ = _tmp685_;
		_tmp679_ = _tmp686_ != NULL;
	} else {
		_tmp679_ = FALSE;
	}
	if (_tmp679_) {
		ValaDataType* _tmp687_;
		ValaDataType* _tmp688_;
		ValaTypeSymbol* _tmp689_;
		ValaTypeSymbol* _tmp690_;
		_tmp687_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp688_ = _tmp687_;
		_tmp689_ = vala_data_type_get_type_symbol (_tmp688_);
		_tmp690_ = _tmp689_;
		_tmp678_ = VALA_IS_ENUM (_tmp690_);
	} else {
		_tmp678_ = FALSE;
	}
	if (_tmp678_) {
		ValaEnum* enum_type = NULL;
		ValaDataType* _tmp691_;
		ValaDataType* _tmp692_;
		ValaTypeSymbol* _tmp693_;
		ValaTypeSymbol* _tmp694_;
		_tmp691_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp692_ = _tmp691_;
		_tmp693_ = vala_data_type_get_type_symbol (_tmp692_);
		_tmp694_ = _tmp693_;
		enum_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp694_, VALA_TYPE_ENUM, ValaEnum);
		{
			ValaList* _val_list = NULL;
			ValaEnum* _tmp695_;
			ValaList* _tmp696_;
			gint _val_size = 0;
			ValaList* _tmp697_;
			gint _tmp698_;
			gint _tmp699_;
			gint _val_index = 0;
			_tmp695_ = enum_type;
			_tmp696_ = vala_enum_get_values (_tmp695_);
			_val_list = _tmp696_;
			_tmp697_ = _val_list;
			_tmp698_ = vala_collection_get_size ((ValaCollection*) _tmp697_);
			_tmp699_ = _tmp698_;
			_val_size = _tmp699_;
			_val_index = -1;
			while (TRUE) {
				gint _tmp700_;
				gint _tmp701_;
				ValaEnumValue* val = NULL;
				ValaList* _tmp702_;
				gpointer _tmp703_;
				const gchar* _tmp704_;
				ValaEnumValue* _tmp705_;
				const gchar* _tmp706_;
				const gchar* _tmp707_;
				_val_index = _val_index + 1;
				_tmp700_ = _val_index;
				_tmp701_ = _val_size;
				if (!(_tmp700_ < _tmp701_)) {
					break;
				}
				_tmp702_ = _val_list;
				_tmp703_ = vala_list_get (_tmp702_, _val_index);
				val = (ValaEnumValue*) _tmp703_;
				_tmp704_ = self->priv->_member_name;
				_tmp705_ = val;
				_tmp706_ = vala_symbol_get_name ((ValaSymbol*) _tmp705_);
				_tmp707_ = _tmp706_;
				if (g_strcmp0 (_tmp704_, _tmp707_) == 0) {
					ValaEnumValue* _tmp708_;
					_tmp708_ = val;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp708_);
					_vala_code_node_unref0 (val);
					break;
				}
				_vala_code_node_unref0 (val);
			}
		}
	}
	_tmp709_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp710_ = _tmp709_;
	if (_tmp710_ == NULL) {
		gchar* base_type_name = NULL;
		gchar* _tmp711_;
		ValaSymbol* base_type = NULL;
		gboolean _tmp712_ = FALSE;
		ValaExpression* _tmp713_;
		ValaExpression* _tmp714_;
		gchar* base_type_package = NULL;
		gchar* _tmp734_;
		gboolean _tmp735_ = FALSE;
		ValaSymbol* _tmp736_;
		gchar* visited_types_string = NULL;
		gchar* _tmp751_;
		ValaSourceReference* _tmp767_;
		ValaSourceReference* _tmp768_;
		const gchar* _tmp769_;
		const gchar* _tmp770_;
		const gchar* _tmp771_;
		const gchar* _tmp772_;
		ValaInvalidType* _tmp773_;
		ValaInvalidType* _tmp774_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp711_ = g_strdup ("(null)");
		base_type_name = _tmp711_;
		base_type = NULL;
		_tmp713_ = vala_member_access_get_inner (self);
		_tmp714_ = _tmp713_;
		if (_tmp714_ != NULL) {
			ValaExpression* _tmp715_;
			ValaExpression* _tmp716_;
			ValaDataType* _tmp717_;
			ValaDataType* _tmp718_;
			_tmp715_ = vala_member_access_get_inner (self);
			_tmp716_ = _tmp715_;
			_tmp717_ = vala_expression_get_value_type (_tmp716_);
			_tmp718_ = _tmp717_;
			_tmp712_ = _tmp718_ != NULL;
		} else {
			_tmp712_ = FALSE;
		}
		if (_tmp712_) {
			ValaExpression* _tmp719_;
			ValaExpression* _tmp720_;
			ValaDataType* _tmp721_;
			ValaDataType* _tmp722_;
			gchar* _tmp723_;
			ValaExpression* _tmp724_;
			ValaExpression* _tmp725_;
			ValaDataType* _tmp726_;
			ValaDataType* _tmp727_;
			ValaTypeSymbol* _tmp728_;
			ValaTypeSymbol* _tmp729_;
			_tmp719_ = vala_member_access_get_inner (self);
			_tmp720_ = _tmp719_;
			_tmp721_ = vala_expression_get_value_type (_tmp720_);
			_tmp722_ = _tmp721_;
			_tmp723_ = vala_code_node_to_string ((ValaCodeNode*) _tmp722_);
			_g_free0 (base_type_name);
			base_type_name = _tmp723_;
			_tmp724_ = vala_member_access_get_inner (self);
			_tmp725_ = _tmp724_;
			_tmp726_ = vala_expression_get_value_type (_tmp725_);
			_tmp727_ = _tmp726_;
			_tmp728_ = vala_data_type_get_type_symbol (_tmp727_);
			_tmp729_ = _tmp728_;
			base_type = (ValaSymbol*) _tmp729_;
		} else {
			ValaSymbol* _tmp730_;
			_tmp730_ = base_symbol;
			if (_tmp730_ != NULL) {
				ValaSymbol* _tmp731_;
				gchar* _tmp732_;
				ValaSymbol* _tmp733_;
				_tmp731_ = base_symbol;
				_tmp732_ = vala_symbol_get_full_name (_tmp731_);
				_g_free0 (base_type_name);
				base_type_name = _tmp732_;
				_tmp733_ = base_symbol;
				base_type = _tmp733_;
			}
		}
		_tmp734_ = g_strdup ("");
		base_type_package = _tmp734_;
		_tmp736_ = base_type;
		if (_tmp736_ != NULL) {
			ValaSymbol* _tmp737_;
			gboolean _tmp738_;
			gboolean _tmp739_;
			_tmp737_ = base_type;
			_tmp738_ = vala_symbol_get_external_package (_tmp737_);
			_tmp739_ = _tmp738_;
			_tmp735_ = _tmp739_;
		} else {
			_tmp735_ = FALSE;
		}
		if (_tmp735_) {
			ValaSymbol* _tmp740_;
			ValaSourceReference* _tmp741_;
			ValaSourceReference* _tmp742_;
			ValaSourceFile* _tmp743_;
			ValaSourceFile* _tmp744_;
			const gchar* _tmp745_;
			const gchar* _tmp746_;
			gchar* _tmp747_;
			const gchar* _tmp748_;
			_tmp740_ = base_symbol;
			_tmp741_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp740_);
			_tmp742_ = _tmp741_;
			_tmp743_ = vala_source_reference_get_file (_tmp742_);
			_tmp744_ = _tmp743_;
			_tmp745_ = vala_source_file_get_package_name (_tmp744_);
			_tmp746_ = _tmp745_;
			_tmp747_ = g_strdup (_tmp746_);
			_g_free0 (base_type_package);
			base_type_package = _tmp747_;
			_tmp748_ = base_type_package;
			if (_tmp748_ != NULL) {
				const gchar* _tmp749_;
				gchar* _tmp750_;
				_tmp749_ = base_type_package;
				_tmp750_ = g_strdup_printf (" (%s)", _tmp749_);
				_g_free0 (base_type_package);
				base_type_package = _tmp750_;
			}
		}
		_tmp751_ = g_strdup ("");
		visited_types_string = _tmp751_;
		{
			ValaArrayList* _type_list = NULL;
			ValaArrayList* _tmp752_;
			gint _type_size = 0;
			ValaArrayList* _tmp753_;
			gint _tmp754_;
			gint _tmp755_;
			gint _type_index = 0;
			_tmp752_ = visited_types;
			_type_list = _tmp752_;
			_tmp753_ = _type_list;
			_tmp754_ = vala_collection_get_size ((ValaCollection*) _tmp753_);
			_tmp755_ = _tmp754_;
			_type_size = _tmp755_;
			_type_index = -1;
			while (TRUE) {
				gint _tmp756_;
				gint _tmp757_;
				ValaDataType* type = NULL;
				ValaArrayList* _tmp758_;
				gpointer _tmp759_;
				const gchar* _tmp760_;
				ValaDataType* _tmp761_;
				gchar* _tmp762_;
				gchar* _tmp763_;
				gchar* _tmp764_;
				gchar* _tmp765_;
				gchar* _tmp766_;
				_type_index = _type_index + 1;
				_tmp756_ = _type_index;
				_tmp757_ = _type_size;
				if (!(_tmp756_ < _tmp757_)) {
					break;
				}
				_tmp758_ = _type_list;
				_tmp759_ = vala_list_get ((ValaList*) _tmp758_, _type_index);
				type = (ValaDataType*) _tmp759_;
				_tmp760_ = visited_types_string;
				_tmp761_ = type;
				_tmp762_ = vala_code_node_to_string ((ValaCodeNode*) _tmp761_);
				_tmp763_ = _tmp762_;
				_tmp764_ = g_strdup_printf (" or `%s'", _tmp763_);
				_tmp765_ = _tmp764_;
				_tmp766_ = g_strconcat (_tmp760_, _tmp765_, NULL);
				_g_free0 (visited_types_string);
				visited_types_string = _tmp766_;
				_g_free0 (_tmp765_);
				_g_free0 (_tmp763_);
				_vala_code_node_unref0 (type);
			}
		}
		_tmp767_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp768_ = _tmp767_;
		_tmp769_ = self->priv->_member_name;
		_tmp770_ = base_type_name;
		_tmp771_ = base_type_package;
		_tmp772_ = visited_types_string;
		vala_report_error (_tmp768_, "The name `%s' does not exist in the context of `%s'%s%s", _tmp769_, _tmp770_, _tmp771_, _tmp772_);
		_tmp773_ = vala_invalid_type_new ();
		_tmp774_ = _tmp773_;
		vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp774_);
		_vala_code_node_unref0 (_tmp774_);
		result = FALSE;
		_g_free0 (visited_types_string);
		_g_free0 (base_type_package);
		_g_free0 (base_type_name);
		_vala_iterable_unref0 (visited_types);
		return result;
	} else {
		ValaSymbol* _tmp775_;
		ValaSymbol* _tmp776_;
		gboolean _tmp777_;
		gboolean _tmp778_;
		_tmp775_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp776_ = _tmp775_;
		_tmp777_ = vala_code_node_get_error ((ValaCodeNode*) _tmp776_);
		_tmp778_ = _tmp777_;
		if (_tmp778_) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_iterable_unref0 (visited_types);
			return result;
		}
	}
	_tmp779_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp780_ = _tmp779_;
	if (VALA_IS_SIGNAL (_tmp780_)) {
		ValaSignal* sig = NULL;
		ValaSymbol* _tmp781_;
		ValaSymbol* _tmp782_;
		ValaCodeNode* ma = NULL;
		ValaCodeNode* parent = NULL;
		ValaCodeNode* _tmp789_;
		ValaCodeNode* _tmp790_;
		ValaCodeNode* _tmp791_;
		gboolean _tmp792_ = FALSE;
		gboolean _tmp793_ = FALSE;
		gboolean _tmp794_ = FALSE;
		ValaCodeNode* _tmp795_;
		_tmp781_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp782_ = _tmp781_;
		sig = G_TYPE_CHECK_INSTANCE_CAST (_tmp782_, VALA_TYPE_SIGNAL, ValaSignal);
		ma = (ValaCodeNode*) self;
		while (TRUE) {
			ValaCodeNode* _tmp783_;
			ValaCodeNode* _tmp784_;
			ValaCodeNode* _tmp785_;
			ValaCodeNode* _tmp786_;
			ValaCodeNode* _tmp787_;
			ValaCodeNode* _tmp788_;
			_tmp783_ = ma;
			_tmp784_ = vala_code_node_get_parent_node (_tmp783_);
			_tmp785_ = _tmp784_;
			if (!VALA_IS_MEMBER_ACCESS (_tmp785_)) {
				break;
			}
			_tmp786_ = ma;
			_tmp787_ = vala_code_node_get_parent_node (_tmp786_);
			_tmp788_ = _tmp787_;
			ma = _tmp788_;
		}
		_tmp789_ = ma;
		_tmp790_ = vala_code_node_get_parent_node (_tmp789_);
		_tmp791_ = _tmp790_;
		parent = _tmp791_;
		_tmp795_ = parent;
		if (_tmp795_ != NULL) {
			ValaCodeNode* _tmp796_;
			_tmp796_ = parent;
			_tmp794_ = !VALA_IS_ELEMENT_ACCESS (_tmp796_);
		} else {
			_tmp794_ = FALSE;
		}
		if (_tmp794_) {
			ValaCodeNode* _tmp797_;
			ValaExpression* _tmp798_;
			ValaExpression* _tmp799_;
			_tmp797_ = ma;
			_tmp798_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp797_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp799_ = _tmp798_;
			_tmp793_ = !VALA_IS_BASE_ACCESS (_tmp799_);
		} else {
			_tmp793_ = FALSE;
		}
		if (_tmp793_) {
			gboolean _tmp800_ = FALSE;
			ValaCodeNode* _tmp801_;
			_tmp801_ = parent;
			if (!VALA_IS_METHOD_CALL (_tmp801_)) {
				_tmp800_ = TRUE;
			} else {
				ValaCodeNode* _tmp802_;
				ValaList* _tmp803_;
				_tmp802_ = parent;
				_tmp803_ = vala_callable_expression_get_argument_list ((ValaCallableExpression*) G_TYPE_CHECK_INSTANCE_CAST (_tmp802_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
				_tmp800_ = vala_collection_contains ((ValaCollection*) _tmp803_, (ValaExpression*) self);
			}
			_tmp792_ = _tmp800_;
		} else {
			_tmp792_ = FALSE;
		}
		if (_tmp792_) {
			ValaSignal* _tmp804_;
			ValaAttribute* _tmp805_;
			_tmp804_ = sig;
			_tmp805_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp804_, "HasEmitter");
			if (_tmp805_ != NULL) {
				ValaSignal* _tmp806_;
				ValaSignal* _tmp807_;
				ValaMethod* _tmp808_;
				ValaMethod* _tmp809_;
				_tmp806_ = sig;
				if (!vala_code_node_check ((ValaCodeNode*) _tmp806_, context)) {
					result = FALSE;
					_vala_iterable_unref0 (visited_types);
					return result;
				}
				_tmp807_ = sig;
				_tmp808_ = vala_signal_get_emitter (_tmp807_);
				_tmp809_ = _tmp808_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp809_);
			} else {
				ValaSourceReference* _tmp810_;
				ValaSourceReference* _tmp811_;
				ValaSymbol* _tmp812_;
				ValaSymbol* _tmp813_;
				gchar* _tmp814_;
				gchar* _tmp815_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp810_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp811_ = _tmp810_;
				_tmp812_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp813_ = _tmp812_;
				_tmp814_ = vala_symbol_get_full_name (_tmp813_);
				_tmp815_ = _tmp814_;
				vala_report_error (_tmp811_, "Signal `%s' requires emitter in this context", _tmp815_);
				_g_free0 (_tmp815_);
				result = FALSE;
				_vala_iterable_unref0 (visited_types);
				return result;
			}
		}
	}
	_tmp816_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp817_ = _tmp816_;
	member = _tmp817_;
	access = VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
	instance = FALSE;
	klass = FALSE;
	generics = FALSE;
	_tmp818_ = member;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp818_, context)) {
		result = FALSE;
		_vala_iterable_unref0 (visited_types);
		return result;
	}
	_tmp819_ = member;
	if (VALA_IS_LOCAL_VARIABLE (_tmp819_)) {
		ValaLocalVariable* local = NULL;
		ValaSymbol* _tmp820_;
		ValaBlock* block = NULL;
		ValaLocalVariable* _tmp821_;
		ValaSymbol* _tmp822_;
		ValaSymbol* _tmp823_;
		gboolean _tmp824_ = FALSE;
		ValaBlock* _tmp825_;
		_tmp820_ = member;
		local = G_TYPE_CHECK_INSTANCE_CAST (_tmp820_, VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable);
		_tmp821_ = local;
		_tmp822_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp821_);
		_tmp823_ = _tmp822_;
		block = VALA_IS_BLOCK (_tmp823_) ? ((ValaBlock*) _tmp823_) : NULL;
		_tmp825_ = block;
		if (_tmp825_ != NULL) {
			ValaBlock* _tmp826_;
			ValaSymbol* _tmp827_;
			ValaSemanticAnalyzer* _tmp828_;
			ValaSemanticAnalyzer* _tmp829_;
			ValaSymbol* _tmp830_;
			ValaSymbol* _tmp831_;
			_tmp826_ = block;
			_tmp827_ = vala_semantic_analyzer_find_parent_method_or_property_accessor ((ValaSymbol*) _tmp826_);
			_tmp828_ = vala_code_context_get_analyzer (context);
			_tmp829_ = _tmp828_;
			_tmp830_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp829_);
			_tmp831_ = _tmp830_;
			_tmp824_ = _tmp827_ != _tmp831_;
		} else {
			_tmp824_ = FALSE;
		}
		if (_tmp824_) {
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp832_;
			ValaSemanticAnalyzer* _tmp833_;
			ValaSymbol* _tmp834_;
			ValaSymbol* _tmp835_;
			ValaLocalVariable* _tmp846_;
			ValaBlock* _tmp847_;
			ValaLocalVariable* _tmp848_;
			ValaDataType* _tmp849_;
			ValaDataType* _tmp850_;
			ValaTypeSymbol* _tmp851_;
			ValaTypeSymbol* _tmp852_;
			ValaSemanticAnalyzer* _tmp853_;
			ValaSemanticAnalyzer* _tmp854_;
			ValaDataType* _tmp855_;
			ValaTypeSymbol* _tmp856_;
			ValaTypeSymbol* _tmp857_;
			_tmp832_ = vala_code_context_get_analyzer (context);
			_tmp833_ = _tmp832_;
			_tmp834_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp833_);
			_tmp835_ = _tmp834_;
			sym = _tmp835_;
			while (TRUE) {
				ValaSymbol* _tmp836_;
				ValaBlock* _tmp837_;
				ValaMethod* method = NULL;
				ValaSymbol* _tmp838_;
				ValaMethod* _tmp839_;
				ValaSymbol* _tmp843_;
				ValaSymbol* _tmp844_;
				ValaSymbol* _tmp845_;
				_tmp836_ = sym;
				_tmp837_ = block;
				if (!(_tmp836_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp837_, VALA_TYPE_SYMBOL, ValaSymbol))) {
					break;
				}
				_tmp838_ = sym;
				method = VALA_IS_METHOD (_tmp838_) ? ((ValaMethod*) _tmp838_) : NULL;
				_tmp839_ = method;
				if (_tmp839_ != NULL) {
					ValaMethod* _tmp840_;
					ValaMethod* _tmp841_;
					ValaLocalVariable* _tmp842_;
					_tmp840_ = method;
					vala_method_set_closure (_tmp840_, TRUE);
					_tmp841_ = method;
					_tmp842_ = local;
					vala_method_add_captured_variable (_tmp841_, _tmp842_);
				}
				_tmp843_ = sym;
				_tmp844_ = vala_symbol_get_parent_symbol (_tmp843_);
				_tmp845_ = _tmp844_;
				sym = _tmp845_;
			}
			_tmp846_ = local;
			vala_local_variable_set_captured (_tmp846_, TRUE);
			_tmp847_ = block;
			vala_block_set_captured (_tmp847_, TRUE);
			_tmp848_ = local;
			_tmp849_ = vala_variable_get_variable_type ((ValaVariable*) _tmp848_);
			_tmp850_ = _tmp849_;
			_tmp851_ = vala_data_type_get_type_symbol (_tmp850_);
			_tmp852_ = _tmp851_;
			_tmp853_ = vala_code_context_get_analyzer (context);
			_tmp854_ = _tmp853_;
			_tmp855_ = _tmp854_->va_list_type;
			_tmp856_ = vala_data_type_get_type_symbol (_tmp855_);
			_tmp857_ = _tmp856_;
			if (_tmp852_ == _tmp857_) {
				ValaSourceReference* _tmp858_;
				ValaSourceReference* _tmp859_;
				ValaLocalVariable* _tmp860_;
				gchar* _tmp861_;
				gchar* _tmp862_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp858_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp859_ = _tmp858_;
				_tmp860_ = local;
				_tmp861_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp860_);
				_tmp862_ = _tmp861_;
				vala_report_error (_tmp859_, "Capturing `va_list' variable `%s' is not allowed", _tmp862_);
				_g_free0 (_tmp862_);
			}
		}
	} else {
		ValaSymbol* _tmp863_;
		_tmp863_ = member;
		if (VALA_IS_PARAMETER (_tmp863_)) {
			ValaParameter* param = NULL;
			ValaSymbol* _tmp864_;
			ValaMethod* m = NULL;
			ValaParameter* _tmp865_;
			ValaSymbol* _tmp866_;
			ValaSymbol* _tmp867_;
			gboolean _tmp868_ = FALSE;
			gboolean _tmp869_ = FALSE;
			ValaMethod* _tmp870_;
			_tmp864_ = member;
			param = G_TYPE_CHECK_INSTANCE_CAST (_tmp864_, VALA_TYPE_PARAMETER, ValaParameter);
			_tmp865_ = param;
			_tmp866_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp865_);
			_tmp867_ = _tmp866_;
			m = VALA_IS_METHOD (_tmp867_) ? ((ValaMethod*) _tmp867_) : NULL;
			_tmp870_ = m;
			if (_tmp870_ != NULL) {
				ValaMethod* _tmp871_;
				ValaSemanticAnalyzer* _tmp872_;
				ValaSemanticAnalyzer* _tmp873_;
				ValaSymbol* _tmp874_;
				ValaSymbol* _tmp875_;
				_tmp871_ = m;
				_tmp872_ = vala_code_context_get_analyzer (context);
				_tmp873_ = _tmp872_;
				_tmp874_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp873_);
				_tmp875_ = _tmp874_;
				_tmp869_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp871_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp875_;
			} else {
				_tmp869_ = FALSE;
			}
			if (_tmp869_) {
				ValaParameter* _tmp876_;
				ValaMethod* _tmp877_;
				ValaParameter* _tmp878_;
				ValaParameter* _tmp879_;
				_tmp876_ = param;
				_tmp877_ = m;
				_tmp878_ = vala_method_get_this_parameter (_tmp877_);
				_tmp879_ = _tmp878_;
				_tmp868_ = _tmp876_ != _tmp879_;
			} else {
				_tmp868_ = FALSE;
			}
			if (_tmp868_) {
				ValaSymbol* sym = NULL;
				ValaSemanticAnalyzer* _tmp880_;
				ValaSemanticAnalyzer* _tmp881_;
				ValaSymbol* _tmp882_;
				ValaSymbol* _tmp883_;
				ValaParameter* _tmp892_;
				ValaMethod* _tmp893_;
				ValaBlock* _tmp894_;
				ValaBlock* _tmp895_;
				ValaParameter* _tmp896_;
				ValaParameterDirection _tmp897_;
				ValaParameterDirection _tmp898_;
				ValaParameter* _tmp904_;
				ValaDataType* _tmp905_;
				ValaDataType* _tmp906_;
				ValaTypeSymbol* _tmp907_;
				ValaTypeSymbol* _tmp908_;
				ValaSemanticAnalyzer* _tmp909_;
				ValaSemanticAnalyzer* _tmp910_;
				ValaDataType* _tmp911_;
				ValaTypeSymbol* _tmp912_;
				ValaTypeSymbol* _tmp913_;
				_tmp880_ = vala_code_context_get_analyzer (context);
				_tmp881_ = _tmp880_;
				_tmp882_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp881_);
				_tmp883_ = _tmp882_;
				sym = _tmp883_;
				while (TRUE) {
					ValaSymbol* _tmp884_;
					ValaMethod* _tmp885_;
					ValaMethod* method = NULL;
					ValaSymbol* _tmp886_;
					ValaMethod* _tmp887_;
					ValaSymbol* _tmp889_;
					ValaSymbol* _tmp890_;
					ValaSymbol* _tmp891_;
					_tmp884_ = sym;
					_tmp885_ = m;
					if (!(_tmp884_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp885_, VALA_TYPE_SYMBOL, ValaSymbol))) {
						break;
					}
					_tmp886_ = sym;
					method = VALA_IS_METHOD (_tmp886_) ? ((ValaMethod*) _tmp886_) : NULL;
					_tmp887_ = method;
					if (_tmp887_ != NULL) {
						ValaMethod* _tmp888_;
						_tmp888_ = method;
						vala_method_set_closure (_tmp888_, TRUE);
					}
					_tmp889_ = sym;
					_tmp890_ = vala_symbol_get_parent_symbol (_tmp889_);
					_tmp891_ = _tmp890_;
					sym = _tmp891_;
				}
				_tmp892_ = param;
				vala_parameter_set_captured (_tmp892_, TRUE);
				_tmp893_ = m;
				_tmp894_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp893_);
				_tmp895_ = _tmp894_;
				vala_block_set_captured (_tmp895_, TRUE);
				_tmp896_ = param;
				_tmp897_ = vala_parameter_get_direction (_tmp896_);
				_tmp898_ = _tmp897_;
				if (_tmp898_ != VALA_PARAMETER_DIRECTION_IN) {
					ValaSourceReference* _tmp899_;
					ValaSourceReference* _tmp900_;
					ValaParameter* _tmp901_;
					gchar* _tmp902_;
					gchar* _tmp903_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp899_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp900_ = _tmp899_;
					_tmp901_ = param;
					_tmp902_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp901_);
					_tmp903_ = _tmp902_;
					vala_report_error (_tmp900_, "Cannot capture reference or output parameter `%s'", _tmp903_);
					_g_free0 (_tmp903_);
				}
				_tmp904_ = param;
				_tmp905_ = vala_variable_get_variable_type ((ValaVariable*) _tmp904_);
				_tmp906_ = _tmp905_;
				_tmp907_ = vala_data_type_get_type_symbol (_tmp906_);
				_tmp908_ = _tmp907_;
				_tmp909_ = vala_code_context_get_analyzer (context);
				_tmp910_ = _tmp909_;
				_tmp911_ = _tmp910_->va_list_type;
				_tmp912_ = vala_data_type_get_type_symbol (_tmp911_);
				_tmp913_ = _tmp912_;
				if (_tmp908_ == _tmp913_) {
					ValaSourceReference* _tmp914_;
					ValaSourceReference* _tmp915_;
					ValaParameter* _tmp916_;
					gchar* _tmp917_;
					gchar* _tmp918_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp914_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp915_ = _tmp914_;
					_tmp916_ = param;
					_tmp917_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp916_);
					_tmp918_ = _tmp917_;
					vala_report_error (_tmp915_, "Capturing `va_list' parameter `%s' is not allowed", _tmp918_);
					_g_free0 (_tmp918_);
				}
			} else {
				ValaPropertyAccessor* acc = NULL;
				ValaParameter* _tmp919_;
				ValaSymbol* _tmp920_;
				ValaSymbol* _tmp921_;
				ValaSymbol* _tmp922_;
				ValaSymbol* _tmp923_;
				gboolean _tmp924_ = FALSE;
				gboolean _tmp925_ = FALSE;
				ValaPropertyAccessor* _tmp926_;
				_tmp919_ = param;
				_tmp920_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp919_);
				_tmp921_ = _tmp920_;
				_tmp922_ = vala_symbol_get_parent_symbol (_tmp921_);
				_tmp923_ = _tmp922_;
				acc = VALA_IS_PROPERTY_ACCESSOR (_tmp923_) ? ((ValaPropertyAccessor*) _tmp923_) : NULL;
				_tmp926_ = acc;
				if (_tmp926_ != NULL) {
					ValaPropertyAccessor* _tmp927_;
					ValaSemanticAnalyzer* _tmp928_;
					ValaSemanticAnalyzer* _tmp929_;
					ValaSymbol* _tmp930_;
					ValaSymbol* _tmp931_;
					_tmp927_ = acc;
					_tmp928_ = vala_code_context_get_analyzer (context);
					_tmp929_ = _tmp928_;
					_tmp930_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp929_);
					_tmp931_ = _tmp930_;
					_tmp925_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp927_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp931_;
				} else {
					_tmp925_ = FALSE;
				}
				if (_tmp925_) {
					ValaParameter* _tmp932_;
					ValaPropertyAccessor* _tmp933_;
					ValaProperty* _tmp934_;
					ValaProperty* _tmp935_;
					ValaParameter* _tmp936_;
					ValaParameter* _tmp937_;
					_tmp932_ = param;
					_tmp933_ = acc;
					_tmp934_ = vala_property_accessor_get_prop (_tmp933_);
					_tmp935_ = _tmp934_;
					_tmp936_ = vala_property_get_this_parameter (_tmp935_);
					_tmp937_ = _tmp936_;
					_tmp924_ = _tmp932_ != _tmp937_;
				} else {
					_tmp924_ = FALSE;
				}
				if (_tmp924_) {
					ValaSymbol* sym = NULL;
					ValaSemanticAnalyzer* _tmp938_;
					ValaSemanticAnalyzer* _tmp939_;
					ValaSymbol* _tmp940_;
					ValaSymbol* _tmp941_;
					ValaParameter* _tmp950_;
					ValaPropertyAccessor* _tmp951_;
					ValaBlock* _tmp952_;
					ValaBlock* _tmp953_;
					_tmp938_ = vala_code_context_get_analyzer (context);
					_tmp939_ = _tmp938_;
					_tmp940_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp939_);
					_tmp941_ = _tmp940_;
					sym = _tmp941_;
					while (TRUE) {
						ValaSymbol* _tmp942_;
						ValaMethod* _tmp943_;
						ValaMethod* method = NULL;
						ValaSymbol* _tmp944_;
						ValaMethod* _tmp945_;
						ValaSymbol* _tmp947_;
						ValaSymbol* _tmp948_;
						ValaSymbol* _tmp949_;
						_tmp942_ = sym;
						_tmp943_ = m;
						if (!(_tmp942_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp943_, VALA_TYPE_SYMBOL, ValaSymbol))) {
							break;
						}
						_tmp944_ = sym;
						method = VALA_IS_METHOD (_tmp944_) ? ((ValaMethod*) _tmp944_) : NULL;
						_tmp945_ = method;
						if (_tmp945_ != NULL) {
							ValaMethod* _tmp946_;
							_tmp946_ = method;
							vala_method_set_closure (_tmp946_, TRUE);
						}
						_tmp947_ = sym;
						_tmp948_ = vala_symbol_get_parent_symbol (_tmp947_);
						_tmp949_ = _tmp948_;
						sym = _tmp949_;
					}
					_tmp950_ = param;
					vala_parameter_set_captured (_tmp950_, TRUE);
					_tmp951_ = acc;
					_tmp952_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp951_);
					_tmp953_ = _tmp952_;
					vala_block_set_captured (_tmp953_, TRUE);
				}
			}
		} else {
			ValaSymbol* _tmp954_;
			_tmp954_ = member;
			if (VALA_IS_FIELD (_tmp954_)) {
				ValaField* f = NULL;
				ValaSymbol* _tmp955_;
				ValaField* _tmp956_;
				ValaSymbolAccessibility _tmp957_;
				ValaSymbolAccessibility _tmp958_;
				ValaField* _tmp959_;
				ValaMemberBinding _tmp960_;
				ValaMemberBinding _tmp961_;
				ValaField* _tmp962_;
				ValaMemberBinding _tmp963_;
				ValaMemberBinding _tmp964_;
				ValaField* _tmp965_;
				ValaDataType* _tmp966_;
				ValaDataType* _tmp967_;
				_tmp955_ = member;
				f = G_TYPE_CHECK_INSTANCE_CAST (_tmp955_, VALA_TYPE_FIELD, ValaField);
				_tmp956_ = f;
				_tmp957_ = vala_symbol_get_access ((ValaSymbol*) _tmp956_);
				_tmp958_ = _tmp957_;
				access = _tmp958_;
				_tmp959_ = f;
				_tmp960_ = vala_field_get_binding (_tmp959_);
				_tmp961_ = _tmp960_;
				instance = _tmp961_ == VALA_MEMBER_BINDING_INSTANCE;
				_tmp962_ = f;
				_tmp963_ = vala_field_get_binding (_tmp962_);
				_tmp964_ = _tmp963_;
				klass = _tmp964_ == VALA_MEMBER_BINDING_CLASS;
				_tmp965_ = f;
				_tmp966_ = vala_variable_get_variable_type ((ValaVariable*) _tmp965_);
				_tmp967_ = _tmp966_;
				if (VALA_IS_GENERIC_TYPE (_tmp967_)) {
					generics = TRUE;
				}
			} else {
				ValaSymbol* _tmp968_;
				_tmp968_ = member;
				if (VALA_IS_CONSTANT (_tmp968_)) {
					ValaConstant* c = NULL;
					ValaSymbol* _tmp969_;
					ValaConstant* _tmp970_;
					ValaSymbolAccessibility _tmp971_;
					ValaSymbolAccessibility _tmp972_;
					ValaBlock* block = NULL;
					ValaConstant* _tmp973_;
					ValaSymbol* _tmp974_;
					ValaSymbol* _tmp975_;
					gboolean _tmp976_ = FALSE;
					ValaBlock* _tmp977_;
					_tmp969_ = member;
					c = G_TYPE_CHECK_INSTANCE_CAST (_tmp969_, VALA_TYPE_CONSTANT, ValaConstant);
					_tmp970_ = c;
					_tmp971_ = vala_symbol_get_access ((ValaSymbol*) _tmp970_);
					_tmp972_ = _tmp971_;
					access = _tmp972_;
					_tmp973_ = c;
					_tmp974_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp973_);
					_tmp975_ = _tmp974_;
					block = VALA_IS_BLOCK (_tmp975_) ? ((ValaBlock*) _tmp975_) : NULL;
					_tmp977_ = block;
					if (_tmp977_ != NULL) {
						ValaBlock* _tmp978_;
						ValaSymbol* _tmp979_;
						ValaSemanticAnalyzer* _tmp980_;
						ValaSemanticAnalyzer* _tmp981_;
						ValaSymbol* _tmp982_;
						ValaSymbol* _tmp983_;
						_tmp978_ = block;
						_tmp979_ = vala_semantic_analyzer_find_parent_method_or_property_accessor ((ValaSymbol*) _tmp978_);
						_tmp980_ = vala_code_context_get_analyzer (context);
						_tmp981_ = _tmp980_;
						_tmp982_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp981_);
						_tmp983_ = _tmp982_;
						_tmp976_ = _tmp979_ != _tmp983_;
					} else {
						_tmp976_ = FALSE;
					}
					if (_tmp976_) {
						ValaSourceReference* _tmp984_;
						ValaSourceReference* _tmp985_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp984_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp985_ = _tmp984_;
						vala_report_error (_tmp985_, "internal error: accessing local constants of outer methods is not supp" \
"orted yet");
						result = FALSE;
						_vala_iterable_unref0 (visited_types);
						return result;
					}
				} else {
					ValaSymbol* _tmp986_;
					_tmp986_ = member;
					if (VALA_IS_METHOD (_tmp986_)) {
						ValaMethod* m = NULL;
						ValaSymbol* _tmp987_;
						ValaMethod* _tmp988_;
						gboolean _tmp989_;
						gboolean _tmp990_;
						ValaMethod* _tmp1077_;
						ValaSymbolAccessibility _tmp1078_;
						ValaSymbolAccessibility _tmp1079_;
						ValaMethod* _tmp1080_;
						ValaMethod* _tmp1084_;
						ValaMemberBinding _tmp1085_;
						ValaMemberBinding _tmp1086_;
						ValaGenericType* generic_type = NULL;
						ValaMethod* _tmp1106_;
						ValaDataType* _tmp1107_;
						ValaDataType* _tmp1108_;
						gboolean _tmp1109_ = FALSE;
						ValaGenericType* _tmp1110_;
						_tmp987_ = member;
						m = G_TYPE_CHECK_INSTANCE_CAST (_tmp987_, VALA_TYPE_METHOD, ValaMethod);
						_tmp988_ = m;
						_tmp989_ = vala_method_get_is_async_callback (_tmp988_);
						_tmp990_ = _tmp989_;
						if (_tmp990_) {
							ValaMethod* async_method = NULL;
							ValaSemanticAnalyzer* _tmp991_;
							ValaSemanticAnalyzer* _tmp992_;
							ValaMethod* _tmp993_;
							ValaMethod* _tmp994_;
							gboolean is_valid_access = FALSE;
							ValaMethod* _tmp995_;
							ValaMethod* _tmp1022_;
							ValaSemanticAnalyzer* _tmp1023_;
							ValaSemanticAnalyzer* _tmp1024_;
							ValaMethod* _tmp1025_;
							ValaMethod* _tmp1026_;
							ValaMethod* _tmp1042_;
							ValaMethod* _tmp1043_;
							ValaMethod* _tmp1044_;
							ValaSymbol* _tmp1045_;
							ValaSymbol* _tmp1046_;
							_tmp991_ = vala_code_context_get_analyzer (context);
							_tmp992_ = _tmp991_;
							_tmp993_ = vala_semantic_analyzer_get_current_async_method (_tmp992_);
							_tmp994_ = _tmp993_;
							async_method = _tmp994_;
							is_valid_access = FALSE;
							_tmp995_ = async_method;
							if (_tmp995_ != NULL) {
								ValaMethod* _tmp996_;
								ValaMethod* _tmp997_;
								ValaMethod* _tmp998_;
								_tmp996_ = m;
								_tmp997_ = async_method;
								_tmp998_ = vala_method_get_callback_method (_tmp997_);
								if (_tmp996_ == _tmp998_) {
									is_valid_access = TRUE;
								} else {
									gboolean _tmp999_ = FALSE;
									ValaMethod* _tmp1000_;
									ValaMethod* _tmp1001_;
									ValaMethod* _tmp1002_;
									_tmp1000_ = async_method;
									_tmp1001_ = vala_method_get_base_method (_tmp1000_);
									_tmp1002_ = _tmp1001_;
									if (_tmp1002_ != NULL) {
										ValaMethod* _tmp1003_;
										ValaMethod* _tmp1004_;
										ValaMethod* _tmp1005_;
										ValaMethod* _tmp1006_;
										ValaMethod* _tmp1007_;
										_tmp1003_ = m;
										_tmp1004_ = async_method;
										_tmp1005_ = vala_method_get_base_method (_tmp1004_);
										_tmp1006_ = _tmp1005_;
										_tmp1007_ = vala_method_get_callback_method (_tmp1006_);
										_tmp999_ = _tmp1003_ == _tmp1007_;
									} else {
										_tmp999_ = FALSE;
									}
									if (_tmp999_) {
										is_valid_access = TRUE;
									} else {
										gboolean _tmp1008_ = FALSE;
										ValaMethod* _tmp1009_;
										ValaMethod* _tmp1010_;
										ValaMethod* _tmp1011_;
										_tmp1009_ = async_method;
										_tmp1010_ = vala_method_get_base_interface_method (_tmp1009_);
										_tmp1011_ = _tmp1010_;
										if (_tmp1011_ != NULL) {
											ValaMethod* _tmp1012_;
											ValaMethod* _tmp1013_;
											ValaMethod* _tmp1014_;
											ValaMethod* _tmp1015_;
											ValaMethod* _tmp1016_;
											_tmp1012_ = m;
											_tmp1013_ = async_method;
											_tmp1014_ = vala_method_get_base_interface_method (_tmp1013_);
											_tmp1015_ = _tmp1014_;
											_tmp1016_ = vala_method_get_callback_method (_tmp1015_);
											_tmp1008_ = _tmp1012_ == _tmp1016_;
										} else {
											_tmp1008_ = FALSE;
										}
										if (_tmp1008_) {
											is_valid_access = TRUE;
										}
									}
								}
							}
							if (!is_valid_access) {
								ValaSourceReference* _tmp1017_;
								ValaSourceReference* _tmp1018_;
								ValaMethod* _tmp1019_;
								gchar* _tmp1020_;
								gchar* _tmp1021_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp1017_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp1018_ = _tmp1017_;
								_tmp1019_ = m;
								_tmp1020_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1019_);
								_tmp1021_ = _tmp1020_;
								vala_report_error (_tmp1018_, "Access to async callback `%s' not allowed in this context", _tmp1021_);
								_g_free0 (_tmp1021_);
								result = FALSE;
								_vala_iterable_unref0 (visited_types);
								return result;
							}
							_tmp1022_ = async_method;
							_tmp1023_ = vala_code_context_get_analyzer (context);
							_tmp1024_ = _tmp1023_;
							_tmp1025_ = vala_semantic_analyzer_get_current_method (_tmp1024_);
							_tmp1026_ = _tmp1025_;
							if (_tmp1022_ != _tmp1026_) {
								ValaSymbol* sym = NULL;
								ValaSemanticAnalyzer* _tmp1027_;
								ValaSemanticAnalyzer* _tmp1028_;
								ValaMethod* _tmp1029_;
								ValaMethod* _tmp1030_;
								ValaMethod* _tmp1039_;
								ValaBlock* _tmp1040_;
								ValaBlock* _tmp1041_;
								_tmp1027_ = vala_code_context_get_analyzer (context);
								_tmp1028_ = _tmp1027_;
								_tmp1029_ = vala_semantic_analyzer_get_current_method (_tmp1028_);
								_tmp1030_ = _tmp1029_;
								sym = (ValaSymbol*) _tmp1030_;
								while (TRUE) {
									ValaSymbol* _tmp1031_;
									ValaMethod* _tmp1032_;
									ValaMethod* method = NULL;
									ValaSymbol* _tmp1033_;
									ValaMethod* _tmp1034_;
									ValaSymbol* _tmp1036_;
									ValaSymbol* _tmp1037_;
									ValaSymbol* _tmp1038_;
									_tmp1031_ = sym;
									_tmp1032_ = async_method;
									if (!(_tmp1031_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1032_, VALA_TYPE_SYMBOL, ValaSymbol))) {
										break;
									}
									_tmp1033_ = sym;
									method = VALA_IS_METHOD (_tmp1033_) ? ((ValaMethod*) _tmp1033_) : NULL;
									_tmp1034_ = method;
									if (_tmp1034_ != NULL) {
										ValaMethod* _tmp1035_;
										_tmp1035_ = method;
										vala_method_set_closure (_tmp1035_, TRUE);
									}
									_tmp1036_ = sym;
									_tmp1037_ = vala_symbol_get_parent_symbol (_tmp1036_);
									_tmp1038_ = _tmp1037_;
									sym = _tmp1038_;
								}
								_tmp1039_ = async_method;
								_tmp1040_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp1039_);
								_tmp1041_ = _tmp1040_;
								vala_block_set_captured (_tmp1041_, TRUE);
							}
							_tmp1042_ = async_method;
							_tmp1043_ = vala_method_get_callback_method (_tmp1042_);
							m = _tmp1043_;
							_tmp1044_ = m;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1044_);
							_tmp1045_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp1046_ = _tmp1045_;
							member = _tmp1046_;
						} else {
							ValaMethod* _tmp1047_;
							ValaMethod* _tmp1048_;
							ValaMethod* _tmp1049_;
							_tmp1047_ = m;
							_tmp1048_ = vala_method_get_base_method (_tmp1047_);
							_tmp1049_ = _tmp1048_;
							if (_tmp1049_ != NULL) {
								ValaMethod* _tmp1050_;
								ValaMethod* _tmp1051_;
								ValaMethod* _tmp1052_;
								ValaMethod* _tmp1053_;
								ValaSignal* _tmp1054_;
								ValaSignal* _tmp1055_;
								ValaSymbol* _tmp1060_;
								ValaSymbol* _tmp1061_;
								_tmp1050_ = m;
								_tmp1051_ = vala_method_get_base_method (_tmp1050_);
								_tmp1052_ = _tmp1051_;
								m = _tmp1052_;
								_tmp1053_ = m;
								_tmp1054_ = vala_method_get_signal_reference (_tmp1053_);
								_tmp1055_ = _tmp1054_;
								if (_tmp1055_ != NULL) {
									ValaMethod* _tmp1056_;
									ValaSignal* _tmp1057_;
									ValaSignal* _tmp1058_;
									_tmp1056_ = m;
									_tmp1057_ = vala_method_get_signal_reference (_tmp1056_);
									_tmp1058_ = _tmp1057_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1058_);
								} else {
									ValaMethod* _tmp1059_;
									_tmp1059_ = m;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1059_);
								}
								_tmp1060_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp1061_ = _tmp1060_;
								member = _tmp1061_;
							} else {
								ValaMethod* _tmp1062_;
								ValaMethod* _tmp1063_;
								ValaMethod* _tmp1064_;
								_tmp1062_ = m;
								_tmp1063_ = vala_method_get_base_interface_method (_tmp1062_);
								_tmp1064_ = _tmp1063_;
								if (_tmp1064_ != NULL) {
									ValaMethod* _tmp1065_;
									ValaMethod* _tmp1066_;
									ValaMethod* _tmp1067_;
									ValaMethod* _tmp1068_;
									ValaSignal* _tmp1069_;
									ValaSignal* _tmp1070_;
									ValaSymbol* _tmp1075_;
									ValaSymbol* _tmp1076_;
									_tmp1065_ = m;
									_tmp1066_ = vala_method_get_base_interface_method (_tmp1065_);
									_tmp1067_ = _tmp1066_;
									m = _tmp1067_;
									_tmp1068_ = m;
									_tmp1069_ = vala_method_get_signal_reference (_tmp1068_);
									_tmp1070_ = _tmp1069_;
									if (_tmp1070_ != NULL) {
										ValaMethod* _tmp1071_;
										ValaSignal* _tmp1072_;
										ValaSignal* _tmp1073_;
										_tmp1071_ = m;
										_tmp1072_ = vala_method_get_signal_reference (_tmp1071_);
										_tmp1073_ = _tmp1072_;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1073_);
									} else {
										ValaMethod* _tmp1074_;
										_tmp1074_ = m;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1074_);
									}
									_tmp1075_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1076_ = _tmp1075_;
									member = _tmp1076_;
								}
							}
						}
						_tmp1077_ = m;
						_tmp1078_ = vala_symbol_get_access ((ValaSymbol*) _tmp1077_);
						_tmp1079_ = _tmp1078_;
						access = _tmp1079_;
						_tmp1080_ = m;
						if (!VALA_IS_CREATION_METHOD (_tmp1080_)) {
							ValaMethod* _tmp1081_;
							ValaMemberBinding _tmp1082_;
							ValaMemberBinding _tmp1083_;
							_tmp1081_ = m;
							_tmp1082_ = vala_method_get_binding (_tmp1081_);
							_tmp1083_ = _tmp1082_;
							instance = _tmp1083_ == VALA_MEMBER_BINDING_INSTANCE;
						}
						_tmp1084_ = m;
						_tmp1085_ = vala_method_get_binding (_tmp1084_);
						_tmp1086_ = _tmp1085_;
						klass = _tmp1086_ == VALA_MEMBER_BINDING_CLASS;
						{
							ValaList* _param_list = NULL;
							ValaMethod* _tmp1087_;
							ValaList* _tmp1088_;
							gint _param_size = 0;
							ValaList* _tmp1089_;
							gint _tmp1090_;
							gint _tmp1091_;
							gint _param_index = 0;
							_tmp1087_ = m;
							_tmp1088_ = vala_callable_get_parameters ((ValaCallable*) _tmp1087_);
							_param_list = _tmp1088_;
							_tmp1089_ = _param_list;
							_tmp1090_ = vala_collection_get_size ((ValaCollection*) _tmp1089_);
							_tmp1091_ = _tmp1090_;
							_param_size = _tmp1091_;
							_param_index = -1;
							while (TRUE) {
								gint _tmp1092_;
								gint _tmp1093_;
								ValaParameter* param = NULL;
								ValaList* _tmp1094_;
								gpointer _tmp1095_;
								ValaGenericType* generic_type = NULL;
								ValaParameter* _tmp1096_;
								ValaDataType* _tmp1097_;
								ValaDataType* _tmp1098_;
								gboolean _tmp1099_ = FALSE;
								ValaGenericType* _tmp1100_;
								_param_index = _param_index + 1;
								_tmp1092_ = _param_index;
								_tmp1093_ = _param_size;
								if (!(_tmp1092_ < _tmp1093_)) {
									break;
								}
								_tmp1094_ = _param_list;
								_tmp1095_ = vala_list_get (_tmp1094_, _param_index);
								param = (ValaParameter*) _tmp1095_;
								_tmp1096_ = param;
								_tmp1097_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1096_);
								_tmp1098_ = _tmp1097_;
								generic_type = VALA_IS_GENERIC_TYPE (_tmp1098_) ? ((ValaGenericType*) _tmp1098_) : NULL;
								_tmp1100_ = generic_type;
								if (_tmp1100_ != NULL) {
									ValaGenericType* _tmp1101_;
									ValaTypeParameter* _tmp1102_;
									ValaTypeParameter* _tmp1103_;
									ValaSymbol* _tmp1104_;
									ValaSymbol* _tmp1105_;
									_tmp1101_ = generic_type;
									_tmp1102_ = vala_generic_type_get_type_parameter (_tmp1101_);
									_tmp1103_ = _tmp1102_;
									_tmp1104_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1103_);
									_tmp1105_ = _tmp1104_;
									_tmp1099_ = VALA_IS_TYPESYMBOL (_tmp1105_);
								} else {
									_tmp1099_ = FALSE;
								}
								if (_tmp1099_) {
									generics = TRUE;
									_vala_code_node_unref0 (param);
									break;
								}
								_vala_code_node_unref0 (param);
							}
						}
						_tmp1106_ = m;
						_tmp1107_ = vala_callable_get_return_type ((ValaCallable*) _tmp1106_);
						_tmp1108_ = _tmp1107_;
						generic_type = VALA_IS_GENERIC_TYPE (_tmp1108_) ? ((ValaGenericType*) _tmp1108_) : NULL;
						_tmp1110_ = generic_type;
						if (_tmp1110_ != NULL) {
							ValaGenericType* _tmp1111_;
							ValaTypeParameter* _tmp1112_;
							ValaTypeParameter* _tmp1113_;
							ValaSymbol* _tmp1114_;
							ValaSymbol* _tmp1115_;
							_tmp1111_ = generic_type;
							_tmp1112_ = vala_generic_type_get_type_parameter (_tmp1111_);
							_tmp1113_ = _tmp1112_;
							_tmp1114_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1113_);
							_tmp1115_ = _tmp1114_;
							_tmp1109_ = VALA_IS_TYPESYMBOL (_tmp1115_);
						} else {
							_tmp1109_ = FALSE;
						}
						if (_tmp1109_) {
							generics = TRUE;
						}
					} else {
						ValaSymbol* _tmp1116_;
						_tmp1116_ = member;
						if (VALA_IS_PROPERTY (_tmp1116_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp1117_;
							ValaProperty* _tmp1118_;
							ValaProperty* _tmp1119_;
							ValaProperty* _tmp1120_;
							ValaProperty* _tmp1121_;
							ValaProperty* _tmp1137_;
							ValaSymbolAccessibility _tmp1138_;
							ValaSymbolAccessibility _tmp1139_;
							gboolean _tmp1140_;
							gboolean _tmp1141_;
							ValaProperty* _tmp1240_;
							ValaMemberBinding _tmp1241_;
							ValaMemberBinding _tmp1242_;
							ValaProperty* _tmp1243_;
							ValaDataType* _tmp1244_;
							ValaDataType* _tmp1245_;
							_tmp1117_ = member;
							prop = G_TYPE_CHECK_INSTANCE_CAST (_tmp1117_, VALA_TYPE_PROPERTY, ValaProperty);
							_tmp1118_ = prop;
							if (!vala_code_node_check ((ValaCodeNode*) _tmp1118_, context)) {
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								result = FALSE;
								_vala_iterable_unref0 (visited_types);
								return result;
							}
							_tmp1119_ = prop;
							_tmp1120_ = vala_property_get_base_property (_tmp1119_);
							_tmp1121_ = _tmp1120_;
							if (_tmp1121_ != NULL) {
								ValaProperty* _tmp1122_;
								ValaProperty* _tmp1123_;
								ValaProperty* _tmp1124_;
								ValaProperty* _tmp1125_;
								ValaSymbol* _tmp1126_;
								ValaSymbol* _tmp1127_;
								_tmp1122_ = prop;
								_tmp1123_ = vala_property_get_base_property (_tmp1122_);
								_tmp1124_ = _tmp1123_;
								prop = _tmp1124_;
								_tmp1125_ = prop;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1125_);
								_tmp1126_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp1127_ = _tmp1126_;
								member = _tmp1127_;
							} else {
								ValaProperty* _tmp1128_;
								ValaProperty* _tmp1129_;
								ValaProperty* _tmp1130_;
								_tmp1128_ = prop;
								_tmp1129_ = vala_property_get_base_interface_property (_tmp1128_);
								_tmp1130_ = _tmp1129_;
								if (_tmp1130_ != NULL) {
									ValaProperty* _tmp1131_;
									ValaProperty* _tmp1132_;
									ValaProperty* _tmp1133_;
									ValaProperty* _tmp1134_;
									ValaSymbol* _tmp1135_;
									ValaSymbol* _tmp1136_;
									_tmp1131_ = prop;
									_tmp1132_ = vala_property_get_base_interface_property (_tmp1131_);
									_tmp1133_ = _tmp1132_;
									prop = _tmp1133_;
									_tmp1134_ = prop;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1134_);
									_tmp1135_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1136_ = _tmp1135_;
									member = _tmp1136_;
								}
							}
							_tmp1137_ = prop;
							_tmp1138_ = vala_symbol_get_access ((ValaSymbol*) _tmp1137_);
							_tmp1139_ = _tmp1138_;
							access = _tmp1139_;
							_tmp1140_ = vala_expression_get_lvalue ((ValaExpression*) self);
							_tmp1141_ = _tmp1140_;
							if (_tmp1141_) {
								ValaProperty* _tmp1142_;
								ValaPropertyAccessor* _tmp1143_;
								ValaPropertyAccessor* _tmp1144_;
								ValaProperty* _tmp1188_;
								ValaSymbolAccessibility _tmp1189_;
								ValaSymbolAccessibility _tmp1190_;
								_tmp1142_ = prop;
								_tmp1143_ = vala_property_get_set_accessor (_tmp1142_);
								_tmp1144_ = _tmp1143_;
								if (_tmp1144_ == NULL) {
									ValaSourceReference* _tmp1145_;
									ValaSourceReference* _tmp1146_;
									ValaProperty* _tmp1147_;
									gchar* _tmp1148_;
									gchar* _tmp1149_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp1145_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp1146_ = _tmp1145_;
									_tmp1147_ = prop;
									_tmp1148_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1147_);
									_tmp1149_ = _tmp1148_;
									vala_report_error (_tmp1146_, "Property `%s' is read-only", _tmp1149_);
									_g_free0 (_tmp1149_);
									result = FALSE;
									_vala_iterable_unref0 (visited_types);
									return result;
								} else {
									gboolean _tmp1150_ = FALSE;
									ValaProperty* _tmp1151_;
									ValaPropertyAccessor* _tmp1152_;
									ValaPropertyAccessor* _tmp1153_;
									gboolean _tmp1154_;
									gboolean _tmp1155_;
									_tmp1151_ = prop;
									_tmp1152_ = vala_property_get_set_accessor (_tmp1151_);
									_tmp1153_ = _tmp1152_;
									_tmp1154_ = vala_property_accessor_get_writable (_tmp1153_);
									_tmp1155_ = _tmp1154_;
									if (!_tmp1155_) {
										ValaProperty* _tmp1156_;
										ValaPropertyAccessor* _tmp1157_;
										ValaPropertyAccessor* _tmp1158_;
										gboolean _tmp1159_;
										gboolean _tmp1160_;
										_tmp1156_ = prop;
										_tmp1157_ = vala_property_get_set_accessor (_tmp1156_);
										_tmp1158_ = _tmp1157_;
										_tmp1159_ = vala_property_accessor_get_construction (_tmp1158_);
										_tmp1160_ = _tmp1159_;
										_tmp1150_ = _tmp1160_;
									} else {
										_tmp1150_ = FALSE;
									}
									if (_tmp1150_) {
										ValaSemanticAnalyzer* _tmp1161_;
										ValaSemanticAnalyzer* _tmp1162_;
										ValaMethod* _tmp1163_;
										_tmp1161_ = vala_code_context_get_analyzer (context);
										_tmp1162_ = _tmp1161_;
										_tmp1163_ = vala_semantic_analyzer_find_current_method (_tmp1162_);
										if (VALA_IS_CREATION_METHOD (_tmp1163_)) {
											ValaSourceReference* _tmp1164_;
											ValaSourceReference* _tmp1165_;
											vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
											_tmp1164_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
											_tmp1165_ = _tmp1164_;
											vala_report_error (_tmp1165_, "Cannot assign to construct-only properties, use Object (property: valu" \
"e) constructor chain up");
											result = FALSE;
											_vala_iterable_unref0 (visited_types);
											return result;
										} else {
											ValaSemanticAnalyzer* _tmp1166_;
											ValaSemanticAnalyzer* _tmp1167_;
											_tmp1166_ = vala_code_context_get_analyzer (context);
											_tmp1167_ = _tmp1166_;
											if (vala_semantic_analyzer_is_in_constructor (_tmp1167_)) {
												ValaSemanticAnalyzer* _tmp1168_;
												ValaSemanticAnalyzer* _tmp1169_;
												ValaTypeSymbol* _tmp1170_;
												ValaTypeSymbol* _tmp1171_;
												ValaProperty* _tmp1172_;
												ValaSymbol* _tmp1173_;
												ValaSymbol* _tmp1174_;
												_tmp1168_ = vala_code_context_get_analyzer (context);
												_tmp1169_ = _tmp1168_;
												_tmp1170_ = vala_semantic_analyzer_get_current_type_symbol (_tmp1169_);
												_tmp1171_ = _tmp1170_;
												_tmp1172_ = prop;
												_tmp1173_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1172_);
												_tmp1174_ = _tmp1173_;
												if (!vala_typesymbol_is_subtype_of (_tmp1171_, G_TYPE_CHECK_INSTANCE_CAST (_tmp1174_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol))) {
													ValaSourceReference* _tmp1175_;
													ValaSourceReference* _tmp1176_;
													ValaProperty* _tmp1177_;
													gchar* _tmp1178_;
													gchar* _tmp1179_;
													ValaSemanticAnalyzer* _tmp1180_;
													ValaSemanticAnalyzer* _tmp1181_;
													ValaTypeSymbol* _tmp1182_;
													ValaTypeSymbol* _tmp1183_;
													gchar* _tmp1184_;
													gchar* _tmp1185_;
													vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
													_tmp1175_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
													_tmp1176_ = _tmp1175_;
													_tmp1177_ = prop;
													_tmp1178_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1177_);
													_tmp1179_ = _tmp1178_;
													_tmp1180_ = vala_code_context_get_analyzer (context);
													_tmp1181_ = _tmp1180_;
													_tmp1182_ = vala_semantic_analyzer_get_current_type_symbol (_tmp1181_);
													_tmp1183_ = _tmp1182_;
													_tmp1184_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1183_);
													_tmp1185_ = _tmp1184_;
													vala_report_error (_tmp1176_, "Cannot assign to construct-only property `%s' in `construct' of `%s'", _tmp1179_, _tmp1185_);
													_g_free0 (_tmp1185_);
													_g_free0 (_tmp1179_);
													result = FALSE;
													_vala_iterable_unref0 (visited_types);
													return result;
												}
											} else {
												ValaSourceReference* _tmp1186_;
												ValaSourceReference* _tmp1187_;
												vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
												_tmp1186_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
												_tmp1187_ = _tmp1186_;
												vala_report_error (_tmp1187_, "Cannot assign to construct-only property in this context");
												result = FALSE;
												_vala_iterable_unref0 (visited_types);
												return result;
											}
										}
									}
								}
								_tmp1188_ = prop;
								_tmp1189_ = vala_symbol_get_access ((ValaSymbol*) _tmp1188_);
								_tmp1190_ = _tmp1189_;
								if (_tmp1190_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp1191_;
									ValaPropertyAccessor* _tmp1192_;
									ValaPropertyAccessor* _tmp1193_;
									ValaSymbolAccessibility _tmp1194_;
									ValaSymbolAccessibility _tmp1195_;
									_tmp1191_ = prop;
									_tmp1192_ = vala_property_get_set_accessor (_tmp1191_);
									_tmp1193_ = _tmp1192_;
									_tmp1194_ = vala_symbol_get_access ((ValaSymbol*) _tmp1193_);
									_tmp1195_ = _tmp1194_;
									access = _tmp1195_;
								} else {
									gboolean _tmp1196_ = FALSE;
									ValaProperty* _tmp1197_;
									ValaSymbolAccessibility _tmp1198_;
									ValaSymbolAccessibility _tmp1199_;
									_tmp1197_ = prop;
									_tmp1198_ = vala_symbol_get_access ((ValaSymbol*) _tmp1197_);
									_tmp1199_ = _tmp1198_;
									if (_tmp1199_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp1200_;
										ValaPropertyAccessor* _tmp1201_;
										ValaPropertyAccessor* _tmp1202_;
										ValaSymbolAccessibility _tmp1203_;
										ValaSymbolAccessibility _tmp1204_;
										_tmp1200_ = prop;
										_tmp1201_ = vala_property_get_set_accessor (_tmp1200_);
										_tmp1202_ = _tmp1201_;
										_tmp1203_ = vala_symbol_get_access ((ValaSymbol*) _tmp1202_);
										_tmp1204_ = _tmp1203_;
										_tmp1196_ = _tmp1204_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp1196_ = FALSE;
									}
									if (_tmp1196_) {
										ValaProperty* _tmp1205_;
										ValaPropertyAccessor* _tmp1206_;
										ValaPropertyAccessor* _tmp1207_;
										ValaSymbolAccessibility _tmp1208_;
										ValaSymbolAccessibility _tmp1209_;
										_tmp1205_ = prop;
										_tmp1206_ = vala_property_get_set_accessor (_tmp1205_);
										_tmp1207_ = _tmp1206_;
										_tmp1208_ = vala_symbol_get_access ((ValaSymbol*) _tmp1207_);
										_tmp1209_ = _tmp1208_;
										access = _tmp1209_;
									}
								}
							} else {
								ValaProperty* _tmp1210_;
								ValaPropertyAccessor* _tmp1211_;
								ValaPropertyAccessor* _tmp1212_;
								ValaProperty* _tmp1218_;
								ValaSymbolAccessibility _tmp1219_;
								ValaSymbolAccessibility _tmp1220_;
								_tmp1210_ = prop;
								_tmp1211_ = vala_property_get_get_accessor (_tmp1210_);
								_tmp1212_ = _tmp1211_;
								if (_tmp1212_ == NULL) {
									ValaSourceReference* _tmp1213_;
									ValaSourceReference* _tmp1214_;
									ValaProperty* _tmp1215_;
									gchar* _tmp1216_;
									gchar* _tmp1217_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp1213_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp1214_ = _tmp1213_;
									_tmp1215_ = prop;
									_tmp1216_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1215_);
									_tmp1217_ = _tmp1216_;
									vala_report_error (_tmp1214_, "Property `%s' is write-only", _tmp1217_);
									_g_free0 (_tmp1217_);
									result = FALSE;
									_vala_iterable_unref0 (visited_types);
									return result;
								}
								_tmp1218_ = prop;
								_tmp1219_ = vala_symbol_get_access ((ValaSymbol*) _tmp1218_);
								_tmp1220_ = _tmp1219_;
								if (_tmp1220_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp1221_;
									ValaPropertyAccessor* _tmp1222_;
									ValaPropertyAccessor* _tmp1223_;
									ValaSymbolAccessibility _tmp1224_;
									ValaSymbolAccessibility _tmp1225_;
									_tmp1221_ = prop;
									_tmp1222_ = vala_property_get_get_accessor (_tmp1221_);
									_tmp1223_ = _tmp1222_;
									_tmp1224_ = vala_symbol_get_access ((ValaSymbol*) _tmp1223_);
									_tmp1225_ = _tmp1224_;
									access = _tmp1225_;
								} else {
									gboolean _tmp1226_ = FALSE;
									ValaProperty* _tmp1227_;
									ValaSymbolAccessibility _tmp1228_;
									ValaSymbolAccessibility _tmp1229_;
									_tmp1227_ = prop;
									_tmp1228_ = vala_symbol_get_access ((ValaSymbol*) _tmp1227_);
									_tmp1229_ = _tmp1228_;
									if (_tmp1229_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp1230_;
										ValaPropertyAccessor* _tmp1231_;
										ValaPropertyAccessor* _tmp1232_;
										ValaSymbolAccessibility _tmp1233_;
										ValaSymbolAccessibility _tmp1234_;
										_tmp1230_ = prop;
										_tmp1231_ = vala_property_get_get_accessor (_tmp1230_);
										_tmp1232_ = _tmp1231_;
										_tmp1233_ = vala_symbol_get_access ((ValaSymbol*) _tmp1232_);
										_tmp1234_ = _tmp1233_;
										_tmp1226_ = _tmp1234_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp1226_ = FALSE;
									}
									if (_tmp1226_) {
										ValaProperty* _tmp1235_;
										ValaPropertyAccessor* _tmp1236_;
										ValaPropertyAccessor* _tmp1237_;
										ValaSymbolAccessibility _tmp1238_;
										ValaSymbolAccessibility _tmp1239_;
										_tmp1235_ = prop;
										_tmp1236_ = vala_property_get_get_accessor (_tmp1235_);
										_tmp1237_ = _tmp1236_;
										_tmp1238_ = vala_symbol_get_access ((ValaSymbol*) _tmp1237_);
										_tmp1239_ = _tmp1238_;
										access = _tmp1239_;
									}
								}
							}
							_tmp1240_ = prop;
							_tmp1241_ = vala_property_get_binding (_tmp1240_);
							_tmp1242_ = _tmp1241_;
							instance = _tmp1242_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp1243_ = prop;
							_tmp1244_ = vala_property_get_property_type (_tmp1243_);
							_tmp1245_ = _tmp1244_;
							if (VALA_IS_GENERIC_TYPE (_tmp1245_)) {
								generics = TRUE;
							}
						} else {
							ValaSymbol* _tmp1246_;
							_tmp1246_ = member;
							if (VALA_IS_SIGNAL (_tmp1246_)) {
								ValaSymbol* _tmp1247_;
								ValaSymbolAccessibility _tmp1248_;
								ValaSymbolAccessibility _tmp1249_;
								instance = TRUE;
								_tmp1247_ = member;
								_tmp1248_ = vala_symbol_get_access (_tmp1247_);
								_tmp1249_ = _tmp1248_;
								access = _tmp1249_;
							} else {
								gboolean _tmp1250_ = FALSE;
								gboolean _tmp1251_;
								_tmp1251_ = self->priv->_creation_member;
								if (!_tmp1251_) {
									ValaSymbol* _tmp1252_;
									_tmp1252_ = member;
									_tmp1250_ = VALA_IS_ERROR_CODE (_tmp1252_);
								} else {
									_tmp1250_ = FALSE;
								}
								if (_tmp1250_) {
									ValaSymbol* _tmp1253_;
									ValaConstant* _tmp1254_;
									ValaConstant* _tmp1255_;
									ValaSymbol* _tmp1256_;
									ValaSymbol* _tmp1257_;
									_tmp1253_ = member;
									_tmp1254_ = vala_error_code_get_code (G_TYPE_CHECK_INSTANCE_CAST (_tmp1253_, VALA_TYPE_ERROR_CODE, ValaErrorCode));
									_tmp1255_ = _tmp1254_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1255_);
									_tmp1256_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1257_ = _tmp1256_;
									member = _tmp1257_;
								}
							}
						}
					}
				}
			}
		}
	}
	parent = (ValaCodeNode*) self;
	while (TRUE) {
		ValaCodeNode* _tmp1258_;
		ValaSymbol* _tmp1259_;
		ValaCodeNode* _tmp1260_;
		ValaCodeNode* _tmp1261_;
		ValaCodeNode* _tmp1262_;
		gboolean _tmp1263_ = FALSE;
		ValaCodeNode* _tmp1264_;
		_tmp1258_ = parent;
		_tmp1259_ = member;
		if (!(_tmp1258_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1259_, VALA_TYPE_CODE_NODE, ValaCodeNode))) {
			break;
		}
		_tmp1260_ = parent;
		_tmp1261_ = vala_code_node_get_parent_node (_tmp1260_);
		_tmp1262_ = _tmp1261_;
		parent = _tmp1262_;
		_tmp1264_ = parent;
		if (_tmp1264_ == NULL) {
			_tmp1263_ = TRUE;
		} else {
			ValaCodeNode* _tmp1265_;
			ValaSymbol* _tmp1266_;
			_tmp1265_ = parent;
			_tmp1266_ = member;
			_tmp1263_ = _tmp1265_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1266_, VALA_TYPE_CODE_NODE, ValaCodeNode);
		}
		if (_tmp1263_) {
			break;
		}
	}
	_tmp1267_ = parent;
	_tmp1268_ = member;
	if (_tmp1267_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1268_, VALA_TYPE_CODE_NODE, ValaCodeNode)) {
		ValaSymbol* _tmp1269_;
		_tmp1269_ = member;
		vala_symbol_set_used (_tmp1269_, TRUE);
	}
	_tmp1270_ = member;
	_tmp1271_ = vala_symbol_get_version (_tmp1270_);
	_tmp1272_ = _tmp1271_;
	_tmp1273_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp1274_ = _tmp1273_;
	vala_version_attribute_check (_tmp1272_, context, _tmp1274_);
	_tmp1276_ = access;
	if (_tmp1276_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
		ValaSymbol* _tmp1277_;
		ValaSymbol* _tmp1278_;
		ValaSymbol* _tmp1279_;
		_tmp1277_ = member;
		_tmp1278_ = vala_symbol_get_parent_symbol (_tmp1277_);
		_tmp1279_ = _tmp1278_;
		_tmp1275_ = VALA_IS_TYPESYMBOL (_tmp1279_);
	} else {
		_tmp1275_ = FALSE;
	}
	if (_tmp1275_) {
		ValaTypeSymbol* target_type = NULL;
		ValaSymbol* _tmp1280_;
		ValaSymbol* _tmp1281_;
		ValaSymbol* _tmp1282_;
		gboolean in_subtype = FALSE;
		_tmp1280_ = member;
		_tmp1281_ = vala_symbol_get_parent_symbol (_tmp1280_);
		_tmp1282_ = _tmp1281_;
		target_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp1282_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
		in_subtype = FALSE;
		{
			ValaSymbol* this_symbol = NULL;
			ValaSemanticAnalyzer* _tmp1283_;
			ValaSemanticAnalyzer* _tmp1284_;
			ValaSymbol* _tmp1285_;
			ValaSymbol* _tmp1286_;
			ValaSymbol* _tmp1287_;
			_tmp1283_ = vala_code_context_get_analyzer (context);
			_tmp1284_ = _tmp1283_;
			_tmp1285_ = vala_semantic_analyzer_get_current_symbol (_tmp1284_);
			_tmp1286_ = _tmp1285_;
			_tmp1287_ = _vala_code_node_ref0 (_tmp1286_);
			this_symbol = _tmp1287_;
			{
				gboolean _tmp1288_ = FALSE;
				_tmp1288_ = TRUE;
				while (TRUE) {
					ValaSymbol* _tmp1293_;
					ValaSymbol* _tmp1294_;
					ValaTypeSymbol* _tmp1295_;
					ValaClass* cl = NULL;
					ValaSymbol* _tmp1296_;
					gboolean _tmp1297_ = FALSE;
					ValaClass* _tmp1298_;
					if (!_tmp1288_) {
						ValaSymbol* _tmp1289_;
						ValaSymbol* _tmp1290_;
						ValaSymbol* _tmp1291_;
						ValaSymbol* _tmp1292_;
						_tmp1289_ = this_symbol;
						_tmp1290_ = vala_symbol_get_parent_symbol (_tmp1289_);
						_tmp1291_ = _tmp1290_;
						_tmp1292_ = _vala_code_node_ref0 (_tmp1291_);
						_vala_code_node_unref0 (this_symbol);
						this_symbol = _tmp1292_;
					}
					_tmp1288_ = FALSE;
					_tmp1293_ = this_symbol;
					if (!(_tmp1293_ != NULL)) {
						break;
					}
					_tmp1294_ = this_symbol;
					_tmp1295_ = target_type;
					if (_tmp1294_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1295_, VALA_TYPE_SYMBOL, ValaSymbol)) {
						in_subtype = TRUE;
						break;
					}
					_tmp1296_ = this_symbol;
					cl = VALA_IS_CLASS (_tmp1296_) ? ((ValaClass*) _tmp1296_) : NULL;
					_tmp1298_ = cl;
					if (_tmp1298_ != NULL) {
						ValaClass* _tmp1299_;
						ValaTypeSymbol* _tmp1300_;
						_tmp1299_ = cl;
						_tmp1300_ = target_type;
						_tmp1297_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp1299_, _tmp1300_);
					} else {
						_tmp1297_ = FALSE;
					}
					if (_tmp1297_) {
						in_subtype = TRUE;
						break;
					}
				}
			}
			_vala_code_node_unref0 (this_symbol);
		}
		if (!in_subtype) {
			ValaSourceReference* _tmp1301_;
			ValaSourceReference* _tmp1302_;
			ValaSymbol* _tmp1303_;
			gchar* _tmp1304_;
			gchar* _tmp1305_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1301_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1302_ = _tmp1301_;
			_tmp1303_ = member;
			_tmp1304_ = vala_symbol_get_full_name (_tmp1303_);
			_tmp1305_ = _tmp1304_;
			vala_report_error (_tmp1302_, "Access to protected member `%s' denied", _tmp1305_);
			_g_free0 (_tmp1305_);
			result = FALSE;
			_vala_iterable_unref0 (visited_types);
			return result;
		}
	} else {
		ValaSymbolAccessibility _tmp1306_;
		_tmp1306_ = access;
		if (_tmp1306_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaSymbol* target_type = NULL;
			ValaSymbol* _tmp1307_;
			ValaSymbol* _tmp1308_;
			ValaSymbol* _tmp1309_;
			gboolean in_target_type = FALSE;
			_tmp1307_ = member;
			_tmp1308_ = vala_symbol_get_parent_symbol (_tmp1307_);
			_tmp1309_ = _tmp1308_;
			target_type = _tmp1309_;
			in_target_type = FALSE;
			{
				ValaSymbol* this_symbol = NULL;
				ValaSemanticAnalyzer* _tmp1310_;
				ValaSemanticAnalyzer* _tmp1311_;
				ValaSymbol* _tmp1312_;
				ValaSymbol* _tmp1313_;
				ValaSymbol* _tmp1314_;
				_tmp1310_ = vala_code_context_get_analyzer (context);
				_tmp1311_ = _tmp1310_;
				_tmp1312_ = vala_semantic_analyzer_get_current_symbol (_tmp1311_);
				_tmp1313_ = _tmp1312_;
				_tmp1314_ = _vala_code_node_ref0 (_tmp1313_);
				this_symbol = _tmp1314_;
				{
					gboolean _tmp1315_ = FALSE;
					_tmp1315_ = TRUE;
					while (TRUE) {
						ValaSymbol* _tmp1320_;
						ValaSymbol* _tmp1321_;
						ValaSymbol* _tmp1322_;
						if (!_tmp1315_) {
							ValaSymbol* _tmp1316_;
							ValaSymbol* _tmp1317_;
							ValaSymbol* _tmp1318_;
							ValaSymbol* _tmp1319_;
							_tmp1316_ = this_symbol;
							_tmp1317_ = vala_symbol_get_parent_symbol (_tmp1316_);
							_tmp1318_ = _tmp1317_;
							_tmp1319_ = _vala_code_node_ref0 (_tmp1318_);
							_vala_code_node_unref0 (this_symbol);
							this_symbol = _tmp1319_;
						}
						_tmp1315_ = FALSE;
						_tmp1320_ = this_symbol;
						if (!(_tmp1320_ != NULL)) {
							break;
						}
						_tmp1321_ = target_type;
						_tmp1322_ = this_symbol;
						if (_tmp1321_ == _tmp1322_) {
							in_target_type = TRUE;
							break;
						}
					}
				}
				_vala_code_node_unref0 (this_symbol);
			}
			if (!in_target_type) {
				ValaSourceReference* _tmp1323_;
				ValaSourceReference* _tmp1324_;
				ValaSymbol* _tmp1325_;
				gchar* _tmp1326_;
				gchar* _tmp1327_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp1323_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1324_ = _tmp1323_;
				_tmp1325_ = member;
				_tmp1326_ = vala_symbol_get_full_name (_tmp1325_);
				_tmp1327_ = _tmp1326_;
				vala_report_error (_tmp1324_, "Access to private member `%s' denied", _tmp1327_);
				_g_free0 (_tmp1327_);
				result = FALSE;
				_vala_iterable_unref0 (visited_types);
				return result;
			}
		}
	}
	if (generics) {
		ValaExpression* _tmp1329_;
		ValaExpression* _tmp1330_;
		_tmp1329_ = vala_member_access_get_inner (self);
		_tmp1330_ = _tmp1329_;
		_tmp1328_ = _tmp1330_ != NULL;
	} else {
		_tmp1328_ = FALSE;
	}
	if (_tmp1328_) {
		ValaDataType* instance_type = NULL;
		ValaExpression* _tmp1331_;
		ValaExpression* _tmp1332_;
		ValaDataType* _tmp1333_;
		ValaDataType* _tmp1334_;
		ValaPointerType* pointer_type = NULL;
		ValaExpression* _tmp1335_;
		ValaExpression* _tmp1336_;
		ValaDataType* _tmp1337_;
		ValaDataType* _tmp1338_;
		ValaPointerType* _tmp1339_;
		ValaObjectType* object_type = NULL;
		ValaDataType* _tmp1343_;
		gboolean _tmp1344_ = FALSE;
		gboolean _tmp1345_ = FALSE;
		ValaObjectType* _tmp1346_;
		_tmp1331_ = vala_member_access_get_inner (self);
		_tmp1332_ = _tmp1331_;
		_tmp1333_ = vala_expression_get_value_type (_tmp1332_);
		_tmp1334_ = _tmp1333_;
		instance_type = _tmp1334_;
		_tmp1335_ = vala_member_access_get_inner (self);
		_tmp1336_ = _tmp1335_;
		_tmp1337_ = vala_expression_get_value_type (_tmp1336_);
		_tmp1338_ = _tmp1337_;
		pointer_type = VALA_IS_POINTER_TYPE (_tmp1338_) ? ((ValaPointerType*) _tmp1338_) : NULL;
		_tmp1339_ = pointer_type;
		if (_tmp1339_ != NULL) {
			ValaPointerType* _tmp1340_;
			ValaDataType* _tmp1341_;
			ValaDataType* _tmp1342_;
			_tmp1340_ = pointer_type;
			_tmp1341_ = vala_pointer_type_get_base_type (_tmp1340_);
			_tmp1342_ = _tmp1341_;
			instance_type = _tmp1342_;
		}
		_tmp1343_ = instance_type;
		object_type = VALA_IS_OBJECT_TYPE (_tmp1343_) ? ((ValaObjectType*) _tmp1343_) : NULL;
		_tmp1346_ = object_type;
		if (_tmp1346_ != NULL) {
			ValaObjectType* _tmp1347_;
			ValaObjectTypeSymbol* _tmp1348_;
			ValaObjectTypeSymbol* _tmp1349_;
			_tmp1347_ = object_type;
			_tmp1348_ = vala_object_type_get_object_type_symbol (_tmp1347_);
			_tmp1349_ = _tmp1348_;
			_tmp1345_ = vala_object_type_symbol_has_type_parameters (_tmp1349_);
		} else {
			_tmp1345_ = FALSE;
		}
		if (_tmp1345_) {
			ValaDataType* _tmp1350_;
			_tmp1350_ = instance_type;
			_tmp1344_ = !vala_data_type_has_type_arguments (_tmp1350_);
		} else {
			_tmp1344_ = FALSE;
		}
		if (_tmp1344_) {
			ValaExpression* _tmp1351_;
			ValaExpression* _tmp1352_;
			ValaSourceReference* _tmp1353_;
			ValaSourceReference* _tmp1354_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1351_ = vala_member_access_get_inner (self);
			_tmp1352_ = _tmp1351_;
			_tmp1353_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1352_);
			_tmp1354_ = _tmp1353_;
			vala_report_error (_tmp1354_, "missing generic type arguments");
			result = FALSE;
			_vala_iterable_unref0 (visited_types);
			return result;
		}
	}
	if (instance) {
		_tmp1356_ = !may_access_instance_members;
	} else {
		_tmp1356_ = FALSE;
	}
	if (_tmp1356_) {
		_tmp1355_ = TRUE;
	} else {
		gboolean _tmp1357_ = FALSE;
		if (klass) {
			_tmp1357_ = !may_access_klass_members;
		} else {
			_tmp1357_ = FALSE;
		}
		_tmp1355_ = _tmp1357_;
	}
	if (_tmp1355_) {
		ValaSymbol* _tmp1358_;
		ValaSymbol* _tmp1359_;
		ValaDataType* _tmp1394_;
		ValaDataType* _tmp1395_;
		vala_member_access_set_prototype_access (self, TRUE);
		_tmp1358_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1359_ = _tmp1358_;
		if (VALA_IS_METHOD (_tmp1359_)) {
			ValaSemanticAnalyzer* _tmp1360_;
			ValaSemanticAnalyzer* _tmp1361_;
			ValaSymbol* _tmp1362_;
			ValaSymbol* _tmp1363_;
			gboolean _tmp1364_;
			gboolean _tmp1365_;
			ValaDataType* _tmp1366_;
			ValaDataType* _tmp1367_;
			ValaDataType* _tmp1368_;
			ValaDataType* _tmp1369_;
			ValaSourceReference* _tmp1370_;
			ValaSourceReference* _tmp1371_;
			_tmp1360_ = vala_code_context_get_analyzer (context);
			_tmp1361_ = _tmp1360_;
			_tmp1362_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1363_ = _tmp1362_;
			_tmp1364_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp1365_ = _tmp1364_;
			_tmp1366_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1361_, _tmp1363_, _tmp1365_);
			_tmp1367_ = _tmp1366_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1367_);
			_vala_code_node_unref0 (_tmp1367_);
			_tmp1368_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp1369_ = _tmp1368_;
			_tmp1370_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1371_ = _tmp1370_;
			vala_code_node_set_source_reference ((ValaCodeNode*) _tmp1369_, _tmp1371_);
		} else {
			ValaSymbol* _tmp1372_;
			ValaSymbol* _tmp1373_;
			_tmp1372_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1373_ = _tmp1372_;
			if (VALA_IS_FIELD (_tmp1373_)) {
				ValaSymbol* _tmp1374_;
				ValaSymbol* _tmp1375_;
				ValaFieldPrototype* _tmp1376_;
				ValaFieldPrototype* _tmp1377_;
				ValaDataType* _tmp1378_;
				ValaDataType* _tmp1379_;
				ValaSourceReference* _tmp1380_;
				ValaSourceReference* _tmp1381_;
				_tmp1374_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1375_ = _tmp1374_;
				_tmp1376_ = vala_field_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1375_, VALA_TYPE_FIELD, ValaField));
				_tmp1377_ = _tmp1376_;
				vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1377_);
				_vala_code_node_unref0 (_tmp1377_);
				_tmp1378_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp1379_ = _tmp1378_;
				_tmp1380_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1381_ = _tmp1380_;
				vala_code_node_set_source_reference ((ValaCodeNode*) _tmp1379_, _tmp1381_);
			} else {
				ValaSymbol* _tmp1382_;
				ValaSymbol* _tmp1383_;
				_tmp1382_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1383_ = _tmp1382_;
				if (VALA_IS_PROPERTY (_tmp1383_)) {
					ValaSymbol* _tmp1384_;
					ValaSymbol* _tmp1385_;
					ValaPropertyPrototype* _tmp1386_;
					ValaPropertyPrototype* _tmp1387_;
					ValaDataType* _tmp1388_;
					ValaDataType* _tmp1389_;
					ValaSourceReference* _tmp1390_;
					ValaSourceReference* _tmp1391_;
					_tmp1384_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1385_ = _tmp1384_;
					_tmp1386_ = vala_property_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1385_, VALA_TYPE_PROPERTY, ValaProperty));
					_tmp1387_ = _tmp1386_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1387_);
					_vala_code_node_unref0 (_tmp1387_);
					_tmp1388_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp1389_ = _tmp1388_;
					_tmp1390_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp1391_ = _tmp1390_;
					vala_code_node_set_source_reference ((ValaCodeNode*) _tmp1389_, _tmp1391_);
				} else {
					ValaInvalidType* _tmp1392_;
					ValaInvalidType* _tmp1393_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp1392_ = vala_invalid_type_new ();
					_tmp1393_ = _tmp1392_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1393_);
					_vala_code_node_unref0 (_tmp1393_);
				}
			}
		}
		_tmp1394_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp1395_ = _tmp1394_;
		if (_tmp1395_ != NULL) {
			ValaDataType* _tmp1396_;
			ValaDataType* _tmp1397_;
			ValaDataType* _tmp1398_;
			ValaDataType* _tmp1399_;
			gboolean _tmp1400_;
			gboolean _tmp1401_;
			_tmp1396_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp1397_ = _tmp1396_;
			_tmp1398_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1399_ = _tmp1398_;
			_tmp1400_ = vala_data_type_get_value_owned (_tmp1399_);
			_tmp1401_ = _tmp1400_;
			vala_data_type_set_value_owned (_tmp1397_, _tmp1401_);
		}
	} else {
		gboolean _tmp1402_ = FALSE;
		gboolean _tmp1423_ = FALSE;
		gboolean _tmp1424_ = FALSE;
		gboolean _tmp1425_ = FALSE;
		gboolean _tmp1426_ = FALSE;
		gboolean _tmp1467_ = FALSE;
		gboolean _tmp1468_ = FALSE;
		gboolean _tmp1469_ = FALSE;
		gboolean _tmp1470_ = FALSE;
		gboolean _tmp1471_ = FALSE;
		gboolean _tmp1472_;
		gboolean _tmp1473_;
		ValaMethod* m = NULL;
		ValaSymbol* _tmp1498_;
		ValaSymbol* _tmp1499_;
		ValaMemberAccess* inner_ma = NULL;
		ValaExpression* _tmp1500_;
		ValaExpression* _tmp1501_;
		gboolean _tmp1502_ = FALSE;
		gboolean _tmp1503_ = FALSE;
		gboolean _tmp1504_ = FALSE;
		gboolean _tmp1505_ = FALSE;
		gboolean _tmp1506_ = FALSE;
		ValaMethod* _tmp1507_;
		ValaSemanticAnalyzer* _tmp1551_;
		ValaSemanticAnalyzer* _tmp1552_;
		ValaSymbol* _tmp1553_;
		ValaSymbol* _tmp1554_;
		gboolean _tmp1555_;
		gboolean _tmp1556_;
		ValaDataType* _tmp1557_;
		ValaDataType* _tmp1558_;
		gboolean _tmp1559_ = FALSE;
		ValaExpression* _tmp1560_;
		ValaExpression* _tmp1561_;
		ValaSymbol* _tmp1574_;
		ValaSymbol* _tmp1575_;
		gboolean _tmp1649_ = FALSE;
		gboolean _tmp1650_ = FALSE;
		ValaExpression* _tmp1651_;
		ValaExpression* _tmp1652_;
		if (instance) {
			ValaExpression* _tmp1403_;
			ValaExpression* _tmp1404_;
			_tmp1403_ = vala_member_access_get_inner (self);
			_tmp1404_ = _tmp1403_;
			_tmp1402_ = _tmp1404_ == NULL;
		} else {
			_tmp1402_ = FALSE;
		}
		if (_tmp1402_) {
			ValaSourceReference* _tmp1405_;
			ValaSourceReference* _tmp1406_;
			ValaMemberAccess* _tmp1407_;
			ValaMemberAccess* _tmp1408_;
			ValaExpression* _tmp1409_;
			ValaExpression* _tmp1410_;
			ValaParameter* _tmp1411_;
			ValaDataType* _tmp1412_;
			ValaDataType* _tmp1413_;
			ValaDataType* _tmp1414_;
			ValaDataType* _tmp1415_;
			ValaExpression* _tmp1416_;
			ValaExpression* _tmp1417_;
			ValaDataType* _tmp1418_;
			ValaDataType* _tmp1419_;
			ValaExpression* _tmp1420_;
			ValaExpression* _tmp1421_;
			ValaParameter* _tmp1422_;
			_tmp1405_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1406_ = _tmp1405_;
			_tmp1407_ = vala_member_access_new (NULL, "this", _tmp1406_);
			_tmp1408_ = _tmp1407_;
			vala_member_access_set_inner (self, (ValaExpression*) _tmp1408_);
			_vala_code_node_unref0 (_tmp1408_);
			_tmp1409_ = vala_member_access_get_inner (self);
			_tmp1410_ = _tmp1409_;
			_tmp1411_ = this_parameter;
			_tmp1412_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1411_);
			_tmp1413_ = _tmp1412_;
			_tmp1414_ = vala_data_type_copy (_tmp1413_);
			_tmp1415_ = _tmp1414_;
			vala_expression_set_value_type (_tmp1410_, _tmp1415_);
			_vala_code_node_unref0 (_tmp1415_);
			_tmp1416_ = vala_member_access_get_inner (self);
			_tmp1417_ = _tmp1416_;
			_tmp1418_ = vala_expression_get_value_type (_tmp1417_);
			_tmp1419_ = _tmp1418_;
			vala_data_type_set_value_owned (_tmp1419_, FALSE);
			_tmp1420_ = vala_member_access_get_inner (self);
			_tmp1421_ = _tmp1420_;
			_tmp1422_ = this_parameter;
			vala_expression_set_symbol_reference (_tmp1421_, (ValaSymbol*) _tmp1422_);
		} else {
			vala_member_access_check_lvalue_access (self);
		}
		if (!instance) {
			_tmp1426_ = !klass;
		} else {
			_tmp1426_ = FALSE;
		}
		if (_tmp1426_) {
			ValaSymbol* _tmp1427_;
			ValaSymbol* _tmp1428_;
			_tmp1427_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1428_ = _tmp1427_;
			_tmp1425_ = !VALA_IS_CREATION_METHOD (_tmp1428_);
		} else {
			_tmp1425_ = FALSE;
		}
		if (_tmp1425_) {
			_tmp1424_ = may_access_instance_members;
		} else {
			_tmp1424_ = FALSE;
		}
		if (_tmp1424_) {
			ValaExpression* _tmp1429_;
			ValaExpression* _tmp1430_;
			_tmp1429_ = vala_member_access_get_inner (self);
			_tmp1430_ = _tmp1429_;
			_tmp1423_ = _tmp1430_ != NULL;
		} else {
			_tmp1423_ = FALSE;
		}
		if (_tmp1423_) {
			ValaExpression* _tmp1431_;
			ValaExpression* _tmp1432_;
			ValaSymbol* _tmp1433_;
			ValaSymbol* _tmp1434_;
			_tmp1431_ = vala_member_access_get_inner (self);
			_tmp1432_ = _tmp1431_;
			_tmp1433_ = vala_expression_get_symbol_reference (_tmp1432_);
			_tmp1434_ = _tmp1433_;
			if (VALA_IS_METHOD (_tmp1434_)) {
			} else {
				ValaSourceReference* _tmp1435_;
				ValaSourceReference* _tmp1436_;
				ValaSymbol* _tmp1437_;
				ValaSymbol* _tmp1438_;
				gchar* _tmp1439_;
				gchar* _tmp1440_;
				ValaSymbol* inner_sym = NULL;
				ValaSymbol* _tmp1441_;
				ValaSymbol* _tmp1442_;
				ValaSymbol* _tmp1443_;
				ValaSymbol* _tmp1444_;
				ValaMemberAccess* inner_ma = NULL;
				ValaMemberAccess* _tmp1464_;
				ValaExpression* _tmp1465_;
				ValaExpression* _tmp1466_;
				_tmp1435_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1436_ = _tmp1435_;
				_tmp1437_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1438_ = _tmp1437_;
				_tmp1439_ = vala_symbol_get_full_name (_tmp1438_);
				_tmp1440_ = _tmp1439_;
				vala_report_warning (_tmp1436_, "Access to static member `%s' with an instance reference", _tmp1440_);
				_g_free0 (_tmp1440_);
				_tmp1441_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1442_ = _tmp1441_;
				_tmp1443_ = vala_symbol_get_parent_symbol (_tmp1442_);
				_tmp1444_ = _tmp1443_;
				inner_sym = _tmp1444_;
				inner_ma = self;
				while (TRUE) {
					gboolean _tmp1445_ = FALSE;
					ValaSymbol* _tmp1446_;
					ValaMemberAccess* _tmp1450_;
					ValaSymbol* _tmp1451_;
					const gchar* _tmp1452_;
					const gchar* _tmp1453_;
					ValaSourceReference* _tmp1454_;
					ValaSourceReference* _tmp1455_;
					ValaMemberAccess* _tmp1456_;
					ValaMemberAccess* _tmp1457_;
					ValaMemberAccess* _tmp1458_;
					ValaExpression* _tmp1459_;
					ValaExpression* _tmp1460_;
					ValaSymbol* _tmp1461_;
					ValaSymbol* _tmp1462_;
					ValaSymbol* _tmp1463_;
					_tmp1446_ = inner_sym;
					if (_tmp1446_ != NULL) {
						ValaSymbol* _tmp1447_;
						const gchar* _tmp1448_;
						const gchar* _tmp1449_;
						_tmp1447_ = inner_sym;
						_tmp1448_ = vala_symbol_get_name (_tmp1447_);
						_tmp1449_ = _tmp1448_;
						_tmp1445_ = _tmp1449_ != NULL;
					} else {
						_tmp1445_ = FALSE;
					}
					if (!_tmp1445_) {
						break;
					}
					_tmp1450_ = inner_ma;
					_tmp1451_ = inner_sym;
					_tmp1452_ = vala_symbol_get_name (_tmp1451_);
					_tmp1453_ = _tmp1452_;
					_tmp1454_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp1455_ = _tmp1454_;
					_tmp1456_ = vala_member_access_new (NULL, _tmp1453_, _tmp1455_);
					_tmp1457_ = _tmp1456_;
					vala_member_access_set_inner (_tmp1450_, (ValaExpression*) _tmp1457_);
					_vala_code_node_unref0 (_tmp1457_);
					_tmp1458_ = inner_ma;
					_tmp1459_ = vala_member_access_get_inner (_tmp1458_);
					_tmp1460_ = _tmp1459_;
					inner_ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp1460_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
					_tmp1461_ = inner_sym;
					_tmp1462_ = vala_symbol_get_parent_symbol (_tmp1461_);
					_tmp1463_ = _tmp1462_;
					inner_sym = _tmp1463_;
				}
				_tmp1464_ = inner_ma;
				vala_member_access_set_qualified (_tmp1464_, TRUE);
				_tmp1465_ = vala_member_access_get_inner (self);
				_tmp1466_ = _tmp1465_;
				vala_code_node_check ((ValaCodeNode*) _tmp1466_, context);
			}
		}
		_tmp1472_ = vala_code_context_get_experimental_non_null (context);
		_tmp1473_ = _tmp1472_;
		if (_tmp1473_) {
			_tmp1471_ = instance;
		} else {
			_tmp1471_ = FALSE;
		}
		if (_tmp1471_) {
			ValaExpression* _tmp1474_;
			ValaExpression* _tmp1475_;
			ValaDataType* _tmp1476_;
			ValaDataType* _tmp1477_;
			gboolean _tmp1478_;
			gboolean _tmp1479_;
			_tmp1474_ = vala_member_access_get_inner (self);
			_tmp1475_ = _tmp1474_;
			_tmp1476_ = vala_expression_get_value_type (_tmp1475_);
			_tmp1477_ = _tmp1476_;
			_tmp1478_ = vala_data_type_get_nullable (_tmp1477_);
			_tmp1479_ = _tmp1478_;
			_tmp1470_ = _tmp1479_;
		} else {
			_tmp1470_ = FALSE;
		}
		if (_tmp1470_) {
			ValaExpression* _tmp1480_;
			ValaExpression* _tmp1481_;
			ValaDataType* _tmp1482_;
			ValaDataType* _tmp1483_;
			_tmp1480_ = vala_member_access_get_inner (self);
			_tmp1481_ = _tmp1480_;
			_tmp1482_ = vala_expression_get_value_type (_tmp1481_);
			_tmp1483_ = _tmp1482_;
			_tmp1469_ = !VALA_IS_POINTER_TYPE (_tmp1483_);
		} else {
			_tmp1469_ = FALSE;
		}
		if (_tmp1469_) {
			ValaExpression* _tmp1484_;
			ValaExpression* _tmp1485_;
			ValaDataType* _tmp1486_;
			ValaDataType* _tmp1487_;
			_tmp1484_ = vala_member_access_get_inner (self);
			_tmp1485_ = _tmp1484_;
			_tmp1486_ = vala_expression_get_value_type (_tmp1485_);
			_tmp1487_ = _tmp1486_;
			_tmp1468_ = !VALA_IS_GENERIC_TYPE (_tmp1487_);
		} else {
			_tmp1468_ = FALSE;
		}
		if (_tmp1468_) {
			ValaExpression* _tmp1488_;
			ValaExpression* _tmp1489_;
			ValaDataType* _tmp1490_;
			ValaDataType* _tmp1491_;
			_tmp1488_ = vala_member_access_get_inner (self);
			_tmp1489_ = _tmp1488_;
			_tmp1490_ = vala_expression_get_value_type (_tmp1489_);
			_tmp1491_ = _tmp1490_;
			_tmp1467_ = !VALA_IS_ARRAY_TYPE (_tmp1491_);
		} else {
			_tmp1467_ = FALSE;
		}
		if (_tmp1467_) {
			ValaSourceReference* _tmp1492_;
			ValaSourceReference* _tmp1493_;
			ValaSymbol* _tmp1494_;
			ValaSymbol* _tmp1495_;
			gchar* _tmp1496_;
			gchar* _tmp1497_;
			_tmp1492_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1493_ = _tmp1492_;
			_tmp1494_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1495_ = _tmp1494_;
			_tmp1496_ = vala_symbol_get_full_name (_tmp1495_);
			_tmp1497_ = _tmp1496_;
			vala_report_error (_tmp1493_, "Access to instance member `%s' from nullable reference denied", _tmp1497_);
			_g_free0 (_tmp1497_);
		}
		_tmp1498_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1499_ = _tmp1498_;
		m = VALA_IS_METHOD (_tmp1499_) ? ((ValaMethod*) _tmp1499_) : NULL;
		_tmp1500_ = vala_member_access_get_inner (self);
		_tmp1501_ = _tmp1500_;
		inner_ma = VALA_IS_MEMBER_ACCESS (_tmp1501_) ? ((ValaMemberAccess*) _tmp1501_) : NULL;
		_tmp1507_ = m;
		if (_tmp1507_ != NULL) {
			ValaMethod* _tmp1508_;
			ValaMemberBinding _tmp1509_;
			ValaMemberBinding _tmp1510_;
			_tmp1508_ = m;
			_tmp1509_ = vala_method_get_binding (_tmp1508_);
			_tmp1510_ = _tmp1509_;
			_tmp1506_ = _tmp1510_ == VALA_MEMBER_BINDING_STATIC;
		} else {
			_tmp1506_ = FALSE;
		}
		if (_tmp1506_) {
			ValaMethod* _tmp1511_;
			ValaSymbol* _tmp1512_;
			ValaSymbol* _tmp1513_;
			_tmp1511_ = m;
			_tmp1512_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1511_);
			_tmp1513_ = _tmp1512_;
			_tmp1505_ = VALA_IS_OBJECT_TYPE_SYMBOL (_tmp1513_);
		} else {
			_tmp1505_ = FALSE;
		}
		if (_tmp1505_) {
			ValaExpression* _tmp1514_;
			ValaExpression* _tmp1515_;
			_tmp1514_ = vala_member_access_get_inner (self);
			_tmp1515_ = _tmp1514_;
			_tmp1504_ = _tmp1515_ != NULL;
		} else {
			_tmp1504_ = FALSE;
		}
		if (_tmp1504_) {
			ValaExpression* _tmp1516_;
			ValaExpression* _tmp1517_;
			ValaDataType* _tmp1518_;
			ValaDataType* _tmp1519_;
			_tmp1516_ = vala_member_access_get_inner (self);
			_tmp1517_ = _tmp1516_;
			_tmp1518_ = vala_expression_get_value_type (_tmp1517_);
			_tmp1519_ = _tmp1518_;
			_tmp1503_ = _tmp1519_ == NULL;
		} else {
			_tmp1503_ = FALSE;
		}
		if (_tmp1503_) {
			ValaMemberAccess* _tmp1520_;
			ValaList* _tmp1521_;
			gint _tmp1522_;
			gint _tmp1523_;
			_tmp1520_ = inner_ma;
			_tmp1521_ = _tmp1520_->priv->type_argument_list;
			_tmp1522_ = vala_collection_get_size ((ValaCollection*) _tmp1521_);
			_tmp1523_ = _tmp1522_;
			_tmp1502_ = _tmp1523_ > 0;
		} else {
			_tmp1502_ = FALSE;
		}
		if (_tmp1502_) {
			ValaExpression* _tmp1524_;
			ValaExpression* _tmp1525_;
			ValaMethod* _tmp1526_;
			ValaSymbol* _tmp1527_;
			ValaSymbol* _tmp1528_;
			ValaObjectType* _tmp1529_;
			ValaObjectType* _tmp1530_;
			ValaExpression* _tmp1531_;
			ValaExpression* _tmp1532_;
			ValaDataType* _tmp1533_;
			ValaDataType* _tmp1534_;
			ValaSourceReference* _tmp1535_;
			ValaSourceReference* _tmp1536_;
			_tmp1524_ = vala_member_access_get_inner (self);
			_tmp1525_ = _tmp1524_;
			_tmp1526_ = m;
			_tmp1527_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1526_);
			_tmp1528_ = _tmp1527_;
			_tmp1529_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1528_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp1530_ = _tmp1529_;
			vala_expression_set_value_type (_tmp1525_, (ValaDataType*) _tmp1530_);
			_vala_code_node_unref0 (_tmp1530_);
			_tmp1531_ = vala_member_access_get_inner (self);
			_tmp1532_ = _tmp1531_;
			_tmp1533_ = vala_expression_get_value_type (_tmp1532_);
			_tmp1534_ = _tmp1533_;
			_tmp1535_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1536_ = _tmp1535_;
			vala_code_node_set_source_reference ((ValaCodeNode*) _tmp1534_, _tmp1536_);
			{
				ValaList* _type_argument_list = NULL;
				ValaMemberAccess* _tmp1537_;
				ValaList* _tmp1538_;
				gint _type_argument_size = 0;
				ValaList* _tmp1539_;
				gint _tmp1540_;
				gint _tmp1541_;
				gint _type_argument_index = 0;
				_tmp1537_ = inner_ma;
				_tmp1538_ = _tmp1537_->priv->type_argument_list;
				_type_argument_list = _tmp1538_;
				_tmp1539_ = _type_argument_list;
				_tmp1540_ = vala_collection_get_size ((ValaCollection*) _tmp1539_);
				_tmp1541_ = _tmp1540_;
				_type_argument_size = _tmp1541_;
				_type_argument_index = -1;
				while (TRUE) {
					gint _tmp1542_;
					gint _tmp1543_;
					ValaDataType* type_argument = NULL;
					ValaList* _tmp1544_;
					gpointer _tmp1545_;
					ValaExpression* _tmp1546_;
					ValaExpression* _tmp1547_;
					ValaDataType* _tmp1548_;
					ValaDataType* _tmp1549_;
					ValaDataType* _tmp1550_;
					_type_argument_index = _type_argument_index + 1;
					_tmp1542_ = _type_argument_index;
					_tmp1543_ = _type_argument_size;
					if (!(_tmp1542_ < _tmp1543_)) {
						break;
					}
					_tmp1544_ = _type_argument_list;
					_tmp1545_ = vala_list_get (_tmp1544_, _type_argument_index);
					type_argument = (ValaDataType*) _tmp1545_;
					_tmp1546_ = vala_member_access_get_inner (self);
					_tmp1547_ = _tmp1546_;
					_tmp1548_ = vala_expression_get_value_type (_tmp1547_);
					_tmp1549_ = _tmp1548_;
					_tmp1550_ = type_argument;
					vala_data_type_add_type_argument (_tmp1549_, _tmp1550_);
					_vala_code_node_unref0 (type_argument);
				}
			}
		}
		_tmp1551_ = vala_code_context_get_analyzer (context);
		_tmp1552_ = _tmp1551_;
		_tmp1553_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1554_ = _tmp1553_;
		_tmp1555_ = vala_expression_get_lvalue ((ValaExpression*) self);
		_tmp1556_ = _tmp1555_;
		_tmp1557_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1552_, _tmp1554_, _tmp1556_);
		_tmp1558_ = _tmp1557_;
		vala_expression_set_formal_value_type ((ValaExpression*) self, _tmp1558_);
		_vala_code_node_unref0 (_tmp1558_);
		_tmp1560_ = vala_member_access_get_inner (self);
		_tmp1561_ = _tmp1560_;
		if (_tmp1561_ != NULL) {
			ValaDataType* _tmp1562_;
			ValaDataType* _tmp1563_;
			_tmp1562_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1563_ = _tmp1562_;
			_tmp1559_ = _tmp1563_ != NULL;
		} else {
			_tmp1559_ = FALSE;
		}
		if (_tmp1559_) {
			ValaDataType* _tmp1564_;
			ValaDataType* _tmp1565_;
			ValaExpression* _tmp1566_;
			ValaExpression* _tmp1567_;
			ValaDataType* _tmp1568_;
			ValaDataType* _tmp1569_;
			ValaDataType* _tmp1570_;
			ValaDataType* _tmp1571_;
			_tmp1564_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1565_ = _tmp1564_;
			_tmp1566_ = vala_member_access_get_inner (self);
			_tmp1567_ = _tmp1566_;
			_tmp1568_ = vala_expression_get_value_type (_tmp1567_);
			_tmp1569_ = _tmp1568_;
			_tmp1570_ = vala_data_type_get_actual_type (_tmp1565_, _tmp1569_, NULL, (ValaCodeNode*) self);
			_tmp1571_ = _tmp1570_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1571_);
			_vala_code_node_unref0 (_tmp1571_);
		} else {
			ValaDataType* _tmp1572_;
			ValaDataType* _tmp1573_;
			_tmp1572_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1573_ = _tmp1572_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1573_);
		}
		_tmp1574_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1575_ = _tmp1574_;
		if (VALA_IS_METHOD (_tmp1575_)) {
			ValaMethod* method = NULL;
			ValaSymbol* _tmp1576_;
			ValaSymbol* _tmp1577_;
			ValaDataType* _tmp1578_;
			ValaDataType* _tmp1579_;
			gboolean _tmp1586_ = FALSE;
			_tmp1576_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1577_ = _tmp1576_;
			method = G_TYPE_CHECK_INSTANCE_CAST (_tmp1577_, VALA_TYPE_METHOD, ValaMethod);
			_tmp1578_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1579_ = _tmp1578_;
			if (_tmp1579_ != NULL) {
				ValaDataType* _tmp1580_;
				ValaDataType* _tmp1581_;
				ValaDataType* _tmp1582_;
				ValaDataType* _tmp1583_;
				gboolean _tmp1584_;
				gboolean _tmp1585_;
				_tmp1580_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp1581_ = _tmp1580_;
				_tmp1582_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp1583_ = _tmp1582_;
				_tmp1584_ = vala_data_type_get_value_owned (_tmp1583_);
				_tmp1585_ = _tmp1584_;
				vala_data_type_set_value_owned (_tmp1581_, _tmp1585_);
			}
			if (instance) {
				ValaMethod* _tmp1587_;
				ValaSymbol* _tmp1588_;
				ValaSymbol* _tmp1589_;
				_tmp1587_ = method;
				_tmp1588_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1587_);
				_tmp1589_ = _tmp1588_;
				_tmp1586_ = VALA_IS_TYPESYMBOL (_tmp1589_);
			} else {
				_tmp1586_ = FALSE;
			}
			if (_tmp1586_) {
				ValaExpression* _tmp1590_;
				ValaExpression* _tmp1591_;
				ValaMethod* _tmp1592_;
				ValaSymbol* _tmp1593_;
				ValaSymbol* _tmp1594_;
				ValaDataType* _tmp1595_;
				ValaDataType* _tmp1596_;
				ValaExpression* _tmp1597_;
				ValaExpression* _tmp1598_;
				ValaDataType* _tmp1599_;
				ValaDataType* _tmp1600_;
				ValaMethod* _tmp1601_;
				ValaParameter* _tmp1602_;
				ValaParameter* _tmp1603_;
				ValaDataType* _tmp1604_;
				ValaDataType* _tmp1605_;
				gboolean _tmp1606_;
				gboolean _tmp1607_;
				_tmp1590_ = vala_member_access_get_inner (self);
				_tmp1591_ = _tmp1590_;
				_tmp1592_ = method;
				_tmp1593_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1592_);
				_tmp1594_ = _tmp1593_;
				_tmp1595_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1594_);
				_tmp1596_ = _tmp1595_;
				vala_expression_set_target_type (_tmp1591_, _tmp1596_);
				_vala_code_node_unref0 (_tmp1596_);
				_tmp1597_ = vala_member_access_get_inner (self);
				_tmp1598_ = _tmp1597_;
				_tmp1599_ = vala_expression_get_target_type (_tmp1598_);
				_tmp1600_ = _tmp1599_;
				_tmp1601_ = method;
				_tmp1602_ = vala_method_get_this_parameter (_tmp1601_);
				_tmp1603_ = _tmp1602_;
				_tmp1604_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1603_);
				_tmp1605_ = _tmp1604_;
				_tmp1606_ = vala_data_type_get_value_owned (_tmp1605_);
				_tmp1607_ = _tmp1606_;
				vala_data_type_set_value_owned (_tmp1600_, _tmp1607_);
			}
		} else {
			gboolean _tmp1608_ = FALSE;
			gboolean _tmp1609_ = FALSE;
			ValaSymbol* _tmp1610_;
			ValaSymbol* _tmp1611_;
			_tmp1610_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1611_ = _tmp1610_;
			if (VALA_IS_PROPERTY (_tmp1611_)) {
				_tmp1609_ = instance;
			} else {
				_tmp1609_ = FALSE;
			}
			if (_tmp1609_) {
				ValaSymbol* _tmp1612_;
				ValaSymbol* _tmp1613_;
				ValaSymbol* _tmp1614_;
				ValaSymbol* _tmp1615_;
				_tmp1612_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1613_ = _tmp1612_;
				_tmp1614_ = vala_symbol_get_parent_symbol (_tmp1613_);
				_tmp1615_ = _tmp1614_;
				_tmp1608_ = _tmp1615_ != NULL;
			} else {
				_tmp1608_ = FALSE;
			}
			if (_tmp1608_) {
				ValaExpression* _tmp1616_;
				ValaExpression* _tmp1617_;
				ValaSymbol* _tmp1618_;
				ValaSymbol* _tmp1619_;
				ValaSymbol* _tmp1620_;
				ValaSymbol* _tmp1621_;
				ValaDataType* _tmp1622_;
				ValaDataType* _tmp1623_;
				_tmp1616_ = vala_member_access_get_inner (self);
				_tmp1617_ = _tmp1616_;
				_tmp1618_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1619_ = _tmp1618_;
				_tmp1620_ = vala_symbol_get_parent_symbol (_tmp1619_);
				_tmp1621_ = _tmp1620_;
				_tmp1622_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1621_);
				_tmp1623_ = _tmp1622_;
				vala_expression_set_target_type (_tmp1617_, _tmp1623_);
				_vala_code_node_unref0 (_tmp1623_);
			} else {
				gboolean _tmp1624_ = FALSE;
				gboolean _tmp1625_ = FALSE;
				gboolean _tmp1626_ = FALSE;
				ValaSymbol* _tmp1627_;
				ValaSymbol* _tmp1628_;
				_tmp1627_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1628_ = _tmp1627_;
				if (VALA_IS_FIELD (_tmp1628_)) {
					_tmp1626_ = TRUE;
				} else {
					ValaSymbol* _tmp1629_;
					ValaSymbol* _tmp1630_;
					_tmp1629_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1630_ = _tmp1629_;
					_tmp1626_ = VALA_IS_SIGNAL (_tmp1630_);
				}
				if (_tmp1626_) {
					_tmp1625_ = instance;
				} else {
					_tmp1625_ = FALSE;
				}
				if (_tmp1625_) {
					ValaSymbol* _tmp1631_;
					ValaSymbol* _tmp1632_;
					ValaSymbol* _tmp1633_;
					ValaSymbol* _tmp1634_;
					_tmp1631_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1632_ = _tmp1631_;
					_tmp1633_ = vala_symbol_get_parent_symbol (_tmp1632_);
					_tmp1634_ = _tmp1633_;
					_tmp1624_ = _tmp1634_ != NULL;
				} else {
					_tmp1624_ = FALSE;
				}
				if (_tmp1624_) {
					ValaDataType* parent_type = NULL;
					ValaSymbol* _tmp1635_;
					ValaSymbol* _tmp1636_;
					ValaSymbol* _tmp1637_;
					ValaSymbol* _tmp1638_;
					ValaDataType* _tmp1639_;
					ValaExpression* _tmp1640_;
					ValaExpression* _tmp1641_;
					ValaDataType* _tmp1642_;
					ValaExpression* _tmp1643_;
					ValaExpression* _tmp1644_;
					ValaDataType* _tmp1645_;
					ValaDataType* _tmp1646_;
					ValaDataType* _tmp1647_;
					ValaDataType* _tmp1648_;
					_tmp1635_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1636_ = _tmp1635_;
					_tmp1637_ = vala_symbol_get_parent_symbol (_tmp1636_);
					_tmp1638_ = _tmp1637_;
					_tmp1639_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1638_);
					parent_type = _tmp1639_;
					_tmp1640_ = vala_member_access_get_inner (self);
					_tmp1641_ = _tmp1640_;
					_tmp1642_ = parent_type;
					_tmp1643_ = vala_member_access_get_inner (self);
					_tmp1644_ = _tmp1643_;
					_tmp1645_ = vala_expression_get_value_type (_tmp1644_);
					_tmp1646_ = _tmp1645_;
					_tmp1647_ = vala_data_type_get_actual_type (_tmp1642_, _tmp1646_, NULL, (ValaCodeNode*) self);
					_tmp1648_ = _tmp1647_;
					vala_expression_set_target_type (_tmp1641_, _tmp1648_);
					_vala_code_node_unref0 (_tmp1648_);
					_vala_code_node_unref0 (parent_type);
				}
			}
		}
		_tmp1651_ = vala_member_access_get_inner (self);
		_tmp1652_ = _tmp1651_;
		if (_tmp1652_ == NULL) {
			ValaDataType* _tmp1653_;
			ValaDataType* _tmp1654_;
			_tmp1653_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp1654_ = _tmp1653_;
			_tmp1650_ = _tmp1654_ != NULL;
		} else {
			_tmp1650_ = FALSE;
		}
		if (_tmp1650_) {
			ValaProfile _tmp1655_;
			ValaProfile _tmp1656_;
			_tmp1655_ = vala_code_context_get_profile (context);
			_tmp1656_ = _tmp1655_;
			_tmp1649_ = _tmp1656_ == VALA_PROFILE_GOBJECT;
		} else {
			_tmp1649_ = FALSE;
		}
		if (_tmp1649_) {
			vala_member_access_check_narrowed_value_type (self);
		}
	}
	_tmp1657_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp1658_ = _tmp1657_;
	if (_tmp1658_ != NULL) {
		ValaDataType* _tmp1659_;
		ValaDataType* _tmp1660_;
		_tmp1659_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp1660_ = _tmp1659_;
		vala_code_node_check ((ValaCodeNode*) _tmp1660_, context);
	}
	_tmp1661_ = self->priv->_tainted_access;
	if (!_tmp1661_) {
		vala_member_access_set_tainted_access (self, vala_member_access_is_tainted (self));
	}
	_tmp1662_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp1663_ = _tmp1662_;
	result = !_tmp1663_;
	_vala_iterable_unref0 (visited_types);
	return result;
}

static gboolean
vala_member_access_is_instance_symbol (ValaSymbol* symbol)
{
	gboolean _tmp0_ = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (symbol != NULL, FALSE);
	if (VALA_IS_FIELD (symbol)) {
		ValaMemberBinding _tmp1_;
		ValaMemberBinding _tmp2_;
		_tmp1_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_FIELD, ValaField));
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		if (VALA_IS_METHOD (symbol)) {
			_tmp4_ = !VALA_IS_CREATION_METHOD (symbol);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			ValaMemberBinding _tmp5_;
			ValaMemberBinding _tmp6_;
			_tmp5_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_METHOD, ValaMethod));
			_tmp6_ = _tmp5_;
			_tmp3_ = _tmp6_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp7_ = FALSE;
			if (VALA_IS_PROPERTY (symbol)) {
				ValaMemberBinding _tmp8_;
				ValaMemberBinding _tmp9_;
				_tmp8_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_PROPERTY, ValaProperty));
				_tmp9_ = _tmp8_;
				_tmp7_ = _tmp9_ == VALA_MEMBER_BINDING_INSTANCE;
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				result = TRUE;
				return result;
			} else {
				if (VALA_IS_SIGNAL (symbol)) {
					result = TRUE;
					return result;
				} else {
					result = FALSE;
					return result;
				}
			}
		}
	}
}

void
vala_member_access_check_lvalue_access (ValaMemberAccess* self)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	gboolean instance = FALSE;
	gboolean _tmp23_ = FALSE;
	ValaExpression* _tmp24_;
	ValaExpression* _tmp25_;
	ValaSymbol* _tmp26_;
	ValaSymbol* _tmp27_;
	gboolean this_access = FALSE;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp35_ = FALSE;
	ValaExpression* _tmp36_;
	ValaExpression* _tmp37_;
	ValaDataType* _tmp38_;
	ValaDataType* _tmp39_;
	gboolean struct_or_array = FALSE;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp50_;
	ValaExpression* _tmp51_;
	gboolean _tmp52_ = FALSE;
	gboolean _tmp53_ = FALSE;
	ValaMemberAccess* _tmp54_;
	gboolean _tmp61_ = FALSE;
	gboolean _tmp62_ = FALSE;
	gboolean _tmp63_ = FALSE;
	gboolean _tmp64_ = FALSE;
	gboolean _tmp83_ = FALSE;
	ValaSymbol* _tmp84_;
	ValaSymbol* _tmp85_;
	g_return_if_fail (self != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp4_ = _tmp3_;
	if (VALA_IS_FIELD (_tmp4_)) {
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		ValaMemberBinding _tmp7_;
		ValaMemberBinding _tmp8_;
		_tmp5_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_FIELD, ValaField));
		_tmp8_ = _tmp7_;
		_tmp2_ = _tmp8_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp2_ = FALSE;
	}
	instance = _tmp2_;
	if (!instance) {
		gboolean _tmp9_ = FALSE;
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		_tmp10_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp11_ = _tmp10_;
		if (VALA_IS_METHOD (_tmp11_)) {
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			ValaMemberBinding _tmp14_;
			ValaMemberBinding _tmp15_;
			_tmp12_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_METHOD, ValaMethod));
			_tmp15_ = _tmp14_;
			_tmp9_ = _tmp15_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp9_ = FALSE;
		}
		instance = _tmp9_;
	}
	if (!instance) {
		gboolean _tmp16_ = FALSE;
		ValaSymbol* _tmp17_;
		ValaSymbol* _tmp18_;
		_tmp17_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp18_ = _tmp17_;
		if (VALA_IS_PROPERTY (_tmp18_)) {
			ValaSymbol* _tmp19_;
			ValaSymbol* _tmp20_;
			ValaMemberBinding _tmp21_;
			ValaMemberBinding _tmp22_;
			_tmp19_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, VALA_TYPE_PROPERTY, ValaProperty));
			_tmp22_ = _tmp21_;
			_tmp16_ = _tmp22_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp16_ = FALSE;
		}
		instance = _tmp16_;
	}
	_tmp24_ = vala_member_access_get_inner (self);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_expression_get_symbol_reference (_tmp25_);
	_tmp27_ = _tmp26_;
	if (VALA_IS_PARAMETER (_tmp27_)) {
		ValaExpression* _tmp28_;
		ValaExpression* _tmp29_;
		ValaSymbol* _tmp30_;
		ValaSymbol* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		_tmp28_ = vala_member_access_get_inner (self);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_expression_get_symbol_reference (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_symbol_get_name (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp23_ = g_strcmp0 (_tmp33_, "this") == 0;
	} else {
		_tmp23_ = FALSE;
	}
	this_access = _tmp23_;
	_tmp36_ = vala_member_access_get_inner (self);
	_tmp37_ = _tmp36_;
	_tmp38_ = vala_expression_get_value_type (_tmp37_);
	_tmp39_ = _tmp38_;
	if (VALA_IS_STRUCT_VALUE_TYPE (_tmp39_)) {
		ValaExpression* _tmp40_;
		ValaExpression* _tmp41_;
		ValaDataType* _tmp42_;
		ValaDataType* _tmp43_;
		gboolean _tmp44_;
		gboolean _tmp45_;
		_tmp40_ = vala_member_access_get_inner (self);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_expression_get_value_type (_tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_data_type_get_nullable (_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp35_ = !_tmp45_;
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		_tmp34_ = TRUE;
	} else {
		ValaExpression* _tmp46_;
		ValaExpression* _tmp47_;
		ValaDataType* _tmp48_;
		ValaDataType* _tmp49_;
		_tmp46_ = vala_member_access_get_inner (self);
		_tmp47_ = _tmp46_;
		_tmp48_ = vala_expression_get_value_type (_tmp47_);
		_tmp49_ = _tmp48_;
		_tmp34_ = VALA_IS_ARRAY_TYPE (_tmp49_);
	}
	struct_or_array = _tmp34_;
	_tmp50_ = vala_member_access_get_inner (self);
	_tmp51_ = _tmp50_;
	ma = VALA_IS_MEMBER_ACCESS (_tmp51_) ? ((ValaMemberAccess*) _tmp51_) : NULL;
	_tmp54_ = ma;
	if (_tmp54_ == NULL) {
		_tmp53_ = struct_or_array;
	} else {
		_tmp53_ = FALSE;
	}
	if (_tmp53_) {
		ValaExpression* _tmp55_;
		ValaExpression* _tmp56_;
		_tmp55_ = vala_member_access_get_inner (self);
		_tmp56_ = _tmp55_;
		_tmp52_ = VALA_IS_POINTER_INDIRECTION (_tmp56_);
	} else {
		_tmp52_ = FALSE;
	}
	if (_tmp52_) {
		ValaExpression* _tmp57_;
		ValaExpression* _tmp58_;
		ValaExpression* _tmp59_;
		ValaExpression* _tmp60_;
		_tmp57_ = vala_member_access_get_inner (self);
		_tmp58_ = _tmp57_;
		_tmp59_ = vala_pointer_indirection_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, VALA_TYPE_POINTER_INDIRECTION, ValaPointerIndirection));
		_tmp60_ = _tmp59_;
		ma = VALA_IS_MEMBER_ACCESS (_tmp60_) ? ((ValaMemberAccess*) _tmp60_) : NULL;
	}
	if (instance) {
		_tmp64_ = struct_or_array;
	} else {
		_tmp64_ = FALSE;
	}
	if (_tmp64_) {
		gboolean _tmp65_ = FALSE;
		ValaSymbol* _tmp66_;
		ValaSymbol* _tmp67_;
		_tmp66_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp67_ = _tmp66_;
		if (VALA_IS_METHOD (_tmp67_)) {
			_tmp65_ = TRUE;
		} else {
			gboolean _tmp68_;
			gboolean _tmp69_;
			_tmp68_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp69_ = _tmp68_;
			_tmp65_ = _tmp69_;
		}
		_tmp63_ = _tmp65_;
	} else {
		_tmp63_ = FALSE;
	}
	if (_tmp63_) {
		gboolean _tmp70_ = FALSE;
		gboolean _tmp71_ = FALSE;
		ValaMemberAccess* _tmp72_;
		_tmp72_ = ma;
		if (_tmp72_ != NULL) {
			ValaMemberAccess* _tmp73_;
			ValaSymbol* _tmp74_;
			ValaSymbol* _tmp75_;
			_tmp73_ = ma;
			_tmp74_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp73_);
			_tmp75_ = _tmp74_;
			_tmp71_ = VALA_IS_VARIABLE (_tmp75_);
		} else {
			_tmp71_ = FALSE;
		}
		if (_tmp71_) {
			_tmp70_ = TRUE;
		} else {
			ValaExpression* _tmp76_;
			ValaExpression* _tmp77_;
			_tmp76_ = vala_member_access_get_inner (self);
			_tmp77_ = _tmp76_;
			_tmp70_ = VALA_IS_ELEMENT_ACCESS (_tmp77_);
		}
		_tmp62_ = _tmp70_;
	} else {
		_tmp62_ = FALSE;
	}
	if (_tmp62_) {
		_tmp61_ = !this_access;
	} else {
		_tmp61_ = FALSE;
	}
	if (_tmp61_) {
		ValaExpression* _tmp78_;
		ValaExpression* _tmp79_;
		ValaMemberAccess* _tmp80_;
		_tmp78_ = vala_member_access_get_inner (self);
		_tmp79_ = _tmp78_;
		vala_expression_set_lvalue (_tmp79_, TRUE);
		_tmp80_ = ma;
		if (_tmp80_ != NULL) {
			ValaMemberAccess* _tmp81_;
			ValaMemberAccess* _tmp82_;
			_tmp81_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp81_, TRUE);
			_tmp82_ = ma;
			vala_member_access_check_lvalue_access (_tmp82_);
		}
	}
	_tmp84_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp85_ = _tmp84_;
	if (VALA_IS_METHOD (_tmp85_)) {
		ValaSymbol* _tmp86_;
		ValaSymbol* _tmp87_;
		ValaAttribute* _tmp88_;
		_tmp86_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp87_ = _tmp86_;
		_tmp88_ = vala_code_node_get_attribute ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (_tmp87_, VALA_TYPE_METHOD, ValaMethod), "DestroysInstance");
		_tmp83_ = _tmp88_ != NULL;
	} else {
		_tmp83_ = FALSE;
	}
	if (_tmp83_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp89_;
		ValaSymbol* _tmp90_;
		ValaSymbol* _tmp91_;
		ValaSymbol* _tmp92_;
		gboolean _tmp93_ = FALSE;
		gboolean _tmp94_ = FALSE;
		ValaClass* _tmp95_;
		_tmp89_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp90_ = _tmp89_;
		_tmp91_ = vala_symbol_get_parent_symbol ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp90_, VALA_TYPE_METHOD, ValaMethod));
		_tmp92_ = _tmp91_;
		cl = VALA_IS_CLASS (_tmp92_) ? ((ValaClass*) _tmp92_) : NULL;
		_tmp95_ = cl;
		if (_tmp95_ != NULL) {
			ValaClass* _tmp96_;
			gboolean _tmp97_;
			gboolean _tmp98_;
			_tmp96_ = cl;
			_tmp97_ = vala_class_get_is_compact (_tmp96_);
			_tmp98_ = _tmp97_;
			_tmp94_ = _tmp98_;
		} else {
			_tmp94_ = FALSE;
		}
		if (_tmp94_) {
			ValaMemberAccess* _tmp99_;
			_tmp99_ = ma;
			_tmp93_ = _tmp99_ != NULL;
		} else {
			_tmp93_ = FALSE;
		}
		if (_tmp93_) {
			ValaMemberAccess* _tmp100_;
			ValaMemberAccess* _tmp101_;
			_tmp100_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp100_, TRUE);
			_tmp101_ = ma;
			vala_member_access_check_lvalue_access (_tmp101_);
		}
	}
}

static void
vala_member_access_real_emit (ValaCodeNode* base,
                              ValaCodeGenerator* codegen)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_emit ((ValaCodeNode*) _tmp3_, codegen);
	}
	vala_code_visitor_visit_member_access ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                               ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, collection);
	}
}

static void
vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                            ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaLocalVariable* local = NULL;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaParameter* param = NULL;
	ValaSymbol* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaLocalVariable* _tmp8_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp3_, collection);
	}
	_tmp4_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp5_ = _tmp4_;
	local = VALA_IS_LOCAL_VARIABLE (_tmp5_) ? ((ValaLocalVariable*) _tmp5_) : NULL;
	_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp7_ = _tmp6_;
	param = VALA_IS_PARAMETER (_tmp7_) ? ((ValaParameter*) _tmp7_) : NULL;
	_tmp8_ = local;
	if (_tmp8_ != NULL) {
		ValaLocalVariable* _tmp9_;
		_tmp9_ = local;
		vala_collection_add (collection, (ValaVariable*) _tmp9_);
	} else {
		gboolean _tmp10_ = FALSE;
		ValaParameter* _tmp11_;
		_tmp11_ = param;
		if (_tmp11_ != NULL) {
			ValaParameter* _tmp12_;
			ValaParameterDirection _tmp13_;
			ValaParameterDirection _tmp14_;
			_tmp12_ = param;
			_tmp13_ = vala_parameter_get_direction (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp10_ = _tmp14_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			ValaParameter* _tmp15_;
			_tmp15_ = param;
			vala_collection_add (collection, (ValaVariable*) _tmp15_);
		}
	}
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		ValaMemberAccess* self;
		self = _data1_->self;
		_vala_code_node_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static ValaTraverseStatus
__lambda4_ (Block1Data* _data1_,
            ValaCodeNode* n)
{
	ValaMemberAccess* self;
	ValaTraverseStatus result = 0;
	self = _data1_->self;
	g_return_val_if_fail (n != NULL, 0);
	if (VALA_IS_POSTFIX_EXPRESSION (n)) {
		_data1_->found = TRUE;
		result = VALA_TRAVERSE_STATUS_STOP;
		return result;
	} else {
		if (VALA_IS_UNARY_EXPRESSION (n)) {
			ValaUnaryExpression* e = NULL;
			gboolean _tmp0_ = FALSE;
			ValaUnaryExpression* _tmp1_;
			ValaUnaryOperator _tmp2_;
			ValaUnaryOperator _tmp3_;
			e = G_TYPE_CHECK_INSTANCE_CAST (n, VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression);
			_tmp1_ = e;
			_tmp2_ = vala_unary_expression_get_operator (_tmp1_);
			_tmp3_ = _tmp2_;
			if (_tmp3_ == VALA_UNARY_OPERATOR_INCREMENT) {
				_tmp0_ = TRUE;
			} else {
				ValaUnaryExpression* _tmp4_;
				ValaUnaryOperator _tmp5_;
				ValaUnaryOperator _tmp6_;
				_tmp4_ = e;
				_tmp5_ = vala_unary_expression_get_operator (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp0_ = _tmp6_ == VALA_UNARY_OPERATOR_DECREMENT;
			}
			if (_tmp0_) {
				_data1_->found = TRUE;
				result = VALA_TRAVERSE_STATUS_STOP;
				return result;
			}
		}
	}
	result = VALA_TRAVERSE_STATUS_CONTINUE;
	return result;
}

static ValaTraverseStatus
___lambda4__vala_traverse_func (ValaCodeNode* node,
                                gpointer self)
{
	ValaTraverseStatus result;
	result = __lambda4_ (self, node);
	return result;
}

static gboolean
vala_member_access_is_tainted (ValaMemberAccess* self)
{
	Block1Data* _data1_;
	ValaCodeNode* node = NULL;
	ValaCodeNode* _tmp0_;
	ValaCodeNode* _tmp1_;
	ValaCodeNode* _tmp2_;
	ValaTraverseVisitor* traverse = NULL;
	ValaTraverseVisitor* _tmp14_;
	ValaCodeNode* _tmp15_;
	ValaTraverseVisitor* _tmp16_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = vala_code_node_ref (self);
	node = (ValaCodeNode*) self;
	_tmp0_ = node;
	_tmp1_ = vala_code_node_get_parent_node (_tmp0_);
	_tmp2_ = _tmp1_;
	if (VALA_IS_MEMBER_ACCESS (_tmp2_)) {
		result = FALSE;
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return result;
	}
	while (TRUE) {
		ValaCodeNode* _tmp3_;
		ValaCodeNode* _tmp4_;
		ValaCodeNode* _tmp5_;
		ValaCodeNode* _tmp6_;
		ValaCodeNode* _tmp7_;
		ValaCodeNode* _tmp8_;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		ValaCodeNode* _tmp11_;
		_tmp3_ = node;
		_tmp4_ = vala_code_node_get_parent_node (_tmp3_);
		_tmp5_ = _tmp4_;
		if (!VALA_IS_EXPRESSION (_tmp5_)) {
			break;
		}
		_tmp6_ = node;
		_tmp7_ = vala_code_node_get_parent_node (_tmp6_);
		_tmp8_ = _tmp7_;
		node = _tmp8_;
		_tmp11_ = node;
		if (VALA_IS_ASSIGNMENT (_tmp11_)) {
			_tmp10_ = TRUE;
		} else {
			ValaCodeNode* _tmp12_;
			_tmp12_ = node;
			_tmp10_ = VALA_IS_METHOD_CALL (_tmp12_);
		}
		if (_tmp10_) {
			_tmp9_ = TRUE;
		} else {
			ValaCodeNode* _tmp13_;
			_tmp13_ = node;
			_tmp9_ = VALA_IS_OBJECT_CREATION_EXPRESSION (_tmp13_);
		}
		if (_tmp9_) {
			break;
		}
	}
	_data1_->found = FALSE;
	_tmp14_ = vala_traverse_visitor_new (___lambda4__vala_traverse_func, block1_data_ref (_data1_), block1_data_unref);
	traverse = _tmp14_;
	_tmp15_ = node;
	_tmp16_ = traverse;
	vala_code_node_accept (_tmp15_, (ValaCodeVisitor*) _tmp16_);
	result = _data1_->found;
	_vala_code_visitor_unref0 (traverse);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}

static void
vala_member_access_check_narrowed_value_type (ValaMemberAccess* self)
{
	ValaVariable* variable = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaVariable* _tmp2_;
	ValaCodeNode* _tmp3_;
	ValaCodeNode* _tmp4_;
	gboolean is_negation = FALSE;
	ValaCodeNode* parent = NULL;
	ValaCodeNode* _tmp5_;
	ValaCodeNode* _tmp6_;
	ValaIfStatement* if_statement = NULL;
	ValaArrayList* scope_type_checks = NULL;
	GEqualFunc _tmp7_;
	ValaArrayList* _tmp8_;
	ValaIfStatement* _tmp43_;
	ValaDataType* _tmp79_;
	ValaDataType* _tmp80_;
	ValaSymbol* _tmp81_;
	ValaSymbol* _tmp82_;
	g_return_if_fail (self != NULL);
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	variable = VALA_IS_VARIABLE (_tmp1_) ? ((ValaVariable*) _tmp1_) : NULL;
	_tmp2_ = variable;
	if (_tmp2_ == NULL) {
		return;
	}
	_tmp3_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
	_tmp4_ = _tmp3_;
	if (!VALA_IS_MEMBER_ACCESS (_tmp4_)) {
		return;
	}
	is_negation = FALSE;
	_tmp5_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
	_tmp6_ = _tmp5_;
	parent = _tmp6_;
	if_statement = NULL;
	_tmp7_ = g_direct_equal;
	_tmp8_ = vala_array_list_new (VALA_TYPE_TYPECHECK, NULL, NULL, _tmp7_);
	scope_type_checks = _tmp8_;
	while (TRUE) {
		gboolean _tmp9_ = FALSE;
		ValaCodeNode* _tmp10_;
		ValaCodeNode* _tmp12_;
		ValaCodeNode* _tmp13_;
		ValaCodeNode* _tmp14_;
		ValaCodeNode* _tmp15_;
		ValaCodeNode* _tmp23_;
		ValaCodeNode* _tmp24_;
		ValaCodeNode* _tmp25_;
		ValaCodeNode* _tmp40_;
		ValaCodeNode* _tmp41_;
		ValaCodeNode* _tmp42_;
		_tmp10_ = parent;
		if (_tmp10_ != NULL) {
			ValaCodeNode* _tmp11_;
			_tmp11_ = parent;
			_tmp9_ = !VALA_IS_METHOD (_tmp11_);
		} else {
			_tmp9_ = FALSE;
		}
		if (!_tmp9_) {
			break;
		}
		_tmp12_ = parent;
		if (VALA_IS_TYPECHECK (_tmp12_)) {
			parent = NULL;
			break;
		}
		_tmp13_ = parent;
		_tmp14_ = vala_code_node_get_parent_node (_tmp13_);
		_tmp15_ = _tmp14_;
		if (VALA_IS_IF_STATEMENT (_tmp15_)) {
			ValaCodeNode* _tmp16_;
			ValaCodeNode* _tmp17_;
			ValaCodeNode* _tmp18_;
			ValaIfStatement* _tmp19_;
			ValaBlock* _tmp20_;
			ValaBlock* _tmp21_;
			ValaCodeNode* _tmp22_;
			_tmp16_ = parent;
			_tmp17_ = vala_code_node_get_parent_node (_tmp16_);
			_tmp18_ = _tmp17_;
			if_statement = G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_IF_STATEMENT, ValaIfStatement);
			_tmp19_ = if_statement;
			_tmp20_ = vala_if_statement_get_false_statement (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = parent;
			is_negation = G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, VALA_TYPE_CODE_NODE, ValaCodeNode) == _tmp22_;
			break;
		}
		_tmp23_ = parent;
		_tmp24_ = vala_code_node_get_parent_node (_tmp23_);
		_tmp25_ = _tmp24_;
		if (VALA_IS_METHOD (_tmp25_)) {
			{
				ValaList* _expr_list = NULL;
				ValaCodeNode* _tmp26_;
				ValaCodeNode* _tmp27_;
				ValaCodeNode* _tmp28_;
				ValaList* _tmp29_;
				gint _expr_size = 0;
				ValaList* _tmp30_;
				gint _tmp31_;
				gint _tmp32_;
				gint _expr_index = 0;
				_tmp26_ = parent;
				_tmp27_ = vala_code_node_get_parent_node (_tmp26_);
				_tmp28_ = _tmp27_;
				_tmp29_ = vala_method_get_preconditions (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, VALA_TYPE_METHOD, ValaMethod));
				_expr_list = _tmp29_;
				_tmp30_ = _expr_list;
				_tmp31_ = vala_collection_get_size ((ValaCollection*) _tmp30_);
				_tmp32_ = _tmp31_;
				_expr_size = _tmp32_;
				_expr_index = -1;
				while (TRUE) {
					gint _tmp33_;
					gint _tmp34_;
					ValaExpression* expr = NULL;
					ValaList* _tmp35_;
					gpointer _tmp36_;
					ValaExpression* _tmp37_;
					_expr_index = _expr_index + 1;
					_tmp33_ = _expr_index;
					_tmp34_ = _expr_size;
					if (!(_tmp33_ < _tmp34_)) {
						break;
					}
					_tmp35_ = _expr_list;
					_tmp36_ = vala_list_get (_tmp35_, _expr_index);
					expr = (ValaExpression*) _tmp36_;
					_tmp37_ = expr;
					if (VALA_IS_TYPECHECK (_tmp37_)) {
						ValaArrayList* _tmp38_;
						ValaExpression* _tmp39_;
						_tmp38_ = scope_type_checks;
						_tmp39_ = expr;
						vala_collection_add ((ValaCollection*) _tmp38_, G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, VALA_TYPE_TYPECHECK, ValaTypeCheck));
					}
					_vala_code_node_unref0 (expr);
				}
			}
			break;
		}
		_tmp40_ = parent;
		_tmp41_ = vala_code_node_get_parent_node (_tmp40_);
		_tmp42_ = _tmp41_;
		parent = _tmp42_;
	}
	_tmp43_ = if_statement;
	if (_tmp43_ != NULL) {
		ValaExpression* expr = NULL;
		ValaIfStatement* _tmp44_;
		ValaExpression* _tmp45_;
		ValaExpression* _tmp46_;
		gboolean _tmp47_ = FALSE;
		ValaExpression* _tmp48_;
		ValaTypeCheck* type_check = NULL;
		ValaExpression* _tmp55_;
		gboolean _tmp56_ = FALSE;
		_tmp44_ = if_statement;
		_tmp45_ = vala_if_statement_get_condition (_tmp44_);
		_tmp46_ = _tmp45_;
		expr = _tmp46_;
		_tmp48_ = expr;
		if (VALA_IS_UNARY_EXPRESSION (_tmp48_)) {
			ValaExpression* _tmp49_;
			ValaUnaryOperator _tmp50_;
			ValaUnaryOperator _tmp51_;
			_tmp49_ = expr;
			_tmp50_ = vala_unary_expression_get_operator (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression));
			_tmp51_ = _tmp50_;
			_tmp47_ = _tmp51_ == VALA_UNARY_OPERATOR_LOGICAL_NEGATION;
		} else {
			_tmp47_ = FALSE;
		}
		if (_tmp47_) {
			ValaExpression* _tmp52_;
			ValaExpression* _tmp53_;
			ValaExpression* _tmp54_;
			_tmp52_ = expr;
			_tmp53_ = vala_unary_expression_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression));
			_tmp54_ = _tmp53_;
			expr = _tmp54_;
			is_negation = !is_negation;
		}
		_tmp55_ = expr;
		type_check = VALA_IS_TYPECHECK (_tmp55_) ? ((ValaTypeCheck*) _tmp55_) : NULL;
		if (!is_negation) {
			ValaTypeCheck* _tmp57_;
			_tmp57_ = type_check;
			_tmp56_ = _tmp57_ != NULL;
		} else {
			_tmp56_ = FALSE;
		}
		if (_tmp56_) {
			ValaTypeSymbol* narrowed_symnol = NULL;
			ValaTypeCheck* _tmp58_;
			ValaDataType* _tmp59_;
			ValaDataType* _tmp60_;
			ValaTypeSymbol* _tmp61_;
			ValaTypeSymbol* _tmp62_;
			ValaVariable* _tmp63_;
			ValaTypeCheck* _tmp64_;
			ValaExpression* _tmp65_;
			ValaExpression* _tmp66_;
			ValaSymbol* _tmp67_;
			ValaSymbol* _tmp68_;
			_tmp58_ = type_check;
			_tmp59_ = vala_typecheck_get_type_reference (_tmp58_);
			_tmp60_ = _tmp59_;
			_tmp61_ = vala_data_type_get_type_symbol (_tmp60_);
			_tmp62_ = _tmp61_;
			narrowed_symnol = _tmp62_;
			_tmp63_ = variable;
			_tmp64_ = type_check;
			_tmp65_ = vala_typecheck_get_expression (_tmp64_);
			_tmp66_ = _tmp65_;
			_tmp67_ = vala_expression_get_symbol_reference (_tmp66_);
			_tmp68_ = _tmp67_;
			if (G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, VALA_TYPE_SYMBOL, ValaSymbol) == _tmp68_) {
				ValaTypeSymbol* _tmp69_;
				ValaDataType* _tmp70_;
				ValaDataType* _tmp71_;
				ValaTypeSymbol* _tmp72_;
				ValaTypeSymbol* _tmp73_;
				ValaDataType* _tmp77_;
				ValaDataType* _tmp78_;
				_tmp69_ = narrowed_symnol;
				_tmp70_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp71_ = _tmp70_;
				_tmp72_ = vala_data_type_get_type_symbol (_tmp71_);
				_tmp73_ = _tmp72_;
				if (_tmp69_ != _tmp73_) {
					ValaDataType* _tmp74_;
					ValaDataType* _tmp75_;
					ValaTypeSymbol* _tmp76_;
					_tmp74_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp75_ = _tmp74_;
					_tmp76_ = narrowed_symnol;
					vala_data_type_set_context_symbol (_tmp75_, (ValaSymbol*) _tmp76_);
				}
				_tmp77_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp78_ = _tmp77_;
				vala_data_type_set_nullable (_tmp78_, FALSE);
			}
		}
	}
	_tmp79_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp80_ = _tmp79_;
	_tmp81_ = vala_data_type_get_context_symbol (_tmp80_);
	_tmp82_ = _tmp81_;
	if (_tmp82_ == NULL) {
		{
			ValaArrayList* _type_check_list = NULL;
			ValaArrayList* _tmp83_;
			gint _type_check_size = 0;
			ValaArrayList* _tmp84_;
			gint _tmp85_;
			gint _tmp86_;
			gint _type_check_index = 0;
			_tmp83_ = scope_type_checks;
			_type_check_list = _tmp83_;
			_tmp84_ = _type_check_list;
			_tmp85_ = vala_collection_get_size ((ValaCollection*) _tmp84_);
			_tmp86_ = _tmp85_;
			_type_check_size = _tmp86_;
			_type_check_index = -1;
			while (TRUE) {
				gint _tmp87_;
				gint _tmp88_;
				ValaTypeCheck* type_check = NULL;
				ValaArrayList* _tmp89_;
				gpointer _tmp90_;
				ValaTypeCheck* _tmp91_;
				ValaTypeSymbol* narrowed_symnol = NULL;
				ValaTypeCheck* _tmp92_;
				ValaDataType* _tmp93_;
				ValaDataType* _tmp94_;
				ValaTypeSymbol* _tmp95_;
				ValaTypeSymbol* _tmp96_;
				ValaVariable* _tmp97_;
				ValaTypeCheck* _tmp98_;
				ValaExpression* _tmp99_;
				ValaExpression* _tmp100_;
				ValaSymbol* _tmp101_;
				ValaSymbol* _tmp102_;
				_type_check_index = _type_check_index + 1;
				_tmp87_ = _type_check_index;
				_tmp88_ = _type_check_size;
				if (!(_tmp87_ < _tmp88_)) {
					break;
				}
				_tmp89_ = _type_check_list;
				_tmp90_ = vala_list_get ((ValaList*) _tmp89_, _type_check_index);
				_tmp91_ = _vala_code_node_ref0 ((ValaTypeCheck*) _tmp90_);
				type_check = _tmp91_;
				_tmp92_ = type_check;
				_tmp93_ = vala_typecheck_get_type_reference (_tmp92_);
				_tmp94_ = _tmp93_;
				_tmp95_ = vala_data_type_get_type_symbol (_tmp94_);
				_tmp96_ = _tmp95_;
				narrowed_symnol = _tmp96_;
				_tmp97_ = variable;
				_tmp98_ = type_check;
				_tmp99_ = vala_typecheck_get_expression (_tmp98_);
				_tmp100_ = _tmp99_;
				_tmp101_ = vala_expression_get_symbol_reference (_tmp100_);
				_tmp102_ = _tmp101_;
				if (G_TYPE_CHECK_INSTANCE_CAST (_tmp97_, VALA_TYPE_SYMBOL, ValaSymbol) == _tmp102_) {
					ValaTypeSymbol* _tmp103_;
					ValaDataType* _tmp104_;
					ValaDataType* _tmp105_;
					ValaTypeSymbol* _tmp106_;
					ValaTypeSymbol* _tmp107_;
					ValaDataType* _tmp111_;
					ValaDataType* _tmp112_;
					_tmp103_ = narrowed_symnol;
					_tmp104_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp105_ = _tmp104_;
					_tmp106_ = vala_data_type_get_type_symbol (_tmp105_);
					_tmp107_ = _tmp106_;
					if (_tmp103_ != _tmp107_) {
						ValaDataType* _tmp108_;
						ValaDataType* _tmp109_;
						ValaTypeSymbol* _tmp110_;
						_tmp108_ = vala_expression_get_value_type ((ValaExpression*) self);
						_tmp109_ = _tmp108_;
						_tmp110_ = narrowed_symnol;
						vala_data_type_set_context_symbol (_tmp109_, (ValaSymbol*) _tmp110_);
					}
					_tmp111_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp112_ = _tmp111_;
					vala_data_type_set_nullable (_tmp112_, FALSE);
				}
				_vala_code_node_unref0 (type_check);
			}
		}
	}
	_vala_iterable_unref0 (scope_type_checks);
}

static void
vala_member_access_class_init (ValaMemberAccessClass * klass,
                               gpointer klass_data)
{
	vala_member_access_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_member_access_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMemberAccess_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept_children;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_member_access_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_member_access_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_member_access_real_is_accessible;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_member_access_real_replace_type;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_constant;
	((ValaExpressionClass *) klass)->is_non_null = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_non_null;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_member_access_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_member_access_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_member_access_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_used_variables;
}

static void
vala_member_access_instance_init (ValaMemberAccess * self,
                                  gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_member_access_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->type_argument_list = (ValaList*) _tmp1_;
}

static void
vala_member_access_finalize (ValaCodeNode * obj)
{
	ValaMemberAccess * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
	_g_free0 (self->priv->_member_name);
	_vala_code_node_unref0 (self->priv->_inner);
	_vala_iterable_unref0 (self->priv->type_argument_list);
	VALA_CODE_NODE_CLASS (vala_member_access_parent_class)->finalize (obj);
}

/**
 * Represents an access to a type member in the source code.
 */
static GType
vala_member_access_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaMemberAccessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_member_access_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMemberAccess), 0, (GInstanceInitFunc) vala_member_access_instance_init, NULL };
	GType vala_member_access_type_id;
	vala_member_access_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMemberAccess", &g_define_type_info, 0);
	ValaMemberAccess_private_offset = g_type_add_instance_private (vala_member_access_type_id, sizeof (ValaMemberAccessPrivate));
	return vala_member_access_type_id;
}

GType
vala_member_access_get_type (void)
{
	static volatile gsize vala_member_access_type_id__volatile = 0;
	if (g_once_init_enter (&vala_member_access_type_id__volatile)) {
		GType vala_member_access_type_id;
		vala_member_access_type_id = vala_member_access_get_type_once ();
		g_once_init_leave (&vala_member_access_type_id__volatile, vala_member_access_type_id);
	}
	return vala_member_access_type_id__volatile;
}

