/* valasignal.c generated by valac, the Vala compiler
 * generated from valasignal.vala, do not modify */

/* valasignal.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaSignalPrivate {
	gboolean _is_virtual;
	ValaList* parameters;
	ValaMethod* _default_handler;
	ValaMethod* _emitter;
	ValaDataType* _return_type;
	ValaBlock* _body;
};

static gint ValaSignal_private_offset;
static gpointer vala_signal_parent_class = NULL;
static ValaCallableIface * vala_signal_vala_callable_parent_iface = NULL;

static void vala_signal_set_default_handler (ValaSignal* self,
                                      ValaMethod* value);
static void vala_signal_set_emitter (ValaSignal* self,
                              ValaMethod* value);
static void vala_signal_real_add_parameter (ValaCallable* base,
                                     ValaParameter* param);
static ValaList* vala_signal_real_get_parameters (ValaCallable* base);
static void vala_signal_real_accept (ValaCodeNode* base,
                              ValaCodeVisitor* visitor);
static void vala_signal_real_accept_children (ValaCodeNode* base,
                                       ValaCodeVisitor* visitor);
static void vala_signal_real_replace_type (ValaCodeNode* base,
                                    ValaDataType* old_type,
                                    ValaDataType* new_type);
static gboolean vala_signal_real_check (ValaCodeNode* base,
                                 ValaCodeContext* context);
static void vala_signal_finalize (ValaCodeNode * obj);
static GType vala_signal_get_type_once (void);

static inline gpointer
vala_signal_get_instance_private (ValaSignal* self)
{
	return G_STRUCT_MEMBER_P (self, ValaSignal_private_offset);
}

static ValaDataType*
vala_signal_real_get_return_type (ValaCallable* base)
{
	ValaDataType* result;
	ValaSignal* self;
	ValaDataType* _tmp0_;
	self = (ValaSignal*) base;
	_tmp0_ = self->priv->_return_type;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static void
vala_signal_real_set_return_type (ValaCallable* base,
                                  ValaDataType* value)
{
	ValaSignal* self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaSignal*) base;
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_return_type);
	self->priv->_return_type = _tmp0_;
	_tmp1_ = self->priv->_return_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

ValaBlock*
vala_signal_get_body (ValaSignal* self)
{
	ValaBlock* result;
	ValaBlock* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_body;
	result = _tmp0_;
	return result;
}

void
vala_signal_set_body (ValaSignal* self,
                      ValaBlock* value)
{
	ValaBlock* _tmp0_;
	ValaBlock* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_body);
	self->priv->_body = _tmp0_;
	_tmp1_ = self->priv->_body;
	if (_tmp1_ != NULL) {
		ValaBlock* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_body;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

gboolean
vala_signal_get_is_virtual (ValaSignal* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_virtual;
	return result;
}

void
vala_signal_set_is_virtual (ValaSignal* self,
                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_virtual = value;
}

ValaMethod*
vala_signal_get_default_handler (ValaSignal* self)
{
	ValaMethod* result;
	ValaMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_default_handler;
	result = _tmp0_;
	return result;
}

static void
vala_signal_set_default_handler (ValaSignal* self,
                                 ValaMethod* value)
{
	ValaMethod* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_default_handler);
	self->priv->_default_handler = _tmp0_;
}

ValaMethod*
vala_signal_get_emitter (ValaSignal* self)
{
	ValaMethod* result;
	ValaMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_emitter;
	result = _tmp0_;
	return result;
}

static void
vala_signal_set_emitter (ValaSignal* self,
                         ValaMethod* value)
{
	ValaMethod* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_emitter);
	self->priv->_emitter = _tmp0_;
}

/**
 * Creates a new signal.
 *
 * @param name              signal name
 * @param return_type       signal return type
 * @param source_reference  reference to source code
 * @return                  newly created signal
 */
ValaSignal*
vala_signal_construct (GType object_type,
                       const gchar* name,
                       ValaDataType* return_type,
                       ValaSourceReference* source_reference,
                       ValaComment* comment)
{
	ValaSignal* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (return_type != NULL, NULL);
	self = (ValaSignal*) vala_symbol_construct (object_type, name, source_reference, comment);
	vala_callable_set_return_type ((ValaCallable*) self, return_type);
	return self;
}

ValaSignal*
vala_signal_new (const gchar* name,
                 ValaDataType* return_type,
                 ValaSourceReference* source_reference,
                 ValaComment* comment)
{
	return vala_signal_construct (VALA_TYPE_SIGNAL, name, return_type, source_reference, comment);
}

/**
 * Appends parameter to signal handler.
 *
 * @param param a formal parameter
 */
static void
vala_signal_real_add_parameter (ValaCallable* base,
                                ValaParameter* param)
{
	ValaSignal * self;
	ValaList* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	self = (ValaSignal*) base;
	g_return_if_fail (param != NULL);
	_tmp0_ = self->priv->parameters;
	vala_collection_add ((ValaCollection*) _tmp0_, param);
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) param);
	_tmp4_ = _tmp3_;
	vala_scope_add (_tmp2_, _tmp4_, (ValaSymbol*) param);
}

static ValaList*
vala_signal_real_get_parameters (ValaCallable* base)
{
	ValaSignal * self;
	ValaList* _tmp0_;
	ValaList* result = NULL;
	self = (ValaSignal*) base;
	_tmp0_ = self->priv->parameters;
	result = _tmp0_;
	return result;
}

/**
 * Returns generated delegate to be used for signal handlers.
 *
 * @return delegate
 */
ValaDelegate*
vala_signal_get_delegate (ValaSignal* self,
                          ValaDataType* sender_type,
                          ValaCodeNode* node_reference)
{
	ValaDataType* actual_return_type = NULL;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDelegate* generated_delegate = NULL;
	ValaDataType* _tmp3_;
	ValaDelegate* _tmp4_;
	ValaDelegate* _tmp5_;
	ValaDelegate* _tmp6_;
	ValaScope* _tmp7_;
	ValaScope* _tmp8_;
	ValaDataType* sender_param_type = NULL;
	ValaDataType* _tmp9_;
	ValaDataType* _tmp10_;
	ValaDataType* _tmp11_;
	ValaDelegate* _tmp12_;
	ValaDataType* _tmp13_;
	gboolean is_generic = FALSE;
	ValaScope* _tmp85_;
	ValaScope* _tmp86_;
	ValaDelegate* _tmp87_;
	ValaDelegate* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sender_type != NULL, NULL);
	g_return_val_if_fail (node_reference != NULL, NULL);
	_tmp0_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_data_type_get_actual_type (_tmp1_, sender_type, NULL, node_reference);
	actual_return_type = _tmp2_;
	_tmp3_ = actual_return_type;
	_tmp4_ = vala_delegate_new (NULL, _tmp3_, NULL, NULL);
	generated_delegate = _tmp4_;
	_tmp5_ = generated_delegate;
	vala_symbol_set_access ((ValaSymbol*) _tmp5_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp6_ = generated_delegate;
	_tmp7_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp8_ = _tmp7_;
	vala_symbol_set_owner ((ValaSymbol*) _tmp6_, _tmp8_);
	_tmp9_ = vala_data_type_copy (sender_type);
	sender_param_type = _tmp9_;
	_tmp10_ = sender_param_type;
	vala_data_type_set_value_owned (_tmp10_, FALSE);
	_tmp11_ = sender_param_type;
	vala_data_type_set_nullable (_tmp11_, FALSE);
	_tmp12_ = generated_delegate;
	_tmp13_ = sender_param_type;
	vala_delegate_set_sender_type (_tmp12_, _tmp13_);
	is_generic = FALSE;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp14_;
		gint _param_size = 0;
		ValaList* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gint _param_index = 0;
		_tmp14_ = self->priv->parameters;
		_param_list = _tmp14_;
		_tmp15_ = _param_list;
		_tmp16_ = vala_collection_get_size ((ValaCollection*) _tmp15_);
		_tmp17_ = _tmp16_;
		_param_size = _tmp17_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp18_;
			gint _tmp19_;
			ValaParameter* param = NULL;
			ValaList* _tmp20_;
			gpointer _tmp21_;
			ValaParameter* actual_param = NULL;
			ValaParameter* _tmp22_;
			ValaParameter* _tmp23_;
			ValaParameter* _tmp24_;
			ValaParameter* _tmp25_;
			ValaDataType* _tmp26_;
			ValaDataType* _tmp27_;
			ValaDataType* _tmp28_;
			ValaDataType* _tmp29_;
			ValaDelegate* _tmp30_;
			ValaParameter* _tmp31_;
			ValaParameter* _tmp32_;
			ValaDataType* _tmp33_;
			ValaDataType* _tmp34_;
			_param_index = _param_index + 1;
			_tmp18_ = _param_index;
			_tmp19_ = _param_size;
			if (!(_tmp18_ < _tmp19_)) {
				break;
			}
			_tmp20_ = _param_list;
			_tmp21_ = vala_list_get (_tmp20_, _param_index);
			param = (ValaParameter*) _tmp21_;
			_tmp22_ = param;
			_tmp23_ = vala_parameter_copy (_tmp22_);
			actual_param = _tmp23_;
			_tmp24_ = actual_param;
			_tmp25_ = actual_param;
			_tmp26_ = vala_variable_get_variable_type ((ValaVariable*) _tmp25_);
			_tmp27_ = _tmp26_;
			_tmp28_ = vala_data_type_get_actual_type (_tmp27_, sender_type, NULL, node_reference);
			_tmp29_ = _tmp28_;
			vala_variable_set_variable_type ((ValaVariable*) _tmp24_, _tmp29_);
			_vala_code_node_unref0 (_tmp29_);
			_tmp30_ = generated_delegate;
			_tmp31_ = actual_param;
			vala_callable_add_parameter ((ValaCallable*) _tmp30_, _tmp31_);
			_tmp32_ = actual_param;
			_tmp33_ = vala_variable_get_variable_type ((ValaVariable*) _tmp32_);
			_tmp34_ = _tmp33_;
			if (vala_data_type_is_generic (_tmp34_)) {
				is_generic = TRUE;
			}
			_vala_code_node_unref0 (actual_param);
			_vala_code_node_unref0 (param);
		}
	}
	if (is_generic) {
		ValaObjectTypeSymbol* cl = NULL;
		ValaSymbol* _tmp35_;
		ValaSymbol* _tmp36_;
		_tmp35_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp36_ = _tmp35_;
		cl = G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol);
		{
			ValaList* _type_param_list = NULL;
			ValaObjectTypeSymbol* _tmp37_;
			ValaList* _tmp38_;
			gint _type_param_size = 0;
			ValaList* _tmp39_;
			gint _tmp40_;
			gint _tmp41_;
			gint _type_param_index = 0;
			_tmp37_ = cl;
			_tmp38_ = vala_object_type_symbol_get_type_parameters (_tmp37_);
			_type_param_list = _tmp38_;
			_tmp39_ = _type_param_list;
			_tmp40_ = vala_collection_get_size ((ValaCollection*) _tmp39_);
			_tmp41_ = _tmp40_;
			_type_param_size = _tmp41_;
			_type_param_index = -1;
			while (TRUE) {
				gint _tmp42_;
				gint _tmp43_;
				ValaTypeParameter* type_param = NULL;
				ValaList* _tmp44_;
				gpointer _tmp45_;
				ValaDelegate* _tmp46_;
				ValaTypeParameter* _tmp47_;
				const gchar* _tmp48_;
				const gchar* _tmp49_;
				ValaTypeParameter* _tmp50_;
				ValaSourceReference* _tmp51_;
				ValaSourceReference* _tmp52_;
				ValaTypeParameter* _tmp53_;
				ValaTypeParameter* _tmp54_;
				_type_param_index = _type_param_index + 1;
				_tmp42_ = _type_param_index;
				_tmp43_ = _type_param_size;
				if (!(_tmp42_ < _tmp43_)) {
					break;
				}
				_tmp44_ = _type_param_list;
				_tmp45_ = vala_list_get (_tmp44_, _type_param_index);
				type_param = (ValaTypeParameter*) _tmp45_;
				_tmp46_ = generated_delegate;
				_tmp47_ = type_param;
				_tmp48_ = vala_symbol_get_name ((ValaSymbol*) _tmp47_);
				_tmp49_ = _tmp48_;
				_tmp50_ = type_param;
				_tmp51_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp50_);
				_tmp52_ = _tmp51_;
				_tmp53_ = vala_typeparameter_new (_tmp49_, _tmp52_);
				_tmp54_ = _tmp53_;
				vala_delegate_add_type_parameter (_tmp46_, _tmp54_);
				_vala_code_node_unref0 (_tmp54_);
				_vala_code_node_unref0 (type_param);
			}
		}
		{
			ValaList* _param_list = NULL;
			ValaDelegate* _tmp55_;
			ValaList* _tmp56_;
			gint _param_size = 0;
			ValaList* _tmp57_;
			gint _tmp58_;
			gint _tmp59_;
			gint _param_index = 0;
			_tmp55_ = generated_delegate;
			_tmp56_ = vala_callable_get_parameters ((ValaCallable*) _tmp55_);
			_param_list = _tmp56_;
			_tmp57_ = _param_list;
			_tmp58_ = vala_collection_get_size ((ValaCollection*) _tmp57_);
			_tmp59_ = _tmp58_;
			_param_size = _tmp59_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp60_;
				gint _tmp61_;
				ValaParameter* param = NULL;
				ValaList* _tmp62_;
				gpointer _tmp63_;
				_param_index = _param_index + 1;
				_tmp60_ = _param_index;
				_tmp61_ = _param_size;
				if (!(_tmp60_ < _tmp61_)) {
					break;
				}
				_tmp62_ = _param_list;
				_tmp63_ = vala_list_get (_tmp62_, _param_index);
				param = (ValaParameter*) _tmp63_;
				{
					ValaList* _type_param_list = NULL;
					ValaDelegate* _tmp64_;
					ValaList* _tmp65_;
					gint _type_param_size = 0;
					ValaList* _tmp66_;
					gint _tmp67_;
					gint _tmp68_;
					gint _type_param_index = 0;
					_tmp64_ = generated_delegate;
					_tmp65_ = vala_delegate_get_type_parameters (_tmp64_);
					_type_param_list = _tmp65_;
					_tmp66_ = _type_param_list;
					_tmp67_ = vala_collection_get_size ((ValaCollection*) _tmp66_);
					_tmp68_ = _tmp67_;
					_type_param_size = _tmp68_;
					_type_param_index = -1;
					while (TRUE) {
						gint _tmp69_;
						gint _tmp70_;
						ValaTypeParameter* type_param = NULL;
						ValaList* _tmp71_;
						gpointer _tmp72_;
						ValaParameter* _tmp73_;
						ValaDataType* _tmp74_;
						ValaDataType* _tmp75_;
						ValaObjectTypeSymbol* _tmp76_;
						ValaList* _tmp77_;
						ValaObjectTypeSymbol* _tmp78_;
						ValaTypeParameter* _tmp79_;
						const gchar* _tmp80_;
						const gchar* _tmp81_;
						gpointer _tmp82_;
						ValaTypeParameter* _tmp83_;
						ValaTypeParameter* _tmp84_;
						_type_param_index = _type_param_index + 1;
						_tmp69_ = _type_param_index;
						_tmp70_ = _type_param_size;
						if (!(_tmp69_ < _tmp70_)) {
							break;
						}
						_tmp71_ = _type_param_list;
						_tmp72_ = vala_list_get (_tmp71_, _type_param_index);
						type_param = (ValaTypeParameter*) _tmp72_;
						_tmp73_ = param;
						_tmp74_ = vala_variable_get_variable_type ((ValaVariable*) _tmp73_);
						_tmp75_ = _tmp74_;
						_tmp76_ = cl;
						_tmp77_ = vala_object_type_symbol_get_type_parameters (_tmp76_);
						_tmp78_ = cl;
						_tmp79_ = type_param;
						_tmp80_ = vala_symbol_get_name ((ValaSymbol*) _tmp79_);
						_tmp81_ = _tmp80_;
						_tmp82_ = vala_list_get (_tmp77_, vala_typesymbol_get_type_parameter_index ((ValaTypeSymbol*) _tmp78_, _tmp81_));
						_tmp83_ = (ValaTypeParameter*) _tmp82_;
						_tmp84_ = type_param;
						vala_data_type_replace_type_parameter (_tmp75_, _tmp83_, _tmp84_);
						_vala_code_node_unref0 (_tmp83_);
						_vala_code_node_unref0 (type_param);
					}
				}
				_vala_code_node_unref0 (param);
			}
		}
	}
	_tmp85_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp86_ = _tmp85_;
	_tmp87_ = generated_delegate;
	vala_scope_add (_tmp86_, NULL, (ValaSymbol*) _tmp87_);
	result = generated_delegate;
	_vala_code_node_unref0 (sender_param_type);
	_vala_code_node_unref0 (actual_return_type);
	return result;
}

static void
vala_signal_real_accept (ValaCodeNode* base,
                         ValaCodeVisitor* visitor)
{
	ValaSignal * self;
	self = (ValaSignal*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_signal (visitor, self);
}

static void
vala_signal_real_accept_children (ValaCodeNode* base,
                                  ValaCodeVisitor* visitor)
{
	ValaSignal * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	gboolean _tmp11_ = FALSE;
	ValaMethod* _tmp12_;
	ValaMethod* _tmp19_;
	self = (ValaSignal*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp2_;
		gint _param_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _param_index = 0;
		_tmp2_ = self->priv->parameters;
		_param_list = _tmp2_;
		_tmp3_ = _param_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_param_size = _tmp5_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			ValaParameter* param = NULL;
			ValaList* _tmp8_;
			gpointer _tmp9_;
			ValaParameter* _tmp10_;
			_param_index = _param_index + 1;
			_tmp6_ = _param_index;
			_tmp7_ = _param_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _param_list;
			_tmp9_ = vala_list_get (_tmp8_, _param_index);
			param = (ValaParameter*) _tmp9_;
			_tmp10_ = param;
			vala_code_node_accept ((ValaCodeNode*) _tmp10_, visitor);
			_vala_code_node_unref0 (param);
		}
	}
	_tmp12_ = self->priv->_default_handler;
	if (_tmp12_ == NULL) {
		ValaBlock* _tmp13_;
		ValaBlock* _tmp14_;
		_tmp13_ = vala_signal_get_body (self);
		_tmp14_ = _tmp13_;
		_tmp11_ = _tmp14_ != NULL;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		ValaBlock* _tmp15_;
		ValaBlock* _tmp16_;
		_tmp15_ = vala_signal_get_body (self);
		_tmp16_ = _tmp15_;
		vala_code_node_accept ((ValaCodeNode*) _tmp16_, visitor);
	} else {
		ValaMethod* _tmp17_;
		_tmp17_ = self->priv->_default_handler;
		if (_tmp17_ != NULL) {
			ValaMethod* _tmp18_;
			_tmp18_ = self->priv->_default_handler;
			vala_code_node_accept ((ValaCodeNode*) _tmp18_, visitor);
		}
	}
	_tmp19_ = self->priv->_emitter;
	if (_tmp19_ != NULL) {
		ValaMethod* _tmp20_;
		_tmp20_ = self->priv->_emitter;
		vala_code_node_accept ((ValaCodeNode*) _tmp20_, visitor);
	}
}

static void
vala_signal_real_replace_type (ValaCodeNode* base,
                               ValaDataType* old_type,
                               ValaDataType* new_type)
{
	ValaSignal * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaSignal*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_callable_set_return_type ((ValaCallable*) self, new_type);
	}
}

static gboolean
vala_signal_real_check (ValaCodeNode* base,
                        ValaCodeContext* context)
{
	ValaSignal * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaClass* parent_cl = NULL;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	gboolean _tmp6_ = FALSE;
	ValaClass* _tmp7_;
	ValaClass* _tmp13_;
	ValaDataType* _tmp35_;
	ValaDataType* _tmp36_;
	ValaDataType* _tmp37_;
	ValaDataType* _tmp38_;
	ValaTypeSymbol* _tmp39_;
	ValaTypeSymbol* _tmp40_;
	ValaSemanticAnalyzer* _tmp41_;
	ValaSemanticAnalyzer* _tmp42_;
	ValaDataType* _tmp43_;
	ValaTypeSymbol* _tmp44_;
	ValaTypeSymbol* _tmp45_;
	gboolean _tmp69_ = FALSE;
	ValaBlock* _tmp70_;
	ValaBlock* _tmp71_;
	ValaAttribute* _tmp119_;
	gboolean _tmp188_ = FALSE;
	gboolean _tmp189_ = FALSE;
	gboolean _tmp190_;
	gboolean _tmp191_;
	gboolean _tmp204_;
	gboolean _tmp205_;
	gboolean result = FALSE;
	self = (ValaSignal*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp5_ = _tmp4_;
	parent_cl = VALA_IS_CLASS (_tmp5_) ? ((ValaClass*) _tmp5_) : NULL;
	_tmp7_ = parent_cl;
	if (_tmp7_ != NULL) {
		ValaClass* _tmp8_;
		gboolean _tmp9_;
		gboolean _tmp10_;
		_tmp8_ = parent_cl;
		_tmp9_ = vala_class_get_is_compact (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp6_ = _tmp10_;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		ValaSourceReference* _tmp11_;
		ValaSourceReference* _tmp12_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp11_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp12_ = _tmp11_;
		vala_report_error (_tmp12_, "Signals are not supported in compact classes");
		result = FALSE;
		return result;
	}
	_tmp13_ = parent_cl;
	if (_tmp13_ != NULL) {
		{
			ValaList* _base_type_list = NULL;
			ValaClass* _tmp14_;
			ValaList* _tmp15_;
			gint _base_type_size = 0;
			ValaList* _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			gint _base_type_index = 0;
			_tmp14_ = parent_cl;
			_tmp15_ = vala_class_get_base_types (_tmp14_);
			_base_type_list = _tmp15_;
			_tmp16_ = _base_type_list;
			_tmp17_ = vala_collection_get_size ((ValaCollection*) _tmp16_);
			_tmp18_ = _tmp17_;
			_base_type_size = _tmp18_;
			_base_type_index = -1;
			while (TRUE) {
				gint _tmp19_;
				gint _tmp20_;
				ValaDataType* base_type = NULL;
				ValaList* _tmp21_;
				gpointer _tmp22_;
				ValaDataType* _tmp23_;
				ValaTypeSymbol* _tmp24_;
				ValaTypeSymbol* _tmp25_;
				const gchar* _tmp26_;
				const gchar* _tmp27_;
				ValaSymbol* _tmp28_;
				ValaSymbol* _tmp29_;
				gboolean _tmp30_;
				_base_type_index = _base_type_index + 1;
				_tmp19_ = _base_type_index;
				_tmp20_ = _base_type_size;
				if (!(_tmp19_ < _tmp20_)) {
					break;
				}
				_tmp21_ = _base_type_list;
				_tmp22_ = vala_list_get (_tmp21_, _base_type_index);
				base_type = (ValaDataType*) _tmp22_;
				_tmp23_ = base_type;
				_tmp24_ = vala_data_type_get_type_symbol (_tmp23_);
				_tmp25_ = _tmp24_;
				_tmp26_ = vala_symbol_get_name ((ValaSymbol*) self);
				_tmp27_ = _tmp26_;
				_tmp28_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) _tmp25_, _tmp27_);
				_tmp29_ = _tmp28_;
				_tmp30_ = VALA_IS_SIGNAL (_tmp29_);
				_vala_code_node_unref0 (_tmp29_);
				if (_tmp30_) {
					ValaSourceReference* _tmp31_;
					ValaSourceReference* _tmp32_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp31_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp32_ = _tmp31_;
					vala_report_error (_tmp32_, "Signals with the same name as a signal in a base type are not supporte" \
"d");
					result = FALSE;
					_vala_code_node_unref0 (base_type);
					return result;
				}
				_vala_code_node_unref0 (base_type);
			}
		}
	}
	if (VALA_IS_DYNAMIC_SIGNAL (self)) {
		gboolean _tmp33_;
		gboolean _tmp34_;
		_tmp33_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp34_ = _tmp33_;
		result = !_tmp34_;
		return result;
	}
	_tmp35_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp36_ = _tmp35_;
	vala_code_node_check ((ValaCodeNode*) _tmp36_, context);
	_tmp37_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp38_ = _tmp37_;
	_tmp39_ = vala_data_type_get_type_symbol (_tmp38_);
	_tmp40_ = _tmp39_;
	_tmp41_ = vala_code_context_get_analyzer (context);
	_tmp42_ = _tmp41_;
	_tmp43_ = _tmp42_->va_list_type;
	_tmp44_ = vala_data_type_get_type_symbol (_tmp43_);
	_tmp45_ = _tmp44_;
	if (_tmp40_ == _tmp45_) {
		ValaSourceReference* _tmp46_;
		ValaSourceReference* _tmp47_;
		ValaDataType* _tmp48_;
		ValaDataType* _tmp49_;
		ValaTypeSymbol* _tmp50_;
		ValaTypeSymbol* _tmp51_;
		gchar* _tmp52_;
		gchar* _tmp53_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp46_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp47_ = _tmp46_;
		_tmp48_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp49_ = _tmp48_;
		_tmp50_ = vala_data_type_get_type_symbol (_tmp49_);
		_tmp51_ = _tmp50_;
		_tmp52_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp51_);
		_tmp53_ = _tmp52_;
		vala_report_error (_tmp47_, "`%s' not supported as return type", _tmp53_);
		_g_free0 (_tmp53_);
		result = FALSE;
		return result;
	}
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp54_;
		gint _param_size = 0;
		ValaList* _tmp55_;
		gint _tmp56_;
		gint _tmp57_;
		gint _param_index = 0;
		_tmp54_ = self->priv->parameters;
		_param_list = _tmp54_;
		_tmp55_ = _param_list;
		_tmp56_ = vala_collection_get_size ((ValaCollection*) _tmp55_);
		_tmp57_ = _tmp56_;
		_param_size = _tmp57_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp58_;
			gint _tmp59_;
			ValaParameter* param = NULL;
			ValaList* _tmp60_;
			gpointer _tmp61_;
			ValaParameter* _tmp62_;
			gboolean _tmp63_;
			gboolean _tmp64_;
			ValaParameter* _tmp68_;
			_param_index = _param_index + 1;
			_tmp58_ = _param_index;
			_tmp59_ = _param_size;
			if (!(_tmp58_ < _tmp59_)) {
				break;
			}
			_tmp60_ = _param_list;
			_tmp61_ = vala_list_get (_tmp60_, _param_index);
			param = (ValaParameter*) _tmp61_;
			_tmp62_ = param;
			_tmp63_ = vala_parameter_get_ellipsis (_tmp62_);
			_tmp64_ = _tmp63_;
			if (_tmp64_) {
				ValaParameter* _tmp65_;
				ValaSourceReference* _tmp66_;
				ValaSourceReference* _tmp67_;
				_tmp65_ = param;
				_tmp66_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp65_);
				_tmp67_ = _tmp66_;
				vala_report_error (_tmp67_, "Signals with variable argument lists are not supported");
				result = FALSE;
				_vala_code_node_unref0 (param);
				return result;
			}
			_tmp68_ = param;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp68_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			_vala_code_node_unref0 (param);
		}
	}
	_tmp70_ = vala_signal_get_body (self);
	_tmp71_ = _tmp70_;
	if (_tmp71_ != NULL) {
		_tmp69_ = TRUE;
	} else {
		gboolean _tmp72_ = FALSE;
		gboolean _tmp73_;
		_tmp73_ = self->priv->_is_virtual;
		if (_tmp73_) {
			gboolean _tmp74_;
			gboolean _tmp75_;
			_tmp74_ = vala_symbol_get_external_package ((ValaSymbol*) self);
			_tmp75_ = _tmp74_;
			_tmp72_ = _tmp75_;
		} else {
			_tmp72_ = FALSE;
		}
		_tmp69_ = _tmp72_;
	}
	if (_tmp69_) {
		const gchar* _tmp76_;
		const gchar* _tmp77_;
		ValaDataType* _tmp78_;
		ValaDataType* _tmp79_;
		ValaSourceReference* _tmp80_;
		ValaSourceReference* _tmp81_;
		ValaMethod* _tmp82_;
		ValaMethod* _tmp83_;
		ValaMethod* _tmp84_;
		ValaScope* _tmp85_;
		ValaScope* _tmp86_;
		ValaSymbolAccessibility _tmp87_ = 0;
		gboolean _tmp88_;
		ValaMethod* _tmp91_;
		ValaMethod* _tmp92_;
		gboolean _tmp93_;
		gboolean _tmp94_;
		ValaMethod* _tmp95_;
		gboolean _tmp96_;
		gboolean _tmp97_;
		ValaMethod* _tmp98_;
		gboolean _tmp99_;
		ValaMethod* _tmp100_;
		ValaMethod* _tmp101_;
		ValaBlock* _tmp102_;
		ValaBlock* _tmp103_;
		ValaObjectTypeSymbol* cl = NULL;
		ValaSymbol* _tmp114_;
		ValaSymbol* _tmp115_;
		ValaObjectTypeSymbol* _tmp116_;
		ValaMethod* _tmp117_;
		ValaMethod* _tmp118_;
		_tmp76_ = vala_symbol_get_name ((ValaSymbol*) self);
		_tmp77_ = _tmp76_;
		_tmp78_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp79_ = _tmp78_;
		_tmp80_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp81_ = _tmp80_;
		_tmp82_ = vala_method_new (_tmp77_, _tmp79_, _tmp81_, NULL);
		_tmp83_ = _tmp82_;
		vala_signal_set_default_handler (self, _tmp83_);
		_vala_code_node_unref0 (_tmp83_);
		_tmp84_ = self->priv->_default_handler;
		_tmp85_ = vala_symbol_get_owner ((ValaSymbol*) self);
		_tmp86_ = _tmp85_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp84_, _tmp86_);
		_tmp88_ = self->priv->_is_virtual;
		if (_tmp88_) {
			ValaSymbolAccessibility _tmp89_;
			ValaSymbolAccessibility _tmp90_;
			_tmp89_ = vala_symbol_get_access ((ValaSymbol*) self);
			_tmp90_ = _tmp89_;
			_tmp87_ = _tmp90_;
		} else {
			_tmp87_ = VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
		}
		_tmp91_ = self->priv->_default_handler;
		vala_symbol_set_access ((ValaSymbol*) _tmp91_, _tmp87_);
		_tmp92_ = self->priv->_default_handler;
		_tmp93_ = vala_symbol_get_external ((ValaSymbol*) self);
		_tmp94_ = _tmp93_;
		vala_symbol_set_external ((ValaSymbol*) _tmp92_, _tmp94_);
		_tmp95_ = self->priv->_default_handler;
		_tmp96_ = vala_symbol_get_hides ((ValaSymbol*) self);
		_tmp97_ = _tmp96_;
		vala_symbol_set_hides ((ValaSymbol*) _tmp95_, _tmp97_);
		_tmp98_ = self->priv->_default_handler;
		_tmp99_ = self->priv->_is_virtual;
		vala_method_set_is_virtual (_tmp98_, _tmp99_);
		_tmp100_ = self->priv->_default_handler;
		vala_method_set_signal_reference (_tmp100_, self);
		_tmp101_ = self->priv->_default_handler;
		_tmp102_ = vala_signal_get_body (self);
		_tmp103_ = _tmp102_;
		vala_subroutine_set_body ((ValaSubroutine*) _tmp101_, _tmp103_);
		{
			ValaList* _param_list = NULL;
			ValaList* _tmp104_;
			gint _param_size = 0;
			ValaList* _tmp105_;
			gint _tmp106_;
			gint _tmp107_;
			gint _param_index = 0;
			_tmp104_ = self->priv->parameters;
			_param_list = _tmp104_;
			_tmp105_ = _param_list;
			_tmp106_ = vala_collection_get_size ((ValaCollection*) _tmp105_);
			_tmp107_ = _tmp106_;
			_param_size = _tmp107_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp108_;
				gint _tmp109_;
				ValaParameter* param = NULL;
				ValaList* _tmp110_;
				gpointer _tmp111_;
				ValaMethod* _tmp112_;
				ValaParameter* _tmp113_;
				_param_index = _param_index + 1;
				_tmp108_ = _param_index;
				_tmp109_ = _param_size;
				if (!(_tmp108_ < _tmp109_)) {
					break;
				}
				_tmp110_ = _param_list;
				_tmp111_ = vala_list_get (_tmp110_, _param_index);
				param = (ValaParameter*) _tmp111_;
				_tmp112_ = self->priv->_default_handler;
				_tmp113_ = param;
				vala_callable_add_parameter ((ValaCallable*) _tmp112_, _tmp113_);
				_vala_code_node_unref0 (param);
			}
		}
		_tmp114_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp115_ = _tmp114_;
		cl = VALA_IS_OBJECT_TYPE_SYMBOL (_tmp115_) ? ((ValaObjectTypeSymbol*) _tmp115_) : NULL;
		_tmp116_ = cl;
		_tmp117_ = self->priv->_default_handler;
		vala_object_type_symbol_add_hidden_method (_tmp116_, _tmp117_);
		_tmp118_ = self->priv->_default_handler;
		vala_code_node_check ((ValaCodeNode*) _tmp118_, context);
	}
	_tmp119_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "HasEmitter");
	if (_tmp119_ != NULL) {
		const gchar* _tmp120_;
		const gchar* _tmp121_;
		ValaDataType* _tmp122_;
		ValaDataType* _tmp123_;
		ValaSourceReference* _tmp124_;
		ValaSourceReference* _tmp125_;
		ValaMethod* _tmp126_;
		ValaMethod* _tmp127_;
		ValaMethod* _tmp128_;
		ValaScope* _tmp129_;
		ValaScope* _tmp130_;
		ValaMethod* _tmp131_;
		ValaSymbolAccessibility _tmp132_;
		ValaSymbolAccessibility _tmp133_;
		ValaBlock* body = NULL;
		ValaSourceReference* _tmp134_;
		ValaSourceReference* _tmp135_;
		ValaBlock* _tmp136_;
		ValaMethodCall* call = NULL;
		const gchar* _tmp137_;
		const gchar* _tmp138_;
		ValaSourceReference* _tmp139_;
		ValaSourceReference* _tmp140_;
		ValaMemberAccess* _tmp141_;
		ValaMemberAccess* _tmp142_;
		ValaSourceReference* _tmp143_;
		ValaSourceReference* _tmp144_;
		ValaMethodCall* _tmp145_;
		ValaMethodCall* _tmp146_;
		ValaDataType* _tmp165_;
		ValaDataType* _tmp166_;
		ValaMethod* _tmp179_;
		ValaBlock* _tmp180_;
		ValaObjectTypeSymbol* cl = NULL;
		ValaSymbol* _tmp181_;
		ValaSymbol* _tmp182_;
		ValaObjectTypeSymbol* _tmp183_;
		ValaMethod* _tmp184_;
		gboolean _tmp185_;
		gboolean _tmp186_;
		_tmp120_ = vala_symbol_get_name ((ValaSymbol*) self);
		_tmp121_ = _tmp120_;
		_tmp122_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp123_ = _tmp122_;
		_tmp124_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp125_ = _tmp124_;
		_tmp126_ = vala_method_new (_tmp121_, _tmp123_, _tmp125_, NULL);
		_tmp127_ = _tmp126_;
		vala_signal_set_emitter (self, _tmp127_);
		_vala_code_node_unref0 (_tmp127_);
		_tmp128_ = self->priv->_emitter;
		_tmp129_ = vala_symbol_get_owner ((ValaSymbol*) self);
		_tmp130_ = _tmp129_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp128_, _tmp130_);
		_tmp131_ = self->priv->_emitter;
		_tmp132_ = vala_symbol_get_access ((ValaSymbol*) self);
		_tmp133_ = _tmp132_;
		vala_symbol_set_access ((ValaSymbol*) _tmp131_, _tmp133_);
		_tmp134_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp135_ = _tmp134_;
		_tmp136_ = vala_block_new (_tmp135_);
		body = _tmp136_;
		_tmp137_ = vala_symbol_get_name ((ValaSymbol*) self);
		_tmp138_ = _tmp137_;
		_tmp139_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp140_ = _tmp139_;
		_tmp141_ = vala_member_access_new_simple (_tmp138_, _tmp140_);
		_tmp142_ = _tmp141_;
		_tmp143_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp144_ = _tmp143_;
		_tmp145_ = vala_method_call_new ((ValaExpression*) _tmp142_, _tmp144_);
		_tmp146_ = _tmp145_;
		_vala_code_node_unref0 (_tmp142_);
		call = _tmp146_;
		{
			ValaList* _param_list = NULL;
			ValaList* _tmp147_;
			gint _param_size = 0;
			ValaList* _tmp148_;
			gint _tmp149_;
			gint _tmp150_;
			gint _param_index = 0;
			_tmp147_ = self->priv->parameters;
			_param_list = _tmp147_;
			_tmp148_ = _param_list;
			_tmp149_ = vala_collection_get_size ((ValaCollection*) _tmp148_);
			_tmp150_ = _tmp149_;
			_param_size = _tmp150_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp151_;
				gint _tmp152_;
				ValaParameter* param = NULL;
				ValaList* _tmp153_;
				gpointer _tmp154_;
				ValaMethod* _tmp155_;
				ValaParameter* _tmp156_;
				ValaMethodCall* _tmp157_;
				ValaParameter* _tmp158_;
				const gchar* _tmp159_;
				const gchar* _tmp160_;
				ValaSourceReference* _tmp161_;
				ValaSourceReference* _tmp162_;
				ValaMemberAccess* _tmp163_;
				ValaMemberAccess* _tmp164_;
				_param_index = _param_index + 1;
				_tmp151_ = _param_index;
				_tmp152_ = _param_size;
				if (!(_tmp151_ < _tmp152_)) {
					break;
				}
				_tmp153_ = _param_list;
				_tmp154_ = vala_list_get (_tmp153_, _param_index);
				param = (ValaParameter*) _tmp154_;
				_tmp155_ = self->priv->_emitter;
				_tmp156_ = param;
				vala_callable_add_parameter ((ValaCallable*) _tmp155_, _tmp156_);
				_tmp157_ = call;
				_tmp158_ = param;
				_tmp159_ = vala_symbol_get_name ((ValaSymbol*) _tmp158_);
				_tmp160_ = _tmp159_;
				_tmp161_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp162_ = _tmp161_;
				_tmp163_ = vala_member_access_new_simple (_tmp160_, _tmp162_);
				_tmp164_ = _tmp163_;
				vala_callable_expression_add_argument ((ValaCallableExpression*) _tmp157_, (ValaExpression*) _tmp164_);
				_vala_code_node_unref0 (_tmp164_);
				_vala_code_node_unref0 (param);
			}
		}
		_tmp165_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp166_ = _tmp165_;
		if (VALA_IS_VOID_TYPE (_tmp166_)) {
			ValaBlock* _tmp167_;
			ValaMethodCall* _tmp168_;
			ValaSourceReference* _tmp169_;
			ValaSourceReference* _tmp170_;
			ValaExpressionStatement* _tmp171_;
			ValaExpressionStatement* _tmp172_;
			_tmp167_ = body;
			_tmp168_ = call;
			_tmp169_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp170_ = _tmp169_;
			_tmp171_ = vala_expression_statement_new ((ValaExpression*) _tmp168_, _tmp170_);
			_tmp172_ = _tmp171_;
			vala_block_add_statement (_tmp167_, (ValaStatement*) _tmp172_);
			_vala_code_node_unref0 (_tmp172_);
		} else {
			ValaBlock* _tmp173_;
			ValaMethodCall* _tmp174_;
			ValaSourceReference* _tmp175_;
			ValaSourceReference* _tmp176_;
			ValaReturnStatement* _tmp177_;
			ValaReturnStatement* _tmp178_;
			_tmp173_ = body;
			_tmp174_ = call;
			_tmp175_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp176_ = _tmp175_;
			_tmp177_ = vala_return_statement_new ((ValaExpression*) _tmp174_, _tmp176_);
			_tmp178_ = _tmp177_;
			vala_block_add_statement (_tmp173_, (ValaStatement*) _tmp178_);
			_vala_code_node_unref0 (_tmp178_);
		}
		_tmp179_ = self->priv->_emitter;
		_tmp180_ = body;
		vala_subroutine_set_body ((ValaSubroutine*) _tmp179_, _tmp180_);
		_tmp181_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp182_ = _tmp181_;
		cl = VALA_IS_OBJECT_TYPE_SYMBOL (_tmp182_) ? ((ValaObjectTypeSymbol*) _tmp182_) : NULL;
		_tmp183_ = cl;
		_tmp184_ = self->priv->_emitter;
		vala_object_type_symbol_add_hidden_method (_tmp183_, _tmp184_);
		_tmp185_ = vala_symbol_get_external_package ((ValaSymbol*) self);
		_tmp186_ = _tmp185_;
		if (!_tmp186_) {
			ValaMethod* _tmp187_;
			_tmp187_ = self->priv->_emitter;
			vala_code_node_check ((ValaCodeNode*) _tmp187_, context);
		}
		_vala_code_node_unref0 (call);
		_vala_code_node_unref0 (body);
	}
	_tmp190_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp191_ = _tmp190_;
	if (!_tmp191_) {
		gboolean _tmp192_;
		gboolean _tmp193_;
		_tmp192_ = vala_symbol_get_hides ((ValaSymbol*) self);
		_tmp193_ = _tmp192_;
		_tmp189_ = !_tmp193_;
	} else {
		_tmp189_ = FALSE;
	}
	if (_tmp189_) {
		ValaSymbol* _tmp194_;
		ValaSymbol* _tmp195_;
		_tmp194_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp195_ = _tmp194_;
		_tmp188_ = _tmp195_ != NULL;
		_vala_code_node_unref0 (_tmp195_);
	} else {
		_tmp188_ = FALSE;
	}
	if (_tmp188_) {
		ValaSourceReference* _tmp196_;
		ValaSourceReference* _tmp197_;
		gchar* _tmp198_;
		gchar* _tmp199_;
		ValaSymbol* _tmp200_;
		ValaSymbol* _tmp201_;
		gchar* _tmp202_;
		gchar* _tmp203_;
		_tmp196_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp197_ = _tmp196_;
		_tmp198_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp199_ = _tmp198_;
		_tmp200_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp201_ = _tmp200_;
		_tmp202_ = vala_symbol_get_full_name (_tmp201_);
		_tmp203_ = _tmp202_;
		vala_report_warning (_tmp197_, "%s hides inherited signal `%s'. Use the `new' keyword if hiding was in" \
"tentional", _tmp199_, _tmp203_);
		_g_free0 (_tmp203_);
		_vala_code_node_unref0 (_tmp201_);
		_g_free0 (_tmp199_);
	}
	_tmp204_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp205_ = _tmp204_;
	result = !_tmp205_;
	return result;
}

static void
vala_signal_class_init (ValaSignalClass * klass,
                        gpointer klass_data)
{
	vala_signal_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_signal_finalize;
	g_type_class_adjust_private_offset (klass, &ValaSignal_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_signal_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_signal_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_signal_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_signal_real_check;
}

static void
vala_signal_vala_callable_interface_init (ValaCallableIface * iface,
                                          gpointer iface_data)
{
	vala_signal_vala_callable_parent_iface = g_type_interface_peek_parent (iface);
	iface->add_parameter = (void (*) (ValaCallable*, ValaParameter*)) vala_signal_real_add_parameter;
	iface->get_parameters = (ValaList* (*) (ValaCallable*)) vala_signal_real_get_parameters;
	iface->get_return_type = vala_signal_real_get_return_type;
	iface->set_return_type = vala_signal_real_set_return_type;
}

static void
vala_signal_instance_init (ValaSignal * self,
                           gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_signal_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->parameters = (ValaList*) _tmp1_;
}

static void
vala_signal_finalize (ValaCodeNode * obj)
{
	ValaSignal * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_SIGNAL, ValaSignal);
	_vala_iterable_unref0 (self->priv->parameters);
	_vala_code_node_unref0 (self->priv->_default_handler);
	_vala_code_node_unref0 (self->priv->_emitter);
	_vala_code_node_unref0 (self->priv->_return_type);
	_vala_code_node_unref0 (self->priv->_body);
	VALA_CODE_NODE_CLASS (vala_signal_parent_class)->finalize (obj);
}

/**
 * Represents an object signal. Signals enable objects to provide notifications.
 */
static GType
vala_signal_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaSignalClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_signal_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaSignal), 0, (GInstanceInitFunc) vala_signal_instance_init, NULL };
	static const GInterfaceInfo vala_callable_info = { (GInterfaceInitFunc) vala_signal_vala_callable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType vala_signal_type_id;
	vala_signal_type_id = g_type_register_static (VALA_TYPE_SYMBOL, "ValaSignal", &g_define_type_info, 0);
	g_type_add_interface_static (vala_signal_type_id, VALA_TYPE_CALLABLE, &vala_callable_info);
	ValaSignal_private_offset = g_type_add_instance_private (vala_signal_type_id, sizeof (ValaSignalPrivate));
	return vala_signal_type_id;
}

GType
vala_signal_get_type (void)
{
	static volatile gsize vala_signal_type_id__volatile = 0;
	if (g_once_init_enter (&vala_signal_type_id__volatile)) {
		GType vala_signal_type_id;
		vala_signal_type_id = vala_signal_get_type_once ();
		g_once_init_leave (&vala_signal_type_id__volatile, vala_signal_type_id);
	}
	return vala_signal_type_id__volatile;
}

