/* valacreationmethod.c generated by valac, the Vala compiler
 * generated from valacreationmethod.vala, do not modify */

/* valacreationmethod.vala
 *
 * Copyright (C) 2007-2010  Jürg Billeter
 * Copyright (C) 2007-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

struct _ValaCreationMethodPrivate {
	gchar* _class_name;
	gboolean _chain_up;
};

static gint ValaCreationMethod_private_offset;
static gpointer vala_creation_method_parent_class = NULL;

static void vala_creation_method_real_accept (ValaCodeNode* base,
                                       ValaCodeVisitor* visitor);
static void vala_creation_method_real_accept_children (ValaCodeNode* base,
                                                ValaCodeVisitor* visitor);
static gboolean vala_creation_method_real_check (ValaCodeNode* base,
                                          ValaCodeContext* context);
static void vala_creation_method_finalize (ValaCodeNode * obj);
static GType vala_creation_method_get_type_once (void);

static inline gpointer
vala_creation_method_get_instance_private (ValaCreationMethod* self)
{
	return G_STRUCT_MEMBER_P (self, ValaCreationMethod_private_offset);
}

const gchar*
vala_creation_method_get_class_name (ValaCreationMethod* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_class_name;
	result = _tmp0_;
	return result;
}

void
vala_creation_method_set_class_name (ValaCreationMethod* self,
                                     const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_class_name);
	self->priv->_class_name = _tmp0_;
}

gboolean
vala_creation_method_get_chain_up (ValaCreationMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_chain_up;
	return result;
}

void
vala_creation_method_set_chain_up (ValaCreationMethod* self,
                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_chain_up = value;
}

/**
 * Creates a new method.
 *
 * @param name             method name
 * @param source_reference reference to source code
 * @return                 newly created method
 */
ValaCreationMethod*
vala_creation_method_construct (GType object_type,
                                const gchar* class_name,
                                const gchar* name,
                                ValaSourceReference* source_reference,
                                ValaComment* comment)
{
	ValaCreationMethod* self = NULL;
	ValaVoidType* _tmp0_;
	ValaVoidType* _tmp1_;
	_tmp0_ = vala_void_type_new (NULL);
	_tmp1_ = _tmp0_;
	self = (ValaCreationMethod*) vala_method_construct (object_type, name, (ValaDataType*) _tmp1_, source_reference, comment);
	_vala_code_node_unref0 (_tmp1_);
	vala_creation_method_set_class_name (self, class_name);
	return self;
}

ValaCreationMethod*
vala_creation_method_new (const gchar* class_name,
                          const gchar* name,
                          ValaSourceReference* source_reference,
                          ValaComment* comment)
{
	return vala_creation_method_construct (VALA_TYPE_CREATION_METHOD, class_name, name, source_reference, comment);
}

static void
vala_creation_method_real_accept (ValaCodeNode* base,
                                  ValaCodeVisitor* visitor)
{
	ValaCreationMethod * self;
	self = (ValaCreationMethod*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_creation_method (visitor, self);
}

static void
vala_creation_method_real_accept_children (ValaCodeNode* base,
                                           ValaCodeVisitor* visitor)
{
	ValaCreationMethod * self;
	ValaList* _tmp9_;
	ValaBlock* _tmp37_;
	ValaBlock* _tmp38_;
	self = (ValaCreationMethod*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		gint _param_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _param_index = 0;
		_tmp0_ = vala_callable_get_parameters ((ValaCallable*) self);
		_param_list = _tmp0_;
		_tmp1_ = _param_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_param_size = _tmp3_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaParameter* param = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaParameter* _tmp8_;
			_param_index = _param_index + 1;
			_tmp4_ = _param_index;
			_tmp5_ = _param_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _param_list;
			_tmp7_ = vala_list_get (_tmp6_, _param_index);
			param = (ValaParameter*) _tmp7_;
			_tmp8_ = param;
			vala_code_node_accept ((ValaCodeNode*) _tmp8_, visitor);
			_vala_code_node_unref0 (param);
		}
	}
	_tmp9_ = ((ValaMethod*) self)->error_types;
	if (_tmp9_ != NULL) {
		{
			ValaList* _error_type_list = NULL;
			ValaList* _tmp10_;
			gint _error_type_size = 0;
			ValaList* _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			gint _error_type_index = 0;
			_tmp10_ = ((ValaMethod*) self)->error_types;
			_error_type_list = _tmp10_;
			_tmp11_ = _error_type_list;
			_tmp12_ = vala_collection_get_size ((ValaCollection*) _tmp11_);
			_tmp13_ = _tmp12_;
			_error_type_size = _tmp13_;
			_error_type_index = -1;
			while (TRUE) {
				gint _tmp14_;
				gint _tmp15_;
				ValaDataType* error_type = NULL;
				ValaList* _tmp16_;
				gpointer _tmp17_;
				ValaDataType* _tmp18_;
				_error_type_index = _error_type_index + 1;
				_tmp14_ = _error_type_index;
				_tmp15_ = _error_type_size;
				if (!(_tmp14_ < _tmp15_)) {
					break;
				}
				_tmp16_ = _error_type_list;
				_tmp17_ = vala_list_get (_tmp16_, _error_type_index);
				error_type = (ValaDataType*) _tmp17_;
				_tmp18_ = error_type;
				vala_code_node_accept ((ValaCodeNode*) _tmp18_, visitor);
				_vala_code_node_unref0 (error_type);
			}
		}
	}
	{
		ValaList* _precondition_list = NULL;
		ValaList* _tmp19_;
		gint _precondition_size = 0;
		ValaList* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		gint _precondition_index = 0;
		_tmp19_ = vala_method_get_preconditions ((ValaMethod*) self);
		_precondition_list = _tmp19_;
		_tmp20_ = _precondition_list;
		_tmp21_ = vala_collection_get_size ((ValaCollection*) _tmp20_);
		_tmp22_ = _tmp21_;
		_precondition_size = _tmp22_;
		_precondition_index = -1;
		while (TRUE) {
			gint _tmp23_;
			gint _tmp24_;
			ValaExpression* precondition = NULL;
			ValaList* _tmp25_;
			gpointer _tmp26_;
			ValaExpression* _tmp27_;
			_precondition_index = _precondition_index + 1;
			_tmp23_ = _precondition_index;
			_tmp24_ = _precondition_size;
			if (!(_tmp23_ < _tmp24_)) {
				break;
			}
			_tmp25_ = _precondition_list;
			_tmp26_ = vala_list_get (_tmp25_, _precondition_index);
			precondition = (ValaExpression*) _tmp26_;
			_tmp27_ = precondition;
			vala_code_node_accept ((ValaCodeNode*) _tmp27_, visitor);
			_vala_code_node_unref0 (precondition);
		}
	}
	{
		ValaList* _postcondition_list = NULL;
		ValaList* _tmp28_;
		gint _postcondition_size = 0;
		ValaList* _tmp29_;
		gint _tmp30_;
		gint _tmp31_;
		gint _postcondition_index = 0;
		_tmp28_ = vala_method_get_postconditions ((ValaMethod*) self);
		_postcondition_list = _tmp28_;
		_tmp29_ = _postcondition_list;
		_tmp30_ = vala_collection_get_size ((ValaCollection*) _tmp29_);
		_tmp31_ = _tmp30_;
		_postcondition_size = _tmp31_;
		_postcondition_index = -1;
		while (TRUE) {
			gint _tmp32_;
			gint _tmp33_;
			ValaExpression* postcondition = NULL;
			ValaList* _tmp34_;
			gpointer _tmp35_;
			ValaExpression* _tmp36_;
			_postcondition_index = _postcondition_index + 1;
			_tmp32_ = _postcondition_index;
			_tmp33_ = _postcondition_size;
			if (!(_tmp32_ < _tmp33_)) {
				break;
			}
			_tmp34_ = _postcondition_list;
			_tmp35_ = vala_list_get (_tmp34_, _postcondition_index);
			postcondition = (ValaExpression*) _tmp35_;
			_tmp36_ = postcondition;
			vala_code_node_accept ((ValaCodeNode*) _tmp36_, visitor);
			_vala_code_node_unref0 (postcondition);
		}
	}
	_tmp37_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp38_ = _tmp37_;
	if (_tmp38_ != NULL) {
		ValaBlock* _tmp39_;
		ValaBlock* _tmp40_;
		_tmp39_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp40_ = _tmp39_;
		vala_code_node_accept ((ValaCodeNode*) _tmp40_, visitor);
	}
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gboolean
vala_creation_method_real_check (ValaCodeNode* base,
                                 ValaCodeContext* context)
{
	ValaCreationMethod * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	ValaParameter* _tmp20_;
	ValaParameter* _tmp21_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp24_;
	ValaSemanticAnalyzer* _tmp25_;
	ValaSourceFile* _tmp26_;
	ValaSourceFile* _tmp27_;
	ValaSourceFile* _tmp28_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp29_;
	ValaSemanticAnalyzer* _tmp30_;
	ValaSymbol* _tmp31_;
	ValaSymbol* _tmp32_;
	ValaSymbol* _tmp33_;
	ValaSourceReference* _tmp34_;
	ValaSourceReference* _tmp35_;
	ValaSemanticAnalyzer* _tmp42_;
	ValaSemanticAnalyzer* _tmp43_;
	gint i = 0;
	ValaList* _tmp127_;
	ValaBlock* _tmp165_;
	ValaBlock* _tmp166_;
	ValaSemanticAnalyzer* _tmp290_;
	ValaSemanticAnalyzer* _tmp291_;
	ValaSourceFile* _tmp292_;
	ValaSemanticAnalyzer* _tmp293_;
	ValaSemanticAnalyzer* _tmp294_;
	ValaSymbol* _tmp295_;
	gboolean _tmp296_ = FALSE;
	gboolean _tmp297_ = FALSE;
	gboolean _tmp298_;
	gboolean _tmp299_;
	gboolean _tmp308_ = FALSE;
	ValaBlock* _tmp309_;
	ValaBlock* _tmp310_;
	gboolean _tmp349_;
	gboolean _tmp350_;
	gboolean result = FALSE;
	self = (ValaCreationMethod*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp5_ = self->priv->_class_name;
	if (_tmp5_ != NULL) {
		const gchar* _tmp6_;
		ValaSymbol* _tmp7_;
		ValaSymbol* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		_tmp6_ = self->priv->_class_name;
		_tmp7_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_symbol_get_name (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp4_ = g_strcmp0 (_tmp6_, _tmp10_) != 0;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaSourceReference* _tmp11_;
		ValaSourceReference* _tmp12_;
		ValaSemanticAnalyzer* _tmp13_;
		ValaSemanticAnalyzer* _tmp14_;
		ValaSymbol* _tmp15_;
		ValaSymbol* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		const gchar* _tmp19_;
		_tmp11_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_code_context_get_analyzer (context);
		_tmp14_ = _tmp13_;
		_tmp15_ = vala_semantic_analyzer_get_current_symbol (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_symbol_get_full_name (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = self->priv->_class_name;
		vala_report_error (_tmp12_, "missing return type in method `%s.%s´", _tmp18_, _tmp19_);
		_g_free0 (_tmp18_);
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp20_ = vala_method_get_this_parameter ((ValaMethod*) self);
	_tmp21_ = _tmp20_;
	if (_tmp21_ != NULL) {
		ValaParameter* _tmp22_;
		ValaParameter* _tmp23_;
		_tmp22_ = vala_method_get_this_parameter ((ValaMethod*) self);
		_tmp23_ = _tmp22_;
		vala_code_node_check ((ValaCodeNode*) _tmp23_, context);
	}
	_tmp24_ = vala_code_context_get_analyzer (context);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_semantic_analyzer_get_current_source_file (_tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = _vala_source_file_ref0 (_tmp27_);
	old_source_file = _tmp28_;
	_tmp29_ = vala_code_context_get_analyzer (context);
	_tmp30_ = _tmp29_;
	_tmp31_ = vala_semantic_analyzer_get_current_symbol (_tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = _vala_code_node_ref0 (_tmp32_);
	old_symbol = _tmp33_;
	_tmp34_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp35_ = _tmp34_;
	if (_tmp35_ != NULL) {
		ValaSemanticAnalyzer* _tmp36_;
		ValaSemanticAnalyzer* _tmp37_;
		ValaSourceReference* _tmp38_;
		ValaSourceReference* _tmp39_;
		ValaSourceFile* _tmp40_;
		ValaSourceFile* _tmp41_;
		_tmp36_ = vala_code_context_get_analyzer (context);
		_tmp37_ = _tmp36_;
		_tmp38_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp39_ = _tmp38_;
		_tmp40_ = vala_source_reference_get_file (_tmp39_);
		_tmp41_ = _tmp40_;
		vala_semantic_analyzer_set_current_source_file (_tmp37_, _tmp41_);
	}
	_tmp42_ = vala_code_context_get_analyzer (context);
	_tmp43_ = _tmp42_;
	vala_semantic_analyzer_set_current_symbol (_tmp43_, (ValaSymbol*) self);
	i = 0;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp44_;
		gint _param_size = 0;
		ValaList* _tmp45_;
		gint _tmp46_;
		gint _tmp47_;
		gint _param_index = 0;
		_tmp44_ = vala_callable_get_parameters ((ValaCallable*) self);
		_param_list = _tmp44_;
		_tmp45_ = _param_list;
		_tmp46_ = vala_collection_get_size ((ValaCollection*) _tmp45_);
		_tmp47_ = _tmp46_;
		_param_size = _tmp47_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp48_;
			gint _tmp49_;
			ValaParameter* param = NULL;
			ValaList* _tmp50_;
			gpointer _tmp51_;
			ValaParameter* _tmp52_;
			gboolean _tmp53_ = FALSE;
			gboolean _tmp54_ = FALSE;
			gint _tmp63_;
			gboolean _tmp64_ = FALSE;
			ValaParameter* _tmp65_;
			gboolean _tmp66_;
			gboolean _tmp67_;
			_param_index = _param_index + 1;
			_tmp48_ = _param_index;
			_tmp49_ = _param_size;
			if (!(_tmp48_ < _tmp49_)) {
				break;
			}
			_tmp50_ = _param_list;
			_tmp51_ = vala_list_get (_tmp50_, _param_index);
			param = (ValaParameter*) _tmp51_;
			_tmp52_ = param;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp52_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			if (i == 0) {
				ValaParameter* _tmp55_;
				gboolean _tmp56_;
				gboolean _tmp57_;
				_tmp55_ = param;
				_tmp56_ = vala_parameter_get_ellipsis (_tmp55_);
				_tmp57_ = _tmp56_;
				_tmp54_ = _tmp57_;
			} else {
				_tmp54_ = FALSE;
			}
			if (_tmp54_) {
				ValaBlock* _tmp58_;
				ValaBlock* _tmp59_;
				_tmp58_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp59_ = _tmp58_;
				_tmp53_ = _tmp59_ != NULL;
			} else {
				_tmp53_ = FALSE;
			}
			if (_tmp53_) {
				ValaParameter* _tmp60_;
				ValaSourceReference* _tmp61_;
				ValaSourceReference* _tmp62_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp60_ = param;
				_tmp61_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp60_);
				_tmp62_ = _tmp61_;
				vala_report_error (_tmp62_, "Named parameter required before `...'");
			}
			_tmp63_ = i;
			i = _tmp63_ + 1;
			_tmp65_ = param;
			_tmp66_ = vala_parameter_get_params_array (_tmp65_);
			_tmp67_ = _tmp66_;
			if (_tmp67_) {
				ValaBlock* _tmp68_;
				ValaBlock* _tmp69_;
				_tmp68_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp69_ = _tmp68_;
				_tmp64_ = _tmp69_ != NULL;
			} else {
				_tmp64_ = FALSE;
			}
			if (_tmp64_) {
				ValaLocalVariable* _tmp70_;
				ValaLocalVariable* _tmp71_;
				gboolean _tmp75_;
				gboolean _tmp76_;
				ValaArrayType* type = NULL;
				ValaParameter* _tmp80_;
				ValaDataType* _tmp81_;
				ValaDataType* _tmp82_;
				ValaDataType* _tmp83_;
				ValaArrayType* _tmp84_;
				ValaDataType* _tmp85_;
				ValaDataType* _tmp86_;
				ValaArrayType* _tmp87_;
				gboolean _tmp88_;
				gboolean _tmp89_;
				ValaArrayType* _tmp90_;
				gboolean _tmp91_ = FALSE;
				ValaArrayType* _tmp92_;
				ValaDataType* _tmp93_;
				ValaDataType* _tmp94_;
				ValaArrayType* _tmp103_;
				ValaExpression* _tmp104_;
				ValaExpression* _tmp105_;
				ValaArrayType* _tmp109_;
				ValaParameter* _tmp110_;
				const gchar* _tmp111_;
				const gchar* _tmp112_;
				ValaParameter* _tmp113_;
				ValaSourceReference* _tmp114_;
				ValaSourceReference* _tmp115_;
				ValaLocalVariable* _tmp116_;
				ValaLocalVariable* _tmp117_;
				ValaBlock* _tmp118_;
				ValaBlock* _tmp119_;
				ValaLocalVariable* _tmp120_;
				ValaLocalVariable* _tmp121_;
				ValaParameter* _tmp122_;
				ValaSourceReference* _tmp123_;
				ValaSourceReference* _tmp124_;
				ValaDeclarationStatement* _tmp125_;
				ValaDeclarationStatement* _tmp126_;
				_tmp70_ = vala_method_get_params_array_var ((ValaMethod*) self);
				_tmp71_ = _tmp70_;
				if (_tmp71_ != NULL) {
					ValaParameter* _tmp72_;
					ValaSourceReference* _tmp73_;
					ValaSourceReference* _tmp74_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp72_ = param;
					_tmp73_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp72_);
					_tmp74_ = _tmp73_;
					vala_report_error (_tmp74_, "Only one params-array parameter is allowed");
					_vala_code_node_unref0 (param);
					continue;
				}
				_tmp75_ = vala_code_context_get_experimental (context);
				_tmp76_ = _tmp75_;
				if (!_tmp76_) {
					ValaParameter* _tmp77_;
					ValaSourceReference* _tmp78_;
					ValaSourceReference* _tmp79_;
					_tmp77_ = param;
					_tmp78_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp77_);
					_tmp79_ = _tmp78_;
					vala_report_warning (_tmp79_, "Support of params-arrays is experimental");
				}
				_tmp80_ = param;
				_tmp81_ = vala_variable_get_variable_type ((ValaVariable*) _tmp80_);
				_tmp82_ = _tmp81_;
				_tmp83_ = vala_data_type_copy (_tmp82_);
				type = G_TYPE_CHECK_INSTANCE_CAST (_tmp83_, VALA_TYPE_ARRAY_TYPE, ValaArrayType);
				_tmp84_ = type;
				_tmp85_ = vala_array_type_get_element_type (_tmp84_);
				_tmp86_ = _tmp85_;
				_tmp87_ = type;
				_tmp88_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp87_);
				_tmp89_ = _tmp88_;
				vala_data_type_set_value_owned (_tmp86_, _tmp89_);
				_tmp90_ = type;
				vala_data_type_set_value_owned ((ValaDataType*) _tmp90_, TRUE);
				_tmp92_ = type;
				_tmp93_ = vala_array_type_get_element_type (_tmp92_);
				_tmp94_ = _tmp93_;
				if (vala_data_type_is_real_struct_type (_tmp94_)) {
					ValaArrayType* _tmp95_;
					ValaDataType* _tmp96_;
					ValaDataType* _tmp97_;
					gboolean _tmp98_;
					gboolean _tmp99_;
					_tmp95_ = type;
					_tmp96_ = vala_array_type_get_element_type (_tmp95_);
					_tmp97_ = _tmp96_;
					_tmp98_ = vala_data_type_get_nullable (_tmp97_);
					_tmp99_ = _tmp98_;
					_tmp91_ = !_tmp99_;
				} else {
					_tmp91_ = FALSE;
				}
				if (_tmp91_) {
					ValaParameter* _tmp100_;
					ValaSourceReference* _tmp101_;
					ValaSourceReference* _tmp102_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp100_ = param;
					_tmp101_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp100_);
					_tmp102_ = _tmp101_;
					vala_report_error (_tmp102_, "Only nullable struct elements are supported in params-array");
				}
				_tmp103_ = type;
				_tmp104_ = vala_array_type_get_length (_tmp103_);
				_tmp105_ = _tmp104_;
				if (_tmp105_ != NULL) {
					ValaParameter* _tmp106_;
					ValaSourceReference* _tmp107_;
					ValaSourceReference* _tmp108_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp106_ = param;
					_tmp107_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp106_);
					_tmp108_ = _tmp107_;
					vala_report_error (_tmp108_, "Passing length to params-array is not supported yet");
				}
				_tmp109_ = type;
				_tmp110_ = param;
				_tmp111_ = vala_symbol_get_name ((ValaSymbol*) _tmp110_);
				_tmp112_ = _tmp111_;
				_tmp113_ = param;
				_tmp114_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp113_);
				_tmp115_ = _tmp114_;
				_tmp116_ = vala_local_variable_new ((ValaDataType*) _tmp109_, _tmp112_, NULL, _tmp115_);
				_tmp117_ = _tmp116_;
				vala_method_set_params_array_var ((ValaMethod*) self, _tmp117_);
				_vala_code_node_unref0 (_tmp117_);
				_tmp118_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp119_ = _tmp118_;
				_tmp120_ = vala_method_get_params_array_var ((ValaMethod*) self);
				_tmp121_ = _tmp120_;
				_tmp122_ = param;
				_tmp123_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp122_);
				_tmp124_ = _tmp123_;
				_tmp125_ = vala_declaration_statement_new ((ValaSymbol*) _tmp121_, _tmp124_);
				_tmp126_ = _tmp125_;
				vala_block_insert_statement (_tmp119_, 0, (ValaStatement*) _tmp126_);
				_vala_code_node_unref0 (_tmp126_);
				_vala_code_node_unref0 (type);
			}
			_vala_code_node_unref0 (param);
		}
	}
	_tmp127_ = ((ValaMethod*) self)->error_types;
	if (_tmp127_ != NULL) {
		{
			ValaList* _error_type_list = NULL;
			ValaList* _tmp128_;
			gint _error_type_size = 0;
			ValaList* _tmp129_;
			gint _tmp130_;
			gint _tmp131_;
			gint _error_type_index = 0;
			_tmp128_ = ((ValaMethod*) self)->error_types;
			_error_type_list = _tmp128_;
			_tmp129_ = _error_type_list;
			_tmp130_ = vala_collection_get_size ((ValaCollection*) _tmp129_);
			_tmp131_ = _tmp130_;
			_error_type_size = _tmp131_;
			_error_type_index = -1;
			while (TRUE) {
				gint _tmp132_;
				gint _tmp133_;
				ValaDataType* error_type = NULL;
				ValaList* _tmp134_;
				gpointer _tmp135_;
				ValaDataType* _tmp136_;
				ValaSemanticAnalyzer* _tmp137_;
				ValaSemanticAnalyzer* _tmp138_;
				ValaDataType* _tmp139_;
				_error_type_index = _error_type_index + 1;
				_tmp132_ = _error_type_index;
				_tmp133_ = _error_type_size;
				if (!(_tmp132_ < _tmp133_)) {
					break;
				}
				_tmp134_ = _error_type_list;
				_tmp135_ = vala_list_get (_tmp134_, _error_type_index);
				error_type = (ValaDataType*) _tmp135_;
				_tmp136_ = error_type;
				vala_code_node_check ((ValaCodeNode*) _tmp136_, context);
				_tmp137_ = vala_code_context_get_analyzer (context);
				_tmp138_ = _tmp137_;
				_tmp139_ = error_type;
				if (!vala_semantic_analyzer_is_type_accessible (_tmp138_, (ValaSymbol*) self, _tmp139_)) {
					ValaSourceReference* _tmp140_;
					ValaSourceReference* _tmp141_;
					ValaDataType* _tmp142_;
					gchar* _tmp143_;
					gchar* _tmp144_;
					gchar* _tmp145_;
					gchar* _tmp146_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp140_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp141_ = _tmp140_;
					_tmp142_ = error_type;
					_tmp143_ = vala_code_node_to_string ((ValaCodeNode*) _tmp142_);
					_tmp144_ = _tmp143_;
					_tmp145_ = vala_symbol_get_full_name ((ValaSymbol*) self);
					_tmp146_ = _tmp145_;
					vala_report_error (_tmp141_, "error type `%s' is less accessible than creation method `%s'", _tmp144_, _tmp146_);
					_g_free0 (_tmp146_);
					_g_free0 (_tmp144_);
					result = FALSE;
					_vala_code_node_unref0 (error_type);
					_vala_code_node_unref0 (old_symbol);
					_vala_source_file_unref0 (old_source_file);
					return result;
				}
				_vala_code_node_unref0 (error_type);
			}
		}
	}
	{
		ValaList* _precondition_list = NULL;
		ValaList* _tmp147_;
		gint _precondition_size = 0;
		ValaList* _tmp148_;
		gint _tmp149_;
		gint _tmp150_;
		gint _precondition_index = 0;
		_tmp147_ = vala_method_get_preconditions ((ValaMethod*) self);
		_precondition_list = _tmp147_;
		_tmp148_ = _precondition_list;
		_tmp149_ = vala_collection_get_size ((ValaCollection*) _tmp148_);
		_tmp150_ = _tmp149_;
		_precondition_size = _tmp150_;
		_precondition_index = -1;
		while (TRUE) {
			gint _tmp151_;
			gint _tmp152_;
			ValaExpression* precondition = NULL;
			ValaList* _tmp153_;
			gpointer _tmp154_;
			ValaExpression* _tmp155_;
			_precondition_index = _precondition_index + 1;
			_tmp151_ = _precondition_index;
			_tmp152_ = _precondition_size;
			if (!(_tmp151_ < _tmp152_)) {
				break;
			}
			_tmp153_ = _precondition_list;
			_tmp154_ = vala_list_get (_tmp153_, _precondition_index);
			precondition = (ValaExpression*) _tmp154_;
			_tmp155_ = precondition;
			vala_code_node_check ((ValaCodeNode*) _tmp155_, context);
			_vala_code_node_unref0 (precondition);
		}
	}
	{
		ValaList* _postcondition_list = NULL;
		ValaList* _tmp156_;
		gint _postcondition_size = 0;
		ValaList* _tmp157_;
		gint _tmp158_;
		gint _tmp159_;
		gint _postcondition_index = 0;
		_tmp156_ = vala_method_get_postconditions ((ValaMethod*) self);
		_postcondition_list = _tmp156_;
		_tmp157_ = _postcondition_list;
		_tmp158_ = vala_collection_get_size ((ValaCollection*) _tmp157_);
		_tmp159_ = _tmp158_;
		_postcondition_size = _tmp159_;
		_postcondition_index = -1;
		while (TRUE) {
			gint _tmp160_;
			gint _tmp161_;
			ValaExpression* postcondition = NULL;
			ValaList* _tmp162_;
			gpointer _tmp163_;
			ValaExpression* _tmp164_;
			_postcondition_index = _postcondition_index + 1;
			_tmp160_ = _postcondition_index;
			_tmp161_ = _postcondition_size;
			if (!(_tmp160_ < _tmp161_)) {
				break;
			}
			_tmp162_ = _postcondition_list;
			_tmp163_ = vala_list_get (_tmp162_, _postcondition_index);
			postcondition = (ValaExpression*) _tmp163_;
			_tmp164_ = postcondition;
			vala_code_node_check ((ValaCodeNode*) _tmp164_, context);
			_vala_code_node_unref0 (postcondition);
		}
	}
	_tmp165_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp166_ = _tmp165_;
	if (_tmp166_ != NULL) {
		ValaBlock* _tmp167_;
		ValaBlock* _tmp168_;
		ValaClass* cl = NULL;
		ValaSymbol* _tmp169_;
		ValaSymbol* _tmp170_;
		gboolean _tmp171_ = FALSE;
		gboolean _tmp172_ = FALSE;
		gboolean _tmp173_;
		_tmp167_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp168_ = _tmp167_;
		vala_code_node_check ((ValaCodeNode*) _tmp168_, context);
		_tmp169_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp170_ = _tmp169_;
		cl = VALA_IS_CLASS (_tmp170_) ? ((ValaClass*) _tmp170_) : NULL;
		_tmp173_ = self->priv->_chain_up;
		if (!_tmp173_) {
			ValaClass* _tmp174_;
			_tmp174_ = cl;
			_tmp172_ = _tmp174_ != NULL;
		} else {
			_tmp172_ = FALSE;
		}
		if (_tmp172_) {
			ValaClass* _tmp175_;
			ValaClass* _tmp176_;
			ValaClass* _tmp177_;
			_tmp175_ = cl;
			_tmp176_ = vala_class_get_base_class (_tmp175_);
			_tmp177_ = _tmp176_;
			_tmp171_ = _tmp177_ != NULL;
		} else {
			_tmp171_ = FALSE;
		}
		if (_tmp171_) {
			gboolean _tmp178_ = FALSE;
			gboolean _tmp179_ = FALSE;
			ValaProfile _tmp180_;
			ValaProfile _tmp181_;
			_tmp180_ = vala_code_context_get_profile (context);
			_tmp181_ = _tmp180_;
			if (_tmp181_ == VALA_PROFILE_GOBJECT) {
				ValaClass* _tmp182_;
				ValaClass* _tmp183_;
				ValaClass* _tmp184_;
				ValaCreationMethod* _tmp185_;
				ValaCreationMethod* _tmp186_;
				_tmp182_ = cl;
				_tmp183_ = vala_class_get_base_class (_tmp182_);
				_tmp184_ = _tmp183_;
				_tmp185_ = vala_class_get_default_construction_method (_tmp184_);
				_tmp186_ = _tmp185_;
				_tmp179_ = _tmp186_ != NULL;
			} else {
				_tmp179_ = FALSE;
			}
			if (_tmp179_) {
				ValaClass* _tmp187_;
				ValaClass* _tmp188_;
				ValaClass* _tmp189_;
				ValaCreationMethod* _tmp190_;
				ValaCreationMethod* _tmp191_;
				gboolean _tmp192_;
				gboolean _tmp193_;
				_tmp187_ = cl;
				_tmp188_ = vala_class_get_base_class (_tmp187_);
				_tmp189_ = _tmp188_;
				_tmp190_ = vala_class_get_default_construction_method (_tmp189_);
				_tmp191_ = _tmp190_;
				_tmp192_ = vala_method_get_has_construct_function ((ValaMethod*) _tmp191_);
				_tmp193_ = _tmp192_;
				_tmp178_ = !_tmp193_;
			} else {
				_tmp178_ = FALSE;
			}
			if (_tmp178_) {
				ValaBlock* old_insert_block = NULL;
				ValaSemanticAnalyzer* _tmp194_;
				ValaSemanticAnalyzer* _tmp195_;
				ValaBlock* _tmp196_;
				ValaBlock* _tmp197_;
				ValaSemanticAnalyzer* _tmp198_;
				ValaSemanticAnalyzer* _tmp199_;
				ValaBlock* _tmp200_;
				ValaBlock* _tmp201_;
				ValaSemanticAnalyzer* _tmp202_;
				ValaSemanticAnalyzer* _tmp203_;
				ValaBlock* _tmp204_;
				ValaBlock* _tmp205_;
				ValaBlock* _tmp206_;
				ValaExpressionStatement* stmt = NULL;
				ValaSourceReference* _tmp207_;
				ValaSourceReference* _tmp208_;
				ValaMemberAccess* _tmp209_;
				ValaMemberAccess* _tmp210_;
				ValaSourceReference* _tmp211_;
				ValaSourceReference* _tmp212_;
				ValaMemberAccess* _tmp213_;
				ValaMemberAccess* _tmp214_;
				ValaSourceReference* _tmp215_;
				ValaSourceReference* _tmp216_;
				ValaMethodCall* _tmp217_;
				ValaMethodCall* _tmp218_;
				ValaSourceReference* _tmp219_;
				ValaSourceReference* _tmp220_;
				ValaExpressionStatement* _tmp221_;
				ValaExpressionStatement* _tmp222_;
				ValaBlock* _tmp223_;
				ValaBlock* _tmp224_;
				ValaExpressionStatement* _tmp225_;
				ValaExpressionStatement* _tmp226_;
				ValaSemanticAnalyzer* _tmp227_;
				ValaSemanticAnalyzer* _tmp228_;
				ValaSemanticAnalyzer* _tmp229_;
				ValaSemanticAnalyzer* _tmp230_;
				ValaBlock* _tmp231_;
				ValaBlock* _tmp232_;
				_tmp194_ = vala_code_context_get_analyzer (context);
				_tmp195_ = _tmp194_;
				_tmp196_ = _tmp195_->insert_block;
				_tmp197_ = _vala_code_node_ref0 (_tmp196_);
				old_insert_block = _tmp197_;
				_tmp198_ = vala_code_context_get_analyzer (context);
				_tmp199_ = _tmp198_;
				_tmp200_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp201_ = _tmp200_;
				vala_semantic_analyzer_set_current_symbol (_tmp199_, (ValaSymbol*) _tmp201_);
				_tmp202_ = vala_code_context_get_analyzer (context);
				_tmp203_ = _tmp202_;
				_tmp204_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp205_ = _tmp204_;
				_tmp206_ = _vala_code_node_ref0 (_tmp205_);
				_vala_code_node_unref0 (_tmp203_->insert_block);
				_tmp203_->insert_block = _tmp206_;
				_tmp207_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp208_ = _tmp207_;
				_tmp209_ = vala_member_access_new_simple ("GLib", _tmp208_);
				_tmp210_ = _tmp209_;
				_tmp211_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp212_ = _tmp211_;
				_tmp213_ = vala_member_access_new ((ValaExpression*) _tmp210_, "Object", _tmp212_);
				_tmp214_ = _tmp213_;
				_tmp215_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp216_ = _tmp215_;
				_tmp217_ = vala_method_call_new ((ValaExpression*) _tmp214_, _tmp216_);
				_tmp218_ = _tmp217_;
				_tmp219_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp220_ = _tmp219_;
				_tmp221_ = vala_expression_statement_new ((ValaExpression*) _tmp218_, _tmp220_);
				_tmp222_ = _tmp221_;
				_vala_code_node_unref0 (_tmp218_);
				_vala_code_node_unref0 (_tmp214_);
				_vala_code_node_unref0 (_tmp210_);
				stmt = _tmp222_;
				_tmp223_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp224_ = _tmp223_;
				_tmp225_ = stmt;
				vala_block_insert_statement (_tmp224_, 0, (ValaStatement*) _tmp225_);
				_tmp226_ = stmt;
				vala_code_node_check ((ValaCodeNode*) _tmp226_, context);
				_tmp227_ = vala_code_context_get_analyzer (context);
				_tmp228_ = _tmp227_;
				vala_semantic_analyzer_set_current_symbol (_tmp228_, (ValaSymbol*) self);
				_tmp229_ = vala_code_context_get_analyzer (context);
				_tmp230_ = _tmp229_;
				_tmp231_ = old_insert_block;
				_tmp232_ = _vala_code_node_ref0 (_tmp231_);
				_vala_code_node_unref0 (_tmp230_->insert_block);
				_tmp230_->insert_block = _tmp232_;
				_vala_code_node_unref0 (stmt);
				_vala_code_node_unref0 (old_insert_block);
			} else {
				gboolean _tmp233_ = FALSE;
				ValaClass* _tmp234_;
				ValaClass* _tmp235_;
				ValaClass* _tmp236_;
				ValaCreationMethod* _tmp237_;
				ValaCreationMethod* _tmp238_;
				_tmp234_ = cl;
				_tmp235_ = vala_class_get_base_class (_tmp234_);
				_tmp236_ = _tmp235_;
				_tmp237_ = vala_class_get_default_construction_method (_tmp236_);
				_tmp238_ = _tmp237_;
				if (_tmp238_ == NULL) {
					_tmp233_ = TRUE;
				} else {
					ValaClass* _tmp239_;
					ValaClass* _tmp240_;
					ValaClass* _tmp241_;
					ValaCreationMethod* _tmp242_;
					ValaCreationMethod* _tmp243_;
					ValaSymbolAccessibility _tmp244_;
					ValaSymbolAccessibility _tmp245_;
					_tmp239_ = cl;
					_tmp240_ = vala_class_get_base_class (_tmp239_);
					_tmp241_ = _tmp240_;
					_tmp242_ = vala_class_get_default_construction_method (_tmp241_);
					_tmp243_ = _tmp242_;
					_tmp244_ = vala_symbol_get_access ((ValaSymbol*) _tmp243_);
					_tmp245_ = _tmp244_;
					_tmp233_ = _tmp245_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
				}
				if (_tmp233_) {
					ValaSourceReference* _tmp246_;
					ValaSourceReference* _tmp247_;
					_tmp246_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp247_ = _tmp246_;
					vala_report_error (_tmp247_, "unable to chain up to private base constructor");
				} else {
					ValaClass* _tmp248_;
					ValaClass* _tmp249_;
					ValaClass* _tmp250_;
					ValaCreationMethod* _tmp251_;
					ValaCreationMethod* _tmp252_;
					_tmp248_ = cl;
					_tmp249_ = vala_class_get_base_class (_tmp248_);
					_tmp250_ = _tmp249_;
					_tmp251_ = vala_class_get_default_construction_method (_tmp250_);
					_tmp252_ = _tmp251_;
					if (vala_method_get_required_arguments ((ValaMethod*) _tmp252_) > 0) {
						ValaSourceReference* _tmp253_;
						ValaSourceReference* _tmp254_;
						_tmp253_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp254_ = _tmp253_;
						vala_report_error (_tmp254_, "unable to chain up to base constructor requiring arguments");
					} else {
						ValaBlock* old_insert_block = NULL;
						ValaSemanticAnalyzer* _tmp255_;
						ValaSemanticAnalyzer* _tmp256_;
						ValaBlock* _tmp257_;
						ValaBlock* _tmp258_;
						ValaSemanticAnalyzer* _tmp259_;
						ValaSemanticAnalyzer* _tmp260_;
						ValaBlock* _tmp261_;
						ValaBlock* _tmp262_;
						ValaSemanticAnalyzer* _tmp263_;
						ValaSemanticAnalyzer* _tmp264_;
						ValaBlock* _tmp265_;
						ValaBlock* _tmp266_;
						ValaBlock* _tmp267_;
						ValaExpressionStatement* stmt = NULL;
						ValaSourceReference* _tmp268_;
						ValaSourceReference* _tmp269_;
						ValaBaseAccess* _tmp270_;
						ValaBaseAccess* _tmp271_;
						ValaSourceReference* _tmp272_;
						ValaSourceReference* _tmp273_;
						ValaMethodCall* _tmp274_;
						ValaMethodCall* _tmp275_;
						ValaSourceReference* _tmp276_;
						ValaSourceReference* _tmp277_;
						ValaExpressionStatement* _tmp278_;
						ValaExpressionStatement* _tmp279_;
						ValaBlock* _tmp280_;
						ValaBlock* _tmp281_;
						ValaExpressionStatement* _tmp282_;
						ValaExpressionStatement* _tmp283_;
						ValaSemanticAnalyzer* _tmp284_;
						ValaSemanticAnalyzer* _tmp285_;
						ValaSemanticAnalyzer* _tmp286_;
						ValaSemanticAnalyzer* _tmp287_;
						ValaBlock* _tmp288_;
						ValaBlock* _tmp289_;
						_tmp255_ = vala_code_context_get_analyzer (context);
						_tmp256_ = _tmp255_;
						_tmp257_ = _tmp256_->insert_block;
						_tmp258_ = _vala_code_node_ref0 (_tmp257_);
						old_insert_block = _tmp258_;
						_tmp259_ = vala_code_context_get_analyzer (context);
						_tmp260_ = _tmp259_;
						_tmp261_ = vala_subroutine_get_body ((ValaSubroutine*) self);
						_tmp262_ = _tmp261_;
						vala_semantic_analyzer_set_current_symbol (_tmp260_, (ValaSymbol*) _tmp262_);
						_tmp263_ = vala_code_context_get_analyzer (context);
						_tmp264_ = _tmp263_;
						_tmp265_ = vala_subroutine_get_body ((ValaSubroutine*) self);
						_tmp266_ = _tmp265_;
						_tmp267_ = _vala_code_node_ref0 (_tmp266_);
						_vala_code_node_unref0 (_tmp264_->insert_block);
						_tmp264_->insert_block = _tmp267_;
						_tmp268_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp269_ = _tmp268_;
						_tmp270_ = vala_base_access_new (_tmp269_);
						_tmp271_ = _tmp270_;
						_tmp272_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp273_ = _tmp272_;
						_tmp274_ = vala_method_call_new ((ValaExpression*) _tmp271_, _tmp273_);
						_tmp275_ = _tmp274_;
						_tmp276_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp277_ = _tmp276_;
						_tmp278_ = vala_expression_statement_new ((ValaExpression*) _tmp275_, _tmp277_);
						_tmp279_ = _tmp278_;
						_vala_code_node_unref0 (_tmp275_);
						_vala_code_node_unref0 (_tmp271_);
						stmt = _tmp279_;
						_tmp280_ = vala_subroutine_get_body ((ValaSubroutine*) self);
						_tmp281_ = _tmp280_;
						_tmp282_ = stmt;
						vala_block_insert_statement (_tmp281_, 0, (ValaStatement*) _tmp282_);
						_tmp283_ = stmt;
						vala_code_node_check ((ValaCodeNode*) _tmp283_, context);
						_tmp284_ = vala_code_context_get_analyzer (context);
						_tmp285_ = _tmp284_;
						vala_semantic_analyzer_set_current_symbol (_tmp285_, (ValaSymbol*) self);
						_tmp286_ = vala_code_context_get_analyzer (context);
						_tmp287_ = _tmp286_;
						_tmp288_ = old_insert_block;
						_tmp289_ = _vala_code_node_ref0 (_tmp288_);
						_vala_code_node_unref0 (_tmp287_->insert_block);
						_tmp287_->insert_block = _tmp289_;
						_vala_code_node_unref0 (stmt);
						_vala_code_node_unref0 (old_insert_block);
					}
				}
			}
		}
	}
	_tmp290_ = vala_code_context_get_analyzer (context);
	_tmp291_ = _tmp290_;
	_tmp292_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp291_, _tmp292_);
	_tmp293_ = vala_code_context_get_analyzer (context);
	_tmp294_ = _tmp293_;
	_tmp295_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp294_, _tmp295_);
	_tmp298_ = vala_method_get_is_abstract ((ValaMethod*) self);
	_tmp299_ = _tmp298_;
	if (_tmp299_) {
		_tmp297_ = TRUE;
	} else {
		gboolean _tmp300_;
		gboolean _tmp301_;
		_tmp300_ = vala_method_get_is_virtual ((ValaMethod*) self);
		_tmp301_ = _tmp300_;
		_tmp297_ = _tmp301_;
	}
	if (_tmp297_) {
		_tmp296_ = TRUE;
	} else {
		gboolean _tmp302_;
		gboolean _tmp303_;
		_tmp302_ = vala_method_get_overrides ((ValaMethod*) self);
		_tmp303_ = _tmp302_;
		_tmp296_ = _tmp303_;
	}
	if (_tmp296_) {
		ValaSourceReference* _tmp304_;
		ValaSourceReference* _tmp305_;
		gchar* _tmp306_;
		gchar* _tmp307_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp304_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp305_ = _tmp304_;
		_tmp306_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp307_ = _tmp306_;
		vala_report_error (_tmp305_, "The creation method `%s' cannot be marked as override, virtual, or abs" \
"tract", _tmp307_);
		_g_free0 (_tmp307_);
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp309_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp310_ = _tmp309_;
	if (_tmp310_ != NULL) {
		ValaBlock* _tmp311_;
		ValaBlock* _tmp312_;
		gboolean _tmp313_;
		gboolean _tmp314_;
		_tmp311_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp312_ = _tmp311_;
		_tmp313_ = vala_code_node_get_error ((ValaCodeNode*) _tmp312_);
		_tmp314_ = _tmp313_;
		_tmp308_ = !_tmp314_;
	} else {
		_tmp308_ = FALSE;
	}
	if (_tmp308_) {
		ValaArrayList* body_errors = NULL;
		GEqualFunc _tmp315_;
		ValaArrayList* _tmp316_;
		ValaBlock* _tmp317_;
		ValaBlock* _tmp318_;
		ValaArrayList* _tmp319_;
		_tmp315_ = g_direct_equal;
		_tmp316_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp315_);
		body_errors = _tmp316_;
		_tmp317_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp318_ = _tmp317_;
		_tmp319_ = body_errors;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp318_, (ValaCollection*) _tmp319_, NULL);
		{
			ValaArrayList* _body_error_type_list = NULL;
			ValaArrayList* _tmp320_;
			gint _body_error_type_size = 0;
			ValaArrayList* _tmp321_;
			gint _tmp322_;
			gint _tmp323_;
			gint _body_error_type_index = 0;
			_tmp320_ = body_errors;
			_body_error_type_list = _tmp320_;
			_tmp321_ = _body_error_type_list;
			_tmp322_ = vala_collection_get_size ((ValaCollection*) _tmp321_);
			_tmp323_ = _tmp322_;
			_body_error_type_size = _tmp323_;
			_body_error_type_index = -1;
			while (TRUE) {
				gint _tmp324_;
				gint _tmp325_;
				ValaDataType* body_error_type = NULL;
				ValaArrayList* _tmp326_;
				gpointer _tmp327_;
				gboolean can_propagate_error = FALSE;
				ValaList* _tmp328_;
				gboolean _tmp339_ = FALSE;
				_body_error_type_index = _body_error_type_index + 1;
				_tmp324_ = _body_error_type_index;
				_tmp325_ = _body_error_type_size;
				if (!(_tmp324_ < _tmp325_)) {
					break;
				}
				_tmp326_ = _body_error_type_list;
				_tmp327_ = vala_list_get ((ValaList*) _tmp326_, _body_error_type_index);
				body_error_type = (ValaDataType*) _tmp327_;
				can_propagate_error = FALSE;
				_tmp328_ = ((ValaMethod*) self)->error_types;
				if (_tmp328_ != NULL) {
					{
						ValaList* _method_error_type_list = NULL;
						ValaList* _tmp329_;
						gint _method_error_type_size = 0;
						ValaList* _tmp330_;
						gint _tmp331_;
						gint _tmp332_;
						gint _method_error_type_index = 0;
						_tmp329_ = ((ValaMethod*) self)->error_types;
						_method_error_type_list = _tmp329_;
						_tmp330_ = _method_error_type_list;
						_tmp331_ = vala_collection_get_size ((ValaCollection*) _tmp330_);
						_tmp332_ = _tmp331_;
						_method_error_type_size = _tmp332_;
						_method_error_type_index = -1;
						while (TRUE) {
							gint _tmp333_;
							gint _tmp334_;
							ValaDataType* method_error_type = NULL;
							ValaList* _tmp335_;
							gpointer _tmp336_;
							ValaDataType* _tmp337_;
							ValaDataType* _tmp338_;
							_method_error_type_index = _method_error_type_index + 1;
							_tmp333_ = _method_error_type_index;
							_tmp334_ = _method_error_type_size;
							if (!(_tmp333_ < _tmp334_)) {
								break;
							}
							_tmp335_ = _method_error_type_list;
							_tmp336_ = vala_list_get (_tmp335_, _method_error_type_index);
							method_error_type = (ValaDataType*) _tmp336_;
							_tmp337_ = body_error_type;
							_tmp338_ = method_error_type;
							if (vala_data_type_compatible (_tmp337_, _tmp338_)) {
								can_propagate_error = TRUE;
							}
							_vala_code_node_unref0 (method_error_type);
						}
					}
				}
				if (!can_propagate_error) {
					ValaDataType* _tmp340_;
					gboolean _tmp341_;
					gboolean _tmp342_;
					_tmp340_ = body_error_type;
					_tmp341_ = vala_error_type_get_dynamic_error (G_TYPE_CHECK_INSTANCE_CAST (_tmp340_, VALA_TYPE_ERROR_TYPE, ValaErrorType));
					_tmp342_ = _tmp341_;
					_tmp339_ = !_tmp342_;
				} else {
					_tmp339_ = FALSE;
				}
				if (_tmp339_) {
					ValaDataType* _tmp343_;
					ValaSourceReference* _tmp344_;
					ValaSourceReference* _tmp345_;
					ValaDataType* _tmp346_;
					gchar* _tmp347_;
					gchar* _tmp348_;
					_tmp343_ = body_error_type;
					_tmp344_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp343_);
					_tmp345_ = _tmp344_;
					_tmp346_ = body_error_type;
					_tmp347_ = vala_code_node_to_string ((ValaCodeNode*) _tmp346_);
					_tmp348_ = _tmp347_;
					vala_report_warning (_tmp345_, "unhandled error `%s'", _tmp348_);
					_g_free0 (_tmp348_);
				}
				_vala_code_node_unref0 (body_error_type);
			}
		}
		_vala_iterable_unref0 (body_errors);
	}
	_tmp349_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp350_ = _tmp349_;
	result = !_tmp350_;
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}

static void
vala_creation_method_class_init (ValaCreationMethodClass * klass,
                                 gpointer klass_data)
{
	vala_creation_method_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_creation_method_finalize;
	g_type_class_adjust_private_offset (klass, &ValaCreationMethod_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_creation_method_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_creation_method_real_accept_children;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_creation_method_real_check;
}

static void
vala_creation_method_instance_init (ValaCreationMethod * self,
                                    gpointer klass)
{
	self->priv = vala_creation_method_get_instance_private (self);
}

static void
vala_creation_method_finalize (ValaCodeNode * obj)
{
	ValaCreationMethod * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CREATION_METHOD, ValaCreationMethod);
	_g_free0 (self->priv->_class_name);
	VALA_CODE_NODE_CLASS (vala_creation_method_parent_class)->finalize (obj);
}

/**
 * Represents a type creation method.
 */
static GType
vala_creation_method_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaCreationMethodClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_creation_method_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCreationMethod), 0, (GInstanceInitFunc) vala_creation_method_instance_init, NULL };
	GType vala_creation_method_type_id;
	vala_creation_method_type_id = g_type_register_static (VALA_TYPE_METHOD, "ValaCreationMethod", &g_define_type_info, 0);
	ValaCreationMethod_private_offset = g_type_add_instance_private (vala_creation_method_type_id, sizeof (ValaCreationMethodPrivate));
	return vala_creation_method_type_id;
}

GType
vala_creation_method_get_type (void)
{
	static volatile gsize vala_creation_method_type_id__volatile = 0;
	if (g_once_init_enter (&vala_creation_method_type_id__volatile)) {
		GType vala_creation_method_type_id;
		vala_creation_method_type_id = vala_creation_method_get_type_once ();
		g_once_init_leave (&vala_creation_method_type_id__volatile, vala_creation_method_type_id);
	}
	return vala_creation_method_type_id__volatile;
}

