/* valaobjectcreationexpression.c generated by valac, the Vala compiler
 * generated from valaobjectcreationexpression.vala, do not modify */

/* valaobjectcreationexpression.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaObjectCreationExpressionPrivate {
	gboolean _is_yield_expression;
	gboolean _is_chainup;
	gboolean _struct_creation;
	ValaList* argument_list;
	ValaList* object_initializer;
	ValaDataType* _data_type;
	ValaMemberAccess* _member_name;
};

static gint ValaObjectCreationExpression_private_offset;
static gpointer vala_object_creation_expression_parent_class = NULL;
static ValaCallableExpressionIface * vala_object_creation_expression_vala_callable_expression_parent_iface = NULL;

static void vala_object_creation_expression_set_type_reference (ValaObjectCreationExpression* self,
                                                         ValaDataType* value);
static void vala_object_creation_expression_set_member_name (ValaObjectCreationExpression* self,
                                                      ValaMemberAccess* value);
static void vala_object_creation_expression_real_add_argument (ValaCallableExpression* base,
                                                        ValaExpression* arg);
static ValaList* vala_object_creation_expression_real_get_argument_list (ValaCallableExpression* base);
static void vala_object_creation_expression_real_accept (ValaCodeNode* base,
                                                  ValaCodeVisitor* visitor);
static void vala_object_creation_expression_real_accept_children (ValaCodeNode* base,
                                                           ValaCodeVisitor* visitor);
static void vala_object_creation_expression_real_replace_expression (ValaCodeNode* base,
                                                              ValaExpression* old_node,
                                                              ValaExpression* new_node);
static gboolean vala_object_creation_expression_real_is_pure (ValaExpression* base);
static gboolean vala_object_creation_expression_real_is_accessible (ValaExpression* base,
                                                             ValaSymbol* sym);
static void vala_object_creation_expression_real_replace_type (ValaCodeNode* base,
                                                        ValaDataType* old_type,
                                                        ValaDataType* new_type);
static gboolean vala_object_creation_expression_real_check (ValaCodeNode* base,
                                                     ValaCodeContext* context);
static void vala_object_creation_expression_real_get_error_types (ValaCodeNode* base,
                                                           ValaCollection* collection,
                                                           ValaSourceReference* source_reference);
static void vala_object_creation_expression_real_emit (ValaCodeNode* base,
                                                ValaCodeGenerator* codegen);
static void vala_object_creation_expression_real_get_defined_variables (ValaCodeNode* base,
                                                                 ValaCollection* collection);
static void vala_object_creation_expression_real_get_used_variables (ValaCodeNode* base,
                                                              ValaCollection* collection);
static gchar* vala_object_creation_expression_real_to_string (ValaCodeNode* base);
static void vala_object_creation_expression_finalize (ValaCodeNode * obj);
static GType vala_object_creation_expression_get_type_once (void);

static inline gpointer
vala_object_creation_expression_get_instance_private (ValaObjectCreationExpression* self)
{
	return G_STRUCT_MEMBER_P (self, ValaObjectCreationExpression_private_offset);
}

ValaDataType*
vala_object_creation_expression_get_type_reference (ValaObjectCreationExpression* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_data_type;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static void
vala_object_creation_expression_set_type_reference (ValaObjectCreationExpression* self,
                                                    ValaDataType* value)
{
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_data_type);
	self->priv->_data_type = _tmp0_;
	_tmp1_ = self->priv->_data_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

ValaMemberAccess*
vala_object_creation_expression_get_member_name (ValaObjectCreationExpression* self)
{
	ValaMemberAccess* result;
	ValaMemberAccess* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_member_name;
	result = _tmp0_;
	return result;
}

static void
vala_object_creation_expression_set_member_name (ValaObjectCreationExpression* self,
                                                 ValaMemberAccess* value)
{
	ValaMemberAccess* _tmp0_;
	ValaMemberAccess* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_member_name);
	self->priv->_member_name = _tmp0_;
	_tmp1_ = self->priv->_member_name;
	if (_tmp1_ != NULL) {
		ValaMemberAccess* _tmp2_;
		_tmp2_ = self->priv->_member_name;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}

static gboolean
vala_object_creation_expression_real_get_is_yield_expression (ValaCallableExpression* base)
{
	gboolean result;
	ValaObjectCreationExpression* self;
	self = (ValaObjectCreationExpression*) base;
	result = self->priv->_is_yield_expression;
	return result;
}

static void
vala_object_creation_expression_real_set_is_yield_expression (ValaCallableExpression* base,
                                                              gboolean value)
{
	ValaObjectCreationExpression* self;
	self = (ValaObjectCreationExpression*) base;
	self->priv->_is_yield_expression = value;
}

static gboolean
vala_object_creation_expression_real_get_is_chainup (ValaCallableExpression* base)
{
	gboolean result;
	ValaObjectCreationExpression* self;
	self = (ValaObjectCreationExpression*) base;
	result = self->priv->_is_chainup;
	return result;
}

static void
vala_object_creation_expression_real_set_is_chainup (ValaCallableExpression* base,
                                                     gboolean value)
{
	ValaObjectCreationExpression* self;
	self = (ValaObjectCreationExpression*) base;
	self->priv->_is_chainup = value;
}

gboolean
vala_object_creation_expression_get_struct_creation (ValaObjectCreationExpression* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_struct_creation;
	return result;
}

void
vala_object_creation_expression_set_struct_creation (ValaObjectCreationExpression* self,
                                                     gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_struct_creation = value;
}

/**
 * Creates a new object creation expression.
 *
 * @param member_name      object type to create
 * @param source_reference reference to source code
 * @return                 newly created object creation expression
 */
ValaObjectCreationExpression*
vala_object_creation_expression_construct (GType object_type,
                                           ValaMemberAccess* member_name,
                                           ValaSourceReference* source_reference)
{
	ValaObjectCreationExpression* self = NULL;
	self = (ValaObjectCreationExpression*) vala_expression_construct (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_object_creation_expression_set_member_name (self, member_name);
	return self;
}

ValaObjectCreationExpression*
vala_object_creation_expression_new (ValaMemberAccess* member_name,
                                     ValaSourceReference* source_reference)
{
	return vala_object_creation_expression_construct (VALA_TYPE_OBJECT_CREATION_EXPRESSION, member_name, source_reference);
}

/**
 * Appends the specified expression to the list of arguments.
 *
 * @param arg an argument
 */
static void
vala_object_creation_expression_real_add_argument (ValaCallableExpression* base,
                                                   ValaExpression* arg)
{
	ValaObjectCreationExpression * self;
	ValaList* _tmp0_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}

/**
 * Returns the argument list.
 *
 * @return argument list
 */
static ValaList*
vala_object_creation_expression_real_get_argument_list (ValaCallableExpression* base)
{
	ValaObjectCreationExpression * self;
	ValaList* _tmp0_;
	ValaList* result;
	self = (ValaObjectCreationExpression*) base;
	_tmp0_ = self->priv->argument_list;
	result = _tmp0_;
	return result;
}

/**
 * Appends the specified member initializer to the object initializer.
 *
 * @param init a member initializer
 */
void
vala_object_creation_expression_add_member_initializer (ValaObjectCreationExpression* self,
                                                        ValaMemberInitializer* init)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (init != NULL);
	_tmp0_ = self->priv->object_initializer;
	vala_collection_add ((ValaCollection*) _tmp0_, init);
	vala_code_node_set_parent_node ((ValaCodeNode*) init, (ValaCodeNode*) self);
}

/**
 * Returns the object initializer.
 *
 * @return member initializer list
 */
ValaList*
vala_object_creation_expression_get_object_initializer (ValaObjectCreationExpression* self)
{
	ValaList* _tmp0_;
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->object_initializer;
	result = _tmp0_;
	return result;
}

static void
vala_object_creation_expression_real_accept (ValaCodeNode* base,
                                             ValaCodeVisitor* visitor)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_object_creation_expression (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_object_creation_expression_real_accept_children (ValaCodeNode* base,
                                                      ValaCodeVisitor* visitor)
{
	ValaObjectCreationExpression * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaMemberAccess* _tmp4_;
	ValaMemberAccess* _tmp5_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_object_creation_expression_get_type_reference (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaDataType* _tmp2_;
		ValaDataType* _tmp3_;
		_tmp2_ = vala_object_creation_expression_get_type_reference (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	_tmp4_ = vala_object_creation_expression_get_member_name (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaMemberAccess* _tmp6_;
		ValaMemberAccess* _tmp7_;
		_tmp6_ = vala_object_creation_expression_get_member_name (self);
		_tmp7_ = _tmp6_;
		vala_code_node_accept ((ValaCodeNode*) _tmp7_, visitor);
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp8_;
		gint _arg_size = 0;
		ValaList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _arg_index = 0;
		_tmp8_ = self->priv->argument_list;
		_arg_list = _tmp8_;
		_tmp9_ = _arg_list;
		_tmp10_ = vala_collection_get_size ((ValaCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		_arg_size = _tmp11_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp12_;
			gint _tmp13_;
			ValaExpression* arg = NULL;
			ValaList* _tmp14_;
			gpointer _tmp15_;
			ValaExpression* _tmp16_;
			_arg_index = _arg_index + 1;
			_tmp12_ = _arg_index;
			_tmp13_ = _arg_size;
			if (!(_tmp12_ < _tmp13_)) {
				break;
			}
			_tmp14_ = _arg_list;
			_tmp15_ = vala_list_get (_tmp14_, _arg_index);
			arg = (ValaExpression*) _tmp15_;
			_tmp16_ = arg;
			vala_code_node_accept ((ValaCodeNode*) _tmp16_, visitor);
			_vala_code_node_unref0 (arg);
		}
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp17_;
		gint _init_size = 0;
		ValaList* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _init_index = 0;
		_tmp17_ = self->priv->object_initializer;
		_init_list = _tmp17_;
		_tmp18_ = _init_list;
		_tmp19_ = vala_collection_get_size ((ValaCollection*) _tmp18_);
		_tmp20_ = _tmp19_;
		_init_size = _tmp20_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp21_;
			gint _tmp22_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp23_;
			gpointer _tmp24_;
			ValaMemberInitializer* _tmp25_;
			_init_index = _init_index + 1;
			_tmp21_ = _init_index;
			_tmp22_ = _init_size;
			if (!(_tmp21_ < _tmp22_)) {
				break;
			}
			_tmp23_ = _init_list;
			_tmp24_ = vala_list_get (_tmp23_, _init_index);
			init = (ValaMemberInitializer*) _tmp24_;
			_tmp25_ = init;
			vala_code_node_accept ((ValaCodeNode*) _tmp25_, visitor);
			_vala_code_node_unref0 (init);
		}
	}
}

static void
vala_object_creation_expression_real_replace_expression (ValaCodeNode* base,
                                                         ValaExpression* old_node,
                                                         ValaExpression* new_node)
{
	ValaObjectCreationExpression * self;
	gint index = 0;
	ValaList* _tmp0_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = self->priv->argument_list;
	index = vala_list_index_of (_tmp0_, old_node);
	if (index >= 0) {
		ValaList* _tmp1_;
		_tmp1_ = self->priv->argument_list;
		vala_list_set (_tmp1_, index, new_node);
		vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
	}
}

static gboolean
vala_object_creation_expression_real_is_pure (ValaExpression* base)
{
	ValaObjectCreationExpression * self;
	gboolean result;
	self = (ValaObjectCreationExpression*) base;
	result = FALSE;
	return result;
}

static gboolean
vala_object_creation_expression_real_is_accessible (ValaExpression* base,
                                                    ValaSymbol* sym)
{
	ValaObjectCreationExpression * self;
	gboolean _tmp0_ = FALSE;
	ValaMemberAccess* _tmp1_;
	ValaMemberAccess* _tmp2_;
	gboolean result;
	self = (ValaObjectCreationExpression*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp1_ = vala_object_creation_expression_get_member_name (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		ValaMemberAccess* _tmp3_;
		ValaMemberAccess* _tmp4_;
		_tmp3_ = vala_object_creation_expression_get_member_name (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = !vala_expression_is_accessible ((ValaExpression*) _tmp4_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp5_;
		gint _arg_size = 0;
		ValaList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _arg_index = 0;
		_tmp5_ = self->priv->argument_list;
		_arg_list = _tmp5_;
		_tmp6_ = _arg_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_arg_size = _tmp8_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			ValaExpression* arg = NULL;
			ValaList* _tmp11_;
			gpointer _tmp12_;
			ValaExpression* _tmp13_;
			_arg_index = _arg_index + 1;
			_tmp9_ = _arg_index;
			_tmp10_ = _arg_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _arg_list;
			_tmp12_ = vala_list_get (_tmp11_, _arg_index);
			arg = (ValaExpression*) _tmp12_;
			_tmp13_ = arg;
			if (!vala_expression_is_accessible (_tmp13_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (arg);
				return result;
			}
			_vala_code_node_unref0 (arg);
		}
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp14_;
		gint _init_size = 0;
		ValaList* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gint _init_index = 0;
		_tmp14_ = self->priv->object_initializer;
		_init_list = _tmp14_;
		_tmp15_ = _init_list;
		_tmp16_ = vala_collection_get_size ((ValaCollection*) _tmp15_);
		_tmp17_ = _tmp16_;
		_init_size = _tmp17_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp18_;
			gint _tmp19_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp20_;
			gpointer _tmp21_;
			ValaMemberInitializer* _tmp22_;
			ValaExpression* _tmp23_;
			ValaExpression* _tmp24_;
			_init_index = _init_index + 1;
			_tmp18_ = _init_index;
			_tmp19_ = _init_size;
			if (!(_tmp18_ < _tmp19_)) {
				break;
			}
			_tmp20_ = _init_list;
			_tmp21_ = vala_list_get (_tmp20_, _init_index);
			init = (ValaMemberInitializer*) _tmp21_;
			_tmp22_ = init;
			_tmp23_ = vala_member_initializer_get_initializer (_tmp22_);
			_tmp24_ = _tmp23_;
			if (!vala_expression_is_accessible (_tmp24_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (init);
				return result;
			}
			_vala_code_node_unref0 (init);
		}
	}
	result = TRUE;
	return result;
}

static void
vala_object_creation_expression_real_replace_type (ValaCodeNode* base,
                                                   ValaDataType* old_type,
                                                   ValaDataType* new_type)
{
	ValaObjectCreationExpression * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_object_creation_expression_get_type_reference (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_object_creation_expression_set_type_reference (self, new_type);
	}
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static gboolean
vala_object_creation_expression_real_check (ValaCodeNode* base,
                                            ValaCodeContext* context)
{
	ValaObjectCreationExpression * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaMemberAccess* _tmp4_;
	ValaMemberAccess* _tmp5_;
	ValaTypeSymbol* type = NULL;
	ValaDataType* _tmp8_;
	ValaDataType* _tmp9_;
	ValaDataType* _tmp110_;
	ValaDataType* _tmp111_;
	ValaDataType* _tmp112_;
	ValaDataType* _tmp113_;
	ValaDataType* _tmp114_;
	ValaDataType* _tmp115_;
	ValaTypeSymbol* _tmp116_;
	ValaDataType* _tmp222_;
	ValaDataType* _tmp223_;
	gboolean _tmp224_ = FALSE;
	ValaSymbol* _tmp225_;
	ValaSymbol* _tmp226_;
	ValaSymbol* _tmp235_;
	ValaSymbol* _tmp236_;
	ValaTypeSymbol* _tmp489_;
	gboolean _tmp490_;
	gboolean _tmp491_;
	gboolean _tmp579_;
	gboolean _tmp580_;
	gboolean _tmp636_;
	gboolean _tmp637_;
	gboolean result;
	self = (ValaObjectCreationExpression*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_object_creation_expression_get_member_name (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaMemberAccess* _tmp6_;
		ValaMemberAccess* _tmp7_;
		_tmp6_ = vala_object_creation_expression_get_member_name (self);
		_tmp7_ = _tmp6_;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp7_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			return result;
		}
	}
	_tmp8_ = vala_object_creation_expression_get_type_reference (self);
	_tmp9_ = _tmp8_;
	if (_tmp9_ == NULL) {
		ValaMemberAccess* _tmp10_;
		ValaMemberAccess* _tmp11_;
		ValaMemberAccess* _tmp14_;
		ValaMemberAccess* _tmp15_;
		ValaSymbol* _tmp16_;
		ValaSymbol* _tmp17_;
		ValaSymbol* constructor_sym = NULL;
		ValaMemberAccess* _tmp18_;
		ValaMemberAccess* _tmp19_;
		ValaSymbol* _tmp20_;
		ValaSymbol* _tmp21_;
		ValaSymbol* _tmp22_;
		ValaSymbol* type_sym = NULL;
		ValaMemberAccess* _tmp23_;
		ValaMemberAccess* _tmp24_;
		ValaSymbol* _tmp25_;
		ValaSymbol* _tmp26_;
		ValaSymbol* _tmp27_;
		ValaList* type_args = NULL;
		ValaMemberAccess* _tmp28_;
		ValaMemberAccess* _tmp29_;
		ValaList* _tmp30_;
		ValaList* _tmp31_;
		ValaSymbol* _tmp32_;
		ValaSymbol* _tmp54_;
		_tmp10_ = vala_object_creation_expression_get_member_name (self);
		_tmp11_ = _tmp10_;
		if (_tmp11_ == NULL) {
			ValaSourceReference* _tmp12_;
			ValaSourceReference* _tmp13_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp12_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp13_ = _tmp12_;
			vala_report_error (_tmp13_, "Incomplete object creation expression");
			result = FALSE;
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp14_ = vala_object_creation_expression_get_member_name (self);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp15_);
		_tmp17_ = _tmp16_;
		if (_tmp17_ == NULL) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp18_ = vala_object_creation_expression_get_member_name (self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = _vala_code_node_ref0 (_tmp21_);
		constructor_sym = _tmp22_;
		_tmp23_ = vala_object_creation_expression_get_member_name (self);
		_tmp24_ = _tmp23_;
		_tmp25_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = _vala_code_node_ref0 (_tmp26_);
		type_sym = _tmp27_;
		_tmp28_ = vala_object_creation_expression_get_member_name (self);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_member_access_get_type_arguments (_tmp29_);
		_tmp31_ = _vala_iterable_ref0 (_tmp30_);
		type_args = _tmp31_;
		_tmp32_ = constructor_sym;
		if (VALA_IS_METHOD (_tmp32_)) {
			ValaSymbol* _tmp33_;
			ValaSymbol* _tmp34_;
			ValaSymbol* _tmp35_;
			ValaSymbol* _tmp36_;
			ValaMethod* constructor = NULL;
			ValaSymbol* _tmp37_;
			ValaMethod* _tmp38_;
			ValaSymbol* _tmp39_;
			ValaMethod* _tmp45_;
			ValaMemberAccess* ma = NULL;
			ValaMemberAccess* _tmp46_;
			ValaMemberAccess* _tmp47_;
			ValaExpression* _tmp48_;
			ValaExpression* _tmp49_;
			ValaMemberAccess* _tmp50_;
			_tmp33_ = constructor_sym;
			_tmp34_ = vala_symbol_get_parent_symbol (_tmp33_);
			_tmp35_ = _tmp34_;
			_tmp36_ = _vala_code_node_ref0 (_tmp35_);
			_vala_code_node_unref0 (type_sym);
			type_sym = _tmp36_;
			_tmp37_ = constructor_sym;
			_tmp38_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, VALA_TYPE_METHOD, ValaMethod));
			constructor = _tmp38_;
			_tmp39_ = constructor_sym;
			if (!VALA_IS_CREATION_METHOD (_tmp39_)) {
				ValaSourceReference* _tmp40_;
				ValaSourceReference* _tmp41_;
				ValaMethod* _tmp42_;
				gchar* _tmp43_;
				gchar* _tmp44_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp40_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp41_ = _tmp40_;
				_tmp42_ = constructor;
				_tmp43_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp42_);
				_tmp44_ = _tmp43_;
				vala_report_error (_tmp41_, "`%s' is not a creation method", _tmp44_);
				_g_free0 (_tmp44_);
				result = FALSE;
				_vala_code_node_unref0 (constructor);
				_vala_iterable_unref0 (type_args);
				_vala_code_node_unref0 (type_sym);
				_vala_code_node_unref0 (constructor_sym);
				_vala_code_node_unref0 (type);
				return result;
			}
			_tmp45_ = constructor;
			vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp45_);
			_tmp46_ = vala_object_creation_expression_get_member_name (self);
			_tmp47_ = _tmp46_;
			_tmp48_ = vala_member_access_get_inner (_tmp47_);
			_tmp49_ = _tmp48_;
			ma = VALA_IS_MEMBER_ACCESS (_tmp49_) ? ((ValaMemberAccess*) _tmp49_) : NULL;
			_tmp50_ = ma;
			if (_tmp50_ != NULL) {
				ValaMemberAccess* _tmp51_;
				ValaList* _tmp52_;
				ValaList* _tmp53_;
				_tmp51_ = ma;
				_tmp52_ = vala_member_access_get_type_arguments (_tmp51_);
				_tmp53_ = _vala_iterable_ref0 (_tmp52_);
				_vala_iterable_unref0 (type_args);
				type_args = _tmp53_;
			}
			_vala_code_node_unref0 (constructor);
		}
		_tmp54_ = type_sym;
		if (VALA_IS_CLASS (_tmp54_)) {
			ValaSymbol* _tmp55_;
			ValaTypeSymbol* _tmp56_;
			ValaTypeSymbol* _tmp57_;
			gboolean _tmp58_;
			gboolean _tmp59_;
			_tmp55_ = type_sym;
			_tmp56_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
			_vala_code_node_unref0 (type);
			type = _tmp56_;
			_tmp57_ = type;
			_tmp58_ = vala_class_get_is_error_base (G_TYPE_CHECK_INSTANCE_CAST (_tmp57_, VALA_TYPE_CLASS, ValaClass));
			_tmp59_ = _tmp58_;
			if (_tmp59_) {
				ValaSourceReference* _tmp60_;
				ValaSourceReference* _tmp61_;
				ValaErrorType* _tmp62_;
				ValaErrorType* _tmp63_;
				_tmp60_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp61_ = _tmp60_;
				_tmp62_ = vala_error_type_new (NULL, NULL, _tmp61_);
				_tmp63_ = _tmp62_;
				vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp63_);
				_vala_code_node_unref0 (_tmp63_);
			} else {
				ValaTypeSymbol* _tmp64_;
				ValaSourceReference* _tmp65_;
				ValaSourceReference* _tmp66_;
				ValaObjectType* _tmp67_;
				ValaObjectType* _tmp68_;
				_tmp64_ = type;
				_tmp65_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp66_ = _tmp65_;
				_tmp67_ = vala_object_type_new ((ValaObjectTypeSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp64_, VALA_TYPE_CLASS, ValaClass), _tmp66_);
				_tmp68_ = _tmp67_;
				vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp68_);
				_vala_code_node_unref0 (_tmp68_);
			}
		} else {
			ValaSymbol* _tmp69_;
			_tmp69_ = type_sym;
			if (VALA_IS_STRUCT (_tmp69_)) {
				ValaSymbol* _tmp70_;
				ValaTypeSymbol* _tmp71_;
				ValaTypeSymbol* _tmp72_;
				ValaSourceReference* _tmp73_;
				ValaSourceReference* _tmp74_;
				ValaStructValueType* _tmp75_;
				ValaStructValueType* _tmp76_;
				_tmp70_ = type_sym;
				_tmp71_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp70_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
				_vala_code_node_unref0 (type);
				type = _tmp71_;
				_tmp72_ = type;
				_tmp73_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp74_ = _tmp73_;
				_tmp75_ = vala_struct_value_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp72_, VALA_TYPE_STRUCT, ValaStruct), _tmp74_);
				_tmp76_ = _tmp75_;
				vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp76_);
				_vala_code_node_unref0 (_tmp76_);
			} else {
				ValaSymbol* _tmp77_;
				_tmp77_ = type_sym;
				if (VALA_IS_ERROR_CODE (_tmp77_)) {
					ValaSymbol* _tmp78_;
					ValaTypeSymbol* _tmp79_;
					ValaSymbol* _tmp80_;
					ValaSymbol* _tmp81_;
					ValaSymbol* _tmp82_;
					ValaSymbol* _tmp83_;
					ValaSourceReference* _tmp84_;
					ValaSourceReference* _tmp85_;
					ValaErrorType* _tmp86_;
					ValaErrorType* _tmp87_;
					ValaSymbol* _tmp88_;
					_tmp78_ = type_sym;
					_tmp79_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp78_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
					_vala_code_node_unref0 (type);
					type = _tmp79_;
					_tmp80_ = type_sym;
					_tmp81_ = vala_symbol_get_parent_symbol (_tmp80_);
					_tmp82_ = _tmp81_;
					_tmp83_ = type_sym;
					_tmp84_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp85_ = _tmp84_;
					_tmp86_ = vala_error_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp82_, VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain), G_TYPE_CHECK_INSTANCE_CAST (_tmp83_, VALA_TYPE_ERROR_CODE, ValaErrorCode), _tmp85_);
					_tmp87_ = _tmp86_;
					vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp87_);
					_vala_code_node_unref0 (_tmp87_);
					_tmp88_ = type_sym;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp88_);
				} else {
					ValaSourceReference* _tmp89_;
					ValaSourceReference* _tmp90_;
					ValaSymbol* _tmp91_;
					gchar* _tmp92_;
					gchar* _tmp93_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp89_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp90_ = _tmp89_;
					_tmp91_ = type_sym;
					_tmp92_ = vala_symbol_get_full_name (_tmp91_);
					_tmp93_ = _tmp92_;
					vala_report_error (_tmp90_, "`%s' is not a class, struct, or error code", _tmp93_);
					_g_free0 (_tmp93_);
					result = FALSE;
					_vala_iterable_unref0 (type_args);
					_vala_code_node_unref0 (type_sym);
					_vala_code_node_unref0 (constructor_sym);
					_vala_code_node_unref0 (type);
					return result;
				}
			}
		}
		{
			ValaList* _type_arg_list = NULL;
			ValaList* _tmp94_;
			gint _type_arg_size = 0;
			ValaList* _tmp95_;
			gint _tmp96_;
			gint _tmp97_;
			gint _type_arg_index = 0;
			_tmp94_ = type_args;
			_type_arg_list = _tmp94_;
			_tmp95_ = _type_arg_list;
			_tmp96_ = vala_collection_get_size ((ValaCollection*) _tmp95_);
			_tmp97_ = _tmp96_;
			_type_arg_size = _tmp97_;
			_type_arg_index = -1;
			while (TRUE) {
				gint _tmp98_;
				gint _tmp99_;
				ValaDataType* type_arg = NULL;
				ValaList* _tmp100_;
				gpointer _tmp101_;
				ValaDataType* _tmp102_;
				ValaDataType* _tmp103_;
				ValaDataType* _tmp104_;
				_type_arg_index = _type_arg_index + 1;
				_tmp98_ = _type_arg_index;
				_tmp99_ = _type_arg_size;
				if (!(_tmp98_ < _tmp99_)) {
					break;
				}
				_tmp100_ = _type_arg_list;
				_tmp101_ = vala_list_get (_tmp100_, _type_arg_index);
				type_arg = (ValaDataType*) _tmp101_;
				_tmp102_ = vala_object_creation_expression_get_type_reference (self);
				_tmp103_ = _tmp102_;
				_tmp104_ = type_arg;
				vala_data_type_add_type_argument (_tmp103_, _tmp104_);
				_vala_code_node_unref0 (type_arg);
			}
		}
		_vala_iterable_unref0 (type_args);
		_vala_code_node_unref0 (type_sym);
		_vala_code_node_unref0 (constructor_sym);
	} else {
		ValaDataType* _tmp105_;
		ValaDataType* _tmp106_;
		ValaTypeSymbol* _tmp107_;
		ValaTypeSymbol* _tmp108_;
		ValaTypeSymbol* _tmp109_;
		_tmp105_ = vala_object_creation_expression_get_type_reference (self);
		_tmp106_ = _tmp105_;
		_tmp107_ = vala_data_type_get_type_symbol (_tmp106_);
		_tmp108_ = _tmp107_;
		_tmp109_ = _vala_code_node_ref0 (_tmp108_);
		_vala_code_node_unref0 (type);
		type = _tmp109_;
	}
	_tmp110_ = vala_object_creation_expression_get_type_reference (self);
	_tmp111_ = _tmp110_;
	_tmp112_ = vala_data_type_copy (_tmp111_);
	_tmp113_ = _tmp112_;
	vala_expression_set_value_type ((ValaExpression*) self, _tmp113_);
	_vala_code_node_unref0 (_tmp113_);
	_tmp114_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp115_ = _tmp114_;
	vala_data_type_set_value_owned (_tmp115_, TRUE);
	_tmp116_ = type;
	if (VALA_IS_CLASS (_tmp116_)) {
		ValaClass* cl = NULL;
		ValaTypeSymbol* _tmp117_;
		ValaClass* _tmp118_;
		gboolean _tmp119_;
		ValaClass* _tmp122_;
		gboolean _tmp123_;
		gboolean _tmp124_;
		ValaSymbol* _tmp130_;
		ValaSymbol* _tmp131_;
		gboolean _tmp150_ = FALSE;
		ValaSymbol* _tmp151_;
		ValaSymbol* _tmp152_;
		_tmp117_ = type;
		_tmp118_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp117_, VALA_TYPE_CLASS, ValaClass));
		cl = _tmp118_;
		_tmp119_ = self->priv->_struct_creation;
		if (_tmp119_) {
			ValaSourceReference* _tmp120_;
			ValaSourceReference* _tmp121_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp120_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp121_ = _tmp120_;
			vala_report_error (_tmp121_, "syntax error, use `new' to create new objects");
			result = FALSE;
			_vala_code_node_unref0 (cl);
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp122_ = cl;
		_tmp123_ = vala_class_get_is_abstract (_tmp122_);
		_tmp124_ = _tmp123_;
		if (_tmp124_) {
			ValaSourceReference* _tmp125_;
			ValaSourceReference* _tmp126_;
			ValaClass* _tmp127_;
			gchar* _tmp128_;
			gchar* _tmp129_;
			vala_expression_set_value_type ((ValaExpression*) self, NULL);
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp125_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp126_ = _tmp125_;
			_tmp127_ = cl;
			_tmp128_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp127_);
			_tmp129_ = _tmp128_;
			vala_report_error (_tmp126_, "Can't create instance of abstract class `%s'", _tmp129_);
			_g_free0 (_tmp129_);
			result = FALSE;
			_vala_code_node_unref0 (cl);
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp130_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp131_ = _tmp130_;
		if (_tmp131_ == NULL) {
			ValaClass* _tmp132_;
			ValaCreationMethod* _tmp133_;
			ValaCreationMethod* _tmp134_;
			ValaSymbol* _tmp135_;
			ValaSymbol* _tmp136_;
			ValaSymbol* _tmp142_;
			ValaSymbol* _tmp143_;
			ValaSymbol* _tmp144_;
			ValaSymbol* _tmp145_;
			ValaVersionAttribute* _tmp146_;
			ValaVersionAttribute* _tmp147_;
			ValaSourceReference* _tmp148_;
			ValaSourceReference* _tmp149_;
			_tmp132_ = cl;
			_tmp133_ = vala_class_get_default_construction_method (_tmp132_);
			_tmp134_ = _tmp133_;
			vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp134_);
			_tmp135_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp136_ = _tmp135_;
			if (_tmp136_ == NULL) {
				ValaSourceReference* _tmp137_;
				ValaSourceReference* _tmp138_;
				ValaClass* _tmp139_;
				gchar* _tmp140_;
				gchar* _tmp141_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp137_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp138_ = _tmp137_;
				_tmp139_ = cl;
				_tmp140_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp139_);
				_tmp141_ = _tmp140_;
				vala_report_error (_tmp138_, "`%s' does not have a default constructor", _tmp141_);
				_g_free0 (_tmp141_);
				result = FALSE;
				_vala_code_node_unref0 (cl);
				_vala_code_node_unref0 (type);
				return result;
			}
			_tmp142_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp143_ = _tmp142_;
			vala_symbol_set_used (_tmp143_, TRUE);
			_tmp144_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp145_ = _tmp144_;
			_tmp146_ = vala_symbol_get_version (_tmp145_);
			_tmp147_ = _tmp146_;
			_tmp148_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp149_ = _tmp148_;
			vala_version_attribute_check (_tmp147_, context, _tmp149_);
		}
		_tmp151_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp152_ = _tmp151_;
		if (_tmp152_ != NULL) {
			gboolean _tmp153_ = FALSE;
			ValaSymbol* _tmp154_;
			ValaSymbol* _tmp155_;
			ValaSymbolAccessibility _tmp156_;
			ValaSymbolAccessibility _tmp157_;
			_tmp154_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp155_ = _tmp154_;
			_tmp156_ = vala_symbol_get_access (_tmp155_);
			_tmp157_ = _tmp156_;
			if (_tmp157_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
				_tmp153_ = TRUE;
			} else {
				ValaSymbol* _tmp158_;
				ValaSymbol* _tmp159_;
				ValaSymbolAccessibility _tmp160_;
				ValaSymbolAccessibility _tmp161_;
				_tmp158_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp159_ = _tmp158_;
				_tmp160_ = vala_symbol_get_access (_tmp159_);
				_tmp161_ = _tmp160_;
				_tmp153_ = _tmp161_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED;
			}
			_tmp150_ = _tmp153_;
		} else {
			_tmp150_ = FALSE;
		}
		if (_tmp150_) {
			gboolean in_target_type = FALSE;
			in_target_type = FALSE;
			{
				ValaSymbol* this_symbol = NULL;
				ValaSemanticAnalyzer* _tmp162_;
				ValaSemanticAnalyzer* _tmp163_;
				ValaSymbol* _tmp164_;
				ValaSymbol* _tmp165_;
				ValaSymbol* _tmp166_;
				_tmp162_ = vala_code_context_get_analyzer (context);
				_tmp163_ = _tmp162_;
				_tmp164_ = vala_semantic_analyzer_get_current_symbol (_tmp163_);
				_tmp165_ = _tmp164_;
				_tmp166_ = _vala_code_node_ref0 (_tmp165_);
				this_symbol = _tmp166_;
				{
					gboolean _tmp167_ = FALSE;
					_tmp167_ = TRUE;
					while (TRUE) {
						ValaSymbol* _tmp172_;
						ValaSymbol* _tmp173_;
						ValaClass* _tmp174_;
						if (!_tmp167_) {
							ValaSymbol* _tmp168_;
							ValaSymbol* _tmp169_;
							ValaSymbol* _tmp170_;
							ValaSymbol* _tmp171_;
							_tmp168_ = this_symbol;
							_tmp169_ = vala_symbol_get_parent_symbol (_tmp168_);
							_tmp170_ = _tmp169_;
							_tmp171_ = _vala_code_node_ref0 (_tmp170_);
							_vala_code_node_unref0 (this_symbol);
							this_symbol = _tmp171_;
						}
						_tmp167_ = FALSE;
						_tmp172_ = this_symbol;
						if (!(_tmp172_ != NULL)) {
							break;
						}
						_tmp173_ = this_symbol;
						_tmp174_ = cl;
						if (_tmp173_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp174_, VALA_TYPE_SYMBOL, ValaSymbol)) {
							in_target_type = TRUE;
							break;
						}
					}
				}
				_vala_code_node_unref0 (this_symbol);
			}
			if (!in_target_type) {
				ValaSourceReference* _tmp175_;
				ValaSourceReference* _tmp176_;
				ValaSymbol* _tmp177_;
				ValaSymbol* _tmp178_;
				gchar* _tmp179_;
				gchar* _tmp180_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp175_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp176_ = _tmp175_;
				_tmp177_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp178_ = _tmp177_;
				_tmp179_ = vala_symbol_get_full_name (_tmp178_);
				_tmp180_ = _tmp179_;
				vala_report_error (_tmp176_, "Access to non-public constructor `%s' denied", _tmp180_);
				_g_free0 (_tmp180_);
				result = FALSE;
				_vala_code_node_unref0 (cl);
				_vala_code_node_unref0 (type);
				return result;
			}
		}
		while (TRUE) {
			ValaClass* _tmp181_;
			ValaClass* _tmp182_;
			gchar* _tmp183_;
			gchar* _tmp184_;
			gboolean _tmp185_;
			ValaClass* _tmp188_;
			ValaClass* _tmp189_;
			ValaClass* _tmp190_;
			ValaClass* _tmp191_;
			_tmp181_ = cl;
			if (!(_tmp181_ != NULL)) {
				break;
			}
			_tmp182_ = cl;
			_tmp183_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp182_, "CCode", "ref_sink_function", NULL);
			_tmp184_ = _tmp183_;
			_tmp185_ = _tmp184_ != NULL;
			_g_free0 (_tmp184_);
			if (_tmp185_) {
				ValaDataType* _tmp186_;
				ValaDataType* _tmp187_;
				_tmp186_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp187_ = _tmp186_;
				vala_data_type_set_floating_reference (_tmp187_, TRUE);
				break;
			}
			_tmp188_ = cl;
			_tmp189_ = vala_class_get_base_class (_tmp188_);
			_tmp190_ = _tmp189_;
			_tmp191_ = _vala_code_node_ref0 (_tmp190_);
			_vala_code_node_unref0 (cl);
			cl = _tmp191_;
		}
		_vala_code_node_unref0 (cl);
	} else {
		ValaTypeSymbol* _tmp192_;
		_tmp192_ = type;
		if (VALA_IS_STRUCT (_tmp192_)) {
			ValaStruct* st = NULL;
			ValaTypeSymbol* _tmp193_;
			ValaStruct* _tmp194_;
			gboolean _tmp195_ = FALSE;
			gboolean _tmp196_;
			ValaSymbol* _tmp201_;
			ValaSymbol* _tmp202_;
			gboolean _tmp206_ = FALSE;
			gboolean _tmp207_ = FALSE;
			gboolean _tmp208_ = FALSE;
			ValaProfile _tmp209_;
			ValaProfile _tmp210_;
			_tmp193_ = type;
			_tmp194_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp193_, VALA_TYPE_STRUCT, ValaStruct));
			st = _tmp194_;
			_tmp196_ = self->priv->_struct_creation;
			if (!_tmp196_) {
				gboolean _tmp197_;
				gboolean _tmp198_;
				_tmp197_ = vala_code_context_get_deprecated (context);
				_tmp198_ = _tmp197_;
				_tmp195_ = !_tmp198_;
			} else {
				_tmp195_ = FALSE;
			}
			if (_tmp195_) {
				ValaSourceReference* _tmp199_;
				ValaSourceReference* _tmp200_;
				_tmp199_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp200_ = _tmp199_;
				vala_report_warning (_tmp200_, "deprecated syntax, don't use `new' to initialize structs");
			}
			_tmp201_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp202_ = _tmp201_;
			if (_tmp202_ == NULL) {
				ValaStruct* _tmp203_;
				ValaCreationMethod* _tmp204_;
				ValaCreationMethod* _tmp205_;
				_tmp203_ = st;
				_tmp204_ = vala_struct_get_default_construction_method (_tmp203_);
				_tmp205_ = _tmp204_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp205_);
			}
			_tmp209_ = vala_code_context_get_profile (context);
			_tmp210_ = _tmp209_;
			if (_tmp210_ == VALA_PROFILE_GOBJECT) {
				ValaStruct* _tmp211_;
				_tmp211_ = st;
				_tmp208_ = vala_struct_is_simple_type (_tmp211_);
			} else {
				_tmp208_ = FALSE;
			}
			if (_tmp208_) {
				ValaSymbol* _tmp212_;
				ValaSymbol* _tmp213_;
				_tmp212_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp213_ = _tmp212_;
				_tmp207_ = _tmp213_ == NULL;
			} else {
				_tmp207_ = FALSE;
			}
			if (_tmp207_) {
				ValaList* _tmp214_;
				gint _tmp215_;
				gint _tmp216_;
				_tmp214_ = self->priv->object_initializer;
				_tmp215_ = vala_collection_get_size ((ValaCollection*) _tmp214_);
				_tmp216_ = _tmp215_;
				_tmp206_ = _tmp216_ == 0;
			} else {
				_tmp206_ = FALSE;
			}
			if (_tmp206_) {
				ValaSourceReference* _tmp217_;
				ValaSourceReference* _tmp218_;
				ValaStruct* _tmp219_;
				gchar* _tmp220_;
				gchar* _tmp221_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp217_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp218_ = _tmp217_;
				_tmp219_ = st;
				_tmp220_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp219_);
				_tmp221_ = _tmp220_;
				vala_report_error (_tmp218_, "`%s' does not have a default constructor", _tmp221_);
				_g_free0 (_tmp221_);
				result = FALSE;
				_vala_code_node_unref0 (st);
				_vala_code_node_unref0 (type);
				return result;
			}
			_vala_code_node_unref0 (st);
		}
	}
	_tmp222_ = vala_object_creation_expression_get_type_reference (self);
	_tmp223_ = _tmp222_;
	if (!vala_data_type_check_type_arguments (_tmp223_, context, FALSE)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		_vala_code_node_unref0 (type);
		return result;
	}
	_tmp225_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp226_ = _tmp225_;
	if (_tmp226_ == NULL) {
		ValaList* _tmp227_;
		gint _tmp228_;
		gint _tmp229_;
		_tmp227_ = self->priv->argument_list;
		_tmp228_ = vala_collection_get_size ((ValaCollection*) _tmp227_);
		_tmp229_ = _tmp228_;
		_tmp224_ = _tmp229_ != 0;
	} else {
		_tmp224_ = FALSE;
	}
	if (_tmp224_) {
		ValaSourceReference* _tmp230_;
		ValaSourceReference* _tmp231_;
		ValaTypeSymbol* _tmp232_;
		gchar* _tmp233_;
		gchar* _tmp234_;
		vala_expression_set_value_type ((ValaExpression*) self, NULL);
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp230_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp231_ = _tmp230_;
		_tmp232_ = type;
		_tmp233_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp232_);
		_tmp234_ = _tmp233_;
		vala_report_error (_tmp231_, "No arguments allowed when constructing type `%s'", _tmp234_);
		_g_free0 (_tmp234_);
		result = FALSE;
		_vala_code_node_unref0 (type);
		return result;
	}
	_tmp235_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp236_ = _tmp235_;
	if (VALA_IS_METHOD (_tmp236_)) {
		ValaMethod* m = NULL;
		ValaSymbol* _tmp237_;
		ValaSymbol* _tmp238_;
		ValaMethod* _tmp239_;
		gboolean _tmp240_;
		gboolean _tmp241_;
		ValaExpression* last_arg = NULL;
		ValaIterator* arg_it = NULL;
		ValaList* _tmp266_;
		ValaIterator* _tmp267_;
		ValaMethod* _tmp318_;
		gboolean _tmp319_;
		gboolean _tmp320_;
		ValaSemanticAnalyzer* _tmp383_;
		ValaSemanticAnalyzer* _tmp384_;
		ValaMethod* _tmp385_;
		ValaMethodType* _tmp386_;
		ValaMethodType* _tmp387_;
		ValaMethod* _tmp388_;
		ValaList* _tmp389_;
		ValaList* _tmp390_;
		_tmp237_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp238_ = _tmp237_;
		_tmp239_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp238_, VALA_TYPE_METHOD, ValaMethod));
		m = _tmp239_;
		_tmp240_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) self);
		_tmp241_ = _tmp240_;
		if (_tmp241_) {
			ValaMethod* _tmp242_;
			gboolean _tmp243_;
			gboolean _tmp244_;
			gboolean _tmp247_ = FALSE;
			ValaSemanticAnalyzer* _tmp248_;
			ValaSemanticAnalyzer* _tmp249_;
			ValaMethod* _tmp250_;
			ValaMethod* _tmp251_;
			_tmp242_ = m;
			_tmp243_ = vala_method_get_coroutine (_tmp242_);
			_tmp244_ = _tmp243_;
			if (!_tmp244_) {
				ValaSourceReference* _tmp245_;
				ValaSourceReference* _tmp246_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp245_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp246_ = _tmp245_;
				vala_report_error (_tmp246_, "yield expression requires async method");
			}
			_tmp248_ = vala_code_context_get_analyzer (context);
			_tmp249_ = _tmp248_;
			_tmp250_ = vala_semantic_analyzer_get_current_method (_tmp249_);
			_tmp251_ = _tmp250_;
			if (_tmp251_ == NULL) {
				_tmp247_ = TRUE;
			} else {
				ValaSemanticAnalyzer* _tmp252_;
				ValaSemanticAnalyzer* _tmp253_;
				ValaMethod* _tmp254_;
				ValaMethod* _tmp255_;
				gboolean _tmp256_;
				gboolean _tmp257_;
				_tmp252_ = vala_code_context_get_analyzer (context);
				_tmp253_ = _tmp252_;
				_tmp254_ = vala_semantic_analyzer_get_current_method (_tmp253_);
				_tmp255_ = _tmp254_;
				_tmp256_ = vala_method_get_coroutine (_tmp255_);
				_tmp257_ = _tmp256_;
				_tmp247_ = !_tmp257_;
			}
			if (_tmp247_) {
				ValaSourceReference* _tmp258_;
				ValaSourceReference* _tmp259_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp258_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp259_ = _tmp258_;
				vala_report_error (_tmp259_, "yield expression not available outside async method");
			}
		} else {
			ValaMethod* _tmp260_;
			_tmp260_ = m;
			if (VALA_IS_CREATION_METHOD (_tmp260_)) {
				ValaMethod* _tmp261_;
				gboolean _tmp262_;
				gboolean _tmp263_;
				_tmp261_ = m;
				_tmp262_ = vala_method_get_coroutine (_tmp261_);
				_tmp263_ = _tmp262_;
				if (_tmp263_) {
					ValaSourceReference* _tmp264_;
					ValaSourceReference* _tmp265_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp264_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp265_ = _tmp264_;
					vala_report_error (_tmp265_, "missing `yield' before async creation expression");
				}
			}
		}
		last_arg = NULL;
		_tmp266_ = self->priv->argument_list;
		_tmp267_ = vala_iterable_iterator ((ValaIterable*) _tmp266_);
		arg_it = _tmp267_;
		{
			ValaList* _param_list = NULL;
			ValaMethod* _tmp268_;
			ValaList* _tmp269_;
			gint _param_size = 0;
			ValaList* _tmp270_;
			gint _tmp271_;
			gint _tmp272_;
			gint _param_index = 0;
			_tmp268_ = m;
			_tmp269_ = vala_callable_get_parameters ((ValaCallable*) _tmp268_);
			_param_list = _tmp269_;
			_tmp270_ = _param_list;
			_tmp271_ = vala_collection_get_size ((ValaCollection*) _tmp270_);
			_tmp272_ = _tmp271_;
			_param_size = _tmp272_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp273_;
				gint _tmp274_;
				ValaParameter* param = NULL;
				ValaList* _tmp275_;
				gpointer _tmp276_;
				ValaParameter* _tmp277_;
				ValaParameter* _tmp278_;
				gboolean _tmp279_;
				gboolean _tmp280_;
				ValaParameter* _tmp281_;
				gboolean _tmp282_;
				gboolean _tmp283_;
				ValaIterator* _tmp301_;
				_param_index = _param_index + 1;
				_tmp273_ = _param_index;
				_tmp274_ = _param_size;
				if (!(_tmp273_ < _tmp274_)) {
					break;
				}
				_tmp275_ = _param_list;
				_tmp276_ = vala_list_get (_tmp275_, _param_index);
				param = (ValaParameter*) _tmp276_;
				_tmp277_ = param;
				if (!vala_code_node_check ((ValaCodeNode*) _tmp277_, context)) {
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
				_tmp278_ = param;
				_tmp279_ = vala_parameter_get_ellipsis (_tmp278_);
				_tmp280_ = _tmp279_;
				if (_tmp280_) {
					_vala_code_node_unref0 (param);
					break;
				}
				_tmp281_ = param;
				_tmp282_ = vala_parameter_get_params_array (_tmp281_);
				_tmp283_ = _tmp282_;
				if (_tmp283_) {
					ValaArrayType* array_type = NULL;
					ValaParameter* _tmp284_;
					ValaDataType* _tmp285_;
					ValaDataType* _tmp286_;
					ValaArrayType* _tmp287_;
					_tmp284_ = param;
					_tmp285_ = vala_variable_get_variable_type ((ValaVariable*) _tmp284_);
					_tmp286_ = _tmp285_;
					_tmp287_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp286_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
					array_type = _tmp287_;
					while (TRUE) {
						ValaIterator* _tmp288_;
						ValaExpression* arg = NULL;
						ValaIterator* _tmp289_;
						gpointer _tmp290_;
						ValaExpression* _tmp291_;
						ValaArrayType* _tmp292_;
						ValaDataType* _tmp293_;
						ValaDataType* _tmp294_;
						ValaExpression* _tmp295_;
						ValaDataType* _tmp296_;
						ValaDataType* _tmp297_;
						ValaArrayType* _tmp298_;
						gboolean _tmp299_;
						gboolean _tmp300_;
						_tmp288_ = arg_it;
						if (!vala_iterator_next (_tmp288_)) {
							break;
						}
						_tmp289_ = arg_it;
						_tmp290_ = vala_iterator_get (_tmp289_);
						arg = (ValaExpression*) _tmp290_;
						_tmp291_ = arg;
						_tmp292_ = array_type;
						_tmp293_ = vala_array_type_get_element_type (_tmp292_);
						_tmp294_ = _tmp293_;
						vala_expression_set_target_type (_tmp291_, _tmp294_);
						_tmp295_ = arg;
						_tmp296_ = vala_expression_get_target_type (_tmp295_);
						_tmp297_ = _tmp296_;
						_tmp298_ = array_type;
						_tmp299_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp298_);
						_tmp300_ = _tmp299_;
						vala_data_type_set_value_owned (_tmp297_, _tmp300_);
						_vala_code_node_unref0 (arg);
					}
					_vala_code_node_unref0 (array_type);
					_vala_code_node_unref0 (param);
					break;
				}
				_tmp301_ = arg_it;
				if (vala_iterator_next (_tmp301_)) {
					ValaExpression* arg = NULL;
					ValaIterator* _tmp302_;
					gpointer _tmp303_;
					ValaExpression* _tmp304_;
					ValaParameter* _tmp305_;
					ValaDataType* _tmp306_;
					ValaDataType* _tmp307_;
					ValaExpression* _tmp308_;
					ValaExpression* _tmp309_;
					ValaDataType* _tmp310_;
					ValaDataType* _tmp311_;
					ValaDataType* _tmp312_;
					ValaDataType* _tmp313_;
					ValaDataType* _tmp314_;
					ValaDataType* _tmp315_;
					ValaExpression* _tmp316_;
					ValaExpression* _tmp317_;
					_tmp302_ = arg_it;
					_tmp303_ = vala_iterator_get (_tmp302_);
					arg = (ValaExpression*) _tmp303_;
					_tmp304_ = arg;
					_tmp305_ = param;
					_tmp306_ = vala_variable_get_variable_type ((ValaVariable*) _tmp305_);
					_tmp307_ = _tmp306_;
					vala_expression_set_formal_target_type (_tmp304_, _tmp307_);
					_tmp308_ = arg;
					_tmp309_ = arg;
					_tmp310_ = vala_expression_get_formal_target_type (_tmp309_);
					_tmp311_ = _tmp310_;
					_tmp312_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp313_ = _tmp312_;
					_tmp314_ = vala_data_type_get_actual_type (_tmp311_, _tmp313_, NULL, (ValaCodeNode*) self);
					_tmp315_ = _tmp314_;
					vala_expression_set_target_type (_tmp308_, _tmp315_);
					_vala_code_node_unref0 (_tmp315_);
					_tmp316_ = arg;
					_tmp317_ = _vala_code_node_ref0 (_tmp316_);
					_vala_code_node_unref0 (last_arg);
					last_arg = _tmp317_;
					_vala_code_node_unref0 (arg);
				}
				_vala_code_node_unref0 (param);
			}
		}
		_tmp318_ = m;
		_tmp319_ = vala_method_get_printf_format (_tmp318_);
		_tmp320_ = _tmp319_;
		if (_tmp320_) {
			ValaStringLiteral* format_literal = NULL;
			ValaExpression* _tmp321_;
			ValaStringLiteral* _tmp365_;
			format_literal = NULL;
			_tmp321_ = last_arg;
			if (VALA_IS_NULL_LITERAL (_tmp321_)) {
			} else {
				ValaExpression* _tmp322_;
				_tmp322_ = last_arg;
				if (_tmp322_ != NULL) {
					ValaExpression* _tmp323_;
					ValaStringLiteral* _tmp324_;
					gboolean _tmp325_ = FALSE;
					ValaStringLiteral* _tmp326_;
					_tmp323_ = last_arg;
					_tmp324_ = vala_string_literal_get_format_literal (_tmp323_);
					_vala_code_node_unref0 (format_literal);
					format_literal = _tmp324_;
					_tmp326_ = format_literal;
					if (_tmp326_ == NULL) {
						ValaList* _tmp327_;
						gint _tmp328_;
						gint _tmp329_;
						ValaMethod* _tmp330_;
						ValaList* _tmp331_;
						gint _tmp332_;
						gint _tmp333_;
						_tmp327_ = self->priv->argument_list;
						_tmp328_ = vala_collection_get_size ((ValaCollection*) _tmp327_);
						_tmp329_ = _tmp328_;
						_tmp330_ = m;
						_tmp331_ = vala_callable_get_parameters ((ValaCallable*) _tmp330_);
						_tmp332_ = vala_collection_get_size ((ValaCollection*) _tmp331_);
						_tmp333_ = _tmp332_;
						_tmp325_ = _tmp329_ == (_tmp333_ - 1);
					} else {
						_tmp325_ = FALSE;
					}
					if (_tmp325_) {
						ValaStringLiteral* _tmp334_;
						ValaStringLiteral* _tmp335_;
						ValaSemanticAnalyzer* _tmp336_;
						ValaSemanticAnalyzer* _tmp337_;
						ValaDataType* _tmp338_;
						ValaDataType* _tmp339_;
						ValaDataType* _tmp340_;
						ValaList* _tmp341_;
						ValaList* _tmp342_;
						gint _tmp343_;
						gint _tmp344_;
						ValaStringLiteral* _tmp345_;
						ValaList* _tmp346_;
						ValaIterator* _tmp347_;
						_tmp334_ = vala_string_literal_new ("\"%s\"", NULL);
						_vala_code_node_unref0 (format_literal);
						format_literal = _tmp334_;
						_tmp335_ = format_literal;
						_tmp336_ = vala_code_context_get_analyzer (context);
						_tmp337_ = _tmp336_;
						_tmp338_ = _tmp337_->string_type;
						_tmp339_ = vala_data_type_copy (_tmp338_);
						_tmp340_ = _tmp339_;
						vala_expression_set_target_type ((ValaExpression*) _tmp335_, _tmp340_);
						_vala_code_node_unref0 (_tmp340_);
						_tmp341_ = self->priv->argument_list;
						_tmp342_ = self->priv->argument_list;
						_tmp343_ = vala_collection_get_size ((ValaCollection*) _tmp342_);
						_tmp344_ = _tmp343_;
						_tmp345_ = format_literal;
						vala_list_insert (_tmp341_, _tmp344_ - 1, (ValaExpression*) _tmp345_);
						_tmp346_ = self->priv->argument_list;
						_tmp347_ = vala_iterable_iterator ((ValaIterable*) _tmp346_);
						_vala_iterator_unref0 (arg_it);
						arg_it = _tmp347_;
						{
							ValaList* _param_list = NULL;
							ValaMethod* _tmp348_;
							ValaList* _tmp349_;
							gint _param_size = 0;
							ValaList* _tmp350_;
							gint _tmp351_;
							gint _tmp352_;
							gint _param_index = 0;
							_tmp348_ = m;
							_tmp349_ = vala_callable_get_parameters ((ValaCallable*) _tmp348_);
							_param_list = _tmp349_;
							_tmp350_ = _param_list;
							_tmp351_ = vala_collection_get_size ((ValaCollection*) _tmp350_);
							_tmp352_ = _tmp351_;
							_param_size = _tmp352_;
							_param_index = -1;
							while (TRUE) {
								gint _tmp353_;
								gint _tmp354_;
								ValaParameter* param = NULL;
								ValaList* _tmp355_;
								gpointer _tmp356_;
								gboolean _tmp357_ = FALSE;
								ValaParameter* _tmp358_;
								gboolean _tmp359_;
								gboolean _tmp360_;
								ValaIterator* _tmp364_;
								_param_index = _param_index + 1;
								_tmp353_ = _param_index;
								_tmp354_ = _param_size;
								if (!(_tmp353_ < _tmp354_)) {
									break;
								}
								_tmp355_ = _param_list;
								_tmp356_ = vala_list_get (_tmp355_, _param_index);
								param = (ValaParameter*) _tmp356_;
								_tmp358_ = param;
								_tmp359_ = vala_parameter_get_ellipsis (_tmp358_);
								_tmp360_ = _tmp359_;
								if (_tmp360_) {
									_tmp357_ = TRUE;
								} else {
									ValaParameter* _tmp361_;
									gboolean _tmp362_;
									gboolean _tmp363_;
									_tmp361_ = param;
									_tmp362_ = vala_parameter_get_params_array (_tmp361_);
									_tmp363_ = _tmp362_;
									_tmp357_ = _tmp363_;
								}
								if (_tmp357_) {
									_vala_code_node_unref0 (param);
									break;
								}
								_tmp364_ = arg_it;
								vala_iterator_next (_tmp364_);
								_vala_code_node_unref0 (param);
							}
						}
					}
				}
			}
			_tmp365_ = format_literal;
			if (_tmp365_ != NULL) {
				gchar* format = NULL;
				ValaStringLiteral* _tmp366_;
				gchar* _tmp367_;
				ValaSemanticAnalyzer* _tmp368_;
				ValaSemanticAnalyzer* _tmp369_;
				const gchar* _tmp370_;
				ValaIterator* _tmp371_;
				ValaSourceReference* _tmp372_;
				ValaSourceReference* _tmp373_;
				_tmp366_ = format_literal;
				_tmp367_ = vala_string_literal_eval (_tmp366_);
				format = _tmp367_;
				_tmp368_ = vala_code_context_get_analyzer (context);
				_tmp369_ = _tmp368_;
				_tmp370_ = format;
				_tmp371_ = arg_it;
				_tmp372_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp373_ = _tmp372_;
				if (!vala_semantic_analyzer_check_print_format (_tmp369_, _tmp370_, _tmp371_, _tmp373_)) {
					result = FALSE;
					_g_free0 (format);
					_vala_code_node_unref0 (format_literal);
					_vala_iterator_unref0 (arg_it);
					_vala_code_node_unref0 (last_arg);
					_vala_code_node_unref0 (m);
					_vala_code_node_unref0 (type);
					return result;
				}
				_g_free0 (format);
			}
			_vala_code_node_unref0 (format_literal);
		}
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp374_;
			gint _arg_size = 0;
			ValaList* _tmp375_;
			gint _tmp376_;
			gint _tmp377_;
			gint _arg_index = 0;
			_tmp374_ = self->priv->argument_list;
			_arg_list = _tmp374_;
			_tmp375_ = _arg_list;
			_tmp376_ = vala_collection_get_size ((ValaCollection*) _tmp375_);
			_tmp377_ = _tmp376_;
			_arg_size = _tmp377_;
			_arg_index = -1;
			while (TRUE) {
				gint _tmp378_;
				gint _tmp379_;
				ValaExpression* arg = NULL;
				ValaList* _tmp380_;
				gpointer _tmp381_;
				ValaExpression* _tmp382_;
				_arg_index = _arg_index + 1;
				_tmp378_ = _arg_index;
				_tmp379_ = _arg_size;
				if (!(_tmp378_ < _tmp379_)) {
					break;
				}
				_tmp380_ = _arg_list;
				_tmp381_ = vala_list_get (_tmp380_, _arg_index);
				arg = (ValaExpression*) _tmp381_;
				_tmp382_ = arg;
				vala_code_node_check ((ValaCodeNode*) _tmp382_, context);
				_vala_code_node_unref0 (arg);
			}
		}
		_tmp383_ = vala_code_context_get_analyzer (context);
		_tmp384_ = _tmp383_;
		_tmp385_ = m;
		_tmp386_ = vala_method_type_new (_tmp385_, NULL);
		_tmp387_ = _tmp386_;
		_tmp388_ = m;
		_tmp389_ = vala_callable_get_parameters ((ValaCallable*) _tmp388_);
		_tmp390_ = self->priv->argument_list;
		vala_semantic_analyzer_check_arguments (_tmp384_, (ValaExpression*) self, (ValaDataType*) _tmp387_, _tmp389_, _tmp390_);
		_vala_code_node_unref0 (_tmp387_);
		_vala_iterator_unref0 (arg_it);
		_vala_code_node_unref0 (last_arg);
		_vala_code_node_unref0 (m);
	} else {
		ValaDataType* _tmp391_;
		ValaDataType* _tmp392_;
		_tmp391_ = vala_object_creation_expression_get_type_reference (self);
		_tmp392_ = _tmp391_;
		if (VALA_IS_ERROR_TYPE (_tmp392_)) {
			ValaDataType* _tmp393_;
			ValaDataType* _tmp394_;
			ValaMemberAccess* _tmp397_;
			ValaMemberAccess* _tmp398_;
			ValaList* _tmp419_;
			gint _tmp420_;
			gint _tmp421_;
			_tmp393_ = vala_object_creation_expression_get_type_reference (self);
			_tmp394_ = _tmp393_;
			if (_tmp394_ != NULL) {
				ValaDataType* _tmp395_;
				ValaDataType* _tmp396_;
				_tmp395_ = vala_object_creation_expression_get_type_reference (self);
				_tmp396_ = _tmp395_;
				vala_code_node_check ((ValaCodeNode*) _tmp396_, context);
			}
			_tmp397_ = vala_object_creation_expression_get_member_name (self);
			_tmp398_ = _tmp397_;
			if (_tmp398_ != NULL) {
				ValaMemberAccess* _tmp399_;
				ValaMemberAccess* _tmp400_;
				_tmp399_ = vala_object_creation_expression_get_member_name (self);
				_tmp400_ = _tmp399_;
				vala_code_node_check ((ValaCodeNode*) _tmp400_, context);
			}
			{
				ValaList* _arg_list = NULL;
				ValaList* _tmp401_;
				gint _arg_size = 0;
				ValaList* _tmp402_;
				gint _tmp403_;
				gint _tmp404_;
				gint _arg_index = 0;
				_tmp401_ = self->priv->argument_list;
				_arg_list = _tmp401_;
				_tmp402_ = _arg_list;
				_tmp403_ = vala_collection_get_size ((ValaCollection*) _tmp402_);
				_tmp404_ = _tmp403_;
				_arg_size = _tmp404_;
				_arg_index = -1;
				while (TRUE) {
					gint _tmp405_;
					gint _tmp406_;
					ValaExpression* arg = NULL;
					ValaList* _tmp407_;
					gpointer _tmp408_;
					ValaExpression* _tmp409_;
					_arg_index = _arg_index + 1;
					_tmp405_ = _arg_index;
					_tmp406_ = _arg_size;
					if (!(_tmp405_ < _tmp406_)) {
						break;
					}
					_tmp407_ = _arg_list;
					_tmp408_ = vala_list_get (_tmp407_, _arg_index);
					arg = (ValaExpression*) _tmp408_;
					_tmp409_ = arg;
					vala_code_node_check ((ValaCodeNode*) _tmp409_, context);
					_vala_code_node_unref0 (arg);
				}
			}
			{
				ValaList* _init_list = NULL;
				ValaList* _tmp410_;
				gint _init_size = 0;
				ValaList* _tmp411_;
				gint _tmp412_;
				gint _tmp413_;
				gint _init_index = 0;
				_tmp410_ = self->priv->object_initializer;
				_init_list = _tmp410_;
				_tmp411_ = _init_list;
				_tmp412_ = vala_collection_get_size ((ValaCollection*) _tmp411_);
				_tmp413_ = _tmp412_;
				_init_size = _tmp413_;
				_init_index = -1;
				while (TRUE) {
					gint _tmp414_;
					gint _tmp415_;
					ValaMemberInitializer* init = NULL;
					ValaList* _tmp416_;
					gpointer _tmp417_;
					ValaMemberInitializer* _tmp418_;
					_init_index = _init_index + 1;
					_tmp414_ = _init_index;
					_tmp415_ = _init_size;
					if (!(_tmp414_ < _tmp415_)) {
						break;
					}
					_tmp416_ = _init_list;
					_tmp417_ = vala_list_get (_tmp416_, _init_index);
					init = (ValaMemberInitializer*) _tmp417_;
					_tmp418_ = init;
					vala_code_node_check ((ValaCodeNode*) _tmp418_, context);
					_vala_code_node_unref0 (init);
				}
			}
			_tmp419_ = self->priv->argument_list;
			_tmp420_ = vala_collection_get_size ((ValaCollection*) _tmp419_);
			_tmp421_ = _tmp420_;
			if (_tmp421_ == 0) {
				ValaSourceReference* _tmp422_;
				ValaSourceReference* _tmp423_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp422_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp423_ = _tmp422_;
				vala_report_error (_tmp423_, "Too few arguments, errors need at least 1 argument");
			} else {
				ValaIterator* arg_it = NULL;
				ValaList* _tmp424_;
				ValaIterator* _tmp425_;
				ValaIterator* _tmp426_;
				ValaExpression* ex = NULL;
				ValaIterator* _tmp427_;
				gpointer _tmp428_;
				gboolean _tmp429_ = FALSE;
				ValaExpression* _tmp430_;
				ValaDataType* _tmp431_;
				ValaDataType* _tmp432_;
				ValaStringLiteral* format_literal = NULL;
				ValaExpression* _tmp441_;
				ValaStringLiteral* _tmp442_;
				ValaStringLiteral* _tmp443_;
				ValaList* _tmp452_;
				ValaIterator* _tmp453_;
				ValaIterator* _tmp454_;
				ValaSemanticAnalyzer* _tmp455_;
				ValaSemanticAnalyzer* _tmp456_;
				ValaIterator* _tmp457_;
				ValaSourceReference* _tmp458_;
				ValaSourceReference* _tmp459_;
				_tmp424_ = self->priv->argument_list;
				_tmp425_ = vala_iterable_iterator ((ValaIterable*) _tmp424_);
				arg_it = _tmp425_;
				_tmp426_ = arg_it;
				vala_iterator_next (_tmp426_);
				_tmp427_ = arg_it;
				_tmp428_ = vala_iterator_get (_tmp427_);
				ex = (ValaExpression*) _tmp428_;
				_tmp430_ = ex;
				_tmp431_ = vala_expression_get_value_type (_tmp430_);
				_tmp432_ = _tmp431_;
				if (_tmp432_ == NULL) {
					_tmp429_ = TRUE;
				} else {
					ValaExpression* _tmp433_;
					ValaDataType* _tmp434_;
					ValaDataType* _tmp435_;
					ValaSemanticAnalyzer* _tmp436_;
					ValaSemanticAnalyzer* _tmp437_;
					ValaDataType* _tmp438_;
					_tmp433_ = ex;
					_tmp434_ = vala_expression_get_value_type (_tmp433_);
					_tmp435_ = _tmp434_;
					_tmp436_ = vala_code_context_get_analyzer (context);
					_tmp437_ = _tmp436_;
					_tmp438_ = _tmp437_->string_type;
					_tmp429_ = !vala_data_type_compatible (_tmp435_, _tmp438_);
				}
				if (_tmp429_) {
					ValaSourceReference* _tmp439_;
					ValaSourceReference* _tmp440_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp439_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp440_ = _tmp439_;
					vala_report_error (_tmp440_, "Invalid type for argument 1");
				}
				_tmp441_ = ex;
				_tmp442_ = vala_string_literal_get_format_literal (_tmp441_);
				format_literal = _tmp442_;
				_tmp443_ = format_literal;
				if (_tmp443_ != NULL) {
					gchar* format = NULL;
					ValaStringLiteral* _tmp444_;
					gchar* _tmp445_;
					ValaSemanticAnalyzer* _tmp446_;
					ValaSemanticAnalyzer* _tmp447_;
					const gchar* _tmp448_;
					ValaIterator* _tmp449_;
					ValaSourceReference* _tmp450_;
					ValaSourceReference* _tmp451_;
					_tmp444_ = format_literal;
					_tmp445_ = vala_string_literal_eval (_tmp444_);
					format = _tmp445_;
					_tmp446_ = vala_code_context_get_analyzer (context);
					_tmp447_ = _tmp446_;
					_tmp448_ = format;
					_tmp449_ = arg_it;
					_tmp450_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp451_ = _tmp450_;
					if (!vala_semantic_analyzer_check_print_format (_tmp447_, _tmp448_, _tmp449_, _tmp451_)) {
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						result = FALSE;
						_g_free0 (format);
						_vala_code_node_unref0 (format_literal);
						_vala_code_node_unref0 (ex);
						_vala_iterator_unref0 (arg_it);
						_vala_code_node_unref0 (type);
						return result;
					}
					_g_free0 (format);
				}
				_tmp452_ = self->priv->argument_list;
				_tmp453_ = vala_iterable_iterator ((ValaIterable*) _tmp452_);
				_vala_iterator_unref0 (arg_it);
				arg_it = _tmp453_;
				_tmp454_ = arg_it;
				vala_iterator_next (_tmp454_);
				_tmp455_ = vala_code_context_get_analyzer (context);
				_tmp456_ = _tmp455_;
				_tmp457_ = arg_it;
				_tmp458_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp459_ = _tmp458_;
				if (!vala_semantic_analyzer_check_variadic_arguments (_tmp456_, _tmp457_, 1, _tmp459_)) {
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					result = FALSE;
					_vala_code_node_unref0 (format_literal);
					_vala_code_node_unref0 (ex);
					_vala_iterator_unref0 (arg_it);
					_vala_code_node_unref0 (type);
					return result;
				}
				_vala_code_node_unref0 (format_literal);
				_vala_code_node_unref0 (ex);
				_vala_iterator_unref0 (arg_it);
			}
		}
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp460_;
		gint _arg_size = 0;
		ValaList* _tmp461_;
		gint _tmp462_;
		gint _tmp463_;
		gint _arg_index = 0;
		_tmp460_ = self->priv->argument_list;
		_arg_list = _tmp460_;
		_tmp461_ = _arg_list;
		_tmp462_ = vala_collection_get_size ((ValaCollection*) _tmp461_);
		_tmp463_ = _tmp462_;
		_arg_size = _tmp463_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp464_;
			gint _tmp465_;
			ValaExpression* arg = NULL;
			ValaList* _tmp466_;
			gpointer _tmp467_;
			ValaSizeofExpression* sizeof_expr = NULL;
			ValaExpression* _tmp468_;
			gboolean _tmp469_ = FALSE;
			ValaSizeofExpression* _tmp470_;
			_arg_index = _arg_index + 1;
			_tmp464_ = _arg_index;
			_tmp465_ = _arg_size;
			if (!(_tmp464_ < _tmp465_)) {
				break;
			}
			_tmp466_ = _arg_list;
			_tmp467_ = vala_list_get (_tmp466_, _arg_index);
			arg = (ValaExpression*) _tmp467_;
			_tmp468_ = arg;
			sizeof_expr = VALA_IS_SIZEOF_EXPRESSION (_tmp468_) ? ((ValaSizeofExpression*) _tmp468_) : NULL;
			_tmp470_ = sizeof_expr;
			if (_tmp470_ != NULL) {
				ValaSizeofExpression* _tmp471_;
				ValaDataType* _tmp472_;
				ValaDataType* _tmp473_;
				_tmp471_ = sizeof_expr;
				_tmp472_ = vala_sizeof_expression_get_type_reference (_tmp471_);
				_tmp473_ = _tmp472_;
				_tmp469_ = VALA_IS_GENERIC_TYPE (_tmp473_);
			} else {
				_tmp469_ = FALSE;
			}
			if (_tmp469_) {
				ValaDataType* sizeof_type = NULL;
				ValaSizeofExpression* _tmp474_;
				ValaDataType* _tmp475_;
				ValaDataType* _tmp476_;
				ValaDataType* _tmp477_;
				ValaDataType* _tmp478_;
				ValaDataType* _tmp479_;
				ValaDataType* _tmp480_;
				ValaList* _tmp481_;
				ValaDataType* _tmp482_;
				ValaExpression* _tmp483_;
				ValaDataType* _tmp484_;
				ValaSourceReference* _tmp485_;
				ValaSourceReference* _tmp486_;
				ValaSizeofExpression* _tmp487_;
				ValaSizeofExpression* _tmp488_;
				_tmp474_ = sizeof_expr;
				_tmp475_ = vala_sizeof_expression_get_type_reference (_tmp474_);
				_tmp476_ = _tmp475_;
				_tmp477_ = vala_object_creation_expression_get_type_reference (self);
				_tmp478_ = _tmp477_;
				_tmp479_ = vala_object_creation_expression_get_type_reference (self);
				_tmp480_ = _tmp479_;
				_tmp481_ = vala_data_type_get_type_arguments (_tmp480_);
				_tmp482_ = vala_data_type_get_actual_type (_tmp476_, _tmp478_, _tmp481_, (ValaCodeNode*) self);
				sizeof_type = _tmp482_;
				_tmp483_ = arg;
				_tmp484_ = sizeof_type;
				_tmp485_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp486_ = _tmp485_;
				_tmp487_ = vala_sizeof_expression_new (_tmp484_, _tmp486_);
				_tmp488_ = _tmp487_;
				vala_code_node_replace_expression ((ValaCodeNode*) self, _tmp483_, (ValaExpression*) _tmp488_);
				_vala_code_node_unref0 (_tmp488_);
				_vala_code_node_unref0 (sizeof_type);
			}
			_vala_code_node_unref0 (arg);
		}
	}
	_tmp489_ = type;
	_tmp490_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp489_);
	_tmp491_ = _tmp490_;
	if (!_tmp491_) {
		ValaSemanticAnalyzer* _tmp492_;
		ValaSemanticAnalyzer* _tmp493_;
		ValaDataType* _tmp494_;
		ValaDataType* _tmp495_;
		_tmp492_ = vala_code_context_get_analyzer (context);
		_tmp493_ = _tmp492_;
		_tmp494_ = vala_object_creation_expression_get_type_reference (self);
		_tmp495_ = _tmp494_;
		vala_semantic_analyzer_check_type (_tmp493_, _tmp495_);
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp496_;
		gint _init_size = 0;
		ValaList* _tmp497_;
		gint _tmp498_;
		gint _tmp499_;
		gint _init_index = 0;
		_tmp496_ = vala_object_creation_expression_get_object_initializer (self);
		_init_list = _tmp496_;
		_tmp497_ = _init_list;
		_tmp498_ = vala_collection_get_size ((ValaCollection*) _tmp497_);
		_tmp499_ = _tmp498_;
		_init_size = _tmp499_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp500_;
			gint _tmp501_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp502_;
			gpointer _tmp503_;
			ValaMemberInitializer* _tmp504_;
			ValaExpression* _tmp505_;
			ValaExpression* _tmp506_;
			gint index = 0;
			ValaList* _tmp507_;
			ValaMemberInitializer* _tmp508_;
			ValaList* _tmp509_;
			gpointer _tmp510_;
			ValaMemberInitializer* _tmp511_;
			ValaMemberInitializer* inner_mi = NULL;
			ValaMemberInitializer* _tmp512_;
			ValaExpression* _tmp513_;
			ValaExpression* _tmp514_;
			ValaLocalVariable* local = NULL;
			gchar* _tmp521_;
			gchar* _tmp522_;
			ValaMemberInitializer* _tmp523_;
			ValaExpression* _tmp524_;
			ValaExpression* _tmp525_;
			ValaMemberInitializer* _tmp526_;
			ValaExpression* _tmp527_;
			ValaExpression* _tmp528_;
			ValaSourceReference* _tmp529_;
			ValaSourceReference* _tmp530_;
			ValaLocalVariable* _tmp531_;
			ValaLocalVariable* _tmp532_;
			ValaDeclarationStatement* decl = NULL;
			ValaLocalVariable* _tmp533_;
			ValaMemberInitializer* _tmp534_;
			ValaExpression* _tmp535_;
			ValaExpression* _tmp536_;
			ValaSourceReference* _tmp537_;
			ValaSourceReference* _tmp538_;
			ValaDeclarationStatement* _tmp539_;
			ValaDeclarationStatement* _tmp540_;
			ValaSemanticAnalyzer* _tmp541_;
			ValaSemanticAnalyzer* _tmp542_;
			ValaBlock* _tmp543_;
			ValaDeclarationStatement* _tmp544_;
			_init_index = _init_index + 1;
			_tmp500_ = _init_index;
			_tmp501_ = _init_size;
			if (!(_tmp500_ < _tmp501_)) {
				break;
			}
			_tmp502_ = _init_list;
			_tmp503_ = vala_list_get (_tmp502_, _init_index);
			init = (ValaMemberInitializer*) _tmp503_;
			_tmp504_ = init;
			_tmp505_ = vala_member_initializer_get_initializer (_tmp504_);
			_tmp506_ = _tmp505_;
			if (!VALA_IS_MEMBER_INITIALIZER (_tmp506_)) {
				_vala_code_node_unref0 (init);
				continue;
			}
			_tmp507_ = self->priv->object_initializer;
			_tmp508_ = init;
			index = vala_list_index_of (_tmp507_, _tmp508_);
			_tmp509_ = self->priv->object_initializer;
			_tmp510_ = vala_list_remove_at (_tmp509_, index);
			_tmp511_ = (ValaMemberInitializer*) _tmp510_;
			_vala_code_node_unref0 (_tmp511_);
			_vala_assert (index >= 0, "index >= 0");
			_tmp512_ = init;
			_tmp513_ = vala_member_initializer_get_initializer (_tmp512_);
			_tmp514_ = _tmp513_;
			inner_mi = G_TYPE_CHECK_INSTANCE_CAST (_tmp514_, VALA_TYPE_MEMBER_INITIALIZER, ValaMemberInitializer);
			while (TRUE) {
				ValaMemberInitializer* _tmp515_;
				ValaExpression* _tmp516_;
				ValaExpression* _tmp517_;
				ValaMemberInitializer* _tmp518_;
				ValaExpression* _tmp519_;
				ValaExpression* _tmp520_;
				_tmp515_ = inner_mi;
				_tmp516_ = vala_member_initializer_get_initializer (_tmp515_);
				_tmp517_ = _tmp516_;
				if (!VALA_IS_MEMBER_INITIALIZER (_tmp517_)) {
					break;
				}
				_tmp518_ = inner_mi;
				_tmp519_ = vala_member_initializer_get_initializer (_tmp518_);
				_tmp520_ = _tmp519_;
				inner_mi = G_TYPE_CHECK_INSTANCE_CAST (_tmp520_, VALA_TYPE_MEMBER_INITIALIZER, ValaMemberInitializer);
			}
			_tmp521_ = vala_code_node_get_temp_name ();
			_tmp522_ = _tmp521_;
			_tmp523_ = inner_mi;
			_tmp524_ = vala_member_initializer_get_initializer (_tmp523_);
			_tmp525_ = _tmp524_;
			_tmp526_ = inner_mi;
			_tmp527_ = vala_member_initializer_get_initializer (_tmp526_);
			_tmp528_ = _tmp527_;
			_tmp529_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp528_);
			_tmp530_ = _tmp529_;
			_tmp531_ = vala_local_variable_new (NULL, _tmp522_, _tmp525_, _tmp530_);
			_tmp532_ = _tmp531_;
			_g_free0 (_tmp522_);
			local = _tmp532_;
			_tmp533_ = local;
			_tmp534_ = inner_mi;
			_tmp535_ = vala_member_initializer_get_initializer (_tmp534_);
			_tmp536_ = _tmp535_;
			_tmp537_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp536_);
			_tmp538_ = _tmp537_;
			_tmp539_ = vala_declaration_statement_new ((ValaSymbol*) _tmp533_, _tmp538_);
			decl = _tmp539_;
			_tmp540_ = decl;
			vala_code_node_check ((ValaCodeNode*) _tmp540_, context);
			_tmp541_ = vala_code_context_get_analyzer (context);
			_tmp542_ = _tmp541_;
			_tmp543_ = _tmp542_->insert_block;
			_tmp544_ = decl;
			vala_expression_insert_statement ((ValaExpression*) self, _tmp543_, (ValaStatement*) _tmp544_);
			{
				gboolean _tmp545_ = FALSE;
				_tmp545_ = TRUE;
				while (TRUE) {
					ValaMemberInitializer* member_init = NULL;
					ValaMemberInitializer* _tmp547_;
					const gchar* _tmp548_;
					const gchar* _tmp549_;
					ValaLocalVariable* _tmp550_;
					const gchar* _tmp551_;
					const gchar* _tmp552_;
					ValaMemberInitializer* _tmp553_;
					ValaSourceReference* _tmp554_;
					ValaSourceReference* _tmp555_;
					ValaMemberAccess* _tmp556_;
					ValaMemberAccess* _tmp557_;
					ValaMemberInitializer* _tmp558_;
					ValaSourceReference* _tmp559_;
					ValaSourceReference* _tmp560_;
					ValaMemberInitializer* _tmp561_;
					ValaMemberInitializer* _tmp562_;
					ValaList* _tmp563_;
					gint _tmp564_;
					ValaMemberInitializer* _tmp565_;
					ValaMemberInitializer* _tmp566_;
					ValaCodeNode* _tmp567_;
					ValaCodeNode* _tmp568_;
					if (!_tmp545_) {
						ValaMemberInitializer* _tmp546_;
						_tmp546_ = inner_mi;
						if (!(_tmp546_ != NULL)) {
							break;
						}
					}
					_tmp545_ = FALSE;
					_tmp547_ = inner_mi;
					_tmp548_ = vala_member_initializer_get_name (_tmp547_);
					_tmp549_ = _tmp548_;
					_tmp550_ = local;
					_tmp551_ = vala_symbol_get_name ((ValaSymbol*) _tmp550_);
					_tmp552_ = _tmp551_;
					_tmp553_ = inner_mi;
					_tmp554_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp553_);
					_tmp555_ = _tmp554_;
					_tmp556_ = vala_member_access_new (NULL, _tmp552_, _tmp555_);
					_tmp557_ = _tmp556_;
					_tmp558_ = inner_mi;
					_tmp559_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp558_);
					_tmp560_ = _tmp559_;
					_tmp561_ = vala_member_initializer_new (_tmp549_, (ValaExpression*) _tmp557_, _tmp560_);
					_tmp562_ = _tmp561_;
					_vala_code_node_unref0 (_tmp557_);
					member_init = _tmp562_;
					_tmp563_ = self->priv->object_initializer;
					_tmp564_ = index;
					index = _tmp564_ + 1;
					_tmp565_ = member_init;
					vala_list_insert (_tmp563_, _tmp564_, _tmp565_);
					_tmp566_ = inner_mi;
					_tmp567_ = vala_code_node_get_parent_node ((ValaCodeNode*) _tmp566_);
					_tmp568_ = _tmp567_;
					inner_mi = VALA_IS_MEMBER_INITIALIZER (_tmp568_) ? ((ValaMemberInitializer*) _tmp568_) : NULL;
					_vala_code_node_unref0 (member_init);
				}
			}
			_vala_code_node_unref0 (decl);
			_vala_code_node_unref0 (local);
			_vala_code_node_unref0 (init);
		}
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp569_;
		gint _init_size = 0;
		ValaList* _tmp570_;
		gint _tmp571_;
		gint _tmp572_;
		gint _init_index = 0;
		_tmp569_ = vala_object_creation_expression_get_object_initializer (self);
		_init_list = _tmp569_;
		_tmp570_ = _init_list;
		_tmp571_ = vala_collection_get_size ((ValaCollection*) _tmp570_);
		_tmp572_ = _tmp571_;
		_init_size = _tmp572_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp573_;
			gint _tmp574_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp575_;
			gpointer _tmp576_;
			ValaMemberInitializer* _tmp577_;
			ValaMemberInitializer* _tmp578_;
			_init_index = _init_index + 1;
			_tmp573_ = _init_index;
			_tmp574_ = _init_size;
			if (!(_tmp573_ < _tmp574_)) {
				break;
			}
			_tmp575_ = _init_list;
			_tmp576_ = vala_list_get (_tmp575_, _init_index);
			init = (ValaMemberInitializer*) _tmp576_;
			_tmp577_ = init;
			vala_code_node_set_parent_node ((ValaCodeNode*) _tmp577_, (ValaCodeNode*) self);
			_tmp578_ = init;
			vala_code_node_check ((ValaCodeNode*) _tmp578_, context);
			_vala_code_node_unref0 (init);
		}
	}
	_tmp579_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
	_tmp580_ = _tmp579_;
	if (_tmp580_) {
		gboolean _tmp581_ = FALSE;
		ValaCodeNode* _tmp582_;
		ValaCodeNode* _tmp583_;
		_tmp582_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp583_ = _tmp582_;
		if (VALA_IS_LOCAL_VARIABLE (_tmp583_)) {
			_tmp581_ = TRUE;
		} else {
			ValaCodeNode* _tmp584_;
			ValaCodeNode* _tmp585_;
			_tmp584_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp585_ = _tmp584_;
			_tmp581_ = VALA_IS_EXPRESSION_STATEMENT (_tmp585_);
		}
		if (_tmp581_) {
		} else {
			ValaSemanticAnalyzer* _tmp586_;
			ValaSemanticAnalyzer* _tmp587_;
			ValaSymbol* _tmp588_;
			ValaSymbol* _tmp589_;
			_tmp586_ = vala_code_context_get_analyzer (context);
			_tmp587_ = _tmp586_;
			_tmp588_ = vala_semantic_analyzer_get_current_symbol (_tmp587_);
			_tmp589_ = _tmp588_;
			if (!VALA_IS_BLOCK (_tmp589_)) {
				ValaSourceReference* _tmp590_;
				ValaSourceReference* _tmp591_;
				_tmp590_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp591_ = _tmp590_;
				vala_report_error (_tmp591_, "Field initializers must not throw errors");
			} else {
				ValaCodeNode* old_parent_node = NULL;
				ValaCodeNode* _tmp592_;
				ValaCodeNode* _tmp593_;
				ValaCodeNode* _tmp594_;
				ValaLocalVariable* local = NULL;
				ValaDataType* _tmp595_;
				ValaDataType* _tmp596_;
				ValaDataType* _tmp597_;
				ValaDataType* _tmp598_;
				gchar* _tmp599_;
				gchar* _tmp600_;
				ValaSourceReference* _tmp601_;
				ValaSourceReference* _tmp602_;
				ValaLocalVariable* _tmp603_;
				ValaLocalVariable* _tmp604_;
				ValaDeclarationStatement* decl = NULL;
				ValaLocalVariable* _tmp605_;
				ValaSourceReference* _tmp606_;
				ValaSourceReference* _tmp607_;
				ValaDeclarationStatement* _tmp608_;
				ValaSemanticAnalyzer* _tmp609_;
				ValaSemanticAnalyzer* _tmp610_;
				ValaBlock* _tmp611_;
				ValaDeclarationStatement* _tmp612_;
				ValaExpression* temp_access = NULL;
				ValaLocalVariable* _tmp613_;
				ValaDataType* _tmp614_;
				ValaDataType* _tmp615_;
				ValaExpression* _tmp616_;
				ValaExpression* _tmp617_;
				ValaDataType* _tmp618_;
				ValaDataType* _tmp619_;
				ValaLocalVariable* _tmp620_;
				ValaDeclarationStatement* _tmp621_;
				ValaBlock* block = NULL;
				ValaSemanticAnalyzer* _tmp622_;
				ValaSemanticAnalyzer* _tmp623_;
				ValaSymbol* _tmp624_;
				ValaSymbol* _tmp625_;
				ValaBlock* _tmp626_;
				ValaBlock* _tmp627_;
				ValaLocalVariable* _tmp628_;
				ValaSemanticAnalyzer* _tmp629_;
				ValaSemanticAnalyzer* _tmp630_;
				ValaBlock* _tmp631_;
				ValaLocalVariable* _tmp632_;
				ValaCodeNode* _tmp633_;
				ValaExpression* _tmp634_;
				ValaExpression* _tmp635_;
				_tmp592_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp593_ = _tmp592_;
				_tmp594_ = _vala_code_node_ref0 (_tmp593_);
				old_parent_node = _tmp594_;
				_tmp595_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp596_ = _tmp595_;
				_tmp597_ = vala_data_type_copy (_tmp596_);
				_tmp598_ = _tmp597_;
				_tmp599_ = vala_code_node_get_temp_name ();
				_tmp600_ = _tmp599_;
				_tmp601_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp602_ = _tmp601_;
				_tmp603_ = vala_local_variable_new (_tmp598_, _tmp600_, NULL, _tmp602_);
				_tmp604_ = _tmp603_;
				_g_free0 (_tmp600_);
				_vala_code_node_unref0 (_tmp598_);
				local = _tmp604_;
				_tmp605_ = local;
				_tmp606_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp607_ = _tmp606_;
				_tmp608_ = vala_declaration_statement_new ((ValaSymbol*) _tmp605_, _tmp607_);
				decl = _tmp608_;
				_tmp609_ = vala_code_context_get_analyzer (context);
				_tmp610_ = _tmp609_;
				_tmp611_ = _tmp610_->insert_block;
				_tmp612_ = decl;
				vala_expression_insert_statement ((ValaExpression*) self, _tmp611_, (ValaStatement*) _tmp612_);
				_tmp613_ = local;
				_tmp614_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp615_ = _tmp614_;
				_tmp616_ = vala_semantic_analyzer_create_temp_access (_tmp613_, _tmp615_);
				temp_access = _tmp616_;
				_tmp617_ = temp_access;
				_tmp618_ = vala_expression_get_formal_target_type ((ValaExpression*) self);
				_tmp619_ = _tmp618_;
				vala_expression_set_formal_target_type (_tmp617_, _tmp619_);
				_tmp620_ = local;
				vala_variable_set_initializer ((ValaVariable*) _tmp620_, (ValaExpression*) self);
				_tmp621_ = decl;
				vala_code_node_check ((ValaCodeNode*) _tmp621_, context);
				_tmp622_ = vala_code_context_get_analyzer (context);
				_tmp623_ = _tmp622_;
				_tmp624_ = vala_semantic_analyzer_get_current_symbol (_tmp623_);
				_tmp625_ = _tmp624_;
				_tmp626_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp625_, VALA_TYPE_BLOCK, ValaBlock));
				block = _tmp626_;
				_tmp627_ = block;
				_tmp628_ = local;
				vala_block_remove_local_variable (_tmp627_, _tmp628_);
				_tmp629_ = vala_code_context_get_analyzer (context);
				_tmp630_ = _tmp629_;
				_tmp631_ = _tmp630_->insert_block;
				_tmp632_ = local;
				vala_block_add_local_variable (_tmp631_, _tmp632_);
				_tmp633_ = old_parent_node;
				_tmp634_ = temp_access;
				vala_code_node_replace_expression (_tmp633_, (ValaExpression*) self, _tmp634_);
				_tmp635_ = temp_access;
				vala_code_node_check ((ValaCodeNode*) _tmp635_, context);
				_vala_code_node_unref0 (block);
				_vala_code_node_unref0 (temp_access);
				_vala_code_node_unref0 (decl);
				_vala_code_node_unref0 (local);
				_vala_code_node_unref0 (old_parent_node);
			}
		}
	}
	_tmp636_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp637_ = _tmp636_;
	result = !_tmp637_;
	_vala_code_node_unref0 (type);
	return result;
}

static void
vala_object_creation_expression_real_get_error_types (ValaCodeNode* base,
                                                      ValaCollection* collection,
                                                      ValaSourceReference* source_reference)
{
	ValaObjectCreationExpression * self;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	if (VALA_IS_METHOD (_tmp1_)) {
		ValaMethod* m = NULL;
		ValaSymbol* _tmp4_;
		ValaSymbol* _tmp5_;
		ValaMethod* _tmp6_;
		ValaMethod* _tmp7_;
		if (source_reference == NULL) {
			ValaSourceReference* _tmp2_;
			ValaSourceReference* _tmp3_;
			_tmp2_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp3_ = _tmp2_;
			source_reference = _tmp3_;
		}
		_tmp4_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp5_ = _tmp4_;
		_tmp6_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, VALA_TYPE_METHOD, ValaMethod));
		m = _tmp6_;
		_tmp7_ = m;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp7_, collection, source_reference);
		_vala_code_node_unref0 (m);
	}
}

static void
vala_object_creation_expression_real_emit (ValaCodeNode* base,
                                           ValaCodeGenerator* codegen)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (codegen != NULL);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		gint _arg_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_arg_list = _tmp0_;
		_tmp1_ = _arg_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_arg_size = _tmp3_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaExpression* arg = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaExpression* _tmp8_;
			_arg_index = _arg_index + 1;
			_tmp4_ = _arg_index;
			_tmp5_ = _arg_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _arg_list;
			_tmp7_ = vala_list_get (_tmp6_, _arg_index);
			arg = (ValaExpression*) _tmp7_;
			_tmp8_ = arg;
			vala_code_node_emit ((ValaCodeNode*) _tmp8_, codegen);
			_vala_code_node_unref0 (arg);
		}
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp9_;
		gint _init_size = 0;
		ValaList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _init_index = 0;
		_tmp9_ = self->priv->object_initializer;
		_init_list = _tmp9_;
		_tmp10_ = _init_list;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_init_size = _tmp12_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp13_;
			gint _tmp14_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp15_;
			gpointer _tmp16_;
			ValaMemberInitializer* _tmp17_;
			_init_index = _init_index + 1;
			_tmp13_ = _init_index;
			_tmp14_ = _init_size;
			if (!(_tmp13_ < _tmp14_)) {
				break;
			}
			_tmp15_ = _init_list;
			_tmp16_ = vala_list_get (_tmp15_, _init_index);
			init = (ValaMemberInitializer*) _tmp16_;
			_tmp17_ = init;
			vala_code_node_emit ((ValaCodeNode*) _tmp17_, codegen);
			_vala_code_node_unref0 (init);
		}
	}
	vala_code_visitor_visit_object_creation_expression ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_object_creation_expression_real_get_defined_variables (ValaCodeNode* base,
                                                            ValaCollection* collection)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (collection != NULL);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		gint _arg_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_arg_list = _tmp0_;
		_tmp1_ = _arg_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_arg_size = _tmp3_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaExpression* arg = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaExpression* _tmp8_;
			_arg_index = _arg_index + 1;
			_tmp4_ = _arg_index;
			_tmp5_ = _arg_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _arg_list;
			_tmp7_ = vala_list_get (_tmp6_, _arg_index);
			arg = (ValaExpression*) _tmp7_;
			_tmp8_ = arg;
			vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp8_, collection);
			_vala_code_node_unref0 (arg);
		}
	}
}

static void
vala_object_creation_expression_real_get_used_variables (ValaCodeNode* base,
                                                         ValaCollection* collection)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (collection != NULL);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		gint _arg_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_arg_list = _tmp0_;
		_tmp1_ = _arg_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_arg_size = _tmp3_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaExpression* arg = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaExpression* _tmp8_;
			_arg_index = _arg_index + 1;
			_tmp4_ = _arg_index;
			_tmp5_ = _arg_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _arg_list;
			_tmp7_ = vala_list_get (_tmp6_, _arg_index);
			arg = (ValaExpression*) _tmp7_;
			_tmp8_ = arg;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp8_, collection);
			_vala_code_node_unref0 (arg);
		}
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp9_;
		gint _init_size = 0;
		ValaList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _init_index = 0;
		_tmp9_ = self->priv->object_initializer;
		_init_list = _tmp9_;
		_tmp10_ = _init_list;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_init_size = _tmp12_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp13_;
			gint _tmp14_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp15_;
			gpointer _tmp16_;
			ValaMemberInitializer* _tmp17_;
			_init_index = _init_index + 1;
			_tmp13_ = _init_index;
			_tmp14_ = _init_size;
			if (!(_tmp13_ < _tmp14_)) {
				break;
			}
			_tmp15_ = _init_list;
			_tmp16_ = vala_list_get (_tmp15_, _init_index);
			init = (ValaMemberInitializer*) _tmp16_;
			_tmp17_ = init;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp17_, collection);
			_vala_code_node_unref0 (init);
		}
	}
}

static gchar*
vala_object_creation_expression_real_to_string (ValaCodeNode* base)
{
	ValaObjectCreationExpression * self;
	GString* b = NULL;
	GString* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp4_;
	ValaMemberAccess* _tmp6_;
	ValaMemberAccess* _tmp7_;
	GString* _tmp13_;
	gboolean first = FALSE;
	GString* _tmp27_;
	GString* _tmp28_;
	const gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* result;
	self = (ValaObjectCreationExpression*) base;
	_tmp0_ = g_string_new ("");
	b = _tmp0_;
	_tmp1_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GString* _tmp3_;
		_tmp3_ = b;
		g_string_append (_tmp3_, "yield ");
	}
	_tmp4_ = self->priv->_struct_creation;
	if (!_tmp4_) {
		GString* _tmp5_;
		_tmp5_ = b;
		g_string_append (_tmp5_, "new ");
	}
	_tmp6_ = vala_object_creation_expression_get_member_name (self);
	_tmp7_ = _tmp6_;
	if (_tmp7_ != NULL) {
		GString* _tmp8_;
		ValaMemberAccess* _tmp9_;
		ValaMemberAccess* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp8_ = b;
		_tmp9_ = vala_object_creation_expression_get_member_name (self);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_code_node_to_string ((ValaCodeNode*) _tmp10_);
		_tmp12_ = _tmp11_;
		g_string_append (_tmp8_, _tmp12_);
		_g_free0 (_tmp12_);
	}
	_tmp13_ = b;
	g_string_append_c (_tmp13_, '(');
	first = TRUE;
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp14_;
		gint _expr_size = 0;
		ValaList* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gint _expr_index = 0;
		_tmp14_ = self->priv->argument_list;
		_expr_list = _tmp14_;
		_tmp15_ = _expr_list;
		_tmp16_ = vala_collection_get_size ((ValaCollection*) _tmp15_);
		_tmp17_ = _tmp16_;
		_expr_size = _tmp17_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp18_;
			gint _tmp19_;
			ValaExpression* expr = NULL;
			ValaList* _tmp20_;
			gpointer _tmp21_;
			GString* _tmp23_;
			ValaExpression* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			_expr_index = _expr_index + 1;
			_tmp18_ = _expr_index;
			_tmp19_ = _expr_size;
			if (!(_tmp18_ < _tmp19_)) {
				break;
			}
			_tmp20_ = _expr_list;
			_tmp21_ = vala_list_get (_tmp20_, _expr_index);
			expr = (ValaExpression*) _tmp21_;
			if (!first) {
				GString* _tmp22_;
				_tmp22_ = b;
				g_string_append (_tmp22_, ", ");
			}
			_tmp23_ = b;
			_tmp24_ = expr;
			_tmp25_ = vala_code_node_to_string ((ValaCodeNode*) _tmp24_);
			_tmp26_ = _tmp25_;
			g_string_append (_tmp23_, _tmp26_);
			_g_free0 (_tmp26_);
			first = FALSE;
			_vala_code_node_unref0 (expr);
		}
	}
	_tmp27_ = b;
	g_string_append_c (_tmp27_, ')');
	_tmp28_ = b;
	_tmp29_ = _tmp28_->str;
	_tmp30_ = g_strdup (_tmp29_);
	result = _tmp30_;
	_g_string_free0 (b);
	return result;
}

static void
vala_object_creation_expression_class_init (ValaObjectCreationExpressionClass * klass,
                                            gpointer klass_data)
{
	vala_object_creation_expression_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_object_creation_expression_finalize;
	g_type_class_adjust_private_offset (klass, &ValaObjectCreationExpression_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_object_creation_expression_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_object_creation_expression_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_object_creation_expression_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_object_creation_expression_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_object_creation_expression_real_is_accessible;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_object_creation_expression_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_object_creation_expression_real_check;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_object_creation_expression_real_get_error_types;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_object_creation_expression_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_object_creation_expression_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_object_creation_expression_real_get_used_variables;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_object_creation_expression_real_to_string;
}

static void
vala_object_creation_expression_vala_callable_expression_interface_init (ValaCallableExpressionIface * iface,
                                                                         gpointer iface_data)
{
	vala_object_creation_expression_vala_callable_expression_parent_iface = g_type_interface_peek_parent (iface);
	iface->add_argument = (void (*) (ValaCallableExpression*, ValaExpression*)) vala_object_creation_expression_real_add_argument;
	iface->get_argument_list = (ValaList* (*) (ValaCallableExpression*)) vala_object_creation_expression_real_get_argument_list;
	iface->get_is_yield_expression = vala_object_creation_expression_real_get_is_yield_expression;
	iface->set_is_yield_expression = vala_object_creation_expression_real_set_is_yield_expression;
	iface->get_is_chainup = vala_object_creation_expression_real_get_is_chainup;
	iface->set_is_chainup = vala_object_creation_expression_real_set_is_chainup;
}

static void
vala_object_creation_expression_instance_init (ValaObjectCreationExpression * self,
                                               gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	self->priv = vala_object_creation_expression_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->argument_list = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_MEMBER_INITIALIZER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
	self->priv->object_initializer = (ValaList*) _tmp3_;
}

static void
vala_object_creation_expression_finalize (ValaCodeNode * obj)
{
	ValaObjectCreationExpression * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_OBJECT_CREATION_EXPRESSION, ValaObjectCreationExpression);
	_vala_iterable_unref0 (self->priv->argument_list);
	_vala_iterable_unref0 (self->priv->object_initializer);
	_vala_code_node_unref0 (self->priv->_data_type);
	_vala_code_node_unref0 (self->priv->_member_name);
	VALA_CODE_NODE_CLASS (vala_object_creation_expression_parent_class)->finalize (obj);
}

/**
 * Represents an object creation expression in the source code.
 */
static GType
vala_object_creation_expression_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaObjectCreationExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_object_creation_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaObjectCreationExpression), 0, (GInstanceInitFunc) vala_object_creation_expression_instance_init, NULL };
	static const GInterfaceInfo vala_callable_expression_info = { (GInterfaceInitFunc) vala_object_creation_expression_vala_callable_expression_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType vala_object_creation_expression_type_id;
	vala_object_creation_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaObjectCreationExpression", &g_define_type_info, 0);
	g_type_add_interface_static (vala_object_creation_expression_type_id, VALA_TYPE_CALLABLE_EXPRESSION, &vala_callable_expression_info);
	ValaObjectCreationExpression_private_offset = g_type_add_instance_private (vala_object_creation_expression_type_id, sizeof (ValaObjectCreationExpressionPrivate));
	return vala_object_creation_expression_type_id;
}

GType
vala_object_creation_expression_get_type (void)
{
	static volatile gsize vala_object_creation_expression_type_id__once = 0;
	if (g_once_init_enter (&vala_object_creation_expression_type_id__once)) {
		GType vala_object_creation_expression_type_id;
		vala_object_creation_expression_type_id = vala_object_creation_expression_get_type_once ();
		g_once_init_leave (&vala_object_creation_expression_type_id__once, vala_object_creation_expression_type_id);
	}
	return vala_object_creation_expression_type_id__once;
}

