/* valaobjectcreationexpression.c generated by valac, the Vala compiler
 * generated from valaobjectcreationexpression.vala, do not modify */

/* valaobjectcreationexpression.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaObjectCreationExpressionPrivate {
	gboolean _is_yield_expression;
	gboolean _is_chainup;
	gboolean _struct_creation;
	ValaList* argument_list;
	ValaList* object_initializer;
	ValaDataType* _data_type;
	ValaMemberAccess* _member_name;
};

static gint ValaObjectCreationExpression_private_offset;
static gpointer vala_object_creation_expression_parent_class = NULL;
static ValaCallableExpressionIface * vala_object_creation_expression_vala_callable_expression_parent_iface = NULL;

static void vala_object_creation_expression_set_type_reference (ValaObjectCreationExpression* self,
                                                         ValaDataType* value);
static void vala_object_creation_expression_set_member_name (ValaObjectCreationExpression* self,
                                                      ValaMemberAccess* value);
static void vala_object_creation_expression_real_add_argument (ValaCallableExpression* base,
                                                        ValaExpression* arg);
static ValaList* vala_object_creation_expression_real_get_argument_list (ValaCallableExpression* base);
static void vala_object_creation_expression_real_accept (ValaCodeNode* base,
                                                  ValaCodeVisitor* visitor);
static void vala_object_creation_expression_real_accept_children (ValaCodeNode* base,
                                                           ValaCodeVisitor* visitor);
static void vala_object_creation_expression_real_replace_expression (ValaCodeNode* base,
                                                              ValaExpression* old_node,
                                                              ValaExpression* new_node);
static gboolean vala_object_creation_expression_real_is_pure (ValaExpression* base);
static gboolean vala_object_creation_expression_real_is_accessible (ValaExpression* base,
                                                             ValaSymbol* sym);
static void vala_object_creation_expression_real_replace_type (ValaCodeNode* base,
                                                        ValaDataType* old_type,
                                                        ValaDataType* new_type);
static gboolean vala_object_creation_expression_real_check (ValaCodeNode* base,
                                                     ValaCodeContext* context);
static void vala_object_creation_expression_real_get_error_types (ValaCodeNode* base,
                                                           ValaCollection* collection,
                                                           ValaSourceReference* source_reference);
static void vala_object_creation_expression_real_emit (ValaCodeNode* base,
                                                ValaCodeGenerator* codegen);
static void vala_object_creation_expression_real_get_defined_variables (ValaCodeNode* base,
                                                                 ValaCollection* collection);
static void vala_object_creation_expression_real_get_used_variables (ValaCodeNode* base,
                                                              ValaCollection* collection);
static gchar* vala_object_creation_expression_real_to_string (ValaCodeNode* base);
static void vala_object_creation_expression_finalize (ValaCodeNode * obj);
static GType vala_object_creation_expression_get_type_once (void);

static inline gpointer
vala_object_creation_expression_get_instance_private (ValaObjectCreationExpression* self)
{
	return G_STRUCT_MEMBER_P (self, ValaObjectCreationExpression_private_offset);
}

ValaDataType*
vala_object_creation_expression_get_type_reference (ValaObjectCreationExpression* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_data_type;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static void
vala_object_creation_expression_set_type_reference (ValaObjectCreationExpression* self,
                                                    ValaDataType* value)
{
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_data_type);
	self->priv->_data_type = _tmp0_;
	_tmp1_ = self->priv->_data_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

static ValaExpression*
vala_object_creation_expression_real_get_call (ValaCallableExpression* base)
{
	ValaExpression* result;
	ValaObjectCreationExpression* self;
	ValaMemberAccess* _tmp0_;
	ValaMemberAccess* _tmp1_;
	self = (ValaObjectCreationExpression*) base;
	_tmp0_ = vala_object_creation_expression_get_member_name (self);
	_tmp1_ = _tmp0_;
	result = (ValaExpression*) _tmp1_;
	return result;
}

ValaMemberAccess*
vala_object_creation_expression_get_member_name (ValaObjectCreationExpression* self)
{
	ValaMemberAccess* result;
	ValaMemberAccess* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_member_name;
	result = _tmp0_;
	return result;
}

static void
vala_object_creation_expression_set_member_name (ValaObjectCreationExpression* self,
                                                 ValaMemberAccess* value)
{
	ValaMemberAccess* _tmp0_;
	ValaMemberAccess* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_member_name);
	self->priv->_member_name = _tmp0_;
	_tmp1_ = self->priv->_member_name;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

static gboolean
vala_object_creation_expression_real_get_is_yield_expression (ValaCallableExpression* base)
{
	gboolean result;
	ValaObjectCreationExpression* self;
	self = (ValaObjectCreationExpression*) base;
	result = self->priv->_is_yield_expression;
	return result;
}

static void
vala_object_creation_expression_real_set_is_yield_expression (ValaCallableExpression* base,
                                                              gboolean value)
{
	ValaObjectCreationExpression* self;
	self = (ValaObjectCreationExpression*) base;
	self->priv->_is_yield_expression = value;
}

static gboolean
vala_object_creation_expression_real_get_is_chainup (ValaCallableExpression* base)
{
	gboolean result;
	ValaObjectCreationExpression* self;
	self = (ValaObjectCreationExpression*) base;
	result = self->priv->_is_chainup;
	return result;
}

static void
vala_object_creation_expression_real_set_is_chainup (ValaCallableExpression* base,
                                                     gboolean value)
{
	ValaObjectCreationExpression* self;
	self = (ValaObjectCreationExpression*) base;
	self->priv->_is_chainup = value;
}

gboolean
vala_object_creation_expression_get_struct_creation (ValaObjectCreationExpression* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_struct_creation;
	return result;
}

void
vala_object_creation_expression_set_struct_creation (ValaObjectCreationExpression* self,
                                                     gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_struct_creation = value;
}

/**
 * Creates a new object creation expression.
 *
 * @param member_name      object type to create
 * @param source_reference reference to source code
 * @return                 newly created object creation expression
 */
ValaObjectCreationExpression*
vala_object_creation_expression_construct (GType object_type,
                                           ValaMemberAccess* member_name,
                                           ValaSourceReference* source_reference)
{
	ValaObjectCreationExpression* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaObjectCreationExpression*) vala_expression_construct (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_object_creation_expression_set_member_name (self, member_name);
	return self;
}

ValaObjectCreationExpression*
vala_object_creation_expression_new (ValaMemberAccess* member_name,
                                     ValaSourceReference* source_reference)
{
	return vala_object_creation_expression_construct (VALA_TYPE_OBJECT_CREATION_EXPRESSION, member_name, source_reference);
}

/**
 * Appends the specified expression to the list of arguments.
 *
 * @param arg an argument
 */
static void
vala_object_creation_expression_real_add_argument (ValaCallableExpression* base,
                                                   ValaExpression* arg)
{
	ValaObjectCreationExpression * self;
	ValaList* _tmp0_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}

/**
 * Returns the argument list.
 *
 * @return argument list
 */
static ValaList*
vala_object_creation_expression_real_get_argument_list (ValaCallableExpression* base)
{
	ValaObjectCreationExpression * self;
	ValaList* _tmp0_;
	ValaList* result;
	self = (ValaObjectCreationExpression*) base;
	_tmp0_ = self->priv->argument_list;
	result = _tmp0_;
	return result;
}

/**
 * Appends the specified member initializer to the object initializer.
 *
 * @param init a member initializer
 */
void
vala_object_creation_expression_add_member_initializer (ValaObjectCreationExpression* self,
                                                        ValaMemberInitializer* init)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (init != NULL);
	_tmp0_ = self->priv->object_initializer;
	vala_collection_add ((ValaCollection*) _tmp0_, init);
	vala_code_node_set_parent_node ((ValaCodeNode*) init, (ValaCodeNode*) self);
}

/**
 * Returns the object initializer.
 *
 * @return member initializer list
 */
ValaList*
vala_object_creation_expression_get_object_initializer (ValaObjectCreationExpression* self)
{
	ValaList* _tmp0_;
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->object_initializer;
	result = _tmp0_;
	return result;
}

static void
vala_object_creation_expression_real_accept (ValaCodeNode* base,
                                             ValaCodeVisitor* visitor)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_object_creation_expression (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_object_creation_expression_real_accept_children (ValaCodeNode* base,
                                                      ValaCodeVisitor* visitor)
{
	ValaObjectCreationExpression * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaMemberAccess* _tmp4_;
	ValaMemberAccess* _tmp5_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_object_creation_expression_get_type_reference (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaDataType* _tmp2_;
		ValaDataType* _tmp3_;
		_tmp2_ = vala_object_creation_expression_get_type_reference (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	_tmp4_ = vala_object_creation_expression_get_member_name (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaMemberAccess* _tmp6_;
		ValaMemberAccess* _tmp7_;
		_tmp6_ = vala_object_creation_expression_get_member_name (self);
		_tmp7_ = _tmp6_;
		vala_code_node_accept ((ValaCodeNode*) _tmp7_, visitor);
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp8_;
		gint _arg_size = 0;
		ValaList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _arg_index = 0;
		_tmp8_ = self->priv->argument_list;
		_arg_list = _tmp8_;
		_tmp9_ = _arg_list;
		_tmp10_ = vala_collection_get_size ((ValaCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		_arg_size = _tmp11_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp12_;
			gint _tmp13_;
			ValaExpression* arg = NULL;
			ValaList* _tmp14_;
			gpointer _tmp15_;
			ValaExpression* _tmp16_;
			_arg_index = _arg_index + 1;
			_tmp12_ = _arg_index;
			_tmp13_ = _arg_size;
			if (!(_tmp12_ < _tmp13_)) {
				break;
			}
			_tmp14_ = _arg_list;
			_tmp15_ = vala_list_get (_tmp14_, _arg_index);
			arg = (ValaExpression*) _tmp15_;
			_tmp16_ = arg;
			vala_code_node_accept ((ValaCodeNode*) _tmp16_, visitor);
			_vala_code_node_unref0 (arg);
		}
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp17_;
		gint _init_size = 0;
		ValaList* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _init_index = 0;
		_tmp17_ = self->priv->object_initializer;
		_init_list = _tmp17_;
		_tmp18_ = _init_list;
		_tmp19_ = vala_collection_get_size ((ValaCollection*) _tmp18_);
		_tmp20_ = _tmp19_;
		_init_size = _tmp20_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp21_;
			gint _tmp22_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp23_;
			gpointer _tmp24_;
			ValaMemberInitializer* _tmp25_;
			_init_index = _init_index + 1;
			_tmp21_ = _init_index;
			_tmp22_ = _init_size;
			if (!(_tmp21_ < _tmp22_)) {
				break;
			}
			_tmp23_ = _init_list;
			_tmp24_ = vala_list_get (_tmp23_, _init_index);
			init = (ValaMemberInitializer*) _tmp24_;
			_tmp25_ = init;
			vala_code_node_accept ((ValaCodeNode*) _tmp25_, visitor);
			_vala_code_node_unref0 (init);
		}
	}
}

static void
vala_object_creation_expression_real_replace_expression (ValaCodeNode* base,
                                                         ValaExpression* old_node,
                                                         ValaExpression* new_node)
{
	ValaObjectCreationExpression * self;
	gint index = 0;
	ValaList* _tmp0_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = self->priv->argument_list;
	index = vala_list_index_of (_tmp0_, old_node);
	if (index >= 0) {
		ValaList* _tmp1_;
		_tmp1_ = self->priv->argument_list;
		vala_list_set (_tmp1_, index, new_node);
		vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
	}
}

static gboolean
vala_object_creation_expression_real_is_pure (ValaExpression* base)
{
	ValaObjectCreationExpression * self;
	gboolean result;
	self = (ValaObjectCreationExpression*) base;
	result = FALSE;
	return result;
}

static gboolean
vala_object_creation_expression_real_is_accessible (ValaExpression* base,
                                                    ValaSymbol* sym)
{
	ValaObjectCreationExpression * self;
	gboolean _tmp0_ = FALSE;
	ValaMemberAccess* _tmp1_;
	ValaMemberAccess* _tmp2_;
	gboolean result;
	self = (ValaObjectCreationExpression*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp1_ = vala_object_creation_expression_get_member_name (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		ValaMemberAccess* _tmp3_;
		ValaMemberAccess* _tmp4_;
		_tmp3_ = vala_object_creation_expression_get_member_name (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = !vala_expression_is_accessible ((ValaExpression*) _tmp4_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp5_;
		gint _arg_size = 0;
		ValaList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _arg_index = 0;
		_tmp5_ = self->priv->argument_list;
		_arg_list = _tmp5_;
		_tmp6_ = _arg_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_arg_size = _tmp8_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			ValaExpression* arg = NULL;
			ValaList* _tmp11_;
			gpointer _tmp12_;
			ValaExpression* _tmp13_;
			_arg_index = _arg_index + 1;
			_tmp9_ = _arg_index;
			_tmp10_ = _arg_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _arg_list;
			_tmp12_ = vala_list_get (_tmp11_, _arg_index);
			arg = (ValaExpression*) _tmp12_;
			_tmp13_ = arg;
			if (!vala_expression_is_accessible (_tmp13_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (arg);
				return result;
			}
			_vala_code_node_unref0 (arg);
		}
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp14_;
		gint _init_size = 0;
		ValaList* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gint _init_index = 0;
		_tmp14_ = self->priv->object_initializer;
		_init_list = _tmp14_;
		_tmp15_ = _init_list;
		_tmp16_ = vala_collection_get_size ((ValaCollection*) _tmp15_);
		_tmp17_ = _tmp16_;
		_init_size = _tmp17_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp18_;
			gint _tmp19_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp20_;
			gpointer _tmp21_;
			ValaMemberInitializer* _tmp22_;
			ValaExpression* _tmp23_;
			ValaExpression* _tmp24_;
			_init_index = _init_index + 1;
			_tmp18_ = _init_index;
			_tmp19_ = _init_size;
			if (!(_tmp18_ < _tmp19_)) {
				break;
			}
			_tmp20_ = _init_list;
			_tmp21_ = vala_list_get (_tmp20_, _init_index);
			init = (ValaMemberInitializer*) _tmp21_;
			_tmp22_ = init;
			_tmp23_ = vala_member_initializer_get_initializer (_tmp22_);
			_tmp24_ = _tmp23_;
			if (!vala_expression_is_accessible (_tmp24_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (init);
				return result;
			}
			_vala_code_node_unref0 (init);
		}
	}
	result = TRUE;
	return result;
}

static void
vala_object_creation_expression_real_replace_type (ValaCodeNode* base,
                                                   ValaDataType* old_type,
                                                   ValaDataType* new_type)
{
	ValaObjectCreationExpression * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_object_creation_expression_get_type_reference (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_object_creation_expression_set_type_reference (self, new_type);
	}
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static gboolean
vala_object_creation_expression_real_check (ValaCodeNode* base,
                                            ValaCodeContext* context)
{
	ValaObjectCreationExpression * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaMemberAccess* _tmp4_;
	ValaMemberAccess* _tmp5_;
	ValaTypeSymbol* type = NULL;
	ValaMemberAccess* _tmp6_;
	ValaMemberAccess* _tmp7_;
	ValaSymbol* _tmp8_;
	ValaSymbol* _tmp9_;
	ValaSymbol* constructor_sym = NULL;
	ValaMemberAccess* _tmp10_;
	ValaMemberAccess* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaSymbol* _tmp14_;
	ValaSymbol* type_sym = NULL;
	ValaMemberAccess* _tmp15_;
	ValaMemberAccess* _tmp16_;
	ValaSymbol* _tmp17_;
	ValaSymbol* _tmp18_;
	ValaSymbol* _tmp19_;
	ValaList* type_args = NULL;
	ValaMemberAccess* _tmp20_;
	ValaMemberAccess* _tmp21_;
	ValaList* _tmp22_;
	ValaList* _tmp23_;
	ValaSymbol* _tmp24_;
	ValaSymbol* _tmp46_;
	ValaDataType* _tmp97_;
	ValaDataType* _tmp98_;
	ValaSemanticAnalyzer* _tmp99_;
	ValaSemanticAnalyzer* _tmp100_;
	ValaDataType* _tmp101_;
	ValaDataType* _tmp102_;
	ValaDataType* _tmp103_;
	ValaDataType* _tmp104_;
	ValaDataType* _tmp105_;
	ValaDataType* _tmp106_;
	ValaDataType* _tmp107_;
	ValaDataType* _tmp108_;
	ValaDataType* _tmp109_;
	ValaDataType* _tmp110_;
	ValaTypeSymbol* _tmp111_;
	gboolean _tmp217_ = FALSE;
	ValaSymbol* _tmp218_;
	ValaSymbol* _tmp219_;
	ValaSymbol* _tmp228_;
	ValaSymbol* _tmp229_;
	gboolean _tmp561_;
	gboolean _tmp562_;
	gboolean _tmp618_;
	gboolean _tmp619_;
	gboolean result;
	self = (ValaObjectCreationExpression*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_object_creation_expression_get_member_name (self);
	_tmp5_ = _tmp4_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp5_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp6_ = vala_object_creation_expression_get_member_name (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_ == NULL) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		_vala_code_node_unref0 (type);
		return result;
	}
	_tmp10_ = vala_object_creation_expression_get_member_name (self);
	_tmp11_ = _tmp10_;
	_tmp12_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = _vala_code_node_ref0 (_tmp13_);
	constructor_sym = _tmp14_;
	_tmp15_ = vala_object_creation_expression_get_member_name (self);
	_tmp16_ = _tmp15_;
	_tmp17_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = _vala_code_node_ref0 (_tmp18_);
	type_sym = _tmp19_;
	_tmp20_ = vala_object_creation_expression_get_member_name (self);
	_tmp21_ = _tmp20_;
	_tmp22_ = vala_member_access_get_type_arguments (_tmp21_);
	_tmp23_ = _vala_iterable_ref0 (_tmp22_);
	type_args = _tmp23_;
	_tmp24_ = constructor_sym;
	if (VALA_IS_METHOD (_tmp24_)) {
		ValaSymbol* _tmp25_;
		ValaSymbol* _tmp26_;
		ValaSymbol* _tmp27_;
		ValaSymbol* _tmp28_;
		ValaMethod* constructor = NULL;
		ValaSymbol* _tmp29_;
		ValaMethod* _tmp30_;
		ValaSymbol* _tmp31_;
		ValaMethod* _tmp37_;
		ValaMemberAccess* ma = NULL;
		ValaMemberAccess* _tmp38_;
		ValaMemberAccess* _tmp39_;
		ValaExpression* _tmp40_;
		ValaExpression* _tmp41_;
		ValaMemberAccess* _tmp42_;
		_tmp25_ = constructor_sym;
		_tmp26_ = vala_symbol_get_parent_symbol (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = _vala_code_node_ref0 (_tmp27_);
		_vala_code_node_unref0 (type_sym);
		type_sym = _tmp28_;
		_tmp29_ = constructor_sym;
		_tmp30_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, VALA_TYPE_METHOD, ValaMethod));
		constructor = _tmp30_;
		_tmp31_ = constructor_sym;
		if (!VALA_IS_CREATION_METHOD (_tmp31_)) {
			ValaSourceReference* _tmp32_;
			ValaSourceReference* _tmp33_;
			ValaMethod* _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp36_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp32_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp33_ = _tmp32_;
			_tmp34_ = constructor;
			_tmp35_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp34_);
			_tmp36_ = _tmp35_;
			vala_report_error (_tmp33_, "`%s' is not a creation method", _tmp36_);
			_g_free0 (_tmp36_);
			result = FALSE;
			_vala_code_node_unref0 (constructor);
			_vala_iterable_unref0 (type_args);
			_vala_code_node_unref0 (type_sym);
			_vala_code_node_unref0 (constructor_sym);
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp37_ = constructor;
		vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp37_);
		_tmp38_ = vala_object_creation_expression_get_member_name (self);
		_tmp39_ = _tmp38_;
		_tmp40_ = vala_member_access_get_inner (_tmp39_);
		_tmp41_ = _tmp40_;
		ma = VALA_IS_MEMBER_ACCESS (_tmp41_) ? ((ValaMemberAccess*) _tmp41_) : NULL;
		_tmp42_ = ma;
		if (_tmp42_ != NULL) {
			ValaMemberAccess* _tmp43_;
			ValaList* _tmp44_;
			ValaList* _tmp45_;
			_tmp43_ = ma;
			_tmp44_ = vala_member_access_get_type_arguments (_tmp43_);
			_tmp45_ = _vala_iterable_ref0 (_tmp44_);
			_vala_iterable_unref0 (type_args);
			type_args = _tmp45_;
		}
		_vala_code_node_unref0 (constructor);
	}
	_tmp46_ = type_sym;
	if (VALA_IS_CLASS (_tmp46_)) {
		ValaSymbol* _tmp47_;
		ValaTypeSymbol* _tmp48_;
		ValaTypeSymbol* _tmp49_;
		gboolean _tmp50_;
		gboolean _tmp51_;
		_tmp47_ = type_sym;
		_tmp48_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
		_vala_code_node_unref0 (type);
		type = _tmp48_;
		_tmp49_ = type;
		_tmp50_ = vala_class_get_is_error_base (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, VALA_TYPE_CLASS, ValaClass));
		_tmp51_ = _tmp50_;
		if (_tmp51_) {
			ValaSourceReference* _tmp52_;
			ValaSourceReference* _tmp53_;
			ValaErrorType* _tmp54_;
			ValaErrorType* _tmp55_;
			_tmp52_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp53_ = _tmp52_;
			_tmp54_ = vala_error_type_new (NULL, NULL, _tmp53_);
			_tmp55_ = _tmp54_;
			vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp55_);
			_vala_code_node_unref0 (_tmp55_);
		} else {
			ValaTypeSymbol* _tmp56_;
			ValaSourceReference* _tmp57_;
			ValaSourceReference* _tmp58_;
			ValaObjectType* _tmp59_;
			ValaObjectType* _tmp60_;
			_tmp56_ = type;
			_tmp57_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp58_ = _tmp57_;
			_tmp59_ = vala_object_type_new ((ValaObjectTypeSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, VALA_TYPE_CLASS, ValaClass), _tmp58_);
			_tmp60_ = _tmp59_;
			vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp60_);
			_vala_code_node_unref0 (_tmp60_);
		}
	} else {
		ValaSymbol* _tmp61_;
		_tmp61_ = type_sym;
		if (VALA_IS_STRUCT (_tmp61_)) {
			ValaSymbol* _tmp62_;
			ValaTypeSymbol* _tmp63_;
			ValaTypeSymbol* _tmp64_;
			ValaSourceReference* _tmp65_;
			ValaSourceReference* _tmp66_;
			ValaStructValueType* _tmp67_;
			ValaStructValueType* _tmp68_;
			_tmp62_ = type_sym;
			_tmp63_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp62_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
			_vala_code_node_unref0 (type);
			type = _tmp63_;
			_tmp64_ = type;
			_tmp65_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp66_ = _tmp65_;
			_tmp67_ = vala_struct_value_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp64_, VALA_TYPE_STRUCT, ValaStruct), _tmp66_);
			_tmp68_ = _tmp67_;
			vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp68_);
			_vala_code_node_unref0 (_tmp68_);
		} else {
			ValaSymbol* _tmp69_;
			_tmp69_ = type_sym;
			if (VALA_IS_ERROR_CODE (_tmp69_)) {
				ValaSymbol* _tmp70_;
				ValaTypeSymbol* _tmp71_;
				ValaSymbol* _tmp72_;
				ValaSymbol* _tmp73_;
				ValaSymbol* _tmp74_;
				ValaSymbol* _tmp75_;
				ValaSourceReference* _tmp76_;
				ValaSourceReference* _tmp77_;
				ValaErrorType* _tmp78_;
				ValaErrorType* _tmp79_;
				ValaSymbol* _tmp80_;
				_tmp70_ = type_sym;
				_tmp71_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp70_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
				_vala_code_node_unref0 (type);
				type = _tmp71_;
				_tmp72_ = type_sym;
				_tmp73_ = vala_symbol_get_parent_symbol (_tmp72_);
				_tmp74_ = _tmp73_;
				_tmp75_ = type_sym;
				_tmp76_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp77_ = _tmp76_;
				_tmp78_ = vala_error_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp74_, VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain), G_TYPE_CHECK_INSTANCE_CAST (_tmp75_, VALA_TYPE_ERROR_CODE, ValaErrorCode), _tmp77_);
				_tmp79_ = _tmp78_;
				vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp79_);
				_vala_code_node_unref0 (_tmp79_);
				_tmp80_ = type_sym;
				vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp80_);
			} else {
				ValaSourceReference* _tmp81_;
				ValaSourceReference* _tmp82_;
				ValaSymbol* _tmp83_;
				gchar* _tmp84_;
				gchar* _tmp85_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp81_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp82_ = _tmp81_;
				_tmp83_ = type_sym;
				_tmp84_ = vala_symbol_get_full_name (_tmp83_);
				_tmp85_ = _tmp84_;
				vala_report_error (_tmp82_, "`%s' is not a class, struct, or error code", _tmp85_);
				_g_free0 (_tmp85_);
				result = FALSE;
				_vala_iterable_unref0 (type_args);
				_vala_code_node_unref0 (type_sym);
				_vala_code_node_unref0 (constructor_sym);
				_vala_code_node_unref0 (type);
				return result;
			}
		}
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp86_;
		gint _type_arg_size = 0;
		ValaList* _tmp87_;
		gint _tmp88_;
		gint _tmp89_;
		gint _type_arg_index = 0;
		_tmp86_ = type_args;
		_type_arg_list = _tmp86_;
		_tmp87_ = _type_arg_list;
		_tmp88_ = vala_collection_get_size ((ValaCollection*) _tmp87_);
		_tmp89_ = _tmp88_;
		_type_arg_size = _tmp89_;
		_type_arg_index = -1;
		while (TRUE) {
			gint _tmp90_;
			gint _tmp91_;
			ValaDataType* type_arg = NULL;
			ValaList* _tmp92_;
			gpointer _tmp93_;
			ValaDataType* _tmp94_;
			ValaDataType* _tmp95_;
			ValaDataType* _tmp96_;
			_type_arg_index = _type_arg_index + 1;
			_tmp90_ = _type_arg_index;
			_tmp91_ = _type_arg_size;
			if (!(_tmp90_ < _tmp91_)) {
				break;
			}
			_tmp92_ = _type_arg_list;
			_tmp93_ = vala_list_get (_tmp92_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp93_;
			_tmp94_ = vala_object_creation_expression_get_type_reference (self);
			_tmp95_ = _tmp94_;
			_tmp96_ = type_arg;
			vala_data_type_add_type_argument (_tmp95_, _tmp96_);
			_vala_code_node_unref0 (type_arg);
		}
	}
	_tmp97_ = vala_object_creation_expression_get_type_reference (self);
	_tmp98_ = _tmp97_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp98_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		_vala_iterable_unref0 (type_args);
		_vala_code_node_unref0 (type_sym);
		_vala_code_node_unref0 (constructor_sym);
		_vala_code_node_unref0 (type);
		return result;
	}
	_tmp99_ = vala_code_context_get_analyzer (context);
	_tmp100_ = _tmp99_;
	_tmp101_ = vala_object_creation_expression_get_type_reference (self);
	_tmp102_ = _tmp101_;
	vala_semantic_analyzer_check_type (_tmp100_, _tmp102_);
	_tmp103_ = vala_object_creation_expression_get_type_reference (self);
	_tmp104_ = _tmp103_;
	if (!vala_data_type_check_type_arguments (_tmp104_, context, FALSE)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		_vala_iterable_unref0 (type_args);
		_vala_code_node_unref0 (type_sym);
		_vala_code_node_unref0 (constructor_sym);
		_vala_code_node_unref0 (type);
		return result;
	}
	_tmp105_ = vala_object_creation_expression_get_type_reference (self);
	_tmp106_ = _tmp105_;
	_tmp107_ = vala_data_type_copy (_tmp106_);
	_tmp108_ = _tmp107_;
	vala_expression_set_value_type ((ValaExpression*) self, _tmp108_);
	_vala_code_node_unref0 (_tmp108_);
	_tmp109_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp110_ = _tmp109_;
	vala_data_type_set_value_owned (_tmp110_, TRUE);
	_tmp111_ = type;
	if (VALA_IS_CLASS (_tmp111_)) {
		ValaClass* cl = NULL;
		ValaTypeSymbol* _tmp112_;
		ValaClass* _tmp113_;
		gboolean _tmp114_;
		ValaClass* _tmp117_;
		gboolean _tmp118_;
		gboolean _tmp119_;
		ValaSymbol* _tmp125_;
		ValaSymbol* _tmp126_;
		gboolean _tmp145_ = FALSE;
		ValaSymbol* _tmp146_;
		ValaSymbol* _tmp147_;
		_tmp112_ = type;
		_tmp113_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp112_, VALA_TYPE_CLASS, ValaClass));
		cl = _tmp113_;
		_tmp114_ = self->priv->_struct_creation;
		if (_tmp114_) {
			ValaSourceReference* _tmp115_;
			ValaSourceReference* _tmp116_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp115_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp116_ = _tmp115_;
			vala_report_error (_tmp116_, "syntax error, use `new' to create new objects");
			result = FALSE;
			_vala_code_node_unref0 (cl);
			_vala_iterable_unref0 (type_args);
			_vala_code_node_unref0 (type_sym);
			_vala_code_node_unref0 (constructor_sym);
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp117_ = cl;
		_tmp118_ = vala_class_get_is_abstract (_tmp117_);
		_tmp119_ = _tmp118_;
		if (_tmp119_) {
			ValaSourceReference* _tmp120_;
			ValaSourceReference* _tmp121_;
			ValaClass* _tmp122_;
			gchar* _tmp123_;
			gchar* _tmp124_;
			vala_expression_set_value_type ((ValaExpression*) self, NULL);
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp120_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp121_ = _tmp120_;
			_tmp122_ = cl;
			_tmp123_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp122_);
			_tmp124_ = _tmp123_;
			vala_report_error (_tmp121_, "Can't create instance of abstract class `%s'", _tmp124_);
			_g_free0 (_tmp124_);
			result = FALSE;
			_vala_code_node_unref0 (cl);
			_vala_iterable_unref0 (type_args);
			_vala_code_node_unref0 (type_sym);
			_vala_code_node_unref0 (constructor_sym);
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp125_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp126_ = _tmp125_;
		if (_tmp126_ == NULL) {
			ValaClass* _tmp127_;
			ValaCreationMethod* _tmp128_;
			ValaCreationMethod* _tmp129_;
			ValaSymbol* _tmp130_;
			ValaSymbol* _tmp131_;
			ValaSymbol* _tmp137_;
			ValaSymbol* _tmp138_;
			ValaSymbol* _tmp139_;
			ValaSymbol* _tmp140_;
			ValaVersionAttribute* _tmp141_;
			ValaVersionAttribute* _tmp142_;
			ValaSourceReference* _tmp143_;
			ValaSourceReference* _tmp144_;
			_tmp127_ = cl;
			_tmp128_ = vala_class_get_default_construction_method (_tmp127_);
			_tmp129_ = _tmp128_;
			vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp129_);
			_tmp130_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp131_ = _tmp130_;
			if (_tmp131_ == NULL) {
				ValaSourceReference* _tmp132_;
				ValaSourceReference* _tmp133_;
				ValaClass* _tmp134_;
				gchar* _tmp135_;
				gchar* _tmp136_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp132_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp133_ = _tmp132_;
				_tmp134_ = cl;
				_tmp135_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp134_);
				_tmp136_ = _tmp135_;
				vala_report_error (_tmp133_, "`%s' does not have a default constructor", _tmp136_);
				_g_free0 (_tmp136_);
				result = FALSE;
				_vala_code_node_unref0 (cl);
				_vala_iterable_unref0 (type_args);
				_vala_code_node_unref0 (type_sym);
				_vala_code_node_unref0 (constructor_sym);
				_vala_code_node_unref0 (type);
				return result;
			}
			_tmp137_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp138_ = _tmp137_;
			vala_symbol_set_used (_tmp138_, TRUE);
			_tmp139_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp140_ = _tmp139_;
			_tmp141_ = vala_symbol_get_version (_tmp140_);
			_tmp142_ = _tmp141_;
			_tmp143_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp144_ = _tmp143_;
			vala_version_attribute_check (_tmp142_, context, _tmp144_);
		}
		_tmp146_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp147_ = _tmp146_;
		if (_tmp147_ != NULL) {
			gboolean _tmp148_ = FALSE;
			ValaSymbol* _tmp149_;
			ValaSymbol* _tmp150_;
			ValaSymbolAccessibility _tmp151_;
			ValaSymbolAccessibility _tmp152_;
			_tmp149_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp150_ = _tmp149_;
			_tmp151_ = vala_symbol_get_access (_tmp150_);
			_tmp152_ = _tmp151_;
			if (_tmp152_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
				_tmp148_ = TRUE;
			} else {
				ValaSymbol* _tmp153_;
				ValaSymbol* _tmp154_;
				ValaSymbolAccessibility _tmp155_;
				ValaSymbolAccessibility _tmp156_;
				_tmp153_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp154_ = _tmp153_;
				_tmp155_ = vala_symbol_get_access (_tmp154_);
				_tmp156_ = _tmp155_;
				_tmp148_ = _tmp156_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED;
			}
			_tmp145_ = _tmp148_;
		} else {
			_tmp145_ = FALSE;
		}
		if (_tmp145_) {
			gboolean in_target_type = FALSE;
			in_target_type = FALSE;
			{
				ValaSymbol* this_symbol = NULL;
				ValaSemanticAnalyzer* _tmp157_;
				ValaSemanticAnalyzer* _tmp158_;
				ValaSymbol* _tmp159_;
				ValaSymbol* _tmp160_;
				ValaSymbol* _tmp161_;
				_tmp157_ = vala_code_context_get_analyzer (context);
				_tmp158_ = _tmp157_;
				_tmp159_ = vala_semantic_analyzer_get_current_symbol (_tmp158_);
				_tmp160_ = _tmp159_;
				_tmp161_ = _vala_code_node_ref0 (_tmp160_);
				this_symbol = _tmp161_;
				{
					gboolean _tmp162_ = FALSE;
					_tmp162_ = TRUE;
					while (TRUE) {
						ValaSymbol* _tmp167_;
						ValaSymbol* _tmp168_;
						ValaClass* _tmp169_;
						if (!_tmp162_) {
							ValaSymbol* _tmp163_;
							ValaSymbol* _tmp164_;
							ValaSymbol* _tmp165_;
							ValaSymbol* _tmp166_;
							_tmp163_ = this_symbol;
							_tmp164_ = vala_symbol_get_parent_symbol (_tmp163_);
							_tmp165_ = _tmp164_;
							_tmp166_ = _vala_code_node_ref0 (_tmp165_);
							_vala_code_node_unref0 (this_symbol);
							this_symbol = _tmp166_;
						}
						_tmp162_ = FALSE;
						_tmp167_ = this_symbol;
						if (!(_tmp167_ != NULL)) {
							break;
						}
						_tmp168_ = this_symbol;
						_tmp169_ = cl;
						if (_tmp168_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp169_, VALA_TYPE_SYMBOL, ValaSymbol)) {
							in_target_type = TRUE;
							break;
						}
					}
				}
				_vala_code_node_unref0 (this_symbol);
			}
			if (!in_target_type) {
				ValaSourceReference* _tmp170_;
				ValaSourceReference* _tmp171_;
				ValaSymbol* _tmp172_;
				ValaSymbol* _tmp173_;
				gchar* _tmp174_;
				gchar* _tmp175_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp170_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp171_ = _tmp170_;
				_tmp172_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp173_ = _tmp172_;
				_tmp174_ = vala_symbol_get_full_name (_tmp173_);
				_tmp175_ = _tmp174_;
				vala_report_error (_tmp171_, "Access to non-public constructor `%s' denied", _tmp175_);
				_g_free0 (_tmp175_);
				result = FALSE;
				_vala_code_node_unref0 (cl);
				_vala_iterable_unref0 (type_args);
				_vala_code_node_unref0 (type_sym);
				_vala_code_node_unref0 (constructor_sym);
				_vala_code_node_unref0 (type);
				return result;
			}
		}
		while (TRUE) {
			ValaClass* _tmp176_;
			ValaClass* _tmp177_;
			gchar* _tmp178_;
			gchar* _tmp179_;
			gboolean _tmp180_;
			ValaClass* _tmp183_;
			ValaClass* _tmp184_;
			ValaClass* _tmp185_;
			ValaClass* _tmp186_;
			_tmp176_ = cl;
			if (!(_tmp176_ != NULL)) {
				break;
			}
			_tmp177_ = cl;
			_tmp178_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp177_, "CCode", "ref_sink_function", NULL);
			_tmp179_ = _tmp178_;
			_tmp180_ = _tmp179_ != NULL;
			_g_free0 (_tmp179_);
			if (_tmp180_) {
				ValaDataType* _tmp181_;
				ValaDataType* _tmp182_;
				_tmp181_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp182_ = _tmp181_;
				vala_data_type_set_floating_reference (_tmp182_, TRUE);
				break;
			}
			_tmp183_ = cl;
			_tmp184_ = vala_class_get_base_class (_tmp183_);
			_tmp185_ = _tmp184_;
			_tmp186_ = _vala_code_node_ref0 (_tmp185_);
			_vala_code_node_unref0 (cl);
			cl = _tmp186_;
		}
		_vala_code_node_unref0 (cl);
	} else {
		ValaTypeSymbol* _tmp187_;
		_tmp187_ = type;
		if (VALA_IS_STRUCT (_tmp187_)) {
			ValaStruct* st = NULL;
			ValaTypeSymbol* _tmp188_;
			ValaStruct* _tmp189_;
			gboolean _tmp190_ = FALSE;
			gboolean _tmp191_;
			ValaSymbol* _tmp196_;
			ValaSymbol* _tmp197_;
			gboolean _tmp201_ = FALSE;
			gboolean _tmp202_ = FALSE;
			gboolean _tmp203_ = FALSE;
			ValaProfile _tmp204_;
			ValaProfile _tmp205_;
			_tmp188_ = type;
			_tmp189_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp188_, VALA_TYPE_STRUCT, ValaStruct));
			st = _tmp189_;
			_tmp191_ = self->priv->_struct_creation;
			if (!_tmp191_) {
				gboolean _tmp192_;
				gboolean _tmp193_;
				_tmp192_ = vala_code_context_get_deprecated (context);
				_tmp193_ = _tmp192_;
				_tmp190_ = !_tmp193_;
			} else {
				_tmp190_ = FALSE;
			}
			if (_tmp190_) {
				ValaSourceReference* _tmp194_;
				ValaSourceReference* _tmp195_;
				_tmp194_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp195_ = _tmp194_;
				vala_report_warning (_tmp195_, "deprecated syntax, don't use `new' to initialize structs");
			}
			_tmp196_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp197_ = _tmp196_;
			if (_tmp197_ == NULL) {
				ValaStruct* _tmp198_;
				ValaCreationMethod* _tmp199_;
				ValaCreationMethod* _tmp200_;
				_tmp198_ = st;
				_tmp199_ = vala_struct_get_default_construction_method (_tmp198_);
				_tmp200_ = _tmp199_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp200_);
			}
			_tmp204_ = vala_code_context_get_profile (context);
			_tmp205_ = _tmp204_;
			if (_tmp205_ == VALA_PROFILE_GOBJECT) {
				ValaStruct* _tmp206_;
				_tmp206_ = st;
				_tmp203_ = vala_struct_is_simple_type (_tmp206_);
			} else {
				_tmp203_ = FALSE;
			}
			if (_tmp203_) {
				ValaSymbol* _tmp207_;
				ValaSymbol* _tmp208_;
				_tmp207_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp208_ = _tmp207_;
				_tmp202_ = _tmp208_ == NULL;
			} else {
				_tmp202_ = FALSE;
			}
			if (_tmp202_) {
				ValaList* _tmp209_;
				gint _tmp210_;
				gint _tmp211_;
				_tmp209_ = self->priv->object_initializer;
				_tmp210_ = vala_collection_get_size ((ValaCollection*) _tmp209_);
				_tmp211_ = _tmp210_;
				_tmp201_ = _tmp211_ == 0;
			} else {
				_tmp201_ = FALSE;
			}
			if (_tmp201_) {
				ValaSourceReference* _tmp212_;
				ValaSourceReference* _tmp213_;
				ValaStruct* _tmp214_;
				gchar* _tmp215_;
				gchar* _tmp216_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp212_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp213_ = _tmp212_;
				_tmp214_ = st;
				_tmp215_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp214_);
				_tmp216_ = _tmp215_;
				vala_report_error (_tmp213_, "`%s' does not have a default constructor", _tmp216_);
				_g_free0 (_tmp216_);
				result = FALSE;
				_vala_code_node_unref0 (st);
				_vala_iterable_unref0 (type_args);
				_vala_code_node_unref0 (type_sym);
				_vala_code_node_unref0 (constructor_sym);
				_vala_code_node_unref0 (type);
				return result;
			}
			_vala_code_node_unref0 (st);
		}
	}
	_tmp218_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp219_ = _tmp218_;
	if (_tmp219_ == NULL) {
		ValaList* _tmp220_;
		gint _tmp221_;
		gint _tmp222_;
		_tmp220_ = self->priv->argument_list;
		_tmp221_ = vala_collection_get_size ((ValaCollection*) _tmp220_);
		_tmp222_ = _tmp221_;
		_tmp217_ = _tmp222_ != 0;
	} else {
		_tmp217_ = FALSE;
	}
	if (_tmp217_) {
		ValaSourceReference* _tmp223_;
		ValaSourceReference* _tmp224_;
		ValaTypeSymbol* _tmp225_;
		gchar* _tmp226_;
		gchar* _tmp227_;
		vala_expression_set_value_type ((ValaExpression*) self, NULL);
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp223_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp224_ = _tmp223_;
		_tmp225_ = type;
		_tmp226_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp225_);
		_tmp227_ = _tmp226_;
		vala_report_error (_tmp224_, "No arguments allowed when constructing type `%s'", _tmp227_);
		_g_free0 (_tmp227_);
		result = FALSE;
		_vala_iterable_unref0 (type_args);
		_vala_code_node_unref0 (type_sym);
		_vala_code_node_unref0 (constructor_sym);
		_vala_code_node_unref0 (type);
		return result;
	}
	_tmp228_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp229_ = _tmp228_;
	if (VALA_IS_METHOD (_tmp229_)) {
		ValaMethod* m = NULL;
		ValaSymbol* _tmp230_;
		ValaSymbol* _tmp231_;
		ValaMethod* _tmp232_;
		gboolean _tmp233_;
		gboolean _tmp234_;
		ValaExpression* last_arg = NULL;
		ValaIterator* arg_it = NULL;
		ValaList* _tmp259_;
		ValaIterator* _tmp260_;
		ValaMethod* _tmp311_;
		gboolean _tmp312_;
		gboolean _tmp313_;
		ValaSemanticAnalyzer* _tmp376_;
		ValaSemanticAnalyzer* _tmp377_;
		ValaMethod* _tmp378_;
		ValaMethodType* _tmp379_;
		ValaMethodType* _tmp380_;
		ValaMethod* _tmp381_;
		ValaList* _tmp382_;
		ValaList* _tmp383_;
		_tmp230_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp231_ = _tmp230_;
		_tmp232_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp231_, VALA_TYPE_METHOD, ValaMethod));
		m = _tmp232_;
		_tmp233_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) self);
		_tmp234_ = _tmp233_;
		if (_tmp234_) {
			ValaMethod* _tmp235_;
			gboolean _tmp236_;
			gboolean _tmp237_;
			gboolean _tmp240_ = FALSE;
			ValaSemanticAnalyzer* _tmp241_;
			ValaSemanticAnalyzer* _tmp242_;
			ValaMethod* _tmp243_;
			ValaMethod* _tmp244_;
			_tmp235_ = m;
			_tmp236_ = vala_method_get_coroutine (_tmp235_);
			_tmp237_ = _tmp236_;
			if (!_tmp237_) {
				ValaSourceReference* _tmp238_;
				ValaSourceReference* _tmp239_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp238_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp239_ = _tmp238_;
				vala_report_error (_tmp239_, "yield expression requires async method");
			}
			_tmp241_ = vala_code_context_get_analyzer (context);
			_tmp242_ = _tmp241_;
			_tmp243_ = vala_semantic_analyzer_get_current_method (_tmp242_);
			_tmp244_ = _tmp243_;
			if (_tmp244_ == NULL) {
				_tmp240_ = TRUE;
			} else {
				ValaSemanticAnalyzer* _tmp245_;
				ValaSemanticAnalyzer* _tmp246_;
				ValaMethod* _tmp247_;
				ValaMethod* _tmp248_;
				gboolean _tmp249_;
				gboolean _tmp250_;
				_tmp245_ = vala_code_context_get_analyzer (context);
				_tmp246_ = _tmp245_;
				_tmp247_ = vala_semantic_analyzer_get_current_method (_tmp246_);
				_tmp248_ = _tmp247_;
				_tmp249_ = vala_method_get_coroutine (_tmp248_);
				_tmp250_ = _tmp249_;
				_tmp240_ = !_tmp250_;
			}
			if (_tmp240_) {
				ValaSourceReference* _tmp251_;
				ValaSourceReference* _tmp252_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp251_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp252_ = _tmp251_;
				vala_report_error (_tmp252_, "yield expression not available outside async method");
			}
		} else {
			ValaMethod* _tmp253_;
			_tmp253_ = m;
			if (VALA_IS_CREATION_METHOD (_tmp253_)) {
				ValaMethod* _tmp254_;
				gboolean _tmp255_;
				gboolean _tmp256_;
				_tmp254_ = m;
				_tmp255_ = vala_method_get_coroutine (_tmp254_);
				_tmp256_ = _tmp255_;
				if (_tmp256_) {
					ValaSourceReference* _tmp257_;
					ValaSourceReference* _tmp258_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp257_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp258_ = _tmp257_;
					vala_report_error (_tmp258_, "missing `yield' before async creation expression");
				}
			}
		}
		last_arg = NULL;
		_tmp259_ = self->priv->argument_list;
		_tmp260_ = vala_iterable_iterator ((ValaIterable*) _tmp259_);
		arg_it = _tmp260_;
		{
			ValaList* _param_list = NULL;
			ValaMethod* _tmp261_;
			ValaList* _tmp262_;
			gint _param_size = 0;
			ValaList* _tmp263_;
			gint _tmp264_;
			gint _tmp265_;
			gint _param_index = 0;
			_tmp261_ = m;
			_tmp262_ = vala_callable_get_parameters ((ValaCallable*) _tmp261_);
			_param_list = _tmp262_;
			_tmp263_ = _param_list;
			_tmp264_ = vala_collection_get_size ((ValaCollection*) _tmp263_);
			_tmp265_ = _tmp264_;
			_param_size = _tmp265_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp266_;
				gint _tmp267_;
				ValaParameter* param = NULL;
				ValaList* _tmp268_;
				gpointer _tmp269_;
				ValaParameter* _tmp270_;
				ValaParameter* _tmp271_;
				gboolean _tmp272_;
				gboolean _tmp273_;
				ValaParameter* _tmp274_;
				gboolean _tmp275_;
				gboolean _tmp276_;
				ValaIterator* _tmp294_;
				_param_index = _param_index + 1;
				_tmp266_ = _param_index;
				_tmp267_ = _param_size;
				if (!(_tmp266_ < _tmp267_)) {
					break;
				}
				_tmp268_ = _param_list;
				_tmp269_ = vala_list_get (_tmp268_, _param_index);
				param = (ValaParameter*) _tmp269_;
				_tmp270_ = param;
				if (!vala_code_node_check ((ValaCodeNode*) _tmp270_, context)) {
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
				_tmp271_ = param;
				_tmp272_ = vala_parameter_get_ellipsis (_tmp271_);
				_tmp273_ = _tmp272_;
				if (_tmp273_) {
					_vala_code_node_unref0 (param);
					break;
				}
				_tmp274_ = param;
				_tmp275_ = vala_parameter_get_params_array (_tmp274_);
				_tmp276_ = _tmp275_;
				if (_tmp276_) {
					ValaArrayType* array_type = NULL;
					ValaParameter* _tmp277_;
					ValaDataType* _tmp278_;
					ValaDataType* _tmp279_;
					ValaArrayType* _tmp280_;
					_tmp277_ = param;
					_tmp278_ = vala_variable_get_variable_type ((ValaVariable*) _tmp277_);
					_tmp279_ = _tmp278_;
					_tmp280_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp279_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
					array_type = _tmp280_;
					while (TRUE) {
						ValaIterator* _tmp281_;
						ValaExpression* arg = NULL;
						ValaIterator* _tmp282_;
						gpointer _tmp283_;
						ValaExpression* _tmp284_;
						ValaArrayType* _tmp285_;
						ValaDataType* _tmp286_;
						ValaDataType* _tmp287_;
						ValaExpression* _tmp288_;
						ValaDataType* _tmp289_;
						ValaDataType* _tmp290_;
						ValaArrayType* _tmp291_;
						gboolean _tmp292_;
						gboolean _tmp293_;
						_tmp281_ = arg_it;
						if (!vala_iterator_next (_tmp281_)) {
							break;
						}
						_tmp282_ = arg_it;
						_tmp283_ = vala_iterator_get (_tmp282_);
						arg = (ValaExpression*) _tmp283_;
						_tmp284_ = arg;
						_tmp285_ = array_type;
						_tmp286_ = vala_array_type_get_element_type (_tmp285_);
						_tmp287_ = _tmp286_;
						vala_expression_set_target_type (_tmp284_, _tmp287_);
						_tmp288_ = arg;
						_tmp289_ = vala_expression_get_target_type (_tmp288_);
						_tmp290_ = _tmp289_;
						_tmp291_ = array_type;
						_tmp292_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp291_);
						_tmp293_ = _tmp292_;
						vala_data_type_set_value_owned (_tmp290_, _tmp293_);
						_vala_code_node_unref0 (arg);
					}
					_vala_code_node_unref0 (array_type);
					_vala_code_node_unref0 (param);
					break;
				}
				_tmp294_ = arg_it;
				if (vala_iterator_next (_tmp294_)) {
					ValaExpression* arg = NULL;
					ValaIterator* _tmp295_;
					gpointer _tmp296_;
					ValaExpression* _tmp297_;
					ValaParameter* _tmp298_;
					ValaDataType* _tmp299_;
					ValaDataType* _tmp300_;
					ValaExpression* _tmp301_;
					ValaExpression* _tmp302_;
					ValaDataType* _tmp303_;
					ValaDataType* _tmp304_;
					ValaDataType* _tmp305_;
					ValaDataType* _tmp306_;
					ValaDataType* _tmp307_;
					ValaDataType* _tmp308_;
					ValaExpression* _tmp309_;
					ValaExpression* _tmp310_;
					_tmp295_ = arg_it;
					_tmp296_ = vala_iterator_get (_tmp295_);
					arg = (ValaExpression*) _tmp296_;
					_tmp297_ = arg;
					_tmp298_ = param;
					_tmp299_ = vala_variable_get_variable_type ((ValaVariable*) _tmp298_);
					_tmp300_ = _tmp299_;
					vala_expression_set_formal_target_type (_tmp297_, _tmp300_);
					_tmp301_ = arg;
					_tmp302_ = arg;
					_tmp303_ = vala_expression_get_formal_target_type (_tmp302_);
					_tmp304_ = _tmp303_;
					_tmp305_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp306_ = _tmp305_;
					_tmp307_ = vala_data_type_get_actual_type (_tmp304_, _tmp306_, NULL, (ValaCodeNode*) self);
					_tmp308_ = _tmp307_;
					vala_expression_set_target_type (_tmp301_, _tmp308_);
					_vala_code_node_unref0 (_tmp308_);
					_tmp309_ = arg;
					_tmp310_ = _vala_code_node_ref0 (_tmp309_);
					_vala_code_node_unref0 (last_arg);
					last_arg = _tmp310_;
					_vala_code_node_unref0 (arg);
				}
				_vala_code_node_unref0 (param);
			}
		}
		_tmp311_ = m;
		_tmp312_ = vala_method_get_printf_format (_tmp311_);
		_tmp313_ = _tmp312_;
		if (_tmp313_) {
			ValaStringLiteral* format_literal = NULL;
			ValaExpression* _tmp314_;
			ValaStringLiteral* _tmp358_;
			format_literal = NULL;
			_tmp314_ = last_arg;
			if (VALA_IS_NULL_LITERAL (_tmp314_)) {
			} else {
				ValaExpression* _tmp315_;
				_tmp315_ = last_arg;
				if (_tmp315_ != NULL) {
					ValaExpression* _tmp316_;
					ValaStringLiteral* _tmp317_;
					gboolean _tmp318_ = FALSE;
					ValaStringLiteral* _tmp319_;
					_tmp316_ = last_arg;
					_tmp317_ = vala_string_literal_get_format_literal (_tmp316_);
					_vala_code_node_unref0 (format_literal);
					format_literal = _tmp317_;
					_tmp319_ = format_literal;
					if (_tmp319_ == NULL) {
						ValaList* _tmp320_;
						gint _tmp321_;
						gint _tmp322_;
						ValaMethod* _tmp323_;
						ValaList* _tmp324_;
						gint _tmp325_;
						gint _tmp326_;
						_tmp320_ = self->priv->argument_list;
						_tmp321_ = vala_collection_get_size ((ValaCollection*) _tmp320_);
						_tmp322_ = _tmp321_;
						_tmp323_ = m;
						_tmp324_ = vala_callable_get_parameters ((ValaCallable*) _tmp323_);
						_tmp325_ = vala_collection_get_size ((ValaCollection*) _tmp324_);
						_tmp326_ = _tmp325_;
						_tmp318_ = _tmp322_ == (_tmp326_ - 1);
					} else {
						_tmp318_ = FALSE;
					}
					if (_tmp318_) {
						ValaStringLiteral* _tmp327_;
						ValaStringLiteral* _tmp328_;
						ValaSemanticAnalyzer* _tmp329_;
						ValaSemanticAnalyzer* _tmp330_;
						ValaDataType* _tmp331_;
						ValaDataType* _tmp332_;
						ValaDataType* _tmp333_;
						ValaList* _tmp334_;
						ValaList* _tmp335_;
						gint _tmp336_;
						gint _tmp337_;
						ValaStringLiteral* _tmp338_;
						ValaList* _tmp339_;
						ValaIterator* _tmp340_;
						_tmp327_ = vala_string_literal_new ("\"%s\"", NULL);
						_vala_code_node_unref0 (format_literal);
						format_literal = _tmp327_;
						_tmp328_ = format_literal;
						_tmp329_ = vala_code_context_get_analyzer (context);
						_tmp330_ = _tmp329_;
						_tmp331_ = _tmp330_->string_type;
						_tmp332_ = vala_data_type_copy (_tmp331_);
						_tmp333_ = _tmp332_;
						vala_expression_set_target_type ((ValaExpression*) _tmp328_, _tmp333_);
						_vala_code_node_unref0 (_tmp333_);
						_tmp334_ = self->priv->argument_list;
						_tmp335_ = self->priv->argument_list;
						_tmp336_ = vala_collection_get_size ((ValaCollection*) _tmp335_);
						_tmp337_ = _tmp336_;
						_tmp338_ = format_literal;
						vala_list_insert (_tmp334_, _tmp337_ - 1, (ValaExpression*) _tmp338_);
						_tmp339_ = self->priv->argument_list;
						_tmp340_ = vala_iterable_iterator ((ValaIterable*) _tmp339_);
						_vala_iterator_unref0 (arg_it);
						arg_it = _tmp340_;
						{
							ValaList* _param_list = NULL;
							ValaMethod* _tmp341_;
							ValaList* _tmp342_;
							gint _param_size = 0;
							ValaList* _tmp343_;
							gint _tmp344_;
							gint _tmp345_;
							gint _param_index = 0;
							_tmp341_ = m;
							_tmp342_ = vala_callable_get_parameters ((ValaCallable*) _tmp341_);
							_param_list = _tmp342_;
							_tmp343_ = _param_list;
							_tmp344_ = vala_collection_get_size ((ValaCollection*) _tmp343_);
							_tmp345_ = _tmp344_;
							_param_size = _tmp345_;
							_param_index = -1;
							while (TRUE) {
								gint _tmp346_;
								gint _tmp347_;
								ValaParameter* param = NULL;
								ValaList* _tmp348_;
								gpointer _tmp349_;
								gboolean _tmp350_ = FALSE;
								ValaParameter* _tmp351_;
								gboolean _tmp352_;
								gboolean _tmp353_;
								ValaIterator* _tmp357_;
								_param_index = _param_index + 1;
								_tmp346_ = _param_index;
								_tmp347_ = _param_size;
								if (!(_tmp346_ < _tmp347_)) {
									break;
								}
								_tmp348_ = _param_list;
								_tmp349_ = vala_list_get (_tmp348_, _param_index);
								param = (ValaParameter*) _tmp349_;
								_tmp351_ = param;
								_tmp352_ = vala_parameter_get_ellipsis (_tmp351_);
								_tmp353_ = _tmp352_;
								if (_tmp353_) {
									_tmp350_ = TRUE;
								} else {
									ValaParameter* _tmp354_;
									gboolean _tmp355_;
									gboolean _tmp356_;
									_tmp354_ = param;
									_tmp355_ = vala_parameter_get_params_array (_tmp354_);
									_tmp356_ = _tmp355_;
									_tmp350_ = _tmp356_;
								}
								if (_tmp350_) {
									_vala_code_node_unref0 (param);
									break;
								}
								_tmp357_ = arg_it;
								vala_iterator_next (_tmp357_);
								_vala_code_node_unref0 (param);
							}
						}
					}
				}
			}
			_tmp358_ = format_literal;
			if (_tmp358_ != NULL) {
				gchar* format = NULL;
				ValaStringLiteral* _tmp359_;
				gchar* _tmp360_;
				ValaSemanticAnalyzer* _tmp361_;
				ValaSemanticAnalyzer* _tmp362_;
				const gchar* _tmp363_;
				ValaIterator* _tmp364_;
				ValaSourceReference* _tmp365_;
				ValaSourceReference* _tmp366_;
				_tmp359_ = format_literal;
				_tmp360_ = vala_string_literal_eval (_tmp359_);
				format = _tmp360_;
				_tmp361_ = vala_code_context_get_analyzer (context);
				_tmp362_ = _tmp361_;
				_tmp363_ = format;
				_tmp364_ = arg_it;
				_tmp365_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp366_ = _tmp365_;
				if (!vala_semantic_analyzer_check_print_format (_tmp362_, _tmp363_, _tmp364_, _tmp366_)) {
					result = FALSE;
					_g_free0 (format);
					_vala_code_node_unref0 (format_literal);
					_vala_iterator_unref0 (arg_it);
					_vala_code_node_unref0 (last_arg);
					_vala_code_node_unref0 (m);
					_vala_iterable_unref0 (type_args);
					_vala_code_node_unref0 (type_sym);
					_vala_code_node_unref0 (constructor_sym);
					_vala_code_node_unref0 (type);
					return result;
				}
				_g_free0 (format);
			}
			_vala_code_node_unref0 (format_literal);
		}
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp367_;
			gint _arg_size = 0;
			ValaList* _tmp368_;
			gint _tmp369_;
			gint _tmp370_;
			gint _arg_index = 0;
			_tmp367_ = self->priv->argument_list;
			_arg_list = _tmp367_;
			_tmp368_ = _arg_list;
			_tmp369_ = vala_collection_get_size ((ValaCollection*) _tmp368_);
			_tmp370_ = _tmp369_;
			_arg_size = _tmp370_;
			_arg_index = -1;
			while (TRUE) {
				gint _tmp371_;
				gint _tmp372_;
				ValaExpression* arg = NULL;
				ValaList* _tmp373_;
				gpointer _tmp374_;
				ValaExpression* _tmp375_;
				_arg_index = _arg_index + 1;
				_tmp371_ = _arg_index;
				_tmp372_ = _arg_size;
				if (!(_tmp371_ < _tmp372_)) {
					break;
				}
				_tmp373_ = _arg_list;
				_tmp374_ = vala_list_get (_tmp373_, _arg_index);
				arg = (ValaExpression*) _tmp374_;
				_tmp375_ = arg;
				vala_code_node_check ((ValaCodeNode*) _tmp375_, context);
				_vala_code_node_unref0 (arg);
			}
		}
		_tmp376_ = vala_code_context_get_analyzer (context);
		_tmp377_ = _tmp376_;
		_tmp378_ = m;
		_tmp379_ = vala_method_type_new (_tmp378_, NULL);
		_tmp380_ = _tmp379_;
		_tmp381_ = m;
		_tmp382_ = vala_callable_get_parameters ((ValaCallable*) _tmp381_);
		_tmp383_ = self->priv->argument_list;
		vala_semantic_analyzer_check_arguments (_tmp377_, (ValaExpression*) self, (ValaDataType*) _tmp380_, _tmp382_, _tmp383_);
		_vala_code_node_unref0 (_tmp380_);
		_vala_iterator_unref0 (arg_it);
		_vala_code_node_unref0 (last_arg);
		_vala_code_node_unref0 (m);
	} else {
		ValaDataType* _tmp384_;
		ValaDataType* _tmp385_;
		_tmp384_ = vala_object_creation_expression_get_type_reference (self);
		_tmp385_ = _tmp384_;
		if (VALA_IS_ERROR_TYPE (_tmp385_)) {
			ValaMemberAccess* _tmp386_;
			ValaMemberAccess* _tmp387_;
			ValaList* _tmp408_;
			gint _tmp409_;
			gint _tmp410_;
			_tmp386_ = vala_object_creation_expression_get_member_name (self);
			_tmp387_ = _tmp386_;
			if (_tmp387_ != NULL) {
				ValaMemberAccess* _tmp388_;
				ValaMemberAccess* _tmp389_;
				_tmp388_ = vala_object_creation_expression_get_member_name (self);
				_tmp389_ = _tmp388_;
				vala_code_node_check ((ValaCodeNode*) _tmp389_, context);
			}
			{
				ValaList* _arg_list = NULL;
				ValaList* _tmp390_;
				gint _arg_size = 0;
				ValaList* _tmp391_;
				gint _tmp392_;
				gint _tmp393_;
				gint _arg_index = 0;
				_tmp390_ = self->priv->argument_list;
				_arg_list = _tmp390_;
				_tmp391_ = _arg_list;
				_tmp392_ = vala_collection_get_size ((ValaCollection*) _tmp391_);
				_tmp393_ = _tmp392_;
				_arg_size = _tmp393_;
				_arg_index = -1;
				while (TRUE) {
					gint _tmp394_;
					gint _tmp395_;
					ValaExpression* arg = NULL;
					ValaList* _tmp396_;
					gpointer _tmp397_;
					ValaExpression* _tmp398_;
					_arg_index = _arg_index + 1;
					_tmp394_ = _arg_index;
					_tmp395_ = _arg_size;
					if (!(_tmp394_ < _tmp395_)) {
						break;
					}
					_tmp396_ = _arg_list;
					_tmp397_ = vala_list_get (_tmp396_, _arg_index);
					arg = (ValaExpression*) _tmp397_;
					_tmp398_ = arg;
					vala_code_node_check ((ValaCodeNode*) _tmp398_, context);
					_vala_code_node_unref0 (arg);
				}
			}
			{
				ValaList* _init_list = NULL;
				ValaList* _tmp399_;
				gint _init_size = 0;
				ValaList* _tmp400_;
				gint _tmp401_;
				gint _tmp402_;
				gint _init_index = 0;
				_tmp399_ = self->priv->object_initializer;
				_init_list = _tmp399_;
				_tmp400_ = _init_list;
				_tmp401_ = vala_collection_get_size ((ValaCollection*) _tmp400_);
				_tmp402_ = _tmp401_;
				_init_size = _tmp402_;
				_init_index = -1;
				while (TRUE) {
					gint _tmp403_;
					gint _tmp404_;
					ValaMemberInitializer* init = NULL;
					ValaList* _tmp405_;
					gpointer _tmp406_;
					ValaMemberInitializer* _tmp407_;
					_init_index = _init_index + 1;
					_tmp403_ = _init_index;
					_tmp404_ = _init_size;
					if (!(_tmp403_ < _tmp404_)) {
						break;
					}
					_tmp405_ = _init_list;
					_tmp406_ = vala_list_get (_tmp405_, _init_index);
					init = (ValaMemberInitializer*) _tmp406_;
					_tmp407_ = init;
					vala_code_node_check ((ValaCodeNode*) _tmp407_, context);
					_vala_code_node_unref0 (init);
				}
			}
			_tmp408_ = self->priv->argument_list;
			_tmp409_ = vala_collection_get_size ((ValaCollection*) _tmp408_);
			_tmp410_ = _tmp409_;
			if (_tmp410_ == 0) {
				ValaSourceReference* _tmp411_;
				ValaSourceReference* _tmp412_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp411_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp412_ = _tmp411_;
				vala_report_error (_tmp412_, "Too few arguments, errors need at least 1 argument");
			} else {
				ValaIterator* arg_it = NULL;
				ValaList* _tmp413_;
				ValaIterator* _tmp414_;
				ValaIterator* _tmp415_;
				ValaExpression* ex = NULL;
				ValaIterator* _tmp416_;
				gpointer _tmp417_;
				gboolean _tmp418_ = FALSE;
				ValaExpression* _tmp419_;
				ValaDataType* _tmp420_;
				ValaDataType* _tmp421_;
				ValaStringLiteral* format_literal = NULL;
				ValaExpression* _tmp430_;
				ValaStringLiteral* _tmp431_;
				ValaStringLiteral* _tmp432_;
				ValaList* _tmp441_;
				ValaIterator* _tmp442_;
				ValaIterator* _tmp443_;
				ValaSemanticAnalyzer* _tmp444_;
				ValaSemanticAnalyzer* _tmp445_;
				ValaIterator* _tmp446_;
				ValaSourceReference* _tmp447_;
				ValaSourceReference* _tmp448_;
				_tmp413_ = self->priv->argument_list;
				_tmp414_ = vala_iterable_iterator ((ValaIterable*) _tmp413_);
				arg_it = _tmp414_;
				_tmp415_ = arg_it;
				vala_iterator_next (_tmp415_);
				_tmp416_ = arg_it;
				_tmp417_ = vala_iterator_get (_tmp416_);
				ex = (ValaExpression*) _tmp417_;
				_tmp419_ = ex;
				_tmp420_ = vala_expression_get_value_type (_tmp419_);
				_tmp421_ = _tmp420_;
				if (_tmp421_ == NULL) {
					_tmp418_ = TRUE;
				} else {
					ValaExpression* _tmp422_;
					ValaDataType* _tmp423_;
					ValaDataType* _tmp424_;
					ValaSemanticAnalyzer* _tmp425_;
					ValaSemanticAnalyzer* _tmp426_;
					ValaDataType* _tmp427_;
					_tmp422_ = ex;
					_tmp423_ = vala_expression_get_value_type (_tmp422_);
					_tmp424_ = _tmp423_;
					_tmp425_ = vala_code_context_get_analyzer (context);
					_tmp426_ = _tmp425_;
					_tmp427_ = _tmp426_->string_type;
					_tmp418_ = !vala_data_type_compatible (_tmp424_, _tmp427_);
				}
				if (_tmp418_) {
					ValaSourceReference* _tmp428_;
					ValaSourceReference* _tmp429_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp428_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp429_ = _tmp428_;
					vala_report_error (_tmp429_, "Invalid type for argument 1");
				}
				_tmp430_ = ex;
				_tmp431_ = vala_string_literal_get_format_literal (_tmp430_);
				format_literal = _tmp431_;
				_tmp432_ = format_literal;
				if (_tmp432_ != NULL) {
					gchar* format = NULL;
					ValaStringLiteral* _tmp433_;
					gchar* _tmp434_;
					ValaSemanticAnalyzer* _tmp435_;
					ValaSemanticAnalyzer* _tmp436_;
					const gchar* _tmp437_;
					ValaIterator* _tmp438_;
					ValaSourceReference* _tmp439_;
					ValaSourceReference* _tmp440_;
					_tmp433_ = format_literal;
					_tmp434_ = vala_string_literal_eval (_tmp433_);
					format = _tmp434_;
					_tmp435_ = vala_code_context_get_analyzer (context);
					_tmp436_ = _tmp435_;
					_tmp437_ = format;
					_tmp438_ = arg_it;
					_tmp439_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp440_ = _tmp439_;
					if (!vala_semantic_analyzer_check_print_format (_tmp436_, _tmp437_, _tmp438_, _tmp440_)) {
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						result = FALSE;
						_g_free0 (format);
						_vala_code_node_unref0 (format_literal);
						_vala_code_node_unref0 (ex);
						_vala_iterator_unref0 (arg_it);
						_vala_iterable_unref0 (type_args);
						_vala_code_node_unref0 (type_sym);
						_vala_code_node_unref0 (constructor_sym);
						_vala_code_node_unref0 (type);
						return result;
					}
					_g_free0 (format);
				}
				_tmp441_ = self->priv->argument_list;
				_tmp442_ = vala_iterable_iterator ((ValaIterable*) _tmp441_);
				_vala_iterator_unref0 (arg_it);
				arg_it = _tmp442_;
				_tmp443_ = arg_it;
				vala_iterator_next (_tmp443_);
				_tmp444_ = vala_code_context_get_analyzer (context);
				_tmp445_ = _tmp444_;
				_tmp446_ = arg_it;
				_tmp447_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp448_ = _tmp447_;
				if (!vala_semantic_analyzer_check_variadic_arguments (_tmp445_, _tmp446_, 1, _tmp448_)) {
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					result = FALSE;
					_vala_code_node_unref0 (format_literal);
					_vala_code_node_unref0 (ex);
					_vala_iterator_unref0 (arg_it);
					_vala_iterable_unref0 (type_args);
					_vala_code_node_unref0 (type_sym);
					_vala_code_node_unref0 (constructor_sym);
					_vala_code_node_unref0 (type);
					return result;
				}
				_vala_code_node_unref0 (format_literal);
				_vala_code_node_unref0 (ex);
				_vala_iterator_unref0 (arg_it);
			}
		}
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp449_;
		gint _arg_size = 0;
		ValaList* _tmp450_;
		gint _tmp451_;
		gint _tmp452_;
		gint _arg_index = 0;
		_tmp449_ = self->priv->argument_list;
		_arg_list = _tmp449_;
		_tmp450_ = _arg_list;
		_tmp451_ = vala_collection_get_size ((ValaCollection*) _tmp450_);
		_tmp452_ = _tmp451_;
		_arg_size = _tmp452_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp453_;
			gint _tmp454_;
			ValaExpression* arg = NULL;
			ValaList* _tmp455_;
			gpointer _tmp456_;
			ValaSizeofExpression* sizeof_expr = NULL;
			ValaExpression* _tmp457_;
			gboolean _tmp458_ = FALSE;
			ValaSizeofExpression* _tmp459_;
			_arg_index = _arg_index + 1;
			_tmp453_ = _arg_index;
			_tmp454_ = _arg_size;
			if (!(_tmp453_ < _tmp454_)) {
				break;
			}
			_tmp455_ = _arg_list;
			_tmp456_ = vala_list_get (_tmp455_, _arg_index);
			arg = (ValaExpression*) _tmp456_;
			_tmp457_ = arg;
			sizeof_expr = VALA_IS_SIZEOF_EXPRESSION (_tmp457_) ? ((ValaSizeofExpression*) _tmp457_) : NULL;
			_tmp459_ = sizeof_expr;
			if (_tmp459_ != NULL) {
				ValaSizeofExpression* _tmp460_;
				ValaDataType* _tmp461_;
				ValaDataType* _tmp462_;
				_tmp460_ = sizeof_expr;
				_tmp461_ = vala_sizeof_expression_get_type_reference (_tmp460_);
				_tmp462_ = _tmp461_;
				_tmp458_ = VALA_IS_GENERIC_TYPE (_tmp462_);
			} else {
				_tmp458_ = FALSE;
			}
			if (_tmp458_) {
				ValaDataType* sizeof_type = NULL;
				ValaSizeofExpression* _tmp463_;
				ValaDataType* _tmp464_;
				ValaDataType* _tmp465_;
				ValaDataType* _tmp466_;
				ValaDataType* _tmp467_;
				ValaDataType* _tmp468_;
				ValaDataType* _tmp469_;
				ValaList* _tmp470_;
				ValaDataType* _tmp471_;
				ValaExpression* _tmp472_;
				ValaDataType* _tmp473_;
				ValaSourceReference* _tmp474_;
				ValaSourceReference* _tmp475_;
				ValaSizeofExpression* _tmp476_;
				ValaSizeofExpression* _tmp477_;
				_tmp463_ = sizeof_expr;
				_tmp464_ = vala_sizeof_expression_get_type_reference (_tmp463_);
				_tmp465_ = _tmp464_;
				_tmp466_ = vala_object_creation_expression_get_type_reference (self);
				_tmp467_ = _tmp466_;
				_tmp468_ = vala_object_creation_expression_get_type_reference (self);
				_tmp469_ = _tmp468_;
				_tmp470_ = vala_data_type_get_type_arguments (_tmp469_);
				_tmp471_ = vala_data_type_get_actual_type (_tmp465_, _tmp467_, _tmp470_, (ValaCodeNode*) self);
				sizeof_type = _tmp471_;
				_tmp472_ = arg;
				_tmp473_ = sizeof_type;
				_tmp474_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp475_ = _tmp474_;
				_tmp476_ = vala_sizeof_expression_new (_tmp473_, _tmp475_);
				_tmp477_ = _tmp476_;
				vala_code_node_replace_expression ((ValaCodeNode*) self, _tmp472_, (ValaExpression*) _tmp477_);
				_vala_code_node_unref0 (_tmp477_);
				_vala_code_node_unref0 (sizeof_type);
			}
			_vala_code_node_unref0 (arg);
		}
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp478_;
		gint _init_size = 0;
		ValaList* _tmp479_;
		gint _tmp480_;
		gint _tmp481_;
		gint _init_index = 0;
		_tmp478_ = vala_object_creation_expression_get_object_initializer (self);
		_init_list = _tmp478_;
		_tmp479_ = _init_list;
		_tmp480_ = vala_collection_get_size ((ValaCollection*) _tmp479_);
		_tmp481_ = _tmp480_;
		_init_size = _tmp481_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp482_;
			gint _tmp483_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp484_;
			gpointer _tmp485_;
			ValaMemberInitializer* _tmp486_;
			ValaExpression* _tmp487_;
			ValaExpression* _tmp488_;
			gint index = 0;
			ValaList* _tmp489_;
			ValaMemberInitializer* _tmp490_;
			ValaList* _tmp491_;
			gpointer _tmp492_;
			ValaMemberInitializer* _tmp493_;
			ValaMemberInitializer* inner_mi = NULL;
			ValaMemberInitializer* _tmp494_;
			ValaExpression* _tmp495_;
			ValaExpression* _tmp496_;
			ValaLocalVariable* local = NULL;
			gchar* _tmp503_;
			gchar* _tmp504_;
			ValaMemberInitializer* _tmp505_;
			ValaExpression* _tmp506_;
			ValaExpression* _tmp507_;
			ValaMemberInitializer* _tmp508_;
			ValaExpression* _tmp509_;
			ValaExpression* _tmp510_;
			ValaSourceReference* _tmp511_;
			ValaSourceReference* _tmp512_;
			ValaLocalVariable* _tmp513_;
			ValaLocalVariable* _tmp514_;
			ValaDeclarationStatement* decl = NULL;
			ValaLocalVariable* _tmp515_;
			ValaMemberInitializer* _tmp516_;
			ValaExpression* _tmp517_;
			ValaExpression* _tmp518_;
			ValaSourceReference* _tmp519_;
			ValaSourceReference* _tmp520_;
			ValaDeclarationStatement* _tmp521_;
			ValaDeclarationStatement* _tmp522_;
			ValaSemanticAnalyzer* _tmp523_;
			ValaSemanticAnalyzer* _tmp524_;
			ValaBlock* _tmp525_;
			ValaDeclarationStatement* _tmp526_;
			_init_index = _init_index + 1;
			_tmp482_ = _init_index;
			_tmp483_ = _init_size;
			if (!(_tmp482_ < _tmp483_)) {
				break;
			}
			_tmp484_ = _init_list;
			_tmp485_ = vala_list_get (_tmp484_, _init_index);
			init = (ValaMemberInitializer*) _tmp485_;
			_tmp486_ = init;
			_tmp487_ = vala_member_initializer_get_initializer (_tmp486_);
			_tmp488_ = _tmp487_;
			if (!VALA_IS_MEMBER_INITIALIZER (_tmp488_)) {
				_vala_code_node_unref0 (init);
				continue;
			}
			_tmp489_ = self->priv->object_initializer;
			_tmp490_ = init;
			index = vala_list_index_of (_tmp489_, _tmp490_);
			_tmp491_ = self->priv->object_initializer;
			_tmp492_ = vala_list_remove_at (_tmp491_, index);
			_tmp493_ = (ValaMemberInitializer*) _tmp492_;
			_vala_code_node_unref0 (_tmp493_);
			_vala_assert (index >= 0, "index >= 0");
			_tmp494_ = init;
			_tmp495_ = vala_member_initializer_get_initializer (_tmp494_);
			_tmp496_ = _tmp495_;
			inner_mi = G_TYPE_CHECK_INSTANCE_CAST (_tmp496_, VALA_TYPE_MEMBER_INITIALIZER, ValaMemberInitializer);
			while (TRUE) {
				ValaMemberInitializer* _tmp497_;
				ValaExpression* _tmp498_;
				ValaExpression* _tmp499_;
				ValaMemberInitializer* _tmp500_;
				ValaExpression* _tmp501_;
				ValaExpression* _tmp502_;
				_tmp497_ = inner_mi;
				_tmp498_ = vala_member_initializer_get_initializer (_tmp497_);
				_tmp499_ = _tmp498_;
				if (!VALA_IS_MEMBER_INITIALIZER (_tmp499_)) {
					break;
				}
				_tmp500_ = inner_mi;
				_tmp501_ = vala_member_initializer_get_initializer (_tmp500_);
				_tmp502_ = _tmp501_;
				inner_mi = G_TYPE_CHECK_INSTANCE_CAST (_tmp502_, VALA_TYPE_MEMBER_INITIALIZER, ValaMemberInitializer);
			}
			_tmp503_ = vala_code_node_get_temp_name ();
			_tmp504_ = _tmp503_;
			_tmp505_ = inner_mi;
			_tmp506_ = vala_member_initializer_get_initializer (_tmp505_);
			_tmp507_ = _tmp506_;
			_tmp508_ = inner_mi;
			_tmp509_ = vala_member_initializer_get_initializer (_tmp508_);
			_tmp510_ = _tmp509_;
			_tmp511_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp510_);
			_tmp512_ = _tmp511_;
			_tmp513_ = vala_local_variable_new (NULL, _tmp504_, _tmp507_, _tmp512_);
			_tmp514_ = _tmp513_;
			_g_free0 (_tmp504_);
			local = _tmp514_;
			_tmp515_ = local;
			_tmp516_ = inner_mi;
			_tmp517_ = vala_member_initializer_get_initializer (_tmp516_);
			_tmp518_ = _tmp517_;
			_tmp519_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp518_);
			_tmp520_ = _tmp519_;
			_tmp521_ = vala_declaration_statement_new ((ValaSymbol*) _tmp515_, _tmp520_);
			decl = _tmp521_;
			_tmp522_ = decl;
			vala_code_node_check ((ValaCodeNode*) _tmp522_, context);
			_tmp523_ = vala_code_context_get_analyzer (context);
			_tmp524_ = _tmp523_;
			_tmp525_ = _tmp524_->insert_block;
			_tmp526_ = decl;
			vala_expression_insert_statement ((ValaExpression*) self, _tmp525_, (ValaStatement*) _tmp526_);
			{
				gboolean _tmp527_ = FALSE;
				_tmp527_ = TRUE;
				while (TRUE) {
					ValaMemberInitializer* member_init = NULL;
					ValaMemberInitializer* _tmp529_;
					const gchar* _tmp530_;
					const gchar* _tmp531_;
					ValaLocalVariable* _tmp532_;
					const gchar* _tmp533_;
					const gchar* _tmp534_;
					ValaMemberInitializer* _tmp535_;
					ValaSourceReference* _tmp536_;
					ValaSourceReference* _tmp537_;
					ValaMemberAccess* _tmp538_;
					ValaMemberAccess* _tmp539_;
					ValaMemberInitializer* _tmp540_;
					ValaSourceReference* _tmp541_;
					ValaSourceReference* _tmp542_;
					ValaMemberInitializer* _tmp543_;
					ValaMemberInitializer* _tmp544_;
					ValaList* _tmp545_;
					gint _tmp546_;
					ValaMemberInitializer* _tmp547_;
					ValaMemberInitializer* _tmp548_;
					ValaCodeNode* _tmp549_;
					ValaCodeNode* _tmp550_;
					if (!_tmp527_) {
						ValaMemberInitializer* _tmp528_;
						_tmp528_ = inner_mi;
						if (!(_tmp528_ != NULL)) {
							break;
						}
					}
					_tmp527_ = FALSE;
					_tmp529_ = inner_mi;
					_tmp530_ = vala_member_initializer_get_name (_tmp529_);
					_tmp531_ = _tmp530_;
					_tmp532_ = local;
					_tmp533_ = vala_symbol_get_name ((ValaSymbol*) _tmp532_);
					_tmp534_ = _tmp533_;
					_tmp535_ = inner_mi;
					_tmp536_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp535_);
					_tmp537_ = _tmp536_;
					_tmp538_ = vala_member_access_new (NULL, _tmp534_, _tmp537_);
					_tmp539_ = _tmp538_;
					_tmp540_ = inner_mi;
					_tmp541_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp540_);
					_tmp542_ = _tmp541_;
					_tmp543_ = vala_member_initializer_new (_tmp531_, (ValaExpression*) _tmp539_, _tmp542_);
					_tmp544_ = _tmp543_;
					_vala_code_node_unref0 (_tmp539_);
					member_init = _tmp544_;
					_tmp545_ = self->priv->object_initializer;
					_tmp546_ = index;
					index = _tmp546_ + 1;
					_tmp547_ = member_init;
					vala_list_insert (_tmp545_, _tmp546_, _tmp547_);
					_tmp548_ = inner_mi;
					_tmp549_ = vala_code_node_get_parent_node ((ValaCodeNode*) _tmp548_);
					_tmp550_ = _tmp549_;
					inner_mi = VALA_IS_MEMBER_INITIALIZER (_tmp550_) ? ((ValaMemberInitializer*) _tmp550_) : NULL;
					_vala_code_node_unref0 (member_init);
				}
			}
			_vala_code_node_unref0 (decl);
			_vala_code_node_unref0 (local);
			_vala_code_node_unref0 (init);
		}
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp551_;
		gint _init_size = 0;
		ValaList* _tmp552_;
		gint _tmp553_;
		gint _tmp554_;
		gint _init_index = 0;
		_tmp551_ = vala_object_creation_expression_get_object_initializer (self);
		_init_list = _tmp551_;
		_tmp552_ = _init_list;
		_tmp553_ = vala_collection_get_size ((ValaCollection*) _tmp552_);
		_tmp554_ = _tmp553_;
		_init_size = _tmp554_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp555_;
			gint _tmp556_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp557_;
			gpointer _tmp558_;
			ValaMemberInitializer* _tmp559_;
			ValaMemberInitializer* _tmp560_;
			_init_index = _init_index + 1;
			_tmp555_ = _init_index;
			_tmp556_ = _init_size;
			if (!(_tmp555_ < _tmp556_)) {
				break;
			}
			_tmp557_ = _init_list;
			_tmp558_ = vala_list_get (_tmp557_, _init_index);
			init = (ValaMemberInitializer*) _tmp558_;
			_tmp559_ = init;
			vala_code_node_set_parent_node ((ValaCodeNode*) _tmp559_, (ValaCodeNode*) self);
			_tmp560_ = init;
			vala_code_node_check ((ValaCodeNode*) _tmp560_, context);
			_vala_code_node_unref0 (init);
		}
	}
	_tmp561_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
	_tmp562_ = _tmp561_;
	if (_tmp562_) {
		gboolean _tmp563_ = FALSE;
		ValaCodeNode* _tmp564_;
		ValaCodeNode* _tmp565_;
		_tmp564_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp565_ = _tmp564_;
		if (VALA_IS_LOCAL_VARIABLE (_tmp565_)) {
			_tmp563_ = TRUE;
		} else {
			ValaCodeNode* _tmp566_;
			ValaCodeNode* _tmp567_;
			_tmp566_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp567_ = _tmp566_;
			_tmp563_ = VALA_IS_EXPRESSION_STATEMENT (_tmp567_);
		}
		if (_tmp563_) {
		} else {
			ValaSemanticAnalyzer* _tmp568_;
			ValaSemanticAnalyzer* _tmp569_;
			ValaSymbol* _tmp570_;
			ValaSymbol* _tmp571_;
			_tmp568_ = vala_code_context_get_analyzer (context);
			_tmp569_ = _tmp568_;
			_tmp570_ = vala_semantic_analyzer_get_current_symbol (_tmp569_);
			_tmp571_ = _tmp570_;
			if (!VALA_IS_BLOCK (_tmp571_)) {
				ValaSourceReference* _tmp572_;
				ValaSourceReference* _tmp573_;
				_tmp572_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp573_ = _tmp572_;
				vala_report_error (_tmp573_, "Field initializers must not throw errors");
			} else {
				ValaCodeNode* old_parent_node = NULL;
				ValaCodeNode* _tmp574_;
				ValaCodeNode* _tmp575_;
				ValaCodeNode* _tmp576_;
				ValaLocalVariable* local = NULL;
				ValaDataType* _tmp577_;
				ValaDataType* _tmp578_;
				ValaDataType* _tmp579_;
				ValaDataType* _tmp580_;
				gchar* _tmp581_;
				gchar* _tmp582_;
				ValaSourceReference* _tmp583_;
				ValaSourceReference* _tmp584_;
				ValaLocalVariable* _tmp585_;
				ValaLocalVariable* _tmp586_;
				ValaDeclarationStatement* decl = NULL;
				ValaLocalVariable* _tmp587_;
				ValaSourceReference* _tmp588_;
				ValaSourceReference* _tmp589_;
				ValaDeclarationStatement* _tmp590_;
				ValaSemanticAnalyzer* _tmp591_;
				ValaSemanticAnalyzer* _tmp592_;
				ValaBlock* _tmp593_;
				ValaDeclarationStatement* _tmp594_;
				ValaExpression* temp_access = NULL;
				ValaLocalVariable* _tmp595_;
				ValaDataType* _tmp596_;
				ValaDataType* _tmp597_;
				ValaExpression* _tmp598_;
				ValaExpression* _tmp599_;
				ValaDataType* _tmp600_;
				ValaDataType* _tmp601_;
				ValaLocalVariable* _tmp602_;
				ValaDeclarationStatement* _tmp603_;
				ValaBlock* block = NULL;
				ValaSemanticAnalyzer* _tmp604_;
				ValaSemanticAnalyzer* _tmp605_;
				ValaSymbol* _tmp606_;
				ValaSymbol* _tmp607_;
				ValaBlock* _tmp608_;
				ValaBlock* _tmp609_;
				ValaLocalVariable* _tmp610_;
				ValaSemanticAnalyzer* _tmp611_;
				ValaSemanticAnalyzer* _tmp612_;
				ValaBlock* _tmp613_;
				ValaLocalVariable* _tmp614_;
				ValaCodeNode* _tmp615_;
				ValaExpression* _tmp616_;
				ValaExpression* _tmp617_;
				_tmp574_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp575_ = _tmp574_;
				_tmp576_ = _vala_code_node_ref0 (_tmp575_);
				old_parent_node = _tmp576_;
				_tmp577_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp578_ = _tmp577_;
				_tmp579_ = vala_data_type_copy (_tmp578_);
				_tmp580_ = _tmp579_;
				_tmp581_ = vala_code_node_get_temp_name ();
				_tmp582_ = _tmp581_;
				_tmp583_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp584_ = _tmp583_;
				_tmp585_ = vala_local_variable_new (_tmp580_, _tmp582_, NULL, _tmp584_);
				_tmp586_ = _tmp585_;
				_g_free0 (_tmp582_);
				_vala_code_node_unref0 (_tmp580_);
				local = _tmp586_;
				_tmp587_ = local;
				_tmp588_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp589_ = _tmp588_;
				_tmp590_ = vala_declaration_statement_new ((ValaSymbol*) _tmp587_, _tmp589_);
				decl = _tmp590_;
				_tmp591_ = vala_code_context_get_analyzer (context);
				_tmp592_ = _tmp591_;
				_tmp593_ = _tmp592_->insert_block;
				_tmp594_ = decl;
				vala_expression_insert_statement ((ValaExpression*) self, _tmp593_, (ValaStatement*) _tmp594_);
				_tmp595_ = local;
				_tmp596_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp597_ = _tmp596_;
				_tmp598_ = vala_semantic_analyzer_create_temp_access (_tmp595_, _tmp597_);
				temp_access = _tmp598_;
				_tmp599_ = temp_access;
				_tmp600_ = vala_expression_get_formal_target_type ((ValaExpression*) self);
				_tmp601_ = _tmp600_;
				vala_expression_set_formal_target_type (_tmp599_, _tmp601_);
				_tmp602_ = local;
				vala_variable_set_initializer ((ValaVariable*) _tmp602_, (ValaExpression*) self);
				_tmp603_ = decl;
				vala_code_node_check ((ValaCodeNode*) _tmp603_, context);
				_tmp604_ = vala_code_context_get_analyzer (context);
				_tmp605_ = _tmp604_;
				_tmp606_ = vala_semantic_analyzer_get_current_symbol (_tmp605_);
				_tmp607_ = _tmp606_;
				_tmp608_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp607_, VALA_TYPE_BLOCK, ValaBlock));
				block = _tmp608_;
				_tmp609_ = block;
				_tmp610_ = local;
				vala_block_remove_local_variable (_tmp609_, _tmp610_);
				_tmp611_ = vala_code_context_get_analyzer (context);
				_tmp612_ = _tmp611_;
				_tmp613_ = _tmp612_->insert_block;
				_tmp614_ = local;
				vala_block_add_local_variable (_tmp613_, _tmp614_);
				_tmp615_ = old_parent_node;
				_tmp616_ = temp_access;
				vala_code_node_replace_expression (_tmp615_, (ValaExpression*) self, _tmp616_);
				_tmp617_ = temp_access;
				vala_code_node_check ((ValaCodeNode*) _tmp617_, context);
				_vala_code_node_unref0 (block);
				_vala_code_node_unref0 (temp_access);
				_vala_code_node_unref0 (decl);
				_vala_code_node_unref0 (local);
				_vala_code_node_unref0 (old_parent_node);
			}
		}
	}
	_tmp618_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp619_ = _tmp618_;
	result = !_tmp619_;
	_vala_iterable_unref0 (type_args);
	_vala_code_node_unref0 (type_sym);
	_vala_code_node_unref0 (constructor_sym);
	_vala_code_node_unref0 (type);
	return result;
}

static void
vala_object_creation_expression_real_get_error_types (ValaCodeNode* base,
                                                      ValaCollection* collection,
                                                      ValaSourceReference* source_reference)
{
	ValaObjectCreationExpression * self;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	if (VALA_IS_METHOD (_tmp1_)) {
		ValaMethod* m = NULL;
		ValaSymbol* _tmp4_;
		ValaSymbol* _tmp5_;
		ValaMethod* _tmp6_;
		ValaMethod* _tmp7_;
		if (source_reference == NULL) {
			ValaSourceReference* _tmp2_;
			ValaSourceReference* _tmp3_;
			_tmp2_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp3_ = _tmp2_;
			source_reference = _tmp3_;
		}
		_tmp4_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp5_ = _tmp4_;
		_tmp6_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, VALA_TYPE_METHOD, ValaMethod));
		m = _tmp6_;
		_tmp7_ = m;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp7_, collection, source_reference);
		_vala_code_node_unref0 (m);
	}
}

static void
vala_object_creation_expression_real_emit (ValaCodeNode* base,
                                           ValaCodeGenerator* codegen)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (codegen != NULL);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		gint _arg_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_arg_list = _tmp0_;
		_tmp1_ = _arg_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_arg_size = _tmp3_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaExpression* arg = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaExpression* _tmp8_;
			_arg_index = _arg_index + 1;
			_tmp4_ = _arg_index;
			_tmp5_ = _arg_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _arg_list;
			_tmp7_ = vala_list_get (_tmp6_, _arg_index);
			arg = (ValaExpression*) _tmp7_;
			_tmp8_ = arg;
			vala_code_node_emit ((ValaCodeNode*) _tmp8_, codegen);
			_vala_code_node_unref0 (arg);
		}
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp9_;
		gint _init_size = 0;
		ValaList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _init_index = 0;
		_tmp9_ = self->priv->object_initializer;
		_init_list = _tmp9_;
		_tmp10_ = _init_list;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_init_size = _tmp12_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp13_;
			gint _tmp14_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp15_;
			gpointer _tmp16_;
			ValaMemberInitializer* _tmp17_;
			_init_index = _init_index + 1;
			_tmp13_ = _init_index;
			_tmp14_ = _init_size;
			if (!(_tmp13_ < _tmp14_)) {
				break;
			}
			_tmp15_ = _init_list;
			_tmp16_ = vala_list_get (_tmp15_, _init_index);
			init = (ValaMemberInitializer*) _tmp16_;
			_tmp17_ = init;
			vala_code_node_emit ((ValaCodeNode*) _tmp17_, codegen);
			_vala_code_node_unref0 (init);
		}
	}
	vala_code_visitor_visit_object_creation_expression ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_object_creation_expression_real_get_defined_variables (ValaCodeNode* base,
                                                            ValaCollection* collection)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (collection != NULL);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		gint _arg_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_arg_list = _tmp0_;
		_tmp1_ = _arg_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_arg_size = _tmp3_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaExpression* arg = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaExpression* _tmp8_;
			_arg_index = _arg_index + 1;
			_tmp4_ = _arg_index;
			_tmp5_ = _arg_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _arg_list;
			_tmp7_ = vala_list_get (_tmp6_, _arg_index);
			arg = (ValaExpression*) _tmp7_;
			_tmp8_ = arg;
			vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp8_, collection);
			_vala_code_node_unref0 (arg);
		}
	}
}

static void
vala_object_creation_expression_real_get_used_variables (ValaCodeNode* base,
                                                         ValaCollection* collection)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (collection != NULL);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		gint _arg_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_arg_list = _tmp0_;
		_tmp1_ = _arg_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_arg_size = _tmp3_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaExpression* arg = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaExpression* _tmp8_;
			_arg_index = _arg_index + 1;
			_tmp4_ = _arg_index;
			_tmp5_ = _arg_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _arg_list;
			_tmp7_ = vala_list_get (_tmp6_, _arg_index);
			arg = (ValaExpression*) _tmp7_;
			_tmp8_ = arg;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp8_, collection);
			_vala_code_node_unref0 (arg);
		}
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp9_;
		gint _init_size = 0;
		ValaList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _init_index = 0;
		_tmp9_ = self->priv->object_initializer;
		_init_list = _tmp9_;
		_tmp10_ = _init_list;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_init_size = _tmp12_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp13_;
			gint _tmp14_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp15_;
			gpointer _tmp16_;
			ValaMemberInitializer* _tmp17_;
			_init_index = _init_index + 1;
			_tmp13_ = _init_index;
			_tmp14_ = _init_size;
			if (!(_tmp13_ < _tmp14_)) {
				break;
			}
			_tmp15_ = _init_list;
			_tmp16_ = vala_list_get (_tmp15_, _init_index);
			init = (ValaMemberInitializer*) _tmp16_;
			_tmp17_ = init;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp17_, collection);
			_vala_code_node_unref0 (init);
		}
	}
}

static gchar*
vala_object_creation_expression_real_to_string (ValaCodeNode* base)
{
	ValaObjectCreationExpression * self;
	GString* b = NULL;
	GString* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp4_;
	ValaMemberAccess* _tmp6_;
	ValaMemberAccess* _tmp7_;
	GString* _tmp13_;
	gboolean first = FALSE;
	GString* _tmp27_;
	GString* _tmp28_;
	const gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* result;
	self = (ValaObjectCreationExpression*) base;
	_tmp0_ = g_string_new ("");
	b = _tmp0_;
	_tmp1_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GString* _tmp3_;
		_tmp3_ = b;
		g_string_append (_tmp3_, "yield ");
	}
	_tmp4_ = self->priv->_struct_creation;
	if (!_tmp4_) {
		GString* _tmp5_;
		_tmp5_ = b;
		g_string_append (_tmp5_, "new ");
	}
	_tmp6_ = vala_object_creation_expression_get_member_name (self);
	_tmp7_ = _tmp6_;
	if (_tmp7_ != NULL) {
		GString* _tmp8_;
		ValaMemberAccess* _tmp9_;
		ValaMemberAccess* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp8_ = b;
		_tmp9_ = vala_object_creation_expression_get_member_name (self);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_code_node_to_string ((ValaCodeNode*) _tmp10_);
		_tmp12_ = _tmp11_;
		g_string_append (_tmp8_, _tmp12_);
		_g_free0 (_tmp12_);
	}
	_tmp13_ = b;
	g_string_append_c (_tmp13_, '(');
	first = TRUE;
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp14_;
		gint _expr_size = 0;
		ValaList* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gint _expr_index = 0;
		_tmp14_ = self->priv->argument_list;
		_expr_list = _tmp14_;
		_tmp15_ = _expr_list;
		_tmp16_ = vala_collection_get_size ((ValaCollection*) _tmp15_);
		_tmp17_ = _tmp16_;
		_expr_size = _tmp17_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp18_;
			gint _tmp19_;
			ValaExpression* expr = NULL;
			ValaList* _tmp20_;
			gpointer _tmp21_;
			GString* _tmp23_;
			ValaExpression* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			_expr_index = _expr_index + 1;
			_tmp18_ = _expr_index;
			_tmp19_ = _expr_size;
			if (!(_tmp18_ < _tmp19_)) {
				break;
			}
			_tmp20_ = _expr_list;
			_tmp21_ = vala_list_get (_tmp20_, _expr_index);
			expr = (ValaExpression*) _tmp21_;
			if (!first) {
				GString* _tmp22_;
				_tmp22_ = b;
				g_string_append (_tmp22_, ", ");
			}
			_tmp23_ = b;
			_tmp24_ = expr;
			_tmp25_ = vala_code_node_to_string ((ValaCodeNode*) _tmp24_);
			_tmp26_ = _tmp25_;
			g_string_append (_tmp23_, _tmp26_);
			_g_free0 (_tmp26_);
			first = FALSE;
			_vala_code_node_unref0 (expr);
		}
	}
	_tmp27_ = b;
	g_string_append_c (_tmp27_, ')');
	_tmp28_ = b;
	_tmp29_ = _tmp28_->str;
	_tmp30_ = g_strdup (_tmp29_);
	result = _tmp30_;
	_g_string_free0 (b);
	return result;
}

static void
vala_object_creation_expression_class_init (ValaObjectCreationExpressionClass * klass,
                                            gpointer klass_data)
{
	vala_object_creation_expression_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_object_creation_expression_finalize;
	g_type_class_adjust_private_offset (klass, &ValaObjectCreationExpression_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_object_creation_expression_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_object_creation_expression_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_object_creation_expression_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_object_creation_expression_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_object_creation_expression_real_is_accessible;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_object_creation_expression_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_object_creation_expression_real_check;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_object_creation_expression_real_get_error_types;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_object_creation_expression_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_object_creation_expression_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_object_creation_expression_real_get_used_variables;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_object_creation_expression_real_to_string;
}

static void
vala_object_creation_expression_vala_callable_expression_interface_init (ValaCallableExpressionIface * iface,
                                                                         gpointer iface_data)
{
	vala_object_creation_expression_vala_callable_expression_parent_iface = g_type_interface_peek_parent (iface);
	iface->add_argument = (void (*) (ValaCallableExpression*, ValaExpression*)) vala_object_creation_expression_real_add_argument;
	iface->get_argument_list = (ValaList* (*) (ValaCallableExpression*)) vala_object_creation_expression_real_get_argument_list;
	iface->get_call = vala_object_creation_expression_real_get_call;
	iface->get_is_yield_expression = vala_object_creation_expression_real_get_is_yield_expression;
	iface->set_is_yield_expression = vala_object_creation_expression_real_set_is_yield_expression;
	iface->get_is_chainup = vala_object_creation_expression_real_get_is_chainup;
	iface->set_is_chainup = vala_object_creation_expression_real_set_is_chainup;
}

static void
vala_object_creation_expression_instance_init (ValaObjectCreationExpression * self,
                                               gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	self->priv = vala_object_creation_expression_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->argument_list = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_MEMBER_INITIALIZER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
	self->priv->object_initializer = (ValaList*) _tmp3_;
}

static void
vala_object_creation_expression_finalize (ValaCodeNode * obj)
{
	ValaObjectCreationExpression * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_OBJECT_CREATION_EXPRESSION, ValaObjectCreationExpression);
	_vala_iterable_unref0 (self->priv->argument_list);
	_vala_iterable_unref0 (self->priv->object_initializer);
	_vala_code_node_unref0 (self->priv->_data_type);
	_vala_code_node_unref0 (self->priv->_member_name);
	VALA_CODE_NODE_CLASS (vala_object_creation_expression_parent_class)->finalize (obj);
}

/**
 * Represents an object creation expression in the source code.
 */
static GType
vala_object_creation_expression_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaObjectCreationExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_object_creation_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaObjectCreationExpression), 0, (GInstanceInitFunc) vala_object_creation_expression_instance_init, NULL };
	static const GInterfaceInfo vala_callable_expression_info = { (GInterfaceInitFunc) vala_object_creation_expression_vala_callable_expression_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType vala_object_creation_expression_type_id;
	vala_object_creation_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaObjectCreationExpression", &g_define_type_info, 0);
	g_type_add_interface_static (vala_object_creation_expression_type_id, VALA_TYPE_CALLABLE_EXPRESSION, &vala_callable_expression_info);
	ValaObjectCreationExpression_private_offset = g_type_add_instance_private (vala_object_creation_expression_type_id, sizeof (ValaObjectCreationExpressionPrivate));
	return vala_object_creation_expression_type_id;
}

GType
vala_object_creation_expression_get_type (void)
{
	static volatile gsize vala_object_creation_expression_type_id__once = 0;
	if (g_once_init_enter (&vala_object_creation_expression_type_id__once)) {
		GType vala_object_creation_expression_type_id;
		vala_object_creation_expression_type_id = vala_object_creation_expression_get_type_once ();
		g_once_init_leave (&vala_object_creation_expression_type_id__once, vala_object_creation_expression_type_id);
	}
	return vala_object_creation_expression_type_id__once;
}

