// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{TextChildAnchor, TextIter, TextMark, TextTag, TextTagTable};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::{boxed::Box as Box_, fmt, mem::transmute};

glib::wrapper! {
    #[doc(alias = "GtkTextBuffer")]
    pub struct TextBuffer(Object<ffi::GtkTextBuffer, ffi::GtkTextBufferClass>);

    match fn {
        type_ => || ffi::gtk_text_buffer_get_type(),
    }
}

impl TextBuffer {
    pub const NONE: Option<&'static TextBuffer> = None;

    #[doc(alias = "gtk_text_buffer_new")]
    pub fn new(table: Option<&TextTagTable>) -> TextBuffer {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::gtk_text_buffer_new(table.to_glib_none().0)) }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`TextBuffer`] objects.
    ///
    /// This method returns an instance of [`TextBufferBuilder`](crate::builders::TextBufferBuilder) which can be used to create [`TextBuffer`] objects.
    pub fn builder() -> TextBufferBuilder {
        TextBufferBuilder::new()
    }
}

impl Default for TextBuffer {
    fn default() -> Self {
        glib::object::Object::new::<Self>()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`TextBuffer`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct TextBufferBuilder {
    builder: glib::object::ObjectBuilder<'static, TextBuffer>,
}

impl TextBufferBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn enable_undo(self, enable_undo: bool) -> Self {
        Self {
            builder: self.builder.property("enable-undo", enable_undo),
        }
    }

    pub fn tag_table(self, tag_table: &TextTagTable) -> Self {
        Self {
            builder: self.builder.property("tag-table", tag_table.clone()),
        }
    }

    pub fn text(self, text: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("text", text.into()),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`TextBuffer`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> TextBuffer {
        self.builder.build()
    }
}

pub trait TextBufferExt: 'static {
    #[doc(alias = "gtk_text_buffer_add_mark")]
    fn add_mark(&self, mark: &impl IsA<TextMark>, where_: &TextIter);

    #[doc(alias = "gtk_text_buffer_add_selection_clipboard")]
    fn add_selection_clipboard(&self, clipboard: &gdk::Clipboard);

    #[doc(alias = "gtk_text_buffer_apply_tag")]
    fn apply_tag(&self, tag: &impl IsA<TextTag>, start: &TextIter, end: &TextIter);

    #[doc(alias = "gtk_text_buffer_apply_tag_by_name")]
    fn apply_tag_by_name(&self, name: &str, start: &TextIter, end: &TextIter);

    #[doc(alias = "gtk_text_buffer_backspace")]
    fn backspace(&self, iter: &mut TextIter, interactive: bool, default_editable: bool) -> bool;

    #[doc(alias = "gtk_text_buffer_begin_irreversible_action")]
    fn begin_irreversible_action(&self);

    #[doc(alias = "gtk_text_buffer_begin_user_action")]
    fn begin_user_action(&self);

    #[doc(alias = "gtk_text_buffer_copy_clipboard")]
    fn copy_clipboard(&self, clipboard: &gdk::Clipboard);

    #[doc(alias = "gtk_text_buffer_create_child_anchor")]
    fn create_child_anchor(&self, iter: &mut TextIter) -> TextChildAnchor;

    #[doc(alias = "gtk_text_buffer_create_mark")]
    fn create_mark(
        &self,
        mark_name: Option<&str>,
        where_: &TextIter,
        left_gravity: bool,
    ) -> TextMark;

    #[doc(alias = "gtk_text_buffer_cut_clipboard")]
    fn cut_clipboard(&self, clipboard: &gdk::Clipboard, default_editable: bool);

    #[doc(alias = "gtk_text_buffer_delete")]
    fn delete(&self, start: &mut TextIter, end: &mut TextIter);

    #[doc(alias = "gtk_text_buffer_delete_interactive")]
    fn delete_interactive(
        &self,
        start_iter: &mut TextIter,
        end_iter: &mut TextIter,
        default_editable: bool,
    ) -> bool;

    #[doc(alias = "gtk_text_buffer_delete_mark")]
    fn delete_mark(&self, mark: &impl IsA<TextMark>);

    #[doc(alias = "gtk_text_buffer_delete_mark_by_name")]
    fn delete_mark_by_name(&self, name: &str);

    #[doc(alias = "gtk_text_buffer_delete_selection")]
    fn delete_selection(&self, interactive: bool, default_editable: bool) -> bool;

    #[doc(alias = "gtk_text_buffer_end_irreversible_action")]
    fn end_irreversible_action(&self);

    #[doc(alias = "gtk_text_buffer_end_user_action")]
    fn end_user_action(&self);

    #[doc(alias = "gtk_text_buffer_get_bounds")]
    #[doc(alias = "get_bounds")]
    fn bounds(&self) -> (TextIter, TextIter);

    #[doc(alias = "gtk_text_buffer_get_can_redo")]
    #[doc(alias = "get_can_redo")]
    fn can_redo(&self) -> bool;

    #[doc(alias = "gtk_text_buffer_get_can_undo")]
    #[doc(alias = "get_can_undo")]
    fn can_undo(&self) -> bool;

    #[doc(alias = "gtk_text_buffer_get_char_count")]
    #[doc(alias = "get_char_count")]
    fn char_count(&self) -> i32;

    #[doc(alias = "gtk_text_buffer_get_enable_undo")]
    #[doc(alias = "get_enable_undo")]
    fn enables_undo(&self) -> bool;

    #[doc(alias = "gtk_text_buffer_get_end_iter")]
    #[doc(alias = "get_end_iter")]
    fn end_iter(&self) -> TextIter;

    #[doc(alias = "gtk_text_buffer_get_has_selection")]
    #[doc(alias = "get_has_selection")]
    fn has_selection(&self) -> bool;

    #[doc(alias = "gtk_text_buffer_get_insert")]
    fn get_insert(&self) -> TextMark;

    #[doc(alias = "gtk_text_buffer_get_iter_at_child_anchor")]
    #[doc(alias = "get_iter_at_child_anchor")]
    fn iter_at_child_anchor(&self, anchor: &impl IsA<TextChildAnchor>) -> TextIter;

    #[doc(alias = "gtk_text_buffer_get_iter_at_line")]
    #[doc(alias = "get_iter_at_line")]
    fn iter_at_line(&self, line_number: i32) -> Option<TextIter>;

    #[doc(alias = "gtk_text_buffer_get_iter_at_line_index")]
    #[doc(alias = "get_iter_at_line_index")]
    fn iter_at_line_index(&self, line_number: i32, byte_index: i32) -> Option<TextIter>;

    #[doc(alias = "gtk_text_buffer_get_iter_at_line_offset")]
    #[doc(alias = "get_iter_at_line_offset")]
    fn iter_at_line_offset(&self, line_number: i32, char_offset: i32) -> Option<TextIter>;

    #[doc(alias = "gtk_text_buffer_get_iter_at_mark")]
    #[doc(alias = "get_iter_at_mark")]
    fn iter_at_mark(&self, mark: &impl IsA<TextMark>) -> TextIter;

    #[doc(alias = "gtk_text_buffer_get_iter_at_offset")]
    #[doc(alias = "get_iter_at_offset")]
    fn iter_at_offset(&self, char_offset: i32) -> TextIter;

    #[doc(alias = "gtk_text_buffer_get_line_count")]
    #[doc(alias = "get_line_count")]
    fn line_count(&self) -> i32;

    #[doc(alias = "gtk_text_buffer_get_mark")]
    #[doc(alias = "get_mark")]
    fn mark(&self, name: &str) -> Option<TextMark>;

    #[doc(alias = "gtk_text_buffer_get_max_undo_levels")]
    #[doc(alias = "get_max_undo_levels")]
    fn max_undo_levels(&self) -> u32;

    #[doc(alias = "gtk_text_buffer_get_modified")]
    #[doc(alias = "get_modified")]
    fn is_modified(&self) -> bool;

    #[doc(alias = "gtk_text_buffer_get_selection_bound")]
    #[doc(alias = "get_selection_bound")]
    fn selection_bound(&self) -> TextMark;

    #[doc(alias = "gtk_text_buffer_get_selection_bounds")]
    #[doc(alias = "get_selection_bounds")]
    fn selection_bounds(&self) -> Option<(TextIter, TextIter)>;

    #[doc(alias = "gtk_text_buffer_get_selection_content")]
    #[doc(alias = "get_selection_content")]
    fn selection_content(&self) -> gdk::ContentProvider;

    #[doc(alias = "gtk_text_buffer_get_slice")]
    #[doc(alias = "get_slice")]
    fn slice(&self, start: &TextIter, end: &TextIter, include_hidden_chars: bool) -> glib::GString;

    #[doc(alias = "gtk_text_buffer_get_start_iter")]
    #[doc(alias = "get_start_iter")]
    fn start_iter(&self) -> TextIter;

    #[doc(alias = "gtk_text_buffer_get_tag_table")]
    #[doc(alias = "get_tag_table")]
    fn tag_table(&self) -> TextTagTable;

    #[doc(alias = "gtk_text_buffer_get_text")]
    #[doc(alias = "get_text")]
    fn text(&self, start: &TextIter, end: &TextIter, include_hidden_chars: bool) -> glib::GString;

    #[doc(alias = "gtk_text_buffer_insert")]
    fn insert(&self, iter: &mut TextIter, text: &str);

    #[doc(alias = "gtk_text_buffer_insert_at_cursor")]
    fn insert_at_cursor(&self, text: &str);

    #[doc(alias = "gtk_text_buffer_insert_child_anchor")]
    fn insert_child_anchor(&self, iter: &mut TextIter, anchor: &impl IsA<TextChildAnchor>);

    #[doc(alias = "gtk_text_buffer_insert_interactive")]
    fn insert_interactive(&self, iter: &mut TextIter, text: &str, default_editable: bool) -> bool;

    #[doc(alias = "gtk_text_buffer_insert_interactive_at_cursor")]
    fn insert_interactive_at_cursor(&self, text: &str, default_editable: bool) -> bool;

    #[doc(alias = "gtk_text_buffer_insert_markup")]
    fn insert_markup(&self, iter: &mut TextIter, markup: &str);

    #[doc(alias = "gtk_text_buffer_insert_paintable")]
    fn insert_paintable(&self, iter: &mut TextIter, paintable: &impl IsA<gdk::Paintable>);

    #[doc(alias = "gtk_text_buffer_insert_range")]
    fn insert_range(&self, iter: &mut TextIter, start: &TextIter, end: &TextIter);

    #[doc(alias = "gtk_text_buffer_insert_range_interactive")]
    fn insert_range_interactive(
        &self,
        iter: &mut TextIter,
        start: &TextIter,
        end: &TextIter,
        default_editable: bool,
    ) -> bool;

    #[doc(alias = "gtk_text_buffer_move_mark")]
    fn move_mark(&self, mark: &impl IsA<TextMark>, where_: &TextIter);

    #[doc(alias = "gtk_text_buffer_move_mark_by_name")]
    fn move_mark_by_name(&self, name: &str, where_: &TextIter);

    #[doc(alias = "gtk_text_buffer_paste_clipboard")]
    fn paste_clipboard(
        &self,
        clipboard: &gdk::Clipboard,
        override_location: Option<&TextIter>,
        default_editable: bool,
    );

    #[doc(alias = "gtk_text_buffer_place_cursor")]
    fn place_cursor(&self, where_: &TextIter);

    #[doc(alias = "gtk_text_buffer_redo")]
    fn redo(&self);

    #[doc(alias = "gtk_text_buffer_remove_all_tags")]
    fn remove_all_tags(&self, start: &TextIter, end: &TextIter);

    #[doc(alias = "gtk_text_buffer_remove_selection_clipboard")]
    fn remove_selection_clipboard(&self, clipboard: &gdk::Clipboard);

    #[doc(alias = "gtk_text_buffer_remove_tag")]
    fn remove_tag(&self, tag: &impl IsA<TextTag>, start: &TextIter, end: &TextIter);

    #[doc(alias = "gtk_text_buffer_remove_tag_by_name")]
    fn remove_tag_by_name(&self, name: &str, start: &TextIter, end: &TextIter);

    #[doc(alias = "gtk_text_buffer_select_range")]
    fn select_range(&self, ins: &TextIter, bound: &TextIter);

    #[doc(alias = "gtk_text_buffer_set_enable_undo")]
    fn set_enable_undo(&self, enable_undo: bool);

    #[doc(alias = "gtk_text_buffer_set_max_undo_levels")]
    fn set_max_undo_levels(&self, max_undo_levels: u32);

    #[doc(alias = "gtk_text_buffer_set_modified")]
    fn set_modified(&self, setting: bool);

    #[doc(alias = "gtk_text_buffer_set_text")]
    fn set_text(&self, text: &str);

    #[doc(alias = "gtk_text_buffer_undo")]
    fn undo(&self);

    #[doc(alias = "cursor-position")]
    fn cursor_position(&self) -> i32;

    #[doc(alias = "apply-tag")]
    fn connect_apply_tag<F: Fn(&Self, &TextTag, &TextIter, &TextIter) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "begin-user-action")]
    fn connect_begin_user_action<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "changed")]
    fn connect_changed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "delete-range")]
    fn connect_delete_range<F: Fn(&Self, &TextIter, &TextIter) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "end-user-action")]
    fn connect_end_user_action<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "insert-child-anchor")]
    fn connect_insert_child_anchor<F: Fn(&Self, &TextIter, &TextChildAnchor) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "insert-paintable")]
    fn connect_insert_paintable<F: Fn(&Self, &TextIter, &gdk::Paintable) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "mark-deleted")]
    fn connect_mark_deleted<F: Fn(&Self, &TextMark) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "mark-set")]
    fn connect_mark_set<F: Fn(&Self, &TextIter, &TextMark) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "modified-changed")]
    fn connect_modified_changed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "paste-done")]
    fn connect_paste_done<F: Fn(&Self, &gdk::Clipboard) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "redo")]
    fn connect_redo<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "remove-tag")]
    fn connect_remove_tag<F: Fn(&Self, &TextTag, &TextIter, &TextIter) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "undo")]
    fn connect_undo<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "can-redo")]
    fn connect_can_redo_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "can-undo")]
    fn connect_can_undo_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "cursor-position")]
    fn connect_cursor_position_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "enable-undo")]
    fn connect_enable_undo_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "has-selection")]
    fn connect_has_selection_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "text")]
    fn connect_text_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<TextBuffer>> TextBufferExt for O {
    fn add_mark(&self, mark: &impl IsA<TextMark>, where_: &TextIter) {
        unsafe {
            ffi::gtk_text_buffer_add_mark(
                self.as_ref().to_glib_none().0,
                mark.as_ref().to_glib_none().0,
                where_.to_glib_none().0,
            );
        }
    }

    fn add_selection_clipboard(&self, clipboard: &gdk::Clipboard) {
        unsafe {
            ffi::gtk_text_buffer_add_selection_clipboard(
                self.as_ref().to_glib_none().0,
                clipboard.to_glib_none().0,
            );
        }
    }

    fn apply_tag(&self, tag: &impl IsA<TextTag>, start: &TextIter, end: &TextIter) {
        unsafe {
            ffi::gtk_text_buffer_apply_tag(
                self.as_ref().to_glib_none().0,
                tag.as_ref().to_glib_none().0,
                start.to_glib_none().0,
                end.to_glib_none().0,
            );
        }
    }

    fn apply_tag_by_name(&self, name: &str, start: &TextIter, end: &TextIter) {
        unsafe {
            ffi::gtk_text_buffer_apply_tag_by_name(
                self.as_ref().to_glib_none().0,
                name.to_glib_none().0,
                start.to_glib_none().0,
                end.to_glib_none().0,
            );
        }
    }

    fn backspace(&self, iter: &mut TextIter, interactive: bool, default_editable: bool) -> bool {
        unsafe {
            from_glib(ffi::gtk_text_buffer_backspace(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none_mut().0,
                interactive.into_glib(),
                default_editable.into_glib(),
            ))
        }
    }

    fn begin_irreversible_action(&self) {
        unsafe {
            ffi::gtk_text_buffer_begin_irreversible_action(self.as_ref().to_glib_none().0);
        }
    }

    fn begin_user_action(&self) {
        unsafe {
            ffi::gtk_text_buffer_begin_user_action(self.as_ref().to_glib_none().0);
        }
    }

    fn copy_clipboard(&self, clipboard: &gdk::Clipboard) {
        unsafe {
            ffi::gtk_text_buffer_copy_clipboard(
                self.as_ref().to_glib_none().0,
                clipboard.to_glib_none().0,
            );
        }
    }

    fn create_child_anchor(&self, iter: &mut TextIter) -> TextChildAnchor {
        unsafe {
            from_glib_none(ffi::gtk_text_buffer_create_child_anchor(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none_mut().0,
            ))
        }
    }

    fn create_mark(
        &self,
        mark_name: Option<&str>,
        where_: &TextIter,
        left_gravity: bool,
    ) -> TextMark {
        unsafe {
            from_glib_none(ffi::gtk_text_buffer_create_mark(
                self.as_ref().to_glib_none().0,
                mark_name.to_glib_none().0,
                where_.to_glib_none().0,
                left_gravity.into_glib(),
            ))
        }
    }

    fn cut_clipboard(&self, clipboard: &gdk::Clipboard, default_editable: bool) {
        unsafe {
            ffi::gtk_text_buffer_cut_clipboard(
                self.as_ref().to_glib_none().0,
                clipboard.to_glib_none().0,
                default_editable.into_glib(),
            );
        }
    }

    fn delete(&self, start: &mut TextIter, end: &mut TextIter) {
        unsafe {
            ffi::gtk_text_buffer_delete(
                self.as_ref().to_glib_none().0,
                start.to_glib_none_mut().0,
                end.to_glib_none_mut().0,
            );
        }
    }

    fn delete_interactive(
        &self,
        start_iter: &mut TextIter,
        end_iter: &mut TextIter,
        default_editable: bool,
    ) -> bool {
        unsafe {
            from_glib(ffi::gtk_text_buffer_delete_interactive(
                self.as_ref().to_glib_none().0,
                start_iter.to_glib_none_mut().0,
                end_iter.to_glib_none_mut().0,
                default_editable.into_glib(),
            ))
        }
    }

    fn delete_mark(&self, mark: &impl IsA<TextMark>) {
        unsafe {
            ffi::gtk_text_buffer_delete_mark(
                self.as_ref().to_glib_none().0,
                mark.as_ref().to_glib_none().0,
            );
        }
    }

    fn delete_mark_by_name(&self, name: &str) {
        unsafe {
            ffi::gtk_text_buffer_delete_mark_by_name(
                self.as_ref().to_glib_none().0,
                name.to_glib_none().0,
            );
        }
    }

    fn delete_selection(&self, interactive: bool, default_editable: bool) -> bool {
        unsafe {
            from_glib(ffi::gtk_text_buffer_delete_selection(
                self.as_ref().to_glib_none().0,
                interactive.into_glib(),
                default_editable.into_glib(),
            ))
        }
    }

    fn end_irreversible_action(&self) {
        unsafe {
            ffi::gtk_text_buffer_end_irreversible_action(self.as_ref().to_glib_none().0);
        }
    }

    fn end_user_action(&self) {
        unsafe {
            ffi::gtk_text_buffer_end_user_action(self.as_ref().to_glib_none().0);
        }
    }

    fn bounds(&self) -> (TextIter, TextIter) {
        unsafe {
            let mut start = TextIter::uninitialized();
            let mut end = TextIter::uninitialized();
            ffi::gtk_text_buffer_get_bounds(
                self.as_ref().to_glib_none().0,
                start.to_glib_none_mut().0,
                end.to_glib_none_mut().0,
            );
            (start, end)
        }
    }

    fn can_redo(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_text_buffer_get_can_redo(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn can_undo(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_text_buffer_get_can_undo(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn char_count(&self) -> i32 {
        unsafe { ffi::gtk_text_buffer_get_char_count(self.as_ref().to_glib_none().0) }
    }

    fn enables_undo(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_text_buffer_get_enable_undo(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn end_iter(&self) -> TextIter {
        unsafe {
            let mut iter = TextIter::uninitialized();
            ffi::gtk_text_buffer_get_end_iter(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none_mut().0,
            );
            iter
        }
    }

    fn has_selection(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_text_buffer_get_has_selection(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_insert(&self) -> TextMark {
        unsafe {
            from_glib_none(ffi::gtk_text_buffer_get_insert(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn iter_at_child_anchor(&self, anchor: &impl IsA<TextChildAnchor>) -> TextIter {
        unsafe {
            let mut iter = TextIter::uninitialized();
            ffi::gtk_text_buffer_get_iter_at_child_anchor(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none_mut().0,
                anchor.as_ref().to_glib_none().0,
            );
            iter
        }
    }

    fn iter_at_line(&self, line_number: i32) -> Option<TextIter> {
        unsafe {
            let mut iter = TextIter::uninitialized();
            let ret = from_glib(ffi::gtk_text_buffer_get_iter_at_line(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none_mut().0,
                line_number,
            ));
            if ret {
                Some(iter)
            } else {
                None
            }
        }
    }

    fn iter_at_line_index(&self, line_number: i32, byte_index: i32) -> Option<TextIter> {
        unsafe {
            let mut iter = TextIter::uninitialized();
            let ret = from_glib(ffi::gtk_text_buffer_get_iter_at_line_index(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none_mut().0,
                line_number,
                byte_index,
            ));
            if ret {
                Some(iter)
            } else {
                None
            }
        }
    }

    fn iter_at_line_offset(&self, line_number: i32, char_offset: i32) -> Option<TextIter> {
        unsafe {
            let mut iter = TextIter::uninitialized();
            let ret = from_glib(ffi::gtk_text_buffer_get_iter_at_line_offset(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none_mut().0,
                line_number,
                char_offset,
            ));
            if ret {
                Some(iter)
            } else {
                None
            }
        }
    }

    fn iter_at_mark(&self, mark: &impl IsA<TextMark>) -> TextIter {
        unsafe {
            let mut iter = TextIter::uninitialized();
            ffi::gtk_text_buffer_get_iter_at_mark(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none_mut().0,
                mark.as_ref().to_glib_none().0,
            );
            iter
        }
    }

    fn iter_at_offset(&self, char_offset: i32) -> TextIter {
        unsafe {
            let mut iter = TextIter::uninitialized();
            ffi::gtk_text_buffer_get_iter_at_offset(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none_mut().0,
                char_offset,
            );
            iter
        }
    }

    fn line_count(&self) -> i32 {
        unsafe { ffi::gtk_text_buffer_get_line_count(self.as_ref().to_glib_none().0) }
    }

    fn mark(&self, name: &str) -> Option<TextMark> {
        unsafe {
            from_glib_none(ffi::gtk_text_buffer_get_mark(
                self.as_ref().to_glib_none().0,
                name.to_glib_none().0,
            ))
        }
    }

    fn max_undo_levels(&self) -> u32 {
        unsafe { ffi::gtk_text_buffer_get_max_undo_levels(self.as_ref().to_glib_none().0) }
    }

    fn is_modified(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_text_buffer_get_modified(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn selection_bound(&self) -> TextMark {
        unsafe {
            from_glib_none(ffi::gtk_text_buffer_get_selection_bound(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn selection_bounds(&self) -> Option<(TextIter, TextIter)> {
        unsafe {
            let mut start = TextIter::uninitialized();
            let mut end = TextIter::uninitialized();
            let ret = from_glib(ffi::gtk_text_buffer_get_selection_bounds(
                self.as_ref().to_glib_none().0,
                start.to_glib_none_mut().0,
                end.to_glib_none_mut().0,
            ));
            if ret {
                Some((start, end))
            } else {
                None
            }
        }
    }

    fn selection_content(&self) -> gdk::ContentProvider {
        unsafe {
            from_glib_full(ffi::gtk_text_buffer_get_selection_content(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn slice(&self, start: &TextIter, end: &TextIter, include_hidden_chars: bool) -> glib::GString {
        unsafe {
            from_glib_full(ffi::gtk_text_buffer_get_slice(
                self.as_ref().to_glib_none().0,
                start.to_glib_none().0,
                end.to_glib_none().0,
                include_hidden_chars.into_glib(),
            ))
        }
    }

    fn start_iter(&self) -> TextIter {
        unsafe {
            let mut iter = TextIter::uninitialized();
            ffi::gtk_text_buffer_get_start_iter(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none_mut().0,
            );
            iter
        }
    }

    fn tag_table(&self) -> TextTagTable {
        unsafe {
            from_glib_none(ffi::gtk_text_buffer_get_tag_table(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn text(&self, start: &TextIter, end: &TextIter, include_hidden_chars: bool) -> glib::GString {
        unsafe {
            from_glib_full(ffi::gtk_text_buffer_get_text(
                self.as_ref().to_glib_none().0,
                start.to_glib_none().0,
                end.to_glib_none().0,
                include_hidden_chars.into_glib(),
            ))
        }
    }

    fn insert(&self, iter: &mut TextIter, text: &str) {
        let len = text.len() as _;
        unsafe {
            ffi::gtk_text_buffer_insert(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none_mut().0,
                text.to_glib_none().0,
                len,
            );
        }
    }

    fn insert_at_cursor(&self, text: &str) {
        let len = text.len() as _;
        unsafe {
            ffi::gtk_text_buffer_insert_at_cursor(
                self.as_ref().to_glib_none().0,
                text.to_glib_none().0,
                len,
            );
        }
    }

    fn insert_child_anchor(&self, iter: &mut TextIter, anchor: &impl IsA<TextChildAnchor>) {
        unsafe {
            ffi::gtk_text_buffer_insert_child_anchor(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none_mut().0,
                anchor.as_ref().to_glib_none().0,
            );
        }
    }

    fn insert_interactive(&self, iter: &mut TextIter, text: &str, default_editable: bool) -> bool {
        let len = text.len() as _;
        unsafe {
            from_glib(ffi::gtk_text_buffer_insert_interactive(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none_mut().0,
                text.to_glib_none().0,
                len,
                default_editable.into_glib(),
            ))
        }
    }

    fn insert_interactive_at_cursor(&self, text: &str, default_editable: bool) -> bool {
        let len = text.len() as _;
        unsafe {
            from_glib(ffi::gtk_text_buffer_insert_interactive_at_cursor(
                self.as_ref().to_glib_none().0,
                text.to_glib_none().0,
                len,
                default_editable.into_glib(),
            ))
        }
    }

    fn insert_markup(&self, iter: &mut TextIter, markup: &str) {
        let len = markup.len() as _;
        unsafe {
            ffi::gtk_text_buffer_insert_markup(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none_mut().0,
                markup.to_glib_none().0,
                len,
            );
        }
    }

    fn insert_paintable(&self, iter: &mut TextIter, paintable: &impl IsA<gdk::Paintable>) {
        unsafe {
            ffi::gtk_text_buffer_insert_paintable(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none_mut().0,
                paintable.as_ref().to_glib_none().0,
            );
        }
    }

    fn insert_range(&self, iter: &mut TextIter, start: &TextIter, end: &TextIter) {
        unsafe {
            ffi::gtk_text_buffer_insert_range(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none_mut().0,
                start.to_glib_none().0,
                end.to_glib_none().0,
            );
        }
    }

    fn insert_range_interactive(
        &self,
        iter: &mut TextIter,
        start: &TextIter,
        end: &TextIter,
        default_editable: bool,
    ) -> bool {
        unsafe {
            from_glib(ffi::gtk_text_buffer_insert_range_interactive(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none_mut().0,
                start.to_glib_none().0,
                end.to_glib_none().0,
                default_editable.into_glib(),
            ))
        }
    }

    fn move_mark(&self, mark: &impl IsA<TextMark>, where_: &TextIter) {
        unsafe {
            ffi::gtk_text_buffer_move_mark(
                self.as_ref().to_glib_none().0,
                mark.as_ref().to_glib_none().0,
                where_.to_glib_none().0,
            );
        }
    }

    fn move_mark_by_name(&self, name: &str, where_: &TextIter) {
        unsafe {
            ffi::gtk_text_buffer_move_mark_by_name(
                self.as_ref().to_glib_none().0,
                name.to_glib_none().0,
                where_.to_glib_none().0,
            );
        }
    }

    fn paste_clipboard(
        &self,
        clipboard: &gdk::Clipboard,
        override_location: Option<&TextIter>,
        default_editable: bool,
    ) {
        unsafe {
            ffi::gtk_text_buffer_paste_clipboard(
                self.as_ref().to_glib_none().0,
                clipboard.to_glib_none().0,
                mut_override(override_location.to_glib_none().0),
                default_editable.into_glib(),
            );
        }
    }

    fn place_cursor(&self, where_: &TextIter) {
        unsafe {
            ffi::gtk_text_buffer_place_cursor(
                self.as_ref().to_glib_none().0,
                where_.to_glib_none().0,
            );
        }
    }

    fn redo(&self) {
        unsafe {
            ffi::gtk_text_buffer_redo(self.as_ref().to_glib_none().0);
        }
    }

    fn remove_all_tags(&self, start: &TextIter, end: &TextIter) {
        unsafe {
            ffi::gtk_text_buffer_remove_all_tags(
                self.as_ref().to_glib_none().0,
                start.to_glib_none().0,
                end.to_glib_none().0,
            );
        }
    }

    fn remove_selection_clipboard(&self, clipboard: &gdk::Clipboard) {
        unsafe {
            ffi::gtk_text_buffer_remove_selection_clipboard(
                self.as_ref().to_glib_none().0,
                clipboard.to_glib_none().0,
            );
        }
    }

    fn remove_tag(&self, tag: &impl IsA<TextTag>, start: &TextIter, end: &TextIter) {
        unsafe {
            ffi::gtk_text_buffer_remove_tag(
                self.as_ref().to_glib_none().0,
                tag.as_ref().to_glib_none().0,
                start.to_glib_none().0,
                end.to_glib_none().0,
            );
        }
    }

    fn remove_tag_by_name(&self, name: &str, start: &TextIter, end: &TextIter) {
        unsafe {
            ffi::gtk_text_buffer_remove_tag_by_name(
                self.as_ref().to_glib_none().0,
                name.to_glib_none().0,
                start.to_glib_none().0,
                end.to_glib_none().0,
            );
        }
    }

    fn select_range(&self, ins: &TextIter, bound: &TextIter) {
        unsafe {
            ffi::gtk_text_buffer_select_range(
                self.as_ref().to_glib_none().0,
                ins.to_glib_none().0,
                bound.to_glib_none().0,
            );
        }
    }

    fn set_enable_undo(&self, enable_undo: bool) {
        unsafe {
            ffi::gtk_text_buffer_set_enable_undo(
                self.as_ref().to_glib_none().0,
                enable_undo.into_glib(),
            );
        }
    }

    fn set_max_undo_levels(&self, max_undo_levels: u32) {
        unsafe {
            ffi::gtk_text_buffer_set_max_undo_levels(
                self.as_ref().to_glib_none().0,
                max_undo_levels,
            );
        }
    }

    fn set_modified(&self, setting: bool) {
        unsafe {
            ffi::gtk_text_buffer_set_modified(self.as_ref().to_glib_none().0, setting.into_glib());
        }
    }

    fn set_text(&self, text: &str) {
        let len = text.len() as _;
        unsafe {
            ffi::gtk_text_buffer_set_text(
                self.as_ref().to_glib_none().0,
                text.to_glib_none().0,
                len,
            );
        }
    }

    fn undo(&self) {
        unsafe {
            ffi::gtk_text_buffer_undo(self.as_ref().to_glib_none().0);
        }
    }

    fn cursor_position(&self) -> i32 {
        glib::ObjectExt::property(self.as_ref(), "cursor-position")
    }

    fn connect_apply_tag<F: Fn(&Self, &TextTag, &TextIter, &TextIter) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn apply_tag_trampoline<
            P: IsA<TextBuffer>,
            F: Fn(&P, &TextTag, &TextIter, &TextIter) + 'static,
        >(
            this: *mut ffi::GtkTextBuffer,
            tag: *mut ffi::GtkTextTag,
            start: *mut ffi::GtkTextIter,
            end: *mut ffi::GtkTextIter,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                TextBuffer::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(tag),
                &from_glib_borrow(start),
                &from_glib_borrow(end),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"apply-tag\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    apply_tag_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_begin_user_action<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn begin_user_action_trampoline<
            P: IsA<TextBuffer>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextBuffer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextBuffer::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"begin-user-action\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    begin_user_action_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_changed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn changed_trampoline<P: IsA<TextBuffer>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextBuffer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextBuffer::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"changed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    changed_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_delete_range<F: Fn(&Self, &TextIter, &TextIter) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn delete_range_trampoline<
            P: IsA<TextBuffer>,
            F: Fn(&P, &TextIter, &TextIter) + 'static,
        >(
            this: *mut ffi::GtkTextBuffer,
            start: *mut ffi::GtkTextIter,
            end: *mut ffi::GtkTextIter,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                TextBuffer::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(start),
                &from_glib_borrow(end),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"delete-range\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    delete_range_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_end_user_action<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn end_user_action_trampoline<P: IsA<TextBuffer>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextBuffer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextBuffer::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"end-user-action\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    end_user_action_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_insert_child_anchor<F: Fn(&Self, &TextIter, &TextChildAnchor) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn insert_child_anchor_trampoline<
            P: IsA<TextBuffer>,
            F: Fn(&P, &TextIter, &TextChildAnchor) + 'static,
        >(
            this: *mut ffi::GtkTextBuffer,
            location: *mut ffi::GtkTextIter,
            anchor: *mut ffi::GtkTextChildAnchor,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                TextBuffer::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(location),
                &from_glib_borrow(anchor),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"insert-child-anchor\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    insert_child_anchor_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_insert_paintable<F: Fn(&Self, &TextIter, &gdk::Paintable) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn insert_paintable_trampoline<
            P: IsA<TextBuffer>,
            F: Fn(&P, &TextIter, &gdk::Paintable) + 'static,
        >(
            this: *mut ffi::GtkTextBuffer,
            location: *mut ffi::GtkTextIter,
            paintable: *mut gdk::ffi::GdkPaintable,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                TextBuffer::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(location),
                &from_glib_borrow(paintable),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"insert-paintable\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    insert_paintable_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_mark_deleted<F: Fn(&Self, &TextMark) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn mark_deleted_trampoline<
            P: IsA<TextBuffer>,
            F: Fn(&P, &TextMark) + 'static,
        >(
            this: *mut ffi::GtkTextBuffer,
            mark: *mut ffi::GtkTextMark,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                TextBuffer::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(mark),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"mark-deleted\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    mark_deleted_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_mark_set<F: Fn(&Self, &TextIter, &TextMark) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn mark_set_trampoline<
            P: IsA<TextBuffer>,
            F: Fn(&P, &TextIter, &TextMark) + 'static,
        >(
            this: *mut ffi::GtkTextBuffer,
            location: *mut ffi::GtkTextIter,
            mark: *mut ffi::GtkTextMark,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                TextBuffer::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(location),
                &from_glib_borrow(mark),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"mark-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    mark_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_modified_changed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn modified_changed_trampoline<
            P: IsA<TextBuffer>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextBuffer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextBuffer::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"modified-changed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    modified_changed_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_paste_done<F: Fn(&Self, &gdk::Clipboard) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn paste_done_trampoline<
            P: IsA<TextBuffer>,
            F: Fn(&P, &gdk::Clipboard) + 'static,
        >(
            this: *mut ffi::GtkTextBuffer,
            clipboard: *mut gdk::ffi::GdkClipboard,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                TextBuffer::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(clipboard),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"paste-done\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    paste_done_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_redo<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn redo_trampoline<P: IsA<TextBuffer>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextBuffer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextBuffer::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"redo\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    redo_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_remove_tag<F: Fn(&Self, &TextTag, &TextIter, &TextIter) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn remove_tag_trampoline<
            P: IsA<TextBuffer>,
            F: Fn(&P, &TextTag, &TextIter, &TextIter) + 'static,
        >(
            this: *mut ffi::GtkTextBuffer,
            tag: *mut ffi::GtkTextTag,
            start: *mut ffi::GtkTextIter,
            end: *mut ffi::GtkTextIter,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                TextBuffer::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(tag),
                &from_glib_borrow(start),
                &from_glib_borrow(end),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"remove-tag\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    remove_tag_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_undo<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn undo_trampoline<P: IsA<TextBuffer>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextBuffer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextBuffer::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"undo\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    undo_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_can_redo_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_can_redo_trampoline<P: IsA<TextBuffer>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextBuffer,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextBuffer::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::can-redo\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_can_redo_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_can_undo_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_can_undo_trampoline<P: IsA<TextBuffer>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextBuffer,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextBuffer::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::can-undo\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_can_undo_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_cursor_position_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_cursor_position_trampoline<
            P: IsA<TextBuffer>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextBuffer,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextBuffer::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::cursor-position\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_cursor_position_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_enable_undo_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_enable_undo_trampoline<
            P: IsA<TextBuffer>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextBuffer,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextBuffer::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::enable-undo\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_enable_undo_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_has_selection_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_has_selection_trampoline<
            P: IsA<TextBuffer>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextBuffer,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextBuffer::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::has-selection\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_has_selection_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_text_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_text_trampoline<P: IsA<TextBuffer>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextBuffer,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextBuffer::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::text\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_text_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for TextBuffer {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("TextBuffer")
    }
}
