/* gtkatspiprivate.h: AT-SPI shared types
 *
 * Copyright 2020  GNOME Foundation
 *
 * SPDX-License-Identifier: LGPL-2.1-or-later
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */

#pragma once

#include <glib.h>

G_BEGIN_DECLS

typedef enum {
  ATSPI_ROLE_INVALID,
  ATSPI_ROLE_ACCELERATOR_LABEL,
  ATSPI_ROLE_ALERT,
  ATSPI_ROLE_ANIMATION,
  ATSPI_ROLE_ARROW,
  ATSPI_ROLE_CALENDAR,
  ATSPI_ROLE_CANVAS,
  ATSPI_ROLE_CHECK_BOX,
  ATSPI_ROLE_CHECK_MENU_ITEM,
  ATSPI_ROLE_COLOR_CHOOSER,
  ATSPI_ROLE_COLUMN_HEADER,
  ATSPI_ROLE_COMBO_BOX,
  ATSPI_ROLE_DATE_EDITOR,
  ATSPI_ROLE_DESKTOP_ICON,
  ATSPI_ROLE_DESKTOP_FRAME,
  ATSPI_ROLE_DIAL,
  ATSPI_ROLE_DIALOG,
  ATSPI_ROLE_DIRECTORY_PANE,
  ATSPI_ROLE_DRAWING_AREA,
  ATSPI_ROLE_FILE_CHOOSER,
  ATSPI_ROLE_FILLER,
  ATSPI_ROLE_FOCUS_TRAVERSABLE,
  ATSPI_ROLE_FONT_CHOOSER,
  ATSPI_ROLE_FRAME,
  ATSPI_ROLE_GLASS_PANE,
  ATSPI_ROLE_HTML_CONTAINER,
  ATSPI_ROLE_ICON,
  ATSPI_ROLE_IMAGE,
  ATSPI_ROLE_INTERNAL_FRAME,
  ATSPI_ROLE_LABEL,
  ATSPI_ROLE_LAYERED_PANE,
  ATSPI_ROLE_LIST,
  ATSPI_ROLE_LIST_ITEM,
  ATSPI_ROLE_MENU,
  ATSPI_ROLE_MENU_BAR,
  ATSPI_ROLE_MENU_ITEM,
  ATSPI_ROLE_OPTION_PANE,
  ATSPI_ROLE_PAGE_TAB,
  ATSPI_ROLE_PAGE_TAB_LIST,
  ATSPI_ROLE_PANEL,
  ATSPI_ROLE_PASSWORD_TEXT,
  ATSPI_ROLE_POPUP_MENU,
  ATSPI_ROLE_PROGRESS_BAR,
  ATSPI_ROLE_PUSH_BUTTON,
  ATSPI_ROLE_RADIO_BUTTON,
  ATSPI_ROLE_RADIO_MENU_ITEM,
  ATSPI_ROLE_ROOT_PANE,
  ATSPI_ROLE_ROW_HEADER,
  ATSPI_ROLE_SCROLL_BAR,
  ATSPI_ROLE_SCROLL_PANE,
  ATSPI_ROLE_SEPARATOR,
  ATSPI_ROLE_SLIDER,
  ATSPI_ROLE_SPIN_BUTTON,
  ATSPI_ROLE_SPLIT_PANE,
  ATSPI_ROLE_STATUS_BAR,
  ATSPI_ROLE_TABLE,
  ATSPI_ROLE_TABLE_CELL,
  ATSPI_ROLE_TABLE_COLUMN_HEADER,
  ATSPI_ROLE_TABLE_ROW_HEADER,
  ATSPI_ROLE_TEAROFF_MENU_ITEM,
  ATSPI_ROLE_TERMINAL,
  ATSPI_ROLE_TEXT,
  ATSPI_ROLE_TOGGLE_BUTTON,
  ATSPI_ROLE_TOOL_BAR,
  ATSPI_ROLE_TOOL_TIP,
  ATSPI_ROLE_TREE,
  ATSPI_ROLE_TREE_TABLE,
  ATSPI_ROLE_UNKNOWN,
  ATSPI_ROLE_VIEWPORT,
  ATSPI_ROLE_WINDOW,
  ATSPI_ROLE_EXTENDED,
  ATSPI_ROLE_HEADER,
  ATSPI_ROLE_FOOTER,
  ATSPI_ROLE_PARAGRAPH,
  ATSPI_ROLE_RULER,
  ATSPI_ROLE_APPLICATION,
  ATSPI_ROLE_AUTOCOMPLETE,
  ATSPI_ROLE_EDITBAR,
  ATSPI_ROLE_EMBEDDED,
  ATSPI_ROLE_ENTRY,
  ATSPI_ROLE_CHART,
  ATSPI_ROLE_CAPTION,
  ATSPI_ROLE_DOCUMENT_FRAME,
  ATSPI_ROLE_HEADING,
  ATSPI_ROLE_PAGE,
  ATSPI_ROLE_SECTION,
  ATSPI_ROLE_REDUNDANT_OBJECT,
  ATSPI_ROLE_FORM,
  ATSPI_ROLE_LINK,
  ATSPI_ROLE_INPUT_METHOD_WINDOW,
  ATSPI_ROLE_TABLE_ROW,
  ATSPI_ROLE_TREE_ITEM,
  ATSPI_ROLE_DOCUMENT_SPREADSHEET,
  ATSPI_ROLE_DOCUMENT_PRESENTATION,
  ATSPI_ROLE_DOCUMENT_TEXT,
  ATSPI_ROLE_DOCUMENT_WEB,
  ATSPI_ROLE_DOCUMENT_EMAIL,
  ATSPI_ROLE_COMMENT,
  ATSPI_ROLE_LIST_BOX,
  ATSPI_ROLE_GROUPING,
  ATSPI_ROLE_IMAGE_MAP,
  ATSPI_ROLE_NOTIFICATION,
  ATSPI_ROLE_INFO_BAR,
  ATSPI_ROLE_LEVEL_BAR,
  ATSPI_ROLE_TITLE_BAR,
  ATSPI_ROLE_BLOCK_QUOTE,
  ATSPI_ROLE_AUDIO,
  ATSPI_ROLE_VIDEO,
  ATSPI_ROLE_DEFINITION,
  ATSPI_ROLE_ARTICLE,
  ATSPI_ROLE_LANDMARK,
  ATSPI_ROLE_LOG,
  ATSPI_ROLE_MARQUEE,
  ATSPI_ROLE_MATH,
  ATSPI_ROLE_RATING,
  ATSPI_ROLE_TIMER,
  ATSPI_ROLE_STATIC,
  ATSPI_ROLE_MATH_FRACTION,
  ATSPI_ROLE_MATH_ROOT,
  ATSPI_ROLE_SUBSCRIPT,
  ATSPI_ROLE_SUPERSCRIPT,
  ATSPI_ROLE_DESCRIPTION_LIST,
  ATSPI_ROLE_DESCRIPTION_TERM,
  ATSPI_ROLE_DESCRIPTION_VALUE,
  ATSPI_ROLE_FOOTNOTE,
  ATSPI_ROLE_CONTENT_DELETION,
  ATSPI_ROLE_CONTENT_INSERTION,
  ATSPI_ROLE_MARK,
  ATSPI_ROLE_SUGGESTION,
  ATSPI_ROLE_LAST_DEFINED,
} AtspiRole;

typedef enum {
  ATSPI_STATE_INVALID,
  ATSPI_STATE_ACTIVE,
  ATSPI_STATE_ARMED,
  ATSPI_STATE_BUSY,
  ATSPI_STATE_CHECKED,
  ATSPI_STATE_COLLAPSED,
  ATSPI_STATE_DEFUNCT,
  ATSPI_STATE_EDITABLE,
  ATSPI_STATE_ENABLED,
  ATSPI_STATE_EXPANDABLE,
  ATSPI_STATE_EXPANDED,
  ATSPI_STATE_FOCUSABLE,
  ATSPI_STATE_FOCUSED,
  ATSPI_STATE_HAS_TOOLTIP,
  ATSPI_STATE_HORIZONTAL,
  ATSPI_STATE_ICONIFIED,
  ATSPI_STATE_MODAL,
  ATSPI_STATE_MULTI_LINE,
  ATSPI_STATE_MULTISELECTABLE,
  ATSPI_STATE_OPAQUE,
  ATSPI_STATE_PRESSED,
  ATSPI_STATE_RESIZABLE,
  ATSPI_STATE_SELECTABLE,
  ATSPI_STATE_SELECTED,
  ATSPI_STATE_SENSITIVE,
  ATSPI_STATE_SHOWING,
  ATSPI_STATE_SINGLE_LINE,
  ATSPI_STATE_STALE,
  ATSPI_STATE_TRANSIENT,
  ATSPI_STATE_VERTICAL,
  ATSPI_STATE_VISIBLE,
  ATSPI_STATE_MANAGES_DESCENDANTS,
  ATSPI_STATE_INDETERMINATE,
  ATSPI_STATE_REQUIRED,
  ATSPI_STATE_TRUNCATED,
  ATSPI_STATE_ANIMATED,
  ATSPI_STATE_INVALID_ENTRY,
  ATSPI_STATE_SUPPORTS_AUTOCOMPLETION,
  ATSPI_STATE_SELECTABLE_TEXT,
  ATSPI_STATE_IS_DEFAULT,
  ATSPI_STATE_VISITED,
  ATSPI_STATE_CHECKABLE,
  ATSPI_STATE_HAS_POPUP,
  ATSPI_STATE_READ_ONLY,
  ATSPI_STATE_LAST_DEFINED,
} AtspiStateType;

typedef enum {
  ATSPI_RELATION_NULL,
  ATSPI_RELATION_LABEL_FOR,
  ATSPI_RELATION_LABELLED_BY,
  ATSPI_RELATION_CONTROLLER_FOR,
  ATSPI_RELATION_CONTROLLED_BY,
  ATSPI_RELATION_MEMBER_OF,
  ATSPI_RELATION_TOOLTIP_FOR,
  ATSPI_RELATION_NODE_CHILD_OF,
  ATSPI_RELATION_NODE_PARENT_OF,
  ATSPI_RELATION_EXTENDED,
  ATSPI_RELATION_FLOWS_TO,
  ATSPI_RELATION_FLOWS_FROM,
  ATSPI_RELATION_SUBWINDOW_OF,
  ATSPI_RELATION_EMBEDS,
  ATSPI_RELATION_EMBEDDED_BY,
  ATSPI_RELATION_POPUP_FOR,
  ATSPI_RELATION_PARENT_WINDOW_OF,
  ATSPI_RELATION_DESCRIPTION_FOR,
  ATSPI_RELATION_DESCRIBED_BY,
  ATSPI_RELATION_DETAILS,
  ATSPI_RELATION_LAST_DEFINED,
} AtspiRelationType;

typedef enum {
  ATSPI_TEXT_BOUNDARY_CHAR,
  ATSPI_TEXT_BOUNDARY_WORD_START,
  ATSPI_TEXT_BOUNDARY_WORD_END,
  ATSPI_TEXT_BOUNDARY_SENTENCE_START,
  ATSPI_TEXT_BOUNDARY_SENTENCE_END,
  ATSPI_TEXT_BOUNDARY_LINE_START,
  ATSPI_TEXT_BOUNDARY_LINE_END,
} AtspiTextBoundaryType;

typedef enum {
  ATSPI_TEXT_GRANULARITY_CHAR,
  ATSPI_TEXT_GRANULARITY_WORD,
  ATSPI_TEXT_GRANULARITY_SENTENCE,
  ATSPI_TEXT_GRANULARITY_LINE,
  ATSPI_TEXT_GRANULARITY_PARAGRAPH
} AtspiTextGranularity;

typedef enum {
  ATSPI_COORD_TYPE_SCREEN,
  ATSPI_COORD_TYPE_WINDOW,
  ATSPI_COORD_TYPE_PARENT,
} AtspiCoordType;

typedef enum {
  ATSPI_COMPONENT_LAYER_INVALID,
  ATSPI_COMPONENT_LAYER_BACKGROUND,
  ATSPI_COMPONENT_LAYER_CANVAS,
  ATSPI_COMPONENT_LAYER_WIDGET,
  ATSPI_COMPONENT_LAYER_MDI,
  ATSPI_COMPONENT_LAYER_POPUP,
  ATSPI_COMPONENT_LAYER_OVERLAY,
  ATSPI_COMPONENT_LAYER_WINDOW
} AtspiComponentLayer;

typedef enum {
  ATSPI_SCROLL_TOP_LEFT,
  ATSPI_SCROLL_BOTTOM_RIGHT,
  ATSPI_SCROLL_TOP_EDGE,
  ATSPI_SCROLL_BOTTOM_EDGE,
  ATSPI_SCROLL_LEFT_EDGE,
  ATSPI_SCROLL_RIGHT_EDGE,
  ATSPI_SCROLL_ANYWHERE
} AtspiScrollType;

typedef struct _GtkAtSpiRoot    GtkAtSpiRoot;
typedef struct _GtkAtSpiCache   GtkAtSpiCache;
typedef struct _GtkAtSpiContext GtkAtSpiContext;

G_END_DECLS
