#include "obgtkCList.h"

@implementation Gtk_CList
- castGtkCList:(GtkCList *) castitem
{
  gtkclist = castitem;
  return [super castGtkContainer:GTK_CONTAINER(castitem)];
}

- initWithCListInfo:(gint) ncolumns
		   :(gchar **) column_titles
{
  return [self castGtkCList:GTK_CLIST(gtk_clist_new(ncolumns, column_titles))];
}

- set_border:(GtkShadowType) border
{
  gtk_clist_set_border(gtkclist, border);
}

- set_selection_mode:(GtkSelectionMode) mode
{
  gtk_clist_set_selection_mode(gtkclist, mode);
  return self;
}

- set_policy:(GtkPolicyType) vscrollbar_policy
	    :(GtkPolicyType) hscrollbar_policy
{
  gtk_clist_set_policy(gtkclist,
		       vscrollbar_policy,
		       hscrollbar_policy);
  return self;
}

- freeze
{
  gtk_clist_freeze(gtkclist);
  return self;
}

- thaw
{
  gtk_clist_thaw(gtkclist);
  return self;
}

- set_column_title:(gint) column
		  :(gchar *) title
{
  gtk_clist_set_column_title(gtkclist, column, title);
  return self;
}

- set_column_widget:(gint) column
		   :(Gtk_Widget *) widget
{
  gtk_clist_set_column_widget(gtkclist, column, widget->gtkwidget);
  return self;
}

- set_column_justification:(gint) column
			  :(GtkJustification) justification
{
  gtk_clist_set_column_justification(gtkclist, column, justification);
  return self;
}

- set_column_width:(gint) column
		  :(gint) width
{
  gtk_clist_set_column_width(gtkclist, column, width);
  return self;
}

- set_row_height:(gint) height
{
  gtk_clist_set_row_height(gtkclist, height);
  return self;
}

- moveto:(gint) row
	:(gint) column
	:(gfloat) row_align
	:(gfloat) col_align
{
  gtk_clist_moveto(gtkclist, row, column, row_align, col_align);
  return self;
}

- set_text:(gint) row
	  :(gint) column
	  :(gchar *) text
{
  gtk_clist_set_text(gtkclist, row, column, text);
  return self;
}

- set_pixmap:(gint) row
	    :(gint) column
	    :(GdkPixmap *) pixmap
	    :(GdkBitmap *) mask
{
  gtk_clist_set_pixmap(gtkclist, row, column, pixmap, mask);
  return self;
}

- set_pixtext:(gint) row
	     :(gint) column
	     :(gchar *) text
	     :(guint8) spacing
	     :(GdkPixmap *) pixmap
	     :(GdkBitmap *) mask
{
  gtk_clist_set_pixtext(gtkclist,
			row, column, text, spacing, pixmap, mask);
  return self;
}

- set_foreground:(gint) row
		:(GdkColor *) color
{
  gtk_clist_set_foreground(gtkclist, row, color);
  return self;
}

- set_background:(gint) row
		:(GdkColor *) color
{
  gtk_clist_set_background(gtkclist, row, color);
  return self;
}

- set_shift:(gint) row
	   :(gint) column
	   :(gint) vertical
	   :(gint) horizontal
{
  gtk_clist_set_shift(gtkclist, row, column, vertical, horizontal);
  return self;
}

- (gint)append:(gchar **) text
{
  return gtk_clist_append(gtkclist, text);
}

- insert:(gint) row
	:(gchar **) text
{
  gtk_clist_insert(gtkclist, row, text);
  return self;
}

- remove:(gint) row
{
  gtk_clist_remove(gtkclist, row);
  return self;
}

- set_row_data:(gint) row
	      :(gpointer) data
{
  gtk_clist_set_row_data(gtkclist, row, data);
  return self;
}

- (gpointer) get_row_data:(gint) row
{
  return gtk_clist_get_row_data(gtkclist, row);
}

- select_row:(gint) row
	    :(gint) column
{
  gtk_clist_select_row(gtkclist, row, column);
  return self;
}

- unselect_row:(gint) row
	      :(gint) column
{
  gtk_clist_unselect_row(gtkclist, row, column);
  return self;
}

- clear
{
  gtk_clist_clear(gtkclist);
  return self;
}
@end
