/* GnomENIUS Calculator
 * Copyright (C) 1997 George Lebl.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

%{
#include <gmp.h>
#include <glib.h>
#include "eval.h"
#include "dict.h"

extern evalstack_t evalstack;

#define PUSH_FUNC(ACT) t_push(makefuncb(ACT,&evalstack),&evalstack);
#define PUSH_DFUNC(FUNC) t_push(makefuncd(FUNC,&evalstack),&evalstack);
#define ADD_USERFUNC(ID,ARGS)					\
	{							\
		tree_t *n;					\
		n=t_pop(&evalstack);				\
		d_addfunc(d_makeufunc(ID,n,ARGS));		\
		t_push(copynode(n),&evalstack);			\
		g_free(ID);					\
	}

%}

%union {
	mpz_t ival;
	mpf_t fval;
	func_t *func;
	char *id;
}

%token <ival> NORMINT NEGNORMINT
%token <fval> FLOAT NEGFLOAT

/* functions have to have the number fo arguments figured out at parse time
   ... how would I put the type in here without bison barfing ... */
%token FUNCID0 FUNCID1 FUNCID2 FUNCID3 FUNCID4
%token FUNCID5 FUNCID6 FUNCID7 FUNCID8
%token UNKNOWNID

%token INFIX_EXPR POSTFIX_EXPR PREFIX_EXPR NEG

%left EQUALS
%left '+' '-'
%left '*' '/' '%'

%right NEG UMINUS '!'
%right '^'

%%

expr:		INFIX_EXPR inexpr
	|	POSTFIX_EXPR poexpr
	|	PREFIX_EXPR prexpr
	|	error { yyclearin; }
	;

inexpr:		UNKNOWNID EQUALS inexpr	{ ADD_USERFUNC($<id>1,0); }
	|	inexpr EQUALS inexpr	{ PUSH_FUNC(E_EQUALS); }
	|	inexpr '+' inexpr	{ PUSH_FUNC(E_PLUS); }
	|	inexpr '-' inexpr	{ PUSH_FUNC(E_MINUS); }
	|	inexpr '*' inexpr	{ PUSH_FUNC(E_MUL); }
	|	inexpr '/' inexpr	{ PUSH_FUNC(E_DIV); }
	|	inexpr '%' inexpr	{ PUSH_FUNC(E_MOD); }
	|	inexpr '!'		{ PUSH_FUNC(E_FACT); }
	| 	NEG inexpr 		{ PUSH_FUNC(E_NEG); }
	|	'-' inexpr %prec UMINUS	{ PUSH_FUNC(E_NEG); }
	| 	inexpr '^' inexpr	{ PUSH_FUNC(E_EXP); }
	|	infunc			{ PUSH_DFUNC($<func>1); }
	|	'(' inexpr ')'
	|	posnum
	;

infunc:		FUNCID0
			{ $<func>$ = $<func>1 }
	|	FUNCID0 '(' ')'
			{ $<func>$ = $<func>1 }
	|	FUNCID1 '(' inexpr ')'
			{ $<func>$ = $<func>1 }
	|	FUNCID2 '(' inexpr ',' inexpr ')'
			{ $<func>$ = $<func>1 }
	|	FUNCID3 '(' inexpr ',' inexpr ',' inexpr ')'
			{ $<func>$ = $<func>1 }
	|	FUNCID4 '(' inexpr ',' inexpr ',' inexpr ',' inexpr ')'
			{ $<func>$ = $<func>1 }
	|	FUNCID5 '(' inexpr ',' inexpr ',' inexpr ',' inexpr ','
			inexpr ')'
			{ $<func>$ = $<func>1 }
	|	FUNCID6 '(' inexpr ',' inexpr ',' inexpr ',' inexpr ','
			inexpr ',' inexpr ')'
			{ $<func>$ = $<func>1 }
	|	FUNCID7 '(' inexpr ',' inexpr ',' inexpr ',' inexpr ','
			inexpr ',' inexpr ',' inexpr ')'
			{ $<func>$ = $<func>1 }
	|	FUNCID8 '(' inexpr ',' inexpr ',' inexpr ',' inexpr ','
			inexpr ',' inexpr ',' inexpr ',' inexpr ')'
			{ $<func>$ = $<func>1 }
	;


poexpr:		UNKNOWNID poexpr EQUALS	{ ADD_USERFUNC($<id>1,0); }
	|	poexpr poexpr EQUALS	{ PUSH_FUNC(E_EQUALS); }
	|	poexpr poexpr '+'	{ PUSH_FUNC(E_PLUS); }
	|	poexpr poexpr '-'	{ PUSH_FUNC(E_MINUS); }
	|	poexpr poexpr '*'	{ PUSH_FUNC(E_MUL); }
	|	poexpr poexpr '/'	{ PUSH_FUNC(E_DIV); }
	|	poexpr poexpr '%'	{ PUSH_FUNC(E_MOD); }
	|	poexpr NEG		{ PUSH_FUNC(E_NEG); }
	|	poexpr '!'		{ PUSH_FUNC(E_FACT); }
	|	poexpr poexpr '^'	{ PUSH_FUNC(E_EXP); }
	|	'(' poexpr ')'
	|	pofunc			{ PUSH_DFUNC($<func>1); }
	|	num
	;

pofunc:		FUNCID0
			{ $<func>$ = $<func>1 }
	|	poexpr FUNCID1
			{ $<func>$ = $<func>2 }
	|	poexpr poexpr FUNCID2
			{ $<func>$ = $<func>3 }
	|	poexpr poexpr poexpr FUNCID3
			{ $<func>$ = $<func>4 }
	|	poexpr poexpr poexpr poexpr FUNCID4
			{ $<func>$ = $<func>5 }
	|	poexpr poexpr poexpr poexpr poexpr FUNCID5
			{ $<func>$ = $<func>6 }
	|	poexpr poexpr poexpr poexpr poexpr poexpr FUNCID6
			{ $<func>$ = $<func>7 }
	|	poexpr poexpr poexpr poexpr poexpr poexpr poexpr FUNCID7
			{ $<func>$ = $<func>8 }
	|	poexpr poexpr poexpr poexpr poexpr poexpr poexpr poexpr FUNCID8
			{ $<func>$ = $<func>9 }
	;

prexpr:		EQUALS UNKNOWNID prexpr	{ ADD_USERFUNC($<id>2,0); }
	|	EQUALS prexpr prexpr	{ PUSH_FUNC(E_EQUALS); }
	|	'+' prexpr prexpr	{ PUSH_FUNC(E_PLUS); }
	|	'-' prexpr prexpr	{ PUSH_FUNC(E_MINUS); }
	|	'*' prexpr prexpr	{ PUSH_FUNC(E_MUL); }
	|	'/' prexpr prexpr	{ PUSH_FUNC(E_DIV); }
	|	'%' prexpr prexpr	{ PUSH_FUNC(E_MOD); }
	|	NEG prexpr 		{ PUSH_FUNC(E_NEG); }
	|	'!' prexpr		{ PUSH_FUNC(E_FACT); }
	|	'^' prexpr prexpr	{ PUSH_FUNC(E_EXP); }
	|	prfunc			{ PUSH_DFUNC($<func>1); }
	|	'(' prexpr ')'
	|	num
	;

prfunc: 	FUNCID0
			{ $<func>$ = $<func>1 }
	|	FUNCID1 prexpr
			{ $<func>$ = $<func>1 }
	|	FUNCID2 prexpr prexpr
			{ $<func>$ = $<func>1 }
	|	FUNCID3 prexpr prexpr prexpr
			{ $<func>$ = $<func>1 }
	|	FUNCID4 prexpr prexpr prexpr prexpr
			{ $<func>$ = $<func>1 }
	|	FUNCID5 prexpr prexpr prexpr prexpr prexpr
			{ $<func>$ = $<func>1 }
	|	FUNCID6 prexpr prexpr prexpr prexpr prexpr prexpr
			{ $<func>$ = $<func>1 }
	|	FUNCID7 prexpr prexpr prexpr prexpr prexpr prexpr prexpr
			{ $<func>$ = $<func>1 }
	|	FUNCID8 prexpr prexpr prexpr prexpr prexpr prexpr prexpr prexpr
			{ $<func>$ = $<func>1 }
	;

num:		posnum
	|	negnum
	;

posnum:		NORMINT	{
				t_push(makenum_z($1),&evalstack);
				mpz_clear($1);
			}
	|	FLOAT	{
				t_push(makenum_f($1),&evalstack);
				mpf_clear($1);
			}
	;

negnum:		NEGNORMINT	{
				t_push(makenum_z($1),&evalstack);
				mpz_clear($1);
			}
	|	NEGFLOAT	{
				t_push(makenum_f($1),&evalstack);
				mpf_clear($1);
			}
	;

%%
