/* GnomeTalk: Get names interface module
 * (C) 1997 the Free Software Foundation
 *
 * Author: Federico Mena
 */

#include <netdb.h>
#include <netinet/in.h>
#include <pwd.h>
#include <string.h>
#include <sys/param.h>
#include <unistd.h>
#include "gnome.h"
#include "global.h"
#include "names.h"
#include "protocol.h"


static GtkWidget *dialog;
static GtkWidget *user_entry;
static GtkWidget *tty_check_button;
static GtkWidget *tty_entry;


static void
toggle_tty(GtkWidget *widget, gpointer *data)
{
	int active;

	active = GTK_TOGGLE_BUTTON(widget)->active;
	
	gtk_widget_set_sensitive(tty_entry, active);

	if (active)
		gtk_widget_grab_focus(tty_entry); /* this is a nicety */
}


static void
ok_callback(GtkWidget *widget, gpointer data)
{
	char *user, *tty;
	
	user = g_strdup(gtk_entry_get_text(GTK_ENTRY(user_entry)));

	if (GTK_TOGGLE_BUTTON(tty_check_button)->active)
		tty = g_strdup(gtk_entry_get_text(GTK_ENTRY(tty_entry)));
	else
		tty = NULL;
	
	gtk_widget_destroy(dialog);

	init_names(user, tty);
}


static void
cancel_callback(GtkWidget *widget, gpointer data)
{
	gtk_widget_destroy(dialog);
	gtk_main_quit();
}


void
get_names_from_user(void)
{
	GtkWidget *vbox;
	GtkWidget *aa;
	GtkWidget *table;
	GtkWidget *label;
	GtkWidget *button;

	dialog = gtk_dialog_new();
	gtk_window_position(GTK_WINDOW(dialog), GTK_WIN_POS_MOUSE);
	gtk_window_set_policy(GTK_WINDOW(dialog), FALSE, FALSE, TRUE);
	gtk_window_set_title(GTK_WINDOW(dialog), _("Talk to"));
	gtk_signal_connect(GTK_OBJECT(dialog), "delete_event",
			   (GtkSignalFunc) cancel_callback,
			   NULL);
	
	vbox = GTK_DIALOG(dialog)->vbox;
	aa = GTK_DIALOG(dialog)->action_area;

	table = gtk_table_new(2, 2, FALSE);
	gtk_container_border_width(GTK_CONTAINER(table), 6);
	gtk_table_set_row_spacings(GTK_TABLE(table), 4);
	gtk_table_set_col_spacings(GTK_TABLE(table), 4);
	gtk_box_pack_start(GTK_BOX(vbox), table, FALSE, FALSE, 0);
	gtk_widget_show(table);

	label = gtk_label_new(_("Talk to"));
	gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);
	gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 1, 0, 1);
	gtk_widget_show(label);

	user_entry = gtk_entry_new();
	gtk_table_attach_defaults(GTK_TABLE(table), user_entry, 1, 2, 0, 1);
	gtk_widget_show(user_entry);

	tty_check_button = gtk_check_button_new_with_label(_("Specify TTY"));
	gtk_table_attach_defaults(GTK_TABLE(table), tty_check_button, 0, 1, 1, 2);
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(tty_check_button), FALSE);
	gtk_signal_connect(GTK_OBJECT(tty_check_button), "toggled",
			   (GtkSignalFunc) toggle_tty,
			   NULL);
	gtk_widget_show(tty_check_button);

	tty_entry = gtk_entry_new();
	gtk_table_attach_defaults(GTK_TABLE(table), tty_entry, 1, 2, 1, 2);
	gtk_widget_set_sensitive(tty_entry, FALSE);
	gtk_widget_show(tty_entry);

	gtk_container_border_width(GTK_CONTAINER(aa), 6);

	button = gtk_button_new_with_label(_("Ok"));
	GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
	gtk_box_pack_start(GTK_BOX(aa), button, TRUE, TRUE, 0);
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
			   (GtkSignalFunc) ok_callback,
			   NULL);
	gtk_widget_grab_default(button);
	gtk_widget_show(button);

	button = gtk_button_new_with_label(_("Cancel"));
	GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
	gtk_box_pack_start(GTK_BOX(aa), button, TRUE, TRUE, 0);
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
			   (GtkSignalFunc) cancel_callback,
			   NULL);
	gtk_widget_show(button);

	gtk_widget_grab_focus(user_entry);
	gtk_widget_show(dialog);
}


static void
get_addrs(char *my_machine, char *his_machine)
{
	struct hostent *host;

	host = gethostbyname(my_machine);
	if (!host) {
		fprintf(stderr, "get_addrs: gethostbyname() failed for %s\n", my_machine);
		exit(1);
	}
	memcpy(&our_machine_addr.s_addr, host->h_addr, sizeof(our_machine_addr.s_addr));

	if (strcmp(my_machine, his_machine) != 0) {
		/* Lookup remote machine */

		host = gethostbyname(his_machine);
		if (!host) {
			fprintf(stderr, "get_addrs: gethostbyname() failed for %s\n", his_machine);
			exit(1);
		}
		memcpy(&his_machine_addr.s_addr, host->h_addr, sizeof(our_machine_addr.s_addr));
	} else
		his_machine_addr = our_machine_addr; /* same machine, so just copy addrs */
}


void
init_names(char *user, char *tty)
{
	char *me, *he;
	char  my_hostname[MAXHOSTNAMELEN];
	char *my_machine, *his_machine;
	struct passwd *pw;

	me = getlogin();
	if (!me || !me[0]) {
		pw = getpwuid(getuid());
		if (!pw) {
			fprintf(stderr, "init_names: Could not get username!\n");
			exit(1);
		}

		me = pw->pw_name;
	}

	gethostname(my_hostname, sizeof(my_hostname));
	my_machine = my_hostname;

	he = g_strdup(user);

	his_machine = strchr(he, '@');
	if (his_machine)
		*his_machine++ = 0; /* wipe and skip over @ */
	else
		his_machine = my_machine; /* local user */

	if (tty)
		his_tty = tty;
	else
		his_tty = "";

	our_name = me;
	his_name = user;

	get_addrs(my_machine, his_machine);
	
	create_connection(me, he, his_tty);
}
