/*
 * GULP: The Gnome printer controller
 *
 * Author: Elliot Lee (sopwith@cuc.edu)
 *
 */
#include <objc/Object.h>
#include "gPrint.h"
#include <stdio.h>

#include "gulp.h"

@implementation Gtk_MessageBox
- initWithLabel:(gchar *) label
{
	self = [super init];
	lbl_msg = [[[Gtk_Label alloc] initWithLabel:label] show];
	btn_ok = [[[Gtk_Button alloc] initWithLabel:"OK"] show];
	[vbox add:lbl_msg];
	[action_area add:btn_ok];
	[btn_ok connectObj:"clicked" :self];
	[self connect:"destroy"];
	return [self show];
}

- run
{
	gtk_grab_add(gtkwidget);
	return self;
}

- destroy:(id) obj
{
	gtk_grab_remove(gtkwidget);
	return [self free];
}

- clicked:(id) obj
{
	if (obj == btn_ok){
		gtk_grab_remove(gtkwidget);
		return [self free];
	}
	return self;
}

- free
{
	[btn_ok free];
	[lbl_msg free];
	return [super free];
}
@end

@implementation GULPMainWin
- menu_help_about:(id) anobj
{
  [[[Gtk_MessageBox alloc]
     initWithLabel:"\nGULP\n\n    Copyright (C) 1997 Elliot Lee <sopwith@redhat.com>.    \n\nLicensed under the GPL.\n"]
    run];
}

- menu_file_exit:(id) anobj
{
  [app quit];
}

- delete_event:(id) anobj
{
  [app quit];
  return (id)TRUE;
}
@end

@implementation GULPApp
- destroy:(id) obj
{
	gtk_main_quit();
	return self;
}

- toggled:(id) obj
{
#if 0
	if (dotogglehandler) {
		int opstatus = 0;
		id curprinter = nil;
		if(printerlist->gtklist->selection)
			curprinter =
				gtk_object_get_user_data(printerlist->gtklist->selection->data);
		
		if(curprinter == nil) {
			[[[Gtk_MessageBox alloc] initWithLabel:"You must select a printer"] run];
			return self;
		}
		if(obj == nb.printops.updown) {
			if(((Gtk_CheckButton*)obj)->gtktogglebutton->active)
				opstatus = [curprinter up];
			else
				opstatus = [curprinter down];
		} else if(obj == nb.printops.startstop) {
		  GtkLed *aled;
		  aled = gtk_object_get_data(printerlist->gtklist->selection->data, "led");
		  if(((Gtk_CheckButton*)obj)->gtktogglebutton->active) {
		    opstatus = [curprinter start];
		    if(!opstatus)
		      gtk_led_set_state(aled,
					GTK_STATE_PRELIGHT,
					TRUE);
		    
		  } else {
		    opstatus = [curprinter stop];
		    if(!opstatus)
		      gtk_led_set_state(aled, GTK_STATE_PRELIGHT, FALSE);
		  }
		}
		if(opstatus){
			[[[Gtk_MessageBox alloc] initWithLabel:"Operation failed"] run];
			dotogglehandler = 0;
			[(Gtk_CheckButton *)
			obj
			set_state:!((Gtk_CheckButton*)obj)->gtktogglebutton->active];
			dotogglehandler = 1;
		}
	}
#endif
	return self;
}

- clicked:(id) obj
{
	id curprinter = nil, tmp;
	int opstatus = 0;
#if 0	
	if (printerlist->gtklist->selection)
		curprinter = gtk_object_get_user_data(printerlist->gtklist->selection->data);
	
	if (curprinter == nil){
		[[[Gtk_MessageBox alloc] initWithLabel:"You must select a printer"] run];
		return self;
	}
	
	if (obj == nb.jobs.canceljob){
		if (nb.jobs.joblist->gtkclist->selection){
			tmp = gtk_object_get_data(nb.jobs.joblist->gtklist->selection->data,
						  "gulpJob");
			[tmp cancel];
			[self dojoblist];
		} else
			[[[Gtk_MessageBox alloc] initWithLabel:"You must select a job"] run];
	} else if(obj == nb.printops.clean)
		opstatus = [curprinter clean];
	else if(obj == nb.printops.restart)
		opstatus = [curprinter restart];
	else
		printf("Click on unknown widget\n");
	
	if(opstatus)
		[[[Gtk_MessageBox alloc] initWithLabel:"Operation failed"] run];
#endif	
	return self;
}

- selection_changed:(id) obj
{
#if 0
	if (obj == printerlist){
		/* We need to redisplay the jobs */
		id curprinter = nil;
		if(printerlist->gtklist->selection)
			curprinter = gtk_object_get_user_data(printerlist->gtklist->selection->data);
		
		[self dojoblist];
		dotogglehandler = 0;
		[nb.printops.updown set_state:[curprinter isUp]];
		[nb.printops.startstop set_state:[curprinter isStarted]];
		dotogglehandler = 1;
	}
#endif	
	return self;
}

- dojoblist
{
	GList *l;
	int i;
	Printer *newprt;
	char buf[255];

#if 0
	if(nb.jobs.joblist->gtklist->selection)
		[nb.jobs.joblist
		unselect_child:gtk_object_get_data(nb.jobs.joblist->gtklist->selection->data,"objc_id")];
	[[nb.jobs.joblist freeze] clear];
	
	if(!printerlist->gtklist->selection)
		return self;
	newprt = [(id)gtk_object_get_data(printerlist->gtklist->selection->data,
					  "objc_id") get_user_data];
	[newprt getJobs];
	
	nb.jobs.jobs = realloc(nb.jobs.jobs, (newprt->numjobs * sizeof(Gtk_List *)));
	
	for (i = 0; i < newprt->numjobs; i++){
	  char *vals[4];
	  vals[0] = [newprt->jobs[i] getJobID];
	  vals[1] = [newprt->jobs[i] getJobFilenames];
	  vals[2] = [newprt->jobs[i] getJobSize];
	  vals[3] = [newprt->jobs[i] getJobOwner];
	  [nb.jobs.joblist set_row_data:[nb.jobs.joblist append:vals]
	     :newprt->jobs[i]];
	}
#endif
	
	return self;
}

- initApp:(int *)argcp
	:(char ***)argvp
{
	int i;
	GList *anitem = NULL;
	GnomeMenuInfo filemenu[] = {
	  {GNOME_APP_MENU_ITEM, "Exit", "menu_file_exit", NULL},
	  {GNOME_APP_MENU_ENDOFINFO, NULL, NULL, NULL}
	};
	GnomeMenuInfo helpmenu[] = {
	  {GNOME_APP_MENU_ITEM, "About", "menu_help_about", NULL},
	  {GNOME_APP_MENU_ENDOFINFO, NULL, NULL, NULL}
	};
	GnomeMenuInfo mainmenu[] = {
	  {GNOME_APP_MENU_SUBMENU, "File", &filemenu, NULL},
	  {GNOME_APP_MENU_SUBMENU, "Help", &helpmenu, NULL},	  
	  {GNOME_APP_MENU_ENDOFINFO, NULL, NULL, NULL}
	};
	
	self = [super initApp:argcp :argvp];

	dotogglehandler = 1;
	printsys = [PrintSystem new];
	if(![printsys exists]) {
	    [[[Gtk_MessageBox alloc] initWithLabel:"Printing system not installed"] run];
	    g_print("Printing system not installed\n");
	    [printsys free];
	    [super free];
	    return nil;
	}
	mainwin = [[GULPMainWin alloc]
		    initWithAppWinInfo:"gulp" : "GNOME Unified Link to Printers"];
	mainwin->app = self;
	vbox = [[[Gtk_VBox alloc] initWithBoxInfo:0 setSpacing:5] show];

	[mainwin create_menus:mainmenu];

	[mainwin connect:"delete_event"];
	printers = malloc(sizeof(Gtk_ListItem *) * printsys->numprinters);
	leds = malloc(sizeof(Gtk_Misc *) * printsys->numprinters);
	lbls = malloc(sizeof(Gtk_Label *) * printsys->numprinters);
	printerlist = [[[Gtk_List alloc] init] show];
	
	for (i = 0; i < printsys->numprinters; i++){
	  lbls[i] = [[[Gtk_Label alloc] initWithLabel:[printsys->printers[i] getQueueName]] show];
	  leds[i] = [[[Gtk_Misc alloc] castGtkMisc:GTK_MISC(gtk_led_new())] show];
	  gtk_led_set_state(GTK_LED(leds[i]->gtkmisc), GTK_STATE_PRELIGHT,
			    [printsys->printers[i] isUp]);
	  printers[i] = [[[Gtk_ListItem alloc]
			   init] show];
	  [printers[i] set_data:"led" :(leds[i]->gtkmisc)];
	  [printers[i] add:[[[[Gtk_HBox new] show]
			     pack_start_defaults:leds[i]]
			     pack_start_defaults:lbls[i]]
		   ];
	  [printers[i] set_user_data:printsys->printers[i]];
	  anitem = g_list_append(anitem, (gpointer) printers[i]->gtkwidget);
	}
	
	[printerlist append_items:anitem];
	[printerlist set_usize:100 height:50];
	[printerlist connectObj:"selection_changed" :self];

	[vbox pack_start_defaults:printerlist];
	[vbox pack_start_defaults:[[Gtk_HSeparator new] show]];
  
	nb.jobs.page = [[[Gtk_VBox alloc] initWithBoxInfo:TRUE setSpacing:0] show];
	{
	  char *collist[] = {
	    "Job ID",
	    "Filenames",
	    "Owner",
	    "Size"
	  };
	  nb.jobs.joblist = [[[Gtk_CList alloc] initWithCListInfo:4
						:collist] show];
	}
	nb.jobs.canceljob = [[[[Gtk_Button alloc] initWithLabel:"Cancel"] show]
			    connectObj:"clicked" :self];
	[nb.jobs.page add:nb.jobs.joblist];
	[nb.jobs.page add:nb.jobs.canceljob];

	nb.printops.page = [[[Gtk_HBox alloc] initWithBoxInfo:TRUE setSpacing:0] show];
	nb.printops.updown = [[[[Gtk_CheckButton alloc] initWithLabel:"Queueing"] show]
			     connectObj:"toggled" :self];
	nb.printops.clean = [[[[Gtk_Button alloc] initWithLabel:"Clear Queue"] show]
			    connectObj:"clicked" :self];
	nb.printops.restart = [[[[Gtk_Button alloc] initWithLabel:"Restart"] show]
			      connectObj:"clicked" :self];
	nb.printops.startstop = [[[[Gtk_CheckButton alloc] initWithLabel:"Printing"] show]
				connectObj:"toggled" :self];
	[nb.printops.page add:nb.printops.updown];
	[nb.printops.page add:nb.printops.clean];
	[nb.printops.page add:nb.printops.restart];
	[nb.printops.page add:nb.printops.startstop];       

	[vbox add:nb.printops.page];
	[vbox add:nb.jobs.page];
	[mainwin set_contents:vbox];
	[mainwin show];
	return self;
}

- free
{
	int i;

#if 0
	for (i = 0; i < printsys->numprinters; i++) {
	  [printers[i] free];
	}
#endif

	free(printers);
	g_print("Freeing mainwin\n");
	[mainwin free];
	g_print("Freed mainwin\n");
	[printsys free];

	return [super free];
}
@end

int main(int argc, char *argv[])
{
	id myapp = [GULPApp alloc];
	[myapp initApp:&argc :&argv];
	[myapp run];
	[myapp free];
	return 0;
}
