/*
 * GULP: The Gnome printer controller
 *
 * Authors: Elliot Lee (sopwith@cuc.edu)
 *          Federico Mena (federico@nuclecu.unam.mx)
 *
 */
#include <objc/Object.h>
#include "gPrint.h"
#include <stdio.h>
#include "yes.xpm"
#include "no.xpm"

#include "gulp.h"

@implementation Gtk_MessageBox
- initWithLabel:(gchar *) label
{
  id align;
  
  self = [super init];

  align = [[[Gtk_Alignment alloc] initWithAlignmentInfo:0.5 alignY:0.5 scaleX:0.0 scaleY:0.0] show];
  lbl_msg = [[[Gtk_Label alloc] initWithLabel:label] show];
  btn_ok = [[[Gtk_Button alloc] initWithLabel:"OK"] show];

  [align border_width:8];

  [vbox add:align];
  [align add:lbl_msg];
  [action_area add:btn_ok];
  [btn_ok connectObj:"clicked" :self];
  [self connect:"destroy"];
  return [self show];
}

- run
{
  gtk_grab_add(gtkwidget);
  return self;
}

- destroy:(id) obj
{
  gtk_grab_remove(gtkwidget);
  return [self free];
}

- clicked:(id) obj
{
  if (obj == btn_ok)
    {
      gtk_grab_remove(gtkwidget);
      return [self free];
    }
  return self;
}

- free
{
  [btn_ok free];
  [lbl_msg free];
  return [super free];
}
@end

@implementation GULPMainWin
- menu_help_about:(id) anobj
{
  [[[Gtk_MessageBox alloc]
     initWithLabel:("GNOME Unified Link to Printers\n\n"
		    "Copyright (C) 1997 Elliot Lee <sopwith@redhat.com>\n"
		    "Copyright (C) Federico Mena <federico@nuclecu.unam.mx>\n"
		    "Licensed under the GPL")]
    run];
}

- menu_file_exit:(id) anobj
{
  [app quit];
}

- delete_event:(id) anobj
{
  [app quit];
  return (id)TRUE;
}

@end

@implementation GULPApp

- destroy:(id) obj
{
  gtk_main_quit();
  return self;
}

- toggled:(id) obj
{
  int opstatus = 0;
  id curprinter = nil;

  if (!dotogglehandler)
    return self;

  if (printer_list->gtkclist->selection)
    curprinter = ((GtkCListRow *) (printer_list->gtkclist->selection->data))->data;
  
  if (curprinter == nil)
    {
      [[[Gtk_MessageBox alloc]
	 initWithLabel:"You must select a printer"]
	run];
      return self;
    }
    
  if (obj == queueing)
    {
      [self set_wait_cursor:TRUE];
      
      if (((Gtk_CheckButton *) obj)->gtktogglebutton->active)
	opstatus = [curprinter up];
      else
	opstatus = [curprinter down];

      [self set_wait_cursor:FALSE];
    }
  else if (obj == printing)
    {
      [self set_wait_cursor:TRUE];
      
      if (((Gtk_CheckButton *) obj)->gtktogglebutton->active)
	opstatus = [curprinter start];
      else
	opstatus = [curprinter stop];

      [self set_wait_cursor:FALSE];
    }

  /* Let user know about any errors that happened */
  if (opstatus)
    {
      [[[Gtk_MessageBox alloc] initWithLabel:"Operation failed"] run];
      dotogglehandler = 0;
      [(Gtk_CheckButton *) obj
			   set_state:!((Gtk_CheckButton *) obj)->gtktogglebutton->active];
      dotogglehandler = 1;
    }

  [self do_printer_list];

  return self;
}

- clicked:(id) obj
{
  id curprinter = nil, tmp;
  int opstatus = 0;

  if (printer_list->gtkclist->selection)
    curprinter = ((GtkCListRow *) (printer_list->gtkclist->selection->data))->data;

  if (curprinter == nil)
    {
      [[[Gtk_MessageBox alloc]
	 initWithLabel:"You must select a printer"] run];
      return self;
    }
	
  if (obj == cancel_job)
    {
      if (job_list->gtkclist->selection)
	{
	  GList *anitem;
	  for (anitem = job_list->gtkclist->selection; anitem; anitem = anitem->next)
	    {
	      tmp = ((GtkCListRow *) anitem->data)->data;
	      [self set_wait_cursor:TRUE];
	      [tmp cancel];
	      [self set_wait_cursor:FALSE];
	    }
	}
      else
	[[[Gtk_MessageBox alloc] initWithLabel:"You must select a job"] run];
    }
  else if (obj == clear_queue)
    {
      [self set_wait_cursor:TRUE];
      opstatus = [curprinter clean];
      [self set_wait_cursor:FALSE];
    }
  else if (obj == restart)
    {
      [self set_wait_cursor:TRUE];
      opstatus = [curprinter restart];
      [self set_wait_cursor:FALSE];
    }
  else
    printf("Click on unknown widget\n");
	
  if (opstatus)
    [[[Gtk_MessageBox alloc] initWithLabel:"Operation failed"] run];

  [[self do_printer_list] do_job_list];

  dotogglehandler = 0;
  [self set_wait_cursor:TRUE];
  [queueing set_state:[curprinter isUp]];
  [printing set_state:[curprinter isStarted]];
  [self set_wait_cursor:FALSE];
  dotogglehandler = 1;

  return self;
}

- select_row:(id) obj
{
  if (obj == printer_list && doselecthandler)
    [self do_job_list];

  return self;
}

- do_job_list
{
  GList *l;
  int i;
  Printer *newprt;
  char idbuf[30], sizebuf[10];
  gchar *vals[4];
  gchar *collist[] = {
    "Job ID",
    "Filenames",
    "Size",
    "Owner"
  };
  int oldoffset = -1;
  GList *anitem;

  [self set_wait_cursor:TRUE];

  if (job_list)
    {
      if (job_list->gtkclist->selection)
	{
	  for (i = 0, anitem = job_list->gtkclist->row_list; anitem; i++, anitem = anitem->next)
	    if (anitem->data == job_list->gtkclist->selection->data)
	      {
		oldoffset = i;
		g_print("oldoffset for job_list is %d\n",
			oldoffset);
		break;
	      }
	}
      
      [[job_list freeze] clear];
    }
  else
    {
      job_list = [[[[Gtk_CList alloc] initWithCListInfoTitles:4 Titles:collist] show] freeze];
      [job_list set_policy:GTK_POLICY_ALWAYS :GTK_POLICY_AUTOMATIC];
      [job_list set_selection_mode:GTK_SELECTION_BROWSE];
      [job_list set_column_width:0 :40];
      [job_list set_column_width:1 :200];
      [job_list set_column_width:2 :40];
    }

  if (!printer_list->gtkclist->selection)
    {
      [self set_wait_cursor:FALSE];
      return self;
    }

  newprt = ((GtkCListRow *) printer_list->gtkclist->selection->data)->data;
  [newprt getJobs];

  dotogglehandler = FALSE;
  [queueing set_state:[newprt isUp]];
  [printing set_state:[newprt isStarted]];
  dotogglehandler = TRUE;

  vals[0] = idbuf;
  vals[2] = sizebuf;

  if (newprt->numjobs == 0)
    [cancel_job set_sensitive:FALSE];
  else
    [cancel_job set_sensitive:TRUE];

  for (i = 0; i < newprt->numjobs; i++)
    {
      sprintf(vals[0], "%d", [newprt->jobs[i] getJobID]);
      vals[1] = (char *) [newprt->jobs[i] getJobFilenames];
      sprintf(vals[2], "%d", [newprt->jobs[i] getJobSize]);
      vals[3] = (char *) [newprt->jobs[i] getJobOwner];
      [job_list set_row_data:[job_list appendCListRow:vals] :newprt->jobs[i]];
    }

  if (oldoffset >= 0)
    [job_list select_row:oldoffset :0];
  [job_list thaw];

  [self set_wait_cursor:FALSE];

  return self;
}

- do_printer_list
{
  gchar *columns[] = {
    "Printer",
    "Jobs",
    "Queueing",
    "Printing"
  };
  gchar *tmp;
  Printer *cp;
  int i, cnt;
  int oldoffset = -1;
  GList *anitem;
  id printer;

  [self set_wait_cursor:TRUE];

  doselecthandler = FALSE;
  if (printer_list)
    {
      if (printer_list->gtkclist->selection)
	{
	  for (i = 0, anitem = printer_list->gtkclist->row_list; anitem; i++, anitem = anitem->next)
	    if (anitem->data == printer_list->gtkclist->selection->data)
	      {
		oldoffset = i;
		g_print("oldoffset for printer_list is %d\n",
			oldoffset);
		break;
	      }
	}
      
      [[printer_list freeze] clear];
    }
  else
    {
      printer_list = [[[[Gtk_CList alloc] initWithCListInfoTitles:4 Titles:columns] show] freeze];
      [printer_list set_policy:GTK_POLICY_ALWAYS :GTK_POLICY_AUTOMATIC];
      [printer_list set_selection_mode:GTK_SELECTION_BROWSE];
      [printer_list connectObj:"select_row" :self];
    }

  tmp = g_malloc(10);

  for (cnt = 0; cnt < printsys->numprinters; cnt++)
    {
      i = [printer_list appendCListRow:columns];
      g_print("Doing row %d\n", i);
      cp = printsys->printers[cnt];

      [printer_list set_text:i :0 :(char *) [[cp getJobs] getQueueName]];
      g_snprintf(tmp, 10, "%d", cp->numjobs);
      [printer_list set_text:i :1 :tmp];

      if ([cp isUp])
	[printer_list set_pixmap:i :2 :yes_pixmap :yes_mask];
      else
	[printer_list set_pixmap:i :2 :no_pixmap :no_mask];

      if ([cp isStarted])
	[printer_list set_pixmap:i :3 :yes_pixmap :yes_mask];
      else
	[printer_list set_pixmap:i :3 :no_pixmap :no_mask];
      g_print("Setting row data %d to %#x\n", i, cp);
      [printer_list set_row_data:i :cp];
    }
  g_free(tmp);

  if (oldoffset >= 0)
    {
      [printer_list select_row:oldoffset :0];

      printer = ((GtkCListRow *) printer_list->gtkclist->selection->data)->data;

      dotogglehandler = FALSE;
      [queueing set_state:[printer isUp]];
      [printing set_state:[printer isStarted]];
      dotogglehandler = TRUE;
    }

  [printer_list thaw];
  doselecthandler = TRUE;

  [self set_wait_cursor:FALSE];

  return self;
}

/* Probably should have subclassed the Gnome_AppWin widget and
   done everything in there, so sue me */
- initApp:(int *)argcp
	 :(char ***)argvp
{
  int i;
  id  table;
  id  label;
  id  vbox;

  GList *anitem = NULL;
  GnomeMenuInfo filemenu[] = {
    { GNOME_APP_MENU_ITEM, "Exit", "menu_file_exit", NULL },
    { GNOME_APP_MENU_ENDOFINFO, NULL, NULL, NULL }
  };
  GnomeMenuInfo helpmenu[] = {
    { GNOME_APP_MENU_ITEM, "About", "menu_help_about", NULL },
    { GNOME_APP_MENU_ENDOFINFO, NULL, NULL, NULL }
  };
  GnomeMenuInfo mainmenu[] = {
    { GNOME_APP_MENU_SUBMENU, "File", &filemenu, NULL },
    { GNOME_APP_MENU_SUBMENU, "Help", &helpmenu, NULL },
    { GNOME_APP_MENU_ENDOFINFO, NULL, NULL, NULL }
  };
	
  self = [super initApp:argcp :argvp];

  dotogglehandler = doselecthandler = TRUE;
  printer_list = nil;
  job_list = nil;
  printsys = [PrintSystem new];

  if (![printsys exists])
    {
      [[[Gtk_MessageBox alloc] initWithLabel:"Printing system not installed"] run];
      g_print("Printing system not installed\n");
      [printsys free];
      [super free];
      return nil;
    }

  wait_cursor = gdk_cursor_new(GDK_WATCH);

  mainwin = [[GULPMainWin alloc] initWithAppWinInfo:"gulp" : "GNOME Unified Link to Printers"];

  [mainwin set_usize:550 height:400];
  mainwin->app = self;

  /* Pixmaps */

  [mainwin realize];

  yes_pixmap = gdk_pixmap_create_from_xpm_d(mainwin->gtkwidget->window,
					    &yes_mask,
					    &mainwin->gtkwidget->style->white,
					    yes_xpm);
  no_pixmap = gdk_pixmap_create_from_xpm_d(mainwin->gtkwidget->window,
					   &no_mask,
					   &mainwin->gtkwidget->style->white,
					   no_xpm);

  /* Printer queues */

  table = [[[Gtk_Table alloc] initWithTableInfo:4 cntCols:2 isHomo:FALSE] border_width:6];
  [table set_col_spacing:0 Spacing:4];
  [table set_row_spacing:1 Spacing:4];
  [table show];
  [mainwin set_contents:table];

  label = [[[[Gtk_Label alloc] initWithLabel:"Printer queues"]
	     set_alignment:0.0 alignY:0.5] show];
  [table attach:label
	 attachLeft:0 attachRight:1 attachTop:0 attachBottom:1
	 optionsX:(GTK_EXPAND | GTK_FILL) optionsY:0
	 paddingX:0 paddingY:0];

  [self do_printer_list];
  [table attach:printer_list
	 attachLeft:0 attachRight:1 attachTop:1 attachBottom:2
	 optionsX:(GTK_EXPAND | GTK_FILL) optionsY:(GTK_EXPAND | GTK_FILL)
	 paddingX:0 paddingY:0];

  vbox = [[[Gtk_VBox alloc] initWithBoxInfo:FALSE setSpacing:4] show];
  [table attach:vbox
	 attachLeft:1 attachRight:2 attachTop:1 attachBottom:2
	 optionsX:(GTK_FILL | GTK_SHRINK) optionsY:(GTK_EXPAND | GTK_FILL)
	 paddingX:0 paddingY:0];

  queueing    = [[[[Gtk_CheckButton alloc] initWithLabel:"Queueing"] show] connectObj:"toggled" :self];
  printing    = [[[[Gtk_CheckButton alloc] initWithLabel:"Printing"] show] connectObj:"toggled" :self];
  clear_queue = [[[[Gtk_Button alloc]      initWithLabel:"Clear queue"] show] connectObj:"clicked" :self];
  restart     = [[[[Gtk_Button alloc]      initWithLabel:"Restart daemon"] show] connectObj:"clicked" :self];

  [vbox pack_start:queueing doExpand:FALSE doFill:FALSE doPadding:0];
  [vbox pack_start:printing doExpand:FALSE doFill:FALSE doPadding:0];
  [vbox pack_start:clear_queue doExpand:FALSE doFill:FALSE doPadding:0];
  [vbox pack_start:restart doExpand:FALSE doFill:FALSE doPadding:0];

  /* Disable these buttons if we are not root */

  if (getuid() != 0)
    [vbox set_sensitive:FALSE];

  /* Jobs */

  label = [[[[Gtk_Label alloc] initWithLabel:"Jobs for selected printer"]
	     set_alignment:0.0 alignY:0.5] show];
  [table attach:label
	 attachLeft:0 attachRight:1 attachTop:2 attachBottom:3
	 optionsX:(GTK_EXPAND | GTK_FILL) optionsY:0
	 paddingX:0 paddingY:0];

  [self do_job_list];
  [table attach:job_list
	 attachLeft:0 attachRight:1 attachTop:3 attachBottom:4
	 optionsX:(GTK_EXPAND | GTK_FILL) optionsY:(GTK_EXPAND | GTK_FILL)
	 paddingX:0 paddingY:0];

  vbox = [[[Gtk_VBox alloc] initWithBoxInfo:FALSE setSpacing:4] show];
  [table attach:vbox
	 attachLeft:1 attachRight:2 attachTop:3 attachBottom:4
	 optionsX:(GTK_FILL | GTK_SHRINK) optionsY:(GTK_EXPAND | GTK_FILL)
	 paddingX:0 paddingY:0];

  cancel_job = [[[[Gtk_Button alloc] initWithLabel:"Cancel job"] show] connectObj:"clicked" :self];

  [vbox pack_start:cancel_job doExpand:FALSE doFill:FALSE doPadding:0];

  [mainwin create_menus:mainmenu];
  gtk_menu_item_right_justify(GTK_MENU_ITEM(mainmenu[1].widget));

  [mainwin connect:"delete_event"];
  [mainwin show];

  return self;
}

- free
{
  int i;
  
  [mainwin free];
  [printsys free];

  gdk_cursor_destroy(wait_cursor);
  
  return [super free];
}

- set_wait_cursor:(gint) wait
{
  if (GTK_WIDGET_REALIZED(mainwin->gtkwidget))
    {
      if (wait)
	gdk_window_set_cursor(mainwin->gtkwidget->window, wait_cursor);
      else
	gdk_window_set_cursor(mainwin->gtkwidget->window, NULL);

      gdk_flush();
    }
}

@end

int main(int argc, char *argv[])
{
  id myapp = [GULPApp alloc];
  [myapp initApp:&argc :&argv];
  [myapp run];
  [myapp free];
  return 0;
}

