#include "obgnomeAppWin.h"

static void
obgnome_do_signal_connection(GnomeApp *app,
			     GnomeUIInfo *info_item,
			     gchar *signal_name,
			     GnomeUIBuilderData uidata)
{
  /* Copied almost verbatrim from obgtk/obgtkObject.m - connectObj */
  gchar *datid;
  int i;
  GString *foo;
  GtkSignalQuery *siginfo;
  ObgtkRelayInfo mydata;

  siginfo = gtk_signal_query(gtk_signal_lookup(signal_name,
						GTK_OBJECT(info_item->widget)->klass->type));
  if(!siginfo)
    {
      g_warning("obgnome_do_signal_connection: Couldn't lookup signale %s\n", signal_name);
      return;
    }

  foo = g_string_new(info_item->moreinfo);

  mydata = g_new(struct _ObgtkRelayInfo, 1);
  mydata->object = uidata->data;
  g_string_append_c(foo, ':'); /* For signalled object parameter */
  for(i = 0; i < siginfo->nparams; i++)
    g_string_append_c(foo, ':'); /* For other gtk-specific params */
  mydata->method = sel_get_uid(foo->str);
  g_string_free(foo, TRUE);
  g_free(siginfo);
  gtk_signal_connect_interp(info_item->widget,
			    signal_name,
			    uidata->relay_func,
			    mydata,
			    uidata->destroy_func,
			    FALSE);
}

@implementation Gnome_AppWin
- initWithAppWinInfo:(char *) name
                    :(char *) title
{
  return [self castGnomeApp:GNOME_APP(gnome_app_new(name, title))];
}

- castGnomeApp:(GnomeApp *) castitem
{
  gnomeapp = castitem;
  return [super castGtkWindow:GTK_WINDOW(castitem)];
}

/* Need to find a way to make these send ObjC messages */

- create_menus:(GnomeUIInfo *) menuinfo
{
  struct _GnomeUIBuilderData uibdata =
  {
    GNOME_UISIGFUNC(obgnome_do_signal_connection),
    self,
    TRUE,
    (GtkCallbackMarshal)obgtk_signal_relay,
    g_free
  };

  gnome_app_create_menus_custom(gnomeapp,
				menuinfo,
				&uibdata);
  return self;
}

- create_toolbar:(GnomeUIInfo *) tbinfo
{
  struct _GnomeUIBuilderData uibdata =
  {
    GNOME_UISIGFUNC(obgnome_do_signal_connection),
    self,
    TRUE,
    (GtkCallbackMarshal)obgtk_signal_relay,
    g_free
  };

  gnome_app_create_toolbar_custom(gnomeapp,
				  tbinfo,
				  &uibdata);
  return self;
}

- set_menus:(Gtk_MenuBar *) setmenubar
{
  menubar = setmenubar;
  gnome_app_set_menus(gnomeapp, menubar->gtkmenubar);
  return self;
}

- set_toolbar:(Gtk_Toolbar *) settoolbar
{
  toolbar = settoolbar;
  gnome_app_set_toolbar(gnomeapp, toolbar->gtktoolbar);
  return self;
}

- set_contents:(Gtk_Widget *) setcontents
{
  contents = setcontents;
  gnome_app_set_contents(gnomeapp, setcontents->gtkwidget);
  return self;
}

- set_menubar_position:(GnomeAppWidgetPositionType) pos_menubar
{
  gnome_app_menu_set_position(gnomeapp, pos_menubar);
  return self;
}

- set_toolbar_position:(GnomeAppWidgetPositionType) pos_toolbar
{
  gnome_app_toolbar_set_position(gnomeapp, pos_toolbar);
  return self;
}

@end
