#include "obgtk.h"

@implementation Gtk_Window
- castGtkWindow:(GtkWindow *) castitem
{
  gtkwindow = castitem;
  return [super castGtkBin:(GtkBin *) castitem];
}

- initWithWindowType:(GtkWindowType) wintype
{
  gtkwindow = GTK_WINDOW(gtk_window_new(wintype));
  return [super castGtkBin:(GtkBin *) gtkwindow];
}

- init
{
  return [self initWithWindowType:GTK_WINDOW_TOPLEVEL];
}


- set_title:(gchar *) title
{
  gtk_window_set_title(gtkwindow, title);
  return self;
}

- set_focus:(Gtk_Widget *) focus
{
  gtk_window_set_focus(gtkwindow, focus->gtkwidget);
  return self;
}

- set_default:(Gtk_Widget *) defaultw
{
  gtk_window_set_default(gtkwindow, defaultw->gtkwidget);
  return self;
}

- set_policy:
allowShrink:(gint) allow_shrink
allowGrow:(gint) allow_grow
autoShrink:(gint) auto_shrink
{
  gtk_window_set_policy(gtkwindow, allow_shrink, allow_grow, auto_shrink);
  return self;
}

- add_accelerator_table:(Gtk_AcceleratorTable *) table
{
  gtk_window_add_accelerator_table(gtkwindow, table->gtkacceleratortable);
  return self;
}

- remove_accelerator_table:(Gtk_AcceleratorTable *) table
{
  gtk_window_remove_accelerator_table(gtkwindow,
				      table->gtkacceleratortable);
  return self;
}

- position:(GtkWindowPosition) position
{
  gtk_window_position(gtkwindow, position);
  return self;
}

@end
