/*
 * $Id: sql_interface.c,v 1.12 1998/05/25 18:32:03 gregm Exp $
 * GXSNMP -- An snmp mangament application
 * Copyright (C) 1998 Gregory McLean
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc.,  59 Temple Place - Suite 330, Cambridge, MA 02139, USA.
 *
 * SQL interfacing code.
 */
#ifndef lint
static char const copyright[] =
"@(#) Copyright (c) 1998 Gregory McLean";
#endif
static char const rcsid[] =
"$Id: sql_interface.c,v 1.12 1998/05/25 18:32:03 gregm Exp $";

#include "main.h"
#ifdef HAVE_SQL
#include <mysql/mysql.h>
#endif

/*
 * Local module variables
 */

/*
 * Global varibles
 */

extern gxsnmp *app_info;

/*
 * Global Functions
 */
char *
sql_server_status (sql_server *server)
{
  char            *retval;
#ifdef HAVE_SQL
  MYSQL           *sql;
  char            *tmp;
  
  sql = (MYSQL *)g_malloc (sizeof(MYSQL));

  mysql_connect (sql, 
		 server->sql_host,
		 server->sql_user,
		 server->sql_pass);
  tmp = mysql_stat (sql);
  retval = g_strdup (tmp);
  mysql_close (sql);
  g_free (sql);
  return retval;
#else
  retval = g_strdup ("Sql support was not enabled.");
  return retval;
#endif
}

GList *
sql_db_list (sql_server *server)
{
#ifdef HAVE_SQL
  GList     *db_list;
  MYSQL     *sql;
  MYSQL_RES *sql_res;
  MYSQL_ROW row;

  sql = (MYSQL *)g_malloc (sizeof(MYSQL));
  if (mysql_connect (sql, 
		     server->sql_host,
		     server->sql_user,
		     server->sql_pass))
    {
      sql_res = mysql_use_result (sql);
      sql_res = mysql_list_dbs (sql, "");
      while ( (row = mysql_fetch_row(sql_res)) )
	{
	  db_list = g_list_append (db_list, row[0]);
	}
      mysql_free_result (sql_res);
      mysql_close (sql);
      g_free (sql);
    }
  if (g_list_length (db_list) > 0)
    return db_list;
  else
    return NULL;
#else
  return NULL;
#endif
}

gboolean
sql_check_db (sql_server *server, gchar *db)
{
#ifdef HAVE_SQL
  MYSQL    *sql;
  
  sql = (MYSQL *)g_malloc (sizeof (MYSQL));
  if (mysql_connect (sql,
		     server->sql_host,
		     server->sql_user,
		     server->sql_pass))
    {
      if (mysql_select_db (sql, db))
	{
	  mysql_close (sql);
	  g_free (sql);
	  return TRUE;
	}
    }
  return FALSE;
#endif
}

gboolean
sql_create_db (sql_server *server, gchar *db)
{
#ifdef HAVE_SQL
  MYSQL      *sql;

  sql = (MYSQL *)g_malloc (sizeof (MYSQL));
  if (mysql_connect (sql,
		     server->sql_host,
		     server->sql_user,
		     server->sql_pass))
    {
      if ( (mysql_select_db (sql, db)) < 0)
	{
	  /* its not there so go ahead and create it */
	  if ( (mysql_create_db (sql, db)) < 0)
	    {
	      /* Couldn't create the db */
	      g_print (mysql_error(sql));
	      mysql_close (sql);
	      g_free (sql);
	      return FALSE;
	    }
	  else
	    {
	      mysql_close (sql);
	      g_free (sql);
	      return TRUE;
	    }
	}
      /* Database is aready present */
      mysql_close (sql);
      g_free (sql);
    }
#endif
  return FALSE;
}

gboolean
sql_drop_db (sql_server *server, gchar *db)
{
#ifdef HAVE_SQL
  MYSQL     *sql;
  
  sql = (MYSQL *)g_malloc (sizeof (MYSQL));
  if (sql)
    {
      if (sql = mysql_connect (sql,
			   server->sql_host,
			   server->sql_user,
			   server->sql_pass))
	{
	  if (mysql_select_db (sql, db))
	    {
	      if (mysql_drop_db (sql, db))
		{
		  mysql_close (sql);
		  g_free (sql);
		  return TRUE;
		}
	    }
	  mysql_close (sql);
	}
      g_free (sql);
    }
#endif
  return FALSE;
}
/*
 * Add a host to the host table in the sql database
 */
gboolean
sql_add_host_entry (sql_server *server, hosts *host)
{
#ifdef HAVE_SQL
  MYSQL     *sql;
  char      query[2048];
  char      datebuf[20];
  struct tm *tim;
  time_t    gm_time;
  int       foo;

  sql = (MYSQL *)g_malloc (sizeof (MYSQL));
  if (mysql_connect (sql,
		     server->sql_host,
		     server->sql_user,
		     server->sql_pass))
    {
      if (mysql_select_db (sql, app_info->current_config.def_sql_db) == 0 )
	{
	  sql_time_str (&datebuf[0]);
	  snprintf (query, sizeof (query), "INSERT INTO hosts (hostname, "
		    "display_name, read_comm, write_comm, snmp_port, retries,"
		    "timeout, created, modified) VALUES ('%s', '%s', '%s', "
		    "'%s', %i, %i, %i, '%s', '%s')",
		    host->hl_snmp.name,
		    host->hl_disp,
		    host->hl_snmp.rcomm,
		    host->hl_snmp.wcomm,
		    host->hl_snmp.port,
		    host->hl_snmp.retries,
		    host->hl_snmp.timeout,
		    datebuf,
		    datebuf);
	  if (mysql_query (sql, query) == 0)
	    {
	      mysql_close (sql);
	      g_free (sql);
	      return TRUE;
	    }
	}
      else
	{
	  g_print ("Couldn't connect to the %s db\n%s\n",
		   app_info->current_config.def_sql_db,
		   mysql_error (sql));
	}

    }
  else
    {
      g_print ("failed to connect to the sql server\n%s\n",
	       mysql_error (sql));
    }
  mysql_close (sql);
  g_free (sql);
  return FALSE;
#else
  return TRUE;
#endif
}

gboolean
sql_add_snmp_entry (sql_server *server, hosts *host)
{
#ifdef HAVE_SQL
  MYSQL        *sql;
  char         query[2048];
  char         datebuf[20];
  struct tm    *tim;
  time_t       gm_time;
  int          foo;

  sql = (MYSQL *)g_malloc (sizeof (MYSQL));
  if (mysql_connect (sql,
		     server->sql_host,
		     server->sql_user,
		     server->sql_pass));
  {
    if (mysql_select_db (sql, "snmp") == 0 )
      {
	gm_time = time (NULL);
	tim     = localtime (&gm_time);
	strftime (datebuf, sizeof (datebuf), "%Y%m%d%H%M%S", tim);
	snprintf (query, sizeof (query), "INSERT INTO snmp (nodename, "
		  "snmp_version, snmp_port, retries, timeout, read_comm, "
		  "write_comm, created, modified) VALUES ('%s', %i, %i, "
		  "%i, %i, '%s', '%s')",
		  host->hl_snmp.name,
		  1,
		  host->hl_snmp.port,
		  host->hl_snmp.retries,
		  host->hl_snmp.timeout,
		  host->hl_snmp.rcomm,
		  host->hl_snmp.wcomm,
		  datebuf,
		  datebuf);
	if (mysql_query (sql, query) == 0)
	  {
	    mysql_close (sql);
	    g_free (sql);
	    return TRUE;
	  }
      }
    else
      {
	g_print ("Unable to connect to the snmp table\n%s\n",
		 mysql_error (sql));
      }
    g_print ("Unable to connect to the sql server\n%s\n",
	     mysql_error (sql));
  }
  mysql_close (sql);
  g_free (sql);
#else
  return FALSE;
#endif
}

gboolean
sql_del_host_entry (sql_server *server, hosts *host)
{
  /* remove a host from the database */
}

gboolean
sql_update_host_entry (sql_server *server, hosts *host)
{
  /* update the record for this host */
}

hosts *
sql_fetch_host_entry (sql_server *server, char *hostname)
{
#ifdef HAVE_SQL
  MYSQL        *sql;
  MYSQL_RES    *sql_res;
  MYSQL_ROW    row;
  char         query[2048];
  hosts        *host;

  sql  = (MYSQL *)g_malloc (sizeof (MYSQL));
  if (sql)                    
    {
      if (sql = mysql_connect (sql, 
			       server->sql_host,
			       server->sql_user,
			       server->sql_pass))
	{
	  /* connected */
	  if (mysql_select_db (sql, app_info->current_config.def_sql_db))
	    {
	      /* database selected */
	      host = g_new (hosts, 1);
	      snprintf (query, sizeof (query), "SELECT * FROM hosts WHERE "
			"hostname LIKE '%s'",hostname);
	      if (mysql_query (sql, query))
		{
		  sql_res = mysql_store_result (sql);
		  if (mysql_num_rows (sql_res))
		    {
		      row = mysql_fetch_row (sql_res);
		      /* copy to host struct */
		    }
		  mysql_free_result (sql_res);
		}
	      g_free (host);
	    }
	  mysql_close (sql);
	}
      g_free (sql);
    }
#endif
  return NULL;
}

gboolean
sql_load_host_table ()
{
#ifdef HAVE_SQL
  MYSQL       *sql;
  MYSQL_RES   *sql_res;
  MYSQL_ROW   row;
  MYSQL_FIELD *field;
  hosts       *entry;
  int        i, x;

  sql = (MYSQL *)g_malloc (sizeof (MYSQL));
  if (mysql_connect (sql,
		     app_info->current_config.def_sql_host,
		     app_info->current_config.def_sql_user,
		     app_info->current_config.def_sql_pass))
    {
      if ( (mysql_select_db (sql, app_info->current_config.def_sql_db)) < 0)
	{
	  mysql_close (sql);
	  return FALSE;
	}
      else
	{
	  entry = g_new (hosts, 1);
	  mysql_query (sql, "SELECT * FROM hosts ORDER BY hostname");
	  sql_res = mysql_store_result (sql);
	  i = mysql_num_rows (sql_res);
	  while (i > 0)
	    {
	      row = mysql_fetch_row (sql_res);
	      x = mysql_num_fields(sql_res);
	      x--;
	      while (x >= 0)
		{
		  switch (x)
		    {
		      /* ICK ICK ICK */
		    case 12:
		    case 11:
		    case 10:
		      break;
		    case 9:
                      if (row[x])
		        entry->hl_snmp.timeout = atoi(row[x]);
		      break;
		    case 8:
                      if (row[x])
		        entry->hl_snmp.retries = atoi(row[x]);
		      break;
		    case 7:
                      if (row[x])
		        entry->hl_snmp.port = atoi(row[x]);
		      break;
		    case 6:
		      /* g_print ("snmp_version = %s\n", row[x]); */
		      break;
		    case 5:
		      /* g_print ("system_location = %s\n", row[x]); */
		      break;
		    case 4:
		      /* g_print ("contact_person = %s\n", row[x]); */
		      break;
		    case 3:
                      if (row[x])
		        entry->hl_snmp.wcomm = g_strdup (row[x]);
		      break;
		    case 2:
                      if (row[x])
		        entry->hl_snmp.rcomm = g_strdup (row[x]);
		      break;
		    case 1:
                      if (row[x])
		        entry->hl_disp = g_strdup (row[x]);
		      break;
		    case 0:
                      if (row[x])
		        entry->hl_snmp.name = g_strdup (row[x]);
		      break;
		    }
		  x--;
		}
	      draw_host (NULL, entry);
	      i--;
	    }
	  mysql_free_result (sql_res);
	  mysql_close (sql);
	}
    }
#endif
}

/* EOF */


