#include "obgtkNotebook.h"

@implementation Gtk_Notebook
- castGtkNotebook:(GtkNotebook *) castitem
{
  gtknotebook = castitem;
  return [super castGtkContainer:GTK_CONTAINER(castitem)];
}

- init
{
  return [self castGtkNotebook:GTK_NOTEBOOK(gtk_notebook_new())];
}

- append_page:(id) child
     tabLabel:(id) tab_label
{
  gtk_notebook_append_page(gtknotebook, GTK_WIDGET([child getGtkObject]),
			   GTK_WIDGET([tab_label getGtkObject]));
  return self;
}

- prepend_page:(id) child
      tabLabel:(id) tab_label
{
  gtk_notebook_prepend_page(gtknotebook, GTK_WIDGET([child getGtkObject]),
			   GTK_WIDGET([tab_label getGtkObject]));
  return self;
}

- insert_page:(id) child
     tabLabel:(id) tab_label
      pagePos:(gint) position
{
  gtk_notebook_insert_page(gtknotebook, GTK_WIDGET([child getGtkObject]),
			   GTK_WIDGET([child getGtkObject]), position);
  return self;
}

- append_page_menu:(id) child
	  tabLabel:(id) tab_label
	 menuLabel:(id) menu_label
{
  gtk_notebook_append_page_menu(gtknotebook, GTK_WIDGET([child getGtkObject]),
				GTK_WIDGET([tab_label getGtkObject]),
				GTK_WIDGET([menu_label getGtkObject]));
  return self;
}

- prepend_page_menu:(id) child
	   tabLabel:(id) tab_label
	  menuLabel:(id) menu_label
{
  gtk_notebook_prepend_page_menu(gtknotebook, GTK_WIDGET([child getGtkObject]),
				GTK_WIDGET([tab_label getGtkObject]),
				GTK_WIDGET([menu_label getGtkObject]));
  return self;
}

- insert_page_menu:(id) child
	  tabLabel:(id) tab_label
	 menuLabel:(id) menu_label
	   pagePos:(gint) position
{
  gtk_notebook_insert_page_menu(gtknotebook, GTK_WIDGET([child getGtkObject]),
				GTK_WIDGET([tab_label getGtkObject]),
				GTK_WIDGET([menu_label getGtkObject]),
				position);
  return self;
}

- remove_page:(gint) page_num
{
  gtk_notebook_remove_page(gtknotebook, page_num);
  return self;
}

- (gint) current_page
{
  return gtk_notebook_current_page(gtknotebook);
}

- set_page:(gint) page_num
{
  gtk_notebook_set_page(gtknotebook, page_num);
  return self;
}

- next_page
{
  gtk_notebook_next_page(gtknotebook);
  return self;
}

- prev_page
{
  gtk_notebook_prev_page(gtknotebook);
  return self;
}

- set_tab_pos:(GtkPositionType) pos
{
  gtk_notebook_set_tab_pos(gtknotebook, pos);
  return self;
}

- set_show_tabs:(gint) show_tabs
{
  gtk_notebook_set_show_tabs(gtknotebook, show_tabs);
  return self;
}

- set_show_border:(gint) show_border
{
  gtk_notebook_set_show_border(gtknotebook, show_border);
  return self;
}

- set_tab_border:(gint) border_width
{
  gtk_notebook_set_tab_border(gtknotebook, border_width);
  return self;
}

- set_scrollable:(gint) scrollable
{
  gtk_notebook_set_scrollable(gtknotebook, scrollable);
  return self;
}

- popup_enable
{
  gtk_notebook_popup_enable(gtknotebook);
  return self;
}

- popup_disable
{
  gtk_notebook_popup_disable(gtknotebook);
  return self;
}
@end
