/* gEdit
 * Copyright (C) 1998 Alex Roberts, Evan Lawrence, and Chris Lahey
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <string.h>
#include <gtk/gtk.h>
#include "main.h"
#include "gE_plugin_api.h"
#include "gE_document.h"
#include "commands.h"

#ifndef WITHOUT_GNOME
#include <config.h>
#include <gnome.h>
#endif

GList *plugins;

/* --- Accesory functions for gedit's handling of the plugins --- */

void start_plugin( GtkWidget *widget, gE_data *data )
{
  plugin_callback_struct callbacks;
  plugin *plug = plugin_new( data->temp1 );

  callbacks.document.create = gE_plugin_document_create;
  callbacks.text.append = gE_plugin_text_append;
  callbacks.document.show = gE_plugin_document_show;
  callbacks.document.current = gE_plugin_document_current;
  callbacks.document.filename = gE_plugin_document_filename;
  callbacks.text.get = gE_plugin_text_get;
  callbacks.program.quit = gE_plugin_program_quit;
  
  plugin_register( plug, &callbacks, GPOINTER_TO_INT( data->window ) );
}


void add_plugin_to_menu (gE_window *window, plugin_info *info)
{
	gE_data *data = g_malloc0 (sizeof (gE_data));
#ifdef WITHOUT_GNOME
	GtkMenuEntry *entry = g_malloc0 (sizeof (GtkMenuEntry));
	
	entry->path = g_malloc0 (strlen (info->menu_location) + strlen ("Plugins/") + 1);
	sprintf (entry->path, "Plugins/%s", info->menu_location);
	entry->accelerator = NULL;
	entry->callback = (GtkMenuCallback)(GTK_SIGNAL_FUNC (start_plugin));
	data->temp1 = g_strdup (info->plugin_name);
	data->window = window;
	entry->callback_data = data;
	
	gtk_menu_factory_add_entries((GtkMenuFactory *)(window->factory), entry, 1);
#else
	gchar *path;
	GnomeUIInfo *menu = g_malloc0 (2 * sizeof (GnomeUIInfo));
	
	data->temp1 = g_strdup (info->plugin_name);
	data->window = window;
	path = g_new (gchar, strlen (_("Plugins") ) + 2 );
	sprintf (path, "%s/", _("Plugins"));
	menu->label = g_strdup (info->menu_location);
	menu->type = GNOME_APP_UI_ITEM;
	menu->hint = NULL;
	menu->moreinfo = start_plugin;
	menu->user_data = data;
	menu->unused_data = NULL;
	menu->pixmap_type = 0;
	menu->pixmap_info = NULL;
	menu->accelerator_key = 0;

	(menu + 1)->type = GNOME_APP_UI_ENDOFINFO;
	
	gnome_app_insert_menus_with_data (GNOME_APP(window->window), path, menu, data);
#endif

}

void add_plugins_to_window (plugin_info *info, gE_window *window)
{
	add_plugin_to_menu (window, info);
}


/* --- Direct interface to the plugins API --- */

int gE_plugin_document_create( gint context, gchar *title )
{
  return GPOINTER_TO_INT( gE_document_new( GINT_TO_POINTER( context ) ) );
}

void gE_plugin_text_append( gint docid, gchar *buffer, gint length )
{
  gE_document *document = (gE_document *) GINT_TO_POINTER( docid );
  GtkText *text = GTK_TEXT( document->text );
  gtk_text_freeze( text );
  gtk_text_set_point( text, gtk_text_get_length( text ) );
  gtk_text_insert( text, NULL, NULL, NULL, buffer, length );
  gtk_text_thaw( text );
  document->changed = 1;
}

void gE_plugin_document_show( gint docid )
{
}

int gE_plugin_document_current( gint context )
{
  return GPOINTER_TO_INT( gE_document_current( GINT_TO_POINTER( context ) ) );
}

gchar *gE_plugin_document_filename( gint docid )
{
  gE_document *document = (gE_document *) GINT_TO_POINTER( docid );
  if (document->filename == NULL)
  	return "";
  else
  	return document->filename;
}

char *gE_plugin_text_get( gint docid )
{
  gE_document *document = (gE_document *) GINT_TO_POINTER( docid );
  return gtk_editable_get_chars( GTK_EDITABLE( document->text ), 0, -1 );
}


gboolean gE_plugin_program_quit ()
{
	gE_data *data;
	gE_window *window;
	data = g_malloc0 (sizeof (gE_data));
	window = g_list_nth_data (window_list, 1);
	data->window = window;
	data->temp1 = window;
	file_close_cmd_callback (NULL, data);
	return TRUE;
}

/* mercilessly lifted right out of go.. */

void gE_plugin_program_register (plugin_info *info)
{
  plugin_info *temp;

  temp = info;
  info = g_malloc0( sizeof( plugin_info ) );
  info->type = temp->type;
  info->menu_location = g_malloc0( strlen( temp->menu_location ) + 1 );
  strcpy( info->menu_location, temp->menu_location );
  info->plugin_name = g_malloc0( strlen( temp->plugin_name ) + 1 );
  strcpy( info->plugin_name, temp->plugin_name );
  plugins = g_list_append( plugins, info );

  g_list_foreach( window_list, (GFunc)add_plugin_to_menu, info );
}
