#include <gtk/gtk.h>
#include <gnome.h>


#include <stdio.h>
#include <unistd.h>
#include <signal.h>

#include "raft_config.h"
#include "raft_interface.h"
#include "raft_parse.h"


extern Raft_info raft_info;

static void trap_sigchld(void)
{
    struct sigaction act;
    
    act.sa_handler = SIG_IGN;
    sigemptyset(&act.sa_mask);
    act.sa_flags = SA_NOCLDSTOP;
    act.sa_restorer = 0;
    sigaction(SIGCHLD, &act, NULL);
}

int main (int argc, char *argv[])
{
    gchar *filename;
    gint found = FALSE;
    
    gnome_init (&argc, &argv);

    filename = gnome_file_from_home_dir("raft.conf");
    
    if (gnome_file_exists (filename)) {
	raft_parse_config(filename);
	g_print("parsing %s\n", filename);
	found = TRUE;
    }
    g_free (filename);
    
    if (!found) {
	filename = gnome_file_from_datadir("gnome/raft.conf");
	if (gnome_file_exists (filename)) {
	    raft_parse_config(filename);
	    g_print("parsing %s\n", filename);
	    found = TRUE;
	}
	g_free (filename);
    }
    
    if (!found)
	    g_error ("Unable to locate 'raft.conf' file");
	    
    if (argc > 1) {
	raft_info.x_position = atoi(argv[1]);
	raft_info.y_position = atoi(argv[2]);
    }
    
    raft_interface_create_main_window();
    
    trap_sigchld();
    
    gtk_main ();
    
    return 0;
}

