#include <string.h>
#include "applet.h"
#include "panel.h"

static Panel *panel;

static void
load_default_applets(void)
{
	applets_init_applet("Menu", panel, ".", 0, 0);
	applets_init_applet("Mail check", panel, "", 550, 0);
}


static void
init_user_applets(void)
{
	void *iterator;
	char *key;
	char *value;
	char *applet_name;
	char *applet_params;
	int   xpos, ypos;

	iterator = gnome_config_init_iterator("/panel/Applets");

	if (!iterator)
		load_default_applets();
	
	while (iterator) {
		iterator = gnome_config_iterator_next(iterator, &key, &value);

		applet_params = strchr(key, ','); /* Everything after first comma is parameters to the applet */
		if (applet_params) 
			*applet_params++ = '\0'; /* Terminate string at comma and skip over it */
		else
			applet_params = "";

		applet_name = key;

		if (sscanf(value, "%d%d", &xpos, &ypos) != 2) {
			fprintf(stderr, "init_user_applets: using position (0, 0) for applet "
				"without specified position\n");

			xpos = ypos = 0;
		}
		applets_init_applet(applet_name, panel, applet_params, xpos, ypos);
	}
}


int
main(int argc, char **argv)
{
	gtk_init(&argc, &argv);
	gnome_init(&argc, &argv);

	panel = panel_new();

	applets_init();
	init_user_applets();

	gtk_widget_show(panel->window);
	
	gtk_main();
	return 0;
}
