#include "applet.h"


#define DEFAULT_STEP_SIZE 4
#define DEFAULT_DELAY     0
#define DEFAULT_HEIGHT    48


typedef struct {
	int x, y;
} Point;


static void
move_window(GtkWindow *window, int x, int y)
{
	GtkWidget *widget;

	widget = GTK_WIDGET(window);
	
	gdk_window_set_hints(widget->window, x, y, 0, 0, 0, 0, GDK_HINT_POS);
	gdk_window_move(widget->window, x, y);
}


static void
move_horiz(Panel *panel, int src_x, int dest_x)
{
	int x;

	if (panel->step_size != 0)
		if (src_x < dest_x)
			for (x = src_x; x < dest_x; x += panel->step_size) {
				move_window(GTK_WINDOW(panel->window), x, 0); 
				/* FIXME: do delay */
			}
		else
			for (x = src_x; x > dest_x; x -= panel->step_size) {
				move_window(GTK_WINDOW(panel->window), x, 0); 
				/* FIXME: do delay */
			}
	
	move_window(GTK_WINDOW(panel->window), dest_x, 0);
}

static void
move_vert(Panel *panel, int src_y, int dest_y)
{
	int y;

	if (panel->step_size != 0)
		if (src_y < dest_y)
			for (y = src_y; y < dest_y; y += panel->step_size) {
				move_window(GTK_WINDOW(panel->window), 0, y);
				/* FIXME: do delay */
			}
		else
			for (y = src_y; y > dest_y; y -= panel->step_size) {
				move_window(GTK_WINDOW(panel->window), 0, y);
				/* FIXME: do delay */
			}

	move_window(GTK_WINDOW(panel->window), 0, dest_y);
}


static void
pop_up(Panel *panel)
{
	int width, height;
	int swidth, sheight;
	
	if (panel->state == PANEL_SHOWN)
		return;

	width   = panel->window->allocation.width;
	height  = panel->window->allocation.height;
	swidth  = gdk_screen_width();
	sheight = gdk_screen_height();

	switch (panel->pos) {
		case PANEL_POS_TOP:
			move_vert(panel, -height + 1, 0);
			break;

		case PANEL_POS_BOTTOM:
			move_vert(panel, sheight - 1, sheight - height);
			break;

		case PANEL_POS_LEFT:
			move_horiz(panel, -width + 1, 0);
			break;

		case PANEL_POS_RIGHT:
			move_horiz(panel, swidth - 1, swidth - width);
			break;
	}

	panel->state = PANEL_SHOWN;
}

static void
pop_down(Panel *panel)
{
	int width, height;
	int swidth, sheight;

	if (panel->state == PANEL_HIDDEN)
		return;

	width   = panel->window->allocation.width;
	height  = panel->window->allocation.height;
	swidth  = gdk_screen_width();
	sheight = gdk_screen_height();

	switch (panel->pos) {
		case PANEL_POS_TOP:
			move_vert(panel, 0, -height + 1);
			break;

		case PANEL_POS_BOTTOM:
			move_vert(panel, sheight - height, sheight - 1);
			break;

		case PANEL_POS_LEFT:
			move_horiz(panel, 0, -width + 1);
			break;

		case PANEL_POS_RIGHT:
			move_horiz(panel, swidth - width, swidth - 1);
			break;
	}

	panel->state = PANEL_HIDDEN;
}


static gint
panel_enter_notify(GtkWidget *widget, GdkEventCrossing *event, gpointer data)
{
	Panel *panel;

	panel = data;

	if ((panel->mode == PANEL_STAYS_PUT) ||
	    (event->detail == GDK_NOTIFY_INFERIOR))
		return FALSE;

	pop_up(panel);

	return FALSE;
}


static gint
panel_leave_notify(GtkWidget *widget, GdkEventCrossing *event, gpointer data)
{
	Panel *panel;

	panel = data;

	if ((panel->mode == PANEL_STAYS_PUT) ||
	    (event->detail == GDK_NOTIFY_INFERIOR))
		return FALSE;

	pop_down(panel);

	return FALSE;
}

static void
max_pos(GtkWidget *widget, gpointer data)
{
	Point *point;

	point = data;

	point->x = MAX(point->x, widget->allocation.x + widget->allocation.width);
	point->y = MAX(point->y, widget->allocation.y + widget->allocation.height);
}


static void
get_applet_placement(Panel *panel, int *x, int *y)
{
	Point point;

	point.x = 0;
	point.y = 0;
	
	gtk_container_foreach(GTK_CONTAINER(panel->fixed),
			      (GtkCallback) max_pos,
			      &point);

	switch (panel->pos) {
		case PANEL_POS_TOP:
		case PANEL_POS_BOTTOM:
			*x = point.x;
			*y = 0;
			break;

		case PANEL_POS_LEFT:
		case PANEL_POS_RIGHT:
			*x = 0;
			*y = point.y;
			break;
	}
}


static void
change_window_cursor(GdkWindow *window, GdkCursorType cursor_type)
{
	GdkCursor *cursor;

	cursor = gdk_cursor_new(cursor_type);
	gdk_window_set_cursor(window, cursor);
	gdk_cursor_destroy(cursor);
}


static void
realize_change_cursor(GtkWidget *widget, gpointer data)
{
	change_window_cursor(widget->window, GDK_ARROW); /* XXX: I don't like this arrow */
}


static void
save_applet_configuration(GtkWidget *widget, gpointer data)
{
}


static void
panel_quit(Panel *panel)
{
	g_assert(panel != NULL);

	gtk_container_foreach(GTK_CONTAINER(panel->fixed), save_applet_configuration, panel);
	gtk_widget_destroy(panel->window);
	applets_destroy();
}


Panel *
panel_new(void)
{
	Panel     *panel;

	panel = g_new(Panel, 1);

	panel->window = gtk_window_new(GTK_WINDOW_POPUP);

	panel->fixed = gtk_fixed_new();
	gtk_container_add(GTK_CONTAINER(panel->window), panel->fixed);
	gtk_widget_show(panel->fixed);

	panel->pos   = PANEL_POS_BOTTOM;
	panel->state = PANEL_SHOWN;
	panel->mode  = PANEL_GETS_HIDDEN;
	gtk_widget_set_usize(panel->window, gdk_screen_width(), DEFAULT_HEIGHT);
	gtk_widget_set_uposition(panel->window, 0, gdk_screen_height() - DEFAULT_HEIGHT);

#if 0
	panel->pos   = PANEL_POS_TOP;
	panel->state = PANEL_SHOWN;
	panel->mode  = PANEL_GETS_HIDDEN;
	gtk_widget_set_usize(panel->window, gdk_screen_width(), DEFAULT_HEIGHT);
	gtk_widget_set_uposition(panel->window, 0, 0);
#endif
#if 0
	panel->pos   = PANEL_POS_RIGHT;
	panel->state = PANEL_SHOWN;
	panel->mode  = PANEL_GETS_HIDDEN;
	gtk_widget_set_usize(panel->window, DEFAULT_HEIGHT, gdk_screen_height());
	gtk_widget_set_uposition(panel->window, gdk_screen_width() - DEFAULT_HEIGHT, 0);
#endif
#if 0
	panel->pos   = PANEL_POS_LEFT;
	panel->state = PANEL_SHOWN;
	panel->mode  = PANEL_GETS_HIDDEN;
	gtk_widget_set_usize(panel->window, DEFAULT_HEIGHT, gdk_screen_height());
	gtk_widget_set_uposition(panel->window, 0, 0);
#endif
	panel->step_size       = DEFAULT_STEP_SIZE;
	panel->delay           = DEFAULT_DELAY;

	gtk_signal_connect(GTK_OBJECT(panel->window), "enter_notify_event",
			   (GtkSignalFunc) panel_enter_notify,
			   panel);
	gtk_signal_connect(GTK_OBJECT(panel->window), "leave_notify_event",
			   (GtkSignalFunc) panel_leave_notify,
			   panel);
	gtk_signal_connect_after(GTK_OBJECT(panel->window), "realize",
				 (GtkSignalFunc) realize_change_cursor,
				 NULL);

	return panel;
}


void
panel_register_toy(Panel *panel, GtkWidget *applet, int xpos, int ypos, int flags)
{
	g_assert(panel != NULL);
	g_assert(applet != NULL);

	gtk_fixed_put(GTK_FIXED(panel->fixed), applet, xpos, ypos);
	gtk_widget_show(applet);
}


int
panel_command(Panel *panel, PanelCommand *cmd)
{
	g_assert(panel != NULL);
	g_assert(cmd != NULL);
	
	switch (cmd->cmd) {
		case PANEL_CMD_REGISTER_TOY:
			panel_register_toy(panel,
					   cmd->params.register_toy.applet,
					   cmd->params.register_toy.xpos,
					   cmd->params.register_toy.ypos,
					   cmd->params.register_toy.flags);
			return 0;

		case PANEL_CMD_QUIT:
			panel_quit(panel);
			gtk_main_quit();
			return 0;
	}

	return -1;
}
