; FIXME: do all of these really need to be here?

(define (launch-gnome fn)
  ; call to gtk-main moved to gnome-guile.c (federico)
  (fn)
  (gtk-main))

(define (gtk-widget-show-multi . list)
  (for-each gtk-widget-show list))

(define (internal-make-filled-box boxfunc homogeneous padding widgets)
  (let ((box (boxfunc homogeneous padding))
	(state 'pack-start))
    (for-each (lambda (thing)
		(cond
		 ((eq? thing 'pack-start) (set! state 'pack-start) )
		 ((eq? thing 'pack-end) (set! state 'pack-end))
		 ((and (list? thing) (eq? 'boxed-widget (car thing)))
		  (case state
		    ((pack-start) (gtk-box-pack-start box
						      (cadr thing)
						      (caddr thing)
						      (cadddr thing)
						      (car (cddddr 
thing)))
				  (gtk-widget-show (cadr thing)))
		    ((pack-end) (gtk-box-pack-end box
						  (cadr thing)
						  (caddr thing)
						  (cadddr thing)
						  (car (cddddr thing)))
				(gtk-widget-show (cadr thing)))))
		 (thing (error 'wrong-type-arg thing))))
	      widgets)
    (gtk-widget-show box)
    box))

(define (gnome-make-filled-hbox homogeneous padding . widgets)
  (internal-make-filled-box gtk-hbox-new homogeneous padding widgets))

(define (gnome-make-filled-vbox homogeneous padding . widgets)
  (internal-make-filled-box gtk-vbox-new homogeneous padding widgets))

(define-macro (gnome-boxed-widget-internal expand fill padding widget)
  `(list 'boxed-widget ,widget ,expand ,fill ,padding))

(define-macro (gnome-boxed-widget . args)
  (if (boolean? (car args))
      `(gnome-boxed-widget-internal ,@args)
      `(gnome-boxed-widget-internal #f #f 0 ,@args)))

(define (make-gnome-window title menu-def make-contents make-statusline)

  (define window (gtk-window-new 'toplevel))
  (define main-vbox (gtk-vbox-new #f 0))
  (define menubar (gtk-menu-bar-new))
  (define contents-frame (gtk-frame-new #f))
  (define statusbar-separator (gtk-hseparator-new))
  (define statusbar-hbox (gtk-hbox-new #f 0))
  
  ;;
  ;; Create a menu from a menu-definition
  ;;
  (define (make-menu! menubar menu-def)
    (defmacro nil-if-exception (expr)
      `(catch #t (lambda () ,expr)
	      (lambda args '())))
    (define (cadr* l)
      (nil-if-exception (cadr l)))
    (for-each 
     (lambda (menu)
       (let ((menuitem (gtk-menu-item-new-with-label (car menu)))
	     (submenu (gtk-menu-new))
	     (items (map (lambda (item action)
			   (let ((menuitem 
				  (gtk-menu-item-new-with-label item)))
			     (gtk-signal-connect 
			      menuitem "activate" 
			      (if (null? action)
				  (lambda () 
				    (display "undefined!\n"))
				  action))
			     menuitem))
			 (map car (cdr menu))
			 (map cadr* (cdr menu)))))
	 (for-each (lambda (item) (gtk-menu-append submenu item)) items)
	 (for-each (lambda (item) (gtk-widget-show item)) items)
	 (gtk-menu-item-set-submenu menuitem submenu)
	 (gtk-menu-bar-append menubar menuitem)
	 (gtk-widget-show menuitem)))
     menu-def))

  ; init the main window
  (gtk-window-set-title window title)
  (gtk-container-border-width window 0)
  (gtk-container-add window main-vbox)
  (gtk-widget-show main-vbox)
    
  ; add the menubar and the menus
  (gtk-box-pack-start main-vbox menubar #f #t 0)
  (gtk-widget-show menubar)
  (make-menu! menubar menu-definition)
  
  ; create a container with a border for the contents
  (gtk-frame-set-shadow-type contents-frame 'none)
  (gtk-container-border-width contents-frame 5)
  (gtk-box-pack-start main-vbox contents-frame #t #t 0)
  (gtk-widget-show contents-frame)

  ; create the contents of the main windows
  (make-contents contents-frame)

  ; create a seperation line for the status bar
  (gtk-box-pack-start main-vbox statusbar-separator #f #t 0)
  (gtk-widget-show statusbar-separator)

  ; create the hbox for the status bar
  (gtk-box-pack-start main-vbox statusbar-hbox #f #t 0)
  (gtk-widget-show statusbar-hbox)

  ; create the statubar
  (make-statusline statusbar-hbox)

  ; show me what i want
  (gtk-widget-show window)

  (define (self . args)
    (if (null? args)
	(throw 'wrong-number-of-args)
	(case (car args)
	  ((get-window) window)
	  ((get-menubar) menubar)
	  ((get-contents-frame) contents-frame)
	  ((get-statusbar-hbox) statusbar-hbox)
	  )))
  self)

;;
;; Read a file and display it in a window. Use this to show the GPL:
;;
;; (gnome-show-file "COPYING" "GNU Public License"
;;                  "-*-lucidatypewriter-medium-*-*-*-12-*-*-*-*-*-*-*"
;;                  600 800)
;;
(define (gnome-show-file file title font width height)
  (let* ((window (gtk-window-new 'toplevel))
         (vbox (gtk-vbox-new #f 0))
         (table (gtk-table-new 2 2 #f))
         (vadj (gtk-adjustment-new 0.0 0.0 101.0 0.1 1.0 1.0))
         (text (gtk-text-new #f vadj))
         (vscrollbar (gtk-vscrollbar-new vadj))
         (hbox (gtk-hbox-new #f 0))
         (close-button (gtk-button-new-with-label "Close"))
         (port (open-input-file file)))

    (letrec ((insert-file (lambda ()
                            (let ((line (read-line port 'split)))
                              (if (not (eof-object? (cdr line)))
                                  (let ((str (string-append (car line) "\n")))
                                    (gtk-text-insert text font #f #f str -1)
                                    (insert-file))
                                  (close-input-port port))))))

      ; create window and vbox
      (gtk-window-set-title window title)
      (gtk-widget-set-usize window width height)
      (gtk-container-add window vbox)
      (gtk-widget-show vbox)

      ; create table
      (gtk-table-set-row-spacing table 0 2)
      (gtk-table-set-col-spacing table 0 2)
      (gtk-box-pack-start vbox table #t #t 0)
      (gtk-widget-show table)

      ; attache text and scrollbar
      (gtk-table-attach-defaults table text 0 1 0 1)
      (gtk-widget-show text)
      (gtk-table-attach table vscrollbar 1 2 0 1
                        '(fill) '(expand fill) 0 0)
      (gtk-widget-show vscrollbar)

      ; insert text file
      (gtk-text-freeze text)
      (gtk-widget-realize text)
      (insert-file)
      (gtk-text-thaw text)

      ; create close button
      (gtk-box-pack-start vbox hbox #f #f 10)
      (gtk-widget-show hbox)
      (gtk-box-pack-start hbox close-button #f #f 10)
      (gtk-signal-connect close-button "clicked"
                          (lambda () (gtk-widget-destroy window)))
      (gtk-widget-show close-button)

      ; show it
      (gtk-widget-show window))))

(or (feature? 'gettext)
    (begin
      ;; Usage: (gettext String ?Domain? ?Category?)
      ;; Optional args turn it into a call to dgettext or dcgettext.
      (define (gettext string . args) string)
      ;; Usage just like the C function.
      (define (textdomain string) string)
      ;; Usage like the C function; if the second arg is not given
      ;; then NULL is passed to bindtextdomain().
      (define (bindtextdomain string . args) string)))
