(define-module (toolkits gtk)
  :use-module (toolkits gtkstubs)
  :use-module (event-repl))

;; Merge the C stubs from their own module

(define (merge-exports module interface)
  (let ((mod-i (module-public-interface module)))
    (module-for-each (lambda (sym var)
		       (module-add! mod-i sym var))
		     interface)))

(merge-exports (current-module)
	       (or (resolve-interface '(toolkits gtkstubs))
		   (error "gtkstubs module not found")))

;; The default Gtk repl

(define-public (gtk-repl)
  (define inport (current-input-port))
  (define outport (current-output-port))

  (define unspecified (if #f #f))
  (define (prompt)
    (display "gtk> " outport)
    (force-output outport))
  (define (print val)
    (cond ((not (eq? unspecified val))
	   (write val outport)
	   (newline outport)))
    (prompt))
  (define (report data)
    (repl-display-backtrace data outport)
    (repl-display-error data outport)
    (prompt))
  (define repl (make-event-repl read eval print report))

  (define (nonblocking-read port)
    (let loop ((res '()))
      (if (char-ready? port)
	  (let ((ch (read-char port)))
	    (if (eof-object? ch)
		(if (null? res)
		    ch 
		    (apply string (reverse res)))
		(loop (cons ch res))))
	  (apply string (reverse res)))))
  
  (gtk-input-add inport
		 '(read)
		 (lambda (source condition)
		   (catch 'quit
			  (lambda ()
			    (let ((str (nonblocking-read inport)))
			      (if (eof-object? str)
				  (gtk-exit)
				  (repl-input repl str))))
			  (lambda (key . args)
			    (gtk-exit (if (null? args) 0 (car args)))))))
  (prompt)
  (gtk-main))
