#include "obgtk.h"

@implementation Gtk_Tooltips
- init
{
  gtktooltips = gtk_tooltips_new();
  return self;
}

- initWithGtkWidgetLabel:(Gtk_Widget *)widget
		tipsText:(gchar *) tips_text
{
  gtktooltips = gtk_tooltips_new();
  return [self set_tips:widget tipsText:tips_text];
}

- free
{
  gtk_tooltips_destroy(gtktooltips);
  return [super free];
}

- enable
{
  gtk_tooltips_enable(gtktooltips);
  return self;
}

- disable
{
  gtk_tooltips_disable(gtktooltips);
  return self;
}

- set_delay:(gint) delay
{
  gtk_tooltips_set_delay(gtktooltips, delay);
  return self;
}

- set_tips:(Gtk_Widget *) widget
  tipsText:(gchar *) tips_text
{
  gtk_tooltips_set_tips(gtktooltips, widget->gtkwidget, tips_text);
  return self;
}

- set_colors:(GdkColor *) background
   colorFg:(GdkColor *) foreground
{
  gtk_tooltips_set_colors(gtktooltips, background, foreground);
  return self;
}
@end
