/*
 * GULP: The Gnome printer controller
 *
 * Author: Elliot Lee (sopwith@cuc.edu)
 *
 */
#include <objc/Object.h>
#include "gPrint.h"
#include <stdio.h>

#include "gulp.h"

@implementation Gtk_MessageBox
- initWithLabel:(gchar *) label
{
	self = [super init];
	lbl_msg = [[[Gtk_Label alloc] initWithLabel:label] show];
	btn_ok = [[[Gtk_Button alloc] initWithLabel:"OK"] show];
	[vbox add:lbl_msg];
	[action_area add:btn_ok];
	[btn_ok connectObj:"clicked" :self];
	[self connect:"destroy"];
	[self show];
	return self;
}

- run
{
	gtk_grab_add(gtkwidget);
	return self;
}

- destroy:(id) obj
{
	gtk_grab_remove(gtkwidget);
	return [self free];
}

- clicked:(id) obj
{
	if (obj == btn_ok){
		gtk_grab_remove(gtkwidget);
		return [self free];
	}
	return self;
}

- free
{
	[btn_ok free];
	[lbl_msg free];
	return [super free];
}
@end

@implementation GULPApp
- activate:(id) obj
{
	if (obj == menus.helpm.about)
		[[[Gtk_MessageBox alloc]
		 initWithLabel:"Copyright (C) 1997 Elliot Lee. Licensed under the GPL."]
		run];
	else
		printf("Unknown activation\n");
	return self;
}

- destroy:(id) obj
{
	gtk_main_quit();
	return self;
}

- toggled:(id) obj
{
	if (dotogglehandler) {
		int opstatus = 0;
		id curprinter = nil;
		if(printerlist->gtklist->selection)
			curprinter =
				gtk_object_get_user_data(printerlist->gtklist->selection->data);
		
		if(curprinter == nil) {
			[[[Gtk_MessageBox alloc] initWithLabel:"You must select a printer"] run];
			return self;
		}
		if(obj == nb.printops.updown) {
			if(((Gtk_CheckButton*)obj)->gtktogglebutton->active)
				opstatus = [curprinter up];
			else
				opstatus = [curprinter down];
		} else if(obj == nb.printops.startstop) {
			if(((Gtk_CheckButton*)obj)->gtktogglebutton->active) {
				fprintf(stderr, "Starting it\n");
				opstatus = [curprinter start];
			} else
				opstatus = [curprinter stop];
		}
		if(opstatus){
			[[[Gtk_MessageBox alloc] initWithLabel:"Operation failed"] run];
			dotogglehandler = 0;
			[(Gtk_CheckButton *)
			obj
			set_state:!((Gtk_CheckButton*)obj)->gtktogglebutton->active];
			dotogglehandler = 1;
		}
	}
	return self;
}

- clicked:(id) obj
{
	id curprinter = nil, tmp;
	int opstatus = 0;
	
	if (printerlist->gtklist->selection)
		curprinter = gtk_object_get_user_data(printerlist->gtklist->selection->data);
	
	if (curprinter == nil){
		[[[Gtk_MessageBox alloc] initWithLabel:"You must select a printer"] run];
		return self;
	}
	
	if (obj == nb.jobs.canceljob){
		if (nb.jobs.joblist->gtklist->selection){
			tmp = gtk_object_get_data(nb.jobs.joblist->gtklist->selection->data,
						  "gulpJob");
			[tmp cancel];
			[self dojoblist];
		} else
			[[[Gtk_MessageBox alloc] initWithLabel:"You must select a job"] run];
	} else if(obj == nb.printops.clean)
		opstatus = [curprinter clean];
	else if(obj == nb.printops.restart)
		opstatus = [curprinter restart];
	else
		printf("Click on unknown widget\n");
	
	if(opstatus)
		[[[Gtk_MessageBox alloc] initWithLabel:"Operation failed"] run];
	
	return self;
}

- selection_changed:(id) obj
{
	if (obj == printerlist){
		/* We need to redisplay the jobs */
		id curprinter = nil;
		if(printerlist->gtklist->selection)
			curprinter = gtk_object_get_user_data(printerlist->gtklist->selection->data);
		
		[self dojoblist];
		dotogglehandler = 0;
		[nb.printops.updown set_state:[curprinter isUp]];
		[nb.printops.startstop set_state:[curprinter isStarted]];
		dotogglehandler = 1;
	}
	
	return self;
}

- dojoblist
{
	GList *l;
	int i;
	Printer *newprt;
	char buf[255];
	if(nb.jobs.joblist->gtklist->selection)
		[nb.jobs.joblist
		unselect_child:gtk_object_get_data(nb.jobs.joblist->gtklist->selection->data,"objc_id")];
	
	if (nb.jobs.joblist->gtklist->children){
		for(l = nb.jobs.joblist->gtklist->children; l; l = l->next)
			[(id)gtk_object_get_data(l->data, "objc_id") free];
		[nb.jobs.joblist clear_items:0 theEnd:99999];
	}
	
	if(!printerlist->gtklist->selection)
		return self;
	newprt = [(id)gtk_object_get_data(printerlist->gtklist->selection->data,
					  "objc_id") get_user_data];
	[newprt getJobs];
	
	nb.jobs.jobs = realloc(nb.jobs.jobs, (newprt->numjobs * sizeof(Gtk_List *)));
	
	for (i = 0; i < newprt->numjobs; i++){
		snprintf(buf, sizeof(buf), "%-5d %-10d %-10s %s",
			 [newprt->jobs[i] getJobID],
			 [newprt->jobs[i] getJobSize],
			 [newprt->jobs[i] getJobOwner],
			 [newprt->jobs[i] getJobFilenames]);
		nb.jobs.jobs[i] = [[[Gtk_ListItem alloc] initWithLabel:buf] show];
		[nb.jobs.jobs[i] set_data:"gulpJob" :newprt->jobs[i]];
		[nb.jobs.joblist add:nb.jobs.jobs[i]];
	}
	
	return self;
}

- initApp:(int *)argcp
	:(char ***)argvp
{
	int i;
	GList *anitem = NULL;
	
	self = [super initApp:argcp :argvp];

	dotogglehandler = 1;
	printsys = [PrintSystem new];
	if(![printsys exists]) {
	    [[[Gtk_MessageBox alloc] initWithLabel:"Printing system not installed"] run];
	    [printsys free];
	    [super free];
	    return nil;
	}
	mainwin = [[Gtk_Window alloc] initWithWindowType:GTK_WINDOW_TOPLEVEL];
	[mainwin set_title:"GNOME Unified Link to Printers"];
	vbox = [[[Gtk_VBox alloc] initWithBoxInfo:0 setSpacing:5] show];
	
	menus.menu = [[[Gtk_MenuBar alloc] init] show];
	menus.file = [[[Gtk_MenuItem alloc] initWithLabel:"File"] show];
	menus.filem.filem = [[Gtk_Menu new] show];
	menus.filem.exit = [[[Gtk_MenuItem alloc] initWithLabel:"Exit"] show];
	[menus.filem.exit signal_connect:"activate"
	signalFunc:(GtkSignalFunc)gtk_exit funcData:0];

	menus.help = [[[Gtk_MenuItem alloc] initWithLabel:"Help"] show];
	menus.helpm.helpm = [[Gtk_Menu new] show];
	menus.helpm.about = [[[[Gtk_MenuItem alloc] initWithLabel:"About"] show]
			    connectObj:"activate" :self];
  
	[menus.menu append:menus.file];
	[menus.menu append:menus.help];
	[menus.help connectObj:"activate" :self];
	[menus.filem.filem append:menus.filem.exit];
	[menus.file set_submenu:menus.filem.filem];
	[menus.helpm.helpm append:menus.helpm.about];
	[menus.help set_submenu:menus.helpm.helpm];

	[vbox pack_start_defaults:menus.menu];
	[mainwin signal_connect:"destroy"
	signalFunc:(GtkSignalFunc)gtk_exit funcData:0];
	printers = malloc(sizeof(Gtk_ListItem *) * printsys->numprinters);
	printerlist = [[[Gtk_List alloc] init] show];
	
	for (i = 0; i < printsys->numprinters; i++){
		printers[i] = [[[Gtk_ListItem alloc]
			       initWithLabel:[printsys->printers[i] getQueueName]] show];
		[printers[i] set_user_data:printsys->printers[i]];
		anitem = g_list_append(anitem, (gpointer) printers[i]->gtkwidget);
	}
	
	[printerlist append_items:anitem];
	[printerlist set_usize:100 height:50];
	[printerlist connectObj:"selection_changed" :self];

	[vbox pack_start_defaults:printerlist];
	[vbox pack_start_defaults:[[Gtk_HSeparator new] show]];
  
	nb.jobs.page = [[[Gtk_VBox alloc] initWithBoxInfo:1 setSpacing:0] show];
	nb.jobs.joblist = [[Gtk_List new] show];
	nb.jobs.canceljob = [[[[Gtk_Button alloc] initWithLabel:"Cancel"] show]
			    connectObj:"clicked" :self];
	[nb.jobs.page add:nb.jobs.joblist];
	[nb.jobs.page add:nb.jobs.canceljob];

	nb.printops.page = [[[Gtk_HBox alloc] initWithBoxInfo:1 setSpacing:0] show];
	nb.printops.updown = [[[[Gtk_CheckButton alloc] initWithLabel:"Queueing"] show]
			     connectObj:"toggled" :self];
	nb.printops.clean = [[[[Gtk_Button alloc] initWithLabel:"Clear Queue"] show]
			    connectObj:"clicked" :self];
	nb.printops.restart = [[[[Gtk_Button alloc] initWithLabel:"Restart"] show]
			      connectObj:"clicked" :self];
	nb.printops.startstop = [[[[Gtk_CheckButton alloc] initWithLabel:"Printing"] show]
				connectObj:"toggled" :self];
	[nb.printops.page add:nb.printops.updown];
	[nb.printops.page add:nb.printops.clean];
	[nb.printops.page add:nb.printops.restart];
	[nb.printops.page add:nb.printops.startstop];
       

	[vbox add:nb.printops.page];
	[vbox add:nb.jobs.page];
	[mainwin add:vbox];
	[mainwin show];
	return self;
}

- free
{
	int i;

	for (i = 0; i < printsys->numprinters; i++)
		[printers[i] free];

	free(printers);
	[printerlist free];
	[mainwin hide];
	[vbox hide];

	[menus.filem.filem free];
	[menus.filem.exit free];
	[menus.file free];

	[menus.help free];
	[menus.helpm.helpm free];
	[menus.helpm.about free];

	[menus.menu free];

	[vbox free];
	[mainwin free];

	[nb.jobs.page free]; [nb.jobs.joblist free]; [nb.jobs.canceljob free];
	[nb.printops.page free];
	[nb.printops.updown free];
	[nb.printops.clean free];
	[nb.printops.restart free];
	[nb.printops.startstop free];
	[printsys free];

	return [super free];
}
@end

int main(int argc, char *argv[])
{
	id myapp = [[GULPApp alloc] initApp:&argc :&argv];
	if(myapp != nil) {
	    [myapp run];
	    [myapp free];
	    return 0;
	} else
	    return 1;
}
