#include <gnome.h>

#include "gstmediainfo.h"

struct _GstMediaInfoPrivate {
	GnomeCanvasItem *label_filename;
};

static void gst_media_info_finalize (GObject *object);
static void gst_media_info_response (GtkDialog *dialog, gint response);

GNOME_CLASS_BOILERPLATE (GstMediaInfo, gst_media_info,
			 GtkDialog, GTK_TYPE_DIALOG)
static gchar*
build_string_for_display (const gchar *location)
{
	gchar *tmp = NULL;
	gchar **ampersand;

	tmp = g_strdup_printf ("%s", location);

	if (tmp != NULL && strlen (tmp) > 40)
	{
		tmp = g_strdup_printf ("%s...", g_strndup (tmp, 40));
	}

	if (tmp != NULL)
	{
		ampersand = g_strsplit (tmp, "&", 0); 

		if (ampersand != NULL)
		{
			tmp = g_strjoinv ("&amp;", ampersand); 
		}

		g_strfreev (ampersand);
	}

	return tmp;
}

static void
gst_media_info_class_init (GstMediaInfoClass *klass)
{
	GObjectClass *object_class;
	GtkWidgetClass *widget_class;
	GtkDialogClass *dialog_class;

	object_class = (GObjectClass *) klass;
	widget_class = (GtkWidgetClass *) klass;
	dialog_class = (GtkDialogClass *) klass;

	object_class->finalize = gst_media_info_finalize;

	dialog_class->response = gst_media_info_response;
}

static void
gst_media_info_instance_init (GstMediaInfo *media_info)
{
	GstMediaInfoPrivate  *priv;
	GnomeCanvasGroup     *root;
	GtkWidget            *canvas;
	GdkPixbuf            *pixbuf;
	GtkStyle             *rcstyle;
	char                 *font;
  
	priv = g_new0 (GstMediaInfoPrivate, 1);
	media_info->_priv = priv;

	priv->label_filename = NULL;

	gtk_widget_push_colormap (gdk_rgb_get_cmap ());
	canvas = gnome_canvas_new_aa ();
	gtk_widget_set_usize (canvas, 291, 139);
	gnome_canvas_set_center_scroll_region (GNOME_CANVAS (canvas), FALSE);
	root = gnome_canvas_root (GNOME_CANVAS (canvas));
	gnome_canvas_set_pixels_per_unit (GNOME_CANVAS (canvas), 1.0);
	gtk_box_pack_start (GTK_BOX (GTK_DIALOG (media_info)->vbox), canvas, TRUE, TRUE, 0);
	gtk_widget_show (canvas);

	gnome_canvas_item_new (root,
			       gnome_canvas_rect_get_type (),
			       "x1", 0.0,
			       "y1", 0.0,
			       "x2", 64.0,
			       "y2", 139.0,
			       "fill-color-rgba", GNOME_CANVAS_COLOR_A(171, 221, 161, 255),
			       NULL);

	gnome_canvas_item_new(root,
			      gnome_canvas_rect_get_type(),
			      "x1", 65.0,
			      "y1", 0.0,
			      "x2", 66.0,
			      "y2", 139.0,
			      "fill-color-rgba", GNOME_CANVAS_COLOR_A (0, 0, 0, 255),
			      NULL);

	gnome_canvas_item_new (root,
			       gnome_canvas_rect_get_type (),
			       "x1", 66.0,
			       "y1", 0.0,
			       "x2", 291.0,
			       "y2", 139.0,
			       "fill-color", "white",
			       NULL);

	rcstyle = gtk_rc_get_style (canvas);
	if (rcstyle == NULL)
		rcstyle = canvas->style;

	font = pango_font_description_to_string (rcstyle->font_desc);

	gnome_canvas_item_new (root,
			       gnome_canvas_text_get_type (),
			       "text", "Testing - Testing",
			       "x", 70.0,
			       "y", 22.0,
			       "font", font,
			       "anchor", GTK_ANCHOR_NW,
			       "justification", GTK_JUSTIFY_LEFT,
			       "fill_color", "black",
			       NULL);

	gnome_canvas_item_new (root,
			       gnome_canvas_text_get_type (),
			       "text", "File Info",
			       "x", 20.0,
			       "y", 55.0,
			       "font", font,
			       "anchor", GTK_ANCHOR_NW,
			       "justification", GTK_JUSTIFY_LEFT,
			       "fill_color", "blue",
			       NULL);

	gnome_canvas_item_new (root,
			       gnome_canvas_text_get_type (),
			       "text", "Sound",
			       "x", 33.0,
			       "y", 68.0,
			       "font", font,
			       "anchor", GTK_ANCHOR_NW,
			       "justification", GTK_JUSTIFY_LEFT,
			       "fill_color", "red",
			       NULL);

	gnome_canvas_item_new (root,
			       gnome_canvas_text_get_type (),
			       "text", "Ogg Vorbis Decoder",
			       "x", 68.0,
			       "y", 68.0,
			       "font", font,
			       "anchor", GTK_ANCHOR_NW,
			       "justification", GTK_JUSTIFY_LEFT,
			       "fill_color", "black",
			       NULL);

	gnome_canvas_item_new (root,
			       gnome_canvas_text_get_type (),
			       "text", "16 Bit Stereo, 44.10 kHz",
			       "x", 68.0,
			       "y", 80.0,
			       "font", font,
			       "anchor", GTK_ANCHOR_NW,
			       "justification", GTK_JUSTIFY_LEFT,
			       "fill_color", "black",
			       NULL);

	gnome_canvas_item_new (root,
			       gnome_canvas_text_get_type (),
			       "text", "Duration",
			       "x", 20.0,
			       "y", 91.0,
			       "font", font,
			       "anchor", GTK_ANCHOR_NW,
			       "justification", GTK_JUSTIFY_LEFT,
			       "fill_color", "red",
			       NULL);

	gnome_canvas_item_new (root,
			       gnome_canvas_text_get_type (),
			       "text", "0:00",
			       "x", 68.0,
			       "y", 92.0,
			       "font", font,
			       "anchor", GTK_ANCHOR_NW,
			       "justification", GTK_JUSTIFY_LEFT,
			       "fill_color", "black",
			       NULL);

	gnome_canvas_item_new (root,
			       gnome_canvas_text_get_type (),
			       "text", "Location",
			       "x", 20.0,
			       "y", 103.0,
			       "font", font,
			       "anchor", GTK_ANCHOR_NW,
			       "justification", GTK_JUSTIFY_LEFT,
			       "fill_color", "red",
			       NULL);

	priv->label_filename = gnome_canvas_item_new (root,
						gnome_canvas_text_get_type (),
						"text", "",
						"x", 68.0,
						"y", 103.0,
						"font", font,
						"anchor", GTK_ANCHOR_NW,
						"justification", GTK_JUSTIFY_CENTER,
						"fill_color", "black",
						NULL);

	gtk_widget_pop_colormap ();

	gtk_dialog_add_button (GTK_DIALOG (media_info), GTK_STOCK_OK, GTK_RESPONSE_OK);
	gtk_dialog_set_default_response (GTK_DIALOG (media_info), GTK_RESPONSE_OK);

	gtk_window_set_resizable (GTK_WINDOW (media_info), FALSE);
}	

static void
gst_media_info_finalize (GObject *object)
{
	GstMediaInfo *media_info = GST_MEDIA_INFO (object);

	GNOME_CALL_PARENT (G_OBJECT_CLASS, finalize, (object));
}

static void
gst_media_info_response (GtkDialog *dialog, gint response)
{
	gtk_widget_destroy (GTK_WIDGET (dialog));
}

GtkWidget*
gst_media_info_new (const gchar *location)
{
	GstMediaInfo *media_info;

	g_return_val_if_fail (location != NULL, NULL);

	media_info = g_object_new (GST_TYPE_MEDIA_INFO, NULL);
	gst_media_info_construct (media_info, location);

	return GTK_WIDGET (media_info);
}

void
gst_media_info_construct (GstMediaInfo *media_info, const gchar *location)
{
	gchar *tmp;

	gtk_window_set_title (GTK_WINDOW (media_info), g_strdup_printf ("%s info", location));

	tmp = build_string_for_display (location);
	gnome_canvas_item_set (media_info->_priv->label_filename,
			       "markup", tmp, NULL);
	g_free (tmp);
}
