/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

#ifndef __GPA_UTILS_H__
#define __GPA_UTILS_H__

/*
 *  gpa-utils.h:
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Authors :
 *    Jose M. Celorio <chema@ximian.com>
 *    Lauris Kaplinski <lauris@ximian.com>
 *
 *  Copyright (C) 2000-2001 Ximian, Inc. and Jose M. Celorio
 *  Contains pieces of code from glib, Copyright GLib Team and others 1997-2000.
 *
 */

#include <glib/gmacros.h>

G_BEGIN_DECLS

#include <libxml/tree.h>
#include "gpa-node.h"

guchar * gpa_id_new (const guchar *key);

/* Attach and detach */
GPANode *gpa_node_attach (GPANode *parent, GPANode *child);
GPANode *gpa_node_attach_ref (GPANode *parent, GPANode *child);

GPANode *gpa_node_detach (GPANode *parent, GPANode *child);
GPANode *gpa_node_detach_unref (GPANode *parent, GPANode *child);

GPANode *gpa_node_detach_next (GPANode *parent, GPANode *child);
GPANode *gpa_node_detach_unref_next (GPANode *parent, GPANode *child);

/* Lookup */
const guchar * gpa_node_lookup_check  (const guchar *path, const guchar *key);
gboolean       gpa_node_lookup_helper (GPANode *node, const guchar *path, const guchar *starts_with, GPANode **child);

/* XML helpers */
xmlChar *  gpa_xml_node_get_name (xmlNodePtr node);
xmlNodePtr gpa_xml_node_get_child (xmlNodePtr node, const guchar *name);

/* Dumps the node and all nodes below it to the console */
void gpa_utils_dump_tree (GPANode *node, gint follow_references);

/* Private quarks */
typedef guint GPAQuark;

GPAQuark gpa_quark_try_string (const guchar *string);
GPAQuark gpa_quark_from_string (const guchar *string);
GPAQuark gpa_quark_from_static_string (const guchar *string);
const guchar *gpa_quark_to_string (GPAQuark quark);

#define gpa_return_false_if_fail(expr)	G_STMT_START{			\
     if (expr) { } else							\
       {								\
	 g_log (G_LOG_DOMAIN,						\
		G_LOG_LEVEL_CRITICAL,					\
		"file %s: line %d (%s): assertion `%s' failed",		\
		__FILE__,						\
		__LINE__,						\
		__PRETTY_FUNCTION__,					\
		#expr);							\
	 exit (-1);							\
	 return (FALSE);						\
       };				}G_STMT_END


#ifndef __GNUC__
#define __FUNCTION__   ""
#endif

#define gpa_enter(...) gpa_enter_real (__LINE__, __FILE__, __FUNCTION__, __VA_ARGS__)
#define gpa_leave(...) gpa_leave_real (__LINE__, __FILE__, __FUNCTION__, __VA_ARGS__)

void gpa_enter_real (gint line,
		     const gchar *file,
		     const gchar *func,
		     const gchar *format, ...);
void gpa_leave_real (gint line,
		     const gchar *file,
		     const gchar *func,		     
		     const gchar *format, ...);
void gpa_enter_leave_disable (void);
void gpa_enter_leave_enable  (void);

#endif /* __GPA_UTILS_H__ */
