#ifndef _yahtzee_H_
#define _yahtzee_H_
/*
 * Gyatzee: Gnomified Yahtzee game.
 * (C) 1998 the Free Software Foundation
 *
 * File:   yahtzee.h
 *
 * Author: Scott Heavner
 *
 * This program is based on based on orest zborowski's curses based
 * yahtze (c)1992.
 */

#include <glib/gi18n.h>

#define COMPUTER_DELAY 1	/* sec */

#define NUM_ROLLS 3
#define NUMBER_OF_DICE       5

#define MAX_NUMBER_OF_PLAYERS 6
#define LAST_COL (MAX_NUMBER_OF_PLAYERS+2)
#define MAX_NAME_LENGTH 8
#define NUM_UPPER 6
#define NUM_LOWER 7
#define NUM_FIELDS (NUM_UPPER + NUM_LOWER)

#define EXTRA_FIELDS 4

/* Locations of fields containing totals */
#define F_LOWERT (NUM_FIELDS)
#define F_GRANDT (F_LOWERT+1)
#define F_UPPERT (F_GRANDT+1)
#define F_BONUS  (F_UPPERT+1)

#define H_3 6
#define H_4 7
#define H_FH 8
#define H_SS 9
#define H_LS 10
#define H_YA 11
#define H_CH 12

typedef struct {
  char *name;
  short used[NUM_FIELDS];
  int score[NUM_FIELDS];
  int finished;
  int comp;
} Player;

typedef struct {
  int val;
  int sel;
} DiceInfo;

/* yahtzee.c */
extern DiceInfo DiceValues[];
extern Player players[];
extern int NumberOfPlayers;
extern int NumberOfHumans;
extern int NumberOfComputers;
extern int DoDelay;
extern int NumberOfRolls;
extern int WinningScore;
extern int DisplayComputerThoughts;
extern int OnlyShowScores;
extern int CurrentPlayer;
extern char *ProgramHeader;
extern char *FieldLabels[NUM_FIELDS + EXTRA_FIELDS];
extern char *DefaultPlayerNames[MAX_NUMBER_OF_PLAYERS];

extern void YahtzeeInit (void);
extern void NewGame (void);
extern int upper_total (int num);
extern int lower_total (int num);
extern int total_score (int num);
extern int count (int val);
extern int find_n_of_a_kind (int n, int but_not);
extern int find_straight (int run, int notstart, int notrun);
extern int find_yahtzee (void);
extern int add_dice (void);
extern int play_score (int player, int field);
extern void handle_play (int player);
extern void play (void);
extern void calc_random (void);
extern void say (char *fmt, ...);
extern void SelectAllDice (void);
extern int NoDiceSelected (void);
extern int RollDie (void);
extern void RollSelectedDice (void);
extern int GameIsOver (void);
extern int FindWinner (void);
int UndoPossible (void);

/* Computer.c */
extern void ComputerRolling (int player);
extern void ComputerScoring (int player);

/* Specific to a windowing system: gyahtzee.c/cyahtzee.c */
extern void NewGame (void);
extern void UpdateAllDicePixmaps (void);
extern void DeselectAllDice (void);
extern void ShowPlayer (int num, int field);
extern void NextPlayer (void);
extern void ShowHighScores (void);

enum { SCORE_OK = 0, SLOT_USED, PLAYER_DONE, YAHTZEE_NEWGAME };


#endif /* _yahtzee_H_ */


/* Arrgh - lets all use the same tabs under emacs: 
Local Variables:
tab-width: 8
c-basic-offset: 8
indent-tabs-mode: nil
End:
*/
