/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*-
 *
 * Copyright (C) 2008 William Jon McCann <jmccann@redhat.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#ifndef __GDM_A11Y_PREFERENCES_DIALOG_H
#define __GDM_A11Y_PREFERENCES_DIALOG_H

#include <glib-object.h>
#include <gtk/gtkdialog.h>

G_BEGIN_DECLS

#define GDM_TYPE_A11Y_PREFERENCES_DIALOG         (gdm_a11y_preferences_dialog_get_type ())
#define GDM_A11Y_PREFERENCES_DIALOG(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), GDM_TYPE_A11Y_PREFERENCES_DIALOG, GdmA11yPreferencesDialog))
#define GDM_A11Y_PREFERENCES_DIALOG_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST((k), GDM_TYPE_A11Y_PREFERENCES_DIALOG, GdmA11yPreferencesDialogClass))
#define GDM_IS_A11Y_PREFERENCES_DIALOG(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), GDM_TYPE_A11Y_PREFERENCES_DIALOG))
#define GDM_IS_A11Y_PREFERENCES_DIALOG_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), GDM_TYPE_A11Y_PREFERENCES_DIALOG))
#define GDM_A11Y_PREFERENCES_DIALOG_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), GDM_TYPE_A11Y_PREFERENCES_DIALOG, GdmA11yPreferencesDialogClass))

typedef struct GdmA11yPreferencesDialogPrivate GdmA11yPreferencesDialogPrivate;

typedef struct
{
        GtkDialog                        parent;
        GdmA11yPreferencesDialogPrivate *priv;
} GdmA11yPreferencesDialog;

typedef struct
{
        GtkDialogClass   parent_class;
} GdmA11yPreferencesDialogClass;

GType                  gdm_a11y_preferences_dialog_get_type                   (void);

GtkWidget            * gdm_a11y_preferences_dialog_new                        (void);

G_END_DECLS

#endif /* __GDM_A11Y_PREFERENCES_DIALOG_H */
