/*
 *  Copyright (C) 2002  Ricardo Fernndez Pascual
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __bookmarks_single_editor_h
#define __bookmarks_single_editor_h

#include <glib-object.h>
#include <bookmarks.h>

/* object forward declarations */

typedef struct _GbSingleEditor GbSingleEditor;
typedef struct _GbSingleEditorClass GbSingleEditorClass;
typedef struct _GbSingleEditorPrivate GbSingleEditorPrivate;

/**
 * Editor object
 */

#define GB_TYPE_SINGLE_EDITOR			(gb_single_editor_get_type())
#define GB_SINGLE_EDITOR(object)		(G_TYPE_CHECK_INSTANCE_CAST((object), GB_TYPE_SINGLE_EDITOR,\
						 GbSingleEditor))
#define GB_SINGLE_EDITOR_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST((klass), GB_TYPE_SINGLE_EDITOR,\
						 GbSingleEditorClass))
#define GB_IS_SINGLE_EDITOR(object)		(G_TYPE_CHECK_INSTANCE_TYPE((object), GB_TYPE_SINGLE_EDITOR))
#define GB_IS_SINGLE_EDITOR_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), GB_TYPE_SINGLE_EDITOR))
#define GB_SINGLE_EDITOR_GET_CLASS(obj)		(G_TYPE_INSTANCE_GET_CLASS((obj), GB_TYPE_SINGLE_EDITOR,\
						 GbSingleEditorClass))

struct _GbSingleEditorClass 
{
	GObjectClass parent_class;
	

};

/* Remember: fields are public read-only */
struct _GbSingleEditor
{
	GObject parent_object;

	GbSingleEditorPrivate *priv;
};

GType			gb_single_editor_get_type		(void);
GbSingleEditor *	gb_single_editor_new			(void);
void			gb_single_editor_set_bookmark		(GbSingleEditor *editor, GbBookmark *b);
void			gb_single_editor_show			(GbSingleEditor *editor);

#endif
