/*
 *  Copyright (C) 2002  Ricardo Fernndez Pascual
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <libgnome/gnome-i18n.h>
#include "gul-gobject-misc.h"
#include "galeon-marshal.h"
#include "gul-bonobo-extensions.h"
#include "galeon-tbi.h"
#include <string.h>

#define NOT_IMPLEMENTED g_warning ("not implemented: " G_STRLOC);
//#define DEBUG_MSG(x) g_print x
#define DEBUG_MSG(x)

/**
 * Private data
 */
struct _GaleonTbiPrivate 
{
};

/**
 * Private functions, only availble from this file
 */
static void		galeon_tbi_class_init			(GaleonTbiClass *klass);
static void		galeon_tbi_init				(GaleonTbi *tb);
static void		galeon_tbi_finalize_impl		(GObject *o);
static GtkWidget *	galeon_tbi_get_widget_impl		(GulTbItem *i);
static GdkPixbuf *	galeon_tbi_get_icon_impl		(GulTbItem *i);
static gchar *		galeon_tbi_get_name_human_impl		(GulTbItem *i);
static gchar *		galeon_tbi_to_string_impl		(GulTbItem *i);
static gboolean		galeon_tbi_is_unique_impl		(GulTbItem *i);
static GulTbItem *	galeon_tbi_clone_impl			(GulTbItem *i);
static void		galeon_tbi_parse_properties_impl	(GulTbItem *i, const gchar *props);
static void		galeon_tbi_add_to_bonobo_tb_impl	(GulTbItem *i, 
								 BonoboUIComponent *ui, 
								 const char *container_path,
								 guint index);


static gpointer gul_tb_item_class;

/**
 * GaleonTbi object
 */

MAKE_GET_TYPE (galeon_tbi, "GaleonTbi", GaleonTbi, galeon_tbi_class_init, 
	       galeon_tbi_init, GUL_TYPE_TB_ITEM);

static void
galeon_tbi_class_init (GaleonTbiClass *klass)
{
	G_OBJECT_CLASS (klass)->finalize = galeon_tbi_finalize_impl;
	
	GUL_TB_ITEM_CLASS (klass)->get_widget = galeon_tbi_get_widget_impl;
	GUL_TB_ITEM_CLASS (klass)->get_icon = galeon_tbi_get_icon_impl;
	GUL_TB_ITEM_CLASS (klass)->get_name_human = galeon_tbi_get_name_human_impl;
	GUL_TB_ITEM_CLASS (klass)->to_string = galeon_tbi_to_string_impl;
	GUL_TB_ITEM_CLASS (klass)->is_unique = galeon_tbi_is_unique_impl;
	GUL_TB_ITEM_CLASS (klass)->clone = galeon_tbi_clone_impl;
	GUL_TB_ITEM_CLASS (klass)->parse_properties = galeon_tbi_parse_properties_impl;
	GUL_TB_ITEM_CLASS (klass)->add_to_bonobo_tb = galeon_tbi_add_to_bonobo_tb_impl;
	
	gul_tb_item_class = g_type_class_peek_parent (klass);
}

static void 
galeon_tbi_init (GaleonTbi *tbi)
{
	tbi->window = NULL;
}

static void
galeon_tbi_finalize_impl (GObject *o)
{
	GaleonTbi *it = GALEON_TBI (o);

	if (it->window)
	{
		g_object_remove_weak_pointer (G_OBJECT (it->window),
					      (gpointer *) &it->window);
	}
	
	DEBUG_MSG (("GaleonTbi finalized\n"));
	
	G_OBJECT_CLASS (gul_tb_item_class)->finalize (o);
}

static GtkWidget *
galeon_tbi_get_widget_impl (GulTbItem *i)
{
	/* this class is abstract */
	g_assert_not_reached ();

	return NULL;
}

static GdkPixbuf *
galeon_tbi_get_icon_impl (GulTbItem *i)
{
	return NULL;
}

static gchar *
galeon_tbi_get_name_human_impl (GulTbItem *i)
{
	/* this class is abstract */
	g_assert_not_reached ();

	return NULL;
}

static gchar *
galeon_tbi_to_string_impl (GulTbItem *i)
{
	/* this class is abstract */
	g_assert_not_reached ();

	return NULL;
}

static gboolean
galeon_tbi_is_unique_impl (GulTbItem *i)
{
	return TRUE;
}

static GulTbItem *
galeon_tbi_clone_impl (GulTbItem *i)
{
	/* you can't clone this directly because this class is abstract */
	g_assert_not_reached ();
	return NULL;
}

static void
galeon_tbi_add_to_bonobo_tb_impl (GulTbItem *i, BonoboUIComponent *ui, 
				  const char *container_path, guint index)
{
	GtkWidget *w = gul_tb_item_get_widget (i);
	gtk_widget_show (w);
	gul_bonobo_add_numbered_widget (ui, w, index, container_path);
}

static void
galeon_tbi_parse_properties_impl (GulTbItem *it, const gchar *props)
{
	/* we have no properties */
}

void
galeon_tbi_set_window (GaleonTbi *it, GaleonWindow *w)
{
	if (it->window)
	{
		g_object_remove_weak_pointer (G_OBJECT (it->window),
					      (gpointer *) &it->window);
	}

	it->window = w;

	if (it->window)
	{
		g_object_add_weak_pointer (G_OBJECT (it->window), 
					   (gpointer *) &it->window);
	}
}

GaleonWindow *
galeon_tbi_get_window (GaleonTbi *tbi)
{
	return tbi->window;
}

