/* gok-page-wordcomplete.c
*
* Copyright 2002 Sun Microsystems, Inc.,
* Copyright 2002 University Of Toronto
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Library General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Library General Public License for more details.
*
* You should have received a copy of the GNU Library General Public
* License along with this library; if not, write to the
* Free Software Foundation, Inc., 59 Temple Place - Suite 330,
* Boston, MA 02111-1307, USA.
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include "gok-page-wordcomplete.h"
#include "gok-data.h"
#include "support.h"
#include "gok-log.h"
#include "gok-word-complete.h"

/* pointer to the settings dialog window */
static GtkWidget* m_pWindowSettings;

/* settings for the page */
static gboolean m_WordCompleteOnOff;
static int m_NumberPredictions;

/* backup of the page data */
static gboolean m_WordCompleteOnOffBackup;
static int m_NumberPredictionsBackup;

/**
* gok-page-wordcomplete-initialize
* @pWindowSettings: Pointer to the settings dialog window.
*
* Initializes this page of the gok settings dialog. This must be called
* prior to any calls on this page.
*
* returns: TRUE if the page was properly initialized, FALSE if not.
**/
gboolean gok_page_wordcomplete_initialize (GtkWidget* pWindowSettings)
{
	GtkWidget* pCheckboxOnOff;
	GtkWidget* pSpinNumberPredictions;
	
	g_assert (pWindowSettings != NULL);
		
	m_pWindowSettings = pWindowSettings;
	
	/* store the current values */
	m_WordCompleteOnOff = gok_data_get_wordcomplete();
	m_NumberPredictions = gok_data_get_num_predictions();
	gok_page_wordcomplete_backup();
	
	/* update the controls */
	pCheckboxOnOff = lookup_widget (m_pWindowSettings, "checkWordCompletion");
	g_assert (pCheckboxOnOff != NULL);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(pCheckboxOnOff), gok_data_get_wordcomplete());

	pSpinNumberPredictions = lookup_widget (m_pWindowSettings, "spinNumberPredictions");
	g_assert (pSpinNumberPredictions != NULL);
	gtk_spin_button_set_value (GTK_SPIN_BUTTON(pSpinNumberPredictions), gok_data_get_num_predictions());
	
	return TRUE;
}

/**
* gok_page_wordcomplete_refresh
* 
* Refreshes the controls on this page from the gok data.
**/
void gok_page_wordcomplete_refresh ()
{

}

/**
* gok_page_wordcomplete_apply
* 
* Updates the gok data with values from the controls.
*
* returns: TRUE if any of the gok data settings have changed, FALSE if not.
**/
gboolean gok_page_wordcomplete_apply ()
{
	GtkWidget* pCheckboxOnOff;
	GtkWidget* pSpinNumberPredictions;
	gboolean bDataChanged;

	g_assert (m_pWindowSettings != NULL);
	
	bDataChanged = FALSE;

	pCheckboxOnOff = lookup_widget (m_pWindowSettings, "checkWordCompletion");
	g_assert (pCheckboxOnOff != NULL);
	m_WordCompleteOnOff = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(pCheckboxOnOff));

	pSpinNumberPredictions = lookup_widget (m_pWindowSettings, "spinNumberPredictions");
	g_assert (pSpinNumberPredictions != NULL);
	m_NumberPredictions = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON(pSpinNumberPredictions));

	/* update the gok data with any new settings */
	if (gok_data_get_wordcomplete() != m_WordCompleteOnOff)
	{
		bDataChanged = TRUE;
		gok_data_set_wordcomplete (m_WordCompleteOnOff);
		gok_wordcomplete_on (m_WordCompleteOnOff);
	}

	if (m_NumberPredictions != gok_data_get_num_predictions())
	{
		bDataChanged = TRUE;
		gok_data_set_num_predictions (m_NumberPredictions);
		gok_wordcomplete_change_number_predictions (m_NumberPredictions);
	}

	return bDataChanged;
}

/**
* gok_page_wordcomplete_revert
* 
* Revert to the backup settings for this page.
*
* returns: TRUE if any of the settings have changed, FALSE 
* if they are all still the same.
**/
gboolean gok_page_wordcomplete_revert ()
{
	GtkWidget* pCheckboxOnOff;
	GtkWidget* pSpinNumberPredictions;
	gboolean bDataChanged;

	bDataChanged = FALSE;

	/* get the original settings */
	if (m_WordCompleteOnOff != m_WordCompleteOnOffBackup)
	{
		bDataChanged = TRUE;
		m_WordCompleteOnOff = m_WordCompleteOnOffBackup;
		gok_data_set_wordcomplete (m_WordCompleteOnOff);
		gok_wordcomplete_on (m_WordCompleteOnOff);

		pCheckboxOnOff = lookup_widget (m_pWindowSettings, "checkWordCompletion");
		g_assert (pCheckboxOnOff != NULL);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(pCheckboxOnOff), m_WordCompleteOnOff);

	}

	if (m_NumberPredictions != m_NumberPredictionsBackup)
	{
		bDataChanged = TRUE;
		m_NumberPredictions = m_NumberPredictionsBackup;
		gok_data_set_num_predictions (m_NumberPredictions);
		gok_wordcomplete_change_number_predictions (m_NumberPredictions);

		pSpinNumberPredictions = lookup_widget (m_pWindowSettings, "spinNumberPredictions");
		g_assert (pSpinNumberPredictions != NULL);
		gtk_spin_button_set_value (GTK_SPIN_BUTTON(pSpinNumberPredictions), m_NumberPredictions);
	}

	return bDataChanged;
}

/**
* gok_page_wordcomplete_backup
* 
* Copies all the member settings to backup.
**/
void gok_page_wordcomplete_backup ()
{
	m_WordCompleteOnOffBackup = m_WordCompleteOnOff;
	m_NumberPredictionsBackup = m_NumberPredictions;
}


