/* dconf-update.c generated by valac 0.9.7, the Vala compiler
 * generated from dconf-update.vala, do not modify */

/*
 * Copyright © 2010 Codethink Limited
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the licence, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Ryan Lortie <desrt@desrt.ca>
 */

#include <glib.h>
#include <glib-object.h>
#include <gvdb-builder.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>
#include <unistd.h>
#include <gio/gio.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_builder_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))



GvdbItem* get_parent (GHashTable* table, const char* name);
GHashTable* read_directory (const char* dirname, GError** error);
void maybe_update_from_directory (const char* dirname, GError** error);
void update_all (const char* dirname, GError** error);
void do_update (void);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);



GvdbItem* get_parent (GHashTable* table, const char* name) {
	GvdbItem* result = NULL;
	GvdbItem* parent;
	gint end;
	char* parent_name;
	g_return_val_if_fail (table != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	parent = NULL;
	end = 0;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(g_utf8_get_char (g_utf8_offset_to_pointer (name, i)) != '\0')) {
					break;
				}
				if (g_utf8_get_char (g_utf8_offset_to_pointer (name, i - 1)) == '/') {
					end = i;
				}
			}
		}
	}
	parent_name = g_strndup (name, (gsize) end);
	parent = (GvdbItem*) g_hash_table_lookup (table, parent_name);
	if (parent == NULL) {
		parent = gvdb_hash_table_insert (table, parent_name);
		gvdb_item_set_parent (parent, get_parent (table, parent_name));
	}
	result = parent;
	_g_free0 (parent_name);
	return result;
}


GHashTable* read_directory (const char* dirname, GError** error) {
	GHashTable* result = NULL;
	GHashTable* table;
	const char* name;
	GDir* dir;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (dirname != NULL, NULL);
	table = gvdb_hash_table_new (NULL, NULL);
	name = NULL;
	gvdb_hash_table_insert (table, "/");
	dir = g_dir_open (dirname, 0, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_hash_table_unref0 (table);
		return NULL;
	}
	while (TRUE) {
		char* filename;
		GKeyFile* kf;
		if (!((name = g_dir_read_name (dir)) != NULL)) {
			break;
		}
		filename = g_build_filename (dirname, name, NULL);
		kf = g_key_file_new ();
		{
			g_key_file_load_from_file (kf, filename, G_KEY_FILE_NONE, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch1_g_error;
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				fprintf (stderr, "%s: %s\n", filename, e->message);
				_g_error_free0 (e);
				_g_key_file_free0 (kf);
				_g_free0 (filename);
				continue;
			}
		}
		__finally1:
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_key_file_free0 (kf);
			_g_free0 (filename);
			_g_dir_close0 (dir);
			_g_hash_table_unref0 (table);
			return NULL;
		}
		{
			gsize _tmp0_;
			char** group_collection;
			int group_collection_length1;
			int group_it;
			group_collection = g_key_file_get_groups (kf, &_tmp0_);
			group_collection_length1 = _tmp0_;
			for (group_it = 0; group_it < _tmp0_; group_it = group_it + 1) {
				char* group;
				group = g_strdup (group_collection[group_it]);
				{
					gboolean _tmp1_ = FALSE;
					gboolean _tmp2_ = FALSE;
					gint _tmp4__length1;
					gint __tmp4__size_;
					char** _tmp5_;
					gsize _tmp3_;
					char** _tmp4_;
					if (g_str_has_prefix (group, "/")) {
						_tmp2_ = TRUE;
					} else {
						_tmp2_ = g_str_has_suffix (group, "/");
					}
					if (_tmp2_) {
						_tmp1_ = TRUE;
					} else {
						_tmp1_ = strstr (group, "//") != NULL;
					}
					if (_tmp1_) {
						fprintf (stderr, "%s: ignoring invalid group name: %s\n", filename, group);
						_g_free0 (group);
						continue;
					}
					_tmp4_ = (_tmp5_ = g_key_file_get_keys (kf, group, &_tmp3_, &_inner_error_), _tmp4__length1 = _tmp3_, __tmp4__size_ = _tmp4__length1, _tmp5_);
					if (_inner_error_ != NULL) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (group);
						group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
						_g_key_file_free0 (kf);
						_g_free0 (filename);
						_g_dir_close0 (dir);
						_g_hash_table_unref0 (table);
						return NULL;
					}
					{
						char** key_collection;
						int key_collection_length1;
						int key_it;
						key_collection = _tmp4_;
						key_collection_length1 = _tmp4__length1;
						for (key_it = 0; key_it < _tmp4__length1; key_it = key_it + 1) {
							char* key;
							key = g_strdup (key_collection[key_it]);
							{
								char* _tmp6_;
								char* _tmp7_;
								char* _tmp8_;
								char* path;
								char* text;
								if (strstr (key, "/") != NULL) {
									fprintf (stderr, "%s: [%s]: ignoring invalid key name: %s\n", filename, group, key);
									_g_free0 (key);
									continue;
								}
								path = (_tmp8_ = g_strconcat (_tmp7_ = g_strconcat (_tmp6_ = g_strconcat ("/", group, NULL), "/", NULL), key, NULL), _g_free0 (_tmp7_), _g_free0 (_tmp6_), _tmp8_);
								if (((GvdbItem*) g_hash_table_lookup (table, path)) != NULL) {
									fprintf (stderr, "%s: [%s]: %s: ignoring duplicate definition of key %s\n", filename, group, key, path);
									_g_free0 (path);
									_g_free0 (key);
									continue;
								}
								text = g_key_file_get_value (kf, group, key, &_inner_error_);
								if (_inner_error_ != NULL) {
									g_propagate_error (error, _inner_error_);
									_g_free0 (path);
									_g_free0 (key);
									key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
									_g_free0 (group);
									group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
									_g_key_file_free0 (kf);
									_g_free0 (filename);
									_g_dir_close0 (dir);
									_g_hash_table_unref0 (table);
									return NULL;
								}
								{
									GVariant* value;
									GvdbItem* item;
									value = g_variant_parse (NULL, text, NULL, NULL, &_inner_error_);
									if (_inner_error_ != NULL) {
										if (_inner_error_->domain == G_VARIANT_PARSE_ERROR) {
											goto __catch2_g_variant_parse_error;
										}
										_g_free0 (text);
										_g_free0 (path);
										_g_free0 (key);
										key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
										_g_free0 (group);
										group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
										_g_key_file_free0 (kf);
										_g_free0 (filename);
										_g_dir_close0 (dir);
										_g_hash_table_unref0 (table);
										g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return NULL;
									}
									item = gvdb_hash_table_insert (table, path);
									gvdb_item_set_parent (item, get_parent (table, path));
									gvdb_item_set_value (item, value);
									_g_variant_unref0 (value);
								}
								goto __finally2;
								__catch2_g_variant_parse_error:
								{
									GError * e;
									e = _inner_error_;
									_inner_error_ = NULL;
									{
										fprintf (stderr, "%s: [%s]: %s: skipping invalid value: %s (%s)\n", filename, group, key, text, e->message);
										_g_error_free0 (e);
									}
								}
								__finally2:
								if (_inner_error_ != NULL) {
									g_propagate_error (error, _inner_error_);
									_g_free0 (text);
									_g_free0 (path);
									_g_free0 (key);
									key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
									_g_free0 (group);
									group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
									_g_key_file_free0 (kf);
									_g_free0 (filename);
									_g_dir_close0 (dir);
									_g_hash_table_unref0 (table);
									return NULL;
								}
								_g_free0 (text);
								_g_free0 (path);
								_g_free0 (key);
							}
						}
						key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
					}
					_g_free0 (group);
				}
			}
			group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
		}
		_g_key_file_free0 (kf);
		_g_free0 (filename);
	}
	result = table;
	_g_dir_close0 (dir);
	return result;
}


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, -1);
	return result;
}


void maybe_update_from_directory (const char* dirname, GError** error) {
	struct stat dir_buf = {0};
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (dirname != NULL);
	if (stat (dirname, &dir_buf) == 0) {
		_tmp0_ = S_ISDIR (dir_buf.st_mode);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		struct stat file_buf = {0};
		char* filename;
		gboolean _tmp1_ = FALSE;
		GHashTable* table;
		gint fd;
		gboolean _tmp2_ = FALSE;
		filename = g_strndup (dirname, (gsize) (string_get_length (dirname) - 2));
		if (stat (filename, &file_buf) == 0) {
			_tmp1_ = file_buf.st_mtime > dir_buf.st_mtime;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			_g_free0 (filename);
			return;
		}
		table = read_directory (dirname, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (filename);
			return;
		}
		fd = open (filename, O_WRONLY, 0);
		if (fd < 0) {
			_tmp2_ = errno != EEXIST;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			gint saved_error;
			saved_error = errno;
			_inner_error_ = g_error_new (G_FILE_ERROR, G_FILE_ERROR_FAILED, "Can not open '%s' for replacement: %s", filename, g_strerror (saved_error));
			{
				g_propagate_error (error, _inner_error_);
				_g_hash_table_unref0 (table);
				_g_free0 (filename);
				return;
			}
		}
		{
			gvdb_table_write_contents (table, filename, FALSE, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __finally3;
			}
			if (fd >= 0) {
				write (fd, "\0\0\0\0\0\0\0\0", (gsize) 8);
			}
		}
		__finally3:
		{
			if (fd >= 0) {
				close (fd);
			}
		}
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_hash_table_unref0 (table);
			_g_free0 (filename);
			return;
		}
		{
			GDBusConnection* system_bus;
			char* _tmp3_;
			char* _tmp4_;
			GVariantBuilder* _tmp5_;
			GVariant* _tmp6_;
			system_bus = g_bus_get_sync (G_BUS_TYPE_SYSTEM, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch4_g_error;
			}
			g_dbus_connection_emit_signal (system_bus, NULL, _tmp4_ = g_strconcat ("/", _tmp3_ = g_path_get_basename (filename), NULL), "ca.desrt.dconf.Writer", "Notify", _tmp6_ = g_variant_ref_sink (g_variant_new ("(tsas)", (guint64) 0, "/", _tmp5_ = g_variant_builder_new (G_VARIANT_TYPE_STRING_ARRAY), NULL)), &_inner_error_);
			_g_variant_unref0 (_tmp6_);
			_g_variant_builder_unref0 (_tmp5_);
			_g_free0 (_tmp4_);
			_g_free0 (_tmp3_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (system_bus);
				goto __catch4_g_error;
			}
			g_dbus_connection_flush_sync (system_bus, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (system_bus);
				goto __catch4_g_error;
			}
			_g_object_unref0 (system_bus);
		}
		goto __finally4;
		__catch4_g_error:
		{
			g_clear_error (&_inner_error_);
			_inner_error_ = NULL;
			{
			}
		}
		__finally4:
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_hash_table_unref0 (table);
			_g_free0 (filename);
			return;
		}
		_g_hash_table_unref0 (table);
		_g_free0 (filename);
	}
}


void update_all (const char* dirname, GError** error) {
	const char* name;
	GDir* dir;
	GError * _inner_error_ = NULL;
	g_return_if_fail (dirname != NULL);
	name = NULL;
	dir = g_dir_open (dirname, 0, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	while (TRUE) {
		if (!((name = g_dir_read_name (dir)) != NULL)) {
			break;
		}
		if (g_str_has_suffix (name, ".d")) {
			{
				char* _tmp0_;
				maybe_update_from_directory (_tmp0_ = g_build_filename (dirname, name, NULL), &_inner_error_);
				_g_free0 (_tmp0_);
				if (_inner_error_ != NULL) {
					goto __catch5_g_error;
				}
			}
			goto __finally5;
			__catch5_g_error:
			{
				GError * e;
				e = _inner_error_;
				_inner_error_ = NULL;
				{
					fprintf (stderr, "%s\n", e->message);
					_g_error_free0 (e);
				}
			}
			__finally5:
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_dir_close0 (dir);
				return;
			}
		}
	}
	_g_dir_close0 (dir);
}


void do_update (void) {
	GError * _inner_error_ = NULL;
	{
		update_all ("/etc/dconf/db", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch6_g_error;
		}
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			fprintf (stderr, "fatal: %s\n", e->message);
			_g_error_free0 (e);
		}
	}
	__finally6:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}




