from GConfBackend import GConfBackend
from DummyBackend import DummyBackend
import settings

_CONFIG_LOCATION = "/apps/gdesklets"


#
# Class for managing configuration.
#
class ConfigManager:

    def __init__(self):

        # hashtable for config change handlers: (id, key) -> handler
        self.__handlers = {}


        if (settings.no_config):
            self.__backend = DummyBackend(_CONFIG_LOCATION)
        else:
            self.__backend = GConfBackend(_CONFIG_LOCATION)

        self.__backend.add_observer(self.__on_observe_backend)



    def __on_observe_backend(self, src, cmd, *args):

        if (cmd == src.OBS_UPDATE):
            key, value = args
            config_id, k = key

            handler = self.__handlers.get((config_id, k)) or \
                      self.__handlers.get((config_id, ""))
            if (handler):
                apply(handler, [k, value])



    #
    # Sets a configuration value
    #
    def set(self, config_id, key, value):

        self.__backend.set(config_id, key, value)



    #
    # Gets a configuration value
    #
    def get(self, config_id, key):

        return self.__backend.get(config_id, key)



    #
    # Sets a callback handler for watching changes for the given configuration
    # entry
    #
    def watch(self, config_id, key, handler):

        self.__handlers[(config_id, key)] = handler



    #
    # Removes a watch callback handler.
    #
    def remove_watcher(self, config_id, key, handler):

        k = (config_id, key)
        if (self.__handlers.has_key(k)):
            del self.__handlers[k]



    #
    # Clears an ID entry in the configuration backend
    #
    def clear(self, config_id):

        self.__backend.clear(config_id)



    #
    # Lists directories in the configuration backend
    #
    def list(self, *args):

        return apply(self.__backend.list, args)
