import polling
import glibtop

import os, stat


class Memory:

    def __init__(self):

        self.__get_total_ram = polling.wrap(self.__poll_total_ram, 0)

        self.get_ram = polling.wrap(self.__poll_mem, 0.2, 0)
        self.get_swap = polling.wrap(self.__poll_mem, 0.2, 1)



    def __poll_total_ram(self):

        memtotal = glibtop.get_mem()[0]
        #memtotal = os.stat("/proc/kcore")[stat.ST_SIZE]
        return memtotal



    def __poll_mem(self, mode):

        #fd = open("/proc/meminfo", "r")
        #mem = fd.read()
        #fd.close()
        #lines = mem.splitlines()

        # RAM
        if (mode == 0):
            total, used, free = glibtop.get_mem()[:3]
            #total = int(self.__get_total_ram()/1024)
            #for l in lines:
            #    if (l.startswith("MemFree:")):
            #        value = l.split()
            #        free = int(value[1])
            #    elif (l.startswith("Buffers:")):
            #        value = l.split()
            #        free = free + int(value[1])
            #    elif (l.startswith("Cached:")):
            #        value = l.split()
            #        free = free + int(value[1])
            #        break
            #used = total - free

        # Swap
        elif (mode == 1):
            total, used, free = glibtop.get_mem()[:3]
            #for l in lines:
            #    if (l.startswith("SwapTotal:")):
            #        value = l.split()
            #        total = int(value[1])
            #    elif (l.startswith("SwapFree:")):
            #        value = l.split()
            #        free = int(value[1])
            #        break
            #used = total - free

        return (total / 1024, used / 1024)
